/*
 *
 * $Id: gui.c,v 1.8 1994/07/22 15:25:13 beust Exp $
 */


#include <pwd.h>    /* for struct passwd */
#include "main.h"

static  Widget cedXtAppInitialize( /* obsolete */
#if NeedFunctionPrototypes
    XtAppContext *appContext	/* app_context_return */,
    _Xconst _XtString appClass	/* application_class */,
    XrmOptionDescList descList	/* options */,
    Cardinal numOptions		/* num_options */,
    int* argcp		/* argc_in_out */,
    String* argv		/* argv_in_out */,
    String* fallback		/* fallback_resources */,
    ArgList args		/* args */,
    Cardinal numArgs		/* num_args */
#endif
)
{
   int running = 1, i = 1;

   if (NULL == descList)
      return XtAppInitialize(appContext, appClass, descList, numOptions,
			     argcp, argv, fallback, args, numArgs);
   while (running) {
      if (i == *argcp) {
	 return XtAppInitialize(appContext, appClass, descList, numOptions,
				argcp, argv, fallback, args, numArgs);
      }
      if (0 == strcmp("-help", argv[i]) ||
	  0 == strcmp("-h", argv[i])) {
	 running = 0;
      }
      else {
	 i++;
      }
   }

   printf("Usage : %s\n", argv[0]);
   for (i = 0; i < numOptions; i++) {
      char *type;
      char format[64];
      switch(descList[i].argKind) {
	 case XrmoptionNoArg : {
	    type = "";
	 }
	 break;
	 case XrmoptionIsArg : {
	    type = "";
	 }
	 break;
	 case XrmoptionStickyArg : {
	    type = "<value>";
	 }
	 break;
	 case XrmoptionSepArg : {
	    type = " <value>";
	 }
	 break;
	 case XrmoptionResArg : {
	    type = " <resource: value>";
	 }
	 break;
	 case XrmoptionSkipArg : {
	    type = " (ignored, and next argument one too)";
	 }
	 break;
	 case XrmoptionSkipLine : {
	    type = " (ignored, and rest of arguments too)";
	 }
	 break;
	 case XrmoptionSkipNArgs : {
	    sprintf(format, "( ignored, and next %d arguments too)",
		    descList[i].value);
	    type = format;
	 }
	 break;
	 default :
	    assert(0);
      }
      printf("\t\t%s%s\n", descList[i].option, type);
   }
   exit(0);
}

static XmString
cedListGetSelectedString(Widget list)
{
   Arg args[10];
   XmString *xms;
   int *selectedPos, selectedCount;
   XmString result = NULL;

   XtSetArg(args[0], XmNitems, & xms);
   XtGetValues(list, args, 1);
   if (NULL != xms) {
      XmListGetSelectedPos(list, & selectedPos, & selectedCount);
      if (0 != selectedCount) {
	 result = xms[selectedPos[0] - 1];
      }
   }

   return result;
}

/***************************************************************************
 * Callbacks
 ***************************************************************************/

static void
cbQuit(Widget wid, XtPointer userData, XtPointer call_data)
{
   GV gv = (GV) userData;
   DB_DestroyDataBase(gv -> requests);
   kt_UnInit(gv -> ktContext);
   exit(1);
}

static void
cbSingleSelect(Widget wid, XtPointer userData, XtPointer call_data)
{
   Arg args[16];
   int n = 0;
   String selectionFull, selection[128];
   char c;
   XmString *xms;
   GV gv = (GV) userData;
   CARD32 krs;

   XtSetArg(args[n], XmNselectedItems, & xms); n++;
   XtGetValues(wid, args, n);
   if (NULL != xms) {
      XmStringGetLtoR(xms[0], XmFONTLIST_DEFAULT_TAG, & selectionFull);
      sscanf(selectionFull, KRS_FORMAT, selection, & krs, & c);

      n = 0;
      XtSetArg(args[n], XmNvalue, selection); n++;
      XtSetValues(gv -> krsTF, args, n);
      n = 0;
      if ('o' == c) {
	 XmToggleButtonSetState(gv -> s1TB, True, True);
      }
      else {
	 XmToggleButtonSetState(gv -> s2TB, True, True);
      }
   }

/*
   XtFree(selection);
*/
}

static void
cbReplySend(Widget wid, XtPointer userData, XtPointer call_data)
{
   char *a1, *a2, *a3;
   Request_t request = (Request_t) userData;
   GV gv = & GlobalVars;

   /*
   ** Unmap the popup
   */
   XtUnmanageChild(request -> shell3);
   XtDestroyWidget(request -> shell3);

   /*
   ** Send the reply
   */
   a1 = XmTextFieldGetString(request -> tf7);
   a2 = XmTextFieldGetString(request -> tf8);
   a3 = XmTextFieldGetString(request -> tf9);
   guiLog2(gv, ">>> Replied to request", "");
   busReply(gv, a1, a2, a3);
   XtFree(a1);
   XtFree(a2);
   XtFree(a3);
   DB_RemoveEntry(gv -> requests, request);
   
}

static void
cbMessageSend(Widget wid, XtPointer userData, XtPointer call_data)
{
   GV gv = (GV) userData;
   char *s[3], *strKRL;
   char *operation = "operationTest";
   Boolean isNotice, isKrl;
   int i;

   strKRL = XmTextFieldGetString(gv -> destTF);
   s[0] = XmTextFieldGetString(gv -> arg1TF);
   s[1] = XmTextFieldGetString(gv -> arg2TF);
   s[2] = XmTextFieldGetString(gv -> arg3TF);
   operation = XmTextFieldGetString(gv -> operationTF);
   isNotice = XmToggleButtonGetState(gv -> notice);
   isKrl = XmToggleButtonGetState(gv -> krlTB);
   busMessageSend(gv, operation, strKRL, s[0], s[1], s[2], isNotice, isKrl);

   XtFree(s[0]);
   XtFree(s[1]);
   XtFree(s[2]);
   XtFree(strKRL);
}

static void
cbMessageHide(Widget wid, XtPointer userData, XtPointer call_data)
{
   GV gv = (GV) userData;
   XtUnmapWidget(gv -> shell1);
}

static void
cbMessageShow(Widget wid, XtPointer userData, XtPointer call_data)
{
   GV gv = (GV) userData;

   XtMapWidget(gv -> shell1);
}

/***************************************************************************
 * Actions
 ***************************************************************************/

void
actSendMessage(Widget wid, XEvent *event, String *params, Cardinal *nParams)
{
   cbMessageSend(wid, & GlobalVars, NULL);
}

static Bool
findRequest(Request_t request, Widget w)
{
   if (w == request -> tf7 || w == request -> tf8 ||
       w == request -> tf9) return True;
   else return False;
}

void
actSendReply(Widget wid, XEvent *event, String *params, Cardinal *nParams)
{
   Request_t request;
   GV gv = & GlobalVars;
   request = DB_LocateEntry(gv -> requests,
			    (void *) findRequest,
			    (void *) wid);
   assert(request);
   cbReplySend(wid, request, NULL);
}

void
actConnectServer(Widget wid, XEvent *event, String *params, Cardinal *nParams)
{
   GV gv = & GlobalVars;
   char *serverString = XmTextGetString(gv -> serverTF);

   gv -> isServerConnectionOk = busServerConnect(gv, serverString);
   XtFree(serverString);
}

void
actAddKRS(Widget wid, XEvent *event, String *params, Cardinal *nParams)
{
   GV gv = & GlobalVars;
   XmString xms;
   CARD32 krs;
   char krsToAdd[128];
   char *krsString = XmTextGetString(gv -> krsTF);
   Bool observe = XmToggleButtonGetState(gv -> s1TB);
   int status;

   /*
   ** Send info to Koalatalk
   */
   status = busKRSAdd(gv, krsString, observe, & krs);

   if (0 != status) {
      /*
      ** Koalatalk said ok, so update GUI
      */
      if (True == observe)
	 sprintf(krsToAdd, "%s (%d o)", krsString, krs);
      else
	 sprintf(krsToAdd, "%s (%d h)", krsString, krs);
      
      xms = XmStringCreateSimple(krsToAdd);
      XmListAddItem(gv -> krsList, xms, 0);
      XmStringFree(xms);
   }
   XtFree(krsString);
}

void
actRemoveKRS(Widget wid, XEvent *event, String *params, Cardinal *nParams)
{
   GV gv = & GlobalVars;
   XmString xms;
   CARD32 krsId;
   char *krsToRemove, tmp[128], oh;
   int n, *l;

   /*
   ** Remove the selection from the XmList
   */
   xms = cedListGetSelectedString(gv -> krsList);
   XmStringGetLtoR(xms, XmFONTLIST_DEFAULT_TAG, & krsToRemove);
   if (NULL != krsToRemove) {
      XmListDeleteItem(gv -> krsList, xms);
   
   /*
   ** Send info to Koalatalk
   */
      sscanf(krsToRemove, KRS_FORMAT, tmp, & krsId, & oh);
      busKRSRemove(gv, krsId);
   }
   
}
/***************************************************************************
 * Misc
 ***************************************************************************/

Request_t
guiCreateRequestPopup(GV gv)
{
   Request_t result;
   int n;
   Arg args[10];
   Widget tmp;

   NEW(result, RequestRec_t);
   n = 0;
   result ->shell3 = XtCreatePopupShell("requestShell",
				     topLevelShellWidgetClass,
				     gv -> toplevel, args, n);

   n = 0;
   tmp = result ->requestDialog = XmCreateForm(result ->shell3, "request", args, n);

#if 0
   result -> requestId = XmCreateLabel(result -> requestDialog, "idReq", args, n);
   {
      char *ktId, format[128];
      XmString xms;
      int n;
      Arg arg[10];

      ktId = busReturnIdentity(gv);
      sprintf(format, "%s", ktId);
      xms = XmStringCreateSimple(format);
      n = 0;
      XtSetArg(args[n], XmNlabelString, xms); n++;
      XtSetValues(result -> requestId, args, n);
      XtFree(xms);
   }
#endif
   n = 0;

#if 0
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNleftWidget, result -> requestId); n++;
   XtManageChild(result ->requestId);
#endif
   result ->requestLab = XmCreateLabel(result ->requestDialog, "requestLab", args, n);
   XtManageChild(result ->requestLab);

   /*
   ** KRS number
   */
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, result ->requestLab); n++;
   result ->frame3 = XmCreateFrame(result ->requestDialog, "frame3", args, n);
   n = 0;
   result ->f10 = XmCreateForm(result ->frame3, "f10", args, n);
   result ->krs1Lab = XmCreateLabel(result ->f10, "krs1Lab", args, n);
   n = 0;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNleftWidget, result ->krs1Lab); n++;
   result ->krs2Lab = XmCreateLabel(result ->f10, "krs2Lab", args, n);
   XtManageChild(result ->krs1Lab); XtManageChild(result ->krs2Lab);
   XtManageChild(result ->f10); XtManageChild(result ->frame3);

   /*
   ** Arg 1
   */
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, result ->frame3); n++;
   result ->fm1 = XmCreateForm(result ->requestDialog, "fm1", args, n);
   result ->lm1 = XmCreateLabel(result ->fm1, "lm1", args, n);
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, result ->lm1); n++;
   result ->lm2 = XmCreateLabel(result ->fm1, "lm2", args, n);
   XtManageChild(result ->lm2); XtManageChild(result ->lm1);
   XtManageChild(result ->fm1);

   /*
   ** Arg 2
   */
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, result ->frame3); n++;
   result ->fm3 = XmCreateForm(result ->requestDialog, "fm3", args, n);
   result ->lm3 = XmCreateLabel(result ->fm3, "lm3", args, n);
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, result ->lm3); n++;
   result ->lm4 = XmCreateLabel(result ->fm3, "lm4", args, n);
   XtManageChild(result ->lm4); XtManageChild(result ->lm3);
   XtManageChild(result ->fm3);
   n = 0;

   /*
   ** Arg 3
   */
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, result ->frame3); n++;
   result ->fm5 = XmCreateForm(result ->requestDialog, "fm5", args, n);
   result ->lm5 = XmCreateLabel(result ->fm5, "lm5", args, n);
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, result ->lm5); n++;
   result ->lm6 = XmCreateLabel(result ->fm5, "lm6", args, n);
   XtManageChild(result ->lm6); XtManageChild(result ->lm5);
   XtManageChild(result ->fm5);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, result ->fm1); n++;
   result ->sep5 = XmCreateSeparator(result ->requestDialog, "sep5", args, n);
   XtManageChild(result ->sep5);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, result ->sep5); n++;
   result ->replyLab = XmCreateLabel(result ->requestDialog, "replyLab", args, n);
   XtManageChild(result ->replyLab);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, result ->replyLab); n++;
   result ->fm7 = XmCreateForm(result ->requestDialog, "fm7", args, n);
   n = 0;
   result ->lm7 = XmCreateLabel(result ->fm7, "lm7", args, n);
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNleftWidget, result ->lm7); n++;
   result ->tf7 = XmCreateTextField(result ->fm7, "tf7", args, n);
   XtManageChild(result ->lm7); XtManageChild(result ->tf7);
   XtManageChild(result ->fm7);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, result ->fm7); n++;
   result ->fm8 = XmCreateForm(result ->requestDialog, "fm8", args, n);
   n = 0;
   result ->lm8 = XmCreateLabel(result ->fm8, "lm8", args, n);
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNleftWidget, result ->lm8); n++;
   result ->tf8 = XmCreateTextField(result ->fm8, "tf8", args, n);
   XtManageChild(result ->tf8); XtManageChild(result ->lm8);
   XtManageChild(result ->fm8);
   
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, result ->fm8); n++;
   result ->fm9 = XmCreateForm(result ->requestDialog, "fm9", args, n);
   n = 0;
   result ->lm9 = XmCreateLabel(result ->fm9, "lm9", args, n);
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNleftWidget, result ->lm9); n++;
   result ->tf9 = XmCreateTextField(result ->fm9, "tf9", args, n);
   XtManageChild(result ->tf9); XtManageChild(result ->lm9);
   XtManageChild(result ->fm9);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, result ->fm9); n++;
   result ->pb10 = XmCreatePushButton(result ->requestDialog, "send", args, n);
   XtAddCallback(result ->pb10, XmNactivateCallback, cbReplySend, result);
   XtManageChild(result ->pb10);
   
   XtManageChild(result ->requestDialog);

   return result;
}

void
guiInit(GV gv)
{
   Arg args[16];
   int n;
   Widget tmp;
   XtActionsRec actionTable[] = {
      {"addKRS", actAddKRS},
      {"removeKRS", actRemoveKRS},
      {"connectServer", actConnectServer},
      {"sendMessage", actSendMessage},
      {"sendReply", actSendReply},
      NULL
   };


   /*
   ** Read the specific resources
   */
   static XrmOptionDescRec options[] = {
      { "-autoConnect", "*autoConnect", XrmoptionNoArg, "True" },
      { "-observed", "*observed", XrmoptionSepArg, 0 },
      { "-handled", "*handled", XrmoptionSepArg, 0 },
      { "-sendToKRL", "*sendToKRL", XrmoptionSepArg, 0 },
      { "-isNotice", "*isNotice", XrmoptionSepArg, 0 },
      { "-krl", "*krl", XrmoptionSepArg, 0 },
      { "-arg1", "*arg1", XrmoptionSepArg, 0 },
      { "-arg2", "*arg2", XrmoptionSepArg, 0 },
      { "-arg3", "*arg3", XrmoptionSepArg, 0 },
      { "-operation", "*operation", XrmoptionSepArg, 0 },
      { "-server", "*server", XrmoptionSepArg, 0 },
   };

   static XtResource xrl[] = {
#define offset(field) XtOffset(Prefs_t, field)
      { "autoConnect", "AutoConnect", XtRBool, sizeof(Bool),
	offset(autoConnect), XtRImmediate, (caddr_t) False },
      { "observed", "Observed", XtRString, sizeof(String),
	offset(observed), XtRImmediate, (caddr_t) NULL },
      { "handled", "Handled", XtRString, sizeof(String),
	offset(handled), XtRImmediate, (caddr_t) NULL },
      { "sendToKRL", "SendToKRL", XtRBool, sizeof(Bool),
	offset(sendToKRL), XtRImmediate, (caddr_t) True },
      { "isNotice", "IsNotice", XtRBool, sizeof(Bool),
	offset(isNotice), XtRImmediate, (caddr_t) True },
      { "krl", "Krl", XtRString, sizeof(String),
	offset(krl), XtRImmediate, (caddr_t) "default" },
      { "arg1", "Arg1", XtRString, sizeof(String),
	offset(arg1), XtRImmediate, (caddr_t) "default" },
      { "arg2", "Arg2", XtRString, sizeof(String),
	offset(arg2), XtRImmediate, (caddr_t) "default" },
      { "arg3", "Arg3", XtRString, sizeof(String),
	offset(arg3), XtRImmediate, (caddr_t) "default" },
      { "operation", "Operation", XtRString, sizeof(String),
	offset(operation), XtRImmediate, (caddr_t) "no_operation" },
      { "server", "Server", XtRString, sizeof(String),
	offset(server), XtRImmediate, (caddr_t) 0 },
   };

/*
   XrmParseCommand(XrmGetDataBase(XtDisplay(gv -> toplevel)),
   options, XtNumber(options), CLASSNAME,
   & gv -> argc, gv -> argv);
   */


   gv -> toplevel = cedXtAppInitialize(&gv -> appContext, CLASSNAME,
				    options, XtNumber(options),
				    & gv -> argc, gv -> argv, 0, 0, 0);
   XtGetApplicationResources(gv -> toplevel, & gv -> prefs,
			     xrl, XtNumber(xrl),
			     NULL, 0);
   gv -> actionTable = actionTable;
   XtAppAddActions(gv -> appContext, actionTable, XtNumber(actionTable));
   XtAddEventHandler(gv -> toplevel, 0, True, _XEditResCheckMessages, NULL);

/*
   XtAppAddConverter(gv -> appContext, "String", "Callback",
		     stringCallbackCvt, gv, 1);
*/

   /*
   ** Create widgets
   */

   gv -> mainw = XmCreateMainWindow(gv -> toplevel, "mainw", 0, 0);
   n = 0;
   gv -> mainForm = XmCreateForm(gv -> mainw, "mform", args, n);

   /*
   ** ID + Message Button
   */
   n = 0;
   gv -> frame2 = XmCreateFrame(gv -> mainForm, "frame2", args, n);
   gv -> idLab = XmCreateLabel(gv -> frame2, "idLab", args, n);
   n = 0;
   gv -> pb2 = XmCreatePushButton(gv -> mainForm, "pb2", args, n);
   XtAddCallback(gv -> pb2, XmNactivateCallback, cbMessageShow, gv);
   n = 0;

   XtManageChild(gv -> pb2);
   XtManageChild(gv -> idLab);
   XtManageChild(gv -> frame2);
   XtManageChild(gv -> mainForm);

   /*
   ** Separator
   */
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> pb2); n++;
   gv -> sep2 = XmCreateSeparator(gv -> mainForm, "sep2", args, n);
   XtManageChild(gv -> sep2);

   /*
   ** Server section
   */

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> sep2); n++;
   tmp = gv -> f5 = XmCreateForm(gv -> mainForm, "f5", args, n);

   n = 0;
   gv -> serverLab = XmCreateLabel(tmp, "serverLab", args, n);
   n = 0;
   gv -> serverTF = XmCreateTextField(tmp, "serverTF", args, n);
   XtManageChild(gv -> serverLab); XtManageChild(gv -> serverTF);

   n = 0;
   gv -> f51 = XmCreateForm(tmp, "f51", args, n);
   n = 0;
   gv -> connectPB = XmCreatePushButton(gv -> f51, "connectPB", args, n);
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> connectPB); n++;
   gv -> disconnectPB = XmCreatePushButton(gv -> f51, "disconnectPB", args, n);
   XtManageChild(gv -> serverTF);
   XtManageChild(gv -> connectPB);
   XtManageChild(gv -> serverLab);
   XtManageChild(gv -> disconnectPB);
   XtManageChild(gv -> f51);
   XtManageChild(tmp);


   /*
   ** Separator
   */

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> serverLab); n++;
   gv -> sep3 = XmCreateSeparator(gv -> mainForm, "sep3", args, n);
   XtManageChild(gv -> sep3);

   /*
   ** krs section
   */
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> sep3); n++;
   gv -> f1 = XmCreateForm(gv -> mainForm, "f1", args, n);

   n = 0;
   gv -> krsLab = XmCreateLabel(gv -> f1, "krs", args, n);
   XtManageChild(gv -> krsLab);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> krsLab); n++;
   gv -> krsTF = XmCreateTextField(gv -> f1, "krsTF", args, n);
   XtManageChild(gv -> krsTF);
   XtManageChild(gv -> f1);
   
   n = 0;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNleftWidget, gv -> f1); n++;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> sep3); n++;
   gv -> f2 = XmCreateForm(gv -> mainForm, "f2", args, n);

   n = 0;
   gv -> sType = XmCreateRadioBox(gv -> f2, "stype", args,n);
   gv -> s1TB = XmCreateToggleButton(gv -> sType, "observe", args, n);
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> s2TB); n++;
   gv -> s2TB = XmCreateToggleButton(gv -> sType, "handle", args, n);
   XtManageChild(gv -> s1TB); XtManageChild(gv -> s2TB);
   XtManageChild(gv -> sType); XtManageChild(gv -> f2);

   n = 0;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNleftWidget, gv -> f2); n++;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> sep3); n++;
   gv -> f3 = XmCreateForm(gv -> mainForm, "f3", args, n);

   n = 0;
   gv -> pb7 = XmCreatePushButton(gv -> f3, "addPB", args, n);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> pb7); n++;
/*
   XtSetArg(args[n], XmNtopPosition, 10); n++;
*/
   gv -> pb8 = XmCreatePushButton(gv -> f3, "removePB", args, n);
   XtManageChild(gv -> pb7);
   XtManageChild(gv -> pb8);
   XtManageChild(gv -> f3);

   n = 0;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNleftWidget, gv -> f3); n++;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> sep3); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNrightWidget, gv -> mainForm); n++;
   gv -> krsList = XmCreateScrolledList(gv -> mainForm, "krsList", args, n);
   XtAddCallback(gv -> krsList, XmNsingleSelectionCallback, cbSingleSelect, gv);
   XtManageChild(gv -> krsList);

   /*
   ** Separator
   */
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> krsList); n++;
   gv -> sep3 = XmCreateSeparator(gv -> mainForm, "sep3", args, n);
   XtManageChild(gv -> sep3);

   /*
   ** Text
   */
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> sep3); n++;
   gv -> text = XmCreateScrolledText(gv -> mainForm, "text", args, n);
   XtManageChild(gv -> text);

   /*
   ** Dialogs : messages
   */
   n = 0;
   gv -> shell1 = XtCreatePopupShell("messagesShell",
				      topLevelShellWidgetClass,
				      gv -> toplevel, args, n);
   n = 0;
   tmp = gv -> messageDialog = XmCreateBulletinBoard(gv -> shell1, "messages", args, n);
   gv -> frame1 = XmCreateFrame(tmp, "frame1", args, n);
   gv -> f6 = XmCreateForm(gv -> frame1, "f6", args, n);
   gv -> sendToLab = XmCreateLabel(gv -> f6, "sendToLab", args, n);
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> sendToLab); n++;
   gv -> f61 = XmCreateRadioBox(gv -> f6, "f61", args, n);
   n = 0;
   gv -> krlTB = XmCreateToggleButton(gv -> f61, "krlTB", args, n);
   gv -> peerTB = XmCreateToggleButton(gv -> f61, "peerTB", args, n);
   XtManageChild(gv -> krlTB);
   XtManageChild(gv -> peerTB);
   XtManageChild(gv -> f6);
   XtManageChild(gv -> frame1);
   XtManageChild(gv -> f61);
   XtManageChild(gv -> sendToLab);
   XtManageChild(tmp);

   n = 0;
   gv -> f7 = XmCreateForm(tmp, "f7", args, n);
   gv -> destLab = XmCreateLabel(gv -> f7, "destLab", args, n);
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNleftWidget, gv -> f6); n++;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> destLab); n++;
   gv -> destTF = XmCreateTextField(gv -> f7, "destTF", args, n);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> destTF); n++;
   gv -> operationLab = XmCreateLabel(gv -> f7, "operationLab", args, n);
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, gv -> operationLab); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNleftWidget, gv -> f6); n++;
   gv -> operationTF = XmCreateTextField(gv -> f7, "operationTF", args, n);
   XtManageChild(gv -> destTF);
   XtManageChild(gv -> destLab);
   XtManageChild(gv -> operationLab);
   XtManageChild(gv -> operationTF);
   XtManageChild(gv -> f7);

   n = 0;
   tmp = XmCreateSeparator(gv -> messageDialog, "sep1", args, n);
   XtManageChild(tmp);

   /*
   ** Title "message content"
   */
   n = 0;
   gv -> msgContent = XmCreateLabel(gv -> messageDialog, "msgContent", args, n);
   XtManageChild(gv -> msgContent);
   /*
   ** Argument 1
   */
   n = 0;
   gv -> typeM = XmCreatePulldownMenu(gv -> messageDialog, "pd1", args, n);
   XtManageChild(gv -> strB = XmCreatePushButton(gv -> typeM, "str", args, n));

   n = 0;
   XtSetArg(args[n], XmNsubMenuId, gv -> typeM); n++;
   gv -> o1 = XmCreateOptionMenu(gv -> messageDialog, "o1", args, n);
   XtManageChild(gv -> o1);

   n = 0;
   XtManageChild(gv -> arg1TF = XmCreateTextField(gv -> messageDialog, "arg1T", args, n));
   

   /*
   ** Argument 2
   */
   n = 0;
   XtSetArg(args[n], XmNsubMenuId, gv -> typeM); n++;
   gv -> o2 = XmCreateOptionMenu(gv -> messageDialog, "o2", args, n);
   XtManageChild(gv -> o2);

   n = 0;
   XtManageChild(gv -> arg2TF = XmCreateTextField(gv -> messageDialog, "arg2T", args, n));
   

   /*
   ** Argument 3
   */
   n = 0;
   XtSetArg(args[n], XmNsubMenuId, gv -> typeM); n++;
   gv -> o3 = XmCreateOptionMenu(gv -> messageDialog, "o3", args, n);
   XtManageChild(gv -> o3);

   n = 0;
   XtManageChild(gv -> arg3TF = XmCreateTextField(gv -> messageDialog, "arg3T", args, n));

   /*
   ** Message type
   */
   n = 0;
   gv -> mType = XmCreateRadioBox(gv -> messageDialog, "mtype", args, n);
   gv -> notice = XmCreateToggleButton(gv -> mType, "notice", args, n);
   gv -> request = XmCreateToggleButton(gv -> mType, "request", args, n);
   XtManageChild(gv -> notice); XtManageChild(gv -> request);
   XtManageChild(gv -> mType);

   /*
   ** Bottom buttons
   */
   n = 0;
   XtManageChild(gv -> pb4 = XmCreatePushButton(gv -> messageDialog, "send", args, n));
   XtAddCallback(gv -> pb4, XmNactivateCallback, cbMessageSend, gv);
   XtManageChild(gv -> pb5 = XmCreatePushButton(gv -> messageDialog, "hide", args, n));
   XtAddCallback(gv -> pb5, XmNactivateCallback, cbMessageHide, gv);

   /*
   ** Dialog : replying to a request
   */
   gv -> requests = DB_NewDataBase(sizeof(RequestRec_t), NULL);

   /*
   ** Menus
   */
   gv -> menubar = XmCreateMenuBar(gv -> mainw, "menubar", 0, 0);
   gv -> fileM = XmCreatePulldownMenu(gv -> menubar, "gv -> fileM", 0, 0);
   gv -> helpM = XmCreatePulldownMenu(gv -> menubar, "gv -> fileM", 0, 0);
    
   n = 0;
   XtSetArg(args[n], XmNsubMenuId, gv -> fileM); n++;
   XtManageChild(XmCreateCascadeButton(gv -> menubar, "file", args, n));
    
   n = 0;
   XtSetArg(args[n], XmNsubMenuId, gv -> helpM); n++;
   XtManageChild(tmp=XmCreateCascadeButton(gv -> menubar, "help", args, n));
   XtVaSetValues(gv -> menubar, 
		 XmNmenuHelpWidget, tmp,
		 NULL);


   XtManageChild(tmp=XmCreatePushButton(gv -> fileM, "open", 0, 0));
   XtManageChild(tmp=XmCreatePushButton(gv -> fileM, "save", 0, 0));
   XtManageChild(tmp=XmCreateSeparator(gv -> fileM, "s1", 0, 0));
   XtManageChild(tmp=XmCreatePushButton(gv -> fileM, "quit", 0, 0));
   XtAddCallback(tmp, XmNactivateCallback, cbQuit, gv);

   XtManageChild(tmp=XmCreatePushButton(gv -> helpM, "index", 0, 0));
   XtManageChild(tmp=XmCreatePushButton(gv -> helpM, "context", 0, 0));
   XtManageChild(tmp=XmCreateSeparator(gv -> helpM, "context", 0, 0));
   XtManageChild(tmp=XmCreatePushButton(gv -> helpM, "version", 0, 0));

   XtManageChild(gv -> menubar);
   XtManageChild(gv -> mainw);

   XtRealizeWidget(gv -> toplevel);
   XtManageChild(gv -> shell1);
/*
   XtMapWidget(gv -> shell1);
   XtManageChild(gv -> shell3);
*/

   {
       char *server = busLocateServer();
       XmTextSetString(gv -> serverTF, server);
       free(server);
   }
}

void
guiLog1(GV gv, char *str)
{
   int pos;

   pos = XmTextGetLastPosition(gv -> text);
   XmTextInsert(gv -> text, pos, str);
   pos = XmTextGetLastPosition(gv -> text);
}

void
guiLog2(GV gv, char *s1, char *s2)
{
   guiLog1(gv, s1); guiLog1(gv, s2);
   guiLog1(gv, "\n");
}

void
guiLog2d(GV gv, char *s1, int n)
{
   char s[256];
   sprintf(s, s1, n);
   guiLog1(gv, s); guiLog1(gv, "");
   guiLog1(gv, "\n");
}

void
guiUpdate(GV gv)
{
   Arg args[10];
   int n;
   char *ktId, format[128];
   XmString xms;
   struct passwd *pwd;
   CARD32 krs;

   /*
   ** Update the GUI accordingly to the specific resources
   */
   {
      char *p;
      char *interested[2];
      char string[256], *ps;
      int running, i;

      /*
      ** A specific server maybe?
      */
      if (0 != gv -> prefs.server) {
	 XmTextSetString(gv -> serverTF, gv -> prefs.server);
      }

      /*
      ** Connection to server requested?
      */
      if (True == gv -> prefs.autoConnect) {
	 Bool isServerOk;
	 actConnectServer(gv -> toplevel, NULL, NULL, 0);
	 if (False == gv -> isServerConnectionOk)
	    fprintf(stderr, "+++ ktmon warning, couldn't connect to server\n");
      };

      /*
      ** Any observe/handle patterns?
      ** Only do that if we are connected to a server
      */
      if (True == gv -> prefs.autoConnect) {
	 interested[0] = gv -> prefs.observed;
	 interested[1] = gv -> prefs.handled;
	 for (i=0; i<2; i++) {
	    p = interested[i];
	    if (NULL == p) continue;
	    ps = string;
	    running = 1;
	    while (1 == running) {
	       while ('\0' != *p && ',' != *p) {
		  *ps++ = *p++;
	       }
	       *ps++ = '\0';
	       XmToggleButtonSetState(gv -> s1TB, (i == 0 ? True : False), True);
	       XmToggleButtonSetState(gv -> s2TB, (i == 0 ? False : True), True);
	       XmTextFieldSetString(gv -> krsTF, string);
	       actAddKRS(gv -> toplevel, NULL, NULL, 0);
	       if ('\0' == *p) running = 0;
	       else {
		  ps = string;
		  p++;
	       }
	    }   /* while running */
	 }   /* for */
      } /* if True == autoConnect */

      /*
      ** Fill the message dialog with supplied values
      */
      XmTextFieldSetString(gv -> destTF, gv -> prefs.krl);
      XmTextFieldSetString(gv -> arg1TF, gv -> prefs.arg1);
      XmTextFieldSetString(gv -> arg2TF, gv -> prefs.arg2);
      XmTextFieldSetString(gv -> arg3TF, gv -> prefs.arg3);
      XmTextFieldSetString(gv -> operationTF, gv -> prefs.operation);
      if (False == gv -> prefs.sendToKRL) {
	 XmToggleButtonSetState(gv -> krlTB, False, True);
	 XmToggleButtonSetState(gv -> peerTB, True, True);
      }
      if (False == gv -> prefs.isNotice) {
	 XmToggleButtonSetState(gv -> notice, False, True);
	 XmToggleButtonSetState(gv -> request, True, True);
      }

   } /* enf of prefs-specific updating */

   /*
   ** Retrieve our personal id and put it in the label widget
   */
   ktId = busReturnIdentity(gv);
   sprintf(format, "%s", ktId);
   xms = XmStringCreateSimple(format);
   n = 0;
   XtSetArg(args[n], XmNlabelString, xms); n++;
   XtSetValues(gv -> idLab, args, n);
/*
   XtFree(xms);
*/

   /*
   ** Observe a krs matching my user id
   */
/*
   pwd = getpwuid(getuid());
   XmTextSetString(gv -> krsTF, pwd -> pw_name);
   actAddKRS(gv -> krsTF, (XEvent *) 0, (String *) 0, (Cardinal *) 0);
*/

}

void
guiGetReply(GV gv, char *a1, char *a2, char *a3, CARD32 spec)
{
   int n, i;
   Arg args[10];
   XmString x;
   char *s[3], pchKRSpec[128];
   Widget w[3];
   XmString xms;
   Request_t newRequest;

   newRequest = guiCreateRequestPopup(gv);

   s[0] = a1; s[1] = a2; s[2] = a3;
   w[0] = newRequest -> lm2; w[1] = newRequest -> lm4; w[2]= newRequest->lm6;

   sprintf(pchKRSpec, "%d", spec);
   xms = XmStringCreateSimple(pchKRSpec);
   XtVaSetValues(newRequest -> krs2Lab,
		 XmNlabelString, xms,
		 NULL);
/*
   XtFree(xms);
*/
   for (i=0; i<3; i++) {
      n = 0;
      x = XmStringCreateSimple(s[i]);
      XtSetArg(args[n], XmNlabelString, x); n++;
      XtSetValues(w[i], args, n);
/*
      XtFree(x);
*/
   }

   DB_AddEntry(gv -> requests, newRequest);
   XtManageChild(newRequest -> shell3);
}


void
guiHandleXInput(GV gv)
{
   XtInputMask xim;
   XEvent event;

   while (0 != (xim = XtAppPending(gv -> appContext))) {
      XtAppNextEvent(gv -> appContext, & event);
      XtDispatchEvent(& event);
   }
}

