/*
 *
 * $Id: main.h,v 1.9 1994/07/11 14:02:13 beust Exp $
 */

#include <assert.h>

#include "kt_lib.h"
#include "database.h"

#include <X11/Intrinsic.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/MainW.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/Frame.h>
#include <Xm/List.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <X11/Xmu/Editres.h>

#define CLASSNAME "Ktmon"

typedef struct {
                    Bool autoConnect;
                    char *observed;
		    char *handled;
		    Bool sendToKRL;
		    Bool isNotice;
		    char *krl;
		    char *arg1, *arg2, *arg3;
		    char *operation;
		    char *server;
} *Prefs_t, PrefsRec_t;


typedef struct {
   Widget shell3, requestDialog;
   Widget requestId;
   Widget requestLab;
   Widget frame3, f10, krs1Lab, krs2Lab;
   Widget fm1, lm1, lm2;
   Widget fm3, lm3, lm4;
   Widget fm5, lm5, lm6;
   Widget sep5;
   Widget replyLab;
   Widget fm7, lm7, tf7;
   Widget fm8, lm8, tf8;
   Widget fm9, lm9, tf9;
   Widget pb10, pb11;
} *Request_t, RequestRec_t;

typedef struct {
   XtInputId id;     /* id returned by XtAppAddInput */
} *InfoFd_t, InfoFdRec_t;

typedef struct _GlobalVars {

   int argc;
   char **argv;
   Bool isServerConnectionOk;

   /*
   ** Default values (via resources or command line)
   */
   PrefsRec_t prefs;

   /*
   ** Bus related
   */
   Kt_Context ktContext;
   Kt_Message lastRequest;
   CARD32 lastRequestId;
#ifdef USE_SELECT
   fd_set fds;
   int xfd;    /* X file descriptor */
#else
   InfoFd_t fdi[64];     /* actually, getdtablesize() */
#endif

   /*
   ** Gui related
   */
   XtAppContext appContext;
   XtActionsRec *actionTable;

   Widget toplevel, mainw, menubar;
   Widget fileM, helpM, file, help;
   Widget mainForm;
   Widget frame2, idLab, pb2;

   Widget sep2;

   Widget f5, serverLab, serverTF, f51, connectPB, disconnectPB;

   Widget sep3;

   Widget f1, f2, f3, f4;
   Widget krsLab, krsTF;
   Widget sType, s1TB, s2TB;
   Widget pb7, pb8;
   Widget krsList;

   Widget sep4;

   Widget text;

   /*
   ** Messages
   */
   Widget shell1, shell2;
   Widget messageDialog, prefsDialog;
   Widget f6, sendToLab, frame1, f61, krlTB, peerTB;
   Widget f7, destLab, destTF, operationLab, operationTF;

   Widget msgContent;
   Widget o1, o2, o3;   /* options menus */
   Widget typeM;    /* type of message menu */
   Widget strB, bytesB;    /* pushbuttons */
   Widget arg1TF, arg2TF, arg3TF;  /* textfields for arguments contents */
   Widget mType;   /* message type */
   Widget notice, request;
   Widget pb4, pb5, pb6;

   /*
   ** Replying to a request
   */
   DataBase requests;   /* db of struct Request_t */

} GVRec, *GV;

extern GVRec GlobalVars;

/* gui.c */

/* Format : krs (krsId o|h) */
#define KRS_FORMAT "%s (%d %c)"

/*
** Called each time an X event is available
*/
void
guiHandleXInput(GV gv);

void
guiInit(GV gv);

void
guiGetReply(GV gv, char *a1, char *a2, char *a3, CARD32 spec);

void
guiUpdate(GV gv);

void
addKRSAction(Widget wid, XEvent *event, String *params, Cardinal *nParams);

void
guiLog1(GV gv, char *s1);

void
guiLog2(GV gv, char *s1, char *s2);

/* bus.c */

void
busInit(GV gv);

void
busUpdate(GV gv);

char *
busReturnIdentity(GV gv);

Bool
busServerConnect(GV gv, char *serverIceCoord);
/* Return True if connection successful */

void
busMessageSend(GV gv, char *strOperation,
	       char *krl, char *s1, char *s2, char *s3,
	       Bool isNotice, Bool isKrl);

/*
** Return != 0 if successful
*/
int
busKRSAdd(GV gv, char *krSpec, Bool observe, CARD32 *returnedKRS);

int
busKRSRemove(GV gv, CARD32 krs);

char *
busLocateServer();

void
busMainLoop(GV gv);

#ifdef DEBUG
#define D(x) x
#else
#define D(x)
#endif
