/*
 *
 * $Id$
 */

#include "kt_lib.h"

/* callback of type Kt_ServerMsgCallback */
static void
cb(Kt_Context context, void *userData, Kt_Message msg, CARD32 krlId)
{
      printf("-------------launch received a message, op='%s'\n",
	     kt_MessageOperationGet(msg));

}

void
main()
{
   Kt_Context context;
   Kt_Message msg;
   Bool isDispatched;
   char *coord, **servers;
   int n;
   char *arg1;

   kt_LocateServer(& servers, & n);
   if (n > 0) {
      context = kt_Init(0, 0, 0, 0);
      printf("-------------launch started (%s)\n", kt_ReturnIdentity(context));
      kt_OpenServerConnection(context, servers[0], "A launched program");
      kt_KRObserve(context, "launched.*", cb, 0);
      while (1) {
	 printf("------------- blocking on NextMessage\n");
	 kt_NextMessage(context, & msg);
	 printf("------------- got msg: op='%s'\n",
		kt_MessageOperationGet(msg));
	 kt_MessageStringGet(msg, 0, & arg1);
	 printf("------------- got msg: arg1='%s'\n",
		arg1);
	 free(arg1);
	 isDispatched = kt_DispatchMessage(context, msg);
	 if (False == isDispatched)
	    printf("------------- msg not dispatched\n");
	 else
	    printf("------------- msg was dispatched\n");
      }
      printf("-------------launch ended\n");
   }
   else {
      printf("no server\n");
   }
}

