/* Native support for GDB 4.17 an Intel i386 DG/ux.
   Copyright 1986, 1987, 1989, 1992 Free Software Foundation, Inc.
   Changes for 80386 by Pace Willisson (pace@prep.ai.mit.edu), July 1988.
   Written by Takis Psarogiannakopoulos
   Department of Pure Mathematics, Cambridge University
   UK , e-mail <takis@dpmms.cam.ac.uk>

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#define FLOAT_INFO { i386dgux_float_info (); }


/* From nm-i386v.h file */
#define REGISTER_U_ADDR(addr, blockend, regno) \
	(addr) = i386dgux_register_u_addr ((blockend),(regno));

/* This should be in i386dgux-nat.c or directly to dg_xtrace.c */
extern int
i386dgux_register_u_addr PARAMS ((int, int));

/* U_REGS_OFFSET is the offset of the registers
 * the user structure. After 4 integers we have 
 * the structure pt_mcontext (for ix86) which 
 * contains just the sets gregs and fpregs. 
 */

#define U_REGS_OFFSET \
    (offsetof (struct ptrace_user, pt_mcontext.gregs))

/* For floating point Info */
#define U_FPREGS_OFFSET \
    (offsetof (struct ptrace_user, pt_mcontext.fpregs.fp_reg_set.fpchip_state.state))

#define NO_PTRACE_H
#if !defined(ATTACH_DETACH)
#define ATTACH_DETACH 1
#endif
#define PROCESS_GROUP_TYPE pid_t

#define CHILD_WAIT 1
struct target_waitstatus;
extern int child_wait PARAMS ((int, struct target_waitstatus *));
extern int first_time_dg_attach;

/* Use SVR4 style shared library support
 * with DG/ux flavor so modify also solib.c
 */

#define SVR4_SHARED_LIBS
#include "solib.h"
#define SVR4_SHARED_LIBS_DGUX_FLAVOR

