/* Intel DGUX Interface to dg_xtrace syscall for GDB.
   Copyright 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996 Free Software Foundation, Inc.
   Written by Takis Psarogiannakopoulos
   Department of Pure Mathematics, Cambridge University
   UK , e-mail <takis@dpmms.cam.ac.uk>


This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "defs.h"
#include "frame.h"
#include "inferior.h"
#include "target.h"
#include "gdb_string.h"
#include "wait.h"
#include "command.h"
#include <sys/types.h>
#include <sys/param.h>
#include <sys/dir.h>
#include <signal.h>
#include <sys/ioctl.h>

#include "gdbcore.h"
#include <sys/file.h>
#include <sys/user.h>
#include <sys/dg_xtrace.h>

int first_time_dg_attach=0;


#if 0
/* Don't think this is used anymore.  On the sequent (not sure whether it's
   dynix or ptx or both), it is included unconditionally by sys/user.h and
   not protected against multiple inclusion.  */
#include "gdb_stat.h"
#endif

#if !defined (CHILD_XFER_MEMORY)
static void udot_info PARAMS ((char *, int));
#endif

#if !defined (FETCH_INFERIOR_REGISTERS)
static void fetch_register PARAMS ((int));
static void store_register PARAMS ((int));
#endif

void
kill_inferior ()
{
  union dg_xtrace_u dgxu;
  int result;
  if (inferior_pid == 0)
  {
     return;
  }

  /* This once used to call "kill" to kill the inferior just in case
     the inferior was still running.  As others have noted in the past
     (kingdon) there shouldn't be any way to get here if the inferior
     is still running -- else there's a major problem elsewere in gdb
     and it needs to be fixed. */



  errno = 0;
  result=0;
  result=DG_XTRACE_TERMINATE_TARGET(inferior_pid, &dgxu);

  if (result !=0)
  {
    perror_with_name ("kill inferior|dg_xtrace");
  }

  wait ((int *)0);
  target_mourn_inferior ();
}


#ifndef CHILD_RESUME

/* Resume execution of the inferior process.
   If STEP is nonzero, single-step it.
   If SIGNAL is nonzero, give it that signal.  */

void
child_resume (pid, step, signal)
     int pid;
     int step;
     enum target_signal signal;
{
  union dg_xtrace_u dgxu;
  int result=0;
  errno = 0;

  if (pid == -1)
    /* Resume all threads.  */
    /* I think this only gets used in the non-threaded case, where "resume
       all threads" and "resume inferior_pid" are the same.  */
    pid = inferior_pid;


   /*
     If this system does not support PT_STEP, a higher level function will
     have called single_step() to transmute the step request into a
     continue request (by setting breakpoints on all possible successor
     instructions), so we don't have to worry about that here.  */

  if (step)
    {
#if defined(NO_SINGLE_STEP)
      abort();  /* Make sure this doesn't happen. */
#else
      result=DG_XTRACE_SINGLE_STEP_TARGET(pid, target_signal_to_host(signal) ,&dgxu);

#endif          /* NO_SINGLE_STEP */
    }
  else
      result=DG_XTRACE_CONTINUE_TARGET(pid, target_signal_to_host(signal), read_pc(), &dgxu);
  if (result !=0)
  {
    perror_with_name ("child_resume|dg_xtrace");
  }

}
#endif

#ifdef ATTACH_DETACH
/* Start debugging the process whose number is PID.  */

int
attach (pid)
     int pid;
{
  union dg_xtrace_u dgxu;
  int result;

#if defined(DGDEBUG)
  printf("Using the attach(pid) function ...\n");
#endif
  errno = 0;
  result=0;
  inferior_pid = pid;
  result=DG_XTRACE_TRACE_PID (pid, &dgxu);
  if (result !=0)
  {
    perror_with_name ("attach|dg_xtrace");
  }
  attach_flag = 1;
  first_time_dg_attach=1;
  errno=0;
  /* SEND STOP */
  if (kill (inferior_pid, SIGTRAP) != 0)
  {
    error("Attempt to send SIGTRAP to pid %d fail,errno %d\n", inferior_pid, errno);
  }
  return pid;
}



/* Stop debugging the process whose number is PID
   and continue it with signal number SIGNAL.
   SIGNAL = 0 means just continue it.  */

void
detach (signal)
     int signal;
{

  union dg_xtrace_u dgxu;
  int takis;
  int result;

#if defined(DGDEBUG)
  printf("Using the dettach(pid) function ...\n");
#endif

  errno = 0;
  takis = 1;
  result=0;
  result=DG_XTRACE_UNTRACE_PID (inferior_pid, takis, &dgxu);
  if (result !=0)
  {
     perror_with_name ("detach|dg_xtrace");
  }
  attach_flag = 0;
  first_time_dg_attach=0;

}

#endif /* ATTACH_DETACH */


/* Default the type of the ptrace transfer to int.  */
#ifndef PTRACE_XFER_TYPE
#define PTRACE_XFER_TYPE int
#endif

#if !defined (FETCH_INFERIOR_REGISTERS)

#if !defined (offsetof)
#define offsetof(TYPE, MEMBER) ((unsigned long) &((TYPE *)0)->MEMBER)
#endif

/* Copy LEN bytes from inferior's memory starting at MEMADDR
   to debugger memory starting at MYADDR.
   On failure (cannot read from inferior, usually because address is out
   of bounds) returns the value of errno. */

int
dgux_read_inferior_memory (memaddr, myaddr, len)
     CORE_ADDR memaddr;
     char *myaddr;
     int len;
{
   union dg_xtrace_u dgxu;
   return (DG_XTRACE_READ_TARGET (inferior_pid, DG_XT_ADDRESS_SPACE, (char *)memaddr,
					myaddr, (long *)&len, &dgxu) < 0
		? errno : 0);
}


/* Copy LEN bytes of data from debugger memory at MYADDR
   to inferior's memory at MEMADDR.
   On failure (cannot write the inferior)
   returns the value of errno.  */

int
dgux_write_inferior_memory (memaddr, myaddr, len)
     CORE_ADDR memaddr;
     char *myaddr;
     int len;
{
   union dg_xtrace_u dgxu;
   return (DG_XTRACE_WRITE_TARGET (inferior_pid, DG_XT_ADDRESS_SPACE, (char *)memaddr,
					(char *)myaddr, (long *)&len, &dgxu) < 0
		? errno : 0);

}

void
i386dgxtrace_read_float_registers ()
{

  unsigned int offset;
  union dg_xtrace_u dgxu;
  struct ptrace_user u;
  unsigned int total;
  unsigned int size_fprg;
  struct fpregset fprg;
  char mess[128];

 /*  
  *
  * floatoffset = (char *) &u.pt_mcontext.fpregs.fp_reg_set.fpchip_state.state
  * - (char *) &u
  * fpregset should be 380 bytes
  * but read only 112 = 10*4
  * + 7*4 + 4
  * total=sizeof(fprg)
  */

  /* Read all registers to
   * avoid updating olny
   * the floating point
   * registers
   */

  size_fprg = sizeof(fprg);
  total = (76+size_fprg);

  offset = U_REGS_OFFSET;
  if (DG_XTRACE_READ_TARGET (inferior_pid, DG_XT_USER_SPACE, (char *)offset,
		(char *)&registers, (long *)&total, &dgxu) < 0)
  {
    sprintf (mess, "error in subroutine i386dgxtrace_read_float_registers:");
    perror_with_name (mess);
  }

}



void
i386dgxtrace_fetch_all_inferior_registers ()
{

  unsigned int offset;
  union dg_xtrace_u dgxu;
  struct ptrace_user u;
  unsigned int size_fprg;
  unsigned int total;
  struct fpregset fprg;
  char mess[128];

  /* 19 General Regs 4 bytes each
   * plus fpregset = 380
   */
  size_fprg = sizeof(fprg);
  total = (76+size_fprg);

  offset = U_REGS_OFFSET;
  if (DG_XTRACE_READ_TARGET (inferior_pid, DG_XT_USER_SPACE, (char *)offset,
				(char *)&registers, (long *)&total, &dgxu) < 0)
  {
    sprintf (mess, "error in subroutine i386dgxtrace_fetch_all_inferior_registers:");
    perror_with_name (mess);
  }

}

void
i386dgxtrace_write_all_inferior_registers ()
{

  union dg_xtrace_u dgxu;
  struct ptrace_user u;
  struct fpregset fprg;
  unsigned int size_fprg;
  unsigned int offset;
  unsigned int total;
  char mess[128];

  /*
   * 19 General Regs 4 bytes each
   * plus fpregset = 380
   */

  size_fprg = sizeof(fprg);
  total=(76+size_fprg);

  offset = U_REGS_OFFSET;

  if (DG_XTRACE_WRITE_TARGET (inferior_pid, DG_XT_USER_SPACE, (char *)offset,
					(char *)&registers, (long *)&total, &dgxu) < 0)
  {
    sprintf (mess, "error in subroutine i386dgxtrace_write_all_inferior_registers:");
    perror_with_name (mess);
  }

}





/* Registers we shouldn't try to fetch.  */

#if !defined (CANNOT_FETCH_REGISTER)
#define CANNOT_FETCH_REGISTER(regno) 0
#endif

/* Fetch one register.  */

static void
fetch_register (regno)
     int regno;
{
  struct ptrace_user u;
  int num_read = REGISTER_RAW_SIZE (regno);
  union dg_xtrace_u dgxu;
  /* This isn't really an address */
  CORE_ADDR regaddr;
  char mess[128];				/* For messages */
  unsigned int offset;  /* Offset of registers within the u area.  */
  char buf[MAX_REGISTER_RAW_SIZE];
  int result;

  if (CANNOT_FETCH_REGISTER (regno))
  {
      memset (buf, '\0', REGISTER_RAW_SIZE (regno));	/* Supply zeroes */
      supply_register (regno, buf);
      return;
  }

  offset = U_REGS_OFFSET;
  regaddr = register_addr (regno, offset);
  result=0;
  result=DG_XTRACE_READ_TARGET (inferior_pid, DG_XT_USER_SPACE, (char *)regaddr, buf, (long *)&num_read, &dgxu);
  if (result != 0)
  {
    sprintf (mess, "reading register %s (#%d)", reg_names[regno], regno);
    perror_with_name (mess);
  }
  supply_register (regno, buf);
}


/* 
 * Fetch register values from the inferior.
 * If REGNO is negative, do this for all registers.
 * Otherwise, REGNO specifies which register (so we can save time)
 *
 */

void
fetch_inferior_registers (regno)
     int regno;
{
  if (regno >= 0)
  {
      fetch_register (regno);
  }
  else
  {
      i386dgxtrace_fetch_all_inferior_registers();
  }

}

/* Registers we shouldn't try to store.  */
#if !defined (CANNOT_STORE_REGISTER)
#define CANNOT_STORE_REGISTER(regno) 0
#endif


/* Store one register. */

static void
store_register (regno)
     int regno;
{

  /*
   * This isn't really an address.But dg_xtrace thinks
   * of it as one by taking it as &u + regaddr
   */

  union dg_xtrace_u dgxu;
  unsigned int num_write;
  CORE_ADDR regaddr;
  char mess[128];                               /* For messages */
  unsigned int offset;  /* Offset of registers within the u area.  */
  int result;

  num_write = REGISTER_RAW_SIZE(regno);
  if (CANNOT_STORE_REGISTER (regno))
  {
      return;
  }

  offset = U_REGS_OFFSET;
  regaddr = register_addr (regno, offset);
  result = 0;
  /* Write back the register */
  result = DG_XTRACE_WRITE_TARGET (inferior_pid, DG_XT_USER_SPACE, (char *)regaddr,
					(char *)&registers[REGISTER_BYTE(regno)], (long *)&num_write, &dgxu);
  if (result != 0)
  {
      sprintf (mess, "writing register %s (#%d)", reg_names[regno], regno);
      perror_with_name (mess);
  }

}

/* Store our register values back into the inferior.
   If REGNO is negative, do this for all registers.
   Otherwise, REGNO specifies which register (so we can save time).  */

void
store_inferior_registers (regno)
     int regno;
{
  if (regno >= 0)
    {
      store_register (regno);
    }
  else
    {
      i386dgxtrace_write_all_inferior_registers();
    }
}

#endif /* !defined (FETCH_INFERIOR_REGISTERS).  */


#if !defined (CHILD_XFER_MEMORY)

/* Copy LEN bytes to or from inferior's memory starting at MEMADDR
   to debugger memory starting at MYADDR.   Copy to inferior if
   WRITE is nonzero.
   Returns the length copied, which is either the LEN argument or zero.
   This xfer function does not do partial moves, since child_ops
 * doesn't allow memory operations to cross below us in the target stack
 * anyway.
 */

int
child_xfer_memory (memaddr, myaddr, len, write, target)
     CORE_ADDR memaddr;
     char *myaddr;
     int len;
     int write;
     struct target_ops *target;		/* ignored */
{
  int result;
  char mess[128];
  result=0;
  if (write)
  {
     result=dgux_write_inferior_memory (memaddr, myaddr, len);
     if (result != 0)
     {
        sprintf (mess, "error in subroutine child_xfer_memory :write part");
        perror_with_name (mess);
        return 0;
     }
  }  
  else
  {
     result=dgux_read_inferior_memory (memaddr, myaddr, len);
     if (result != 0)
     {
        sprintf (mess, "error in subroutine child_xfer_memory :read part");
        perror_with_name (mess);
        return 0;
     }
  }
  return len;
}

/* READ 2048 bytes of the struct user=ptrace_user */

static void
udot_info (dummy1, dummy2)
     char *dummy1;
     int dummy2;
{
  int result;
#if defined (KERNEL_U_SIZE)
  union dg_xtrace_u dgxu;
  struct ptrace_user u;
  unsigned int num_read; /* 4 Bytes */ 
  int udot_off;         /* Offset into user struct */
  int udot_val;         /* Value from user struct at udot_off */
  char mess[128];       /* For messages */
#endif

   if (!target_has_execution)
     {
       error ("The program is not being run.");
     }

#if !defined (KERNEL_U_SIZE)

  /* Adding support for this command is easy.  Typically you just add a
     routine, called "kernel_u_size" that returns the size of the user
     struct, to the appropriate *-nat.c file and then add to the native
     config file "#define KERNEL_U_SIZE kernel_u_size()" */
  error ("Don't know how large ``struct user'' is in this version of gdb.");

#else

  /* udot_val is an integer so 4 bytes */
  num_read = 4; /* read 4 bytes by mimic ptrace syscall */

  for (udot_off = 0; udot_off < KERNEL_U_SIZE; udot_off += sizeof (udot_val))
  {
      if ((udot_off % 24) == 0)
      {
          if (udot_off > 0)
          {
             printf_filtered ("\n");
          }
          printf_filtered ("%04x:", udot_off);
      }
      result =0;
      result = DG_XTRACE_READ_TARGET(inferior_pid, DG_XT_USER_SPACE, (char *)udot_off,
					(char *)&udot_val, (long *)&num_read, &dgxu);
      if (result != 0)
        {
          sprintf (mess, "\nreading user struct at offset 0x%x", udot_off);
          perror_with_name (mess);
        }
      /* Avoid using nonportable (?) "*" in print specs */
      printf_filtered (sizeof (int) == 4 ? " 0x%08x" : " 0x%16x", udot_val);
    }
  printf_filtered ("\n");

#endif
}
#endif /* !defined (CHILD_XFER_MEMORY).  */

void
_initialize_infptrace ()
{

#if !defined (CHILD_XFER_MEMORY)
  add_info ("udot", udot_info,
	    "Print contents of kernel ``struct user'' for current child.");
#endif
}

