/* Macro definitions for Intel based ix86 AViiON DG/ux machines.
   Copyright 1986, 1987, 1989, 1991, 1992, 1993 Free Software Foundation, Inc.
   Written by Takis Psarogiannakopoulos
   Department of Pure Mathematics, Cambridge University
   UK , e-mail <takis@dpmms.cam.ac.uk>


This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#if !defined (TM_I386DGUX_H)
#define TM_I386DGUX_H 1

#define TARGET_BYTE_ORDER LITTLE_ENDIAN

/* For SVR4 shared libraries, each call to a library routine goes through
   a small piece of trampoline code in the ".plt" section.
   The horribly ugly wait_for_inferior() routine uses this macro to detect
   when we have stepped into one of these fragments.
   We do not use lookup_solib_trampoline_symbol_by_pc, because
   we cannot always find the shared library trampoline symbols
   (e.g. on Irix5).  */

#define IN_SOLIB_CALL_TRAMPOLINE(pc, name) in_plt_section((pc), (name))
extern int in_plt_section PARAMS ((CORE_ADDR, char *));

/* If PC is in a shared library trampoline code, return the PC
   where the function itself actually starts.  If not, return 0.  */

#define SKIP_TRAMPOLINE_CODE(pc)  find_solib_trampoline_target (pc)

/* It is unknown which, if any, SVR4 assemblers do not accept dollar signs
   in identifiers.  The default in G++ is to use dots instead, for all SVR4
   systems, so we make that our default also.  FIXME: There should be some
   way to get G++ to tell us what CPLUS_MARKER it is using, perhaps by
   stashing it in the debugging information as part of the name of an
   invented symbol ("gcc_cplus_marker$" for example). */

#undef CPLUS_MARKER
#define CPLUS_MARKER '.'

/* turn this on when rest of gdb is ready */
#define IEEE_FLOAT

/* Offset from address of function to start of its code.
   Zero on most machines.  */

#define FUNCTION_START_OFFSET 0

/* Advance PC across any function entry prologue instructions
   to reach some "real" code.  */

#define SKIP_PROLOGUE(frompc)   {(frompc) = i386_skip_prologue((frompc));}

extern int
i386_skip_prologue PARAMS ((int));

/* Immediately after a function call, return the saved pc.
   Can't always go through the frames for this because on some machines
   the new frame is not set up until the new function executes
   some instructions.  */

#define SAVED_PC_AFTER_CALL(frame) \
  (read_memory_integer (read_register (SP_REGNUM), 4))

/* Stack grows downward.  */

#define INNER_THAN(lhs,rhs) ((lhs) < (rhs))

/* Sequence of bytes for breakpoint instruction.  */

#define BREAKPOINT {0xcc}

/* Amount PC must be decremented by after a breakpoint.
   This is often the number of bytes in BREAKPOINT
   but not always.  */

#ifndef DECR_PC_AFTER_BREAK
#define DECR_PC_AFTER_BREAK 1
#endif

/* Nonzero if instruction at PC is a return instruction.  */

#define ABOUT_TO_RETURN(pc) (read_memory_integer (pc, 1) == 0xc3)

/* Return 1 if P points to an invalid floating point value.
   LEN is the length in bytes -- not relevant on the 386.  */

#define INVALID_FLOAT(p, len) (0)

/* Say how long (ordinary) registers are.  This is a piece of bogosity
   used in push_word and a few other places; REGISTER_RAW_SIZE is the
   real way to know how big a register is.  */

#define REGISTER_SIZE 4

/* Number of machine registers */

#include <sys/regset.h>
#define NUM_FREGS 8             /* Number of FP regs */
#define NUM_REGS (NGREG + NUM_FREGS + 8)    /* Basic ix86 regs=19 + FP regs */

/* The order of the first 19 registers must match the compiler's 
 * numbering scheme (which is the same as the 386 scheme)
 * also, this table must match regmap in i386dgux-nat.c.
 */


/* We have in addition three general registers before the set of fpregs
 * in the struct ptrace_user , ie esp=7, err=13, trapno=12
 */


#define REGISTER_NAMES { "eax", "ecx", "edx", "ebx", \
			 "uesp", "ebp", "esi", "edi", \
			 "eip", "eflags", "cs", "ss", \
			 "ds", "es", "fs", "gs", \
			 "esp", "err", "trapno", "fctrl", \
			 "fstat", "ftag", "fip", "fcs", \
			 "fopoff", "fopsel", "fst0", \
			 "fst1", "fst2", "fst3", "fst4", \
			 "fst5", "fst6", "fst7", "fchipstatus" \
		        }

/* Register numbers of various important registers.
   Note that some of these values are "real" register numbers,
   and correspond to the general registers of the machine,
   and some are "phony" register numbers which are too large
   to be actual register numbers as far as the user is concerned
   but do serve to get the desired values when passed to read_register.  */

#define FP_REGNUM 5     /* (ebp) Contains address of executing stack frame */
#define SP_REGNUM 4     /* (uesp) Contains address of top of stack */
#define PC_REGNUM 8     /* (eip) Contains program counter */
#define PS_REGNUM 9     /* (ps=eflags)  Contains processor status */

#define FP0_REGNUM          26 		/* (fst0) first float 387 register */
#define FP1_REGNUM          27  	/* (fst1) float 387 register */
#define FP2_REGNUM          28 		/* (fst2) float 387 register */
#define FP3_REGNUM          29 		/* (fst3) float 387 register */
#define FP4_REGNUM          30  	/* (fst4) float 387 register */
#define FP5_REGNUM          31 		/* (fst5) float 387 register */
#define FP6_REGNUM          32  	/* (fst6) float 387 register */
#define FP7_REGNUM          33  	/* (fst7) float 387 register */


#define FPC_REGNUM          19 		/* fctrl  80387 control register */
#define FPSTAT_REGNUM       20 		/* fstat */
#define FPTAG_REGNUM        21 		/* ftag */
#define FPIP_REGNUM         22 		/* fip */
#define FPCS_REGNUM         23		/* fcs */
#define FPOPOFF_REGNUM      24		/* fopoff */
#define FPOPSEL_REGNUM      25 		/* fopsel */


#define FPCHIPSTATUS_REGNUM 34 		/* fchipstatus */


/* Total amount of space needed to store our copies of the machine's register
 * state, the array `registers'.
 * ( 19*4 + 7*4 + 8*10 1*4 ) = 76+28+80+4=188 
 */

#define REGISTER_BYTES (19*4 + 7*4 + 8*10 + 4)

/* Index within `registers' of the first byte of the space for register N.
 * (19 and not 16!  General registers * 4 bytes each =76 below)
 * plus 8 additional float registers 7*4=28 -->total 76+28=104 bytes
 */
 
#define REGISTER_BYTE(N) \
 ((N) >= FPCHIPSTATUS_REGNUM ? (((N) - FPCHIPSTATUS_REGNUM) * 4) + 184    \
  : (N) >= FP0_REGNUM ? (((N) - FP0_REGNUM) * 10) + 104  \
  : (N) * 4)


/* Number of bytes of storage in the actual machine representation for
 * register N.  All registers are 4 bytes, except 387 fst(0) - fst(7),
 * which are 80 bits each =(10 bytes).
 */

#define REGISTER_RAW_SIZE(N) (((unsigned)((N) - FP0_REGNUM)) < 8 ? 10 : 4)

/* Largest value REGISTER_RAW_SIZE can have.  */

#define MAX_REGISTER_RAW_SIZE 10

/* Number of bytes of storage in the program's representation
   for register N. */

#define REGISTER_VIRTUAL_SIZE(N) (((unsigned)((N) - FP0_REGNUM)) < 8 ? 8 : 4)

/* Largest value REGISTER_VIRTUAL_SIZE can have.  */

#define MAX_REGISTER_VIRTUAL_SIZE 8


/* Nonzero if register N requires conversion
   from raw format to virtual format.  */

#define REGISTER_CONVERTIBLE(N) (((unsigned)((N) - FP0_REGNUM)) < 8)

/* Convert data from raw format for register REGNUM in buffer FROM
   to virtual format with type TYPE in buffer TO.  */

#undef  REGISTER_CONVERT_TO_VIRTUAL
#define REGISTER_CONVERT_TO_VIRTUAL(REGNUM,TYPE,FROM,TO) \
{ \
  double val; \
  i387_to_double ((FROM), (char *)&val); \
  store_floating ((TO), TYPE_LENGTH (TYPE), val); \
}
extern void
i387_to_double PARAMS ((char *, char *));

/* Convert data from virtual format with type TYPE in buffer FROM
   to raw format for register REGNUM in buffer TO.  */

#undef  REGISTER_CONVERT_TO_RAW
#define REGISTER_CONVERT_TO_RAW(TYPE,REGNUM,FROM,TO) \
{ \
  double val = extract_floating ((FROM), TYPE_LENGTH (TYPE)); \
  double_to_i387((char *)&val, (TO)); \
}
extern void
double_to_i387 PARAMS ((char *, char *));

/*
 * Return the GDB type object for the "standard" data type of data in
 * register N.  Perhaps si and di should go here, but potentially they
 * could be used for things other than address.
 */

#define REGISTER_VIRTUAL_TYPE(N) \
 (((unsigned)((N) - FP0_REGNUM)) < 8 ? builtin_type_double : builtin_type_int)

/* Store the address of the place in which to copy the structure the
   subroutine will return.  This is called from call_function. */

#define STORE_STRUCT_RETURN(ADDR, SP) \
  { (SP) -= sizeof (ADDR);              \
    write_memory ((SP), (char *) &(ADDR), sizeof (ADDR)); }

/* Extract from an array REGBUF containing the (raw) register state
   a function return value of type TYPE, and copy that, in virtual format,
   into VALBUF.  */


#define EXTRACT_RETURN_VALUE(TYPE,REGBUF,VALBUF) \
   i386dgux_extract_return_value ((TYPE),(REGBUF),(VALBUF))

struct type;

extern void
i386dgux_extract_return_value PARAMS ((struct type *, char [], char *));

/* Write into appropriate registers a function return value of type TYPE, given
   in virtual format.  */

#define STORE_RETURN_VALUE(TYPE,VALBUF) \
  {                                                                          \
    if (TYPE_CODE (TYPE) == TYPE_CODE_FLT)                                   \
      write_register_bytes (REGISTER_BYTE (FP0_REGNUM), (VALBUF),            \
                            TYPE_LENGTH (TYPE));                             \
    else                                                                     \
      write_register_bytes (0, (VALBUF), TYPE_LENGTH (TYPE));                \
  }

/* Extract from an array REGBUF containing the (raw) register state the address
   in which a function should return its structure value, as a CORE_ADDR (or an
   expression that can be used as one).  */

#define EXTRACT_STRUCT_VALUE_ADDRESS(REGBUF) (*(int *)(REGBUF))

/* FRAME_CHAIN takes a frame's nominal address and produces the frame's
   chain-pointer.
   In the case of the i386, the frame's nominal address
   is the address of a 4-byte word containing the calling frame's address.  */

#define FRAME_CHAIN(thisframe)  \
  ((thisframe)->signal_handler_caller \
   ? (thisframe)->frame \
   : (!inside_entry_file ((thisframe)->pc) \
      ? read_memory_integer ((thisframe)->frame, 4) \
      : 0))


/* A macro that tells us whether the function invocation represented
   by FI does not have a frame on the stack associated with it.  If it
   does not, FRAMELESS is set to 1, else 0.  */


#define FRAMELESS_FUNCTION_INVOCATION(FI, FRAMELESS) \
  do { \
    if ((FI)->signal_handler_caller) \
      (FRAMELESS) = 0; \
    else \
      (FRAMELESS) = frameless_look_for_prologue(FI); \
  } while (0)


/* The following redefines make backtracing through sigtramp work.
   They manufacture a fake sigtramp frame and obtain the saved pc in sigtramp
   from the ucontext structure which is pushed by the kernel on the
   user stack. Unfortunately there are three variants of sigtramp handlers.  */


#define IN_SIGTRAMP(pc, name) ((name)                                   \
                               && (STREQ ("_sigreturn", name)           \
                                   || STREQ ("_sigacthandler", name)    \
                                   || STREQ ("sigvechandler", name)))

/* Saved Pc.  Get it from sigcontext if within sigtramp.  */

#define FRAME_SAVED_PC(FRAME) \
  (((FRAME)->signal_handler_caller \
    ? i386dgux_sigtramp_saved_pc (FRAME) \
    : read_memory_integer ((FRAME)->frame + 4, 4)) \
   )


struct frame_info;
struct frame_saved_regs;

extern CORE_ADDR
i386dgux_sigtramp_saved_pc PARAMS ((struct frame_info *));

#define sigtramp_saved_pc i386dgux_sigtramp_saved_pc


#define FRAME_ARGS_ADDRESS(fi) ((fi)->frame)

#define FRAME_LOCALS_ADDRESS(fi) ((fi)->frame)

/* Return number of args passed to a frame.  Can return -1, meaning no way
   to tell, which is typical now that the C compiler delays popping them.  */

#define FRAME_NUM_ARGS(numargs, fi) (numargs) = i386_frame_num_args(fi)

extern int
i386_frame_num_args PARAMS ((struct frame_info *));

/* Return number of bytes at start of arglist that are not really args.  */

#define FRAME_ARGS_SKIP 8

/* Put here the code to store, into a struct frame_saved_regs,
   the addresses of the saved registers of frame described by FRAME_INFO.
   This includes special registers such as pc and fp saved in special
   ways in the stack frame.  sp is even more special:
   the address we return for it IS the sp for the next frame.  */


#define FRAME_FIND_SAVED_REGS(frame_info, frame_saved_regs) \
{ i386_frame_find_saved_regs ((frame_info), &(frame_saved_regs)); }


extern void
i386_frame_find_saved_regs PARAMS ((struct frame_info *,
				    struct frame_saved_regs *));


/* Things needed for making the inferior call functions.  */

/* Push an empty stack frame, to record the current PC, etc.  */

#define PUSH_DUMMY_FRAME { i386_push_dummy_frame (); }

extern void
i386_push_dummy_frame PARAMS ((void));

/* Discard from the stack the innermost frame, restoring all registers.  */

#define POP_FRAME  { i386_pop_frame (); }

extern void
i386_pop_frame PARAMS ((void));

/* this is 
 *   call 11223344 (32 bit relative)
 *   int3
 */

#define CALL_DUMMY { 0x223344e8, 0xcc11 }

#define CALL_DUMMY_LENGTH 8

#define CALL_DUMMY_START_OFFSET 0  /* Start execution at beginning of dummy */

#define CALL_DUMMY_BREAKPOINT_OFFSET 5

/* Insert the specified number of args and function address
   into a call sequence of the above form stored at DUMMYNAME.  */

#define FIX_CALL_DUMMY(dummyname, pc, fun, nargs, args, type, gcc_p)   \
{ \
	int from, to, delta, loc; \
	loc = (int)(read_register (SP_REGNUM) - CALL_DUMMY_LENGTH); \
	from = loc + 5; \
	to = (int)(fun); \
	delta = to - from; \
	*((char *)(dummyname) + 1) = (delta & 0xff); \
	*((char *)(dummyname) + 2) = ((delta >> 8) & 0xff); \
	*((char *)(dummyname) + 3) = ((delta >> 16) & 0xff); \
	*((char *)(dummyname) + 4) = ((delta >> 24) & 0xff); \
}

extern void
print_387_control_word PARAMS ((unsigned int));

extern void
print_387_status_word PARAMS ((unsigned int));

/* Offset from SP to first arg on stack at first instruction of a function */

#define SP_ARG0 (1 * 4)

#endif	/* !defined (TM_I386DGUX_H) */
