/* $TOG: Xcupstr.h /main/3 1998/02/09 11:21:34 kaleb $ */

/*

Copyright 1987, 1988, 1998  The Open Group

All Rights Reserved.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of The Open Group shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from The Open Group.

*/

#ifndef _XCUPSTR_H_ /* { */
#define _XCUPSTR_H_

#include "Xcup.h"

#define XCUPNAME "TOG-CUP"

#define XCUP_MAJOR_VERSION	1	/* current version numbers */
#define XCUP_MINOR_VERSION	0

typedef struct _XcupQueryVersion {
    CARD8	reqType;	/* always XcupReqCode */
    CARD8	xcupReqType;	/* always X_XcupQueryVersion */
    CARD16	length B16;
    CARD16	client_major_version B16;
    CARD16	client_minor_version B16;
} xXcupQueryVersionReq;
#define sz_xXcupQueryVersionReq		8

typedef struct {
    BYTE	type;		/* X_Reply */
    BOOL	pad1;
    CARD16	sequence_number B16;
    CARD32	length B32;
    CARD16	server_major_version B16;
    CARD16	server_minor_version B16;
    CARD32	pad2 B32;
    CARD32	pad3 B32;
    CARD32	pad4 B32;
    CARD32	pad5 B32;
    CARD32	pad6 B32;
} xXcupQueryVersionReply;
#define sz_xXcupQueryVersionReply	32

typedef struct _XcupGetReservedColormapEntries {
    CARD8	reqType;	/* always XcupReqCode */
    CARD8	xcupReqType;	/* always X_XcupGetReservedColormapEntries */
    CARD16	length B16;
    CARD32	screen B32;
} xXcupGetReservedColormapEntriesReq;
#define sz_xXcupGetReservedColormapEntriesReq 8

typedef struct {
    BYTE	type;		/* X_Reply */
    BOOL	pad1;
    CARD16	sequence_number B16;
    CARD32	length B32;
    CARD32	pad2 B32;
    CARD32	pad3 B32;
    CARD32	pad4 B32;
    CARD32	pad5 B32;
    CARD32	pad6 B32;
    CARD32	pad7 B32;
} xXcupGetReservedColormapEntriesReply;
#define sz_xXcupGetReservedColormapEntriesReply		32

typedef struct _XcupStoreColors {
    CARD8	reqType;	/* always XcupReqCode */
    CARD8	xcupReqType;	/* always X_XcupStoreColors */
    CARD16	length B16;
    CARD32	cmap B32;
} xXcupStoreColorsReq;
#define sz_xXcupStoreColorsReq		8

typedef struct {
    BYTE	type;		/* X_Reply */
    BOOL	pad1;
    CARD16	sequence_number B16;
    CARD32	length B32;
    CARD32	pad2 B32;
    CARD32	pad3 B32;
    CARD32	pad4 B32;
    CARD32	pad5 B32;
    CARD32	pad6 B32;
    CARD32	pad7 B32;
} xXcupStoreColorsReply;
#define sz_xXcupStoreColorsReply	32

#endif /* } _XCUPSTR_H_ */

