;; SKK tutorial (version 3.4 for SKK version 5.29, and later versions.)
;; Copyright (C) 1988, 1992 Masahiko Sato (masahiko@sato.riec.tohoku.ac.jp)

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;; version 3.4 released 1992.4.12
;; version 3.3 released 1991.4.20
;; version 3.2 released 1990.4.15
;; version 2.2 released 1989.4.15

;; Introduced by W. Matsui (matsui@atr-rd.atr.co.jp), 1991.8.14.
(defvar skk-tut-directory exec-directory)

(setq j-mode-line-skk nil)
(setq skk-problem-nos 37)

(defun skk-tutorial ()
  (interactive)
  (let ((inhibit-quit t))
    (setq skk-features-save features) ;; save features and restore it later
    (if (featurep 'skk) (setq skk-server-host-save skk-server-host
			      skk-mode-save skk-mode))
    (load "skk")
    (setq skk-problem-count 0
	  skk-tutorial-end nil
	  skk-jisyo-save nil)
    (setq skk-server-host nil)
    (if (not (fboundp 'j-save-other-window))
	(fset 'j-save-other-window (symbol-function 'other-window)))
    (fset 'other-window 'j-other-window)
    (if (get-buffer " *skk-jisyo*")
	(save-excursion
	  (setq skk-jisyo-save t)
	  (set-buffer " *skk-jisyo*")
	  (copy-to-buffer " *save-skk-jisyo*" (point-min) (point-max))
	  (erase-buffer)
	  (set-buffer " *skk-okuri-jisyo*")
	  (copy-to-buffer " *save-skk-okuri-jisyo*" (point-min) (point-max))
	  (erase-buffer)
	  ))
    (set-buffer (get-buffer-create " *skk-tutorial*"))
    (erase-buffer)
    ;; Modified by W. Matsui, 1991.8.14.
    (insert-file-contents
     (concat (expand-file-name skk-tut-directory) "SKK.tut"))
    (goto-char (point-min))
    (switch-to-buffer (get-buffer-create "**"))
    (erase-buffer)
    (setq skk-tutorial-map (make-keymap))
    (fillarray skk-tutorial-map 'skk-error)
    (use-local-map skk-tutorial-map)
    (erase-buffer)
    (skk-get-new-page)
    (delete-other-windows)
    (split-window-vertically nil)
    (other-window 1)
    (enlarge-window (- (window-height (selected-window)) 20))
    (switch-to-buffer (get-buffer-create "**"))
    (local-set-key "\C-xn" 'skk-next-window)
    (local-set-key "\C-xq" 'skk-quit-tutorial)
    (local-set-key "\C-xs" 'skk-skip-problem)
    (local-set-key "\C-x\C-j" 'j-skk-mode)
    (local-set-key "\C-h" 'skk-nil) ;; disable help
    (switch-to-buffer-other-window "**")
    (goto-char (point-max))
    (beginning-of-line)
    (skk-answer-window)
    (message "")))

(defun j-save-skk-variables ()
  (setq skk-server-host-save skk-server-host
	iskk-mode-save skk-mode))

(defun j-skk-mode ()
  (interactive)
  (or (featurep 'skk) (provide 'skk))
  (if skk-mode
      (progn
	(j-change-mode-line "--")
	(setq j-mode t)
	(use-local-map skk-map))
    (or j-mode-line-skk
	(setq mode-line-format
	      (cons "" (cons 'j-mode-line-skk
			     (cdr (default-value 'mode-line-format))))))
    (j-change-mode-line "--")
    (setq skk-mode t
	  j-mode t
	  j-katakana nil)
    (local-set-key "\C-j" 'j-kakutei)
    (setq j-emacs-local-map
	  (j-convert-to-vector (copy-keymap (current-local-map))))
    (define-key minibuffer-local-map "\C-j" 'skk-mode)
    (define-key minibuffer-local-map "\C-m" 'j-newline)
    (j-setup-skk-map)
    (j-setup-skk-zenkaku-map)
    (j-setup-skk-abbrev-map)
    (use-local-map skk-map)
    (if (= skk-problem-count 2) (skk-disable))))

(defun skk-error ()
  (interactive)
  (switch-to-buffer-other-window "**"))

(defun skk-nil ()
  (interactive)
  (error ""))

(defun skk-get-new-page ()
  (save-excursion
    (set-buffer " *skk-tutorial*")
    (goto-char (point-min))
    (search-forward "--\n")
    (delete-region (point-min) (point))
    (if (looking-at ";")
	(let (p)
	  (forward-char 3)
	  (setq p (point))
	  (end-of-line)
	  (save-excursion (eval-region p (point) nil))
	  (forward-char 1)))
    (or skk-tutorial-end
	(let ((p (point)))
	  (search-forward "\n>>")
	  (end-of-line)
	  (copy-to-buffer "**" p (point)))))
  (setq skk-problem-count (1+ skk-problem-count))
  (setq mode-line-buffer-identification
	(concat "ӣˣ˥塼ȥꥢ:  "
		(int-to-string skk-problem-count)
		" ʻĤ "
		(int-to-string (- skk-problem-nos skk-problem-count))
		""))
  (set-buffer-modified-p t)
  (sit-for 0))

(defun skk-quit-tutorial (&optional now)
  (interactive)
  (if (or now (yes-or-no-p "˥塼ȥꥢޤ? "))
      (let ((inhibit-quit t))
	(delete-other-windows)
	(kill-buffer " *skk-tutorial*")
	(kill-buffer "**")
	(kill-buffer "**")
	(if (fboundp 'j-save-set-henkan-point)
	    (fset
	     'j-set-henkan-point (symbol-function 'j-save-set-henkan-point)))
	(if (fboundp 'j-save-abbrev-input)
	    (fset 'j-abbrev-input (symbol-function 'j-save-abbrev-input)))
	(if (fboundp 'j-save-other-window)
	    (fset 'other-window (symbol-function 'j-save-other-window)))
	(fmakunbound 'j-save-set-henkan-point)
	(fmakunbound 'j-save-abbrev-input)
	(fmakunbound 'j-save-other-window)
	(if (boundp 'skk-server-host-save)
	    (setq skk-server-host skk-server-host-save
		  skk-mode skk-mode-save))
	(setq features skk-features-save)
	(if skk-jisyo-save
	    (progn
	      (set-buffer " *save-skk-jisyo*")
	      ;; call skk-mode in this buffer to restore the initial setup
	      (let ((j-skk-mode-invoked nil))
		(skk-mode t))
	      (copy-to-buffer " *skk-jisyo*" (point-min) (point-max))
	      (kill-buffer " *save-skk-jisyo*")
	      (set-buffer " *save-skk-okuri-jisyo*")
	      (copy-to-buffer " *skk-okuri-jisyo*" (point-min) (point-max))
	      (kill-buffer " *save-skk-okuri-jisyo*")
	      )))))

(defun skk-answer-window ()
  (interactive)
  ;(switch-to-buffer "**")
  (goto-char (point-max))
  (search-backward "\n>>")
  (forward-char 1)
  (let ((p (point)))
    (setq skk-ans
	  (buffer-substring (+ 3 (point)) (progn (end-of-line) (point))))
    (goto-char p))
  (switch-to-buffer-other-window "**")
  ;(goto-char (point-min))
  (skk-insert-answer-form))

(defun skk-next-window ()
  (interactive)
  (let (user-ans)
    (goto-char (point-min))
    (end-of-line)         
    (skip-chars-backward " \t")
    (setq user-ans (buffer-substring (+ 3 (point-min)) (point)))
    (if (string= skk-ans user-ans)
	(progn
	  (message "")
	  (erase-buffer)
	  (other-window 1)
	  (skk-get-new-page)
	  (if skk-tutorial-end (skk-quit-tutorial t) (skk-answer-window)))
      (message "㤤ޤ⤦٤äƤߤƲ")
      (ding)
      (save-excursion
	(set-buffer " *skk-tutorial*")
	(goto-char (point-min))
	(if (looking-at ";")
	    (let (p)
	      (end-of-line)
	      (setq p (point))
	      (eval-last-sexp t)
	      (delete-region p (point)))))
      (erase-buffer)
      (skk-insert-answer-form)
      (goto-char (+ 3 (point-min)))
      (insert user-ans))))

(defun skk-skip-problem ()
  (interactive)
  (erase-buffer)
  (if (= skk-problem-count 2) (j-skk-mode))
  (other-window 1)
  (skk-get-new-page)
  (if skk-tutorial-end (skk-quit-tutorial t) (skk-answer-window)))

(defun skk-insert-answer-form ()
  (insert ">> \n\n"
	  "* ǤC-x n; ǤˤϡC-x q; "
	  "åפˤϡC-x s *")
  (goto-char (+ (point-min) 3)))

(defun skk-disable ()
  (if (not (fboundp 'j-save-set-henkan-point))
      (progn
	(fset 'j-save-set-henkan-point (symbol-function 'j-set-henkan-point))
	(fset 'j-set-henkan-point (symbol-function 'j-set-henkan-point-tmp))))
  (if (not (fboundp 'j-save-abbrev-input))
      (progn
	(fset 'j-save-abbrev-input (symbol-function 'j-abbrev-input))
	(fset 'j-abbrev-input (symbol-function 'j-abbrev-input-tmp))))
  (skk-use-jisyo ""))

(defun j-set-henkan-point-tmp ()
  (interactive)
  (if j-mode 
      (error "/ʥ⡼ɤǤϡʸϤޤȤޤ")
    (insert (if j-zenkaku (concat (char-to-string 163)
				  (char-to-string (+ last-command-char 128)))
	      last-command-char))))

(defun j-abbrev-input-tmp ()
  (interactive)
  (if j-mode
      (error "ΥϤޤȤޤ")
    (insert last-command-char)))

;; functions below are called from the tutorial text

(defun skk-enable ()
  (fset 'j-set-henkan-point (symbol-function 'j-save-set-henkan-point))
  (fset 'j-abbrev-input (symbol-function 'j-save-abbrev-input))
  ;; save jisyo buffer, and modify jisyo buffer for this tutorial
  (skk-use-jisyo " ///ƻ/\n"))

;; The following two functions are tricky, since they are executed by
;; "eval-region".

(defun skk-test-name ()
  (let ((p (point-min)) (q (point-max)))
    (widen)
    (search-forward "\n>> ")
    (insert "My name is " (user-full-name) ".")
    (narrow-to-region p q)
    (goto-char q)))

(defun skk-test-today ()
  (let ((p (point-min)) (q (point-max)))
    (widen)
    (search-forward "\n>> ")
    (insert "֤礦ϡ" (j-date) "Ǥ")
    (narrow-to-region p q)
    (goto-char q)))

(defun skk-use-jisyo (str)
  (save-excursion
    (set-buffer (get-buffer-create " *skk-jisyo*"))
    (erase-buffer)
    (insert ";; okuri-nasi entries.\n" str)))

(defun skk-use-okuri-jisyo (str)
  (save-excursion
    (set-buffer (get-buffer-create " *skk-okuri-jisyo*"))
    (erase-buffer)
    (insert ";; okuri-ari entries.\n" str)))

(defun skk-end-of-tutorial ()
  (message "")
  (switch-to-buffer " **")
  (erase-buffer)
  (goto-char (point-min))
  (insert "SKK 塼ȥꥢϤǽǤ\n\n")
  (sit-for 1)
  (insert "SKK ˴ؤ䡢ȡbug report \n\n")
  (sit-for 1)
  (insert "\tskk@sato.riec.tohoku.ac.jp\n\n")
  (sit-for 3)
  (insert "겼\n\n")
  (sit-for 2)
  (let ((count 5) p)
    (while (> count 0)
      (beginning-of-line)
      (setq p (point))
      (end-of-line)
      (delete-region p (point))
      (insert "ʤβ̤ " (int-to-string count)
	      " ø˼ưŪ˾Ǥޤ")
      (sit-for 1)
      (setq count (1- count))))
  (setq skk-tutorial-end t))

(if (not (fboundp 'j-save-other-window))
    (fset 'j-save-other-window (symbol-function 'other-window)))

(defun j-other-window (arg)
  (interactive "p")
  (if (interactive-p)
      (error "Can't switch window now.")
    (j-save-other-window arg)))
