/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2002, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/button.c,v 4.10 2002/01/05 02:47:59 william Exp $
 */

#define _INCLUDE_FROM_BUTTON_C_

#include "tgifdefs.h"

#include "auxtext.e"
#include "box.e"
#include "button.e"
#include "cursor.e"
#include "file.e"
#include "font.e"
#include "mainloop.e"
#include "mainmenu.e"
#include "menu.e"
#include "msg.e"
#include "raster.e"
#include "rect.e"
#include "setup.e"

int ButtonWidth(Str, MinLen)
   char *Str;
   int MinLen;
{
   int len=strlen(Str);

   if (boldMsgFontSet == NULL && boldMsgFontPtr == NULL) {
      return (defaultFontWidth * max(len+2, MinLen));
   } else if (len > MinLen-2) {
      char buf[40];
      int len1=0, len2=0;

      /* do not translate -- the string is used to measure things */
      sprintf(buf, "  %s  ", Str);
      len1 = 4+BoldMsgTextWidth(boldMsgFontPtr, buf, len+4);
      len2 = 4+BoldMsgTextWidth(boldMsgFontPtr, "  CANCEL  ", 10);

      return max(len1,len2);
   } else {
      /* do not translate -- the string is used to measure things */
      return 4+BoldMsgTextWidth(boldMsgFontPtr, "  CANCEL  ", 10);
   }
}

#define BTN_Y_MARGIN 2

void DisplayButtonInBBox(Win, Str, Len, BBox, Normal, HighLight, Width)
   Window Win;
   char *Str;
   int Len, HighLight, Width;
   struct BBRec *BBox;
   int Normal;
   /* Display a button in Win at location ((*BBox).ltx,(*BBox).lty), Str is */
   /*    centered in the button.  The width of the button is given in BBox. */
   /* Len must be strlen(Str) */
   /* If HighLight is TRUE, Width is used to draw an outline around the box. */
{
   int button_w, button_h, left, top, text_w;
   int bg_pixel=(threeDLook ? myLtGryPixel : myBgPixel);

   button_w = BBox->rbx - BBox->ltx;
   button_h = BBox->rby - BBox->lty;
   if (boldMsgFontSet == NULL && boldMsgFontPtr == NULL) {
      text_w = defaultFontWidth * Len;
      left = ((button_w - text_w)>>1);
      top = ((button_h - defaultFontHeight)>>1);
   } else {
      text_w = BoldMsgTextWidth(boldMsgFontPtr, Str, Len);
      left = ((button_w - text_w)>>1);
      top = ((button_h - boldMsgFontHeight)>>1);
   }
   XSetForeground(mainDisplay, defaultGC, (Normal ? bg_pixel : myFgPixel));
   XFillRectangle(mainDisplay, Win, defaultGC, BBox->ltx, BBox->lty,
         button_w, button_h);
   XSetForeground(mainDisplay, defaultGC, myFgPixel);
   if (threeDLook) {
      struct BBRec bbox;

      SetBBRec(&bbox, BBox->ltx, BBox->lty-windowPadding, BBox->ltx+button_w,
            BBox->lty+button_h+windowPadding);
      TgDrawThreeDButton(mainDisplay, Win, textMenuGC, &bbox,
            (Normal ? TGBS_RAISED : TGBS_LOWRED), 2, Normal);
   } else {
      XDrawRectangle(mainDisplay, Win, defaultGC, BBox->ltx, BBox->lty,
            button_w, button_h);
   }
   if (!Normal) {
      XSetForeground(mainDisplay, defaultGC, myBgPixel);
   }
   if (boldMsgFontSet == NULL && boldMsgFontPtr == NULL) {
      DrawBoldMsgString(mainDisplay, Win, defaultGC, BBox->ltx+left,
            BBox->lty+defaultFontAsc+BTN_Y_MARGIN, Str, Len);
   } else {
      if (boldMsgFontPtr != NULL) {
         XSetFont(mainDisplay, defaultGC, boldMsgFontPtr->fid);
      }
      DrawBoldMsgString(mainDisplay, Win, defaultGC, BBox->ltx+left,
            BBox->lty+boldMsgFontAsc+BTN_Y_MARGIN, Str, Len);
      XSetFont(mainDisplay, defaultGC, defaultFontPtr->fid);
   }
   if (!Normal) {
      XSetForeground(mainDisplay, defaultGC, myFgPixel);
   }
   if (HighLight) {
      if (threeDLook) {
         XSetForeground(mainDisplay, defaultGC, myBorderPixel);
         XDrawRectangle(mainDisplay, Win, defaultGC, BBox->ltx-1,
               BBox->lty-windowPadding-1, button_w+1,
               button_h+(windowPadding<<1)+1);
         XSetForeground(mainDisplay, defaultGC, myFgPixel);
      } else {
         XDrawRectangle(mainDisplay, Win, defaultGC, BBox->ltx-Width,
               BBox->lty-Width, button_w+(Width<<1), button_h+(Width<<1));
      }
   }
}
