/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2003, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/color.e,v 4.16 2003/02/25 01:17:39 william Exp $
 */

#ifndef _COLOR_E_
#define _COLOR_E_

extern int	maxColors;
extern int	defaultColorIndex;
extern int	colorIndex;
extern char	myFgColorStr[];
extern char	myBgColorStr[];
extern char	myRubberBandColorStr[];
extern char	* * colorMenuItems;
extern int	* colorPixels;
extern int	* xorColorPixels;
extern int	* colorLayerOn;
extern XColor	* tgifColors;
extern XColor	* tgifRequestedColors;
extern XColor	myBgColor;
extern int	maxRGB;
extern int	colorDump;
extern int	useLocalRGBTxt;
extern int	printUsingRequestedColor;
extern int	colorLayers;
extern int	needToRedrawColorWindow;
extern int	initColorDontReload;
extern int	gnUpdatePixelObjCount;

extern char	defaultBgColorStr[];
extern int	defaultBgColorIndex;

extern char	altEditTextBgColorStr[];
extern int	altEditTextBgIndex;
extern char	altEditTextHighlightColorStr[];
extern int	altEditTextHighlightIndex;
extern int	useAltEditTextBgColor;

#ifdef _INCLUDE_FROM_COLOR_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_COLOR_C_*/

extern void	DefaultColorArrays ARGS_DECL((int Entries, int **ForePixels,
		                              int **Valid, int **InitRV,
		                              char ***StatusStr));
extern int	GetDrawingBgPixel ARGS_DECL((int index, int pixel));
extern int	GetDrawingFgPixel ARGS_DECL((int index, int pixel));
extern void	GetDrawingFgColorStr ARGS_DECL((int index, int pixel,
		                                char *color_buf, int buf_sz));
extern int	TgifParseColor ARGS_DECL((char*, XColor*));
extern void	RecalcXorPixels ARGS_DECL((void));
extern void	InitColor ARGS_DECL((void));
extern void	RedrawColorWindow ARGS_DECL((void));
extern int	OneColorObject ARGS_DECL((struct ObjRec *, int *ColorIndex));
extern int	ChangeObjColor ARGS_DECL((struct ObjRec *, int ColorIndex));
extern void	ChangeAllSelColor ARGS_DECL((int ColorIndex, int HighLight));
extern void	RefreshColorMenu ARGS_DECL((TgMenu*));
extern void	SetUpColorMenuPixmap ARGS_DECL((int **ForeColors,
		                                int **InitRV, Pixmap **,
		                                int *Rows, int *Cols));
extern TgMenu	*CreateColorMenu ARGS_DECL((TgMenu*, int X, int Y,
		                            TgMenuInfo*,
		                            int status_str_xlated));
extern int	ColorMenu ARGS_DECL((int X, int Y, int TrackMenubar));
extern void	CleanUpColors ARGS_DECL((void));
extern void	ColorEventHandler ARGS_DECL((XEvent*));
extern void	RedrawColorDummyWindow ARGS_DECL((void));
extern void	ColorDummyEventHandler ARGS_DECL((XEvent*));
extern int	UpdatePixel ARGS_DECL((struct ObjRec *, char **));
extern void 	UpdateXPmObjects ARGS_DECL((struct ObjRec *));
extern int	FlushColormap ARGS_DECL((void));
extern void	AddColor ARGS_DECL((void));
extern void	SetAltEditTextBgColor ARGS_DECL((void));
extern void	SetAltEditTextHighlightColor ARGS_DECL((void));
extern void	ToggleAltEditTextBgColor ARGS_DECL((void));
extern void	SaveColors ARGS_DECL((FILE*));
extern int	ReadColors ARGS_DECL((FILE*, char*));
extern void	DumpRGBColorLine ARGS_DECL((FILE *FP, int ColorIndex,
		                            int Indent, int EndOfLine));

#ifdef _INCLUDE_FROM_COLOR_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_COLOR_C_*/

#endif /*_COLOR_E_*/
