/***************************************************************************
                             rmchat.c
                             -------------------
    begin                : February 2002
    copyright            : (C) 2002 by Jorge Allyson Azevedo
                                       Milena Scanferla
                                       Daniel Sadoc
    email                : {allyson,milena,sadoc}@land.ufrj.br

    This program is a simple chat application that uses the Rmcast Library.

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <string.h>

#include "rmcast.h" /* Rmcast Library header */

#define BUFFSIZE 500 /* Max buffer size for messages  */

#define TRUE 1
#define FALSE 0

/* Global Variables */
int chatSock;

/***************************************************************************
*   ReceivePacket                                                          *
*                                                                          *
*   Function to receive data from the network                              *
*                                                                          *
****************************************************************************/
void *ReceivePacket( void *arg ){
    
    char receive_buffer[BUFFSIZE];

    int bytes_read;

    while( TRUE ){

            if( (bytes_read = RM_recv(chatSock,receive_buffer , BUFFSIZE)) > 0 ){
                 
                 /* We have received data from the network, show it to the user */
                 fprintf(stdout,"\n%s>",receive_buffer);
                 fflush(stdout);
            }
            else{
                 
                 fprintf(stderr,"[ReceivePacket Error]: receiving data.\n"); 
            }
            
    }   

    return 0; 
      

}


int main(void){

    pthread_t tid=0; /* Thread Id */
    
    int port=0;
    
    char buffer[BUFFSIZE],aux[16],user_name[20],msg_buff[BUFFSIZE-20];

/*
 *     Read the configuration file first.
 *     If the configuration file doesn't exist we will use default options
 */
    RM_readConfigFile("rmcast.config");
    
    /* Initialize the Rmcast Library functions */
    RM_initialize();
    
/*
 *     Join the Multicast Group.
 *     If you want to set a "hardcoded" Multicast group IP and port replace the
 *     RM_USE_CURRENT_CONFIG constants, otherwise we will use the IP and Port
 *     from the configuration file or from the default option
 */

    chatSock = RM_joinGroup( (char*)RM_USE_CURRENT_CONFIG, RM_USE_CURRENT_CONFIG);

    fprintf(stdout,"\nEnter a user name (max 16 chars):\n");
    scanf("%s",user_name);
    aux[0]='\0';
    strcat(aux,"[");
    strcat(aux,user_name);
    strcat(aux,"]>");

    fprintf(stdout,"\n*************\nHello %s!\n",user_name);
    fprintf(stdout,"Now you can send messages to the Multicast Group!");
    fprintf(stdout,"\nType \"exit\" to quit the program\n*************\n>");
    
    /* Now we will create a thread to receive data from the network */
    if( pthread_create( &tid, NULL, ReceivePacket, NULL ) != 0 ){

          /* Error, terminate the application */
          fprintf( stderr, "[rmchat Error]: Could not create Receive Thread\n" );
          exit( -1 );
    }
     
    while( TRUE ){

        buffer[0]='\0';

        /* Now we will read the messages from the standard input */
        fgets(msg_buff,BUFFSIZE-21,stdin);
        
        if (strcmp(msg_buff,"exit\n")==0){
            
            /* The user wants to terminate the application */
            fprintf(stdout,"\n*************\n");
            fprintf(stdout,"Exiting rmchat ...\n");
            break;
        }
        else{
            if (strcmp(msg_buff,"send\n")==0){
                
                /* Send command: will send packets with a number to the group,
                   just for tests purposes */
                int j,num=0;
                char aux2[10];
                
                /* Ask the user how many packets we are supposed to send */
                fprintf(stdout,"Enter the number of packets to send:");
                scanf("%d",&num);
                
                for(j=0;j<num;j++){
                
                   /*Fill the message with a number */
                   buffer[0]='\0';
                   strcat(buffer,aux);
                   sprintf(aux2,"%d\n",j);
                   strcat(buffer,aux2);

                   /* Send the message to the Multicast Group */
                   RM_sendto(chatSock,buffer,BUFFSIZE);
                   
                   fprintf(stdout,"\n%s>",buffer); 
                }
            }
                
            else{

                strcat(buffer,aux);
                strcat(buffer,msg_buff);

                /* Send the message to the Multicast Group */
                RM_sendto(chatSock,buffer,BUFFSIZE);

                fprintf(stdout,"\n%s>",buffer); 
            }
        }
    }
    
    /* Getting Multicast Group IP and Port from the Rmcast Library */
    RM_getOption(DEST_IP, (void *)aux);
    RM_getOption(DEST_PORT, (void *)&port);

    /* Kill the Receive thread */
    pthread_kill(tid,9);
    
    /* Leave the Multicast Group */
    fprintf(stdout,"Leaving Multicast Group %s:%d ",aux,port);
    RM_leaveGroup( chatSock, (char*)RM_USE_CURRENT_CONFIG );

    fprintf(stdout,"OK.\nrmchat terminated.\n*************\n");

    return 0;
}
