/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2003, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/tdgtdraw.e,v 4.7 2003/08/03 17:35:45 william Exp $
 */

#ifndef _TDGTDRAW_E_
#define _TDGTDRAW_E_

#include "tidget.h"

#define TDGTDRAW_DEF_H_PAD 2
#define TDGTDRAW_DEF_V_PAD 2

struct tagTdgtDraw;

typedef int (TdgtDrawRedrawCallbackFunc)ARGS_DECL((struct tagTdgtDraw *));
typedef int (TdgtDrawEvHandlerCallbackFunc)ARGS_DECL((struct tagTdgtDraw *,
		XEvent*));
typedef int (TdgtDrawResetCallbackFunc)ARGS_DECL((struct tagTdgtDraw *));
typedef int (TdgtDrawSendCmdCallbackFunc)ARGS_DECL((struct tagTdgtDraw *,
		int cmd_type, int cmd_arg, void *pv_cmd_userdata));

/*
 * A drawing area tidget uses callback routings to handl redraws
 *         and mouse events.
 */
typedef struct tagTdgtDraw {
   TidgetInfo *pti;

   SimpleWinInfo client_area;

   void *pv_userdata;

   /* callback functions */
   TdgtDrawRedrawCallbackFunc *pf_redraw_callback;
   TdgtDrawEvHandlerCallbackFunc *pf_ev_handler_callback;
   TdgtDrawResetCallbackFunc *pf_reset_callback;
   TdgtDrawSendCmdCallbackFunc *pf_sendcmd_callback;
} TdgtDraw;

#ifdef _INCLUDE_FROM_TDGTDRAW_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_TDGTDRAW_C_*/

extern void	TdgtDrawReset ARGS_DECL((TdgtDraw*));
extern TdgtDraw	*CreateTdgtDraw ARGS_DECL((Window parent_win,
				TidgetInfo *parent_tidgetinfo, int ctl_id,
				int x, int y, int client_w, int client_h,
				int h_pad, int v_pad, int state,
				void *pv_userdata));

extern int	TdgtDrawSetUserData ARGS_DECL((TdgtDraw*, void *pv_userdata));
extern char	*TdgtDrawGetUserData ARGS_DECL((TdgtDraw*));
extern int	TdgtDrawSetState ARGS_DECL((TdgtDraw*, int));
extern int	TdgtDrawGetState ARGS_DECL((TdgtDraw*));

extern void	TdgtDrawSetRedrawCallback ARGS_DECL((TdgtDraw*,
				TdgtDrawRedrawCallbackFunc*));
extern void	TdgtDrawSetEvHandlerCallback ARGS_DECL((TdgtDraw*,
				TdgtDrawEvHandlerCallbackFunc*));
extern void	TdgtDrawSetResetCallback ARGS_DECL((TdgtDraw*,
				TdgtDrawResetCallbackFunc*));
extern void	TdgtDrawSetSendCmdCallback ARGS_DECL((TdgtDraw*,
				TdgtDrawSendCmdCallbackFunc*));

extern int	InitTdgtDraw ARGS_DECL((void));
extern void	CleanUpTdgtDraw ARGS_DECL((void));

#ifdef _INCLUDE_FROM_TDGTDRAW_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_TDGTDRAW_C_*/

#endif /*_TDGTDRAW_E_*/
