/*
 * Copyright (c) 1999
 *      Computer Systems and Communication Lab,
 *      Institute of Information Science, Academia Sinica.
 *      All rights reserved.
 * Copyright (c) 1999 Pai-Hsiang Hsiao. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the
 *      Computer Systems and Communication Lab,
 *      Insitute of Information Science, Academia Sinica
 *      and its contributors.
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <gtk/gtk.h>

#include <tabe.h>

#include "bims.h"

int
key_input(widget, event)
GtkWidget *widget;
GdkEventKey *event;
{
  return(bimsGTKEntryFeedKey(widget, event));
}

int
main(int argc, char *argv[])
{
  int rval;

  GtkWidget *window;
  GtkWidget *entry;

  gdk_set_locale();
  gtk_init (&argc, &argv);
  gtk_rc_parse("bims.rc");

  rval = bimsInit("tsi.db", "yin.db");
  if (rval < 0) {
    fprintf(stderr, "can not open appropriate database.\n");
    exit(0);
  }

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  gtk_window_set_title(GTK_WINDOW (window), "bims");

  entry = gtk_entry_new();
  gtk_signal_connect_after(GTK_OBJECT(entry), "key_press_event",
			   GTK_SIGNAL_FUNC(key_input), NULL);

  gtk_container_add(GTK_CONTAINER(window), entry);

  gtk_widget_show(entry);
  gtk_widget_show(window);

  gtk_main();

  bimsDestroy();

  return(0);
}
