/*
 * Copyright 1999, TaBE Project, All Rights Reserved.
 * Copyright 1999, Pai-Hsiang Hsiao, All Rights Reserved.
 *
 * $Id: tsidel.c,v 1.3 1999/05/10 02:46:35 shawn Exp $
 *
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include <tabe.h>

#include <db.h>

void
usage()
{
  printf("Usage: tsidel -d <TsiDB> [-f input file]\n");
  exit(0);
}

void
del(db, fp)
struct TsiDB *db;
FILE *fp;
{
  struct TsiInfo *tsi;
  int rval, i, j;
  char buf[1000];
  DBT key;

  rval = db->RecordNumber(db);
  if (rval < 0) {
    fprintf(stderr, "tsidel: wrong DB format.\n");
    usage();
  }

  tsi = (struct TsiInfo *)malloc(sizeof(struct TsiInfo));
  tsi->tsi = (ZhiStr)malloc(sizeof(unsigned char)*80);
  memset(tsi->tsi, 0, 80);
  tsi->refcount = -1;
  tsi->yinnum = -1;

  i = j = 0;
  while (1) {
    if (!fgets(buf, 1000, fp)) {
      break;
    }
    sscanf(buf, "%80s", tsi->tsi);
    i++;
    rval = db->Get(db, tsi);
    if (!rval) {
      memset(&key, 0, sizeof(DBT));
      key.data = tsi->tsi;
      key.size = strlen(tsi->tsi);
      rval = ((DB *)(db->dbp))->del((DB *)db->dbp, NULL, &key, 0);
      j++;
    }
    else {
      /* donothing */
    }
  }

  printf("There're %d queries, %d deleted.\n", i, j);
  db->Close(db);
}

int
main(argc, argv)
int argc;
char **argv;
{
  char ch;
  FILE *fp;
  struct TsiDB *db;

  char *db_name, *op_name;

  db_name = op_name = (char *)NULL;

  while ((ch = getopt(argc, argv, "d:f:")) != -1) {
    switch(ch) {
      case 'd':
        db_name = strdup(optarg);
        break;
      case 'f':
        op_name = strdup(optarg);
        break;
      default:
        usage();
        break;
    }
  }
  argc -= optind;
  argv += optind;

  if (!db_name) {
    usage();
  }

  db = tabeTsiDBOpen(DB_TYPE_DB, db_name, 0);
  if (!db) {
    usage();
  }

  if (op_name) {
    fp = fopen(op_name, "r");
    del(db, fp);
    fclose(fp);
  }
  else {
    del(db, stdout);
  }

  return(0);
}
