# Generated by default/object.tt
package Paws::Connect::MediaConcurrency;
  use Moose;
  has Channel => (is => 'ro', isa => 'Str', required => 1);
  has Concurrency => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Connect::MediaConcurrency

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Connect::MediaConcurrency object:

  $service_obj->Method(Att1 => { Channel => $value, ..., Concurrency => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Connect::MediaConcurrency object:

  $result = $service_obj->Method(...);
  $result->Att1->Channel

=head1 DESCRIPTION

Contains information about which channels are supported, and how many
contacts an agent can have on a channel simultaneously.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Channel => Str

The channels that agents can handle in the Contact Control Panel (CCP).


=head2 B<REQUIRED> Concurrency => Int

The number of contacts an agent can have on a channel simultaneously.

Valid Range for C<VOICE>: Minimum value of 1. Maximum value of 1.

Valid Range for C<CHAT>: Minimum value of 1. Maximum value of 10.

Valid Range for C<TASK>: Minimum value of 1. Maximum value of 10.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Connect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

