# Generated by default/object.tt
package Paws::LexModelsV2::ExportSummary;
  use Moose;
  has CreationDateTime => (is => 'ro', isa => 'Str', request_name => 'creationDateTime', traits => ['NameInRequest']);
  has ExportId => (is => 'ro', isa => 'Str', request_name => 'exportId', traits => ['NameInRequest']);
  has ExportStatus => (is => 'ro', isa => 'Str', request_name => 'exportStatus', traits => ['NameInRequest']);
  has FileFormat => (is => 'ro', isa => 'Str', request_name => 'fileFormat', traits => ['NameInRequest']);
  has LastUpdatedDateTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedDateTime', traits => ['NameInRequest']);
  has ResourceSpecification => (is => 'ro', isa => 'Paws::LexModelsV2::ExportResourceSpecification', request_name => 'resourceSpecification', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::ExportSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::ExportSummary object:

  $service_obj->Method(Att1 => { CreationDateTime => $value, ..., ResourceSpecification => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::ExportSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationDateTime

=head1 DESCRIPTION

Provides summary information about an export in an export list.

=head1 ATTRIBUTES


=head2 CreationDateTime => Str

The date and time that the export was created.


=head2 ExportId => Str

The unique identifier that Amazon Lex assigned to the export.


=head2 ExportStatus => Str

The status of the export. When the status is C<Completed> the export is
ready to download.


=head2 FileFormat => Str

The file format used in the export files.


=head2 LastUpdatedDateTime => Str

The date and time that the export was last updated.


=head2 ResourceSpecification => L<Paws::LexModelsV2::ExportResourceSpecification>

Information about the bot or bot locale that was exported.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

