#!/usr/bin/perl

# $Id: class_to_object_key.pl,v 1.2 2001/07/15 23:43:20 lachoy Exp $

# class_to_object_key.pl

#   Take all objects in a class and create an entry in the
#   'object_keys' table for them.

# Usage:
#   $ export OIWEBSITE=/path/to/mysite
#   $ perl class_to_object_key.pl basicpage
#   $ perl class_to_object_key.pl news

use strict;
use OpenInteract::Startup;

use constant DEBUG => 0;

{
    my $usage = "Usage: $0 --website_dir=/path/to/my_site class-alias";

    my $R = OpenInteract::Startup->setup_static_environment_options( $usage );

    my ( $class_alias ) = @ARGV;
    die "$usage\n"                                         unless ( $class_alias );
    my $object_class = eval { $R->$class_alias() };
    die "$usage\n -- '$class_alias' is not a valid alias.\n" if ( $@ );

    my $iter = $object_class->fetch_iterator();
    while ( my $object = $iter->get_next ) {
        my $key = $object->save_object_key;
        DEBUG() && warn "Object (", ref $object, ") (", $object->id, ") --> $key\n";
    }
    $R->db->disconnect;
}
