# -*-perl-*-

# $Id: 03_uuid_key.t,v 3.2 2004/02/26 02:02:30 lachoy Exp $

use strict;

{
    require Test::More;

    # Check to see if Data::UUID is installed
    eval { require Data::UUID };
    if ( $@ ) {
        Test::More->import( skip_all => 'Data::UUID is not installed' );
    }

    Test::More->import( tests => 6 );

    do "t/config.pl";

    my %config = (
      test => {
         class    => 'LoopbackTest',
         isa      => [ qw( SPOPS::Key::UUID SPOPS::Loopback ) ],
         field    => [ qw( id_field field_name ) ],
         id_field => 'id_field',
      },
    );

    # Create our test class using the loopback
    require_ok( 'SPOPS::Initialize' );
    my $class_init_list = eval { SPOPS::Initialize->process({ config => \%config }) };
    ok( ! $@, "Initialize process run $@" );
    is( $class_init_list->[0], 'LoopbackTest', 'Loopback initialized' );

    # Create an object and save it, checking to see if {id_field} was
    # generated by SPOPS::Key::UUID

    my $item = eval { LoopbackTest->new };
    ok( ! $@, "Create object" );

    eval { $item->save };
    $item->save;
    ok( $item->{id_field}, "UUID generate on save()" );

    # Now just call it directly and ensure they're unique

    my %track = ();
    for ( 1..100 ) {
        my ( $new_uuid, $n ) = SPOPS::Key::UUID->pre_fetch_id;
        $track{ $new_uuid }++;
    }
    is( scalar keys %track, 100, "Unique keys generated" );
}
