use strict;
use warnings;

package App::Embra::Role::Snippet;
$App::Embra::Role::Snippet::VERSION = '0.001'; # TRIAL
# ABSTRACT: an HTML fragment to be inserted into some pages of your site

use Method::Signatures;
use Moo::Role;



has 'fragment' => (
    is => 'ro',
    default => '',
);


has 'clipboard' => (
    is => 'ro',
    default => '',
);

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Role::Snippet - an HTML fragment to be inserted into some pages of your site

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This role provides a few key methods and attributes to add fragments of HTML to pages in your site.

=head1 ATTRIBUTES

=head2 fragment

The HTML to insert into a page.

=head2 clipboard

Where the fragment belongs.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
