# Generated by default/object.tt
package Paws::AppMesh::VirtualGatewayClientPolicyTls;
  use Moose;
  has Certificate => (is => 'ro', isa => 'Paws::AppMesh::VirtualGatewayClientTlsCertificate', request_name => 'certificate', traits => ['NameInRequest']);
  has Enforce => (is => 'ro', isa => 'Bool', request_name => 'enforce', traits => ['NameInRequest']);
  has Ports => (is => 'ro', isa => 'ArrayRef[Int]', request_name => 'ports', traits => ['NameInRequest']);
  has Validation => (is => 'ro', isa => 'Paws::AppMesh::VirtualGatewayTlsValidationContext', request_name => 'validation', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::VirtualGatewayClientPolicyTls

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::VirtualGatewayClientPolicyTls object:

  $service_obj->Method(Att1 => { Certificate => $value, ..., Validation => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::VirtualGatewayClientPolicyTls object:

  $result = $service_obj->Method(...);
  $result->Att1->Certificate

=head1 DESCRIPTION

An object that represents a Transport Layer Security (TLS) client
policy.

=head1 ATTRIBUTES


=head2 Certificate => L<Paws::AppMesh::VirtualGatewayClientTlsCertificate>

A reference to an object that represents a virtual gateway's client's
Transport Layer Security (TLS) certificate.


=head2 Enforce => Bool

Whether the policy is enforced. The default is C<True>, if a value
isn't specified.


=head2 Ports => ArrayRef[Int]

One or more ports that the policy is enforced for.


=head2 B<REQUIRED> Validation => L<Paws::AppMesh::VirtualGatewayTlsValidationContext>

A reference to an object that represents a Transport Layer Security
(TLS) validation context.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

