#!/usr/bin/env perl
use strict;
use warnings;

use Lingua::EUS::Numbers qw(ordinal2alpha);
use Test::More tests => 156;

my %list = (
0 => 'zerogarren',
1 => 'lehenengo',
2 => 'bigarren',
3 => 'hirugarren',
4 => 'laugarren',
5 => 'bostgarren',
6 => 'seigarren',
7 => 'zazpigarren',
8 => 'zortzigarren',
9 => 'bederatzigarren',
10 => 'hamargarren',
11 => 'hamaikagarren',
12 => 'hamabigarren',
13 => 'hamahirugarren',
14 => 'hamalaugarren',
15 => 'hamabostgarren',
16 => 'hamaseigarren',
17 => 'hamazazpigarren',
18 => 'hemezortzigarren',
19 => 'hemeretzigarren',
20 => 'hogeigarren',
21 => 'hogeita batgarren',
22 => 'hogeita bigarren',
23 => 'hogeita hirugarren',
24 => 'hogeita laugarren',
25 => 'hogeita bostgarren',
26 => 'hogeita seigarren',
27 => 'hogeita zazpigarren',
28 => 'hogeita zortzigarren',
29 => 'hogeita bederatzigarren',
30 => 'hogeita hamargarren',
31 => 'hogeita hamaikagarren',
32 => 'hogeita hamabigarren',
33 => 'hogeita hamahirugarren',
34 => 'hogeita hamalaugarren',
35 => 'hogeita hamabostgarren',
36 => 'hogeita hamaseigarren',
37 => 'hogeita hamazazpigarren',
38 => 'hogeita hemezortzigarren',
39 => 'hogeita hemeretzigarren',
40 => 'berrogeigarren',
41 => 'berrogeita batgarren',
42 => 'berrogeita bigarren',
43 => 'berrogeita hirugarren',
44 => 'berrogeita laugarren',
45 => 'berrogeita bostgarren',
46 => 'berrogeita seigarren',
47 => 'berrogeita zazpigarren',
48 => 'berrogeita zortzigarren',
49 => 'berrogeita bederatzigarren',
50 => 'berrogeita hamargarren',
51 => 'berrogeita hamaikagarren',
52 => 'berrogeita hamabigarren',
53 => 'berrogeita hamahirugarren',
54 => 'berrogeita hamalaugarren',
55 => 'berrogeita hamabostgarren',
56 => 'berrogeita hamaseigarren',
57 => 'berrogeita hamazazpigarren',
58 => 'berrogeita hemezortzigarren',
59 => 'berrogeita hemeretzigarren',
60 => 'hirurogeigarren',
61 => 'hirurogeita batgarren',
62 => 'hirurogeita bigarren',
63 => 'hirurogeita hirugarren',
64 => 'hirurogeita laugarren',
65 => 'hirurogeita bostgarren',
66 => 'hirurogeita seigarren',
67 => 'hirurogeita zazpigarren',
68 => 'hirurogeita zortzigarren',
69 => 'hirurogeita bederatzigarren',
70 => 'hirurogeita hamargarren',
71 => 'hirurogeita hamaikagarren',
72 => 'hirurogeita hamabigarren',
73 => 'hirurogeita hamahirugarren',
74 => 'hirurogeita hamalaugarren',
75 => 'hirurogeita hamabostgarren',
76 => 'hirurogeita hamaseigarren',
77 => 'hirurogeita hamazazpigarren',
78 => 'hirurogeita hemezortzigarren',
79 => 'hirurogeita hemeretzigarren',
80 => 'laurogeigarren',
81 => 'laurogeita batgarren',
82 => 'laurogeita bigarren',
83 => 'laurogeita hirugarren',
84 => 'laurogeita laugarren',
85 => 'laurogeita bostgarren',
86 => 'laurogeita seigarren',
87 => 'laurogeita zazpigarren',
88 => 'laurogeita zortzigarren',
89 => 'laurogeita bederatzigarren',
90 => 'laurogeita hamargarren',
91 => 'laurogeita hamaikagarren',
92 => 'laurogeita hamabigarren',
93 => 'laurogeita hamahirugarren',
94 => 'laurogeita hamalaugarren',
95 => 'laurogeita hamabostgarren',
96 => 'laurogeita hamaseigarren',
97 => 'laurogeita hamazazpigarren',
98 => 'laurogeita hemezortzigarren',
99 => 'laurogeita hemeretzigarren',
100 => 'ehungarren',
101 => 'ehun eta batgarren',
102 => 'ehun eta bigarren',
110 => 'ehun eta hamargarren',
200 => 'berrehungarren',
202 => 'berrehun eta bigarren',
210 => 'berrehun eta hamargarren',
300 => 'hirurehungarren',
400 => 'laurehungarren',
500 => 'bostehungarren',
600 => 'seiehungarren',
700 => 'zazpiehungarren',
800 => 'zortziehungarren',
900 => 'bederatziehungarren',
1_000 => 'milagarren',
1_001 => 'mila eta batgarren',
1_010 => 'mila hamargarren',
1_100 => 'mila eta ehungarren',
1_200 => 'mila eta berrehungarren',
1_201 => 'mila berrehun eta batgarren',
1_984 => 'mila bederatziehun eta laurogeita laugarren',
1_000_000 => 'milioi batgarren',
1_000_001 => 'milioi bat eta batgarren',
1_000_002 => 'milioi bat eta bigarren',
1_000_010 => 'milioi bat eta hamargarren',
1_000_100 => 'milioi bat eta ehungarren',
1_000_200 => 'milioi bat eta berrehungarren',
1_001_000 => 'milioi bat eta milagarren',
1_002_000 => 'milioi bat eta bi milagarren',
1_001_100 => 'milioi bat eta mila eta ehungarren',
1_002_200 => 'milioi bat eta bi mila eta berrehungarren',
1_001_101 => 'milioi bat eta mila ehun eta batgarren',
1_001_102 => 'milioi bat eta mila ehun eta bigarren',
1_010_000 => 'milioi bat eta hamar milagarren',
1_020_000 => 'milioi bat eta hogei milagarren',
1_010_100 => 'milioi bat eta hamar mila eta ehungarren',
1_010_200 => 'milioi bat eta hamar mila eta berrehungarren',
1_010_101 => 'milioi bat eta hamar mila ehun eta batgarren',
10_000_000 => 'hamar milioigarren',
20_000_000 => 'hogei milioigarren',
10_000_001 => 'hamar milioi eta batgarren',
20_000_001 => 'hogei milioi eta batgarren',
20_000_002 => 'hogei milioi eta bigarren',
20_000_200 => 'hogei milioi eta berrehungarren',
1_000_000_000 => 'mila milioigarren',
1_000_000_001 => 'mila milioi eta batgarren',
2_000_000_000 => 'bi mila milioigarren',
2_000_000_001 => 'bi mila milioi eta batgarren',
10_000_000_000 => 'hamar mila milioigarren',
20_000_000_000 => 'hogei mila milioigarren',
100_000_000_000 => 'ehun mila milioigarren',
200_000_000_000 => 'berrehun mila milioigarren',
101_000_000_000 => 'ehun eta bat mila milioigarren',
201_000_000_000 => 'berrehun eta bat mila milioigarren',
110_000_000_000 => 'ehun eta hamar mila milioigarren',
210_000_000_000 => 'berrehun eta hamar mila milioigarren'

) ;


while( my( $key, $value) = each(%list) ) {
   my $result = &ordinal2alpha($key) ;
   is($result, $value, "Value of $key") ;
}
