#
#   finalizer.rb - 
#   	$Release Version: 0.3$
#   	$Revision: 1.4 $
#   	$Date: 1998/02/27 05:34:33 $
#   	by Keiju ISHITSUKA
#
# --
#
#   Usage:
#
#   add(obj, dependant, method = :finalize, *opt)
#   add_dependency(obj, dependant, method = :finalize, *opt)
#	¸ط R_method(obj, dependant) ɲ
#
#   delete(obj_or_id, dependant, method = :finalize)
#   delete_dependency(obj_or_id, dependant, method = :finalize)
#	¸ط R_method(obj, dependant) κ
#   delete_all_dependency(obj_or_id, dependant)
#	¸ط R_*(obj, dependant) κ
#   delete_by_dependant(dependant, method = :finalize)
#	¸ط R_method(*, dependant) κ
#   delete_all_by_dependant(dependant)
#	¸ط R_*(*, dependant) κ
#   delete_all
#	Ƥΰ¸طκ.
#
#   finalize(obj_or_id, dependant, method = :finalize)
#   finalize_dependency(obj_or_id, dependant, method = :finalize)
#	¸Ϣ R_method(obj, dependtant) ǷФdependant
#	finalize.
#   finalize_all_dependency(obj_or_id, dependant)
#	¸Ϣ R_*(obj, dependtant) ǷФdependantfinalize.
#   finalize_by_dependant(dependant, method = :finalize)
#	¸Ϣ R_method(*, dependtant) ǷФdependantfinalize.
#   fainalize_all_by_dependant(dependant)
#	¸Ϣ R_*(*, dependtant) ǷФdependantfinalize.
#   finalize_all
#	FinalizerϿƤdependantfinalize
#
#   safe{..}
#	gcFinalizerưΤߤ.
#
#

module Finalizer
  RCS_ID='-$Id: finalize.rb,v 1.4 1998/02/27 05:34:33 keiju Exp keiju $-'
  
  # @dependency: {id => [[dependant, method, *opt], ...], ...}
  
  # ¸ط R_method(obj, dependant) ɲ
  def add_dependency(obj, dependant, method = :finalize, *opt)
    ObjectSpace.call_finalizer(obj)
    method = method.intern unless method.kind_of?(Integer)
    assoc = [dependant, method].concat(opt)
    if dep = @dependency[obj.id]
      dep.push assoc
    else
      @dependency[obj.id] = [assoc]
    end
  end
  alias add add_dependency
  
  # ¸ط R_method(obj, dependant) κ
  def delete_dependency(id, dependant, method = :finalize)
    id = id.id unless id.kind_of?(Integer)
    method = method.intern unless method.kind_of?(Integer)
    for assoc in @dependency[id]
      assoc.delete_if do
	|d, m, *o|
	d == dependant && m == method
      end
      @dependency.delete(id) if assoc.empty?
    end
  end
  alias delete delete_dependency
  
  # ¸ط R_*(obj, dependant) κ
  def delete_all_dependency(id, dependant)
    id = id.id unless id.kind_of?(Integer)
    method = method.intern unless method.kind_of?(Integer)
    for assoc in @dependency[id]
      assoc.delete_if do
	|d, m, *o|
	d == dependant
      end
      @dependency.delete(id) if assoc.empty?
    end
  end
  
  # ¸ط R_method(*, dependant) κ
  def delete_by_dependant(dependant, method = :finalize)
    method = method.intern unless method.kind_of?(Integer)
    for id in @dependency.keys
      delete(id, dependant, method)
    end
  end
  
  # ¸ط R_*(*, dependant) κ
  def delete_all_by_dependant(dependant)
    for id in @dependency.keys
      delete_all_dependency(id, dependant)
    end
  end
  
  # ¸Ϣ R_method(obj, dependtant) ǷФdependantfinalize
  # .
  def finalize_dependency(id, dependant, method = :finalize)
    id = id.id unless id.kind_of?(Integer)
    method = method.intern unless method.kind_of?(Integer)
    for assocs in @dependency[id]
      assocs.delete_if do
	|d, m, *o|
	d.send(m, id, *o) if ret = d == dependant && m == method
	ret
      end
      @dependency.delete(id) if assoc.empty?
    end
  end
  alias finalize finalize_dependency
  
  # ¸Ϣ R_*(obj, dependtant) ǷФdependantfinalize.
  def finalize_all_dependency(id, dependant)
    id = id.id unless id.kind_of?(Integer)
    method = method.intern unless method.kind_of?(Integer)
    for assoc in @dependency[id]
      assoc.delete_if do
	|d, m, *o|
	d.send(m, id, *o) if ret = d == dependant
      end
      @dependency.delete(id) if assoc.empty?
    end
  end
  
  # ¸Ϣ R_method(*, dependtant) ǷФdependantfinalize.
  def finalize_by_dependant(dependant, method = :finalize)
    method = method.intern unless method.kind_of?(Integer)
    for id in @dependency.keys
      finalize(id, dependant, method)
    end
  end
  
  # ¸Ϣ R_*(*, dependtant) ǷФdependantfinalize.
  def fainalize_all_by_dependant(dependant)
    for id in @dependency.keys
      finalize_all_dependency(id, dependant)
    end
  end
  
  # FinalizerϿƤƤdependantfinalize
  def finalize_all
    for id, assocs in @dependency
      for dependant, method, *opt in assocs
	dependant.send(method, id, *opt)
      end
      assocs.clear
    end
  end
  
  # finalize_* ˸ƤӽФΥƥ졼
  def safe
    old_status = Thread.critical
    Thread.critical = TRUE
    ObjectSpace.remove_finalizer(@proc)
    yield
    ObjectSpace.add_finalizer(@proc)
    Thread.critical = old_status
  end
  
  # ObjectSpace#add_finalizerؤϿؿ
  def final_of(id)
    if assocs = @dependency.delete(id)
      for dependant, method, *opt in assocs
	dependant.send(method, id, *opt)
      end
    end
  end
  
  @dependency = Hash.new
  @proc = proc{|id| final_of(id)}
  ObjectSpace.add_finalizer(@proc)

  module_function :add
  module_function :add_dependency
  
  module_function :delete
  module_function :delete_dependency
  module_function :delete_all_dependency
  module_function :delete_by_dependant
  module_function :delete_all_by_dependant
  
  module_function :finalize
  module_function :finalize_dependency
  module_function :finalize_all_dependency
  module_function :finalize_by_dependant
  module_function :fainalize_all_by_dependant
  module_function :finalize_all

  module_function :safe
  
  module_function :final_of
  private_class_method :final_of
  
end

