require 'nkf'

module Kconv
  def kconv(str, out_code, in_code = NKF::AUTO)
    opt = '-'
    case in_code
    when NKF::JIS
      opt << 'J'
    when NKF::EUC
      opt << 'E'
    when NKF::SJIS
      opt << 'S'
    end

    case out_code
    when NKF::JIS
      opt << 'j'
    when NKF::EUC
      opt << 'e'
    when NKF::SJIS
      opt << 's'
    when NKF::NOCONV
      return str
    end

    opt = '' if opt == '-'

    return NKF::nkf(opt, str)
  end
  module_function :kconv

  def tojis(str)
    return NKF::nkf('-j', str)
  end
  module_function :tojis

  def toeuc(str)
    return NKF::nkf('-e', str)
  end
  module_function :toeuc

  def tosjis(str)
    return NKF::nkf('-s', str)
  end
  module_function :tosjis

  def guess(str)
    return NKF::guess(str)
  end
  module_function :guess
end
