#include "transcode_data.h"

static const unsigned char
from_SHIFT_JIS_81_offsets[256] = {
    147,147,147,147,147,147,147,147,  147,147,147,147,147,147,147,147,
    147,147,147,147,147,147,147,147,  147,147,147,147,147,147,147,147,
    147,147,147,147,147,147,147,147,  147,147,147,147,147,147,147,147,
    147,147,147,147,147,147,147,147,  147,147,147,147,147,147,147,147,
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,   24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39,   40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55,   56, 57, 58, 59, 60, 61, 62,147,
     63, 64, 65, 66, 67, 68, 69, 70,   71, 72, 73, 74, 75, 76, 77, 78,
     79, 80, 81, 82, 83, 84, 85, 86,   87, 88, 89, 90, 91, 92, 93, 94,
     95, 96, 97, 98, 99,100,101,102,  103,104,105,106,107,147,147,147,
    147,147,147,147,147,147,147,147,  108,109,110,111,112,113,114,115,
    147,147,147,147,147,147,147,147,  116,117,118,119,120,121,122,147,
    147,147,147,147,147,147,147,147,  147,147,123,124,125,126,127,128,
    129,130,131,132,133,134,135,136,  137,147,147,147,147,147,147,147,
    138,139,140,141,142,143,144,145,  147,147,147,147,146,147,147,147,
};
static const struct byte_lookup* const
from_SHIFT_JIS_81_infos[148] = {
     o3(0xE3,0x80,0x80), o3(0xE3,0x80,0x81),
     o3(0xE3,0x80,0x82), o3(0xEF,0xBC,0x8C),
     o3(0xEF,0xBC,0x8E), o3(0xE3,0x83,0xBB),
     o3(0xEF,0xBC,0x9A), o3(0xEF,0xBC,0x9B),
     o3(0xEF,0xBC,0x9F), o3(0xEF,0xBC,0x81),
     o3(0xE3,0x82,0x9B), o3(0xE3,0x82,0x9C),
          o2(0xC2,0xB4), o3(0xEF,0xBD,0x80),
          o2(0xC2,0xA8), o3(0xEF,0xBC,0xBE),
     o3(0xEF,0xBF,0xA3), o3(0xEF,0xBC,0xBF),
     o3(0xE3,0x83,0xBD), o3(0xE3,0x83,0xBE),
     o3(0xE3,0x82,0x9D), o3(0xE3,0x82,0x9E),
     o3(0xE3,0x80,0x83), o3(0xE4,0xBB,0x9D),
     o3(0xE3,0x80,0x85), o3(0xE3,0x80,0x86),
     o3(0xE3,0x80,0x87), o3(0xE3,0x83,0xBC),
     o3(0xE2,0x80,0x95), o3(0xE2,0x80,0x90),
     o3(0xEF,0xBC,0x8F), o3(0xEF,0xBC,0xBC),
     o3(0xEF,0xBD,0x9E), o3(0xE2,0x88,0xA5),
     o3(0xEF,0xBD,0x9C), o3(0xE2,0x80,0xA6),
     o3(0xE2,0x80,0xA5), o3(0xE2,0x80,0x98),
     o3(0xE2,0x80,0x99), o3(0xE2,0x80,0x9C),
     o3(0xE2,0x80,0x9D), o3(0xEF,0xBC,0x88),
     o3(0xEF,0xBC,0x89), o3(0xE3,0x80,0x94),
     o3(0xE3,0x80,0x95), o3(0xEF,0xBC,0xBB),
     o3(0xEF,0xBC,0xBD), o3(0xEF,0xBD,0x9B),
     o3(0xEF,0xBD,0x9D), o3(0xE3,0x80,0x88),
     o3(0xE3,0x80,0x89), o3(0xE3,0x80,0x8A),
     o3(0xE3,0x80,0x8B), o3(0xE3,0x80,0x8C),
     o3(0xE3,0x80,0x8D), o3(0xE3,0x80,0x8E),
     o3(0xE3,0x80,0x8F), o3(0xE3,0x80,0x90),
     o3(0xE3,0x80,0x91), o3(0xEF,0xBC,0x8B),
     o3(0xEF,0xBC,0x8D),      o2(0xC2,0xB1),
          o2(0xC3,0x97),      o2(0xC3,0xB7),
     o3(0xEF,0xBC,0x9D), o3(0xE2,0x89,0xA0),
     o3(0xEF,0xBC,0x9C), o3(0xEF,0xBC,0x9E),
     o3(0xE2,0x89,0xA6), o3(0xE2,0x89,0xA7),
     o3(0xE2,0x88,0x9E), o3(0xE2,0x88,0xB4),
     o3(0xE2,0x99,0x82), o3(0xE2,0x99,0x80),
          o2(0xC2,0xB0), o3(0xE2,0x80,0xB2),
     o3(0xE2,0x80,0xB3), o3(0xE2,0x84,0x83),
     o3(0xEF,0xBF,0xA5), o3(0xEF,0xBC,0x84),
     o3(0xEF,0xBF,0xA0), o3(0xEF,0xBF,0xA1),
     o3(0xEF,0xBC,0x85), o3(0xEF,0xBC,0x83),
     o3(0xEF,0xBC,0x86), o3(0xEF,0xBC,0x8A),
     o3(0xEF,0xBC,0xA0),      o2(0xC2,0xA7),
     o3(0xE2,0x98,0x86), o3(0xE2,0x98,0x85),
     o3(0xE2,0x97,0x8B), o3(0xE2,0x97,0x8F),
     o3(0xE2,0x97,0x8E), o3(0xE2,0x97,0x87),
     o3(0xE2,0x97,0x86), o3(0xE2,0x96,0xA1),
     o3(0xE2,0x96,0xA0), o3(0xE2,0x96,0xB3),
     o3(0xE2,0x96,0xB2), o3(0xE2,0x96,0xBD),
     o3(0xE2,0x96,0xBC), o3(0xE2,0x80,0xBB),
     o3(0xE3,0x80,0x92), o3(0xE2,0x86,0x92),
     o3(0xE2,0x86,0x90), o3(0xE2,0x86,0x91),
     o3(0xE2,0x86,0x93), o3(0xE3,0x80,0x93),
     o3(0xE2,0x88,0x88), o3(0xE2,0x88,0x8B),
     o3(0xE2,0x8A,0x86), o3(0xE2,0x8A,0x87),
     o3(0xE2,0x8A,0x82), o3(0xE2,0x8A,0x83),
     o3(0xE2,0x88,0xAA), o3(0xE2,0x88,0xA9),
     o3(0xE2,0x88,0xA7), o3(0xE2,0x88,0xA8),
     o3(0xEF,0xBF,0xA2), o3(0xE2,0x87,0x92),
     o3(0xE2,0x87,0x94), o3(0xE2,0x88,0x80),
     o3(0xE2,0x88,0x83), o3(0xE2,0x88,0xA0),
     o3(0xE2,0x8A,0xA5), o3(0xE2,0x8C,0x92),
     o3(0xE2,0x88,0x82), o3(0xE2,0x88,0x87),
     o3(0xE2,0x89,0xA1), o3(0xE2,0x89,0x92),
     o3(0xE2,0x89,0xAA), o3(0xE2,0x89,0xAB),
     o3(0xE2,0x88,0x9A), o3(0xE2,0x88,0xBD),
     o3(0xE2,0x88,0x9D), o3(0xE2,0x88,0xB5),
     o3(0xE2,0x88,0xAB), o3(0xE2,0x88,0xAC),
     o3(0xE2,0x84,0xAB), o3(0xE2,0x80,0xB0),
     o3(0xE2,0x99,0xAF), o3(0xE2,0x99,0xAD),
     o3(0xE2,0x99,0xAA), o3(0xE2,0x80,0xA0),
     o3(0xE2,0x80,0xA1),      o2(0xC2,0xB6),
     o3(0xE2,0x97,0xAF),              UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_81 = {
    from_SHIFT_JIS_81_offsets,
    from_SHIFT_JIS_81_infos
};

static const unsigned char
from_SHIFT_JIS_82_offsets[256] = {
    145,145,145,145,145,145,145,145,  145,145,145,145,145,145,145,145,
    145,145,145,145,145,145,145,145,  145,145,145,145,145,145,145,145,
    145,145,145,145,145,145,145,145,  145,145,145,145,145,145,145,145,
    145,145,145,145,145,145,145,145,  145,145,145,145,145,145,145,145,
    145,145,145,145,145,145,145,145,  145,145,145,145,145,145,145,  0,
      1,  2,  3,  4,  5,  6,  7,  8,    9,145,145,145,145,145,145,145,
     10, 11, 12, 13, 14, 15, 16, 17,   18, 19, 20, 21, 22, 23, 24, 25,
     26, 27, 28, 29, 30, 31, 32, 33,   34, 35,145,145,145,145,145,145,
    145, 36, 37, 38, 39, 40, 41, 42,   43, 44, 45, 46, 47, 48, 49, 50,
     51, 52, 53, 54, 55, 56, 57, 58,   59, 60, 61,145,145,145,145, 62,
     63, 64, 65, 66, 67, 68, 69, 70,   71, 72, 73, 74, 75, 76, 77, 78,
     79, 80, 81, 82, 83, 84, 85, 86,   87, 88, 89, 90, 91, 92, 93, 94,
     95, 96, 97, 98, 99,100,101,102,  103,104,105,106,107,108,109,110,
    111,112,113,114,115,116,117,118,  119,120,121,122,123,124,125,126,
    127,128,129,130,131,132,133,134,  135,136,137,138,139,140,141,142,
    143,144,145,145,145,145,145,145,  145,145,145,145,145,145,145,145,
};
static const struct byte_lookup* const
from_SHIFT_JIS_82_infos[146] = {
     o3(0xEF,0xBC,0x90), o3(0xEF,0xBC,0x91),
     o3(0xEF,0xBC,0x92), o3(0xEF,0xBC,0x93),
     o3(0xEF,0xBC,0x94), o3(0xEF,0xBC,0x95),
     o3(0xEF,0xBC,0x96), o3(0xEF,0xBC,0x97),
     o3(0xEF,0xBC,0x98), o3(0xEF,0xBC,0x99),
     o3(0xEF,0xBC,0xA1), o3(0xEF,0xBC,0xA2),
     o3(0xEF,0xBC,0xA3), o3(0xEF,0xBC,0xA4),
     o3(0xEF,0xBC,0xA5), o3(0xEF,0xBC,0xA6),
     o3(0xEF,0xBC,0xA7), o3(0xEF,0xBC,0xA8),
     o3(0xEF,0xBC,0xA9), o3(0xEF,0xBC,0xAA),
     o3(0xEF,0xBC,0xAB), o3(0xEF,0xBC,0xAC),
     o3(0xEF,0xBC,0xAD), o3(0xEF,0xBC,0xAE),
     o3(0xEF,0xBC,0xAF), o3(0xEF,0xBC,0xB0),
     o3(0xEF,0xBC,0xB1), o3(0xEF,0xBC,0xB2),
     o3(0xEF,0xBC,0xB3), o3(0xEF,0xBC,0xB4),
     o3(0xEF,0xBC,0xB5), o3(0xEF,0xBC,0xB6),
     o3(0xEF,0xBC,0xB7), o3(0xEF,0xBC,0xB8),
     o3(0xEF,0xBC,0xB9), o3(0xEF,0xBC,0xBA),
     o3(0xEF,0xBD,0x81), o3(0xEF,0xBD,0x82),
     o3(0xEF,0xBD,0x83), o3(0xEF,0xBD,0x84),
     o3(0xEF,0xBD,0x85), o3(0xEF,0xBD,0x86),
     o3(0xEF,0xBD,0x87), o3(0xEF,0xBD,0x88),
     o3(0xEF,0xBD,0x89), o3(0xEF,0xBD,0x8A),
     o3(0xEF,0xBD,0x8B), o3(0xEF,0xBD,0x8C),
     o3(0xEF,0xBD,0x8D), o3(0xEF,0xBD,0x8E),
     o3(0xEF,0xBD,0x8F), o3(0xEF,0xBD,0x90),
     o3(0xEF,0xBD,0x91), o3(0xEF,0xBD,0x92),
     o3(0xEF,0xBD,0x93), o3(0xEF,0xBD,0x94),
     o3(0xEF,0xBD,0x95), o3(0xEF,0xBD,0x96),
     o3(0xEF,0xBD,0x97), o3(0xEF,0xBD,0x98),
     o3(0xEF,0xBD,0x99), o3(0xEF,0xBD,0x9A),
     o3(0xE3,0x81,0x81), o3(0xE3,0x81,0x82),
     o3(0xE3,0x81,0x83), o3(0xE3,0x81,0x84),
     o3(0xE3,0x81,0x85), o3(0xE3,0x81,0x86),
     o3(0xE3,0x81,0x87), o3(0xE3,0x81,0x88),
     o3(0xE3,0x81,0x89), o3(0xE3,0x81,0x8A),
     o3(0xE3,0x81,0x8B), o3(0xE3,0x81,0x8C),
     o3(0xE3,0x81,0x8D), o3(0xE3,0x81,0x8E),
     o3(0xE3,0x81,0x8F), o3(0xE3,0x81,0x90),
     o3(0xE3,0x81,0x91), o3(0xE3,0x81,0x92),
     o3(0xE3,0x81,0x93), o3(0xE3,0x81,0x94),
     o3(0xE3,0x81,0x95), o3(0xE3,0x81,0x96),
     o3(0xE3,0x81,0x97), o3(0xE3,0x81,0x98),
     o3(0xE3,0x81,0x99), o3(0xE3,0x81,0x9A),
     o3(0xE3,0x81,0x9B), o3(0xE3,0x81,0x9C),
     o3(0xE3,0x81,0x9D), o3(0xE3,0x81,0x9E),
     o3(0xE3,0x81,0x9F), o3(0xE3,0x81,0xA0),
     o3(0xE3,0x81,0xA1), o3(0xE3,0x81,0xA2),
     o3(0xE3,0x81,0xA3), o3(0xE3,0x81,0xA4),
     o3(0xE3,0x81,0xA5), o3(0xE3,0x81,0xA6),
     o3(0xE3,0x81,0xA7), o3(0xE3,0x81,0xA8),
     o3(0xE3,0x81,0xA9), o3(0xE3,0x81,0xAA),
     o3(0xE3,0x81,0xAB), o3(0xE3,0x81,0xAC),
     o3(0xE3,0x81,0xAD), o3(0xE3,0x81,0xAE),
     o3(0xE3,0x81,0xAF), o3(0xE3,0x81,0xB0),
     o3(0xE3,0x81,0xB1), o3(0xE3,0x81,0xB2),
     o3(0xE3,0x81,0xB3), o3(0xE3,0x81,0xB4),
     o3(0xE3,0x81,0xB5), o3(0xE3,0x81,0xB6),
     o3(0xE3,0x81,0xB7), o3(0xE3,0x81,0xB8),
     o3(0xE3,0x81,0xB9), o3(0xE3,0x81,0xBA),
     o3(0xE3,0x81,0xBB), o3(0xE3,0x81,0xBC),
     o3(0xE3,0x81,0xBD), o3(0xE3,0x81,0xBE),
     o3(0xE3,0x81,0xBF), o3(0xE3,0x82,0x80),
     o3(0xE3,0x82,0x81), o3(0xE3,0x82,0x82),
     o3(0xE3,0x82,0x83), o3(0xE3,0x82,0x84),
     o3(0xE3,0x82,0x85), o3(0xE3,0x82,0x86),
     o3(0xE3,0x82,0x87), o3(0xE3,0x82,0x88),
     o3(0xE3,0x82,0x89), o3(0xE3,0x82,0x8A),
     o3(0xE3,0x82,0x8B), o3(0xE3,0x82,0x8C),
     o3(0xE3,0x82,0x8D), o3(0xE3,0x82,0x8E),
     o3(0xE3,0x82,0x8F), o3(0xE3,0x82,0x90),
     o3(0xE3,0x82,0x91), o3(0xE3,0x82,0x92),
     o3(0xE3,0x82,0x93),              UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_82 = {
    from_SHIFT_JIS_82_offsets,
    from_SHIFT_JIS_82_infos
};

static const unsigned char
from_SHIFT_JIS_83_offsets[256] = {
    134,134,134,134,134,134,134,134,  134,134,134,134,134,134,134,134,
    134,134,134,134,134,134,134,134,  134,134,134,134,134,134,134,134,
    134,134,134,134,134,134,134,134,  134,134,134,134,134,134,134,134,
    134,134,134,134,134,134,134,134,  134,134,134,134,134,134,134,134,
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,   24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39,   40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55,   56, 57, 58, 59, 60, 61, 62,134,
     63, 64, 65, 66, 67, 68, 69, 70,   71, 72, 73, 74, 75, 76, 77, 78,
     79, 80, 81, 82, 83, 84, 85,134,  134,134,134,134,134,134,134, 86,
     87, 88, 89, 90, 91, 92, 93, 94,   95, 96, 97, 98, 99,100,101,102,
    103,104,105,106,107,108,109,134,  134,134,134,134,134,134,134,110,
    111,112,113,114,115,116,117,118,  119,120,121,122,123,124,125,126,
    127,128,129,130,131,132,133,134,  134,134,134,134,134,134,134,134,
    134,134,134,134,134,134,134,134,  134,134,134,134,134,134,134,134,
    134,134,134,134,134,134,134,134,  134,134,134,134,134,134,134,134,
};
static const struct byte_lookup* const
from_SHIFT_JIS_83_infos[135] = {
     o3(0xE3,0x82,0xA1), o3(0xE3,0x82,0xA2),
     o3(0xE3,0x82,0xA3), o3(0xE3,0x82,0xA4),
     o3(0xE3,0x82,0xA5), o3(0xE3,0x82,0xA6),
     o3(0xE3,0x82,0xA7), o3(0xE3,0x82,0xA8),
     o3(0xE3,0x82,0xA9), o3(0xE3,0x82,0xAA),
     o3(0xE3,0x82,0xAB), o3(0xE3,0x82,0xAC),
     o3(0xE3,0x82,0xAD), o3(0xE3,0x82,0xAE),
     o3(0xE3,0x82,0xAF), o3(0xE3,0x82,0xB0),
     o3(0xE3,0x82,0xB1), o3(0xE3,0x82,0xB2),
     o3(0xE3,0x82,0xB3), o3(0xE3,0x82,0xB4),
     o3(0xE3,0x82,0xB5), o3(0xE3,0x82,0xB6),
     o3(0xE3,0x82,0xB7), o3(0xE3,0x82,0xB8),
     o3(0xE3,0x82,0xB9), o3(0xE3,0x82,0xBA),
     o3(0xE3,0x82,0xBB), o3(0xE3,0x82,0xBC),
     o3(0xE3,0x82,0xBD), o3(0xE3,0x82,0xBE),
     o3(0xE3,0x82,0xBF), o3(0xE3,0x83,0x80),
     o3(0xE3,0x83,0x81), o3(0xE3,0x83,0x82),
     o3(0xE3,0x83,0x83), o3(0xE3,0x83,0x84),
     o3(0xE3,0x83,0x85), o3(0xE3,0x83,0x86),
     o3(0xE3,0x83,0x87), o3(0xE3,0x83,0x88),
     o3(0xE3,0x83,0x89), o3(0xE3,0x83,0x8A),
     o3(0xE3,0x83,0x8B), o3(0xE3,0x83,0x8C),
     o3(0xE3,0x83,0x8D), o3(0xE3,0x83,0x8E),
     o3(0xE3,0x83,0x8F), o3(0xE3,0x83,0x90),
     o3(0xE3,0x83,0x91), o3(0xE3,0x83,0x92),
     o3(0xE3,0x83,0x93), o3(0xE3,0x83,0x94),
     o3(0xE3,0x83,0x95), o3(0xE3,0x83,0x96),
     o3(0xE3,0x83,0x97), o3(0xE3,0x83,0x98),
     o3(0xE3,0x83,0x99), o3(0xE3,0x83,0x9A),
     o3(0xE3,0x83,0x9B), o3(0xE3,0x83,0x9C),
     o3(0xE3,0x83,0x9D), o3(0xE3,0x83,0x9E),
     o3(0xE3,0x83,0x9F), o3(0xE3,0x83,0xA0),
     o3(0xE3,0x83,0xA1), o3(0xE3,0x83,0xA2),
     o3(0xE3,0x83,0xA3), o3(0xE3,0x83,0xA4),
     o3(0xE3,0x83,0xA5), o3(0xE3,0x83,0xA6),
     o3(0xE3,0x83,0xA7), o3(0xE3,0x83,0xA8),
     o3(0xE3,0x83,0xA9), o3(0xE3,0x83,0xAA),
     o3(0xE3,0x83,0xAB), o3(0xE3,0x83,0xAC),
     o3(0xE3,0x83,0xAD), o3(0xE3,0x83,0xAE),
     o3(0xE3,0x83,0xAF), o3(0xE3,0x83,0xB0),
     o3(0xE3,0x83,0xB1), o3(0xE3,0x83,0xB2),
     o3(0xE3,0x83,0xB3), o3(0xE3,0x83,0xB4),
     o3(0xE3,0x83,0xB5), o3(0xE3,0x83,0xB6),
          o2(0xCE,0x91),      o2(0xCE,0x92),
          o2(0xCE,0x93),      o2(0xCE,0x94),
          o2(0xCE,0x95),      o2(0xCE,0x96),
          o2(0xCE,0x97),      o2(0xCE,0x98),
          o2(0xCE,0x99),      o2(0xCE,0x9A),
          o2(0xCE,0x9B),      o2(0xCE,0x9C),
          o2(0xCE,0x9D),      o2(0xCE,0x9E),
          o2(0xCE,0x9F),      o2(0xCE,0xA0),
          o2(0xCE,0xA1),      o2(0xCE,0xA3),
          o2(0xCE,0xA4),      o2(0xCE,0xA5),
          o2(0xCE,0xA6),      o2(0xCE,0xA7),
          o2(0xCE,0xA8),      o2(0xCE,0xA9),
          o2(0xCE,0xB1),      o2(0xCE,0xB2),
          o2(0xCE,0xB3),      o2(0xCE,0xB4),
          o2(0xCE,0xB5),      o2(0xCE,0xB6),
          o2(0xCE,0xB7),      o2(0xCE,0xB8),
          o2(0xCE,0xB9),      o2(0xCE,0xBA),
          o2(0xCE,0xBB),      o2(0xCE,0xBC),
          o2(0xCE,0xBD),      o2(0xCE,0xBE),
          o2(0xCE,0xBF),      o2(0xCF,0x80),
          o2(0xCF,0x81),      o2(0xCF,0x83),
          o2(0xCF,0x84),      o2(0xCF,0x85),
          o2(0xCF,0x86),      o2(0xCF,0x87),
          o2(0xCF,0x88),      o2(0xCF,0x89),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_83 = {
    from_SHIFT_JIS_83_offsets,
    from_SHIFT_JIS_83_infos
};

static const unsigned char
from_SHIFT_JIS_84_offsets[256] = {
     98, 98, 98, 98, 98, 98, 98, 98,   98, 98, 98, 98, 98, 98, 98, 98,
     98, 98, 98, 98, 98, 98, 98, 98,   98, 98, 98, 98, 98, 98, 98, 98,
     98, 98, 98, 98, 98, 98, 98, 98,   98, 98, 98, 98, 98, 98, 98, 98,
     98, 98, 98, 98, 98, 98, 98, 98,   98, 98, 98, 98, 98, 98, 98, 98,
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,   24, 25, 26, 27, 28, 29, 30, 31,
     32, 98, 98, 98, 98, 98, 98, 98,   98, 98, 98, 98, 98, 98, 98, 98,
     33, 34, 35, 36, 37, 38, 39, 40,   41, 42, 43, 44, 45, 46, 47, 98,
     48, 49, 50, 51, 52, 53, 54, 55,   56, 57, 58, 59, 60, 61, 62, 63,
     64, 65, 98, 98, 98, 98, 98, 98,   98, 98, 98, 98, 98, 98, 98, 66,
     67, 68, 69, 70, 71, 72, 73, 74,   75, 76, 77, 78, 79, 80, 81, 82,
     83, 84, 85, 86, 87, 88, 89, 90,   91, 92, 93, 94, 95, 96, 97, 98,
     98, 98, 98, 98, 98, 98, 98, 98,   98, 98, 98, 98, 98, 98, 98, 98,
     98, 98, 98, 98, 98, 98, 98, 98,   98, 98, 98, 98, 98, 98, 98, 98,
     98, 98, 98, 98, 98, 98, 98, 98,   98, 98, 98, 98, 98, 98, 98, 98,
     98, 98, 98, 98, 98, 98, 98, 98,   98, 98, 98, 98, 98, 98, 98, 98,
};
static const struct byte_lookup* const
from_SHIFT_JIS_84_infos[99] = {
          o2(0xD0,0x90),      o2(0xD0,0x91),
          o2(0xD0,0x92),      o2(0xD0,0x93),
          o2(0xD0,0x94),      o2(0xD0,0x95),
          o2(0xD0,0x81),      o2(0xD0,0x96),
          o2(0xD0,0x97),      o2(0xD0,0x98),
          o2(0xD0,0x99),      o2(0xD0,0x9A),
          o2(0xD0,0x9B),      o2(0xD0,0x9C),
          o2(0xD0,0x9D),      o2(0xD0,0x9E),
          o2(0xD0,0x9F),      o2(0xD0,0xA0),
          o2(0xD0,0xA1),      o2(0xD0,0xA2),
          o2(0xD0,0xA3),      o2(0xD0,0xA4),
          o2(0xD0,0xA5),      o2(0xD0,0xA6),
          o2(0xD0,0xA7),      o2(0xD0,0xA8),
          o2(0xD0,0xA9),      o2(0xD0,0xAA),
          o2(0xD0,0xAB),      o2(0xD0,0xAC),
          o2(0xD0,0xAD),      o2(0xD0,0xAE),
          o2(0xD0,0xAF),      o2(0xD0,0xB0),
          o2(0xD0,0xB1),      o2(0xD0,0xB2),
          o2(0xD0,0xB3),      o2(0xD0,0xB4),
          o2(0xD0,0xB5),      o2(0xD1,0x91),
          o2(0xD0,0xB6),      o2(0xD0,0xB7),
          o2(0xD0,0xB8),      o2(0xD0,0xB9),
          o2(0xD0,0xBA),      o2(0xD0,0xBB),
          o2(0xD0,0xBC),      o2(0xD0,0xBD),
          o2(0xD0,0xBE),      o2(0xD0,0xBF),
          o2(0xD1,0x80),      o2(0xD1,0x81),
          o2(0xD1,0x82),      o2(0xD1,0x83),
          o2(0xD1,0x84),      o2(0xD1,0x85),
          o2(0xD1,0x86),      o2(0xD1,0x87),
          o2(0xD1,0x88),      o2(0xD1,0x89),
          o2(0xD1,0x8A),      o2(0xD1,0x8B),
          o2(0xD1,0x8C),      o2(0xD1,0x8D),
          o2(0xD1,0x8E),      o2(0xD1,0x8F),
     o3(0xE2,0x94,0x80), o3(0xE2,0x94,0x82),
     o3(0xE2,0x94,0x8C), o3(0xE2,0x94,0x90),
     o3(0xE2,0x94,0x98), o3(0xE2,0x94,0x94),
     o3(0xE2,0x94,0x9C), o3(0xE2,0x94,0xAC),
     o3(0xE2,0x94,0xA4), o3(0xE2,0x94,0xB4),
     o3(0xE2,0x94,0xBC), o3(0xE2,0x94,0x81),
     o3(0xE2,0x94,0x83), o3(0xE2,0x94,0x8F),
     o3(0xE2,0x94,0x93), o3(0xE2,0x94,0x9B),
     o3(0xE2,0x94,0x97), o3(0xE2,0x94,0xA3),
     o3(0xE2,0x94,0xB3), o3(0xE2,0x94,0xAB),
     o3(0xE2,0x94,0xBB), o3(0xE2,0x95,0x8B),
     o3(0xE2,0x94,0xA0), o3(0xE2,0x94,0xAF),
     o3(0xE2,0x94,0xA8), o3(0xE2,0x94,0xB7),
     o3(0xE2,0x94,0xBF), o3(0xE2,0x94,0x9D),
     o3(0xE2,0x94,0xB0), o3(0xE2,0x94,0xA5),
     o3(0xE2,0x94,0xB8), o3(0xE2,0x95,0x82),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_84 = {
    from_SHIFT_JIS_84_offsets,
    from_SHIFT_JIS_84_infos
};

static const unsigned char
from_SHIFT_JIS_87_offsets[256] = {
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,   24, 25, 26, 27, 28, 29, 83, 30,
     31, 32, 33, 34, 35, 36, 37, 38,   39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 83, 83,   83, 83, 83, 83, 83, 83, 53, 83,
     54, 55, 56, 57, 58, 59, 60, 61,   62, 63, 64, 65, 66, 67, 68, 69,
     70, 71, 72, 73, 74, 75, 76, 77,   78, 79, 80, 81, 82, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
};
static const struct byte_lookup* const
from_SHIFT_JIS_87_infos[84] = {
  /* used from from_SHIFT_JIS_87 */
  /* used from from_EUC_JP_AD */
     o3(0xE2,0x91,0xA0), o3(0xE2,0x91,0xA1),
     o3(0xE2,0x91,0xA2), o3(0xE2,0x91,0xA3),
     o3(0xE2,0x91,0xA4), o3(0xE2,0x91,0xA5),
     o3(0xE2,0x91,0xA6), o3(0xE2,0x91,0xA7),
     o3(0xE2,0x91,0xA8), o3(0xE2,0x91,0xA9),
     o3(0xE2,0x91,0xAA), o3(0xE2,0x91,0xAB),
     o3(0xE2,0x91,0xAC), o3(0xE2,0x91,0xAD),
     o3(0xE2,0x91,0xAE), o3(0xE2,0x91,0xAF),
     o3(0xE2,0x91,0xB0), o3(0xE2,0x91,0xB1),
     o3(0xE2,0x91,0xB2), o3(0xE2,0x91,0xB3),
     o3(0xE2,0x85,0xA0), o3(0xE2,0x85,0xA1),
     o3(0xE2,0x85,0xA2), o3(0xE2,0x85,0xA3),
     o3(0xE2,0x85,0xA4), o3(0xE2,0x85,0xA5),
     o3(0xE2,0x85,0xA6), o3(0xE2,0x85,0xA7),
     o3(0xE2,0x85,0xA8), o3(0xE2,0x85,0xA9),
     o3(0xE3,0x8D,0x89), o3(0xE3,0x8C,0x94),
     o3(0xE3,0x8C,0xA2), o3(0xE3,0x8D,0x8D),
     o3(0xE3,0x8C,0x98), o3(0xE3,0x8C,0xA7),
     o3(0xE3,0x8C,0x83), o3(0xE3,0x8C,0xB6),
     o3(0xE3,0x8D,0x91), o3(0xE3,0x8D,0x97),
     o3(0xE3,0x8C,0x8D), o3(0xE3,0x8C,0xA6),
     o3(0xE3,0x8C,0xA3), o3(0xE3,0x8C,0xAB),
     o3(0xE3,0x8D,0x8A), o3(0xE3,0x8C,0xBB),
     o3(0xE3,0x8E,0x9C), o3(0xE3,0x8E,0x9D),
     o3(0xE3,0x8E,0x9E), o3(0xE3,0x8E,0x8E),
     o3(0xE3,0x8E,0x8F), o3(0xE3,0x8F,0x84),
     o3(0xE3,0x8E,0xA1), o3(0xE3,0x8D,0xBB),
     o3(0xE3,0x80,0x9D), o3(0xE3,0x80,0x9F),
     o3(0xE2,0x84,0x96), o3(0xE3,0x8F,0x8D),
     o3(0xE2,0x84,0xA1), o3(0xE3,0x8A,0xA4),
     o3(0xE3,0x8A,0xA5), o3(0xE3,0x8A,0xA6),
     o3(0xE3,0x8A,0xA7), o3(0xE3,0x8A,0xA8),
     o3(0xE3,0x88,0xB1), o3(0xE3,0x88,0xB2),
     o3(0xE3,0x88,0xB9), o3(0xE3,0x8D,0xBE),
     o3(0xE3,0x8D,0xBD), o3(0xE3,0x8D,0xBC),
     o3(0xE2,0x89,0x92), o3(0xE2,0x89,0xA1),
     o3(0xE2,0x88,0xAB), o3(0xE2,0x88,0xAE),
     o3(0xE2,0x88,0x91), o3(0xE2,0x88,0x9A),
     o3(0xE2,0x8A,0xA5), o3(0xE2,0x88,0xA0),
     o3(0xE2,0x88,0x9F), o3(0xE2,0x8A,0xBF),
     o3(0xE2,0x88,0xB5), o3(0xE2,0x88,0xA9),
     o3(0xE2,0x88,0xAA),              UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_87 = {
    from_SHIFT_JIS_87_offsets,
    from_SHIFT_JIS_87_infos
};

static const unsigned char
from_SHIFT_JIS_88_offsets[256] = {
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94,  0,
      1,  2,  3,  4,  5,  6,  7,  8,    9, 10, 11, 12, 13, 14, 15, 16,
     17, 18, 19, 20, 21, 22, 23, 24,   25, 26, 27, 28, 29, 30, 31, 32,
     33, 34, 35, 36, 37, 38, 39, 40,   41, 42, 43, 44, 45, 46, 47, 48,
     49, 50, 51, 52, 53, 54, 55, 56,   57, 58, 59, 60, 61, 62, 63, 64,
     65, 66, 67, 68, 69, 70, 71, 72,   73, 74, 75, 76, 77, 78, 79, 80,
     81, 82, 83, 84, 85, 86, 87, 88,   89, 90, 91, 92, 93, 94, 94, 94,
};
static const struct byte_lookup* const
from_SHIFT_JIS_88_infos[95] = {
  /* used from from_SHIFT_JIS_88 */
  /* used from from_EUC_JP_B0 */
     o3(0xE4,0xBA,0x9C), o3(0xE5,0x94,0x96),
     o3(0xE5,0xA8,0x83), o3(0xE9,0x98,0xBF),
     o3(0xE5,0x93,0x80), o3(0xE6,0x84,0x9B),
     o3(0xE6,0x8C,0xA8), o3(0xE5,0xA7,0xB6),
     o3(0xE9,0x80,0xA2), o3(0xE8,0x91,0xB5),
     o3(0xE8,0x8C,0x9C), o3(0xE7,0xA9,0x90),
     o3(0xE6,0x82,0xAA), o3(0xE6,0x8F,0xA1),
     o3(0xE6,0xB8,0xA5), o3(0xE6,0x97,0xAD),
     o3(0xE8,0x91,0xA6), o3(0xE8,0x8A,0xA6),
     o3(0xE9,0xAF,0xB5), o3(0xE6,0xA2,0x93),
     o3(0xE5,0x9C,0xA7), o3(0xE6,0x96,0xA1),
     o3(0xE6,0x89,0xB1), o3(0xE5,0xAE,0x9B),
     o3(0xE5,0xA7,0x90), o3(0xE8,0x99,0xBB),
     o3(0xE9,0xA3,0xB4), o3(0xE7,0xB5,0xA2),
     o3(0xE7,0xB6,0xBE), o3(0xE9,0xAE,0x8E),
     o3(0xE6,0x88,0x96), o3(0xE7,0xB2,0x9F),
     o3(0xE8,0xA2,0xB7), o3(0xE5,0xAE,0x89),
     o3(0xE5,0xBA,0xB5), o3(0xE6,0x8C,0x89),
     o3(0xE6,0x9A,0x97), o3(0xE6,0xA1,0x88),
     o3(0xE9,0x97,0x87), o3(0xE9,0x9E,0x8D),
     o3(0xE6,0x9D,0x8F), o3(0xE4,0xBB,0xA5),
     o3(0xE4,0xBC,0x8A), o3(0xE4,0xBD,0x8D),
     o3(0xE4,0xBE,0x9D), o3(0xE5,0x81,0x89),
     o3(0xE5,0x9B,0xB2), o3(0xE5,0xA4,0xB7),
     o3(0xE5,0xA7,0x94), o3(0xE5,0xA8,0x81),
     o3(0xE5,0xB0,0x89), o3(0xE6,0x83,0x9F),
     o3(0xE6,0x84,0x8F), o3(0xE6,0x85,0xB0),
     o3(0xE6,0x98,0x93), o3(0xE6,0xA4,0x85),
     o3(0xE7,0x82,0xBA), o3(0xE7,0x95,0x8F),
     o3(0xE7,0x95,0xB0), o3(0xE7,0xA7,0xBB),
     o3(0xE7,0xB6,0xAD), o3(0xE7,0xB7,0xAF),
     o3(0xE8,0x83,0x83), o3(0xE8,0x90,0x8E),
     o3(0xE8,0xA1,0xA3), o3(0xE8,0xAC,0x82),
     o3(0xE9,0x81,0x95), o3(0xE9,0x81,0xBA),
     o3(0xE5,0x8C,0xBB), o3(0xE4,0xBA,0x95),
     o3(0xE4,0xBA,0xA5), o3(0xE5,0x9F,0x9F),
     o3(0xE8,0x82,0xB2), o3(0xE9,0x83,0x81),
     o3(0xE7,0xA3,0xAF), o3(0xE4,0xB8,0x80),
     o3(0xE5,0xA3,0xB1), o3(0xE6,0xBA,0xA2),
     o3(0xE9,0x80,0xB8), o3(0xE7,0xA8,0xB2),
     o3(0xE8,0x8C,0xA8), o3(0xE8,0x8A,0x8B),
     o3(0xE9,0xB0,0xAF), o3(0xE5,0x85,0x81),
     o3(0xE5,0x8D,0xB0), o3(0xE5,0x92,0xBD),
     o3(0xE5,0x93,0xA1), o3(0xE5,0x9B,0xA0),
     o3(0xE5,0xA7,0xBB), o3(0xE5,0xBC,0x95),
     o3(0xE9,0xA3,0xB2), o3(0xE6,0xB7,0xAB),
     o3(0xE8,0x83,0xA4), o3(0xE8,0x94,0xAD),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_88 = {
    from_SHIFT_JIS_88_offsets,
    from_SHIFT_JIS_88_infos
};

static const unsigned char
from_SHIFT_JIS_89_offsets[256] = {
  /* used from from_SHIFT_JIS_89 */
  /* used from from_SHIFT_JIS_8A */
  /* used from from_SHIFT_JIS_8B */
  /* used from from_SHIFT_JIS_8C */
  /* used from from_SHIFT_JIS_8D */
  /* used from from_SHIFT_JIS_8E */
  /* used from from_SHIFT_JIS_8F */
  /* used from from_SHIFT_JIS_90 */
  /* used from from_SHIFT_JIS_91 */
  /* used from from_SHIFT_JIS_92 */
  /* used from from_SHIFT_JIS_93 */
  /* used from from_SHIFT_JIS_94 */
  /* used from from_SHIFT_JIS_95 */
  /* used from from_SHIFT_JIS_96 */
  /* used from from_SHIFT_JIS_97 */
  /* used from from_SHIFT_JIS_99 */
  /* used from from_SHIFT_JIS_9A */
  /* used from from_SHIFT_JIS_9B */
  /* used from from_SHIFT_JIS_9C */
  /* used from from_SHIFT_JIS_9D */
  /* used from from_SHIFT_JIS_9E */
  /* used from from_SHIFT_JIS_9F */
  /* used from from_SHIFT_JIS_E0 */
  /* used from from_SHIFT_JIS_E1 */
  /* used from from_SHIFT_JIS_E2 */
  /* used from from_SHIFT_JIS_E3 */
  /* used from from_SHIFT_JIS_E4 */
  /* used from from_SHIFT_JIS_E5 */
  /* used from from_SHIFT_JIS_E6 */
  /* used from from_SHIFT_JIS_E7 */
  /* used from from_SHIFT_JIS_E8 */
  /* used from from_SHIFT_JIS_E9 */
  /* used from from_SHIFT_JIS_FB */
    188,188,188,188,188,188,188,188,  188,188,188,188,188,188,188,188,
    188,188,188,188,188,188,188,188,  188,188,188,188,188,188,188,188,
    188,188,188,188,188,188,188,188,  188,188,188,188,188,188,188,188,
    188,188,188,188,188,188,188,188,  188,188,188,188,188,188,188,188,
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,   24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39,   40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55,   56, 57, 58, 59, 60, 61, 62,188,
     63, 64, 65, 66, 67, 68, 69, 70,   71, 72, 73, 74, 75, 76, 77, 78,
     79, 80, 81, 82, 83, 84, 85, 86,   87, 88, 89, 90, 91, 92, 93, 94,
     95, 96, 97, 98, 99,100,101,102,  103,104,105,106,107,108,109,110,
    111,112,113,114,115,116,117,118,  119,120,121,122,123,124,125,126,
    127,128,129,130,131,132,133,134,  135,136,137,138,139,140,141,142,
    143,144,145,146,147,148,149,150,  151,152,153,154,155,156,157,158,
    159,160,161,162,163,164,165,166,  167,168,169,170,171,172,173,174,
    175,176,177,178,179,180,181,182,  183,184,185,186,187,188,188,188,
};
static const struct byte_lookup* const
from_SHIFT_JIS_89_infos[189] = {
     o3(0xE9,0x99,0xA2), o3(0xE9,0x99,0xB0),
     o3(0xE9,0x9A,0xA0), o3(0xE9,0x9F,0xBB),
     o3(0xE5,0x90,0x8B), o3(0xE5,0x8F,0xB3),
     o3(0xE5,0xAE,0x87), o3(0xE7,0x83,0x8F),
     o3(0xE7,0xBE,0xBD), o3(0xE8,0xBF,0x82),
     o3(0xE9,0x9B,0xA8), o3(0xE5,0x8D,0xAF),
     o3(0xE9,0xB5,0x9C), o3(0xE7,0xAA,0xBA),
     o3(0xE4,0xB8,0x91), o3(0xE7,0xA2,0x93),
     o3(0xE8,0x87,0xBC), o3(0xE6,0xB8,0xA6),
     o3(0xE5,0x98,0x98), o3(0xE5,0x94,0x84),
     o3(0xE6,0xAC,0x9D), o3(0xE8,0x94,0x9A),
     o3(0xE9,0xB0,0xBB), o3(0xE5,0xA7,0xA5),
     o3(0xE5,0x8E,0xA9), o3(0xE6,0xB5,0xA6),
     o3(0xE7,0x93,0x9C), o3(0xE9,0x96,0x8F),
     o3(0xE5,0x99,0x82), o3(0xE4,0xBA,0x91),
     o3(0xE9,0x81,0x8B), o3(0xE9,0x9B,0xB2),
     o3(0xE8,0x8D,0x8F), o3(0xE9,0xA4,0x8C),
     o3(0xE5,0x8F,0xA1), o3(0xE5,0x96,0xB6),
     o3(0xE5,0xAC,0xB0), o3(0xE5,0xBD,0xB1),
     o3(0xE6,0x98,0xA0), o3(0xE6,0x9B,0xB3),
     o3(0xE6,0xA0,0x84), o3(0xE6,0xB0,0xB8),
     o3(0xE6,0xB3,0xB3), o3(0xE6,0xB4,0xA9),
     o3(0xE7,0x91,0x9B), o3(0xE7,0x9B,0x88),
     o3(0xE7,0xA9,0x8E), o3(0xE9,0xA0,0xB4),
     o3(0xE8,0x8B,0xB1), o3(0xE8,0xA1,0x9B),
     o3(0xE8,0xA9,0xA0), o3(0xE9,0x8B,0xAD),
     o3(0xE6,0xB6,0xB2), o3(0xE7,0x96,0xAB),
     o3(0xE7,0x9B,0x8A), o3(0xE9,0xA7,0x85),
     o3(0xE6,0x82,0xA6), o3(0xE8,0xAC,0x81),
     o3(0xE8,0xB6,0x8A), o3(0xE9,0x96,0xB2),
     o3(0xE6,0xA6,0x8E), o3(0xE5,0x8E,0xAD),
     o3(0xE5,0x86,0x86), o3(0xE5,0x9C,0x92),
     o3(0xE5,0xA0,0xB0), o3(0xE5,0xA5,0x84),
     o3(0xE5,0xAE,0xB4), o3(0xE5,0xBB,0xB6),
     o3(0xE6,0x80,0xA8), o3(0xE6,0x8E,0xA9),
     o3(0xE6,0x8F,0xB4), o3(0xE6,0xB2,0xBF),
     o3(0xE6,0xBC,0x94), o3(0xE7,0x82,0x8E),
     o3(0xE7,0x84,0x94), o3(0xE7,0x85,0x99),
     o3(0xE7,0x87,0x95), o3(0xE7,0x8C,0xBF),
     o3(0xE7,0xB8,0x81), o3(0xE8,0x89,0xB6),
     o3(0xE8,0x8B,0x91), o3(0xE8,0x96,0x97),
     o3(0xE9,0x81,0xA0), o3(0xE9,0x89,0x9B),
     o3(0xE9,0xB4,0x9B), o3(0xE5,0xA1,0xA9),
     o3(0xE6,0x96,0xBC), o3(0xE6,0xB1,0x9A),
     o3(0xE7,0x94,0xA5), o3(0xE5,0x87,0xB9),
     o3(0xE5,0xA4,0xAE), o3(0xE5,0xA5,0xA5),
     o3(0xE5,0xBE,0x80), o3(0xE5,0xBF,0x9C),
     o3(0xE6,0x8A,0xBC), o3(0xE6,0x97,0xBA),
     o3(0xE6,0xA8,0xAA), o3(0xE6,0xAC,0xA7),
     o3(0xE6,0xAE,0xB4), o3(0xE7,0x8E,0x8B),
     o3(0xE7,0xBF,0x81), o3(0xE8,0xA5,0x96),
     o3(0xE9,0xB4,0xAC), o3(0xE9,0xB4,0x8E),
     o3(0xE9,0xBB,0x84), o3(0xE5,0xB2,0xA1),
     o3(0xE6,0xB2,0x96), o3(0xE8,0x8D,0xBB),
     o3(0xE5,0x84,0x84), o3(0xE5,0xB1,0x8B),
     o3(0xE6,0x86,0xB6), o3(0xE8,0x87,0x86),
     o3(0xE6,0xA1,0xB6), o3(0xE7,0x89,0xA1),
     o3(0xE4,0xB9,0x99), o3(0xE4,0xBF,0xBA),
     o3(0xE5,0x8D,0xB8), o3(0xE6,0x81,0xA9),
     o3(0xE6,0xB8,0xA9), o3(0xE7,0xA9,0x8F),
     o3(0xE9,0x9F,0xB3), o3(0xE4,0xB8,0x8B),
     o3(0xE5,0x8C,0x96), o3(0xE4,0xBB,0xAE),
     o3(0xE4,0xBD,0x95), o3(0xE4,0xBC,0xBD),
     o3(0xE4,0xBE,0xA1), o3(0xE4,0xBD,0xB3),
     o3(0xE5,0x8A,0xA0), o3(0xE5,0x8F,0xAF),
     o3(0xE5,0x98,0x89), o3(0xE5,0xA4,0x8F),
     o3(0xE5,0xAB,0x81), o3(0xE5,0xAE,0xB6),
     o3(0xE5,0xAF,0xA1), o3(0xE7,0xA7,0x91),
     o3(0xE6,0x9A,0x87), o3(0xE6,0x9E,0x9C),
     o3(0xE6,0x9E,0xB6), o3(0xE6,0xAD,0x8C),
     o3(0xE6,0xB2,0xB3), o3(0xE7,0x81,0xAB),
     o3(0xE7,0x8F,0x82), o3(0xE7,0xA6,0x8D),
     o3(0xE7,0xA6,0xBE), o3(0xE7,0xA8,0xBC),
     o3(0xE7,0xAE,0x87), o3(0xE8,0x8A,0xB1),
     o3(0xE8,0x8B,0x9B), o3(0xE8,0x8C,0x84),
     o3(0xE8,0x8D,0xB7), o3(0xE8,0x8F,0xAF),
     o3(0xE8,0x8F,0x93), o3(0xE8,0x9D,0xA6),
     o3(0xE8,0xAA,0xB2), o3(0xE5,0x98,0xA9),
     o3(0xE8,0xB2,0xA8), o3(0xE8,0xBF,0xA6),
     o3(0xE9,0x81,0x8E), o3(0xE9,0x9C,0x9E),
     o3(0xE8,0x9A,0x8A), o3(0xE4,0xBF,0x84),
     o3(0xE5,0xB3,0xA8), o3(0xE6,0x88,0x91),
     o3(0xE7,0x89,0x99), o3(0xE7,0x94,0xBB),
     o3(0xE8,0x87,0xA5), o3(0xE8,0x8A,0xBD),
     o3(0xE8,0x9B,0xBE), o3(0xE8,0xB3,0x80),
     o3(0xE9,0x9B,0x85), o3(0xE9,0xA4,0x93),
     o3(0xE9,0xA7,0x95), o3(0xE4,0xBB,0x8B),
     o3(0xE4,0xBC,0x9A), o3(0xE8,0xA7,0xA3),
     o3(0xE5,0x9B,0x9E), o3(0xE5,0xA1,0x8A),
     o3(0xE5,0xA3,0x8A), o3(0xE5,0xBB,0xBB),
     o3(0xE5,0xBF,0xAB), o3(0xE6,0x80,0xAA),
     o3(0xE6,0x82,0x94), o3(0xE6,0x81,0xA2),
     o3(0xE6,0x87,0x90), o3(0xE6,0x88,0x92),
     o3(0xE6,0x8B,0x90), o3(0xE6,0x94,0xB9),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_89 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_89_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_8A_infos[189] = {
     o3(0xE9,0xAD,0x81), o3(0xE6,0x99,0xA6),
     o3(0xE6,0xA2,0xB0), o3(0xE6,0xB5,0xB7),
     o3(0xE7,0x81,0xB0), o3(0xE7,0x95,0x8C),
     o3(0xE7,0x9A,0x86), o3(0xE7,0xB5,0xB5),
     o3(0xE8,0x8A,0xA5), o3(0xE8,0x9F,0xB9),
     o3(0xE9,0x96,0x8B), o3(0xE9,0x9A,0x8E),
     o3(0xE8,0xB2,0x9D), o3(0xE5,0x87,0xB1),
     o3(0xE5,0x8A,0xBE), o3(0xE5,0xA4,0x96),
     o3(0xE5,0x92,0xB3), o3(0xE5,0xAE,0xB3),
     o3(0xE5,0xB4,0x96), o3(0xE6,0x85,0xA8),
     o3(0xE6,0xA6,0x82), o3(0xE6,0xB6,0xAF),
     o3(0xE7,0xA2,0x8D), o3(0xE8,0x93,0x8B),
     o3(0xE8,0xA1,0x97), o3(0xE8,0xA9,0xB2),
     o3(0xE9,0x8E,0xA7), o3(0xE9,0xAA,0xB8),
     o3(0xE6,0xB5,0xAC), o3(0xE9,0xA6,0xA8),
     o3(0xE8,0x9B,0x99), o3(0xE5,0x9E,0xA3),
     o3(0xE6,0x9F,0xBF), o3(0xE8,0x9B,0x8E),
     o3(0xE9,0x88,0x8E), o3(0xE5,0x8A,0x83),
     o3(0xE5,0x9A,0x87), o3(0xE5,0x90,0x84),
     o3(0xE5,0xBB,0x93), o3(0xE6,0x8B,0xA1),
     o3(0xE6,0x92,0xB9), o3(0xE6,0xA0,0xBC),
     o3(0xE6,0xA0,0xB8), o3(0xE6,0xAE,0xBB),
     o3(0xE7,0x8D,0xB2), o3(0xE7,0xA2,0xBA),
     o3(0xE7,0xA9,0xAB), o3(0xE8,0xA6,0x9A),
     o3(0xE8,0xA7,0x92), o3(0xE8,0xB5,0xAB),
     o3(0xE8,0xBC,0x83), o3(0xE9,0x83,0xAD),
     o3(0xE9,0x96,0xA3), o3(0xE9,0x9A,0x94),
     o3(0xE9,0x9D,0xA9), o3(0xE5,0xAD,0xA6),
     o3(0xE5,0xB2,0xB3), o3(0xE6,0xA5,0xBD),
     o3(0xE9,0xA1,0x8D), o3(0xE9,0xA1,0x8E),
     o3(0xE6,0x8E,0x9B), o3(0xE7,0xAC,0xA0),
     o3(0xE6,0xA8,0xAB), o3(0xE6,0xA9,0xBF),
     o3(0xE6,0xA2,0xB6), o3(0xE9,0xB0,0x8D),
     o3(0xE6,0xBD,0x9F), o3(0xE5,0x89,0xB2),
     o3(0xE5,0x96,0x9D), o3(0xE6,0x81,0xB0),
     o3(0xE6,0x8B,0xAC), o3(0xE6,0xB4,0xBB),
     o3(0xE6,0xB8,0x87), o3(0xE6,0xBB,0x91),
     o3(0xE8,0x91,0x9B), o3(0xE8,0xA4,0x90),
     o3(0xE8,0xBD,0x84), o3(0xE4,0xB8,0x94),
     o3(0xE9,0xB0,0xB9), o3(0xE5,0x8F,0xB6),
     o3(0xE6,0xA4,0x9B), o3(0xE6,0xA8,0xBA),
     o3(0xE9,0x9E,0x84), o3(0xE6,0xA0,0xAA),
     o3(0xE5,0x85,0x9C), o3(0xE7,0xAB,0x83),
     o3(0xE8,0x92,0xB2), o3(0xE9,0x87,0x9C),
     o3(0xE9,0x8E,0x8C), o3(0xE5,0x99,0x9B),
     o3(0xE9,0xB4,0xA8), o3(0xE6,0xA0,0xA2),
     o3(0xE8,0x8C,0x85), o3(0xE8,0x90,0xB1),
     o3(0xE7,0xB2,0xA5), o3(0xE5,0x88,0x88),
     o3(0xE8,0x8B,0x85), o3(0xE7,0x93,0xA6),
     o3(0xE4,0xB9,0xBE), o3(0xE4,0xBE,0x83),
     o3(0xE5,0x86,0xA0), o3(0xE5,0xAF,0x92),
     o3(0xE5,0x88,0x8A), o3(0xE5,0x8B,0x98),
     o3(0xE5,0x8B,0xA7), o3(0xE5,0xB7,0xBB),
     o3(0xE5,0x96,0x9A), o3(0xE5,0xA0,0xAA),
     o3(0xE5,0xA7,0xA6), o3(0xE5,0xAE,0x8C),
     o3(0xE5,0xAE,0x98), o3(0xE5,0xAF,0x9B),
     o3(0xE5,0xB9,0xB2), o3(0xE5,0xB9,0xB9),
     o3(0xE6,0x82,0xA3), o3(0xE6,0x84,0x9F),
     o3(0xE6,0x85,0xA3), o3(0xE6,0x86,0xBE),
     o3(0xE6,0x8F,0x9B), o3(0xE6,0x95,0xA2),
     o3(0xE6,0x9F,0x91), o3(0xE6,0xA1,0x93),
     o3(0xE6,0xA3,0xBA), o3(0xE6,0xAC,0xBE),
     o3(0xE6,0xAD,0x93), o3(0xE6,0xB1,0x97),
     o3(0xE6,0xBC,0xA2), o3(0xE6,0xBE,0x97),
     o3(0xE6,0xBD,0x85), o3(0xE7,0x92,0xB0),
     o3(0xE7,0x94,0x98), o3(0xE7,0x9B,0xA3),
     o3(0xE7,0x9C,0x8B), o3(0xE7,0xAB,0xBF),
     o3(0xE7,0xAE,0xA1), o3(0xE7,0xB0,0xA1),
     o3(0xE7,0xB7,0xA9), o3(0xE7,0xBC,0xB6),
     o3(0xE7,0xBF,0xB0), o3(0xE8,0x82,0x9D),
     o3(0xE8,0x89,0xA6), o3(0xE8,0x8E,0x9E),
     o3(0xE8,0xA6,0xB3), o3(0xE8,0xAB,0x8C),
     o3(0xE8,0xB2,0xAB), o3(0xE9,0x82,0x84),
     o3(0xE9,0x91,0x91), o3(0xE9,0x96,0x93),
     o3(0xE9,0x96,0x91), o3(0xE9,0x96,0xA2),
     o3(0xE9,0x99,0xA5), o3(0xE9,0x9F,0x93),
     o3(0xE9,0xA4,0xA8), o3(0xE8,0x88,0x98),
     o3(0xE4,0xB8,0xB8), o3(0xE5,0x90,0xAB),
     o3(0xE5,0xB2,0xB8), o3(0xE5,0xB7,0x8C),
     o3(0xE7,0x8E,0xA9), o3(0xE7,0x99,0x8C),
     o3(0xE7,0x9C,0xBC), o3(0xE5,0xB2,0xA9),
     o3(0xE7,0xBF,0xAB), o3(0xE8,0xB4,0x8B),
     o3(0xE9,0x9B,0x81), o3(0xE9,0xA0,0x91),
     o3(0xE9,0xA1,0x94), o3(0xE9,0xA1,0x98),
     o3(0xE4,0xBC,0x81), o3(0xE4,0xBC,0x8E),
     o3(0xE5,0x8D,0xB1), o3(0xE5,0x96,0x9C),
     o3(0xE5,0x99,0xA8), o3(0xE5,0x9F,0xBA),
     o3(0xE5,0xA5,0x87), o3(0xE5,0xAC,0x89),
     o3(0xE5,0xAF,0x84), o3(0xE5,0xB2,0x90),
     o3(0xE5,0xB8,0x8C), o3(0xE5,0xB9,0xBE),
     o3(0xE5,0xBF,0x8C), o3(0xE6,0x8F,0xAE),
     o3(0xE6,0x9C,0xBA), o3(0xE6,0x97,0x97),
     o3(0xE6,0x97,0xA2), o3(0xE6,0x9C,0x9F),
     o3(0xE6,0xA3,0x8B), o3(0xE6,0xA3,0x84),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_8A = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_8A_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_8B_infos[189] = {
     o3(0xE6,0xA9,0x9F), o3(0xE5,0xB8,0xB0),
     o3(0xE6,0xAF,0x85), o3(0xE6,0xB0,0x97),
     o3(0xE6,0xB1,0xBD), o3(0xE7,0x95,0xBF),
     o3(0xE7,0xA5,0x88), o3(0xE5,0xAD,0xA3),
     o3(0xE7,0xA8,0x80), o3(0xE7,0xB4,0x80),
     o3(0xE5,0xBE,0xBD), o3(0xE8,0xA6,0x8F),
     o3(0xE8,0xA8,0x98), o3(0xE8,0xB2,0xB4),
     o3(0xE8,0xB5,0xB7), o3(0xE8,0xBB,0x8C),
     o3(0xE8,0xBC,0x9D), o3(0xE9,0xA3,0xA2),
     o3(0xE9,0xA8,0x8E), o3(0xE9,0xAC,0xBC),
     o3(0xE4,0xBA,0x80), o3(0xE5,0x81,0xBD),
     o3(0xE5,0x84,0x80), o3(0xE5,0xA6,0x93),
     o3(0xE5,0xAE,0x9C), o3(0xE6,0x88,0xAF),
     o3(0xE6,0x8A,0x80), o3(0xE6,0x93,0xAC),
     o3(0xE6,0xAC,0xBA), o3(0xE7,0x8A,0xA0),
     o3(0xE7,0x96,0x91), o3(0xE7,0xA5,0x87),
     o3(0xE7,0xBE,0xA9), o3(0xE8,0x9F,0xBB),
     o3(0xE8,0xAA,0xBC), o3(0xE8,0xAD,0xB0),
     o3(0xE6,0x8E,0xAC), o3(0xE8,0x8F,0x8A),
     o3(0xE9,0x9E,0xA0), o3(0xE5,0x90,0x89),
     o3(0xE5,0x90,0x83), o3(0xE5,0x96,0xAB),
     o3(0xE6,0xA1,0x94), o3(0xE6,0xA9,0x98),
     o3(0xE8,0xA9,0xB0), o3(0xE7,0xA0,0xA7),
     o3(0xE6,0x9D,0xB5), o3(0xE9,0xBB,0x8D),
     o3(0xE5,0x8D,0xB4), o3(0xE5,0xAE,0xA2),
     o3(0xE8,0x84,0x9A), o3(0xE8,0x99,0x90),
     o3(0xE9,0x80,0x86), o3(0xE4,0xB8,0x98),
     o3(0xE4,0xB9,0x85), o3(0xE4,0xBB,0x87),
     o3(0xE4,0xBC,0x91), o3(0xE5,0x8F,0x8A),
     o3(0xE5,0x90,0xB8), o3(0xE5,0xAE,0xAE),
     o3(0xE5,0xBC,0x93), o3(0xE6,0x80,0xA5),
     o3(0xE6,0x95,0x91), o3(0xE6,0x9C,0xBD),
     o3(0xE6,0xB1,0x82), o3(0xE6,0xB1,0xB2),
     o3(0xE6,0xB3,0xA3), o3(0xE7,0x81,0xB8),
     o3(0xE7,0x90,0x83), o3(0xE7,0xA9,0xB6),
     o3(0xE7,0xAA,0xAE), o3(0xE7,0xAC,0x88),
     o3(0xE7,0xB4,0x9A), o3(0xE7,0xB3,0xBE),
     o3(0xE7,0xB5,0xA6), o3(0xE6,0x97,0xA7),
     o3(0xE7,0x89,0x9B), o3(0xE5,0x8E,0xBB),
     o3(0xE5,0xB1,0x85), o3(0xE5,0xB7,0xA8),
     o3(0xE6,0x8B,0x92), o3(0xE6,0x8B,0xA0),
     o3(0xE6,0x8C,0x99), o3(0xE6,0xB8,0xA0),
     o3(0xE8,0x99,0x9A), o3(0xE8,0xA8,0xB1),
     o3(0xE8,0xB7,0x9D), o3(0xE9,0x8B,0xB8),
     o3(0xE6,0xBC,0x81), o3(0xE7,0xA6,0xA6),
     o3(0xE9,0xAD,0x9A), o3(0xE4,0xBA,0xA8),
     o3(0xE4,0xBA,0xAB), o3(0xE4,0xBA,0xAC),
     o3(0xE4,0xBE,0x9B), o3(0xE4,0xBE,0xA0),
     o3(0xE5,0x83,0x91), o3(0xE5,0x85,0x87),
     o3(0xE7,0xAB,0xB6), o3(0xE5,0x85,0xB1),
     o3(0xE5,0x87,0xB6), o3(0xE5,0x8D,0x94),
     o3(0xE5,0x8C,0xA1), o3(0xE5,0x8D,0xBF),
     o3(0xE5,0x8F,0xAB), o3(0xE5,0x96,0xAC),
     o3(0xE5,0xA2,0x83), o3(0xE5,0xB3,0xA1),
     o3(0xE5,0xBC,0xB7), o3(0xE5,0xBD,0x8A),
     o3(0xE6,0x80,0xAF), o3(0xE6,0x81,0x90),
     o3(0xE6,0x81,0xAD), o3(0xE6,0x8C,0x9F),
     o3(0xE6,0x95,0x99), o3(0xE6,0xA9,0x8B),
     o3(0xE6,0xB3,0x81), o3(0xE7,0x8B,0x82),
     o3(0xE7,0x8B,0xAD), o3(0xE7,0x9F,0xAF),
     o3(0xE8,0x83,0xB8), o3(0xE8,0x84,0x85),
     o3(0xE8,0x88,0x88), o3(0xE8,0x95,0x8E),
     o3(0xE9,0x83,0xB7), o3(0xE9,0x8F,0xA1),
     o3(0xE9,0x9F,0xBF), o3(0xE9,0xA5,0x97),
     o3(0xE9,0xA9,0x9A), o3(0xE4,0xBB,0xB0),
     o3(0xE5,0x87,0x9D), o3(0xE5,0xB0,0xAD),
     o3(0xE6,0x9A,0x81), o3(0xE6,0xA5,0xAD),
     o3(0xE5,0xB1,0x80), o3(0xE6,0x9B,0xB2),
     o3(0xE6,0xA5,0xB5), o3(0xE7,0x8E,0x89),
     o3(0xE6,0xA1,0x90), o3(0xE7,0xB2,0x81),
     o3(0xE5,0x83,0x85), o3(0xE5,0x8B,0xA4),
     o3(0xE5,0x9D,0x87), o3(0xE5,0xB7,0xBE),
     o3(0xE9,0x8C,0xA6), o3(0xE6,0x96,0xA4),
     o3(0xE6,0xAC,0xA3), o3(0xE6,0xAC,0xBD),
     o3(0xE7,0x90,0xB4), o3(0xE7,0xA6,0x81),
     o3(0xE7,0xA6,0xBD), o3(0xE7,0xAD,0x8B),
     o3(0xE7,0xB7,0x8A), o3(0xE8,0x8A,0xB9),
     o3(0xE8,0x8F,0x8C), o3(0xE8,0xA1,0xBF),
     o3(0xE8,0xA5,0x9F), o3(0xE8,0xAC,0xB9),
     o3(0xE8,0xBF,0x91), o3(0xE9,0x87,0x91),
     o3(0xE5,0x90,0x9F), o3(0xE9,0x8A,0x80),
     o3(0xE4,0xB9,0x9D), o3(0xE5,0x80,0xB6),
     o3(0xE5,0x8F,0xA5), o3(0xE5,0x8C,0xBA),
     o3(0xE7,0x8B,0x97), o3(0xE7,0x8E,0x96),
     o3(0xE7,0x9F,0xA9), o3(0xE8,0x8B,0xA6),
     o3(0xE8,0xBA,0xAF), o3(0xE9,0xA7,0x86),
     o3(0xE9,0xA7,0x88), o3(0xE9,0xA7,0x92),
     o3(0xE5,0x85,0xB7), o3(0xE6,0x84,0x9A),
     o3(0xE8,0x99,0x9E), o3(0xE5,0x96,0xB0),
     o3(0xE7,0xA9,0xBA), o3(0xE5,0x81,0xB6),
     o3(0xE5,0xAF,0x93), o3(0xE9,0x81,0x87),
     o3(0xE9,0x9A,0x85), o3(0xE4,0xB8,0xB2),
     o3(0xE6,0xAB,0x9B), o3(0xE9,0x87,0xA7),
     o3(0xE5,0xB1,0x91), o3(0xE5,0xB1,0x88),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_8B = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_8B_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_8C_infos[189] = {
     o3(0xE6,0x8E,0x98), o3(0xE7,0xAA,0x9F),
     o3(0xE6,0xB2,0x93), o3(0xE9,0x9D,0xB4),
     o3(0xE8,0xBD,0xA1), o3(0xE7,0xAA,0xAA),
     o3(0xE7,0x86,0x8A), o3(0xE9,0x9A,0x88),
     o3(0xE7,0xB2,0x82), o3(0xE6,0xA0,0x97),
     o3(0xE7,0xB9,0xB0), o3(0xE6,0xA1,0x91),
     o3(0xE9,0x8D,0xAC), o3(0xE5,0x8B,0xB2),
     o3(0xE5,0x90,0x9B), o3(0xE8,0x96,0xAB),
     o3(0xE8,0xA8,0x93), o3(0xE7,0xBE,0xA4),
     o3(0xE8,0xBB,0x8D), o3(0xE9,0x83,0xA1),
     o3(0xE5,0x8D,0xA6), o3(0xE8,0xA2,0x88),
     o3(0xE7,0xA5,0x81), o3(0xE4,0xBF,0x82),
     o3(0xE5,0x82,0xBE), o3(0xE5,0x88,0x91),
     o3(0xE5,0x85,0x84), o3(0xE5,0x95,0x93),
     o3(0xE5,0x9C,0xAD), o3(0xE7,0x8F,0xAA),
     o3(0xE5,0x9E,0x8B), o3(0xE5,0xA5,0x91),
     o3(0xE5,0xBD,0xA2), o3(0xE5,0xBE,0x84),
     o3(0xE6,0x81,0xB5), o3(0xE6,0x85,0xB6),
     o3(0xE6,0x85,0xA7), o3(0xE6,0x86,0xA9),
     o3(0xE6,0x8E,0xB2), o3(0xE6,0x90,0xBA),
     o3(0xE6,0x95,0xAC), o3(0xE6,0x99,0xAF),
     o3(0xE6,0xA1,0x82), o3(0xE6,0xB8,0x93),
     o3(0xE7,0x95,0xA6), o3(0xE7,0xA8,0xBD),
     o3(0xE7,0xB3,0xBB), o3(0xE7,0xB5,0x8C),
     o3(0xE7,0xB6,0x99), o3(0xE7,0xB9,0x8B),
     o3(0xE7,0xBD,0xAB), o3(0xE8,0x8C,0x8E),
     o3(0xE8,0x8D,0x8A), o3(0xE8,0x9B,0x8D),
     o3(0xE8,0xA8,0x88), o3(0xE8,0xA9,0xA3),
     o3(0xE8,0xAD,0xA6), o3(0xE8,0xBB,0xBD),
     o3(0xE9,0xA0,0x9A), o3(0xE9,0xB6,0x8F),
     o3(0xE8,0x8A,0xB8), o3(0xE8,0xBF,0x8E),
     o3(0xE9,0xAF,0xA8), o3(0xE5,0x8A,0x87),
     o3(0xE6,0x88,0x9F), o3(0xE6,0x92,0x83),
     o3(0xE6,0xBF,0x80), o3(0xE9,0x9A,0x99),
     o3(0xE6,0xA1,0x81), o3(0xE5,0x82,0x91),
     o3(0xE6,0xAC,0xA0), o3(0xE6,0xB1,0xBA),
     o3(0xE6,0xBD,0x94), o3(0xE7,0xA9,0xB4),
     o3(0xE7,0xB5,0x90), o3(0xE8,0xA1,0x80),
     o3(0xE8,0xA8,0xA3), o3(0xE6,0x9C,0x88),
     o3(0xE4,0xBB,0xB6), o3(0xE5,0x80,0xB9),
     o3(0xE5,0x80,0xA6), o3(0xE5,0x81,0xA5),
     o3(0xE5,0x85,0xBC), o3(0xE5,0x88,0xB8),
     o3(0xE5,0x89,0xA3), o3(0xE5,0x96,0xA7),
     o3(0xE5,0x9C,0x8F), o3(0xE5,0xA0,0x85),
     o3(0xE5,0xAB,0x8C), o3(0xE5,0xBB,0xBA),
     o3(0xE6,0x86,0xB2), o3(0xE6,0x87,0xB8),
     o3(0xE6,0x8B,0xB3), o3(0xE6,0x8D,0xB2),
     o3(0xE6,0xA4,0x9C), o3(0xE6,0xA8,0xA9),
     o3(0xE7,0x89,0xBD), o3(0xE7,0x8A,0xAC),
     o3(0xE7,0x8C,0xAE), o3(0xE7,0xA0,0x94),
     o3(0xE7,0xA1,0xAF), o3(0xE7,0xB5,0xB9),
     o3(0xE7,0x9C,0x8C), o3(0xE8,0x82,0xA9),
     o3(0xE8,0xA6,0x8B), o3(0xE8,0xAC,0x99),
     o3(0xE8,0xB3,0xA2), o3(0xE8,0xBB,0x92),
     o3(0xE9,0x81,0xA3), o3(0xE9,0x8D,0xB5),
     o3(0xE9,0x99,0xBA), o3(0xE9,0xA1,0x95),
     o3(0xE9,0xA8,0x93), o3(0xE9,0xB9,0xB8),
     o3(0xE5,0x85,0x83), o3(0xE5,0x8E,0x9F),
     o3(0xE5,0x8E,0xB3), o3(0xE5,0xB9,0xBB),
     o3(0xE5,0xBC,0xA6), o3(0xE6,0xB8,0x9B),
     o3(0xE6,0xBA,0x90), o3(0xE7,0x8E,0x84),
     o3(0xE7,0x8F,0xBE), o3(0xE7,0xB5,0x83),
     o3(0xE8,0x88,0xB7), o3(0xE8,0xA8,0x80),
     o3(0xE8,0xAB,0xBA), o3(0xE9,0x99,0x90),
     o3(0xE4,0xB9,0x8E), o3(0xE5,0x80,0x8B),
     o3(0xE5,0x8F,0xA4), o3(0xE5,0x91,0xBC),
     o3(0xE5,0x9B,0xBA), o3(0xE5,0xA7,0x91),
     o3(0xE5,0xAD,0xA4), o3(0xE5,0xB7,0xB1),
     o3(0xE5,0xBA,0xAB), o3(0xE5,0xBC,0xA7),
     o3(0xE6,0x88,0xB8), o3(0xE6,0x95,0x85),
     o3(0xE6,0x9E,0xAF), o3(0xE6,0xB9,0x96),
     o3(0xE7,0x8B,0x90), o3(0xE7,0xB3,0x8A),
     o3(0xE8,0xA2,0xB4), o3(0xE8,0x82,0xA1),
     o3(0xE8,0x83,0xA1), o3(0xE8,0x8F,0xB0),
     o3(0xE8,0x99,0x8E), o3(0xE8,0xAA,0x87),
     o3(0xE8,0xB7,0xA8), o3(0xE9,0x88,0xB7),
     o3(0xE9,0x9B,0x87), o3(0xE9,0xA1,0xA7),
     o3(0xE9,0xBC,0x93), o3(0xE4,0xBA,0x94),
     o3(0xE4,0xBA,0x92), o3(0xE4,0xBC,0x8D),
     o3(0xE5,0x8D,0x88), o3(0xE5,0x91,0x89),
     o3(0xE5,0x90,0xBE), o3(0xE5,0xA8,0xAF),
     o3(0xE5,0xBE,0x8C), o3(0xE5,0xBE,0xA1),
     o3(0xE6,0x82,0x9F), o3(0xE6,0xA2,0xA7),
     o3(0xE6,0xAA,0x8E), o3(0xE7,0x91,0x9A),
     o3(0xE7,0xA2,0x81), o3(0xE8,0xAA,0x9E),
     o3(0xE8,0xAA,0xA4), o3(0xE8,0xAD,0xB7),
     o3(0xE9,0x86,0x90), o3(0xE4,0xB9,0x9E),
     o3(0xE9,0xAF,0x89), o3(0xE4,0xBA,0xA4),
     o3(0xE4,0xBD,0xBC), o3(0xE4,0xBE,0xAF),
     o3(0xE5,0x80,0x99), o3(0xE5,0x80,0x96),
     o3(0xE5,0x85,0x89), o3(0xE5,0x85,0xAC),
     o3(0xE5,0x8A,0x9F), o3(0xE5,0x8A,0xB9),
     o3(0xE5,0x8B,0xBE), o3(0xE5,0x8E,0x9A),
     o3(0xE5,0x8F,0xA3), o3(0xE5,0x90,0x91),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_8C = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_8C_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_8D_infos[189] = {
     o3(0xE5,0x90,0x8E), o3(0xE5,0x96,0x89),
     o3(0xE5,0x9D,0x91), o3(0xE5,0x9E,0xA2),
     o3(0xE5,0xA5,0xBD), o3(0xE5,0xAD,0x94),
     o3(0xE5,0xAD,0x9D), o3(0xE5,0xAE,0x8F),
     o3(0xE5,0xB7,0xA5), o3(0xE5,0xB7,0xA7),
     o3(0xE5,0xB7,0xB7), o3(0xE5,0xB9,0xB8),
     o3(0xE5,0xBA,0x83), o3(0xE5,0xBA,0x9A),
     o3(0xE5,0xBA,0xB7), o3(0xE5,0xBC,0x98),
     o3(0xE6,0x81,0x92), o3(0xE6,0x85,0x8C),
     o3(0xE6,0x8A,0x97), o3(0xE6,0x8B,0x98),
     o3(0xE6,0x8E,0xA7), o3(0xE6,0x94,0xBB),
     o3(0xE6,0x98,0x82), o3(0xE6,0x99,0x83),
     o3(0xE6,0x9B,0xB4), o3(0xE6,0x9D,0xAD),
     o3(0xE6,0xA0,0xA1), o3(0xE6,0xA2,0x97),
     o3(0xE6,0xA7,0x8B), o3(0xE6,0xB1,0x9F),
     o3(0xE6,0xB4,0xAA), o3(0xE6,0xB5,0xA9),
     o3(0xE6,0xB8,0xAF), o3(0xE6,0xBA,0x9D),
     o3(0xE7,0x94,0xB2), o3(0xE7,0x9A,0x87),
     o3(0xE7,0xA1,0xAC), o3(0xE7,0xA8,0xBF),
     o3(0xE7,0xB3,0xA0), o3(0xE7,0xB4,0x85),
     o3(0xE7,0xB4,0x98), o3(0xE7,0xB5,0x9E),
     o3(0xE7,0xB6,0xB1), o3(0xE8,0x80,0x95),
     o3(0xE8,0x80,0x83), o3(0xE8,0x82,0xAF),
     o3(0xE8,0x82,0xB1), o3(0xE8,0x85,0x94),
     o3(0xE8,0x86,0x8F), o3(0xE8,0x88,0xAA),
     o3(0xE8,0x8D,0x92), o3(0xE8,0xA1,0x8C),
     o3(0xE8,0xA1,0xA1), o3(0xE8,0xAC,0x9B),
     o3(0xE8,0xB2,0xA2), o3(0xE8,0xB3,0xBC),
     o3(0xE9,0x83,0x8A), o3(0xE9,0x85,0xB5),
     o3(0xE9,0x89,0xB1), o3(0xE7,0xA0,0xBF),
     o3(0xE9,0x8B,0xBC), o3(0xE9,0x96,0xA4),
     o3(0xE9,0x99,0x8D), o3(0xE9,0xA0,0x85),
     o3(0xE9,0xA6,0x99), o3(0xE9,0xAB,0x98),
     o3(0xE9,0xB4,0xBB), o3(0xE5,0x89,0x9B),
     o3(0xE5,0x8A,0xAB), o3(0xE5,0x8F,0xB7),
     o3(0xE5,0x90,0x88), o3(0xE5,0xA3,0x95),
     o3(0xE6,0x8B,0xB7), o3(0xE6,0xBF,0xA0),
     o3(0xE8,0xB1,0xAA), o3(0xE8,0xBD,0x9F),
     o3(0xE9,0xBA,0xB9), o3(0xE5,0x85,0x8B),
     o3(0xE5,0x88,0xBB), o3(0xE5,0x91,0x8A),
     o3(0xE5,0x9B,0xBD), o3(0xE7,0xA9,0x80),
     o3(0xE9,0x85,0xB7), o3(0xE9,0xB5,0xA0),
     o3(0xE9,0xBB,0x92), o3(0xE7,0x8D,0x84),
     o3(0xE6,0xBC,0x89), o3(0xE8,0x85,0xB0),
     o3(0xE7,0x94,0x91), o3(0xE5,0xBF,0xBD),
     o3(0xE6,0x83,0x9A), o3(0xE9,0xAA,0xA8),
     o3(0xE7,0x8B,0x9B), o3(0xE8,0xBE,0xBC),
     o3(0xE6,0xAD,0xA4), o3(0xE9,0xA0,0x83),
     o3(0xE4,0xBB,0x8A), o3(0xE5,0x9B,0xB0),
     o3(0xE5,0x9D,0xA4), o3(0xE5,0xA2,0xBE),
     o3(0xE5,0xA9,0x9A), o3(0xE6,0x81,0xA8),
     o3(0xE6,0x87,0x87), o3(0xE6,0x98,0x8F),
     o3(0xE6,0x98,0x86), o3(0xE6,0xA0,0xB9),
     o3(0xE6,0xA2,0xB1), o3(0xE6,0xB7,0xB7),
     o3(0xE7,0x97,0x95), o3(0xE7,0xB4,0xBA),
     o3(0xE8,0x89,0xAE), o3(0xE9,0xAD,0x82),
     o3(0xE4,0xBA,0x9B), o3(0xE4,0xBD,0x90),
     o3(0xE5,0x8F,0x89), o3(0xE5,0x94,0x86),
     o3(0xE5,0xB5,0xAF), o3(0xE5,0xB7,0xA6),
     o3(0xE5,0xB7,0xAE), o3(0xE6,0x9F,0xBB),
     o3(0xE6,0xB2,0x99), o3(0xE7,0x91,0xB3),
     o3(0xE7,0xA0,0x82), o3(0xE8,0xA9,0x90),
     o3(0xE9,0x8E,0x96), o3(0xE8,0xA3,0x9F),
     o3(0xE5,0x9D,0x90), o3(0xE5,0xBA,0xA7),
     o3(0xE6,0x8C,0xAB), o3(0xE5,0x82,0xB5),
     o3(0xE5,0x82,0xAC), o3(0xE5,0x86,0x8D),
     o3(0xE6,0x9C,0x80), o3(0xE5,0x93,0x89),
     o3(0xE5,0xA1,0x9E), o3(0xE5,0xA6,0xBB),
     o3(0xE5,0xAE,0xB0), o3(0xE5,0xBD,0xA9),
     o3(0xE6,0x89,0x8D), o3(0xE6,0x8E,0xA1),
     o3(0xE6,0xA0,0xBD), o3(0xE6,0xAD,0xB3),
     o3(0xE6,0xB8,0x88), o3(0xE7,0x81,0xBD),
     o3(0xE9,0x87,0x87), o3(0xE7,0x8A,0x80),
     o3(0xE7,0xA0,0x95), o3(0xE7,0xA0,0xA6),
     o3(0xE7,0xA5,0xAD), o3(0xE6,0x96,0x8E),
     o3(0xE7,0xB4,0xB0), o3(0xE8,0x8F,0x9C),
     o3(0xE8,0xA3,0x81), o3(0xE8,0xBC,0x89),
     o3(0xE9,0x9A,0x9B), o3(0xE5,0x89,0xA4),
     o3(0xE5,0x9C,0xA8), o3(0xE6,0x9D,0x90),
     o3(0xE7,0xBD,0xAA), o3(0xE8,0xB2,0xA1),
     o3(0xE5,0x86,0xB4), o3(0xE5,0x9D,0x82),
     o3(0xE9,0x98,0xAA), o3(0xE5,0xA0,0xBA),
     o3(0xE6,0xA6,0x8A), o3(0xE8,0x82,0xB4),
     o3(0xE5,0x92,0xB2), o3(0xE5,0xB4,0x8E),
     o3(0xE5,0x9F,0xBC), o3(0xE7,0xA2,0x95),
     o3(0xE9,0xB7,0xBA), o3(0xE4,0xBD,0x9C),
     o3(0xE5,0x89,0x8A), o3(0xE5,0x92,0x8B),
     o3(0xE6,0x90,0xBE), o3(0xE6,0x98,0xA8),
     o3(0xE6,0x9C,0x94), o3(0xE6,0x9F,0xB5),
     o3(0xE7,0xAA,0x84), o3(0xE7,0xAD,0x96),
     o3(0xE7,0xB4,0xA2), o3(0xE9,0x8C,0xAF),
     o3(0xE6,0xA1,0x9C), o3(0xE9,0xAE,0xAD),
     o3(0xE7,0xAC,0xB9), o3(0xE5,0x8C,0x99),
     o3(0xE5,0x86,0x8A), o3(0xE5,0x88,0xB7),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_8D = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_8D_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_8E_infos[189] = {
     o3(0xE5,0xAF,0x9F), o3(0xE6,0x8B,0xB6),
     o3(0xE6,0x92,0xAE), o3(0xE6,0x93,0xA6),
     o3(0xE6,0x9C,0xAD), o3(0xE6,0xAE,0xBA),
     o3(0xE8,0x96,0xA9), o3(0xE9,0x9B,0x91),
     o3(0xE7,0x9A,0x90), o3(0xE9,0xAF,0x96),
     o3(0xE6,0x8D,0x8C), o3(0xE9,0x8C,0x86),
     o3(0xE9,0xAE,0xAB), o3(0xE7,0x9A,0xBF),
     o3(0xE6,0x99,0x92), o3(0xE4,0xB8,0x89),
     o3(0xE5,0x82,0x98), o3(0xE5,0x8F,0x82),
     o3(0xE5,0xB1,0xB1), o3(0xE6,0x83,0xA8),
     o3(0xE6,0x92,0x92), o3(0xE6,0x95,0xA3),
     o3(0xE6,0xA1,0x9F), o3(0xE7,0x87,0xA6),
     o3(0xE7,0x8F,0x8A), o3(0xE7,0x94,0xA3),
     o3(0xE7,0xAE,0x97), o3(0xE7,0xBA,0x82),
     o3(0xE8,0x9A,0x95), o3(0xE8,0xAE,0x83),
     o3(0xE8,0xB3,0x9B), o3(0xE9,0x85,0xB8),
     o3(0xE9,0xA4,0x90), o3(0xE6,0x96,0xAC),
     o3(0xE6,0x9A,0xAB), o3(0xE6,0xAE,0x8B),
     o3(0xE4,0xBB,0x95), o3(0xE4,0xBB,0x94),
     o3(0xE4,0xBC,0xBA), o3(0xE4,0xBD,0xBF),
     o3(0xE5,0x88,0xBA), o3(0xE5,0x8F,0xB8),
     o3(0xE5,0x8F,0xB2), o3(0xE5,0x97,0xA3),
     o3(0xE5,0x9B,0x9B), o3(0xE5,0xA3,0xAB),
     o3(0xE5,0xA7,0x8B), o3(0xE5,0xA7,0x89),
     o3(0xE5,0xA7,0xBF), o3(0xE5,0xAD,0x90),
     o3(0xE5,0xB1,0x8D), o3(0xE5,0xB8,0x82),
     o3(0xE5,0xB8,0xAB), o3(0xE5,0xBF,0x97),
     o3(0xE6,0x80,0x9D), o3(0xE6,0x8C,0x87),
     o3(0xE6,0x94,0xAF), o3(0xE5,0xAD,0x9C),
     o3(0xE6,0x96,0xAF), o3(0xE6,0x96,0xBD),
     o3(0xE6,0x97,0xA8), o3(0xE6,0x9E,0x9D),
     o3(0xE6,0xAD,0xA2), o3(0xE6,0xAD,0xBB),
     o3(0xE6,0xB0,0x8F), o3(0xE7,0x8D,0x85),
     o3(0xE7,0xA5,0x89), o3(0xE7,0xA7,0x81),
     o3(0xE7,0xB3,0xB8), o3(0xE7,0xB4,0x99),
     o3(0xE7,0xB4,0xAB), o3(0xE8,0x82,0xA2),
     o3(0xE8,0x84,0x82), o3(0xE8,0x87,0xB3),
     o3(0xE8,0xA6,0x96), o3(0xE8,0xA9,0x9E),
     o3(0xE8,0xA9,0xA9), o3(0xE8,0xA9,0xA6),
     o3(0xE8,0xAA,0x8C), o3(0xE8,0xAB,0xAE),
     o3(0xE8,0xB3,0x87), o3(0xE8,0xB3,0x9C),
     o3(0xE9,0x9B,0x8C), o3(0xE9,0xA3,0xBC),
     o3(0xE6,0xAD,0xAF), o3(0xE4,0xBA,0x8B),
     o3(0xE4,0xBC,0xBC), o3(0xE4,0xBE,0x8D),
     o3(0xE5,0x85,0x90), o3(0xE5,0xAD,0x97),
     o3(0xE5,0xAF,0xBA), o3(0xE6,0x85,0x88),
     o3(0xE6,0x8C,0x81), o3(0xE6,0x99,0x82),
     o3(0xE6,0xAC,0xA1), o3(0xE6,0xBB,0x8B),
     o3(0xE6,0xB2,0xBB), o3(0xE7,0x88,0xBE),
     o3(0xE7,0x92,0xBD), o3(0xE7,0x97,0x94),
     o3(0xE7,0xA3,0x81), o3(0xE7,0xA4,0xBA),
     o3(0xE8,0x80,0x8C), o3(0xE8,0x80,0xB3),
     o3(0xE8,0x87,0xAA), o3(0xE8,0x92,0x94),
     o3(0xE8,0xBE,0x9E), o3(0xE6,0xB1,0x90),
     o3(0xE9,0xB9,0xBF), o3(0xE5,0xBC,0x8F),
     o3(0xE8,0xAD,0x98), o3(0xE9,0xB4,0xAB),
     o3(0xE7,0xAB,0xBA), o3(0xE8,0xBB,0xB8),
     o3(0xE5,0xAE,0x8D), o3(0xE9,0x9B,0xAB),
     o3(0xE4,0xB8,0x83), o3(0xE5,0x8F,0xB1),
     o3(0xE5,0x9F,0xB7), o3(0xE5,0xA4,0xB1),
     o3(0xE5,0xAB,0x89), o3(0xE5,0xAE,0xA4),
     o3(0xE6,0x82,0x89), o3(0xE6,0xB9,0xBF),
     o3(0xE6,0xBC,0x86), o3(0xE7,0x96,0xBE),
     o3(0xE8,0xB3,0xAA), o3(0xE5,0xAE,0x9F),
     o3(0xE8,0x94,0x80), o3(0xE7,0xAF,0xA0),
     o3(0xE5,0x81,0xB2), o3(0xE6,0x9F,0xB4),
     o3(0xE8,0x8A,0x9D), o3(0xE5,0xB1,0xA1),
     o3(0xE8,0x95,0x8A), o3(0xE7,0xB8,0x9E),
     o3(0xE8,0x88,0x8E), o3(0xE5,0x86,0x99),
     o3(0xE5,0xB0,0x84), o3(0xE6,0x8D,0xA8),
     o3(0xE8,0xB5,0xA6), o3(0xE6,0x96,0x9C),
     o3(0xE7,0x85,0xAE), o3(0xE7,0xA4,0xBE),
     o3(0xE7,0xB4,0x97), o3(0xE8,0x80,0x85),
     o3(0xE8,0xAC,0x9D), o3(0xE8,0xBB,0x8A),
     o3(0xE9,0x81,0xAE), o3(0xE8,0x9B,0x87),
     o3(0xE9,0x82,0xAA), o3(0xE5,0x80,0x9F),
     o3(0xE5,0x8B,0xBA), o3(0xE5,0xB0,0xBA),
     o3(0xE6,0x9D,0x93), o3(0xE7,0x81,0xBC),
     o3(0xE7,0x88,0xB5), o3(0xE9,0x85,0x8C),
     o3(0xE9,0x87,0x88), o3(0xE9,0x8C,0xAB),
     o3(0xE8,0x8B,0xA5), o3(0xE5,0xAF,0x82),
     o3(0xE5,0xBC,0xB1), o3(0xE6,0x83,0xB9),
     o3(0xE4,0xB8,0xBB), o3(0xE5,0x8F,0x96),
     o3(0xE5,0xAE,0x88), o3(0xE6,0x89,0x8B),
     o3(0xE6,0x9C,0xB1), o3(0xE6,0xAE,0x8A),
     o3(0xE7,0x8B,0xA9), o3(0xE7,0x8F,0xA0),
     o3(0xE7,0xA8,0xAE), o3(0xE8,0x85,0xAB),
     o3(0xE8,0xB6,0xA3), o3(0xE9,0x85,0x92),
     o3(0xE9,0xA6,0x96), o3(0xE5,0x84,0x92),
     o3(0xE5,0x8F,0x97), o3(0xE5,0x91,0xAA),
     o3(0xE5,0xAF,0xBF), o3(0xE6,0x8E,0x88),
     o3(0xE6,0xA8,0xB9), o3(0xE7,0xB6,0xAC),
     o3(0xE9,0x9C,0x80), o3(0xE5,0x9B,0x9A),
     o3(0xE5,0x8F,0x8E), o3(0xE5,0x91,0xA8),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_8E = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_8E_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_8F_infos[189] = {
     o3(0xE5,0xAE,0x97), o3(0xE5,0xB0,0xB1),
     o3(0xE5,0xB7,0x9E), o3(0xE4,0xBF,0xAE),
     o3(0xE6,0x84,0x81), o3(0xE6,0x8B,0xBE),
     o3(0xE6,0xB4,0xB2), o3(0xE7,0xA7,0x80),
     o3(0xE7,0xA7,0x8B), o3(0xE7,0xB5,0x82),
     o3(0xE7,0xB9,0x8D), o3(0xE7,0xBF,0x92),
     o3(0xE8,0x87,0xAD), o3(0xE8,0x88,0x9F),
     o3(0xE8,0x92,0x90), o3(0xE8,0xA1,0x86),
     o3(0xE8,0xA5,0xB2), o3(0xE8,0xAE,0x90),
     o3(0xE8,0xB9,0xB4), o3(0xE8,0xBC,0xAF),
     o3(0xE9,0x80,0xB1), o3(0xE9,0x85,0x8B),
     o3(0xE9,0x85,0xAC), o3(0xE9,0x9B,0x86),
     o3(0xE9,0x86,0x9C), o3(0xE4,0xBB,0x80),
     o3(0xE4,0xBD,0x8F), o3(0xE5,0x85,0x85),
     o3(0xE5,0x8D,0x81), o3(0xE5,0xBE,0x93),
     o3(0xE6,0x88,0x8E), o3(0xE6,0x9F,0x94),
     o3(0xE6,0xB1,0x81), o3(0xE6,0xB8,0x8B),
     o3(0xE7,0x8D,0xA3), o3(0xE7,0xB8,0xA6),
     o3(0xE9,0x87,0x8D), o3(0xE9,0x8A,0x83),
     o3(0xE5,0x8F,0x94), o3(0xE5,0xA4,0x99),
     o3(0xE5,0xAE,0xBF), o3(0xE6,0xB7,0x91),
     o3(0xE7,0xA5,0x9D), o3(0xE7,0xB8,0xAE),
     o3(0xE7,0xB2,0x9B), o3(0xE5,0xA1,0xBE),
     o3(0xE7,0x86,0x9F), o3(0xE5,0x87,0xBA),
     o3(0xE8,0xA1,0x93), o3(0xE8,0xBF,0xB0),
     o3(0xE4,0xBF,0x8A), o3(0xE5,0xB3,0xBB),
     o3(0xE6,0x98,0xA5), o3(0xE7,0x9E,0xAC),
     o3(0xE7,0xAB,0xA3), o3(0xE8,0x88,0x9C),
     o3(0xE9,0xA7,0xBF), o3(0xE5,0x87,0x86),
     o3(0xE5,0xBE,0xAA), o3(0xE6,0x97,0xAC),
     o3(0xE6,0xA5,0xAF), o3(0xE6,0xAE,0x89),
     o3(0xE6,0xB7,0xB3), o3(0xE6,0xBA,0x96),
     o3(0xE6,0xBD,0xA4), o3(0xE7,0x9B,0xBE),
     o3(0xE7,0xB4,0x94), o3(0xE5,0xB7,0xA1),
     o3(0xE9,0x81,0xB5), o3(0xE9,0x86,0x87),
     o3(0xE9,0xA0,0x86), o3(0xE5,0x87,0xA6),
     o3(0xE5,0x88,0x9D), o3(0xE6,0x89,0x80),
     o3(0xE6,0x9A,0x91), o3(0xE6,0x9B,0x99),
     o3(0xE6,0xB8,0x9A), o3(0xE5,0xBA,0xB6),
     o3(0xE7,0xB7,0x92), o3(0xE7,0xBD,0xB2),
     o3(0xE6,0x9B,0xB8), o3(0xE8,0x96,0xAF),
     o3(0xE8,0x97,0xB7), o3(0xE8,0xAB,0xB8),
     o3(0xE5,0x8A,0xA9), o3(0xE5,0x8F,0x99),
     o3(0xE5,0xA5,0xB3), o3(0xE5,0xBA,0x8F),
     o3(0xE5,0xBE,0x90), o3(0xE6,0x81,0x95),
     o3(0xE9,0x8B,0xA4), o3(0xE9,0x99,0xA4),
     o3(0xE5,0x82,0xB7), o3(0xE5,0x84,0x9F),
     o3(0xE5,0x8B,0x9D), o3(0xE5,0x8C,0xA0),
     o3(0xE5,0x8D,0x87), o3(0xE5,0x8F,0xAC),
     o3(0xE5,0x93,0xA8), o3(0xE5,0x95,0x86),
     o3(0xE5,0x94,0xB1), o3(0xE5,0x98,0x97),
     o3(0xE5,0xA5,0xA8), o3(0xE5,0xA6,0xBE),
     o3(0xE5,0xA8,0xBC), o3(0xE5,0xAE,0xB5),
     o3(0xE5,0xB0,0x86), o3(0xE5,0xB0,0x8F),
     o3(0xE5,0xB0,0x91), o3(0xE5,0xB0,0x9A),
     o3(0xE5,0xBA,0x84), o3(0xE5,0xBA,0x8A),
     o3(0xE5,0xBB,0xA0), o3(0xE5,0xBD,0xB0),
     o3(0xE6,0x89,0xBF), o3(0xE6,0x8A,0x84),
     o3(0xE6,0x8B,0x9B), o3(0xE6,0x8E,0x8C),
     o3(0xE6,0x8D,0xB7), o3(0xE6,0x98,0x87),
     o3(0xE6,0x98,0x8C), o3(0xE6,0x98,0xAD),
     o3(0xE6,0x99,0xB6), o3(0xE6,0x9D,0xBE),
     o3(0xE6,0xA2,0xA2), o3(0xE6,0xA8,0x9F),
     o3(0xE6,0xA8,0xB5), o3(0xE6,0xB2,0xBC),
     o3(0xE6,0xB6,0x88), o3(0xE6,0xB8,0x89),
     o3(0xE6,0xB9,0x98), o3(0xE7,0x84,0xBC),
     o3(0xE7,0x84,0xA6), o3(0xE7,0x85,0xA7),
     o3(0xE7,0x97,0x87), o3(0xE7,0x9C,0x81),
     o3(0xE7,0xA1,0x9D), o3(0xE7,0xA4,0x81),
     o3(0xE7,0xA5,0xA5), o3(0xE7,0xA7,0xB0),
     o3(0xE7,0xAB,0xA0), o3(0xE7,0xAC,0x91),
     o3(0xE7,0xB2,0xA7), o3(0xE7,0xB4,0xB9),
     o3(0xE8,0x82,0x96), o3(0xE8,0x8F,0x96),
     o3(0xE8,0x92,0x8B), o3(0xE8,0x95,0x89),
     o3(0xE8,0xA1,0x9D), o3(0xE8,0xA3,0xB3),
     o3(0xE8,0xA8,0x9F), o3(0xE8,0xA8,0xBC),
     o3(0xE8,0xA9,0x94), o3(0xE8,0xA9,0xB3),
     o3(0xE8,0xB1,0xA1), o3(0xE8,0xB3,0x9E),
     o3(0xE9,0x86,0xA4), o3(0xE9,0x89,0xA6),
     o3(0xE9,0x8D,0xBE), o3(0xE9,0x90,0x98),
     o3(0xE9,0x9A,0x9C), o3(0xE9,0x9E,0x98),
     o3(0xE4,0xB8,0x8A), o3(0xE4,0xB8,0x88),
     o3(0xE4,0xB8,0x9E), o3(0xE4,0xB9,0x97),
     o3(0xE5,0x86,0x97), o3(0xE5,0x89,0xB0),
     o3(0xE5,0x9F,0x8E), o3(0xE5,0xA0,0xB4),
     o3(0xE5,0xA3,0x8C), o3(0xE5,0xAC,0xA2),
     o3(0xE5,0xB8,0xB8), o3(0xE6,0x83,0x85),
     o3(0xE6,0x93,0xBE), o3(0xE6,0x9D,0xA1),
     o3(0xE6,0x9D,0x96), o3(0xE6,0xB5,0x84),
     o3(0xE7,0x8A,0xB6), o3(0xE7,0x95,0xB3),
     o3(0xE7,0xA9,0xA3), o3(0xE8,0x92,0xB8),
     o3(0xE8,0xAD,0xB2), o3(0xE9,0x86,0xB8),
     o3(0xE9,0x8C,0xA0), o3(0xE5,0x98,0xB1),
     o3(0xE5,0x9F,0xB4), o3(0xE9,0xA3,0xBE),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_8F = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_8F_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_90_infos[189] = {
     o3(0xE6,0x8B,0xAD), o3(0xE6,0xA4,0x8D),
     o3(0xE6,0xAE,0x96), o3(0xE7,0x87,0xAD),
     o3(0xE7,0xB9,0x94), o3(0xE8,0x81,0xB7),
     o3(0xE8,0x89,0xB2), o3(0xE8,0xA7,0xA6),
     o3(0xE9,0xA3,0x9F), o3(0xE8,0x9D,0x95),
     o3(0xE8,0xBE,0xB1), o3(0xE5,0xB0,0xBB),
     o3(0xE4,0xBC,0xB8), o3(0xE4,0xBF,0xA1),
     o3(0xE4,0xBE,0xB5), o3(0xE5,0x94,0x87),
     o3(0xE5,0xA8,0xA0), o3(0xE5,0xAF,0x9D),
     o3(0xE5,0xAF,0xA9), o3(0xE5,0xBF,0x83),
     o3(0xE6,0x85,0x8E), o3(0xE6,0x8C,0xAF),
     o3(0xE6,0x96,0xB0), o3(0xE6,0x99,0x8B),
     o3(0xE6,0xA3,0xAE), o3(0xE6,0xA6,0x9B),
     o3(0xE6,0xB5,0xB8), o3(0xE6,0xB7,0xB1),
     o3(0xE7,0x94,0xB3), o3(0xE7,0x96,0xB9),
     o3(0xE7,0x9C,0x9F), o3(0xE7,0xA5,0x9E),
     o3(0xE7,0xA7,0xA6), o3(0xE7,0xB4,0xB3),
     o3(0xE8,0x87,0xA3), o3(0xE8,0x8A,0xAF),
     o3(0xE8,0x96,0xAA), o3(0xE8,0xA6,0xAA),
     o3(0xE8,0xA8,0xBA), o3(0xE8,0xBA,0xAB),
     o3(0xE8,0xBE,0x9B), o3(0xE9,0x80,0xB2),
     o3(0xE9,0x87,0x9D), o3(0xE9,0x9C,0x87),
     o3(0xE4,0xBA,0xBA), o3(0xE4,0xBB,0x81),
     o3(0xE5,0x88,0x83), o3(0xE5,0xA1,0xB5),
     o3(0xE5,0xA3,0xAC), o3(0xE5,0xB0,0x8B),
     o3(0xE7,0x94,0x9A), o3(0xE5,0xB0,0xBD),
     o3(0xE8,0x85,0x8E), o3(0xE8,0xA8,0x8A),
     o3(0xE8,0xBF,0x85), o3(0xE9,0x99,0xA3),
     o3(0xE9,0x9D,0xAD), o3(0xE7,0xAC,0xA5),
     o3(0xE8,0xAB,0x8F), o3(0xE9,0xA0,0x88),
     o3(0xE9,0x85,0xA2), o3(0xE5,0x9B,0xB3),
     o3(0xE5,0x8E,0xA8), o3(0xE9,0x80,0x97),
     o3(0xE5,0x90,0xB9), o3(0xE5,0x9E,0x82),
     o3(0xE5,0xB8,0xA5), o3(0xE6,0x8E,0xA8),
     o3(0xE6,0xB0,0xB4), o3(0xE7,0x82,0x8A),
     o3(0xE7,0x9D,0xA1), o3(0xE7,0xB2,0x8B),
     o3(0xE7,0xBF,0xA0), o3(0xE8,0xA1,0xB0),
     o3(0xE9,0x81,0x82), o3(0xE9,0x85,0x94),
     o3(0xE9,0x8C,0x90), o3(0xE9,0x8C,0x98),
     o3(0xE9,0x9A,0x8F), o3(0xE7,0x91,0x9E),
     o3(0xE9,0xAB,0x84), o3(0xE5,0xB4,0x87),
     o3(0xE5,0xB5,0xA9), o3(0xE6,0x95,0xB0),
     o3(0xE6,0x9E,0xA2), o3(0xE8,0xB6,0xA8),
     o3(0xE9,0x9B,0x9B), o3(0xE6,0x8D,0xAE),
     o3(0xE6,0x9D,0x89), o3(0xE6,0xA4,0x99),
     o3(0xE8,0x8F,0x85), o3(0xE9,0xA0,0x97),
     o3(0xE9,0x9B,0x80), o3(0xE8,0xA3,0xBE),
     o3(0xE6,0xBE,0x84), o3(0xE6,0x91,0xBA),
     o3(0xE5,0xAF,0xB8), o3(0xE4,0xB8,0x96),
     o3(0xE7,0x80,0xAC), o3(0xE7,0x95,0x9D),
     o3(0xE6,0x98,0xAF), o3(0xE5,0x87,0x84),
     o3(0xE5,0x88,0xB6), o3(0xE5,0x8B,0xA2),
     o3(0xE5,0xA7,0x93), o3(0xE5,0xBE,0x81),
     o3(0xE6,0x80,0xA7), o3(0xE6,0x88,0x90),
     o3(0xE6,0x94,0xBF), o3(0xE6,0x95,0xB4),
     o3(0xE6,0x98,0x9F), o3(0xE6,0x99,0xB4),
     o3(0xE6,0xA3,0xB2), o3(0xE6,0xA0,0x96),
     o3(0xE6,0xAD,0xA3), o3(0xE6,0xB8,0x85),
     o3(0xE7,0x89,0xB2), o3(0xE7,0x94,0x9F),
     o3(0xE7,0x9B,0x9B), o3(0xE7,0xB2,0xBE),
     o3(0xE8,0x81,0x96), o3(0xE5,0xA3,0xB0),
     o3(0xE8,0xA3,0xBD), o3(0xE8,0xA5,0xBF),
     o3(0xE8,0xAA,0xA0), o3(0xE8,0xAA,0x93),
     o3(0xE8,0xAB,0x8B), o3(0xE9,0x80,0x9D),
     o3(0xE9,0x86,0x92), o3(0xE9,0x9D,0x92),
     o3(0xE9,0x9D,0x99), o3(0xE6,0x96,0x89),
     o3(0xE7,0xA8,0x8E), o3(0xE8,0x84,0x86),
     o3(0xE9,0x9A,0xBB), o3(0xE5,0xB8,0xAD),
     o3(0xE6,0x83,0x9C), o3(0xE6,0x88,0x9A),
     o3(0xE6,0x96,0xA5), o3(0xE6,0x98,0x94),
     o3(0xE6,0x9E,0x90), o3(0xE7,0x9F,0xB3),
     o3(0xE7,0xA9,0x8D), o3(0xE7,0xB1,0x8D),
     o3(0xE7,0xB8,0xBE), o3(0xE8,0x84,0x8A),
     o3(0xE8,0xB2,0xAC), o3(0xE8,0xB5,0xA4),
     o3(0xE8,0xB7,0xA1), o3(0xE8,0xB9,0x9F),
     o3(0xE7,0xA2,0xA9), o3(0xE5,0x88,0x87),
     o3(0xE6,0x8B,0x99), o3(0xE6,0x8E,0xA5),
     o3(0xE6,0x91,0x82), o3(0xE6,0x8A,0x98),
     o3(0xE8,0xA8,0xAD), o3(0xE7,0xAA,0x83),
     o3(0xE7,0xAF,0x80), o3(0xE8,0xAA,0xAC),
     o3(0xE9,0x9B,0xAA), o3(0xE7,0xB5,0xB6),
     o3(0xE8,0x88,0x8C), o3(0xE8,0x9D,0x89),
     o3(0xE4,0xBB,0x99), o3(0xE5,0x85,0x88),
     o3(0xE5,0x8D,0x83), o3(0xE5,0x8D,0xA0),
     o3(0xE5,0xAE,0xA3), o3(0xE5,0xB0,0x82),
     o3(0xE5,0xB0,0x96), o3(0xE5,0xB7,0x9D),
     o3(0xE6,0x88,0xA6), o3(0xE6,0x89,0x87),
     o3(0xE6,0x92,0xB0), o3(0xE6,0xA0,0x93),
     o3(0xE6,0xA0,0xB4), o3(0xE6,0xB3,0x89),
     o3(0xE6,0xB5,0x85), o3(0xE6,0xB4,0x97),
     o3(0xE6,0x9F,0x93), o3(0xE6,0xBD,0x9C),
     o3(0xE7,0x85,0x8E), o3(0xE7,0x85,0xBD),
     o3(0xE6,0x97,0x8B), o3(0xE7,0xA9,0xBF),
     o3(0xE7,0xAE,0xAD), o3(0xE7,0xB7,0x9A),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_90 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_90_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_91_infos[189] = {
     o3(0xE7,0xB9,0x8A), o3(0xE7,0xBE,0xA8),
     o3(0xE8,0x85,0xBA), o3(0xE8,0x88,0x9B),
     o3(0xE8,0x88,0xB9), o3(0xE8,0x96,0xA6),
     o3(0xE8,0xA9,0xAE), o3(0xE8,0xB3,0x8E),
     o3(0xE8,0xB7,0xB5), o3(0xE9,0x81,0xB8),
     o3(0xE9,0x81,0xB7), o3(0xE9,0x8A,0xAD),
     o3(0xE9,0x8A,0x91), o3(0xE9,0x96,0x83),
     o3(0xE9,0xAE,0xAE), o3(0xE5,0x89,0x8D),
     o3(0xE5,0x96,0x84), o3(0xE6,0xBC,0xB8),
     o3(0xE7,0x84,0xB6), o3(0xE5,0x85,0xA8),
     o3(0xE7,0xA6,0x85), o3(0xE7,0xB9,0x95),
     o3(0xE8,0x86,0xB3), o3(0xE7,0xB3,0x8E),
     o3(0xE5,0x99,0x8C), o3(0xE5,0xA1,0x91),
     o3(0xE5,0xB2,0xA8), o3(0xE6,0x8E,0xAA),
     o3(0xE6,0x9B,0xBE), o3(0xE6,0x9B,0xBD),
     o3(0xE6,0xA5,0x9A), o3(0xE7,0x8B,0x99),
     o3(0xE7,0x96,0x8F), o3(0xE7,0x96,0x8E),
     o3(0xE7,0xA4,0x8E), o3(0xE7,0xA5,0x96),
     o3(0xE7,0xA7,0x9F), o3(0xE7,0xB2,0x97),
     o3(0xE7,0xB4,0xA0), o3(0xE7,0xB5,0x84),
     o3(0xE8,0x98,0x87), o3(0xE8,0xA8,0xB4),
     o3(0xE9,0x98,0xBB), o3(0xE9,0x81,0xA1),
     o3(0xE9,0xBC,0xA0), o3(0xE5,0x83,0xA7),
     o3(0xE5,0x89,0xB5), o3(0xE5,0x8F,0x8C),
     o3(0xE5,0x8F,0xA2), o3(0xE5,0x80,0x89),
     o3(0xE5,0x96,0xAA), o3(0xE5,0xA3,0xAE),
     o3(0xE5,0xA5,0x8F), o3(0xE7,0x88,0xBD),
     o3(0xE5,0xAE,0x8B), o3(0xE5,0xB1,0xA4),
     o3(0xE5,0x8C,0x9D), o3(0xE6,0x83,0xA3),
     o3(0xE6,0x83,0xB3), o3(0xE6,0x8D,0x9C),
     o3(0xE6,0x8E,0x83), o3(0xE6,0x8C,0xBF),
     o3(0xE6,0x8E,0xBB), o3(0xE6,0x93,0x8D),
     o3(0xE6,0x97,0xA9), o3(0xE6,0x9B,0xB9),
     o3(0xE5,0xB7,0xA3), o3(0xE6,0xA7,0x8D),
     o3(0xE6,0xA7,0xBD), o3(0xE6,0xBC,0x95),
     o3(0xE7,0x87,0xA5), o3(0xE4,0xBA,0x89),
     o3(0xE7,0x97,0xA9), o3(0xE7,0x9B,0xB8),
     o3(0xE7,0xAA,0x93), o3(0xE7,0xB3,0x9F),
     o3(0xE7,0xB7,0x8F), o3(0xE7,0xB6,0x9C),
     o3(0xE8,0x81,0xA1), o3(0xE8,0x8D,0x89),
     o3(0xE8,0x8D,0x98), o3(0xE8,0x91,0xAC),
     o3(0xE8,0x92,0xBC), o3(0xE8,0x97,0xBB),
     o3(0xE8,0xA3,0x85), o3(0xE8,0xB5,0xB0),
     o3(0xE9,0x80,0x81), o3(0xE9,0x81,0xAD),
     o3(0xE9,0x8E,0x97), o3(0xE9,0x9C,0x9C),
     o3(0xE9,0xA8,0x92), o3(0xE5,0x83,0x8F),
     o3(0xE5,0xA2,0x97), o3(0xE6,0x86,0x8E),
     o3(0xE8,0x87,0x93), o3(0xE8,0x94,0xB5),
     o3(0xE8,0xB4,0x88), o3(0xE9,0x80,0xA0),
     o3(0xE4,0xBF,0x83), o3(0xE5,0x81,0xB4),
     o3(0xE5,0x89,0x87), o3(0xE5,0x8D,0xB3),
     o3(0xE6,0x81,0xAF), o3(0xE6,0x8D,0x89),
     o3(0xE6,0x9D,0x9F), o3(0xE6,0xB8,0xAC),
     o3(0xE8,0xB6,0xB3), o3(0xE9,0x80,0x9F),
     o3(0xE4,0xBF,0x97), o3(0xE5,0xB1,0x9E),
     o3(0xE8,0xB3,0x8A), o3(0xE6,0x97,0x8F),
     o3(0xE7,0xB6,0x9A), o3(0xE5,0x8D,0x92),
     o3(0xE8,0xA2,0x96), o3(0xE5,0x85,0xB6),
     o3(0xE6,0x8F,0x83), o3(0xE5,0xAD,0x98),
     o3(0xE5,0xAD,0xAB), o3(0xE5,0xB0,0x8A),
     o3(0xE6,0x90,0x8D), o3(0xE6,0x9D,0x91),
     o3(0xE9,0x81,0x9C), o3(0xE4,0xBB,0x96),
     o3(0xE5,0xA4,0x9A), o3(0xE5,0xA4,0xAA),
     o3(0xE6,0xB1,0xB0), o3(0xE8,0xA9,0x91),
     o3(0xE5,0x94,0xBE), o3(0xE5,0xA0,0x95),
     o3(0xE5,0xA6,0xA5), o3(0xE6,0x83,0xB0),
     o3(0xE6,0x89,0x93), o3(0xE6,0x9F,0x81),
     o3(0xE8,0x88,0xB5), o3(0xE6,0xA5,0x95),
     o3(0xE9,0x99,0x80), o3(0xE9,0xA7,0x84),
     o3(0xE9,0xA8,0xA8), o3(0xE4,0xBD,0x93),
     o3(0xE5,0xA0,0x86), o3(0xE5,0xAF,0xBE),
     o3(0xE8,0x80,0x90), o3(0xE5,0xB2,0xB1),
     o3(0xE5,0xB8,0xAF), o3(0xE5,0xBE,0x85),
     o3(0xE6,0x80,0xA0), o3(0xE6,0x85,0x8B),
     o3(0xE6,0x88,0xB4), o3(0xE6,0x9B,0xBF),
     o3(0xE6,0xB3,0xB0), o3(0xE6,0xBB,0x9E),
     o3(0xE8,0x83,0x8E), o3(0xE8,0x85,0xBF),
     o3(0xE8,0x8B,0x94), o3(0xE8,0xA2,0x8B),
     o3(0xE8,0xB2,0xB8), o3(0xE9,0x80,0x80),
     o3(0xE9,0x80,0xAE), o3(0xE9,0x9A,0x8A),
     o3(0xE9,0xBB,0x9B), o3(0xE9,0xAF,0x9B),
     o3(0xE4,0xBB,0xA3), o3(0xE5,0x8F,0xB0),
     o3(0xE5,0xA4,0xA7), o3(0xE7,0xAC,0xAC),
     o3(0xE9,0x86,0x8D), o3(0xE9,0xA1,0x8C),
     o3(0xE9,0xB7,0xB9), o3(0xE6,0xBB,0x9D),
     o3(0xE7,0x80,0xA7), o3(0xE5,0x8D,0x93),
     o3(0xE5,0x95,0x84), o3(0xE5,0xAE,0x85),
     o3(0xE6,0x89,0x98), o3(0xE6,0x8A,0x9E),
     o3(0xE6,0x8B,0x93), o3(0xE6,0xB2,0xA2),
     o3(0xE6,0xBF,0xAF), o3(0xE7,0x90,0xA2),
     o3(0xE8,0xA8,0x97), o3(0xE9,0x90,0xB8),
     o3(0xE6,0xBF,0x81), o3(0xE8,0xAB,0xBE),
     o3(0xE8,0x8C,0xB8), o3(0xE5,0x87,0xA7),
     o3(0xE8,0x9B,0xB8), o3(0xE5,0x8F,0xAA),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_91 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_91_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_92_infos[189] = {
     o3(0xE5,0x8F,0xA9), o3(0xE4,0xBD,0x86),
     o3(0xE9,0x81,0x94), o3(0xE8,0xBE,0xB0),
     o3(0xE5,0xA5,0xAA), o3(0xE8,0x84,0xB1),
     o3(0xE5,0xB7,0xBD), o3(0xE7,0xAB,0xAA),
     o3(0xE8,0xBE,0xBF), o3(0xE6,0xA3,0x9A),
     o3(0xE8,0xB0,0xB7), o3(0xE7,0x8B,0xB8),
     o3(0xE9,0xB1,0x88), o3(0xE6,0xA8,0xBD),
     o3(0xE8,0xAA,0xB0), o3(0xE4,0xB8,0xB9),
     o3(0xE5,0x8D,0x98), o3(0xE5,0x98,0x86),
     o3(0xE5,0x9D,0xA6), o3(0xE6,0x8B,0x85),
     o3(0xE6,0x8E,0xA2), o3(0xE6,0x97,0xA6),
     o3(0xE6,0xAD,0x8E), o3(0xE6,0xB7,0xA1),
     o3(0xE6,0xB9,0x9B), o3(0xE7,0x82,0xAD),
     o3(0xE7,0x9F,0xAD), o3(0xE7,0xAB,0xAF),
     o3(0xE7,0xAE,0xAA), o3(0xE7,0xB6,0xBB),
     o3(0xE8,0x80,0xBD), o3(0xE8,0x83,0x86),
     o3(0xE8,0x9B,0x8B), o3(0xE8,0xAA,0x95),
     o3(0xE9,0x8D,0x9B), o3(0xE5,0x9B,0xA3),
     o3(0xE5,0xA3,0x87), o3(0xE5,0xBC,0xBE),
     o3(0xE6,0x96,0xAD), o3(0xE6,0x9A,0x96),
     o3(0xE6,0xAA,0x80), o3(0xE6,0xAE,0xB5),
     o3(0xE7,0x94,0xB7), o3(0xE8,0xAB,0x87),
     o3(0xE5,0x80,0xA4), o3(0xE7,0x9F,0xA5),
     o3(0xE5,0x9C,0xB0), o3(0xE5,0xBC,0x9B),
     o3(0xE6,0x81,0xA5), o3(0xE6,0x99,0xBA),
     o3(0xE6,0xB1,0xA0), o3(0xE7,0x97,0xB4),
     o3(0xE7,0xA8,0x9A), o3(0xE7,0xBD,0xAE),
     o3(0xE8,0x87,0xB4), o3(0xE8,0x9C,0x98),
     o3(0xE9,0x81,0x85), o3(0xE9,0xA6,0xB3),
     o3(0xE7,0xAF,0x89), o3(0xE7,0x95,0x9C),
     o3(0xE7,0xAB,0xB9), o3(0xE7,0xAD,0x91),
     o3(0xE8,0x93,0x84), o3(0xE9,0x80,0x90),
     o3(0xE7,0xA7,0xA9), o3(0xE7,0xAA,0x92),
     o3(0xE8,0x8C,0xB6), o3(0xE5,0xAB,0xA1),
     o3(0xE7,0x9D,0x80), o3(0xE4,0xB8,0xAD),
     o3(0xE4,0xBB,0xB2), o3(0xE5,0xAE,0x99),
     o3(0xE5,0xBF,0xA0), o3(0xE6,0x8A,0xBD),
     o3(0xE6,0x98,0xBC), o3(0xE6,0x9F,0xB1),
     o3(0xE6,0xB3,0xA8), o3(0xE8,0x99,0xAB),
     o3(0xE8,0xA1,0xB7), o3(0xE8,0xA8,0xBB),
     o3(0xE9,0x85,0x8E), o3(0xE9,0x8B,0xB3),
     o3(0xE9,0xA7,0x90), o3(0xE6,0xA8,0x97),
     o3(0xE7,0x80,0xA6), o3(0xE7,0x8C,0xAA),
     o3(0xE8,0x8B,0xA7), o3(0xE8,0x91,0x97),
     o3(0xE8,0xB2,0xAF), o3(0xE4,0xB8,0x81),
     o3(0xE5,0x85,0x86), o3(0xE5,0x87,0x8B),
     o3(0xE5,0x96,0x8B), o3(0xE5,0xAF,0xB5),
     o3(0xE5,0xB8,0x96), o3(0xE5,0xB8,0xB3),
     o3(0xE5,0xBA,0x81), o3(0xE5,0xBC,0x94),
     o3(0xE5,0xBC,0xB5), o3(0xE5,0xBD,0xAB),
     o3(0xE5,0xBE,0xB4), o3(0xE6,0x87,0xB2),
     o3(0xE6,0x8C,0x91), o3(0xE6,0x9A,0xA2),
     o3(0xE6,0x9C,0x9D), o3(0xE6,0xBD,0xAE),
     o3(0xE7,0x89,0x92), o3(0xE7,0x94,0xBA),
     o3(0xE7,0x9C,0xBA), o3(0xE8,0x81,0xB4),
     o3(0xE8,0x84,0xB9), o3(0xE8,0x85,0xB8),
     o3(0xE8,0x9D,0xB6), o3(0xE8,0xAA,0xBF),
     o3(0xE8,0xAB,0x9C), o3(0xE8,0xB6,0x85),
     o3(0xE8,0xB7,0xB3), o3(0xE9,0x8A,0x9A),
     o3(0xE9,0x95,0xB7), o3(0xE9,0xA0,0x82),
     o3(0xE9,0xB3,0xA5), o3(0xE5,0x8B,0x85),
     o3(0xE6,0x8D,0x97), o3(0xE7,0x9B,0xB4),
     o3(0xE6,0x9C,0x95), o3(0xE6,0xB2,0x88),
     o3(0xE7,0x8F,0x8D), o3(0xE8,0xB3,0x83),
     o3(0xE9,0x8E,0xAE), o3(0xE9,0x99,0xB3),
     o3(0xE6,0xB4,0xA5), o3(0xE5,0xA2,0x9C),
     o3(0xE6,0xA4,0x8E), o3(0xE6,0xA7,0x8C),
     o3(0xE8,0xBF,0xBD), o3(0xE9,0x8E,0x9A),
     o3(0xE7,0x97,0x9B), o3(0xE9,0x80,0x9A),
     o3(0xE5,0xA1,0x9A), o3(0xE6,0xA0,0x82),
     o3(0xE6,0x8E,0xB4), o3(0xE6,0xA7,0xBB),
     o3(0xE4,0xBD,0x83), o3(0xE6,0xBC,0xAC),
     o3(0xE6,0x9F,0x98), o3(0xE8,0xBE,0xBB),
     o3(0xE8,0x94,0xA6), o3(0xE7,0xB6,0xB4),
     o3(0xE9,0x8D,0x94), o3(0xE6,0xA4,0xBF),
     o3(0xE6,0xBD,0xB0), o3(0xE5,0x9D,0xAA),
     o3(0xE5,0xA3,0xB7), o3(0xE5,0xAC,0xAC),
     o3(0xE7,0xB4,0xAC), o3(0xE7,0x88,0xAA),
     o3(0xE5,0x90,0x8A), o3(0xE9,0x87,0xA3),
     o3(0xE9,0xB6,0xB4), o3(0xE4,0xBA,0xAD),
     o3(0xE4,0xBD,0x8E), o3(0xE5,0x81,0x9C),
     o3(0xE5,0x81,0xB5), o3(0xE5,0x89,0x83),
     o3(0xE8,0xB2,0x9E), o3(0xE5,0x91,0x88),
     o3(0xE5,0xA0,0xA4), o3(0xE5,0xAE,0x9A),
     o3(0xE5,0xB8,0x9D), o3(0xE5,0xBA,0x95),
     o3(0xE5,0xBA,0xAD), o3(0xE5,0xBB,0xB7),
     o3(0xE5,0xBC,0x9F), o3(0xE6,0x82,0x8C),
     o3(0xE6,0x8A,0xB5), o3(0xE6,0x8C,0xBA),
     o3(0xE6,0x8F,0x90), o3(0xE6,0xA2,0xAF),
     o3(0xE6,0xB1,0x80), o3(0xE7,0xA2,0x87),
     o3(0xE7,0xA6,0x8E), o3(0xE7,0xA8,0x8B),
     o3(0xE7,0xB7,0xA0), o3(0xE8,0x89,0x87),
     o3(0xE8,0xA8,0x82), o3(0xE8,0xAB,0xA6),
     o3(0xE8,0xB9,0x84), o3(0xE9,0x80,0x93),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_92 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_92_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_93_infos[189] = {
     o3(0xE9,0x82,0xB8), o3(0xE9,0x84,0xAD),
     o3(0xE9,0x87,0x98), o3(0xE9,0xBC,0x8E),
     o3(0xE6,0xB3,0xA5), o3(0xE6,0x91,0x98),
     o3(0xE6,0x93,0xA2), o3(0xE6,0x95,0xB5),
     o3(0xE6,0xBB,0xB4), o3(0xE7,0x9A,0x84),
     o3(0xE7,0xAC,0x9B), o3(0xE9,0x81,0xA9),
     o3(0xE9,0x8F,0x91), o3(0xE6,0xBA,0xBA),
     o3(0xE5,0x93,0xB2), o3(0xE5,0xBE,0xB9),
     o3(0xE6,0x92,0xA4), o3(0xE8,0xBD,0x8D),
     o3(0xE8,0xBF,0xAD), o3(0xE9,0x89,0x84),
     o3(0xE5,0x85,0xB8), o3(0xE5,0xA1,0xAB),
     o3(0xE5,0xA4,0xA9), o3(0xE5,0xB1,0x95),
     o3(0xE5,0xBA,0x97), o3(0xE6,0xB7,0xBB),
     o3(0xE7,0xBA,0x8F), o3(0xE7,0x94,0x9C),
     o3(0xE8,0xB2,0xBC), o3(0xE8,0xBB,0xA2),
     o3(0xE9,0xA1,0x9B), o3(0xE7,0x82,0xB9),
     o3(0xE4,0xBC,0x9D), o3(0xE6,0xAE,0xBF),
     o3(0xE6,0xBE,0xB1), o3(0xE7,0x94,0xB0),
     o3(0xE9,0x9B,0xBB), o3(0xE5,0x85,0x8E),
     o3(0xE5,0x90,0x90), o3(0xE5,0xA0,0xB5),
     o3(0xE5,0xA1,0x97), o3(0xE5,0xA6,0xAC),
     o3(0xE5,0xB1,0xA0), o3(0xE5,0xBE,0x92),
     o3(0xE6,0x96,0x97), o3(0xE6,0x9D,0x9C),
     o3(0xE6,0xB8,0xA1), o3(0xE7,0x99,0xBB),
     o3(0xE8,0x8F,0x9F), o3(0xE8,0xB3,0xAD),
     o3(0xE9,0x80,0x94), o3(0xE9,0x83,0xBD),
     o3(0xE9,0x8D,0x8D), o3(0xE7,0xA0,0xA5),
     o3(0xE7,0xA0,0xBA), o3(0xE5,0x8A,0xAA),
     o3(0xE5,0xBA,0xA6), o3(0xE5,0x9C,0x9F),
     o3(0xE5,0xA5,0xB4), o3(0xE6,0x80,0x92),
     o3(0xE5,0x80,0x92), o3(0xE5,0x85,0x9A),
     o3(0xE5,0x86,0xAC), o3(0xE5,0x87,0x8D),
     o3(0xE5,0x88,0x80), o3(0xE5,0x94,0x90),
     o3(0xE5,0xA1,0x94), o3(0xE5,0xA1,0x98),
     o3(0xE5,0xA5,0x97), o3(0xE5,0xAE,0x95),
     o3(0xE5,0xB3,0xB6), o3(0xE5,0xB6,0x8B),
     o3(0xE6,0x82,0xBC), o3(0xE6,0x8A,0x95),
     o3(0xE6,0x90,0xAD), o3(0xE6,0x9D,0xB1),
     o3(0xE6,0xA1,0x83), o3(0xE6,0xA2,0xBC),
     o3(0xE6,0xA3,0x9F), o3(0xE7,0x9B,0x97),
     o3(0xE6,0xB7,0x98), o3(0xE6,0xB9,0xAF),
     o3(0xE6,0xB6,0x9B), o3(0xE7,0x81,0xAF),
     o3(0xE7,0x87,0x88), o3(0xE5,0xBD,0x93),
     o3(0xE7,0x97,0x98), o3(0xE7,0xA5,0xB7),
     o3(0xE7,0xAD,0x89), o3(0xE7,0xAD,0x94),
     o3(0xE7,0xAD,0x92), o3(0xE7,0xB3,0x96),
     o3(0xE7,0xB5,0xB1), o3(0xE5,0x88,0xB0),
     o3(0xE8,0x91,0xA3), o3(0xE8,0x95,0xA9),
     o3(0xE8,0x97,0xA4), o3(0xE8,0xA8,0x8E),
     o3(0xE8,0xAC,0x84), o3(0xE8,0xB1,0x86),
     o3(0xE8,0xB8,0x8F), o3(0xE9,0x80,0x83),
     o3(0xE9,0x80,0x8F), o3(0xE9,0x90,0x99),
     o3(0xE9,0x99,0xB6), o3(0xE9,0xA0,0xAD),
     o3(0xE9,0xA8,0xB0), o3(0xE9,0x97,0x98),
     o3(0xE5,0x83,0x8D), o3(0xE5,0x8B,0x95),
     o3(0xE5,0x90,0x8C), o3(0xE5,0xA0,0x82),
     o3(0xE5,0xB0,0x8E), o3(0xE6,0x86,0xA7),
     o3(0xE6,0x92,0x9E), o3(0xE6,0xB4,0x9E),
     o3(0xE7,0x9E,0xB3), o3(0xE7,0xAB,0xA5),
     o3(0xE8,0x83,0xB4), o3(0xE8,0x90,0x84),
     o3(0xE9,0x81,0x93), o3(0xE9,0x8A,0x85),
     o3(0xE5,0xB3,0xA0), o3(0xE9,0xB4,0x87),
     o3(0xE5,0x8C,0xBF), o3(0xE5,0xBE,0x97),
     o3(0xE5,0xBE,0xB3), o3(0xE6,0xB6,0x9C),
     o3(0xE7,0x89,0xB9), o3(0xE7,0x9D,0xA3),
     o3(0xE7,0xA6,0xBF), o3(0xE7,0xAF,0xA4),
     o3(0xE6,0xAF,0x92), o3(0xE7,0x8B,0xAC),
     o3(0xE8,0xAA,0xAD), o3(0xE6,0xA0,0x83),
     o3(0xE6,0xA9,0xA1), o3(0xE5,0x87,0xB8),
     o3(0xE7,0xAA,0x81), o3(0xE6,0xA4,0xB4),
     o3(0xE5,0xB1,0x8A), o3(0xE9,0xB3,0xB6),
     o3(0xE8,0x8B,0xAB), o3(0xE5,0xAF,0x85),
     o3(0xE9,0x85,0x89), o3(0xE7,0x80,0x9E),
     o3(0xE5,0x99,0xB8), o3(0xE5,0xB1,0xAF),
     o3(0xE6,0x83,0x87), o3(0xE6,0x95,0xA6),
     o3(0xE6,0xB2,0x8C), o3(0xE8,0xB1,0x9A),
     o3(0xE9,0x81,0x81), o3(0xE9,0xA0,0x93),
     o3(0xE5,0x91,0x91), o3(0xE6,0x9B,0x87),
     o3(0xE9,0x88,0x8D), o3(0xE5,0xA5,0x88),
     o3(0xE9,0x82,0xA3), o3(0xE5,0x86,0x85),
     o3(0xE4,0xB9,0x8D), o3(0xE5,0x87,0xAA),
     o3(0xE8,0x96,0x99), o3(0xE8,0xAC,0x8E),
     o3(0xE7,0x81,0x98), o3(0xE6,0x8D,0xBA),
     o3(0xE9,0x8D,0x8B), o3(0xE6,0xA5,0xA2),
     o3(0xE9,0xA6,0xB4), o3(0xE7,0xB8,0x84),
     o3(0xE7,0x95,0xB7), o3(0xE5,0x8D,0x97),
     o3(0xE6,0xA5,0xA0), o3(0xE8,0xBB,0x9F),
     o3(0xE9,0x9B,0xA3), o3(0xE6,0xB1,0x9D),
     o3(0xE4,0xBA,0x8C), o3(0xE5,0xB0,0xBC),
     o3(0xE5,0xBC,0x90), o3(0xE8,0xBF,0xA9),
     o3(0xE5,0x8C,0x82), o3(0xE8,0xB3,0x91),
     o3(0xE8,0x82,0x89), o3(0xE8,0x99,0xB9),
     o3(0xE5,0xBB,0xBF), o3(0xE6,0x97,0xA5),
     o3(0xE4,0xB9,0xB3), o3(0xE5,0x85,0xA5),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_93 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_93_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_94_infos[189] = {
     o3(0xE5,0xA6,0x82), o3(0xE5,0xB0,0xBF),
     o3(0xE9,0x9F,0xAE), o3(0xE4,0xBB,0xBB),
     o3(0xE5,0xA6,0x8A), o3(0xE5,0xBF,0x8D),
     o3(0xE8,0xAA,0x8D), o3(0xE6,0xBF,0xA1),
     o3(0xE7,0xA6,0xB0), o3(0xE7,0xA5,0xA2),
     o3(0xE5,0xAF,0xA7), o3(0xE8,0x91,0xB1),
     o3(0xE7,0x8C,0xAB), o3(0xE7,0x86,0xB1),
     o3(0xE5,0xB9,0xB4), o3(0xE5,0xBF,0xB5),
     o3(0xE6,0x8D,0xBB), o3(0xE6,0x92,0x9A),
     o3(0xE7,0x87,0x83), o3(0xE7,0xB2,0x98),
     o3(0xE4,0xB9,0x83), o3(0xE5,0xBB,0xBC),
     o3(0xE4,0xB9,0x8B), o3(0xE5,0x9F,0x9C),
     o3(0xE5,0x9A,0xA2), o3(0xE6,0x82,0xA9),
     o3(0xE6,0xBF,0x83), o3(0xE7,0xB4,0x8D),
     o3(0xE8,0x83,0xBD), o3(0xE8,0x84,0xB3),
     o3(0xE8,0x86,0xBF), o3(0xE8,0xBE,0xB2),
     o3(0xE8,0xA6,0x97), o3(0xE8,0x9A,0xA4),
     o3(0xE5,0xB7,0xB4), o3(0xE6,0x8A,0x8A),
     o3(0xE6,0x92,0xAD), o3(0xE8,0xA6,0x87),
     o3(0xE6,0x9D,0xB7), o3(0xE6,0xB3,0xA2),
     o3(0xE6,0xB4,0xBE), o3(0xE7,0x90,0xB6),
     o3(0xE7,0xA0,0xB4), o3(0xE5,0xA9,0x86),
     o3(0xE7,0xBD,0xB5), o3(0xE8,0x8A,0xAD),
     o3(0xE9,0xA6,0xAC), o3(0xE4,0xBF,0xB3),
     o3(0xE5,0xBB,0x83), o3(0xE6,0x8B,0x9D),
     o3(0xE6,0x8E,0x92), o3(0xE6,0x95,0x97),
     o3(0xE6,0x9D,0xAF), o3(0xE7,0x9B,0x83),
     o3(0xE7,0x89,0x8C), o3(0xE8,0x83,0x8C),
     o3(0xE8,0x82,0xBA), o3(0xE8,0xBC,0xA9),
     o3(0xE9,0x85,0x8D), o3(0xE5,0x80,0x8D),
     o3(0xE5,0x9F,0xB9), o3(0xE5,0xAA,0x92),
     o3(0xE6,0xA2,0x85), o3(0xE6,0xA5,0xB3),
     o3(0xE7,0x85,0xA4), o3(0xE7,0x8B,0xBD),
     o3(0xE8,0xB2,0xB7), o3(0xE5,0xA3,0xB2),
     o3(0xE8,0xB3,0xA0), o3(0xE9,0x99,0xAA),
     o3(0xE9,0x80,0x99), o3(0xE8,0x9D,0xBF),
     o3(0xE7,0xA7,0xA4), o3(0xE7,0x9F,0xA7),
     o3(0xE8,0x90,0xA9), o3(0xE4,0xBC,0xAF),
     o3(0xE5,0x89,0xA5), o3(0xE5,0x8D,0x9A),
     o3(0xE6,0x8B,0x8D), o3(0xE6,0x9F,0x8F),
     o3(0xE6,0xB3,0x8A), o3(0xE7,0x99,0xBD),
     o3(0xE7,0xAE,0x94), o3(0xE7,0xB2,0x95),
     o3(0xE8,0x88,0xB6), o3(0xE8,0x96,0x84),
     o3(0xE8,0xBF,0xAB), o3(0xE6,0x9B,0x9D),
     o3(0xE6,0xBC,0xA0), o3(0xE7,0x88,0x86),
     o3(0xE7,0xB8,0x9B), o3(0xE8,0x8E,0xAB),
     o3(0xE9,0xA7,0x81), o3(0xE9,0xBA,0xA6),
     o3(0xE5,0x87,0xBD), o3(0xE7,0xAE,0xB1),
     o3(0xE7,0xA1,0xB2), o3(0xE7,0xAE,0xB8),
     o3(0xE8,0x82,0x87), o3(0xE7,0xAD,0x88),
     o3(0xE6,0xAB,0xA8), o3(0xE5,0xB9,0xA1),
     o3(0xE8,0x82,0x8C), o3(0xE7,0x95,0x91),
     o3(0xE7,0x95,0xA0), o3(0xE5,0x85,0xAB),
     o3(0xE9,0x89,0xA2), o3(0xE6,0xBA,0x8C),
     o3(0xE7,0x99,0xBA), o3(0xE9,0x86,0x97),
     o3(0xE9,0xAB,0xAA), o3(0xE4,0xBC,0x90),
     o3(0xE7,0xBD,0xB0), o3(0xE6,0x8A,0x9C),
     o3(0xE7,0xAD,0x8F), o3(0xE9,0x96,0xA5),
     o3(0xE9,0xB3,0xA9), o3(0xE5,0x99,0xBA),
     o3(0xE5,0xA1,0x99), o3(0xE8,0x9B,0xA4),
     o3(0xE9,0x9A,0xBC), o3(0xE4,0xBC,0xB4),
     o3(0xE5,0x88,0xA4), o3(0xE5,0x8D,0x8A),
     o3(0xE5,0x8F,0x8D), o3(0xE5,0x8F,0x9B),
     o3(0xE5,0xB8,0x86), o3(0xE6,0x90,0xAC),
     o3(0xE6,0x96,0x91), o3(0xE6,0x9D,0xBF),
     o3(0xE6,0xB0,0xBE), o3(0xE6,0xB1,0x8E),
     o3(0xE7,0x89,0x88), o3(0xE7,0x8A,0xAF),
     o3(0xE7,0x8F,0xAD), o3(0xE7,0x95,0x94),
     o3(0xE7,0xB9,0x81), o3(0xE8,0x88,0xAC),
     o3(0xE8,0x97,0xA9), o3(0xE8,0xB2,0xA9),
     o3(0xE7,0xAF,0x84), o3(0xE9,0x87,0x86),
     o3(0xE7,0x85,0xA9), o3(0xE9,0xA0,0x92),
     o3(0xE9,0xA3,0xAF), o3(0xE6,0x8C,0xBD),
     o3(0xE6,0x99,0xA9), o3(0xE7,0x95,0xAA),
     o3(0xE7,0x9B,0xA4), o3(0xE7,0xA3,0x90),
     o3(0xE8,0x95,0x83), o3(0xE8,0x9B,0xAE),
     o3(0xE5,0x8C,0xAA), o3(0xE5,0x8D,0x91),
     o3(0xE5,0x90,0xA6), o3(0xE5,0xA6,0x83),
     o3(0xE5,0xBA,0x87), o3(0xE5,0xBD,0xBC),
     o3(0xE6,0x82,0xB2), o3(0xE6,0x89,0x89),
     o3(0xE6,0x89,0xB9), o3(0xE6,0x8A,0xAB),
     o3(0xE6,0x96,0x90), o3(0xE6,0xAF,0x94),
     o3(0xE6,0xB3,0x8C), o3(0xE7,0x96,0xB2),
     o3(0xE7,0x9A,0xAE), o3(0xE7,0xA2,0x91),
     o3(0xE7,0xA7,0x98), o3(0xE7,0xB7,0x8B),
     o3(0xE7,0xBD,0xB7), o3(0xE8,0x82,0xA5),
     o3(0xE8,0xA2,0xAB), o3(0xE8,0xAA,0xB9),
     o3(0xE8,0xB2,0xBB), o3(0xE9,0x81,0xBF),
     o3(0xE9,0x9D,0x9E), o3(0xE9,0xA3,0x9B),
     o3(0xE6,0xA8,0x8B), o3(0xE7,0xB0,0xB8),
     o3(0xE5,0x82,0x99), o3(0xE5,0xB0,0xBE),
     o3(0xE5,0xBE,0xAE), o3(0xE6,0x9E,0x87),
     o3(0xE6,0xAF,0x98), o3(0xE7,0x90,0xB5),
     o3(0xE7,0x9C,0x89), o3(0xE7,0xBE,0x8E),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_94 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_94_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_95_infos[189] = {
     o3(0xE9,0xBC,0xBB), o3(0xE6,0x9F,0x8A),
     o3(0xE7,0xA8,0x97), o3(0xE5,0x8C,0xB9),
     o3(0xE7,0x96,0x8B), o3(0xE9,0xAB,0xAD),
     o3(0xE5,0xBD,0xA6), o3(0xE8,0x86,0x9D),
     o3(0xE8,0x8F,0xB1), o3(0xE8,0x82,0x98),
     o3(0xE5,0xBC,0xBC), o3(0xE5,0xBF,0x85),
     o3(0xE7,0x95,0xA2), o3(0xE7,0xAD,0x86),
     o3(0xE9,0x80,0xBC), o3(0xE6,0xA1,0xA7),
     o3(0xE5,0xA7,0xAB), o3(0xE5,0xAA,0x9B),
     o3(0xE7,0xB4,0x90), o3(0xE7,0x99,0xBE),
     o3(0xE8,0xAC,0xAC), o3(0xE4,0xBF,0xB5),
     o3(0xE5,0xBD,0xAA), o3(0xE6,0xA8,0x99),
     o3(0xE6,0xB0,0xB7), o3(0xE6,0xBC,0x82),
     o3(0xE7,0x93,0xA2), o3(0xE7,0xA5,0xA8),
     o3(0xE8,0xA1,0xA8), o3(0xE8,0xA9,0x95),
     o3(0xE8,0xB1,0xB9), o3(0xE5,0xBB,0x9F),
     o3(0xE6,0x8F,0x8F), o3(0xE7,0x97,0x85),
     o3(0xE7,0xA7,0x92), o3(0xE8,0x8B,0x97),
     o3(0xE9,0x8C,0xA8), o3(0xE9,0x8B,0xB2),
     o3(0xE8,0x92,0x9C), o3(0xE8,0x9B,0xAD),
     o3(0xE9,0xB0,0xAD), o3(0xE5,0x93,0x81),
     o3(0xE5,0xBD,0xAC), o3(0xE6,0x96,0x8C),
     o3(0xE6,0xB5,0x9C), o3(0xE7,0x80,0x95),
     o3(0xE8,0xB2,0xA7), o3(0xE8,0xB3,0x93),
     o3(0xE9,0xA0,0xBB), o3(0xE6,0x95,0x8F),
     o3(0xE7,0x93,0xB6), o3(0xE4,0xB8,0x8D),
     o3(0xE4,0xBB,0x98), o3(0xE5,0x9F,0xA0),
     o3(0xE5,0xA4,0xAB), o3(0xE5,0xA9,0xA6),
     o3(0xE5,0xAF,0x8C), o3(0xE5,0x86,0xA8),
     o3(0xE5,0xB8,0x83), o3(0xE5,0xBA,0x9C),
     o3(0xE6,0x80,0x96), o3(0xE6,0x89,0xB6),
     o3(0xE6,0x95,0xB7), o3(0xE6,0x96,0xA7),
     o3(0xE6,0x99,0xAE), o3(0xE6,0xB5,0xAE),
     o3(0xE7,0x88,0xB6), o3(0xE7,0xAC,0xA6),
     o3(0xE8,0x85,0x90), o3(0xE8,0x86,0x9A),
     o3(0xE8,0x8A,0x99), o3(0xE8,0xAD,0x9C),
     o3(0xE8,0xB2,0xA0), o3(0xE8,0xB3,0xA6),
     o3(0xE8,0xB5,0xB4), o3(0xE9,0x98,0x9C),
     o3(0xE9,0x99,0x84), o3(0xE4,0xBE,0xAE),
     o3(0xE6,0x92,0xAB), o3(0xE6,0xAD,0xA6),
     o3(0xE8,0x88,0x9E), o3(0xE8,0x91,0xA1),
     o3(0xE8,0x95,0xAA), o3(0xE9,0x83,0xA8),
     o3(0xE5,0xB0,0x81), o3(0xE6,0xA5,0x93),
     o3(0xE9,0xA2,0xA8), o3(0xE8,0x91,0xBA),
     o3(0xE8,0x95,0x97), o3(0xE4,0xBC,0x8F),
     o3(0xE5,0x89,0xAF), o3(0xE5,0xBE,0xA9),
     o3(0xE5,0xB9,0x85), o3(0xE6,0x9C,0x8D),
     o3(0xE7,0xA6,0x8F), o3(0xE8,0x85,0xB9),
     o3(0xE8,0xA4,0x87), o3(0xE8,0xA6,0x86),
     o3(0xE6,0xB7,0xB5), o3(0xE5,0xBC,0x97),
     o3(0xE6,0x89,0x95), o3(0xE6,0xB2,0xB8),
     o3(0xE4,0xBB,0x8F), o3(0xE7,0x89,0xA9),
     o3(0xE9,0xAE,0x92), o3(0xE5,0x88,0x86),
     o3(0xE5,0x90,0xBB), o3(0xE5,0x99,0xB4),
     o3(0xE5,0xA2,0xB3), o3(0xE6,0x86,0xA4),
     o3(0xE6,0x89,0xAE), o3(0xE7,0x84,0x9A),
     o3(0xE5,0xA5,0xAE), o3(0xE7,0xB2,0x89),
     o3(0xE7,0xB3,0x9E), o3(0xE7,0xB4,0x9B),
     o3(0xE9,0x9B,0xB0), o3(0xE6,0x96,0x87),
     o3(0xE8,0x81,0x9E), o3(0xE4,0xB8,0x99),
     o3(0xE4,0xBD,0xB5), o3(0xE5,0x85,0xB5),
     o3(0xE5,0xA1,0x80), o3(0xE5,0xB9,0xA3),
     o3(0xE5,0xB9,0xB3), o3(0xE5,0xBC,0x8A),
     o3(0xE6,0x9F,0x84), o3(0xE4,0xB8,0xA6),
     o3(0xE8,0x94,0xBD), o3(0xE9,0x96,0x89),
     o3(0xE9,0x99,0x9B), o3(0xE7,0xB1,0xB3),
     o3(0xE9,0xA0,0x81), o3(0xE5,0x83,0xBB),
     o3(0xE5,0xA3,0x81), o3(0xE7,0x99,0x96),
     o3(0xE7,0xA2,0xA7), o3(0xE5,0x88,0xA5),
     o3(0xE7,0x9E,0xA5), o3(0xE8,0x94,0x91),
     o3(0xE7,0xAE,0x86), o3(0xE5,0x81,0x8F),
     o3(0xE5,0xA4,0x89), o3(0xE7,0x89,0x87),
     o3(0xE7,0xAF,0x87), o3(0xE7,0xB7,0xA8),
     o3(0xE8,0xBE,0xBA), o3(0xE8,0xBF,0x94),
     o3(0xE9,0x81,0x8D), o3(0xE4,0xBE,0xBF),
     o3(0xE5,0x8B,0x89), o3(0xE5,0xA8,0xA9),
     o3(0xE5,0xBC,0x81), o3(0xE9,0x9E,0xAD),
     o3(0xE4,0xBF,0x9D), o3(0xE8,0x88,0x97),
     o3(0xE9,0x8B,0xAA), o3(0xE5,0x9C,0x83),
     o3(0xE6,0x8D,0x95), o3(0xE6,0xAD,0xA9),
     o3(0xE7,0x94,0xAB), o3(0xE8,0xA3,0x9C),
     o3(0xE8,0xBC,0x94), o3(0xE7,0xA9,0x82),
     o3(0xE5,0x8B,0x9F), o3(0xE5,0xA2,0x93),
     o3(0xE6,0x85,0x95), o3(0xE6,0x88,0x8A),
     o3(0xE6,0x9A,0xAE), o3(0xE6,0xAF,0x8D),
     o3(0xE7,0xB0,0xBF), o3(0xE8,0x8F,0xA9),
     o3(0xE5,0x80,0xA3), o3(0xE4,0xBF,0xB8),
     o3(0xE5,0x8C,0x85), o3(0xE5,0x91,0x86),
     o3(0xE5,0xA0,0xB1), o3(0xE5,0xA5,0x89),
     o3(0xE5,0xAE,0x9D), o3(0xE5,0xB3,0xB0),
     o3(0xE5,0xB3,0xAF), o3(0xE5,0xB4,0xA9),
     o3(0xE5,0xBA,0x96), o3(0xE6,0x8A,0xB1),
     o3(0xE6,0x8D,0xA7), o3(0xE6,0x94,0xBE),
     o3(0xE6,0x96,0xB9), o3(0xE6,0x9C,0x8B),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_95 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_95_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_96_infos[189] = {
     o3(0xE6,0xB3,0x95), o3(0xE6,0xB3,0xA1),
     o3(0xE7,0x83,0xB9), o3(0xE7,0xA0,0xB2),
     o3(0xE7,0xB8,0xAB), o3(0xE8,0x83,0x9E),
     o3(0xE8,0x8A,0xB3), o3(0xE8,0x90,0x8C),
     o3(0xE8,0x93,0xAC), o3(0xE8,0x9C,0x82),
     o3(0xE8,0xA4,0x92), o3(0xE8,0xA8,0xAA),
     o3(0xE8,0xB1,0x8A), o3(0xE9,0x82,0xA6),
     o3(0xE9,0x8B,0x92), o3(0xE9,0xA3,0xBD),
     o3(0xE9,0xB3,0xB3), o3(0xE9,0xB5,0xAC),
     o3(0xE4,0xB9,0x8F), o3(0xE4,0xBA,0xA1),
     o3(0xE5,0x82,0x8D), o3(0xE5,0x89,0x96),
     o3(0xE5,0x9D,0x8A), o3(0xE5,0xA6,0xA8),
     o3(0xE5,0xB8,0xBD), o3(0xE5,0xBF,0x98),
     o3(0xE5,0xBF,0x99), o3(0xE6,0x88,0xBF),
     o3(0xE6,0x9A,0xB4), o3(0xE6,0x9C,0x9B),
     o3(0xE6,0x9F,0x90), o3(0xE6,0xA3,0x92),
     o3(0xE5,0x86,0x92), o3(0xE7,0xB4,0xA1),
     o3(0xE8,0x82,0xAA), o3(0xE8,0x86,0xA8),
     o3(0xE8,0xAC,0x80), o3(0xE8,0xB2,0x8C),
     o3(0xE8,0xB2,0xBF), o3(0xE9,0x89,0xBE),
     o3(0xE9,0x98,0xB2), o3(0xE5,0x90,0xA0),
     o3(0xE9,0xA0,0xAC), o3(0xE5,0x8C,0x97),
     o3(0xE5,0x83,0x95), o3(0xE5,0x8D,0x9C),
     o3(0xE5,0xA2,0xA8), o3(0xE6,0x92,0xB2),
     o3(0xE6,0x9C,0xB4), o3(0xE7,0x89,0xA7),
     o3(0xE7,0x9D,0xA6), o3(0xE7,0xA9,0x86),
     o3(0xE9,0x87,0xA6), o3(0xE5,0x8B,0x83),
     o3(0xE6,0xB2,0xA1), o3(0xE6,0xAE,0x86),
     o3(0xE5,0xA0,0x80), o3(0xE5,0xB9,0x8C),
     o3(0xE5,0xA5,0x94), o3(0xE6,0x9C,0xAC),
     o3(0xE7,0xBF,0xBB), o3(0xE5,0x87,0xA1),
     o3(0xE7,0x9B,0x86), o3(0xE6,0x91,0xA9),
     o3(0xE7,0xA3,0xA8), o3(0xE9,0xAD,0x94),
     o3(0xE9,0xBA,0xBB), o3(0xE5,0x9F,0x8B),
     o3(0xE5,0xA6,0xB9), o3(0xE6,0x98,0xA7),
     o3(0xE6,0x9E,0x9A), o3(0xE6,0xAF,0x8E),
     o3(0xE5,0x93,0xA9), o3(0xE6,0xA7,0x99),
     o3(0xE5,0xB9,0x95), o3(0xE8,0x86,0x9C),
     o3(0xE6,0x9E,0x95), o3(0xE9,0xAE,0xAA),
     o3(0xE6,0x9F,0xBE), o3(0xE9,0xB1,0x92),
     o3(0xE6,0xA1,0x9D), o3(0xE4,0xBA,0xA6),
     o3(0xE4,0xBF,0xA3), o3(0xE5,0x8F,0x88),
     o3(0xE6,0x8A,0xB9), o3(0xE6,0x9C,0xAB),
     o3(0xE6,0xB2,0xAB), o3(0xE8,0xBF,0x84),
     o3(0xE4,0xBE,0xAD), o3(0xE7,0xB9,0xAD),
     o3(0xE9,0xBA,0xBF), o3(0xE4,0xB8,0x87),
     o3(0xE6,0x85,0xA2), o3(0xE6,0xBA,0x80),
     o3(0xE6,0xBC,0xAB), o3(0xE8,0x94,0x93),
     o3(0xE5,0x91,0xB3), o3(0xE6,0x9C,0xAA),
     o3(0xE9,0xAD,0x85), o3(0xE5,0xB7,0xB3),
     o3(0xE7,0xAE,0x95), o3(0xE5,0xB2,0xAC),
     o3(0xE5,0xAF,0x86), o3(0xE8,0x9C,0x9C),
     o3(0xE6,0xB9,0x8A), o3(0xE8,0x93,0x91),
     o3(0xE7,0xA8,0x94), o3(0xE8,0x84,0x88),
     o3(0xE5,0xA6,0x99), o3(0xE7,0xB2,0x8D),
     o3(0xE6,0xB0,0x91), o3(0xE7,0x9C,0xA0),
     o3(0xE5,0x8B,0x99), o3(0xE5,0xA4,0xA2),
     o3(0xE7,0x84,0xA1), o3(0xE7,0x89,0x9F),
     o3(0xE7,0x9F,0x9B), o3(0xE9,0x9C,0xA7),
     o3(0xE9,0xB5,0xA1), o3(0xE6,0xA4,0x8B),
     o3(0xE5,0xA9,0xBF), o3(0xE5,0xA8,0x98),
     o3(0xE5,0x86,0xA5), o3(0xE5,0x90,0x8D),
     o3(0xE5,0x91,0xBD), o3(0xE6,0x98,0x8E),
     o3(0xE7,0x9B,0x9F), o3(0xE8,0xBF,0xB7),
     o3(0xE9,0x8A,0x98), o3(0xE9,0xB3,0xB4),
     o3(0xE5,0xA7,0xAA), o3(0xE7,0x89,0x9D),
     o3(0xE6,0xBB,0x85), o3(0xE5,0x85,0x8D),
     o3(0xE6,0xA3,0x89), o3(0xE7,0xB6,0xBF),
     o3(0xE7,0xB7,0xAC), o3(0xE9,0x9D,0xA2),
     o3(0xE9,0xBA,0xBA), o3(0xE6,0x91,0xB8),
     o3(0xE6,0xA8,0xA1), o3(0xE8,0x8C,0x82),
     o3(0xE5,0xA6,0x84), o3(0xE5,0xAD,0x9F),
     o3(0xE6,0xAF,0x9B), o3(0xE7,0x8C,0x9B),
     o3(0xE7,0x9B,0xB2), o3(0xE7,0xB6,0xB2),
     o3(0xE8,0x80,0x97), o3(0xE8,0x92,0x99),
     o3(0xE5,0x84,0xB2), o3(0xE6,0x9C,0xA8),
     o3(0xE9,0xBB,0x99), o3(0xE7,0x9B,0xAE),
     o3(0xE6,0x9D,0xA2), o3(0xE5,0x8B,0xBF),
     o3(0xE9,0xA4,0x85), o3(0xE5,0xB0,0xA4),
     o3(0xE6,0x88,0xBB), o3(0xE7,0xB1,0xBE),
     o3(0xE8,0xB2,0xB0), o3(0xE5,0x95,0x8F),
     o3(0xE6,0x82,0xB6), o3(0xE7,0xB4,0x8B),
     o3(0xE9,0x96,0x80), o3(0xE5,0x8C,0x81),
     o3(0xE4,0xB9,0x9F), o3(0xE5,0x86,0xB6),
     o3(0xE5,0xA4,0x9C), o3(0xE7,0x88,0xBA),
     o3(0xE8,0x80,0xB6), o3(0xE9,0x87,0x8E),
     o3(0xE5,0xBC,0xA5), o3(0xE7,0x9F,0xA2),
     o3(0xE5,0x8E,0x84), o3(0xE5,0xBD,0xB9),
     o3(0xE7,0xB4,0x84), o3(0xE8,0x96,0xAC),
     o3(0xE8,0xA8,0xB3), o3(0xE8,0xBA,0x8D),
     o3(0xE9,0x9D,0x96), o3(0xE6,0x9F,0xB3),
     o3(0xE8,0x96,0xAE), o3(0xE9,0x91,0x93),
     o3(0xE6,0x84,0x89), o3(0xE6,0x84,0x88),
     o3(0xE6,0xB2,0xB9), o3(0xE7,0x99,0x92),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_96 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_96_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_97_infos[189] = {
     o3(0xE8,0xAB,0xAD), o3(0xE8,0xBC,0xB8),
     o3(0xE5,0x94,0xAF), o3(0xE4,0xBD,0x91),
     o3(0xE5,0x84,0xAA), o3(0xE5,0x8B,0x87),
     o3(0xE5,0x8F,0x8B), o3(0xE5,0xAE,0xA5),
     o3(0xE5,0xB9,0xBD), o3(0xE6,0x82,0xA0),
     o3(0xE6,0x86,0x82), o3(0xE6,0x8F,0x96),
     o3(0xE6,0x9C,0x89), o3(0xE6,0x9F,0x9A),
     o3(0xE6,0xB9,0xA7), o3(0xE6,0xB6,0x8C),
     o3(0xE7,0x8C,0xB6), o3(0xE7,0x8C,0xB7),
     o3(0xE7,0x94,0xB1), o3(0xE7,0xA5,0x90),
     o3(0xE8,0xA3,0x95), o3(0xE8,0xAA,0x98),
     o3(0xE9,0x81,0x8A), o3(0xE9,0x82,0x91),
     o3(0xE9,0x83,0xB5), o3(0xE9,0x9B,0x84),
     o3(0xE8,0x9E,0x8D), o3(0xE5,0xA4,0x95),
     o3(0xE4,0xBA,0x88), o3(0xE4,0xBD,0x99),
     o3(0xE4,0xB8,0x8E), o3(0xE8,0xAA,0x89),
     o3(0xE8,0xBC,0xBF), o3(0xE9,0xA0,0x90),
     o3(0xE5,0x82,0xAD), o3(0xE5,0xB9,0xBC),
     o3(0xE5,0xA6,0x96), o3(0xE5,0xAE,0xB9),
     o3(0xE5,0xBA,0xB8), o3(0xE6,0x8F,0x9A),
     o3(0xE6,0x8F,0xBA), o3(0xE6,0x93,0x81),
     o3(0xE6,0x9B,0x9C), o3(0xE6,0xA5,0x8A),
     o3(0xE6,0xA7,0x98), o3(0xE6,0xB4,0x8B),
     o3(0xE6,0xBA,0xB6), o3(0xE7,0x86,0x94),
     o3(0xE7,0x94,0xA8), o3(0xE7,0xAA,0xAF),
     o3(0xE7,0xBE,0x8A), o3(0xE8,0x80,0x80),
     o3(0xE8,0x91,0x89), o3(0xE8,0x93,0x89),
     o3(0xE8,0xA6,0x81), o3(0xE8,0xAC,0xA1),
     o3(0xE8,0xB8,0x8A), o3(0xE9,0x81,0xA5),
     o3(0xE9,0x99,0xBD), o3(0xE9,0xA4,0x8A),
     o3(0xE6,0x85,0xBE), o3(0xE6,0x8A,0x91),
     o3(0xE6,0xAC,0xB2), o3(0xE6,0xB2,0x83),
     o3(0xE6,0xB5,0xB4), o3(0xE7,0xBF,0x8C),
     o3(0xE7,0xBF,0xBC), o3(0xE6,0xB7,0x80),
     o3(0xE7,0xBE,0x85), o3(0xE8,0x9E,0xBA),
     o3(0xE8,0xA3,0xB8), o3(0xE6,0x9D,0xA5),
     o3(0xE8,0x8E,0xB1), o3(0xE9,0xA0,0xBC),
     o3(0xE9,0x9B,0xB7), o3(0xE6,0xB4,0x9B),
     o3(0xE7,0xB5,0xA1), o3(0xE8,0x90,0xBD),
     o3(0xE9,0x85,0xAA), o3(0xE4,0xB9,0xB1),
     o3(0xE5,0x8D,0xB5), o3(0xE5,0xB5,0x90),
     o3(0xE6,0xAC,0x84), o3(0xE6,0xBF,0xAB),
     o3(0xE8,0x97,0x8D), o3(0xE8,0x98,0xAD),
     o3(0xE8,0xA6,0xA7), o3(0xE5,0x88,0xA9),
     o3(0xE5,0x90,0x8F), o3(0xE5,0xB1,0xA5),
     o3(0xE6,0x9D,0x8E), o3(0xE6,0xA2,0xA8),
     o3(0xE7,0x90,0x86), o3(0xE7,0x92,0x83),
     o3(0xE7,0x97,0xA2), o3(0xE8,0xA3,0x8F),
     o3(0xE8,0xA3,0xA1), o3(0xE9,0x87,0x8C),
     o3(0xE9,0x9B,0xA2), o3(0xE9,0x99,0xB8),
     o3(0xE5,0xBE,0x8B), o3(0xE7,0x8E,0x87),
     o3(0xE7,0xAB,0x8B), o3(0xE8,0x91,0x8E),
     o3(0xE6,0x8E,0xA0), o3(0xE7,0x95,0xA5),
     o3(0xE5,0x8A,0x89), o3(0xE6,0xB5,0x81),
     o3(0xE6,0xBA,0x9C), o3(0xE7,0x90,0x89),
     o3(0xE7,0x95,0x99), o3(0xE7,0xA1,0xAB),
     o3(0xE7,0xB2,0x92), o3(0xE9,0x9A,0x86),
     o3(0xE7,0xAB,0x9C), o3(0xE9,0xBE,0x8D),
     o3(0xE4,0xBE,0xB6), o3(0xE6,0x85,0xAE),
     o3(0xE6,0x97,0x85), o3(0xE8,0x99,0x9C),
     o3(0xE4,0xBA,0x86), o3(0xE4,0xBA,0xAE),
     o3(0xE5,0x83,0x9A), o3(0xE4,0xB8,0xA1),
     o3(0xE5,0x87,0x8C), o3(0xE5,0xAF,0xAE),
     o3(0xE6,0x96,0x99), o3(0xE6,0xA2,0x81),
     o3(0xE6,0xB6,0xBC), o3(0xE7,0x8C,0x9F),
     o3(0xE7,0x99,0x82), o3(0xE7,0x9E,0xAD),
     o3(0xE7,0xA8,0x9C), o3(0xE7,0xB3,0xA7),
     o3(0xE8,0x89,0xAF), o3(0xE8,0xAB,0x92),
     o3(0xE9,0x81,0xBC), o3(0xE9,0x87,0x8F),
     o3(0xE9,0x99,0xB5), o3(0xE9,0xA0,0x98),
     o3(0xE5,0x8A,0x9B), o3(0xE7,0xB7,0x91),
     o3(0xE5,0x80,0xAB), o3(0xE5,0x8E,0x98),
     o3(0xE6,0x9E,0x97), o3(0xE6,0xB7,0x8B),
     o3(0xE7,0x87,0x90), o3(0xE7,0x90,0xB3),
     o3(0xE8,0x87,0xA8), o3(0xE8,0xBC,0xAA),
     o3(0xE9,0x9A,0xA3), o3(0xE9,0xB1,0x97),
     o3(0xE9,0xBA,0x9F), o3(0xE7,0x91,0xA0),
     o3(0xE5,0xA1,0x81), o3(0xE6,0xB6,0x99),
     o3(0xE7,0xB4,0xAF), o3(0xE9,0xA1,0x9E),
     o3(0xE4,0xBB,0xA4), o3(0xE4,0xBC,0xB6),
     o3(0xE4,0xBE,0x8B), o3(0xE5,0x86,0xB7),
     o3(0xE5,0x8A,0xB1), o3(0xE5,0xB6,0xBA),
     o3(0xE6,0x80,0x9C), o3(0xE7,0x8E,0xB2),
     o3(0xE7,0xA4,0xBC), o3(0xE8,0x8B,0x93),
     o3(0xE9,0x88,0xB4), o3(0xE9,0x9A,0xB7),
     o3(0xE9,0x9B,0xB6), o3(0xE9,0x9C,0x8A),
     o3(0xE9,0xBA,0x97), o3(0xE9,0xBD,0xA2),
     o3(0xE6,0x9A,0xA6), o3(0xE6,0xAD,0xB4),
     o3(0xE5,0x88,0x97), o3(0xE5,0x8A,0xA3),
     o3(0xE7,0x83,0x88), o3(0xE8,0xA3,0x82),
     o3(0xE5,0xBB,0x89), o3(0xE6,0x81,0x8B),
     o3(0xE6,0x86,0x90), o3(0xE6,0xBC,0xA3),
     o3(0xE7,0x85,0x89), o3(0xE7,0xB0,0xBE),
     o3(0xE7,0xB7,0xB4), o3(0xE8,0x81,0xAF),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_97 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_97_infos
};

static const unsigned char
from_SHIFT_JIS_98_offsets[256] = {
    145,145,145,145,145,145,145,145,  145,145,145,145,145,145,145,145,
    145,145,145,145,145,145,145,145,  145,145,145,145,145,145,145,145,
    145,145,145,145,145,145,145,145,  145,145,145,145,145,145,145,145,
    145,145,145,145,145,145,145,145,  145,145,145,145,145,145,145,145,
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,   24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39,   40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50,145,145,145,145,145,  145,145,145,145,145,145,145,145,
    145,145,145,145,145,145,145,145,  145,145,145,145,145,145,145,145,
    145,145,145,145,145,145,145,145,  145,145,145,145,145,145,145, 51,
     52, 53, 54, 55, 56, 57, 58, 59,   60, 61, 62, 63, 64, 65, 66, 67,
     68, 69, 70, 71, 72, 73, 74, 75,   76, 77, 78, 79, 80, 81, 82, 83,
     84, 85, 86, 87, 88, 89, 90, 91,   92, 93, 94, 95, 96, 97, 98, 99,
    100,101,102,103,104,105,106,107,  108,109,110,111,112,113,114,115,
    116,117,118,119,120,121,122,123,  124,125,126,127,128,129,130,131,
    132,133,134,135,136,137,138,139,  140,141,142,143,144,145,145,145,
};
static const struct byte_lookup* const
from_SHIFT_JIS_98_infos[146] = {
     o3(0xE8,0x93,0xAE), o3(0xE9,0x80,0xA3),
     o3(0xE9,0x8C,0xAC), o3(0xE5,0x91,0x82),
     o3(0xE9,0xAD,0xAF), o3(0xE6,0xAB,0x93),
     o3(0xE7,0x82,0x89), o3(0xE8,0xB3,0x82),
     o3(0xE8,0xB7,0xAF), o3(0xE9,0x9C,0xB2),
     o3(0xE5,0x8A,0xB4), o3(0xE5,0xA9,0x81),
     o3(0xE5,0xBB,0x8A), o3(0xE5,0xBC,0x84),
     o3(0xE6,0x9C,0x97), o3(0xE6,0xA5,0xBC),
     o3(0xE6,0xA6,0x94), o3(0xE6,0xB5,0xAA),
     o3(0xE6,0xBC,0x8F), o3(0xE7,0x89,0xA2),
     o3(0xE7,0x8B,0xBC), o3(0xE7,0xAF,0xAD),
     o3(0xE8,0x80,0x81), o3(0xE8,0x81,0xBE),
     o3(0xE8,0x9D,0x8B), o3(0xE9,0x83,0x8E),
     o3(0xE5,0x85,0xAD), o3(0xE9,0xBA,0x93),
     o3(0xE7,0xA6,0x84), o3(0xE8,0x82,0x8B),
     o3(0xE9,0x8C,0xB2), o3(0xE8,0xAB,0x96),
     o3(0xE5,0x80,0xAD), o3(0xE5,0x92,0x8C),
     o3(0xE8,0xA9,0xB1), o3(0xE6,0xAD,0xAA),
     o3(0xE8,0xB3,0x84), o3(0xE8,0x84,0x87),
     o3(0xE6,0x83,0x91), o3(0xE6,0x9E,0xA0),
     o3(0xE9,0xB7,0xB2), o3(0xE4,0xBA,0x99),
     o3(0xE4,0xBA,0x98), o3(0xE9,0xB0,0x90),
     o3(0xE8,0xA9,0xAB), o3(0xE8,0x97,0x81),
     o3(0xE8,0x95,0xA8), o3(0xE6,0xA4,0x80),
     o3(0xE6,0xB9,0xBE), o3(0xE7,0xA2,0x97),
     o3(0xE8,0x85,0x95), o3(0xE5,0xBC,0x8C),
     o3(0xE4,0xB8,0x90), o3(0xE4,0xB8,0x95),
     o3(0xE4,0xB8,0xAA), o3(0xE4,0xB8,0xB1),
     o3(0xE4,0xB8,0xB6), o3(0xE4,0xB8,0xBC),
     o3(0xE4,0xB8,0xBF), o3(0xE4,0xB9,0x82),
     o3(0xE4,0xB9,0x96), o3(0xE4,0xB9,0x98),
     o3(0xE4,0xBA,0x82), o3(0xE4,0xBA,0x85),
     o3(0xE8,0xB1,0xAB), o3(0xE4,0xBA,0x8A),
     o3(0xE8,0x88,0x92), o3(0xE5,0xBC,0x8D),
     o3(0xE4,0xBA,0x8E), o3(0xE4,0xBA,0x9E),
     o3(0xE4,0xBA,0x9F), o3(0xE4,0xBA,0xA0),
     o3(0xE4,0xBA,0xA2), o3(0xE4,0xBA,0xB0),
     o3(0xE4,0xBA,0xB3), o3(0xE4,0xBA,0xB6),
     o3(0xE4,0xBB,0x8E), o3(0xE4,0xBB,0x8D),
     o3(0xE4,0xBB,0x84), o3(0xE4,0xBB,0x86),
     o3(0xE4,0xBB,0x82), o3(0xE4,0xBB,0x97),
     o3(0xE4,0xBB,0x9E), o3(0xE4,0xBB,0xAD),
     o3(0xE4,0xBB,0x9F), o3(0xE4,0xBB,0xB7),
     o3(0xE4,0xBC,0x89), o3(0xE4,0xBD,0x9A),
     o3(0xE4,0xBC,0xB0), o3(0xE4,0xBD,0x9B),
     o3(0xE4,0xBD,0x9D), o3(0xE4,0xBD,0x97),
     o3(0xE4,0xBD,0x87), o3(0xE4,0xBD,0xB6),
     o3(0xE4,0xBE,0x88), o3(0xE4,0xBE,0x8F),
     o3(0xE4,0xBE,0x98), o3(0xE4,0xBD,0xBB),
     o3(0xE4,0xBD,0xA9), o3(0xE4,0xBD,0xB0),
     o3(0xE4,0xBE,0x91), o3(0xE4,0xBD,0xAF),
     o3(0xE4,0xBE,0x86), o3(0xE4,0xBE,0x96),
     o3(0xE5,0x84,0x98), o3(0xE4,0xBF,0x94),
     o3(0xE4,0xBF,0x9F), o3(0xE4,0xBF,0x8E),
     o3(0xE4,0xBF,0x98), o3(0xE4,0xBF,0x9B),
     o3(0xE4,0xBF,0x91), o3(0xE4,0xBF,0x9A),
     o3(0xE4,0xBF,0x90), o3(0xE4,0xBF,0xA4),
     o3(0xE4,0xBF,0xA5), o3(0xE5,0x80,0x9A),
     o3(0xE5,0x80,0xA8), o3(0xE5,0x80,0x94),
     o3(0xE5,0x80,0xAA), o3(0xE5,0x80,0xA5),
     o3(0xE5,0x80,0x85), o3(0xE4,0xBC,0x9C),
     o3(0xE4,0xBF,0xB6), o3(0xE5,0x80,0xA1),
     o3(0xE5,0x80,0xA9), o3(0xE5,0x80,0xAC),
     o3(0xE4,0xBF,0xBE), o3(0xE4,0xBF,0xAF),
     o3(0xE5,0x80,0x91), o3(0xE5,0x80,0x86),
     o3(0xE5,0x81,0x83), o3(0xE5,0x81,0x87),
     o3(0xE6,0x9C,0x83), o3(0xE5,0x81,0x95),
     o3(0xE5,0x81,0x90), o3(0xE5,0x81,0x88),
     o3(0xE5,0x81,0x9A), o3(0xE5,0x81,0x96),
     o3(0xE5,0x81,0xAC), o3(0xE5,0x81,0xB8),
     o3(0xE5,0x82,0x80), o3(0xE5,0x82,0x9A),
     o3(0xE5,0x82,0x85), o3(0xE5,0x82,0xB4),
     o3(0xE5,0x82,0xB2),              UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_98 = {
    from_SHIFT_JIS_98_offsets,
    from_SHIFT_JIS_98_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_99_infos[189] = {
     o3(0xE5,0x83,0x89), o3(0xE5,0x83,0x8A),
     o3(0xE5,0x82,0xB3), o3(0xE5,0x83,0x82),
     o3(0xE5,0x83,0x96), o3(0xE5,0x83,0x9E),
     o3(0xE5,0x83,0xA5), o3(0xE5,0x83,0xAD),
     o3(0xE5,0x83,0xA3), o3(0xE5,0x83,0xAE),
     o3(0xE5,0x83,0xB9), o3(0xE5,0x83,0xB5),
     o3(0xE5,0x84,0x89), o3(0xE5,0x84,0x81),
     o3(0xE5,0x84,0x82), o3(0xE5,0x84,0x96),
     o3(0xE5,0x84,0x95), o3(0xE5,0x84,0x94),
     o3(0xE5,0x84,0x9A), o3(0xE5,0x84,0xA1),
     o3(0xE5,0x84,0xBA), o3(0xE5,0x84,0xB7),
     o3(0xE5,0x84,0xBC), o3(0xE5,0x84,0xBB),
     o3(0xE5,0x84,0xBF), o3(0xE5,0x85,0x80),
     o3(0xE5,0x85,0x92), o3(0xE5,0x85,0x8C),
     o3(0xE5,0x85,0x94), o3(0xE5,0x85,0xA2),
     o3(0xE7,0xAB,0xB8), o3(0xE5,0x85,0xA9),
     o3(0xE5,0x85,0xAA), o3(0xE5,0x85,0xAE),
     o3(0xE5,0x86,0x80), o3(0xE5,0x86,0x82),
     o3(0xE5,0x9B,0x98), o3(0xE5,0x86,0x8C),
     o3(0xE5,0x86,0x89), o3(0xE5,0x86,0x8F),
     o3(0xE5,0x86,0x91), o3(0xE5,0x86,0x93),
     o3(0xE5,0x86,0x95), o3(0xE5,0x86,0x96),
     o3(0xE5,0x86,0xA4), o3(0xE5,0x86,0xA6),
     o3(0xE5,0x86,0xA2), o3(0xE5,0x86,0xA9),
     o3(0xE5,0x86,0xAA), o3(0xE5,0x86,0xAB),
     o3(0xE5,0x86,0xB3), o3(0xE5,0x86,0xB1),
     o3(0xE5,0x86,0xB2), o3(0xE5,0x86,0xB0),
     o3(0xE5,0x86,0xB5), o3(0xE5,0x86,0xBD),
     o3(0xE5,0x87,0x85), o3(0xE5,0x87,0x89),
     o3(0xE5,0x87,0x9B), o3(0xE5,0x87,0xA0),
     o3(0xE8,0x99,0x95), o3(0xE5,0x87,0xA9),
     o3(0xE5,0x87,0xAD), o3(0xE5,0x87,0xB0),
     o3(0xE5,0x87,0xB5), o3(0xE5,0x87,0xBE),
     o3(0xE5,0x88,0x84), o3(0xE5,0x88,0x8B),
     o3(0xE5,0x88,0x94), o3(0xE5,0x88,0x8E),
     o3(0xE5,0x88,0xA7), o3(0xE5,0x88,0xAA),
     o3(0xE5,0x88,0xAE), o3(0xE5,0x88,0xB3),
     o3(0xE5,0x88,0xB9), o3(0xE5,0x89,0x8F),
     o3(0xE5,0x89,0x84), o3(0xE5,0x89,0x8B),
     o3(0xE5,0x89,0x8C), o3(0xE5,0x89,0x9E),
     o3(0xE5,0x89,0x94), o3(0xE5,0x89,0xAA),
     o3(0xE5,0x89,0xB4), o3(0xE5,0x89,0xA9),
     o3(0xE5,0x89,0xB3), o3(0xE5,0x89,0xBF),
     o3(0xE5,0x89,0xBD), o3(0xE5,0x8A,0x8D),
     o3(0xE5,0x8A,0x94), o3(0xE5,0x8A,0x92),
     o3(0xE5,0x89,0xB1), o3(0xE5,0x8A,0x88),
     o3(0xE5,0x8A,0x91), o3(0xE8,0xBE,0xA8),
     o3(0xE8,0xBE,0xA7), o3(0xE5,0x8A,0xAC),
     o3(0xE5,0x8A,0xAD), o3(0xE5,0x8A,0xBC),
     o3(0xE5,0x8A,0xB5), o3(0xE5,0x8B,0x81),
     o3(0xE5,0x8B,0x8D), o3(0xE5,0x8B,0x97),
     o3(0xE5,0x8B,0x9E), o3(0xE5,0x8B,0xA3),
     o3(0xE5,0x8B,0xA6), o3(0xE9,0xA3,0xAD),
     o3(0xE5,0x8B,0xA0), o3(0xE5,0x8B,0xB3),
     o3(0xE5,0x8B,0xB5), o3(0xE5,0x8B,0xB8),
     o3(0xE5,0x8B,0xB9), o3(0xE5,0x8C,0x86),
     o3(0xE5,0x8C,0x88), o3(0xE7,0x94,0xB8),
     o3(0xE5,0x8C,0x8D), o3(0xE5,0x8C,0x90),
     o3(0xE5,0x8C,0x8F), o3(0xE5,0x8C,0x95),
     o3(0xE5,0x8C,0x9A), o3(0xE5,0x8C,0xA3),
     o3(0xE5,0x8C,0xAF), o3(0xE5,0x8C,0xB1),
     o3(0xE5,0x8C,0xB3), o3(0xE5,0x8C,0xB8),
     o3(0xE5,0x8D,0x80), o3(0xE5,0x8D,0x86),
     o3(0xE5,0x8D,0x85), o3(0xE4,0xB8,0x97),
     o3(0xE5,0x8D,0x89), o3(0xE5,0x8D,0x8D),
     o3(0xE5,0x87,0x96), o3(0xE5,0x8D,0x9E),
     o3(0xE5,0x8D,0xA9), o3(0xE5,0x8D,0xAE),
     o3(0xE5,0xA4,0x98), o3(0xE5,0x8D,0xBB),
     o3(0xE5,0x8D,0xB7), o3(0xE5,0x8E,0x82),
     o3(0xE5,0x8E,0x96), o3(0xE5,0x8E,0xA0),
     o3(0xE5,0x8E,0xA6), o3(0xE5,0x8E,0xA5),
     o3(0xE5,0x8E,0xAE), o3(0xE5,0x8E,0xB0),
     o3(0xE5,0x8E,0xB6), o3(0xE5,0x8F,0x83),
     o3(0xE7,0xB0,0x92), o3(0xE9,0x9B,0x99),
     o3(0xE5,0x8F,0x9F), o3(0xE6,0x9B,0xBC),
     o3(0xE7,0x87,0xAE), o3(0xE5,0x8F,0xAE),
     o3(0xE5,0x8F,0xA8), o3(0xE5,0x8F,0xAD),
     o3(0xE5,0x8F,0xBA), o3(0xE5,0x90,0x81),
     o3(0xE5,0x90,0xBD), o3(0xE5,0x91,0x80),
     o3(0xE5,0x90,0xAC), o3(0xE5,0x90,0xAD),
     o3(0xE5,0x90,0xBC), o3(0xE5,0x90,0xAE),
     o3(0xE5,0x90,0xB6), o3(0xE5,0x90,0xA9),
     o3(0xE5,0x90,0x9D), o3(0xE5,0x91,0x8E),
     o3(0xE5,0x92,0x8F), o3(0xE5,0x91,0xB5),
     o3(0xE5,0x92,0x8E), o3(0xE5,0x91,0x9F),
     o3(0xE5,0x91,0xB1), o3(0xE5,0x91,0xB7),
     o3(0xE5,0x91,0xB0), o3(0xE5,0x92,0x92),
     o3(0xE5,0x91,0xBB), o3(0xE5,0x92,0x80),
     o3(0xE5,0x91,0xB6), o3(0xE5,0x92,0x84),
     o3(0xE5,0x92,0x90), o3(0xE5,0x92,0x86),
     o3(0xE5,0x93,0x87), o3(0xE5,0x92,0xA2),
     o3(0xE5,0x92,0xB8), o3(0xE5,0x92,0xA5),
     o3(0xE5,0x92,0xAC), o3(0xE5,0x93,0x84),
     o3(0xE5,0x93,0x88), o3(0xE5,0x92,0xA8),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_99 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_99_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_9A_infos[189] = {
     o3(0xE5,0x92,0xAB), o3(0xE5,0x93,0x82),
     o3(0xE5,0x92,0xA4), o3(0xE5,0x92,0xBE),
     o3(0xE5,0x92,0xBC), o3(0xE5,0x93,0x98),
     o3(0xE5,0x93,0xA5), o3(0xE5,0x93,0xA6),
     o3(0xE5,0x94,0x8F), o3(0xE5,0x94,0x94),
     o3(0xE5,0x93,0xBD), o3(0xE5,0x93,0xAE),
     o3(0xE5,0x93,0xAD), o3(0xE5,0x93,0xBA),
     o3(0xE5,0x93,0xA2), o3(0xE5,0x94,0xB9),
     o3(0xE5,0x95,0x80), o3(0xE5,0x95,0xA3),
     o3(0xE5,0x95,0x8C), o3(0xE5,0x94,0xAE),
     o3(0xE5,0x95,0x9C), o3(0xE5,0x95,0x85),
     o3(0xE5,0x95,0x96), o3(0xE5,0x95,0x97),
     o3(0xE5,0x94,0xB8), o3(0xE5,0x94,0xB3),
     o3(0xE5,0x95,0x9D), o3(0xE5,0x96,0x99),
     o3(0xE5,0x96,0x80), o3(0xE5,0x92,0xAF),
     o3(0xE5,0x96,0x8A), o3(0xE5,0x96,0x9F),
     o3(0xE5,0x95,0xBB), o3(0xE5,0x95,0xBE),
     o3(0xE5,0x96,0x98), o3(0xE5,0x96,0x9E),
     o3(0xE5,0x96,0xAE), o3(0xE5,0x95,0xBC),
     o3(0xE5,0x96,0x83), o3(0xE5,0x96,0xA9),
     o3(0xE5,0x96,0x87), o3(0xE5,0x96,0xA8),
     o3(0xE5,0x97,0x9A), o3(0xE5,0x97,0x85),
     o3(0xE5,0x97,0x9F), o3(0xE5,0x97,0x84),
     o3(0xE5,0x97,0x9C), o3(0xE5,0x97,0xA4),
     o3(0xE5,0x97,0x94), o3(0xE5,0x98,0x94),
     o3(0xE5,0x97,0xB7), o3(0xE5,0x98,0x96),
     o3(0xE5,0x97,0xBE), o3(0xE5,0x97,0xBD),
     o3(0xE5,0x98,0x9B), o3(0xE5,0x97,0xB9),
     o3(0xE5,0x99,0x8E), o3(0xE5,0x99,0x90),
     o3(0xE7,0x87,0x9F), o3(0xE5,0x98,0xB4),
     o3(0xE5,0x98,0xB6), o3(0xE5,0x98,0xB2),
     o3(0xE5,0x98,0xB8), o3(0xE5,0x99,0xAB),
     o3(0xE5,0x99,0xA4), o3(0xE5,0x98,0xAF),
     o3(0xE5,0x99,0xAC), o3(0xE5,0x99,0xAA),
     o3(0xE5,0x9A,0x86), o3(0xE5,0x9A,0x80),
     o3(0xE5,0x9A,0x8A), o3(0xE5,0x9A,0xA0),
     o3(0xE5,0x9A,0x94), o3(0xE5,0x9A,0x8F),
     o3(0xE5,0x9A,0xA5), o3(0xE5,0x9A,0xAE),
     o3(0xE5,0x9A,0xB6), o3(0xE5,0x9A,0xB4),
     o3(0xE5,0x9B,0x82), o3(0xE5,0x9A,0xBC),
     o3(0xE5,0x9B,0x81), o3(0xE5,0x9B,0x83),
     o3(0xE5,0x9B,0x80), o3(0xE5,0x9B,0x88),
     o3(0xE5,0x9B,0x8E), o3(0xE5,0x9B,0x91),
     o3(0xE5,0x9B,0x93), o3(0xE5,0x9B,0x97),
     o3(0xE5,0x9B,0xAE), o3(0xE5,0x9B,0xB9),
     o3(0xE5,0x9C,0x80), o3(0xE5,0x9B,0xBF),
     o3(0xE5,0x9C,0x84), o3(0xE5,0x9C,0x89),
     o3(0xE5,0x9C,0x88), o3(0xE5,0x9C,0x8B),
     o3(0xE5,0x9C,0x8D), o3(0xE5,0x9C,0x93),
     o3(0xE5,0x9C,0x98), o3(0xE5,0x9C,0x96),
     o3(0xE5,0x97,0x87), o3(0xE5,0x9C,0x9C),
     o3(0xE5,0x9C,0xA6), o3(0xE5,0x9C,0xB7),
     o3(0xE5,0x9C,0xB8), o3(0xE5,0x9D,0x8E),
     o3(0xE5,0x9C,0xBB), o3(0xE5,0x9D,0x80),
     o3(0xE5,0x9D,0x8F), o3(0xE5,0x9D,0xA9),
     o3(0xE5,0x9F,0x80), o3(0xE5,0x9E,0x88),
     o3(0xE5,0x9D,0xA1), o3(0xE5,0x9D,0xBF),
     o3(0xE5,0x9E,0x89), o3(0xE5,0x9E,0x93),
     o3(0xE5,0x9E,0xA0), o3(0xE5,0x9E,0xB3),
     o3(0xE5,0x9E,0xA4), o3(0xE5,0x9E,0xAA),
     o3(0xE5,0x9E,0xB0), o3(0xE5,0x9F,0x83),
     o3(0xE5,0x9F,0x86), o3(0xE5,0x9F,0x94),
     o3(0xE5,0x9F,0x92), o3(0xE5,0x9F,0x93),
     o3(0xE5,0xA0,0x8A), o3(0xE5,0x9F,0x96),
     o3(0xE5,0x9F,0xA3), o3(0xE5,0xA0,0x8B),
     o3(0xE5,0xA0,0x99), o3(0xE5,0xA0,0x9D),
     o3(0xE5,0xA1,0xB2), o3(0xE5,0xA0,0xA1),
     o3(0xE5,0xA1,0xA2), o3(0xE5,0xA1,0x8B),
     o3(0xE5,0xA1,0xB0), o3(0xE6,0xAF,0x80),
     o3(0xE5,0xA1,0x92), o3(0xE5,0xA0,0xBD),
     o3(0xE5,0xA1,0xB9), o3(0xE5,0xA2,0x85),
     o3(0xE5,0xA2,0xB9), o3(0xE5,0xA2,0x9F),
     o3(0xE5,0xA2,0xAB), o3(0xE5,0xA2,0xBA),
     o3(0xE5,0xA3,0x9E), o3(0xE5,0xA2,0xBB),
     o3(0xE5,0xA2,0xB8), o3(0xE5,0xA2,0xAE),
     o3(0xE5,0xA3,0x85), o3(0xE5,0xA3,0x93),
     o3(0xE5,0xA3,0x91), o3(0xE5,0xA3,0x97),
     o3(0xE5,0xA3,0x99), o3(0xE5,0xA3,0x98),
     o3(0xE5,0xA3,0xA5), o3(0xE5,0xA3,0x9C),
     o3(0xE5,0xA3,0xA4), o3(0xE5,0xA3,0x9F),
     o3(0xE5,0xA3,0xAF), o3(0xE5,0xA3,0xBA),
     o3(0xE5,0xA3,0xB9), o3(0xE5,0xA3,0xBB),
     o3(0xE5,0xA3,0xBC), o3(0xE5,0xA3,0xBD),
     o3(0xE5,0xA4,0x82), o3(0xE5,0xA4,0x8A),
     o3(0xE5,0xA4,0x90), o3(0xE5,0xA4,0x9B),
     o3(0xE6,0xA2,0xA6), o3(0xE5,0xA4,0xA5),
     o3(0xE5,0xA4,0xAC), o3(0xE5,0xA4,0xAD),
     o3(0xE5,0xA4,0xB2), o3(0xE5,0xA4,0xB8),
     o3(0xE5,0xA4,0xBE), o3(0xE7,0xAB,0x92),
     o3(0xE5,0xA5,0x95), o3(0xE5,0xA5,0x90),
     o3(0xE5,0xA5,0x8E), o3(0xE5,0xA5,0x9A),
     o3(0xE5,0xA5,0x98), o3(0xE5,0xA5,0xA2),
     o3(0xE5,0xA5,0xA0), o3(0xE5,0xA5,0xA7),
     o3(0xE5,0xA5,0xAC), o3(0xE5,0xA5,0xA9),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_9A = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_9A_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_9B_infos[189] = {
     o3(0xE5,0xA5,0xB8), o3(0xE5,0xA6,0x81),
     o3(0xE5,0xA6,0x9D), o3(0xE4,0xBD,0x9E),
     o3(0xE4,0xBE,0xAB), o3(0xE5,0xA6,0xA3),
     o3(0xE5,0xA6,0xB2), o3(0xE5,0xA7,0x86),
     o3(0xE5,0xA7,0xA8), o3(0xE5,0xA7,0x9C),
     o3(0xE5,0xA6,0x8D), o3(0xE5,0xA7,0x99),
     o3(0xE5,0xA7,0x9A), o3(0xE5,0xA8,0xA5),
     o3(0xE5,0xA8,0x9F), o3(0xE5,0xA8,0x91),
     o3(0xE5,0xA8,0x9C), o3(0xE5,0xA8,0x89),
     o3(0xE5,0xA8,0x9A), o3(0xE5,0xA9,0x80),
     o3(0xE5,0xA9,0xAC), o3(0xE5,0xA9,0x89),
     o3(0xE5,0xA8,0xB5), o3(0xE5,0xA8,0xB6),
     o3(0xE5,0xA9,0xA2), o3(0xE5,0xA9,0xAA),
     o3(0xE5,0xAA,0x9A), o3(0xE5,0xAA,0xBC),
     o3(0xE5,0xAA,0xBE), o3(0xE5,0xAB,0x8B),
     o3(0xE5,0xAB,0x82), o3(0xE5,0xAA,0xBD),
     o3(0xE5,0xAB,0xA3), o3(0xE5,0xAB,0x97),
     o3(0xE5,0xAB,0xA6), o3(0xE5,0xAB,0xA9),
     o3(0xE5,0xAB,0x96), o3(0xE5,0xAB,0xBA),
     o3(0xE5,0xAB,0xBB), o3(0xE5,0xAC,0x8C),
     o3(0xE5,0xAC,0x8B), o3(0xE5,0xAC,0x96),
     o3(0xE5,0xAC,0xB2), o3(0xE5,0xAB,0x90),
     o3(0xE5,0xAC,0xAA), o3(0xE5,0xAC,0xB6),
     o3(0xE5,0xAC,0xBE), o3(0xE5,0xAD,0x83),
     o3(0xE5,0xAD,0x85), o3(0xE5,0xAD,0x80),
     o3(0xE5,0xAD,0x91), o3(0xE5,0xAD,0x95),
     o3(0xE5,0xAD,0x9A), o3(0xE5,0xAD,0x9B),
     o3(0xE5,0xAD,0xA5), o3(0xE5,0xAD,0xA9),
     o3(0xE5,0xAD,0xB0), o3(0xE5,0xAD,0xB3),
     o3(0xE5,0xAD,0xB5), o3(0xE5,0xAD,0xB8),
     o3(0xE6,0x96,0x88), o3(0xE5,0xAD,0xBA),
     o3(0xE5,0xAE,0x80), o3(0xE5,0xAE,0x83),
     o3(0xE5,0xAE,0xA6), o3(0xE5,0xAE,0xB8),
     o3(0xE5,0xAF,0x83), o3(0xE5,0xAF,0x87),
     o3(0xE5,0xAF,0x89), o3(0xE5,0xAF,0x94),
     o3(0xE5,0xAF,0x90), o3(0xE5,0xAF,0xA4),
     o3(0xE5,0xAF,0xA6), o3(0xE5,0xAF,0xA2),
     o3(0xE5,0xAF,0x9E), o3(0xE5,0xAF,0xA5),
     o3(0xE5,0xAF,0xAB), o3(0xE5,0xAF,0xB0),
     o3(0xE5,0xAF,0xB6), o3(0xE5,0xAF,0xB3),
     o3(0xE5,0xB0,0x85), o3(0xE5,0xB0,0x87),
     o3(0xE5,0xB0,0x88), o3(0xE5,0xB0,0x8D),
     o3(0xE5,0xB0,0x93), o3(0xE5,0xB0,0xA0),
     o3(0xE5,0xB0,0xA2), o3(0xE5,0xB0,0xA8),
     o3(0xE5,0xB0,0xB8), o3(0xE5,0xB0,0xB9),
     o3(0xE5,0xB1,0x81), o3(0xE5,0xB1,0x86),
     o3(0xE5,0xB1,0x8E), o3(0xE5,0xB1,0x93),
     o3(0xE5,0xB1,0x90), o3(0xE5,0xB1,0x8F),
     o3(0xE5,0xAD,0xB1), o3(0xE5,0xB1,0xAC),
     o3(0xE5,0xB1,0xAE), o3(0xE4,0xB9,0xA2),
     o3(0xE5,0xB1,0xB6), o3(0xE5,0xB1,0xB9),
     o3(0xE5,0xB2,0x8C), o3(0xE5,0xB2,0x91),
     o3(0xE5,0xB2,0x94), o3(0xE5,0xA6,0x9B),
     o3(0xE5,0xB2,0xAB), o3(0xE5,0xB2,0xBB),
     o3(0xE5,0xB2,0xB6), o3(0xE5,0xB2,0xBC),
     o3(0xE5,0xB2,0xB7), o3(0xE5,0xB3,0x85),
     o3(0xE5,0xB2,0xBE), o3(0xE5,0xB3,0x87),
     o3(0xE5,0xB3,0x99), o3(0xE5,0xB3,0xA9),
     o3(0xE5,0xB3,0xBD), o3(0xE5,0xB3,0xBA),
     o3(0xE5,0xB3,0xAD), o3(0xE5,0xB6,0x8C),
     o3(0xE5,0xB3,0xAA), o3(0xE5,0xB4,0x8B),
     o3(0xE5,0xB4,0x95), o3(0xE5,0xB4,0x97),
     o3(0xE5,0xB5,0x9C), o3(0xE5,0xB4,0x9F),
     o3(0xE5,0xB4,0x9B), o3(0xE5,0xB4,0x91),
     o3(0xE5,0xB4,0x94), o3(0xE5,0xB4,0xA2),
     o3(0xE5,0xB4,0x9A), o3(0xE5,0xB4,0x99),
     o3(0xE5,0xB4,0x98), o3(0xE5,0xB5,0x8C),
     o3(0xE5,0xB5,0x92), o3(0xE5,0xB5,0x8E),
     o3(0xE5,0xB5,0x8B), o3(0xE5,0xB5,0xAC),
     o3(0xE5,0xB5,0xB3), o3(0xE5,0xB5,0xB6),
     o3(0xE5,0xB6,0x87), o3(0xE5,0xB6,0x84),
     o3(0xE5,0xB6,0x82), o3(0xE5,0xB6,0xA2),
     o3(0xE5,0xB6,0x9D), o3(0xE5,0xB6,0xAC),
     o3(0xE5,0xB6,0xAE), o3(0xE5,0xB6,0xBD),
     o3(0xE5,0xB6,0x90), o3(0xE5,0xB6,0xB7),
     o3(0xE5,0xB6,0xBC), o3(0xE5,0xB7,0x89),
     o3(0xE5,0xB7,0x8D), o3(0xE5,0xB7,0x93),
     o3(0xE5,0xB7,0x92), o3(0xE5,0xB7,0x96),
     o3(0xE5,0xB7,0x9B), o3(0xE5,0xB7,0xAB),
     o3(0xE5,0xB7,0xB2), o3(0xE5,0xB7,0xB5),
     o3(0xE5,0xB8,0x8B), o3(0xE5,0xB8,0x9A),
     o3(0xE5,0xB8,0x99), o3(0xE5,0xB8,0x91),
     o3(0xE5,0xB8,0x9B), o3(0xE5,0xB8,0xB6),
     o3(0xE5,0xB8,0xB7), o3(0xE5,0xB9,0x84),
     o3(0xE5,0xB9,0x83), o3(0xE5,0xB9,0x80),
     o3(0xE5,0xB9,0x8E), o3(0xE5,0xB9,0x97),
     o3(0xE5,0xB9,0x94), o3(0xE5,0xB9,0x9F),
     o3(0xE5,0xB9,0xA2), o3(0xE5,0xB9,0xA4),
     o3(0xE5,0xB9,0x87), o3(0xE5,0xB9,0xB5),
     o3(0xE5,0xB9,0xB6), o3(0xE5,0xB9,0xBA),
     o3(0xE9,0xBA,0xBC), o3(0xE5,0xB9,0xBF),
     o3(0xE5,0xBA,0xA0), o3(0xE5,0xBB,0x81),
     o3(0xE5,0xBB,0x82), o3(0xE5,0xBB,0x88),
     o3(0xE5,0xBB,0x90), o3(0xE5,0xBB,0x8F),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_9B = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_9B_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_9C_infos[189] = {
     o3(0xE5,0xBB,0x96), o3(0xE5,0xBB,0xA3),
     o3(0xE5,0xBB,0x9D), o3(0xE5,0xBB,0x9A),
     o3(0xE5,0xBB,0x9B), o3(0xE5,0xBB,0xA2),
     o3(0xE5,0xBB,0xA1), o3(0xE5,0xBB,0xA8),
     o3(0xE5,0xBB,0xA9), o3(0xE5,0xBB,0xAC),
     o3(0xE5,0xBB,0xB1), o3(0xE5,0xBB,0xB3),
     o3(0xE5,0xBB,0xB0), o3(0xE5,0xBB,0xB4),
     o3(0xE5,0xBB,0xB8), o3(0xE5,0xBB,0xBE),
     o3(0xE5,0xBC,0x83), o3(0xE5,0xBC,0x89),
     o3(0xE5,0xBD,0x9D), o3(0xE5,0xBD,0x9C),
     o3(0xE5,0xBC,0x8B), o3(0xE5,0xBC,0x91),
     o3(0xE5,0xBC,0x96), o3(0xE5,0xBC,0xA9),
     o3(0xE5,0xBC,0xAD), o3(0xE5,0xBC,0xB8),
     o3(0xE5,0xBD,0x81), o3(0xE5,0xBD,0x88),
     o3(0xE5,0xBD,0x8C), o3(0xE5,0xBD,0x8E),
     o3(0xE5,0xBC,0xAF), o3(0xE5,0xBD,0x91),
     o3(0xE5,0xBD,0x96), o3(0xE5,0xBD,0x97),
     o3(0xE5,0xBD,0x99), o3(0xE5,0xBD,0xA1),
     o3(0xE5,0xBD,0xAD), o3(0xE5,0xBD,0xB3),
     o3(0xE5,0xBD,0xB7), o3(0xE5,0xBE,0x83),
     o3(0xE5,0xBE,0x82), o3(0xE5,0xBD,0xBF),
     o3(0xE5,0xBE,0x8A), o3(0xE5,0xBE,0x88),
     o3(0xE5,0xBE,0x91), o3(0xE5,0xBE,0x87),
     o3(0xE5,0xBE,0x9E), o3(0xE5,0xBE,0x99),
     o3(0xE5,0xBE,0x98), o3(0xE5,0xBE,0xA0),
     o3(0xE5,0xBE,0xA8), o3(0xE5,0xBE,0xAD),
     o3(0xE5,0xBE,0xBC), o3(0xE5,0xBF,0x96),
     o3(0xE5,0xBF,0xBB), o3(0xE5,0xBF,0xA4),
     o3(0xE5,0xBF,0xB8), o3(0xE5,0xBF,0xB1),
     o3(0xE5,0xBF,0x9D), o3(0xE6,0x82,0xB3),
     o3(0xE5,0xBF,0xBF), o3(0xE6,0x80,0xA1),
     o3(0xE6,0x81,0xA0), o3(0xE6,0x80,0x99),
     o3(0xE6,0x80,0x90), o3(0xE6,0x80,0xA9),
     o3(0xE6,0x80,0x8E), o3(0xE6,0x80,0xB1),
     o3(0xE6,0x80,0x9B), o3(0xE6,0x80,0x95),
     o3(0xE6,0x80,0xAB), o3(0xE6,0x80,0xA6),
     o3(0xE6,0x80,0x8F), o3(0xE6,0x80,0xBA),
     o3(0xE6,0x81,0x9A), o3(0xE6,0x81,0x81),
     o3(0xE6,0x81,0xAA), o3(0xE6,0x81,0xB7),
     o3(0xE6,0x81,0x9F), o3(0xE6,0x81,0x8A),
     o3(0xE6,0x81,0x86), o3(0xE6,0x81,0x8D),
     o3(0xE6,0x81,0xA3), o3(0xE6,0x81,0x83),
     o3(0xE6,0x81,0xA4), o3(0xE6,0x81,0x82),
     o3(0xE6,0x81,0xAC), o3(0xE6,0x81,0xAB),
     o3(0xE6,0x81,0x99), o3(0xE6,0x82,0x81),
     o3(0xE6,0x82,0x8D), o3(0xE6,0x83,0xA7),
     o3(0xE6,0x82,0x83), o3(0xE6,0x82,0x9A),
     o3(0xE6,0x82,0x84), o3(0xE6,0x82,0x9B),
     o3(0xE6,0x82,0x96), o3(0xE6,0x82,0x97),
     o3(0xE6,0x82,0x92), o3(0xE6,0x82,0xA7),
     o3(0xE6,0x82,0x8B), o3(0xE6,0x83,0xA1),
     o3(0xE6,0x82,0xB8), o3(0xE6,0x83,0xA0),
     o3(0xE6,0x83,0x93), o3(0xE6,0x82,0xB4),
     o3(0xE5,0xBF,0xB0), o3(0xE6,0x82,0xBD),
     o3(0xE6,0x83,0x86), o3(0xE6,0x82,0xB5),
     o3(0xE6,0x83,0x98), o3(0xE6,0x85,0x8D),
     o3(0xE6,0x84,0x95), o3(0xE6,0x84,0x86),
     o3(0xE6,0x83,0xB6), o3(0xE6,0x83,0xB7),
     o3(0xE6,0x84,0x80), o3(0xE6,0x83,0xB4),
     o3(0xE6,0x83,0xBA), o3(0xE6,0x84,0x83),
     o3(0xE6,0x84,0xA1), o3(0xE6,0x83,0xBB),
     o3(0xE6,0x83,0xB1), o3(0xE6,0x84,0x8D),
     o3(0xE6,0x84,0x8E), o3(0xE6,0x85,0x87),
     o3(0xE6,0x84,0xBE), o3(0xE6,0x84,0xA8),
     o3(0xE6,0x84,0xA7), o3(0xE6,0x85,0x8A),
     o3(0xE6,0x84,0xBF), o3(0xE6,0x84,0xBC),
     o3(0xE6,0x84,0xAC), o3(0xE6,0x84,0xB4),
     o3(0xE6,0x84,0xBD), o3(0xE6,0x85,0x82),
     o3(0xE6,0x85,0x84), o3(0xE6,0x85,0xB3),
     o3(0xE6,0x85,0xB7), o3(0xE6,0x85,0x98),
     o3(0xE6,0x85,0x99), o3(0xE6,0x85,0x9A),
     o3(0xE6,0x85,0xAB), o3(0xE6,0x85,0xB4),
     o3(0xE6,0x85,0xAF), o3(0xE6,0x85,0xA5),
     o3(0xE6,0x85,0xB1), o3(0xE6,0x85,0x9F),
     o3(0xE6,0x85,0x9D), o3(0xE6,0x85,0x93),
     o3(0xE6,0x85,0xB5), o3(0xE6,0x86,0x99),
     o3(0xE6,0x86,0x96), o3(0xE6,0x86,0x87),
     o3(0xE6,0x86,0xAC), o3(0xE6,0x86,0x94),
     o3(0xE6,0x86,0x9A), o3(0xE6,0x86,0x8A),
     o3(0xE6,0x86,0x91), o3(0xE6,0x86,0xAB),
     o3(0xE6,0x86,0xAE), o3(0xE6,0x87,0x8C),
     o3(0xE6,0x87,0x8A), o3(0xE6,0x87,0x89),
     o3(0xE6,0x87,0xB7), o3(0xE6,0x87,0x88),
     o3(0xE6,0x87,0x83), o3(0xE6,0x87,0x86),
     o3(0xE6,0x86,0xBA), o3(0xE6,0x87,0x8B),
     o3(0xE7,0xBD,0xB9), o3(0xE6,0x87,0x8D),
     o3(0xE6,0x87,0xA6), o3(0xE6,0x87,0xA3),
     o3(0xE6,0x87,0xB6), o3(0xE6,0x87,0xBA),
     o3(0xE6,0x87,0xB4), o3(0xE6,0x87,0xBF),
     o3(0xE6,0x87,0xBD), o3(0xE6,0x87,0xBC),
     o3(0xE6,0x87,0xBE), o3(0xE6,0x88,0x80),
     o3(0xE6,0x88,0x88), o3(0xE6,0x88,0x89),
     o3(0xE6,0x88,0x8D), o3(0xE6,0x88,0x8C),
     o3(0xE6,0x88,0x94), o3(0xE6,0x88,0x9B),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_9C = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_9C_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_9D_infos[189] = {
     o3(0xE6,0x88,0x9E), o3(0xE6,0x88,0xA1),
     o3(0xE6,0x88,0xAA), o3(0xE6,0x88,0xAE),
     o3(0xE6,0x88,0xB0), o3(0xE6,0x88,0xB2),
     o3(0xE6,0x88,0xB3), o3(0xE6,0x89,0x81),
     o3(0xE6,0x89,0x8E), o3(0xE6,0x89,0x9E),
     o3(0xE6,0x89,0xA3), o3(0xE6,0x89,0x9B),
     o3(0xE6,0x89,0xA0), o3(0xE6,0x89,0xA8),
     o3(0xE6,0x89,0xBC), o3(0xE6,0x8A,0x82),
     o3(0xE6,0x8A,0x89), o3(0xE6,0x89,0xBE),
     o3(0xE6,0x8A,0x92), o3(0xE6,0x8A,0x93),
     o3(0xE6,0x8A,0x96), o3(0xE6,0x8B,0x94),
     o3(0xE6,0x8A,0x83), o3(0xE6,0x8A,0x94),
     o3(0xE6,0x8B,0x97), o3(0xE6,0x8B,0x91),
     o3(0xE6,0x8A,0xBB), o3(0xE6,0x8B,0x8F),
     o3(0xE6,0x8B,0xBF), o3(0xE6,0x8B,0x86),
     o3(0xE6,0x93,0x94), o3(0xE6,0x8B,0x88),
     o3(0xE6,0x8B,0x9C), o3(0xE6,0x8B,0x8C),
     o3(0xE6,0x8B,0x8A), o3(0xE6,0x8B,0x82),
     o3(0xE6,0x8B,0x87), o3(0xE6,0x8A,0x9B),
     o3(0xE6,0x8B,0x89), o3(0xE6,0x8C,0x8C),
     o3(0xE6,0x8B,0xAE), o3(0xE6,0x8B,0xB1),
     o3(0xE6,0x8C,0xA7), o3(0xE6,0x8C,0x82),
     o3(0xE6,0x8C,0x88), o3(0xE6,0x8B,0xAF),
     o3(0xE6,0x8B,0xB5), o3(0xE6,0x8D,0x90),
     o3(0xE6,0x8C,0xBE), o3(0xE6,0x8D,0x8D),
     o3(0xE6,0x90,0x9C), o3(0xE6,0x8D,0x8F),
     o3(0xE6,0x8E,0x96), o3(0xE6,0x8E,0x8E),
     o3(0xE6,0x8E,0x80), o3(0xE6,0x8E,0xAB),
     o3(0xE6,0x8D,0xB6), o3(0xE6,0x8E,0xA3),
     o3(0xE6,0x8E,0x8F), o3(0xE6,0x8E,0x89),
     o3(0xE6,0x8E,0x9F), o3(0xE6,0x8E,0xB5),
     o3(0xE6,0x8D,0xAB), o3(0xE6,0x8D,0xA9),
     o3(0xE6,0x8E,0xBE), o3(0xE6,0x8F,0xA9),
     o3(0xE6,0x8F,0x80), o3(0xE6,0x8F,0x86),
     o3(0xE6,0x8F,0xA3), o3(0xE6,0x8F,0x89),
     o3(0xE6,0x8F,0x92), o3(0xE6,0x8F,0xB6),
     o3(0xE6,0x8F,0x84), o3(0xE6,0x90,0x96),
     o3(0xE6,0x90,0xB4), o3(0xE6,0x90,0x86),
     o3(0xE6,0x90,0x93), o3(0xE6,0x90,0xA6),
     o3(0xE6,0x90,0xB6), o3(0xE6,0x94,0x9D),
     o3(0xE6,0x90,0x97), o3(0xE6,0x90,0xA8),
     o3(0xE6,0x90,0x8F), o3(0xE6,0x91,0xA7),
     o3(0xE6,0x91,0xAF), o3(0xE6,0x91,0xB6),
     o3(0xE6,0x91,0x8E), o3(0xE6,0x94,0xAA),
     o3(0xE6,0x92,0x95), o3(0xE6,0x92,0x93),
     o3(0xE6,0x92,0xA5), o3(0xE6,0x92,0xA9),
     o3(0xE6,0x92,0x88), o3(0xE6,0x92,0xBC),
     o3(0xE6,0x93,0x9A), o3(0xE6,0x93,0x92),
     o3(0xE6,0x93,0x85), o3(0xE6,0x93,0x87),
     o3(0xE6,0x92,0xBB), o3(0xE6,0x93,0x98),
     o3(0xE6,0x93,0x82), o3(0xE6,0x93,0xB1),
     o3(0xE6,0x93,0xA7), o3(0xE8,0x88,0x89),
     o3(0xE6,0x93,0xA0), o3(0xE6,0x93,0xA1),
     o3(0xE6,0x8A,0xAC), o3(0xE6,0x93,0xA3),
     o3(0xE6,0x93,0xAF), o3(0xE6,0x94,0xAC),
     o3(0xE6,0x93,0xB6), o3(0xE6,0x93,0xB4),
     o3(0xE6,0x93,0xB2), o3(0xE6,0x93,0xBA),
     o3(0xE6,0x94,0x80), o3(0xE6,0x93,0xBD),
     o3(0xE6,0x94,0x98), o3(0xE6,0x94,0x9C),
     o3(0xE6,0x94,0x85), o3(0xE6,0x94,0xA4),
     o3(0xE6,0x94,0xA3), o3(0xE6,0x94,0xAB),
     o3(0xE6,0x94,0xB4), o3(0xE6,0x94,0xB5),
     o3(0xE6,0x94,0xB7), o3(0xE6,0x94,0xB6),
     o3(0xE6,0x94,0xB8), o3(0xE7,0x95,0x8B),
     o3(0xE6,0x95,0x88), o3(0xE6,0x95,0x96),
     o3(0xE6,0x95,0x95), o3(0xE6,0x95,0x8D),
     o3(0xE6,0x95,0x98), o3(0xE6,0x95,0x9E),
     o3(0xE6,0x95,0x9D), o3(0xE6,0x95,0xB2),
     o3(0xE6,0x95,0xB8), o3(0xE6,0x96,0x82),
     o3(0xE6,0x96,0x83), o3(0xE8,0xAE,0x8A),
     o3(0xE6,0x96,0x9B), o3(0xE6,0x96,0x9F),
     o3(0xE6,0x96,0xAB), o3(0xE6,0x96,0xB7),
     o3(0xE6,0x97,0x83), o3(0xE6,0x97,0x86),
     o3(0xE6,0x97,0x81), o3(0xE6,0x97,0x84),
     o3(0xE6,0x97,0x8C), o3(0xE6,0x97,0x92),
     o3(0xE6,0x97,0x9B), o3(0xE6,0x97,0x99),
     o3(0xE6,0x97,0xA0), o3(0xE6,0x97,0xA1),
     o3(0xE6,0x97,0xB1), o3(0xE6,0x9D,0xB2),
     o3(0xE6,0x98,0x8A), o3(0xE6,0x98,0x83),
     o3(0xE6,0x97,0xBB), o3(0xE6,0x9D,0xB3),
     o3(0xE6,0x98,0xB5), o3(0xE6,0x98,0xB6),
     o3(0xE6,0x98,0xB4), o3(0xE6,0x98,0x9C),
     o3(0xE6,0x99,0x8F), o3(0xE6,0x99,0x84),
     o3(0xE6,0x99,0x89), o3(0xE6,0x99,0x81),
     o3(0xE6,0x99,0x9E), o3(0xE6,0x99,0x9D),
     o3(0xE6,0x99,0xA4), o3(0xE6,0x99,0xA7),
     o3(0xE6,0x99,0xA8), o3(0xE6,0x99,0x9F),
     o3(0xE6,0x99,0xA2), o3(0xE6,0x99,0xB0),
     o3(0xE6,0x9A,0x83), o3(0xE6,0x9A,0x88),
     o3(0xE6,0x9A,0x8E), o3(0xE6,0x9A,0x89),
     o3(0xE6,0x9A,0x84), o3(0xE6,0x9A,0x98),
     o3(0xE6,0x9A,0x9D), o3(0xE6,0x9B,0x81),
     o3(0xE6,0x9A,0xB9), o3(0xE6,0x9B,0x89),
     o3(0xE6,0x9A,0xBE), o3(0xE6,0x9A,0xBC),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_9D = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_9D_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_9E_infos[189] = {
     o3(0xE6,0x9B,0x84), o3(0xE6,0x9A,0xB8),
     o3(0xE6,0x9B,0x96), o3(0xE6,0x9B,0x9A),
     o3(0xE6,0x9B,0xA0), o3(0xE6,0x98,0xBF),
     o3(0xE6,0x9B,0xA6), o3(0xE6,0x9B,0xA9),
     o3(0xE6,0x9B,0xB0), o3(0xE6,0x9B,0xB5),
     o3(0xE6,0x9B,0xB7), o3(0xE6,0x9C,0x8F),
     o3(0xE6,0x9C,0x96), o3(0xE6,0x9C,0x9E),
     o3(0xE6,0x9C,0xA6), o3(0xE6,0x9C,0xA7),
     o3(0xE9,0x9C,0xB8), o3(0xE6,0x9C,0xAE),
     o3(0xE6,0x9C,0xBF), o3(0xE6,0x9C,0xB6),
     o3(0xE6,0x9D,0x81), o3(0xE6,0x9C,0xB8),
     o3(0xE6,0x9C,0xB7), o3(0xE6,0x9D,0x86),
     o3(0xE6,0x9D,0x9E), o3(0xE6,0x9D,0xA0),
     o3(0xE6,0x9D,0x99), o3(0xE6,0x9D,0xA3),
     o3(0xE6,0x9D,0xA4), o3(0xE6,0x9E,0x89),
     o3(0xE6,0x9D,0xB0), o3(0xE6,0x9E,0xA9),
     o3(0xE6,0x9D,0xBC), o3(0xE6,0x9D,0xAA),
     o3(0xE6,0x9E,0x8C), o3(0xE6,0x9E,0x8B),
     o3(0xE6,0x9E,0xA6), o3(0xE6,0x9E,0xA1),
     o3(0xE6,0x9E,0x85), o3(0xE6,0x9E,0xB7),
     o3(0xE6,0x9F,0xAF), o3(0xE6,0x9E,0xB4),
     o3(0xE6,0x9F,0xAC), o3(0xE6,0x9E,0xB3),
     o3(0xE6,0x9F,0xA9), o3(0xE6,0x9E,0xB8),
     o3(0xE6,0x9F,0xA4), o3(0xE6,0x9F,0x9E),
     o3(0xE6,0x9F,0x9D), o3(0xE6,0x9F,0xA2),
     o3(0xE6,0x9F,0xAE), o3(0xE6,0x9E,0xB9),
     o3(0xE6,0x9F,0x8E), o3(0xE6,0x9F,0x86),
     o3(0xE6,0x9F,0xA7), o3(0xE6,0xAA,0x9C),
     o3(0xE6,0xA0,0x9E), o3(0xE6,0xA1,0x86),
     o3(0xE6,0xA0,0xA9), o3(0xE6,0xA1,0x80),
     o3(0xE6,0xA1,0x8D), o3(0xE6,0xA0,0xB2),
     o3(0xE6,0xA1,0x8E), o3(0xE6,0xA2,0xB3),
     o3(0xE6,0xA0,0xAB), o3(0xE6,0xA1,0x99),
     o3(0xE6,0xA1,0xA3), o3(0xE6,0xA1,0xB7),
     o3(0xE6,0xA1,0xBF), o3(0xE6,0xA2,0x9F),
     o3(0xE6,0xA2,0x8F), o3(0xE6,0xA2,0xAD),
     o3(0xE6,0xA2,0x94), o3(0xE6,0xA2,0x9D),
     o3(0xE6,0xA2,0x9B), o3(0xE6,0xA2,0x83),
     o3(0xE6,0xAA,0xAE), o3(0xE6,0xA2,0xB9),
     o3(0xE6,0xA1,0xB4), o3(0xE6,0xA2,0xB5),
     o3(0xE6,0xA2,0xA0), o3(0xE6,0xA2,0xBA),
     o3(0xE6,0xA4,0x8F), o3(0xE6,0xA2,0x8D),
     o3(0xE6,0xA1,0xBE), o3(0xE6,0xA4,0x81),
     o3(0xE6,0xA3,0x8A), o3(0xE6,0xA4,0x88),
     o3(0xE6,0xA3,0x98), o3(0xE6,0xA4,0xA2),
     o3(0xE6,0xA4,0xA6), o3(0xE6,0xA3,0xA1),
     o3(0xE6,0xA4,0x8C), o3(0xE6,0xA3,0x8D),
     o3(0xE6,0xA3,0x94), o3(0xE6,0xA3,0xA7),
     o3(0xE6,0xA3,0x95), o3(0xE6,0xA4,0xB6),
     o3(0xE6,0xA4,0x92), o3(0xE6,0xA4,0x84),
     o3(0xE6,0xA3,0x97), o3(0xE6,0xA3,0xA3),
     o3(0xE6,0xA4,0xA5), o3(0xE6,0xA3,0xB9),
     o3(0xE6,0xA3,0xA0), o3(0xE6,0xA3,0xAF),
     o3(0xE6,0xA4,0xA8), o3(0xE6,0xA4,0xAA),
     o3(0xE6,0xA4,0x9A), o3(0xE6,0xA4,0xA3),
     o3(0xE6,0xA4,0xA1), o3(0xE6,0xA3,0x86),
     o3(0xE6,0xA5,0xB9), o3(0xE6,0xA5,0xB7),
     o3(0xE6,0xA5,0x9C), o3(0xE6,0xA5,0xB8),
     o3(0xE6,0xA5,0xAB), o3(0xE6,0xA5,0x94),
     o3(0xE6,0xA5,0xBE), o3(0xE6,0xA5,0xAE),
     o3(0xE6,0xA4,0xB9), o3(0xE6,0xA5,0xB4),
     o3(0xE6,0xA4,0xBD), o3(0xE6,0xA5,0x99),
     o3(0xE6,0xA4,0xB0), o3(0xE6,0xA5,0xA1),
     o3(0xE6,0xA5,0x9E), o3(0xE6,0xA5,0x9D),
     o3(0xE6,0xA6,0x81), o3(0xE6,0xA5,0xAA),
     o3(0xE6,0xA6,0xB2), o3(0xE6,0xA6,0xAE),
     o3(0xE6,0xA7,0x90), o3(0xE6,0xA6,0xBF),
     o3(0xE6,0xA7,0x81), o3(0xE6,0xA7,0x93),
     o3(0xE6,0xA6,0xBE), o3(0xE6,0xA7,0x8E),
     o3(0xE5,0xAF,0xA8), o3(0xE6,0xA7,0x8A),
     o3(0xE6,0xA7,0x9D), o3(0xE6,0xA6,0xBB),
     o3(0xE6,0xA7,0x83), o3(0xE6,0xA6,0xA7),
     o3(0xE6,0xA8,0xAE), o3(0xE6,0xA6,0x91),
     o3(0xE6,0xA6,0xA0), o3(0xE6,0xA6,0x9C),
     o3(0xE6,0xA6,0x95), o3(0xE6,0xA6,0xB4),
     o3(0xE6,0xA7,0x9E), o3(0xE6,0xA7,0xA8),
     o3(0xE6,0xA8,0x82), o3(0xE6,0xA8,0x9B),
     o3(0xE6,0xA7,0xBF), o3(0xE6,0xAC,0x8A),
     o3(0xE6,0xA7,0xB9), o3(0xE6,0xA7,0xB2),
     o3(0xE6,0xA7,0xA7), o3(0xE6,0xA8,0x85),
     o3(0xE6,0xA6,0xB1), o3(0xE6,0xA8,0x9E),
     o3(0xE6,0xA7,0xAD), o3(0xE6,0xA8,0x94),
     o3(0xE6,0xA7,0xAB), o3(0xE6,0xA8,0x8A),
     o3(0xE6,0xA8,0x92), o3(0xE6,0xAB,0x81),
     o3(0xE6,0xA8,0xA3), o3(0xE6,0xA8,0x93),
     o3(0xE6,0xA9,0x84), o3(0xE6,0xA8,0x8C),
     o3(0xE6,0xA9,0xB2), o3(0xE6,0xA8,0xB6),
     o3(0xE6,0xA9,0xB8), o3(0xE6,0xA9,0x87),
     o3(0xE6,0xA9,0xA2), o3(0xE6,0xA9,0x99),
     o3(0xE6,0xA9,0xA6), o3(0xE6,0xA9,0x88),
     o3(0xE6,0xA8,0xB8), o3(0xE6,0xA8,0xA2),
     o3(0xE6,0xAA,0x90), o3(0xE6,0xAA,0x8D),
     o3(0xE6,0xAA,0xA0), o3(0xE6,0xAA,0x84),
     o3(0xE6,0xAA,0xA2), o3(0xE6,0xAA,0xA3),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_9E = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_9E_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_9F_infos[189] = {
     o3(0xE6,0xAA,0x97), o3(0xE8,0x98,0x97),
     o3(0xE6,0xAA,0xBB), o3(0xE6,0xAB,0x83),
     o3(0xE6,0xAB,0x82), o3(0xE6,0xAA,0xB8),
     o3(0xE6,0xAA,0xB3), o3(0xE6,0xAA,0xAC),
     o3(0xE6,0xAB,0x9E), o3(0xE6,0xAB,0x91),
     o3(0xE6,0xAB,0x9F), o3(0xE6,0xAA,0xAA),
     o3(0xE6,0xAB,0x9A), o3(0xE6,0xAB,0xAA),
     o3(0xE6,0xAB,0xBB), o3(0xE6,0xAC,0x85),
     o3(0xE8,0x98,0x96), o3(0xE6,0xAB,0xBA),
     o3(0xE6,0xAC,0x92), o3(0xE6,0xAC,0x96),
     o3(0xE9,0xAC,0xB1), o3(0xE6,0xAC,0x9F),
     o3(0xE6,0xAC,0xB8), o3(0xE6,0xAC,0xB7),
     o3(0xE7,0x9B,0x9C), o3(0xE6,0xAC,0xB9),
     o3(0xE9,0xA3,0xAE), o3(0xE6,0xAD,0x87),
     o3(0xE6,0xAD,0x83), o3(0xE6,0xAD,0x89),
     o3(0xE6,0xAD,0x90), o3(0xE6,0xAD,0x99),
     o3(0xE6,0xAD,0x94), o3(0xE6,0xAD,0x9B),
     o3(0xE6,0xAD,0x9F), o3(0xE6,0xAD,0xA1),
     o3(0xE6,0xAD,0xB8), o3(0xE6,0xAD,0xB9),
     o3(0xE6,0xAD,0xBF), o3(0xE6,0xAE,0x80),
     o3(0xE6,0xAE,0x84), o3(0xE6,0xAE,0x83),
     o3(0xE6,0xAE,0x8D), o3(0xE6,0xAE,0x98),
     o3(0xE6,0xAE,0x95), o3(0xE6,0xAE,0x9E),
     o3(0xE6,0xAE,0xA4), o3(0xE6,0xAE,0xAA),
     o3(0xE6,0xAE,0xAB), o3(0xE6,0xAE,0xAF),
     o3(0xE6,0xAE,0xB2), o3(0xE6,0xAE,0xB1),
     o3(0xE6,0xAE,0xB3), o3(0xE6,0xAE,0xB7),
     o3(0xE6,0xAE,0xBC), o3(0xE6,0xAF,0x86),
     o3(0xE6,0xAF,0x8B), o3(0xE6,0xAF,0x93),
     o3(0xE6,0xAF,0x9F), o3(0xE6,0xAF,0xAC),
     o3(0xE6,0xAF,0xAB), o3(0xE6,0xAF,0xB3),
     o3(0xE6,0xAF,0xAF), o3(0xE9,0xBA,0xBE),
     o3(0xE6,0xB0,0x88), o3(0xE6,0xB0,0x93),
     o3(0xE6,0xB0,0x94), o3(0xE6,0xB0,0x9B),
     o3(0xE6,0xB0,0xA4), o3(0xE6,0xB0,0xA3),
     o3(0xE6,0xB1,0x9E), o3(0xE6,0xB1,0x95),
     o3(0xE6,0xB1,0xA2), o3(0xE6,0xB1,0xAA),
     o3(0xE6,0xB2,0x82), o3(0xE6,0xB2,0x8D),
     o3(0xE6,0xB2,0x9A), o3(0xE6,0xB2,0x81),
     o3(0xE6,0xB2,0x9B), o3(0xE6,0xB1,0xBE),
     o3(0xE6,0xB1,0xA8), o3(0xE6,0xB1,0xB3),
     o3(0xE6,0xB2,0x92), o3(0xE6,0xB2,0x90),
     o3(0xE6,0xB3,0x84), o3(0xE6,0xB3,0xB1),
     o3(0xE6,0xB3,0x93), o3(0xE6,0xB2,0xBD),
     o3(0xE6,0xB3,0x97), o3(0xE6,0xB3,0x85),
     o3(0xE6,0xB3,0x9D), o3(0xE6,0xB2,0xAE),
     o3(0xE6,0xB2,0xB1), o3(0xE6,0xB2,0xBE),
     o3(0xE6,0xB2,0xBA), o3(0xE6,0xB3,0x9B),
     o3(0xE6,0xB3,0xAF), o3(0xE6,0xB3,0x99),
     o3(0xE6,0xB3,0xAA), o3(0xE6,0xB4,0x9F),
     o3(0xE8,0xA1,0x8D), o3(0xE6,0xB4,0xB6),
     o3(0xE6,0xB4,0xAB), o3(0xE6,0xB4,0xBD),
     o3(0xE6,0xB4,0xB8), o3(0xE6,0xB4,0x99),
     o3(0xE6,0xB4,0xB5), o3(0xE6,0xB4,0xB3),
     o3(0xE6,0xB4,0x92), o3(0xE6,0xB4,0x8C),
     o3(0xE6,0xB5,0xA3), o3(0xE6,0xB6,0x93),
     o3(0xE6,0xB5,0xA4), o3(0xE6,0xB5,0x9A),
     o3(0xE6,0xB5,0xB9), o3(0xE6,0xB5,0x99),
     o3(0xE6,0xB6,0x8E), o3(0xE6,0xB6,0x95),
     o3(0xE6,0xBF,0xA4), o3(0xE6,0xB6,0x85),
     o3(0xE6,0xB7,0xB9), o3(0xE6,0xB8,0x95),
     o3(0xE6,0xB8,0x8A), o3(0xE6,0xB6,0xB5),
     o3(0xE6,0xB7,0x87), o3(0xE6,0xB7,0xA6),
     o3(0xE6,0xB6,0xB8), o3(0xE6,0xB7,0x86),
     o3(0xE6,0xB7,0xAC), o3(0xE6,0xB7,0x9E),
     o3(0xE6,0xB7,0x8C), o3(0xE6,0xB7,0xA8),
     o3(0xE6,0xB7,0x92), o3(0xE6,0xB7,0x85),
     o3(0xE6,0xB7,0xBA), o3(0xE6,0xB7,0x99),
     o3(0xE6,0xB7,0xA4), o3(0xE6,0xB7,0x95),
     o3(0xE6,0xB7,0xAA), o3(0xE6,0xB7,0xAE),
     o3(0xE6,0xB8,0xAD), o3(0xE6,0xB9,0xAE),
     o3(0xE6,0xB8,0xAE), o3(0xE6,0xB8,0x99),
     o3(0xE6,0xB9,0xB2), o3(0xE6,0xB9,0x9F),
     o3(0xE6,0xB8,0xBE), o3(0xE6,0xB8,0xA3),
     o3(0xE6,0xB9,0xAB), o3(0xE6,0xB8,0xAB),
     o3(0xE6,0xB9,0xB6), o3(0xE6,0xB9,0x8D),
     o3(0xE6,0xB8,0x9F), o3(0xE6,0xB9,0x83),
     o3(0xE6,0xB8,0xBA), o3(0xE6,0xB9,0x8E),
     o3(0xE6,0xB8,0xA4), o3(0xE6,0xBB,0xBF),
     o3(0xE6,0xB8,0x9D), o3(0xE6,0xB8,0xB8),
     o3(0xE6,0xBA,0x82), o3(0xE6,0xBA,0xAA),
     o3(0xE6,0xBA,0x98), o3(0xE6,0xBB,0x89),
     o3(0xE6,0xBA,0xB7), o3(0xE6,0xBB,0x93),
     o3(0xE6,0xBA,0xBD), o3(0xE6,0xBA,0xAF),
     o3(0xE6,0xBB,0x84), o3(0xE6,0xBA,0xB2),
     o3(0xE6,0xBB,0x94), o3(0xE6,0xBB,0x95),
     o3(0xE6,0xBA,0x8F), o3(0xE6,0xBA,0xA5),
     o3(0xE6,0xBB,0x82), o3(0xE6,0xBA,0x9F),
     o3(0xE6,0xBD,0x81), o3(0xE6,0xBC,0x91),
     o3(0xE7,0x81,0x8C), o3(0xE6,0xBB,0xAC),
     o3(0xE6,0xBB,0xB8), o3(0xE6,0xBB,0xBE),
     o3(0xE6,0xBC,0xBF), o3(0xE6,0xBB,0xB2),
     o3(0xE6,0xBC,0xB1), o3(0xE6,0xBB,0xAF),
     o3(0xE6,0xBC,0xB2), o3(0xE6,0xBB,0x8C),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_9F = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_9F_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_E0_infos[189] = {
     o3(0xE6,0xBC,0xBE), o3(0xE6,0xBC,0x93),
     o3(0xE6,0xBB,0xB7), o3(0xE6,0xBE,0x86),
     o3(0xE6,0xBD,0xBA), o3(0xE6,0xBD,0xB8),
     o3(0xE6,0xBE,0x81), o3(0xE6,0xBE,0x80),
     o3(0xE6,0xBD,0xAF), o3(0xE6,0xBD,0x9B),
     o3(0xE6,0xBF,0xB3), o3(0xE6,0xBD,0xAD),
     o3(0xE6,0xBE,0x82), o3(0xE6,0xBD,0xBC),
     o3(0xE6,0xBD,0x98), o3(0xE6,0xBE,0x8E),
     o3(0xE6,0xBE,0x91), o3(0xE6,0xBF,0x82),
     o3(0xE6,0xBD,0xA6), o3(0xE6,0xBE,0xB3),
     o3(0xE6,0xBE,0xA3), o3(0xE6,0xBE,0xA1),
     o3(0xE6,0xBE,0xA4), o3(0xE6,0xBE,0xB9),
     o3(0xE6,0xBF,0x86), o3(0xE6,0xBE,0xAA),
     o3(0xE6,0xBF,0x9F), o3(0xE6,0xBF,0x95),
     o3(0xE6,0xBF,0xAC), o3(0xE6,0xBF,0x94),
     o3(0xE6,0xBF,0x98), o3(0xE6,0xBF,0xB1),
     o3(0xE6,0xBF,0xAE), o3(0xE6,0xBF,0x9B),
     o3(0xE7,0x80,0x89), o3(0xE7,0x80,0x8B),
     o3(0xE6,0xBF,0xBA), o3(0xE7,0x80,0x91),
     o3(0xE7,0x80,0x81), o3(0xE7,0x80,0x8F),
     o3(0xE6,0xBF,0xBE), o3(0xE7,0x80,0x9B),
     o3(0xE7,0x80,0x9A), o3(0xE6,0xBD,0xB4),
     o3(0xE7,0x80,0x9D), o3(0xE7,0x80,0x98),
     o3(0xE7,0x80,0x9F), o3(0xE7,0x80,0xB0),
     o3(0xE7,0x80,0xBE), o3(0xE7,0x80,0xB2),
     o3(0xE7,0x81,0x91), o3(0xE7,0x81,0xA3),
     o3(0xE7,0x82,0x99), o3(0xE7,0x82,0x92),
     o3(0xE7,0x82,0xAF), o3(0xE7,0x83,0xB1),
     o3(0xE7,0x82,0xAC), o3(0xE7,0x82,0xB8),
     o3(0xE7,0x82,0xB3), o3(0xE7,0x82,0xAE),
     o3(0xE7,0x83,0x9F), o3(0xE7,0x83,0x8B),
     o3(0xE7,0x83,0x9D), o3(0xE7,0x83,0x99),
     o3(0xE7,0x84,0x89), o3(0xE7,0x83,0xBD),
     o3(0xE7,0x84,0x9C), o3(0xE7,0x84,0x99),
     o3(0xE7,0x85,0xA5), o3(0xE7,0x85,0x95),
     o3(0xE7,0x86,0x88), o3(0xE7,0x85,0xA6),
     o3(0xE7,0x85,0xA2), o3(0xE7,0x85,0x8C),
     o3(0xE7,0x85,0x96), o3(0xE7,0x85,0xAC),
     o3(0xE7,0x86,0x8F), o3(0xE7,0x87,0xBB),
     o3(0xE7,0x86,0x84), o3(0xE7,0x86,0x95),
     o3(0xE7,0x86,0xA8), o3(0xE7,0x86,0xAC),
     o3(0xE7,0x87,0x97), o3(0xE7,0x86,0xB9),
     o3(0xE7,0x86,0xBE), o3(0xE7,0x87,0x92),
     o3(0xE7,0x87,0x89), o3(0xE7,0x87,0x94),
     o3(0xE7,0x87,0x8E), o3(0xE7,0x87,0xA0),
     o3(0xE7,0x87,0xAC), o3(0xE7,0x87,0xA7),
     o3(0xE7,0x87,0xB5), o3(0xE7,0x87,0xBC),
     o3(0xE7,0x87,0xB9), o3(0xE7,0x87,0xBF),
     o3(0xE7,0x88,0x8D), o3(0xE7,0x88,0x90),
     o3(0xE7,0x88,0x9B), o3(0xE7,0x88,0xA8),
     o3(0xE7,0x88,0xAD), o3(0xE7,0x88,0xAC),
     o3(0xE7,0x88,0xB0), o3(0xE7,0x88,0xB2),
     o3(0xE7,0x88,0xBB), o3(0xE7,0x88,0xBC),
     o3(0xE7,0x88,0xBF), o3(0xE7,0x89,0x80),
     o3(0xE7,0x89,0x86), o3(0xE7,0x89,0x8B),
     o3(0xE7,0x89,0x98), o3(0xE7,0x89,0xB4),
     o3(0xE7,0x89,0xBE), o3(0xE7,0x8A,0x82),
     o3(0xE7,0x8A,0x81), o3(0xE7,0x8A,0x87),
     o3(0xE7,0x8A,0x92), o3(0xE7,0x8A,0x96),
     o3(0xE7,0x8A,0xA2), o3(0xE7,0x8A,0xA7),
     o3(0xE7,0x8A,0xB9), o3(0xE7,0x8A,0xB2),
     o3(0xE7,0x8B,0x83), o3(0xE7,0x8B,0x86),
     o3(0xE7,0x8B,0x84), o3(0xE7,0x8B,0x8E),
     o3(0xE7,0x8B,0x92), o3(0xE7,0x8B,0xA2),
     o3(0xE7,0x8B,0xA0), o3(0xE7,0x8B,0xA1),
     o3(0xE7,0x8B,0xB9), o3(0xE7,0x8B,0xB7),
     o3(0xE5,0x80,0x8F), o3(0xE7,0x8C,0x97),
     o3(0xE7,0x8C,0x8A), o3(0xE7,0x8C,0x9C),
     o3(0xE7,0x8C,0x96), o3(0xE7,0x8C,0x9D),
     o3(0xE7,0x8C,0xB4), o3(0xE7,0x8C,0xAF),
     o3(0xE7,0x8C,0xA9), o3(0xE7,0x8C,0xA5),
     o3(0xE7,0x8C,0xBE), o3(0xE7,0x8D,0x8E),
     o3(0xE7,0x8D,0x8F), o3(0xE9,0xBB,0x98),
     o3(0xE7,0x8D,0x97), o3(0xE7,0x8D,0xAA),
     o3(0xE7,0x8D,0xA8), o3(0xE7,0x8D,0xB0),
     o3(0xE7,0x8D,0xB8), o3(0xE7,0x8D,0xB5),
     o3(0xE7,0x8D,0xBB), o3(0xE7,0x8D,0xBA),
     o3(0xE7,0x8F,0x88), o3(0xE7,0x8E,0xB3),
     o3(0xE7,0x8F,0x8E), o3(0xE7,0x8E,0xBB),
     o3(0xE7,0x8F,0x80), o3(0xE7,0x8F,0xA5),
     o3(0xE7,0x8F,0xAE), o3(0xE7,0x8F,0x9E),
     o3(0xE7,0x92,0xA2), o3(0xE7,0x90,0x85),
     o3(0xE7,0x91,0xAF), o3(0xE7,0x90,0xA5),
     o3(0xE7,0x8F,0xB8), o3(0xE7,0x90,0xB2),
     o3(0xE7,0x90,0xBA), o3(0xE7,0x91,0x95),
     o3(0xE7,0x90,0xBF), o3(0xE7,0x91,0x9F),
     o3(0xE7,0x91,0x99), o3(0xE7,0x91,0x81),
     o3(0xE7,0x91,0x9C), o3(0xE7,0x91,0xA9),
     o3(0xE7,0x91,0xB0), o3(0xE7,0x91,0xA3),
     o3(0xE7,0x91,0xAA), o3(0xE7,0x91,0xB6),
     o3(0xE7,0x91,0xBE), o3(0xE7,0x92,0x8B),
     o3(0xE7,0x92,0x9E), o3(0xE7,0x92,0xA7),
     o3(0xE7,0x93,0x8A), o3(0xE7,0x93,0x8F),
     o3(0xE7,0x93,0x94), o3(0xE7,0x8F,0xB1),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_E0 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_E0_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_E1_infos[189] = {
     o3(0xE7,0x93,0xA0), o3(0xE7,0x93,0xA3),
     o3(0xE7,0x93,0xA7), o3(0xE7,0x93,0xA9),
     o3(0xE7,0x93,0xAE), o3(0xE7,0x93,0xB2),
     o3(0xE7,0x93,0xB0), o3(0xE7,0x93,0xB1),
     o3(0xE7,0x93,0xB8), o3(0xE7,0x93,0xB7),
     o3(0xE7,0x94,0x84), o3(0xE7,0x94,0x83),
     o3(0xE7,0x94,0x85), o3(0xE7,0x94,0x8C),
     o3(0xE7,0x94,0x8E), o3(0xE7,0x94,0x8D),
     o3(0xE7,0x94,0x95), o3(0xE7,0x94,0x93),
     o3(0xE7,0x94,0x9E), o3(0xE7,0x94,0xA6),
     o3(0xE7,0x94,0xAC), o3(0xE7,0x94,0xBC),
     o3(0xE7,0x95,0x84), o3(0xE7,0x95,0x8D),
     o3(0xE7,0x95,0x8A), o3(0xE7,0x95,0x89),
     o3(0xE7,0x95,0x9B), o3(0xE7,0x95,0x86),
     o3(0xE7,0x95,0x9A), o3(0xE7,0x95,0xA9),
     o3(0xE7,0x95,0xA4), o3(0xE7,0x95,0xA7),
     o3(0xE7,0x95,0xAB), o3(0xE7,0x95,0xAD),
     o3(0xE7,0x95,0xB8), o3(0xE7,0x95,0xB6),
     o3(0xE7,0x96,0x86), o3(0xE7,0x96,0x87),
     o3(0xE7,0x95,0xB4), o3(0xE7,0x96,0x8A),
     o3(0xE7,0x96,0x89), o3(0xE7,0x96,0x82),
     o3(0xE7,0x96,0x94), o3(0xE7,0x96,0x9A),
     o3(0xE7,0x96,0x9D), o3(0xE7,0x96,0xA5),
     o3(0xE7,0x96,0xA3), o3(0xE7,0x97,0x82),
     o3(0xE7,0x96,0xB3), o3(0xE7,0x97,0x83),
     o3(0xE7,0x96,0xB5), o3(0xE7,0x96,0xBD),
     o3(0xE7,0x96,0xB8), o3(0xE7,0x96,0xBC),
     o3(0xE7,0x96,0xB1), o3(0xE7,0x97,0x8D),
     o3(0xE7,0x97,0x8A), o3(0xE7,0x97,0x92),
     o3(0xE7,0x97,0x99), o3(0xE7,0x97,0xA3),
     o3(0xE7,0x97,0x9E), o3(0xE7,0x97,0xBE),
     o3(0xE7,0x97,0xBF), o3(0xE7,0x97,0xBC),
     o3(0xE7,0x98,0x81), o3(0xE7,0x97,0xB0),
     o3(0xE7,0x97,0xBA), o3(0xE7,0x97,0xB2),
     o3(0xE7,0x97,0xB3), o3(0xE7,0x98,0x8B),
     o3(0xE7,0x98,0x8D), o3(0xE7,0x98,0x89),
     o3(0xE7,0x98,0x9F), o3(0xE7,0x98,0xA7),
     o3(0xE7,0x98,0xA0), o3(0xE7,0x98,0xA1),
     o3(0xE7,0x98,0xA2), o3(0xE7,0x98,0xA4),
     o3(0xE7,0x98,0xB4), o3(0xE7,0x98,0xB0),
     o3(0xE7,0x98,0xBB), o3(0xE7,0x99,0x87),
     o3(0xE7,0x99,0x88), o3(0xE7,0x99,0x86),
     o3(0xE7,0x99,0x9C), o3(0xE7,0x99,0x98),
     o3(0xE7,0x99,0xA1), o3(0xE7,0x99,0xA2),
     o3(0xE7,0x99,0xA8), o3(0xE7,0x99,0xA9),
     o3(0xE7,0x99,0xAA), o3(0xE7,0x99,0xA7),
     o3(0xE7,0x99,0xAC), o3(0xE7,0x99,0xB0),
     o3(0xE7,0x99,0xB2), o3(0xE7,0x99,0xB6),
     o3(0xE7,0x99,0xB8), o3(0xE7,0x99,0xBC),
     o3(0xE7,0x9A,0x80), o3(0xE7,0x9A,0x83),
     o3(0xE7,0x9A,0x88), o3(0xE7,0x9A,0x8B),
     o3(0xE7,0x9A,0x8E), o3(0xE7,0x9A,0x96),
     o3(0xE7,0x9A,0x93), o3(0xE7,0x9A,0x99),
     o3(0xE7,0x9A,0x9A), o3(0xE7,0x9A,0xB0),
     o3(0xE7,0x9A,0xB4), o3(0xE7,0x9A,0xB8),
     o3(0xE7,0x9A,0xB9), o3(0xE7,0x9A,0xBA),
     o3(0xE7,0x9B,0x82), o3(0xE7,0x9B,0x8D),
     o3(0xE7,0x9B,0x96), o3(0xE7,0x9B,0x92),
     o3(0xE7,0x9B,0x9E), o3(0xE7,0x9B,0xA1),
     o3(0xE7,0x9B,0xA5), o3(0xE7,0x9B,0xA7),
     o3(0xE7,0x9B,0xAA), o3(0xE8,0x98,0xAF),
     o3(0xE7,0x9B,0xBB), o3(0xE7,0x9C,0x88),
     o3(0xE7,0x9C,0x87), o3(0xE7,0x9C,0x84),
     o3(0xE7,0x9C,0xA9), o3(0xE7,0x9C,0xA4),
     o3(0xE7,0x9C,0x9E), o3(0xE7,0x9C,0xA5),
     o3(0xE7,0x9C,0xA6), o3(0xE7,0x9C,0x9B),
     o3(0xE7,0x9C,0xB7), o3(0xE7,0x9C,0xB8),
     o3(0xE7,0x9D,0x87), o3(0xE7,0x9D,0x9A),
     o3(0xE7,0x9D,0xA8), o3(0xE7,0x9D,0xAB),
     o3(0xE7,0x9D,0x9B), o3(0xE7,0x9D,0xA5),
     o3(0xE7,0x9D,0xBF), o3(0xE7,0x9D,0xBE),
     o3(0xE7,0x9D,0xB9), o3(0xE7,0x9E,0x8E),
     o3(0xE7,0x9E,0x8B), o3(0xE7,0x9E,0x91),
     o3(0xE7,0x9E,0xA0), o3(0xE7,0x9E,0x9E),
     o3(0xE7,0x9E,0xB0), o3(0xE7,0x9E,0xB6),
     o3(0xE7,0x9E,0xB9), o3(0xE7,0x9E,0xBF),
     o3(0xE7,0x9E,0xBC), o3(0xE7,0x9E,0xBD),
     o3(0xE7,0x9E,0xBB), o3(0xE7,0x9F,0x87),
     o3(0xE7,0x9F,0x8D), o3(0xE7,0x9F,0x97),
     o3(0xE7,0x9F,0x9A), o3(0xE7,0x9F,0x9C),
     o3(0xE7,0x9F,0xA3), o3(0xE7,0x9F,0xAE),
     o3(0xE7,0x9F,0xBC), o3(0xE7,0xA0,0x8C),
     o3(0xE7,0xA0,0x92), o3(0xE7,0xA4,0xA6),
     o3(0xE7,0xA0,0xA0), o3(0xE7,0xA4,0xAA),
     o3(0xE7,0xA1,0x85), o3(0xE7,0xA2,0x8E),
     o3(0xE7,0xA1,0xB4), o3(0xE7,0xA2,0x86),
     o3(0xE7,0xA1,0xBC), o3(0xE7,0xA2,0x9A),
     o3(0xE7,0xA2,0x8C), o3(0xE7,0xA2,0xA3),
     o3(0xE7,0xA2,0xB5), o3(0xE7,0xA2,0xAA),
     o3(0xE7,0xA2,0xAF), o3(0xE7,0xA3,0x91),
     o3(0xE7,0xA3,0x86), o3(0xE7,0xA3,0x8B),
     o3(0xE7,0xA3,0x94), o3(0xE7,0xA2,0xBE),
     o3(0xE7,0xA2,0xBC), o3(0xE7,0xA3,0x85),
     o3(0xE7,0xA3,0x8A), o3(0xE7,0xA3,0xAC),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_E1 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_E1_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_E2_infos[189] = {
     o3(0xE7,0xA3,0xA7), o3(0xE7,0xA3,0x9A),
     o3(0xE7,0xA3,0xBD), o3(0xE7,0xA3,0xB4),
     o3(0xE7,0xA4,0x87), o3(0xE7,0xA4,0x92),
     o3(0xE7,0xA4,0x91), o3(0xE7,0xA4,0x99),
     o3(0xE7,0xA4,0xAC), o3(0xE7,0xA4,0xAB),
     o3(0xE7,0xA5,0x80), o3(0xE7,0xA5,0xA0),
     o3(0xE7,0xA5,0x97), o3(0xE7,0xA5,0x9F),
     o3(0xE7,0xA5,0x9A), o3(0xE7,0xA5,0x95),
     o3(0xE7,0xA5,0x93), o3(0xE7,0xA5,0xBA),
     o3(0xE7,0xA5,0xBF), o3(0xE7,0xA6,0x8A),
     o3(0xE7,0xA6,0x9D), o3(0xE7,0xA6,0xA7),
     o3(0xE9,0xBD,0x8B), o3(0xE7,0xA6,0xAA),
     o3(0xE7,0xA6,0xAE), o3(0xE7,0xA6,0xB3),
     o3(0xE7,0xA6,0xB9), o3(0xE7,0xA6,0xBA),
     o3(0xE7,0xA7,0x89), o3(0xE7,0xA7,0x95),
     o3(0xE7,0xA7,0xA7), o3(0xE7,0xA7,0xAC),
     o3(0xE7,0xA7,0xA1), o3(0xE7,0xA7,0xA3),
     o3(0xE7,0xA8,0x88), o3(0xE7,0xA8,0x8D),
     o3(0xE7,0xA8,0x98), o3(0xE7,0xA8,0x99),
     o3(0xE7,0xA8,0xA0), o3(0xE7,0xA8,0x9F),
     o3(0xE7,0xA6,0x80), o3(0xE7,0xA8,0xB1),
     o3(0xE7,0xA8,0xBB), o3(0xE7,0xA8,0xBE),
     o3(0xE7,0xA8,0xB7), o3(0xE7,0xA9,0x83),
     o3(0xE7,0xA9,0x97), o3(0xE7,0xA9,0x89),
     o3(0xE7,0xA9,0xA1), o3(0xE7,0xA9,0xA2),
     o3(0xE7,0xA9,0xA9), o3(0xE9,0xBE,0x9D),
     o3(0xE7,0xA9,0xB0), o3(0xE7,0xA9,0xB9),
     o3(0xE7,0xA9,0xBD), o3(0xE7,0xAA,0x88),
     o3(0xE7,0xAA,0x97), o3(0xE7,0xAA,0x95),
     o3(0xE7,0xAA,0x98), o3(0xE7,0xAA,0x96),
     o3(0xE7,0xAA,0xA9), o3(0xE7,0xAB,0x88),
     o3(0xE7,0xAA,0xB0), o3(0xE7,0xAA,0xB6),
     o3(0xE7,0xAB,0x85), o3(0xE7,0xAB,0x84),
     o3(0xE7,0xAA,0xBF), o3(0xE9,0x82,0x83),
     o3(0xE7,0xAB,0x87), o3(0xE7,0xAB,0x8A),
     o3(0xE7,0xAB,0x8D), o3(0xE7,0xAB,0x8F),
     o3(0xE7,0xAB,0x95), o3(0xE7,0xAB,0x93),
     o3(0xE7,0xAB,0x99), o3(0xE7,0xAB,0x9A),
     o3(0xE7,0xAB,0x9D), o3(0xE7,0xAB,0xA1),
     o3(0xE7,0xAB,0xA2), o3(0xE7,0xAB,0xA6),
     o3(0xE7,0xAB,0xAD), o3(0xE7,0xAB,0xB0),
     o3(0xE7,0xAC,0x82), o3(0xE7,0xAC,0x8F),
     o3(0xE7,0xAC,0x8A), o3(0xE7,0xAC,0x86),
     o3(0xE7,0xAC,0xB3), o3(0xE7,0xAC,0x98),
     o3(0xE7,0xAC,0x99), o3(0xE7,0xAC,0x9E),
     o3(0xE7,0xAC,0xB5), o3(0xE7,0xAC,0xA8),
     o3(0xE7,0xAC,0xB6), o3(0xE7,0xAD,0x90),
     o3(0xE7,0xAD,0xBA), o3(0xE7,0xAC,0x84),
     o3(0xE7,0xAD,0x8D), o3(0xE7,0xAC,0x8B),
     o3(0xE7,0xAD,0x8C), o3(0xE7,0xAD,0x85),
     o3(0xE7,0xAD,0xB5), o3(0xE7,0xAD,0xA5),
     o3(0xE7,0xAD,0xB4), o3(0xE7,0xAD,0xA7),
     o3(0xE7,0xAD,0xB0), o3(0xE7,0xAD,0xB1),
     o3(0xE7,0xAD,0xAC), o3(0xE7,0xAD,0xAE),
     o3(0xE7,0xAE,0x9D), o3(0xE7,0xAE,0x98),
     o3(0xE7,0xAE,0x9F), o3(0xE7,0xAE,0x8D),
     o3(0xE7,0xAE,0x9C), o3(0xE7,0xAE,0x9A),
     o3(0xE7,0xAE,0x8B), o3(0xE7,0xAE,0x92),
     o3(0xE7,0xAE,0x8F), o3(0xE7,0xAD,0x9D),
     o3(0xE7,0xAE,0x99), o3(0xE7,0xAF,0x8B),
     o3(0xE7,0xAF,0x81), o3(0xE7,0xAF,0x8C),
     o3(0xE7,0xAF,0x8F), o3(0xE7,0xAE,0xB4),
     o3(0xE7,0xAF,0x86), o3(0xE7,0xAF,0x9D),
     o3(0xE7,0xAF,0xA9), o3(0xE7,0xB0,0x91),
     o3(0xE7,0xB0,0x94), o3(0xE7,0xAF,0xA6),
     o3(0xE7,0xAF,0xA5), o3(0xE7,0xB1,0xA0),
     o3(0xE7,0xB0,0x80), o3(0xE7,0xB0,0x87),
     o3(0xE7,0xB0,0x93), o3(0xE7,0xAF,0xB3),
     o3(0xE7,0xAF,0xB7), o3(0xE7,0xB0,0x97),
     o3(0xE7,0xB0,0x8D), o3(0xE7,0xAF,0xB6),
     o3(0xE7,0xB0,0xA3), o3(0xE7,0xB0,0xA7),
     o3(0xE7,0xB0,0xAA), o3(0xE7,0xB0,0x9F),
     o3(0xE7,0xB0,0xB7), o3(0xE7,0xB0,0xAB),
     o3(0xE7,0xB0,0xBD), o3(0xE7,0xB1,0x8C),
     o3(0xE7,0xB1,0x83), o3(0xE7,0xB1,0x94),
     o3(0xE7,0xB1,0x8F), o3(0xE7,0xB1,0x80),
     o3(0xE7,0xB1,0x90), o3(0xE7,0xB1,0x98),
     o3(0xE7,0xB1,0x9F), o3(0xE7,0xB1,0xA4),
     o3(0xE7,0xB1,0x96), o3(0xE7,0xB1,0xA5),
     o3(0xE7,0xB1,0xAC), o3(0xE7,0xB1,0xB5),
     o3(0xE7,0xB2,0x83), o3(0xE7,0xB2,0x90),
     o3(0xE7,0xB2,0xA4), o3(0xE7,0xB2,0xAD),
     o3(0xE7,0xB2,0xA2), o3(0xE7,0xB2,0xAB),
     o3(0xE7,0xB2,0xA1), o3(0xE7,0xB2,0xA8),
     o3(0xE7,0xB2,0xB3), o3(0xE7,0xB2,0xB2),
     o3(0xE7,0xB2,0xB1), o3(0xE7,0xB2,0xAE),
     o3(0xE7,0xB2,0xB9), o3(0xE7,0xB2,0xBD),
     o3(0xE7,0xB3,0x80), o3(0xE7,0xB3,0x85),
     o3(0xE7,0xB3,0x82), o3(0xE7,0xB3,0x98),
     o3(0xE7,0xB3,0x92), o3(0xE7,0xB3,0x9C),
     o3(0xE7,0xB3,0xA2), o3(0xE9,0xAC,0xBB),
     o3(0xE7,0xB3,0xAF), o3(0xE7,0xB3,0xB2),
     o3(0xE7,0xB3,0xB4), o3(0xE7,0xB3,0xB6),
     o3(0xE7,0xB3,0xBA), o3(0xE7,0xB4,0x86),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_E2 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_E2_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_E3_infos[189] = {
     o3(0xE7,0xB4,0x82), o3(0xE7,0xB4,0x9C),
     o3(0xE7,0xB4,0x95), o3(0xE7,0xB4,0x8A),
     o3(0xE7,0xB5,0x85), o3(0xE7,0xB5,0x8B),
     o3(0xE7,0xB4,0xAE), o3(0xE7,0xB4,0xB2),
     o3(0xE7,0xB4,0xBF), o3(0xE7,0xB4,0xB5),
     o3(0xE7,0xB5,0x86), o3(0xE7,0xB5,0xB3),
     o3(0xE7,0xB5,0x96), o3(0xE7,0xB5,0x8E),
     o3(0xE7,0xB5,0xB2), o3(0xE7,0xB5,0xA8),
     o3(0xE7,0xB5,0xAE), o3(0xE7,0xB5,0x8F),
     o3(0xE7,0xB5,0xA3), o3(0xE7,0xB6,0x93),
     o3(0xE7,0xB6,0x89), o3(0xE7,0xB5,0x9B),
     o3(0xE7,0xB6,0x8F), o3(0xE7,0xB5,0xBD),
     o3(0xE7,0xB6,0x9B), o3(0xE7,0xB6,0xBA),
     o3(0xE7,0xB6,0xAE), o3(0xE7,0xB6,0xA3),
     o3(0xE7,0xB6,0xB5), o3(0xE7,0xB7,0x87),
     o3(0xE7,0xB6,0xBD), o3(0xE7,0xB6,0xAB),
     o3(0xE7,0xB8,0xBD), o3(0xE7,0xB6,0xA2),
     o3(0xE7,0xB6,0xAF), o3(0xE7,0xB7,0x9C),
     o3(0xE7,0xB6,0xB8), o3(0xE7,0xB6,0x9F),
     o3(0xE7,0xB6,0xB0), o3(0xE7,0xB7,0x98),
     o3(0xE7,0xB7,0x9D), o3(0xE7,0xB7,0xA4),
     o3(0xE7,0xB7,0x9E), o3(0xE7,0xB7,0xBB),
     o3(0xE7,0xB7,0xB2), o3(0xE7,0xB7,0xA1),
     o3(0xE7,0xB8,0x85), o3(0xE7,0xB8,0x8A),
     o3(0xE7,0xB8,0xA3), o3(0xE7,0xB8,0xA1),
     o3(0xE7,0xB8,0x92), o3(0xE7,0xB8,0xB1),
     o3(0xE7,0xB8,0x9F), o3(0xE7,0xB8,0x89),
     o3(0xE7,0xB8,0x8B), o3(0xE7,0xB8,0xA2),
     o3(0xE7,0xB9,0x86), o3(0xE7,0xB9,0xA6),
     o3(0xE7,0xB8,0xBB), o3(0xE7,0xB8,0xB5),
     o3(0xE7,0xB8,0xB9), o3(0xE7,0xB9,0x83),
     o3(0xE7,0xB8,0xB7), o3(0xE7,0xB8,0xB2),
     o3(0xE7,0xB8,0xBA), o3(0xE7,0xB9,0xA7),
     o3(0xE7,0xB9,0x9D), o3(0xE7,0xB9,0x96),
     o3(0xE7,0xB9,0x9E), o3(0xE7,0xB9,0x99),
     o3(0xE7,0xB9,0x9A), o3(0xE7,0xB9,0xB9),
     o3(0xE7,0xB9,0xAA), o3(0xE7,0xB9,0xA9),
     o3(0xE7,0xB9,0xBC), o3(0xE7,0xB9,0xBB),
     o3(0xE7,0xBA,0x83), o3(0xE7,0xB7,0x95),
     o3(0xE7,0xB9,0xBD), o3(0xE8,0xBE,0xAE),
     o3(0xE7,0xB9,0xBF), o3(0xE7,0xBA,0x88),
     o3(0xE7,0xBA,0x89), o3(0xE7,0xBA,0x8C),
     o3(0xE7,0xBA,0x92), o3(0xE7,0xBA,0x90),
     o3(0xE7,0xBA,0x93), o3(0xE7,0xBA,0x94),
     o3(0xE7,0xBA,0x96), o3(0xE7,0xBA,0x8E),
     o3(0xE7,0xBA,0x9B), o3(0xE7,0xBA,0x9C),
     o3(0xE7,0xBC,0xB8), o3(0xE7,0xBC,0xBA),
     o3(0xE7,0xBD,0x85), o3(0xE7,0xBD,0x8C),
     o3(0xE7,0xBD,0x8D), o3(0xE7,0xBD,0x8E),
     o3(0xE7,0xBD,0x90), o3(0xE7,0xBD,0x91),
     o3(0xE7,0xBD,0x95), o3(0xE7,0xBD,0x94),
     o3(0xE7,0xBD,0x98), o3(0xE7,0xBD,0x9F),
     o3(0xE7,0xBD,0xA0), o3(0xE7,0xBD,0xA8),
     o3(0xE7,0xBD,0xA9), o3(0xE7,0xBD,0xA7),
     o3(0xE7,0xBD,0xB8), o3(0xE7,0xBE,0x82),
     o3(0xE7,0xBE,0x86), o3(0xE7,0xBE,0x83),
     o3(0xE7,0xBE,0x88), o3(0xE7,0xBE,0x87),
     o3(0xE7,0xBE,0x8C), o3(0xE7,0xBE,0x94),
     o3(0xE7,0xBE,0x9E), o3(0xE7,0xBE,0x9D),
     o3(0xE7,0xBE,0x9A), o3(0xE7,0xBE,0xA3),
     o3(0xE7,0xBE,0xAF), o3(0xE7,0xBE,0xB2),
     o3(0xE7,0xBE,0xB9), o3(0xE7,0xBE,0xAE),
     o3(0xE7,0xBE,0xB6), o3(0xE7,0xBE,0xB8),
     o3(0xE8,0xAD,0xB1), o3(0xE7,0xBF,0x85),
     o3(0xE7,0xBF,0x86), o3(0xE7,0xBF,0x8A),
     o3(0xE7,0xBF,0x95), o3(0xE7,0xBF,0x94),
     o3(0xE7,0xBF,0xA1), o3(0xE7,0xBF,0xA6),
     o3(0xE7,0xBF,0xA9), o3(0xE7,0xBF,0xB3),
     o3(0xE7,0xBF,0xB9), o3(0xE9,0xA3,0x9C),
     o3(0xE8,0x80,0x86), o3(0xE8,0x80,0x84),
     o3(0xE8,0x80,0x8B), o3(0xE8,0x80,0x92),
     o3(0xE8,0x80,0x98), o3(0xE8,0x80,0x99),
     o3(0xE8,0x80,0x9C), o3(0xE8,0x80,0xA1),
     o3(0xE8,0x80,0xA8), o3(0xE8,0x80,0xBF),
     o3(0xE8,0x80,0xBB), o3(0xE8,0x81,0x8A),
     o3(0xE8,0x81,0x86), o3(0xE8,0x81,0x92),
     o3(0xE8,0x81,0x98), o3(0xE8,0x81,0x9A),
     o3(0xE8,0x81,0x9F), o3(0xE8,0x81,0xA2),
     o3(0xE8,0x81,0xA8), o3(0xE8,0x81,0xB3),
     o3(0xE8,0x81,0xB2), o3(0xE8,0x81,0xB0),
     o3(0xE8,0x81,0xB6), o3(0xE8,0x81,0xB9),
     o3(0xE8,0x81,0xBD), o3(0xE8,0x81,0xBF),
     o3(0xE8,0x82,0x84), o3(0xE8,0x82,0x86),
     o3(0xE8,0x82,0x85), o3(0xE8,0x82,0x9B),
     o3(0xE8,0x82,0x93), o3(0xE8,0x82,0x9A),
     o3(0xE8,0x82,0xAD), o3(0xE5,0x86,0x90),
     o3(0xE8,0x82,0xAC), o3(0xE8,0x83,0x9B),
     o3(0xE8,0x83,0xA5), o3(0xE8,0x83,0x99),
     o3(0xE8,0x83,0x9D), o3(0xE8,0x83,0x84),
     o3(0xE8,0x83,0x9A), o3(0xE8,0x83,0x96),
     o3(0xE8,0x84,0x89), o3(0xE8,0x83,0xAF),
     o3(0xE8,0x83,0xB1), o3(0xE8,0x84,0x9B),
     o3(0xE8,0x84,0xA9), o3(0xE8,0x84,0xA3),
     o3(0xE8,0x84,0xAF), o3(0xE8,0x85,0x8B),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_E3 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_E3_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_E4_infos[189] = {
     o3(0xE9,0x9A,0x8B), o3(0xE8,0x85,0x86),
     o3(0xE8,0x84,0xBE), o3(0xE8,0x85,0x93),
     o3(0xE8,0x85,0x91), o3(0xE8,0x83,0xBC),
     o3(0xE8,0x85,0xB1), o3(0xE8,0x85,0xAE),
     o3(0xE8,0x85,0xA5), o3(0xE8,0x85,0xA6),
     o3(0xE8,0x85,0xB4), o3(0xE8,0x86,0x83),
     o3(0xE8,0x86,0x88), o3(0xE8,0x86,0x8A),
     o3(0xE8,0x86,0x80), o3(0xE8,0x86,0x82),
     o3(0xE8,0x86,0xA0), o3(0xE8,0x86,0x95),
     o3(0xE8,0x86,0xA4), o3(0xE8,0x86,0xA3),
     o3(0xE8,0x85,0x9F), o3(0xE8,0x86,0x93),
     o3(0xE8,0x86,0xA9), o3(0xE8,0x86,0xB0),
     o3(0xE8,0x86,0xB5), o3(0xE8,0x86,0xBE),
     o3(0xE8,0x86,0xB8), o3(0xE8,0x86,0xBD),
     o3(0xE8,0x87,0x80), o3(0xE8,0x87,0x82),
     o3(0xE8,0x86,0xBA), o3(0xE8,0x87,0x89),
     o3(0xE8,0x87,0x8D), o3(0xE8,0x87,0x91),
     o3(0xE8,0x87,0x99), o3(0xE8,0x87,0x98),
     o3(0xE8,0x87,0x88), o3(0xE8,0x87,0x9A),
     o3(0xE8,0x87,0x9F), o3(0xE8,0x87,0xA0),
     o3(0xE8,0x87,0xA7), o3(0xE8,0x87,0xBA),
     o3(0xE8,0x87,0xBB), o3(0xE8,0x87,0xBE),
     o3(0xE8,0x88,0x81), o3(0xE8,0x88,0x82),
     o3(0xE8,0x88,0x85), o3(0xE8,0x88,0x87),
     o3(0xE8,0x88,0x8A), o3(0xE8,0x88,0x8D),
     o3(0xE8,0x88,0x90), o3(0xE8,0x88,0x96),
     o3(0xE8,0x88,0xA9), o3(0xE8,0x88,0xAB),
     o3(0xE8,0x88,0xB8), o3(0xE8,0x88,0xB3),
     o3(0xE8,0x89,0x80), o3(0xE8,0x89,0x99),
     o3(0xE8,0x89,0x98), o3(0xE8,0x89,0x9D),
     o3(0xE8,0x89,0x9A), o3(0xE8,0x89,0x9F),
     o3(0xE8,0x89,0xA4), o3(0xE8,0x89,0xA2),
     o3(0xE8,0x89,0xA8), o3(0xE8,0x89,0xAA),
     o3(0xE8,0x89,0xAB), o3(0xE8,0x88,0xAE),
     o3(0xE8,0x89,0xB1), o3(0xE8,0x89,0xB7),
     o3(0xE8,0x89,0xB8), o3(0xE8,0x89,0xBE),
     o3(0xE8,0x8A,0x8D), o3(0xE8,0x8A,0x92),
     o3(0xE8,0x8A,0xAB), o3(0xE8,0x8A,0x9F),
     o3(0xE8,0x8A,0xBB), o3(0xE8,0x8A,0xAC),
     o3(0xE8,0x8B,0xA1), o3(0xE8,0x8B,0xA3),
     o3(0xE8,0x8B,0x9F), o3(0xE8,0x8B,0x92),
     o3(0xE8,0x8B,0xB4), o3(0xE8,0x8B,0xB3),
     o3(0xE8,0x8B,0xBA), o3(0xE8,0x8E,0x93),
     o3(0xE8,0x8C,0x83), o3(0xE8,0x8B,0xBB),
     o3(0xE8,0x8B,0xB9), o3(0xE8,0x8B,0x9E),
     o3(0xE8,0x8C,0x86), o3(0xE8,0x8B,0x9C),
     o3(0xE8,0x8C,0x89), o3(0xE8,0x8B,0x99),
     o3(0xE8,0x8C,0xB5), o3(0xE8,0x8C,0xB4),
     o3(0xE8,0x8C,0x96), o3(0xE8,0x8C,0xB2),
     o3(0xE8,0x8C,0xB1), o3(0xE8,0x8D,0x80),
     o3(0xE8,0x8C,0xB9), o3(0xE8,0x8D,0x90),
     o3(0xE8,0x8D,0x85), o3(0xE8,0x8C,0xAF),
     o3(0xE8,0x8C,0xAB), o3(0xE8,0x8C,0x97),
     o3(0xE8,0x8C,0x98), o3(0xE8,0x8E,0x85),
     o3(0xE8,0x8E,0x9A), o3(0xE8,0x8E,0xAA),
     o3(0xE8,0x8E,0x9F), o3(0xE8,0x8E,0xA2),
     o3(0xE8,0x8E,0x96), o3(0xE8,0x8C,0xA3),
     o3(0xE8,0x8E,0x8E), o3(0xE8,0x8E,0x87),
     o3(0xE8,0x8E,0x8A), o3(0xE8,0x8D,0xBC),
     o3(0xE8,0x8E,0xB5), o3(0xE8,0x8D,0xB3),
     o3(0xE8,0x8D,0xB5), o3(0xE8,0x8E,0xA0),
     o3(0xE8,0x8E,0x89), o3(0xE8,0x8E,0xA8),
     o3(0xE8,0x8F,0xB4), o3(0xE8,0x90,0x93),
     o3(0xE8,0x8F,0xAB), o3(0xE8,0x8F,0x8E),
     o3(0xE8,0x8F,0xBD), o3(0xE8,0x90,0x83),
     o3(0xE8,0x8F,0x98), o3(0xE8,0x90,0x8B),
     o3(0xE8,0x8F,0x81), o3(0xE8,0x8F,0xB7),
     o3(0xE8,0x90,0x87), o3(0xE8,0x8F,0xA0),
     o3(0xE8,0x8F,0xB2), o3(0xE8,0x90,0x8D),
     o3(0xE8,0x90,0xA2), o3(0xE8,0x90,0xA0),
     o3(0xE8,0x8E,0xBD), o3(0xE8,0x90,0xB8),
     o3(0xE8,0x94,0x86), o3(0xE8,0x8F,0xBB),
     o3(0xE8,0x91,0xAD), o3(0xE8,0x90,0xAA),
     o3(0xE8,0x90,0xBC), o3(0xE8,0x95,0x9A),
     o3(0xE8,0x92,0x84), o3(0xE8,0x91,0xB7),
     o3(0xE8,0x91,0xAB), o3(0xE8,0x92,0xAD),
     o3(0xE8,0x91,0xAE), o3(0xE8,0x92,0x82),
     o3(0xE8,0x91,0xA9), o3(0xE8,0x91,0x86),
     o3(0xE8,0x90,0xAC), o3(0xE8,0x91,0xAF),
     o3(0xE8,0x91,0xB9), o3(0xE8,0x90,0xB5),
     o3(0xE8,0x93,0x8A), o3(0xE8,0x91,0xA2),
     o3(0xE8,0x92,0xB9), o3(0xE8,0x92,0xBF),
     o3(0xE8,0x92,0x9F), o3(0xE8,0x93,0x99),
     o3(0xE8,0x93,0x8D), o3(0xE8,0x92,0xBB),
     o3(0xE8,0x93,0x9A), o3(0xE8,0x93,0x90),
     o3(0xE8,0x93,0x81), o3(0xE8,0x93,0x86),
     o3(0xE8,0x93,0x96), o3(0xE8,0x92,0xA1),
     o3(0xE8,0x94,0xA1), o3(0xE8,0x93,0xBF),
     o3(0xE8,0x93,0xB4), o3(0xE8,0x94,0x97),
     o3(0xE8,0x94,0x98), o3(0xE8,0x94,0xAC),
     o3(0xE8,0x94,0x9F), o3(0xE8,0x94,0x95),
     o3(0xE8,0x94,0x94), o3(0xE8,0x93,0xBC),
     o3(0xE8,0x95,0x80), o3(0xE8,0x95,0xA3),
     o3(0xE8,0x95,0x98), o3(0xE8,0x95,0x88),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_E4 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_E4_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_E5_infos[189] = {
     o3(0xE8,0x95,0x81), o3(0xE8,0x98,0x82),
     o3(0xE8,0x95,0x8B), o3(0xE8,0x95,0x95),
     o3(0xE8,0x96,0x80), o3(0xE8,0x96,0xA4),
     o3(0xE8,0x96,0x88), o3(0xE8,0x96,0x91),
     o3(0xE8,0x96,0x8A), o3(0xE8,0x96,0xA8),
     o3(0xE8,0x95,0xAD), o3(0xE8,0x96,0x94),
     o3(0xE8,0x96,0x9B), o3(0xE8,0x97,0xAA),
     o3(0xE8,0x96,0x87), o3(0xE8,0x96,0x9C),
     o3(0xE8,0x95,0xB7), o3(0xE8,0x95,0xBE),
     o3(0xE8,0x96,0x90), o3(0xE8,0x97,0x89),
     o3(0xE8,0x96,0xBA), o3(0xE8,0x97,0x8F),
     o3(0xE8,0x96,0xB9), o3(0xE8,0x97,0x90),
     o3(0xE8,0x97,0x95), o3(0xE8,0x97,0x9D),
     o3(0xE8,0x97,0xA5), o3(0xE8,0x97,0x9C),
     o3(0xE8,0x97,0xB9), o3(0xE8,0x98,0x8A),
     o3(0xE8,0x98,0x93), o3(0xE8,0x98,0x8B),
     o3(0xE8,0x97,0xBE), o3(0xE8,0x97,0xBA),
     o3(0xE8,0x98,0x86), o3(0xE8,0x98,0xA2),
     o3(0xE8,0x98,0x9A), o3(0xE8,0x98,0xB0),
     o3(0xE8,0x98,0xBF), o3(0xE8,0x99,0x8D),
     o3(0xE4,0xB9,0x95), o3(0xE8,0x99,0x94),
     o3(0xE8,0x99,0x9F), o3(0xE8,0x99,0xA7),
     o3(0xE8,0x99,0xB1), o3(0xE8,0x9A,0x93),
     o3(0xE8,0x9A,0xA3), o3(0xE8,0x9A,0xA9),
     o3(0xE8,0x9A,0xAA), o3(0xE8,0x9A,0x8B),
     o3(0xE8,0x9A,0x8C), o3(0xE8,0x9A,0xB6),
     o3(0xE8,0x9A,0xAF), o3(0xE8,0x9B,0x84),
     o3(0xE8,0x9B,0x86), o3(0xE8,0x9A,0xB0),
     o3(0xE8,0x9B,0x89), o3(0xE8,0xA0,0xA3),
     o3(0xE8,0x9A,0xAB), o3(0xE8,0x9B,0x94),
     o3(0xE8,0x9B,0x9E), o3(0xE8,0x9B,0xA9),
     o3(0xE8,0x9B,0xAC), o3(0xE8,0x9B,0x9F),
     o3(0xE8,0x9B,0x9B), o3(0xE8,0x9B,0xAF),
     o3(0xE8,0x9C,0x92), o3(0xE8,0x9C,0x86),
     o3(0xE8,0x9C,0x88), o3(0xE8,0x9C,0x80),
     o3(0xE8,0x9C,0x83), o3(0xE8,0x9B,0xBB),
     o3(0xE8,0x9C,0x91), o3(0xE8,0x9C,0x89),
     o3(0xE8,0x9C,0x8D), o3(0xE8,0x9B,0xB9),
     o3(0xE8,0x9C,0x8A), o3(0xE8,0x9C,0xB4),
     o3(0xE8,0x9C,0xBF), o3(0xE8,0x9C,0xB7),
     o3(0xE8,0x9C,0xBB), o3(0xE8,0x9C,0xA5),
     o3(0xE8,0x9C,0xA9), o3(0xE8,0x9C,0x9A),
     o3(0xE8,0x9D,0xA0), o3(0xE8,0x9D,0x9F),
     o3(0xE8,0x9D,0xB8), o3(0xE8,0x9D,0x8C),
     o3(0xE8,0x9D,0x8E), o3(0xE8,0x9D,0xB4),
     o3(0xE8,0x9D,0x97), o3(0xE8,0x9D,0xA8),
     o3(0xE8,0x9D,0xAE), o3(0xE8,0x9D,0x99),
     o3(0xE8,0x9D,0x93), o3(0xE8,0x9D,0xA3),
     o3(0xE8,0x9D,0xAA), o3(0xE8,0xA0,0x85),
     o3(0xE8,0x9E,0xA2), o3(0xE8,0x9E,0x9F),
     o3(0xE8,0x9E,0x82), o3(0xE8,0x9E,0xAF),
     o3(0xE8,0x9F,0x8B), o3(0xE8,0x9E,0xBD),
     o3(0xE8,0x9F,0x80), o3(0xE8,0x9F,0x90),
     o3(0xE9,0x9B,0x96), o3(0xE8,0x9E,0xAB),
     o3(0xE8,0x9F,0x84), o3(0xE8,0x9E,0xB3),
     o3(0xE8,0x9F,0x87), o3(0xE8,0x9F,0x86),
     o3(0xE8,0x9E,0xBB), o3(0xE8,0x9F,0xAF),
     o3(0xE8,0x9F,0xB2), o3(0xE8,0x9F,0xA0),
     o3(0xE8,0xA0,0x8F), o3(0xE8,0xA0,0x8D),
     o3(0xE8,0x9F,0xBE), o3(0xE8,0x9F,0xB6),
     o3(0xE8,0x9F,0xB7), o3(0xE8,0xA0,0x8E),
     o3(0xE8,0x9F,0x92), o3(0xE8,0xA0,0x91),
     o3(0xE8,0xA0,0x96), o3(0xE8,0xA0,0x95),
     o3(0xE8,0xA0,0xA2), o3(0xE8,0xA0,0xA1),
     o3(0xE8,0xA0,0xB1), o3(0xE8,0xA0,0xB6),
     o3(0xE8,0xA0,0xB9), o3(0xE8,0xA0,0xA7),
     o3(0xE8,0xA0,0xBB), o3(0xE8,0xA1,0x84),
     o3(0xE8,0xA1,0x82), o3(0xE8,0xA1,0x92),
     o3(0xE8,0xA1,0x99), o3(0xE8,0xA1,0x9E),
     o3(0xE8,0xA1,0xA2), o3(0xE8,0xA1,0xAB),
     o3(0xE8,0xA2,0x81), o3(0xE8,0xA1,0xBE),
     o3(0xE8,0xA2,0x9E), o3(0xE8,0xA1,0xB5),
     o3(0xE8,0xA1,0xBD), o3(0xE8,0xA2,0xB5),
     o3(0xE8,0xA1,0xB2), o3(0xE8,0xA2,0x82),
     o3(0xE8,0xA2,0x97), o3(0xE8,0xA2,0x92),
     o3(0xE8,0xA2,0xAE), o3(0xE8,0xA2,0x99),
     o3(0xE8,0xA2,0xA2), o3(0xE8,0xA2,0x8D),
     o3(0xE8,0xA2,0xA4), o3(0xE8,0xA2,0xB0),
     o3(0xE8,0xA2,0xBF), o3(0xE8,0xA2,0xB1),
     o3(0xE8,0xA3,0x83), o3(0xE8,0xA3,0x84),
     o3(0xE8,0xA3,0x94), o3(0xE8,0xA3,0x98),
     o3(0xE8,0xA3,0x99), o3(0xE8,0xA3,0x9D),
     o3(0xE8,0xA3,0xB9), o3(0xE8,0xA4,0x82),
     o3(0xE8,0xA3,0xBC), o3(0xE8,0xA3,0xB4),
     o3(0xE8,0xA3,0xA8), o3(0xE8,0xA3,0xB2),
     o3(0xE8,0xA4,0x84), o3(0xE8,0xA4,0x8C),
     o3(0xE8,0xA4,0x8A), o3(0xE8,0xA4,0x93),
     o3(0xE8,0xA5,0x83), o3(0xE8,0xA4,0x9E),
     o3(0xE8,0xA4,0xA5), o3(0xE8,0xA4,0xAA),
     o3(0xE8,0xA4,0xAB), o3(0xE8,0xA5,0x81),
     o3(0xE8,0xA5,0x84), o3(0xE8,0xA4,0xBB),
     o3(0xE8,0xA4,0xB6), o3(0xE8,0xA4,0xB8),
     o3(0xE8,0xA5,0x8C), o3(0xE8,0xA4,0x9D),
     o3(0xE8,0xA5,0xA0), o3(0xE8,0xA5,0x9E),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_E5 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_E5_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_E6_infos[189] = {
     o3(0xE8,0xA5,0xA6), o3(0xE8,0xA5,0xA4),
     o3(0xE8,0xA5,0xAD), o3(0xE8,0xA5,0xAA),
     o3(0xE8,0xA5,0xAF), o3(0xE8,0xA5,0xB4),
     o3(0xE8,0xA5,0xB7), o3(0xE8,0xA5,0xBE),
     o3(0xE8,0xA6,0x83), o3(0xE8,0xA6,0x88),
     o3(0xE8,0xA6,0x8A), o3(0xE8,0xA6,0x93),
     o3(0xE8,0xA6,0x98), o3(0xE8,0xA6,0xA1),
     o3(0xE8,0xA6,0xA9), o3(0xE8,0xA6,0xA6),
     o3(0xE8,0xA6,0xAC), o3(0xE8,0xA6,0xAF),
     o3(0xE8,0xA6,0xB2), o3(0xE8,0xA6,0xBA),
     o3(0xE8,0xA6,0xBD), o3(0xE8,0xA6,0xBF),
     o3(0xE8,0xA7,0x80), o3(0xE8,0xA7,0x9A),
     o3(0xE8,0xA7,0x9C), o3(0xE8,0xA7,0x9D),
     o3(0xE8,0xA7,0xA7), o3(0xE8,0xA7,0xB4),
     o3(0xE8,0xA7,0xB8), o3(0xE8,0xA8,0x83),
     o3(0xE8,0xA8,0x96), o3(0xE8,0xA8,0x90),
     o3(0xE8,0xA8,0x8C), o3(0xE8,0xA8,0x9B),
     o3(0xE8,0xA8,0x9D), o3(0xE8,0xA8,0xA5),
     o3(0xE8,0xA8,0xB6), o3(0xE8,0xA9,0x81),
     o3(0xE8,0xA9,0x9B), o3(0xE8,0xA9,0x92),
     o3(0xE8,0xA9,0x86), o3(0xE8,0xA9,0x88),
     o3(0xE8,0xA9,0xBC), o3(0xE8,0xA9,0xAD),
     o3(0xE8,0xA9,0xAC), o3(0xE8,0xA9,0xA2),
     o3(0xE8,0xAA,0x85), o3(0xE8,0xAA,0x82),
     o3(0xE8,0xAA,0x84), o3(0xE8,0xAA,0xA8),
     o3(0xE8,0xAA,0xA1), o3(0xE8,0xAA,0x91),
     o3(0xE8,0xAA,0xA5), o3(0xE8,0xAA,0xA6),
     o3(0xE8,0xAA,0x9A), o3(0xE8,0xAA,0xA3),
     o3(0xE8,0xAB,0x84), o3(0xE8,0xAB,0x8D),
     o3(0xE8,0xAB,0x82), o3(0xE8,0xAB,0x9A),
     o3(0xE8,0xAB,0xAB), o3(0xE8,0xAB,0xB3),
     o3(0xE8,0xAB,0xA7), o3(0xE8,0xAB,0xA4),
     o3(0xE8,0xAB,0xB1), o3(0xE8,0xAC,0x94),
     o3(0xE8,0xAB,0xA0), o3(0xE8,0xAB,0xA2),
     o3(0xE8,0xAB,0xB7), o3(0xE8,0xAB,0x9E),
     o3(0xE8,0xAB,0x9B), o3(0xE8,0xAC,0x8C),
     o3(0xE8,0xAC,0x87), o3(0xE8,0xAC,0x9A),
     o3(0xE8,0xAB,0xA1), o3(0xE8,0xAC,0x96),
     o3(0xE8,0xAC,0x90), o3(0xE8,0xAC,0x97),
     o3(0xE8,0xAC,0xA0), o3(0xE8,0xAC,0xB3),
     o3(0xE9,0x9E,0xAB), o3(0xE8,0xAC,0xA6),
     o3(0xE8,0xAC,0xAB), o3(0xE8,0xAC,0xBE),
     o3(0xE8,0xAC,0xA8), o3(0xE8,0xAD,0x81),
     o3(0xE8,0xAD,0x8C), o3(0xE8,0xAD,0x8F),
     o3(0xE8,0xAD,0x8E), o3(0xE8,0xAD,0x89),
     o3(0xE8,0xAD,0x96), o3(0xE8,0xAD,0x9B),
     o3(0xE8,0xAD,0x9A), o3(0xE8,0xAD,0xAB),
     o3(0xE8,0xAD,0x9F), o3(0xE8,0xAD,0xAC),
     o3(0xE8,0xAD,0xAF), o3(0xE8,0xAD,0xB4),
     o3(0xE8,0xAD,0xBD), o3(0xE8,0xAE,0x80),
     o3(0xE8,0xAE,0x8C), o3(0xE8,0xAE,0x8E),
     o3(0xE8,0xAE,0x92), o3(0xE8,0xAE,0x93),
     o3(0xE8,0xAE,0x96), o3(0xE8,0xAE,0x99),
     o3(0xE8,0xAE,0x9A), o3(0xE8,0xB0,0xBA),
     o3(0xE8,0xB1,0x81), o3(0xE8,0xB0,0xBF),
     o3(0xE8,0xB1,0x88), o3(0xE8,0xB1,0x8C),
     o3(0xE8,0xB1,0x8E), o3(0xE8,0xB1,0x90),
     o3(0xE8,0xB1,0x95), o3(0xE8,0xB1,0xA2),
     o3(0xE8,0xB1,0xAC), o3(0xE8,0xB1,0xB8),
     o3(0xE8,0xB1,0xBA), o3(0xE8,0xB2,0x82),
     o3(0xE8,0xB2,0x89), o3(0xE8,0xB2,0x85),
     o3(0xE8,0xB2,0x8A), o3(0xE8,0xB2,0x8D),
     o3(0xE8,0xB2,0x8E), o3(0xE8,0xB2,0x94),
     o3(0xE8,0xB1,0xBC), o3(0xE8,0xB2,0x98),
     o3(0xE6,0x88,0x9D), o3(0xE8,0xB2,0xAD),
     o3(0xE8,0xB2,0xAA), o3(0xE8,0xB2,0xBD),
     o3(0xE8,0xB2,0xB2), o3(0xE8,0xB2,0xB3),
     o3(0xE8,0xB2,0xAE), o3(0xE8,0xB2,0xB6),
     o3(0xE8,0xB3,0x88), o3(0xE8,0xB3,0x81),
     o3(0xE8,0xB3,0xA4), o3(0xE8,0xB3,0xA3),
     o3(0xE8,0xB3,0x9A), o3(0xE8,0xB3,0xBD),
     o3(0xE8,0xB3,0xBA), o3(0xE8,0xB3,0xBB),
     o3(0xE8,0xB4,0x84), o3(0xE8,0xB4,0x85),
     o3(0xE8,0xB4,0x8A), o3(0xE8,0xB4,0x87),
     o3(0xE8,0xB4,0x8F), o3(0xE8,0xB4,0x8D),
     o3(0xE8,0xB4,0x90), o3(0xE9,0xBD,0x8E),
     o3(0xE8,0xB4,0x93), o3(0xE8,0xB3,0x8D),
     o3(0xE8,0xB4,0x94), o3(0xE8,0xB4,0x96),
     o3(0xE8,0xB5,0xA7), o3(0xE8,0xB5,0xAD),
     o3(0xE8,0xB5,0xB1), o3(0xE8,0xB5,0xB3),
     o3(0xE8,0xB6,0x81), o3(0xE8,0xB6,0x99),
     o3(0xE8,0xB7,0x82), o3(0xE8,0xB6,0xBE),
     o3(0xE8,0xB6,0xBA), o3(0xE8,0xB7,0x8F),
     o3(0xE8,0xB7,0x9A), o3(0xE8,0xB7,0x96),
     o3(0xE8,0xB7,0x8C), o3(0xE8,0xB7,0x9B),
     o3(0xE8,0xB7,0x8B), o3(0xE8,0xB7,0xAA),
     o3(0xE8,0xB7,0xAB), o3(0xE8,0xB7,0x9F),
     o3(0xE8,0xB7,0xA3), o3(0xE8,0xB7,0xBC),
     o3(0xE8,0xB8,0x88), o3(0xE8,0xB8,0x89),
     o3(0xE8,0xB7,0xBF), o3(0xE8,0xB8,0x9D),
     o3(0xE8,0xB8,0x9E), o3(0xE8,0xB8,0x90),
     o3(0xE8,0xB8,0x9F), o3(0xE8,0xB9,0x82),
     o3(0xE8,0xB8,0xB5), o3(0xE8,0xB8,0xB0),
     o3(0xE8,0xB8,0xB4), o3(0xE8,0xB9,0x8A),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_E6 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_E6_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_E7_infos[189] = {
     o3(0xE8,0xB9,0x87), o3(0xE8,0xB9,0x89),
     o3(0xE8,0xB9,0x8C), o3(0xE8,0xB9,0x90),
     o3(0xE8,0xB9,0x88), o3(0xE8,0xB9,0x99),
     o3(0xE8,0xB9,0xA4), o3(0xE8,0xB9,0xA0),
     o3(0xE8,0xB8,0xAA), o3(0xE8,0xB9,0xA3),
     o3(0xE8,0xB9,0x95), o3(0xE8,0xB9,0xB6),
     o3(0xE8,0xB9,0xB2), o3(0xE8,0xB9,0xBC),
     o3(0xE8,0xBA,0x81), o3(0xE8,0xBA,0x87),
     o3(0xE8,0xBA,0x85), o3(0xE8,0xBA,0x84),
     o3(0xE8,0xBA,0x8B), o3(0xE8,0xBA,0x8A),
     o3(0xE8,0xBA,0x93), o3(0xE8,0xBA,0x91),
     o3(0xE8,0xBA,0x94), o3(0xE8,0xBA,0x99),
     o3(0xE8,0xBA,0xAA), o3(0xE8,0xBA,0xA1),
     o3(0xE8,0xBA,0xAC), o3(0xE8,0xBA,0xB0),
     o3(0xE8,0xBB,0x86), o3(0xE8,0xBA,0xB1),
     o3(0xE8,0xBA,0xBE), o3(0xE8,0xBB,0x85),
     o3(0xE8,0xBB,0x88), o3(0xE8,0xBB,0x8B),
     o3(0xE8,0xBB,0x9B), o3(0xE8,0xBB,0xA3),
     o3(0xE8,0xBB,0xBC), o3(0xE8,0xBB,0xBB),
     o3(0xE8,0xBB,0xAB), o3(0xE8,0xBB,0xBE),
     o3(0xE8,0xBC,0x8A), o3(0xE8,0xBC,0x85),
     o3(0xE8,0xBC,0x95), o3(0xE8,0xBC,0x92),
     o3(0xE8,0xBC,0x99), o3(0xE8,0xBC,0x93),
     o3(0xE8,0xBC,0x9C), o3(0xE8,0xBC,0x9F),
     o3(0xE8,0xBC,0x9B), o3(0xE8,0xBC,0x8C),
     o3(0xE8,0xBC,0xA6), o3(0xE8,0xBC,0xB3),
     o3(0xE8,0xBC,0xBB), o3(0xE8,0xBC,0xB9),
     o3(0xE8,0xBD,0x85), o3(0xE8,0xBD,0x82),
     o3(0xE8,0xBC,0xBE), o3(0xE8,0xBD,0x8C),
     o3(0xE8,0xBD,0x89), o3(0xE8,0xBD,0x86),
     o3(0xE8,0xBD,0x8E), o3(0xE8,0xBD,0x97),
     o3(0xE8,0xBD,0x9C), o3(0xE8,0xBD,0xA2),
     o3(0xE8,0xBD,0xA3), o3(0xE8,0xBD,0xA4),
     o3(0xE8,0xBE,0x9C), o3(0xE8,0xBE,0x9F),
     o3(0xE8,0xBE,0xA3), o3(0xE8,0xBE,0xAD),
     o3(0xE8,0xBE,0xAF), o3(0xE8,0xBE,0xB7),
     o3(0xE8,0xBF,0x9A), o3(0xE8,0xBF,0xA5),
     o3(0xE8,0xBF,0xA2), o3(0xE8,0xBF,0xAA),
     o3(0xE8,0xBF,0xAF), o3(0xE9,0x82,0x87),
     o3(0xE8,0xBF,0xB4), o3(0xE9,0x80,0x85),
     o3(0xE8,0xBF,0xB9), o3(0xE8,0xBF,0xBA),
     o3(0xE9,0x80,0x91), o3(0xE9,0x80,0x95),
     o3(0xE9,0x80,0xA1), o3(0xE9,0x80,0x8D),
     o3(0xE9,0x80,0x9E), o3(0xE9,0x80,0x96),
     o3(0xE9,0x80,0x8B), o3(0xE9,0x80,0xA7),
     o3(0xE9,0x80,0xB6), o3(0xE9,0x80,0xB5),
     o3(0xE9,0x80,0xB9), o3(0xE8,0xBF,0xB8),
     o3(0xE9,0x81,0x8F), o3(0xE9,0x81,0x90),
     o3(0xE9,0x81,0x91), o3(0xE9,0x81,0x92),
     o3(0xE9,0x80,0x8E), o3(0xE9,0x81,0x89),
     o3(0xE9,0x80,0xBE), o3(0xE9,0x81,0x96),
     o3(0xE9,0x81,0x98), o3(0xE9,0x81,0x9E),
     o3(0xE9,0x81,0xA8), o3(0xE9,0x81,0xAF),
     o3(0xE9,0x81,0xB6), o3(0xE9,0x9A,0xA8),
     o3(0xE9,0x81,0xB2), o3(0xE9,0x82,0x82),
     o3(0xE9,0x81,0xBD), o3(0xE9,0x82,0x81),
     o3(0xE9,0x82,0x80), o3(0xE9,0x82,0x8A),
     o3(0xE9,0x82,0x89), o3(0xE9,0x82,0x8F),
     o3(0xE9,0x82,0xA8), o3(0xE9,0x82,0xAF),
     o3(0xE9,0x82,0xB1), o3(0xE9,0x82,0xB5),
     o3(0xE9,0x83,0xA2), o3(0xE9,0x83,0xA4),
     o3(0xE6,0x89,0x88), o3(0xE9,0x83,0x9B),
     o3(0xE9,0x84,0x82), o3(0xE9,0x84,0x92),
     o3(0xE9,0x84,0x99), o3(0xE9,0x84,0xB2),
     o3(0xE9,0x84,0xB0), o3(0xE9,0x85,0x8A),
     o3(0xE9,0x85,0x96), o3(0xE9,0x85,0x98),
     o3(0xE9,0x85,0xA3), o3(0xE9,0x85,0xA5),
     o3(0xE9,0x85,0xA9), o3(0xE9,0x85,0xB3),
     o3(0xE9,0x85,0xB2), o3(0xE9,0x86,0x8B),
     o3(0xE9,0x86,0x89), o3(0xE9,0x86,0x82),
     o3(0xE9,0x86,0xA2), o3(0xE9,0x86,0xAB),
     o3(0xE9,0x86,0xAF), o3(0xE9,0x86,0xAA),
     o3(0xE9,0x86,0xB5), o3(0xE9,0x86,0xB4),
     o3(0xE9,0x86,0xBA), o3(0xE9,0x87,0x80),
     o3(0xE9,0x87,0x81), o3(0xE9,0x87,0x89),
     o3(0xE9,0x87,0x8B), o3(0xE9,0x87,0x90),
     o3(0xE9,0x87,0x96), o3(0xE9,0x87,0x9F),
     o3(0xE9,0x87,0xA1), o3(0xE9,0x87,0x9B),
     o3(0xE9,0x87,0xBC), o3(0xE9,0x87,0xB5),
     o3(0xE9,0x87,0xB6), o3(0xE9,0x88,0x9E),
     o3(0xE9,0x87,0xBF), o3(0xE9,0x88,0x94),
     o3(0xE9,0x88,0xAC), o3(0xE9,0x88,0x95),
     o3(0xE9,0x88,0x91), o3(0xE9,0x89,0x9E),
     o3(0xE9,0x89,0x97), o3(0xE9,0x89,0x85),
     o3(0xE9,0x89,0x89), o3(0xE9,0x89,0xA4),
     o3(0xE9,0x89,0x88), o3(0xE9,0x8A,0x95),
     o3(0xE9,0x88,0xBF), o3(0xE9,0x89,0x8B),
     o3(0xE9,0x89,0x90), o3(0xE9,0x8A,0x9C),
     o3(0xE9,0x8A,0x96), o3(0xE9,0x8A,0x93),
     o3(0xE9,0x8A,0x9B), o3(0xE9,0x89,0x9A),
     o3(0xE9,0x8B,0x8F), o3(0xE9,0x8A,0xB9),
     o3(0xE9,0x8A,0xB7), o3(0xE9,0x8B,0xA9),
     o3(0xE9,0x8C,0x8F), o3(0xE9,0x8B,0xBA),
     o3(0xE9,0x8D,0x84), o3(0xE9,0x8C,0xAE),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_E7 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_E7_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_E8_infos[189] = {
     o3(0xE9,0x8C,0x99), o3(0xE9,0x8C,0xA2),
     o3(0xE9,0x8C,0x9A), o3(0xE9,0x8C,0xA3),
     o3(0xE9,0x8C,0xBA), o3(0xE9,0x8C,0xB5),
     o3(0xE9,0x8C,0xBB), o3(0xE9,0x8D,0x9C),
     o3(0xE9,0x8D,0xA0), o3(0xE9,0x8D,0xBC),
     o3(0xE9,0x8D,0xAE), o3(0xE9,0x8D,0x96),
     o3(0xE9,0x8E,0xB0), o3(0xE9,0x8E,0xAC),
     o3(0xE9,0x8E,0xAD), o3(0xE9,0x8E,0x94),
     o3(0xE9,0x8E,0xB9), o3(0xE9,0x8F,0x96),
     o3(0xE9,0x8F,0x97), o3(0xE9,0x8F,0xA8),
     o3(0xE9,0x8F,0xA5), o3(0xE9,0x8F,0x98),
     o3(0xE9,0x8F,0x83), o3(0xE9,0x8F,0x9D),
     o3(0xE9,0x8F,0x90), o3(0xE9,0x8F,0x88),
     o3(0xE9,0x8F,0xA4), o3(0xE9,0x90,0x9A),
     o3(0xE9,0x90,0x94), o3(0xE9,0x90,0x93),
     o3(0xE9,0x90,0x83), o3(0xE9,0x90,0x87),
     o3(0xE9,0x90,0x90), o3(0xE9,0x90,0xB6),
     o3(0xE9,0x90,0xAB), o3(0xE9,0x90,0xB5),
     o3(0xE9,0x90,0xA1), o3(0xE9,0x90,0xBA),
     o3(0xE9,0x91,0x81), o3(0xE9,0x91,0x92),
     o3(0xE9,0x91,0x84), o3(0xE9,0x91,0x9B),
     o3(0xE9,0x91,0xA0), o3(0xE9,0x91,0xA2),
     o3(0xE9,0x91,0x9E), o3(0xE9,0x91,0xAA),
     o3(0xE9,0x88,0xA9), o3(0xE9,0x91,0xB0),
     o3(0xE9,0x91,0xB5), o3(0xE9,0x91,0xB7),
     o3(0xE9,0x91,0xBD), o3(0xE9,0x91,0x9A),
     o3(0xE9,0x91,0xBC), o3(0xE9,0x91,0xBE),
     o3(0xE9,0x92,0x81), o3(0xE9,0x91,0xBF),
     o3(0xE9,0x96,0x82), o3(0xE9,0x96,0x87),
     o3(0xE9,0x96,0x8A), o3(0xE9,0x96,0x94),
     o3(0xE9,0x96,0x96), o3(0xE9,0x96,0x98),
     o3(0xE9,0x96,0x99), o3(0xE9,0x96,0xA0),
     o3(0xE9,0x96,0xA8), o3(0xE9,0x96,0xA7),
     o3(0xE9,0x96,0xAD), o3(0xE9,0x96,0xBC),
     o3(0xE9,0x96,0xBB), o3(0xE9,0x96,0xB9),
     o3(0xE9,0x96,0xBE), o3(0xE9,0x97,0x8A),
     o3(0xE6,0xBF,0xB6), o3(0xE9,0x97,0x83),
     o3(0xE9,0x97,0x8D), o3(0xE9,0x97,0x8C),
     o3(0xE9,0x97,0x95), o3(0xE9,0x97,0x94),
     o3(0xE9,0x97,0x96), o3(0xE9,0x97,0x9C),
     o3(0xE9,0x97,0xA1), o3(0xE9,0x97,0xA5),
     o3(0xE9,0x97,0xA2), o3(0xE9,0x98,0xA1),
     o3(0xE9,0x98,0xA8), o3(0xE9,0x98,0xAE),
     o3(0xE9,0x98,0xAF), o3(0xE9,0x99,0x82),
     o3(0xE9,0x99,0x8C), o3(0xE9,0x99,0x8F),
     o3(0xE9,0x99,0x8B), o3(0xE9,0x99,0xB7),
     o3(0xE9,0x99,0x9C), o3(0xE9,0x99,0x9E),
     o3(0xE9,0x99,0x9D), o3(0xE9,0x99,0x9F),
     o3(0xE9,0x99,0xA6), o3(0xE9,0x99,0xB2),
     o3(0xE9,0x99,0xAC), o3(0xE9,0x9A,0x8D),
     o3(0xE9,0x9A,0x98), o3(0xE9,0x9A,0x95),
     o3(0xE9,0x9A,0x97), o3(0xE9,0x9A,0xAA),
     o3(0xE9,0x9A,0xA7), o3(0xE9,0x9A,0xB1),
     o3(0xE9,0x9A,0xB2), o3(0xE9,0x9A,0xB0),
     o3(0xE9,0x9A,0xB4), o3(0xE9,0x9A,0xB6),
     o3(0xE9,0x9A,0xB8), o3(0xE9,0x9A,0xB9),
     o3(0xE9,0x9B,0x8E), o3(0xE9,0x9B,0x8B),
     o3(0xE9,0x9B,0x89), o3(0xE9,0x9B,0x8D),
     o3(0xE8,0xA5,0x8D), o3(0xE9,0x9B,0x9C),
     o3(0xE9,0x9C,0x8D), o3(0xE9,0x9B,0x95),
     o3(0xE9,0x9B,0xB9), o3(0xE9,0x9C,0x84),
     o3(0xE9,0x9C,0x86), o3(0xE9,0x9C,0x88),
     o3(0xE9,0x9C,0x93), o3(0xE9,0x9C,0x8E),
     o3(0xE9,0x9C,0x91), o3(0xE9,0x9C,0x8F),
     o3(0xE9,0x9C,0x96), o3(0xE9,0x9C,0x99),
     o3(0xE9,0x9C,0xA4), o3(0xE9,0x9C,0xAA),
     o3(0xE9,0x9C,0xB0), o3(0xE9,0x9C,0xB9),
     o3(0xE9,0x9C,0xBD), o3(0xE9,0x9C,0xBE),
     o3(0xE9,0x9D,0x84), o3(0xE9,0x9D,0x86),
     o3(0xE9,0x9D,0x88), o3(0xE9,0x9D,0x82),
     o3(0xE9,0x9D,0x89), o3(0xE9,0x9D,0x9C),
     o3(0xE9,0x9D,0xA0), o3(0xE9,0x9D,0xA4),
     o3(0xE9,0x9D,0xA6), o3(0xE9,0x9D,0xA8),
     o3(0xE5,0x8B,0x92), o3(0xE9,0x9D,0xAB),
     o3(0xE9,0x9D,0xB1), o3(0xE9,0x9D,0xB9),
     o3(0xE9,0x9E,0x85), o3(0xE9,0x9D,0xBC),
     o3(0xE9,0x9E,0x81), o3(0xE9,0x9D,0xBA),
     o3(0xE9,0x9E,0x86), o3(0xE9,0x9E,0x8B),
     o3(0xE9,0x9E,0x8F), o3(0xE9,0x9E,0x90),
     o3(0xE9,0x9E,0x9C), o3(0xE9,0x9E,0xA8),
     o3(0xE9,0x9E,0xA6), o3(0xE9,0x9E,0xA3),
     o3(0xE9,0x9E,0xB3), o3(0xE9,0x9E,0xB4),
     o3(0xE9,0x9F,0x83), o3(0xE9,0x9F,0x86),
     o3(0xE9,0x9F,0x88), o3(0xE9,0x9F,0x8B),
     o3(0xE9,0x9F,0x9C), o3(0xE9,0x9F,0xAD),
     o3(0xE9,0xBD,0x8F), o3(0xE9,0x9F,0xB2),
     o3(0xE7,0xAB,0x9F), o3(0xE9,0x9F,0xB6),
     o3(0xE9,0x9F,0xB5), o3(0xE9,0xA0,0x8F),
     o3(0xE9,0xA0,0x8C), o3(0xE9,0xA0,0xB8),
     o3(0xE9,0xA0,0xA4), o3(0xE9,0xA0,0xA1),
     o3(0xE9,0xA0,0xB7), o3(0xE9,0xA0,0xBD),
     o3(0xE9,0xA1,0x86), o3(0xE9,0xA1,0x8F),
     o3(0xE9,0xA1,0x8B), o3(0xE9,0xA1,0xAB),
     o3(0xE9,0xA1,0xAF), o3(0xE9,0xA1,0xB0),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_E8 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_E8_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_E9_infos[189] = {
     o3(0xE9,0xA1,0xB1), o3(0xE9,0xA1,0xB4),
     o3(0xE9,0xA1,0xB3), o3(0xE9,0xA2,0xAA),
     o3(0xE9,0xA2,0xAF), o3(0xE9,0xA2,0xB1),
     o3(0xE9,0xA2,0xB6), o3(0xE9,0xA3,0x84),
     o3(0xE9,0xA3,0x83), o3(0xE9,0xA3,0x86),
     o3(0xE9,0xA3,0xA9), o3(0xE9,0xA3,0xAB),
     o3(0xE9,0xA4,0x83), o3(0xE9,0xA4,0x89),
     o3(0xE9,0xA4,0x92), o3(0xE9,0xA4,0x94),
     o3(0xE9,0xA4,0x98), o3(0xE9,0xA4,0xA1),
     o3(0xE9,0xA4,0x9D), o3(0xE9,0xA4,0x9E),
     o3(0xE9,0xA4,0xA4), o3(0xE9,0xA4,0xA0),
     o3(0xE9,0xA4,0xAC), o3(0xE9,0xA4,0xAE),
     o3(0xE9,0xA4,0xBD), o3(0xE9,0xA4,0xBE),
     o3(0xE9,0xA5,0x82), o3(0xE9,0xA5,0x89),
     o3(0xE9,0xA5,0x85), o3(0xE9,0xA5,0x90),
     o3(0xE9,0xA5,0x8B), o3(0xE9,0xA5,0x91),
     o3(0xE9,0xA5,0x92), o3(0xE9,0xA5,0x8C),
     o3(0xE9,0xA5,0x95), o3(0xE9,0xA6,0x97),
     o3(0xE9,0xA6,0x98), o3(0xE9,0xA6,0xA5),
     o3(0xE9,0xA6,0xAD), o3(0xE9,0xA6,0xAE),
     o3(0xE9,0xA6,0xBC), o3(0xE9,0xA7,0x9F),
     o3(0xE9,0xA7,0x9B), o3(0xE9,0xA7,0x9D),
     o3(0xE9,0xA7,0x98), o3(0xE9,0xA7,0x91),
     o3(0xE9,0xA7,0xAD), o3(0xE9,0xA7,0xAE),
     o3(0xE9,0xA7,0xB1), o3(0xE9,0xA7,0xB2),
     o3(0xE9,0xA7,0xBB), o3(0xE9,0xA7,0xB8),
     o3(0xE9,0xA8,0x81), o3(0xE9,0xA8,0x8F),
     o3(0xE9,0xA8,0x85), o3(0xE9,0xA7,0xA2),
     o3(0xE9,0xA8,0x99), o3(0xE9,0xA8,0xAB),
     o3(0xE9,0xA8,0xB7), o3(0xE9,0xA9,0x85),
     o3(0xE9,0xA9,0x82), o3(0xE9,0xA9,0x80),
     o3(0xE9,0xA9,0x83), o3(0xE9,0xA8,0xBE),
     o3(0xE9,0xA9,0x95), o3(0xE9,0xA9,0x8D),
     o3(0xE9,0xA9,0x9B), o3(0xE9,0xA9,0x97),
     o3(0xE9,0xA9,0x9F), o3(0xE9,0xA9,0xA2),
     o3(0xE9,0xA9,0xA5), o3(0xE9,0xA9,0xA4),
     o3(0xE9,0xA9,0xA9), o3(0xE9,0xA9,0xAB),
     o3(0xE9,0xA9,0xAA), o3(0xE9,0xAA,0xAD),
     o3(0xE9,0xAA,0xB0), o3(0xE9,0xAA,0xBC),
     o3(0xE9,0xAB,0x80), o3(0xE9,0xAB,0x8F),
     o3(0xE9,0xAB,0x91), o3(0xE9,0xAB,0x93),
     o3(0xE9,0xAB,0x94), o3(0xE9,0xAB,0x9E),
     o3(0xE9,0xAB,0x9F), o3(0xE9,0xAB,0xA2),
     o3(0xE9,0xAB,0xA3), o3(0xE9,0xAB,0xA6),
     o3(0xE9,0xAB,0xAF), o3(0xE9,0xAB,0xAB),
     o3(0xE9,0xAB,0xAE), o3(0xE9,0xAB,0xB4),
     o3(0xE9,0xAB,0xB1), o3(0xE9,0xAB,0xB7),
     o3(0xE9,0xAB,0xBB), o3(0xE9,0xAC,0x86),
     o3(0xE9,0xAC,0x98), o3(0xE9,0xAC,0x9A),
     o3(0xE9,0xAC,0x9F), o3(0xE9,0xAC,0xA2),
     o3(0xE9,0xAC,0xA3), o3(0xE9,0xAC,0xA5),
     o3(0xE9,0xAC,0xA7), o3(0xE9,0xAC,0xA8),
     o3(0xE9,0xAC,0xA9), o3(0xE9,0xAC,0xAA),
     o3(0xE9,0xAC,0xAE), o3(0xE9,0xAC,0xAF),
     o3(0xE9,0xAC,0xB2), o3(0xE9,0xAD,0x84),
     o3(0xE9,0xAD,0x83), o3(0xE9,0xAD,0x8F),
     o3(0xE9,0xAD,0x8D), o3(0xE9,0xAD,0x8E),
     o3(0xE9,0xAD,0x91), o3(0xE9,0xAD,0x98),
     o3(0xE9,0xAD,0xB4), o3(0xE9,0xAE,0x93),
     o3(0xE9,0xAE,0x83), o3(0xE9,0xAE,0x91),
     o3(0xE9,0xAE,0x96), o3(0xE9,0xAE,0x97),
     o3(0xE9,0xAE,0x9F), o3(0xE9,0xAE,0xA0),
     o3(0xE9,0xAE,0xA8), o3(0xE9,0xAE,0xB4),
     o3(0xE9,0xAF,0x80), o3(0xE9,0xAF,0x8A),
     o3(0xE9,0xAE,0xB9), o3(0xE9,0xAF,0x86),
     o3(0xE9,0xAF,0x8F), o3(0xE9,0xAF,0x91),
     o3(0xE9,0xAF,0x92), o3(0xE9,0xAF,0xA3),
     o3(0xE9,0xAF,0xA2), o3(0xE9,0xAF,0xA4),
     o3(0xE9,0xAF,0x94), o3(0xE9,0xAF,0xA1),
     o3(0xE9,0xB0,0xBA), o3(0xE9,0xAF,0xB2),
     o3(0xE9,0xAF,0xB1), o3(0xE9,0xAF,0xB0),
     o3(0xE9,0xB0,0x95), o3(0xE9,0xB0,0x94),
     o3(0xE9,0xB0,0x89), o3(0xE9,0xB0,0x93),
     o3(0xE9,0xB0,0x8C), o3(0xE9,0xB0,0x86),
     o3(0xE9,0xB0,0x88), o3(0xE9,0xB0,0x92),
     o3(0xE9,0xB0,0x8A), o3(0xE9,0xB0,0x84),
     o3(0xE9,0xB0,0xAE), o3(0xE9,0xB0,0x9B),
     o3(0xE9,0xB0,0xA5), o3(0xE9,0xB0,0xA4),
     o3(0xE9,0xB0,0xA1), o3(0xE9,0xB0,0xB0),
     o3(0xE9,0xB1,0x87), o3(0xE9,0xB0,0xB2),
     o3(0xE9,0xB1,0x86), o3(0xE9,0xB0,0xBE),
     o3(0xE9,0xB1,0x9A), o3(0xE9,0xB1,0xA0),
     o3(0xE9,0xB1,0xA7), o3(0xE9,0xB1,0xB6),
     o3(0xE9,0xB1,0xB8), o3(0xE9,0xB3,0xA7),
     o3(0xE9,0xB3,0xAC), o3(0xE9,0xB3,0xB0),
     o3(0xE9,0xB4,0x89), o3(0xE9,0xB4,0x88),
     o3(0xE9,0xB3,0xAB), o3(0xE9,0xB4,0x83),
     o3(0xE9,0xB4,0x86), o3(0xE9,0xB4,0xAA),
     o3(0xE9,0xB4,0xA6), o3(0xE9,0xB6,0xAF),
     o3(0xE9,0xB4,0xA3), o3(0xE9,0xB4,0x9F),
     o3(0xE9,0xB5,0x84), o3(0xE9,0xB4,0x95),
     o3(0xE9,0xB4,0x92), o3(0xE9,0xB5,0x81),
     o3(0xE9,0xB4,0xBF), o3(0xE9,0xB4,0xBE),
     o3(0xE9,0xB5,0x86), o3(0xE9,0xB5,0x88),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_E9 = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_E9_infos
};

static const unsigned char
from_SHIFT_JIS_EA_offsets[256] = {
    100,100,100,100,100,100,100,100,  100,100,100,100,100,100,100,100,
    100,100,100,100,100,100,100,100,  100,100,100,100,100,100,100,100,
    100,100,100,100,100,100,100,100,  100,100,100,100,100,100,100,100,
    100,100,100,100,100,100,100,100,  100,100,100,100,100,100,100,100,
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,   24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39,   40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55,   56, 57, 58, 59, 60, 61, 62,100,
     63, 64, 65, 66, 67, 68, 69, 70,   71, 72, 73, 74, 75, 76, 77, 78,
     79, 80, 81, 82, 83, 84, 85, 86,   87, 88, 89, 90, 91, 92, 93, 94,
     95, 96, 97, 98, 99,100,100,100,  100,100,100,100,100,100,100,100,
    100,100,100,100,100,100,100,100,  100,100,100,100,100,100,100,100,
    100,100,100,100,100,100,100,100,  100,100,100,100,100,100,100,100,
    100,100,100,100,100,100,100,100,  100,100,100,100,100,100,100,100,
    100,100,100,100,100,100,100,100,  100,100,100,100,100,100,100,100,
    100,100,100,100,100,100,100,100,  100,100,100,100,100,100,100,100,
};
static const struct byte_lookup* const
from_SHIFT_JIS_EA_infos[101] = {
     o3(0xE9,0xB5,0x9D), o3(0xE9,0xB5,0x9E),
     o3(0xE9,0xB5,0xA4), o3(0xE9,0xB5,0x91),
     o3(0xE9,0xB5,0x90), o3(0xE9,0xB5,0x99),
     o3(0xE9,0xB5,0xB2), o3(0xE9,0xB6,0x89),
     o3(0xE9,0xB6,0x87), o3(0xE9,0xB6,0xAB),
     o3(0xE9,0xB5,0xAF), o3(0xE9,0xB5,0xBA),
     o3(0xE9,0xB6,0x9A), o3(0xE9,0xB6,0xA4),
     o3(0xE9,0xB6,0xA9), o3(0xE9,0xB6,0xB2),
     o3(0xE9,0xB7,0x84), o3(0xE9,0xB7,0x81),
     o3(0xE9,0xB6,0xBB), o3(0xE9,0xB6,0xB8),
     o3(0xE9,0xB6,0xBA), o3(0xE9,0xB7,0x86),
     o3(0xE9,0xB7,0x8F), o3(0xE9,0xB7,0x82),
     o3(0xE9,0xB7,0x99), o3(0xE9,0xB7,0x93),
     o3(0xE9,0xB7,0xB8), o3(0xE9,0xB7,0xA6),
     o3(0xE9,0xB7,0xAD), o3(0xE9,0xB7,0xAF),
     o3(0xE9,0xB7,0xBD), o3(0xE9,0xB8,0x9A),
     o3(0xE9,0xB8,0x9B), o3(0xE9,0xB8,0x9E),
     o3(0xE9,0xB9,0xB5), o3(0xE9,0xB9,0xB9),
     o3(0xE9,0xB9,0xBD), o3(0xE9,0xBA,0x81),
     o3(0xE9,0xBA,0x88), o3(0xE9,0xBA,0x8B),
     o3(0xE9,0xBA,0x8C), o3(0xE9,0xBA,0x92),
     o3(0xE9,0xBA,0x95), o3(0xE9,0xBA,0x91),
     o3(0xE9,0xBA,0x9D), o3(0xE9,0xBA,0xA5),
     o3(0xE9,0xBA,0xA9), o3(0xE9,0xBA,0xB8),
     o3(0xE9,0xBA,0xAA), o3(0xE9,0xBA,0xAD),
     o3(0xE9,0x9D,0xA1), o3(0xE9,0xBB,0x8C),
     o3(0xE9,0xBB,0x8E), o3(0xE9,0xBB,0x8F),
     o3(0xE9,0xBB,0x90), o3(0xE9,0xBB,0x94),
     o3(0xE9,0xBB,0x9C), o3(0xE9,0xBB,0x9E),
     o3(0xE9,0xBB,0x9D), o3(0xE9,0xBB,0xA0),
     o3(0xE9,0xBB,0xA5), o3(0xE9,0xBB,0xA8),
     o3(0xE9,0xBB,0xAF), o3(0xE9,0xBB,0xB4),
     o3(0xE9,0xBB,0xB6), o3(0xE9,0xBB,0xB7),
     o3(0xE9,0xBB,0xB9), o3(0xE9,0xBB,0xBB),
     o3(0xE9,0xBB,0xBC), o3(0xE9,0xBB,0xBD),
     o3(0xE9,0xBC,0x87), o3(0xE9,0xBC,0x88),
     o3(0xE7,0x9A,0xB7), o3(0xE9,0xBC,0x95),
     o3(0xE9,0xBC,0xA1), o3(0xE9,0xBC,0xAC),
     o3(0xE9,0xBC,0xBE), o3(0xE9,0xBD,0x8A),
     o3(0xE9,0xBD,0x92), o3(0xE9,0xBD,0x94),
     o3(0xE9,0xBD,0xA3), o3(0xE9,0xBD,0x9F),
     o3(0xE9,0xBD,0xA0), o3(0xE9,0xBD,0xA1),
     o3(0xE9,0xBD,0xA6), o3(0xE9,0xBD,0xA7),
     o3(0xE9,0xBD,0xAC), o3(0xE9,0xBD,0xAA),
     o3(0xE9,0xBD,0xB7), o3(0xE9,0xBD,0xB2),
     o3(0xE9,0xBD,0xB6), o3(0xE9,0xBE,0x95),
     o3(0xE9,0xBE,0x9C), o3(0xE9,0xBE,0xA0),
     o3(0xE5,0xA0,0xAF), o3(0xE6,0xA7,0x87),
     o3(0xE9,0x81,0x99), o3(0xE7,0x91,0xA4),
     o3(0xE5,0x87,0x9C), o3(0xE7,0x86,0x99),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_EA = {
    from_SHIFT_JIS_EA_offsets,
    from_SHIFT_JIS_EA_infos
};

static const unsigned char
from_SHIFT_JIS_FA_offsets[256] = {
    173,173,173,173,173,173,173,173,  173,173,173,173,173,173,173,173,
    173,173,173,173,173,173,173,173,  173,173,173,173,173,173,173,173,
    173,173,173,173,173,173,173,173,  173,173,173,173,173,173,173,173,
    173,173,173,173,173,173,173,173,  173,173,173,173,173,173,173,173,
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9,173,173,173,173,173,173,
    173,173,173,173,173, 10, 11, 12,  173,173,173,173, 13, 14, 15, 16,
     17, 18, 19, 20, 21, 22, 23, 24,   25, 26, 27, 28, 29, 30, 31, 32,
     33, 34, 35, 36, 37, 38, 39, 40,   41, 42, 43, 44, 45, 46, 47,173,
     48, 49, 50, 51, 52, 53, 54, 55,   56, 57, 58, 59, 60, 61, 62, 63,
     64, 65, 66, 67, 68, 69, 70, 71,   72, 73, 74, 75, 76, 77, 78, 79,
     80, 81, 82, 83, 84, 85, 86, 87,   88, 89, 90, 91, 92, 93, 94, 95,
     96, 97, 98, 99,100,101,102,103,  104,105,106,107,108,109,110,111,
    112,113,114,115,116,117,118,119,  120,121,122,123,124,125,126,127,
    128,129,130,131,132,133,134,135,  136,137,138,139,140,141,142,143,
    144,145,146,147,148,149,150,151,  152,153,154,155,156,157,158,159,
    160,161,162,163,164,165,166,167,  168,169,170,171,172,173,173,173,
};
static const struct byte_lookup* const
from_SHIFT_JIS_FA_infos[174] = {
     o3(0xE2,0x85,0xB0), o3(0xE2,0x85,0xB1),
     o3(0xE2,0x85,0xB2), o3(0xE2,0x85,0xB3),
     o3(0xE2,0x85,0xB4), o3(0xE2,0x85,0xB5),
     o3(0xE2,0x85,0xB6), o3(0xE2,0x85,0xB7),
     o3(0xE2,0x85,0xB8), o3(0xE2,0x85,0xB9),
     o3(0xEF,0xBF,0xA4), o3(0xEF,0xBC,0x87),
     o3(0xEF,0xBC,0x82), o3(0xE7,0xBA,0x8A),
     o3(0xE8,0xA4,0x9C), o3(0xE9,0x8D,0x88),
     o3(0xE9,0x8A,0x88), o3(0xE8,0x93,0x9C),
     o3(0xE4,0xBF,0x89), o3(0xE7,0x82,0xBB),
     o3(0xE6,0x98,0xB1), o3(0xE6,0xA3,0x88),
     o3(0xE9,0x8B,0xB9), o3(0xE6,0x9B,0xBB),
     o3(0xE5,0xBD,0x85), o3(0xE4,0xB8,0xA8),
     o3(0xE4,0xBB,0xA1), o3(0xE4,0xBB,0xBC),
     o3(0xE4,0xBC,0x80), o3(0xE4,0xBC,0x83),
     o3(0xE4,0xBC,0xB9), o3(0xE4,0xBD,0x96),
     o3(0xE4,0xBE,0x92), o3(0xE4,0xBE,0x8A),
     o3(0xE4,0xBE,0x9A), o3(0xE4,0xBE,0x94),
     o3(0xE4,0xBF,0x8D), o3(0xE5,0x81,0x80),
     o3(0xE5,0x80,0xA2), o3(0xE4,0xBF,0xBF),
     o3(0xE5,0x80,0x9E), o3(0xE5,0x81,0x86),
     o3(0xE5,0x81,0xB0), o3(0xE5,0x81,0x82),
     o3(0xE5,0x82,0x94), o3(0xE5,0x83,0xB4),
     o3(0xE5,0x83,0x98), o3(0xE5,0x85,0x8A),
     o3(0xE5,0x85,0xA4), o3(0xE5,0x86,0x9D),
     o3(0xE5,0x86,0xBE), o3(0xE5,0x87,0xAC),
     o3(0xE5,0x88,0x95), o3(0xE5,0x8A,0x9C),
     o3(0xE5,0x8A,0xA6), o3(0xE5,0x8B,0x80),
     o3(0xE5,0x8B,0x9B), o3(0xE5,0x8C,0x80),
     o3(0xE5,0x8C,0x87), o3(0xE5,0x8C,0xA4),
     o3(0xE5,0x8D,0xB2), o3(0xE5,0x8E,0x93),
     o3(0xE5,0x8E,0xB2), o3(0xE5,0x8F,0x9D),
     o3(0xEF,0xA8,0x8E), o3(0xE5,0x92,0x9C),
     o3(0xE5,0x92,0x8A), o3(0xE5,0x92,0xA9),
     o3(0xE5,0x93,0xBF), o3(0xE5,0x96,0x86),
     o3(0xE5,0x9D,0x99), o3(0xE5,0x9D,0xA5),
     o3(0xE5,0x9E,0xAC), o3(0xE5,0x9F,0x88),
     o3(0xE5,0x9F,0x87), o3(0xEF,0xA8,0x8F),
     o3(0xEF,0xA8,0x90), o3(0xE5,0xA2,0x9E),
     o3(0xE5,0xA2,0xB2), o3(0xE5,0xA4,0x8B),
     o3(0xE5,0xA5,0x93), o3(0xE5,0xA5,0x9B),
     o3(0xE5,0xA5,0x9D), o3(0xE5,0xA5,0xA3),
     o3(0xE5,0xA6,0xA4), o3(0xE5,0xA6,0xBA),
     o3(0xE5,0xAD,0x96), o3(0xE5,0xAF,0x80),
     o3(0xE7,0x94,0xAF), o3(0xE5,0xAF,0x98),
     o3(0xE5,0xAF,0xAC), o3(0xE5,0xB0,0x9E),
     o3(0xE5,0xB2,0xA6), o3(0xE5,0xB2,0xBA),
     o3(0xE5,0xB3,0xB5), o3(0xE5,0xB4,0xA7),
     o3(0xE5,0xB5,0x93), o3(0xEF,0xA8,0x91),
     o3(0xE5,0xB5,0x82), o3(0xE5,0xB5,0xAD),
     o3(0xE5,0xB6,0xB8), o3(0xE5,0xB6,0xB9),
     o3(0xE5,0xB7,0x90), o3(0xE5,0xBC,0xA1),
     o3(0xE5,0xBC,0xB4), o3(0xE5,0xBD,0xA7),
     o3(0xE5,0xBE,0xB7), o3(0xE5,0xBF,0x9E),
     o3(0xE6,0x81,0x9D), o3(0xE6,0x82,0x85),
     o3(0xE6,0x82,0x8A), o3(0xE6,0x83,0x9E),
     o3(0xE6,0x83,0x95), o3(0xE6,0x84,0xA0),
     o3(0xE6,0x83,0xB2), o3(0xE6,0x84,0x91),
     o3(0xE6,0x84,0xB7), o3(0xE6,0x84,0xB0),
     o3(0xE6,0x86,0x98), o3(0xE6,0x88,0x93),
     o3(0xE6,0x8A,0xA6), o3(0xE6,0x8F,0xB5),
     o3(0xE6,0x91,0xA0), o3(0xE6,0x92,0x9D),
     o3(0xE6,0x93,0x8E), o3(0xE6,0x95,0x8E),
     o3(0xE6,0x98,0x80), o3(0xE6,0x98,0x95),
     o3(0xE6,0x98,0xBB), o3(0xE6,0x98,0x89),
     o3(0xE6,0x98,0xAE), o3(0xE6,0x98,0x9E),
     o3(0xE6,0x98,0xA4), o3(0xE6,0x99,0xA5),
     o3(0xE6,0x99,0x97), o3(0xE6,0x99,0x99),
     o3(0xEF,0xA8,0x92), o3(0xE6,0x99,0xB3),
     o3(0xE6,0x9A,0x99), o3(0xE6,0x9A,0xA0),
     o3(0xE6,0x9A,0xB2), o3(0xE6,0x9A,0xBF),
     o3(0xE6,0x9B,0xBA), o3(0xE6,0x9C,0x8E),
     o3(0xEF,0xA4,0xA9), o3(0xE6,0x9D,0xA6),
     o3(0xE6,0x9E,0xBB), o3(0xE6,0xA1,0x92),
     o3(0xE6,0x9F,0x80), o3(0xE6,0xA0,0x81),
     o3(0xE6,0xA1,0x84), o3(0xE6,0xA3,0x8F),
     o3(0xEF,0xA8,0x93), o3(0xE6,0xA5,0xA8),
     o3(0xEF,0xA8,0x94), o3(0xE6,0xA6,0x98),
     o3(0xE6,0xA7,0xA2), o3(0xE6,0xA8,0xB0),
     o3(0xE6,0xA9,0xAB), o3(0xE6,0xA9,0x86),
     o3(0xE6,0xA9,0xB3), o3(0xE6,0xA9,0xBE),
     o3(0xE6,0xAB,0xA2), o3(0xE6,0xAB,0xA4),
     o3(0xE6,0xAF,0x96), o3(0xE6,0xB0,0xBF),
     o3(0xE6,0xB1,0x9C), o3(0xE6,0xB2,0x86),
     o3(0xE6,0xB1,0xAF), o3(0xE6,0xB3,0x9A),
     o3(0xE6,0xB4,0x84), o3(0xE6,0xB6,0x87),
     o3(0xE6,0xB5,0xAF),              UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_FA = {
    from_SHIFT_JIS_FA_offsets,
    from_SHIFT_JIS_FA_infos
};

static const struct byte_lookup* const
from_SHIFT_JIS_FB_infos[189] = {
     o3(0xE6,0xB6,0x96), o3(0xE6,0xB6,0xAC),
     o3(0xE6,0xB7,0x8F), o3(0xE6,0xB7,0xB8),
     o3(0xE6,0xB7,0xB2), o3(0xE6,0xB7,0xBC),
     o3(0xE6,0xB8,0xB9), o3(0xE6,0xB9,0x9C),
     o3(0xE6,0xB8,0xA7), o3(0xE6,0xB8,0xBC),
     o3(0xE6,0xBA,0xBF), o3(0xE6,0xBE,0x88),
     o3(0xE6,0xBE,0xB5), o3(0xE6,0xBF,0xB5),
     o3(0xE7,0x80,0x85), o3(0xE7,0x80,0x87),
     o3(0xE7,0x80,0xA8), o3(0xE7,0x82,0x85),
     o3(0xE7,0x82,0xAB), o3(0xE7,0x84,0x8F),
     o3(0xE7,0x84,0x84), o3(0xE7,0x85,0x9C),
     o3(0xE7,0x85,0x86), o3(0xE7,0x85,0x87),
     o3(0xEF,0xA8,0x95), o3(0xE7,0x87,0x81),
     o3(0xE7,0x87,0xBE), o3(0xE7,0x8A,0xB1),
     o3(0xE7,0x8A,0xBE), o3(0xE7,0x8C,0xA4),
     o3(0xEF,0xA8,0x96), o3(0xE7,0x8D,0xB7),
     o3(0xE7,0x8E,0xBD), o3(0xE7,0x8F,0x89),
     o3(0xE7,0x8F,0x96), o3(0xE7,0x8F,0xA3),
     o3(0xE7,0x8F,0x92), o3(0xE7,0x90,0x87),
     o3(0xE7,0x8F,0xB5), o3(0xE7,0x90,0xA6),
     o3(0xE7,0x90,0xAA), o3(0xE7,0x90,0xA9),
     o3(0xE7,0x90,0xAE), o3(0xE7,0x91,0xA2),
     o3(0xE7,0x92,0x89), o3(0xE7,0x92,0x9F),
     o3(0xE7,0x94,0x81), o3(0xE7,0x95,0xAF),
     o3(0xE7,0x9A,0x82), o3(0xE7,0x9A,0x9C),
     o3(0xE7,0x9A,0x9E), o3(0xE7,0x9A,0x9B),
     o3(0xE7,0x9A,0xA6), o3(0xEF,0xA8,0x97),
     o3(0xE7,0x9D,0x86), o3(0xE5,0x8A,0xAF),
     o3(0xE7,0xA0,0xA1), o3(0xE7,0xA1,0x8E),
     o3(0xE7,0xA1,0xA4), o3(0xE7,0xA1,0xBA),
     o3(0xE7,0xA4,0xB0), o3(0xEF,0xA8,0x98),
     o3(0xEF,0xA8,0x99), o3(0xEF,0xA8,0x9A),
     o3(0xE7,0xA6,0x94), o3(0xEF,0xA8,0x9B),
     o3(0xE7,0xA6,0x9B), o3(0xE7,0xAB,0x91),
     o3(0xE7,0xAB,0xA7), o3(0xEF,0xA8,0x9C),
     o3(0xE7,0xAB,0xAB), o3(0xE7,0xAE,0x9E),
     o3(0xEF,0xA8,0x9D), o3(0xE7,0xB5,0x88),
     o3(0xE7,0xB5,0x9C), o3(0xE7,0xB6,0xB7),
     o3(0xE7,0xB6,0xA0), o3(0xE7,0xB7,0x96),
     o3(0xE7,0xB9,0x92), o3(0xE7,0xBD,0x87),
     o3(0xE7,0xBE,0xA1), o3(0xEF,0xA8,0x9E),
     o3(0xE8,0x8C,0x81), o3(0xE8,0x8D,0xA2),
     o3(0xE8,0x8D,0xBF), o3(0xE8,0x8F,0x87),
     o3(0xE8,0x8F,0xB6), o3(0xE8,0x91,0x88),
     o3(0xE8,0x92,0xB4), o3(0xE8,0x95,0x93),
     o3(0xE8,0x95,0x99), o3(0xE8,0x95,0xAB),
     o3(0xEF,0xA8,0x9F), o3(0xE8,0x96,0xB0),
     o3(0xEF,0xA8,0xA0), o3(0xEF,0xA8,0xA1),
     o3(0xE8,0xA0,0x87), o3(0xE8,0xA3,0xB5),
     o3(0xE8,0xA8,0x92), o3(0xE8,0xA8,0xB7),
     o3(0xE8,0xA9,0xB9), o3(0xE8,0xAA,0xA7),
     o3(0xE8,0xAA,0xBE), o3(0xE8,0xAB,0x9F),
     o3(0xEF,0xA8,0xA2), o3(0xE8,0xAB,0xB6),
     o3(0xE8,0xAD,0x93), o3(0xE8,0xAD,0xBF),
     o3(0xE8,0xB3,0xB0), o3(0xE8,0xB3,0xB4),
     o3(0xE8,0xB4,0x92), o3(0xE8,0xB5,0xB6),
     o3(0xEF,0xA8,0xA3), o3(0xE8,0xBB,0x8F),
     o3(0xEF,0xA8,0xA4), o3(0xEF,0xA8,0xA5),
     o3(0xE9,0x81,0xA7), o3(0xE9,0x83,0x9E),
     o3(0xEF,0xA8,0xA6), o3(0xE9,0x84,0x95),
     o3(0xE9,0x84,0xA7), o3(0xE9,0x87,0x9A),
     o3(0xE9,0x87,0x97), o3(0xE9,0x87,0x9E),
     o3(0xE9,0x87,0xAD), o3(0xE9,0x87,0xAE),
     o3(0xE9,0x87,0xA4), o3(0xE9,0x87,0xA5),
     o3(0xE9,0x88,0x86), o3(0xE9,0x88,0x90),
     o3(0xE9,0x88,0x8A), o3(0xE9,0x88,0xBA),
     o3(0xE9,0x89,0x80), o3(0xE9,0x88,0xBC),
     o3(0xE9,0x89,0x8E), o3(0xE9,0x89,0x99),
     o3(0xE9,0x89,0x91), o3(0xE9,0x88,0xB9),
     o3(0xE9,0x89,0xA7), o3(0xE9,0x8A,0xA7),
     o3(0xE9,0x89,0xB7), o3(0xE9,0x89,0xB8),
     o3(0xE9,0x8B,0xA7), o3(0xE9,0x8B,0x97),
     o3(0xE9,0x8B,0x99), o3(0xE9,0x8B,0x90),
     o3(0xEF,0xA8,0xA7), o3(0xE9,0x8B,0x95),
     o3(0xE9,0x8B,0xA0), o3(0xE9,0x8B,0x93),
     o3(0xE9,0x8C,0xA5), o3(0xE9,0x8C,0xA1),
     o3(0xE9,0x8B,0xBB), o3(0xEF,0xA8,0xA8),
     o3(0xE9,0x8C,0x9E), o3(0xE9,0x8B,0xBF),
     o3(0xE9,0x8C,0x9D), o3(0xE9,0x8C,0x82),
     o3(0xE9,0x8D,0xB0), o3(0xE9,0x8D,0x97),
     o3(0xE9,0x8E,0xA4), o3(0xE9,0x8F,0x86),
     o3(0xE9,0x8F,0x9E), o3(0xE9,0x8F,0xB8),
     o3(0xE9,0x90,0xB1), o3(0xE9,0x91,0x85),
     o3(0xE9,0x91,0x88), o3(0xE9,0x96,0x92),
     o3(0xEF,0xA7,0x9C), o3(0xEF,0xA8,0xA9),
     o3(0xE9,0x9A,0x9D), o3(0xE9,0x9A,0xAF),
     o3(0xE9,0x9C,0xB3), o3(0xE9,0x9C,0xBB),
     o3(0xE9,0x9D,0x83), o3(0xE9,0x9D,0x8D),
     o3(0xE9,0x9D,0x8F), o3(0xE9,0x9D,0x91),
     o3(0xE9,0x9D,0x95), o3(0xE9,0xA1,0x97),
     o3(0xE9,0xA1,0xA5), o3(0xEF,0xA8,0xAA),
     o3(0xEF,0xA8,0xAB), o3(0xE9,0xA4,0xA7),
     o3(0xEF,0xA8,0xAC), o3(0xE9,0xA6,0x9E),
     o3(0xE9,0xA9,0x8E), o3(0xE9,0xAB,0x99),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_FB = {
    from_SHIFT_JIS_89_offsets,
    from_SHIFT_JIS_FB_infos
};

static const unsigned char
from_SHIFT_JIS_FC_offsets[256] = {
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
};
static const struct byte_lookup* const
from_SHIFT_JIS_FC_infos[13] = {
     o3(0xE9,0xAB,0x9C), o3(0xE9,0xAD,0xB5),
     o3(0xE9,0xAD,0xB2), o3(0xE9,0xAE,0x8F),
     o3(0xE9,0xAE,0xB1), o3(0xE9,0xAE,0xBB),
     o3(0xE9,0xB0,0x80), o3(0xE9,0xB5,0xB0),
     o3(0xE9,0xB5,0xAB), o3(0xEF,0xA8,0xAD),
     o3(0xE9,0xB8,0x99), o3(0xE9,0xBB,0x91),
                  UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS_FC = {
    from_SHIFT_JIS_FC_offsets,
    from_SHIFT_JIS_FC_infos
};

static const unsigned char
from_SHIFT_JIS_offsets[256] = {
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
    107,  1,  2,  3,  4,107,107,  5,    6,  7,  8,  9, 10, 11, 12, 13,
     14, 15, 16, 17, 18, 19, 20, 21,   22, 23, 24, 25, 26, 27, 28, 29,
    107, 30, 31, 32, 33, 34, 35, 36,   37, 38, 39, 40, 41, 42, 43, 44,
     45, 46, 47, 48, 49, 50, 51, 52,   53, 54, 55, 56, 57, 58, 59, 60,
     61, 62, 63, 64, 65, 66, 67, 68,   69, 70, 71, 72, 73, 74, 75, 76,
     77, 78, 79, 80, 81, 82, 83, 84,   85, 86, 87, 88, 89, 90, 91, 92,
     93, 94, 95, 96, 97, 98, 99,100,  101,102,103,107,107,107,107,107,
    107,107,107,107,107,107,107,107,  107,107,104,105,106,107,107,107,
};
static const struct byte_lookup* const
from_SHIFT_JIS_infos[108] = {
                  NOMAP, &from_SHIFT_JIS_81,
     &from_SHIFT_JIS_82, &from_SHIFT_JIS_83,
     &from_SHIFT_JIS_84, &from_SHIFT_JIS_87,
     &from_SHIFT_JIS_88, &from_SHIFT_JIS_89,
     &from_SHIFT_JIS_8A, &from_SHIFT_JIS_8B,
     &from_SHIFT_JIS_8C, &from_SHIFT_JIS_8D,
     &from_SHIFT_JIS_8E, &from_SHIFT_JIS_8F,
     &from_SHIFT_JIS_90, &from_SHIFT_JIS_91,
     &from_SHIFT_JIS_92, &from_SHIFT_JIS_93,
     &from_SHIFT_JIS_94, &from_SHIFT_JIS_95,
     &from_SHIFT_JIS_96, &from_SHIFT_JIS_97,
     &from_SHIFT_JIS_98, &from_SHIFT_JIS_99,
     &from_SHIFT_JIS_9A, &from_SHIFT_JIS_9B,
     &from_SHIFT_JIS_9C, &from_SHIFT_JIS_9D,
     &from_SHIFT_JIS_9E, &from_SHIFT_JIS_9F,
     o3(0xEF,0xBD,0xA1), o3(0xEF,0xBD,0xA2),
     o3(0xEF,0xBD,0xA3), o3(0xEF,0xBD,0xA4),
     o3(0xEF,0xBD,0xA5), o3(0xEF,0xBD,0xA6),
     o3(0xEF,0xBD,0xA7), o3(0xEF,0xBD,0xA8),
     o3(0xEF,0xBD,0xA9), o3(0xEF,0xBD,0xAA),
     o3(0xEF,0xBD,0xAB), o3(0xEF,0xBD,0xAC),
     o3(0xEF,0xBD,0xAD), o3(0xEF,0xBD,0xAE),
     o3(0xEF,0xBD,0xAF), o3(0xEF,0xBD,0xB0),
     o3(0xEF,0xBD,0xB1), o3(0xEF,0xBD,0xB2),
     o3(0xEF,0xBD,0xB3), o3(0xEF,0xBD,0xB4),
     o3(0xEF,0xBD,0xB5), o3(0xEF,0xBD,0xB6),
     o3(0xEF,0xBD,0xB7), o3(0xEF,0xBD,0xB8),
     o3(0xEF,0xBD,0xB9), o3(0xEF,0xBD,0xBA),
     o3(0xEF,0xBD,0xBB), o3(0xEF,0xBD,0xBC),
     o3(0xEF,0xBD,0xBD), o3(0xEF,0xBD,0xBE),
     o3(0xEF,0xBD,0xBF), o3(0xEF,0xBE,0x80),
     o3(0xEF,0xBE,0x81), o3(0xEF,0xBE,0x82),
     o3(0xEF,0xBE,0x83), o3(0xEF,0xBE,0x84),
     o3(0xEF,0xBE,0x85), o3(0xEF,0xBE,0x86),
     o3(0xEF,0xBE,0x87), o3(0xEF,0xBE,0x88),
     o3(0xEF,0xBE,0x89), o3(0xEF,0xBE,0x8A),
     o3(0xEF,0xBE,0x8B), o3(0xEF,0xBE,0x8C),
     o3(0xEF,0xBE,0x8D), o3(0xEF,0xBE,0x8E),
     o3(0xEF,0xBE,0x8F), o3(0xEF,0xBE,0x90),
     o3(0xEF,0xBE,0x91), o3(0xEF,0xBE,0x92),
     o3(0xEF,0xBE,0x93), o3(0xEF,0xBE,0x94),
     o3(0xEF,0xBE,0x95), o3(0xEF,0xBE,0x96),
     o3(0xEF,0xBE,0x97), o3(0xEF,0xBE,0x98),
     o3(0xEF,0xBE,0x99), o3(0xEF,0xBE,0x9A),
     o3(0xEF,0xBE,0x9B), o3(0xEF,0xBE,0x9C),
     o3(0xEF,0xBE,0x9D), o3(0xEF,0xBE,0x9E),
     o3(0xEF,0xBE,0x9F), &from_SHIFT_JIS_E0,
     &from_SHIFT_JIS_E1, &from_SHIFT_JIS_E2,
     &from_SHIFT_JIS_E3, &from_SHIFT_JIS_E4,
     &from_SHIFT_JIS_E5, &from_SHIFT_JIS_E6,
     &from_SHIFT_JIS_E7, &from_SHIFT_JIS_E8,
     &from_SHIFT_JIS_E9, &from_SHIFT_JIS_EA,
     &from_SHIFT_JIS_FA, &from_SHIFT_JIS_FB,
     &from_SHIFT_JIS_FC,              UNDEF,
};
static const BYTE_LOOKUP
from_SHIFT_JIS = {
    from_SHIFT_JIS_offsets,
    from_SHIFT_JIS_infos
};
static const rb_transcoder
rb_from_SHIFT_JIS = {
    "SHIFT_JIS", "UTF-8", &from_SHIFT_JIS, 3, 0,
    NULL, NULL,
};
static const rb_transcoder
rb_from_Windows_31J = {
    "Windows-31J", "UTF-8", &from_SHIFT_JIS, 3, 0,
    NULL, NULL,
};

static const unsigned char
to_SHIFT_JIS_C2_offsets[64] = {
  /* used from to_SHIFT_JIS_C2 */
  /* used from to_EUC_JP_C2 */
     13, 13, 13, 13, 13, 13, 13, 13,   13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,   13, 13, 13, 13, 13, 13, 13, 13,
     13, 13,  0,  1, 13,  2,  3,  4,    5, 13, 13, 13,  6, 13, 13,  7,
      8,  9, 13, 13, 10, 13, 11, 13,   12, 13, 13, 13, 13, 13, 13, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_C2_infos[14] = {
     o2(0x81,0x91), o2(0x81,0x92), o2(0x81,0x8F), o2(0xFA,0x55),
     o2(0x81,0x98), o2(0x81,0x4E), o2(0x81,0xCA), o2(0x81,0x50),
     o2(0x81,0x8B), o2(0x81,0x7D), o2(0x81,0x4C), o2(0x81,0xF7),
     o2(0x81,0x43),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_C2 = {
    to_SHIFT_JIS_C2_offsets,
    to_SHIFT_JIS_C2_infos
};

static const unsigned char
to_SHIFT_JIS_C3_offsets[64] = {
  /* used from to_SHIFT_JIS_C3 */
  /* used from to_EUC_JP_C3 */
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  0,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  1,    2,  2,  2,  2,  2,  2,  2,  2,
};
static const struct byte_lookup* const
to_SHIFT_JIS_C3_infos[3] = {
     o2(0x81,0x7E), o2(0x81,0x80),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_C3 = {
    to_SHIFT_JIS_C3_offsets,
    to_SHIFT_JIS_C3_infos
};

static const unsigned char
to_SHIFT_JIS_CE_offsets[64] = {
  /* used from to_SHIFT_JIS_CE */
  /* used from to_EUC_JP_CE */
     39, 39, 39, 39, 39, 39, 39, 39,   39, 39, 39, 39, 39, 39, 39, 39,
     39,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 39, 17, 18, 19, 20, 21,   22, 23, 39, 39, 39, 39, 39, 39,
     39, 24, 25, 26, 27, 28, 29, 30,   31, 32, 33, 34, 35, 36, 37, 38,
};
static const struct byte_lookup* const
to_SHIFT_JIS_CE_infos[40] = {
     o2(0x83,0x9F), o2(0x83,0xA0), o2(0x83,0xA1), o2(0x83,0xA2),
     o2(0x83,0xA3), o2(0x83,0xA4), o2(0x83,0xA5), o2(0x83,0xA6),
     o2(0x83,0xA7), o2(0x83,0xA8), o2(0x83,0xA9), o2(0x83,0xAA),
     o2(0x83,0xAB), o2(0x83,0xAC), o2(0x83,0xAD), o2(0x83,0xAE),
     o2(0x83,0xAF), o2(0x83,0xB0), o2(0x83,0xB1), o2(0x83,0xB2),
     o2(0x83,0xB3), o2(0x83,0xB4), o2(0x83,0xB5), o2(0x83,0xB6),
     o2(0x83,0xBF), o2(0x83,0xC0), o2(0x83,0xC1), o2(0x83,0xC2),
     o2(0x83,0xC3), o2(0x83,0xC4), o2(0x83,0xC5), o2(0x83,0xC6),
     o2(0x83,0xC7), o2(0x83,0xC8), o2(0x83,0xC9), o2(0x83,0xCA),
     o2(0x83,0xCB), o2(0x83,0xCC), o2(0x83,0xCD),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_CE = {
    to_SHIFT_JIS_CE_offsets,
    to_SHIFT_JIS_CE_infos
};

static const unsigned char
to_SHIFT_JIS_CF_offsets[64] = {
  /* used from to_SHIFT_JIS_CF */
  /* used from to_EUC_JP_CF */
      0,  1,  9,  2,  3,  4,  5,  6,    7,  8,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,    9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,    9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,    9,  9,  9,  9,  9,  9,  9,  9,
};
static const struct byte_lookup* const
to_SHIFT_JIS_CF_infos[10] = {
     o2(0x83,0xCE), o2(0x83,0xCF), o2(0x83,0xD0), o2(0x83,0xD1),
     o2(0x83,0xD2), o2(0x83,0xD3), o2(0x83,0xD4), o2(0x83,0xD5),
     o2(0x83,0xD6),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_CF = {
    to_SHIFT_JIS_CF_offsets,
    to_SHIFT_JIS_CF_infos
};

static const unsigned char
to_SHIFT_JIS_D0_offsets[64] = {
  /* used from to_SHIFT_JIS_D0 */
  /* used from to_EUC_JP_D0 */
     49,  0, 49, 49, 49, 49, 49, 49,   49, 49, 49, 49, 49, 49, 49, 49,
      1,  2,  3,  4,  5,  6,  7,  8,    9, 10, 11, 12, 13, 14, 15, 16,
     17, 18, 19, 20, 21, 22, 23, 24,   25, 26, 27, 28, 29, 30, 31, 32,
     33, 34, 35, 36, 37, 38, 39, 40,   41, 42, 43, 44, 45, 46, 47, 48,
};
static const struct byte_lookup* const
to_SHIFT_JIS_D0_infos[50] = {
     o2(0x84,0x46), o2(0x84,0x40), o2(0x84,0x41), o2(0x84,0x42),
     o2(0x84,0x43), o2(0x84,0x44), o2(0x84,0x45), o2(0x84,0x47),
     o2(0x84,0x48), o2(0x84,0x49), o2(0x84,0x4A), o2(0x84,0x4B),
     o2(0x84,0x4C), o2(0x84,0x4D), o2(0x84,0x4E), o2(0x84,0x4F),
     o2(0x84,0x50), o2(0x84,0x51), o2(0x84,0x52), o2(0x84,0x53),
     o2(0x84,0x54), o2(0x84,0x55), o2(0x84,0x56), o2(0x84,0x57),
     o2(0x84,0x58), o2(0x84,0x59), o2(0x84,0x5A), o2(0x84,0x5B),
     o2(0x84,0x5C), o2(0x84,0x5D), o2(0x84,0x5E), o2(0x84,0x5F),
     o2(0x84,0x60), o2(0x84,0x70), o2(0x84,0x71), o2(0x84,0x72),
     o2(0x84,0x73), o2(0x84,0x74), o2(0x84,0x75), o2(0x84,0x77),
     o2(0x84,0x78), o2(0x84,0x79), o2(0x84,0x7A), o2(0x84,0x7B),
     o2(0x84,0x7C), o2(0x84,0x7D), o2(0x84,0x7E), o2(0x84,0x80),
     o2(0x84,0x81),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_D0 = {
    to_SHIFT_JIS_D0_offsets,
    to_SHIFT_JIS_D0_infos
};

static const unsigned char
to_SHIFT_JIS_D1_offsets[64] = {
  /* used from to_SHIFT_JIS_D1 */
  /* used from to_EUC_JP_D1 */
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     17, 16, 17, 17, 17, 17, 17, 17,   17, 17, 17, 17, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,   17, 17, 17, 17, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,   17, 17, 17, 17, 17, 17, 17, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_D1_infos[18] = {
     o2(0x84,0x82), o2(0x84,0x83), o2(0x84,0x84), o2(0x84,0x85),
     o2(0x84,0x86), o2(0x84,0x87), o2(0x84,0x88), o2(0x84,0x89),
     o2(0x84,0x8A), o2(0x84,0x8B), o2(0x84,0x8C), o2(0x84,0x8D),
     o2(0x84,0x8E), o2(0x84,0x8F), o2(0x84,0x90), o2(0x84,0x91),
     o2(0x84,0x76),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_D1 = {
    to_SHIFT_JIS_D1_offsets,
    to_SHIFT_JIS_D1_infos
};

static const unsigned char
to_SHIFT_JIS_E2_80_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_80 */
  /* used from to_EUC_JP_E2_80 */
     15, 15, 15, 15, 15, 15, 15, 15,   15, 15, 15, 15, 15, 15, 15, 15,
      0, 15, 15, 15,  1, 15,  2, 15,    3,  4, 15, 15,  5,  6, 15, 15,
      7,  8, 15, 15, 15,  9, 10, 15,   15, 15, 15, 15, 15, 15, 15, 15,
     11, 15, 12, 13, 15, 15, 15, 15,   15, 15, 15, 14, 15, 15, 15, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_80_infos[16] = {
     o2(0x81,0x5D), o2(0x81,0x5C), o2(0x81,0x61), o2(0x81,0x65),
     o2(0x81,0x66), o2(0x81,0x67), o2(0x81,0x68), o2(0x81,0xF5),
     o2(0x81,0xF6), o2(0x81,0x64), o2(0x81,0x63), o2(0x81,0xF1),
     o2(0x81,0x8C), o2(0x81,0x8D), o2(0x81,0xA6),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_80 = {
    to_SHIFT_JIS_E2_80_offsets,
    to_SHIFT_JIS_E2_80_infos
};

static const unsigned char
to_SHIFT_JIS_E2_84_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_84 */
  /* used from to_EUC_JP_E2_84 */
      4,  4,  4,  0,  4,  4,  4,  4,    4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  1,  4,    4,  4,  4,  4,  4,  4,  4,  4,
      4,  2,  4,  4,  4,  4,  4,  4,    4,  4,  4,  3,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,    4,  4,  4,  4,  4,  4,  4,  4,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_84_infos[5] = {
     o2(0x81,0x8E), o2(0x87,0x82), o2(0x87,0x84), o2(0x81,0xF0),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_84 = {
    to_SHIFT_JIS_E2_84_offsets,
    to_SHIFT_JIS_E2_84_infos
};

static const unsigned char
to_SHIFT_JIS_E2_85_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_85 */
  /* used from to_EUC_JP_E2_85 */
     20, 20, 20, 20, 20, 20, 20, 20,   20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20,   20, 20, 20, 20, 20, 20, 20, 20,
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 20, 20, 20, 20, 20, 20,
     10, 11, 12, 13, 14, 15, 16, 17,   18, 19, 20, 20, 20, 20, 20, 20,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_85_infos[21] = {
     o2(0x87,0x54), o2(0x87,0x55), o2(0x87,0x56), o2(0x87,0x57),
     o2(0x87,0x58), o2(0x87,0x59), o2(0x87,0x5A), o2(0x87,0x5B),
     o2(0x87,0x5C), o2(0x87,0x5D), o2(0xFA,0x40), o2(0xFA,0x41),
     o2(0xFA,0x42), o2(0xFA,0x43), o2(0xFA,0x44), o2(0xFA,0x45),
     o2(0xFA,0x46), o2(0xFA,0x47), o2(0xFA,0x48), o2(0xFA,0x49),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_85 = {
    to_SHIFT_JIS_E2_85_offsets,
    to_SHIFT_JIS_E2_85_infos
};

static const unsigned char
to_SHIFT_JIS_E2_86_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_86 */
  /* used from to_EUC_JP_E2_86 */
      4,  4,  4,  4,  4,  4,  4,  4,    4,  4,  4,  4,  4,  4,  4,  4,
      0,  1,  2,  3,  4,  4,  4,  4,    4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,    4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,    4,  4,  4,  4,  4,  4,  4,  4,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_86_infos[5] = {
     o2(0x81,0xA9), o2(0x81,0xAA), o2(0x81,0xA8), o2(0x81,0xAB),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_86 = {
    to_SHIFT_JIS_E2_86_offsets,
    to_SHIFT_JIS_E2_86_infos
};

static const unsigned char
to_SHIFT_JIS_E2_87_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_87 */
  /* used from to_EUC_JP_E2_87 */
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  0,  2,  1,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_87_infos[3] = {
     o2(0x81,0xCB), o2(0x81,0xCC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_87 = {
    to_SHIFT_JIS_E2_87_offsets,
    to_SHIFT_JIS_E2_87_infos
};

static const unsigned char
to_SHIFT_JIS_E2_88_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_88 */
  /* used from to_EUC_JP_E2_88 */
      0, 23,  1,  2, 23, 23, 23,  3,    4, 23, 23,  5, 23, 23, 23, 23,
     23,  6,  7, 23, 23, 23, 23, 23,   23, 23,  8, 23, 23,  9, 10, 11,
     12, 23, 23, 23, 23, 23, 23, 13,   14, 15, 16, 17, 18, 23, 19, 23,
     23, 23, 23, 23, 20, 21, 23, 23,   23, 23, 23, 23, 23, 22, 23, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_88_infos[24] = {
     o2(0x81,0xCD), o2(0x81,0xDD), o2(0x81,0xCE), o2(0x81,0xDE),
     o2(0x81,0xB8), o2(0x81,0xB9), o2(0x87,0x94), o2(0x81,0x7C),
     o2(0x87,0x95), o2(0x81,0xE5), o2(0x81,0x87), o2(0x87,0x98),
     o2(0x87,0x97), o2(0x81,0xC8), o2(0x81,0xC9), o2(0x87,0x9B),
     o2(0x87,0x9C), o2(0x87,0x92), o2(0x81,0xE8), o2(0x87,0x93),
     o2(0x81,0x88), o2(0x87,0x9A), o2(0x81,0xE4),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_88 = {
    to_SHIFT_JIS_E2_88_offsets,
    to_SHIFT_JIS_E2_88_infos
};

static const unsigned char
to_SHIFT_JIS_E2_89_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_89 */
  /* used from to_EUC_JP_E2_89 */
      7,  7,  7,  7,  7,  7,  7,  7,    7,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  0,  7,  7,  7,  7,  7,    7,  7,  7,  7,  7,  7,  7,  7,
      1,  2,  7,  7,  7,  7,  3,  4,    7,  7,  5,  6,  7,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  7,    7,  7,  7,  7,  7,  7,  7,  7,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_89_infos[8] = {
     o2(0x87,0x90), o2(0x81,0x82), o2(0x87,0x91), o2(0x81,0x85),
     o2(0x81,0x86), o2(0x81,0xE1), o2(0x81,0xE2),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_89 = {
    to_SHIFT_JIS_E2_89_offsets,
    to_SHIFT_JIS_E2_89_infos
};

static const unsigned char
to_SHIFT_JIS_E2_8A_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_8A */
  /* used from to_EUC_JP_E2_8A */
      6,  6,  0,  1,  6,  6,  2,  3,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  4,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  5,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_8A_infos[7] = {
     o2(0x81,0xBC), o2(0x81,0xBD), o2(0x81,0xBA), o2(0x81,0xBB),
     o2(0x87,0x96), o2(0x87,0x99),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_8A = {
    to_SHIFT_JIS_E2_8A_offsets,
    to_SHIFT_JIS_E2_8A_infos
};

static const unsigned char
to_SHIFT_JIS_E2_8C_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_8C */
  /* used from to_EUC_JP_E2_8C */
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  0,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_8C_infos[2] = {
     o2(0x81,0xDC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_8C = {
    to_SHIFT_JIS_E2_8C_offsets,
    to_SHIFT_JIS_E2_8C_infos
};

static const unsigned char
to_SHIFT_JIS_E2_91_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_91 */
  /* used from to_EUC_JP_E2_91 */
     20, 20, 20, 20, 20, 20, 20, 20,   20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20,   20, 20, 20, 20, 20, 20, 20, 20,
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 20, 20, 20,   20, 20, 20, 20, 20, 20, 20, 20,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_91_infos[21] = {
     o2(0x87,0x40), o2(0x87,0x41), o2(0x87,0x42), o2(0x87,0x43),
     o2(0x87,0x44), o2(0x87,0x45), o2(0x87,0x46), o2(0x87,0x47),
     o2(0x87,0x48), o2(0x87,0x49), o2(0x87,0x4A), o2(0x87,0x4B),
     o2(0x87,0x4C), o2(0x87,0x4D), o2(0x87,0x4E), o2(0x87,0x4F),
     o2(0x87,0x50), o2(0x87,0x51), o2(0x87,0x52), o2(0x87,0x53),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_91 = {
    to_SHIFT_JIS_E2_91_offsets,
    to_SHIFT_JIS_E2_91_infos
};

static const unsigned char
to_SHIFT_JIS_E2_94_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_94 */
  /* used from to_EUC_JP_E2_94 */
      0,  1,  2,  3, 30, 30, 30, 30,   30, 30, 30, 30,  4, 30, 30,  5,
      6, 30, 30,  7,  8, 30, 30,  9,   10, 30, 30, 11, 12, 13, 30, 30,
     14, 30, 30, 15, 16, 17, 30, 30,   18, 30, 30, 19, 20, 30, 30, 21,
     22, 30, 30, 23, 24, 30, 30, 25,   26, 30, 30, 27, 28, 30, 30, 29,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_94_infos[31] = {
     o2(0x84,0x9F), o2(0x84,0xAA), o2(0x84,0xA0), o2(0x84,0xAB),
     o2(0x84,0xA1), o2(0x84,0xAC), o2(0x84,0xA2), o2(0x84,0xAD),
     o2(0x84,0xA4), o2(0x84,0xAF), o2(0x84,0xA3), o2(0x84,0xAE),
     o2(0x84,0xA5), o2(0x84,0xBA), o2(0x84,0xB5), o2(0x84,0xB0),
     o2(0x84,0xA7), o2(0x84,0xBC), o2(0x84,0xB7), o2(0x84,0xB2),
     o2(0x84,0xA6), o2(0x84,0xB6), o2(0x84,0xBB), o2(0x84,0xB1),
     o2(0x84,0xA8), o2(0x84,0xB8), o2(0x84,0xBD), o2(0x84,0xB3),
     o2(0x84,0xA9), o2(0x84,0xB9),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_94 = {
    to_SHIFT_JIS_E2_94_offsets,
    to_SHIFT_JIS_E2_94_infos
};

static const unsigned char
to_SHIFT_JIS_E2_95_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_95 */
  /* used from to_EUC_JP_E2_95 */
      2,  2,  0,  2,  2,  2,  2,  2,    2,  2,  2,  1,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_95_infos[3] = {
     o2(0x84,0xBE), o2(0x84,0xB4),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_95 = {
    to_SHIFT_JIS_E2_95_offsets,
    to_SHIFT_JIS_E2_95_infos
};

static const unsigned char
to_SHIFT_JIS_E2_96_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_96 */
  /* used from to_EUC_JP_E2_96 */
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      0,  1,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  2,  3,  6,  6,  6,  6,    6,  6,  6,  6,  4,  5,  6,  6,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_96_infos[7] = {
     o2(0x81,0xA1), o2(0x81,0xA0), o2(0x81,0xA3), o2(0x81,0xA2),
     o2(0x81,0xA5), o2(0x81,0xA4),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_96 = {
    to_SHIFT_JIS_E2_96_offsets,
    to_SHIFT_JIS_E2_96_infos
};

static const unsigned char
to_SHIFT_JIS_E2_97_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_97 */
  /* used from to_EUC_JP_E2_97 */
      6,  6,  6,  6,  6,  6,  0,  1,    6,  6,  6,  2,  6,  6,  3,  4,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  5,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_97_infos[7] = {
     o2(0x81,0x9F), o2(0x81,0x9E), o2(0x81,0x9B), o2(0x81,0x9D),
     o2(0x81,0x9C), o2(0x81,0xFC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_97 = {
    to_SHIFT_JIS_E2_97_offsets,
    to_SHIFT_JIS_E2_97_infos
};

static const unsigned char
to_SHIFT_JIS_E2_98_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_98 */
  /* used from to_EUC_JP_E2_98 */
      2,  2,  2,  2,  2,  0,  1,  2,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_98_infos[3] = {
     o2(0x81,0x9A), o2(0x81,0x99),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_98 = {
    to_SHIFT_JIS_E2_98_offsets,
    to_SHIFT_JIS_E2_98_infos
};

static const unsigned char
to_SHIFT_JIS_E2_99_offsets[64] = {
  /* used from to_SHIFT_JIS_E2_99 */
  /* used from to_EUC_JP_E2_99 */
      0,  5,  1,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  2,  5,  5,  3,  5,  4,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_99_infos[6] = {
     o2(0x81,0x8A), o2(0x81,0x89), o2(0x81,0xF4), o2(0x81,0xF3),
     o2(0x81,0xF2),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2_99 = {
    to_SHIFT_JIS_E2_99_offsets,
    to_SHIFT_JIS_E2_99_infos
};

static const unsigned char
to_SHIFT_JIS_E2_offsets[64] = {
  /* used from to_SHIFT_JIS_E2 */
  /* used from to_EUC_JP_E2 */
      0, 16, 16, 16,  1,  2,  3,  4,    5,  6,  7, 16,  8, 16, 16, 16,
     16,  9, 16, 16, 10, 11, 12, 13,   14, 15, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 16, 16, 16, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E2_infos[17] = {
     &to_SHIFT_JIS_E2_80, &to_SHIFT_JIS_E2_84,
     &to_SHIFT_JIS_E2_85, &to_SHIFT_JIS_E2_86,
     &to_SHIFT_JIS_E2_87, &to_SHIFT_JIS_E2_88,
     &to_SHIFT_JIS_E2_89, &to_SHIFT_JIS_E2_8A,
     &to_SHIFT_JIS_E2_8C, &to_SHIFT_JIS_E2_91,
     &to_SHIFT_JIS_E2_94, &to_SHIFT_JIS_E2_95,
     &to_SHIFT_JIS_E2_96, &to_SHIFT_JIS_E2_97,
     &to_SHIFT_JIS_E2_98, &to_SHIFT_JIS_E2_99,
                   UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E2 = {
    to_SHIFT_JIS_E2_offsets,
    to_SHIFT_JIS_E2_infos
};

static const unsigned char
to_SHIFT_JIS_E3_80_offsets[64] = {
  /* used from to_SHIFT_JIS_E3_80 */
  /* used from to_EUC_JP_E3_80 */
      0,  1,  2,  3, 24,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 24, 24,   24, 24, 24, 24, 21, 22, 24, 23,
     24, 24, 24, 24, 24, 24, 24, 24,   24, 24, 24, 24, 24, 24, 24, 24,
     24, 24, 24, 24, 24, 24, 24, 24,   24, 24, 24, 24, 24, 24, 24, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E3_80_infos[25] = {
     o2(0x81,0x40), o2(0x81,0x41), o2(0x81,0x42), o2(0x81,0x56),
     o2(0x81,0x58), o2(0x81,0x59), o2(0x81,0x5A), o2(0x81,0x71),
     o2(0x81,0x72), o2(0x81,0x73), o2(0x81,0x74), o2(0x81,0x75),
     o2(0x81,0x76), o2(0x81,0x77), o2(0x81,0x78), o2(0x81,0x79),
     o2(0x81,0x7A), o2(0x81,0xA7), o2(0x81,0xAC), o2(0x81,0x6B),
     o2(0x81,0x6C), o2(0x81,0x60), o2(0x87,0x80), o2(0x87,0x81),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E3_80 = {
    to_SHIFT_JIS_E3_80_offsets,
    to_SHIFT_JIS_E3_80_infos
};

static const unsigned char
to_SHIFT_JIS_E3_81_offsets[64] = {
  /* used from to_SHIFT_JIS_E3_81 */
  /* used from to_EUC_JP_E3_81 */
     63,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,   23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,   39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 53, 54,   55, 56, 57, 58, 59, 60, 61, 62,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E3_81_infos[64] = {
     o2(0x82,0x9F), o2(0x82,0xA0), o2(0x82,0xA1), o2(0x82,0xA2),
     o2(0x82,0xA3), o2(0x82,0xA4), o2(0x82,0xA5), o2(0x82,0xA6),
     o2(0x82,0xA7), o2(0x82,0xA8), o2(0x82,0xA9), o2(0x82,0xAA),
     o2(0x82,0xAB), o2(0x82,0xAC), o2(0x82,0xAD), o2(0x82,0xAE),
     o2(0x82,0xAF), o2(0x82,0xB0), o2(0x82,0xB1), o2(0x82,0xB2),
     o2(0x82,0xB3), o2(0x82,0xB4), o2(0x82,0xB5), o2(0x82,0xB6),
     o2(0x82,0xB7), o2(0x82,0xB8), o2(0x82,0xB9), o2(0x82,0xBA),
     o2(0x82,0xBB), o2(0x82,0xBC), o2(0x82,0xBD), o2(0x82,0xBE),
     o2(0x82,0xBF), o2(0x82,0xC0), o2(0x82,0xC1), o2(0x82,0xC2),
     o2(0x82,0xC3), o2(0x82,0xC4), o2(0x82,0xC5), o2(0x82,0xC6),
     o2(0x82,0xC7), o2(0x82,0xC8), o2(0x82,0xC9), o2(0x82,0xCA),
     o2(0x82,0xCB), o2(0x82,0xCC), o2(0x82,0xCD), o2(0x82,0xCE),
     o2(0x82,0xCF), o2(0x82,0xD0), o2(0x82,0xD1), o2(0x82,0xD2),
     o2(0x82,0xD3), o2(0x82,0xD4), o2(0x82,0xD5), o2(0x82,0xD6),
     o2(0x82,0xD7), o2(0x82,0xD8), o2(0x82,0xD9), o2(0x82,0xDA),
     o2(0x82,0xDB), o2(0x82,0xDC), o2(0x82,0xDD),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E3_81 = {
    to_SHIFT_JIS_E3_81_offsets,
    to_SHIFT_JIS_E3_81_infos
};

static const unsigned char
to_SHIFT_JIS_E3_82_offsets[64] = {
  /* used from to_SHIFT_JIS_E3_82 */
  /* used from to_EUC_JP_E3_82 */
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 55, 55, 55, 55,   55, 55, 55, 20, 21, 22, 23, 55,
     55, 24, 25, 26, 27, 28, 29, 30,   31, 32, 33, 34, 35, 36, 37, 38,
     39, 40, 41, 42, 43, 44, 45, 46,   47, 48, 49, 50, 51, 52, 53, 54,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E3_82_infos[56] = {
     o2(0x82,0xDE), o2(0x82,0xDF), o2(0x82,0xE0), o2(0x82,0xE1),
     o2(0x82,0xE2), o2(0x82,0xE3), o2(0x82,0xE4), o2(0x82,0xE5),
     o2(0x82,0xE6), o2(0x82,0xE7), o2(0x82,0xE8), o2(0x82,0xE9),
     o2(0x82,0xEA), o2(0x82,0xEB), o2(0x82,0xEC), o2(0x82,0xED),
     o2(0x82,0xEE), o2(0x82,0xEF), o2(0x82,0xF0), o2(0x82,0xF1),
     o2(0x81,0x4A), o2(0x81,0x4B), o2(0x81,0x54), o2(0x81,0x55),
     o2(0x83,0x40), o2(0x83,0x41), o2(0x83,0x42), o2(0x83,0x43),
     o2(0x83,0x44), o2(0x83,0x45), o2(0x83,0x46), o2(0x83,0x47),
     o2(0x83,0x48), o2(0x83,0x49), o2(0x83,0x4A), o2(0x83,0x4B),
     o2(0x83,0x4C), o2(0x83,0x4D), o2(0x83,0x4E), o2(0x83,0x4F),
     o2(0x83,0x50), o2(0x83,0x51), o2(0x83,0x52), o2(0x83,0x53),
     o2(0x83,0x54), o2(0x83,0x55), o2(0x83,0x56), o2(0x83,0x57),
     o2(0x83,0x58), o2(0x83,0x59), o2(0x83,0x5A), o2(0x83,0x5B),
     o2(0x83,0x5C), o2(0x83,0x5D), o2(0x83,0x5E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E3_82 = {
    to_SHIFT_JIS_E3_82_offsets,
    to_SHIFT_JIS_E3_82_infos
};

static const unsigned char
to_SHIFT_JIS_E3_83_offsets[64] = {
  /* used from to_SHIFT_JIS_E3_83 */
  /* used from to_EUC_JP_E3_83 */
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,   24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39,   40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 59,   59, 59, 59, 55, 56, 57, 58, 59,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E3_83_infos[60] = {
     o2(0x83,0x5F), o2(0x83,0x60), o2(0x83,0x61), o2(0x83,0x62),
     o2(0x83,0x63), o2(0x83,0x64), o2(0x83,0x65), o2(0x83,0x66),
     o2(0x83,0x67), o2(0x83,0x68), o2(0x83,0x69), o2(0x83,0x6A),
     o2(0x83,0x6B), o2(0x83,0x6C), o2(0x83,0x6D), o2(0x83,0x6E),
     o2(0x83,0x6F), o2(0x83,0x70), o2(0x83,0x71), o2(0x83,0x72),
     o2(0x83,0x73), o2(0x83,0x74), o2(0x83,0x75), o2(0x83,0x76),
     o2(0x83,0x77), o2(0x83,0x78), o2(0x83,0x79), o2(0x83,0x7A),
     o2(0x83,0x7B), o2(0x83,0x7C), o2(0x83,0x7D), o2(0x83,0x7E),
     o2(0x83,0x80), o2(0x83,0x81), o2(0x83,0x82), o2(0x83,0x83),
     o2(0x83,0x84), o2(0x83,0x85), o2(0x83,0x86), o2(0x83,0x87),
     o2(0x83,0x88), o2(0x83,0x89), o2(0x83,0x8A), o2(0x83,0x8B),
     o2(0x83,0x8C), o2(0x83,0x8D), o2(0x83,0x8E), o2(0x83,0x8F),
     o2(0x83,0x90), o2(0x83,0x91), o2(0x83,0x92), o2(0x83,0x93),
     o2(0x83,0x94), o2(0x83,0x95), o2(0x83,0x96), o2(0x81,0x45),
     o2(0x81,0x5B), o2(0x81,0x52), o2(0x81,0x53),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E3_83 = {
    to_SHIFT_JIS_E3_83_offsets,
    to_SHIFT_JIS_E3_83_infos
};

static const unsigned char
to_SHIFT_JIS_E3_88_offsets[64] = {
  /* used from to_SHIFT_JIS_E3_88 */
  /* used from to_EUC_JP_E3_88 */
      3,  3,  3,  3,  3,  3,  3,  3,    3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,    3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,    3,  3,  3,  3,  3,  3,  3,  3,
      3,  0,  1,  3,  3,  3,  3,  3,    3,  2,  3,  3,  3,  3,  3,  3,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E3_88_infos[4] = {
     o2(0x87,0x8A), o2(0x87,0x8B), o2(0x87,0x8C),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E3_88 = {
    to_SHIFT_JIS_E3_88_offsets,
    to_SHIFT_JIS_E3_88_infos
};

static const unsigned char
to_SHIFT_JIS_E3_8A_offsets[64] = {
  /* used from to_SHIFT_JIS_E3_8A */
  /* used from to_EUC_JP_E3_8A */
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  0,  1,  2,  3,    4,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E3_8A_infos[6] = {
     o2(0x87,0x85), o2(0x87,0x86), o2(0x87,0x87), o2(0x87,0x88),
     o2(0x87,0x89),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E3_8A = {
    to_SHIFT_JIS_E3_8A_offsets,
    to_SHIFT_JIS_E3_8A_infos
};

static const unsigned char
to_SHIFT_JIS_E3_8C_offsets[64] = {
  /* used from to_SHIFT_JIS_E3_8C */
  /* used from to_EUC_JP_E3_8C */
     11, 11, 11,  0, 11, 11, 11, 11,   11, 11, 11, 11, 11,  1, 11, 11,
     11, 11, 11, 11,  2, 11, 11, 11,    3, 11, 11, 11, 11, 11, 11, 11,
     11, 11,  4,  5, 11, 11,  6,  7,   11, 11, 11,  8, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11,  9, 11,   11, 11, 11, 10, 11, 11, 11, 11,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E3_8C_infos[12] = {
     o2(0x87,0x65), o2(0x87,0x69), o2(0x87,0x60), o2(0x87,0x63),
     o2(0x87,0x61), o2(0x87,0x6B), o2(0x87,0x6A), o2(0x87,0x64),
     o2(0x87,0x6C), o2(0x87,0x66), o2(0x87,0x6E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E3_8C = {
    to_SHIFT_JIS_E3_8C_offsets,
    to_SHIFT_JIS_E3_8C_infos
};

static const unsigned char
to_SHIFT_JIS_E3_8D_offsets[64] = {
  /* used from to_SHIFT_JIS_E3_8D */
  /* used from to_EUC_JP_E3_8D */
      9,  9,  9,  9,  9,  9,  9,  9,    9,  0,  1,  9,  9,  2,  9,  9,
      9,  3,  9,  9,  9,  9,  9,  4,    9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,    9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,    9,  9,  9,  5,  6,  7,  8,  9,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E3_8D_infos[10] = {
     o2(0x87,0x5F), o2(0x87,0x6D), o2(0x87,0x62), o2(0x87,0x67),
     o2(0x87,0x68), o2(0x87,0x7E), o2(0x87,0x8F), o2(0x87,0x8E),
     o2(0x87,0x8D),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E3_8D = {
    to_SHIFT_JIS_E3_8D_offsets,
    to_SHIFT_JIS_E3_8D_infos
};

static const unsigned char
to_SHIFT_JIS_E3_8E_offsets[64] = {
  /* used from to_SHIFT_JIS_E3_8E */
  /* used from to_EUC_JP_E3_8E */
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  0,  1,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  2,  3,  4,  6,
      6,  5,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E3_8E_infos[7] = {
     o2(0x87,0x72), o2(0x87,0x73), o2(0x87,0x6F), o2(0x87,0x70),
     o2(0x87,0x71), o2(0x87,0x75),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E3_8E = {
    to_SHIFT_JIS_E3_8E_offsets,
    to_SHIFT_JIS_E3_8E_infos
};

static const unsigned char
to_SHIFT_JIS_E3_8F_offsets[64] = {
  /* used from to_SHIFT_JIS_E3_8F */
  /* used from to_EUC_JP_E3_8F */
      2,  2,  2,  2,  0,  2,  2,  2,    2,  2,  2,  2,  2,  1,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E3_8F_infos[3] = {
     o2(0x87,0x74), o2(0x87,0x83),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E3_8F = {
    to_SHIFT_JIS_E3_8F_offsets,
    to_SHIFT_JIS_E3_8F_infos
};

static const unsigned char
to_SHIFT_JIS_E3_offsets[64] = {
  /* used from to_SHIFT_JIS_E3 */
  /* used from to_EUC_JP_E3 */
      0,  1,  2,  3, 10, 10, 10, 10,    4, 10,  5, 10,  6,  7,  8,  9,
     10, 10, 10, 10, 10, 10, 10, 10,   10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,   10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,   10, 10, 10, 10, 10, 10, 10, 10,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E3_infos[11] = {
     &to_SHIFT_JIS_E3_80, &to_SHIFT_JIS_E3_81,
     &to_SHIFT_JIS_E3_82, &to_SHIFT_JIS_E3_83,
     &to_SHIFT_JIS_E3_88, &to_SHIFT_JIS_E3_8A,
     &to_SHIFT_JIS_E3_8C, &to_SHIFT_JIS_E3_8D,
     &to_SHIFT_JIS_E3_8E, &to_SHIFT_JIS_E3_8F,
                   UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E3 = {
    to_SHIFT_JIS_E3_offsets,
    to_SHIFT_JIS_E3_infos
};

static const unsigned char
to_SHIFT_JIS_E4_B8_offsets[64] = {
  /* used from to_SHIFT_JIS_E4_B8 */
  /* used from to_EUC_JP_E4_B8 */
      0,  1, 32,  2, 32, 32, 32,  3,    4,  5,  6,  7, 32,  8,  9, 32,
     10, 11, 32, 32, 12, 13, 14, 15,   16, 17, 32, 32, 32, 32, 18, 32,
     32, 19, 32, 32, 32, 32, 20, 32,   21, 32, 22, 32, 32, 23, 32, 32,
     32, 24, 25, 32, 32, 32, 26, 32,   27, 28, 32, 29, 30, 32, 32, 31,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E4_B8_infos[33] = {
     o2(0x88,0xEA), o2(0x92,0x9A), o2(0x8E,0xB5), o2(0x96,0x9C),
     o2(0x8F,0xE4), o2(0x8E,0x4F), o2(0x8F,0xE3), o2(0x89,0xBA),
     o2(0x95,0x73), o2(0x97,0x5E), o2(0x98,0xA0), o2(0x89,0x4E),
     o2(0x8A,0x8E), o2(0x98,0xA1), o2(0x90,0xA2), o2(0x99,0xC0),
     o2(0x8B,0x75), o2(0x95,0xB8), o2(0x8F,0xE5), o2(0x97,0xBC),
     o2(0x95,0xC0), o2(0xFA,0x68), o2(0x98,0xA2), o2(0x92,0x86),
     o2(0x98,0xA3), o2(0x8B,0xF8), o2(0x98,0xA4), o2(0x8A,0xDB),
     o2(0x92,0x4F), o2(0x8E,0xE5), o2(0x98,0xA5), o2(0x98,0xA6),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E4_B8 = {
    to_SHIFT_JIS_E4_B8_offsets,
    to_SHIFT_JIS_E4_B8_infos
};

static const unsigned char
to_SHIFT_JIS_E4_B9_offsets[64] = {
  /* used from to_SHIFT_JIS_E4_B9 */
  /* used from to_EUC_JP_E4_B9 */
     19, 19,  0,  1, 19,  2, 19, 19,   19, 19, 19,  3, 19,  4,  5,  6,
     19, 19, 19, 19, 19,  7,  8,  9,   10, 11, 19, 19, 19, 12, 13, 14,
     19, 19, 15, 19, 19, 19, 19, 19,   19, 19, 19, 19, 19, 19, 19, 19,
     19, 16, 19, 17, 19, 19, 19, 19,   19, 19, 19, 19, 19, 19, 18, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E4_B9_infos[20] = {
     o2(0x98,0xA7), o2(0x94,0x54), o2(0x8B,0x76), o2(0x94,0x56),
     o2(0x93,0xE1), o2(0x8C,0xC1), o2(0x96,0x52), o2(0xE5,0x68),
     o2(0x98,0xA8), o2(0x8F,0xE6), o2(0x98,0xA9), o2(0x89,0xB3),
     o2(0x8B,0xE3), o2(0x8C,0xEE), o2(0x96,0xE7), o2(0x9B,0xA4),
     o2(0x97,0x90), o2(0x93,0xFB), o2(0x8A,0xA3),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E4_B9 = {
    to_SHIFT_JIS_E4_B9_offsets,
    to_SHIFT_JIS_E4_B9_infos
};

static const unsigned char
to_SHIFT_JIS_E4_BA_offsets[64] = {
  /* used from to_SHIFT_JIS_E4_BA */
  /* used from to_EUC_JP_E4_BA */
      0, 35,  1, 35, 35,  2,  3, 35,    4,  5,  6,  7,  8, 35,  9, 35,
     35, 10, 11, 35, 12, 13, 35, 35,   14, 15, 35, 16, 17, 35, 18, 19,
     20, 21, 22, 35, 23, 24, 25, 35,   26, 35, 35, 27, 28, 29, 30, 35,
     31, 35, 35, 32, 35, 35, 33, 35,   35, 35, 34, 35, 35, 35, 35, 35,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E4_BA_infos[36] = {
     o2(0x8B,0x54), o2(0x98,0xAA), o2(0x98,0xAB), o2(0x97,0xB9),
     o2(0x97,0x5C), o2(0x91,0x88), o2(0x98,0xAD), o2(0x8E,0x96),
     o2(0x93,0xF1), o2(0x98,0xB0), o2(0x89,0x5D), o2(0x8C,0xDD),
     o2(0x8C,0xDC), o2(0x88,0xE4), o2(0x98,0x6A), o2(0x98,0x69),
     o2(0x8D,0xB1), o2(0x88,0x9F), o2(0x98,0xB1), o2(0x98,0xB2),
     o2(0x98,0xB3), o2(0x96,0x53), o2(0x98,0xB4), o2(0x8C,0xF0),
     o2(0x88,0xE5), o2(0x96,0x92), o2(0x8B,0x9C), o2(0x8B,0x9D),
     o2(0x8B,0x9E), o2(0x92,0xE0), o2(0x97,0xBA), o2(0x98,0xB5),
     o2(0x98,0xB6), o2(0x98,0xB7), o2(0x90,0x6C),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E4_BA = {
    to_SHIFT_JIS_E4_BA_offsets,
    to_SHIFT_JIS_E4_BA_infos
};

static const unsigned char
to_SHIFT_JIS_E4_BB_offsets[64] = {
  /* used from to_SHIFT_JIS_E4_BB */
  /* used from to_EUC_JP_E4_BB */
      0,  1,  2, 32,  3, 32,  4,  5,   32, 32,  6,  7, 32,  8,  9, 10,
     32, 32, 32, 32, 11, 12, 13, 14,   15, 16, 32, 32, 32, 17, 18, 19,
     32, 20, 32, 21, 22, 23, 32, 32,   32, 32, 32, 32, 32, 24, 25, 32,
     26, 32, 27, 32, 32, 32, 28, 29,   32, 32, 32, 30, 31, 32, 32, 32,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E4_BB_infos[33] = {
     o2(0x8F,0x59), o2(0x90,0x6D), o2(0x98,0xBC), o2(0x98,0xBA),
     o2(0x98,0xBB), o2(0x8B,0x77), o2(0x8D,0xA1), o2(0x89,0xEE),
     o2(0x98,0xB9), o2(0x98,0xB8), o2(0x95,0xA7), o2(0x8E,0x65),
     o2(0x8E,0x64), o2(0x91,0xBC), o2(0x98,0xBD), o2(0x95,0x74),
     o2(0x90,0xE5), o2(0x81,0x57), o2(0x98,0xBE), o2(0x98,0xC0),
     o2(0xFA,0x69), o2(0x91,0xE3), o2(0x97,0xDF), o2(0x88,0xC8),
     o2(0x98,0xBF), o2(0x89,0xBC), o2(0x8B,0xC2), o2(0x92,0x87),
     o2(0x8C,0x8F), o2(0x98,0xC1), o2(0x94,0x43), o2(0xFA,0x6A),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E4_BB = {
    to_SHIFT_JIS_E4_BB_offsets,
    to_SHIFT_JIS_E4_BB_infos
};

static const unsigned char
to_SHIFT_JIS_E4_BC_offsets[64] = {
  /* used from to_SHIFT_JIS_E4_BC */
  /* used from to_EUC_JP_E4_BC */
      0,  1, 22,  2, 22, 22, 22, 22,   22,  3,  4, 22, 22,  5,  6,  7,
      8,  9, 22, 22, 22, 22, 22, 22,   22, 22, 10, 22, 11, 12, 22, 22,
     22, 22, 22, 22, 22, 22, 22, 22,   22, 22, 22, 22, 22, 22, 22, 13,
     14, 22, 22, 22, 15, 22, 16, 22,   17, 18, 19, 22, 20, 21, 22, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E4_BC_infos[23] = {
     o2(0xFA,0x6B), o2(0x8A,0xE9), o2(0xFA,0x6C), o2(0x98,0xC2),
     o2(0x88,0xC9), o2(0x8C,0xDE), o2(0x8A,0xEA), o2(0x95,0x9A),
     o2(0x94,0xB0), o2(0x8B,0x78), o2(0x89,0xEF), o2(0x98,0xE5),
     o2(0x93,0x60), o2(0x94,0x8C), o2(0x98,0xC4), o2(0x94,0xBA),
     o2(0x97,0xE0), o2(0x90,0x4C), o2(0xFA,0x6D), o2(0x8E,0x66),
     o2(0x8E,0x97), o2(0x89,0xBE),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E4_BC = {
    to_SHIFT_JIS_E4_BC_offsets,
    to_SHIFT_JIS_E4_BC_infos
};

static const unsigned char
to_SHIFT_JIS_E4_BD_offsets[64] = {
  /* used from to_SHIFT_JIS_E4_BD */
  /* used from to_EUC_JP_E4_BD */
     27, 27, 27,  0, 27, 27,  1,  2,   27, 27, 27, 27, 27,  3,  4,  5,
      6,  7, 27,  8, 27,  9, 10, 11,   27, 12, 13, 14, 15, 16, 17, 27,
     27, 27, 27, 27, 27, 27, 27, 27,   27, 18, 27, 27, 27, 27, 27, 19,
     20, 27, 27, 21, 27, 22, 23, 27,   27, 27, 27, 24, 25, 27, 27, 26,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E4_BD_infos[28] = {
     o2(0x92,0xCF), o2(0x92,0x41), o2(0x98,0xC8), o2(0x88,0xCA),
     o2(0x92,0xE1), o2(0x8F,0x5A), o2(0x8D,0xB2), o2(0x97,0x43),
     o2(0x91,0xCC), o2(0x89,0xBD), o2(0xFA,0x6E), o2(0x98,0xC7),
     o2(0x97,0x5D), o2(0x98,0xC3), o2(0x98,0xC5), o2(0x8D,0xEC),
     o2(0x98,0xC6), o2(0x9B,0x43), o2(0x98,0xCE), o2(0x98,0xD1),
     o2(0x98,0xCF), o2(0x89,0xC0), o2(0x95,0xB9), o2(0x98,0xC9),
     o2(0x98,0xCD), o2(0x8C,0xF1), o2(0x8E,0x67),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E4_BD = {
    to_SHIFT_JIS_E4_BD_offsets,
    to_SHIFT_JIS_E4_BD_infos
};

static const unsigned char
to_SHIFT_JIS_E4_BE_offsets[64] = {
  /* used from to_SHIFT_JIS_E4_BE */
  /* used from to_EUC_JP_E4_BE */
     24, 24, 24,  0, 24, 24,  1, 24,    2, 24,  3,  4, 24,  5, 24,  6,
     24,  7,  8, 24,  9, 24, 10, 24,   11, 24, 12, 13, 24, 14, 24, 24,
     15, 16, 24, 24, 24, 24, 24, 24,   24, 24, 24, 17, 24, 18, 19, 20,
     24, 24, 24, 24, 24, 21, 22, 24,   24, 24, 24, 24, 24, 24, 24, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E4_BE_infos[25] = {
     o2(0x8A,0xA4), o2(0x98,0xD2), o2(0x98,0xCA), o2(0xFA,0x70),
     o2(0x97,0xE1), o2(0x8E,0x98), o2(0x98,0xCB), o2(0x98,0xD0),
     o2(0xFA,0x6F), o2(0xFA,0x72), o2(0x98,0xD3), o2(0x98,0xCC),
     o2(0xFA,0x71), o2(0x8B,0x9F), o2(0x88,0xCB), o2(0x8B,0xA0),
     o2(0x89,0xBF), o2(0x9B,0x44), o2(0x96,0x99), o2(0x95,0x8E),
     o2(0x8C,0xF2), o2(0x90,0x4E), o2(0x97,0xB5), o2(0x95,0xD6),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E4_BE = {
    to_SHIFT_JIS_E4_BE_offsets,
    to_SHIFT_JIS_E4_BE_infos
};

static const unsigned char
to_SHIFT_JIS_E4_BF_offsets[64] = {
  /* used from to_SHIFT_JIS_E4_BF */
  /* used from to_EUC_JP_E4_BF */
     29, 29,  0,  1,  2, 29, 29, 29,   29,  3,  4, 29, 29,  5,  6, 29,
      7,  8, 29, 29,  9, 29, 29, 10,   11, 29, 12, 13, 29, 14, 29, 15,
     29, 16, 29, 17, 18, 19, 29, 29,   29, 29, 29, 29, 29, 29, 20, 21,
     29, 29, 29, 22, 29, 23, 24, 29,   25, 29, 26, 29, 29, 29, 27, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E4_BF_infos[30] = {
     o2(0x8C,0x57), o2(0x91,0xA3), o2(0x89,0xE2), o2(0xFA,0x61),
     o2(0x8F,0x72), o2(0xFA,0x73), o2(0x98,0xD7), o2(0x98,0xDC),
     o2(0x98,0xDA), o2(0x98,0xD5), o2(0x91,0xAD), o2(0x98,0xD8),
     o2(0x98,0xDB), o2(0x98,0xD9), o2(0x95,0xDB), o2(0x98,0xD6),
     o2(0x90,0x4D), o2(0x96,0x93), o2(0x98,0xDD), o2(0x98,0xDE),
     o2(0x8F,0x43), o2(0x98,0xEB), o2(0x94,0x6F), o2(0x95,0x55),
     o2(0x98,0xE6), o2(0x95,0xEE), o2(0x89,0xB4), o2(0x98,0xEA),
     o2(0xFA,0x76),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E4_BF = {
    to_SHIFT_JIS_E4_BF_offsets,
    to_SHIFT_JIS_E4_BF_infos
};

static const unsigned char
to_SHIFT_JIS_E4_offsets[64] = {
  /* used from to_SHIFT_JIS_E4 */
  /* used from to_EUC_JP_E4 */
      8,  8,  8,  8,  8,  8,  8,  8,    8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,    8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,    8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,    0,  1,  2,  3,  4,  5,  6,  7,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E4_infos[9] = {
     &to_SHIFT_JIS_E4_B8, &to_SHIFT_JIS_E4_B9,
     &to_SHIFT_JIS_E4_BA, &to_SHIFT_JIS_E4_BB,
     &to_SHIFT_JIS_E4_BC, &to_SHIFT_JIS_E4_BD,
     &to_SHIFT_JIS_E4_BE, &to_SHIFT_JIS_E4_BF,
                   UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E4 = {
    to_SHIFT_JIS_E4_offsets,
    to_SHIFT_JIS_E4_infos
};

static const unsigned char
to_SHIFT_JIS_E5_80_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_80 */
  /* used from to_EUC_JP_E5_80 */
     28, 28, 28, 28, 28,  0,  1, 28,   28,  2, 28,  3, 28,  4, 28,  5,
     28,  6,  7, 28,  8, 28,  9, 28,   28, 10, 11, 28, 28, 28, 12, 13,
     28, 14, 15, 16, 17, 18, 19, 28,   20, 21, 22, 23, 24, 25, 28, 28,
     28, 28, 28, 28, 28, 28, 26, 28,   28, 27, 28, 28, 28, 28, 28, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_80_infos[29] = {
     o2(0x98,0xE4), o2(0x98,0xED), o2(0x91,0x71), o2(0x8C,0xC2),
     o2(0x94,0x7B), o2(0xE0,0xC5), o2(0x98,0xEC), o2(0x93,0x7C),
     o2(0x98,0xE1), o2(0x8C,0xF4), o2(0x8C,0xF3), o2(0x98,0xDF),
     o2(0xFA,0x77), o2(0x8E,0xD8), o2(0x98,0xE7), o2(0xFA,0x75),
     o2(0x95,0xED), o2(0x92,0x6C), o2(0x98,0xE3), o2(0x8C,0x91),
     o2(0x98,0xE0), o2(0x98,0xE8), o2(0x98,0xE2), o2(0x97,0xCF),
     o2(0x98,0xE9), o2(0x98,0x60), o2(0x8B,0xE4), o2(0x8C,0x90),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_80 = {
    to_SHIFT_JIS_E5_80_offsets,
    to_SHIFT_JIS_E5_80_infos
};

static const unsigned char
to_SHIFT_JIS_E5_81_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_81 */
  /* used from to_EUC_JP_E5_81 */
      0, 22,  1,  2, 22, 22,  3,  4,    5,  6, 22, 22, 22, 22, 22,  7,
      8, 22, 22, 22, 22,  9, 10, 22,   22, 22, 11, 22, 12, 22, 22, 22,
     22, 22, 22, 22, 22, 13, 22, 22,   22, 22, 22, 22, 14, 22, 22, 22,
     15, 22, 16, 22, 17, 18, 19, 22,   20, 22, 22, 22, 22, 21, 22, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_81_infos[23] = {
     o2(0xFA,0x74), o2(0xFA,0x7A), o2(0x98,0xEE), o2(0xFA,0x78),
     o2(0x98,0xEF), o2(0x98,0xF3), o2(0x88,0xCC), o2(0x95,0xCE),
     o2(0x98,0xF2), o2(0x98,0xF1), o2(0x98,0xF5), o2(0x98,0xF4),
     o2(0x92,0xE2), o2(0x8C,0x92), o2(0x98,0xF6), o2(0xFA,0x79),
     o2(0x8E,0xC3), o2(0x91,0xA4), o2(0x92,0xE3), o2(0x8B,0xF4),
     o2(0x98,0xF7), o2(0x8B,0x55),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_81 = {
    to_SHIFT_JIS_E5_81_offsets,
    to_SHIFT_JIS_E5_81_infos
};

static const unsigned char
to_SHIFT_JIS_E5_82_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_82 */
  /* used from to_EUC_JP_E5_82 */
      0, 16, 16, 16, 16,  1, 16, 16,   16, 16, 16, 16, 16,  2, 16, 16,
     16,  3, 16, 16,  4, 16, 16, 16,    5,  6,  7, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16,  8,  9, 16, 16,
     16, 16, 10, 11, 12, 13, 16, 14,   16, 16, 16, 16, 16, 16, 15, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_82_infos[17] = {
     o2(0x98,0xF8), o2(0x98,0xFA), o2(0x96,0x54), o2(0x8C,0x86),
     o2(0xFA,0x7B), o2(0x8E,0x50), o2(0x94,0xF5), o2(0x98,0xF9),
     o2(0x8D,0xC3), o2(0x97,0x62), o2(0x98,0xFC), o2(0x99,0x42),
     o2(0x98,0xFB), o2(0x8D,0xC2), o2(0x8F,0x9D), o2(0x8C,0x58),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_82 = {
    to_SHIFT_JIS_E5_82_offsets,
    to_SHIFT_JIS_E5_82_infos
};

static const unsigned char
to_SHIFT_JIS_E5_83_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_83 */
  /* used from to_EUC_JP_E5_83 */
     21, 21,  0, 21, 21,  1, 21, 21,   21,  2,  3, 21, 21,  4, 21,  5,
     21,  6, 21, 21, 21,  7,  8, 21,    9, 21, 10, 21, 21, 21, 11, 21,
     21, 21, 21, 12, 21, 13, 21, 14,   21, 21, 21, 21, 21, 15, 16, 21,
     21, 21, 21, 21, 17, 18, 21, 21,   21, 19, 21, 20, 21, 21, 21, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_83_infos[22] = {
     o2(0x99,0x43), o2(0x8B,0xCD), o2(0x99,0x40), o2(0x99,0x41),
     o2(0x93,0xAD), o2(0x91,0x9C), o2(0x8B,0xA1), o2(0x96,0x6C),
     o2(0x99,0x44), o2(0xFA,0x7D), o2(0x97,0xBB), o2(0x99,0x45),
     o2(0x99,0x48), o2(0x99,0x46), o2(0x91,0x6D), o2(0x99,0x47),
     o2(0x99,0x49), o2(0xFA,0x7C), o2(0x99,0x4B), o2(0x99,0x4A),
     o2(0x95,0xC6),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_83 = {
    to_SHIFT_JIS_E5_83_offsets,
    to_SHIFT_JIS_E5_83_infos
};

static const unsigned char
to_SHIFT_JIS_E5_84_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_84 */
  /* used from to_EUC_JP_E5_84 */
      0,  1,  2, 20,  3, 20, 20, 20,   20,  4, 20, 20, 20, 20, 20, 20,
     20, 20,  5, 20,  6,  7,  8, 20,    9, 20, 10, 20, 20, 20, 20, 11,
     20, 12, 20, 20, 20, 20, 20, 20,   20, 20, 13, 20, 20, 20, 20, 20,
     20, 20, 14, 20, 20, 20, 20, 15,   20, 20, 16, 17, 18, 20, 20, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_84_infos[21] = {
     o2(0x8B,0x56), o2(0x99,0x4D), o2(0x99,0x4E), o2(0x89,0xAD),
     o2(0x99,0x4C), o2(0x8E,0xF2), o2(0x99,0x51), o2(0x99,0x50),
     o2(0x99,0x4F), o2(0x98,0xD4), o2(0x99,0x52), o2(0x8F,0x9E),
     o2(0x99,0x53), o2(0x97,0x44), o2(0x96,0xD7), o2(0x99,0x55),
     o2(0x99,0x54), o2(0x99,0x57), o2(0x99,0x56), o2(0x99,0x58),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_84 = {
    to_SHIFT_JIS_E5_84_offsets,
    to_SHIFT_JIS_E5_84_infos
};

static const unsigned char
to_SHIFT_JIS_E5_85_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_85 */
  /* used from to_EUC_JP_E5_85 */
      0,  1, 35,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 35,
     14, 35, 15, 35, 16, 35, 35, 35,   35, 35, 17, 35, 18, 35, 35, 35,
     35, 35, 19, 35, 20, 21, 35, 35,   22, 23, 24, 25, 26, 27, 28, 35,
     35, 29, 35, 35, 35, 30, 31, 32,   33, 35, 35, 35, 34, 35, 35, 35,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_85_infos[36] = {
     o2(0x99,0x59), o2(0x88,0xF2), o2(0x8C,0xB3), o2(0x8C,0x5A),
     o2(0x8F,0x5B), o2(0x92,0x9B), o2(0x8B,0xA2), o2(0x90,0xE6),
     o2(0x8C,0xF5), o2(0xFA,0x7E), o2(0x8D,0x8E), o2(0x99,0x5B),
     o2(0x96,0xC6), o2(0x93,0x65), o2(0x8E,0x99), o2(0x99,0x5A),
     o2(0x99,0x5C), o2(0x93,0x7D), o2(0x8A,0x95), o2(0x99,0x5D),
     o2(0xFA,0x80), o2(0x93,0xFC), o2(0x91,0x53), o2(0x99,0x5F),
     o2(0x99,0x60), o2(0x94,0xAA), o2(0x8C,0xF6), o2(0x98,0x5A),
     o2(0x99,0x61), o2(0x8B,0xA4), o2(0x95,0xBA), o2(0x91,0xB4),
     o2(0x8B,0xEF), o2(0x93,0x54), o2(0x8C,0x93),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_85 = {
    to_SHIFT_JIS_E5_85_offsets,
    to_SHIFT_JIS_E5_85_infos
};

static const unsigned char
to_SHIFT_JIS_E5_86_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_86 */
  /* used from to_EUC_JP_E5_86 */
      0, 38,  1, 38, 38,  2,  3, 38,   38,  4,  5, 38,  6,  7, 38,  8,
      9, 10, 11, 12, 38, 13, 14, 15,   38, 16, 38, 38, 38, 17, 38, 38,
     18, 38, 19, 38, 20, 21, 22, 38,   23, 24, 25, 26, 27, 38, 38, 38,
     28, 29, 30, 31, 32, 33, 34, 35,   38, 38, 38, 38, 38, 36, 37, 38,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_86_infos[39] = {
     o2(0x99,0x62), o2(0x99,0x63), o2(0x93,0xE0), o2(0x89,0x7E),
     o2(0x99,0x66), o2(0x8D,0xFB), o2(0x99,0x65), o2(0x8D,0xC4),
     o2(0x99,0x67), o2(0xE3,0xEC), o2(0x99,0x68), o2(0x96,0x60),
     o2(0x99,0x69), o2(0x99,0x6A), o2(0x99,0x6B), o2(0x8F,0xE7),
     o2(0x8E,0xCA), o2(0xFA,0x81), o2(0x8A,0xA5), o2(0x99,0x6E),
     o2(0x99,0x6C), o2(0x96,0xBB), o2(0x99,0x6D), o2(0x95,0x79),
     o2(0x99,0x6F), o2(0x99,0x70), o2(0x99,0x71), o2(0x93,0x7E),
     o2(0x99,0x75), o2(0x99,0x73), o2(0x99,0x74), o2(0x99,0x72),
     o2(0x8D,0xE1), o2(0x99,0x76), o2(0x96,0xE8), o2(0x97,0xE2),
     o2(0x99,0x77), o2(0xFA,0x82),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_86 = {
    to_SHIFT_JIS_E5_86_offsets,
    to_SHIFT_JIS_E5_86_infos
};

static const unsigned char
to_SHIFT_JIS_E5_87_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_87 */
  /* used from to_EUC_JP_E5_87 */
     28, 28, 28, 28,  0,  1,  2, 28,   28,  3, 28,  4,  5,  6, 28, 28,
     28, 28, 28, 28, 28, 28,  7, 28,   28, 28, 28,  8,  9, 10, 28, 28,
     11, 12, 28, 28, 28, 28, 13, 14,   28, 15, 16, 28, 17, 18, 28, 28,
     19, 20, 28, 28, 28, 21, 22, 28,   23, 24, 25, 28, 28, 26, 27, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_87_infos[29] = {
     o2(0x90,0xA6), o2(0x99,0x78), o2(0x8F,0x79), o2(0x99,0x79),
     o2(0x92,0x9C), o2(0x97,0xBD), o2(0x93,0x80), o2(0x99,0xC3),
     o2(0x99,0x7A), o2(0xEA,0xA3), o2(0x8B,0xC3), o2(0x99,0x7B),
     o2(0x96,0x7D), o2(0x8F,0x88), o2(0x91,0xFA), o2(0x99,0x7D),
     o2(0x93,0xE2), o2(0xFA,0x83), o2(0x99,0x7E), o2(0x99,0x80),
     o2(0x8A,0x4D), o2(0x99,0x81), o2(0x8B,0xA5), o2(0x93,0xCA),
     o2(0x89,0x9A), o2(0x8F,0x6F), o2(0x94,0x9F), o2(0x99,0x82),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_87 = {
    to_SHIFT_JIS_E5_87_offsets,
    to_SHIFT_JIS_E5_87_infos
};

static const unsigned char
to_SHIFT_JIS_E5_88_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_88 */
  /* used from to_EUC_JP_E5_88 */
      0, 28, 28,  1,  2, 28,  3,  4,    5, 28,  6,  7, 28, 28,  8, 28,
     28,  9, 28, 28, 10, 11, 28, 12,   28, 28, 28, 28, 28, 13, 28, 28,
     28, 28, 28, 28, 14, 15, 28, 16,   28, 17, 18, 28, 28, 28, 19, 28,
     20, 28, 28, 21, 28, 28, 22, 23,   24, 25, 26, 27, 28, 28, 28, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_88_infos[29] = {
     o2(0x93,0x81), o2(0x90,0x6E), o2(0x99,0x83), o2(0x95,0xAA),
     o2(0x90,0xD8), o2(0x8A,0xA0), o2(0x8A,0xA7), o2(0x99,0x84),
     o2(0x99,0x86), o2(0x8C,0x59), o2(0x99,0x85), o2(0xFA,0x84),
     o2(0x97,0xF1), o2(0x8F,0x89), o2(0x94,0xBB), o2(0x95,0xCA),
     o2(0x99,0x87), o2(0x97,0x98), o2(0x99,0x88), o2(0x99,0x89),
     o2(0x93,0x9E), o2(0x99,0x8A), o2(0x90,0xA7), o2(0x8D,0xFC),
     o2(0x8C,0x94), o2(0x99,0x8B), o2(0x8E,0x68), o2(0x8D,0x8F),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_88 = {
    to_SHIFT_JIS_E5_88_offsets,
    to_SHIFT_JIS_E5_88_infos
};

static const unsigned char
to_SHIFT_JIS_E5_89_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_89 */
  /* used from to_EUC_JP_E5_89 */
     26, 26, 26,  0,  1, 26, 26,  2,   26, 26,  3,  4,  5,  6, 26,  7,
     26, 26, 26, 26,  8, 26,  9, 26,   26, 26, 26, 10, 26, 26, 11, 26,
     26, 26, 26, 12, 13, 14, 26, 26,   26, 15, 16, 26, 26, 26, 26, 17,
     18, 19, 20, 21, 22, 23, 26, 26,   26, 26, 26, 26, 26, 24, 26, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_89_infos[27] = {
     o2(0x92,0xE4), o2(0x99,0x8D), o2(0x91,0xA5), o2(0x8D,0xED),
     o2(0x99,0x8E), o2(0x99,0x8F), o2(0x91,0x4F), o2(0x99,0x8C),
     o2(0x99,0x91), o2(0x96,0x55), o2(0x8D,0x84), o2(0x99,0x90),
     o2(0x8C,0x95), o2(0x8D,0xDC), o2(0x94,0x8D), o2(0x99,0x94),
     o2(0x99,0x92), o2(0x95,0x9B), o2(0x8F,0xE8), o2(0x99,0x9B),
     o2(0x8A,0x84), o2(0x99,0x95), o2(0x99,0x93), o2(0x91,0x6E),
     o2(0x99,0x97), o2(0x99,0x96),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_89 = {
    to_SHIFT_JIS_E5_89_offsets,
    to_SHIFT_JIS_E5_89_infos
};

static const unsigned char
to_SHIFT_JIS_E5_8A_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_8A */
  /* used from to_EUC_JP_E5_8A */
     26, 26, 26,  0, 26, 26, 26,  1,    2,  3, 26, 26, 26,  4, 26, 26,
     26,  5,  6, 26,  7, 26, 26, 26,   26, 26, 26,  8,  9, 26, 26, 10,
     11, 26, 26, 12, 26, 26, 13, 26,   26, 14, 15, 16, 17, 18, 26, 19,
     26, 20, 26, 26, 21, 22, 26, 26,   26, 23, 26, 26, 24, 26, 25, 26,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_8A_infos[27] = {
     o2(0x8A,0x63), o2(0x8C,0x80), o2(0x99,0x9C), o2(0x97,0xAB),
     o2(0x99,0x98), o2(0x99,0x9D), o2(0x99,0x9A), o2(0x99,0x99),
     o2(0x97,0xCD), o2(0xFA,0x85), o2(0x8C,0xF7), o2(0x89,0xC1),
     o2(0x97,0xF2), o2(0xFA,0x86), o2(0x8F,0x95), o2(0x93,0x77),
     o2(0x8D,0x85), o2(0x99,0xA0), o2(0x99,0xA1), o2(0xFB,0x77),
     o2(0x97,0xE3), o2(0x98,0x4A), o2(0x99,0xA3), o2(0x8C,0xF8),
     o2(0x99,0xA2), o2(0x8A,0x4E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_8A = {
    to_SHIFT_JIS_E5_8A_offsets,
    to_SHIFT_JIS_E5_8A_infos
};

static const unsigned char
to_SHIFT_JIS_E5_8B_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_8B */
  /* used from to_EUC_JP_E5_8B */
      0,  1, 30,  2, 30,  3, 30,  4,   30,  5, 30, 30, 30,  6, 30, 30,
     30, 30,  7, 30, 30,  8, 30,  9,   10, 11, 30, 12, 30, 13, 14, 15,
     16, 30, 17, 18, 19, 30, 20, 21,   30, 30, 30, 30, 30, 30, 30, 30,
     30, 30, 22, 23, 30, 24, 30, 30,   25, 26, 27, 30, 30, 30, 28, 29,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_8B_infos[31] = {
     o2(0xFA,0x87), o2(0x99,0xA4), o2(0x96,0x75), o2(0x92,0xBA),
     o2(0x97,0x45), o2(0x95,0xD7), o2(0x99,0xA5), o2(0xE8,0xD3),
     o2(0x93,0xAE), o2(0x99,0xA6), o2(0x8A,0xA8), o2(0x96,0xB1),
     o2(0xFA,0x88), o2(0x8F,0x9F), o2(0x99,0xA7), o2(0x95,0xE5),
     o2(0x99,0xAB), o2(0x90,0xA8), o2(0x99,0xA8), o2(0x8B,0xCE),
     o2(0x99,0xA9), o2(0x8A,0xA9), o2(0x8C,0x4D), o2(0x99,0xAC),
     o2(0x99,0xAD), o2(0x99,0xAE), o2(0x99,0xAF), o2(0x8E,0xD9),
     o2(0x8C,0xF9), o2(0x96,0xDC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_8B = {
    to_SHIFT_JIS_E5_8B_offsets,
    to_SHIFT_JIS_E5_8B_infos
};

static const unsigned char
to_SHIFT_JIS_E5_8C_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_8C */
  /* used from to_EUC_JP_E5_8C */
      0,  1,  2, 29, 29,  3,  4,  5,    6, 29, 29, 29, 29,  7, 29,  8,
      9, 29, 29, 29, 29, 10, 11, 12,   29, 13, 14, 29, 29, 15, 29, 29,
     16, 17, 29, 18, 19, 29, 29, 29,   29, 29, 20, 29, 29, 29, 29, 21,
     29, 22, 29, 23, 29, 29, 29, 29,   24, 25, 26, 27, 29, 29, 29, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_8C_infos[30] = {
     o2(0xFA,0x89), o2(0x96,0xE6), o2(0x93,0xF5), o2(0x95,0xEF),
     o2(0x99,0xB0), o2(0xFA,0x8A), o2(0x99,0xB1), o2(0x99,0xB3),
     o2(0x99,0xB5), o2(0x99,0xB4), o2(0x99,0xB6), o2(0x89,0xBB),
     o2(0x96,0x6B), o2(0x8D,0xFA), o2(0x99,0xB7), o2(0x91,0x78),
     o2(0x8F,0xA0), o2(0x8B,0xA7), o2(0x99,0xB8), o2(0xFA,0x8B),
     o2(0x94,0xD9), o2(0x99,0xB9), o2(0x99,0xBA), o2(0x99,0xBB),
     o2(0x99,0xBC), o2(0x95,0x43), o2(0x8B,0xE6), o2(0x88,0xE3),
     o2(0x93,0xBD),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_8C = {
    to_SHIFT_JIS_E5_8C_offsets,
    to_SHIFT_JIS_E5_8C_infos
};

static const unsigned char
to_SHIFT_JIS_E5_8D_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_8D */
  /* used from to_EUC_JP_E5_8D */
      0,  1, 34,  2, 34,  3,  4,  5,    6,  7,  8, 34, 34,  9, 34, 34,
     34, 10, 11, 12, 13, 34, 34, 14,   15, 34, 16, 34, 17, 34, 18, 34,
     19, 34, 34, 34, 34, 34, 20, 34,   34, 21, 34, 34, 34, 34, 22, 23,
     24, 25, 26, 27, 28, 29, 34, 30,   31, 34, 34, 32, 34, 34, 34, 33,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_8D_infos[35] = {
     o2(0x99,0xBD), o2(0x8F,0x5C), o2(0x90,0xE7), o2(0x99,0xBF),
     o2(0x99,0xBE), o2(0x8F,0xA1), o2(0x8C,0xDF), o2(0x99,0xC1),
     o2(0x94,0xBC), o2(0x99,0xC2), o2(0x94,0xDA), o2(0x91,0xB2),
     o2(0x91,0xEC), o2(0x8B,0xA6), o2(0x93,0xEC), o2(0x92,0x50),
     o2(0x94,0x8E), o2(0x96,0x6D), o2(0x99,0xC4), o2(0x90,0xE8),
     o2(0x8C,0x54), o2(0x99,0xC5), o2(0x99,0xC6), o2(0x89,0x4B),
     o2(0x88,0xF3), o2(0x8A,0xEB), o2(0xFA,0x8C), o2(0x91,0xA6),
     o2(0x8B,0x70), o2(0x97,0x91), o2(0x99,0xC9), o2(0x89,0xB5),
     o2(0x99,0xC8), o2(0x8B,0xA8),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_8D = {
    to_SHIFT_JIS_E5_8D_offsets,
    to_SHIFT_JIS_E5_8D_infos
};

static const unsigned char
to_SHIFT_JIS_E5_8E_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_8E */
  /* used from to_EUC_JP_E5_8E */
     19, 19,  0, 19,  1, 19, 19, 19,   19, 19, 19, 19, 19, 19, 19, 19,
     19, 19, 19,  2, 19, 19,  3, 19,    4, 19,  5, 19, 19, 19, 19,  6,
      7, 19, 19, 19, 19,  8,  9, 19,   10, 11, 19, 19, 19, 12, 13, 19,
     14, 19, 15, 16, 19, 19, 17, 19,   19, 19, 19, 18, 19, 19, 19, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_8E_infos[20] = {
     o2(0x99,0xCA), o2(0x96,0xEF), o2(0xFA,0x8D), o2(0x99,0xCB),
     o2(0x97,0xD0), o2(0x8C,0xFA), o2(0x8C,0xB4), o2(0x99,0xCC),
     o2(0x99,0xCE), o2(0x99,0xCD), o2(0x90,0x7E), o2(0x89,0x58),
     o2(0x89,0x7D), o2(0x99,0xCF), o2(0x99,0xD0), o2(0xFA,0x8E),
     o2(0x8C,0xB5), o2(0x99,0xD1), o2(0x8B,0x8E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_8E = {
    to_SHIFT_JIS_E5_8E_offsets,
    to_SHIFT_JIS_E5_8E_infos
};

static const unsigned char
to_SHIFT_JIS_E5_8F_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_8F */
  /* used from to_EUC_JP_E5_8F */
     37, 37,  0,  1, 37, 37, 37, 37,    2,  3,  4,  5,  6,  7,  8, 37,
     37, 37, 37, 37,  9, 37, 10, 11,   37, 12, 37, 13, 37, 14, 37, 15,
     37, 16, 17, 18, 19, 20, 37, 37,   21, 22, 23, 24, 25, 26, 27, 28,
     29, 30, 31, 32, 37, 37, 33, 34,   35, 37, 36, 37, 37, 37, 37, 37,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_8F_infos[38] = {
     o2(0x8E,0x51), o2(0x99,0xD2), o2(0x96,0x94), o2(0x8D,0xB3),
     o2(0x8B,0x79), o2(0x97,0x46), o2(0x91,0x6F), o2(0x94,0xBD),
     o2(0x8E,0xFB), o2(0x8F,0x66), o2(0x8E,0xE6), o2(0x8E,0xF3),
     o2(0x8F,0x96), o2(0x94,0xBE), o2(0xFA,0x8F), o2(0x99,0xD5),
     o2(0x89,0x62), o2(0x91,0x70), o2(0x8C,0xFB), o2(0x8C,0xC3),
     o2(0x8B,0xE5), o2(0x99,0xD9), o2(0x92,0x40), o2(0x91,0xFC),
     o2(0x8B,0xA9), o2(0x8F,0xA2), o2(0x99,0xDA), o2(0x99,0xD8),
     o2(0x89,0xC2), o2(0x91,0xE4), o2(0x8E,0xB6), o2(0x8E,0x6A),
     o2(0x89,0x45), o2(0x8A,0x90), o2(0x8D,0x86), o2(0x8E,0x69),
     o2(0x99,0xDB),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_8F = {
    to_SHIFT_JIS_E5_8F_offsets,
    to_SHIFT_JIS_E5_8F_infos
};

static const unsigned char
to_SHIFT_JIS_E5_90_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_90 */
  /* used from to_EUC_JP_E5_90 */
     30,  0, 30,  1,  2, 30, 30, 30,    3,  4,  5,  6,  7,  8,  9, 10,
     11, 12, 30, 30, 30, 30, 30, 30,   30, 30, 30, 13, 30, 14, 30, 15,
     16, 30, 30, 30, 30, 30, 17, 30,   30, 18, 30, 19, 20, 21, 22, 30,
     30, 30, 30, 30, 30, 30, 23, 30,   24, 25, 30, 26, 27, 28, 29, 30,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_90_infos[31] = {
     o2(0x99,0xDC), o2(0x8B,0x68), o2(0x8A,0x65), o2(0x8D,0x87),
     o2(0x8B,0x67), o2(0x92,0xDD), o2(0x89,0x44), o2(0x93,0xAF),
     o2(0x96,0xBC), o2(0x8D,0x40), o2(0x97,0x99), o2(0x93,0x66),
     o2(0x8C,0xFC), o2(0x8C,0x4E), o2(0x99,0xE5), o2(0x8B,0xE1),
     o2(0x96,0x69), o2(0x94,0xDB), o2(0x99,0xE4), o2(0x8A,0xDC),
     o2(0x99,0xDF), o2(0x99,0xE0), o2(0x99,0xE2), o2(0x99,0xE3),
     o2(0x8B,0x7A), o2(0x90,0x81), o2(0x95,0xAB), o2(0x99,0xE1),
     o2(0x99,0xDD), o2(0x8C,0xE1),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_90 = {
    to_SHIFT_JIS_E5_90_offsets,
    to_SHIFT_JIS_E5_90_infos
};

static const unsigned char
to_SHIFT_JIS_E5_91_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_91 */
  /* used from to_EUC_JP_E5_91 */
      0, 20,  1, 20, 20, 20,  2, 20,    3,  4,  5, 20, 20, 20,  6, 20,
     20,  7, 20, 20, 20, 20, 20, 20,   20, 20, 20, 20, 20, 20, 20,  8,
     20, 20, 20, 20, 20, 20, 20, 20,    9, 20, 10, 20, 20, 20, 20, 20,
     11, 12, 20, 13, 20, 14, 15, 16,   20, 20, 20, 17, 18, 19, 20, 20,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_91_infos[21] = {
     o2(0x99,0xDE), o2(0x98,0x43), o2(0x95,0xF0), o2(0x92,0xE6),
     o2(0x8C,0xE0), o2(0x8D,0x90), o2(0x99,0xE6), o2(0x93,0xDB),
     o2(0x99,0xEA), o2(0x8E,0xFC), o2(0x8E,0xF4), o2(0x99,0xED),
     o2(0x99,0xEB), o2(0x96,0xA1), o2(0x99,0xE8), o2(0x99,0xF1),
     o2(0x99,0xEC), o2(0x99,0xEF), o2(0x8C,0xC4), o2(0x96,0xBD),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_91 = {
    to_SHIFT_JIS_E5_91_offsets,
    to_SHIFT_JIS_E5_91_infos
};

static const unsigned char
to_SHIFT_JIS_E5_92_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_92 */
  /* used from to_EUC_JP_E5_92 */
      0, 25, 25, 25,  1, 25,  2, 25,   25, 25,  3,  4,  5, 25,  6,  7,
      8, 25,  9, 25, 25, 25, 25, 25,   25, 25, 25, 25, 10, 25, 25, 25,
     25, 25, 11, 25, 12, 13, 25, 25,   14, 15, 25, 16, 17, 25, 25, 18,
     25, 25, 19, 20, 25, 25, 25, 25,   21, 25, 25, 25, 22, 23, 24, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_92_infos[26] = {
     o2(0x99,0xF0), o2(0x99,0xF2), o2(0x99,0xF4), o2(0xFA,0x92),
     o2(0x8D,0xEE), o2(0x98,0x61), o2(0x99,0xE9), o2(0x99,0xE7),
     o2(0x99,0xF3), o2(0x99,0xEE), o2(0xFA,0x91), o2(0x99,0xF6),
     o2(0x9A,0x42), o2(0x99,0xF8), o2(0x99,0xFC), o2(0xFA,0x93),
     o2(0x9A,0x40), o2(0x99,0xF9), o2(0x9A,0x5D), o2(0x8D,0xE7),
     o2(0x8A,0x50), o2(0x99,0xF7), o2(0x9A,0x44), o2(0x88,0xF4),
     o2(0x9A,0x43),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_92 = {
    to_SHIFT_JIS_E5_92_offsets,
    to_SHIFT_JIS_E5_92_infos
};

static const unsigned char
to_SHIFT_JIS_E5_93_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_93 */
  /* used from to_EUC_JP_E5_93 */
      0,  1,  2, 20,  3, 20, 20,  4,    5,  6, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20,    7, 20, 20, 20, 20, 20, 20, 20,
     20,  8,  9, 20, 20, 10, 11, 20,   12, 13, 20, 20, 20, 14, 15, 20,
     20, 20, 16, 20, 20, 20, 20, 20,   20, 20, 17, 20, 20, 18, 20, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_93_infos[21] = {
     o2(0x88,0xA3), o2(0x95,0x69), o2(0x9A,0x41), o2(0x99,0xFA),
     o2(0x99,0xF5), o2(0x99,0xFB), o2(0x8D,0xC6), o2(0x9A,0x45),
     o2(0x88,0xF5), o2(0x9A,0x4E), o2(0x9A,0x46), o2(0x9A,0x47),
     o2(0x8F,0xA3), o2(0x96,0x89), o2(0x9A,0x4C), o2(0x9A,0x4B),
     o2(0x93,0x4E), o2(0x9A,0x4D), o2(0x9A,0x4A), o2(0xFA,0x94),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_93 = {
    to_SHIFT_JIS_E5_93_offsets,
    to_SHIFT_JIS_E5_93_infos
};

static const unsigned char
to_SHIFT_JIS_E5_94_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_94 */
  /* used from to_EUC_JP_E5_94 */
     14, 14, 14, 14,  0, 14,  1,  2,   14, 14, 14, 14, 14, 14, 14,  3,
      4, 14, 14, 14,  5, 14,  6, 14,   14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,   14, 14, 14, 14, 14, 14,  7,  8,
     14,  9, 14, 10, 14, 14, 14, 14,   11, 12, 14, 14, 14, 14, 13, 14,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_94_infos[15] = {
     o2(0x89,0x53), o2(0x8D,0xB4), o2(0x90,0x4F), o2(0x9A,0x48),
     o2(0x93,0x82), o2(0x9A,0x49), o2(0x88,0xA0), o2(0x9A,0x53),
     o2(0x97,0x42), o2(0x8F,0xA5), o2(0x9A,0x59), o2(0x9A,0x58),
     o2(0x9A,0x4F), o2(0x91,0xC1),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_94 = {
    to_SHIFT_JIS_E5_94_offsets,
    to_SHIFT_JIS_E5_94_infos
};

static const unsigned char
to_SHIFT_JIS_E5_95_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_95 */
  /* used from to_EUC_JP_E5_95 */
      0, 15, 15, 15,  1,  2,  3, 15,   15, 15, 15, 15,  4, 15, 15,  5,
     15, 15, 15,  6, 15, 15,  7,  8,   15, 15, 15, 15,  9, 10, 15, 15,
     15, 15, 15, 11, 15, 15, 15, 15,   15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,   15, 15, 15, 12, 13, 15, 14, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_95_infos[16] = {
     o2(0x9A,0x50), o2(0x91,0xED), o2(0x9A,0x55), o2(0x8F,0xA4),
     o2(0x9A,0x52), o2(0x96,0xE2), o2(0x8C,0x5B), o2(0x9A,0x56),
     o2(0x9A,0x57), o2(0x9A,0x54), o2(0x9A,0x5A), o2(0x9A,0x51),
     o2(0x9A,0x60), o2(0x9A,0x65), o2(0x9A,0x61),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_95 = {
    to_SHIFT_JIS_E5_95_offsets,
    to_SHIFT_JIS_E5_95_infos
};

static const unsigned char
to_SHIFT_JIS_E5_96_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_96 */
  /* used from to_EUC_JP_E5_96 */
      0, 24, 24,  1,  2, 24,  3,  4,   24,  5,  6,  7, 24, 24, 24, 24,
     24, 24, 24, 24, 24, 24, 24, 24,    8,  9, 10, 24, 11, 12, 13, 14,
     24, 24, 24, 24, 24, 24, 24, 15,   16, 17, 18, 19, 20, 24, 21, 24,
     22, 24, 24, 24, 24, 24, 23, 24,   24, 24, 24, 24, 24, 24, 24, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_96_infos[25] = {
     o2(0x9A,0x5C), o2(0x9A,0x66), o2(0x91,0x50), o2(0xFA,0x95),
     o2(0x9A,0x68), o2(0x8D,0x41), o2(0x9A,0x5E), o2(0x92,0x9D),
     o2(0x9A,0x62), o2(0x9A,0x5B), o2(0x8A,0xAB), o2(0x8A,0xEC),
     o2(0x8A,0x85), o2(0x9A,0x63), o2(0x9A,0x5F), o2(0x8C,0x96),
     o2(0x9A,0x69), o2(0x9A,0x67), o2(0x91,0x72), o2(0x8B,0x69),
     o2(0x8B,0xAA), o2(0x9A,0x64), o2(0x8B,0xF2), o2(0x89,0x63),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_96 = {
    to_SHIFT_JIS_E5_96_offsets,
    to_SHIFT_JIS_E5_96_infos
};

static const unsigned char
to_SHIFT_JIS_E5_97_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_97 */
  /* used from to_EUC_JP_E5_97 */
     13, 13, 13, 13,  0,  1, 13,  2,   13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13,  3, 13, 13, 13,   13, 13,  4, 13,  5, 13, 13,  6,
     13, 13, 13,  7,  8, 13, 13, 13,   13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13,  9,   13, 10, 13, 13, 13, 11, 12, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_97_infos[14] = {
     o2(0x9A,0x6D), o2(0x9A,0x6B), o2(0x9A,0xA5), o2(0x9A,0x70),
     o2(0x9A,0x6A), o2(0x9A,0x6E), o2(0x9A,0x6C), o2(0x8E,0x6B),
     o2(0x9A,0x6F), o2(0x9A,0x72), o2(0x9A,0x77), o2(0x9A,0x75),
     o2(0x9A,0x74),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_97 = {
    to_SHIFT_JIS_E5_97_offsets,
    to_SHIFT_JIS_E5_97_infos
};

static const unsigned char
to_SHIFT_JIS_E5_98_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_98 */
  /* used from to_EUC_JP_E5_98 */
     14, 14, 14, 14, 14, 14,  0, 14,   14,  1, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14,  2, 14,  3,  4,    5, 14, 14,  6, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,   14,  7, 14, 14, 14, 14, 14,  8,
     14,  9, 10, 14, 11, 14, 12, 14,   13, 14, 14, 14, 14, 14, 14, 14,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_98_infos[15] = {
     o2(0x92,0x51), o2(0x89,0xC3), o2(0x9A,0x71), o2(0x9A,0x73),
     o2(0x8F,0xA6), o2(0x89,0x52), o2(0x9A,0x76), o2(0x89,0xDC),
     o2(0x9A,0x82), o2(0x8F,0xFA), o2(0x9A,0x7D), o2(0x9A,0x7B),
     o2(0x9A,0x7C), o2(0x9A,0x7E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_98 = {
    to_SHIFT_JIS_E5_98_offsets,
    to_SHIFT_JIS_E5_98_infos
};

static const unsigned char
to_SHIFT_JIS_E5_99_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_99 */
  /* used from to_EUC_JP_E5_99 */
     13, 13,  0, 13, 13, 13, 13, 13,   13, 13, 13, 13,  1, 13,  2, 13,
      3, 13, 13, 13, 13, 13, 13, 13,   13, 13, 13,  4, 13, 13, 13, 13,
     13, 13, 13, 13,  5, 13, 13, 13,    6, 13,  7,  8,  9, 13, 13, 13,
     13, 13, 13, 13, 10, 13, 13, 13,   11, 13, 12, 13, 13, 13, 13, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_99_infos[14] = {
     o2(0x89,0x5C), o2(0x91,0x58), o2(0x9A,0x78), o2(0x9A,0x79),
     o2(0x8A,0x9A), o2(0x9A,0x81), o2(0x8A,0xED), o2(0x9A,0x84),
     o2(0x9A,0x80), o2(0x9A,0x83), o2(0x95,0xAC), o2(0x93,0xD3),
     o2(0x94,0xB6),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_99 = {
    to_SHIFT_JIS_E5_99_offsets,
    to_SHIFT_JIS_E5_99_infos
};

static const unsigned char
to_SHIFT_JIS_E5_9A_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_9A */
  /* used from to_EUC_JP_E5_9A */
      0, 13, 13, 13, 13, 13,  1,  2,   13, 13,  3, 13, 13, 13, 13,  4,
     13, 13, 13, 13,  5, 13, 13, 13,   13, 13, 13, 13, 13, 13, 13, 13,
      6, 13,  7, 13, 13,  8, 13, 13,   13, 13, 13, 13, 13, 13,  9, 13,
     13, 13, 13, 13, 10, 13, 11, 13,   13, 13, 13, 13, 12, 13, 13, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_9A_infos[14] = {
     o2(0x9A,0x86), o2(0x9A,0x85), o2(0x8A,0x64), o2(0x9A,0x87),
     o2(0x9A,0x8A), o2(0x9A,0x89), o2(0x9A,0x88), o2(0x94,0x58),
     o2(0x9A,0x8B), o2(0x9A,0x8C), o2(0x9A,0x8E), o2(0x9A,0x8D),
     o2(0x9A,0x90),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_9A = {
    to_SHIFT_JIS_E5_9A_offsets,
    to_SHIFT_JIS_E5_9A_infos
};

static const unsigned char
to_SHIFT_JIS_E5_9B_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_9B */
  /* used from to_EUC_JP_E5_9B */
      0,  1,  2,  3, 23, 23, 23, 23,    4, 23, 23, 23, 23, 23,  5, 23,
     23,  6, 23,  7, 23, 23, 23,  8,    9, 23, 10, 11, 23, 23, 12, 23,
     13, 23, 23, 14, 23, 23, 23, 23,   23, 23, 23, 23, 23, 23, 15, 23,
     16, 23, 17, 18, 23, 23, 23, 23,   23, 19, 20, 23, 23, 21, 23, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_9B_infos[24] = {
     o2(0x9A,0x93), o2(0x9A,0x91), o2(0x9A,0x8F), o2(0x9A,0x92),
     o2(0x9A,0x94), o2(0x9A,0x95), o2(0x9A,0x96), o2(0x9A,0x97),
     o2(0x9A,0x98), o2(0x99,0x64), o2(0x8E,0xFA), o2(0x8E,0x6C),
     o2(0x89,0xF1), o2(0x88,0xF6), o2(0x92,0x63), o2(0x9A,0x99),
     o2(0x8D,0xA2), o2(0x88,0xCD), o2(0x90,0x7D), o2(0x9A,0x9A),
     o2(0x8C,0xC5), o2(0x8D,0x91), o2(0x9A,0x9C),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_9B = {
    to_SHIFT_JIS_E5_9B_offsets,
    to_SHIFT_JIS_E5_9B_infos
};

static const unsigned char
to_SHIFT_JIS_E5_9C_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_9C */
  /* used from to_EUC_JP_E5_9C */
      0, 22, 22,  1,  2, 22, 22, 22,    3,  4, 22,  5, 22,  6, 22,  7,
     22, 22,  8,  9, 22, 22, 10, 22,   11, 22, 22, 22, 12, 22, 22, 13,
     22, 22, 22, 22, 22, 22, 14, 15,   16, 22, 22, 22, 22, 17, 22, 22,
     18, 22, 22, 22, 22, 22, 22, 19,   20, 22, 22, 21, 22, 22, 22, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_9C_infos[23] = {
     o2(0x9A,0x9B), o2(0x95,0xDE), o2(0x9A,0x9D), o2(0x9A,0x9F),
     o2(0x9A,0x9E), o2(0x9A,0xA0), o2(0x9A,0xA1), o2(0x8C,0x97),
     o2(0x89,0x80), o2(0x9A,0xA2), o2(0x9A,0xA4), o2(0x9A,0xA3),
     o2(0x9A,0xA6), o2(0x93,0x79), o2(0x9A,0xA7), o2(0x88,0xB3),
     o2(0x8D,0xDD), o2(0x8C,0x5C), o2(0x92,0x6E), o2(0x9A,0xA8),
     o2(0x9A,0xA9), o2(0x9A,0xAB),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_9C = {
    to_SHIFT_JIS_E5_9C_offsets,
    to_SHIFT_JIS_E5_9C_infos
};

static const unsigned char
to_SHIFT_JIS_E5_9D_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_9D */
  /* used from to_EUC_JP_E5_9D */
      0, 16,  1, 16, 16, 16, 16,  2,   16, 16,  3, 16, 16, 16,  4,  5,
      6,  7, 16, 16, 16, 16, 16, 16,   16,  8, 16, 16, 16, 16, 16, 16,
     16,  9, 16, 16, 10, 11, 12, 16,   16, 13, 14, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 16, 16, 16, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_9D_infos[17] = {
     o2(0x9A,0xAC), o2(0x8D,0xE2), o2(0x8B,0xCF), o2(0x96,0x56),
     o2(0x9A,0xAA), o2(0x9A,0xAD), o2(0x8D,0xBF), o2(0x8D,0x42),
     o2(0xFA,0x96), o2(0x9A,0xB1), o2(0x8D,0xA3), o2(0xFA,0x97),
     o2(0x92,0x52), o2(0x9A,0xAE), o2(0x92,0xD8), o2(0x9A,0xB2),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_9D = {
    to_SHIFT_JIS_E5_9D_offsets,
    to_SHIFT_JIS_E5_9D_infos
};

static const unsigned char
to_SHIFT_JIS_E5_9E_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_9E */
  /* used from to_EUC_JP_E5_9E */
     13, 13,  0, 13, 13, 13, 13, 13,    1,  2, 13,  3, 13, 13, 13, 13,
     13, 13, 13,  4, 13, 13, 13, 13,   13, 13, 13, 13, 13, 13, 13, 13,
      5, 13,  6,  7,  8, 13, 13, 13,   13, 13,  9, 13, 10, 13, 13, 13,
     11, 13, 13, 12, 13, 13, 13, 13,   13, 13, 13, 13, 13, 13, 13, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_9E_infos[14] = {
     o2(0x90,0x82), o2(0x9A,0xB0), o2(0x9A,0xB3), o2(0x8C,0x5E),
     o2(0x9A,0xB4), o2(0x9A,0xB5), o2(0x8D,0x43), o2(0x8A,0x5F),
     o2(0x9A,0xB7), o2(0x9A,0xB8), o2(0xFA,0x98), o2(0x9A,0xB9),
     o2(0x9A,0xB6),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_9E = {
    to_SHIFT_JIS_E5_9E_offsets,
    to_SHIFT_JIS_E5_9E_infos
};

static const unsigned char
to_SHIFT_JIS_E5_9F_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_9F */
  /* used from to_EUC_JP_E5_9F */
      0, 20, 20,  1, 20, 20,  2,  3,    4, 20, 20,  5, 20, 20,  6, 20,
     20, 20,  7,  8,  9, 20, 10, 20,   20, 20, 20, 20, 11, 20, 20, 12,
     13, 20, 20, 14, 20, 20, 20, 20,   20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 15, 20, 20, 16,   20, 17, 18, 20, 19, 20, 20, 20,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_9F_infos[21] = {
     o2(0x9A,0xAF), o2(0x9A,0xBA), o2(0x9A,0xBB), o2(0xFA,0x9A),
     o2(0xFA,0x99), o2(0x96,0x84), o2(0x8F,0xE9), o2(0x9A,0xBD),
     o2(0x9A,0xBE), o2(0x9A,0xBC), o2(0x9A,0xC0), o2(0x94,0x57),
     o2(0x88,0xE6), o2(0x95,0x75), o2(0x9A,0xC1), o2(0x8F,0xFB),
     o2(0x8E,0xB7), o2(0x94,0x7C), o2(0x8A,0xEE), o2(0x8D,0xE9),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_9F = {
    to_SHIFT_JIS_E5_9F_offsets,
    to_SHIFT_JIS_E5_9F_infos
};

static const unsigned char
to_SHIFT_JIS_E5_A0_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_A0 */
  /* used from to_EUC_JP_E5_A0 */
      0, 19,  1, 19, 19,  2,  3, 19,   19, 19,  4,  5, 19, 19, 19, 19,
     19, 19, 19, 19, 19,  6, 19, 19,   19,  7, 19, 19, 19,  8, 19, 19,
     19,  9, 19, 19, 10, 19, 19, 19,   19, 19, 11, 19, 19, 19, 19, 12,
     13, 14, 19, 19, 15, 16, 19, 19,   19, 19, 17, 19, 19, 18, 19, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_A0_infos[20] = {
     o2(0x96,0x78), o2(0x93,0xB0), o2(0x8C,0x98), o2(0x91,0xCD),
     o2(0x9A,0xBF), o2(0x9A,0xC2), o2(0x91,0xC2), o2(0x9A,0xC3),
     o2(0x9A,0xC4), o2(0x9A,0xC6), o2(0x92,0xE7), o2(0x8A,0xAC),
     o2(0xEA,0x9F), o2(0x89,0x81), o2(0x95,0xF1), o2(0x8F,0xEA),
     o2(0x93,0x67), o2(0x8D,0xE4), o2(0x9A,0xCC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_A0 = {
    to_SHIFT_JIS_E5_A0_offsets,
    to_SHIFT_JIS_E5_A0_infos
};

static const unsigned char
to_SHIFT_JIS_E5_A1_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_A1 */
  /* used from to_EUC_JP_E5_A1 */
      0,  1, 20, 20, 20, 20, 20, 20,   20, 20,  2,  3, 20, 20, 20, 20,
     20,  4,  5, 20,  6, 20, 20,  7,    8,  9, 10, 20, 20, 20, 11, 20,
     20, 20, 12, 20, 20, 20, 20, 20,   20, 13, 20, 14, 20, 20, 20, 20,
     15, 20, 16, 20, 20, 17, 20, 20,   20, 18, 20, 20, 20, 20, 19, 20,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_A1_infos[21] = {
     o2(0x95,0xBB), o2(0x97,0xDB), o2(0x89,0xF2), o2(0x9A,0xC8),
     o2(0x91,0x59), o2(0x9A,0xCB), o2(0x93,0x83), o2(0x93,0x68),
     o2(0x93,0x84), o2(0x94,0xB7), o2(0x92,0xCB), o2(0x8D,0xC7),
     o2(0x9A,0xC7), o2(0x89,0x96), o2(0x93,0x55), o2(0x9A,0xC9),
     o2(0x9A,0xC5), o2(0x90,0x6F), o2(0x9A,0xCD), o2(0x8F,0x6D),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_A1 = {
    to_SHIFT_JIS_E5_A1_offsets,
    to_SHIFT_JIS_E5_A1_infos
};

static const unsigned char
to_SHIFT_JIS_E5_A2_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_A2 */
  /* used from to_EUC_JP_E5_A2 */
     17, 17, 17,  0, 17,  1, 17, 17,   17, 17, 17, 17, 17, 17, 17, 17,
     17, 17, 17,  2, 17, 17, 17,  3,   17, 17, 17, 17,  4, 17,  5,  6,
     17, 17, 17, 17, 17, 17, 17, 17,    7, 17, 17,  8, 17, 17,  9, 17,
     17, 17, 10, 11, 17, 17, 17, 17,   12, 13, 14, 15, 17, 17, 16, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_A2_infos[18] = {
     o2(0x8B,0xAB), o2(0x9A,0xCE), o2(0x95,0xE6), o2(0x91,0x9D),
     o2(0x92,0xC4), o2(0xFA,0x9D), o2(0x9A,0xD0), o2(0x96,0x6E),
     o2(0x9A,0xD1), o2(0x9A,0xD6), o2(0xFA,0x9E), o2(0x95,0xAD),
     o2(0x9A,0xD5), o2(0x9A,0xCF), o2(0x9A,0xD2), o2(0x9A,0xD4),
     o2(0x8D,0xA4),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_A2 = {
    to_SHIFT_JIS_E5_A2_offsets,
    to_SHIFT_JIS_E5_A2_infos
};

static const unsigned char
to_SHIFT_JIS_E5_A3_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_A3 */
  /* used from to_EUC_JP_E5_A3 */
     29,  0, 29, 29, 29,  1, 29,  2,   29, 29,  3, 29,  4, 29, 29, 29,
     29,  5, 29,  6, 29,  7, 29,  8,    9, 10, 29, 29, 11, 29, 12, 13,
     29, 29, 29, 29, 14, 15, 29, 29,   29, 29, 29, 16, 17, 29, 18, 19,
     20, 21, 22, 29, 29, 29, 29, 23,   29, 24, 25, 26, 27, 28, 29, 29,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_A3_infos[30] = {
     o2(0x95,0xC7), o2(0x9A,0xD7), o2(0x92,0x64), o2(0x89,0xF3),
     o2(0x8F,0xEB), o2(0x9A,0xD9), o2(0x9A,0xD8), o2(0x8D,0x88),
     o2(0x9A,0xDA), o2(0x9A,0xDC), o2(0x9A,0xDB), o2(0x9A,0xDE),
     o2(0x9A,0xD3), o2(0x9A,0xE0), o2(0x9A,0xDF), o2(0x9A,0xDD),
     o2(0x8E,0x6D), o2(0x90,0x70), o2(0x91,0x73), o2(0x9A,0xE1),
     o2(0x90,0xBA), o2(0x88,0xEB), o2(0x94,0x84), o2(0x92,0xD9),
     o2(0x9A,0xE3), o2(0x9A,0xE2), o2(0x9A,0xE4), o2(0x9A,0xE5),
     o2(0x9A,0xE6),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_A3 = {
    to_SHIFT_JIS_E5_A3_offsets,
    to_SHIFT_JIS_E5_A3_infos
};

static const unsigned char
to_SHIFT_JIS_E5_A4_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_A4 */
  /* used from to_EUC_JP_E5_A4 */
     27, 27,  0, 27, 27, 27, 27, 27,   27,  1,  2,  3, 27, 27, 27,  4,
      5, 27, 27, 27, 27,  6,  7, 27,    8,  9, 10, 11, 12, 27, 27, 27,
     27, 27, 13, 27, 27, 14, 27, 15,   27, 16, 17, 18, 19, 20, 21, 27,
     27, 22, 23, 27, 27, 27, 27, 24,   25, 27, 27, 27, 27, 27, 26, 27,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_A4_infos[28] = {
     o2(0x9A,0xE7), o2(0x95,0xCF), o2(0x9A,0xE8), o2(0xFA,0x9F),
     o2(0x89,0xC4), o2(0x9A,0xE9), o2(0x97,0x5B), o2(0x8A,0x4F),
     o2(0x99,0xC7), o2(0x8F,0x67), o2(0x91,0xBD), o2(0x9A,0xEA),
     o2(0x96,0xE9), o2(0x96,0xB2), o2(0x9A,0xEC), o2(0x91,0xE5),
     o2(0x93,0x56), o2(0x91,0xBE), o2(0x95,0x76), o2(0x9A,0xED),
     o2(0x9A,0xEE), o2(0x89,0x9B), o2(0x8E,0xB8), o2(0x9A,0xEF),
     o2(0x88,0xCE), o2(0x9A,0xF0), o2(0x9A,0xF1),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_A4 = {
    to_SHIFT_JIS_E5_A4_offsets,
    to_SHIFT_JIS_E5_A4_infos
};

static const unsigned char
to_SHIFT_JIS_E5_A5_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_A5 */
  /* used from to_EUC_JP_E5_A5 */
     30, 30, 30, 30,  0, 30, 30,  1,    2,  3, 30, 30, 30, 30,  4,  5,
      6,  7, 30,  8,  9, 10, 30, 11,   12, 30, 13, 14, 30, 15, 30, 30,
     16, 30, 17, 18, 30, 19, 30, 20,   21, 22, 23, 30, 24, 30, 25, 30,
     30, 30, 30, 26, 27, 30, 30, 30,   28, 30, 30, 30, 30, 29, 30, 30,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_A5_infos[31] = {
     o2(0x89,0x82), o2(0x8A,0xEF), o2(0x93,0xDE), o2(0x95,0xF2),
     o2(0x9A,0xF5), o2(0x91,0x74), o2(0x9A,0xF4), o2(0x8C,0x5F),
     o2(0xFA,0xA0), o2(0x96,0x7A), o2(0x9A,0xF3), o2(0x93,0x85),
     o2(0x9A,0xF7), o2(0x9A,0xF6), o2(0xFA,0xA1), o2(0xFA,0xA2),
     o2(0x9A,0xF9), o2(0x9A,0xF8), o2(0xFA,0xA3), o2(0x89,0x9C),
     o2(0x9A,0xFA), o2(0x8F,0xA7), o2(0x9A,0xFC), o2(0x92,0x44),
     o2(0x9A,0xFB), o2(0x95,0xB1), o2(0x8F,0x97), o2(0x93,0x7A),
     o2(0x9B,0x40), o2(0x8D,0x44),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_A5 = {
    to_SHIFT_JIS_E5_A5_offsets,
    to_SHIFT_JIS_E5_A5_infos
};

static const unsigned char
to_SHIFT_JIS_E5_A6_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_A6 */
  /* used from to_EUC_JP_E5_A6 */
     21,  0,  1,  2,  3, 21, 21, 21,   21, 21,  4, 21, 21,  5, 21, 21,
     21, 21, 21,  6, 21, 21,  7, 21,   21,  8, 21,  9, 21, 10, 21, 21,
     21, 21, 21, 11, 12, 13, 21, 21,   14, 21, 21, 21, 15, 21, 21, 21,
     21, 21, 16, 21, 21, 21, 21, 21,   21, 17, 18, 19, 21, 21, 20, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_A6_infos[22] = {
     o2(0x9B,0x41), o2(0x94,0x40), o2(0x94,0xDC), o2(0x96,0xCF),
     o2(0x94,0x44), o2(0x9B,0x4A), o2(0x8B,0x57), o2(0x97,0x64),
     o2(0x96,0xAD), o2(0x9B,0xAA), o2(0x9B,0x42), o2(0x9B,0x45),
     o2(0xFA,0xA4), o2(0x91,0xC3), o2(0x96,0x57), o2(0x93,0x69),
     o2(0x9B,0x46), o2(0x96,0x85), o2(0xFA,0xA5), o2(0x8D,0xC8),
     o2(0x8F,0xA8),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_A6 = {
    to_SHIFT_JIS_E5_A6_offsets,
    to_SHIFT_JIS_E5_A6_infos
};

static const unsigned char
to_SHIFT_JIS_E5_A7_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_A7 */
  /* used from to_EUC_JP_E5_A7 */
     18, 18, 18, 18, 18, 18,  0, 18,   18,  1, 18,  2, 18, 18, 18, 18,
      3,  4, 18,  5,  6, 18, 18, 18,   18,  7,  8, 18,  9, 18, 18, 18,
     18, 18, 18, 18, 18, 10, 11, 18,   12, 18, 13, 14, 18, 18, 18, 18,
     18, 18, 18, 18, 18, 18, 15, 18,   18, 18, 18, 16, 18, 18, 18, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_A7_infos[19] = {
     o2(0x9B,0x47), o2(0x8E,0x6F), o2(0x8E,0x6E), o2(0x88,0xB7),
     o2(0x8C,0xC6), o2(0x90,0xA9), o2(0x88,0xCF), o2(0x9B,0x4B),
     o2(0x9B,0x4C), o2(0x9B,0x49), o2(0x89,0x57), o2(0x8A,0xAD),
     o2(0x9B,0x48), o2(0x96,0xC3), o2(0x95,0x50), o2(0x88,0xA6),
     o2(0x88,0xF7), o2(0x8E,0x70),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_A7 = {
    to_SHIFT_JIS_E5_A7_offsets,
    to_SHIFT_JIS_E5_A7_infos
};

static const unsigned char
to_SHIFT_JIS_E5_A8_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_A8 */
  /* used from to_EUC_JP_E5_A8 */
     15,  0, 15,  1, 15, 15, 15, 15,   15,  2, 15, 15, 15, 15, 15, 15,
     15,  3, 15, 15, 15, 15, 15, 15,    4, 15,  5, 15,  6, 15, 15,  7,
      8, 15, 15, 15, 15,  9, 15, 15,   15, 10, 15, 15, 15, 15, 15, 11,
     15, 15, 15, 15, 15, 12, 13, 15,   15, 15, 15, 15, 14, 15, 15, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_A8_infos[16] = {
     o2(0x88,0xD0), o2(0x88,0xA1), o2(0x9B,0x51), o2(0x9B,0x4F),
     o2(0x96,0xBA), o2(0x9B,0x52), o2(0x9B,0x50), o2(0x9B,0x4E),
     o2(0x90,0x50), o2(0x9B,0x4D), o2(0x95,0xD8), o2(0x8C,0xE2),
     o2(0x9B,0x56), o2(0x9B,0x57), o2(0x8F,0xA9),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_A8 = {
    to_SHIFT_JIS_E5_A8_offsets,
    to_SHIFT_JIS_E5_A8_infos
};

static const unsigned char
to_SHIFT_JIS_E5_A9_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_A9 */
  /* used from to_EUC_JP_E5_A9 */
      0,  1, 10, 10, 10, 10,  2, 10,   10,  3, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,   10, 10,  4, 10, 10, 10, 10, 10,
     10, 10,  5, 10, 10, 10,  6, 10,   10, 10,  7, 10,  8, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,   10, 10, 10, 10, 10, 10, 10,  9,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_A9_infos[11] = {
     o2(0x9B,0x53), o2(0x98,0x4B), o2(0x94,0x6B), o2(0x9B,0x55),
     o2(0x8D,0xA5), o2(0x9B,0x58), o2(0x95,0x77), o2(0x9B,0x59),
     o2(0x9B,0x54), o2(0x96,0xB9),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_A9 = {
    to_SHIFT_JIS_E5_A9_offsets,
    to_SHIFT_JIS_E5_A9_infos
};

static const unsigned char
to_SHIFT_JIS_E5_AA_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_AA */
  /* used from to_EUC_JP_E5_AA */
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  0,  6,  6,  6,  6,  6,    6,  6,  1,  2,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  3,  4,  5,  6,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_AA_infos[7] = {
     o2(0x94,0x7D), o2(0x9B,0x5A), o2(0x95,0x51), o2(0x9B,0x5B),
     o2(0x9B,0x5F), o2(0x9B,0x5C),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_AA = {
    to_SHIFT_JIS_E5_AA_offsets,
    to_SHIFT_JIS_E5_AA_infos
};

static const unsigned char
to_SHIFT_JIS_E5_AB_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_AB */
  /* used from to_EUC_JP_E5_AB */
     14,  0,  1, 14, 14, 14, 14, 14,   14,  2, 14,  3,  4, 14, 14, 14,
      5, 14, 14, 14, 14, 14,  6,  7,   14, 14, 14, 14, 14, 14, 14, 14,
     14,  8, 14,  9, 14, 14, 10, 14,   14, 11, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,   14, 14, 12, 13, 14, 14, 14, 14,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_AB_infos[15] = {
     o2(0x89,0xC5), o2(0x9B,0x5E), o2(0x8E,0xB9), o2(0x9B,0x5D),
     o2(0x8C,0x99), o2(0x9B,0x6B), o2(0x9B,0x64), o2(0x9B,0x61),
     o2(0x92,0x84), o2(0x9B,0x60), o2(0x9B,0x62), o2(0x9B,0x63),
     o2(0x9B,0x65), o2(0x9B,0x66),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_AB = {
    to_SHIFT_JIS_E5_AB_offsets,
    to_SHIFT_JIS_E5_AB_infos
};

static const unsigned char
to_SHIFT_JIS_E5_AC_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_AC */
  /* used from to_EUC_JP_E5_AC */
     11, 11, 11, 11, 11, 11, 11, 11,   11,  0, 11,  1,  2, 11, 11, 11,
     11, 11, 11, 11, 11, 11,  3, 11,   11, 11, 11, 11, 11, 11, 11, 11,
     11, 11,  4, 11, 11, 11, 11, 11,   11, 11,  5, 11,  6, 11, 11, 11,
      7, 11,  8, 11, 11, 11,  9, 11,   11, 11, 11, 11, 11, 11, 10, 11,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_AC_infos[12] = {
     o2(0x8A,0xF0), o2(0x9B,0x68), o2(0x9B,0x67), o2(0x9B,0x69),
     o2(0x8F,0xEC), o2(0x9B,0x6C), o2(0x92,0xDA), o2(0x89,0x64),
     o2(0x9B,0x6A), o2(0x9B,0x6D), o2(0x9B,0x6E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_AC = {
    to_SHIFT_JIS_E5_AC_offsets,
    to_SHIFT_JIS_E5_AC_infos
};

static const unsigned char
to_SHIFT_JIS_E5_AD_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_AD */
  /* used from to_EUC_JP_E5_AD */
      0, 27, 27,  1, 27,  2, 27, 27,   27, 27, 27, 27, 27, 27, 27, 27,
      3,  4, 27, 27,  5,  6,  7,  8,    9, 27, 10, 11, 12, 13, 27, 14,
     27, 27, 27, 15, 16, 17, 18, 27,   27, 19, 27, 20, 27, 27, 27, 27,
     21, 22, 27, 23, 27, 24, 27, 27,   25, 27, 26, 27, 27, 27, 27, 27,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_AD_infos[28] = {
     o2(0x9B,0x71), o2(0x9B,0x6F), o2(0x9B,0x70), o2(0x8E,0x71),
     o2(0x9B,0x72), o2(0x8D,0x45), o2(0x9B,0x73), o2(0xFA,0xA6),
     o2(0x8E,0x9A), o2(0x91,0xB6), o2(0x9B,0x74), o2(0x9B,0x75),
     o2(0x8E,0x79), o2(0x8D,0x46), o2(0x96,0xD0), o2(0x8B,0x47),
     o2(0x8C,0xC7), o2(0x9B,0x76), o2(0x8A,0x77), o2(0x9B,0x77),
     o2(0x91,0xB7), o2(0x9B,0x78), o2(0x9B,0xA1), o2(0x9B,0x79),
     o2(0x9B,0x7A), o2(0x9B,0x7B), o2(0x9B,0x7D),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_AD = {
    to_SHIFT_JIS_E5_AD_offsets,
    to_SHIFT_JIS_E5_AD_infos
};

static const unsigned char
to_SHIFT_JIS_E5_AE_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_AE */
  /* used from to_EUC_JP_E5_AE */
      0, 33, 33,  1, 33,  2, 33,  3,    4,  5, 33,  6,  7,  8, 33,  9,
     33, 33, 33, 33, 33, 10, 33, 11,   12, 13, 14, 15, 16, 17, 33, 18,
     33, 33, 19, 20, 21, 22, 23, 33,   33, 33, 33, 33, 33, 33, 24, 33,
     25, 33, 33, 26, 27, 28, 29, 33,   30, 31, 33, 33, 33, 33, 33, 32,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_AE_infos[34] = {
     o2(0x9B,0x7E), o2(0x9B,0x80), o2(0x91,0xEE), o2(0x89,0x46),
     o2(0x8E,0xE7), o2(0x88,0xC0), o2(0x91,0x76), o2(0x8A,0xAE),
     o2(0x8E,0xB3), o2(0x8D,0x47), o2(0x93,0x86), o2(0x8F,0x40),
     o2(0x8A,0xAF), o2(0x92,0x88), o2(0x92,0xE8), o2(0x88,0xB6),
     o2(0x8B,0x58), o2(0x95,0xF3), o2(0x8E,0xC0), o2(0x8B,0x71),
     o2(0x90,0xE9), o2(0x8E,0xBA), o2(0x97,0x47), o2(0x9B,0x81),
     o2(0x8B,0x7B), o2(0x8D,0xC9), o2(0x8A,0x51), o2(0x89,0x83),
     o2(0x8F,0xAA), o2(0x89,0xC6), o2(0x9B,0x82), o2(0x97,0x65),
     o2(0x8F,0x68),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_AE = {
    to_SHIFT_JIS_E5_AE_offsets,
    to_SHIFT_JIS_E5_AE_infos
};

static const unsigned char
to_SHIFT_JIS_E5_AF_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_AF */
  /* used from to_EUC_JP_E5_AF */
      0, 37,  1,  2,  3,  4,  5,  6,   37,  7, 37, 37,  8, 37, 37, 37,
      9, 37, 10, 11, 12, 37, 37, 37,   13, 37, 37, 14, 37, 15, 16, 17,
     37, 18, 19, 37, 20, 21, 22, 23,   24, 25, 37, 26, 27, 37, 28, 37,
     29, 37, 37, 30, 37, 31, 32, 37,   33, 37, 34, 37, 37, 37, 35, 36,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_AF_infos[38] = {
     o2(0xFA,0xA7), o2(0x8E,0xE2), o2(0x9B,0x83), o2(0x8A,0xF1),
     o2(0x93,0xD0), o2(0x96,0xA7), o2(0x9B,0x84), o2(0x9B,0x85),
     o2(0x95,0x78), o2(0x9B,0x87), o2(0x8A,0xA6), o2(0x8B,0xF5),
     o2(0x9B,0x86), o2(0xFA,0xA9), o2(0x8A,0xB0), o2(0x90,0x51),
     o2(0x9B,0x8B), o2(0x8E,0x40), o2(0x89,0xC7), o2(0x9B,0x8A),
     o2(0x9B,0x88), o2(0x9B,0x8C), o2(0x9B,0x89), o2(0x94,0x4A),
     o2(0x9E,0xCB), o2(0x90,0x52), o2(0x9B,0x8D), o2(0xFA,0xAA),
     o2(0x97,0xBE), o2(0x9B,0x8E), o2(0x9B,0x90), o2(0x92,0x9E),
     o2(0x9B,0x8F), o2(0x90,0xA1), o2(0x8E,0x9B), o2(0x91,0xCE),
     o2(0x8E,0xF5),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_AF = {
    to_SHIFT_JIS_E5_AF_offsets,
    to_SHIFT_JIS_E5_AF_infos
};

static const unsigned char
to_SHIFT_JIS_E5_B0_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_B0 */
  /* used from to_EUC_JP_E5_B0 */
     32,  0,  1, 32,  2,  3,  4,  5,    6,  7,  8,  9, 32, 10, 11, 12,
     32, 13, 32, 14, 32, 32, 15, 32,   32, 32, 16, 32, 32, 32, 17, 32,
     18, 32, 19, 32, 20, 32, 32, 32,   21, 32, 32, 32, 32, 22, 32, 32,
     32, 23, 32, 32, 32, 32, 32, 32,   24, 25, 26, 27, 28, 29, 30, 31,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_B0_infos[33] = {
     o2(0x95,0x95), o2(0x90,0xEA), o2(0x8E,0xCB), o2(0x9B,0x91),
     o2(0x8F,0xAB), o2(0x9B,0x92), o2(0x9B,0x93), o2(0x88,0xD1),
     o2(0x91,0xB8), o2(0x90,0x71), o2(0x9B,0x94), o2(0x93,0xB1),
     o2(0x8F,0xAC), o2(0x8F,0xAD), o2(0x9B,0x95), o2(0x90,0xEB),
     o2(0x8F,0xAE), o2(0xFA,0xAB), o2(0x9B,0x96), o2(0x9B,0x97),
     o2(0x96,0xDE), o2(0x9B,0x98), o2(0x8B,0xC4), o2(0x8F,0x41),
     o2(0x9B,0x99), o2(0x9B,0x9A), o2(0x8E,0xDA), o2(0x90,0x4B),
     o2(0x93,0xF2), o2(0x90,0x73), o2(0x94,0xF6), o2(0x94,0x41),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_B0 = {
    to_SHIFT_JIS_E5_B0_offsets,
    to_SHIFT_JIS_E5_B0_infos
};

static const unsigned char
to_SHIFT_JIS_E5_B1_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_B1 */
  /* used from to_EUC_JP_E5_B1 */
      0,  1, 25, 25, 25,  2,  3, 25,    4, 25,  5,  6, 25,  7,  8,  9,
     10, 11, 25, 12, 25, 13, 25, 25,   25, 25, 25, 25, 25, 25, 14, 25,
     15, 16, 25, 25, 17, 18, 25, 25,   25, 25, 25, 25, 19, 25, 20, 21,
     25, 22, 25, 25, 25, 25, 23, 25,   25, 24, 25, 25, 25, 25, 25, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_B1_infos[26] = {
     o2(0x8B,0xC7), o2(0x9B,0x9B), o2(0x8B,0x8F), o2(0x9B,0x9C),
     o2(0x8B,0xFC), o2(0x93,0xCD), o2(0x89,0xAE), o2(0x8E,0x72),
     o2(0x9B,0x9D), o2(0x9B,0xA0), o2(0x9B,0x9F), o2(0x8B,0xFB),
     o2(0x9B,0x9E), o2(0x93,0x57), o2(0x91,0xAE), o2(0x93,0x6A),
     o2(0x8E,0xC6), o2(0x91,0x77), o2(0x97,0x9A), o2(0x9B,0xA2),
     o2(0x9B,0xA3), o2(0x93,0xD4), o2(0x8E,0x52), o2(0x9B,0xA5),
     o2(0x9B,0xA6),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_B1 = {
    to_SHIFT_JIS_E5_B1_offsets,
    to_SHIFT_JIS_E5_B1_infos
};

static const unsigned char
to_SHIFT_JIS_E5_B2_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_B2 */
  /* used from to_EUC_JP_E5_B2 */
     19, 19, 19, 19, 19, 19, 19, 19,   19, 19, 19, 19,  0, 19, 19, 19,
      1,  2, 19, 19,  3, 19, 19, 19,   19, 19, 19, 19, 19, 19, 19, 19,
     19,  4, 19, 19, 19, 19,  5, 19,    6,  7, 19,  8,  9, 19, 19, 19,
     19, 10, 19, 11, 19, 19, 12, 13,   14, 19, 15, 16, 17, 19, 18, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_B2_infos[20] = {
     o2(0x9B,0xA7), o2(0x8A,0xF2), o2(0x9B,0xA8), o2(0x9B,0xA9),
     o2(0x89,0xAA), o2(0xFA,0xAC), o2(0x91,0x5A), o2(0x8A,0xE2),
     o2(0x9B,0xAB), o2(0x96,0xA6), o2(0x91,0xD0), o2(0x8A,0x78),
     o2(0x9B,0xAD), o2(0x9B,0xAF), o2(0x8A,0xDD), o2(0xFA,0xAD),
     o2(0x9B,0xAC), o2(0x9B,0xAE), o2(0x9B,0xB1),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_B2 = {
    to_SHIFT_JIS_E5_B2_offsets,
    to_SHIFT_JIS_E5_B2_infos
};

static const unsigned char
to_SHIFT_JIS_E5_B3_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_B3 */
  /* used from to_EUC_JP_E5_B3 */
     16, 16, 16, 16, 16,  0, 16,  1,   16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,   16,  2, 16, 16, 16, 16, 16, 16,
      3,  4, 16, 16, 16, 16, 16, 16,    5,  6,  7, 16, 16,  8, 16,  9,
     10, 16, 16, 16, 16, 11, 12, 16,   16, 16, 13, 14, 16, 15, 16, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_B3_infos[17] = {
     o2(0x9B,0xB0), o2(0x9B,0xB2), o2(0x9B,0xB3), o2(0x93,0xBB),
     o2(0x8B,0xAC), o2(0x89,0xE3), o2(0x9B,0xB4), o2(0x9B,0xB9),
     o2(0x9B,0xB7), o2(0x95,0xF5), o2(0x95,0xF4), o2(0xFA,0xAE),
     o2(0x93,0x87), o2(0x9B,0xB6), o2(0x8F,0x73), o2(0x9B,0xB5),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_B3 = {
    to_SHIFT_JIS_E5_B3_offsets,
    to_SHIFT_JIS_E5_B3_infos
};

static const unsigned char
to_SHIFT_JIS_E5_B4_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_B4 */
  /* used from to_EUC_JP_E5_B4 */
     16, 16, 16, 16, 16, 16, 16,  0,   16, 16, 16,  1, 16, 16,  2, 16,
     16,  3, 16, 16,  4,  5,  6,  7,    8,  9, 10, 11, 16, 16, 16, 12,
     16, 16, 13, 16, 16, 16, 16, 14,   16, 15, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 16, 16, 16, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_B4_infos[17] = {
     o2(0x90,0x92), o2(0x9B,0xBA), o2(0x8D,0xE8), o2(0x9B,0xC0),
     o2(0x9B,0xC1), o2(0x9B,0xBB), o2(0x8A,0x52), o2(0x9B,0xBC),
     o2(0x9B,0xC5), o2(0x9B,0xC4), o2(0x9B,0xC3), o2(0x9B,0xBF),
     o2(0x9B,0xBE), o2(0x9B,0xC2), o2(0xFA,0xAF), o2(0x95,0xF6),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_B4 = {
    to_SHIFT_JIS_E5_B4_offsets,
    to_SHIFT_JIS_E5_B4_infos
};

static const unsigned char
to_SHIFT_JIS_E5_B5_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_B5 */
  /* used from to_EUC_JP_E5_B5 */
     14, 14,  0, 14, 14, 14, 14, 14,   14, 14, 14,  1,  2, 14,  3, 14,
      4, 14,  5,  6, 14, 14, 14, 14,   14, 14, 14, 14,  7, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,   14,  8, 14, 14,  9, 10, 14, 11,
     14, 14, 14, 12, 14, 14, 13, 14,   14, 14, 14, 14, 14, 14, 14, 14,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_B5_infos[15] = {
     o2(0xFA,0xB2), o2(0x9B,0xC9), o2(0x9B,0xC6), o2(0x9B,0xC8),
     o2(0x97,0x92), o2(0x9B,0xC7), o2(0xFA,0xB0), o2(0x9B,0xBD),
     o2(0x90,0x93), o2(0x9B,0xCA), o2(0xFA,0xB3), o2(0x8D,0xB5),
     o2(0x9B,0xCB), o2(0x9B,0xCC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_B5 = {
    to_SHIFT_JIS_E5_B5_offsets,
    to_SHIFT_JIS_E5_B5_infos
};

static const unsigned char
to_SHIFT_JIS_E5_B6_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_B6 */
  /* used from to_EUC_JP_E5_B6 */
     16, 16,  0, 16,  1, 16, 16,  2,   16, 16, 16,  3,  4, 16, 16, 16,
      5, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 16,  6, 16, 16,
     16, 16,  7, 16, 16, 16, 16, 16,   16, 16, 16, 16,  8, 16,  9, 16,
     16, 16, 16, 16, 16, 16, 16, 10,   11, 12, 13, 16, 14, 15, 16, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_B6_infos[17] = {
     o2(0x9B,0xCF), o2(0x9B,0xCE), o2(0x9B,0xCD), o2(0x93,0x88),
     o2(0x9B,0xB8), o2(0x9B,0xD5), o2(0x9B,0xD1), o2(0x9B,0xD0),
     o2(0x9B,0xD2), o2(0x9B,0xD3), o2(0x9B,0xD6), o2(0xFA,0xB4),
     o2(0xFA,0xB5), o2(0x97,0xE4), o2(0x9B,0xD7), o2(0x9B,0xD4),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_B6 = {
    to_SHIFT_JIS_E5_B6_offsets,
    to_SHIFT_JIS_E5_B6_infos
};

static const unsigned char
to_SHIFT_JIS_E5_B7_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_B7 */
  /* used from to_EUC_JP_E5_B7 */
     27, 27, 27, 27, 27, 27, 27, 27,   27,  0, 27, 27,  1,  2, 27, 27,
      3, 27,  4,  5, 27, 27,  6, 27,   27, 27, 27,  7, 27,  8,  9, 27,
     27, 10, 27, 11, 27, 12, 13, 14,   15, 27, 27, 16, 27, 27, 17, 27,
     27, 18, 19, 20, 21, 22, 27, 23,   27, 27, 27, 24, 27, 25, 26, 27,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_B7_infos[28] = {
     o2(0x9B,0xD8), o2(0x8A,0xDE), o2(0x9B,0xD9), o2(0xFA,0xB6),
     o2(0x9B,0xDB), o2(0x9B,0xDA), o2(0x9B,0xDC), o2(0x9B,0xDD),
     o2(0x90,0xEC), o2(0x8F,0x42), o2(0x8F,0x84), o2(0x91,0x83),
     o2(0x8D,0x48), o2(0x8D,0xB6), o2(0x8D,0x49), o2(0x8B,0x90),
     o2(0x9B,0xDE), o2(0x8D,0xB7), o2(0x8C,0xC8), o2(0x9B,0xDF),
     o2(0x96,0xA4), o2(0x94,0x62), o2(0x9B,0xE0), o2(0x8D,0x4A),
     o2(0x8A,0xAA), o2(0x92,0x46), o2(0x8B,0xD0),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_B7 = {
    to_SHIFT_JIS_E5_B7_offsets,
    to_SHIFT_JIS_E5_B7_infos
};

static const unsigned char
to_SHIFT_JIS_E5_B8_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_B8 */
  /* used from to_EUC_JP_E5_B8 */
     21, 21,  0,  1, 21, 21,  2, 21,   21, 21, 21,  3,  4, 21, 21, 21,
     21,  5, 21, 21, 21, 21,  6, 21,   21,  7,  8,  9, 21, 10, 21, 21,
     21, 21, 21, 21, 21, 11, 21, 21,   21, 21, 21, 12, 21, 13, 21, 14,
     15, 21, 21, 16, 21, 21, 17, 18,   19, 21, 21, 21, 21, 20, 21, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_B8_infos[22] = {
     o2(0x8E,0x73), o2(0x95,0x7A), o2(0x94,0xBF), o2(0x9B,0xE1),
     o2(0x8A,0xF3), o2(0x9B,0xE4), o2(0x92,0x9F), o2(0x9B,0xE3),
     o2(0x9B,0xE2), o2(0x9B,0xE5), o2(0x92,0xE9), o2(0x90,0x83),
     o2(0x8E,0x74), o2(0x90,0xC8), o2(0x91,0xD1), o2(0x8B,0x41),
     o2(0x92,0xA0), o2(0x9B,0xE6), o2(0x9B,0xE7), o2(0x8F,0xED),
     o2(0x96,0x58),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_B8 = {
    to_SHIFT_JIS_E5_B8_offsets,
    to_SHIFT_JIS_E5_B8_infos
};

static const unsigned char
to_SHIFT_JIS_E5_B9_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_B9 */
  /* used from to_EUC_JP_E5_B9 */
      0, 28, 28,  1,  2,  3, 28,  4,   28, 28, 28, 28,  5, 28,  6, 28,
     28, 28, 28, 28,  7,  8, 28,  9,   28, 28, 28, 28, 28, 28, 28, 10,
     28, 11, 12, 13, 14, 28, 28, 28,   28, 28, 28, 28, 28, 28, 28, 28,
     28, 28, 15, 16, 17, 18, 19, 28,   20, 21, 22, 23, 24, 25, 26, 27,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_B9_infos[29] = {
     o2(0x9B,0xEA), o2(0x9B,0xE9), o2(0x9B,0xE8), o2(0x95,0x9D),
     o2(0x9B,0xF1), o2(0x96,0x79), o2(0x9B,0xEB), o2(0x9B,0xED),
     o2(0x96,0x8B), o2(0x9B,0xEC), o2(0x9B,0xEE), o2(0x94,0xA6),
     o2(0x9B,0xEF), o2(0x95,0xBC), o2(0x9B,0xF0), o2(0x8A,0xB1),
     o2(0x95,0xBD), o2(0x94,0x4E), o2(0x9B,0xF2), o2(0x9B,0xF3),
     o2(0x8D,0x4B), o2(0x8A,0xB2), o2(0x9B,0xF4), o2(0x8C,0xB6),
     o2(0x97,0x63), o2(0x97,0x48), o2(0x8A,0xF4), o2(0x9B,0xF6),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_B9 = {
    to_SHIFT_JIS_E5_B9_offsets,
    to_SHIFT_JIS_E5_B9_infos
};

static const unsigned char
to_SHIFT_JIS_E5_BA_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_BA */
  /* used from to_EUC_JP_E5_BA */
     20,  0, 20,  1,  2, 20, 20,  3,   20, 20,  4, 20, 20, 20, 20,  5,
     20, 20, 20, 20, 20,  6,  7,  8,   20, 20,  9, 20, 10, 20, 20, 20,
     11, 20, 20, 20, 20, 20, 12, 13,   20, 20, 20, 14, 20, 15, 20, 20,
     20, 20, 20, 20, 20, 16, 17, 18,   19, 20, 20, 20, 20, 20, 20, 20,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_BA_infos[21] = {
     o2(0x92,0xA1), o2(0x8D,0x4C), o2(0x8F,0xAF), o2(0x94,0xDD),
     o2(0x8F,0xB0), o2(0x8F,0x98), o2(0x92,0xEA), o2(0x95,0xF7),
     o2(0x93,0x58), o2(0x8D,0x4D), o2(0x95,0x7B), o2(0x9B,0xF7),
     o2(0x93,0x78), o2(0x8D,0xC0), o2(0x8C,0xC9), o2(0x92,0xEB),
     o2(0x88,0xC1), o2(0x8F,0x8E), o2(0x8D,0x4E), o2(0x97,0x66),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_BA = {
    to_SHIFT_JIS_E5_BA_offsets,
    to_SHIFT_JIS_E5_BA_infos
};

static const unsigned char
to_SHIFT_JIS_E5_BB_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_BB */
  /* used from to_EUC_JP_E5_BB */
     33,  0,  1,  2, 33, 33, 33, 33,    3,  4,  5, 33, 33, 33, 33,  6,
      7, 33, 33,  8, 33, 33,  9, 33,   33, 33, 10, 11, 33, 12, 33, 13,
     14, 15, 16, 17, 33, 33, 33, 33,   18, 19, 33, 33, 20, 33, 33, 33,
     21, 22, 33, 23, 24, 33, 25, 26,   27, 33, 28, 29, 30, 33, 31, 32,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_BB_infos[34] = {
     o2(0x9B,0xF8), o2(0x9B,0xF9), o2(0x94,0x70), o2(0x9B,0xFA),
     o2(0x97,0xF5), o2(0x98,0x4C), o2(0x9B,0xFC), o2(0x9B,0xFB),
     o2(0x8A,0x66), o2(0x9C,0x40), o2(0x9C,0x43), o2(0x9C,0x44),
     o2(0x9C,0x42), o2(0x95,0x5F), o2(0x8F,0xB1), o2(0x9C,0x46),
     o2(0x9C,0x45), o2(0x9C,0x41), o2(0x9C,0x47), o2(0x9C,0x48),
     o2(0x9C,0x49), o2(0x9C,0x4C), o2(0x9C,0x4A), o2(0x9C,0x4B),
     o2(0x9C,0x4D), o2(0x89,0x84), o2(0x92,0xEC), o2(0x9C,0x4E),
     o2(0x8C,0x9A), o2(0x89,0xF4), o2(0x94,0x55), o2(0x9C,0x4F),
     o2(0x93,0xF9),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_BB = {
    to_SHIFT_JIS_E5_BB_offsets,
    to_SHIFT_JIS_E5_BB_infos
};

static const unsigned char
to_SHIFT_JIS_E5_BC_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_BC */
  /* used from to_EUC_JP_E5_BC */
     33,  0, 33,  1,  2, 33, 33, 33,   33,  3,  4,  5,  6,  7, 33,  8,
      9, 10, 33, 11, 12, 13, 14, 15,   16, 33, 33, 17, 33, 33, 33, 18,
     33, 19, 33, 33, 33, 20, 21, 22,   33, 23, 33, 33, 33, 24, 33, 25,
     33, 26, 33, 33, 27, 28, 33, 29,   30, 33, 33, 33, 31, 33, 32, 33,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_BC_infos[34] = {
     o2(0x95,0xD9), o2(0x9C,0x50), o2(0x98,0x4D), o2(0x9C,0x51),
     o2(0x95,0xBE), o2(0x9C,0x54), o2(0x98,0x9F), o2(0x98,0xAF),
     o2(0x8E,0xAE), o2(0x93,0xF3), o2(0x9C,0x55), o2(0x8B,0x7C),
     o2(0x92,0xA2), o2(0x88,0xF8), o2(0x9C,0x56), o2(0x95,0xA4),
     o2(0x8D,0x4F), o2(0x92,0x6F), o2(0x92,0xED), o2(0xFA,0xB7),
     o2(0x96,0xED), o2(0x8C,0xB7), o2(0x8C,0xCA), o2(0x9C,0x57),
     o2(0x9C,0x58), o2(0x9C,0x5E), o2(0x8E,0xE3), o2(0xFA,0xB8),
     o2(0x92,0xA3), o2(0x8B,0xAD), o2(0x9C,0x59), o2(0x95,0x4A),
     o2(0x92,0x65),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_BC = {
    to_SHIFT_JIS_E5_BC_offsets,
    to_SHIFT_JIS_E5_BC_infos
};

static const unsigned char
to_SHIFT_JIS_E5_BD_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_BD */
  /* used from to_EUC_JP_E5_BD */
     29,  0, 29, 29, 29,  1, 29, 29,    2, 29,  3, 29,  4, 29,  5, 29,
     29,  6, 29,  7, 29, 29,  8,  9,   29, 10, 29, 29, 11, 12, 29, 29,
     29, 13, 14, 29, 29, 29, 15, 16,   29, 17, 18, 19, 20, 21, 29, 29,
     22, 23, 29, 24, 29, 29, 29, 25,   29, 26, 29, 29, 27, 29, 29, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_BD_infos[30] = {
     o2(0x9C,0x5A), o2(0xFA,0x67), o2(0x9C,0x5B), o2(0x8B,0xAE),
     o2(0x9C,0x5C), o2(0x9C,0x5D), o2(0x9C,0x5F), o2(0x93,0x96),
     o2(0x9C,0x60), o2(0x9C,0x61), o2(0x9C,0x62), o2(0x9C,0x53),
     o2(0x9C,0x52), o2(0x9C,0x63), o2(0x8C,0x60), o2(0x95,0x46),
     o2(0xFA,0xB9), o2(0x8D,0xCA), o2(0x95,0x56), o2(0x92,0xA4),
     o2(0x95,0x6A), o2(0x9C,0x64), o2(0x8F,0xB2), o2(0x89,0x65),
     o2(0x9C,0x65), o2(0x9C,0x66), o2(0x96,0xF0), o2(0x94,0xDE),
     o2(0x9C,0x69),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_BD = {
    to_SHIFT_JIS_E5_BD_offsets,
    to_SHIFT_JIS_E5_BD_infos
};

static const unsigned char
to_SHIFT_JIS_E5_BE_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_BE */
  /* used from to_EUC_JP_E5_BE */
      0,  1,  2,  3,  4,  5, 32,  6,    7, 32,  8,  9, 10, 32, 32, 32,
     11, 12, 13, 14, 32, 32, 32, 15,   16, 17, 32, 32, 32, 32, 18, 32,
     19, 20, 32, 32, 32, 32, 32, 32,   21, 22, 23, 32, 32, 24, 25, 32,
     32, 32, 32, 26, 27, 32, 32, 28,   32, 29, 32, 32, 30, 31, 32, 32,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_BE_infos[33] = {
     o2(0x89,0x9D), o2(0x90,0xAA), o2(0x9C,0x68), o2(0x9C,0x67),
     o2(0x8C,0x61), o2(0x91,0xD2), o2(0x9C,0x6D), o2(0x9C,0x6B),
     o2(0x9C,0x6A), o2(0x97,0xA5), o2(0x8C,0xE3), o2(0x8F,0x99),
     o2(0x9C,0x6C), o2(0x93,0x6B), o2(0x8F,0x5D), o2(0x93,0xBE),
     o2(0x9C,0x70), o2(0x9C,0x6F), o2(0x9C,0x6E), o2(0x9C,0x71),
     o2(0x8C,0xE4), o2(0x9C,0x72), o2(0x95,0x9C), o2(0x8F,0x7A),
     o2(0x9C,0x73), o2(0x94,0xF7), o2(0x93,0xBF), o2(0x92,0xA5),
     o2(0xFA,0xBA), o2(0x93,0x4F), o2(0x9C,0x74), o2(0x8B,0x4A),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_BE = {
    to_SHIFT_JIS_E5_BE_offsets,
    to_SHIFT_JIS_E5_BE_infos
};

static const unsigned char
to_SHIFT_JIS_E5_BF_offsets[64] = {
  /* used from to_SHIFT_JIS_E5_BF */
  /* used from to_EUC_JP_E5_BF */
     21, 21, 21,  0, 21,  1, 21, 21,   21, 21, 21, 21,  2,  3, 21, 21,
     21, 21, 21, 21, 21, 21,  4,  5,    6,  7, 21, 21,  8,  9, 10, 21,
     11, 21, 21, 21, 12, 21, 21, 21,   21, 21, 21, 13, 21, 21, 21, 21,
     14, 15, 21, 21, 21, 16, 21, 21,   17, 21, 21, 18, 21, 19, 21, 20,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_BF_infos[22] = {
     o2(0x90,0x53), o2(0x95,0x4B), o2(0x8A,0xF5), o2(0x94,0x45),
     o2(0x9C,0x75), o2(0x8E,0x75), o2(0x96,0x59), o2(0x96,0x5A),
     o2(0x89,0x9E), o2(0x9C,0x7A), o2(0xFA,0xBB), o2(0x92,0x89),
     o2(0x9C,0x77), o2(0x89,0xF5), o2(0x9C,0xAB), o2(0x9C,0x79),
     o2(0x94,0x4F), o2(0x9C,0x78), o2(0x9C,0x76), o2(0x8D,0x9A),
     o2(0x9C,0x7C),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5_BF = {
    to_SHIFT_JIS_E5_BF_offsets,
    to_SHIFT_JIS_E5_BF_infos
};

static const unsigned char
to_SHIFT_JIS_E5_offsets[64] = {
  /* used from to_SHIFT_JIS_E5 */
  /* used from to_SHIFT_JIS_E6 */
  /* used from to_EUC_JP_E5 */
  /* used from to_EUC_JP_E6 */
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,   24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39,   40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55,   56, 57, 58, 59, 60, 61, 62, 63,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E5_infos[64] = {
     &to_SHIFT_JIS_E5_80, &to_SHIFT_JIS_E5_81,
     &to_SHIFT_JIS_E5_82, &to_SHIFT_JIS_E5_83,
     &to_SHIFT_JIS_E5_84, &to_SHIFT_JIS_E5_85,
     &to_SHIFT_JIS_E5_86, &to_SHIFT_JIS_E5_87,
     &to_SHIFT_JIS_E5_88, &to_SHIFT_JIS_E5_89,
     &to_SHIFT_JIS_E5_8A, &to_SHIFT_JIS_E5_8B,
     &to_SHIFT_JIS_E5_8C, &to_SHIFT_JIS_E5_8D,
     &to_SHIFT_JIS_E5_8E, &to_SHIFT_JIS_E5_8F,
     &to_SHIFT_JIS_E5_90, &to_SHIFT_JIS_E5_91,
     &to_SHIFT_JIS_E5_92, &to_SHIFT_JIS_E5_93,
     &to_SHIFT_JIS_E5_94, &to_SHIFT_JIS_E5_95,
     &to_SHIFT_JIS_E5_96, &to_SHIFT_JIS_E5_97,
     &to_SHIFT_JIS_E5_98, &to_SHIFT_JIS_E5_99,
     &to_SHIFT_JIS_E5_9A, &to_SHIFT_JIS_E5_9B,
     &to_SHIFT_JIS_E5_9C, &to_SHIFT_JIS_E5_9D,
     &to_SHIFT_JIS_E5_9E, &to_SHIFT_JIS_E5_9F,
     &to_SHIFT_JIS_E5_A0, &to_SHIFT_JIS_E5_A1,
     &to_SHIFT_JIS_E5_A2, &to_SHIFT_JIS_E5_A3,
     &to_SHIFT_JIS_E5_A4, &to_SHIFT_JIS_E5_A5,
     &to_SHIFT_JIS_E5_A6, &to_SHIFT_JIS_E5_A7,
     &to_SHIFT_JIS_E5_A8, &to_SHIFT_JIS_E5_A9,
     &to_SHIFT_JIS_E5_AA, &to_SHIFT_JIS_E5_AB,
     &to_SHIFT_JIS_E5_AC, &to_SHIFT_JIS_E5_AD,
     &to_SHIFT_JIS_E5_AE, &to_SHIFT_JIS_E5_AF,
     &to_SHIFT_JIS_E5_B0, &to_SHIFT_JIS_E5_B1,
     &to_SHIFT_JIS_E5_B2, &to_SHIFT_JIS_E5_B3,
     &to_SHIFT_JIS_E5_B4, &to_SHIFT_JIS_E5_B5,
     &to_SHIFT_JIS_E5_B6, &to_SHIFT_JIS_E5_B7,
     &to_SHIFT_JIS_E5_B8, &to_SHIFT_JIS_E5_B9,
     &to_SHIFT_JIS_E5_BA, &to_SHIFT_JIS_E5_BB,
     &to_SHIFT_JIS_E5_BC, &to_SHIFT_JIS_E5_BD,
     &to_SHIFT_JIS_E5_BE, &to_SHIFT_JIS_E5_BF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E5 = {
    to_SHIFT_JIS_E5_offsets,
    to_SHIFT_JIS_E5_infos
};

static const unsigned char
to_SHIFT_JIS_E6_80_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_80 */
  /* used from to_EUC_JP_E6_80 */
     22, 22, 22, 22, 22, 22, 22, 22,   22, 22, 22, 22, 22, 22,  0,  1,
      2, 22,  3, 22, 22,  4,  5, 22,   22,  6, 22,  7,  8,  9, 22, 22,
     10, 11, 22, 22, 22, 12, 13, 14,   15, 16, 17, 18, 22, 22, 22, 19,
     22, 20, 22, 22, 22, 22, 22, 22,   22, 22, 21, 22, 22, 22, 22, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_80_infos[23] = {
     o2(0x9C,0x83), o2(0x9C,0x89), o2(0x9C,0x81), o2(0x93,0x7B),
     o2(0x9C,0x86), o2(0x95,0x7C), o2(0x9C,0x80), o2(0x9C,0x85),
     o2(0x97,0xE5), o2(0x8E,0x76), o2(0x91,0xD3), o2(0x9C,0x7D),
     o2(0x8B,0x7D), o2(0x9C,0x88), o2(0x90,0xAB), o2(0x89,0x85),
     o2(0x9C,0x82), o2(0x89,0xF6), o2(0x9C,0x87), o2(0x8B,0xAF),
     o2(0x9C,0x84), o2(0x9C,0x8A),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_80 = {
    to_SHIFT_JIS_E6_80_offsets,
    to_SHIFT_JIS_E6_80_infos
};

static const unsigned char
to_SHIFT_JIS_E6_81_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_81 */
  /* used from to_EUC_JP_E6_81 */
     29,  0,  1,  2, 29, 29,  3, 29,   29, 29,  4,  5, 29,  6, 29, 29,
      7, 29,  8, 29, 29,  9, 29, 29,   29, 10, 11, 29, 29, 12, 29, 13,
     14, 29, 15, 16, 17, 18, 29, 29,   19, 20, 21, 22, 23, 24, 29, 25,
     26, 29, 29, 29, 29, 27, 29, 28,   29, 29, 29, 29, 29, 29, 29, 29,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_81_infos[30] = {
     o2(0x9C,0x8C), o2(0x9C,0x96), o2(0x9C,0x94), o2(0x9C,0x91),
     o2(0x9C,0x90), o2(0x97,0xF6), o2(0x9C,0x92), o2(0x8B,0xB0),
     o2(0x8D,0x50), o2(0x8F,0x9A), o2(0x9C,0x99), o2(0x9C,0x8B),
     o2(0xFA,0xBC), o2(0x9C,0x8F), o2(0x9C,0x7E), o2(0x89,0xF8),
     o2(0x9C,0x93), o2(0x9C,0x95), o2(0x92,0x70), o2(0x8D,0xA6),
     o2(0x89,0xB6), o2(0x9C,0x8D), o2(0x9C,0x98), o2(0x9C,0x97),
     o2(0x8B,0xB1), o2(0x91,0xA7), o2(0x8A,0x86), o2(0x8C,0x62),
     o2(0x9C,0x8E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_81 = {
    to_SHIFT_JIS_E6_81_offsets,
    to_SHIFT_JIS_E6_81_infos
};

static const unsigned char
to_SHIFT_JIS_E6_82_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_82 */
  /* used from to_EUC_JP_E6_82 */
     30,  0, 30,  1,  2,  3, 30, 30,   30,  4,  5,  6,  7,  8, 30, 30,
     30, 30,  9, 30, 10, 30, 11, 12,   30, 30, 13, 14, 30, 30, 30, 15,
     16, 30, 30, 17, 30, 30, 18, 19,   30, 20, 21, 30, 30, 30, 30, 30,
     30, 30, 22, 23, 24, 25, 26, 30,   27, 30, 30, 30, 28, 29, 30, 30,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_82_infos[31] = {
     o2(0x9C,0x9A), o2(0x9C,0x9D), o2(0x9C,0x9F), o2(0xFA,0xBD),
     o2(0x8E,0xBB), o2(0xFA,0xBE), o2(0x9C,0xA5), o2(0x92,0xEE),
     o2(0x9C,0x9B), o2(0x9C,0xA3), o2(0x89,0xF7), o2(0x9C,0xA1),
     o2(0x9C,0xA2), o2(0x9C,0x9E), o2(0x9C,0xA0), o2(0x8C,0xE5),
     o2(0x97,0x49), o2(0x8A,0xB3), o2(0x89,0x78), o2(0x9C,0xA4),
     o2(0x94,0x59), o2(0x88,0xAB), o2(0x94,0xDF), o2(0x9C,0x7B),
     o2(0x9C,0xAA), o2(0x9C,0xAE), o2(0x96,0xE3), o2(0x9C,0xA7),
     o2(0x93,0x89), o2(0x9C,0xAC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_82 = {
    to_SHIFT_JIS_E6_82_offsets,
    to_SHIFT_JIS_E6_82_infos
};

static const unsigned char
to_SHIFT_JIS_E6_83_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_83 */
  /* used from to_EUC_JP_E6_83 */
     26, 26, 26, 26, 26,  0,  1,  2,   26, 26, 26, 26, 26, 26, 26, 26,
     26,  3, 26,  4, 26,  5, 26, 26,    6, 26,  7, 26,  8, 26,  9, 10,
     11, 12, 26, 13, 26, 26, 26, 14,   15, 26, 26, 26, 26, 26, 26, 26,
     16, 17, 18, 19, 20, 26, 21, 22,   26, 23, 24, 25, 26, 26, 26, 26,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_83_infos[27] = {
     o2(0x8F,0xEE), o2(0x9C,0xAD), o2(0x93,0xD5), o2(0x98,0x66),
     o2(0x9C,0xA9), o2(0xFA,0xC0), o2(0x9C,0xAF), o2(0x8D,0x9B),
     o2(0x90,0xC9), o2(0xFA,0xBF), o2(0x88,0xD2), o2(0x9C,0xA8),
     o2(0x9C,0xA6), o2(0x91,0x79), o2(0x9C,0x9C), o2(0x8E,0x53),
     o2(0x91,0xC4), o2(0x9C,0xBB), o2(0xFA,0xC2), o2(0x91,0x7A),
     o2(0x9C,0xB6), o2(0x9C,0xB3), o2(0x9C,0xB4), o2(0x8E,0xE4),
     o2(0x9C,0xB7), o2(0x9C,0xBA),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_83 = {
    to_SHIFT_JIS_E6_83_offsets,
    to_SHIFT_JIS_E6_83_infos
};

static const unsigned char
to_SHIFT_JIS_E6_84_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_84 */
  /* used from to_EUC_JP_E6_84 */
      0,  1, 26,  2, 26, 26,  3, 26,    4,  5, 26, 26, 26,  6,  7,  8,
     26,  9, 26, 26, 26, 10, 26, 26,   26, 26, 11, 12, 26, 26, 26, 13,
     14, 15, 26, 26, 26, 26, 26, 16,   17, 26, 26, 26, 18, 26, 26, 26,
     19, 26, 26, 26, 20, 26, 26, 21,   26, 26, 26, 26, 22, 23, 24, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_84_infos[27] = {
     o2(0x9C,0xB5), o2(0x8F,0x44), o2(0x9C,0xB8), o2(0x9C,0xB2),
     o2(0x96,0xFA), o2(0x96,0xF9), o2(0x9C,0xBC), o2(0x9C,0xBD),
     o2(0x88,0xD3), o2(0xFA,0xC3), o2(0x9C,0xB1), o2(0x8B,0xF0),
     o2(0x88,0xA4), o2(0x8A,0xB4), o2(0xFA,0xC1), o2(0x9C,0xB9),
     o2(0x9C,0xC1), o2(0x9C,0xC0), o2(0x9C,0xC5), o2(0xFA,0xC5),
     o2(0x9C,0xC6), o2(0xFA,0xC4), o2(0x9C,0xC4), o2(0x9C,0xC7),
     o2(0x9C,0xBF), o2(0x9C,0xC3),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_84 = {
    to_SHIFT_JIS_E6_84_offsets,
    to_SHIFT_JIS_E6_84_infos
};

static const unsigned char
to_SHIFT_JIS_E6_85_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_85 */
  /* used from to_EUC_JP_E6_85 */
     32, 32,  0, 32,  1, 32, 32,  2,    3, 32,  4,  5,  6,  7,  8, 32,
     32, 32, 32,  9, 32, 10, 32, 32,   11, 12, 13, 32, 32, 14, 32, 15,
     32, 32, 16, 17, 32, 18, 32, 19,   20, 32, 32, 21, 32, 32, 22, 23,
     24, 25, 32, 26, 27, 28, 29, 30,   32, 32, 32, 32, 32, 32, 31, 32,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_85_infos[33] = {
     o2(0x9C,0xC8), o2(0x9C,0xC9), o2(0x9C,0xBE), o2(0x8E,0x9C),
     o2(0x9C,0xC2), o2(0x91,0xD4), o2(0x8D,0x51), o2(0x9C,0xB0),
     o2(0x90,0x54), o2(0x9C,0xD6), o2(0x95,0xE7), o2(0x9C,0xCC),
     o2(0x9C,0xCD), o2(0x9C,0xCE), o2(0x9C,0xD5), o2(0x9C,0xD4),
     o2(0x96,0x9D), o2(0x8A,0xB5), o2(0x9C,0xD2), o2(0x8C,0x64),
     o2(0x8A,0x53), o2(0x9C,0xCF), o2(0x97,0xB6), o2(0x9C,0xD1),
     o2(0x88,0xD4), o2(0x9C,0xD3), o2(0x9C,0xCA), o2(0x9C,0xD0),
     o2(0x9C,0xD7), o2(0x8C,0x63), o2(0x9C,0xCB), o2(0x97,0x7C),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_85 = {
    to_SHIFT_JIS_E6_85_offsets,
    to_SHIFT_JIS_E6_85_infos
};

static const unsigned char
to_SHIFT_JIS_E6_86_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_86 */
  /* used from to_EUC_JP_E6_86 */
     21, 21,  0, 21, 21, 21, 21,  1,   21, 21,  2, 21, 21, 21,  3, 21,
      4,  5, 21, 21,  6, 21,  7, 21,    8,  9, 10, 21, 21, 21, 21, 21,
     21, 21, 21, 21, 11, 21, 21, 12,   21, 13, 21, 14, 15, 21, 16, 21,
     21, 21, 17, 21, 21, 21, 18, 21,   21, 21, 19, 21, 21, 21, 20, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_86_infos[22] = {
     o2(0x97,0x4A), o2(0x9C,0xDA), o2(0x9C,0xDE), o2(0x91,0x9E),
     o2(0x97,0xF7), o2(0x9C,0xDF), o2(0x9C,0xDC), o2(0x9C,0xD9),
     o2(0xFA,0xC6), o2(0x9C,0xD8), o2(0x9C,0xDD), o2(0x95,0xAE),
     o2(0x93,0xB2), o2(0x8C,0x65), o2(0x9C,0xE0), o2(0x9C,0xDB),
     o2(0x9C,0xE1), o2(0x8C,0x9B), o2(0x89,0xAF), o2(0x9C,0xE9),
     o2(0x8A,0xB6),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_86 = {
    to_SHIFT_JIS_E6_86_offsets,
    to_SHIFT_JIS_E6_86_infos
};

static const unsigned char
to_SHIFT_JIS_E6_87_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_87 */
  /* used from to_EUC_JP_E6_87 */
     22, 22, 22,  0, 22, 22,  1,  2,    3,  4,  5,  6,  7,  8, 22, 22,
      9, 22, 22, 22, 22, 22, 22, 22,   22, 22, 22, 22, 22, 22, 22, 22,
     22, 22, 22, 10, 22, 22, 11, 22,   22, 22, 22, 22, 22, 22, 22, 22,
     22, 22, 12, 22, 13, 22, 14, 15,   16, 22, 17, 22, 18, 19, 20, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_87_infos[23] = {
     o2(0x9C,0xE7), o2(0x9C,0xE8), o2(0x8D,0xA7), o2(0x9C,0xE6),
     o2(0x9C,0xE4), o2(0x9C,0xE3), o2(0x9C,0xEA), o2(0x9C,0xE2),
     o2(0x9C,0xEC), o2(0x89,0xF9), o2(0x9C,0xEE), o2(0x9C,0xED),
     o2(0x92,0xA6), o2(0x9C,0xF1), o2(0x9C,0xEF), o2(0x9C,0xE5),
     o2(0x8C,0x9C), o2(0x9C,0xF0), o2(0x9C,0xF4), o2(0x9C,0xF3),
     o2(0x9C,0xF5), o2(0x9C,0xF2),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_87 = {
    to_SHIFT_JIS_E6_87_offsets,
    to_SHIFT_JIS_E6_87_infos
};

static const unsigned char
to_SHIFT_JIS_E6_88_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_88 */
  /* used from to_EUC_JP_E6_88 */
      0, 30, 30, 30, 30, 30, 30, 30,    1,  2,  3, 30,  4,  5,  6, 30,
      7,  8,  9, 10, 11, 30, 12, 30,   30, 30, 13, 14, 30, 15, 16, 17,
     30, 18, 30, 30, 30, 30, 19, 30,   30, 30, 20, 30, 30, 30, 21, 22,
     23, 30, 24, 25, 26, 30, 30, 30,   27, 30, 30, 28, 30, 30, 30, 29,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_88_infos[31] = {
     o2(0x9C,0xF6), o2(0x9C,0xF7), o2(0x9C,0xF8), o2(0x95,0xE8),
     o2(0x9C,0xFA), o2(0x9C,0xF9), o2(0x8F,0x5E), o2(0x90,0xAC),
     o2(0x89,0xE4), o2(0x89,0xFA), o2(0xFA,0xC7), o2(0x9C,0xFB),
     o2(0x88,0xBD), o2(0x90,0xCA), o2(0x9C,0xFC), o2(0xE6,0xC1),
     o2(0x9D,0x40), o2(0x8C,0x81), o2(0x9D,0x41), o2(0x90,0xED),
     o2(0x9D,0x42), o2(0x9D,0x43), o2(0x8B,0x59), o2(0x9D,0x44),
     o2(0x9D,0x45), o2(0x9D,0x46), o2(0x91,0xD5), o2(0x8C,0xCB),
     o2(0x96,0xDF), o2(0x96,0x5B),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_88 = {
    to_SHIFT_JIS_E6_88_offsets,
    to_SHIFT_JIS_E6_88_infos
};

static const unsigned char
to_SHIFT_JIS_E6_89_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_89 */
  /* used from to_EUC_JP_E6_89 */
      0,  1, 23, 23, 23, 23, 23,  2,    3,  4, 23,  5, 23,  6,  7, 23,
     23, 23, 23,  8, 23,  9, 23, 23,   10, 23, 23, 11, 23, 23, 12, 23,
     13, 23, 23, 14, 23, 23, 23, 23,   15, 23, 23, 23, 23, 23, 16, 23,
     23, 17, 23, 23, 23, 23, 18, 23,   23, 19, 23, 23, 20, 23, 21, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_89_infos[24] = {
     o2(0x8F,0x8A), o2(0x9D,0x47), o2(0x90,0xEE), o2(0xE7,0xBB),
     o2(0x94,0xE0), o2(0x8E,0xE8), o2(0x8D,0xCB), o2(0x9D,0x48),
     o2(0x91,0xC5), o2(0x95,0xA5), o2(0x91,0xEF), o2(0x9D,0x4B),
     o2(0x9D,0x49), o2(0x9D,0x4C), o2(0x9D,0x4A), o2(0x9D,0x4D),
     o2(0x95,0xAF), o2(0x88,0xB5), o2(0x95,0x7D), o2(0x94,0xE1),
     o2(0x9D,0x4E), o2(0x9D,0x51), o2(0x8F,0xB3),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_89 = {
    to_SHIFT_JIS_E6_89_offsets,
    to_SHIFT_JIS_E6_89_infos
};

static const unsigned char
to_SHIFT_JIS_E6_8A_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_8A */
  /* used from to_EUC_JP_E6_8A */
      0, 26,  1,  2,  3, 26, 26, 26,   26,  4,  5, 26, 26, 26, 26, 26,
     26,  6,  7,  8,  9, 10, 11, 12,   13, 26, 26, 14, 15, 26, 16, 26,
     26, 26, 26, 26, 26, 26, 17, 26,   26, 26, 26, 18, 19, 26, 26, 26,
     26, 20, 26, 26, 26, 21, 26, 26,   26, 22, 26, 23, 24, 25, 26, 26,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_8A_infos[27] = {
     o2(0x8B,0x5A), o2(0x9D,0x4F), o2(0x9D,0x56), o2(0x8F,0xB4),
     o2(0x9D,0x50), o2(0x94,0x63), o2(0x97,0x7D), o2(0x9D,0x52),
     o2(0x9D,0x53), o2(0x9D,0x57), o2(0x93,0x8A), o2(0x9D,0x54),
     o2(0x8D,0x52), o2(0x90,0xDC), o2(0x9D,0x65), o2(0x94,0xB2),
     o2(0x91,0xF0), o2(0xFA,0xC8), o2(0x94,0xE2), o2(0x9D,0xAB),
     o2(0x95,0xF8), o2(0x92,0xEF), o2(0x96,0x95), o2(0x9D,0x5A),
     o2(0x89,0x9F), o2(0x92,0x8A),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_8A = {
    to_SHIFT_JIS_E6_8A_offsets,
    to_SHIFT_JIS_E6_8A_infos
};

static const unsigned char
to_SHIFT_JIS_E6_8B_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_8B */
  /* used from to_EUC_JP_E6_8B */
     34, 34,  0, 34, 34,  1,  2,  3,    4,  5,  6, 34,  7,  8, 34,  9,
     10, 11, 12, 13, 14, 34, 34, 15,   16, 17, 34, 18, 19, 20, 34, 34,
     21, 22, 34, 34, 34, 34, 34, 34,   34, 34, 34, 34, 23, 24, 25, 26,
     34, 27, 34, 28, 34, 29, 30, 31,   34, 34, 34, 34, 34, 34, 32, 33,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_8B_infos[35] = {
     o2(0x9D,0x63), o2(0x92,0x53), o2(0x9D,0x5D), o2(0x9D,0x64),
     o2(0x9D,0x5F), o2(0x9D,0x66), o2(0x9D,0x62), o2(0x9D,0x61),
     o2(0x94,0x8F), o2(0x9D,0x5B), o2(0x89,0xFB), o2(0x9D,0x59),
     o2(0x8B,0x91), o2(0x91,0xF1), o2(0x9D,0x55), o2(0x9D,0x58),
     o2(0x8D,0x53), o2(0x90,0xD9), o2(0x8F,0xB5), o2(0x9D,0x60),
     o2(0x94,0x71), o2(0x8B,0x92), o2(0x8A,0x67), o2(0x8A,0x87),
     o2(0x90,0x40), o2(0x9D,0x68), o2(0x9D,0x6D), o2(0x9D,0x69),
     o2(0x8C,0x9D), o2(0x9D,0x6E), o2(0x8E,0x41), o2(0x8D,0x89),
     o2(0x8F,0x45), o2(0x9D,0x5C),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_8B = {
    to_SHIFT_JIS_E6_8B_offsets,
    to_SHIFT_JIS_E6_8B_infos
};

static const unsigned char
to_SHIFT_JIS_E6_8C_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_8C */
  /* used from to_EUC_JP_E6_8C */
     17,  0,  1, 17, 17, 17, 17,  2,    3,  4, 17, 17,  5, 17, 17, 17,
     17,  6, 17, 17, 17, 17, 17, 17,   17,  7, 17, 17, 17, 17, 17,  8,
     17, 17, 17, 17, 17, 17, 17,  9,   10, 17, 17, 11, 17, 17, 17, 12,
     17, 17, 17, 17, 17, 17, 17, 17,   17, 17, 13, 17, 17, 14, 15, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_8C_infos[18] = {
     o2(0x8E,0x9D), o2(0x9D,0x6B), o2(0x8E,0x77), o2(0x9D,0x6C),
     o2(0x88,0xC2), o2(0x9D,0x67), o2(0x92,0xA7), o2(0x8B,0x93),
     o2(0x8B,0xB2), o2(0x9D,0x6A), o2(0x88,0xA5), o2(0x8D,0xC1),
     o2(0x90,0x55), o2(0x92,0xF0), o2(0x94,0xD2), o2(0x9D,0x70),
     o2(0x91,0x7D),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_8C = {
    to_SHIFT_JIS_E6_8C_offsets,
    to_SHIFT_JIS_E6_8C_infos
};

static const unsigned char
to_SHIFT_JIS_E6_8D_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_8D */
  /* used from to_EUC_JP_E6_8D */
     18, 18, 18, 18, 18, 18, 18, 18,   18,  0, 18, 18,  1,  2, 18,  3,
      4, 18, 18, 18, 18,  5, 18,  6,   18, 18, 18, 18,  7, 18, 18, 18,
     18, 18, 18, 18, 18, 18, 18,  8,    9, 10, 18, 11, 18, 18, 12, 18,
     18, 18, 13, 18, 18, 18, 14, 15,   18, 18, 16, 17, 18, 18, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_8D_infos[19] = {
     o2(0x91,0xA8), o2(0x8E,0x4A), o2(0x9D,0x71), o2(0x9D,0x73),
     o2(0x9D,0x6F), o2(0x95,0xDF), o2(0x92,0xBB), o2(0x91,0x7B),
     o2(0x95,0xF9), o2(0x8E,0xCC), o2(0x9D,0x80), o2(0x9D,0x7E),
     o2(0x90,0x98), o2(0x8C,0x9E), o2(0x9D,0x78), o2(0x8F,0xB7),
     o2(0x93,0xE6), o2(0x94,0x50),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_8D = {
    to_SHIFT_JIS_E6_8D_offsets,
    to_SHIFT_JIS_E6_8D_infos
};

static const unsigned char
to_SHIFT_JIS_E6_8E_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_8E */
  /* used from to_EUC_JP_E6_8E */
      0, 28, 28,  1, 28, 28, 28, 28,    2,  3, 28, 28,  4, 28,  5,  6,
     28, 28,  7, 28, 28, 28,  8, 28,    9, 28, 28, 10, 28, 28, 28, 11,
     12, 13, 14, 15, 28, 16, 28, 17,   18, 19, 20, 21, 22, 28, 28, 28,
     28, 28, 23, 28, 24, 25, 28, 28,   28, 28, 28, 26, 28, 28, 27, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_8E_infos[29] = {
     o2(0x9D,0x76), o2(0x91,0x7C), o2(0x8E,0xF6), o2(0x9D,0x7B),
     o2(0x8F,0xB6), o2(0x9D,0x75), o2(0x9D,0x7A), o2(0x94,0x72),
     o2(0x9D,0x74), o2(0x8C,0x40), o2(0x8A,0x7C), o2(0x9D,0x7C),
     o2(0x97,0xA9), o2(0x8D,0xCC), o2(0x92,0x54), o2(0x9D,0x79),
     o2(0x90,0xDA), o2(0x8D,0x54), o2(0x90,0x84), o2(0x89,0x86),
     o2(0x91,0x5B), o2(0x9D,0x77), o2(0x8B,0x64), o2(0x8C,0x66),
     o2(0x92,0xCD), o2(0x9D,0x7D), o2(0x91,0x7E), o2(0x9D,0x81),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_8E = {
    to_SHIFT_JIS_E6_8E_offsets,
    to_SHIFT_JIS_E6_8E_infos
};

static const unsigned char
to_SHIFT_JIS_E6_8F_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_8F */
  /* used from to_EUC_JP_E6_8F */
      0, 19, 19,  1,  2, 19,  3, 19,   19,  4, 19, 19, 19, 19, 19,  5,
      6, 19,  7, 19, 19, 19,  8, 19,   19, 19,  9, 10, 19, 19, 19, 19,
     19, 11, 19, 12, 19, 19, 19, 19,   19, 13, 19, 19, 19, 19, 14, 19,
     19, 19, 19, 19, 15, 16, 17, 19,   19, 19, 18, 19, 19, 19, 19, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_8F_infos[20] = {
     o2(0x9D,0x83), o2(0x91,0xB5), o2(0x9D,0x89), o2(0x9D,0x84),
     o2(0x9D,0x86), o2(0x95,0x60), o2(0x92,0xF1), o2(0x9D,0x87),
     o2(0x97,0x4B), o2(0x97,0x67), o2(0x8A,0xB7), o2(0x88,0xAC),
     o2(0x9D,0x85), o2(0x9D,0x82), o2(0x8A,0xF6), o2(0x89,0x87),
     o2(0xFA,0xC9), o2(0x9D,0x88), o2(0x97,0x68),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_8F = {
    to_SHIFT_JIS_E6_8F_offsets,
    to_SHIFT_JIS_E6_8F_infos
};

static const unsigned char
to_SHIFT_JIS_E6_90_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_90 */
  /* used from to_EUC_JP_E6_90 */
     15, 15, 15, 15, 15, 15,  0, 15,   15, 15, 15, 15, 15,  1, 15,  2,
     15, 15, 15,  3, 15, 15,  4,  5,   15, 15, 15, 15,  6, 15, 15, 15,
     15, 15, 15, 15, 15, 15,  7, 15,    8, 15, 15, 15,  9, 10, 15, 15,
     15, 15, 15, 15, 11, 15, 12, 15,   15, 15, 13, 15, 15, 15, 14, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_90_infos[16] = {
     o2(0x9D,0x8C), o2(0x91,0xB9), o2(0x9D,0x93), o2(0x9D,0x8D),
     o2(0x9D,0x8A), o2(0x9D,0x91), o2(0x9D,0x72), o2(0x9D,0x8E),
     o2(0x9D,0x92), o2(0x94,0xC0), o2(0x93,0x8B), o2(0x9D,0x8B),
     o2(0x9D,0x8F), o2(0x8C,0x67), o2(0x8D,0xEF),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_90 = {
    to_SHIFT_JIS_E6_90_offsets,
    to_SHIFT_JIS_E6_90_infos
};

static const unsigned char
to_SHIFT_JIS_E6_91_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_91 */
  /* used from to_EUC_JP_E6_91 */
     10, 10,  0, 10, 10, 10, 10, 10,   10, 10, 10, 10, 10, 10,  1, 10,
     10, 10, 10, 10, 10, 10, 10, 10,    2, 10, 10, 10, 10, 10, 10, 10,
      3, 10, 10, 10, 10, 10, 10,  4,   10,  5, 10, 10, 10, 10, 10,  6,
     10, 10, 10, 10, 10, 10,  7, 10,    8, 10,  9, 10, 10, 10, 10, 10,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_91_infos[11] = {
     o2(0x90,0xDB), o2(0x9D,0x97), o2(0x93,0x45), o2(0xFA,0xCA),
     o2(0x9D,0x94), o2(0x96,0x80), o2(0x9D,0x95), o2(0x9D,0x96),
     o2(0x96,0xCC), o2(0x90,0xA0),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_91 = {
    to_SHIFT_JIS_E6_91_offsets,
    to_SHIFT_JIS_E6_91_infos
};

static const unsigned char
to_SHIFT_JIS_E6_92_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_92 */
  /* used from to_EUC_JP_E6_92 */
     19, 19, 19,  0, 19, 19, 19, 19,    1, 19, 19, 19, 19, 19, 19, 19,
     19, 19,  2,  3, 19,  4, 19, 19,   19, 19,  5, 19, 19,  6,  7, 19,
     19, 19, 19, 19,  8,  9, 19, 19,   19, 10, 19, 11, 19, 12, 13, 19,
     14, 19, 15, 19, 19, 19, 19, 19,   19, 16, 19, 17, 18, 19, 19, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_92_infos[20] = {
     o2(0x8C,0x82), o2(0x9D,0x9D), o2(0x8E,0x54), o2(0x9D,0x9A),
     o2(0x9D,0x99), o2(0x94,0x51), o2(0xFA,0xCB), o2(0x93,0xB3),
     o2(0x93,0x50), o2(0x9D,0x9B), o2(0x9D,0x9C), o2(0x95,0x8F),
     o2(0x94,0x64), o2(0x8E,0x42), o2(0x90,0xEF), o2(0x96,0x6F),
     o2(0x8A,0x68), o2(0x9D,0xA3), o2(0x9D,0x9E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_92 = {
    to_SHIFT_JIS_E6_92_offsets,
    to_SHIFT_JIS_E6_92_infos
};

static const unsigned char
to_SHIFT_JIS_E6_93_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_93 */
  /* used from to_EUC_JP_E6_93 */
     25,  0,  1, 25, 25,  2, 25,  3,   25, 25, 25, 25, 25,  4,  5, 25,
     25, 25,  6, 25,  7, 25, 25, 25,    8, 25,  9, 25, 25, 25, 25, 25,
     10, 11, 12, 13, 25, 25, 14, 15,   25, 25, 25, 25, 16, 25, 25, 17,
     25, 18, 19, 25, 20, 25, 21, 25,   25, 25, 22, 25, 25, 23, 24, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_93_infos[26] = {
     o2(0x97,0x69), o2(0x9D,0xA5), o2(0x9D,0xA1), o2(0x9D,0xA2),
     o2(0x91,0x80), o2(0xFA,0xCC), o2(0x9D,0xA0), o2(0x9D,0x5E),
     o2(0x9D,0xA4), o2(0x9D,0x9F), o2(0x9D,0xA9), o2(0x9D,0xAA),
     o2(0x93,0x46), o2(0x9D,0xAC), o2(0x8E,0x43), o2(0x9D,0xA7),
     o2(0x8B,0x5B), o2(0x9D,0xAD), o2(0x9D,0xA6), o2(0x9D,0xB1),
     o2(0x9D,0xB0), o2(0x9D,0xAF), o2(0x9D,0xB2), o2(0x9D,0xB4),
     o2(0x8F,0xEF),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_93 = {
    to_SHIFT_JIS_E6_93_offsets,
    to_SHIFT_JIS_E6_93_infos
};

static const unsigned char
to_SHIFT_JIS_E6_94_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_94 */
  /* used from to_EUC_JP_E6_94 */
      0, 20, 20, 20, 20,  1, 20, 20,   20, 20, 20, 20, 20, 20, 20, 20,
     20, 20, 20, 20, 20, 20, 20, 20,    2, 20, 20, 20,  3,  4, 20, 20,
     20, 20, 20,  5,  6, 20, 20, 20,   20, 20,  7,  8,  9, 20, 20, 10,
     20, 20, 20, 20, 11, 12, 13, 14,   15, 16, 20, 17, 20, 20, 18, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_94_infos[21] = {
     o2(0x9D,0xB3), o2(0x9D,0xB7), o2(0x9D,0xB5), o2(0x9D,0xB6),
     o2(0x9D,0x90), o2(0x9D,0xB9), o2(0x9D,0xB8), o2(0x9D,0x98),
     o2(0x9D,0xBA), o2(0x9D,0xAE), o2(0x8E,0x78), o2(0x9D,0xBB),
     o2(0x9D,0xBC), o2(0x9D,0xBE), o2(0x9D,0xBD), o2(0x9D,0xBF),
     o2(0x89,0xFC), o2(0x8D,0x55), o2(0x95,0xFA), o2(0x90,0xAD),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_94 = {
    to_SHIFT_JIS_E6_94_offsets,
    to_SHIFT_JIS_E6_94_infos
};

static const unsigned char
to_SHIFT_JIS_E6_95_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_95 */
  /* used from to_EUC_JP_E6_95 */
     23, 23, 23, 23, 23,  0, 23, 23,    1, 23, 23, 23, 23,  2,  3,  4,
     23,  5, 23, 23, 23,  6,  7,  8,    9, 10, 23, 23, 23, 11, 12, 23,
     23, 23, 13, 14, 23, 23, 15, 23,   23, 23, 23, 23, 16, 23, 23, 23,
     17, 23, 18, 23, 19, 20, 23, 21,   22, 23, 23, 23, 23, 23, 23, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_95_infos[24] = {
     o2(0x8C,0xCC), o2(0x9D,0xC1), o2(0x9D,0xC4), o2(0xFA,0xCD),
     o2(0x95,0x71), o2(0x8B,0x7E), o2(0x9D,0xC3), o2(0x9D,0xC2),
     o2(0x94,0x73), o2(0x9D,0xC5), o2(0x8B,0xB3), o2(0x9D,0xC7),
     o2(0x9D,0xC6), o2(0x8A,0xB8), o2(0x8E,0x55), o2(0x93,0xD6),
     o2(0x8C,0x68), o2(0x90,0x94), o2(0x9D,0xC8), o2(0x90,0xAE),
     o2(0x93,0x47), o2(0x95,0x7E), o2(0x9D,0xC9),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_95 = {
    to_SHIFT_JIS_E6_95_offsets,
    to_SHIFT_JIS_E6_95_infos
};

static const unsigned char
to_SHIFT_JIS_E6_96_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_96 */
  /* used from to_EUC_JP_E6_96 */
     27, 27,  0,  1, 27, 27, 27,  2,    3,  4, 27, 27,  5, 27,  6, 27,
      7,  8, 27, 27, 27, 27, 27,  9,   27, 10, 27, 11, 12, 27, 27, 13,
     27, 14, 27, 27, 15, 16, 27, 17,   27, 27, 27, 18, 19, 20, 27, 21,
     22, 27, 27, 27, 27, 27, 27, 23,   27, 24, 27, 27, 25, 26, 27, 27,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_96_infos[28] = {
     o2(0x9D,0xCA), o2(0x9D,0xCB), o2(0x95,0xB6), o2(0x9B,0x7C),
     o2(0x90,0xC4), o2(0x95,0x6B), o2(0x8D,0xD6), o2(0x94,0xE3),
     o2(0x94,0xC1), o2(0x93,0x6C), o2(0x97,0xBF), o2(0x9D,0xCD),
     o2(0x8E,0xCE), o2(0x9D,0xCE), o2(0x88,0xB4), o2(0x8B,0xD2),
     o2(0x90,0xCB), o2(0x95,0x80), o2(0x9D,0xCF), o2(0x8E,0x61),
     o2(0x92,0x66), o2(0x8E,0x7A), o2(0x90,0x56), o2(0x9D,0xD0),
     o2(0x95,0xFB), o2(0x89,0x97), o2(0x8E,0x7B),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_96 = {
    to_SHIFT_JIS_E6_96_offsets,
    to_SHIFT_JIS_E6_96_infos
};

static const unsigned char
to_SHIFT_JIS_E6_97_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_97 */
  /* used from to_EUC_JP_E6_97 */
     25,  0, 25,  1,  2,  3,  4, 25,   25, 25, 25,  5,  6, 25, 25,  7,
     25, 25,  8, 25, 25, 25, 25,  9,   25, 10, 25, 11, 25, 25, 25, 25,
     12, 13, 14, 25, 25, 15, 16, 17,   18, 19, 25, 25, 20, 21, 25, 25,
     25, 22, 25, 25, 25, 25, 25, 25,   25, 25, 23, 24, 25, 25, 25, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_97_infos[26] = {
     o2(0x9D,0xD3), o2(0x9D,0xD1), o2(0x9D,0xD4), o2(0x97,0xB7),
     o2(0x9D,0xD2), o2(0x90,0xF9), o2(0x9D,0xD5), o2(0x91,0xB0),
     o2(0x9D,0xD6), o2(0x8A,0xF8), o2(0x9D,0xD8), o2(0x9D,0xD7),
     o2(0x9D,0xD9), o2(0x9D,0xDA), o2(0x8A,0xF9), o2(0x93,0xFA),
     o2(0x92,0x55), o2(0x8B,0x8C), o2(0x8E,0x7C), o2(0x91,0x81),
     o2(0x8F,0x7B), o2(0x88,0xAE), o2(0x9D,0xDB), o2(0x89,0xA0),
     o2(0x9D,0xDF),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_97 = {
    to_SHIFT_JIS_E6_97_offsets,
    to_SHIFT_JIS_E6_97_infos
};

static const unsigned char
to_SHIFT_JIS_E6_98_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_98 */
  /* used from to_EUC_JP_E6_98 */
      0, 31,  1,  2, 31, 31,  3,  4,   31,  5,  6, 31,  7, 31,  8,  9,
     31, 31, 31, 10, 11, 12, 31, 31,   31, 31, 31, 31, 13, 31, 14, 15,
     16, 31, 31, 31, 17, 18, 31, 19,   20, 31, 31, 31, 31, 21, 22, 23,
     31, 24, 31, 31, 25, 26, 27, 31,   31, 31, 31, 28, 29, 31, 31, 30,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_98_infos[32] = {
     o2(0xFA,0xCE), o2(0x8D,0x56), o2(0x9D,0xDE), o2(0x8D,0xA9),
     o2(0x8F,0xB8), o2(0xFA,0xD1), o2(0x9D,0xDD), o2(0x8F,0xB9),
     o2(0x96,0xBE), o2(0x8D,0xA8), o2(0x88,0xD5), o2(0x90,0xCC),
     o2(0xFA,0xCF), o2(0x9D,0xE4), o2(0xFA,0xD3), o2(0x90,0xAF),
     o2(0x89,0x66), o2(0xFA,0xD4), o2(0x8F,0x74), o2(0x96,0x86),
     o2(0x8D,0xF0), o2(0x8F,0xBA), o2(0xFA,0xD2), o2(0x90,0xA5),
     o2(0xFA,0x63), o2(0x9D,0xE3), o2(0x9D,0xE1), o2(0x9D,0xE2),
     o2(0xFA,0xD0), o2(0x92,0x8B), o2(0x9E,0x45),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_98 = {
    to_SHIFT_JIS_E6_98_offsets,
    to_SHIFT_JIS_E6_98_infos
};

static const unsigned char
to_SHIFT_JIS_E6_99_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_99 */
  /* used from to_EUC_JP_E6_99 */
     27,  0,  1,  2,  3, 27, 27, 27,   27,  4, 27,  5, 27, 27, 27,  6,
     27, 27,  7, 27, 27, 27, 27,  8,   27,  9, 27, 27, 27, 10, 11, 12,
     27, 27, 13, 27, 14, 15, 16, 17,   18, 19, 27, 27, 27, 27, 20, 21,
     22, 27, 27, 23, 24, 27, 25, 27,   27, 27, 26, 27, 27, 27, 27, 27,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_99_infos[28] = {
     o2(0x9D,0xE8), o2(0x8E,0x9E), o2(0x8D,0x57), o2(0x9D,0xE6),
     o2(0x9D,0xE7), o2(0x90,0x57), o2(0x9D,0xE5), o2(0x8E,0x4E),
     o2(0xFA,0xD6), o2(0xFA,0xD7), o2(0x9D,0xEA), o2(0x9D,0xE9),
     o2(0x9D,0xEE), o2(0x9D,0xEF), o2(0x9D,0xEB), o2(0xFA,0xD5),
     o2(0x8A,0x41), o2(0x9D,0xEC), o2(0x9D,0xED), o2(0x94,0xD3),
     o2(0x95,0x81), o2(0x8C,0x69), o2(0x9D,0xF0), o2(0xFA,0xD9),
     o2(0x90,0xB0), o2(0x8F,0xBB), o2(0x92,0x71),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_99 = {
    to_SHIFT_JIS_E6_99_offsets,
    to_SHIFT_JIS_E6_99_infos
};

static const unsigned char
to_SHIFT_JIS_E6_9A_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_9A */
  /* used from to_EUC_JP_E6_9A */
     25,  0, 25,  1,  2, 25, 25,  3,    4,  5, 25, 25, 25, 25,  6, 25,
     25,  7, 25, 25, 25, 25,  8,  9,   10, 11, 25, 25, 25, 12, 25, 25,
     13, 25, 14, 25, 25, 25, 15, 25,   25, 25, 25, 16, 25, 25, 17, 25,
     25, 25, 18, 25, 19, 25, 25, 25,   20, 21, 25, 25, 22, 25, 23, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_9A_infos[26] = {
     o2(0x8B,0xC5), o2(0x9D,0xF1), o2(0x9D,0xF5), o2(0x89,0xC9),
     o2(0x9D,0xF2), o2(0x9D,0xF4), o2(0x9D,0xF3), o2(0x8F,0x8B),
     o2(0x92,0x67), o2(0x88,0xC3), o2(0x9D,0xF6), o2(0xFA,0xDA),
     o2(0x9D,0xF7), o2(0xFA,0xDB), o2(0x92,0xA8), o2(0x97,0xEF),
     o2(0x8E,0x62), o2(0x95,0xE9), o2(0xFA,0xDC), o2(0x96,0x5C),
     o2(0x9E,0x41), o2(0x9D,0xF9), o2(0x9D,0xFC), o2(0x9D,0xFB),
     o2(0xFA,0xDD),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_9A = {
    to_SHIFT_JIS_E6_9A_offsets,
    to_SHIFT_JIS_E6_9A_infos
};

static const unsigned char
to_SHIFT_JIS_E6_9B_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_9B */
  /* used from to_EUC_JP_E6_9B */
     26,  0, 26, 26,  1, 26, 26,  2,   26,  3, 26, 26, 26, 26, 26, 26,
     26, 26, 26, 26, 26, 26,  4, 26,   26,  5,  6, 26,  7,  8, 26, 26,
      9, 26, 26, 26, 26, 26, 10, 26,   26, 11, 26, 26, 26, 26, 26, 26,
     12, 26, 13, 14, 15, 16, 26, 17,   18, 19, 20, 21, 22, 23, 24, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_9B_infos[27] = {
     o2(0x9D,0xF8), o2(0x9E,0x40), o2(0x93,0xDC), o2(0x9D,0xFA),
     o2(0x9E,0x42), o2(0x8F,0x8C), o2(0x9E,0x43), o2(0x97,0x6A),
     o2(0x94,0x98), o2(0x9E,0x44), o2(0x9E,0x46), o2(0x9E,0x47),
     o2(0x9E,0x48), o2(0x8B,0xC8), o2(0x89,0x67), o2(0x8D,0x58),
     o2(0x9E,0x49), o2(0x9E,0x4A), o2(0x8F,0x91), o2(0x91,0x82),
     o2(0xFA,0xDE), o2(0xFA,0x66), o2(0x99,0xD6), o2(0x91,0x5D),
     o2(0x91,0x5C), o2(0x91,0xD6),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_9B = {
    to_SHIFT_JIS_E6_9B_offsets,
    to_SHIFT_JIS_E6_9B_infos
};

static const unsigned char
to_SHIFT_JIS_E6_9C_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_9C */
  /* used from to_EUC_JP_E6_9C */
      0, 32, 32,  1, 32, 32, 32, 32,    2,  3, 32,  4, 32,  5,  6,  7,
     32, 32, 32, 32,  8,  9, 10, 11,   32, 32, 32, 12, 32, 13, 14, 15,
     32, 32, 32, 32, 32, 32, 16, 17,   18, 32, 19, 20, 21, 22, 23, 32,
     32, 24, 32, 32, 25, 32, 26, 27,   28, 32, 29, 32, 32, 30, 32, 31,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_9C_infos[33] = {
     o2(0x8D,0xC5), o2(0x98,0xF0), o2(0x8C,0x8E), o2(0x97,0x4C),
     o2(0x95,0xFC), o2(0x95,0x9E), o2(0xFA,0xDF), o2(0x9E,0x4B),
     o2(0x8D,0xF1), o2(0x92,0xBD), o2(0x9E,0x4C), o2(0x98,0x4E),
     o2(0x96,0x5D), o2(0x92,0xA9), o2(0x9E,0x4D), o2(0x8A,0xFA),
     o2(0x9E,0x4E), o2(0x9E,0x4F), o2(0x96,0xD8), o2(0x96,0xA2),
     o2(0x96,0x96), o2(0x96,0x7B), o2(0x8E,0x44), o2(0x9E,0x51),
     o2(0x8E,0xE9), o2(0x96,0x70), o2(0x9E,0x53), o2(0x9E,0x56),
     o2(0x9E,0x55), o2(0x8A,0xF7), o2(0x8B,0x80), o2(0x9E,0x52),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_9C = {
    to_SHIFT_JIS_E6_9C_offsets,
    to_SHIFT_JIS_E6_9C_infos
};

static const unsigned char
to_SHIFT_JIS_E6_9D_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_9D */
  /* used from to_EUC_JP_E6_9D */
     32,  0, 32, 32, 32, 32,  1, 32,   32,  2, 32, 32, 32, 32,  3,  4,
      5,  6, 32,  7, 32, 32,  8, 32,   32,  9, 32, 32, 10, 32, 11, 12,
     13, 14, 15, 16, 17, 18, 19, 32,   32, 32, 20, 32, 32, 21, 32, 22,
     23, 24, 25, 26, 32, 27, 32, 28,   32, 32, 32, 32, 29, 32, 30, 31,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_9D_infos[33] = {
     o2(0x9E,0x54), o2(0x9E,0x57), o2(0x90,0x99), o2(0x97,0x9B),
     o2(0x88,0xC7), o2(0x8D,0xDE), o2(0x91,0xBA), o2(0x8E,0xDB),
     o2(0x8F,0xF1), o2(0x9E,0x5A), o2(0x93,0x6D), o2(0x9E,0x58),
     o2(0x91,0xA9), o2(0x9E,0x59), o2(0x8F,0xF0), o2(0x96,0xDB),
     o2(0x9E,0x5B), o2(0x9E,0x5C), o2(0x97,0x88), o2(0xFA,0xE1),
     o2(0x9E,0x61), o2(0x8D,0x59), o2(0x94,0x74), o2(0x9E,0x5E),
     o2(0x93,0x8C), o2(0x9D,0xDC), o2(0x9D,0xE0), o2(0x8B,0x6E),
     o2(0x94,0x66), o2(0x9E,0x60), o2(0x8F,0xBC), o2(0x94,0xC2),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_9D = {
    to_SHIFT_JIS_E6_9D_offsets,
    to_SHIFT_JIS_E6_9D_infos
};

static const unsigned char
to_SHIFT_JIS_E6_9E_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_9E */
  /* used from to_EUC_JP_E6_9E */
     24, 24, 24, 24, 24,  0, 24,  1,   24,  2, 24,  3,  4, 24, 24, 24,
      5, 24, 24, 24, 24,  6, 24,  7,   24, 24,  8, 24,  9, 10, 24, 24,
     11, 12, 13, 24, 24, 24, 14, 24,   24, 15, 24, 24, 24, 24, 24, 16,
     24, 24, 24, 17, 18, 24, 19, 20,   21, 22, 24, 23, 24, 24, 24, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_9E_infos[25] = {
     o2(0x9E,0x66), o2(0x94,0xF8), o2(0x9E,0x5D), o2(0x9E,0x63),
     o2(0x9E,0x62), o2(0x90,0xCD), o2(0x96,0x8D), o2(0x97,0xD1),
     o2(0x96,0x87), o2(0x89,0xCA), o2(0x8E,0x7D), o2(0x98,0x67),
     o2(0x9E,0x65), o2(0x90,0x95), o2(0x9E,0x64), o2(0x9E,0x5F),
     o2(0x8C,0xCD), o2(0x9E,0x6B), o2(0x9E,0x69), o2(0x89,0xCB),
     o2(0x9E,0x67), o2(0x9E,0x6D), o2(0x9E,0x73), o2(0xFA,0xE2),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_9E = {
    to_SHIFT_JIS_E6_9E_offsets,
    to_SHIFT_JIS_E6_9E_infos
};

static const unsigned char
to_SHIFT_JIS_E6_9F_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_9F */
  /* used from to_EUC_JP_E6_9F */
      0,  1, 29, 29,  2, 29,  3, 29,   29, 29,  4, 29, 29, 29,  5,  6,
      7,  8, 29,  9, 10, 29, 29, 29,   11, 29, 12, 29, 29, 13, 14, 29,
     29, 29, 15, 29, 16, 29, 29, 17,   29, 18, 29, 29, 19, 29, 20, 21,
     29, 22, 29, 23, 24, 25, 29, 29,   29, 29, 29, 26, 29, 29, 27, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_9F_infos[30] = {
     o2(0xFA,0xE4), o2(0x91,0xC6), o2(0x95,0xBF), o2(0x9E,0x75),
     o2(0x95,0x41), o2(0x9E,0x74), o2(0x94,0x90), o2(0x96,0x5E),
     o2(0x8A,0xB9), o2(0x90,0xF5), o2(0x8F,0x5F), o2(0x92,0xD1),
     o2(0x97,0x4D), o2(0x9E,0x70), o2(0x9E,0x6F), o2(0x9E,0x71),
     o2(0x9E,0x6E), o2(0x9E,0x76), o2(0x9E,0x6C), o2(0x9E,0x6A),
     o2(0x9E,0x72), o2(0x9E,0x68), o2(0x92,0x8C), o2(0x96,0xF6),
     o2(0x8E,0xC4), o2(0x8D,0xF2), o2(0x8D,0xB8), o2(0x96,0x8F),
     o2(0x8A,0x60),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_9F = {
    to_SHIFT_JIS_E6_9F_offsets,
    to_SHIFT_JIS_E6_9F_infos
};

static const unsigned char
to_SHIFT_JIS_E6_A0_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_A0 */
  /* used from to_EUC_JP_E6_A0 */
     19,  0,  1,  2,  3, 19, 19, 19,   19, 19, 19, 19, 19, 19, 19, 19,
     19, 19, 19,  4, 19, 19,  5,  6,   19, 19, 19, 19, 19, 19,  7, 19,
     19,  8,  9, 19, 19, 19, 19, 19,   19, 10, 11, 12, 19, 19, 19, 19,
     19, 19, 13, 19, 14, 19, 19, 19,   15, 16, 19, 19, 17, 18, 19, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_A0_infos[20] = {
     o2(0xFA,0xE5), o2(0x92,0xCC), o2(0x93,0xC8), o2(0x89,0x68),
     o2(0x90,0xF0), o2(0x90,0xB2), o2(0x8C,0x49), o2(0x9E,0x78),
     o2(0x8D,0x5A), o2(0x8A,0x9C), o2(0x9E,0x7A), o2(0x8A,0x94),
     o2(0x9E,0x81), o2(0x9E,0x7D), o2(0x90,0xF1), o2(0x8A,0x6A),
     o2(0x8D,0xAA), o2(0x8A,0x69), o2(0x8D,0xCD),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_A0 = {
    to_SHIFT_JIS_E6_A0_offsets,
    to_SHIFT_JIS_E6_A0_infos
};

static const unsigned char
to_SHIFT_JIS_E6_A1_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_A1 */
  /* used from to_EUC_JP_E6_A1 */
      0,  1,  2,  3,  4, 25,  5, 25,    6, 25, 25, 25, 25,  7,  8, 25,
      9, 10, 11, 12, 13, 25, 25, 25,   25, 14, 25, 25, 15, 16, 25, 17,
     25, 25, 25, 18, 25, 25, 25, 19,   25, 25, 25, 25, 25, 25, 25, 25,
     25, 25, 25, 25, 20, 25, 21, 22,   25, 25, 25, 25, 25, 25, 23, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_A1_infos[26] = {
     o2(0x9E,0x7B), o2(0x8C,0x85), o2(0x8C,0x6A), o2(0x93,0x8D),
     o2(0xFA,0xE6), o2(0x9E,0x79), o2(0x88,0xC4), o2(0x9E,0x7C),
     o2(0x9E,0x7E), o2(0x8B,0xCB), o2(0x8C,0x4B), o2(0xFA,0xE3),
     o2(0x8A,0xBA), o2(0x8B,0x6A), o2(0x9E,0x82), o2(0x8D,0xF7),
     o2(0x96,0x91), o2(0x8E,0x56), o2(0x9E,0x83), o2(0x95,0x4F),
     o2(0x9E,0x8F), o2(0x89,0xB1), o2(0x9E,0x84), o2(0x9E,0x95),
     o2(0x9E,0x85),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_A1 = {
    to_SHIFT_JIS_E6_A1_offsets,
    to_SHIFT_JIS_E6_A1_infos
};

static const unsigned char
to_SHIFT_JIS_E6_A2_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_A2 */
  /* used from to_EUC_JP_E6_A2 */
     26,  0, 26,  1, 26,  2, 26, 26,   26, 26, 26, 26, 26,  3, 26,  4,
     26, 26, 26,  5,  6, 26, 26,  7,   26, 26, 26,  8, 26,  9, 26, 10,
     11, 26, 12, 26, 26, 26, 13, 14,   15, 26, 26, 26, 26, 16, 26, 17,
     18, 19, 26, 20, 26, 21, 22, 26,   26, 23, 24, 26, 25, 26, 26, 26,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_A2_infos[27] = {
     o2(0x97,0xC0), o2(0x9E,0x8C), o2(0x94,0x7E), o2(0x9E,0x94),
     o2(0x9E,0x87), o2(0x88,0xB2), o2(0x9E,0x89), o2(0x8D,0x5B),
     o2(0x9E,0x8B), o2(0x9E,0x8A), o2(0x9E,0x86), o2(0x9E,0x91),
     o2(0x8F,0xBD), o2(0x9A,0xEB), o2(0x8C,0xE6), o2(0x97,0x9C),
     o2(0x9E,0x88), o2(0x92,0xF2), o2(0x8A,0x42), o2(0x8D,0xAB),
     o2(0x9E,0x80), o2(0x9E,0x90), o2(0x8A,0x81), o2(0x9E,0x8E),
     o2(0x9E,0x92), o2(0x93,0x8E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_A2 = {
    to_SHIFT_JIS_E6_A2_offsets,
    to_SHIFT_JIS_E6_A2_infos
};

static const unsigned char
to_SHIFT_JIS_E6_A3_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_A3 */
  /* used from to_EUC_JP_E6_A3 */
     24, 24, 24, 24,  0, 24,  1, 24,    2,  3,  4,  5, 24,  6, 24,  7,
     24, 24,  8, 24,  9, 10, 24, 11,   12, 24, 13, 24, 24, 24, 24, 14,
     15, 16, 24, 17, 24, 24, 24, 18,   24, 24, 24, 24, 24, 24, 19, 20,
     24, 24, 21, 24, 24, 24, 24, 24,   24, 22, 23, 24, 24, 24, 24, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_A3_infos[25] = {
     o2(0x8A,0xFC), o2(0x9E,0xB0), o2(0xFA,0x64), o2(0x96,0xC7),
     o2(0x9E,0x97), o2(0x8A,0xFB), o2(0x9E,0x9E), o2(0xFA,0xE7),
     o2(0x96,0x5F), o2(0x9E,0x9F), o2(0x9E,0xA1), o2(0x9E,0xA5),
     o2(0x9E,0x99), o2(0x92,0x49), o2(0x93,0x8F), o2(0x9E,0xA9),
     o2(0x9E,0x9C), o2(0x9E,0xA6), o2(0x9E,0xA0), o2(0x90,0x58),
     o2(0x9E,0xAA), o2(0x90,0xB1), o2(0x9E,0xA8), o2(0x8A,0xBB),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_A3 = {
    to_SHIFT_JIS_E6_A3_offsets,
    to_SHIFT_JIS_E6_A3_infos
};

static const unsigned char
to_SHIFT_JIS_E6_A4_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_A4 */
  /* used from to_EUC_JP_E6_A4 */
      0,  1, 28, 28,  2,  3, 28, 28,    4, 28, 28,  5,  6,  7,  8,  9,
     28, 28, 10, 28, 28, 28, 28, 28,   28, 11, 12, 13, 14, 28, 28, 28,
     28, 15, 16, 17, 28, 18, 19, 28,   20, 28, 21, 28, 28, 28, 28, 28,
     22, 28, 28, 28, 23, 28, 24, 28,   28, 25, 28, 28, 28, 26, 28, 27,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_A4_infos[29] = {
     o2(0x98,0x6F), o2(0x9E,0x96), o2(0x9E,0xA4), o2(0x88,0xD6),
     o2(0x9E,0x98), o2(0x96,0xB8), o2(0x9E,0x9D), o2(0x90,0x41),
     o2(0x92,0xC5), o2(0x9E,0x93), o2(0x9E,0xA3), o2(0x90,0x9A),
     o2(0x9E,0xAD), o2(0x8A,0x91), o2(0x8C,0x9F), o2(0x9E,0xAF),
     o2(0x9E,0x9A), o2(0x9E,0xAE), o2(0x9E,0xA7), o2(0x9E,0x9B),
     o2(0x9E,0xAB), o2(0x9E,0xAC), o2(0x9E,0xBD), o2(0x93,0xCC),
     o2(0x9E,0xA2), o2(0x9E,0xB9), o2(0x9E,0xBB), o2(0x92,0xD6),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_A4 = {
    to_SHIFT_JIS_E6_A4_offsets,
    to_SHIFT_JIS_E6_A4_infos
};

static const unsigned char
to_SHIFT_JIS_E6_A5_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_A5 */
  /* used from to_EUC_JP_E6_A5 */
     27, 27, 27, 27, 27, 27, 27, 27,   27, 27,  0, 27, 27, 27, 27, 27,
     27, 27, 27,  1,  2,  3, 27, 27,   27,  4,  5, 27,  6,  7,  8, 27,
      9, 10, 11, 27, 27, 27, 27, 27,   12, 27, 13, 14, 27, 15, 16, 17,
     27, 27, 27, 18, 19, 20, 27, 21,   22, 23, 27, 27, 24, 25, 26, 27,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_A5_infos[28] = {
     o2(0x97,0x6B), o2(0x95,0x96), o2(0x9E,0xB6), o2(0x91,0xC8),
     o2(0x9E,0xBC), o2(0x91,0x5E), o2(0x9E,0xB3), o2(0x9E,0xC0),
     o2(0x9E,0xBF), o2(0x93,0xED), o2(0x9E,0xBE), o2(0x93,0xE8),
     o2(0xFA,0xE9), o2(0x9E,0xC2), o2(0x9E,0xB5), o2(0x8B,0xC6),
     o2(0x9E,0xB8), o2(0x8F,0x7C), o2(0x94,0x80), o2(0x9E,0xBA),
     o2(0x8B,0xC9), o2(0x9E,0xB2), o2(0x9E,0xB4), o2(0x9E,0xB1),
     o2(0x98,0x4F), o2(0x8A,0x79), o2(0x9E,0xB7),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_A5 = {
    to_SHIFT_JIS_E6_A5_offsets,
    to_SHIFT_JIS_E6_A5_infos
};

static const unsigned char
to_SHIFT_JIS_E6_A6_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_A6 */
  /* used from to_EUC_JP_E6_A6 */
     19,  0,  1, 19, 19, 19, 19, 19,   19, 19,  2, 19, 19, 19,  3, 19,
     19,  4, 19, 19,  5,  6, 19, 19,    7, 19, 19,  8,  9, 19, 19, 19,
     10, 19, 19, 19, 19, 19, 19, 11,   19, 19, 19, 19, 19, 19, 12, 19,
     19, 13, 14, 19, 15, 19, 19, 19,   19, 19, 19, 16, 19, 19, 17, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_A6_infos[20] = {
     o2(0x9E,0xC1), o2(0x8A,0x54), o2(0x8D,0xE5), o2(0x89,0x7C),
     o2(0x9E,0xD2), o2(0x98,0x50), o2(0x9E,0xD5), o2(0xFA,0xEB),
     o2(0x90,0x59), o2(0x9E,0xD4), o2(0x9E,0xD3), o2(0x9E,0xD0),
     o2(0x9E,0xC4), o2(0x9E,0xE1), o2(0x9E,0xC3), o2(0x9E,0xD6),
     o2(0x9E,0xCE), o2(0x9E,0xC9), o2(0x9E,0xC6),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_A6 = {
    to_SHIFT_JIS_E6_A6_offsets,
    to_SHIFT_JIS_E6_A6_infos
};

static const unsigned char
to_SHIFT_JIS_E6_A7_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_A7 */
  /* used from to_EUC_JP_E6_A7 */
     24,  0, 24,  1, 24, 24, 24,  2,   24, 24,  3,  4,  5,  6,  7, 24,
      8, 24, 24,  9, 24, 24, 24, 24,   10, 11, 24, 24, 24, 12, 13, 24,
     24, 24, 14, 24, 24, 24, 24, 15,   16, 24, 24, 17, 24, 18, 24, 24,
     24, 24, 19, 24, 24, 24, 24, 24,   24, 20, 24, 21, 24, 22, 24, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_A7_infos[25] = {
     o2(0x9E,0xC7), o2(0x9E,0xCF), o2(0xEA,0xA0), o2(0x9E,0xCC),
     o2(0x8D,0x5C), o2(0x92,0xC6), o2(0x91,0x84), o2(0x9E,0xCA),
     o2(0x9E,0xC5), o2(0x9E,0xC8), o2(0x97,0x6C), o2(0x96,0x8A),
     o2(0x9E,0xCD), o2(0x9E,0xD7), o2(0xFA,0xEC), o2(0x9E,0xDF),
     o2(0x9E,0xD8), o2(0x9E,0xE5), o2(0x9E,0xE3), o2(0x9E,0xDE),
     o2(0x9E,0xDD), o2(0x92,0xCE), o2(0x91,0x85), o2(0x9E,0xDB),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_A7 = {
    to_SHIFT_JIS_E6_A7_offsets,
    to_SHIFT_JIS_E6_A7_infos
};

static const unsigned char
to_SHIFT_JIS_E6_A8_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_A8 */
  /* used from to_EUC_JP_E6_A8 */
     27, 27,  0, 27, 27,  1, 27, 27,   27, 27,  2,  3,  4, 27, 27, 27,
     27, 27,  5,  6,  7, 27, 27,  8,   27,  9, 27, 10, 27, 27, 11, 12,
     27, 13, 14, 15, 27, 27, 27, 27,   27, 16, 17, 18, 27, 27, 19, 27,
     20, 27, 27, 27, 27, 21, 22, 27,   23, 24, 25, 27, 27, 26, 27, 27,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_A8_infos[28] = {
     o2(0x9E,0xD9), o2(0x9E,0xE0), o2(0x9E,0xE6), o2(0x94,0xF3),
     o2(0x9E,0xEC), o2(0x9E,0xE7), o2(0x9E,0xEA), o2(0x9E,0xE4),
     o2(0x92,0x94), o2(0x95,0x57), o2(0x9E,0xDA), o2(0x9E,0xE2),
     o2(0x8F,0xBE), o2(0x96,0xCD), o2(0x9E,0xF6), o2(0x9E,0xE9),
     o2(0x8C,0xA0), o2(0x89,0xA1), o2(0x8A,0x7E), o2(0x9E,0xD1),
     o2(0xFA,0xED), o2(0x8F,0xBF), o2(0x9E,0xEE), o2(0x9E,0xF5),
     o2(0x8E,0xF7), o2(0x8A,0x92), o2(0x92,0x4D),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_A8 = {
    to_SHIFT_JIS_E6_A8_offsets,
    to_SHIFT_JIS_E6_A8_infos
};

static const unsigned char
to_SHIFT_JIS_E6_A9_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_A9 */
  /* used from to_EUC_JP_E6_A9 */
     17, 17, 17, 17,  0, 17,  1,  2,    3, 17, 17,  4, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,    5,  6, 17, 17, 17, 17, 17,  7,
     17,  8,  9, 17, 17, 17, 10, 17,   17, 17, 17, 11, 17, 17, 17, 17,
     17, 17, 12, 13, 17, 17, 17, 17,   14, 17, 17, 17, 17, 17, 15, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_A9_infos[18] = {
     o2(0x9E,0xEB), o2(0xFA,0xEF), o2(0x9E,0xF0), o2(0x9E,0xF4),
     o2(0x8B,0xB4), o2(0x8B,0x6B), o2(0x9E,0xF2), o2(0x8B,0x40),
     o2(0x93,0xC9), o2(0x9E,0xF1), o2(0x9E,0xF3), o2(0xFA,0xEE),
     o2(0x9E,0xED), o2(0xFA,0xF0), o2(0x9E,0xEF), o2(0xFA,0xF1),
     o2(0x8A,0x80),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_A9 = {
    to_SHIFT_JIS_E6_A9_offsets,
    to_SHIFT_JIS_E6_A9_infos
};

static const unsigned char
to_SHIFT_JIS_E6_AA_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_AA */
  /* used from to_EUC_JP_E6_AA */
      0, 16, 16, 16,  1, 16, 16, 16,   16, 16, 16, 16, 16,  2,  3, 16,
      4, 16, 16, 16, 16, 16, 16,  5,   16, 16, 16, 16,  6, 16, 16, 16,
      7, 16,  8,  9, 16, 16, 16, 16,   16, 16, 10, 16, 11, 16, 12, 16,
     16, 16, 16, 13, 16, 16, 16, 16,   14, 16, 16, 15, 16, 16, 16, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_AA_infos[17] = {
     o2(0x92,0x68), o2(0x9E,0xFA), o2(0x9E,0xF8), o2(0x8C,0xE7),
     o2(0x9E,0xF7), o2(0x9F,0x40), o2(0x9E,0x77), o2(0x9E,0xF9),
     o2(0x9E,0xFB), o2(0x9E,0xFC), o2(0x9F,0x4B), o2(0x9F,0x47),
     o2(0x9E,0x8D), o2(0x9F,0x46), o2(0x9F,0x45), o2(0x9F,0x42),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_AA = {
    to_SHIFT_JIS_E6_AA_offsets,
    to_SHIFT_JIS_E6_AA_infos
};

static const unsigned char
to_SHIFT_JIS_E6_AB_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_AB */
  /* used from to_EUC_JP_E6_AB */
     15,  0,  1,  2, 15, 15, 15, 15,   15, 15, 15, 15, 15, 15, 15, 15,
     15,  3, 15,  4, 15, 15, 15, 15,   15, 15,  5,  6, 15, 15,  7,  8,
     15, 15,  9, 15, 10, 15, 15, 15,   11, 15, 12, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,   15, 15, 13, 14, 15, 15, 15, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_AB_infos[16] = {
     o2(0x9E,0xE8), o2(0x9F,0x44), o2(0x9F,0x43), o2(0x9F,0x49),
     o2(0x98,0x45), o2(0x9F,0x4C), o2(0x8B,0xF9), o2(0x9F,0x48),
     o2(0x9F,0x4A), o2(0xFA,0xF2), o2(0xFA,0xF3), o2(0x94,0xA5),
     o2(0x9F,0x4D), o2(0x9F,0x51), o2(0x9F,0x4E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_AB = {
    to_SHIFT_JIS_E6_AB_offsets,
    to_SHIFT_JIS_E6_AB_infos
};

static const unsigned char
to_SHIFT_JIS_E6_AC_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_AC */
  /* used from to_EUC_JP_E6_AC */
     18, 18, 18, 18,  0,  1, 18, 18,   18, 18,  2, 18, 18, 18, 18, 18,
     18, 18,  3, 18, 18, 18,  4, 18,   18, 18, 18, 18, 18,  5, 18,  6,
      7,  8, 18,  9, 18, 18, 18, 10,   18, 18, 18, 18, 18, 18, 18, 18,
     18, 18, 11, 18, 18, 18, 18, 12,   13, 14, 15, 18, 18, 16, 17, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_AC_infos[19] = {
     o2(0x97,0x93), o2(0x9F,0x4F), o2(0x9E,0xDC), o2(0x9F,0x52),
     o2(0x9F,0x53), o2(0x89,0x54), o2(0x9F,0x55), o2(0x8C,0x87),
     o2(0x8E,0x9F), o2(0x8B,0xD3), o2(0x89,0xA2), o2(0x97,0x7E),
     o2(0x9F,0x57), o2(0x9F,0x56), o2(0x9F,0x59), o2(0x8B,0x5C),
     o2(0x8B,0xD4), o2(0x8A,0xBC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_AC = {
    to_SHIFT_JIS_E6_AC_offsets,
    to_SHIFT_JIS_E6_AC_infos
};

static const unsigned char
to_SHIFT_JIS_E6_AD_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_AD */
  /* used from to_EUC_JP_E6_AD */
     25, 25, 25,  0, 25, 25, 25,  1,   25,  2, 25, 25,  3, 25,  4, 25,
      5, 25, 25,  6,  7, 25, 25, 25,   25,  8, 25,  9, 25, 25, 25, 10,
     25, 11, 12, 13, 14, 25, 15, 25,   25, 16, 17, 25, 25, 25, 25, 18,
     25, 25, 25, 19, 20, 25, 25, 25,   21, 22, 25, 23, 25, 25, 25, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_AD_infos[26] = {
     o2(0x9F,0x5C), o2(0x9F,0x5B), o2(0x9F,0x5D), o2(0x89,0xCC),
     o2(0x92,0x56), o2(0x9F,0x5E), o2(0x8A,0xBD), o2(0x9F,0x60),
     o2(0x9F,0x5F), o2(0x9F,0x61), o2(0x9F,0x62), o2(0x9F,0x63),
     o2(0x8E,0x7E), o2(0x90,0xB3), o2(0x8D,0x9F), o2(0x95,0x90),
     o2(0x95,0xE0), o2(0x98,0x63), o2(0x8E,0x95), o2(0x8D,0xCE),
     o2(0x97,0xF0), o2(0x9F,0x64), o2(0x9F,0x65), o2(0x8E,0x80),
     o2(0x9F,0x66),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_AD = {
    to_SHIFT_JIS_E6_AD_offsets,
    to_SHIFT_JIS_E6_AD_infos
};

static const unsigned char
to_SHIFT_JIS_E6_AE_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_AE */
  /* used from to_EUC_JP_E6_AE */
      0, 26, 26,  1,  2, 26,  3, 26,   26,  4,  5,  6, 26,  7, 26, 26,
     26, 26, 26, 26, 26,  8,  9, 26,   10, 26, 26, 26, 26, 26, 11, 26,
     26, 26, 26, 26, 12, 26, 26, 26,   26, 26, 13, 14, 26, 26, 26, 15,
     26, 16, 17, 18, 19, 20, 26, 21,   26, 26, 22, 23, 24, 26, 26, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_AE_infos[27] = {
     o2(0x9F,0x67), o2(0x9F,0x69), o2(0x9F,0x68), o2(0x96,0x77),
     o2(0x8F,0x7D), o2(0x8E,0xEA), o2(0x8E,0x63), o2(0x9F,0x6A),
     o2(0x9F,0x6C), o2(0x90,0x42), o2(0x9F,0x6B), o2(0x9F,0x6D),
     o2(0x9F,0x6E), o2(0x9F,0x6F), o2(0x9F,0x70), o2(0x9F,0x71),
     o2(0x9F,0x73), o2(0x9F,0x72), o2(0x9F,0x74), o2(0x89,0xA3),
     o2(0x92,0x69), o2(0x9F,0x75), o2(0x8E,0x45), o2(0x8A,0x6B),
     o2(0x9F,0x76), o2(0x93,0x61),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_AE = {
    to_SHIFT_JIS_E6_AE_offsets,
    to_SHIFT_JIS_E6_AE_infos
};

static const unsigned char
to_SHIFT_JIS_E6_AF_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_AF */
  /* used from to_EUC_JP_E6_AF */
      0, 17, 17, 17, 17,  1,  2, 17,   17, 17, 17,  3, 17,  4,  5, 17,
     17, 17,  6,  7,  8, 17,  9, 17,   10, 17, 17, 11, 17, 17, 17, 12,
     17, 17, 17, 17, 17, 17, 17, 17,   17, 17, 17, 13, 14, 17, 17, 15,
     17, 17, 17, 16, 17, 17, 17, 17,   17, 17, 17, 17, 17, 17, 17, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_AF_infos[18] = {
     o2(0x9A,0xCA), o2(0x8B,0x42), o2(0x9F,0x77), o2(0x9F,0x78),
     o2(0x95,0xEA), o2(0x96,0x88), o2(0x93,0xC5), o2(0x9F,0x79),
     o2(0x94,0xE4), o2(0xFA,0xF4), o2(0x94,0xF9), o2(0x96,0xD1),
     o2(0x9F,0x7A), o2(0x9F,0x7C), o2(0x9F,0x7B), o2(0x9F,0x7E),
     o2(0x9F,0x7D),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_AF = {
    to_SHIFT_JIS_E6_AF_offsets,
    to_SHIFT_JIS_E6_AF_infos
};

static const unsigned char
to_SHIFT_JIS_E6_B0_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_B0 */
  /* used from to_EUC_JP_E6_B0 */
     14, 14, 14, 14, 14, 14, 14, 14,    0, 14, 14, 14, 14, 14, 14,  1,
     14,  2, 14,  3,  4, 14, 14,  5,   14, 14, 14,  6, 14, 14, 14, 14,
     14, 14, 14,  7,  8, 14, 14, 14,   14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14,  9, 14, 14, 10,   11, 14, 14, 14, 14, 14, 12, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_B0_infos[15] = {
     o2(0x9F,0x81), o2(0x8E,0x81), o2(0x96,0xAF), o2(0x9F,0x82),
     o2(0x9F,0x83), o2(0x8B,0x43), o2(0x9F,0x84), o2(0x9F,0x86),
     o2(0x9F,0x85), o2(0x90,0x85), o2(0x95,0x58), o2(0x89,0x69),
     o2(0x94,0xC3), o2(0xFA,0xF5),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_B0 = {
    to_SHIFT_JIS_E6_B0_offsets,
    to_SHIFT_JIS_E6_B0_infos
};

static const unsigned char
to_SHIFT_JIS_E6_B1_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_B1 */
  /* used from to_EUC_JP_E6_B1 */
      0,  1,  2, 23, 23, 23, 23, 23,   23, 23, 23, 23, 23, 23,  3, 23,
      4, 23, 23, 23, 23,  5, 23,  6,   23, 23,  7, 23,  8,  9, 10, 11,
     12, 23, 13, 23, 23, 23, 23, 23,   14, 23, 15, 23, 23, 23, 23, 16,
     17, 23, 18, 19, 23, 23, 23, 23,   23, 23, 20, 23, 23, 21, 22, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_B1_infos[24] = {
     o2(0x92,0xF3), o2(0x8F,0x60), o2(0x8B,0x81), o2(0x94,0xC4),
     o2(0x8E,0xAC), o2(0x9F,0x88), o2(0x8A,0xBE), o2(0x89,0x98),
     o2(0xFA,0xF6), o2(0x93,0xF0), o2(0x9F,0x87), o2(0x8D,0x5D),
     o2(0x92,0x72), o2(0x9F,0x89), o2(0x9F,0x91), o2(0x9F,0x8A),
     o2(0xFA,0xF8), o2(0x91,0xBF), o2(0x8B,0x82), o2(0x9F,0x92),
     o2(0x8C,0x88), o2(0x8B,0x44), o2(0x9F,0x90),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_B1 = {
    to_SHIFT_JIS_E6_B1_offsets,
    to_SHIFT_JIS_E6_B1_infos
};

static const unsigned char
to_SHIFT_JIS_E6_B2_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_B2 */
  /* used from to_EUC_JP_E6_B2 */
     28,  0,  1,  2, 28, 28,  3, 28,    4, 28, 28, 28,  5,  6, 28, 28,
      7, 28,  8,  9, 28, 28, 10, 28,   28, 11, 12, 13, 28, 28, 28, 28,
     28, 14, 15, 28, 28, 28, 28, 28,   28, 28, 28, 16, 28, 28, 17, 28,
     28, 18, 28, 19, 28, 28, 28, 28,   20, 21, 22, 23, 24, 25, 26, 27,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_B2_infos[29] = {
     o2(0x9F,0x8E), o2(0x9F,0x8B), o2(0x97,0x80), o2(0xFA,0xF7),
     o2(0x92,0xBE), o2(0x93,0xD7), o2(0x9F,0x8C), o2(0x9F,0x94),
     o2(0x9F,0x93), o2(0x8C,0x42), o2(0x89,0xAB), o2(0x8D,0xB9),
     o2(0x9F,0x8D), o2(0x9F,0x8F), o2(0x96,0x76), o2(0x91,0xF2),
     o2(0x96,0x97), o2(0x9F,0x9C), o2(0x9F,0x9D), o2(0x89,0xCD),
     o2(0x95,0xA6), o2(0x96,0xFB), o2(0x9F,0x9F), o2(0x8E,0xA1),
     o2(0x8F,0xC0), o2(0x9F,0x98), o2(0x9F,0x9E), o2(0x89,0x88),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_B2 = {
    to_SHIFT_JIS_E6_B2_offsets,
    to_SHIFT_JIS_E6_B2_infos
};

static const unsigned char
to_SHIFT_JIS_E6_B3_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_B3 */
  /* used from to_EUC_JP_E6_B3 */
     23,  0, 23, 23,  1,  2, 23, 23,   23,  3,  4, 23,  5, 23, 23, 23,
     23, 23, 23,  6, 23,  7, 23,  8,   23,  9, 10, 11, 23, 12, 23, 23,
     23, 13, 14, 15, 23, 16, 23, 23,   17, 23, 18, 23, 23, 23, 23, 19,
     20, 21, 23, 22, 23, 23, 23, 23,   23, 23, 23, 23, 23, 23, 23, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_B3_infos[24] = {
     o2(0x8B,0xB5), o2(0x9F,0x95), o2(0x9F,0x9A), o2(0x90,0xF2),
     o2(0x94,0x91), o2(0x94,0xE5), o2(0x9F,0x97), o2(0x96,0x40),
     o2(0x9F,0x99), o2(0x9F,0xA2), o2(0xFA,0xF9), o2(0x9F,0xA0),
     o2(0x9F,0x9B), o2(0x96,0x41), o2(0x94,0x67), o2(0x8B,0x83),
     o2(0x93,0x44), o2(0x92,0x8D), o2(0x9F,0xA3), o2(0x9F,0xA1),
     o2(0x91,0xD7), o2(0x9F,0x96), o2(0x89,0x6A),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_B3 = {
    to_SHIFT_JIS_E6_B3_offsets,
    to_SHIFT_JIS_E6_B3_infos
};

static const unsigned char
to_SHIFT_JIS_E6_B4_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_B4 */
  /* used from to_EUC_JP_E6_B4 */
     21, 21, 21, 21,  0, 21, 21, 21,   21, 21, 21,  1,  2, 21, 21, 21,
     21, 21,  3, 21, 21, 21, 21,  4,   21,  5, 21,  6, 21, 21,  7,  8,
     21, 21, 21, 21, 21,  9, 21, 21,   21, 10, 11, 12, 21, 21, 21, 21,
     21, 21, 13, 14, 21, 15, 16, 21,   17, 21, 21, 18, 21, 19, 20, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_B4_infos[22] = {
     o2(0xFA,0xFA), o2(0x97,0x6D), o2(0x9F,0xAE), o2(0x9F,0xAD),
     o2(0x90,0xF4), o2(0x9F,0xAA), o2(0x97,0x8C), o2(0x93,0xB4),
     o2(0x9F,0xA4), o2(0x92,0xC3), o2(0x89,0x6B), o2(0x8D,0x5E),
     o2(0x9F,0xA7), o2(0x8F,0x46), o2(0x9F,0xAC), o2(0x9F,0xAB),
     o2(0x9F,0xA6), o2(0x9F,0xA9), o2(0x8A,0x88), o2(0x9F,0xA8),
     o2(0x94,0x68),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_B4 = {
    to_SHIFT_JIS_E6_B4_offsets,
    to_SHIFT_JIS_E6_B4_infos
};

static const unsigned char
to_SHIFT_JIS_E6_B5_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_B5 */
  /* used from to_EUC_JP_E6_B5 */
     18,  0, 18, 18,  1,  2, 18, 18,   18, 18, 18, 18, 18, 18, 18, 18,
     18, 18, 18, 18, 18, 18, 18, 18,   18,  3,  4, 18,  5, 18, 18, 18,
     18, 18, 18,  6,  7, 18,  8, 18,   18,  9, 10, 18, 11, 18, 12, 13,
     18, 18, 18, 18, 14, 18, 18, 15,   16, 17, 18, 18, 18, 18, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_B5_infos[19] = {
     o2(0x97,0xAC), o2(0x8F,0xF2), o2(0x90,0xF3), o2(0x9F,0xB4),
     o2(0x9F,0xB2), o2(0x95,0x6C), o2(0x9F,0xAF), o2(0x9F,0xB1),
     o2(0x89,0x59), o2(0x8D,0x5F), o2(0x98,0x51), o2(0x8A,0x5C),
     o2(0x95,0x82), o2(0xFA,0xFC), o2(0x97,0x81), o2(0x8A,0x43),
     o2(0x90,0x5A), o2(0x9F,0xB3),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_B5 = {
    to_SHIFT_JIS_E6_B5_offsets,
    to_SHIFT_JIS_E6_B5_infos
};

static const unsigned char
to_SHIFT_JIS_E6_B6_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_B6 */
  /* used from to_EUC_JP_E6_B6 */
     17, 17, 17, 17, 17,  0, 17,  1,    2, 17, 17, 17,  3, 17,  4, 17,
     17, 17, 17,  5, 17,  6,  7, 17,   17,  8, 17,  9, 10, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,   17, 17, 17, 17, 11, 17, 17, 12,
     17, 17, 13, 17, 17, 14, 17, 17,   15, 17, 17, 17, 16, 17, 17, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_B6_infos[18] = {
     o2(0x9F,0xB8), o2(0xFA,0xFB), o2(0x8F,0xC1), o2(0x97,0x4F),
     o2(0x9F,0xB5), o2(0x9F,0xB0), o2(0x9F,0xB6), o2(0xFB,0x40),
     o2(0x97,0xDC), o2(0x93,0x93), o2(0x93,0xC0), o2(0xFB,0x41),
     o2(0x8A,0x55), o2(0x89,0x74), o2(0x9F,0xBC), o2(0x9F,0xBF),
     o2(0x97,0xC1),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_B6 = {
    to_SHIFT_JIS_E6_B6_offsets,
    to_SHIFT_JIS_E6_B6_infos
};

static const unsigned char
to_SHIFT_JIS_E6_B7_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_B7 */
  /* used from to_EUC_JP_E6_B7 */
      0, 31, 31, 31, 31,  1,  2,  3,   31, 31, 31,  4,  5, 31, 31,  6,
     31,  7,  8, 31, 31,  9, 31, 31,   10, 11, 31, 31, 31, 31, 12, 31,
     31, 13, 31, 31, 14, 31, 15, 31,   16, 31, 17, 18, 19, 31, 20, 31,
     31, 21, 22, 23, 31, 24, 31, 25,   26, 27, 28, 29, 30, 31, 31, 31,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_B7_infos[32] = {
     o2(0x97,0x84), o2(0x9F,0xC6), o2(0x9F,0xC0), o2(0x9F,0xBD),
     o2(0x97,0xD2), o2(0x9F,0xC3), o2(0xFB,0x42), o2(0x8F,0x69),
     o2(0x9F,0xC5), o2(0x9F,0xCA), o2(0x93,0x91), o2(0x9F,0xC8),
     o2(0x9F,0xC2), o2(0x92,0x57), o2(0x9F,0xC9), o2(0x9F,0xBE),
     o2(0x9F,0xC4), o2(0x9F,0xCB), o2(0x88,0xFA), o2(0x9F,0xC1),
     o2(0x9F,0xCC), o2(0x90,0x5B), o2(0xFB,0x44), o2(0x8F,0x7E),
     o2(0x95,0xA3), o2(0x8D,0xAC), o2(0xFB,0x43), o2(0x9F,0xB9),
     o2(0x9F,0xC7), o2(0x93,0x59), o2(0xFB,0x45),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_B7 = {
    to_SHIFT_JIS_E6_B7_offsets,
    to_SHIFT_JIS_E6_B7_infos
};

static const unsigned char
to_SHIFT_JIS_E6_B8_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_B8 */
  /* used from to_EUC_JP_E6_B8 */
     31, 31, 31, 31, 31,  0, 31,  1,    2,  3,  4,  5, 31, 31, 31, 31,
     31, 31, 31,  6, 31,  7, 31, 31,   31,  8,  9, 10, 31, 11, 31, 12,
     13, 14, 31, 15, 16, 17, 18, 19,   31, 20, 31, 21, 22, 23, 24, 25,
     31, 31, 31, 31, 31, 31, 31, 31,   26, 27, 28, 31, 29, 31, 30, 31,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_B8_infos[32] = {
     o2(0x90,0xB4), o2(0x8A,0x89), o2(0x8D,0xCF), o2(0x8F,0xC2),
     o2(0x9F,0xBB), o2(0x8F,0x61), o2(0x8C,0x6B), o2(0x9F,0xBA),
     o2(0x9F,0xD0), o2(0x8F,0x8D), o2(0x8C,0xB8), o2(0x9F,0xDF),
     o2(0x9F,0xD9), o2(0x8B,0x94), o2(0x93,0x6E), o2(0x9F,0xD4),
     o2(0x9F,0xDD), o2(0x88,0xAD), o2(0x89,0x51), o2(0xFB,0x48),
     o2(0x89,0xB7), o2(0x9F,0xD6), o2(0x91,0xAA), o2(0x9F,0xCD),
     o2(0x9F,0xCF), o2(0x8D,0x60), o2(0x9F,0xE0), o2(0xFB,0x46),
     o2(0x9F,0xDB), o2(0xFB,0x49), o2(0x9F,0xD3),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_B8 = {
    to_SHIFT_JIS_E6_B8_offsets,
    to_SHIFT_JIS_E6_B8_infos
};

static const unsigned char
to_SHIFT_JIS_E6_B9_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_B9 */
  /* used from to_EUC_JP_E6_B9 */
     17, 17, 17,  0, 17, 17, 17, 17,   17, 17,  1, 17, 17,  2,  3, 17,
     17, 17, 17, 17, 17, 17,  4, 17,    5, 17, 17,  6,  7, 17, 17,  8,
     17, 17, 17, 17, 17, 17, 17,  9,   17, 17, 17, 10, 17, 17, 11, 12,
     17, 17, 13, 17, 17, 17, 14, 17,   17, 17, 17, 17, 17, 17, 15, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_B9_infos[18] = {
     o2(0x9F,0xDA), o2(0x96,0xA9), o2(0x9F,0xD8), o2(0x9F,0xDC),
     o2(0x8C,0xCE), o2(0x8F,0xC3), o2(0x92,0x58), o2(0xFB,0x47),
     o2(0x9F,0xD2), o2(0x97,0x4E), o2(0x9F,0xD5), o2(0x9F,0xCE),
     o2(0x93,0x92), o2(0x9F,0xD1), o2(0x9F,0xD7), o2(0x98,0x70),
     o2(0x8E,0xBC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_B9 = {
    to_SHIFT_JIS_E6_B9_offsets,
    to_SHIFT_JIS_E6_B9_infos
};

static const unsigned char
to_SHIFT_JIS_E6_BA_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_BA */
  /* used from to_EUC_JP_E6_BA */
      0, 20,  1, 20, 20, 20, 20, 20,   20, 20, 20, 20,  2, 20, 20,  3,
      4, 20, 20, 20, 20, 20,  5, 20,    6, 20, 20, 20,  7,  8, 20,  9,
     20, 20, 10, 20, 20, 11, 20, 20,   20, 20, 12, 20, 20, 20, 20, 13,
     20, 20, 14, 20, 20, 20, 15, 16,   20, 20, 17, 20, 20, 18, 20, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_BA_infos[21] = {
     o2(0x96,0x9E), o2(0x9F,0xE1), o2(0x94,0xAC), o2(0x9F,0xED),
     o2(0x8C,0xB9), o2(0x8F,0x80), o2(0x9F,0xE3), o2(0x97,0xAD),
     o2(0x8D,0x61), o2(0x9F,0xF0), o2(0x88,0xEC), o2(0x9F,0xEE),
     o2(0x9F,0xE2), o2(0x9F,0xE8), o2(0x9F,0xEA), o2(0x97,0x6E),
     o2(0x9F,0xE5), o2(0x93,0x4D), o2(0x9F,0xE7), o2(0xFB,0x4A),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_BA = {
    to_SHIFT_JIS_E6_BA_offsets,
    to_SHIFT_JIS_E6_BA_infos
};

static const unsigned char
to_SHIFT_JIS_E6_BB_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_BB */
  /* used from to_EUC_JP_E6_BB */
     20, 20,  0, 20,  1,  2, 20, 20,   20,  3, 20,  4,  5, 20, 20, 20,
     20,  6, 20,  7,  8,  9, 20, 20,   20, 20, 20, 20, 20, 10, 11, 20,
     20, 20, 20, 20, 20, 20, 20, 20,   20, 20, 20, 20, 12, 20, 20, 13,
     20, 20, 14, 20, 15, 20, 20, 16,   17, 20, 20, 20, 20, 20, 18, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_BB_infos[21] = {
     o2(0x9F,0xEF), o2(0x9F,0xE9), o2(0x96,0xC5), o2(0x9F,0xE4),
     o2(0x8E,0xA0), o2(0x9F,0xFC), o2(0x8A,0x8A), o2(0x9F,0xE6),
     o2(0x9F,0xEB), o2(0x9F,0xEC), o2(0x91,0xEA), o2(0x91,0xD8),
     o2(0x9F,0xF4), o2(0x9F,0xFA), o2(0x9F,0xF8), o2(0x93,0x48),
     o2(0xE0,0x42), o2(0x9F,0xF5), o2(0x9F,0xF6), o2(0x9F,0xDE),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_BB = {
    to_SHIFT_JIS_E6_BB_offsets,
    to_SHIFT_JIS_E6_BB_infos
};

static const unsigned char
to_SHIFT_JIS_E6_BC_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_BC */
  /* used from to_EUC_JP_E6_BC */
     19,  0,  1, 19, 19, 19,  2, 19,   19,  3, 19, 19, 19, 19, 19,  4,
     19,  5, 19,  6,  7,  8, 19, 19,   19, 19, 19, 19, 19, 19, 19, 19,
      9, 19, 10, 11, 19, 19, 19, 19,   19, 19, 19, 12, 13, 19, 19, 19,
     19, 14, 15, 19, 19, 19, 19, 19,   16, 19, 19, 19, 19, 19, 17, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_BC_infos[20] = {
     o2(0x8B,0x99), o2(0x95,0x59), o2(0x8E,0xBD), o2(0x8D,0x97),
     o2(0x98,0x52), o2(0x9F,0xF2), o2(0xE0,0x41), o2(0x89,0x89),
     o2(0x91,0x86), o2(0x94,0x99), o2(0x8A,0xBF), o2(0x97,0xF8),
     o2(0x96,0x9F), o2(0x92,0xD0), o2(0x9F,0xF9), o2(0x9F,0xFB),
     o2(0x91,0x51), o2(0xE0,0x40), o2(0x9F,0xF7),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_BC = {
    to_SHIFT_JIS_E6_BC_offsets,
    to_SHIFT_JIS_E6_BC_infos
};

static const unsigned char
to_SHIFT_JIS_E6_BD_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_BD */
  /* used from to_EUC_JP_E6_BD */
     17,  0, 17, 17, 17,  1, 17, 17,   17, 17, 17, 17, 17, 17, 17, 17,
     17, 17, 17, 17,  2, 17, 17, 17,    3, 17, 17,  4,  5, 17, 17,  6,
     17, 17, 17, 17,  7, 17,  8, 17,   17, 17, 17, 17, 17,  9, 10, 11,
     12, 17, 17, 17, 13, 17, 17, 17,   14, 17, 15, 17, 16, 17, 17, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_BD_infos[18] = {
     o2(0x9F,0xF1), o2(0x8A,0xC1), o2(0x8C,0x89), o2(0xE0,0x4E),
     o2(0xE0,0x49), o2(0x90,0xF6), o2(0x8A,0x83), o2(0x8F,0x81),
     o2(0xE0,0x52), o2(0xE0,0x4B), o2(0x92,0xAA), o2(0xE0,0x48),
     o2(0x92,0xD7), o2(0xE0,0x6B), o2(0xE0,0x45), o2(0xE0,0x44),
     o2(0xE0,0x4D),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_BD = {
    to_SHIFT_JIS_E6_BD_offsets,
    to_SHIFT_JIS_E6_BD_infos
};

static const unsigned char
to_SHIFT_JIS_E6_BE_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_BE */
  /* used from to_EUC_JP_E6_BE */
      0,  1,  2, 17,  3, 17,  4, 17,    5, 17, 17, 17, 17, 17,  6, 17,
     17,  7, 17, 17, 17, 17, 17,  8,   17, 17, 17, 17, 17, 17, 17, 17,
     17,  9, 17, 10, 11, 17, 17, 17,   17, 17, 12, 17, 17, 17, 17, 17,
     17, 13, 17, 14, 17, 15, 17, 17,   17, 16, 17, 17, 17, 17, 17, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_BE_infos[18] = {
     o2(0xE0,0x47), o2(0xE0,0x46), o2(0xE0,0x4C), o2(0x90,0x9F),
     o2(0xE0,0x43), o2(0xFB,0x4B), o2(0xE0,0x4F), o2(0xE0,0x50),
     o2(0x8A,0xC0), o2(0xE0,0x55), o2(0xE0,0x54), o2(0xE0,0x56),
     o2(0xE0,0x59), o2(0x93,0x62), o2(0xE0,0x53), o2(0xFB,0x4C),
     o2(0xE0,0x57),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_BE = {
    to_SHIFT_JIS_E6_BE_offsets,
    to_SHIFT_JIS_E6_BE_infos
};

static const unsigned char
to_SHIFT_JIS_E6_BF_offsets[64] = {
  /* used from to_SHIFT_JIS_E6_BF */
  /* used from to_EUC_JP_E6_BF */
      0,  1,  2,  3, 23, 23,  4, 23,   23, 23, 23, 23, 23, 23, 23, 23,
     23, 23, 23, 23,  5,  6, 23, 23,    7, 23, 23,  8, 23, 23, 23,  9,
     10, 11, 23, 23, 12, 23, 23, 23,   23, 23, 23, 13, 14, 23, 15, 16,
     23, 17, 23, 18, 23, 19, 20, 23,   23, 23, 21, 23, 23, 23, 22, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E6_BF_infos[24] = {
     o2(0x8C,0x83), o2(0x91,0xF7), o2(0xE0,0x51), o2(0x94,0x5A),
     o2(0xE0,0x58), o2(0xE0,0x5D), o2(0xE0,0x5B), o2(0xE0,0x5E),
     o2(0xE0,0x61), o2(0xE0,0x5A), o2(0x8D,0x8A), o2(0x94,0x47),
     o2(0x9F,0xB7), o2(0x97,0x94), o2(0xE0,0x5C), o2(0xE0,0x60),
     o2(0x91,0xF3), o2(0xE0,0x5F), o2(0xE0,0x4A), o2(0xFB,0x4D),
     o2(0xE8,0x89), o2(0xE0,0x64), o2(0xE0,0x68),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6_BF = {
    to_SHIFT_JIS_E6_BF_offsets,
    to_SHIFT_JIS_E6_BF_infos
};

static const struct byte_lookup* const
to_SHIFT_JIS_E6_infos[64] = {
     &to_SHIFT_JIS_E6_80, &to_SHIFT_JIS_E6_81,
     &to_SHIFT_JIS_E6_82, &to_SHIFT_JIS_E6_83,
     &to_SHIFT_JIS_E6_84, &to_SHIFT_JIS_E6_85,
     &to_SHIFT_JIS_E6_86, &to_SHIFT_JIS_E6_87,
     &to_SHIFT_JIS_E6_88, &to_SHIFT_JIS_E6_89,
     &to_SHIFT_JIS_E6_8A, &to_SHIFT_JIS_E6_8B,
     &to_SHIFT_JIS_E6_8C, &to_SHIFT_JIS_E6_8D,
     &to_SHIFT_JIS_E6_8E, &to_SHIFT_JIS_E6_8F,
     &to_SHIFT_JIS_E6_90, &to_SHIFT_JIS_E6_91,
     &to_SHIFT_JIS_E6_92, &to_SHIFT_JIS_E6_93,
     &to_SHIFT_JIS_E6_94, &to_SHIFT_JIS_E6_95,
     &to_SHIFT_JIS_E6_96, &to_SHIFT_JIS_E6_97,
     &to_SHIFT_JIS_E6_98, &to_SHIFT_JIS_E6_99,
     &to_SHIFT_JIS_E6_9A, &to_SHIFT_JIS_E6_9B,
     &to_SHIFT_JIS_E6_9C, &to_SHIFT_JIS_E6_9D,
     &to_SHIFT_JIS_E6_9E, &to_SHIFT_JIS_E6_9F,
     &to_SHIFT_JIS_E6_A0, &to_SHIFT_JIS_E6_A1,
     &to_SHIFT_JIS_E6_A2, &to_SHIFT_JIS_E6_A3,
     &to_SHIFT_JIS_E6_A4, &to_SHIFT_JIS_E6_A5,
     &to_SHIFT_JIS_E6_A6, &to_SHIFT_JIS_E6_A7,
     &to_SHIFT_JIS_E6_A8, &to_SHIFT_JIS_E6_A9,
     &to_SHIFT_JIS_E6_AA, &to_SHIFT_JIS_E6_AB,
     &to_SHIFT_JIS_E6_AC, &to_SHIFT_JIS_E6_AD,
     &to_SHIFT_JIS_E6_AE, &to_SHIFT_JIS_E6_AF,
     &to_SHIFT_JIS_E6_B0, &to_SHIFT_JIS_E6_B1,
     &to_SHIFT_JIS_E6_B2, &to_SHIFT_JIS_E6_B3,
     &to_SHIFT_JIS_E6_B4, &to_SHIFT_JIS_E6_B5,
     &to_SHIFT_JIS_E6_B6, &to_SHIFT_JIS_E6_B7,
     &to_SHIFT_JIS_E6_B8, &to_SHIFT_JIS_E6_B9,
     &to_SHIFT_JIS_E6_BA, &to_SHIFT_JIS_E6_BB,
     &to_SHIFT_JIS_E6_BC, &to_SHIFT_JIS_E6_BD,
     &to_SHIFT_JIS_E6_BE, &to_SHIFT_JIS_E6_BF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E6 = {
    to_SHIFT_JIS_E5_offsets,
    to_SHIFT_JIS_E6_infos
};

static const unsigned char
to_SHIFT_JIS_E7_80_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_80 */
  /* used from to_EUC_JP_E7_80 */
     21,  0, 21, 21, 21,  1, 21,  2,   21,  3, 21,  4, 21, 21, 21,  5,
     21,  6, 21, 21, 21,  7, 21, 21,    8, 21,  9, 10, 21, 11, 12, 13,
     21, 21, 21, 21, 21, 21, 14, 15,   16, 21, 21, 21, 17, 21, 21, 21,
     18, 21, 19, 21, 21, 21, 21, 21,   21, 21, 21, 21, 21, 21, 20, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_80_infos[22] = {
     o2(0xE0,0x66), o2(0xFB,0x4E), o2(0xFB,0x4F), o2(0xE0,0x62),
     o2(0xE0,0x63), o2(0xE0,0x67), o2(0xE0,0x65), o2(0x95,0x6D),
     o2(0xE0,0x6D), o2(0xE0,0x6A), o2(0xE0,0x69), o2(0xE0,0x6C),
     o2(0x93,0xD2), o2(0xE0,0x6E), o2(0x92,0x95), o2(0x91,0xEB),
     o2(0xFB,0x50), o2(0x90,0xA3), o2(0xE0,0x6F), o2(0xE0,0x71),
     o2(0xE0,0x70),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_80 = {
    to_SHIFT_JIS_E7_80_offsets,
    to_SHIFT_JIS_E7_80_infos
};

static const unsigned char
to_SHIFT_JIS_E7_81_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_81 */
  /* used from to_EUC_JP_E7_81 */
     10, 10, 10, 10, 10, 10, 10, 10,   10, 10, 10, 10,  0, 10, 10, 10,
     10,  1, 10, 10, 10, 10, 10, 10,    2, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10,  3, 10, 10, 10, 10,   10, 10, 10,  4, 10, 10, 10,  5,
      6, 10, 10, 10, 10, 10, 10, 10,    7, 10, 10, 10,  8,  9, 10, 10,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_81_infos[11] = {
     o2(0x9F,0xF3), o2(0xE0,0x72), o2(0x93,0xE5), o2(0xE0,0x73),
     o2(0x89,0xCE), o2(0x93,0x94), o2(0x8A,0x44), o2(0x8B,0x84),
     o2(0x8E,0xDC), o2(0x8D,0xD0),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_81 = {
    to_SHIFT_JIS_E7_81_offsets,
    to_SHIFT_JIS_E7_81_infos
};

static const unsigned char
to_SHIFT_JIS_E7_82_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_82 */
  /* used from to_EUC_JP_E7_82 */
     16, 16, 16, 16, 16,  0, 16, 16,   16,  1,  2, 16, 16, 16,  3, 16,
     16, 16,  4, 16, 16, 16, 16, 16,   16,  5, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16,  6,  7,  8,  9, 10,
     16, 16, 16, 11, 16, 16, 16, 16,   12, 13, 14, 15, 16, 16, 16, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_82_infos[17] = {
     o2(0xFB,0x51), o2(0x98,0x46), o2(0x90,0x86), o2(0x89,0x8A),
     o2(0xE0,0x75), o2(0xE0,0x74), o2(0xFB,0x52), o2(0xE0,0x78),
     o2(0x92,0x59), o2(0xE0,0x7B), o2(0xE0,0x76), o2(0xE0,0x7A),
     o2(0xE0,0x79), o2(0x93,0x5F), o2(0x88,0xD7), o2(0xFA,0x62),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_82 = {
    to_SHIFT_JIS_E7_82_offsets,
    to_SHIFT_JIS_E7_82_infos
};

static const unsigned char
to_SHIFT_JIS_E7_83_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_83 */
  /* used from to_EUC_JP_E7_83 */
      9,  9,  9,  9,  9,  9,  9,  9,    0,  9,  9,  1,  9,  9,  9,  2,
      9,  9,  9,  9,  9,  9,  9,  9,    9,  3,  9,  9,  9,  4,  9,  5,
      9,  9,  9,  9,  9,  9,  9,  9,    9,  9,  9,  9,  9,  9,  9,  9,
      9,  6,  9,  9,  9,  9,  9,  9,    9,  7,  9,  9,  9,  8,  9,  9,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_83_infos[10] = {
     o2(0x97,0xF3), o2(0xE0,0x7D), o2(0x89,0x47), o2(0xE0,0x80),
     o2(0xE0,0x7E), o2(0xE0,0x7C), o2(0xE0,0x77), o2(0x96,0x42),
     o2(0xE0,0x82),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_83 = {
    to_SHIFT_JIS_E7_83_offsets,
    to_SHIFT_JIS_E7_83_infos
};

static const unsigned char
to_SHIFT_JIS_E7_84_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_84 */
  /* used from to_EUC_JP_E7_84 */
     11, 11, 11, 11,  0, 11, 11, 11,   11,  1, 11, 11, 11, 11, 11,  2,
     11, 11, 11, 11,  3, 11, 11, 11,   11,  4,  5, 11,  6, 11, 11, 11,
     11,  7, 11, 11, 11, 11,  8, 11,   11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11,  9, 11,   11, 11, 11, 11, 10, 11, 11, 11,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_84_infos[12] = {
     o2(0xFB,0x54), o2(0xE0,0x81), o2(0xFB,0x53), o2(0x89,0x8B),
     o2(0xE0,0x84), o2(0x95,0xB0), o2(0xE0,0x83), o2(0x96,0xB3),
     o2(0x8F,0xC5), o2(0x91,0x52), o2(0x8F,0xC4),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_84 = {
    to_SHIFT_JIS_E7_84_offsets,
    to_SHIFT_JIS_E7_84_infos
};

static const unsigned char
to_SHIFT_JIS_E7_85_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_85 */
  /* used from to_EUC_JP_E7_85 */
     18, 18, 18, 18, 18, 18,  0,  1,   18,  2, 18, 18,  3, 18,  4, 18,
     18, 18, 18, 18, 18,  5,  6, 18,   18,  7, 18, 18,  8, 18, 18, 18,
     18, 18,  9, 18, 10, 11, 12, 13,   18, 14, 18, 18, 15, 18, 16, 18,
     18, 18, 18, 18, 18, 18, 18, 18,   18, 18, 18, 18, 18, 17, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_85_infos[19] = {
     o2(0xFB,0x56), o2(0xFB,0x57), o2(0x97,0xF9), o2(0xE0,0x8A),
     o2(0x90,0xF7), o2(0xE0,0x86), o2(0xE0,0x8B), o2(0x89,0x8C),
     o2(0xFB,0x55), o2(0xE0,0x89), o2(0x94,0x81), o2(0xE0,0x85),
     o2(0xE0,0x88), o2(0x8F,0xC6), o2(0x94,0xCF), o2(0xE0,0x8C),
     o2(0x8E,0xCF), o2(0x90,0xF8),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_85 = {
    to_SHIFT_JIS_E7_85_offsets,
    to_SHIFT_JIS_E7_85_infos
};

static const unsigned char
to_SHIFT_JIS_E7_86_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_86 */
  /* used from to_EUC_JP_E7_86 */
     13, 13, 13, 13,  0, 13, 13, 13,    1, 13,  2, 13, 13, 13, 13,  3,
     13, 13, 13, 13,  4,  5, 13, 13,   13,  6, 13, 13, 13, 13, 13,  7,
     13, 13, 13, 13, 13, 13, 13, 13,    8, 13, 13, 13,  9, 13, 13, 13,
     13, 10, 13, 13, 13, 13, 13, 13,   13, 11, 13, 13, 13, 13, 12, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_86_infos[14] = {
     o2(0xE0,0x8F), o2(0xE0,0x87), o2(0x8C,0x46), o2(0xE0,0x8D),
     o2(0x97,0x6F), o2(0xE0,0x90), o2(0xEA,0xA4), o2(0x8F,0x6E),
     o2(0xE0,0x91), o2(0xE0,0x92), o2(0x94,0x4D), o2(0xE0,0x94),
     o2(0xE0,0x95),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_86 = {
    to_SHIFT_JIS_E7_86_offsets,
    to_SHIFT_JIS_E7_86_infos
};

static const unsigned char
to_SHIFT_JIS_E7_87_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_87 */
  /* used from to_EUC_JP_E7_87 */
     24,  0, 24,  1, 24, 24, 24, 24,    2,  3, 24, 24, 24, 24,  4, 24,
      5, 24,  6, 24,  7,  8, 24,  9,   24, 24, 24, 24, 24, 24, 24, 10,
     11, 24, 24, 24, 24, 12, 13, 14,   24, 24, 24, 24, 15, 16, 17, 24,
     24, 24, 24, 24, 24, 18, 24, 24,   24, 19, 24, 20, 21, 24, 22, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_87_infos[25] = {
     o2(0xFB,0x59), o2(0x94,0x52), o2(0x93,0x95), o2(0xE0,0x97),
     o2(0xE0,0x99), o2(0x97,0xD3), o2(0xE0,0x96), o2(0xE0,0x98),
     o2(0x89,0x8D), o2(0xE0,0x93), o2(0x9A,0x7A), o2(0xE0,0x9A),
     o2(0x91,0x87), o2(0x8E,0x57), o2(0xE0,0x9C), o2(0xE0,0x9B),
     o2(0x90,0x43), o2(0x99,0xD7), o2(0xE0,0x9D), o2(0xE0,0x9F),
     o2(0xE0,0x8E), o2(0xE0,0x9E), o2(0xFB,0x5A), o2(0xE0,0xA0),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_87 = {
    to_SHIFT_JIS_E7_87_offsets,
    to_SHIFT_JIS_E7_87_infos
};

static const unsigned char
to_SHIFT_JIS_E7_88_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_88 */
  /* used from to_EUC_JP_E7_88 */
     18, 18, 18, 18, 18, 18,  0, 18,   18, 18, 18, 18, 18,  1, 18, 18,
      2, 18, 18, 18, 18, 18, 18, 18,   18, 18, 18,  3, 18, 18, 18, 18,
     18, 18, 18, 18, 18, 18, 18, 18,    4, 18,  5, 18,  6,  7, 18, 18,
      8, 18,  9, 18, 18, 10, 11, 18,   18, 18, 12, 13, 14, 15, 16, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_88_infos[19] = {
     o2(0x94,0x9A), o2(0xE0,0xA1), o2(0xE0,0xA2), o2(0xE0,0xA3),
     o2(0xE0,0xA4), o2(0x92,0xDC), o2(0xE0,0xA6), o2(0xE0,0xA5),
     o2(0xE0,0xA7), o2(0xE0,0xA8), o2(0x8E,0xDD), o2(0x95,0x83),
     o2(0x96,0xEA), o2(0xE0,0xA9), o2(0xE0,0xAA), o2(0x91,0x75),
     o2(0x8E,0xA2), o2(0xE0,0xAB),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_88 = {
    to_SHIFT_JIS_E7_88_offsets,
    to_SHIFT_JIS_E7_88_infos
};

static const unsigned char
to_SHIFT_JIS_E7_89_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_89 */
  /* used from to_EUC_JP_E7_89 */
      0, 21, 21, 21, 21, 21,  1,  2,    3, 21, 21,  4,  5, 21, 21, 21,
     21, 21,  6, 21, 21, 21, 21, 21,    7,  8, 21,  9, 21, 10, 21, 11,
     21, 12, 13, 21, 21, 21, 21, 14,   21, 15, 21, 21, 21, 21, 21, 21,
     21, 21, 16, 21, 17, 21, 21, 21,   21, 18, 21, 21, 21, 19, 20, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_89_infos[22] = {
     o2(0xE0,0xAC), o2(0xE0,0xAD), o2(0x95,0xD0), o2(0x94,0xC5),
     o2(0xE0,0xAE), o2(0x94,0x76), o2(0x92,0xAB), o2(0xE0,0xAF),
     o2(0x89,0xE5), o2(0x8B,0x8D), o2(0x96,0xC4), o2(0x96,0xB4),
     o2(0x89,0xB2), o2(0x98,0x53), o2(0x96,0x71), o2(0x95,0xA8),
     o2(0x90,0xB5), o2(0xE0,0xB0), o2(0x93,0xC1), o2(0x8C,0xA1),
     o2(0xE0,0xB1),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_89 = {
    to_SHIFT_JIS_E7_89_offsets,
    to_SHIFT_JIS_E7_89_infos
};

static const unsigned char
to_SHIFT_JIS_E7_8A_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_8A */
  /* used from to_EUC_JP_E7_8A */
      0,  1,  2, 16, 16, 16, 16,  3,   16, 16, 16, 16, 16, 16, 16, 16,
     16, 16,  4, 16, 16, 16,  5, 16,   16, 16, 16, 16, 16, 16, 16, 16,
      6, 16,  7, 16, 16, 16, 16,  8,   16, 16, 16, 16,  9, 16, 16, 10,
     16, 11, 12, 16, 16, 16, 13, 16,   16, 14, 16, 16, 16, 16, 15, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_8A_infos[17] = {
     o2(0x8D,0xD2), o2(0xE0,0xB3), o2(0xE0,0xB2), o2(0xE0,0xB4),
     o2(0xE0,0xB5), o2(0xE0,0xB6), o2(0x8B,0x5D), o2(0xE0,0xB7),
     o2(0xE0,0xB8), o2(0x8C,0xA2), o2(0x94,0xC6), o2(0xFB,0x5B),
     o2(0xE0,0xBA), o2(0x8F,0xF3), o2(0xE0,0xB9), o2(0xFB,0x5C),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_8A = {
    to_SHIFT_JIS_E7_8A_offsets,
    to_SHIFT_JIS_E7_8A_infos
};

static const unsigned char
to_SHIFT_JIS_E7_8B_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_8B */
  /* used from to_EUC_JP_E7_8B */
     21, 21,  0,  1,  2, 21,  3, 21,   21, 21, 21, 21, 21, 21,  4, 21,
      5, 21,  6, 21, 21, 21, 21,  7,   21,  8, 21,  9, 21, 21, 21, 21,
     10, 11, 12, 21, 21, 21, 21, 21,   21, 13, 21, 21, 14, 15, 21, 21,
     21, 21, 21, 21, 21, 21, 21, 16,   17, 18, 21, 21, 19, 20, 21, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_8B_infos[22] = {
     o2(0x8B,0xB6), o2(0xE0,0xBB), o2(0xE0,0xBD), o2(0xE0,0xBC),
     o2(0xE0,0xBE), o2(0x8C,0xCF), o2(0xE0,0xBF), o2(0x8B,0xE7),
     o2(0x91,0x5F), o2(0x8D,0x9D), o2(0xE0,0xC1), o2(0xE0,0xC2),
     o2(0xE0,0xC0), o2(0x8E,0xEB), o2(0x93,0xC6), o2(0x8B,0xB7),
     o2(0xE0,0xC4), o2(0x92,0x4B), o2(0xE0,0xC3), o2(0x98,0x54),
     o2(0x94,0x82),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_8B = {
    to_SHIFT_JIS_E7_8B_offsets,
    to_SHIFT_JIS_E7_8B_infos
};

static const unsigned char
to_SHIFT_JIS_E7_8C_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_8C */
  /* used from to_EUC_JP_E7_8C */
     19, 19, 19, 19, 19, 19, 19, 19,   19, 19,  0, 19, 19, 19, 19, 19,
     19, 19, 19, 19, 19, 19,  1,  2,   19, 19, 19,  3,  4,  5, 19,  6,
     19, 19, 19, 19,  7,  8, 19, 19,   19,  9, 10, 11, 19, 19, 12, 13,
     19, 19, 19, 19, 14, 19, 15, 16,   19, 19, 19, 19, 19, 19, 17, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_8C_infos[20] = {
     o2(0xE0,0xC7), o2(0xE0,0xC9), o2(0xE0,0xC6), o2(0x96,0xD2),
     o2(0xE0,0xC8), o2(0xE0,0xCA), o2(0x97,0xC2), o2(0xFB,0x5D),
     o2(0xE0,0xCE), o2(0xE0,0xCD), o2(0x92,0x96), o2(0x94,0x4C),
     o2(0x8C,0xA3), o2(0xE0,0xCC), o2(0xE0,0xCB), o2(0x97,0x50),
     o2(0x97,0x51), o2(0xE0,0xCF), o2(0x89,0x8E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_8C = {
    to_SHIFT_JIS_E7_8C_offsets,
    to_SHIFT_JIS_E7_8C_infos
};

static const unsigned char
to_SHIFT_JIS_E7_8D_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_8D */
  /* used from to_EUC_JP_E7_8D */
     15, 15, 15, 15,  0,  1, 15, 15,   15, 15, 15, 15, 15, 15,  2,  3,
     15, 15, 15, 15, 15, 15, 15,  4,   15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15,  5, 15, 15, 15, 15,    6, 15,  7, 15, 15, 15, 15, 15,
      8, 15,  9, 15, 15, 10, 15, 11,   12, 15, 13, 14, 15, 15, 15, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_8D_infos[16] = {
     o2(0x8D,0x96), o2(0x8E,0x82), o2(0xE0,0xD0), o2(0xE0,0xD1),
     o2(0xE0,0xD3), o2(0x8F,0x62), o2(0xE0,0xD5), o2(0xE0,0xD4),
     o2(0xE0,0xD6), o2(0x8A,0x6C), o2(0xE0,0xD8), o2(0xFB,0x5F),
     o2(0xE0,0xD7), o2(0xE0,0xDA), o2(0xE0,0xD9),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_8D = {
    to_SHIFT_JIS_E7_8D_offsets,
    to_SHIFT_JIS_E7_8D_infos
};

static const unsigned char
to_SHIFT_JIS_E7_8E_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_8E */
  /* used from to_EUC_JP_E7_8E */
     10, 10, 10, 10,  0, 10, 10,  1,   10,  2, 10,  3, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10,  4, 10,   10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,   10,  5, 10, 10, 10, 10, 10, 10,
     10, 10,  6,  7, 10, 10, 10, 10,   10, 10, 10,  8, 10,  9, 10, 10,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_8E_infos[11] = {
     o2(0x8C,0xBA), o2(0x97,0xA6), o2(0x8B,0xCA), o2(0x89,0xA4),
     o2(0x8B,0xE8), o2(0x8A,0xDF), o2(0x97,0xE6), o2(0xE0,0xDC),
     o2(0xE0,0xDE), o2(0xFB,0x60),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_8E = {
    to_SHIFT_JIS_E7_8E_offsets,
    to_SHIFT_JIS_E7_8E_infos
};

static const unsigned char
to_SHIFT_JIS_E7_8F_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_8F */
  /* used from to_EUC_JP_E7_8F */
      0, 20,  1, 20, 20, 20, 20, 20,    2,  3,  4, 20, 20,  5,  6, 20,
     20, 20,  7, 20, 20, 20,  8, 20,   20, 20, 20, 20, 20, 20,  9, 20,
     10, 20, 20, 11, 20, 12, 20, 20,   20, 20, 13, 20, 20, 14, 15, 20,
     20, 16, 20, 20, 20, 17, 20, 20,   18, 20, 20, 20, 20, 20, 19, 20,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_8F_infos[21] = {
     o2(0xE0,0xDF), o2(0x89,0xCF), o2(0xE0,0xDB), o2(0xFB,0x61),
     o2(0x8E,0x58), o2(0x92,0xBF), o2(0xE0,0xDD), o2(0xFB,0x64),
     o2(0xFB,0x62), o2(0xE0,0xE2), o2(0x8E,0xEC), o2(0xFB,0x63),
     o2(0xE0,0xE0), o2(0x8C,0x5D), o2(0x94,0xC7), o2(0xE0,0xE1),
     o2(0xE0,0xFC), o2(0xFB,0x66), o2(0xE0,0xE7), o2(0x8C,0xBB),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_8F = {
    to_SHIFT_JIS_E7_8F_offsets,
    to_SHIFT_JIS_E7_8F_infos
};

static const unsigned char
to_SHIFT_JIS_E7_90_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_90 */
  /* used from to_EUC_JP_E7_90 */
     18, 18, 18,  0, 18,  1,  2,  3,   18,  4, 18, 18, 18, 18, 18, 18,
     18, 18, 18, 18, 18, 18, 18, 18,   18, 18, 18, 18, 18, 18, 18, 18,
     18, 18,  5, 18, 18,  6,  7, 18,   18,  8,  9, 18, 18, 18, 10, 18,
     18, 18, 11, 12, 13, 14, 15, 18,   18, 18, 16, 18, 18, 18, 18, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_90_infos[19] = {
     o2(0x8B,0x85), o2(0xE0,0xE4), o2(0x97,0x9D), o2(0xFB,0x65),
     o2(0x97,0xAE), o2(0x91,0xF4), o2(0xE0,0xE6), o2(0xFB,0x67),
     o2(0xFB,0x69), o2(0xFB,0x68), o2(0xFB,0x6A), o2(0xE0,0xE8),
     o2(0x97,0xD4), o2(0x8B,0xD5), o2(0x94,0xFA), o2(0x94,0x69),
     o2(0xE0,0xE9), o2(0xE0,0xEB),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_90 = {
    to_SHIFT_JIS_E7_90_offsets,
    to_SHIFT_JIS_E7_90_infos
};

static const unsigned char
to_SHIFT_JIS_E7_91_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_91 */
  /* used from to_EUC_JP_E7_91 */
     19,  0, 19, 19, 19, 19, 19, 19,   19, 19, 19, 19, 19, 19, 19, 19,
     19, 19, 19, 19, 19,  1, 19, 19,   19,  2,  3,  4,  5, 19,  6,  7,
      8, 19,  9, 10, 11, 19, 19, 19,   19, 12, 13, 19, 19, 19, 19, 14,
     15, 19, 19, 16, 19, 19, 17, 19,   19, 19, 19, 19, 19, 19, 18, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_91_infos[20] = {
     o2(0xE0,0xEE), o2(0xE0,0xEA), o2(0xE0,0xED), o2(0x8C,0xE8),
     o2(0x89,0x6C), o2(0xE0,0xEF), o2(0x90,0x90), o2(0xE0,0xEC),
     o2(0x97,0xDA), o2(0xFB,0x6B), o2(0xE0,0xF2), o2(0xEA,0xA2),
     o2(0xE0,0xF0), o2(0xE0,0xF3), o2(0xE0,0xE5), o2(0xE0,0xF1),
     o2(0x8D,0xBA), o2(0xE0,0xF4), o2(0xE0,0xF5),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_91 = {
    to_SHIFT_JIS_E7_91_offsets,
    to_SHIFT_JIS_E7_91_infos
};

static const unsigned char
to_SHIFT_JIS_E7_92_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_92 */
  /* used from to_EUC_JP_E7_92 */
      9,  9,  9,  0,  9,  9,  9,  9,    9,  1,  9,  2,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,    9,  9,  9,  9,  9,  9,  3,  4,
      9,  9,  5,  9,  9,  9,  9,  6,    9,  9,  9,  9,  9,  9,  9,  9,
      7,  9,  9,  9,  9,  9,  9,  9,    9,  9,  9,  9,  9,  8,  9,  9,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_92_infos[10] = {
     o2(0x97,0x9E), o2(0xFB,0x6C), o2(0xE0,0xF6), o2(0xE0,0xF7),
     o2(0xFB,0x6D), o2(0xE0,0xE3), o2(0xE0,0xF8), o2(0x8A,0xC2),
     o2(0x8E,0xA3),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_92 = {
    to_SHIFT_JIS_E7_92_offsets,
    to_SHIFT_JIS_E7_92_infos
};

static const unsigned char
to_SHIFT_JIS_E7_93_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_93 */
  /* used from to_EUC_JP_E7_93 */
     17, 17, 17, 17, 17, 17, 17, 17,   17, 17,  0, 17, 17, 17, 17,  1,
     17, 17, 17, 17,  2, 17, 17, 17,   17, 17, 17, 17,  3, 17, 17, 17,
      4, 17,  5,  6, 17, 17,  7,  8,   17,  9, 17, 17, 17, 17, 10, 17,
     11, 12, 13, 17, 17, 17, 14, 15,   16, 17, 17, 17, 17, 17, 17, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_93_infos[18] = {
     o2(0xE0,0xF9), o2(0xE0,0xFA), o2(0xE0,0xFB), o2(0x89,0x5A),
     o2(0xE1,0x40), o2(0x95,0x5A), o2(0xE1,0x41), o2(0x8A,0xA2),
     o2(0xE1,0x42), o2(0xE1,0x43), o2(0xE1,0x44), o2(0xE1,0x46),
     o2(0xE1,0x47), o2(0xE1,0x45), o2(0x95,0x72), o2(0xE1,0x49),
     o2(0xE1,0x48),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_93 = {
    to_SHIFT_JIS_E7_93_offsets,
    to_SHIFT_JIS_E7_93_infos
};

static const unsigned char
to_SHIFT_JIS_E7_94_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_94 */
  /* used from to_EUC_JP_E7_94 */
     31,  0, 31,  1,  2,  3, 31, 31,   31, 31, 31, 31,  4,  5,  6, 31,
     31,  7, 31,  8, 31,  9, 31, 31,   10, 31, 11, 31, 12, 31, 13, 14,
     31, 31, 31, 15, 31, 16, 17, 31,   18, 31, 31, 19, 20, 31, 31, 21,
     22, 23, 24, 25, 31, 31, 31, 26,   27, 31, 28, 29, 30, 31, 31, 31,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_94_infos[32] = {
     o2(0xFB,0x6E), o2(0xE1,0x4B), o2(0xE1,0x4A), o2(0xE1,0x4C),
     o2(0xE1,0x4D), o2(0xE1,0x4F), o2(0xE1,0x4E), o2(0x8D,0x99),
     o2(0xE1,0x51), o2(0xE1,0x50), o2(0x8A,0xC3), o2(0x90,0x72),
     o2(0x93,0x5B), o2(0xE1,0x52), o2(0x90,0xB6), o2(0x8E,0x59),
     o2(0x89,0x99), o2(0xE1,0x53), o2(0x97,0x70), o2(0x95,0xE1),
     o2(0xE1,0x54), o2(0xFA,0xA8), o2(0x93,0x63), o2(0x97,0x52),
     o2(0x8D,0x62), o2(0x90,0x5C), o2(0x92,0x6A), o2(0x99,0xB2),
     o2(0x92,0xAC), o2(0x89,0xE6), o2(0xE1,0x55),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_94 = {
    to_SHIFT_JIS_E7_94_offsets,
    to_SHIFT_JIS_E7_94_infos
};

static const unsigned char
to_SHIFT_JIS_E7_95_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_95 */
  /* used from to_EUC_JP_E7_95 */
     33, 33, 33, 33,  0, 33,  1, 33,   33,  2,  3,  4,  5,  6, 33,  7,
     33,  8, 33, 33,  9, 33, 33, 33,   33, 10, 11, 12, 13, 14, 33, 33,
     15, 33, 16, 33, 17, 18, 19, 20,   33, 21, 22, 23, 33, 24, 33, 25,
     26, 33, 33, 27, 28, 33, 29, 30,   31, 33, 33, 33, 33, 33, 33, 32,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_95_infos[34] = {
     o2(0xE1,0x56), o2(0xE1,0x5B), o2(0xE1,0x59), o2(0xE1,0x58),
     o2(0x9D,0xC0), o2(0x8A,0x45), o2(0xE1,0x57), o2(0x88,0xD8),
     o2(0x94,0xA8), o2(0x94,0xC8), o2(0x97,0xAF), o2(0xE1,0x5C),
     o2(0xE1,0x5A), o2(0x92,0x7B), o2(0x90,0xA4), o2(0x94,0xA9),
     o2(0x95,0x4C), o2(0xE1,0x5E), o2(0x97,0xAA), o2(0x8C,0x6C),
     o2(0xE1,0x5F), o2(0xE1,0x5D), o2(0x94,0xD4), o2(0xE1,0x60),
     o2(0xE1,0x61), o2(0xFB,0x6F), o2(0x88,0xD9), o2(0x8F,0xF4),
     o2(0xE1,0x66), o2(0xE1,0x63), o2(0x93,0xEB), o2(0xE1,0x62),
     o2(0x8B,0x45),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_95 = {
    to_SHIFT_JIS_E7_95_offsets,
    to_SHIFT_JIS_E7_95_infos
};

static const unsigned char
to_SHIFT_JIS_E7_96_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_96 */
  /* used from to_EUC_JP_E7_96 */
     24, 24,  0, 24, 24, 24,  1,  2,   24,  3,  4,  5, 24, 24,  6,  7,
     24,  8, 24, 24,  9, 24, 24, 24,   24, 24, 10, 24, 24, 11, 24, 24,
     24, 24, 24, 12, 24, 13, 24, 24,   24, 24, 24, 14, 24, 24, 24, 24,
     24, 15, 16, 17, 24, 18, 24, 24,   19, 20, 24, 24, 21, 22, 23, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_96_infos[25] = {
     o2(0xE1,0x69), o2(0xE1,0x64), o2(0xE1,0x65), o2(0xE1,0x68),
     o2(0xE1,0x67), o2(0x95,0x44), o2(0x91,0x61), o2(0x91,0x60),
     o2(0x8B,0x5E), o2(0xE1,0x6A), o2(0xE1,0x6B), o2(0xE1,0x6C),
     o2(0xE1,0x6E), o2(0xE1,0x6D), o2(0x89,0x75), o2(0xE1,0x76),
     o2(0x94,0xE6), o2(0xE1,0x70), o2(0xE1,0x72), o2(0xE1,0x74),
     o2(0x90,0x5D), o2(0xE1,0x75), o2(0xE1,0x73), o2(0x8E,0xBE),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_96 = {
    to_SHIFT_JIS_E7_96_offsets,
    to_SHIFT_JIS_E7_96_infos
};

static const unsigned char
to_SHIFT_JIS_E7_97_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_97 */
  /* used from to_EUC_JP_E7_97 */
     24, 24,  0,  1, 24,  2, 24,  3,   24, 24,  4, 24, 24,  5, 24, 24,
     24, 24,  6, 24,  7,  8, 24, 24,    9, 10, 24, 11, 24, 24, 12, 24,
     24, 24, 13, 14, 24, 24, 24, 24,   24, 15, 24, 24, 24, 24, 24, 24,
     16, 24, 17, 18, 19, 24, 24, 24,   24, 24, 20, 24, 21, 24, 22, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_97_infos[25] = {
     o2(0xE1,0x6F), o2(0xE1,0x71), o2(0x95,0x61), o2(0x8F,0xC7),
     o2(0xE1,0x78), o2(0xE1,0x77), o2(0xE1,0x79), o2(0x8E,0xA4),
     o2(0x8D,0xAD), o2(0x93,0x97), o2(0xE1,0x7A), o2(0x92,0xC9),
     o2(0xE1,0x7C), o2(0x97,0x9F), o2(0xE1,0x7B), o2(0x91,0x89),
     o2(0xE1,0x82), o2(0xE1,0x84), o2(0xE1,0x85), o2(0x92,0x73),
     o2(0xE1,0x83), o2(0xE1,0x80), o2(0xE1,0x7D), o2(0xE1,0x7E),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_97 = {
    to_SHIFT_JIS_E7_97_offsets,
    to_SHIFT_JIS_E7_97_infos
};

static const unsigned char
to_SHIFT_JIS_E7_98_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_98 */
  /* used from to_EUC_JP_E7_98 */
     13,  0, 13, 13, 13, 13, 13, 13,   13,  1, 13,  2, 13,  3, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,   13, 13, 13, 13, 13, 13, 13,  4,
      5,  6,  7, 13,  8, 13, 13,  9,   13, 13, 13, 13, 13, 13, 13, 13,
     10, 13, 13, 13, 11, 13, 13, 13,   13, 13, 13, 12, 13, 13, 13, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_98_infos[14] = {
     o2(0xE1,0x81), o2(0xE1,0x88), o2(0xE1,0x86), o2(0xE1,0x87),
     o2(0xE1,0x89), o2(0xE1,0x8B), o2(0xE1,0x8C), o2(0xE1,0x8D),
     o2(0xE1,0x8E), o2(0xE1,0x8A), o2(0xE1,0x90), o2(0xE1,0x8F),
     o2(0xE1,0x91),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_98 = {
    to_SHIFT_JIS_E7_98_offsets,
    to_SHIFT_JIS_E7_98_infos
};

static const unsigned char
to_SHIFT_JIS_E7_99_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_99 */
  /* used from to_EUC_JP_E7_99 */
     25, 25,  0, 25, 25, 25,  1,  2,    3, 25, 25, 25,  4, 25, 25, 25,
     25, 25,  5, 25, 25, 25,  6, 25,    7, 25, 25, 25,  8, 25, 25, 25,
     25,  9, 10, 25, 25, 25, 25, 11,   12, 13, 14, 25, 15, 25, 25, 25,
     16, 25, 17, 25, 25, 25, 18, 25,   19, 25, 20, 21, 22, 23, 24, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_99_infos[26] = {
     o2(0x97,0xC3), o2(0xE1,0x94), o2(0xE1,0x92), o2(0xE1,0x93),
     o2(0x8A,0xE0), o2(0x96,0xFC), o2(0x95,0xC8), o2(0xE1,0x96),
     o2(0xE1,0x95), o2(0xE1,0x97), o2(0xE1,0x98), o2(0xE1,0x9C),
     o2(0xE1,0x99), o2(0xE1,0x9A), o2(0xE1,0x9B), o2(0xE1,0x9D),
     o2(0xE1,0x9E), o2(0xE1,0x9F), o2(0xE1,0xA0), o2(0xE1,0xA1),
     o2(0x94,0xAD), o2(0x93,0x6F), o2(0xE1,0xA2), o2(0x94,0x92),
     o2(0x95,0x53),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_99 = {
    to_SHIFT_JIS_E7_99_offsets,
    to_SHIFT_JIS_E7_99_infos
};

static const unsigned char
to_SHIFT_JIS_E7_9A_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_9A */
  /* used from to_EUC_JP_E7_9A */
      0, 26,  1,  2,  3, 26,  4,  5,    6, 26, 26,  7, 26, 26,  8, 26,
      9, 26, 26, 10, 26, 26, 11, 26,   26, 12, 13, 14, 15, 26, 16, 26,
     26, 26, 26, 26, 26, 26, 17, 26,   26, 26, 26, 26, 26, 26, 18, 26,
     19, 26, 26, 26, 20, 26, 26, 21,   22, 23, 24, 26, 26, 26, 26, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_9A_infos[27] = {
     o2(0xE1,0xA3), o2(0xFB,0x70), o2(0xE1,0xA4), o2(0x93,0x49),
     o2(0x8A,0x46), o2(0x8D,0x63), o2(0xE1,0xA5), o2(0xE1,0xA6),
     o2(0xE1,0xA7), o2(0x8E,0x48), o2(0xE1,0xA9), o2(0xE1,0xA8),
     o2(0xE1,0xAA), o2(0xE1,0xAB), o2(0xFB,0x73), o2(0xFB,0x71),
     o2(0xFB,0x72), o2(0xFB,0x74), o2(0x94,0xE7), o2(0xE1,0xAC),
     o2(0xE1,0xAD), o2(0xEA,0x89), o2(0xE1,0xAE), o2(0xE1,0xAF),
     o2(0xE1,0xB0), o2(0x8E,0x4D),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_9A = {
    to_SHIFT_JIS_E7_9A_offsets,
    to_SHIFT_JIS_E7_9A_infos
};

static const unsigned char
to_SHIFT_JIS_E7_9B_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_9B */
  /* used from to_EUC_JP_E7_9B */
     25, 25,  0,  1, 25, 25,  2, 25,    3, 25,  4, 25, 25,  5, 25, 25,
     25, 25,  6, 25, 25, 25,  7,  8,   25, 25, 25,  9, 10, 25, 11, 12,
     25, 13, 25, 14, 15, 16, 25, 17,   25, 25, 18, 25, 25, 25, 19, 25,
     25, 25, 20, 25, 21, 25, 25, 25,   22, 25, 25, 23, 25, 25, 24, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_9B_infos[26] = {
     o2(0xE1,0xB1), o2(0x94,0x75), o2(0x96,0x7E), o2(0x89,0x6D),
     o2(0x89,0x76), o2(0xE1,0xB2), o2(0xE1,0xB4), o2(0xE1,0xB3),
     o2(0x93,0x90), o2(0x90,0xB7), o2(0x9F,0x58), o2(0xE1,0xB5),
     o2(0x96,0xBF), o2(0xE1,0xB6), o2(0x8A,0xC4), o2(0x94,0xD5),
     o2(0xE1,0xB7), o2(0xE1,0xB8), o2(0xE1,0xB9), o2(0x96,0xDA),
     o2(0x96,0xD3), o2(0x92,0xBC), o2(0x91,0x8A), o2(0xE1,0xBB),
     o2(0x8F,0x82),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_9B = {
    to_SHIFT_JIS_E7_9B_offsets,
    to_SHIFT_JIS_E7_9B_infos
};

static const unsigned char
to_SHIFT_JIS_E7_9C_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_9C */
  /* used from to_EUC_JP_E7_9C */
     19,  0, 19, 19,  1, 19, 19,  2,    3,  4, 19,  5,  6, 19, 19, 19,
     19, 19, 19, 19, 19, 19, 19, 19,   19, 19, 19,  7, 19, 19,  8,  9,
     10, 19, 19, 19, 11, 12, 13, 19,   19, 14, 19, 19, 19, 19, 19, 19,
     19, 19, 19, 19, 19, 19, 19, 15,   16, 19, 17, 19, 18, 19, 19, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_9C_infos[20] = {
     o2(0x8F,0xC8), o2(0xE1,0xBE), o2(0xE1,0xBD), o2(0xE1,0xBC),
     o2(0x94,0xFB), o2(0x8A,0xC5), o2(0x8C,0xA7), o2(0xE1,0xC4),
     o2(0xE1,0xC1), o2(0x90,0x5E), o2(0x96,0xB0), o2(0xE1,0xC0),
     o2(0xE1,0xC2), o2(0xE1,0xC3), o2(0xE1,0xBF), o2(0xE1,0xC5),
     o2(0xE1,0xC6), o2(0x92,0xAD), o2(0x8A,0xE1),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_9C = {
    to_SHIFT_JIS_E7_9C_offsets,
    to_SHIFT_JIS_E7_9C_infos
};

static const unsigned char
to_SHIFT_JIS_E7_9D_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_9D */
  /* used from to_EUC_JP_E7_9D */
      0, 14, 14, 14, 14, 14,  1,  2,   14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,   14, 14,  3,  4, 14, 14, 14, 14,
     14,  5, 14,  6, 14,  7,  8, 14,    9, 14, 14, 10, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,   14, 11, 14, 14, 14, 14, 12, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_9D_infos[15] = {
     o2(0x92,0x85), o2(0xFB,0x76), o2(0xE1,0xC7), o2(0xE1,0xC8),
     o2(0xE1,0xCB), o2(0x90,0x87), o2(0x93,0xC2), o2(0xE1,0xCC),
     o2(0x96,0x72), o2(0xE1,0xC9), o2(0xE1,0xCA), o2(0xE1,0xCF),
     o2(0xE1,0xCE), o2(0xE1,0xCD),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_9D = {
    to_SHIFT_JIS_E7_9D_offsets,
    to_SHIFT_JIS_E7_9D_infos
};

static const unsigned char
to_SHIFT_JIS_E7_9E_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_9E */
  /* used from to_EUC_JP_E7_9E */
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16,  0, 16, 16,  1, 16,
     16,  2, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 16, 16,  3, 16,
      4, 16, 16, 16, 16,  5, 16, 16,   16, 16, 16, 16,  6,  7, 16, 16,
      8, 16, 16,  9, 16, 16, 10, 16,   16, 11, 16, 12, 13, 14, 16, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_9E_infos[17] = {
     o2(0xE1,0xD1), o2(0xE1,0xD0), o2(0xE1,0xD2), o2(0xE1,0xD4),
     o2(0xE1,0xD3), o2(0x95,0xCB), o2(0x8F,0x75), o2(0x97,0xC4),
     o2(0xE1,0xD5), o2(0x93,0xB5), o2(0xE1,0xD6), o2(0xE1,0xD7),
     o2(0xE1,0xDB), o2(0xE1,0xD9), o2(0xE1,0xDA), o2(0xE1,0xD8),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_9E = {
    to_SHIFT_JIS_E7_9E_offsets,
    to_SHIFT_JIS_E7_9E_infos
};

static const unsigned char
to_SHIFT_JIS_E7_9F_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_9F */
  /* used from to_EUC_JP_E7_9F */
     16, 16, 16, 16, 16, 16, 16,  0,   16, 16, 16, 16, 16,  1, 16, 16,
     16, 16, 16, 16, 16, 16, 16,  2,   16, 16,  3,  4,  5, 16, 16, 16,
     16, 16,  6,  7, 16,  8, 16,  9,   16, 10, 16, 16, 16, 11, 12, 13,
     16, 16, 16, 14, 16, 16, 16, 16,   16, 16, 16, 16, 15, 16, 16, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_9F_infos[17] = {
     o2(0xE1,0xDC), o2(0xE1,0xDD), o2(0xE1,0xDE), o2(0xE1,0xDF),
     o2(0x96,0xB5), o2(0xE1,0xE0), o2(0x96,0xEE), o2(0xE1,0xE1),
     o2(0x92,0x6D), o2(0x94,0x8A), o2(0x8B,0xE9), o2(0x92,0x5A),
     o2(0xE1,0xE2), o2(0x8B,0xB8), o2(0x90,0xCE), o2(0xE1,0xE3),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_9F = {
    to_SHIFT_JIS_E7_9F_offsets,
    to_SHIFT_JIS_E7_9F_infos
};

static const unsigned char
to_SHIFT_JIS_E7_A0_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_A0 */
  /* used from to_EUC_JP_E7_A0 */
     14, 14,  0, 14, 14, 14, 14, 14,   14, 14, 14, 14,  1, 14, 14, 14,
     14, 14,  2, 14,  3,  4, 14, 14,   14, 14, 14, 14, 14, 14, 14, 14,
      5,  6, 14, 14, 14,  7,  8,  9,   14, 14, 14, 14, 14, 14, 14, 14,
     14, 14, 10, 14, 11, 14, 14, 14,   14, 14, 12, 14, 14, 14, 14, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_A0_infos[15] = {
     o2(0x8D,0xBB), o2(0xE1,0xE4), o2(0xE1,0xE5), o2(0x8C,0xA4),
     o2(0x8D,0xD3), o2(0xE1,0xE7), o2(0xFB,0x78), o2(0x93,0x75),
     o2(0x8D,0xD4), o2(0x8B,0x6D), o2(0x96,0x43), o2(0x94,0x6A),
     o2(0x93,0x76), o2(0x8D,0x7B),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_A0 = {
    to_SHIFT_JIS_E7_A0_offsets,
    to_SHIFT_JIS_E7_A0_infos
};

static const unsigned char
to_SHIFT_JIS_E7_A1_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_A1 */
  /* used from to_EUC_JP_E7_A1 */
     11, 11, 11, 11, 11,  0, 11, 11,   11, 11, 11, 11, 11, 11,  1, 11,
     11, 11, 11, 11, 11, 11, 11, 11,   11, 11, 11, 11, 11,  2, 11, 11,
     11, 11, 11, 11,  3, 11, 11, 11,   11, 11, 11,  4,  5, 11, 11,  6,
     11, 11,  7, 11,  8, 11, 11, 11,   11, 11,  9, 11, 10, 11, 11, 11,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_A1_infos[12] = {
     o2(0xE1,0xE9), o2(0xFB,0x79), o2(0x8F,0xC9), o2(0xFB,0x7A),
     o2(0x97,0xB0), o2(0x8D,0x64), o2(0x8C,0xA5), o2(0x94,0xA1),
     o2(0xE1,0xEB), o2(0xFB,0x7B), o2(0xE1,0xED),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_A1 = {
    to_SHIFT_JIS_E7_A1_offsets,
    to_SHIFT_JIS_E7_A1_infos
};

static const unsigned char
to_SHIFT_JIS_E7_A2_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_A2 */
  /* used from to_EUC_JP_E7_A2 */
     20,  0, 20, 20, 20, 20,  1,  2,   20, 20, 20, 20,  3,  4,  5, 20,
     20,  6, 20,  7, 20,  8, 20,  9,   20, 20, 10, 20, 20, 20, 20, 20,
     20, 20, 20, 11, 20, 20, 20, 12,   20, 13, 14, 20, 20, 20, 20, 15,
     20, 20, 20, 20, 20, 16, 20, 20,   20, 20, 17, 20, 18, 20, 19, 20,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_A2_infos[21] = {
     o2(0x8C,0xE9), o2(0xE1,0xEC), o2(0x92,0xF4), o2(0xE1,0xEF),
     o2(0x8A,0x56), o2(0xE1,0xEA), o2(0x94,0xE8), o2(0x89,0x4F),
     o2(0x8D,0xEA), o2(0x98,0x71), o2(0xE1,0xEE), o2(0xE1,0xF0),
     o2(0x95,0xC9), o2(0x90,0xD7), o2(0xE1,0xF2), o2(0xE1,0xF3),
     o2(0xE1,0xF1), o2(0x8A,0x6D), o2(0xE1,0xF9), o2(0xE1,0xF8),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_A2 = {
    to_SHIFT_JIS_E7_A2_offsets,
    to_SHIFT_JIS_E7_A2_infos
};

static const unsigned char
to_SHIFT_JIS_E7_A3_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_A3 */
  /* used from to_EUC_JP_E7_A3 */
     15,  0, 15, 15, 15,  1,  2, 15,   15, 15,  3,  4, 15, 15, 15, 15,
      5,  6, 15, 15,  7, 15, 15, 15,   15, 15,  8, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15,  9,   10, 15, 15, 15, 11, 15, 15, 12,
     15, 15, 15, 15, 13, 15, 15, 15,   15, 15, 15, 15, 15, 14, 15, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_A3_infos[16] = {
     o2(0x8E,0xA5), o2(0xE1,0xFA), o2(0xE1,0xF5), o2(0xE1,0xFB),
     o2(0xE1,0xF6), o2(0x94,0xD6), o2(0xE1,0xF4), o2(0xE1,0xF7),
     o2(0xE2,0x41), o2(0xE2,0x40), o2(0x96,0x81), o2(0xE1,0xFC),
     o2(0x88,0xE9), o2(0xE2,0x43), o2(0xE2,0x42),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_A3 = {
    to_SHIFT_JIS_E7_A3_offsets,
    to_SHIFT_JIS_E7_A3_infos
};

static const unsigned char
to_SHIFT_JIS_E7_A4_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_A4 */
  /* used from to_EUC_JP_E7_A4 */
     14,  0, 14, 14, 14, 14, 14,  1,   14, 14, 14, 14, 14, 14,  2, 14,
     14,  3,  4, 14, 14, 14, 14, 14,   14,  5, 14, 14, 14, 14, 14, 14,
     14, 14, 14, 14, 14, 14,  6, 14,   14, 14,  7,  8,  9, 14, 14, 14,
     10, 14, 14, 14, 14, 14, 14, 14,   14, 14, 11, 14, 12, 14, 13, 14,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_A4_infos[15] = {
     o2(0x8F,0xCA), o2(0xE2,0x44), o2(0x91,0x62), o2(0xE2,0x46),
     o2(0xE2,0x45), o2(0xE2,0x47), o2(0xE1,0xE6), o2(0xE1,0xE8),
     o2(0xE2,0x49), o2(0xE2,0x48), o2(0xFB,0x7C), o2(0x8E,0xA6),
     o2(0x97,0xE7), o2(0x8E,0xD0),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_A4 = {
    to_SHIFT_JIS_E7_A4_offsets,
    to_SHIFT_JIS_E7_A4_infos
};

static const unsigned char
to_SHIFT_JIS_E7_A5_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_A5 */
  /* used from to_EUC_JP_E7_A5 */
      0,  1, 22, 22, 22, 22, 22,  2,    3,  4, 22, 22, 22, 22, 22, 22,
      5, 22, 22,  6, 22,  7,  8,  9,   22, 22, 10, 22, 22, 11, 12, 13,
     14, 22, 15, 22, 22, 16, 22, 22,   17, 22, 22, 22, 22, 18, 22, 22,
     22, 22, 22, 22, 22, 22, 22, 19,   22, 22, 20, 22, 22, 22, 22, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_A5_infos[23] = {
     o2(0xE2,0x4A), o2(0x8C,0x56), o2(0x8B,0x5F), o2(0x8B,0x46),
     o2(0x8E,0x83), o2(0x97,0x53), o2(0xE2,0x50), o2(0xE2,0x4F),
     o2(0x91,0x63), o2(0xE2,0x4C), o2(0xE2,0x4E), o2(0x8F,0x6A),
     o2(0x90,0x5F), o2(0xE2,0x4D), o2(0xE2,0x4B), o2(0x94,0x49),
     o2(0x8F,0xCB), o2(0x95,0x5B), o2(0x8D,0xD5), o2(0x93,0x98),
     o2(0xE2,0x51), o2(0xE2,0x52),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_A5 = {
    to_SHIFT_JIS_E7_A5_offsets,
    to_SHIFT_JIS_E7_A5_infos
};

static const unsigned char
to_SHIFT_JIS_E7_A6_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_A6 */
  /* used from to_EUC_JP_E7_A6 */
      0,  1, 22, 22,  2,  3, 22, 22,   22, 22,  4, 22, 22,  5,  6,  7,
     22, 22, 22, 22,  8, 22, 22, 22,   22, 22, 22,  9, 22, 10, 22, 22,
     22, 22, 22, 22, 22, 22, 11, 12,   22, 22, 13, 22, 22, 22, 14, 22,
     15, 22, 22, 16, 22, 22, 22, 22,   22, 17, 18, 22, 22, 19, 20, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_A6_infos[23] = {
     o2(0xE2,0x68), o2(0x8B,0xD6), o2(0x98,0x5C), o2(0x91,0x54),
     o2(0xE2,0x53), o2(0x89,0xD0), o2(0x92,0xF5), o2(0x95,0x9F),
     o2(0xFB,0x81), o2(0xFB,0x83), o2(0xE2,0x54), o2(0x8B,0x9A),
     o2(0xE2,0x55), o2(0xE2,0x57), o2(0xE2,0x58), o2(0x94,0x48),
     o2(0xE2,0x59), o2(0xE2,0x5A), o2(0xE2,0x5B), o2(0x8B,0xD7),
     o2(0x89,0xD1), o2(0x93,0xC3),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_A6 = {
    to_SHIFT_JIS_E7_A6_offsets,
    to_SHIFT_JIS_E7_A6_infos
};

static const unsigned char
to_SHIFT_JIS_E7_A7_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_A7 */
  /* used from to_EUC_JP_E7_A7 */
      0,  1, 18, 18, 18, 18, 18, 18,   18,  2, 18,  3, 18, 18, 18, 18,
     18,  4,  5, 18, 18,  6, 18, 18,    7, 18, 18, 18, 18, 18, 18,  8,
     18,  9, 18, 10, 11, 18, 12, 13,   18, 14, 18, 18, 15, 18, 18, 18,
     16, 18, 18, 18, 18, 18, 18, 18,   18, 18, 18, 17, 18, 18, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_A7_infos[19] = {
     o2(0x8F,0x47), o2(0x8E,0x84), o2(0xE2,0x5C), o2(0x8F,0x48),
     o2(0x89,0xC8), o2(0x95,0x62), o2(0xE2,0x5D), o2(0x94,0xE9),
     o2(0x91,0x64), o2(0xE2,0x60), o2(0xE2,0x61), o2(0x94,0x89),
     o2(0x90,0x60), o2(0xE2,0x5E), o2(0x92,0x81), o2(0xE2,0x5F),
     o2(0x8F,0xCC), o2(0x88,0xDA),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_A7 = {
    to_SHIFT_JIS_E7_A7_offsets,
    to_SHIFT_JIS_E7_A7_infos
};

static const unsigned char
to_SHIFT_JIS_E7_A8_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_A8 */
  /* used from to_EUC_JP_E7_A8 */
      0, 22, 22, 22, 22, 22, 22, 22,    1, 22, 22,  2, 22,  3,  4, 22,
     22, 22, 22, 22,  5, 22, 22,  6,    7,  8,  9, 22, 10, 22, 22, 11,
     12, 22, 22, 22, 22, 22, 22, 22,   22, 22, 22, 22, 22, 22, 13, 22,
     22, 14, 15, 22, 22, 22, 22, 16,   22, 22, 22, 17, 18, 19, 20, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_A8_infos[23] = {
     o2(0x8B,0x48), o2(0xE2,0x62), o2(0x92,0xF6), o2(0xE2,0x63),
     o2(0x90,0xC5), o2(0x96,0xAB), o2(0x95,0x42), o2(0xE2,0x64),
     o2(0xE2,0x65), o2(0x92,0x74), o2(0x97,0xC5), o2(0xE2,0x67),
     o2(0xE2,0x66), o2(0x8E,0xED), o2(0xE2,0x69), o2(0x88,0xEE),
     o2(0xE2,0x6C), o2(0xE2,0x6A), o2(0x89,0xD2), o2(0x8C,0x6D),
     o2(0xE2,0x6B), o2(0x8D,0x65),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_A8 = {
    to_SHIFT_JIS_E7_A8_offsets,
    to_SHIFT_JIS_E7_A8_infos
};

static const unsigned char
to_SHIFT_JIS_E7_A9_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_A9 */
  /* used from to_EUC_JP_E7_A9 */
      0, 22,  1,  2, 22, 22,  3, 22,   22,  4, 22, 22, 22,  5,  6,  7,
      8, 22, 22, 22, 22, 22, 22,  9,   22, 22, 22, 22, 22, 22, 22, 22,
     22, 10, 11, 12, 22, 22, 22, 22,   22, 13, 22, 14, 22, 22, 22, 22,
     15, 22, 22, 22, 16, 22, 17, 22,   22, 18, 19, 22, 22, 20, 22, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_A9_infos[23] = {
     o2(0x8D,0x92), o2(0x95,0xE4), o2(0xE2,0x6D), o2(0x96,0x73),
     o2(0xE2,0x6F), o2(0x90,0xCF), o2(0x89,0x6E), o2(0x89,0xB8),
     o2(0x88,0xAA), o2(0xE2,0x6E), o2(0xE2,0x70), o2(0xE2,0x71),
     o2(0x8F,0xF5), o2(0xE2,0x72), o2(0x8A,0x6E), o2(0xE2,0x74),
     o2(0x8C,0x8A), o2(0x8B,0x86), o2(0xE2,0x75), o2(0x8B,0xF3),
     o2(0xE2,0x76), o2(0x90,0xFA),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_A9 = {
    to_SHIFT_JIS_E7_A9_offsets,
    to_SHIFT_JIS_E7_A9_infos
};

static const unsigned char
to_SHIFT_JIS_E7_AA_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_AA */
  /* used from to_EUC_JP_E7_AA */
     19,  0, 19,  1,  2, 19, 19, 19,    3, 19, 19, 19, 19, 19, 19, 19,
     19, 19,  4,  5, 19,  6,  7,  8,    9, 19, 19, 19, 19, 19, 19, 10,
     19, 19, 19, 19, 19, 19, 19, 19,   19, 11, 12, 19, 19, 19, 13, 14,
     15, 19, 19, 19, 19, 19, 16, 19,   19, 19, 17, 19, 19, 19, 19, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_AA_infos[20] = {
     o2(0x93,0xCB), o2(0x90,0xDE), o2(0x8D,0xF3), o2(0xE2,0x77),
     o2(0x92,0x82), o2(0x91,0x8B), o2(0xE2,0x79), o2(0xE2,0x7B),
     o2(0xE2,0x78), o2(0xE2,0x7A), o2(0x8C,0x41), o2(0xE2,0x7C),
     o2(0x8C,0x45), o2(0x8B,0x87), o2(0x97,0x71), o2(0xE2,0x7E),
     o2(0xE2,0x80), o2(0x89,0x4D), o2(0xE2,0x83),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_AA = {
    to_SHIFT_JIS_E7_AA_offsets,
    to_SHIFT_JIS_E7_AA_infos
};

static const unsigned char
to_SHIFT_JIS_E7_AB_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_AB */
  /* used from to_EUC_JP_E7_AB */
     35, 35, 35,  0,  1,  2, 35,  3,    4, 35,  5,  6, 35,  7, 35,  8,
     35,  9, 10, 11, 35, 12, 35, 35,   35, 13, 14, 35, 15, 16, 35, 17,
     18, 19, 20, 21, 35, 22, 23, 24,   35, 35, 25, 26, 35, 27, 35, 28,
     29, 35, 35, 35, 35, 35, 30, 35,   31, 32, 33, 35, 35, 35, 35, 34,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_AB_infos[36] = {
     o2(0x8A,0x96), o2(0xE2,0x82), o2(0xE2,0x81), o2(0xE2,0x85),
     o2(0xE2,0x7D), o2(0xE2,0x86), o2(0x97,0xA7), o2(0xE2,0x87),
     o2(0xE2,0x88), o2(0xFB,0x84), o2(0x9A,0xF2), o2(0xE2,0x8A),
     o2(0xE2,0x89), o2(0xE2,0x8B), o2(0xE2,0x8C), o2(0x97,0xB3),
     o2(0xE2,0x8D), o2(0xE8,0xED), o2(0x8F,0xCD), o2(0xE2,0x8E),
     o2(0xE2,0x8F), o2(0x8F,0x76), o2(0x93,0xB6), o2(0xE2,0x90),
     o2(0xFB,0x85), o2(0x92,0x47), o2(0xFB,0x87), o2(0xE2,0x91),
     o2(0x92,0x5B), o2(0xE2,0x92), o2(0x8B,0xA3), o2(0x99,0x5E),
     o2(0x92,0x7C), o2(0x8E,0xB1), o2(0x8A,0xC6),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_AB = {
    to_SHIFT_JIS_E7_AB_offsets,
    to_SHIFT_JIS_E7_AB_infos
};

static const unsigned char
to_SHIFT_JIS_E7_AC_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_AC */
  /* used from to_EUC_JP_E7_AC */
     21, 21,  0, 21,  1, 21,  2, 21,    3, 21,  4,  5, 21, 21, 21,  6,
     21,  7, 21, 21, 21, 21, 21, 21,    8,  9, 21, 10, 21, 21, 11, 21,
     12, 21, 21, 21, 21, 13, 14, 21,   15, 21, 21, 21, 16, 21, 21, 21,
     21, 21, 21, 17, 21, 18, 19, 21,   21, 20, 21, 21, 21, 21, 21, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_AC_infos[22] = {
     o2(0xE2,0x93), o2(0xE2,0xA0), o2(0xE2,0x96), o2(0x8B,0x88),
     o2(0xE2,0x95), o2(0xE2,0xA2), o2(0xE2,0x94), o2(0x8F,0xCE),
     o2(0xE2,0x98), o2(0xE2,0x99), o2(0x93,0x4A), o2(0xE2,0x9A),
     o2(0x8A,0x7D), o2(0x90,0x79), o2(0x95,0x84), o2(0xE2,0x9C),
     o2(0x91,0xE6), o2(0xE2,0x97), o2(0xE2,0x9B), o2(0xE2,0x9D),
     o2(0x8D,0xF9),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_AC = {
    to_SHIFT_JIS_E7_AC_offsets,
    to_SHIFT_JIS_E7_AC_infos
};

static const unsigned char
to_SHIFT_JIS_E7_AD_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_AD */
  /* used from to_EUC_JP_E7_AD */
     23, 23, 23, 23, 23,  0,  1, 23,    2,  3, 23,  4,  5,  6, 23,  7,
      8,  9, 10, 23, 11, 23, 12, 23,   23, 23, 23, 23, 23, 13, 23, 23,
     23, 23, 23, 23, 23, 14, 23, 15,   23, 23, 23, 23, 16, 23, 17, 23,
     18, 19, 23, 23, 20, 21, 23, 23,   23, 23, 22, 23, 23, 23, 23, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_AD_infos[24] = {
     o2(0xE2,0xA4), o2(0x95,0x4D), o2(0x94,0xA4), o2(0x93,0x99),
     o2(0x8B,0xD8), o2(0xE2,0xA3), o2(0xE2,0xA1), o2(0x94,0xB3),
     o2(0xE2,0x9E), o2(0x92,0x7D), o2(0x93,0x9B), o2(0x93,0x9A),
     o2(0x8D,0xF4), o2(0xE2,0xB6), o2(0xE2,0xA6), o2(0xE2,0xA8),
     o2(0xE2,0xAB), o2(0xE2,0xAC), o2(0xE2,0xA9), o2(0xE2,0xAA),
     o2(0xE2,0xA7), o2(0xE2,0xA5), o2(0xE2,0x9F),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_AD = {
    to_SHIFT_JIS_E7_AD_offsets,
    to_SHIFT_JIS_E7_AD_infos
};

static const unsigned char
to_SHIFT_JIS_E7_AE_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_AE */
  /* used from to_EUC_JP_E7_AE */
     22, 22, 22, 22, 22, 22,  0,  1,   22, 22, 22,  2, 22,  3, 22,  4,
     22, 22,  5, 22,  6,  7, 22,  8,    9, 10, 11, 22, 12, 13, 14, 15,
     22, 16, 22, 22, 22, 22, 22, 22,   22, 22, 17, 22, 22, 18, 22, 22,
     22, 19, 22, 22, 20, 22, 22, 22,   21, 22, 22, 22, 22, 22, 22, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_AE_infos[23] = {
     o2(0x95,0xCD), o2(0x89,0xD3), o2(0xE2,0xB3), o2(0xE2,0xB0),
     o2(0xE2,0xB5), o2(0xE2,0xB4), o2(0x94,0x93), o2(0x96,0xA5),
     o2(0x8E,0x5A), o2(0xE2,0xAE), o2(0xE2,0xB7), o2(0xE2,0xB2),
     o2(0xE2,0xB1), o2(0xE2,0xAD), o2(0xFB,0x88), o2(0xE2,0xAF),
     o2(0x8A,0xC7), o2(0x92,0x5C), o2(0x90,0xFB), o2(0x94,0xA0),
     o2(0xE2,0xBC), o2(0x94,0xA2),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_AE = {
    to_SHIFT_JIS_E7_AE_offsets,
    to_SHIFT_JIS_E7_AE_infos
};

static const unsigned char
to_SHIFT_JIS_E7_AF_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_AF */
  /* used from to_EUC_JP_E7_AF */
      0,  1, 19, 19,  2, 19,  3,  4,   19,  5, 19,  6,  7, 19, 19,  8,
     19, 19, 19, 19, 19, 19, 19, 19,   19, 19, 19, 19, 19,  9, 19, 19,
     10, 19, 19, 19, 11, 12, 13, 19,   19, 14, 19, 19, 19, 15, 19, 19,
     19, 19, 19, 16, 19, 19, 17, 18,   19, 19, 19, 19, 19, 19, 19, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_AF_infos[20] = {
     o2(0x90,0xDF), o2(0xE2,0xB9), o2(0x94,0xCD), o2(0xE2,0xBD),
     o2(0x95,0xD1), o2(0x92,0x7A), o2(0xE2,0xB8), o2(0xE2,0xBA),
     o2(0xE2,0xBB), o2(0xE2,0xBE), o2(0x8E,0xC2), o2(0x93,0xC4),
     o2(0xE2,0xC3), o2(0xE2,0xC2), o2(0xE2,0xBF), o2(0x98,0x55),
     o2(0xE2,0xC8), o2(0xE2,0xCC), o2(0xE2,0xC9),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_AF = {
    to_SHIFT_JIS_E7_AF_offsets,
    to_SHIFT_JIS_E7_AF_infos
};

static const unsigned char
to_SHIFT_JIS_E7_B0_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_B0 */
  /* used from to_EUC_JP_E7_B0 */
      0, 19, 19, 19, 19, 19, 19,  1,   19, 19, 19, 19, 19,  2, 19, 19,
     19,  3,  4,  5,  6, 19, 19,  7,   19, 19, 19, 19, 19, 19, 19,  8,
     19,  9, 19, 10, 19, 19, 19, 11,   19, 19, 12, 13, 19, 19, 19, 19,
     19, 19, 19, 19, 19, 19, 19, 14,   15, 19, 19, 19, 19, 16, 17, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_B0_infos[20] = {
     o2(0xE2,0xC5), o2(0xE2,0xC6), o2(0xE2,0xCB), o2(0xE2,0xC0),
     o2(0x99,0xD3), o2(0xE2,0xC7), o2(0xE2,0xC1), o2(0xE2,0xCA),
     o2(0xE2,0xD0), o2(0x8A,0xC8), o2(0xE2,0xCD), o2(0xE2,0xCE),
     o2(0xE2,0xCF), o2(0xE2,0xD2), o2(0xE2,0xD1), o2(0x94,0xF4),
     o2(0xE2,0xD3), o2(0x97,0xFA), o2(0x95,0xEB),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_B0 = {
    to_SHIFT_JIS_E7_B0_offsets,
    to_SHIFT_JIS_E7_B0_infos
};

static const unsigned char
to_SHIFT_JIS_E7_B1_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_B1 */
  /* used from to_EUC_JP_E7_B1 */
      0, 17, 17,  1, 17, 17, 17, 17,   17, 17, 17, 17,  2,  3, 17,  4,
      5, 17, 17, 17,  6, 17,  7, 17,    8, 17, 17, 17, 17, 17, 17,  9,
     10, 17, 17, 17, 11, 12, 17, 17,   17, 17, 17, 17, 13, 17, 17, 17,
     17, 17, 17, 14, 17, 15, 17, 17,   17, 17, 17, 17, 17, 17, 16, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_B1_infos[18] = {
     o2(0xE2,0xD8), o2(0xE2,0xD5), o2(0xE2,0xD4), o2(0x90,0xD0),
     o2(0xE2,0xD7), o2(0xE2,0xD9), o2(0xE2,0xD6), o2(0xE2,0xDD),
     o2(0xE2,0xDA), o2(0xE2,0xDB), o2(0xE2,0xC4), o2(0xE2,0xDC),
     o2(0xE2,0xDE), o2(0xE2,0xDF), o2(0x95,0xC4), o2(0xE2,0xE0),
     o2(0x96,0xE0),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_B1 = {
    to_SHIFT_JIS_E7_B1_offsets,
    to_SHIFT_JIS_E7_B1_infos
};

static const unsigned char
to_SHIFT_JIS_E7_B2_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_B2 */
  /* used from to_EUC_JP_E7_B2 */
     28,  0,  1,  2, 28, 28, 28, 28,   28,  3, 28,  4, 28,  5, 28, 28,
      6, 28,  7, 28, 28,  8, 28,  9,   10, 28, 28, 11, 28, 28, 28, 12,
     28, 13, 14, 28, 15, 16, 28, 17,   18, 28, 28, 19, 28, 20, 21, 28,
     28, 22, 23, 24, 28, 28, 28, 28,   28, 25, 28, 28, 28, 26, 27, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_B2_infos[29] = {
     o2(0x8B,0xCC), o2(0x8C,0x48), o2(0xE2,0xE1), o2(0x95,0xB2),
     o2(0x90,0x88), o2(0x96,0xAE), o2(0xE2,0xE2), o2(0x97,0xB1),
     o2(0x94,0x94), o2(0x91,0x65), o2(0x94,0x53), o2(0x8F,0x6C),
     o2(0x88,0xBE), o2(0xE2,0xE7), o2(0xE2,0xE5), o2(0xE2,0xE3),
     o2(0x8A,0x9F), o2(0x8F,0xCF), o2(0xE2,0xE8), o2(0xE2,0xE6),
     o2(0xE2,0xE4), o2(0xE2,0xEC), o2(0xE2,0xEB), o2(0xE2,0xEA),
     o2(0xE2,0xE9), o2(0xE2,0xED), o2(0xE2,0xEE), o2(0x90,0xB8),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_B2 = {
    to_SHIFT_JIS_E7_B2_offsets,
    to_SHIFT_JIS_E7_B2_infos
};

static const unsigned char
to_SHIFT_JIS_E7_B3_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_B3 */
  /* used from to_EUC_JP_E7_B3 */
      0, 22,  1, 22, 22,  2, 22, 22,   22, 22,  3, 22, 22, 22,  4, 22,
     22, 22,  5, 22, 22, 22,  6, 22,    7, 22, 22, 22,  8, 22,  9, 10,
     11, 22, 12, 22, 22, 22, 22, 13,   22, 22, 22, 22, 22, 22, 22, 14,
     22, 22, 15, 22, 16, 22, 17, 22,   18, 22, 19, 20, 22, 22, 21, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_B3_infos[23] = {
     o2(0xE2,0xEF), o2(0xE2,0xF1), o2(0xE2,0xF0), o2(0x8C,0xD0),
     o2(0x91,0x57), o2(0xE2,0xF3), o2(0x93,0x9C), o2(0xE2,0xF2),
     o2(0xE2,0xF4), o2(0x95,0xB3), o2(0x91,0x8C), o2(0x8D,0x66),
     o2(0xE2,0xF5), o2(0x97,0xC6), o2(0xE2,0xF7), o2(0xE2,0xF8),
     o2(0xE2,0xF9), o2(0xE2,0xFA), o2(0x8E,0x85), o2(0xE2,0xFB),
     o2(0x8C,0x6E), o2(0x8B,0x8A),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_B3 = {
    to_SHIFT_JIS_E7_B3_offsets,
    to_SHIFT_JIS_E7_B3_infos
};

static const unsigned char
to_SHIFT_JIS_E7_B4_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_B4 */
  /* used from to_EUC_JP_E7_B4 */
      0, 31,  1, 31,  2,  3,  4, 31,   31, 31,  5,  6, 31,  7, 31, 31,
      8, 31, 31, 31,  9, 10, 31, 11,   12, 13, 14, 15, 16, 31, 31, 31,
     17, 18, 19, 31, 31, 31, 31, 31,   31, 31, 31, 20, 21, 31, 22, 23,
     24, 31, 25, 26, 31, 27, 31, 31,   31, 28, 29, 31, 31, 31, 31, 30,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_B4_infos[32] = {
     o2(0x8B,0x49), o2(0xE3,0x40), o2(0x96,0xF1), o2(0x8D,0x67),
     o2(0xE2,0xFC), o2(0xE3,0x43), o2(0x96,0xE4), o2(0x94,0x5B),
     o2(0x95,0x52), o2(0x8F,0x83), o2(0xE3,0x42), o2(0x8E,0xD1),
     o2(0x8D,0x68), o2(0x8E,0x86), o2(0x8B,0x89), o2(0x95,0xB4),
     o2(0xE3,0x41), o2(0x91,0x66), o2(0x96,0x61), o2(0x8D,0xF5),
     o2(0x8E,0x87), o2(0x92,0xDB), o2(0xE3,0x46), o2(0x97,0xDD),
     o2(0x8D,0xD7), o2(0xE3,0x47), o2(0x90,0x61), o2(0xE3,0x49),
     o2(0x8F,0xD0), o2(0x8D,0xAE), o2(0xE3,0x48),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_B4 = {
    to_SHIFT_JIS_E7_B4_offsets,
    to_SHIFT_JIS_E7_B4_infos
};

static const unsigned char
to_SHIFT_JIS_E7_B5_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_B5 */
  /* used from to_EUC_JP_E7_B5 */
     28, 28,  0,  1,  2,  3,  4, 28,    5, 28, 28,  6,  7, 28,  8,  9,
     10, 28, 28, 28, 28, 28, 11, 28,   28, 28, 28, 12, 13, 28, 14, 28,
     28, 15, 16, 17, 28, 28, 18, 28,   19, 28, 28, 28, 28, 28, 20, 28,
     28, 21, 22, 23, 28, 24, 25, 28,   28, 26, 28, 28, 28, 27, 28, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_B5_infos[29] = {
     o2(0x8F,0x49), o2(0x8C,0xBC), o2(0x91,0x67), o2(0xE3,0x44),
     o2(0xE3,0x4A), o2(0xFB,0x8A), o2(0xE3,0x45), o2(0x8C,0x6F),
     o2(0xE3,0x4D), o2(0xE3,0x51), o2(0x8C,0x8B), o2(0xE3,0x4C),
     o2(0xE3,0x55), o2(0xFB,0x8B), o2(0x8D,0x69), o2(0x97,0x8D),
     o2(0x88,0xBA), o2(0xE3,0x52), o2(0x8B,0x8B), o2(0xE3,0x4F),
     o2(0xE3,0x50), o2(0x93,0x9D), o2(0xE3,0x4E), o2(0xE3,0x4B),
     o2(0x8A,0x47), o2(0x90,0xE2), o2(0x8C,0xA6), o2(0xE3,0x57),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_B5 = {
    to_SHIFT_JIS_E7_B5_offsets,
    to_SHIFT_JIS_E7_B5_infos
};

static const unsigned char
to_SHIFT_JIS_E7_B6_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_B6 */
  /* used from to_EUC_JP_E7_B6 */
     28, 28, 28, 28, 28, 28, 28, 28,   28,  0, 28, 28, 28, 28, 28,  1,
     28, 28, 28,  2, 28, 28, 28, 28,   28,  3,  4,  5,  6, 28, 28,  7,
      8, 28,  9, 10, 28, 28, 28, 28,   28, 28, 28, 11, 12, 13, 14, 15,
     16, 17, 18, 28, 19, 20, 28, 21,   22, 28, 23, 24, 28, 25, 26, 27,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_B6_infos[29] = {
     o2(0xE3,0x54), o2(0xE3,0x56), o2(0xE3,0x53), o2(0x8C,0x70),
     o2(0x91,0xB1), o2(0xE3,0x58), o2(0x91,0x8E), o2(0xE3,0x65),
     o2(0xFB,0x8D), o2(0xE3,0x61), o2(0xE3,0x5B), o2(0xE3,0x5F),
     o2(0x8E,0xF8), o2(0x88,0xDB), o2(0xE3,0x5A), o2(0xE3,0x62),
     o2(0xE3,0x66), o2(0x8D,0x6A), o2(0x96,0xD4), o2(0x92,0xD4),
     o2(0xE3,0x5C), o2(0xFB,0x8C), o2(0xE3,0x64), o2(0xE3,0x59),
     o2(0x92,0x5D), o2(0xE3,0x5E), o2(0x88,0xBB), o2(0x96,0xC8),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_B6 = {
    to_SHIFT_JIS_E7_B6_offsets,
    to_SHIFT_JIS_E7_B6_infos
};

static const unsigned char
to_SHIFT_JIS_E7_B7_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_B7 */
  /* used from to_EUC_JP_E7_B7 */
     23, 23, 23, 23, 23, 23, 23,  0,   23, 23,  1,  2, 23, 23, 23,  3,
     23,  4,  5, 23, 23,  6,  7, 23,    8, 23,  9, 23, 10, 11, 12, 23,
     13, 14, 23, 23, 15, 23, 23, 23,   16, 17, 23, 23, 18, 23, 23, 19,
     23, 23, 20, 23, 21, 23, 23, 23,   23, 23, 23, 22, 23, 23, 23, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_B7_infos[24] = {
     o2(0xE3,0x5D), o2(0x8B,0xD9), o2(0x94,0xEA), o2(0x91,0x8D),
     o2(0x97,0xCE), o2(0x8F,0x8F), o2(0xE3,0x8E), o2(0xFB,0x8E),
     o2(0xE3,0x67), o2(0x90,0xFC), o2(0xE3,0x63), o2(0xE3,0x68),
     o2(0xE3,0x6A), o2(0x92,0xF7), o2(0xE3,0x6D), o2(0xE3,0x69),
     o2(0x95,0xD2), o2(0x8A,0xC9), o2(0x96,0xC9), o2(0x88,0xDC),
     o2(0xE3,0x6C), o2(0x97,0xFB), o2(0xE3,0x6B),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_B7 = {
    to_SHIFT_JIS_E7_B7_offsets,
    to_SHIFT_JIS_E7_B7_infos
};

static const unsigned char
to_SHIFT_JIS_E7_B8_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_B8 */
  /* used from to_EUC_JP_E7_B8 */
     25,  0, 25, 25,  1,  2, 25, 25,   25,  3,  4,  5, 25, 25, 25, 25,
     25, 25,  6, 25, 25, 25, 25, 25,   25, 25, 25,  7, 25, 25,  8,  9,
     25, 10, 11, 12, 25, 25, 13, 25,   25, 25, 25, 14, 25, 25, 15, 25,
     25, 16, 17, 25, 25, 18, 25, 19,   25, 20, 21, 22, 25, 23, 24, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_B8_infos[26] = {
     o2(0x89,0x8F), o2(0x93,0xEA), o2(0xE3,0x6E), o2(0xE3,0x75),
     o2(0xE3,0x6F), o2(0xE3,0x76), o2(0xE3,0x72), o2(0x94,0x9B),
     o2(0x8E,0xC8), o2(0xE3,0x74), o2(0xE3,0x71), o2(0xE3,0x77),
     o2(0xE3,0x70), o2(0x8F,0x63), o2(0x96,0x44), o2(0x8F,0x6B),
     o2(0xE3,0x73), o2(0xE3,0x80), o2(0xE3,0x7B), o2(0xE3,0x7E),
     o2(0xE3,0x7C), o2(0xE3,0x81), o2(0xE3,0x7A), o2(0xE3,0x60),
     o2(0x90,0xD1),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_B8 = {
    to_SHIFT_JIS_E7_B8_offsets,
    to_SHIFT_JIS_E7_B8_infos
};

static const unsigned char
to_SHIFT_JIS_E7_B9_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_B9 */
  /* used from to_EUC_JP_E7_B9 */
     25,  0, 25,  1, 25, 25,  2, 25,   25, 25,  3,  4, 25,  5, 25, 25,
     25, 25,  6, 25,  7,  8,  9, 25,   25, 10, 11, 25, 25, 12, 13, 25,
     25, 25, 25, 25, 25, 25, 14, 15,   25, 16, 17, 25, 25, 18, 25, 25,
     19, 25, 25, 25, 25, 25, 25, 25,   25, 20, 25, 21, 22, 23, 25, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_B9_infos[26] = {
     o2(0x94,0xC9), o2(0xE3,0x7D), o2(0xE3,0x78), o2(0x91,0x40),
     o2(0x8C,0x71), o2(0x8F,0x4A), o2(0xFB,0x8F), o2(0x90,0x44),
     o2(0x91,0x55), o2(0xE3,0x84), o2(0xE3,0x86), o2(0xE3,0x87),
     o2(0xE3,0x83), o2(0xE3,0x85), o2(0xE3,0x79), o2(0xE3,0x82),
     o2(0xE3,0x8A), o2(0xE3,0x89), o2(0x96,0x9A), o2(0x8C,0x4A),
     o2(0xE3,0x88), o2(0xE3,0x8C), o2(0xE3,0x8B), o2(0xE3,0x8F),
     o2(0xE3,0x91),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_B9 = {
    to_SHIFT_JIS_E7_B9_offsets,
    to_SHIFT_JIS_E7_B9_infos
};

static const unsigned char
to_SHIFT_JIS_E7_BA_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_BA */
  /* used from to_EUC_JP_E7_BA */
     15, 15,  0,  1, 15, 15, 15, 15,    2,  3,  4, 15,  5, 15,  6,  7,
      8, 15,  9, 10, 11, 15, 12, 15,   15, 15, 15, 13, 14, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,   15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,   15, 15, 15, 15, 15, 15, 15, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_BA_infos[16] = {
     o2(0x8E,0x5B), o2(0xE3,0x8D), o2(0xE3,0x92), o2(0xE3,0x93),
     o2(0xFA,0x5C), o2(0xE3,0x94), o2(0xE3,0x9A), o2(0x93,0x5A),
     o2(0xE3,0x96), o2(0xE3,0x95), o2(0xE3,0x97), o2(0xE3,0x98),
     o2(0xE3,0x99), o2(0xE3,0x9B), o2(0xE3,0x9C),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_BA = {
    to_SHIFT_JIS_E7_BA_offsets,
    to_SHIFT_JIS_E7_BA_infos
};

static const unsigned char
to_SHIFT_JIS_E7_BC_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_BC */
  /* used from to_EUC_JP_E7_BC */
      3,  3,  3,  3,  3,  3,  3,  3,    3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,    3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,    3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  0,  3,    1,  3,  2,  3,  3,  3,  3,  3,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_BC_infos[4] = {
     o2(0x8A,0xCA), o2(0xE3,0x9D), o2(0xE3,0x9E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_BC = {
    to_SHIFT_JIS_E7_BC_offsets,
    to_SHIFT_JIS_E7_BC_infos
};

static const unsigned char
to_SHIFT_JIS_E7_BD_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_BD */
  /* used from to_EUC_JP_E7_BD */
     24, 24, 24, 24, 24,  0, 24,  1,   24, 24, 24, 24,  2,  3,  4, 24,
      5,  6, 24, 24,  7,  8, 24, 24,    9, 24, 24, 24, 24, 24, 24, 10,
     11, 24, 24, 24, 24, 24, 24, 12,   13, 14, 15, 16, 24, 24, 17, 24,
     18, 24, 19, 24, 24, 20, 24, 21,   22, 23, 24, 24, 24, 24, 24, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_BD_infos[25] = {
     o2(0xE3,0x9F), o2(0xFB,0x90), o2(0xE3,0xA0), o2(0xE3,0xA1),
     o2(0xE3,0xA2), o2(0xE3,0xA3), o2(0xE3,0xA4), o2(0xE3,0xA6),
     o2(0xE3,0xA5), o2(0xE3,0xA7), o2(0xE3,0xA8), o2(0xE3,0xA9),
     o2(0xE3,0xAC), o2(0xE3,0xAA), o2(0xE3,0xAB), o2(0x8D,0xDF),
     o2(0x8C,0x72), o2(0x92,0x75), o2(0x94,0xB1), o2(0x8F,0x90),
     o2(0x94,0x6C), o2(0x94,0xEB), o2(0xE3,0xAD), o2(0x9C,0xEB),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_BD = {
    to_SHIFT_JIS_E7_BD_offsets,
    to_SHIFT_JIS_E7_BD_infos
};

static const unsigned char
to_SHIFT_JIS_E7_BE_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_BE */
  /* used from to_EUC_JP_E7_BE */
     25, 25,  0,  1, 25,  2,  3,  4,    5, 25,  6, 25,  7, 25,  8, 25,
     25, 25, 25, 25,  9, 25, 25, 25,   25, 25, 10, 25, 25, 11, 12, 25,
     25, 13, 25, 14, 15, 25, 25, 25,   16, 17, 25, 25, 25, 25, 18, 19,
     25, 25, 20, 25, 25, 25, 21, 25,   22, 23, 25, 25, 25, 24, 25, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_BE_infos[26] = {
     o2(0xE3,0xAE), o2(0xE3,0xB0), o2(0x97,0x85), o2(0xE3,0xAF),
     o2(0xE3,0xB2), o2(0xE3,0xB1), o2(0x97,0x72), o2(0xE3,0xB3),
     o2(0x94,0xFC), o2(0xE3,0xB4), o2(0xE3,0xB7), o2(0xE3,0xB6),
     o2(0xE3,0xB5), o2(0xFB,0x91), o2(0xE3,0xB8), o2(0x8C,0x51),
     o2(0x91,0x41), o2(0x8B,0x60), o2(0xE3,0xBC), o2(0xE3,0xB9),
     o2(0xE3,0xBA), o2(0xE3,0xBD), o2(0xE3,0xBE), o2(0xE3,0xBB),
     o2(0x89,0x48),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_BE = {
    to_SHIFT_JIS_E7_BE_offsets,
    to_SHIFT_JIS_E7_BE_infos
};

static const unsigned char
to_SHIFT_JIS_E7_BF_offsets[64] = {
  /* used from to_SHIFT_JIS_E7_BF */
  /* used from to_EUC_JP_E7_BF */
     18,  0, 18, 18, 18,  1,  2, 18,   18, 18,  3, 18,  4, 18, 18, 18,
     18, 18,  5, 18,  6,  7, 18, 18,   18, 18, 18, 18, 18, 18, 18, 18,
      8,  9, 18, 18, 18, 18, 10, 18,   18, 11, 18, 12, 18, 18, 18, 18,
     13, 18, 18, 14, 18, 18, 18, 18,   18, 15, 18, 16, 17, 18, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_BF_infos[19] = {
     o2(0x89,0xA5), o2(0xE3,0xC0), o2(0xE3,0xC1), o2(0xE3,0xC2),
     o2(0x97,0x82), o2(0x8F,0x4B), o2(0xE3,0xC4), o2(0xE3,0xC3),
     o2(0x90,0x89), o2(0xE3,0xC5), o2(0xE3,0xC6), o2(0xE3,0xC7),
     o2(0x8A,0xE3), o2(0x8A,0xCB), o2(0xE3,0xC8), o2(0xE3,0xC9),
     o2(0x96,0x7C), o2(0x97,0x83),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7_BF = {
    to_SHIFT_JIS_E7_BF_offsets,
    to_SHIFT_JIS_E7_BF_infos
};

static const unsigned char
to_SHIFT_JIS_E7_offsets[64] = {
  /* used from to_SHIFT_JIS_E7 */
  /* used from to_EUC_JP_E7 */
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,   24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39,   40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55,   56, 57, 58, 63, 59, 60, 61, 62,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E7_infos[64] = {
     &to_SHIFT_JIS_E7_80, &to_SHIFT_JIS_E7_81,
     &to_SHIFT_JIS_E7_82, &to_SHIFT_JIS_E7_83,
     &to_SHIFT_JIS_E7_84, &to_SHIFT_JIS_E7_85,
     &to_SHIFT_JIS_E7_86, &to_SHIFT_JIS_E7_87,
     &to_SHIFT_JIS_E7_88, &to_SHIFT_JIS_E7_89,
     &to_SHIFT_JIS_E7_8A, &to_SHIFT_JIS_E7_8B,
     &to_SHIFT_JIS_E7_8C, &to_SHIFT_JIS_E7_8D,
     &to_SHIFT_JIS_E7_8E, &to_SHIFT_JIS_E7_8F,
     &to_SHIFT_JIS_E7_90, &to_SHIFT_JIS_E7_91,
     &to_SHIFT_JIS_E7_92, &to_SHIFT_JIS_E7_93,
     &to_SHIFT_JIS_E7_94, &to_SHIFT_JIS_E7_95,
     &to_SHIFT_JIS_E7_96, &to_SHIFT_JIS_E7_97,
     &to_SHIFT_JIS_E7_98, &to_SHIFT_JIS_E7_99,
     &to_SHIFT_JIS_E7_9A, &to_SHIFT_JIS_E7_9B,
     &to_SHIFT_JIS_E7_9C, &to_SHIFT_JIS_E7_9D,
     &to_SHIFT_JIS_E7_9E, &to_SHIFT_JIS_E7_9F,
     &to_SHIFT_JIS_E7_A0, &to_SHIFT_JIS_E7_A1,
     &to_SHIFT_JIS_E7_A2, &to_SHIFT_JIS_E7_A3,
     &to_SHIFT_JIS_E7_A4, &to_SHIFT_JIS_E7_A5,
     &to_SHIFT_JIS_E7_A6, &to_SHIFT_JIS_E7_A7,
     &to_SHIFT_JIS_E7_A8, &to_SHIFT_JIS_E7_A9,
     &to_SHIFT_JIS_E7_AA, &to_SHIFT_JIS_E7_AB,
     &to_SHIFT_JIS_E7_AC, &to_SHIFT_JIS_E7_AD,
     &to_SHIFT_JIS_E7_AE, &to_SHIFT_JIS_E7_AF,
     &to_SHIFT_JIS_E7_B0, &to_SHIFT_JIS_E7_B1,
     &to_SHIFT_JIS_E7_B2, &to_SHIFT_JIS_E7_B3,
     &to_SHIFT_JIS_E7_B4, &to_SHIFT_JIS_E7_B5,
     &to_SHIFT_JIS_E7_B6, &to_SHIFT_JIS_E7_B7,
     &to_SHIFT_JIS_E7_B8, &to_SHIFT_JIS_E7_B9,
     &to_SHIFT_JIS_E7_BA, &to_SHIFT_JIS_E7_BC,
     &to_SHIFT_JIS_E7_BD, &to_SHIFT_JIS_E7_BE,
     &to_SHIFT_JIS_E7_BF,               UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E7 = {
    to_SHIFT_JIS_E7_offsets,
    to_SHIFT_JIS_E7_infos
};

static const unsigned char
to_SHIFT_JIS_E8_80_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_80 */
  /* used from to_EUC_JP_E8_80 */
      0,  1, 22,  2,  3,  4,  5, 22,   22, 22, 22,  6,  7, 22, 22, 22,
      8, 22,  9, 22, 22, 10, 22, 11,   12, 13, 22, 22, 14, 22, 22, 22,
     22, 15, 22, 22, 22, 22, 22, 22,   16, 22, 22, 22, 22, 22, 22, 22,
     22, 22, 22, 17, 22, 22, 18, 22,   22, 22, 22, 19, 22, 20, 22, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_80_infos[23] = {
     o2(0x97,0x73), o2(0x98,0x56), o2(0x8D,0x6C), o2(0xE3,0xCC),
     o2(0x8E,0xD2), o2(0xE3,0xCB), o2(0xE3,0xCD), o2(0x8E,0xA7),
     o2(0x91,0xCF), o2(0xE3,0xCE), o2(0x8D,0x6B), o2(0x96,0xD5),
     o2(0xE3,0xCF), o2(0xE3,0xD0), o2(0xE3,0xD1), o2(0xE3,0xD2),
     o2(0xE3,0xD3), o2(0x8E,0xA8), o2(0x96,0xEB), o2(0xE3,0xD5),
     o2(0x92,0x5E), o2(0xE3,0xD4),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_80 = {
    to_SHIFT_JIS_E8_80_offsets,
    to_SHIFT_JIS_E8_80_infos
};

static const unsigned char
to_SHIFT_JIS_E8_81_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_81 */
  /* used from to_EUC_JP_E8_81 */
     22, 22, 22, 22, 22, 22,  0, 22,   22, 22,  1, 22, 22, 22, 22, 22,
     22, 22,  2, 22, 22, 22,  3, 22,    4, 22,  5, 22, 22, 22,  6,  7,
     22,  8,  9, 22, 22, 22, 22, 22,   10, 22, 22, 22, 22, 22, 22, 11,
     12, 22, 13, 14, 15, 22, 16, 17,   22, 18, 22, 22, 22, 19, 20, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_81_infos[23] = {
     o2(0xE3,0xD7), o2(0xE3,0xD6), o2(0xE3,0xD8), o2(0x90,0xB9),
     o2(0xE3,0xD9), o2(0xE3,0xDA), o2(0x95,0xB7), o2(0xE3,0xDB),
     o2(0x91,0x8F), o2(0xE3,0xDC), o2(0xE3,0xDD), o2(0x97,0xFC),
     o2(0xE3,0xE0), o2(0xE3,0xDF), o2(0xE3,0xDE), o2(0x92,0xAE),
     o2(0xE3,0xE1), o2(0x90,0x45), o2(0xE3,0xE2), o2(0xE3,0xE3),
     o2(0x98,0x57), o2(0xE3,0xE4),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_81 = {
    to_SHIFT_JIS_E8_81_offsets,
    to_SHIFT_JIS_E8_81_infos
};

static const unsigned char
to_SHIFT_JIS_E8_82_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_82 */
  /* used from to_EUC_JP_E8_82 */
     25, 25, 25, 25,  0,  1,  2,  3,   25,  4, 25,  5,  6, 25, 25, 25,
     25, 25, 25,  7, 25, 25,  8, 25,    9, 25, 10, 11, 25, 12, 25, 25,
     25, 13, 14, 25, 25, 15, 25, 25,   25, 16, 17, 25, 18, 19, 25, 20,
     25, 21, 22, 25, 23, 25, 25, 25,   25, 25, 24, 25, 25, 25, 25, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_82_infos[26] = {
     o2(0xE3,0xE5), o2(0xE3,0xE7), o2(0xE3,0xE6), o2(0x94,0xA3),
     o2(0x93,0xF7), o2(0x98,0x5D), o2(0x94,0xA7), o2(0xE3,0xE9),
     o2(0x8F,0xD1), o2(0x95,0x49), o2(0xE3,0xEA), o2(0xE3,0xE8),
     o2(0x8A,0xCC), o2(0x8C,0xD2), o2(0x8E,0x88), o2(0x94,0xEC),
     o2(0x8C,0xA8), o2(0x96,0x62), o2(0xE3,0xED), o2(0xE3,0xEB),
     o2(0x8D,0x6D), o2(0x8D,0x6E), o2(0x88,0xE7), o2(0x8D,0xE6),
     o2(0x94,0x78),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_82 = {
    to_SHIFT_JIS_E8_82_offsets,
    to_SHIFT_JIS_E8_82_infos
};

static const unsigned char
to_SHIFT_JIS_E8_83_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_83 */
  /* used from to_EUC_JP_E8_83 */
     20, 20, 20,  0,  1, 20,  2, 20,   20, 20, 20, 20,  3, 20,  4, 20,
     20, 20, 20, 20, 20, 20,  5, 20,   20,  6,  7,  8, 20,  9, 10, 20,
     20, 11, 20, 20, 12, 13, 20, 20,   20, 20, 20, 20, 20, 20, 20, 14,
     20, 15, 20, 20, 16, 20, 20, 20,   17, 20, 20, 20, 18, 19, 20, 20,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_83_infos[21] = {
     o2(0x88,0xDD), o2(0xE3,0xF2), o2(0x92,0x5F), o2(0x94,0x77),
     o2(0x91,0xD9), o2(0xE3,0xF4), o2(0xE3,0xF0), o2(0xE3,0xF3),
     o2(0xE3,0xEE), o2(0xE3,0xF1), o2(0x96,0x45), o2(0x8C,0xD3),
     o2(0x88,0xFB), o2(0xE3,0xEF), o2(0xE3,0xF6), o2(0xE3,0xF7),
     o2(0x93,0xB7), o2(0x8B,0xB9), o2(0xE4,0x45), o2(0x94,0x5C),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_83 = {
    to_SHIFT_JIS_E8_83_offsets,
    to_SHIFT_JIS_E8_83_infos
};

static const unsigned char
to_SHIFT_JIS_E8_84_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_84 */
  /* used from to_EUC_JP_E8_84 */
     16, 16,  0, 16, 16,  1,  2,  3,    4,  5,  6, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16,  7,  8, 16, 16, 16, 16,
     16, 16, 16,  9, 16, 16, 16, 16,   16, 10, 16, 16, 16, 16, 16, 11,
     16, 12, 16, 13, 16, 16, 16, 16,   16, 14, 16, 16, 16, 16, 15, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_84_infos[17] = {
     o2(0x8E,0x89), o2(0x8B,0xBA), o2(0x90,0xC6), o2(0x98,0x65),
     o2(0x96,0xAC), o2(0xE3,0xF5), o2(0x90,0xD2), o2(0x8B,0x72),
     o2(0xE3,0xF8), o2(0xE3,0xFA), o2(0xE3,0xF9), o2(0xE3,0xFB),
     o2(0x92,0x45), o2(0x94,0x5D), o2(0x92,0xAF), o2(0xE4,0x42),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_84 = {
    to_SHIFT_JIS_E8_84_offsets,
    to_SHIFT_JIS_E8_84_infos
};

static const unsigned char
to_SHIFT_JIS_E8_85_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_85 */
  /* used from to_EUC_JP_E8_85 */
     20, 20, 20, 20, 20, 20,  0, 20,   20, 20, 20,  1, 20, 20,  2, 20,
      3,  4, 20,  5,  6,  7, 20, 20,   20, 20, 20, 20, 20, 20, 20,  8,
     20, 20, 20, 20, 20,  9, 10, 20,   20, 20, 20, 11, 20, 20, 12, 20,
     13, 14, 20, 20, 15, 20, 20, 20,   16, 17, 18, 20, 20, 20, 20, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_85_infos[21] = {
     o2(0xE4,0x41), o2(0xE3,0xFC), o2(0x90,0x74), o2(0x95,0x85),
     o2(0xE4,0x44), o2(0xE4,0x43), o2(0x8D,0x6F), o2(0x98,0x72),
     o2(0xE4,0x54), o2(0xE4,0x48), o2(0xE4,0x49), o2(0x8E,0xEE),
     o2(0xE4,0x47), o2(0x8D,0x98), o2(0xE4,0x46), o2(0xE4,0x4A),
     o2(0x92,0xB0), o2(0x95,0xA0), o2(0x91,0x42), o2(0x91,0xDA),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_85 = {
    to_SHIFT_JIS_E8_85_offsets,
    to_SHIFT_JIS_E8_85_infos
};

static const unsigned char
to_SHIFT_JIS_E8_86_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_86 */
  /* used from to_EUC_JP_E8_86 */
      0, 24,  1,  2, 24, 24, 24, 24,    3, 24,  4, 24, 24, 24, 24,  5,
     24, 24, 24,  6, 24,  7, 24, 24,   24, 24,  8, 24,  9, 10, 24, 24,
     11, 24, 24, 12, 13, 24, 24, 24,   14, 15, 24, 24, 24, 24, 24, 24,
     16, 24, 24, 17, 24, 18, 24, 24,   19, 24, 20, 24, 24, 21, 22, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_86_infos[25] = {
     o2(0xE4,0x4E), o2(0xE4,0x4F), o2(0xE4,0x4B), o2(0xE4,0x4C),
     o2(0xE4,0x4D), o2(0x8D,0x70), o2(0xE4,0x55), o2(0xE4,0x51),
     o2(0x95,0x86), o2(0x96,0x8C), o2(0x95,0x47), o2(0xE4,0x50),
     o2(0xE4,0x53), o2(0xE4,0x52), o2(0x96,0x63), o2(0xE4,0x56),
     o2(0xE4,0x57), o2(0x91,0x56), o2(0xE4,0x58), o2(0xE4,0x5A),
     o2(0xE4,0x5E), o2(0xE4,0x5B), o2(0xE4,0x59), o2(0x94,0x5E),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_86 = {
    to_SHIFT_JIS_E8_86_offsets,
    to_SHIFT_JIS_E8_86_infos
};

static const unsigned char
to_SHIFT_JIS_E8_87_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_87 */
  /* used from to_EUC_JP_E8_87 */
      0, 25,  1, 25, 25, 25,  2, 25,    3,  4, 25, 25, 25,  5, 25, 25,
     25,  6, 25,  7, 25, 25, 25, 25,    8,  9, 10, 25, 25, 25, 25, 11,
     12, 25, 25, 13, 25, 14, 25, 15,   16, 25, 17, 25, 25, 18, 25, 25,
     25, 25, 25, 19, 20, 25, 25, 25,   25, 25, 21, 22, 23, 25, 24, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_87_infos[26] = {
     o2(0xE4,0x5C), o2(0xE4,0x5D), o2(0x89,0xB0), o2(0xE4,0x64),
     o2(0xE4,0x5F), o2(0xE4,0x60), o2(0xE4,0x61), o2(0x91,0x9F),
     o2(0xE4,0x63), o2(0xE4,0x62), o2(0xE4,0x65), o2(0xE4,0x66),
     o2(0xE4,0x67), o2(0x90,0x62), o2(0x89,0xE7), o2(0xE4,0x68),
     o2(0x97,0xD5), o2(0x8E,0xA9), o2(0x8F,0x4C), o2(0x8E,0x8A),
     o2(0x92,0x76), o2(0xE4,0x69), o2(0xE4,0x6A), o2(0x89,0x50),
     o2(0xE4,0x6B),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_87 = {
    to_SHIFT_JIS_E8_87_offsets,
    to_SHIFT_JIS_E8_87_infos
};

static const unsigned char
to_SHIFT_JIS_E8_88_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_88 */
  /* used from to_EUC_JP_E8_88 */
     30,  0,  1, 30, 30,  2, 30,  3,    4,  5,  6, 30,  7,  8,  9, 30,
     10, 30, 11, 30, 30, 30, 12, 13,   14, 30, 30, 15, 16, 30, 17, 18,
     30, 30, 30, 30, 30, 30, 30, 30,   30, 19, 20, 21, 22, 30, 23, 30,
     30, 30, 30, 24, 30, 25, 26, 27,   28, 29, 30, 30, 30, 30, 30, 30,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_88_infos[31] = {
     o2(0xE4,0x6C), o2(0xE4,0x6D), o2(0xE4,0x6E), o2(0xE4,0x6F),
     o2(0x8B,0xBB), o2(0x9D,0xA8), o2(0xE4,0x70), o2(0x90,0xE3),
     o2(0xE4,0x71), o2(0x8E,0xC9), o2(0xE4,0x72), o2(0x98,0xAE),
     o2(0xE4,0x73), o2(0x95,0xDC), o2(0x8A,0xDA), o2(0x91,0x43),
     o2(0x8F,0x77), o2(0x95,0x91), o2(0x8F,0x4D), o2(0xE4,0x74),
     o2(0x8D,0x71), o2(0xE4,0x75), o2(0x94,0xCA), o2(0xE4,0x84),
     o2(0xE4,0x77), o2(0x91,0xC7), o2(0x94,0x95), o2(0x8C,0xBD),
     o2(0xE4,0x76), o2(0x91,0x44),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_88 = {
    to_SHIFT_JIS_E8_88_offsets,
    to_SHIFT_JIS_E8_88_infos
};

static const unsigned char
to_SHIFT_JIS_E8_89_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_89 */
  /* used from to_EUC_JP_E8_89 */
      0, 21, 21, 21, 21, 21, 21,  1,   21, 21, 21, 21, 21, 21, 21, 21,
     21, 21, 21, 21, 21, 21, 21, 21,    2,  3,  4, 21, 21,  5, 21,  6,
     21, 21,  7, 21,  8, 21,  9, 21,   10, 21, 11, 12, 21, 21, 13, 14,
     21, 15, 16, 21, 21, 21, 17, 18,   19, 21, 21, 21, 21, 21, 20, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_89_infos[22] = {
     o2(0xE4,0x78), o2(0x92,0xF8), o2(0xE4,0x7A), o2(0xE4,0x79),
     o2(0xE4,0x7C), o2(0xE4,0x7B), o2(0xE4,0x7D), o2(0xE4,0x80),
     o2(0xE4,0x7E), o2(0x8A,0xCD), o2(0xE4,0x81), o2(0xE4,0x82),
     o2(0xE4,0x83), o2(0x8D,0xAF), o2(0x97,0xC7), o2(0xE4,0x85),
     o2(0x90,0x46), o2(0x89,0x90), o2(0xE4,0x86), o2(0xE4,0x87),
     o2(0xE4,0x88),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_89 = {
    to_SHIFT_JIS_E8_89_offsets,
    to_SHIFT_JIS_E8_89_infos
};

static const unsigned char
to_SHIFT_JIS_E8_8A_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_8A */
  /* used from to_EUC_JP_E8_8A */
     18, 18, 18, 18, 18, 18, 18, 18,   18, 18, 18,  0, 18,  1, 18, 18,
     18, 18,  2, 18, 18, 18, 18, 18,   18,  3, 18, 18, 18,  4, 18,  5,
     18, 18, 18, 18, 18,  6,  7, 18,   18, 18, 18,  8,  9, 10, 18, 11,
     18, 12, 18, 13, 18, 18, 18, 18,   14, 15, 18, 16, 18, 17, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_8A_infos[19] = {
     o2(0x88,0xF0), o2(0xE4,0x89), o2(0xE4,0x8A), o2(0x95,0x87),
     o2(0x8E,0xC5), o2(0xE4,0x8C), o2(0x8A,0x48), o2(0x88,0xB0),
     o2(0xE4,0x8B), o2(0xE4,0x8E), o2(0x94,0x6D), o2(0x90,0x63),
     o2(0x89,0xD4), o2(0x96,0x46), o2(0x8C,0x7C), o2(0x8B,0xDA),
     o2(0xE4,0x8D), o2(0x89,0xE8),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_8A = {
    to_SHIFT_JIS_E8_8A_offsets,
    to_SHIFT_JIS_E8_8A_infos
};

static const unsigned char
to_SHIFT_JIS_E8_8B_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_8B */
  /* used from to_EUC_JP_E8_8B */
     23, 23, 23, 23, 23,  0, 23, 23,   23, 23, 23, 23, 23, 23, 23, 23,
     23,  1,  2,  3,  4, 23, 23,  5,   23,  6, 23,  7,  8, 23,  9, 10,
     23, 11, 23, 12, 23, 13, 14, 15,   23, 23, 23, 16, 23, 23, 23, 23,
     23, 17, 23, 18, 19, 23, 23, 23,   23, 20, 21, 22, 23, 23, 23, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_8B_infos[24] = {
     o2(0x8A,0xA1), o2(0x89,0x91), o2(0xE4,0x92), o2(0x97,0xE8),
     o2(0x91,0xDB), o2(0x95,0x63), o2(0xE4,0x9E), o2(0x89,0xD5),
     o2(0xE4,0x9C), o2(0xE4,0x9A), o2(0xE4,0x91), o2(0xE4,0x8F),
     o2(0xE4,0x90), o2(0x8E,0xE1), o2(0x8B,0xEA), o2(0x92,0x97),
     o2(0x93,0xCF), o2(0x89,0x70), o2(0xE4,0x94), o2(0xE4,0x93),
     o2(0xE4,0x99), o2(0xE4,0x95), o2(0xE4,0x98),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_8B = {
    to_SHIFT_JIS_E8_8B_offsets,
    to_SHIFT_JIS_E8_8B_infos
};

static const unsigned char
to_SHIFT_JIS_E8_8C_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_8C */
  /* used from to_EUC_JP_E8_8C */
     23,  0,  1,  2,  3,  4,  5, 23,   23,  6, 23, 23, 23, 23,  7, 23,
     23, 23, 23, 23, 23, 23,  8,  9,   10, 23, 23, 23, 11, 23, 23, 23,
     23, 23, 23, 12, 23, 23, 23, 23,   13, 23, 23, 14, 23, 23, 23, 15,
     23, 16, 17, 23, 18, 19, 20, 23,   21, 22, 23, 23, 23, 23, 23, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_8C_infos[24] = {
     o2(0xFB,0x93), o2(0x96,0xCE), o2(0xE4,0x97), o2(0x89,0xD6),
     o2(0x8A,0x9D), o2(0xE4,0x9B), o2(0xE4,0x9D), o2(0x8C,0x73),
     o2(0xE4,0xA1), o2(0xE4,0xAA), o2(0xE4,0xAB), o2(0x88,0xA9),
     o2(0xE4,0xB2), o2(0x88,0xEF), o2(0xE4,0xA9), o2(0xE4,0xA8),
     o2(0xE4,0xA3), o2(0xE4,0xA2), o2(0xE4,0xA0), o2(0xE4,0x9F),
     o2(0x92,0x83), o2(0x91,0xF9), o2(0xE4,0xA5),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_8C = {
    to_SHIFT_JIS_E8_8C_offsets,
    to_SHIFT_JIS_E8_8C_infos
};

static const unsigned char
to_SHIFT_JIS_E8_8D_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_8D */
  /* used from to_EUC_JP_E8_8D */
      0, 15, 15, 15, 15,  1, 15, 15,   15,  2,  3, 15, 15, 15, 15,  4,
      5, 15,  6, 15, 15, 15, 15, 15,    7, 15, 15, 15, 15, 15, 15, 15,
     15, 15,  8, 15, 15, 15, 15, 15,   15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15,  9, 15, 10, 15, 11,   15, 15, 15, 12, 13, 15, 15, 14,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_8D_infos[16] = {
     o2(0xE4,0xA4), o2(0xE4,0xA7), o2(0x91,0x90), o2(0x8C,0x74),
     o2(0x89,0x60), o2(0xE4,0xA6), o2(0x8D,0x72), o2(0x91,0x91),
     o2(0xFB,0x94), o2(0xE4,0xB8), o2(0xE4,0xB9), o2(0x89,0xD7),
     o2(0x89,0xAC), o2(0xE4,0xB6), o2(0xFB,0x95),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_8D = {
    to_SHIFT_JIS_E8_8D_offsets,
    to_SHIFT_JIS_E8_8D_infos
};

static const unsigned char
to_SHIFT_JIS_E8_8E_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_8E */
  /* used from to_EUC_JP_E8_8E */
     18, 18, 18, 18, 18,  0, 18,  1,   18,  2,  3, 18, 18, 18,  4, 18,
     18, 18, 18,  5, 18, 18,  6, 18,   18, 18,  7, 18, 18, 18,  8,  9,
     10, 18, 11, 18, 18, 18, 18, 18,   12, 18, 13, 14, 18, 18, 18, 18,
     18, 15, 18, 18, 18, 16, 18, 18,   18, 18, 18, 18, 18, 17, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_8E_infos[19] = {
     o2(0xE4,0xAC), o2(0xE4,0xB4), o2(0xE4,0xBB), o2(0xE4,0xB5),
     o2(0xE4,0xB3), o2(0xE4,0x96), o2(0xE4,0xB1), o2(0xE4,0xAD),
     o2(0x8A,0xCE), o2(0xE4,0xAF), o2(0xE4,0xBA), o2(0xE4,0xB0),
     o2(0xE4,0xBC), o2(0xE4,0xAE), o2(0x94,0x9C), o2(0x97,0x89),
     o2(0xE4,0xB7), o2(0xE4,0xCD),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_8E = {
    to_SHIFT_JIS_E8_8E_offsets,
    to_SHIFT_JIS_E8_8E_infos
};

static const unsigned char
to_SHIFT_JIS_E8_8F_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_8F */
  /* used from to_EUC_JP_E8_8F */
     23,  0, 23, 23, 23,  1, 23,  2,   23, 23,  3, 23,  4, 23,  5, 23,
     23, 23, 23,  6, 23, 23,  7, 23,    8, 23, 23, 23,  9, 23, 23, 10,
     11, 23, 23, 23, 23, 23, 23, 23,   23, 12, 23, 13, 23, 23, 23, 14,
     15, 16, 17, 23, 18, 23, 19, 20,   23, 23, 23, 21, 23, 22, 23, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_8F_infos[24] = {
     o2(0xE4,0xC5), o2(0x90,0x9B), o2(0xFB,0x96), o2(0x8B,0x65),
     o2(0x8B,0xDB), o2(0xE4,0xC0), o2(0x89,0xD9), o2(0x8F,0xD2),
     o2(0xE4,0xC3), o2(0x8D,0xD8), o2(0x93,0x70), o2(0xE4,0xC8),
     o2(0x95,0xEC), o2(0xE4,0xBF), o2(0x89,0xD8), o2(0x8C,0xD4),
     o2(0x95,0x48), o2(0xE4,0xC9), o2(0xE4,0xBD), o2(0xFB,0x97),
     o2(0xE4,0xC6), o2(0xE4,0xD0), o2(0xE4,0xC1),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_8F = {
    to_SHIFT_JIS_E8_8F_offsets,
    to_SHIFT_JIS_E8_8F_infos
};

static const unsigned char
to_SHIFT_JIS_E8_90_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_90 */
  /* used from to_EUC_JP_E8_90 */
     18, 18, 18,  0,  1, 18, 18,  2,   18, 18, 18,  3,  4,  5,  6, 18,
     18, 18, 18,  7, 18, 18, 18, 18,   18, 18, 18, 18, 18, 18, 18, 18,
      8, 18,  9, 18, 18, 18, 18, 18,   18, 10, 11, 18, 12, 18, 18, 18,
     18, 13, 18, 18, 18, 14, 18, 18,   15, 18, 18, 18, 16, 17, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_90_infos[19] = {
     o2(0xE4,0xC2), o2(0x93,0xB8), o2(0xE4,0xC7), o2(0xE4,0xC4),
     o2(0x96,0x47), o2(0xE4,0xCA), o2(0x88,0xDE), o2(0xE4,0xBE),
     o2(0xE4,0xCC), o2(0xE4,0xCB), o2(0x94,0x8B), o2(0xE4,0xD2),
     o2(0xE4,0xDD), o2(0x8A,0x9E), o2(0xE4,0xE0), o2(0xE4,0xCE),
     o2(0xE4,0xD3), o2(0x97,0x8E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_90 = {
    to_SHIFT_JIS_E8_90_offsets,
    to_SHIFT_JIS_E8_90_infos
};

static const unsigned char
to_SHIFT_JIS_E8_91_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_91 */
  /* used from to_EUC_JP_E8_91 */
     21, 21, 21, 21, 21, 21,  0, 21,    1,  2, 21, 21, 21, 21,  3, 21,
     21, 21, 21, 21, 21, 21, 21,  4,   21, 21, 21,  5, 21, 21, 21, 21,
     21,  6,  7,  8, 21, 21,  9, 21,   21, 10, 21, 11, 12, 13, 14, 15,
     21, 16, 21, 21, 21, 17, 21, 18,   21, 19, 20, 21, 21, 21, 21, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_91_infos[22] = {
     o2(0xE4,0xDC), o2(0xFB,0x98), o2(0x97,0x74), o2(0x97,0xA8),
     o2(0x92,0x98), o2(0x8A,0x8B), o2(0x95,0x92), o2(0xE4,0xE2),
     o2(0x93,0x9F), o2(0x88,0xAF), o2(0xE4,0xDB), o2(0xE4,0xD7),
     o2(0x91,0x92), o2(0xE4,0xD1), o2(0xE4,0xD9), o2(0xE4,0xDE),
     o2(0x94,0x4B), o2(0x88,0xA8), o2(0xE4,0xD6), o2(0xE4,0xDF),
     o2(0x95,0x98),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_91 = {
    to_SHIFT_JIS_E8_91_offsets,
    to_SHIFT_JIS_E8_91_infos
};

static const unsigned char
to_SHIFT_JIS_E8_92_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_92 */
  /* used from to_EUC_JP_E8_92 */
     17, 17,  0, 17,  1, 17, 17, 17,   17, 17, 17,  2, 17, 17, 17, 17,
      3, 17, 17, 17,  4, 17, 17, 17,   17,  5, 17, 17,  6, 17, 17,  7,
     17,  8, 17, 17, 17, 17, 17, 17,   17, 17, 17, 17, 17,  9, 17, 17,
     17, 17, 10, 17, 11, 17, 17, 17,   12, 13, 17, 14, 15, 17, 17, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_92_infos[18] = {
     o2(0xE4,0xDA), o2(0xE4,0xD5), o2(0x8F,0xD3), o2(0x8F,0x4E),
     o2(0x8E,0xAA), o2(0x96,0xD6), o2(0x95,0x66), o2(0xE4,0xE5),
     o2(0xE4,0xEE), o2(0xE4,0xD8), o2(0x8A,0x97), o2(0xFB,0x99),
     o2(0x8F,0xF6), o2(0xE4,0xE3), o2(0xE4,0xE8), o2(0x91,0x93),
     o2(0xE4,0xE4),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_92 = {
    to_SHIFT_JIS_E8_92_offsets,
    to_SHIFT_JIS_E8_92_infos
};

static const unsigned char
to_SHIFT_JIS_E8_93_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_93 */
  /* used from to_EUC_JP_E8_93 */
     18,  0, 18, 18,  1, 18,  2, 18,   18,  3,  4,  5, 18,  6, 18, 18,
      7,  8, 18, 18, 18, 18,  9, 18,   18, 10, 11, 18, 12, 18, 18, 18,
     18, 18, 18, 18, 18, 18, 18, 18,   18, 18, 18, 18, 13, 18, 14, 18,
     18, 18, 18, 18, 15, 18, 18, 18,   18, 18, 18, 18, 16, 18, 18, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_93_infos[19] = {
     o2(0xE4,0xEB), o2(0x92,0x7E), o2(0xE4,0xEC), o2(0x97,0x75),
     o2(0xE4,0xE1), o2(0x8A,0x57), o2(0xE4,0xE7), o2(0xE4,0xEA),
     o2(0x96,0xAA), o2(0xE4,0xED), o2(0xE4,0xE6), o2(0xE4,0xE9),
     o2(0xFA,0x60), o2(0x96,0x48), o2(0x98,0x40), o2(0xE4,0xF1),
     o2(0xE4,0xF8), o2(0xE4,0xF0),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_93 = {
    to_SHIFT_JIS_E8_93_offsets,
    to_SHIFT_JIS_E8_93_infos
};

static const unsigned char
to_SHIFT_JIS_E8_94_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_94 */
  /* used from to_EUC_JP_E8_94 */
      0, 16, 16, 16, 16, 16,  1, 16,   16, 16, 16, 16, 16, 16, 16, 16,
     16,  2, 16,  3,  4,  5, 16,  6,    7, 16,  8, 16, 16, 16, 16,  9,
     16, 10, 16, 16, 16, 16, 11, 16,   16, 16, 16, 16, 12, 13, 16, 16,
     16, 16, 16, 16, 16, 14, 16, 16,   16, 16, 16, 16, 16, 15, 16, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_94_infos[17] = {
     o2(0x8E,0xC1), o2(0xE4,0xCF), o2(0x95,0xCC), o2(0x96,0xA0),
     o2(0xE4,0xF7), o2(0xE4,0xF6), o2(0xE4,0xF2), o2(0xE4,0xF3),
     o2(0x89,0x55), o2(0xE4,0xF5), o2(0xE4,0xEF), o2(0x92,0xD3),
     o2(0xE4,0xF4), o2(0x88,0xFC), o2(0x91,0xA0), o2(0x95,0xC1),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_94 = {
    to_SHIFT_JIS_E8_94_offsets,
    to_SHIFT_JIS_E8_94_infos
};

static const unsigned char
to_SHIFT_JIS_E8_95_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_95 */
  /* used from to_EUC_JP_E8_95 */
      0,  1, 22,  2, 22, 22, 22, 22,    3,  4,  5,  6, 22, 22,  7, 22,
     22, 22, 22,  8, 22,  9, 22, 10,   11, 12, 13, 22, 22, 22, 22, 22,
     22, 22, 22, 14, 22, 22, 22, 22,   15, 16, 17, 18, 22, 19, 22, 22,
     22, 22, 22, 22, 22, 22, 22, 20,   22, 22, 22, 22, 22, 22, 21, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_95_infos[23] = {
     o2(0xE4,0xF9), o2(0xE5,0x40), o2(0x94,0xD7), o2(0xE4,0xFC),
     o2(0x8F,0xD4), o2(0x8E,0xC7), o2(0xE5,0x42), o2(0x8B,0xBC),
     o2(0xFB,0x9A), o2(0xE5,0x43), o2(0x95,0x99), o2(0xE4,0xFB),
     o2(0xFB,0x9B), o2(0xE4,0xD4), o2(0xE4,0xFA), o2(0x98,0x6E),
     o2(0x93,0xA0), o2(0x95,0x93), o2(0xFB,0x9C), o2(0xE5,0x4A),
     o2(0xE5,0x50), o2(0xE5,0x51),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_95 = {
    to_SHIFT_JIS_E8_95_offsets,
    to_SHIFT_JIS_E8_95_infos
};

static const unsigned char
to_SHIFT_JIS_E8_96_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_96 */
  /* used from to_EUC_JP_E8_96 */
      0, 24, 24, 24,  1, 24, 24,  2,    3, 24,  4, 24, 24, 24, 24, 24,
      5,  6, 24, 24,  7, 24, 24,  8,   24,  9, 24, 10, 11, 24, 24, 24,
     24, 24, 24, 24, 12, 24, 13, 24,   14, 15, 16, 17, 18, 24, 19, 20,
     21, 24, 24, 24, 24, 24, 24, 24,   24, 22, 23, 24, 24, 24, 24, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_96_infos[25] = {
     o2(0xE5,0x44), o2(0x94,0x96), o2(0xE5,0x4E), o2(0xE5,0x46),
     o2(0xE5,0x48), o2(0xE5,0x52), o2(0xE5,0x47), o2(0xE5,0x4B),
     o2(0x89,0x92), o2(0x93,0xE3), o2(0xE5,0x4C), o2(0xE5,0x4F),
     o2(0xE5,0x45), o2(0x91,0x45), o2(0xE5,0x49), o2(0x8E,0x46),
     o2(0x90,0x64), o2(0x8C,0x4F), o2(0x96,0xF2), o2(0x96,0xF7),
     o2(0x8F,0x92), o2(0xFB,0x9E), o2(0xE5,0x56), o2(0xE5,0x54),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_96 = {
    to_SHIFT_JIS_E8_96_offsets,
    to_SHIFT_JIS_E8_96_infos
};

static const unsigned char
to_SHIFT_JIS_E8_97_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_97 */
  /* used from to_EUC_JP_E8_97 */
     17,  0, 17, 17, 17, 17, 17, 17,   17,  1, 17, 17, 17,  2, 17,  3,
      4, 17, 17, 17, 17,  5, 17, 17,   17, 17, 17, 17,  6,  7, 17, 17,
     17, 17, 17, 17,  8,  9, 17, 17,   17, 10, 11, 17, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 12,   17, 13, 14, 15, 17, 17, 16, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_97_infos[18] = {
     o2(0x98,0x6D), o2(0xE5,0x53), o2(0x97,0x95), o2(0xE5,0x55),
     o2(0xE5,0x57), o2(0xE5,0x58), o2(0xE5,0x5B), o2(0xE5,0x59),
     o2(0x93,0xA1), o2(0xE5,0x5A), o2(0x94,0xCB), o2(0xE5,0x4D),
     o2(0x8F,0x93), o2(0xE5,0x5C), o2(0xE5,0x61), o2(0x91,0x94),
     o2(0xE5,0x60),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_97 = {
    to_SHIFT_JIS_E8_97_offsets,
    to_SHIFT_JIS_E8_97_infos
};

static const unsigned char
to_SHIFT_JIS_E8_98_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_98 */
  /* used from to_EUC_JP_E8_98 */
     14, 14,  0, 14, 14, 14,  1,  2,   14, 14,  3,  4, 14, 14, 14, 14,
     14, 14, 14,  5, 14, 14,  6,  7,   14, 14,  8, 14, 14, 14, 14, 14,
     14, 14,  9, 14, 14, 14, 14, 14,   14, 14, 14, 14, 14, 10, 14, 11,
     12, 14, 14, 14, 14, 14, 14, 14,   14, 14, 14, 14, 14, 14, 14, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_98_infos[15] = {
     o2(0xE5,0x41), o2(0xE5,0x62), o2(0x91,0x68), o2(0xE5,0x5D),
     o2(0xE5,0x5F), o2(0xE5,0x5E), o2(0x9F,0x50), o2(0x9F,0x41),
     o2(0xE5,0x64), o2(0xE5,0x63), o2(0x97,0x96), o2(0xE1,0xBA),
     o2(0xE5,0x65), o2(0xE5,0x66),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_98 = {
    to_SHIFT_JIS_E8_98_offsets,
    to_SHIFT_JIS_E8_98_infos
};

static const unsigned char
to_SHIFT_JIS_E8_99_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_99 */
  /* used from to_EUC_JP_E8_99 */
     14, 14, 14, 14, 14, 14, 14, 14,   14, 14, 14, 14, 14,  0,  1, 14,
      2, 14, 14, 14,  3,  4, 14, 14,   14, 14,  5, 14,  6, 14,  7,  8,
     14, 14, 14, 14, 14, 14, 14,  9,   14, 14, 14, 10, 14, 14, 14, 14,
     14, 11, 14, 14, 14, 14, 14, 14,   14, 12, 14, 13, 14, 14, 14, 14,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_99_infos[15] = {
     o2(0xE5,0x67), o2(0x8C,0xD5), o2(0x8B,0x73), o2(0xE5,0x69),
     o2(0x99,0x7C), o2(0x8B,0x95), o2(0x97,0xB8), o2(0x8B,0xF1),
     o2(0xE5,0x6A), o2(0xE5,0x6B), o2(0x92,0x8E), o2(0xE5,0x6C),
     o2(0x93,0xF8), o2(0x88,0xB8),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_99 = {
    to_SHIFT_JIS_E8_99_offsets,
    to_SHIFT_JIS_E8_99_infos
};

static const unsigned char
to_SHIFT_JIS_E8_9A_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_9A */
  /* used from to_EUC_JP_E8_9A */
     13, 13, 13, 13, 13, 13, 13, 13,   13, 13,  0,  1,  2, 13, 13, 13,
     13, 13, 13,  3, 13,  4, 13, 13,   13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13,  5,  6, 13, 13, 13,   13,  7,  8,  9, 13, 13, 13, 10,
     11, 13, 13, 13, 13, 13, 12, 13,   13, 13, 13, 13, 13, 13, 13, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_9A_infos[14] = {
     o2(0x89,0xE1), o2(0xE5,0x71), o2(0xE5,0x72), o2(0xE5,0x6D),
     o2(0x8E,0x5C), o2(0xE5,0x6E), o2(0x94,0x61), o2(0xE5,0x6F),
     o2(0xE5,0x70), o2(0xE5,0x7A), o2(0xE5,0x74), o2(0xE5,0x77),
     o2(0xE5,0x73),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_9A = {
    to_SHIFT_JIS_E8_9A_offsets,
    to_SHIFT_JIS_E8_9A_infos
};

static const unsigned char
to_SHIFT_JIS_E8_9B_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_9B */
  /* used from to_EUC_JP_E8_9B */
     22, 22, 22, 22,  0, 22,  1,  2,   22,  3, 22,  4, 22,  5,  6, 22,
     22, 22, 22, 22,  7, 22, 22, 22,   22,  8, 22,  9, 22, 22, 10, 11,
     22, 22, 22, 22, 12, 22, 22, 22,   22, 13, 22, 22, 14, 15, 16, 17,
     22, 22, 22, 22, 22, 22, 22, 22,   18, 19, 22, 20, 22, 22, 21, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_9B_infos[23] = {
     o2(0xE5,0x75), o2(0xE5,0x76), o2(0x8E,0xD6), o2(0xE5,0x78),
     o2(0x92,0x60), o2(0x8C,0x75), o2(0x8A,0x61), o2(0xE5,0x7B),
     o2(0x8A,0x5E), o2(0xE5,0x81), o2(0xE5,0x7C), o2(0xE5,0x80),
     o2(0x94,0xB8), o2(0xE5,0x7D), o2(0xE5,0x7E), o2(0x95,0x67),
     o2(0x94,0xD8), o2(0xE5,0x82), o2(0x91,0xFB), o2(0xE5,0x8C),
     o2(0xE5,0x88), o2(0x89,0xE9),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_9B = {
    to_SHIFT_JIS_E8_9B_offsets,
    to_SHIFT_JIS_E8_9B_infos
};

static const unsigned char
to_SHIFT_JIS_E8_9C_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_9C */
  /* used from to_EUC_JP_E8_9C */
      0, 19,  1,  2, 19, 19,  3, 19,    4,  5,  6, 19, 19,  7, 19, 19,
     19,  8,  9, 19, 19, 19, 19, 19,   10, 19, 11, 19, 12, 19, 19, 19,
     19, 19, 19, 19, 19, 13, 19, 19,   19, 14, 19, 19, 19, 19, 19, 19,
     19, 19, 19, 19, 15, 19, 19, 16,   19, 19, 19, 17, 19, 19, 19, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_9C_infos[20] = {
     o2(0xE5,0x86), o2(0x96,0x49), o2(0xE5,0x87), o2(0xE5,0x84),
     o2(0xE5,0x85), o2(0xE5,0x8A), o2(0xE5,0x8D), o2(0xE5,0x8B),
     o2(0xE5,0x89), o2(0xE5,0x83), o2(0x92,0x77), o2(0xE5,0x94),
     o2(0x96,0xA8), o2(0xE5,0x92), o2(0xE5,0x93), o2(0xE5,0x8E),
     o2(0xE5,0x90), o2(0xE5,0x91), o2(0xE5,0x8F),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_9C = {
    to_SHIFT_JIS_E8_9C_offsets,
    to_SHIFT_JIS_E8_9C_infos
};

static const unsigned char
to_SHIFT_JIS_E8_9D_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_9D */
  /* used from to_EUC_JP_E8_9D */
     19, 19, 19, 19, 19, 19, 19, 19,   19,  0, 19,  1,  2, 19,  3, 19,
     19, 19, 19,  4, 19,  5, 19,  6,   19,  7, 19, 19, 19, 19, 19,  8,
      9, 19, 19, 10, 19, 19, 11, 19,   12, 19, 13, 19, 19, 19, 14, 19,
     19, 19, 19, 19, 15, 19, 16, 19,   17, 19, 19, 19, 19, 19, 19, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_9D_infos[20] = {
     o2(0x90,0xE4), o2(0x98,0x58), o2(0xE5,0x98), o2(0xE5,0x99),
     o2(0xE5,0x9F), o2(0x90,0x49), o2(0xE5,0x9B), o2(0xE5,0x9E),
     o2(0xE5,0x96), o2(0xE5,0x95), o2(0xE5,0xA0), o2(0x89,0xDA),
     o2(0xE5,0x9C), o2(0xE5,0xA1), o2(0xE5,0x9D), o2(0xE5,0x9A),
     o2(0x92,0xB1), o2(0xE5,0x97), o2(0x94,0x88),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_9D = {
    to_SHIFT_JIS_E8_9D_offsets,
    to_SHIFT_JIS_E8_9D_infos
};

static const unsigned char
to_SHIFT_JIS_E8_9E_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_9E */
  /* used from to_EUC_JP_E8_9E */
     10, 10,  0, 10, 10, 10, 10, 10,   10, 10, 10, 10, 10,  1, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,   10, 10, 10, 10, 10, 10, 10,  2,
     10, 10,  3, 10, 10, 10, 10, 10,   10, 10, 10,  4, 10, 10, 10,  5,
     10, 10, 10,  6, 10, 10, 10, 10,   10, 10,  7,  8, 10,  9, 10, 10,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_9E_infos[11] = {
     o2(0xE5,0xA5), o2(0x97,0x5A), o2(0xE5,0xA4), o2(0xE5,0xA3),
     o2(0xE5,0xAC), o2(0xE5,0xA6), o2(0xE5,0xAE), o2(0x97,0x86),
     o2(0xE5,0xB1), o2(0xE5,0xA8),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_9E = {
    to_SHIFT_JIS_E8_9E_offsets,
    to_SHIFT_JIS_E8_9E_infos
};

static const unsigned char
to_SHIFT_JIS_E8_9F_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_9F */
  /* used from to_EUC_JP_E8_9F */
      0, 15, 15, 15,  1, 15,  2,  3,   15, 15, 15,  4, 15, 15, 15, 15,
      5, 15,  6, 15, 15, 15, 15, 15,   15, 15, 15, 15, 15, 15, 15, 15,
      7, 15, 15, 15, 15, 15, 15, 15,   15, 15, 15, 15, 15, 15, 15,  8,
     15, 15,  9, 15, 15, 15, 10, 11,   15, 12, 15, 13, 15, 15, 14, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_9F_infos[16] = {
     o2(0xE5,0xA9), o2(0xE5,0xAD), o2(0xE5,0xB0), o2(0xE5,0xAF),
     o2(0xE5,0xA7), o2(0xE5,0xAA), o2(0xE5,0xBB), o2(0xE5,0xB4),
     o2(0xE5,0xB2), o2(0xE5,0xB3), o2(0xE5,0xB8), o2(0xE5,0xB9),
     o2(0x8A,0x49), o2(0x8B,0x61), o2(0xE5,0xB7),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_9F = {
    to_SHIFT_JIS_E8_9F_offsets,
    to_SHIFT_JIS_E8_9F_infos
};

static const unsigned char
to_SHIFT_JIS_E8_A0_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_A0 */
  /* used from to_EUC_JP_E8_A0 */
     16, 16, 16, 16, 16,  0, 16,  1,   16, 16, 16, 16, 16,  2,  3,  4,
     16,  5, 16, 16, 16,  6,  7, 16,   16, 16, 16, 16, 16, 16, 16, 16,
     16,  8,  9, 10, 16, 16, 16, 11,   16, 16, 16, 16, 16, 16, 16, 16,
     16, 12, 16, 16, 16, 16, 13, 16,   16, 14, 16, 15, 16, 16, 16, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_A0_infos[17] = {
     o2(0xE5,0xA2), o2(0xFB,0xA1), o2(0xE5,0xB6), o2(0xE5,0xBA),
     o2(0xE5,0xB5), o2(0xE5,0xBC), o2(0xE5,0xBE), o2(0xE5,0xBD),
     o2(0xE5,0xC0), o2(0xE5,0xBF), o2(0xE5,0x79), o2(0xE5,0xC4),
     o2(0xE5,0xC1), o2(0xE5,0xC2), o2(0xE5,0xC3), o2(0xE5,0xC5),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_A0 = {
    to_SHIFT_JIS_E8_A0_offsets,
    to_SHIFT_JIS_E8_A0_infos
};

static const unsigned char
to_SHIFT_JIS_E8_A1_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_A1 */
  /* used from to_EUC_JP_E8_A1 */
      0, 25,  1, 25,  2, 25,  3, 25,   25, 25, 25, 25,  4,  5, 25, 25,
     25, 25,  6,  7, 25, 25, 25,  8,   25,  9, 25, 10, 25, 11, 12, 25,
     25, 13, 14, 15, 25, 25, 25, 25,   16, 25, 25, 17, 25, 25, 25, 25,
     18, 25, 19, 25, 25, 20, 25, 21,   25, 25, 25, 25, 25, 22, 23, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_A1_infos[26] = {
     o2(0x8C,0x8C), o2(0xE5,0xC7), o2(0xE5,0xC6), o2(0x8F,0x4F),
     o2(0x8D,0x73), o2(0x9F,0xA5), o2(0xE5,0xC8), o2(0x8F,0x70),
     o2(0x8A,0x58), o2(0xE5,0xC9), o2(0x89,0x71), o2(0x8F,0xD5),
     o2(0xE5,0xCA), o2(0x8D,0x74), o2(0xE5,0xCB), o2(0x88,0xDF),
     o2(0x95,0x5C), o2(0xE5,0xCC), o2(0x90,0x8A), o2(0xE5,0xD3),
     o2(0xE5,0xD0), o2(0x92,0x8F), o2(0xE5,0xD1), o2(0xE5,0xCE),
     o2(0x8B,0xDC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_A1 = {
    to_SHIFT_JIS_E8_A1_offsets,
    to_SHIFT_JIS_E8_A1_infos
};

static const unsigned char
to_SHIFT_JIS_E8_A2_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_A2 */
  /* used from to_EUC_JP_E8_A2 */
     20,  0,  1, 20, 20, 20, 20, 20,    2, 20, 20,  3, 20,  4, 20, 20,
     20, 20,  5, 20, 20, 20,  6,  7,   20,  8, 20, 20, 20, 20,  9, 20,
     20, 20, 10, 20, 11, 20, 20, 20,   20, 20, 20, 12, 20, 20, 13, 20,
     14, 15, 20, 20, 16, 17, 20, 18,   20, 20, 20, 20, 20, 20, 20, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_A2_infos[21] = {
     o2(0xE5,0xCD), o2(0xE5,0xD4), o2(0x8C,0x55), o2(0x91,0xDC),
     o2(0xE5,0xDA), o2(0xE5,0xD6), o2(0x91,0xB3), o2(0xE5,0xD5),
     o2(0xE5,0xD8), o2(0xE5,0xCF), o2(0xE5,0xD9), o2(0xE5,0xDB),
     o2(0x94,0xED), o2(0xE5,0xD7), o2(0xE5,0xDC), o2(0xE5,0xDE),
     o2(0x8C,0xD1), o2(0xE5,0xD2), o2(0x88,0xBF), o2(0xE5,0xDD),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_A2 = {
    to_SHIFT_JIS_E8_A2_offsets,
    to_SHIFT_JIS_E8_A2_infos
};

static const unsigned char
to_SHIFT_JIS_E8_A3_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_A3 */
  /* used from to_EUC_JP_E8_A3 */
     24,  0,  1,  2,  3,  4, 24, 24,   24, 24, 24, 24, 24, 24, 24,  5,
     24, 24, 24, 24,  6,  7, 24, 24,    8,  9, 24, 24, 10, 11, 24, 12,
     24, 13, 24, 24, 24, 24, 24, 24,   14, 24, 24, 24, 24, 24, 24, 24,
     24, 24, 15, 16, 17, 18, 24, 24,   19, 20, 24, 24, 21, 22, 23, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_A3_infos[25] = {
     o2(0x8D,0xD9), o2(0x97,0xF4), o2(0xE5,0xDF), o2(0xE5,0xE0),
     o2(0x91,0x95), o2(0x97,0xA0), o2(0xE5,0xE1), o2(0x97,0x54),
     o2(0xE5,0xE2), o2(0xE5,0xE3), o2(0x95,0xE2), o2(0xE5,0xE4),
     o2(0x8D,0xBE), o2(0x97,0xA1), o2(0xE5,0xE9), o2(0xE5,0xEA),
     o2(0x8F,0xD6), o2(0xE5,0xE8), o2(0xFB,0xA2), o2(0x97,0x87),
     o2(0xE5,0xE5), o2(0xE5,0xE7), o2(0x90,0xBB), o2(0x90,0x9E),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_A3 = {
    to_SHIFT_JIS_E8_A3_offsets,
    to_SHIFT_JIS_E8_A3_infos
};

static const unsigned char
to_SHIFT_JIS_E8_A4_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_A4 */
  /* used from to_EUC_JP_E8_A4 */
     17, 17,  0, 17,  1, 17, 17,  2,   17, 17,  3, 17,  4, 17, 17, 17,
      5, 17,  6,  7, 17, 17, 17, 17,   17, 17, 17, 17,  8,  9, 10, 17,
     17, 17, 17, 17, 17, 11, 17, 17,   17, 17, 12, 13, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 14, 17,   15, 17, 17, 16, 17, 17, 17, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_A4_infos[18] = {
     o2(0xE5,0xE6), o2(0xE5,0xEB), o2(0x95,0xA1), o2(0xE5,0xED),
     o2(0xE5,0xEC), o2(0x8A,0x8C), o2(0x96,0x4A), o2(0xE5,0xEE),
     o2(0xFA,0x5D), o2(0xE5,0xFA), o2(0xE5,0xF0), o2(0xE5,0xF1),
     o2(0xE5,0xF2), o2(0xE5,0xF3), o2(0xE5,0xF7), o2(0xE5,0xF8),
     o2(0xE5,0xF6),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_A4 = {
    to_SHIFT_JIS_E8_A4_offsets,
    to_SHIFT_JIS_E8_A4_infos
};

static const unsigned char
to_SHIFT_JIS_E8_A5_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_A5 */
  /* used from to_EUC_JP_E8_A5 */
     19,  0, 19,  1,  2, 19, 19, 19,   19, 19, 19, 19,  3,  4, 19, 19,
     19, 19, 19, 19, 19, 19,  5, 19,   19, 19, 19, 19, 19, 19,  6,  7,
      8, 19, 19, 19,  9, 19, 10, 19,   19, 19, 11, 19, 19, 12, 19, 13,
     19, 19, 14, 19, 15, 19, 19, 16,   19, 19, 19, 19, 19, 19, 17, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_A5_infos[20] = {
     o2(0xE5,0xF4), o2(0xE5,0xEF), o2(0xE5,0xF5), o2(0xE5,0xF9),
     o2(0xE8,0xB5), o2(0x89,0xA6), o2(0xE5,0xFC), o2(0x8B,0xDD),
     o2(0xE5,0xFB), o2(0xE6,0x41), o2(0xE6,0x40), o2(0xE6,0x43),
     o2(0xE6,0x42), o2(0xE6,0x44), o2(0x8F,0x50), o2(0xE6,0x45),
     o2(0xE6,0x46), o2(0xE6,0x47), o2(0x90,0xBC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_A5 = {
    to_SHIFT_JIS_E8_A5_offsets,
    to_SHIFT_JIS_E8_A5_infos
};

static const unsigned char
to_SHIFT_JIS_E8_A6_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_A6 */
  /* used from to_EUC_JP_E8_A6 */
     25,  0, 25,  1, 25, 25,  2,  3,    4, 25,  5,  6, 25, 25, 25,  7,
     25, 25, 25,  8, 25, 25,  9, 10,   11, 25, 12, 25, 25, 25, 25, 25,
     25, 13, 25, 25, 25, 25, 14, 15,   25, 16, 17, 25, 18, 25, 25, 19,
     25, 25, 20, 21, 25, 25, 25, 25,   25, 25, 22, 25, 25, 23, 25, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_A6_infos[26] = {
     o2(0x97,0x76), o2(0xE6,0x48), o2(0x95,0xA2), o2(0x94,0x65),
     o2(0xE6,0x49), o2(0xE6,0x4A), o2(0x8C,0xA9), o2(0x8B,0x4B),
     o2(0xE6,0x4B), o2(0x8E,0x8B), o2(0x94,0x60), o2(0xE6,0x4C),
     o2(0x8A,0x6F), o2(0xE6,0x4D), o2(0xE6,0x4F), o2(0x97,0x97),
     o2(0xE6,0x4E), o2(0x90,0x65), o2(0xE6,0x50), o2(0xE6,0x51),
     o2(0xE6,0x52), o2(0x8A,0xCF), o2(0xE6,0x53), o2(0xE6,0x54),
     o2(0xE6,0x55),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_A6 = {
    to_SHIFT_JIS_E8_A6_offsets,
    to_SHIFT_JIS_E8_A6_infos
};

static const unsigned char
to_SHIFT_JIS_E8_A7_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_A7 */
  /* used from to_EUC_JP_E8_A7 */
      0, 10, 10, 10, 10, 10, 10, 10,   10, 10, 10, 10, 10, 10, 10, 10,
     10, 10,  1, 10, 10, 10, 10, 10,   10, 10,  2, 10,  3,  4, 10, 10,
     10, 10, 10,  5, 10, 10,  6,  7,   10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10,  8, 10, 10, 10,    9, 10, 10, 10, 10, 10, 10, 10,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_A7_infos[11] = {
     o2(0xE6,0x56), o2(0x8A,0x70), o2(0xE6,0x57), o2(0xE6,0x58),
     o2(0xE6,0x59), o2(0x89,0xF0), o2(0x90,0x47), o2(0xE6,0x5A),
     o2(0xE6,0x5B), o2(0xE6,0x5C),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_A7 = {
    to_SHIFT_JIS_E8_A7_offsets,
    to_SHIFT_JIS_E8_A7_infos
};

static const unsigned char
to_SHIFT_JIS_E8_A8_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_A8 */
  /* used from to_EUC_JP_E8_A8 */
      0, 28,  1,  2, 28, 28, 28, 28,    3, 28,  4, 28,  5, 28,  6, 28,
      7, 28,  8,  9, 28, 28, 10, 11,   12, 28, 28, 13, 28, 14, 28, 15,
     28, 28, 28, 16, 28, 17, 28, 28,   28, 28, 18, 28, 28, 19, 28, 28,
     28, 20, 28, 21, 22, 28, 23, 24,   28, 28, 25, 26, 27, 28, 28, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_A8_infos[29] = {
     o2(0x8C,0xBE), o2(0x92,0xF9), o2(0xE6,0x5D), o2(0x8C,0x76),
     o2(0x90,0x75), o2(0xE6,0x60), o2(0x93,0xA2), o2(0xE6,0x5F),
     o2(0xFB,0xA3), o2(0x8C,0x50), o2(0xE6,0x5E), o2(0x91,0xF5),
     o2(0x8B,0x4C), o2(0xE6,0x61), o2(0xE6,0x62), o2(0x8F,0xD7),
     o2(0x8C,0x8D), o2(0xE6,0x63), o2(0x96,0x4B), o2(0x90,0xDD),
     o2(0x8B,0x96), o2(0x96,0xF3), o2(0x91,0x69), o2(0xE6,0x64),
     o2(0xFB,0xA4), o2(0x90,0x66), o2(0x92,0x90), o2(0x8F,0xD8),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_A8 = {
    to_SHIFT_JIS_E8_A8_offsets,
    to_SHIFT_JIS_E8_A8_infos
};

static const unsigned char
to_SHIFT_JIS_E8_A9_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_A9 */
  /* used from to_EUC_JP_E8_A9 */
     25,  0, 25, 25, 25, 25,  1, 25,    2, 25, 25, 25, 25, 25, 25, 25,
      3,  4,  5, 25,  6,  7, 25, 25,   25, 25, 25,  8, 25, 25,  9, 25,
     10, 25, 11, 12, 25, 25, 13, 25,   25, 14, 25, 15, 16, 17, 18, 25,
     19, 20, 21, 22, 25, 25, 25, 25,   25, 23, 25, 25, 24, 25, 25, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_A9_infos[26] = {
     o2(0xE6,0x65), o2(0xE6,0x68), o2(0xE6,0x69), o2(0x8D,0xBC),
     o2(0x91,0xC0), o2(0xE6,0x67), o2(0x8F,0xD9), o2(0x95,0x5D),
     o2(0xE6,0x66), o2(0x8E,0x8C), o2(0x89,0x72), o2(0xE6,0x6D),
     o2(0x8C,0x77), o2(0x8E,0x8E), o2(0x8E,0x8D), o2(0x98,0x6C),
     o2(0xE6,0x6C), o2(0xE6,0x6B), o2(0x91,0x46), o2(0x8B,0x6C),
     o2(0x98,0x62), o2(0x8A,0x59), o2(0x8F,0xDA), o2(0xFB,0xA5),
     o2(0xE6,0x6A),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_A9 = {
    to_SHIFT_JIS_E8_A9_offsets,
    to_SHIFT_JIS_E8_A9_infos
};

static const unsigned char
to_SHIFT_JIS_E8_AA_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_AA */
  /* used from to_EUC_JP_E8_AA */
     29, 29,  0, 29,  1,  2, 29,  3,   29,  4, 29, 29,  5,  6, 29, 29,
     29,  7, 29,  8, 29,  9, 29, 29,   10, 29, 11, 29, 29, 29, 12, 29,
     13, 14, 29, 15, 16, 17, 18, 19,   20, 29, 29, 29, 21, 22, 29, 29,
     23, 29, 24, 29, 29, 29, 29, 29,   29, 25, 29, 29, 26, 29, 27, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_AA_infos[30] = {
     o2(0xE6,0x6F), o2(0xE6,0x70), o2(0xE6,0x6E), o2(0x8C,0xD6),
     o2(0x97,0x5F), o2(0x8E,0x8F), o2(0x94,0x46), o2(0xE6,0x73),
     o2(0x90,0xBE), o2(0x92,0x61), o2(0x97,0x55), o2(0xE6,0x76),
     o2(0x8C,0xEA), o2(0x90,0xBD), o2(0xE6,0x72), o2(0xE6,0x77),
     o2(0x8C,0xEB), o2(0xE6,0x74), o2(0xE6,0x75), o2(0xFB,0xA6),
     o2(0xE6,0x71), o2(0x90,0xE0), o2(0x93,0xC7), o2(0x92,0x4E),
     o2(0x89,0xDB), o2(0x94,0xEE), o2(0x8B,0x62), o2(0xFB,0xA7),
     o2(0x92,0xB2),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_AA = {
    to_SHIFT_JIS_E8_AA_offsets,
    to_SHIFT_JIS_E8_AA_infos
};

static const unsigned char
to_SHIFT_JIS_E8_AB_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_AB */
  /* used from to_EUC_JP_E8_AB */
     30, 30,  0, 30,  1, 30, 30,  2,   30, 30, 30,  3,  4,  5, 30,  6,
     30, 30,  7, 30, 30, 30,  8, 30,   30, 30,  9, 10, 11, 30, 12, 13,
     14, 15, 16, 30, 17, 30, 18, 19,   30, 30, 30, 20, 30, 21, 22, 30,
     30, 23, 30, 24, 30, 30, 25, 26,   27, 30, 28, 30, 30, 30, 29, 30,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_AB_infos[31] = {
     o2(0xE6,0x7A), o2(0xE6,0x78), o2(0x92,0x6B), o2(0x90,0xBF),
     o2(0x8A,0xD0), o2(0xE6,0x79), o2(0x90,0x7A), o2(0x97,0xC8),
     o2(0x98,0x5F), o2(0xE6,0x7B), o2(0xE6,0x87), o2(0x92,0xB3),
     o2(0xE6,0x86), o2(0xFB,0xA8), o2(0xE6,0x83), o2(0xE6,0x8B),
     o2(0xE6,0x84), o2(0xE6,0x80), o2(0x92,0xFA), o2(0xE6,0x7E),
     o2(0xE6,0x7C), o2(0x97,0x40), o2(0x8E,0x90), o2(0xE6,0x81),
     o2(0xE6,0x7D), o2(0xFB,0xAA), o2(0xE6,0x85), o2(0x8F,0x94),
     o2(0x8C,0xBF), o2(0x91,0xF8),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_AB = {
    to_SHIFT_JIS_E8_AB_offsets,
    to_SHIFT_JIS_E8_AB_infos
};

static const unsigned char
to_SHIFT_JIS_E8_AC_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_AC */
  /* used from to_EUC_JP_E8_AC */
      0,  1,  2, 24,  3, 24, 24,  4,   24, 24, 24, 24,  5, 24,  6, 24,
      7, 24, 24, 24,  8, 24,  9, 10,   24, 11, 12, 13, 24, 14, 24, 24,
     15, 16, 24, 24, 24, 24, 17, 24,   18, 24, 24, 19, 20, 24, 24, 24,
     24, 24, 24, 21, 24, 24, 24, 24,   24, 22, 24, 24, 24, 24, 23, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_AC_infos[25] = {
     o2(0x96,0x64), o2(0x89,0x79), o2(0x88,0xE0), o2(0x93,0xA3),
     o2(0xE6,0x89), o2(0xE6,0x88), o2(0x93,0xE4), o2(0xE6,0x8D),
     o2(0xE6,0x82), o2(0xE6,0x8C), o2(0xE6,0x8E), o2(0x8C,0xAA),
     o2(0xE6,0x8A), o2(0x8D,0x75), o2(0x8E,0xD3), o2(0xE6,0x8F),
     o2(0x97,0x77), o2(0xE6,0x92), o2(0xE6,0x95), o2(0xE6,0x93),
     o2(0x95,0x54), o2(0xE6,0x90), o2(0x8B,0xDE), o2(0xE6,0x94),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_AC = {
    to_SHIFT_JIS_E8_AC_offsets,
    to_SHIFT_JIS_E8_AC_infos
};

static const unsigned char
to_SHIFT_JIS_E8_AD_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_AD */
  /* used from to_EUC_JP_E8_AD */
     23,  0, 23, 23, 23, 23, 23, 23,   23,  1, 23, 23,  2, 23,  3,  4,
     23, 23, 23,  5, 23, 23,  6, 23,    7, 23,  8,  9, 10, 23, 23, 11,
     23, 23, 23, 23, 23, 23, 12, 23,   23, 23, 23, 13, 14, 23, 23, 15,
     16, 17, 18, 23, 19, 23, 23, 20,   23, 23, 23, 23, 23, 21, 23, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_AD_infos[24] = {
     o2(0xE6,0x96), o2(0xE6,0x9A), o2(0xE6,0x97), o2(0xE6,0x99),
     o2(0xE6,0x98), o2(0xFB,0xAB), o2(0xE6,0x9B), o2(0x8E,0xAF),
     o2(0xE6,0x9D), o2(0xE6,0x9C), o2(0x95,0x88), o2(0xE6,0x9F),
     o2(0x8C,0x78), o2(0xE6,0x9E), o2(0xE6,0xA0), o2(0xE6,0xA1),
     o2(0x8B,0x63), o2(0xE3,0xBF), o2(0x8F,0xF7), o2(0xE6,0xA2),
     o2(0x8C,0xEC), o2(0xE6,0xA3), o2(0xFB,0xAC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_AD = {
    to_SHIFT_JIS_E8_AD_offsets,
    to_SHIFT_JIS_E8_AD_infos
};

static const unsigned char
to_SHIFT_JIS_E8_AE_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_AE */
  /* used from to_EUC_JP_E8_AE */
      0, 11, 11,  1, 11, 11, 11, 11,   11, 11,  2, 11,  3, 11,  4, 11,
      5, 11,  6,  7, 11, 11,  8, 11,   11,  9, 10, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,   11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,   11, 11, 11, 11, 11, 11, 11, 11,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_AE_infos[12] = {
     o2(0xE6,0xA4), o2(0x8E,0x5D), o2(0x9D,0xCC), o2(0xE6,0xA5),
     o2(0xE6,0xA6), o2(0x8F,0x51), o2(0xE6,0xA7), o2(0xE6,0xA8),
     o2(0xE6,0xA9), o2(0xE6,0xAA), o2(0xE6,0xAB),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_AE = {
    to_SHIFT_JIS_E8_AE_offsets,
    to_SHIFT_JIS_E8_AE_infos
};

static const unsigned char
to_SHIFT_JIS_E8_B0_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_B0 */
  /* used from to_EUC_JP_E8_B0 */
      3,  3,  3,  3,  3,  3,  3,  3,    3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,    3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,    3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  0,    3,  3,  1,  3,  3,  3,  3,  2,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_B0_infos[4] = {
     o2(0x92,0x4A), o2(0xE6,0xAC), o2(0xE6,0xAE),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_B0 = {
    to_SHIFT_JIS_E8_B0_offsets,
    to_SHIFT_JIS_E8_B0_infos
};

static const unsigned char
to_SHIFT_JIS_E8_B1_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_B1 */
  /* used from to_EUC_JP_E8_B1 */
     18,  0, 18, 18, 18, 18,  1, 18,    2, 18,  3, 18,  4, 18,  5, 18,
      6, 18, 18, 18, 18,  7, 18, 18,   18, 18,  8, 18, 18, 18, 18, 18,
     18,  9, 10, 18, 18, 18, 18, 18,   18, 18, 11, 12, 13, 18, 18, 18,
     18, 18, 18, 18, 18, 18, 18, 18,   14, 15, 16, 18, 17, 18, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_B1_infos[19] = {
     o2(0xE6,0xAD), o2(0x93,0xA4), o2(0xE6,0xAF), o2(0x96,0x4C),
     o2(0xE6,0xB0), o2(0xE6,0xB1), o2(0xE6,0xB2), o2(0xE6,0xB3),
     o2(0x93,0xD8), o2(0x8F,0xDB), o2(0xE6,0xB4), o2(0x8D,0x8B),
     o2(0x98,0xAC), o2(0xE6,0xB5), o2(0xE6,0xB6), o2(0x95,0x5E),
     o2(0xE6,0xB7), o2(0xE6,0xBF),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_B1 = {
    to_SHIFT_JIS_E8_B1_offsets,
    to_SHIFT_JIS_E8_B1_infos
};

static const unsigned char
to_SHIFT_JIS_E8_B2_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_B2 */
  /* used from to_EUC_JP_E8_B2 */
     34, 34,  0, 34, 34,  1, 34, 34,   34,  2,  3, 34,  4,  5,  6, 34,
     34, 34, 34, 34,  7, 34, 34, 34,    8, 34, 34, 34, 34,  9, 10, 34,
     11, 12, 13, 34, 34, 34, 34, 14,   15, 16, 17, 18, 19, 20, 21, 22,
     23, 34, 24, 25, 26, 34, 27, 28,   29, 34, 34, 30, 31, 32, 34, 33,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_B2_infos[35] = {
     o2(0xE6,0xB8), o2(0xE6,0xBA), o2(0xE6,0xB9), o2(0xE6,0xBB),
     o2(0x96,0x65), o2(0xE6,0xBC), o2(0xE6,0xBD), o2(0xE6,0xBE),
     o2(0xE6,0xC0), o2(0x8A,0x4C), o2(0x92,0xE5), o2(0x95,0x89),
     o2(0x8D,0xE0), o2(0x8D,0x76), o2(0x95,0x6E), o2(0x89,0xDD),
     o2(0x94,0xCC), o2(0xE6,0xC3), o2(0x8A,0xD1), o2(0x90,0xD3),
     o2(0xE6,0xC2), o2(0xE6,0xC7), o2(0x92,0x99), o2(0x96,0xE1),
     o2(0xE6,0xC5), o2(0xE6,0xC6), o2(0x8B,0x4D), o2(0xE6,0xC8),
     o2(0x94,0x83), o2(0x91,0xDD), o2(0x94,0xEF), o2(0x93,0x5C),
     o2(0xE6,0xC4), o2(0x96,0x66),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_B2 = {
    to_SHIFT_JIS_E8_B2_offsets,
    to_SHIFT_JIS_E8_B2_infos
};

static const unsigned char
to_SHIFT_JIS_E8_B3_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_B3 */
  /* used from to_EUC_JP_E8_B3 */
      0,  1,  2,  3,  4, 29, 29,  5,    6, 29,  7, 29, 29,  8,  9, 29,
     29, 10, 29, 11, 29, 29, 29, 29,   29, 29, 12, 13, 14, 29, 15, 29,
     16, 29, 17, 18, 19, 29, 20, 29,   29, 29, 21, 29, 29, 22, 29, 29,
     23, 29, 29, 29, 24, 29, 29, 29,   29, 29, 25, 26, 27, 28, 29, 29,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_B3_infos[30] = {
     o2(0x89,0xEA), o2(0xE6,0xCA), o2(0x98,0x47), o2(0x92,0xC0),
     o2(0x98,0x64), o2(0x8E,0x91), o2(0xE6,0xC9), o2(0x91,0xAF),
     o2(0xE6,0xDA), o2(0x91,0x47), o2(0x93,0xF6), o2(0x95,0x6F),
     o2(0xE6,0xCD), o2(0x8E,0x5E), o2(0x8E,0x92), o2(0x8F,0xDC),
     o2(0x94,0x85), o2(0x8C,0xAB), o2(0xE6,0xCC), o2(0xE6,0xCB),
     o2(0x95,0x8A), o2(0x8E,0xBF), o2(0x93,0x71), o2(0xFB,0xAD),
     o2(0xFB,0xAE), o2(0xE6,0xCF), o2(0xE6,0xD0), o2(0x8D,0x77),
     o2(0xE6,0xCE),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_B3 = {
    to_SHIFT_JIS_E8_B3_offsets,
    to_SHIFT_JIS_E8_B3_infos
};

static const unsigned char
to_SHIFT_JIS_E8_B4_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_B4 */
  /* used from to_EUC_JP_E8_B4 */
     13, 13, 13, 13,  0,  1, 13,  2,    3, 13,  4,  5, 13,  6, 13,  7,
      8, 13,  9, 10, 11, 13, 12, 13,   13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,   13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,   13, 13, 13, 13, 13, 13, 13, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_B4_infos[14] = {
     o2(0xE6,0xD1), o2(0xE6,0xD2), o2(0xE6,0xD4), o2(0x91,0xA1),
     o2(0xE6,0xD3), o2(0x8A,0xE4), o2(0xE6,0xD6), o2(0xE6,0xD5),
     o2(0xE6,0xD7), o2(0xFB,0xAF), o2(0xE6,0xD9), o2(0xE6,0xDB),
     o2(0xE6,0xDC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_B4 = {
    to_SHIFT_JIS_E8_B4_offsets,
    to_SHIFT_JIS_E8_B4_infos
};

static const unsigned char
to_SHIFT_JIS_E8_B5_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_B5 */
  /* used from to_EUC_JP_E8_B5 */
     11, 11, 11, 11, 11, 11, 11, 11,   11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11, 11, 11, 11, 11,   11, 11, 11, 11, 11, 11, 11, 11,
     11, 11, 11, 11,  0, 11,  1,  2,   11, 11, 11,  3, 11,  4, 11, 11,
      5,  6, 11,  7,  8, 11,  9, 10,   11, 11, 11, 11, 11, 11, 11, 11,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_B5_infos[12] = {
     o2(0x90,0xD4), o2(0x8E,0xCD), o2(0xE6,0xDD), o2(0x8A,0x71),
     o2(0xE6,0xDE), o2(0x91,0x96), o2(0xE6,0xDF), o2(0xE6,0xE0),
     o2(0x95,0x8B), o2(0xFB,0xB0), o2(0x8B,0x4E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_B5 = {
    to_SHIFT_JIS_E8_B5_offsets,
    to_SHIFT_JIS_E8_B5_infos
};

static const unsigned char
to_SHIFT_JIS_E8_B6_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_B6 */
  /* used from to_EUC_JP_E8_B6 */
      9,  0,  9,  9,  9,  1,  9,  9,    9,  9,  2,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,    9,  3,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  4,  9,  9,  9,  9,    5,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  6,  9,  9,  9,  9,    9,  9,  7,  9,  9,  9,  8,  9,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_B6_infos[10] = {
     o2(0xE6,0xE1), o2(0x92,0xB4), o2(0x89,0x7A), o2(0xE6,0xE2),
     o2(0x8E,0xEF), o2(0x90,0x96), o2(0x91,0xAB), o2(0xE6,0xE5),
     o2(0xE6,0xE4),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_B6 = {
    to_SHIFT_JIS_E8_B6_offsets,
    to_SHIFT_JIS_E8_B6_infos
};

static const unsigned char
to_SHIFT_JIS_E8_B7_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_B7 */
  /* used from to_EUC_JP_E8_B7 */
     19, 19,  0, 19, 19, 19, 19, 19,   19, 19, 19,  1,  2, 19, 19,  3,
     19, 19, 19, 19, 19, 19,  4, 19,   19, 19,  5,  6, 19,  7, 19,  8,
     19,  9, 19, 10, 19, 19, 19, 19,   11, 19, 12, 13, 19, 19, 19, 14,
     19, 19, 19, 15, 19, 16, 19, 19,   19, 19, 19, 19, 17, 19, 19, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_B7_infos[20] = {
     o2(0xE6,0xE3), o2(0xE6,0xEB), o2(0xE6,0xE9), o2(0xE6,0xE6),
     o2(0xE6,0xE8), o2(0xE6,0xE7), o2(0xE6,0xEA), o2(0x8B,0x97),
     o2(0xE6,0xEE), o2(0x90,0xD5), o2(0xE6,0xEF), o2(0x8C,0xD7),
     o2(0xE6,0xEC), o2(0xE6,0xED), o2(0x98,0x48), o2(0x92,0xB5),
     o2(0x91,0x48), o2(0xE6,0xF0), o2(0xE6,0xF3),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_B7 = {
    to_SHIFT_JIS_E8_B7_offsets,
    to_SHIFT_JIS_E8_B7_infos
};

static const unsigned char
to_SHIFT_JIS_E8_B8_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_B8 */
  /* used from to_EUC_JP_E8_B8 */
     12, 12, 12, 12, 12, 12, 12, 12,    0,  1,  2, 12, 12, 12, 12,  3,
      4, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12, 12,  5,  6,  7,
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12,  8, 12, 12, 12, 12, 12,
      9, 12, 12, 12, 10, 11, 12, 12,   12, 12, 12, 12, 12, 12, 12, 12,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_B8_infos[13] = {
     o2(0xE6,0xF1), o2(0xE6,0xF2), o2(0x97,0x78), o2(0x93,0xA5),
     o2(0xE6,0xF6), o2(0xE6,0xF4), o2(0xE6,0xF5), o2(0xE6,0xF7),
     o2(0xE7,0x48), o2(0xE6,0xFA), o2(0xE6,0xFB), o2(0xE6,0xF9),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_B8 = {
    to_SHIFT_JIS_E8_B8_offsets,
    to_SHIFT_JIS_E8_B8_infos
};

static const unsigned char
to_SHIFT_JIS_E8_B9_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_B9 */
  /* used from to_EUC_JP_E8_B9 */
     18, 18,  0, 18,  1, 18, 18,  2,    3,  4,  5, 18,  6, 18, 18, 18,
      7, 18, 18, 18, 18,  8, 18, 18,   18,  9, 18, 18, 18, 18, 18, 10,
     11, 18, 18, 12, 13, 18, 18, 18,   18, 18, 18, 18, 18, 18, 18, 18,
     18, 18, 14, 18, 15, 18, 16, 18,   18, 18, 18, 18, 17, 18, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_B9_infos[19] = {
     o2(0xE6,0xF8), o2(0x92,0xFB), o2(0xE7,0x40), o2(0xE7,0x44),
     o2(0xE7,0x41), o2(0xE6,0xFC), o2(0xE7,0x42), o2(0xE7,0x43),
     o2(0xE7,0x4A), o2(0xE7,0x45), o2(0x90,0xD6), o2(0xE7,0x47),
     o2(0xE7,0x49), o2(0xE7,0x46), o2(0xE7,0x4C), o2(0x8F,0x52),
     o2(0xE7,0x4B), o2(0xE7,0x4D),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_B9 = {
    to_SHIFT_JIS_E8_B9_offsets,
    to_SHIFT_JIS_E8_B9_infos
};

static const unsigned char
to_SHIFT_JIS_E8_BA_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_BA */
  /* used from to_EUC_JP_E8_BA */
     19,  0, 19, 19,  1,  2, 19,  3,   19, 19,  4,  5, 19,  6, 19, 19,
     19,  7, 19,  8,  9, 19, 19, 19,   19, 10, 19, 19, 19, 19, 19, 19,
     19, 11, 19, 19, 19, 19, 19, 19,   19, 19, 12, 13, 14, 19, 19, 15,
     16, 17, 19, 19, 19, 19, 19, 19,   19, 19, 19, 19, 19, 19, 18, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_BA_infos[20] = {
     o2(0xE7,0x4E), o2(0xE7,0x51), o2(0xE7,0x50), o2(0xE7,0x4F),
     o2(0xE7,0x53), o2(0xE7,0x52), o2(0x96,0xF4), o2(0xE7,0x55),
     o2(0xE7,0x54), o2(0xE7,0x56), o2(0xE7,0x57), o2(0xE7,0x59),
     o2(0xE7,0x58), o2(0x90,0x67), o2(0xE7,0x5A), o2(0x8B,0xEB),
     o2(0xE7,0x5B), o2(0xE7,0x5D), o2(0xE7,0x5E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_BA = {
    to_SHIFT_JIS_E8_BA_offsets,
    to_SHIFT_JIS_E8_BA_infos
};

static const unsigned char
to_SHIFT_JIS_E8_BB_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_BB */
  /* used from to_EUC_JP_E8_BB */
     19, 19, 19, 19, 19,  0,  1, 19,    2, 19,  3,  4,  5,  6, 19,  7,
     19, 19,  8, 19, 19, 19, 19, 19,   19, 19, 19,  9, 19, 19, 19, 10,
     19, 19, 11, 12, 19, 19, 19, 19,   19, 19, 19, 13, 19, 19, 19, 19,
     19, 19, 19, 19, 19, 19, 19, 19,   14, 19, 19, 15, 16, 17, 18, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_BB_infos[20] = {
     o2(0xE7,0x5F), o2(0xE7,0x5C), o2(0xE7,0x60), o2(0x8E,0xD4),
     o2(0xE7,0x61), o2(0x8B,0x4F), o2(0x8C,0x52), o2(0xFB,0xB2),
     o2(0x8C,0xAC), o2(0xE7,0x62), o2(0x93,0xEE), o2(0x93,0x5D),
     o2(0xE7,0x63), o2(0xE7,0x66), o2(0x8E,0xB2), o2(0xE7,0x65),
     o2(0xE7,0x64), o2(0x8C,0x79), o2(0xE7,0x67),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_BB = {
    to_SHIFT_JIS_E8_BB_offsets,
    to_SHIFT_JIS_E8_BB_infos
};

static const unsigned char
to_SHIFT_JIS_E8_BC_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_BC */
  /* used from to_EUC_JP_E8_BC */
     24, 24, 24,  0, 24,  1, 24, 24,   24,  2,  3, 24,  4, 24, 24, 24,
     24, 24,  5,  6,  7,  8, 24, 24,   24,  9, 24, 10, 11, 12, 24, 13,
     24, 24, 24, 24, 24, 24, 14, 24,   24, 15, 16, 24, 24, 24, 24, 17,
     24, 24, 24, 18, 24, 24, 24, 24,   19, 20, 24, 21, 24, 24, 22, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_BC_infos[25] = {
     o2(0x8A,0x72), o2(0xE7,0x69), o2(0x8D,0xDA), o2(0xE7,0x68),
     o2(0xE7,0x71), o2(0xE7,0x6B), o2(0xE7,0x6D), o2(0x95,0xE3),
     o2(0xE7,0x6A), o2(0xE7,0x6C), o2(0xE7,0x70), o2(0xE7,0x6E),
     o2(0x8B,0x50), o2(0xE7,0x6F), o2(0xE7,0x72), o2(0x94,0x79),
     o2(0x97,0xD6), o2(0x8F,0x53), o2(0xE7,0x73), o2(0x97,0x41),
     o2(0xE7,0x75), o2(0xE7,0x74), o2(0xE7,0x78), o2(0x97,0x60),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_BC = {
    to_SHIFT_JIS_E8_BC_offsets,
    to_SHIFT_JIS_E8_BC_infos
};

static const unsigned char
to_SHIFT_JIS_E8_BD_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_BD */
  /* used from to_EUC_JP_E8_BD */
     15, 15,  0, 15,  1,  2,  3, 15,   15,  4, 15, 15,  5,  6,  7, 15,
     15, 15, 15, 15, 15, 15, 15,  8,   15, 15, 15, 15,  9, 15, 15, 10,
     15, 11, 12, 13, 14, 15, 15, 15,   15, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,   15, 15, 15, 15, 15, 15, 15, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_BD_infos[16] = {
     o2(0xE7,0x77), o2(0x8A,0x8D), o2(0xE7,0x76), o2(0xE7,0x7B),
     o2(0xE7,0x7A), o2(0xE7,0x79), o2(0x93,0x51), o2(0xE7,0x7C),
     o2(0xE7,0x7D), o2(0xE7,0x7E), o2(0x8D,0x8C), o2(0x8C,0x44),
     o2(0xE7,0x80), o2(0xE7,0x81), o2(0xE7,0x82),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_BD = {
    to_SHIFT_JIS_E8_BD_offsets,
    to_SHIFT_JIS_E8_BD_infos
};

static const unsigned char
to_SHIFT_JIS_E8_BE_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_BE */
  /* used from to_EUC_JP_E8_BE */
     18, 18, 18, 18, 18, 18, 18, 18,   18, 18, 18, 18, 18, 18, 18, 18,
     18, 18, 18, 18, 18, 18, 18, 18,   18, 18, 18,  0,  1, 18,  2,  3,
     18, 18, 18,  4, 18, 18, 18,  5,    6, 18, 18, 18, 18,  7,  8,  9,
     10, 11, 12, 18, 18, 18, 18, 13,   18, 18, 14, 15, 16, 18, 18, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_BE_infos[19] = {
     o2(0x90,0x68), o2(0xE7,0x83), o2(0x8E,0xAB), o2(0xE7,0x84),
     o2(0xE7,0x85), o2(0x99,0x9F), o2(0x99,0x9E), o2(0xE7,0x86),
     o2(0xE3,0x90), o2(0xE7,0x87), o2(0x92,0x43), o2(0x90,0x4A),
     o2(0x94,0x5F), o2(0xE7,0x88), o2(0x95,0xD3), o2(0x92,0xD2),
     o2(0x8D,0x9E), o2(0x92,0x48),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_BE = {
    to_SHIFT_JIS_E8_BE_offsets,
    to_SHIFT_JIS_E8_BE_infos
};

static const unsigned char
to_SHIFT_JIS_E8_BF_offsets[64] = {
  /* used from to_SHIFT_JIS_E8_BF */
  /* used from to_EUC_JP_E8_BF */
     22, 22,  0, 22,  1,  2, 22, 22,   22, 22, 22, 22, 22, 22,  3, 22,
     22,  4, 22, 22,  5, 22, 22, 22,   22, 22,  6, 22, 22, 22, 22, 22,
     22, 22,  7, 22, 22,  8,  9, 22,   22, 10, 11, 12, 22, 13, 22, 14,
     15, 22, 22, 22, 16, 22, 22, 17,   18, 19, 20, 22, 22, 21, 22, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_BF_infos[23] = {
     o2(0x89,0x49), o2(0x96,0x98), o2(0x90,0x76), o2(0x8C,0x7D),
     o2(0x8B,0xDF), o2(0x95,0xD4), o2(0xE7,0x89), o2(0xE7,0x8B),
     o2(0xE7,0x8A), o2(0x89,0xDE), o2(0x93,0xF4), o2(0xE7,0x8C),
     o2(0x94,0x97), o2(0x93,0x52), o2(0xE7,0x8D), o2(0x8F,0x71),
     o2(0xE7,0x8F), o2(0x96,0xC0), o2(0xE7,0x9E), o2(0xE7,0x91),
     o2(0xE7,0x92), o2(0x92,0xC7),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8_BF = {
    to_SHIFT_JIS_E8_BF_offsets,
    to_SHIFT_JIS_E8_BF_infos
};

static const unsigned char
to_SHIFT_JIS_E8_offsets[64] = {
  /* used from to_SHIFT_JIS_E8 */
  /* used from to_EUC_JP_E8 */
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,   24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39,   40, 41, 42, 43, 44, 45, 46, 63,
     47, 48, 49, 50, 51, 52, 53, 54,   55, 56, 57, 58, 59, 60, 61, 62,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E8_infos[64] = {
     &to_SHIFT_JIS_E8_80, &to_SHIFT_JIS_E8_81,
     &to_SHIFT_JIS_E8_82, &to_SHIFT_JIS_E8_83,
     &to_SHIFT_JIS_E8_84, &to_SHIFT_JIS_E8_85,
     &to_SHIFT_JIS_E8_86, &to_SHIFT_JIS_E8_87,
     &to_SHIFT_JIS_E8_88, &to_SHIFT_JIS_E8_89,
     &to_SHIFT_JIS_E8_8A, &to_SHIFT_JIS_E8_8B,
     &to_SHIFT_JIS_E8_8C, &to_SHIFT_JIS_E8_8D,
     &to_SHIFT_JIS_E8_8E, &to_SHIFT_JIS_E8_8F,
     &to_SHIFT_JIS_E8_90, &to_SHIFT_JIS_E8_91,
     &to_SHIFT_JIS_E8_92, &to_SHIFT_JIS_E8_93,
     &to_SHIFT_JIS_E8_94, &to_SHIFT_JIS_E8_95,
     &to_SHIFT_JIS_E8_96, &to_SHIFT_JIS_E8_97,
     &to_SHIFT_JIS_E8_98, &to_SHIFT_JIS_E8_99,
     &to_SHIFT_JIS_E8_9A, &to_SHIFT_JIS_E8_9B,
     &to_SHIFT_JIS_E8_9C, &to_SHIFT_JIS_E8_9D,
     &to_SHIFT_JIS_E8_9E, &to_SHIFT_JIS_E8_9F,
     &to_SHIFT_JIS_E8_A0, &to_SHIFT_JIS_E8_A1,
     &to_SHIFT_JIS_E8_A2, &to_SHIFT_JIS_E8_A3,
     &to_SHIFT_JIS_E8_A4, &to_SHIFT_JIS_E8_A5,
     &to_SHIFT_JIS_E8_A6, &to_SHIFT_JIS_E8_A7,
     &to_SHIFT_JIS_E8_A8, &to_SHIFT_JIS_E8_A9,
     &to_SHIFT_JIS_E8_AA, &to_SHIFT_JIS_E8_AB,
     &to_SHIFT_JIS_E8_AC, &to_SHIFT_JIS_E8_AD,
     &to_SHIFT_JIS_E8_AE, &to_SHIFT_JIS_E8_B0,
     &to_SHIFT_JIS_E8_B1, &to_SHIFT_JIS_E8_B2,
     &to_SHIFT_JIS_E8_B3, &to_SHIFT_JIS_E8_B4,
     &to_SHIFT_JIS_E8_B5, &to_SHIFT_JIS_E8_B6,
     &to_SHIFT_JIS_E8_B7, &to_SHIFT_JIS_E8_B8,
     &to_SHIFT_JIS_E8_B9, &to_SHIFT_JIS_E8_BA,
     &to_SHIFT_JIS_E8_BB, &to_SHIFT_JIS_E8_BC,
     &to_SHIFT_JIS_E8_BD, &to_SHIFT_JIS_E8_BE,
     &to_SHIFT_JIS_E8_BF,               UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E8 = {
    to_SHIFT_JIS_E8_offsets,
    to_SHIFT_JIS_E8_infos
};

static const unsigned char
to_SHIFT_JIS_E9_80_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_80 */
  /* used from to_EUC_JP_E9_80 */
      0,  1, 35,  2, 35,  3,  4, 35,   35, 35, 35,  5, 35,  6,  7,  8,
      9, 10, 35, 11, 12, 13, 14, 15,   35, 16, 17, 35, 35, 18, 19, 20,
     21, 22, 23, 24, 35, 35, 35, 25,   35, 35, 35, 35, 35, 35, 26, 35,
     35, 27, 28, 35, 35, 29, 30, 35,   31, 32, 35, 35, 33, 35, 34, 35,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_80_infos[36] = {
     o2(0x91,0xDE), o2(0x91,0x97), o2(0x93,0xA6), o2(0xE7,0x90),
     o2(0x8B,0x74), o2(0xE7,0x99), o2(0xE7,0x96), o2(0xE7,0xA3),
     o2(0x93,0xA7), o2(0x92,0x80), o2(0xE7,0x93), o2(0x92,0xFC),
     o2(0x93,0x72), o2(0xE7,0x94), o2(0xE7,0x98), o2(0x90,0x80),
     o2(0x94,0x87), o2(0x92,0xCA), o2(0x90,0xC0), o2(0xE7,0x97),
     o2(0x91,0xAC), o2(0x91,0xA2), o2(0xE7,0x95), o2(0x88,0xA7),
     o2(0x98,0x41), o2(0xE7,0x9A), o2(0x91,0xDF), o2(0x8F,0x54),
     o2(0x90,0x69), o2(0xE7,0x9C), o2(0xE7,0x9B), o2(0x88,0xED),
     o2(0xE7,0x9D), o2(0x95,0x4E), o2(0xE7,0xA5),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_80 = {
    to_SHIFT_JIS_E9_80_offsets,
    to_SHIFT_JIS_E9_80_infos
};

static const unsigned char
to_SHIFT_JIS_E9_81_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_81 */
  /* used from to_EUC_JP_E9_81 */
     40,  0,  1, 40, 40,  2, 40,  3,   40,  4,  5,  6, 40,  7,  8,  9,
     10, 11, 12, 13, 14, 15, 16, 40,   17, 18, 40, 40, 19, 40, 20, 40,
     21, 22, 40, 23, 40, 24, 40, 25,   26, 27, 40, 40, 40, 28, 29, 30,
     40, 40, 31, 40, 40, 32, 33, 34,   35, 40, 36, 40, 37, 38, 40, 39,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_81_infos[41] = {
     o2(0x93,0xD9), o2(0x90,0x8B), o2(0x92,0x78), o2(0x8B,0xF6),
     o2(0xE7,0xA4), o2(0x97,0x56), o2(0x89,0x5E), o2(0x95,0xD5),
     o2(0x89,0xDF), o2(0xE7,0x9F), o2(0xE7,0xA0), o2(0xE7,0xA1),
     o2(0xE7,0xA2), o2(0x93,0xB9), o2(0x92,0x42), o2(0x88,0xE1),
     o2(0xE7,0xA6), o2(0xE7,0xA7), o2(0xEA,0xA1), o2(0x91,0xBB),
     o2(0xE7,0xA8), o2(0x89,0x93), o2(0x91,0x6B), o2(0x8C,0xAD),
     o2(0x97,0x79), o2(0xFB,0xB5), o2(0xE7,0xA9), o2(0x93,0x4B),
     o2(0x91,0x98), o2(0x8E,0xD5), o2(0xE7,0xAA), o2(0xE7,0xAD),
     o2(0x8F,0x85), o2(0xE7,0xAB), o2(0x91,0x4A), o2(0x91,0x49),
     o2(0x88,0xE2), o2(0x97,0xC9), o2(0xE7,0xAF), o2(0x94,0xF0),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_81 = {
    to_SHIFT_JIS_E9_81_offsets,
    to_SHIFT_JIS_E9_81_infos
};

static const unsigned char
to_SHIFT_JIS_E9_82_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_82 */
  /* used from to_EUC_JP_E9_82 */
      0,  1,  2,  3,  4, 18, 18,  5,   18,  6,  7, 18, 18, 18, 18,  8,
     18,  9, 18, 18, 18, 18, 18, 18,   18, 18, 18, 18, 18, 18, 18, 18,
     18, 18, 18, 10, 18, 18, 11, 18,   12, 18, 13, 18, 18, 18, 18, 14,
     18, 15, 18, 18, 18, 16, 18, 18,   17, 18, 18, 18, 18, 18, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_82_infos[19] = {
     o2(0xE7,0xB1), o2(0xE7,0xB0), o2(0xE7,0xAE), o2(0xE2,0x84),
     o2(0x8A,0xD2), o2(0xE7,0x8E), o2(0xE7,0xB3), o2(0xE7,0xB2),
     o2(0xE7,0xB4), o2(0x97,0x57), o2(0x93,0xDF), o2(0x96,0x4D),
     o2(0xE7,0xB5), o2(0x8E,0xD7), o2(0xE7,0xB6), o2(0xE7,0xB7),
     o2(0xE7,0xB8), o2(0x93,0x40),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_82 = {
    to_SHIFT_JIS_E9_82_offsets,
    to_SHIFT_JIS_E9_82_infos
};

static const unsigned char
to_SHIFT_JIS_E9_83_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_83 */
  /* used from to_EUC_JP_E9_83 */
     13,  0, 13, 13, 13, 13, 13, 13,   13, 13,  1, 13, 13, 13,  2, 13,
     13, 13, 13, 13, 13, 13, 13, 13,   13, 13, 13,  3, 13, 13,  4, 13,
     13,  5,  6, 13,  7, 13, 13, 13,    8, 13, 13, 13, 13,  9, 13, 13,
     13, 13, 13, 13, 13, 10, 13, 11,   13, 13, 13, 13, 13, 12, 13, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_83_infos[14] = {
     o2(0x88,0xE8), o2(0x8D,0x78), o2(0x98,0x59), o2(0xE7,0xBC),
     o2(0xFB,0xB6), o2(0x8C,0x53), o2(0xE7,0xB9), o2(0xE7,0xBA),
     o2(0x95,0x94), o2(0x8A,0x73), o2(0x97,0x58), o2(0x8B,0xBD),
     o2(0x93,0x73),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_83 = {
    to_SHIFT_JIS_E9_83_offsets,
    to_SHIFT_JIS_E9_83_infos
};

static const unsigned char
to_SHIFT_JIS_E9_84_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_84 */
  /* used from to_EUC_JP_E9_84 */
      8,  8,  0,  8,  8,  8,  8,  8,    8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  1,  8,  8,  2,  8,  8,    8,  3,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  4,    8,  8,  8,  8,  8,  5,  8,  8,
      6,  8,  7,  8,  8,  8,  8,  8,    8,  8,  8,  8,  8,  8,  8,  8,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_84_infos[9] = {
     o2(0xE7,0xBD), o2(0xE7,0xBE), o2(0xFB,0xB8), o2(0xE7,0xBF),
     o2(0xFB,0xB9), o2(0x93,0x41), o2(0xE7,0xC1), o2(0xE7,0xC0),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_84 = {
    to_SHIFT_JIS_E9_84_offsets,
    to_SHIFT_JIS_E9_84_infos
};

static const unsigned char
to_SHIFT_JIS_E9_85_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_85 */
  /* used from to_EUC_JP_E9_85 */
     21, 21, 21, 21, 21, 21, 21, 21,   21,  0,  1,  2,  3,  4,  5, 21,
     21, 21,  6, 21,  7, 21,  8, 21,    9, 21, 21, 21, 21, 21, 21, 21,
     21, 21, 10, 11, 21, 12, 21, 21,   21, 13, 14, 21, 15, 21, 21, 21,
     21, 21, 16, 17, 21, 18, 21, 19,   20, 21, 21, 21, 21, 21, 21, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_85_infos[22] = {
     o2(0x93,0xD1), o2(0xE7,0xC2), o2(0x8F,0x55), o2(0x8E,0xDE),
     o2(0x94,0x7A), o2(0x92,0x91), o2(0x8E,0xF0), o2(0x90,0x8C),
     o2(0xE7,0xC3), o2(0xE7,0xC4), o2(0x90,0x7C), o2(0xE7,0xC5),
     o2(0xE7,0xC6), o2(0xE7,0xC7), o2(0x97,0x8F), o2(0x8F,0x56),
     o2(0xE7,0xC9), o2(0xE7,0xC8), o2(0x8D,0x79), o2(0x8D,0x93),
     o2(0x8E,0x5F),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_85 = {
    to_SHIFT_JIS_E9_85_offsets,
    to_SHIFT_JIS_E9_85_infos
};

static const unsigned char
to_SHIFT_JIS_E9_86_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_86 */
  /* used from to_EUC_JP_E9_86 */
     18, 18,  0, 18, 18, 18, 18,  1,   18,  2, 18,  3, 18,  4, 18, 18,
      5, 18,  6, 18, 18, 18, 18,  7,   18, 18, 18, 18,  8, 18, 18, 18,
     18, 18,  9, 18, 10, 18, 18, 18,   18, 18, 11, 12, 18, 18, 18, 13,
     18, 18, 18, 18, 14, 15, 18, 18,   16, 18, 17, 18, 18, 18, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_86_infos[19] = {
     o2(0xE7,0xCC), o2(0x8F,0x86), o2(0xE7,0xCB), o2(0xE7,0xCA),
     o2(0x91,0xE7), o2(0x8C,0xED), o2(0x90,0xC1), o2(0x94,0xAE),
     o2(0x8F,0x58), o2(0xE7,0xCD), o2(0x8F,0xDD), o2(0xE7,0xD0),
     o2(0xE7,0xCE), o2(0xE7,0xCF), o2(0xE7,0xD2), o2(0xE7,0xD1),
     o2(0x8F,0xF8), o2(0xE7,0xD3),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_86 = {
    to_SHIFT_JIS_E9_86_offsets,
    to_SHIFT_JIS_E9_86_infos
};

static const unsigned char
to_SHIFT_JIS_E9_87_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_87 */
  /* used from to_EUC_JP_E9_87 */
      0,  1, 34, 34, 34, 34,  2,  3,    4,  5, 34,  6,  7,  8,  9, 10,
     11, 12, 34, 34, 34, 34, 13, 14,   15, 34, 16, 17, 18, 19, 20, 21,
     34, 22, 34, 23, 24, 25, 26, 27,   34, 34, 34, 34, 34, 28, 29, 34,
     34, 34, 34, 34, 34, 30, 31, 34,   34, 34, 34, 34, 32, 34, 34, 33,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_87_infos[35] = {
     o2(0xE7,0xD4), o2(0xE7,0xD5), o2(0x94,0xCE), o2(0x8D,0xD1),
     o2(0x8E,0xDF), o2(0xE7,0xD6), o2(0xE7,0xD7), o2(0x97,0xA2),
     o2(0x8F,0x64), o2(0x96,0xEC), o2(0x97,0xCA), o2(0xE7,0xD8),
     o2(0x8B,0xE0), o2(0xE7,0xD9), o2(0xFB,0xBB), o2(0x93,0x42),
     o2(0xFB,0xBA), o2(0xE7,0xDC), o2(0x8A,0x98), o2(0x90,0x6A),
     o2(0xFB,0xBC), o2(0xE7,0xDA), o2(0xE7,0xDB), o2(0x92,0xDE),
     o2(0xFB,0xBF), o2(0xFB,0xC0), o2(0x96,0x74), o2(0x8B,0xFA),
     o2(0xFB,0xBD), o2(0xFB,0xBE), o2(0xE7,0xDE), o2(0xE7,0xDF),
     o2(0xE7,0xDD), o2(0xE7,0xE1),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_87 = {
    to_SHIFT_JIS_E9_87_offsets,
    to_SHIFT_JIS_E9_87_infos
};

static const unsigned char
to_SHIFT_JIS_E9_88_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_88 */
  /* used from to_EUC_JP_E9_88 */
     17, 17, 17, 17, 17, 17,  0, 17,   17, 17,  1, 17, 17,  2,  3, 17,
      4,  5, 17, 17,  6,  7, 17, 17,   17, 17, 17, 17, 17, 17,  8, 17,
     17, 17, 17, 17, 17, 17, 17, 17,   17,  9, 17, 17, 10, 17, 17, 17,
     17, 17, 17, 17, 11, 17, 17, 12,   17, 13, 14, 17, 15, 17, 17, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_88_infos[18] = {
     o2(0xFB,0xC1), o2(0xFB,0xC3), o2(0x93,0xDD), o2(0x8A,0x62),
     o2(0xFB,0xC2), o2(0xE7,0xE5), o2(0xE7,0xE2), o2(0xE7,0xE4),
     o2(0xE7,0xE0), o2(0xE8,0x6E), o2(0xE7,0xE3), o2(0x97,0xE9),
     o2(0x8C,0xD8), o2(0xFB,0xCA), o2(0xFB,0xC4), o2(0xFB,0xC6),
     o2(0xE7,0xED),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_88 = {
    to_SHIFT_JIS_E9_88_offsets,
    to_SHIFT_JIS_E9_88_infos
};

static const unsigned char
to_SHIFT_JIS_E9_89_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_89 */
  /* used from to_EUC_JP_E9_89 */
      0, 22, 22, 22,  1,  2, 22, 22,    3,  4, 22,  5, 22, 22,  6, 22,
      7,  8, 22, 22, 22, 22, 22,  9,   22, 10, 11, 12, 22, 22, 13, 22,
     22, 22, 14, 22, 15, 22, 16, 17,   22, 22, 22, 22, 22, 22, 22, 22,
     22, 18, 22, 22, 22, 22, 22, 19,   20, 22, 22, 22, 22, 22, 21, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_89_infos[23] = {
     o2(0xFB,0xC5), o2(0x93,0x53), o2(0xE7,0xE8), o2(0xE7,0xEB),
     o2(0xE7,0xE9), o2(0xE7,0xEE), o2(0xFB,0xC7), o2(0xE7,0xEF),
     o2(0xFB,0xC9), o2(0xE7,0xE7), o2(0xFB,0xC8), o2(0xE7,0xF4),
     o2(0x89,0x94), o2(0xE7,0xE6), o2(0x94,0xAB), o2(0xE7,0xEA),
     o2(0x8F,0xDE), o2(0xFB,0xCB), o2(0x8D,0x7A), o2(0xFB,0xCD),
     o2(0xFB,0xCE), o2(0x96,0x67),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_89 = {
    to_SHIFT_JIS_E9_89_offsets,
    to_SHIFT_JIS_E9_89_infos
};

static const unsigned char
to_SHIFT_JIS_E9_8A_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_8A */
  /* used from to_EUC_JP_E9_8A */
      0, 16, 16,  1, 16,  2, 16, 16,    3, 16, 16, 16, 16, 16, 16, 16,
     16,  4, 16,  5, 16,  6,  7, 16,    8, 16,  9, 10, 11, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 12,   16, 16, 16, 16, 16, 13, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 14,   16, 15, 16, 16, 16, 16, 16, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_8A_infos[17] = {
     o2(0x8B,0xE2), o2(0x8F,0x65), o2(0x93,0xBA), o2(0xFA,0x5F),
     o2(0x91,0x4C), o2(0xE7,0xF2), o2(0xE7,0xEC), o2(0xE7,0xF1),
     o2(0x96,0xC1), o2(0x92,0xB6), o2(0xE7,0xF3), o2(0xE7,0xF0),
     o2(0xFB,0xCC), o2(0x91,0x4B), o2(0xE7,0xF7), o2(0xE7,0xF6),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_8A = {
    to_SHIFT_JIS_E9_8A_offsets,
    to_SHIFT_JIS_E9_8A_infos
};

static const unsigned char
to_SHIFT_JIS_E9_8B_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_8B */
  /* used from to_EUC_JP_E9_8B */
     21, 21, 21, 21, 21, 21, 21, 21,   21, 21, 21, 21, 21, 21, 21,  0,
      1, 21,  2,  3, 21,  4, 21,  5,   21,  6, 21, 21, 21, 21, 21, 21,
      7, 21, 21, 21,  8, 21, 21,  9,   21, 10, 11, 21, 21, 12, 21, 21,
     21, 21, 13, 14, 21, 21, 21, 21,   15, 16, 17, 18, 19, 21, 21, 20,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_8B_infos[22] = {
     o2(0xE7,0xF5), o2(0xFB,0xD2), o2(0x96,0x4E), o2(0xFB,0xD6),
     o2(0xFB,0xD4), o2(0xFB,0xD0), o2(0xFB,0xD1), o2(0xFB,0xD5),
     o2(0x8F,0x9B), o2(0xFB,0xCF), o2(0xE7,0xF8), o2(0x95,0xDD),
     o2(0x89,0x73), o2(0x95,0x65), o2(0x92,0x92), o2(0x8B,0x98),
     o2(0xFA,0x65), o2(0xE7,0xFA), o2(0xFB,0xD9), o2(0x8D,0x7C),
     o2(0xFB,0xDC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_8B = {
    to_SHIFT_JIS_E9_8B_offsets,
    to_SHIFT_JIS_E9_8B_infos
};

static const unsigned char
to_SHIFT_JIS_E9_8C_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_8C */
  /* used from to_EUC_JP_E9_8C */
     24, 24,  0, 24, 24, 24,  1, 24,   24, 24, 24, 24, 24, 24, 24,  2,
      3, 24, 24, 24, 24, 24, 24, 24,    4,  5,  6, 24, 24,  7,  8, 24,
      9, 10, 11, 12, 24, 13, 14, 24,   15, 24, 24, 16, 17, 24, 18, 19,
     24, 24, 20, 24, 24, 21, 24, 24,   24, 24, 22, 23, 24, 24, 24, 24,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_8C_infos[25] = {
     o2(0xFB,0xDE), o2(0x8E,0x4B), o2(0xE7,0xF9), o2(0x90,0x8D),
     o2(0x90,0x8E), o2(0xE8,0x40), o2(0xE8,0x42), o2(0xFB,0xDD),
     o2(0xFB,0xDB), o2(0x8F,0xF9), o2(0xFB,0xD8), o2(0xE8,0x41),
     o2(0xE8,0x43), o2(0xFB,0xD7), o2(0x8B,0xD1), o2(0x95,0x64),
     o2(0x8E,0xE0), o2(0x98,0x42), o2(0xE7,0xFC), o2(0x8D,0xF6),
     o2(0x98,0x5E), o2(0xE8,0x45), o2(0xE8,0x44), o2(0xE8,0x46),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_8C = {
    to_SHIFT_JIS_E9_8C_offsets,
    to_SHIFT_JIS_E9_8C_infos
};

static const unsigned char
to_SHIFT_JIS_E9_8D_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_8D */
  /* used from to_EUC_JP_E9_8D */
     16, 16, 16, 16,  0, 16, 16, 16,    1, 16, 16,  2, 16,  3, 16, 16,
     16, 16, 16, 16,  4, 16,  5,  6,   16, 16, 16,  7,  8, 16, 16, 16,
      9, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 10, 16, 11, 16,
     12, 16, 16, 16, 16, 13, 16, 16,   16, 16, 16, 16, 14, 16, 15, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_8D_infos[17] = {
     o2(0xE7,0xFB), o2(0xFA,0x5E), o2(0x93,0xE7), o2(0x93,0x74),
     o2(0x92,0xD5), o2(0xE8,0x4B), o2(0xFB,0xE0), o2(0x92,0x62),
     o2(0xE8,0x47), o2(0xE8,0x48), o2(0x8C,0x4C), o2(0xE8,0x4A),
     o2(0xFB,0xDF), o2(0x8C,0xAE), o2(0xE8,0x49), o2(0x8F,0xDF),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_8D = {
    to_SHIFT_JIS_E9_8D_offsets,
    to_SHIFT_JIS_E9_8D_infos
};

static const unsigned char
to_SHIFT_JIS_E9_8E_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_8E */
  /* used from to_EUC_JP_E9_8E */
     12, 12, 12, 12, 12, 12, 12, 12,   12, 12, 12, 12,  0, 12, 12, 12,
     12, 12, 12, 12,  1, 12,  2,  3,   12, 12,  4, 12, 12, 12, 12, 12,
     12, 12, 12, 12,  5, 12, 12,  6,   12, 12, 12, 12,  7,  8,  9, 12,
     10, 12, 12, 12, 12, 12, 12, 12,   12, 11, 12, 12, 12, 12, 12, 12,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_8E_infos[13] = {
     o2(0x8A,0x99), o2(0xE8,0x4F), o2(0x8D,0xBD), o2(0x91,0x99),
     o2(0x92,0xC8), o2(0xFB,0xE1), o2(0x8A,0x5A), o2(0xE8,0x4D),
     o2(0xE8,0x4E), o2(0x92,0xC1), o2(0xE8,0x4C), o2(0xE8,0x50),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_8E = {
    to_SHIFT_JIS_E9_8E_offsets,
    to_SHIFT_JIS_E9_8E_infos
};

static const unsigned char
to_SHIFT_JIS_E9_8F_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_8F */
  /* used from to_EUC_JP_E9_8F */
     15, 15, 15,  0, 15, 15,  1, 15,    2, 15, 15, 15, 15, 15, 15, 15,
      3,  4, 15, 15, 15, 15,  5,  6,    7, 15, 15, 15, 15,  8,  9, 15,
     15, 10, 15, 15, 11, 12, 15, 15,   13, 15, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15, 15, 15,   14, 15, 15, 15, 15, 15, 15, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_8F_infos[16] = {
     o2(0xE8,0x56), o2(0xFB,0xE2), o2(0xE8,0x59), o2(0xE8,0x58),
     o2(0x93,0x4C), o2(0xE8,0x51), o2(0xE8,0x52), o2(0xE8,0x55),
     o2(0xE8,0x57), o2(0xFB,0xE3), o2(0x8B,0xBE), o2(0xE8,0x5A),
     o2(0xE8,0x54), o2(0xE8,0x53), o2(0xFB,0xE4),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_8F = {
    to_SHIFT_JIS_E9_8F_offsets,
    to_SHIFT_JIS_E9_8F_infos
};

static const unsigned char
to_SHIFT_JIS_E9_90_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_90 */
  /* used from to_EUC_JP_E9_90 */
     15, 15, 15,  0, 15, 15, 15,  1,   15, 15, 15, 15, 15, 15, 15, 15,
      2, 15, 15,  3,  4, 15, 15, 15,    5,  6,  7, 15, 15, 15, 15, 15,
     15,  8, 15, 15, 15, 15, 15, 15,   15, 15, 15,  9, 15, 15, 15, 15,
     15, 10, 15, 15, 15, 11, 12, 15,   13, 15, 14, 15, 15, 15, 15, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_90_infos[16] = {
     o2(0xE8,0x5E), o2(0xE8,0x5F), o2(0xE8,0x60), o2(0xE8,0x5D),
     o2(0xE8,0x5C), o2(0x8F,0xE0), o2(0x93,0xA8), o2(0xE8,0x5B),
     o2(0xE8,0x64), o2(0xE8,0x62), o2(0xFB,0xE5), o2(0xE8,0x63),
     o2(0xE8,0x61), o2(0x91,0xF6), o2(0xE8,0x65),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_90 = {
    to_SHIFT_JIS_E9_90_offsets,
    to_SHIFT_JIS_E9_90_infos
};

static const unsigned char
to_SHIFT_JIS_E9_91_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_91 */
  /* used from to_EUC_JP_E9_91 */
     20,  0, 20, 20,  1,  2, 20, 20,    3, 20, 20, 20, 20, 20, 20, 20,
     20,  4,  5,  6, 20, 20, 20, 20,   20, 20,  7,  8, 20, 20,  9, 20,
     10, 20, 11, 20, 20, 20, 20, 20,   20, 20, 12, 20, 20, 20, 20, 20,
     13, 20, 20, 20, 20, 14, 20, 15,   20, 20, 20, 20, 16, 17, 18, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_91_infos[21] = {
     o2(0xE8,0x66), o2(0xE8,0x68), o2(0xFB,0xE6), o2(0xFB,0xE7),
     o2(0x8A,0xD3), o2(0xE8,0x67), o2(0x96,0xF8), o2(0xE8,0x73),
     o2(0xE8,0x69), o2(0xE8,0x6C), o2(0xE8,0x6A), o2(0xE8,0x6B),
     o2(0xE8,0x6D), o2(0xE8,0x6F), o2(0xE8,0x70), o2(0xE8,0x71),
     o2(0xE8,0x74), o2(0xE8,0x72), o2(0xE8,0x75), o2(0xE8,0x77),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_91 = {
    to_SHIFT_JIS_E9_91_offsets,
    to_SHIFT_JIS_E9_91_infos
};

static const unsigned char
to_SHIFT_JIS_E9_92_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_92 */
  /* used from to_EUC_JP_E9_92 */
      1,  0,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_92_infos[2] = {
     o2(0xE8,0x76),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_92 = {
    to_SHIFT_JIS_E9_92_offsets,
    to_SHIFT_JIS_E9_92_infos
};

static const unsigned char
to_SHIFT_JIS_E9_95_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_95 */
  /* used from to_EUC_JP_E9_95 */
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  0,    1,  1,  1,  1,  1,  1,  1,  1,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_95_infos[2] = {
     o2(0x92,0xB7),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_95 = {
    to_SHIFT_JIS_E9_95_offsets,
    to_SHIFT_JIS_E9_95_infos
};

static const unsigned char
to_SHIFT_JIS_E9_96_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_96 */
  /* used from to_EUC_JP_E9_96 */
      0, 28,  1,  2, 28, 28, 28,  3,   28,  4,  5,  6, 28, 28, 28,  7,
     28,  8,  9, 10, 11, 28, 12, 28,   13, 14, 28, 28, 28, 28, 28, 28,
     15, 28, 16, 17, 18, 19, 28, 20,   21, 28, 28, 28, 28, 22, 28, 28,
     28, 28, 23, 28, 28, 28, 28, 28,   28, 24, 28, 25, 26, 28, 27, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_96_infos[29] = {
     o2(0x96,0xE5), o2(0xE8,0x78), o2(0x91,0x4D), o2(0xE8,0x79),
     o2(0x95,0xC2), o2(0xE8,0x7A), o2(0x8A,0x4A), o2(0x89,0x5B),
     o2(0x8A,0xD5), o2(0xFB,0xE8), o2(0x8A,0xD4), o2(0xE8,0x7B),
     o2(0xE8,0x7C), o2(0xE8,0x7D), o2(0xE8,0x7E), o2(0xE8,0x80),
     o2(0x8A,0xD6), o2(0x8A,0x74), o2(0x8D,0x7D), o2(0x94,0xB4),
     o2(0xE8,0x82), o2(0xE8,0x81), o2(0xE8,0x83), o2(0x89,0x7B),
     o2(0xE8,0x86), o2(0xE8,0x85), o2(0xE8,0x84), o2(0xE8,0x87),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_96 = {
    to_SHIFT_JIS_E9_96_offsets,
    to_SHIFT_JIS_E9_96_infos
};

static const unsigned char
to_SHIFT_JIS_E9_97_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_97 */
  /* used from to_EUC_JP_E9_97 */
     13, 13, 13,  0, 13, 13, 13,  1,   13, 13,  2, 13,  3,  4, 13, 13,
     13, 13, 13, 13,  5,  6,  7, 13,    8, 13, 13, 13,  9, 13, 13, 13,
     13, 10, 11, 13, 13, 12, 13, 13,   13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13, 13, 13,   13, 13, 13, 13, 13, 13, 13, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_97_infos[14] = {
     o2(0xE8,0x8A), o2(0x88,0xC5), o2(0xE8,0x88), o2(0xE8,0x8C),
     o2(0xE8,0x8B), o2(0xE8,0x8E), o2(0xE8,0x8D), o2(0xE8,0x8F),
     o2(0x93,0xAC), o2(0xE8,0x90), o2(0xE8,0x91), o2(0xE8,0x93),
     o2(0xE8,0x92),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_97 = {
    to_SHIFT_JIS_E9_97_offsets,
    to_SHIFT_JIS_E9_97_infos
};

static const unsigned char
to_SHIFT_JIS_E9_98_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_98 */
  /* used from to_EUC_JP_E9_98 */
      9,  9,  9,  9,  9,  9,  9,  9,    9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,    9,  9,  9,  9,  0,  9,  9,  9,
      9,  1,  9,  9,  9,  9,  9,  9,    2,  9,  3,  9,  9,  9,  4,  5,
      9,  9,  6,  9,  9,  9,  9,  9,    9,  9,  9,  7,  9,  9,  9,  8,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_98_infos[10] = {
     o2(0x95,0x8C), o2(0xE8,0x94), o2(0xE8,0x95), o2(0x8D,0xE3),
     o2(0xE8,0x96), o2(0xE8,0x97), o2(0x96,0x68), o2(0x91,0x6A),
     o2(0x88,0xA2),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_98 = {
    to_SHIFT_JIS_E9_98_offsets,
    to_SHIFT_JIS_E9_98_infos
};

static const unsigned char
to_SHIFT_JIS_E9_99_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_99 */
  /* used from to_EUC_JP_E9_99 */
      0, 29,  1, 29,  2, 29, 29, 29,   29, 29, 29,  3,  4,  5, 29,  6,
      7, 29, 29, 29, 29, 29, 29, 29,   29, 29, 29,  8,  9, 10, 11, 12,
     29, 29, 13, 14, 15, 16, 17, 29,   29, 29, 18, 29, 19, 29, 29, 29,
     20, 29, 21, 22, 29, 23, 24, 25,   26, 29, 27, 29, 29, 28, 29, 29,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_99_infos[30] = {
     o2(0x91,0xC9), o2(0xE8,0x98), o2(0x95,0x8D), o2(0xE8,0x9B),
     o2(0xE8,0x99), o2(0x8D,0x7E), o2(0xE8,0x9A), o2(0x8C,0xC0),
     o2(0x95,0xC3), o2(0xE8,0x9D), o2(0xE8,0x9F), o2(0xE8,0x9E),
     o2(0xE8,0xA0), o2(0x89,0x40), o2(0x90,0x77), o2(0x8F,0x9C),
     o2(0x8A,0xD7), o2(0xE8,0xA1), o2(0x94,0x86), o2(0xE8,0xA3),
     o2(0x89,0x41), o2(0xE8,0xA2), o2(0x92,0xC2), o2(0x97,0xCB),
     o2(0x93,0xA9), o2(0xE8,0x9C), o2(0x97,0xA4), o2(0x8C,0xAF),
     o2(0x97,0x7A),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_99 = {
    to_SHIFT_JIS_E9_99_offsets,
    to_SHIFT_JIS_E9_99_infos
};

static const unsigned char
to_SHIFT_JIS_E9_9A_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_9A */
  /* used from to_EUC_JP_E9_9A */
     32, 32, 32, 32, 32,  0,  1, 32,    2, 32,  3,  4, 32,  5,  6,  7,
     32, 32, 32, 32,  8,  9, 32, 10,   11, 12, 32, 13, 14, 15, 32, 32,
     16, 32, 32, 17, 32, 32, 32, 18,   19, 32, 20, 32, 32, 32, 32, 21,
     22, 23, 24, 32, 25, 32, 26, 27,   28, 29, 32, 30, 31, 32, 32, 32,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_9A_infos[33] = {
     o2(0x8B,0xF7), o2(0x97,0xB2), o2(0x8C,0x47), o2(0x91,0xE0),
     o2(0xE4,0x40), o2(0xE8,0xA4), o2(0x8A,0x4B), o2(0x90,0x8F),
     o2(0x8A,0x75), o2(0xE8,0xA6), o2(0xE8,0xA7), o2(0xE8,0xA5),
     o2(0x8C,0x84), o2(0x8D,0xDB), o2(0x8F,0xE1), o2(0xFB,0xEB),
     o2(0x89,0x42), o2(0x97,0xD7), o2(0xE8,0xA9), o2(0xE7,0xAC),
     o2(0xE8,0xA8), o2(0xFB,0xEC), o2(0xE8,0xAC), o2(0xE8,0xAA),
     o2(0xE8,0xAB), o2(0xE8,0xAD), o2(0xE8,0xAE), o2(0x97,0xEA),
     o2(0xE8,0xAF), o2(0xE8,0xB0), o2(0x90,0xC7), o2(0x94,0xB9),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_9A = {
    to_SHIFT_JIS_E9_9A_offsets,
    to_SHIFT_JIS_E9_9A_infos
};

static const unsigned char
to_SHIFT_JIS_E9_9B_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_9B */
  /* used from to_EUC_JP_E9_9B */
      0,  1, 28, 28,  2,  3,  4,  5,   28,  6, 28,  7,  8,  9, 10, 28,
     28, 11, 28, 28, 28, 12, 13, 28,   28, 14, 28, 15, 16, 28, 28, 28,
     28, 28, 17, 18, 28, 28, 28, 28,   19, 28, 20, 21, 28, 28, 28, 28,
     22, 28, 23, 28, 28, 28, 24, 25,   28, 26, 28, 27, 28, 28, 28, 28,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_9B_infos[29] = {
     o2(0x90,0x9D), o2(0x8A,0xE5), o2(0x97,0x59), o2(0x89,0xEB),
     o2(0x8F,0x57), o2(0x8C,0xD9), o2(0xE8,0xB3), o2(0xE8,0xB2),
     o2(0x8E,0x93), o2(0xE8,0xB4), o2(0xE8,0xB1), o2(0x8E,0x47),
     o2(0xE8,0xB8), o2(0xE5,0xAB), o2(0x99,0xD4), o2(0x90,0x97),
     o2(0xE8,0xB6), o2(0x97,0xA3), o2(0x93,0xEF), o2(0x89,0x4A),
     o2(0x90,0xE1), o2(0x8E,0xB4), o2(0x95,0xB5), o2(0x89,0x5F),
     o2(0x97,0xEB), o2(0x97,0x8B), o2(0xE8,0xB9), o2(0x93,0x64),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_9B = {
    to_SHIFT_JIS_E9_9B_offsets,
    to_SHIFT_JIS_E9_9B_infos
};

static const unsigned char
to_SHIFT_JIS_E9_9C_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_9C */
  /* used from to_EUC_JP_E9_9C */
      0, 26, 26, 26,  1, 26,  2,  3,    4, 26,  5, 26, 26,  6,  7,  8,
     26,  9, 26, 10, 26, 26, 11, 26,   26, 12, 26, 26, 13, 26, 14, 26,
     26, 26, 26, 26, 15, 26, 26, 16,   26, 26, 17, 26, 26, 26, 26, 26,
     18, 26, 19, 20, 26, 26, 26, 26,   21, 22, 26, 23, 26, 24, 25, 26,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_9C_infos[27] = {
     o2(0x8E,0xF9), o2(0xE8,0xBA), o2(0xE8,0xBB), o2(0x90,0x6B),
     o2(0xE8,0xBC), o2(0x97,0xEC), o2(0xE8,0xB7), o2(0xE8,0xBE),
     o2(0xE8,0xC0), o2(0xE8,0xBF), o2(0xE8,0xBD), o2(0xE8,0xC1),
     o2(0xE8,0xC2), o2(0x91,0x9A), o2(0x89,0xE0), o2(0xE8,0xC3),
     o2(0x96,0xB6), o2(0xE8,0xC4), o2(0xE8,0xC5), o2(0x98,0x49),
     o2(0xFB,0xED), o2(0x9E,0x50), o2(0xE8,0xC6), o2(0xFB,0xEE),
     o2(0xE8,0xC7), o2(0xE8,0xC8),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_9C = {
    to_SHIFT_JIS_E9_9C_offsets,
    to_SHIFT_JIS_E9_9C_infos
};

static const unsigned char
to_SHIFT_JIS_E9_9D_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_9D */
  /* used from to_EUC_JP_E9_9D */
     29, 29,  0,  1,  2, 29,  3, 29,    4,  5, 29, 29, 29,  6, 29,  7,
     29,  8,  9, 29, 29, 10, 11, 29,   29, 12, 29, 29, 13, 29, 14, 29,
     15, 16, 17, 29, 18, 29, 19, 29,   20, 21, 29, 22, 29, 23, 29, 29,
     29, 24, 29, 29, 25, 29, 29, 29,   29, 26, 27, 29, 28, 29, 29, 29,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_9D_infos[30] = {
     o2(0xE8,0xCC), o2(0xFB,0xEF), o2(0xE8,0xC9), o2(0xE8,0xCA),
     o2(0xE8,0xCB), o2(0xE8,0xCD), o2(0xFB,0xF0), o2(0xFB,0xF1),
     o2(0xFB,0xF2), o2(0x90,0xC2), o2(0xFB,0xF3), o2(0x96,0xF5),
     o2(0x90,0xC3), o2(0xE8,0xCE), o2(0x94,0xF1), o2(0xE8,0xCF),
     o2(0xEA,0x72), o2(0x96,0xCA), o2(0xE8,0xD0), o2(0xE8,0xD1),
     o2(0xE8,0xD2), o2(0x8A,0x76), o2(0xE8,0xD4), o2(0x90,0x78),
     o2(0xE8,0xD5), o2(0x8C,0x43), o2(0xE8,0xD6), o2(0xE8,0xDA),
     o2(0xE8,0xD8),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_9D = {
    to_SHIFT_JIS_E9_9D_offsets,
    to_SHIFT_JIS_E9_9D_infos
};

static const unsigned char
to_SHIFT_JIS_E9_9E_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_9E */
  /* used from to_EUC_JP_E9_9E */
     18,  0, 18, 18,  1,  2,  3, 18,   18, 18, 18,  4, 18,  5, 18,  6,
      7, 18, 18, 18, 18, 18, 18, 18,    8, 18, 18, 18,  9, 18, 18, 18,
     10, 18, 18, 11, 18, 18, 12, 18,   13, 18, 18, 14, 18, 15, 18, 18,
     18, 18, 18, 16, 17, 18, 18, 18,   18, 18, 18, 18, 18, 18, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_9E_infos[19] = {
     o2(0xE8,0xD9), o2(0x8A,0x93), o2(0xE8,0xD7), o2(0xE8,0xDB),
     o2(0xE8,0xDC), o2(0x88,0xC6), o2(0xE8,0xDD), o2(0xE8,0xDE),
     o2(0x8F,0xE2), o2(0xE8,0xDF), o2(0x8B,0x66), o2(0xE8,0xE2),
     o2(0xE8,0xE1), o2(0xE8,0xE0), o2(0xE6,0x91), o2(0x95,0xDA),
     o2(0xE8,0xE3), o2(0xE8,0xE4),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_9E = {
    to_SHIFT_JIS_E9_9E_offsets,
    to_SHIFT_JIS_E9_9E_infos
};

static const unsigned char
to_SHIFT_JIS_E9_9F_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_9F */
  /* used from to_EUC_JP_E9_9F */
     14, 14, 14,  0, 14, 14,  1, 14,    2, 14, 14,  3, 14, 14, 14, 14,
     14, 14, 14,  4, 14, 14, 14, 14,   14, 14, 14, 14,  5, 14, 14, 14,
     14, 14, 14, 14, 14, 14, 14, 14,   14, 14, 14, 14, 14,  6,  7, 14,
     14, 14,  8,  9, 14, 10, 11, 14,   14, 14, 14, 12, 14, 14, 14, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_9F_infos[15] = {
     o2(0xE8,0xE5), o2(0xE8,0xE6), o2(0xE8,0xE7), o2(0xE8,0xE8),
     o2(0x8A,0xD8), o2(0xE8,0xE9), o2(0xE8,0xEA), o2(0x94,0x42),
     o2(0xE8,0xEC), o2(0x89,0xB9), o2(0xE8,0xEF), o2(0xE8,0xEE),
     o2(0x89,0x43), o2(0x8B,0xBF),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_9F = {
    to_SHIFT_JIS_E9_9F_offsets,
    to_SHIFT_JIS_E9_9F_infos
};

static const unsigned char
to_SHIFT_JIS_E9_A0_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_A0 */
  /* used from to_EUC_JP_E9_A0 */
     25,  0,  1,  2, 25,  3,  4, 25,    5, 25, 25, 25,  6, 25, 25,  7,
      8,  9, 10, 11, 25, 25, 25, 12,   13, 25, 14, 25, 25, 25, 25, 25,
     25, 15, 25, 25, 16, 25, 25, 25,   25, 25, 25, 25, 17, 18, 25, 25,
     25, 25, 25, 25, 19, 25, 25, 20,   21, 25, 25, 22, 23, 24, 25, 25,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_A0_infos[26] = {
     o2(0x95,0xC5), o2(0x92,0xB8), o2(0x8D,0xA0), o2(0x8D,0x80),
     o2(0x8F,0x87), o2(0x90,0x7B), o2(0xE8,0xF1), o2(0xE8,0xF0),
     o2(0x97,0x61), o2(0x8A,0xE6), o2(0x94,0xD0), o2(0x93,0xDA),
     o2(0x90,0x9C), o2(0x97,0xCC), o2(0x8C,0x7A), o2(0xE8,0xF4),
     o2(0xE8,0xF3), o2(0x96,0x6A), o2(0x93,0xAA), o2(0x89,0x6F),
     o2(0xE8,0xF5), o2(0xE8,0xF2), o2(0x95,0x70), o2(0x97,0x8A),
     o2(0xE8,0xF6),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_A0 = {
    to_SHIFT_JIS_E9_A0_offsets,
    to_SHIFT_JIS_E9_A0_infos
};

static const unsigned char
to_SHIFT_JIS_E9_A1_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_A1 */
  /* used from to_EUC_JP_E9_A1 */
     20, 20, 20, 20, 20, 20,  0, 20,   20, 20, 20,  1,  2,  3,  4,  5,
     20, 20, 20, 20,  6,  7, 20,  8,    9, 20, 20, 10, 20, 20, 11, 20,
     20, 20, 20, 20, 20, 12, 20, 13,   20, 20, 20, 14, 20, 20, 20, 15,
     16, 17, 20, 18, 19, 20, 20, 20,   20, 20, 20, 20, 20, 20, 20, 20,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_A1_infos[21] = {
     o2(0xE8,0xF7), o2(0xE8,0xF9), o2(0x91,0xE8), o2(0x8A,0x7A),
     o2(0x8A,0x7B), o2(0xE8,0xF8), o2(0x8A,0xE7), o2(0x8C,0xB0),
     o2(0xFB,0xF4), o2(0x8A,0xE8), o2(0x93,0x5E), o2(0x97,0xDE),
     o2(0xFB,0xF5), o2(0x8C,0xDA), o2(0xE8,0xFA), o2(0xE8,0xFB),
     o2(0xE8,0xFC), o2(0xE9,0x40), o2(0xE9,0x42), o2(0xE9,0x41),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_A1 = {
    to_SHIFT_JIS_E9_A1_offsets,
    to_SHIFT_JIS_E9_A1_infos
};

static const unsigned char
to_SHIFT_JIS_E9_A2_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_A2 */
  /* used from to_EUC_JP_E9_A2 */
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    0,  5,  1,  5,  5,  5,  5,  2,
      5,  3,  5,  5,  5,  5,  4,  5,    5,  5,  5,  5,  5,  5,  5,  5,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_A2_infos[6] = {
     o2(0x95,0x97), o2(0xE9,0x43), o2(0xE9,0x44), o2(0xE9,0x45),
     o2(0xE9,0x46),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_A2 = {
    to_SHIFT_JIS_E9_A2_offsets,
    to_SHIFT_JIS_E9_A2_infos
};

static const unsigned char
to_SHIFT_JIS_E9_A3_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_A3 */
  /* used from to_EUC_JP_E9_A3 */
     17, 17, 17,  0,  1, 17,  2, 17,   17, 17, 17, 17, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,   17, 17, 17,  3,  4, 17, 17,  5,
     17, 17,  6, 17, 17, 17, 17, 17,   17,  7, 17,  8, 17,  9, 10, 11,
     17, 17, 12, 17, 13, 17, 17, 17,   17, 17, 17, 17, 14, 15, 16, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_A3_infos[18] = {
     o2(0xE9,0x48), o2(0xE9,0x47), o2(0xE9,0x49), o2(0x94,0xF2),
     o2(0xE3,0xCA), o2(0x90,0x48), o2(0x8B,0x51), o2(0xE9,0x4A),
     o2(0xE9,0x4B), o2(0x99,0xAA), o2(0x9F,0x5A), o2(0x94,0xD1),
     o2(0x88,0xF9), o2(0x88,0xB9), o2(0x8E,0x94), o2(0x96,0x4F),
     o2(0x8F,0xFC),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_A3 = {
    to_SHIFT_JIS_E9_A3_offsets,
    to_SHIFT_JIS_E9_A3_infos
};

static const unsigned char
to_SHIFT_JIS_E9_A4_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_A4 */
  /* used from to_EUC_JP_E9_A4 */
     21, 21, 21,  0, 21,  1, 21, 21,   21,  2,  3, 21,  4, 21, 21, 21,
      5, 21,  6,  7,  8, 21, 21, 21,    9, 21, 21, 21, 21, 10, 11, 21,
     12, 13, 21, 21, 14, 21, 21, 15,   16, 21, 21, 21, 17, 21, 18, 21,
     21, 21, 21, 21, 21, 21, 21, 21,   21, 21, 21, 21, 21, 19, 20, 21,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_A4_infos[22] = {
     o2(0xE9,0x4C), o2(0x96,0xDD), o2(0xE9,0x4D), o2(0x97,0x7B),
     o2(0x89,0x61), o2(0x8E,0x60), o2(0xE9,0x4E), o2(0x89,0xEC),
     o2(0xE9,0x4F), o2(0xE9,0x50), o2(0xE9,0x52), o2(0xE9,0x53),
     o2(0xE9,0x55), o2(0xE9,0x51), o2(0xE9,0x54), o2(0xFB,0xF8),
     o2(0x8A,0xD9), o2(0xE9,0x56), o2(0xE9,0x57), o2(0xE9,0x58),
     o2(0xE9,0x59),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_A4 = {
    to_SHIFT_JIS_E9_A4_offsets,
    to_SHIFT_JIS_E9_A4_infos
};

static const unsigned char
to_SHIFT_JIS_E9_A5_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_A5 */
  /* used from to_EUC_JP_E9_A5 */
     10, 10,  0, 10, 10,  1, 10, 10,   10,  2, 10,  3,  4, 10, 10, 10,
      5,  6,  7, 10, 10,  8, 10,  9,   10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,   10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,   10, 10, 10, 10, 10, 10, 10, 10,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_A5_infos[11] = {
     o2(0xE9,0x5A), o2(0xE9,0x5C), o2(0xE9,0x5B), o2(0xE9,0x5E),
     o2(0xE9,0x61), o2(0xE9,0x5D), o2(0xE9,0x5F), o2(0xE9,0x60),
     o2(0xE9,0x62), o2(0x8B,0xC0),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_A5 = {
    to_SHIFT_JIS_E9_A5_offsets,
    to_SHIFT_JIS_E9_A5_infos
};

static const unsigned char
to_SHIFT_JIS_E9_A6_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_A6 */
  /* used from to_EUC_JP_E9_A6 */
     13, 13, 13, 13, 13, 13, 13, 13,   13, 13, 13, 13, 13, 13, 13, 13,
     13, 13, 13, 13, 13, 13,  0,  1,    2,  3, 13, 13, 13, 13,  4, 13,
     13, 13, 13, 13, 13,  5, 13, 13,    6, 13, 13, 13,  7,  8,  9, 13,
     13, 13, 13, 10, 11, 13, 13, 13,   13, 13, 13, 13, 12, 13, 13, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_A6_infos[14] = {
     o2(0x8E,0xF1), o2(0xE9,0x63), o2(0xE9,0x64), o2(0x8D,0x81),
     o2(0xFB,0xFA), o2(0xE9,0x65), o2(0x8A,0x5D), o2(0x94,0x6E),
     o2(0xE9,0x66), o2(0xE9,0x67), o2(0x92,0x79), o2(0x93,0xE9),
     o2(0xE9,0x68),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_A6 = {
    to_SHIFT_JIS_E9_A6_offsets,
    to_SHIFT_JIS_E9_A6_infos
};

static const unsigned char
to_SHIFT_JIS_E9_A7_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_A7 */
  /* used from to_EUC_JP_E9_A7 */
     21,  0, 21, 21,  1,  2,  3, 21,    4, 21, 21, 21, 21, 21, 21, 21,
      5,  6,  7, 21, 21,  8, 21, 21,    9, 21, 21, 10, 21, 11, 21, 12,
     21, 21, 13, 21, 21, 21, 21, 21,   21, 21, 21, 21, 21, 14, 15, 21,
     21, 16, 17, 21, 21, 21, 21, 21,   18, 21, 21, 19, 21, 21, 21, 20,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_A7_infos[22] = {
     o2(0x94,0x9D), o2(0x91,0xCA), o2(0x89,0x77), o2(0x8B,0xEC),
     o2(0x8B,0xED), o2(0x92,0x93), o2(0xE9,0x6D), o2(0x8B,0xEE),
     o2(0x89,0xED), o2(0xE9,0x6C), o2(0xE9,0x6A), o2(0xE9,0x6B),
     o2(0xE9,0x69), o2(0xE9,0x77), o2(0xE9,0x6E), o2(0xE9,0x6F),
     o2(0xE9,0x70), o2(0xE9,0x71), o2(0xE9,0x73), o2(0xE9,0x72),
     o2(0x8F,0x78),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_A7 = {
    to_SHIFT_JIS_E9_A7_offsets,
    to_SHIFT_JIS_E9_A7_infos
};

static const unsigned char
to_SHIFT_JIS_E9_A8_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_A8 */
  /* used from to_EUC_JP_E9_A8 */
     12,  0, 12, 12, 12,  1, 12, 12,   12, 12, 12, 12, 12, 12,  2,  3,
     12, 12,  4,  5, 12, 12, 12, 12,   12,  6, 12, 12, 12, 12, 12, 12,
     12, 12, 12, 12, 12, 12, 12, 12,    7, 12, 12,  8, 12, 12, 12, 12,
      9, 12, 12, 12, 12, 12, 12, 10,   12, 12, 12, 12, 12, 12, 11, 12,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_A8_infos[13] = {
     o2(0xE9,0x74), o2(0xE9,0x76), o2(0x8B,0x52), o2(0xE9,0x75),
     o2(0x91,0x9B), o2(0x8C,0xB1), o2(0xE9,0x78), o2(0x91,0xCB),
     o2(0xE9,0x79), o2(0x93,0xAB), o2(0xE9,0x7A), o2(0xE9,0x80),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_A8 = {
    to_SHIFT_JIS_E9_A8_offsets,
    to_SHIFT_JIS_E9_A8_infos
};

static const unsigned char
to_SHIFT_JIS_E9_A9_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_A9 */
  /* used from to_EUC_JP_E9_A9 */
      0, 17,  1,  2, 17,  3, 17, 17,   17, 17, 17, 17, 17,  4,  5, 17,
     17, 17, 17, 17, 17,  6, 17,  7,   17, 17,  8,  9, 17, 17, 17, 10,
     17, 17, 11, 17, 12, 13, 17, 17,   17, 14, 15, 16, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,   17, 17, 17, 17, 17, 17, 17, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_A9_infos[18] = {
     o2(0xE9,0x7D), o2(0xE9,0x7C), o2(0xE9,0x7E), o2(0xE9,0x7B),
     o2(0xE9,0x82), o2(0xFB,0xFB), o2(0xE9,0x81), o2(0xE9,0x84),
     o2(0x8B,0xC1), o2(0xE9,0x83), o2(0xE9,0x85), o2(0xE9,0x86),
     o2(0xE9,0x88), o2(0xE9,0x87), o2(0xE9,0x89), o2(0xE9,0x8B),
     o2(0xE9,0x8A),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_A9 = {
    to_SHIFT_JIS_E9_A9_offsets,
    to_SHIFT_JIS_E9_A9_infos
};

static const unsigned char
to_SHIFT_JIS_E9_AA_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_AA */
  /* used from to_EUC_JP_E9_AA */
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    0,  5,  5,  5,  5,  1,  5,  5,
      2,  5,  5,  5,  5,  5,  5,  5,    3,  5,  5,  5,  4,  5,  5,  5,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_AA_infos[6] = {
     o2(0x8D,0x9C), o2(0xE9,0x8C), o2(0xE9,0x8D), o2(0x8A,0x5B),
     o2(0xE9,0x8E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_AA = {
    to_SHIFT_JIS_E9_AA_offsets,
    to_SHIFT_JIS_E9_AA_infos
};

static const unsigned char
to_SHIFT_JIS_E9_AB_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_AB */
  /* used from to_EUC_JP_E9_AB */
      0, 23, 23, 23,  1, 23, 23, 23,   23, 23, 23, 23, 23, 23, 23,  2,
     23,  3, 23,  4,  5, 23, 23, 23,    6,  7, 23, 23,  8, 23,  9, 10,
     23, 23, 11, 12, 23, 23, 13, 23,   23, 23, 14, 15, 23, 16, 17, 18,
     23, 19, 23, 23, 20, 23, 23, 21,   23, 23, 23, 22, 23, 23, 23, 23,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_AB_infos[24] = {
     o2(0xE9,0x8F), o2(0x90,0x91), o2(0xE9,0x90), o2(0xE9,0x91),
     o2(0xE9,0x92), o2(0xE9,0x93), o2(0x8D,0x82), o2(0xFB,0xFC),
     o2(0xFC,0x40), o2(0xE9,0x94), o2(0xE9,0x95), o2(0xE9,0x96),
     o2(0xE9,0x97), o2(0xE9,0x98), o2(0x94,0xAF), o2(0xE9,0x9A),
     o2(0x95,0x45), o2(0xE9,0x9B), o2(0xE9,0x99), o2(0xE9,0x9D),
     o2(0xE9,0x9C), o2(0xE9,0x9E), o2(0xE9,0x9F),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_AB = {
    to_SHIFT_JIS_E9_AB_offsets,
    to_SHIFT_JIS_E9_AB_infos
};

static const unsigned char
to_SHIFT_JIS_E9_AC_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_AC */
  /* used from to_EUC_JP_E9_AC */
     17, 17, 17, 17, 17, 17,  0, 17,   17, 17, 17, 17, 17, 17, 17, 17,
     17, 17, 17, 17, 17, 17, 17, 17,    1, 17,  2, 17, 17, 17, 17,  3,
     17, 17,  4,  5, 17,  6, 17,  7,    8,  9, 10, 17, 17, 17, 11, 12,
     17, 13, 14, 17, 17, 17, 17, 17,   17, 17, 17, 15, 16, 17, 17, 17,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_AC_infos[18] = {
     o2(0xE9,0xA0), o2(0xE9,0xA1), o2(0xE9,0xA2), o2(0xE9,0xA3),
     o2(0xE9,0xA4), o2(0xE9,0xA5), o2(0xE9,0xA6), o2(0xE9,0xA7),
     o2(0xE9,0xA8), o2(0xE9,0xA9), o2(0xE9,0xAA), o2(0xE9,0xAB),
     o2(0xE9,0xAC), o2(0x9F,0x54), o2(0xE9,0xAD), o2(0xE2,0xF6),
     o2(0x8B,0x53),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_AC = {
    to_SHIFT_JIS_E9_AC_offsets,
    to_SHIFT_JIS_E9_AC_infos
};

static const unsigned char
to_SHIFT_JIS_E9_AD_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_AD */
  /* used from to_EUC_JP_E9_AD */
     16,  0,  1,  2,  3,  4, 16, 16,   16, 16, 16, 16, 16,  5,  6,  7,
     16,  8, 16, 16,  9, 16, 16, 16,   10, 16, 11, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 16, 16, 16, 12,
     16, 16, 13, 16, 14, 15, 16, 16,   16, 16, 16, 16, 16, 16, 16, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_AD_infos[17] = {
     o2(0x8A,0x40), o2(0x8D,0xB0), o2(0xE9,0xAF), o2(0xE9,0xAE),
     o2(0x96,0xA3), o2(0xE9,0xB1), o2(0xE9,0xB2), o2(0xE9,0xB0),
     o2(0xE9,0xB3), o2(0x96,0x82), o2(0xE9,0xB4), o2(0x8B,0x9B),
     o2(0x98,0x44), o2(0xFC,0x42), o2(0xE9,0xB5), o2(0xFC,0x41),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_AD = {
    to_SHIFT_JIS_E9_AD_offsets,
    to_SHIFT_JIS_E9_AD_infos
};

static const unsigned char
to_SHIFT_JIS_E9_AE_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_AE */
  /* used from to_EUC_JP_E9_AE */
     19, 19, 19,  0, 19, 19, 19, 19,   19, 19, 19, 19, 19, 19,  1,  2,
     19,  3,  4,  5, 19, 19,  6,  7,   19, 19, 19, 19, 19, 19, 19,  8,
      9, 19, 19, 19, 19, 19, 19, 19,   10, 19, 11, 12, 19, 13, 14, 19,
     19, 15, 19, 19, 16, 19, 19, 19,   19, 17, 19, 18, 19, 19, 19, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_AE_infos[20] = {
     o2(0xE9,0xB7), o2(0x88,0xBC), o2(0xFC,0x43), o2(0xE9,0xB8),
     o2(0x95,0xA9), o2(0xE9,0xB6), o2(0xE9,0xB9), o2(0xE9,0xBA),
     o2(0xE9,0xBB), o2(0xE9,0xBC), o2(0xE9,0xBD), o2(0x96,0x8E),
     o2(0x8E,0x4C), o2(0x8D,0xF8), o2(0x91,0x4E), o2(0xFC,0x44),
     o2(0xE9,0xBE), o2(0xE9,0xC1), o2(0xFC,0x45),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_AE = {
    to_SHIFT_JIS_E9_AE_offsets,
    to_SHIFT_JIS_E9_AE_infos
};

static const unsigned char
to_SHIFT_JIS_E9_AF_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_AF */
  /* used from to_EUC_JP_E9_AF */
      0, 19, 19, 19, 19, 19,  1, 19,   19,  2,  3, 19, 19, 19, 19,  4,
     19,  5,  6, 19,  7, 19,  8, 19,   19, 19, 19,  9, 19, 19, 19, 19,
     19, 10, 11, 12, 13, 19, 19, 19,   14, 19, 19, 19, 19, 19, 19, 19,
     15, 16, 17, 19, 19, 18, 19, 19,   19, 19, 19, 19, 19, 19, 19, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_AF_infos[20] = {
     o2(0xE9,0xBF), o2(0xE9,0xC2), o2(0x8C,0xEF), o2(0xE9,0xC0),
     o2(0xE9,0xC3), o2(0xE9,0xC4), o2(0xE9,0xC5), o2(0xE9,0xC9),
     o2(0x8E,0x49), o2(0x91,0xE2), o2(0xE9,0xCA), o2(0xE9,0xC7),
     o2(0xE9,0xC6), o2(0xE9,0xC8), o2(0x8C,0x7E), o2(0xE9,0xCE),
     o2(0xE9,0xCD), o2(0xE9,0xCC), o2(0x88,0xB1),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_AF = {
    to_SHIFT_JIS_E9_AF_offsets,
    to_SHIFT_JIS_E9_AF_infos
};

static const unsigned char
to_SHIFT_JIS_E9_B0_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_B0 */
  /* used from to_EUC_JP_E9_B0 */
      0, 26, 26, 26,  1, 26,  2, 26,    3,  4,  5, 26,  6,  7, 26, 26,
      8, 26,  9, 10, 11, 12, 26, 26,   26, 26, 26, 13, 26, 26, 26, 26,
     26, 14, 26, 26, 15, 16, 26, 26,   26, 26, 26, 26, 26, 17, 18, 19,
     20, 26, 21, 26, 26, 26, 26, 26,   26, 22, 23, 24, 26, 26, 25, 26,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_B0_infos[27] = {
     o2(0xFC,0x46), o2(0xE9,0xD8), o2(0xE9,0xD4), o2(0xE9,0xD5),
     o2(0xE9,0xD1), o2(0xE9,0xD7), o2(0xE9,0xD3), o2(0x8A,0x82),
     o2(0x98,0x6B), o2(0xE9,0xD6), o2(0xE9,0xD2), o2(0xE9,0xD0),
     o2(0xE9,0xCF), o2(0xE9,0xDA), o2(0xE9,0xDD), o2(0xE9,0xDC),
     o2(0xE9,0xDB), o2(0x95,0x68), o2(0xE9,0xD9), o2(0x88,0xF1),
     o2(0xE9,0xDE), o2(0xE9,0xE0), o2(0x8A,0x8F), o2(0xE9,0xCB),
     o2(0x89,0x56), o2(0xE9,0xE2),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_B0 = {
    to_SHIFT_JIS_E9_B0_offsets,
    to_SHIFT_JIS_E9_B0_infos
};

static const unsigned char
to_SHIFT_JIS_E9_B1_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_B1 */
  /* used from to_EUC_JP_E9_B1 */
     10, 10, 10, 10, 10, 10,  0,  1,    2, 10, 10, 10, 10, 10, 10, 10,
     10, 10,  3, 10, 10, 10, 10,  4,   10, 10,  5, 10, 10, 10, 10, 10,
      6, 10, 10, 10, 10, 10, 10,  7,   10, 10, 10, 10, 10, 10, 10, 10,
     10, 10, 10, 10, 10, 10,  8, 10,    9, 10, 10, 10, 10, 10, 10, 10,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_B1_infos[11] = {
     o2(0xE9,0xE1), o2(0xE9,0xDF), o2(0x92,0x4C), o2(0x96,0x90),
     o2(0x97,0xD8), o2(0xE9,0xE3), o2(0xE9,0xE4), o2(0xE9,0xE5),
     o2(0xE9,0xE6), o2(0xE9,0xE7),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_B1 = {
    to_SHIFT_JIS_E9_B1_offsets,
    to_SHIFT_JIS_E9_B1_infos
};

static const unsigned char
to_SHIFT_JIS_E9_B3_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_B3 */
  /* used from to_EUC_JP_E9_B3 */
      9,  9,  9,  9,  9,  9,  9,  9,    9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  9,  9,  9,    9,  9,  9,  9,  9,  9,  9,  9,
      9,  9,  9,  9,  9,  0,  9,  1,    9,  2,  9,  3,  4,  9,  9,  9,
      5,  9,  9,  6,  7,  9,  8,  9,    9,  9,  9,  9,  9,  9,  9,  9,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_B3_infos[10] = {
     o2(0x92,0xB9), o2(0xE9,0xE8), o2(0x94,0xB5), o2(0xE9,0xED),
     o2(0xE9,0xE9), o2(0xE9,0xEA), o2(0x96,0x50), o2(0x96,0xC2),
     o2(0x93,0xCE),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_B3 = {
    to_SHIFT_JIS_E9_B3_offsets,
    to_SHIFT_JIS_E9_B3_infos
};

static const unsigned char
to_SHIFT_JIS_E9_B4_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_B4 */
  /* used from to_EUC_JP_E9_B4 */
     19, 19, 19,  0, 19, 19,  1,  2,    3,  4, 19, 19, 19, 19,  5, 19,
     19, 19,  6, 19, 19,  7, 19, 19,   19, 19, 19,  8, 19, 19, 19,  9,
     19, 19, 19, 10, 19, 19, 11, 19,   12, 19, 13, 14, 15, 19, 19, 19,
     19, 19, 19, 19, 19, 19, 19, 19,   19, 19, 19, 16, 19, 19, 17, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_B4_infos[20] = {
     o2(0xE9,0xEE), o2(0xE9,0xEF), o2(0x93,0xBC), o2(0xE9,0xEC),
     o2(0xE9,0xEB), o2(0x89,0xA8), o2(0xE9,0xF7), o2(0xE9,0xF6),
     o2(0x89,0x95), o2(0xE9,0xF4), o2(0xE9,0xF3), o2(0xE9,0xF1),
     o2(0x8A,0x9B), o2(0xE9,0xF0), o2(0x8E,0xB0), o2(0x89,0xA7),
     o2(0x8D,0x83), o2(0xE9,0xFA), o2(0xE9,0xF9),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_B4 = {
    to_SHIFT_JIS_E9_B4_offsets,
    to_SHIFT_JIS_E9_B4_infos
};

static const unsigned char
to_SHIFT_JIS_E9_B5_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_B5 */
  /* used from to_EUC_JP_E9_B5 */
     19,  0, 19, 19,  1, 19,  2, 19,    3, 19, 19, 19, 19, 19, 19, 19,
      4,  5, 19, 19, 19, 19, 19, 19,   19,  6, 19, 19,  7,  8,  9, 19,
     10, 11, 19, 19, 12, 19, 19, 19,   19, 19, 19, 13, 14, 19, 19, 15,
     16, 19, 17, 19, 19, 19, 19, 19,   19, 19, 18, 19, 19, 19, 19, 19,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_B5_infos[20] = {
     o2(0xE9,0xF8), o2(0xE9,0xF5), o2(0xE9,0xFB), o2(0xE9,0xFC),
     o2(0xEA,0x44), o2(0xEA,0x43), o2(0xEA,0x45), o2(0x89,0x4C),
     o2(0xEA,0x40), o2(0xEA,0x41), o2(0x8D,0x94), o2(0x96,0xB7),
     o2(0xEA,0x42), o2(0xFC,0x48), o2(0x96,0x51), o2(0xEA,0x4A),
     o2(0xFC,0x47), o2(0xEA,0x46), o2(0xEA,0x4B),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_B5 = {
    to_SHIFT_JIS_E9_B5_offsets,
    to_SHIFT_JIS_E9_B5_infos
};

static const unsigned char
to_SHIFT_JIS_E9_B6_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_B6 */
  /* used from to_EUC_JP_E9_B6 */
     13, 13, 13, 13, 13, 13, 13,  0,   13,  1, 13, 13, 13, 13, 13,  2,
     13, 13, 13, 13, 13, 13, 13, 13,   13, 13,  3, 13, 13, 13, 13, 13,
     13, 13, 13, 13,  4, 13, 13, 13,   13,  5, 13,  6, 13, 13, 13,  7,
     13, 13,  8, 13,  9, 13, 13, 13,   10, 13, 11, 12, 13, 13, 13, 13,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_B6_infos[14] = {
     o2(0xEA,0x48), o2(0xEA,0x47), o2(0x8C,0x7B), o2(0xEA,0x4C),
     o2(0xEA,0x4D), o2(0xEA,0x4E), o2(0xEA,0x49), o2(0xE9,0xF2),
     o2(0xEA,0x4F), o2(0x92,0xDF), o2(0xEA,0x53), o2(0xEA,0x54),
     o2(0xEA,0x52),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_B6 = {
    to_SHIFT_JIS_E9_B6_offsets,
    to_SHIFT_JIS_E9_B6_infos
};

static const unsigned char
to_SHIFT_JIS_E9_B7_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_B7 */
  /* used from to_EUC_JP_E9_B7 */
     15,  0,  1, 15,  2, 15,  3, 15,   15, 15, 15, 15, 15, 15, 15,  4,
     15, 15, 15,  5, 15, 15, 15, 15,   15,  6, 15, 15, 15, 15, 15, 15,
     15, 15, 15, 15, 15, 15,  7, 15,   15, 15, 15, 15, 15,  8, 15,  9,
     15, 15, 10, 15, 15, 15, 15, 15,   11, 12, 13, 15, 15, 14, 15, 15,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_B7_infos[16] = {
     o2(0xEA,0x51), o2(0xEA,0x57), o2(0xEA,0x50), o2(0xEA,0x55),
     o2(0xEA,0x56), o2(0xEA,0x59), o2(0xEA,0x58), o2(0xEA,0x5B),
     o2(0xEA,0x5C), o2(0xEA,0x5D), o2(0x98,0x68), o2(0xEA,0x5A),
     o2(0x91,0xE9), o2(0x8D,0xEB), o2(0xEA,0x5E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_B7 = {
    to_SHIFT_JIS_E9_B7_offsets,
    to_SHIFT_JIS_E9_B7_infos
};

static const unsigned char
to_SHIFT_JIS_E9_B8_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_B8 */
  /* used from to_EUC_JP_E9_B8 */
      4,  4,  4,  4,  4,  4,  4,  4,    4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,    4,  0,  1,  2,  4,  4,  3,  4,
      4,  4,  4,  4,  4,  4,  4,  4,    4,  4,  4,  4,  4,  4,  4,  4,
      4,  4,  4,  4,  4,  4,  4,  4,    4,  4,  4,  4,  4,  4,  4,  4,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_B8_infos[5] = {
     o2(0xFC,0x4A), o2(0xEA,0x5F), o2(0xEA,0x60), o2(0xEA,0x61),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_B8 = {
    to_SHIFT_JIS_E9_B8_offsets,
    to_SHIFT_JIS_E9_B8_infos
};

static const unsigned char
to_SHIFT_JIS_E9_B9_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_B9 */
  /* used from to_EUC_JP_E9_B9 */
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  0,  5,  5,    1,  2,  5,  5,  5,  3,  5,  4,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_B9_infos[6] = {
     o2(0xEA,0x62), o2(0x8C,0xB2), o2(0xEA,0x63), o2(0xEA,0x64),
     o2(0x8E,0xAD),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_B9 = {
    to_SHIFT_JIS_E9_B9_offsets,
    to_SHIFT_JIS_E9_B9_infos
};

static const unsigned char
to_SHIFT_JIS_E9_BA_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_BA */
  /* used from to_EUC_JP_E9_BA */
     23,  0, 23, 23, 23, 23, 23, 23,    1, 23, 23,  2,  3, 23, 23, 23,
     23,  4,  5,  6, 23,  7, 23,  8,   23, 23, 23, 23, 23,  9, 23, 10,
     23, 23, 23, 23, 23, 11, 12, 23,   23, 13, 14, 23, 23, 15, 23, 23,
     23, 23, 23, 23, 23, 23, 23, 23,   16, 17, 18, 19, 20, 23, 21, 22,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_BA_infos[24] = {
     o2(0xEA,0x65), o2(0xEA,0x66), o2(0xEA,0x67), o2(0xEA,0x68),
     o2(0xEA,0x6B), o2(0xEA,0x69), o2(0x98,0x5B), o2(0xEA,0x6A),
     o2(0x97,0xED), o2(0xEA,0x6C), o2(0x97,0xD9), o2(0xEA,0x6D),
     o2(0x94,0x9E), o2(0xEA,0x6E), o2(0xEA,0x70), o2(0xEA,0x71),
     o2(0xEA,0x6F), o2(0x8D,0x8D), o2(0x96,0xCB), o2(0x96,0x83),
     o2(0x9B,0xF5), o2(0x9F,0x80), o2(0x96,0x9B),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_BA = {
    to_SHIFT_JIS_E9_BA_offsets,
    to_SHIFT_JIS_E9_BA_infos
};

static const unsigned char
to_SHIFT_JIS_E9_BB_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_BB */
  /* used from to_EUC_JP_E9_BB */
     26, 26, 26, 26,  0, 26, 26, 26,   26, 26, 26, 26,  1,  2,  3,  4,
      5,  6,  7, 26,  8, 26, 26, 26,    9, 10, 26, 11, 12, 13, 14, 26,
     15, 26, 26, 26, 26, 16, 26, 26,   17, 26, 26, 26, 26, 26, 26, 18,
     26, 26, 26, 26, 19, 26, 20, 21,   26, 22, 26, 23, 24, 25, 26, 26,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_BB_infos[27] = {
     o2(0x89,0xA9), o2(0xEA,0x73), o2(0x8B,0x6F), o2(0xEA,0x74),
     o2(0xEA,0x75), o2(0xEA,0x76), o2(0xFC,0x4B), o2(0x8D,0x95),
     o2(0xEA,0x77), o2(0xE0,0xD2), o2(0x96,0xD9), o2(0x91,0xE1),
     o2(0xEA,0x78), o2(0xEA,0x7A), o2(0xEA,0x79), o2(0xEA,0x7B),
     o2(0xEA,0x7C), o2(0xEA,0x7D), o2(0xEA,0x7E), o2(0xEA,0x80),
     o2(0xEA,0x81), o2(0xEA,0x82), o2(0xEA,0x83), o2(0xEA,0x84),
     o2(0xEA,0x85), o2(0xEA,0x86),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_BB = {
    to_SHIFT_JIS_E9_BB_offsets,
    to_SHIFT_JIS_E9_BB_infos
};

static const unsigned char
to_SHIFT_JIS_E9_BC_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_BC */
  /* used from to_EUC_JP_E9_BC */
     10, 10, 10, 10, 10, 10, 10,  0,    1, 10, 10, 10, 10, 10,  2, 10,
     10, 10, 10,  3, 10,  4, 10, 10,   10, 10, 10, 10, 10, 10, 10, 10,
      5,  6, 10, 10, 10, 10, 10, 10,   10, 10, 10, 10,  7, 10, 10, 10,
     10, 10, 10, 10, 10, 10, 10, 10,   10, 10, 10,  8, 10, 10,  9, 10,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_BC_infos[11] = {
     o2(0xEA,0x87), o2(0xEA,0x88), o2(0x93,0x43), o2(0x8C,0xDB),
     o2(0xEA,0x8A), o2(0x91,0x6C), o2(0xEA,0x8B), o2(0xEA,0x8C),
     o2(0x95,0x40), o2(0xEA,0x8D),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_BC = {
    to_SHIFT_JIS_E9_BC_offsets,
    to_SHIFT_JIS_E9_BC_infos
};

static const unsigned char
to_SHIFT_JIS_E9_BD_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_BD */
  /* used from to_EUC_JP_E9_BD */
     18, 18, 18, 18, 18, 18, 18, 18,   18, 18,  0,  1, 18, 18,  2,  3,
     18, 18,  4, 18,  5, 18, 18, 18,   18, 18, 18, 18, 18, 18, 18,  6,
      7,  8,  9, 10, 18, 18, 11, 12,   18, 18, 13, 18, 14, 18, 18, 18,
     18, 18, 15, 18, 18, 18, 16, 17,   18, 18, 18, 18, 18, 18, 18, 18,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_BD_infos[19] = {
     o2(0xEA,0x8E), o2(0xE2,0x56), o2(0xE6,0xD8), o2(0xE8,0xEB),
     o2(0xEA,0x8F), o2(0xEA,0x90), o2(0xEA,0x92), o2(0xEA,0x93),
     o2(0xEA,0x94), o2(0x97,0xEE), o2(0xEA,0x91), o2(0xEA,0x95),
     o2(0xEA,0x96), o2(0xEA,0x98), o2(0xEA,0x97), o2(0xEA,0x9A),
     o2(0xEA,0x9B), o2(0xEA,0x99),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_BD = {
    to_SHIFT_JIS_E9_BD_offsets,
    to_SHIFT_JIS_E9_BD_infos
};

static const unsigned char
to_SHIFT_JIS_E9_BE_offsets[64] = {
  /* used from to_SHIFT_JIS_E9_BE */
  /* used from to_EUC_JP_E9_BE */
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  0,  5,  5,
      5,  5,  5,  5,  5,  1,  5,  5,    5,  5,  5,  5,  2,  3,  5,  5,
      4,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_BE_infos[6] = {
     o2(0x97,0xB4), o2(0xEA,0x9C), o2(0xEA,0x9D), o2(0xE2,0x73),
     o2(0xEA,0x9E),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9_BE = {
    to_SHIFT_JIS_E9_BE_offsets,
    to_SHIFT_JIS_E9_BE_infos
};

static const unsigned char
to_SHIFT_JIS_E9_offsets[64] = {
  /* used from to_SHIFT_JIS_E9 */
  /* used from to_EUC_JP_E9 */
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 60, 60, 19, 20, 21,   22, 23, 24, 25, 26, 27, 28, 29,
     30, 31, 32, 33, 34, 35, 36, 37,   38, 39, 40, 41, 42, 43, 44, 45,
     46, 47, 60, 48, 49, 50, 51, 52,   53, 54, 55, 56, 57, 58, 59, 60,
};
static const struct byte_lookup* const
to_SHIFT_JIS_E9_infos[61] = {
     &to_SHIFT_JIS_E9_80, &to_SHIFT_JIS_E9_81,
     &to_SHIFT_JIS_E9_82, &to_SHIFT_JIS_E9_83,
     &to_SHIFT_JIS_E9_84, &to_SHIFT_JIS_E9_85,
     &to_SHIFT_JIS_E9_86, &to_SHIFT_JIS_E9_87,
     &to_SHIFT_JIS_E9_88, &to_SHIFT_JIS_E9_89,
     &to_SHIFT_JIS_E9_8A, &to_SHIFT_JIS_E9_8B,
     &to_SHIFT_JIS_E9_8C, &to_SHIFT_JIS_E9_8D,
     &to_SHIFT_JIS_E9_8E, &to_SHIFT_JIS_E9_8F,
     &to_SHIFT_JIS_E9_90, &to_SHIFT_JIS_E9_91,
     &to_SHIFT_JIS_E9_92, &to_SHIFT_JIS_E9_95,
     &to_SHIFT_JIS_E9_96, &to_SHIFT_JIS_E9_97,
     &to_SHIFT_JIS_E9_98, &to_SHIFT_JIS_E9_99,
     &to_SHIFT_JIS_E9_9A, &to_SHIFT_JIS_E9_9B,
     &to_SHIFT_JIS_E9_9C, &to_SHIFT_JIS_E9_9D,
     &to_SHIFT_JIS_E9_9E, &to_SHIFT_JIS_E9_9F,
     &to_SHIFT_JIS_E9_A0, &to_SHIFT_JIS_E9_A1,
     &to_SHIFT_JIS_E9_A2, &to_SHIFT_JIS_E9_A3,
     &to_SHIFT_JIS_E9_A4, &to_SHIFT_JIS_E9_A5,
     &to_SHIFT_JIS_E9_A6, &to_SHIFT_JIS_E9_A7,
     &to_SHIFT_JIS_E9_A8, &to_SHIFT_JIS_E9_A9,
     &to_SHIFT_JIS_E9_AA, &to_SHIFT_JIS_E9_AB,
     &to_SHIFT_JIS_E9_AC, &to_SHIFT_JIS_E9_AD,
     &to_SHIFT_JIS_E9_AE, &to_SHIFT_JIS_E9_AF,
     &to_SHIFT_JIS_E9_B0, &to_SHIFT_JIS_E9_B1,
     &to_SHIFT_JIS_E9_B3, &to_SHIFT_JIS_E9_B4,
     &to_SHIFT_JIS_E9_B5, &to_SHIFT_JIS_E9_B6,
     &to_SHIFT_JIS_E9_B7, &to_SHIFT_JIS_E9_B8,
     &to_SHIFT_JIS_E9_B9, &to_SHIFT_JIS_E9_BA,
     &to_SHIFT_JIS_E9_BB, &to_SHIFT_JIS_E9_BC,
     &to_SHIFT_JIS_E9_BD, &to_SHIFT_JIS_E9_BE,
                   UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_E9 = {
    to_SHIFT_JIS_E9_offsets,
    to_SHIFT_JIS_E9_infos
};

static const unsigned char
to_SHIFT_JIS_EF_A4_offsets[64] = {
  /* used from to_SHIFT_JIS_EF_A4 */
  /* used from to_EUC_JP_EF_A4 */
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  0,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
};
static const struct byte_lookup* const
to_SHIFT_JIS_EF_A4_infos[2] = {
     o2(0xFA,0xE0),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_EF_A4 = {
    to_SHIFT_JIS_EF_A4_offsets,
    to_SHIFT_JIS_EF_A4_infos
};

static const unsigned char
to_SHIFT_JIS_EF_A7_offsets[64] = {
  /* used from to_SHIFT_JIS_EF_A7 */
  /* used from to_EUC_JP_EF_A7 */
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  0,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
};
static const struct byte_lookup* const
to_SHIFT_JIS_EF_A7_infos[2] = {
     o2(0xFB,0xE9),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_EF_A7 = {
    to_SHIFT_JIS_EF_A7_offsets,
    to_SHIFT_JIS_EF_A7_infos
};

static const unsigned char
to_SHIFT_JIS_EF_A8_offsets[64] = {
  /* used from to_SHIFT_JIS_EF_A8 */
  /* used from to_EUC_JP_EF_A8 */
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32,  0,  1,
      2,  3,  4,  5,  6,  7,  8,  9,   10, 11, 12, 13, 14, 15, 16, 17,
     18, 19, 20, 21, 22, 23, 24, 25,   26, 27, 28, 29, 30, 31, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
};
static const struct byte_lookup* const
to_SHIFT_JIS_EF_A8_infos[33] = {
     o2(0xFA,0x90), o2(0xFA,0x9B), o2(0xFA,0x9C), o2(0xFA,0xB1),
     o2(0xFA,0xD8), o2(0xFA,0xE8), o2(0xFA,0xEA), o2(0xFB,0x58),
     o2(0xFB,0x5E), o2(0xFB,0x75), o2(0xFB,0x7D), o2(0xFB,0x7E),
     o2(0xFB,0x80), o2(0xFB,0x82), o2(0xFB,0x86), o2(0xFB,0x89),
     o2(0xFB,0x92), o2(0xFB,0x9D), o2(0xFB,0x9F), o2(0xFB,0xA0),
     o2(0xFB,0xA9), o2(0xFB,0xB1), o2(0xFB,0xB3), o2(0xFB,0xB4),
     o2(0xFB,0xB7), o2(0xFB,0xD3), o2(0xFB,0xDA), o2(0xFB,0xEA),
     o2(0xFB,0xF6), o2(0xFB,0xF7), o2(0xFB,0xF9), o2(0xFC,0x49),
             UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_EF_A8 = {
    to_SHIFT_JIS_EF_A8_offsets,
    to_SHIFT_JIS_EF_A8_infos
};

static const unsigned char
to_SHIFT_JIS_EF_BC_offsets[64] = {
  /* used from to_SHIFT_JIS_EF_BC */
  /* used from to_EUC_JP_EF_BC */
     61,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 61, 61, 11, 12,
     13, 14, 15, 16, 17, 18, 19, 20,   21, 22, 23, 24, 25, 26, 27, 28,
     29, 30, 31, 32, 33, 34, 35, 36,   37, 38, 39, 40, 41, 42, 43, 44,
     45, 46, 47, 48, 49, 50, 51, 52,   53, 54, 55, 56, 57, 58, 59, 60,
};
static const struct byte_lookup* const
to_SHIFT_JIS_EF_BC_infos[62] = {
     o2(0x81,0x49), o2(0xFA,0x57), o2(0x81,0x94), o2(0x81,0x90),
     o2(0x81,0x93), o2(0x81,0x95), o2(0xFA,0x56), o2(0x81,0x69),
     o2(0x81,0x6A), o2(0x81,0x96), o2(0x81,0x7B), o2(0x81,0x44),
     o2(0x81,0x5E), o2(0x82,0x4F), o2(0x82,0x50), o2(0x82,0x51),
     o2(0x82,0x52), o2(0x82,0x53), o2(0x82,0x54), o2(0x82,0x55),
     o2(0x82,0x56), o2(0x82,0x57), o2(0x82,0x58), o2(0x81,0x46),
     o2(0x81,0x47), o2(0x81,0x83), o2(0x81,0x81), o2(0x81,0x84),
     o2(0x81,0x48), o2(0x81,0x97), o2(0x82,0x60), o2(0x82,0x61),
     o2(0x82,0x62), o2(0x82,0x63), o2(0x82,0x64), o2(0x82,0x65),
     o2(0x82,0x66), o2(0x82,0x67), o2(0x82,0x68), o2(0x82,0x69),
     o2(0x82,0x6A), o2(0x82,0x6B), o2(0x82,0x6C), o2(0x82,0x6D),
     o2(0x82,0x6E), o2(0x82,0x6F), o2(0x82,0x70), o2(0x82,0x71),
     o2(0x82,0x72), o2(0x82,0x73), o2(0x82,0x74), o2(0x82,0x75),
     o2(0x82,0x76), o2(0x82,0x77), o2(0x82,0x78), o2(0x82,0x79),
     o2(0x81,0x6D), o2(0x81,0x5F), o2(0x81,0x6E), o2(0x81,0x4F),
     o2(0x81,0x51),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_EF_BC = {
    to_SHIFT_JIS_EF_BC_offsets,
    to_SHIFT_JIS_EF_BC_infos
};

static const unsigned char
to_SHIFT_JIS_EF_BD_offsets[64] = {
  /* used from to_SHIFT_JIS_EF_BD */
  /* used from to_EUC_JP_EF_BD */
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,   24, 25, 26, 27, 28, 29, 61, 61,
     61, 30, 31, 32, 33, 34, 35, 36,   37, 38, 39, 40, 41, 42, 43, 44,
     45, 46, 47, 48, 49, 50, 51, 52,   53, 54, 55, 56, 57, 58, 59, 60,
};
static const struct byte_lookup* const
to_SHIFT_JIS_EF_BD_infos[62] = {
     o2(0x81,0x4D), o2(0x82,0x81), o2(0x82,0x82), o2(0x82,0x83),
     o2(0x82,0x84), o2(0x82,0x85), o2(0x82,0x86), o2(0x82,0x87),
     o2(0x82,0x88), o2(0x82,0x89), o2(0x82,0x8A), o2(0x82,0x8B),
     o2(0x82,0x8C), o2(0x82,0x8D), o2(0x82,0x8E), o2(0x82,0x8F),
     o2(0x82,0x90), o2(0x82,0x91), o2(0x82,0x92), o2(0x82,0x93),
     o2(0x82,0x94), o2(0x82,0x95), o2(0x82,0x96), o2(0x82,0x97),
     o2(0x82,0x98), o2(0x82,0x99), o2(0x82,0x9A), o2(0x81,0x6F),
     o2(0x81,0x62), o2(0x81,0x70),      o1(0xA1),      o1(0xA2),
          o1(0xA3),      o1(0xA4),      o1(0xA5),      o1(0xA6),
          o1(0xA7),      o1(0xA8),      o1(0xA9),      o1(0xAA),
          o1(0xAB),      o1(0xAC),      o1(0xAD),      o1(0xAE),
          o1(0xAF),      o1(0xB0),      o1(0xB1),      o1(0xB2),
          o1(0xB3),      o1(0xB4),      o1(0xB5),      o1(0xB6),
          o1(0xB7),      o1(0xB8),      o1(0xB9),      o1(0xBA),
          o1(0xBB),      o1(0xBC),      o1(0xBD),      o1(0xBE),
          o1(0xBF),         UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_EF_BD = {
    to_SHIFT_JIS_EF_BD_offsets,
    to_SHIFT_JIS_EF_BD_infos
};

static const unsigned char
to_SHIFT_JIS_EF_BE_offsets[64] = {
  /* used from to_SHIFT_JIS_EF_BE */
  /* used from to_EUC_JP_EF_BE */
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23,   24, 25, 26, 27, 28, 29, 30, 31,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
};
static const struct byte_lookup* const
to_SHIFT_JIS_EF_BE_infos[33] = {
     o1(0xC0), o1(0xC1), o1(0xC2), o1(0xC3),
     o1(0xC4), o1(0xC5), o1(0xC6), o1(0xC7),
     o1(0xC8), o1(0xC9), o1(0xCA), o1(0xCB),
     o1(0xCC), o1(0xCD), o1(0xCE), o1(0xCF),
     o1(0xD0), o1(0xD1), o1(0xD2), o1(0xD3),
     o1(0xD4), o1(0xD5), o1(0xD6), o1(0xD7),
     o1(0xD8), o1(0xD9), o1(0xDA), o1(0xDB),
     o1(0xDC), o1(0xDD), o1(0xDE), o1(0xDF),
        UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_EF_BE = {
    to_SHIFT_JIS_EF_BE_offsets,
    to_SHIFT_JIS_EF_BE_infos
};

static const unsigned char
to_SHIFT_JIS_EF_offsets[64] = {
  /* used from to_SHIFT_JIS_EF */
  /* used from to_EUC_JP_EF */
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  0,  6,  6,  1,    2,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  3,  4,  5,  6,
};
static const struct byte_lookup* const
to_SHIFT_JIS_EF_infos[7] = {
     &to_SHIFT_JIS_EF_A4, &to_SHIFT_JIS_EF_A7,
     &to_SHIFT_JIS_EF_A8, &to_SHIFT_JIS_EF_BC,
     &to_SHIFT_JIS_EF_BD, &to_SHIFT_JIS_EF_BE,
                   UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS_EF = {
    to_SHIFT_JIS_EF_offsets,
    to_SHIFT_JIS_EF_infos
};

static const unsigned char
to_SHIFT_JIS_offsets[256] = {
  /* used from to_SHIFT_JIS */
  /* used from to_EUC_JP */
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 16, 16, 16, 16,
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 16, 16, 16, 16,
     16, 16,  1,  2, 16, 16, 16, 16,   16, 16, 16, 16, 16, 16,  3,  4,
      5,  6, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 16, 16, 16, 16,
     16, 16,  7,  8,  9, 10, 11, 12,   13, 14, 16, 16, 16, 16, 16, 15,
     16, 16, 16, 16, 16, 16, 16, 16,   16, 16, 16, 16, 16, 16, 16, 16,
};
static const struct byte_lookup* const
to_SHIFT_JIS_infos[17] = {
                NOMAP, &to_SHIFT_JIS_C2, &to_SHIFT_JIS_C3, &to_SHIFT_JIS_CE,
     &to_SHIFT_JIS_CF, &to_SHIFT_JIS_D0, &to_SHIFT_JIS_D1, &to_SHIFT_JIS_E2,
     &to_SHIFT_JIS_E3, &to_SHIFT_JIS_E4, &to_SHIFT_JIS_E5, &to_SHIFT_JIS_E6,
     &to_SHIFT_JIS_E7, &to_SHIFT_JIS_E8, &to_SHIFT_JIS_E9, &to_SHIFT_JIS_EF,
                UNDEF,
};
static const BYTE_LOOKUP
to_SHIFT_JIS = {
    to_SHIFT_JIS_offsets,
    to_SHIFT_JIS_infos
};
static const rb_transcoder
rb_to_SHIFT_JIS = {
    "UTF-8", "SHIFT_JIS", &to_SHIFT_JIS, 2, 1,
    NULL, NULL,
};
static const rb_transcoder
rb_to_Windows_31J = {
    "UTF-8", "Windows-31J", &to_SHIFT_JIS, 2, 1,
    NULL, NULL,
};

static const unsigned char
from_EUC_JP_8E_offsets[256] = {
     63, 63, 63, 63, 63, 63, 63, 63,   63, 63, 63, 63, 63, 63, 63, 63,
     63, 63, 63, 63, 63, 63, 63, 63,   63, 63, 63, 63, 63, 63, 63, 63,
     63, 63, 63, 63, 63, 63, 63, 63,   63, 63, 63, 63, 63, 63, 63, 63,
     63, 63, 63, 63, 63, 63, 63, 63,   63, 63, 63, 63, 63, 63, 63, 63,
     63, 63, 63, 63, 63, 63, 63, 63,   63, 63, 63, 63, 63, 63, 63, 63,
     63, 63, 63, 63, 63, 63, 63, 63,   63, 63, 63, 63, 63, 63, 63, 63,
     63, 63, 63, 63, 63, 63, 63, 63,   63, 63, 63, 63, 63, 63, 63, 63,
     63, 63, 63, 63, 63, 63, 63, 63,   63, 63, 63, 63, 63, 63, 63, 63,
     63, 63, 63, 63, 63, 63, 63, 63,   63, 63, 63, 63, 63, 63, 63, 63,
     63, 63, 63, 63, 63, 63, 63, 63,   63, 63, 63, 63, 63, 63, 63, 63,
     63,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,   23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,   39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 53, 54,   55, 56, 57, 58, 59, 60, 61, 62,
     63, 63, 63, 63, 63, 63, 63, 63,   63, 63, 63, 63, 63, 63, 63, 63,
     63, 63, 63, 63, 63, 63, 63, 63,   63, 63, 63, 63, 63, 63, 63, 63,
};
static const struct byte_lookup* const
from_EUC_JP_8E_infos[64] = {
     o3(0xEF,0xBD,0xA1), o3(0xEF,0xBD,0xA2),
     o3(0xEF,0xBD,0xA3), o3(0xEF,0xBD,0xA4),
     o3(0xEF,0xBD,0xA5), o3(0xEF,0xBD,0xA6),
     o3(0xEF,0xBD,0xA7), o3(0xEF,0xBD,0xA8),
     o3(0xEF,0xBD,0xA9), o3(0xEF,0xBD,0xAA),
     o3(0xEF,0xBD,0xAB), o3(0xEF,0xBD,0xAC),
     o3(0xEF,0xBD,0xAD), o3(0xEF,0xBD,0xAE),
     o3(0xEF,0xBD,0xAF), o3(0xEF,0xBD,0xB0),
     o3(0xEF,0xBD,0xB1), o3(0xEF,0xBD,0xB2),
     o3(0xEF,0xBD,0xB3), o3(0xEF,0xBD,0xB4),
     o3(0xEF,0xBD,0xB5), o3(0xEF,0xBD,0xB6),
     o3(0xEF,0xBD,0xB7), o3(0xEF,0xBD,0xB8),
     o3(0xEF,0xBD,0xB9), o3(0xEF,0xBD,0xBA),
     o3(0xEF,0xBD,0xBB), o3(0xEF,0xBD,0xBC),
     o3(0xEF,0xBD,0xBD), o3(0xEF,0xBD,0xBE),
     o3(0xEF,0xBD,0xBF), o3(0xEF,0xBE,0x80),
     o3(0xEF,0xBE,0x81), o3(0xEF,0xBE,0x82),
     o3(0xEF,0xBE,0x83), o3(0xEF,0xBE,0x84),
     o3(0xEF,0xBE,0x85), o3(0xEF,0xBE,0x86),
     o3(0xEF,0xBE,0x87), o3(0xEF,0xBE,0x88),
     o3(0xEF,0xBE,0x89), o3(0xEF,0xBE,0x8A),
     o3(0xEF,0xBE,0x8B), o3(0xEF,0xBE,0x8C),
     o3(0xEF,0xBE,0x8D), o3(0xEF,0xBE,0x8E),
     o3(0xEF,0xBE,0x8F), o3(0xEF,0xBE,0x90),
     o3(0xEF,0xBE,0x91), o3(0xEF,0xBE,0x92),
     o3(0xEF,0xBE,0x93), o3(0xEF,0xBE,0x94),
     o3(0xEF,0xBE,0x95), o3(0xEF,0xBE,0x96),
     o3(0xEF,0xBE,0x97), o3(0xEF,0xBE,0x98),
     o3(0xEF,0xBE,0x99), o3(0xEF,0xBE,0x9A),
     o3(0xEF,0xBE,0x9B), o3(0xEF,0xBE,0x9C),
     o3(0xEF,0xBE,0x9D), o3(0xEF,0xBE,0x9E),
     o3(0xEF,0xBE,0x9F),              UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_8E = {
    from_EUC_JP_8E_offsets,
    from_EUC_JP_8E_infos
};

static const unsigned char
from_EUC_JP_A1_offsets[256] = {
  /* used from from_EUC_JP_A1 */
  /* used from from_EUC_JP_B0 */
  /* used from from_EUC_JP_B1 */
  /* used from from_EUC_JP_B2 */
  /* used from from_EUC_JP_B3 */
  /* used from from_EUC_JP_B4 */
  /* used from from_EUC_JP_B5 */
  /* used from from_EUC_JP_B6 */
  /* used from from_EUC_JP_B7 */
  /* used from from_EUC_JP_B8 */
  /* used from from_EUC_JP_B9 */
  /* used from from_EUC_JP_BA */
  /* used from from_EUC_JP_BB */
  /* used from from_EUC_JP_BC */
  /* used from from_EUC_JP_BD */
  /* used from from_EUC_JP_BE */
  /* used from from_EUC_JP_BF */
  /* used from from_EUC_JP_C0 */
  /* used from from_EUC_JP_C1 */
  /* used from from_EUC_JP_C2 */
  /* used from from_EUC_JP_C3 */
  /* used from from_EUC_JP_C4 */
  /* used from from_EUC_JP_C5 */
  /* used from from_EUC_JP_C6 */
  /* used from from_EUC_JP_C7 */
  /* used from from_EUC_JP_C8 */
  /* used from from_EUC_JP_C9 */
  /* used from from_EUC_JP_CA */
  /* used from from_EUC_JP_CB */
  /* used from from_EUC_JP_CC */
  /* used from from_EUC_JP_CD */
  /* used from from_EUC_JP_CE */
  /* used from from_EUC_JP_D0 */
  /* used from from_EUC_JP_D1 */
  /* used from from_EUC_JP_D2 */
  /* used from from_EUC_JP_D3 */
  /* used from from_EUC_JP_D4 */
  /* used from from_EUC_JP_D5 */
  /* used from from_EUC_JP_D6 */
  /* used from from_EUC_JP_D7 */
  /* used from from_EUC_JP_D8 */
  /* used from from_EUC_JP_D9 */
  /* used from from_EUC_JP_DA */
  /* used from from_EUC_JP_DB */
  /* used from from_EUC_JP_DC */
  /* used from from_EUC_JP_DD */
  /* used from from_EUC_JP_DE */
  /* used from from_EUC_JP_DF */
  /* used from from_EUC_JP_E0 */
  /* used from from_EUC_JP_E1 */
  /* used from from_EUC_JP_E2 */
  /* used from from_EUC_JP_E3 */
  /* used from from_EUC_JP_E4 */
  /* used from from_EUC_JP_E5 */
  /* used from from_EUC_JP_E6 */
  /* used from from_EUC_JP_E7 */
  /* used from from_EUC_JP_E8 */
  /* used from from_EUC_JP_E9 */
  /* used from from_EUC_JP_EA */
  /* used from from_EUC_JP_EB */
  /* used from from_EUC_JP_EC */
  /* used from from_EUC_JP_ED */
  /* used from from_EUC_JP_EE */
  /* used from from_EUC_JP_EF */
  /* used from from_EUC_JP_F0 */
  /* used from from_EUC_JP_F1 */
  /* used from from_EUC_JP_F2 */
  /* used from from_EUC_JP_F3 */
  /* used from from_EUC_JP_F9 */
  /* used from from_EUC_JP_FA */
  /* used from from_EUC_JP_FB */
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94, 94, 94, 94, 94, 94, 94, 94,   94, 94, 94, 94, 94, 94, 94, 94,
     94,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,   23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,   39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 53, 54,   55, 56, 57, 58, 59, 60, 61, 62,
     63, 64, 65, 66, 67, 68, 69, 70,   71, 72, 73, 74, 75, 76, 77, 78,
     79, 80, 81, 82, 83, 84, 85, 86,   87, 88, 89, 90, 91, 92, 93, 94,
};
static const struct byte_lookup* const
from_EUC_JP_A1_infos[95] = {
     o3(0xE3,0x80,0x80), o3(0xE3,0x80,0x81),
     o3(0xE3,0x80,0x82), o3(0xEF,0xBC,0x8C),
     o3(0xEF,0xBC,0x8E), o3(0xE3,0x83,0xBB),
     o3(0xEF,0xBC,0x9A), o3(0xEF,0xBC,0x9B),
     o3(0xEF,0xBC,0x9F), o3(0xEF,0xBC,0x81),
     o3(0xE3,0x82,0x9B), o3(0xE3,0x82,0x9C),
          o2(0xC2,0xB4), o3(0xEF,0xBD,0x80),
          o2(0xC2,0xA8), o3(0xEF,0xBC,0xBE),
     o3(0xEF,0xBF,0xA3), o3(0xEF,0xBC,0xBF),
     o3(0xE3,0x83,0xBD), o3(0xE3,0x83,0xBE),
     o3(0xE3,0x82,0x9D), o3(0xE3,0x82,0x9E),
     o3(0xE3,0x80,0x83), o3(0xE4,0xBB,0x9D),
     o3(0xE3,0x80,0x85), o3(0xE3,0x80,0x86),
     o3(0xE3,0x80,0x87), o3(0xE3,0x83,0xBC),
     o3(0xE2,0x80,0x95), o3(0xE2,0x80,0x90),
     o3(0xEF,0xBC,0x8F), o3(0xEF,0xBC,0xBC),
     o3(0xEF,0xBD,0x9E), o3(0xE2,0x88,0xA5),
     o3(0xEF,0xBD,0x9C), o3(0xE2,0x80,0xA6),
     o3(0xE2,0x80,0xA5), o3(0xE2,0x80,0x98),
     o3(0xE2,0x80,0x99), o3(0xE2,0x80,0x9C),
     o3(0xE2,0x80,0x9D), o3(0xEF,0xBC,0x88),
     o3(0xEF,0xBC,0x89), o3(0xE3,0x80,0x94),
     o3(0xE3,0x80,0x95), o3(0xEF,0xBC,0xBB),
     o3(0xEF,0xBC,0xBD), o3(0xEF,0xBD,0x9B),
     o3(0xEF,0xBD,0x9D), o3(0xE3,0x80,0x88),
     o3(0xE3,0x80,0x89), o3(0xE3,0x80,0x8A),
     o3(0xE3,0x80,0x8B), o3(0xE3,0x80,0x8C),
     o3(0xE3,0x80,0x8D), o3(0xE3,0x80,0x8E),
     o3(0xE3,0x80,0x8F), o3(0xE3,0x80,0x90),
     o3(0xE3,0x80,0x91), o3(0xEF,0xBC,0x8B),
     o3(0xEF,0xBC,0x8D),      o2(0xC2,0xB1),
          o2(0xC3,0x97),      o2(0xC3,0xB7),
     o3(0xEF,0xBC,0x9D), o3(0xE2,0x89,0xA0),
     o3(0xEF,0xBC,0x9C), o3(0xEF,0xBC,0x9E),
     o3(0xE2,0x89,0xA6), o3(0xE2,0x89,0xA7),
     o3(0xE2,0x88,0x9E), o3(0xE2,0x88,0xB4),
     o3(0xE2,0x99,0x82), o3(0xE2,0x99,0x80),
          o2(0xC2,0xB0), o3(0xE2,0x80,0xB2),
     o3(0xE2,0x80,0xB3), o3(0xE2,0x84,0x83),
     o3(0xEF,0xBF,0xA5), o3(0xEF,0xBC,0x84),
     o3(0xEF,0xBF,0xA0), o3(0xEF,0xBF,0xA1),
     o3(0xEF,0xBC,0x85), o3(0xEF,0xBC,0x83),
     o3(0xEF,0xBC,0x86), o3(0xEF,0xBC,0x8A),
     o3(0xEF,0xBC,0xA0),      o2(0xC2,0xA7),
     o3(0xE2,0x98,0x86), o3(0xE2,0x98,0x85),
     o3(0xE2,0x97,0x8B), o3(0xE2,0x97,0x8F),
     o3(0xE2,0x97,0x8E), o3(0xE2,0x97,0x87),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_A1 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_A1_infos
};

static const unsigned char
from_EUC_JP_A2_offsets[256] = {
     53, 53, 53, 53, 53, 53, 53, 53,   53, 53, 53, 53, 53, 53, 53, 53,
     53, 53, 53, 53, 53, 53, 53, 53,   53, 53, 53, 53, 53, 53, 53, 53,
     53, 53, 53, 53, 53, 53, 53, 53,   53, 53, 53, 53, 53, 53, 53, 53,
     53, 53, 53, 53, 53, 53, 53, 53,   53, 53, 53, 53, 53, 53, 53, 53,
     53, 53, 53, 53, 53, 53, 53, 53,   53, 53, 53, 53, 53, 53, 53, 53,
     53, 53, 53, 53, 53, 53, 53, 53,   53, 53, 53, 53, 53, 53, 53, 53,
     53, 53, 53, 53, 53, 53, 53, 53,   53, 53, 53, 53, 53, 53, 53, 53,
     53, 53, 53, 53, 53, 53, 53, 53,   53, 53, 53, 53, 53, 53, 53, 53,
     53, 53, 53, 53, 53, 53, 53, 53,   53, 53, 53, 53, 53, 53, 53, 53,
     53, 53, 53, 53, 53, 53, 53, 53,   53, 53, 53, 53, 53, 53, 53, 53,
     53,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 53,
     53, 53, 53, 53, 53, 53, 53, 53,   53, 53, 14, 15, 16, 17, 18, 19,
     20, 21, 53, 53, 53, 53, 53, 53,   53, 53, 22, 23, 24, 25, 26, 27,
     28, 53, 53, 53, 53, 53, 53, 53,   53, 53, 53, 53, 29, 30, 31, 32,
     33, 34, 35, 36, 37, 38, 39, 40,   41, 42, 43, 53, 53, 53, 53, 53,
     53, 53, 44, 45, 46, 47, 48, 49,   50, 51, 53, 53, 53, 53, 52, 53,
};
static const struct byte_lookup* const
from_EUC_JP_A2_infos[54] = {
     o3(0xE2,0x97,0x86), o3(0xE2,0x96,0xA1),
     o3(0xE2,0x96,0xA0), o3(0xE2,0x96,0xB3),
     o3(0xE2,0x96,0xB2), o3(0xE2,0x96,0xBD),
     o3(0xE2,0x96,0xBC), o3(0xE2,0x80,0xBB),
     o3(0xE3,0x80,0x92), o3(0xE2,0x86,0x92),
     o3(0xE2,0x86,0x90), o3(0xE2,0x86,0x91),
     o3(0xE2,0x86,0x93), o3(0xE3,0x80,0x93),
     o3(0xE2,0x88,0x88), o3(0xE2,0x88,0x8B),
     o3(0xE2,0x8A,0x86), o3(0xE2,0x8A,0x87),
     o3(0xE2,0x8A,0x82), o3(0xE2,0x8A,0x83),
     o3(0xE2,0x88,0xAA), o3(0xE2,0x88,0xA9),
     o3(0xE2,0x88,0xA7), o3(0xE2,0x88,0xA8),
     o3(0xEF,0xBF,0xA2), o3(0xE2,0x87,0x92),
     o3(0xE2,0x87,0x94), o3(0xE2,0x88,0x80),
     o3(0xE2,0x88,0x83), o3(0xE2,0x88,0xA0),
     o3(0xE2,0x8A,0xA5), o3(0xE2,0x8C,0x92),
     o3(0xE2,0x88,0x82), o3(0xE2,0x88,0x87),
     o3(0xE2,0x89,0xA1), o3(0xE2,0x89,0x92),
     o3(0xE2,0x89,0xAA), o3(0xE2,0x89,0xAB),
     o3(0xE2,0x88,0x9A), o3(0xE2,0x88,0xBD),
     o3(0xE2,0x88,0x9D), o3(0xE2,0x88,0xB5),
     o3(0xE2,0x88,0xAB), o3(0xE2,0x88,0xAC),
     o3(0xE2,0x84,0xAB), o3(0xE2,0x80,0xB0),
     o3(0xE2,0x99,0xAF), o3(0xE2,0x99,0xAD),
     o3(0xE2,0x99,0xAA), o3(0xE2,0x80,0xA0),
     o3(0xE2,0x80,0xA1),      o2(0xC2,0xB6),
     o3(0xE2,0x97,0xAF),              UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_A2 = {
    from_EUC_JP_A2_offsets,
    from_EUC_JP_A2_infos
};

static const unsigned char
from_EUC_JP_A3_offsets[256] = {
     62, 62, 62, 62, 62, 62, 62, 62,   62, 62, 62, 62, 62, 62, 62, 62,
     62, 62, 62, 62, 62, 62, 62, 62,   62, 62, 62, 62, 62, 62, 62, 62,
     62, 62, 62, 62, 62, 62, 62, 62,   62, 62, 62, 62, 62, 62, 62, 62,
     62, 62, 62, 62, 62, 62, 62, 62,   62, 62, 62, 62, 62, 62, 62, 62,
     62, 62, 62, 62, 62, 62, 62, 62,   62, 62, 62, 62, 62, 62, 62, 62,
     62, 62, 62, 62, 62, 62, 62, 62,   62, 62, 62, 62, 62, 62, 62, 62,
     62, 62, 62, 62, 62, 62, 62, 62,   62, 62, 62, 62, 62, 62, 62, 62,
     62, 62, 62, 62, 62, 62, 62, 62,   62, 62, 62, 62, 62, 62, 62, 62,
     62, 62, 62, 62, 62, 62, 62, 62,   62, 62, 62, 62, 62, 62, 62, 62,
     62, 62, 62, 62, 62, 62, 62, 62,   62, 62, 62, 62, 62, 62, 62, 62,
     62, 62, 62, 62, 62, 62, 62, 62,   62, 62, 62, 62, 62, 62, 62, 62,
      0,  1,  2,  3,  4,  5,  6,  7,    8,  9, 62, 62, 62, 62, 62, 62,
     62, 10, 11, 12, 13, 14, 15, 16,   17, 18, 19, 20, 21, 22, 23, 24,
     25, 26, 27, 28, 29, 30, 31, 32,   33, 34, 35, 62, 62, 62, 62, 62,
     62, 36, 37, 38, 39, 40, 41, 42,   43, 44, 45, 46, 47, 48, 49, 50,
     51, 52, 53, 54, 55, 56, 57, 58,   59, 60, 61, 62, 62, 62, 62, 62,
};
static const struct byte_lookup* const
from_EUC_JP_A3_infos[63] = {
     o3(0xEF,0xBC,0x90), o3(0xEF,0xBC,0x91),
     o3(0xEF,0xBC,0x92), o3(0xEF,0xBC,0x93),
     o3(0xEF,0xBC,0x94), o3(0xEF,0xBC,0x95),
     o3(0xEF,0xBC,0x96), o3(0xEF,0xBC,0x97),
     o3(0xEF,0xBC,0x98), o3(0xEF,0xBC,0x99),
     o3(0xEF,0xBC,0xA1), o3(0xEF,0xBC,0xA2),
     o3(0xEF,0xBC,0xA3), o3(0xEF,0xBC,0xA4),
     o3(0xEF,0xBC,0xA5), o3(0xEF,0xBC,0xA6),
     o3(0xEF,0xBC,0xA7), o3(0xEF,0xBC,0xA8),
     o3(0xEF,0xBC,0xA9), o3(0xEF,0xBC,0xAA),
     o3(0xEF,0xBC,0xAB), o3(0xEF,0xBC,0xAC),
     o3(0xEF,0xBC,0xAD), o3(0xEF,0xBC,0xAE),
     o3(0xEF,0xBC,0xAF), o3(0xEF,0xBC,0xB0),
     o3(0xEF,0xBC,0xB1), o3(0xEF,0xBC,0xB2),
     o3(0xEF,0xBC,0xB3), o3(0xEF,0xBC,0xB4),
     o3(0xEF,0xBC,0xB5), o3(0xEF,0xBC,0xB6),
     o3(0xEF,0xBC,0xB7), o3(0xEF,0xBC,0xB8),
     o3(0xEF,0xBC,0xB9), o3(0xEF,0xBC,0xBA),
     o3(0xEF,0xBD,0x81), o3(0xEF,0xBD,0x82),
     o3(0xEF,0xBD,0x83), o3(0xEF,0xBD,0x84),
     o3(0xEF,0xBD,0x85), o3(0xEF,0xBD,0x86),
     o3(0xEF,0xBD,0x87), o3(0xEF,0xBD,0x88),
     o3(0xEF,0xBD,0x89), o3(0xEF,0xBD,0x8A),
     o3(0xEF,0xBD,0x8B), o3(0xEF,0xBD,0x8C),
     o3(0xEF,0xBD,0x8D), o3(0xEF,0xBD,0x8E),
     o3(0xEF,0xBD,0x8F), o3(0xEF,0xBD,0x90),
     o3(0xEF,0xBD,0x91), o3(0xEF,0xBD,0x92),
     o3(0xEF,0xBD,0x93), o3(0xEF,0xBD,0x94),
     o3(0xEF,0xBD,0x95), o3(0xEF,0xBD,0x96),
     o3(0xEF,0xBD,0x97), o3(0xEF,0xBD,0x98),
     o3(0xEF,0xBD,0x99), o3(0xEF,0xBD,0x9A),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_A3 = {
    from_EUC_JP_A3_offsets,
    from_EUC_JP_A3_infos
};

static const unsigned char
from_EUC_JP_A4_offsets[256] = {
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,   23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,   39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 53, 54,   55, 56, 57, 58, 59, 60, 61, 62,
     63, 64, 65, 66, 67, 68, 69, 70,   71, 72, 73, 74, 75, 76, 77, 78,
     79, 80, 81, 82, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
};
static const struct byte_lookup* const
from_EUC_JP_A4_infos[84] = {
     o3(0xE3,0x81,0x81), o3(0xE3,0x81,0x82),
     o3(0xE3,0x81,0x83), o3(0xE3,0x81,0x84),
     o3(0xE3,0x81,0x85), o3(0xE3,0x81,0x86),
     o3(0xE3,0x81,0x87), o3(0xE3,0x81,0x88),
     o3(0xE3,0x81,0x89), o3(0xE3,0x81,0x8A),
     o3(0xE3,0x81,0x8B), o3(0xE3,0x81,0x8C),
     o3(0xE3,0x81,0x8D), o3(0xE3,0x81,0x8E),
     o3(0xE3,0x81,0x8F), o3(0xE3,0x81,0x90),
     o3(0xE3,0x81,0x91), o3(0xE3,0x81,0x92),
     o3(0xE3,0x81,0x93), o3(0xE3,0x81,0x94),
     o3(0xE3,0x81,0x95), o3(0xE3,0x81,0x96),
     o3(0xE3,0x81,0x97), o3(0xE3,0x81,0x98),
     o3(0xE3,0x81,0x99), o3(0xE3,0x81,0x9A),
     o3(0xE3,0x81,0x9B), o3(0xE3,0x81,0x9C),
     o3(0xE3,0x81,0x9D), o3(0xE3,0x81,0x9E),
     o3(0xE3,0x81,0x9F), o3(0xE3,0x81,0xA0),
     o3(0xE3,0x81,0xA1), o3(0xE3,0x81,0xA2),
     o3(0xE3,0x81,0xA3), o3(0xE3,0x81,0xA4),
     o3(0xE3,0x81,0xA5), o3(0xE3,0x81,0xA6),
     o3(0xE3,0x81,0xA7), o3(0xE3,0x81,0xA8),
     o3(0xE3,0x81,0xA9), o3(0xE3,0x81,0xAA),
     o3(0xE3,0x81,0xAB), o3(0xE3,0x81,0xAC),
     o3(0xE3,0x81,0xAD), o3(0xE3,0x81,0xAE),
     o3(0xE3,0x81,0xAF), o3(0xE3,0x81,0xB0),
     o3(0xE3,0x81,0xB1), o3(0xE3,0x81,0xB2),
     o3(0xE3,0x81,0xB3), o3(0xE3,0x81,0xB4),
     o3(0xE3,0x81,0xB5), o3(0xE3,0x81,0xB6),
     o3(0xE3,0x81,0xB7), o3(0xE3,0x81,0xB8),
     o3(0xE3,0x81,0xB9), o3(0xE3,0x81,0xBA),
     o3(0xE3,0x81,0xBB), o3(0xE3,0x81,0xBC),
     o3(0xE3,0x81,0xBD), o3(0xE3,0x81,0xBE),
     o3(0xE3,0x81,0xBF), o3(0xE3,0x82,0x80),
     o3(0xE3,0x82,0x81), o3(0xE3,0x82,0x82),
     o3(0xE3,0x82,0x83), o3(0xE3,0x82,0x84),
     o3(0xE3,0x82,0x85), o3(0xE3,0x82,0x86),
     o3(0xE3,0x82,0x87), o3(0xE3,0x82,0x88),
     o3(0xE3,0x82,0x89), o3(0xE3,0x82,0x8A),
     o3(0xE3,0x82,0x8B), o3(0xE3,0x82,0x8C),
     o3(0xE3,0x82,0x8D), o3(0xE3,0x82,0x8E),
     o3(0xE3,0x82,0x8F), o3(0xE3,0x82,0x90),
     o3(0xE3,0x82,0x91), o3(0xE3,0x82,0x92),
     o3(0xE3,0x82,0x93),              UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_A4 = {
    from_EUC_JP_A4_offsets,
    from_EUC_JP_A4_infos
};

static const unsigned char
from_EUC_JP_A5_offsets[256] = {
     86, 86, 86, 86, 86, 86, 86, 86,   86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,   86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,   86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,   86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,   86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,   86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,   86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,   86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,   86, 86, 86, 86, 86, 86, 86, 86,
     86, 86, 86, 86, 86, 86, 86, 86,   86, 86, 86, 86, 86, 86, 86, 86,
     86,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,   23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,   39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 53, 54,   55, 56, 57, 58, 59, 60, 61, 62,
     63, 64, 65, 66, 67, 68, 69, 70,   71, 72, 73, 74, 75, 76, 77, 78,
     79, 80, 81, 82, 83, 84, 85, 86,   86, 86, 86, 86, 86, 86, 86, 86,
};
static const struct byte_lookup* const
from_EUC_JP_A5_infos[87] = {
     o3(0xE3,0x82,0xA1), o3(0xE3,0x82,0xA2),
     o3(0xE3,0x82,0xA3), o3(0xE3,0x82,0xA4),
     o3(0xE3,0x82,0xA5), o3(0xE3,0x82,0xA6),
     o3(0xE3,0x82,0xA7), o3(0xE3,0x82,0xA8),
     o3(0xE3,0x82,0xA9), o3(0xE3,0x82,0xAA),
     o3(0xE3,0x82,0xAB), o3(0xE3,0x82,0xAC),
     o3(0xE3,0x82,0xAD), o3(0xE3,0x82,0xAE),
     o3(0xE3,0x82,0xAF), o3(0xE3,0x82,0xB0),
     o3(0xE3,0x82,0xB1), o3(0xE3,0x82,0xB2),
     o3(0xE3,0x82,0xB3), o3(0xE3,0x82,0xB4),
     o3(0xE3,0x82,0xB5), o3(0xE3,0x82,0xB6),
     o3(0xE3,0x82,0xB7), o3(0xE3,0x82,0xB8),
     o3(0xE3,0x82,0xB9), o3(0xE3,0x82,0xBA),
     o3(0xE3,0x82,0xBB), o3(0xE3,0x82,0xBC),
     o3(0xE3,0x82,0xBD), o3(0xE3,0x82,0xBE),
     o3(0xE3,0x82,0xBF), o3(0xE3,0x83,0x80),
     o3(0xE3,0x83,0x81), o3(0xE3,0x83,0x82),
     o3(0xE3,0x83,0x83), o3(0xE3,0x83,0x84),
     o3(0xE3,0x83,0x85), o3(0xE3,0x83,0x86),
     o3(0xE3,0x83,0x87), o3(0xE3,0x83,0x88),
     o3(0xE3,0x83,0x89), o3(0xE3,0x83,0x8A),
     o3(0xE3,0x83,0x8B), o3(0xE3,0x83,0x8C),
     o3(0xE3,0x83,0x8D), o3(0xE3,0x83,0x8E),
     o3(0xE3,0x83,0x8F), o3(0xE3,0x83,0x90),
     o3(0xE3,0x83,0x91), o3(0xE3,0x83,0x92),
     o3(0xE3,0x83,0x93), o3(0xE3,0x83,0x94),
     o3(0xE3,0x83,0x95), o3(0xE3,0x83,0x96),
     o3(0xE3,0x83,0x97), o3(0xE3,0x83,0x98),
     o3(0xE3,0x83,0x99), o3(0xE3,0x83,0x9A),
     o3(0xE3,0x83,0x9B), o3(0xE3,0x83,0x9C),
     o3(0xE3,0x83,0x9D), o3(0xE3,0x83,0x9E),
     o3(0xE3,0x83,0x9F), o3(0xE3,0x83,0xA0),
     o3(0xE3,0x83,0xA1), o3(0xE3,0x83,0xA2),
     o3(0xE3,0x83,0xA3), o3(0xE3,0x83,0xA4),
     o3(0xE3,0x83,0xA5), o3(0xE3,0x83,0xA6),
     o3(0xE3,0x83,0xA7), o3(0xE3,0x83,0xA8),
     o3(0xE3,0x83,0xA9), o3(0xE3,0x83,0xAA),
     o3(0xE3,0x83,0xAB), o3(0xE3,0x83,0xAC),
     o3(0xE3,0x83,0xAD), o3(0xE3,0x83,0xAE),
     o3(0xE3,0x83,0xAF), o3(0xE3,0x83,0xB0),
     o3(0xE3,0x83,0xB1), o3(0xE3,0x83,0xB2),
     o3(0xE3,0x83,0xB3), o3(0xE3,0x83,0xB4),
     o3(0xE3,0x83,0xB5), o3(0xE3,0x83,0xB6),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_A5 = {
    from_EUC_JP_A5_offsets,
    from_EUC_JP_A5_infos
};

static const unsigned char
from_EUC_JP_A6_offsets[256] = {
     48, 48, 48, 48, 48, 48, 48, 48,   48, 48, 48, 48, 48, 48, 48, 48,
     48, 48, 48, 48, 48, 48, 48, 48,   48, 48, 48, 48, 48, 48, 48, 48,
     48, 48, 48, 48, 48, 48, 48, 48,   48, 48, 48, 48, 48, 48, 48, 48,
     48, 48, 48, 48, 48, 48, 48, 48,   48, 48, 48, 48, 48, 48, 48, 48,
     48, 48, 48, 48, 48, 48, 48, 48,   48, 48, 48, 48, 48, 48, 48, 48,
     48, 48, 48, 48, 48, 48, 48, 48,   48, 48, 48, 48, 48, 48, 48, 48,
     48, 48, 48, 48, 48, 48, 48, 48,   48, 48, 48, 48, 48, 48, 48, 48,
     48, 48, 48, 48, 48, 48, 48, 48,   48, 48, 48, 48, 48, 48, 48, 48,
     48, 48, 48, 48, 48, 48, 48, 48,   48, 48, 48, 48, 48, 48, 48, 48,
     48, 48, 48, 48, 48, 48, 48, 48,   48, 48, 48, 48, 48, 48, 48, 48,
     48,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,   23, 48, 48, 48, 48, 48, 48, 48,
     48, 24, 25, 26, 27, 28, 29, 30,   31, 32, 33, 34, 35, 36, 37, 38,
     39, 40, 41, 42, 43, 44, 45, 46,   47, 48, 48, 48, 48, 48, 48, 48,
     48, 48, 48, 48, 48, 48, 48, 48,   48, 48, 48, 48, 48, 48, 48, 48,
     48, 48, 48, 48, 48, 48, 48, 48,   48, 48, 48, 48, 48, 48, 48, 48,
};
static const struct byte_lookup* const
from_EUC_JP_A6_infos[49] = {
     o2(0xCE,0x91), o2(0xCE,0x92), o2(0xCE,0x93), o2(0xCE,0x94),
     o2(0xCE,0x95), o2(0xCE,0x96), o2(0xCE,0x97), o2(0xCE,0x98),
     o2(0xCE,0x99), o2(0xCE,0x9A), o2(0xCE,0x9B), o2(0xCE,0x9C),
     o2(0xCE,0x9D), o2(0xCE,0x9E), o2(0xCE,0x9F), o2(0xCE,0xA0),
     o2(0xCE,0xA1), o2(0xCE,0xA3), o2(0xCE,0xA4), o2(0xCE,0xA5),
     o2(0xCE,0xA6), o2(0xCE,0xA7), o2(0xCE,0xA8), o2(0xCE,0xA9),
     o2(0xCE,0xB1), o2(0xCE,0xB2), o2(0xCE,0xB3), o2(0xCE,0xB4),
     o2(0xCE,0xB5), o2(0xCE,0xB6), o2(0xCE,0xB7), o2(0xCE,0xB8),
     o2(0xCE,0xB9), o2(0xCE,0xBA), o2(0xCE,0xBB), o2(0xCE,0xBC),
     o2(0xCE,0xBD), o2(0xCE,0xBE), o2(0xCE,0xBF), o2(0xCF,0x80),
     o2(0xCF,0x81), o2(0xCF,0x83), o2(0xCF,0x84), o2(0xCF,0x85),
     o2(0xCF,0x86), o2(0xCF,0x87), o2(0xCF,0x88), o2(0xCF,0x89),
             UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_A6 = {
    from_EUC_JP_A6_offsets,
    from_EUC_JP_A6_infos
};

static const unsigned char
from_EUC_JP_A7_offsets[256] = {
     66, 66, 66, 66, 66, 66, 66, 66,   66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,   66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,   66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,   66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,   66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,   66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,   66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,   66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,   66, 66, 66, 66, 66, 66, 66, 66,
     66, 66, 66, 66, 66, 66, 66, 66,   66, 66, 66, 66, 66, 66, 66, 66,
     66,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,   23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 66, 66, 66, 66, 66, 66,   66, 66, 66, 66, 66, 66, 66, 66,
     66, 33, 34, 35, 36, 37, 38, 39,   40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55,   56, 57, 58, 59, 60, 61, 62, 63,
     64, 65, 66, 66, 66, 66, 66, 66,   66, 66, 66, 66, 66, 66, 66, 66,
};
static const struct byte_lookup* const
from_EUC_JP_A7_infos[67] = {
     o2(0xD0,0x90), o2(0xD0,0x91), o2(0xD0,0x92), o2(0xD0,0x93),
     o2(0xD0,0x94), o2(0xD0,0x95), o2(0xD0,0x81), o2(0xD0,0x96),
     o2(0xD0,0x97), o2(0xD0,0x98), o2(0xD0,0x99), o2(0xD0,0x9A),
     o2(0xD0,0x9B), o2(0xD0,0x9C), o2(0xD0,0x9D), o2(0xD0,0x9E),
     o2(0xD0,0x9F), o2(0xD0,0xA0), o2(0xD0,0xA1), o2(0xD0,0xA2),
     o2(0xD0,0xA3), o2(0xD0,0xA4), o2(0xD0,0xA5), o2(0xD0,0xA6),
     o2(0xD0,0xA7), o2(0xD0,0xA8), o2(0xD0,0xA9), o2(0xD0,0xAA),
     o2(0xD0,0xAB), o2(0xD0,0xAC), o2(0xD0,0xAD), o2(0xD0,0xAE),
     o2(0xD0,0xAF), o2(0xD0,0xB0), o2(0xD0,0xB1), o2(0xD0,0xB2),
     o2(0xD0,0xB3), o2(0xD0,0xB4), o2(0xD0,0xB5), o2(0xD1,0x91),
     o2(0xD0,0xB6), o2(0xD0,0xB7), o2(0xD0,0xB8), o2(0xD0,0xB9),
     o2(0xD0,0xBA), o2(0xD0,0xBB), o2(0xD0,0xBC), o2(0xD0,0xBD),
     o2(0xD0,0xBE), o2(0xD0,0xBF), o2(0xD1,0x80), o2(0xD1,0x81),
     o2(0xD1,0x82), o2(0xD1,0x83), o2(0xD1,0x84), o2(0xD1,0x85),
     o2(0xD1,0x86), o2(0xD1,0x87), o2(0xD1,0x88), o2(0xD1,0x89),
     o2(0xD1,0x8A), o2(0xD1,0x8B), o2(0xD1,0x8C), o2(0xD1,0x8D),
     o2(0xD1,0x8E), o2(0xD1,0x8F),         UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_A7 = {
    from_EUC_JP_A7_offsets,
    from_EUC_JP_A7_infos
};

static const unsigned char
from_EUC_JP_A8_offsets[256] = {
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,   23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
     32, 32, 32, 32, 32, 32, 32, 32,   32, 32, 32, 32, 32, 32, 32, 32,
};
static const struct byte_lookup* const
from_EUC_JP_A8_infos[33] = {
     o3(0xE2,0x94,0x80), o3(0xE2,0x94,0x82),
     o3(0xE2,0x94,0x8C), o3(0xE2,0x94,0x90),
     o3(0xE2,0x94,0x98), o3(0xE2,0x94,0x94),
     o3(0xE2,0x94,0x9C), o3(0xE2,0x94,0xAC),
     o3(0xE2,0x94,0xA4), o3(0xE2,0x94,0xB4),
     o3(0xE2,0x94,0xBC), o3(0xE2,0x94,0x81),
     o3(0xE2,0x94,0x83), o3(0xE2,0x94,0x8F),
     o3(0xE2,0x94,0x93), o3(0xE2,0x94,0x9B),
     o3(0xE2,0x94,0x97), o3(0xE2,0x94,0xA3),
     o3(0xE2,0x94,0xB3), o3(0xE2,0x94,0xAB),
     o3(0xE2,0x94,0xBB), o3(0xE2,0x95,0x8B),
     o3(0xE2,0x94,0xA0), o3(0xE2,0x94,0xAF),
     o3(0xE2,0x94,0xA8), o3(0xE2,0x94,0xB7),
     o3(0xE2,0x94,0xBF), o3(0xE2,0x94,0x9D),
     o3(0xE2,0x94,0xB0), o3(0xE2,0x94,0xA5),
     o3(0xE2,0x94,0xB8), o3(0xE2,0x95,0x82),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_A8 = {
    from_EUC_JP_A8_offsets,
    from_EUC_JP_A8_infos
};

static const unsigned char
from_EUC_JP_AD_offsets[256] = {
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83, 83, 83, 83, 83, 83, 83, 83,   83, 83, 83, 83, 83, 83, 83, 83,
     83,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,   23, 24, 25, 26, 27, 28, 29, 83,
     30, 31, 32, 33, 34, 35, 36, 37,   38, 39, 40, 41, 42, 43, 44, 45,
     46, 47, 48, 49, 50, 51, 52, 83,   83, 83, 83, 83, 83, 83, 83, 53,
     54, 55, 56, 57, 58, 59, 60, 61,   62, 63, 64, 65, 66, 67, 68, 69,
     70, 71, 72, 73, 74, 75, 76, 77,   78, 79, 80, 81, 82, 83, 83, 83,
};
static const BYTE_LOOKUP
from_EUC_JP_AD = {
    from_EUC_JP_AD_offsets,
    from_SHIFT_JIS_87_infos
};

static const BYTE_LOOKUP
from_EUC_JP_B0 = {
    from_EUC_JP_A1_offsets,
    from_SHIFT_JIS_88_infos
};

static const struct byte_lookup* const
from_EUC_JP_B1_infos[95] = {
     o3(0xE9,0x99,0xA2), o3(0xE9,0x99,0xB0),
     o3(0xE9,0x9A,0xA0), o3(0xE9,0x9F,0xBB),
     o3(0xE5,0x90,0x8B), o3(0xE5,0x8F,0xB3),
     o3(0xE5,0xAE,0x87), o3(0xE7,0x83,0x8F),
     o3(0xE7,0xBE,0xBD), o3(0xE8,0xBF,0x82),
     o3(0xE9,0x9B,0xA8), o3(0xE5,0x8D,0xAF),
     o3(0xE9,0xB5,0x9C), o3(0xE7,0xAA,0xBA),
     o3(0xE4,0xB8,0x91), o3(0xE7,0xA2,0x93),
     o3(0xE8,0x87,0xBC), o3(0xE6,0xB8,0xA6),
     o3(0xE5,0x98,0x98), o3(0xE5,0x94,0x84),
     o3(0xE6,0xAC,0x9D), o3(0xE8,0x94,0x9A),
     o3(0xE9,0xB0,0xBB), o3(0xE5,0xA7,0xA5),
     o3(0xE5,0x8E,0xA9), o3(0xE6,0xB5,0xA6),
     o3(0xE7,0x93,0x9C), o3(0xE9,0x96,0x8F),
     o3(0xE5,0x99,0x82), o3(0xE4,0xBA,0x91),
     o3(0xE9,0x81,0x8B), o3(0xE9,0x9B,0xB2),
     o3(0xE8,0x8D,0x8F), o3(0xE9,0xA4,0x8C),
     o3(0xE5,0x8F,0xA1), o3(0xE5,0x96,0xB6),
     o3(0xE5,0xAC,0xB0), o3(0xE5,0xBD,0xB1),
     o3(0xE6,0x98,0xA0), o3(0xE6,0x9B,0xB3),
     o3(0xE6,0xA0,0x84), o3(0xE6,0xB0,0xB8),
     o3(0xE6,0xB3,0xB3), o3(0xE6,0xB4,0xA9),
     o3(0xE7,0x91,0x9B), o3(0xE7,0x9B,0x88),
     o3(0xE7,0xA9,0x8E), o3(0xE9,0xA0,0xB4),
     o3(0xE8,0x8B,0xB1), o3(0xE8,0xA1,0x9B),
     o3(0xE8,0xA9,0xA0), o3(0xE9,0x8B,0xAD),
     o3(0xE6,0xB6,0xB2), o3(0xE7,0x96,0xAB),
     o3(0xE7,0x9B,0x8A), o3(0xE9,0xA7,0x85),
     o3(0xE6,0x82,0xA6), o3(0xE8,0xAC,0x81),
     o3(0xE8,0xB6,0x8A), o3(0xE9,0x96,0xB2),
     o3(0xE6,0xA6,0x8E), o3(0xE5,0x8E,0xAD),
     o3(0xE5,0x86,0x86), o3(0xE5,0x9C,0x92),
     o3(0xE5,0xA0,0xB0), o3(0xE5,0xA5,0x84),
     o3(0xE5,0xAE,0xB4), o3(0xE5,0xBB,0xB6),
     o3(0xE6,0x80,0xA8), o3(0xE6,0x8E,0xA9),
     o3(0xE6,0x8F,0xB4), o3(0xE6,0xB2,0xBF),
     o3(0xE6,0xBC,0x94), o3(0xE7,0x82,0x8E),
     o3(0xE7,0x84,0x94), o3(0xE7,0x85,0x99),
     o3(0xE7,0x87,0x95), o3(0xE7,0x8C,0xBF),
     o3(0xE7,0xB8,0x81), o3(0xE8,0x89,0xB6),
     o3(0xE8,0x8B,0x91), o3(0xE8,0x96,0x97),
     o3(0xE9,0x81,0xA0), o3(0xE9,0x89,0x9B),
     o3(0xE9,0xB4,0x9B), o3(0xE5,0xA1,0xA9),
     o3(0xE6,0x96,0xBC), o3(0xE6,0xB1,0x9A),
     o3(0xE7,0x94,0xA5), o3(0xE5,0x87,0xB9),
     o3(0xE5,0xA4,0xAE), o3(0xE5,0xA5,0xA5),
     o3(0xE5,0xBE,0x80), o3(0xE5,0xBF,0x9C),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_B1 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_B1_infos
};

static const struct byte_lookup* const
from_EUC_JP_B2_infos[95] = {
     o3(0xE6,0x8A,0xBC), o3(0xE6,0x97,0xBA),
     o3(0xE6,0xA8,0xAA), o3(0xE6,0xAC,0xA7),
     o3(0xE6,0xAE,0xB4), o3(0xE7,0x8E,0x8B),
     o3(0xE7,0xBF,0x81), o3(0xE8,0xA5,0x96),
     o3(0xE9,0xB4,0xAC), o3(0xE9,0xB4,0x8E),
     o3(0xE9,0xBB,0x84), o3(0xE5,0xB2,0xA1),
     o3(0xE6,0xB2,0x96), o3(0xE8,0x8D,0xBB),
     o3(0xE5,0x84,0x84), o3(0xE5,0xB1,0x8B),
     o3(0xE6,0x86,0xB6), o3(0xE8,0x87,0x86),
     o3(0xE6,0xA1,0xB6), o3(0xE7,0x89,0xA1),
     o3(0xE4,0xB9,0x99), o3(0xE4,0xBF,0xBA),
     o3(0xE5,0x8D,0xB8), o3(0xE6,0x81,0xA9),
     o3(0xE6,0xB8,0xA9), o3(0xE7,0xA9,0x8F),
     o3(0xE9,0x9F,0xB3), o3(0xE4,0xB8,0x8B),
     o3(0xE5,0x8C,0x96), o3(0xE4,0xBB,0xAE),
     o3(0xE4,0xBD,0x95), o3(0xE4,0xBC,0xBD),
     o3(0xE4,0xBE,0xA1), o3(0xE4,0xBD,0xB3),
     o3(0xE5,0x8A,0xA0), o3(0xE5,0x8F,0xAF),
     o3(0xE5,0x98,0x89), o3(0xE5,0xA4,0x8F),
     o3(0xE5,0xAB,0x81), o3(0xE5,0xAE,0xB6),
     o3(0xE5,0xAF,0xA1), o3(0xE7,0xA7,0x91),
     o3(0xE6,0x9A,0x87), o3(0xE6,0x9E,0x9C),
     o3(0xE6,0x9E,0xB6), o3(0xE6,0xAD,0x8C),
     o3(0xE6,0xB2,0xB3), o3(0xE7,0x81,0xAB),
     o3(0xE7,0x8F,0x82), o3(0xE7,0xA6,0x8D),
     o3(0xE7,0xA6,0xBE), o3(0xE7,0xA8,0xBC),
     o3(0xE7,0xAE,0x87), o3(0xE8,0x8A,0xB1),
     o3(0xE8,0x8B,0x9B), o3(0xE8,0x8C,0x84),
     o3(0xE8,0x8D,0xB7), o3(0xE8,0x8F,0xAF),
     o3(0xE8,0x8F,0x93), o3(0xE8,0x9D,0xA6),
     o3(0xE8,0xAA,0xB2), o3(0xE5,0x98,0xA9),
     o3(0xE8,0xB2,0xA8), o3(0xE8,0xBF,0xA6),
     o3(0xE9,0x81,0x8E), o3(0xE9,0x9C,0x9E),
     o3(0xE8,0x9A,0x8A), o3(0xE4,0xBF,0x84),
     o3(0xE5,0xB3,0xA8), o3(0xE6,0x88,0x91),
     o3(0xE7,0x89,0x99), o3(0xE7,0x94,0xBB),
     o3(0xE8,0x87,0xA5), o3(0xE8,0x8A,0xBD),
     o3(0xE8,0x9B,0xBE), o3(0xE8,0xB3,0x80),
     o3(0xE9,0x9B,0x85), o3(0xE9,0xA4,0x93),
     o3(0xE9,0xA7,0x95), o3(0xE4,0xBB,0x8B),
     o3(0xE4,0xBC,0x9A), o3(0xE8,0xA7,0xA3),
     o3(0xE5,0x9B,0x9E), o3(0xE5,0xA1,0x8A),
     o3(0xE5,0xA3,0x8A), o3(0xE5,0xBB,0xBB),
     o3(0xE5,0xBF,0xAB), o3(0xE6,0x80,0xAA),
     o3(0xE6,0x82,0x94), o3(0xE6,0x81,0xA2),
     o3(0xE6,0x87,0x90), o3(0xE6,0x88,0x92),
     o3(0xE6,0x8B,0x90), o3(0xE6,0x94,0xB9),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_B2 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_B2_infos
};

static const struct byte_lookup* const
from_EUC_JP_B3_infos[95] = {
     o3(0xE9,0xAD,0x81), o3(0xE6,0x99,0xA6),
     o3(0xE6,0xA2,0xB0), o3(0xE6,0xB5,0xB7),
     o3(0xE7,0x81,0xB0), o3(0xE7,0x95,0x8C),
     o3(0xE7,0x9A,0x86), o3(0xE7,0xB5,0xB5),
     o3(0xE8,0x8A,0xA5), o3(0xE8,0x9F,0xB9),
     o3(0xE9,0x96,0x8B), o3(0xE9,0x9A,0x8E),
     o3(0xE8,0xB2,0x9D), o3(0xE5,0x87,0xB1),
     o3(0xE5,0x8A,0xBE), o3(0xE5,0xA4,0x96),
     o3(0xE5,0x92,0xB3), o3(0xE5,0xAE,0xB3),
     o3(0xE5,0xB4,0x96), o3(0xE6,0x85,0xA8),
     o3(0xE6,0xA6,0x82), o3(0xE6,0xB6,0xAF),
     o3(0xE7,0xA2,0x8D), o3(0xE8,0x93,0x8B),
     o3(0xE8,0xA1,0x97), o3(0xE8,0xA9,0xB2),
     o3(0xE9,0x8E,0xA7), o3(0xE9,0xAA,0xB8),
     o3(0xE6,0xB5,0xAC), o3(0xE9,0xA6,0xA8),
     o3(0xE8,0x9B,0x99), o3(0xE5,0x9E,0xA3),
     o3(0xE6,0x9F,0xBF), o3(0xE8,0x9B,0x8E),
     o3(0xE9,0x88,0x8E), o3(0xE5,0x8A,0x83),
     o3(0xE5,0x9A,0x87), o3(0xE5,0x90,0x84),
     o3(0xE5,0xBB,0x93), o3(0xE6,0x8B,0xA1),
     o3(0xE6,0x92,0xB9), o3(0xE6,0xA0,0xBC),
     o3(0xE6,0xA0,0xB8), o3(0xE6,0xAE,0xBB),
     o3(0xE7,0x8D,0xB2), o3(0xE7,0xA2,0xBA),
     o3(0xE7,0xA9,0xAB), o3(0xE8,0xA6,0x9A),
     o3(0xE8,0xA7,0x92), o3(0xE8,0xB5,0xAB),
     o3(0xE8,0xBC,0x83), o3(0xE9,0x83,0xAD),
     o3(0xE9,0x96,0xA3), o3(0xE9,0x9A,0x94),
     o3(0xE9,0x9D,0xA9), o3(0xE5,0xAD,0xA6),
     o3(0xE5,0xB2,0xB3), o3(0xE6,0xA5,0xBD),
     o3(0xE9,0xA1,0x8D), o3(0xE9,0xA1,0x8E),
     o3(0xE6,0x8E,0x9B), o3(0xE7,0xAC,0xA0),
     o3(0xE6,0xA8,0xAB), o3(0xE6,0xA9,0xBF),
     o3(0xE6,0xA2,0xB6), o3(0xE9,0xB0,0x8D),
     o3(0xE6,0xBD,0x9F), o3(0xE5,0x89,0xB2),
     o3(0xE5,0x96,0x9D), o3(0xE6,0x81,0xB0),
     o3(0xE6,0x8B,0xAC), o3(0xE6,0xB4,0xBB),
     o3(0xE6,0xB8,0x87), o3(0xE6,0xBB,0x91),
     o3(0xE8,0x91,0x9B), o3(0xE8,0xA4,0x90),
     o3(0xE8,0xBD,0x84), o3(0xE4,0xB8,0x94),
     o3(0xE9,0xB0,0xB9), o3(0xE5,0x8F,0xB6),
     o3(0xE6,0xA4,0x9B), o3(0xE6,0xA8,0xBA),
     o3(0xE9,0x9E,0x84), o3(0xE6,0xA0,0xAA),
     o3(0xE5,0x85,0x9C), o3(0xE7,0xAB,0x83),
     o3(0xE8,0x92,0xB2), o3(0xE9,0x87,0x9C),
     o3(0xE9,0x8E,0x8C), o3(0xE5,0x99,0x9B),
     o3(0xE9,0xB4,0xA8), o3(0xE6,0xA0,0xA2),
     o3(0xE8,0x8C,0x85), o3(0xE8,0x90,0xB1),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_B3 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_B3_infos
};

static const struct byte_lookup* const
from_EUC_JP_B4_infos[95] = {
     o3(0xE7,0xB2,0xA5), o3(0xE5,0x88,0x88),
     o3(0xE8,0x8B,0x85), o3(0xE7,0x93,0xA6),
     o3(0xE4,0xB9,0xBE), o3(0xE4,0xBE,0x83),
     o3(0xE5,0x86,0xA0), o3(0xE5,0xAF,0x92),
     o3(0xE5,0x88,0x8A), o3(0xE5,0x8B,0x98),
     o3(0xE5,0x8B,0xA7), o3(0xE5,0xB7,0xBB),
     o3(0xE5,0x96,0x9A), o3(0xE5,0xA0,0xAA),
     o3(0xE5,0xA7,0xA6), o3(0xE5,0xAE,0x8C),
     o3(0xE5,0xAE,0x98), o3(0xE5,0xAF,0x9B),
     o3(0xE5,0xB9,0xB2), o3(0xE5,0xB9,0xB9),
     o3(0xE6,0x82,0xA3), o3(0xE6,0x84,0x9F),
     o3(0xE6,0x85,0xA3), o3(0xE6,0x86,0xBE),
     o3(0xE6,0x8F,0x9B), o3(0xE6,0x95,0xA2),
     o3(0xE6,0x9F,0x91), o3(0xE6,0xA1,0x93),
     o3(0xE6,0xA3,0xBA), o3(0xE6,0xAC,0xBE),
     o3(0xE6,0xAD,0x93), o3(0xE6,0xB1,0x97),
     o3(0xE6,0xBC,0xA2), o3(0xE6,0xBE,0x97),
     o3(0xE6,0xBD,0x85), o3(0xE7,0x92,0xB0),
     o3(0xE7,0x94,0x98), o3(0xE7,0x9B,0xA3),
     o3(0xE7,0x9C,0x8B), o3(0xE7,0xAB,0xBF),
     o3(0xE7,0xAE,0xA1), o3(0xE7,0xB0,0xA1),
     o3(0xE7,0xB7,0xA9), o3(0xE7,0xBC,0xB6),
     o3(0xE7,0xBF,0xB0), o3(0xE8,0x82,0x9D),
     o3(0xE8,0x89,0xA6), o3(0xE8,0x8E,0x9E),
     o3(0xE8,0xA6,0xB3), o3(0xE8,0xAB,0x8C),
     o3(0xE8,0xB2,0xAB), o3(0xE9,0x82,0x84),
     o3(0xE9,0x91,0x91), o3(0xE9,0x96,0x93),
     o3(0xE9,0x96,0x91), o3(0xE9,0x96,0xA2),
     o3(0xE9,0x99,0xA5), o3(0xE9,0x9F,0x93),
     o3(0xE9,0xA4,0xA8), o3(0xE8,0x88,0x98),
     o3(0xE4,0xB8,0xB8), o3(0xE5,0x90,0xAB),
     o3(0xE5,0xB2,0xB8), o3(0xE5,0xB7,0x8C),
     o3(0xE7,0x8E,0xA9), o3(0xE7,0x99,0x8C),
     o3(0xE7,0x9C,0xBC), o3(0xE5,0xB2,0xA9),
     o3(0xE7,0xBF,0xAB), o3(0xE8,0xB4,0x8B),
     o3(0xE9,0x9B,0x81), o3(0xE9,0xA0,0x91),
     o3(0xE9,0xA1,0x94), o3(0xE9,0xA1,0x98),
     o3(0xE4,0xBC,0x81), o3(0xE4,0xBC,0x8E),
     o3(0xE5,0x8D,0xB1), o3(0xE5,0x96,0x9C),
     o3(0xE5,0x99,0xA8), o3(0xE5,0x9F,0xBA),
     o3(0xE5,0xA5,0x87), o3(0xE5,0xAC,0x89),
     o3(0xE5,0xAF,0x84), o3(0xE5,0xB2,0x90),
     o3(0xE5,0xB8,0x8C), o3(0xE5,0xB9,0xBE),
     o3(0xE5,0xBF,0x8C), o3(0xE6,0x8F,0xAE),
     o3(0xE6,0x9C,0xBA), o3(0xE6,0x97,0x97),
     o3(0xE6,0x97,0xA2), o3(0xE6,0x9C,0x9F),
     o3(0xE6,0xA3,0x8B), o3(0xE6,0xA3,0x84),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_B4 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_B4_infos
};

static const struct byte_lookup* const
from_EUC_JP_B5_infos[95] = {
     o3(0xE6,0xA9,0x9F), o3(0xE5,0xB8,0xB0),
     o3(0xE6,0xAF,0x85), o3(0xE6,0xB0,0x97),
     o3(0xE6,0xB1,0xBD), o3(0xE7,0x95,0xBF),
     o3(0xE7,0xA5,0x88), o3(0xE5,0xAD,0xA3),
     o3(0xE7,0xA8,0x80), o3(0xE7,0xB4,0x80),
     o3(0xE5,0xBE,0xBD), o3(0xE8,0xA6,0x8F),
     o3(0xE8,0xA8,0x98), o3(0xE8,0xB2,0xB4),
     o3(0xE8,0xB5,0xB7), o3(0xE8,0xBB,0x8C),
     o3(0xE8,0xBC,0x9D), o3(0xE9,0xA3,0xA2),
     o3(0xE9,0xA8,0x8E), o3(0xE9,0xAC,0xBC),
     o3(0xE4,0xBA,0x80), o3(0xE5,0x81,0xBD),
     o3(0xE5,0x84,0x80), o3(0xE5,0xA6,0x93),
     o3(0xE5,0xAE,0x9C), o3(0xE6,0x88,0xAF),
     o3(0xE6,0x8A,0x80), o3(0xE6,0x93,0xAC),
     o3(0xE6,0xAC,0xBA), o3(0xE7,0x8A,0xA0),
     o3(0xE7,0x96,0x91), o3(0xE7,0xA5,0x87),
     o3(0xE7,0xBE,0xA9), o3(0xE8,0x9F,0xBB),
     o3(0xE8,0xAA,0xBC), o3(0xE8,0xAD,0xB0),
     o3(0xE6,0x8E,0xAC), o3(0xE8,0x8F,0x8A),
     o3(0xE9,0x9E,0xA0), o3(0xE5,0x90,0x89),
     o3(0xE5,0x90,0x83), o3(0xE5,0x96,0xAB),
     o3(0xE6,0xA1,0x94), o3(0xE6,0xA9,0x98),
     o3(0xE8,0xA9,0xB0), o3(0xE7,0xA0,0xA7),
     o3(0xE6,0x9D,0xB5), o3(0xE9,0xBB,0x8D),
     o3(0xE5,0x8D,0xB4), o3(0xE5,0xAE,0xA2),
     o3(0xE8,0x84,0x9A), o3(0xE8,0x99,0x90),
     o3(0xE9,0x80,0x86), o3(0xE4,0xB8,0x98),
     o3(0xE4,0xB9,0x85), o3(0xE4,0xBB,0x87),
     o3(0xE4,0xBC,0x91), o3(0xE5,0x8F,0x8A),
     o3(0xE5,0x90,0xB8), o3(0xE5,0xAE,0xAE),
     o3(0xE5,0xBC,0x93), o3(0xE6,0x80,0xA5),
     o3(0xE6,0x95,0x91), o3(0xE6,0x9C,0xBD),
     o3(0xE6,0xB1,0x82), o3(0xE6,0xB1,0xB2),
     o3(0xE6,0xB3,0xA3), o3(0xE7,0x81,0xB8),
     o3(0xE7,0x90,0x83), o3(0xE7,0xA9,0xB6),
     o3(0xE7,0xAA,0xAE), o3(0xE7,0xAC,0x88),
     o3(0xE7,0xB4,0x9A), o3(0xE7,0xB3,0xBE),
     o3(0xE7,0xB5,0xA6), o3(0xE6,0x97,0xA7),
     o3(0xE7,0x89,0x9B), o3(0xE5,0x8E,0xBB),
     o3(0xE5,0xB1,0x85), o3(0xE5,0xB7,0xA8),
     o3(0xE6,0x8B,0x92), o3(0xE6,0x8B,0xA0),
     o3(0xE6,0x8C,0x99), o3(0xE6,0xB8,0xA0),
     o3(0xE8,0x99,0x9A), o3(0xE8,0xA8,0xB1),
     o3(0xE8,0xB7,0x9D), o3(0xE9,0x8B,0xB8),
     o3(0xE6,0xBC,0x81), o3(0xE7,0xA6,0xA6),
     o3(0xE9,0xAD,0x9A), o3(0xE4,0xBA,0xA8),
     o3(0xE4,0xBA,0xAB), o3(0xE4,0xBA,0xAC),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_B5 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_B5_infos
};

static const struct byte_lookup* const
from_EUC_JP_B6_infos[95] = {
     o3(0xE4,0xBE,0x9B), o3(0xE4,0xBE,0xA0),
     o3(0xE5,0x83,0x91), o3(0xE5,0x85,0x87),
     o3(0xE7,0xAB,0xB6), o3(0xE5,0x85,0xB1),
     o3(0xE5,0x87,0xB6), o3(0xE5,0x8D,0x94),
     o3(0xE5,0x8C,0xA1), o3(0xE5,0x8D,0xBF),
     o3(0xE5,0x8F,0xAB), o3(0xE5,0x96,0xAC),
     o3(0xE5,0xA2,0x83), o3(0xE5,0xB3,0xA1),
     o3(0xE5,0xBC,0xB7), o3(0xE5,0xBD,0x8A),
     o3(0xE6,0x80,0xAF), o3(0xE6,0x81,0x90),
     o3(0xE6,0x81,0xAD), o3(0xE6,0x8C,0x9F),
     o3(0xE6,0x95,0x99), o3(0xE6,0xA9,0x8B),
     o3(0xE6,0xB3,0x81), o3(0xE7,0x8B,0x82),
     o3(0xE7,0x8B,0xAD), o3(0xE7,0x9F,0xAF),
     o3(0xE8,0x83,0xB8), o3(0xE8,0x84,0x85),
     o3(0xE8,0x88,0x88), o3(0xE8,0x95,0x8E),
     o3(0xE9,0x83,0xB7), o3(0xE9,0x8F,0xA1),
     o3(0xE9,0x9F,0xBF), o3(0xE9,0xA5,0x97),
     o3(0xE9,0xA9,0x9A), o3(0xE4,0xBB,0xB0),
     o3(0xE5,0x87,0x9D), o3(0xE5,0xB0,0xAD),
     o3(0xE6,0x9A,0x81), o3(0xE6,0xA5,0xAD),
     o3(0xE5,0xB1,0x80), o3(0xE6,0x9B,0xB2),
     o3(0xE6,0xA5,0xB5), o3(0xE7,0x8E,0x89),
     o3(0xE6,0xA1,0x90), o3(0xE7,0xB2,0x81),
     o3(0xE5,0x83,0x85), o3(0xE5,0x8B,0xA4),
     o3(0xE5,0x9D,0x87), o3(0xE5,0xB7,0xBE),
     o3(0xE9,0x8C,0xA6), o3(0xE6,0x96,0xA4),
     o3(0xE6,0xAC,0xA3), o3(0xE6,0xAC,0xBD),
     o3(0xE7,0x90,0xB4), o3(0xE7,0xA6,0x81),
     o3(0xE7,0xA6,0xBD), o3(0xE7,0xAD,0x8B),
     o3(0xE7,0xB7,0x8A), o3(0xE8,0x8A,0xB9),
     o3(0xE8,0x8F,0x8C), o3(0xE8,0xA1,0xBF),
     o3(0xE8,0xA5,0x9F), o3(0xE8,0xAC,0xB9),
     o3(0xE8,0xBF,0x91), o3(0xE9,0x87,0x91),
     o3(0xE5,0x90,0x9F), o3(0xE9,0x8A,0x80),
     o3(0xE4,0xB9,0x9D), o3(0xE5,0x80,0xB6),
     o3(0xE5,0x8F,0xA5), o3(0xE5,0x8C,0xBA),
     o3(0xE7,0x8B,0x97), o3(0xE7,0x8E,0x96),
     o3(0xE7,0x9F,0xA9), o3(0xE8,0x8B,0xA6),
     o3(0xE8,0xBA,0xAF), o3(0xE9,0xA7,0x86),
     o3(0xE9,0xA7,0x88), o3(0xE9,0xA7,0x92),
     o3(0xE5,0x85,0xB7), o3(0xE6,0x84,0x9A),
     o3(0xE8,0x99,0x9E), o3(0xE5,0x96,0xB0),
     o3(0xE7,0xA9,0xBA), o3(0xE5,0x81,0xB6),
     o3(0xE5,0xAF,0x93), o3(0xE9,0x81,0x87),
     o3(0xE9,0x9A,0x85), o3(0xE4,0xB8,0xB2),
     o3(0xE6,0xAB,0x9B), o3(0xE9,0x87,0xA7),
     o3(0xE5,0xB1,0x91), o3(0xE5,0xB1,0x88),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_B6 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_B6_infos
};

static const struct byte_lookup* const
from_EUC_JP_B7_infos[95] = {
     o3(0xE6,0x8E,0x98), o3(0xE7,0xAA,0x9F),
     o3(0xE6,0xB2,0x93), o3(0xE9,0x9D,0xB4),
     o3(0xE8,0xBD,0xA1), o3(0xE7,0xAA,0xAA),
     o3(0xE7,0x86,0x8A), o3(0xE9,0x9A,0x88),
     o3(0xE7,0xB2,0x82), o3(0xE6,0xA0,0x97),
     o3(0xE7,0xB9,0xB0), o3(0xE6,0xA1,0x91),
     o3(0xE9,0x8D,0xAC), o3(0xE5,0x8B,0xB2),
     o3(0xE5,0x90,0x9B), o3(0xE8,0x96,0xAB),
     o3(0xE8,0xA8,0x93), o3(0xE7,0xBE,0xA4),
     o3(0xE8,0xBB,0x8D), o3(0xE9,0x83,0xA1),
     o3(0xE5,0x8D,0xA6), o3(0xE8,0xA2,0x88),
     o3(0xE7,0xA5,0x81), o3(0xE4,0xBF,0x82),
     o3(0xE5,0x82,0xBE), o3(0xE5,0x88,0x91),
     o3(0xE5,0x85,0x84), o3(0xE5,0x95,0x93),
     o3(0xE5,0x9C,0xAD), o3(0xE7,0x8F,0xAA),
     o3(0xE5,0x9E,0x8B), o3(0xE5,0xA5,0x91),
     o3(0xE5,0xBD,0xA2), o3(0xE5,0xBE,0x84),
     o3(0xE6,0x81,0xB5), o3(0xE6,0x85,0xB6),
     o3(0xE6,0x85,0xA7), o3(0xE6,0x86,0xA9),
     o3(0xE6,0x8E,0xB2), o3(0xE6,0x90,0xBA),
     o3(0xE6,0x95,0xAC), o3(0xE6,0x99,0xAF),
     o3(0xE6,0xA1,0x82), o3(0xE6,0xB8,0x93),
     o3(0xE7,0x95,0xA6), o3(0xE7,0xA8,0xBD),
     o3(0xE7,0xB3,0xBB), o3(0xE7,0xB5,0x8C),
     o3(0xE7,0xB6,0x99), o3(0xE7,0xB9,0x8B),
     o3(0xE7,0xBD,0xAB), o3(0xE8,0x8C,0x8E),
     o3(0xE8,0x8D,0x8A), o3(0xE8,0x9B,0x8D),
     o3(0xE8,0xA8,0x88), o3(0xE8,0xA9,0xA3),
     o3(0xE8,0xAD,0xA6), o3(0xE8,0xBB,0xBD),
     o3(0xE9,0xA0,0x9A), o3(0xE9,0xB6,0x8F),
     o3(0xE8,0x8A,0xB8), o3(0xE8,0xBF,0x8E),
     o3(0xE9,0xAF,0xA8), o3(0xE5,0x8A,0x87),
     o3(0xE6,0x88,0x9F), o3(0xE6,0x92,0x83),
     o3(0xE6,0xBF,0x80), o3(0xE9,0x9A,0x99),
     o3(0xE6,0xA1,0x81), o3(0xE5,0x82,0x91),
     o3(0xE6,0xAC,0xA0), o3(0xE6,0xB1,0xBA),
     o3(0xE6,0xBD,0x94), o3(0xE7,0xA9,0xB4),
     o3(0xE7,0xB5,0x90), o3(0xE8,0xA1,0x80),
     o3(0xE8,0xA8,0xA3), o3(0xE6,0x9C,0x88),
     o3(0xE4,0xBB,0xB6), o3(0xE5,0x80,0xB9),
     o3(0xE5,0x80,0xA6), o3(0xE5,0x81,0xA5),
     o3(0xE5,0x85,0xBC), o3(0xE5,0x88,0xB8),
     o3(0xE5,0x89,0xA3), o3(0xE5,0x96,0xA7),
     o3(0xE5,0x9C,0x8F), o3(0xE5,0xA0,0x85),
     o3(0xE5,0xAB,0x8C), o3(0xE5,0xBB,0xBA),
     o3(0xE6,0x86,0xB2), o3(0xE6,0x87,0xB8),
     o3(0xE6,0x8B,0xB3), o3(0xE6,0x8D,0xB2),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_B7 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_B7_infos
};

static const struct byte_lookup* const
from_EUC_JP_B8_infos[95] = {
     o3(0xE6,0xA4,0x9C), o3(0xE6,0xA8,0xA9),
     o3(0xE7,0x89,0xBD), o3(0xE7,0x8A,0xAC),
     o3(0xE7,0x8C,0xAE), o3(0xE7,0xA0,0x94),
     o3(0xE7,0xA1,0xAF), o3(0xE7,0xB5,0xB9),
     o3(0xE7,0x9C,0x8C), o3(0xE8,0x82,0xA9),
     o3(0xE8,0xA6,0x8B), o3(0xE8,0xAC,0x99),
     o3(0xE8,0xB3,0xA2), o3(0xE8,0xBB,0x92),
     o3(0xE9,0x81,0xA3), o3(0xE9,0x8D,0xB5),
     o3(0xE9,0x99,0xBA), o3(0xE9,0xA1,0x95),
     o3(0xE9,0xA8,0x93), o3(0xE9,0xB9,0xB8),
     o3(0xE5,0x85,0x83), o3(0xE5,0x8E,0x9F),
     o3(0xE5,0x8E,0xB3), o3(0xE5,0xB9,0xBB),
     o3(0xE5,0xBC,0xA6), o3(0xE6,0xB8,0x9B),
     o3(0xE6,0xBA,0x90), o3(0xE7,0x8E,0x84),
     o3(0xE7,0x8F,0xBE), o3(0xE7,0xB5,0x83),
     o3(0xE8,0x88,0xB7), o3(0xE8,0xA8,0x80),
     o3(0xE8,0xAB,0xBA), o3(0xE9,0x99,0x90),
     o3(0xE4,0xB9,0x8E), o3(0xE5,0x80,0x8B),
     o3(0xE5,0x8F,0xA4), o3(0xE5,0x91,0xBC),
     o3(0xE5,0x9B,0xBA), o3(0xE5,0xA7,0x91),
     o3(0xE5,0xAD,0xA4), o3(0xE5,0xB7,0xB1),
     o3(0xE5,0xBA,0xAB), o3(0xE5,0xBC,0xA7),
     o3(0xE6,0x88,0xB8), o3(0xE6,0x95,0x85),
     o3(0xE6,0x9E,0xAF), o3(0xE6,0xB9,0x96),
     o3(0xE7,0x8B,0x90), o3(0xE7,0xB3,0x8A),
     o3(0xE8,0xA2,0xB4), o3(0xE8,0x82,0xA1),
     o3(0xE8,0x83,0xA1), o3(0xE8,0x8F,0xB0),
     o3(0xE8,0x99,0x8E), o3(0xE8,0xAA,0x87),
     o3(0xE8,0xB7,0xA8), o3(0xE9,0x88,0xB7),
     o3(0xE9,0x9B,0x87), o3(0xE9,0xA1,0xA7),
     o3(0xE9,0xBC,0x93), o3(0xE4,0xBA,0x94),
     o3(0xE4,0xBA,0x92), o3(0xE4,0xBC,0x8D),
     o3(0xE5,0x8D,0x88), o3(0xE5,0x91,0x89),
     o3(0xE5,0x90,0xBE), o3(0xE5,0xA8,0xAF),
     o3(0xE5,0xBE,0x8C), o3(0xE5,0xBE,0xA1),
     o3(0xE6,0x82,0x9F), o3(0xE6,0xA2,0xA7),
     o3(0xE6,0xAA,0x8E), o3(0xE7,0x91,0x9A),
     o3(0xE7,0xA2,0x81), o3(0xE8,0xAA,0x9E),
     o3(0xE8,0xAA,0xA4), o3(0xE8,0xAD,0xB7),
     o3(0xE9,0x86,0x90), o3(0xE4,0xB9,0x9E),
     o3(0xE9,0xAF,0x89), o3(0xE4,0xBA,0xA4),
     o3(0xE4,0xBD,0xBC), o3(0xE4,0xBE,0xAF),
     o3(0xE5,0x80,0x99), o3(0xE5,0x80,0x96),
     o3(0xE5,0x85,0x89), o3(0xE5,0x85,0xAC),
     o3(0xE5,0x8A,0x9F), o3(0xE5,0x8A,0xB9),
     o3(0xE5,0x8B,0xBE), o3(0xE5,0x8E,0x9A),
     o3(0xE5,0x8F,0xA3), o3(0xE5,0x90,0x91),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_B8 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_B8_infos
};

static const struct byte_lookup* const
from_EUC_JP_B9_infos[95] = {
     o3(0xE5,0x90,0x8E), o3(0xE5,0x96,0x89),
     o3(0xE5,0x9D,0x91), o3(0xE5,0x9E,0xA2),
     o3(0xE5,0xA5,0xBD), o3(0xE5,0xAD,0x94),
     o3(0xE5,0xAD,0x9D), o3(0xE5,0xAE,0x8F),
     o3(0xE5,0xB7,0xA5), o3(0xE5,0xB7,0xA7),
     o3(0xE5,0xB7,0xB7), o3(0xE5,0xB9,0xB8),
     o3(0xE5,0xBA,0x83), o3(0xE5,0xBA,0x9A),
     o3(0xE5,0xBA,0xB7), o3(0xE5,0xBC,0x98),
     o3(0xE6,0x81,0x92), o3(0xE6,0x85,0x8C),
     o3(0xE6,0x8A,0x97), o3(0xE6,0x8B,0x98),
     o3(0xE6,0x8E,0xA7), o3(0xE6,0x94,0xBB),
     o3(0xE6,0x98,0x82), o3(0xE6,0x99,0x83),
     o3(0xE6,0x9B,0xB4), o3(0xE6,0x9D,0xAD),
     o3(0xE6,0xA0,0xA1), o3(0xE6,0xA2,0x97),
     o3(0xE6,0xA7,0x8B), o3(0xE6,0xB1,0x9F),
     o3(0xE6,0xB4,0xAA), o3(0xE6,0xB5,0xA9),
     o3(0xE6,0xB8,0xAF), o3(0xE6,0xBA,0x9D),
     o3(0xE7,0x94,0xB2), o3(0xE7,0x9A,0x87),
     o3(0xE7,0xA1,0xAC), o3(0xE7,0xA8,0xBF),
     o3(0xE7,0xB3,0xA0), o3(0xE7,0xB4,0x85),
     o3(0xE7,0xB4,0x98), o3(0xE7,0xB5,0x9E),
     o3(0xE7,0xB6,0xB1), o3(0xE8,0x80,0x95),
     o3(0xE8,0x80,0x83), o3(0xE8,0x82,0xAF),
     o3(0xE8,0x82,0xB1), o3(0xE8,0x85,0x94),
     o3(0xE8,0x86,0x8F), o3(0xE8,0x88,0xAA),
     o3(0xE8,0x8D,0x92), o3(0xE8,0xA1,0x8C),
     o3(0xE8,0xA1,0xA1), o3(0xE8,0xAC,0x9B),
     o3(0xE8,0xB2,0xA2), o3(0xE8,0xB3,0xBC),
     o3(0xE9,0x83,0x8A), o3(0xE9,0x85,0xB5),
     o3(0xE9,0x89,0xB1), o3(0xE7,0xA0,0xBF),
     o3(0xE9,0x8B,0xBC), o3(0xE9,0x96,0xA4),
     o3(0xE9,0x99,0x8D), o3(0xE9,0xA0,0x85),
     o3(0xE9,0xA6,0x99), o3(0xE9,0xAB,0x98),
     o3(0xE9,0xB4,0xBB), o3(0xE5,0x89,0x9B),
     o3(0xE5,0x8A,0xAB), o3(0xE5,0x8F,0xB7),
     o3(0xE5,0x90,0x88), o3(0xE5,0xA3,0x95),
     o3(0xE6,0x8B,0xB7), o3(0xE6,0xBF,0xA0),
     o3(0xE8,0xB1,0xAA), o3(0xE8,0xBD,0x9F),
     o3(0xE9,0xBA,0xB9), o3(0xE5,0x85,0x8B),
     o3(0xE5,0x88,0xBB), o3(0xE5,0x91,0x8A),
     o3(0xE5,0x9B,0xBD), o3(0xE7,0xA9,0x80),
     o3(0xE9,0x85,0xB7), o3(0xE9,0xB5,0xA0),
     o3(0xE9,0xBB,0x92), o3(0xE7,0x8D,0x84),
     o3(0xE6,0xBC,0x89), o3(0xE8,0x85,0xB0),
     o3(0xE7,0x94,0x91), o3(0xE5,0xBF,0xBD),
     o3(0xE6,0x83,0x9A), o3(0xE9,0xAA,0xA8),
     o3(0xE7,0x8B,0x9B), o3(0xE8,0xBE,0xBC),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_B9 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_B9_infos
};

static const struct byte_lookup* const
from_EUC_JP_BA_infos[95] = {
     o3(0xE6,0xAD,0xA4), o3(0xE9,0xA0,0x83),
     o3(0xE4,0xBB,0x8A), o3(0xE5,0x9B,0xB0),
     o3(0xE5,0x9D,0xA4), o3(0xE5,0xA2,0xBE),
     o3(0xE5,0xA9,0x9A), o3(0xE6,0x81,0xA8),
     o3(0xE6,0x87,0x87), o3(0xE6,0x98,0x8F),
     o3(0xE6,0x98,0x86), o3(0xE6,0xA0,0xB9),
     o3(0xE6,0xA2,0xB1), o3(0xE6,0xB7,0xB7),
     o3(0xE7,0x97,0x95), o3(0xE7,0xB4,0xBA),
     o3(0xE8,0x89,0xAE), o3(0xE9,0xAD,0x82),
     o3(0xE4,0xBA,0x9B), o3(0xE4,0xBD,0x90),
     o3(0xE5,0x8F,0x89), o3(0xE5,0x94,0x86),
     o3(0xE5,0xB5,0xAF), o3(0xE5,0xB7,0xA6),
     o3(0xE5,0xB7,0xAE), o3(0xE6,0x9F,0xBB),
     o3(0xE6,0xB2,0x99), o3(0xE7,0x91,0xB3),
     o3(0xE7,0xA0,0x82), o3(0xE8,0xA9,0x90),
     o3(0xE9,0x8E,0x96), o3(0xE8,0xA3,0x9F),
     o3(0xE5,0x9D,0x90), o3(0xE5,0xBA,0xA7),
     o3(0xE6,0x8C,0xAB), o3(0xE5,0x82,0xB5),
     o3(0xE5,0x82,0xAC), o3(0xE5,0x86,0x8D),
     o3(0xE6,0x9C,0x80), o3(0xE5,0x93,0x89),
     o3(0xE5,0xA1,0x9E), o3(0xE5,0xA6,0xBB),
     o3(0xE5,0xAE,0xB0), o3(0xE5,0xBD,0xA9),
     o3(0xE6,0x89,0x8D), o3(0xE6,0x8E,0xA1),
     o3(0xE6,0xA0,0xBD), o3(0xE6,0xAD,0xB3),
     o3(0xE6,0xB8,0x88), o3(0xE7,0x81,0xBD),
     o3(0xE9,0x87,0x87), o3(0xE7,0x8A,0x80),
     o3(0xE7,0xA0,0x95), o3(0xE7,0xA0,0xA6),
     o3(0xE7,0xA5,0xAD), o3(0xE6,0x96,0x8E),
     o3(0xE7,0xB4,0xB0), o3(0xE8,0x8F,0x9C),
     o3(0xE8,0xA3,0x81), o3(0xE8,0xBC,0x89),
     o3(0xE9,0x9A,0x9B), o3(0xE5,0x89,0xA4),
     o3(0xE5,0x9C,0xA8), o3(0xE6,0x9D,0x90),
     o3(0xE7,0xBD,0xAA), o3(0xE8,0xB2,0xA1),
     o3(0xE5,0x86,0xB4), o3(0xE5,0x9D,0x82),
     o3(0xE9,0x98,0xAA), o3(0xE5,0xA0,0xBA),
     o3(0xE6,0xA6,0x8A), o3(0xE8,0x82,0xB4),
     o3(0xE5,0x92,0xB2), o3(0xE5,0xB4,0x8E),
     o3(0xE5,0x9F,0xBC), o3(0xE7,0xA2,0x95),
     o3(0xE9,0xB7,0xBA), o3(0xE4,0xBD,0x9C),
     o3(0xE5,0x89,0x8A), o3(0xE5,0x92,0x8B),
     o3(0xE6,0x90,0xBE), o3(0xE6,0x98,0xA8),
     o3(0xE6,0x9C,0x94), o3(0xE6,0x9F,0xB5),
     o3(0xE7,0xAA,0x84), o3(0xE7,0xAD,0x96),
     o3(0xE7,0xB4,0xA2), o3(0xE9,0x8C,0xAF),
     o3(0xE6,0xA1,0x9C), o3(0xE9,0xAE,0xAD),
     o3(0xE7,0xAC,0xB9), o3(0xE5,0x8C,0x99),
     o3(0xE5,0x86,0x8A), o3(0xE5,0x88,0xB7),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_BA = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_BA_infos
};

static const struct byte_lookup* const
from_EUC_JP_BB_infos[95] = {
     o3(0xE5,0xAF,0x9F), o3(0xE6,0x8B,0xB6),
     o3(0xE6,0x92,0xAE), o3(0xE6,0x93,0xA6),
     o3(0xE6,0x9C,0xAD), o3(0xE6,0xAE,0xBA),
     o3(0xE8,0x96,0xA9), o3(0xE9,0x9B,0x91),
     o3(0xE7,0x9A,0x90), o3(0xE9,0xAF,0x96),
     o3(0xE6,0x8D,0x8C), o3(0xE9,0x8C,0x86),
     o3(0xE9,0xAE,0xAB), o3(0xE7,0x9A,0xBF),
     o3(0xE6,0x99,0x92), o3(0xE4,0xB8,0x89),
     o3(0xE5,0x82,0x98), o3(0xE5,0x8F,0x82),
     o3(0xE5,0xB1,0xB1), o3(0xE6,0x83,0xA8),
     o3(0xE6,0x92,0x92), o3(0xE6,0x95,0xA3),
     o3(0xE6,0xA1,0x9F), o3(0xE7,0x87,0xA6),
     o3(0xE7,0x8F,0x8A), o3(0xE7,0x94,0xA3),
     o3(0xE7,0xAE,0x97), o3(0xE7,0xBA,0x82),
     o3(0xE8,0x9A,0x95), o3(0xE8,0xAE,0x83),
     o3(0xE8,0xB3,0x9B), o3(0xE9,0x85,0xB8),
     o3(0xE9,0xA4,0x90), o3(0xE6,0x96,0xAC),
     o3(0xE6,0x9A,0xAB), o3(0xE6,0xAE,0x8B),
     o3(0xE4,0xBB,0x95), o3(0xE4,0xBB,0x94),
     o3(0xE4,0xBC,0xBA), o3(0xE4,0xBD,0xBF),
     o3(0xE5,0x88,0xBA), o3(0xE5,0x8F,0xB8),
     o3(0xE5,0x8F,0xB2), o3(0xE5,0x97,0xA3),
     o3(0xE5,0x9B,0x9B), o3(0xE5,0xA3,0xAB),
     o3(0xE5,0xA7,0x8B), o3(0xE5,0xA7,0x89),
     o3(0xE5,0xA7,0xBF), o3(0xE5,0xAD,0x90),
     o3(0xE5,0xB1,0x8D), o3(0xE5,0xB8,0x82),
     o3(0xE5,0xB8,0xAB), o3(0xE5,0xBF,0x97),
     o3(0xE6,0x80,0x9D), o3(0xE6,0x8C,0x87),
     o3(0xE6,0x94,0xAF), o3(0xE5,0xAD,0x9C),
     o3(0xE6,0x96,0xAF), o3(0xE6,0x96,0xBD),
     o3(0xE6,0x97,0xA8), o3(0xE6,0x9E,0x9D),
     o3(0xE6,0xAD,0xA2), o3(0xE6,0xAD,0xBB),
     o3(0xE6,0xB0,0x8F), o3(0xE7,0x8D,0x85),
     o3(0xE7,0xA5,0x89), o3(0xE7,0xA7,0x81),
     o3(0xE7,0xB3,0xB8), o3(0xE7,0xB4,0x99),
     o3(0xE7,0xB4,0xAB), o3(0xE8,0x82,0xA2),
     o3(0xE8,0x84,0x82), o3(0xE8,0x87,0xB3),
     o3(0xE8,0xA6,0x96), o3(0xE8,0xA9,0x9E),
     o3(0xE8,0xA9,0xA9), o3(0xE8,0xA9,0xA6),
     o3(0xE8,0xAA,0x8C), o3(0xE8,0xAB,0xAE),
     o3(0xE8,0xB3,0x87), o3(0xE8,0xB3,0x9C),
     o3(0xE9,0x9B,0x8C), o3(0xE9,0xA3,0xBC),
     o3(0xE6,0xAD,0xAF), o3(0xE4,0xBA,0x8B),
     o3(0xE4,0xBC,0xBC), o3(0xE4,0xBE,0x8D),
     o3(0xE5,0x85,0x90), o3(0xE5,0xAD,0x97),
     o3(0xE5,0xAF,0xBA), o3(0xE6,0x85,0x88),
     o3(0xE6,0x8C,0x81), o3(0xE6,0x99,0x82),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_BB = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_BB_infos
};

static const struct byte_lookup* const
from_EUC_JP_BC_infos[95] = {
     o3(0xE6,0xAC,0xA1), o3(0xE6,0xBB,0x8B),
     o3(0xE6,0xB2,0xBB), o3(0xE7,0x88,0xBE),
     o3(0xE7,0x92,0xBD), o3(0xE7,0x97,0x94),
     o3(0xE7,0xA3,0x81), o3(0xE7,0xA4,0xBA),
     o3(0xE8,0x80,0x8C), o3(0xE8,0x80,0xB3),
     o3(0xE8,0x87,0xAA), o3(0xE8,0x92,0x94),
     o3(0xE8,0xBE,0x9E), o3(0xE6,0xB1,0x90),
     o3(0xE9,0xB9,0xBF), o3(0xE5,0xBC,0x8F),
     o3(0xE8,0xAD,0x98), o3(0xE9,0xB4,0xAB),
     o3(0xE7,0xAB,0xBA), o3(0xE8,0xBB,0xB8),
     o3(0xE5,0xAE,0x8D), o3(0xE9,0x9B,0xAB),
     o3(0xE4,0xB8,0x83), o3(0xE5,0x8F,0xB1),
     o3(0xE5,0x9F,0xB7), o3(0xE5,0xA4,0xB1),
     o3(0xE5,0xAB,0x89), o3(0xE5,0xAE,0xA4),
     o3(0xE6,0x82,0x89), o3(0xE6,0xB9,0xBF),
     o3(0xE6,0xBC,0x86), o3(0xE7,0x96,0xBE),
     o3(0xE8,0xB3,0xAA), o3(0xE5,0xAE,0x9F),
     o3(0xE8,0x94,0x80), o3(0xE7,0xAF,0xA0),
     o3(0xE5,0x81,0xB2), o3(0xE6,0x9F,0xB4),
     o3(0xE8,0x8A,0x9D), o3(0xE5,0xB1,0xA1),
     o3(0xE8,0x95,0x8A), o3(0xE7,0xB8,0x9E),
     o3(0xE8,0x88,0x8E), o3(0xE5,0x86,0x99),
     o3(0xE5,0xB0,0x84), o3(0xE6,0x8D,0xA8),
     o3(0xE8,0xB5,0xA6), o3(0xE6,0x96,0x9C),
     o3(0xE7,0x85,0xAE), o3(0xE7,0xA4,0xBE),
     o3(0xE7,0xB4,0x97), o3(0xE8,0x80,0x85),
     o3(0xE8,0xAC,0x9D), o3(0xE8,0xBB,0x8A),
     o3(0xE9,0x81,0xAE), o3(0xE8,0x9B,0x87),
     o3(0xE9,0x82,0xAA), o3(0xE5,0x80,0x9F),
     o3(0xE5,0x8B,0xBA), o3(0xE5,0xB0,0xBA),
     o3(0xE6,0x9D,0x93), o3(0xE7,0x81,0xBC),
     o3(0xE7,0x88,0xB5), o3(0xE9,0x85,0x8C),
     o3(0xE9,0x87,0x88), o3(0xE9,0x8C,0xAB),
     o3(0xE8,0x8B,0xA5), o3(0xE5,0xAF,0x82),
     o3(0xE5,0xBC,0xB1), o3(0xE6,0x83,0xB9),
     o3(0xE4,0xB8,0xBB), o3(0xE5,0x8F,0x96),
     o3(0xE5,0xAE,0x88), o3(0xE6,0x89,0x8B),
     o3(0xE6,0x9C,0xB1), o3(0xE6,0xAE,0x8A),
     o3(0xE7,0x8B,0xA9), o3(0xE7,0x8F,0xA0),
     o3(0xE7,0xA8,0xAE), o3(0xE8,0x85,0xAB),
     o3(0xE8,0xB6,0xA3), o3(0xE9,0x85,0x92),
     o3(0xE9,0xA6,0x96), o3(0xE5,0x84,0x92),
     o3(0xE5,0x8F,0x97), o3(0xE5,0x91,0xAA),
     o3(0xE5,0xAF,0xBF), o3(0xE6,0x8E,0x88),
     o3(0xE6,0xA8,0xB9), o3(0xE7,0xB6,0xAC),
     o3(0xE9,0x9C,0x80), o3(0xE5,0x9B,0x9A),
     o3(0xE5,0x8F,0x8E), o3(0xE5,0x91,0xA8),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_BC = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_BC_infos
};

static const struct byte_lookup* const
from_EUC_JP_BD_infos[95] = {
     o3(0xE5,0xAE,0x97), o3(0xE5,0xB0,0xB1),
     o3(0xE5,0xB7,0x9E), o3(0xE4,0xBF,0xAE),
     o3(0xE6,0x84,0x81), o3(0xE6,0x8B,0xBE),
     o3(0xE6,0xB4,0xB2), o3(0xE7,0xA7,0x80),
     o3(0xE7,0xA7,0x8B), o3(0xE7,0xB5,0x82),
     o3(0xE7,0xB9,0x8D), o3(0xE7,0xBF,0x92),
     o3(0xE8,0x87,0xAD), o3(0xE8,0x88,0x9F),
     o3(0xE8,0x92,0x90), o3(0xE8,0xA1,0x86),
     o3(0xE8,0xA5,0xB2), o3(0xE8,0xAE,0x90),
     o3(0xE8,0xB9,0xB4), o3(0xE8,0xBC,0xAF),
     o3(0xE9,0x80,0xB1), o3(0xE9,0x85,0x8B),
     o3(0xE9,0x85,0xAC), o3(0xE9,0x9B,0x86),
     o3(0xE9,0x86,0x9C), o3(0xE4,0xBB,0x80),
     o3(0xE4,0xBD,0x8F), o3(0xE5,0x85,0x85),
     o3(0xE5,0x8D,0x81), o3(0xE5,0xBE,0x93),
     o3(0xE6,0x88,0x8E), o3(0xE6,0x9F,0x94),
     o3(0xE6,0xB1,0x81), o3(0xE6,0xB8,0x8B),
     o3(0xE7,0x8D,0xA3), o3(0xE7,0xB8,0xA6),
     o3(0xE9,0x87,0x8D), o3(0xE9,0x8A,0x83),
     o3(0xE5,0x8F,0x94), o3(0xE5,0xA4,0x99),
     o3(0xE5,0xAE,0xBF), o3(0xE6,0xB7,0x91),
     o3(0xE7,0xA5,0x9D), o3(0xE7,0xB8,0xAE),
     o3(0xE7,0xB2,0x9B), o3(0xE5,0xA1,0xBE),
     o3(0xE7,0x86,0x9F), o3(0xE5,0x87,0xBA),
     o3(0xE8,0xA1,0x93), o3(0xE8,0xBF,0xB0),
     o3(0xE4,0xBF,0x8A), o3(0xE5,0xB3,0xBB),
     o3(0xE6,0x98,0xA5), o3(0xE7,0x9E,0xAC),
     o3(0xE7,0xAB,0xA3), o3(0xE8,0x88,0x9C),
     o3(0xE9,0xA7,0xBF), o3(0xE5,0x87,0x86),
     o3(0xE5,0xBE,0xAA), o3(0xE6,0x97,0xAC),
     o3(0xE6,0xA5,0xAF), o3(0xE6,0xAE,0x89),
     o3(0xE6,0xB7,0xB3), o3(0xE6,0xBA,0x96),
     o3(0xE6,0xBD,0xA4), o3(0xE7,0x9B,0xBE),
     o3(0xE7,0xB4,0x94), o3(0xE5,0xB7,0xA1),
     o3(0xE9,0x81,0xB5), o3(0xE9,0x86,0x87),
     o3(0xE9,0xA0,0x86), o3(0xE5,0x87,0xA6),
     o3(0xE5,0x88,0x9D), o3(0xE6,0x89,0x80),
     o3(0xE6,0x9A,0x91), o3(0xE6,0x9B,0x99),
     o3(0xE6,0xB8,0x9A), o3(0xE5,0xBA,0xB6),
     o3(0xE7,0xB7,0x92), o3(0xE7,0xBD,0xB2),
     o3(0xE6,0x9B,0xB8), o3(0xE8,0x96,0xAF),
     o3(0xE8,0x97,0xB7), o3(0xE8,0xAB,0xB8),
     o3(0xE5,0x8A,0xA9), o3(0xE5,0x8F,0x99),
     o3(0xE5,0xA5,0xB3), o3(0xE5,0xBA,0x8F),
     o3(0xE5,0xBE,0x90), o3(0xE6,0x81,0x95),
     o3(0xE9,0x8B,0xA4), o3(0xE9,0x99,0xA4),
     o3(0xE5,0x82,0xB7), o3(0xE5,0x84,0x9F),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_BD = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_BD_infos
};

static const struct byte_lookup* const
from_EUC_JP_BE_infos[95] = {
     o3(0xE5,0x8B,0x9D), o3(0xE5,0x8C,0xA0),
     o3(0xE5,0x8D,0x87), o3(0xE5,0x8F,0xAC),
     o3(0xE5,0x93,0xA8), o3(0xE5,0x95,0x86),
     o3(0xE5,0x94,0xB1), o3(0xE5,0x98,0x97),
     o3(0xE5,0xA5,0xA8), o3(0xE5,0xA6,0xBE),
     o3(0xE5,0xA8,0xBC), o3(0xE5,0xAE,0xB5),
     o3(0xE5,0xB0,0x86), o3(0xE5,0xB0,0x8F),
     o3(0xE5,0xB0,0x91), o3(0xE5,0xB0,0x9A),
     o3(0xE5,0xBA,0x84), o3(0xE5,0xBA,0x8A),
     o3(0xE5,0xBB,0xA0), o3(0xE5,0xBD,0xB0),
     o3(0xE6,0x89,0xBF), o3(0xE6,0x8A,0x84),
     o3(0xE6,0x8B,0x9B), o3(0xE6,0x8E,0x8C),
     o3(0xE6,0x8D,0xB7), o3(0xE6,0x98,0x87),
     o3(0xE6,0x98,0x8C), o3(0xE6,0x98,0xAD),
     o3(0xE6,0x99,0xB6), o3(0xE6,0x9D,0xBE),
     o3(0xE6,0xA2,0xA2), o3(0xE6,0xA8,0x9F),
     o3(0xE6,0xA8,0xB5), o3(0xE6,0xB2,0xBC),
     o3(0xE6,0xB6,0x88), o3(0xE6,0xB8,0x89),
     o3(0xE6,0xB9,0x98), o3(0xE7,0x84,0xBC),
     o3(0xE7,0x84,0xA6), o3(0xE7,0x85,0xA7),
     o3(0xE7,0x97,0x87), o3(0xE7,0x9C,0x81),
     o3(0xE7,0xA1,0x9D), o3(0xE7,0xA4,0x81),
     o3(0xE7,0xA5,0xA5), o3(0xE7,0xA7,0xB0),
     o3(0xE7,0xAB,0xA0), o3(0xE7,0xAC,0x91),
     o3(0xE7,0xB2,0xA7), o3(0xE7,0xB4,0xB9),
     o3(0xE8,0x82,0x96), o3(0xE8,0x8F,0x96),
     o3(0xE8,0x92,0x8B), o3(0xE8,0x95,0x89),
     o3(0xE8,0xA1,0x9D), o3(0xE8,0xA3,0xB3),
     o3(0xE8,0xA8,0x9F), o3(0xE8,0xA8,0xBC),
     o3(0xE8,0xA9,0x94), o3(0xE8,0xA9,0xB3),
     o3(0xE8,0xB1,0xA1), o3(0xE8,0xB3,0x9E),
     o3(0xE9,0x86,0xA4), o3(0xE9,0x89,0xA6),
     o3(0xE9,0x8D,0xBE), o3(0xE9,0x90,0x98),
     o3(0xE9,0x9A,0x9C), o3(0xE9,0x9E,0x98),
     o3(0xE4,0xB8,0x8A), o3(0xE4,0xB8,0x88),
     o3(0xE4,0xB8,0x9E), o3(0xE4,0xB9,0x97),
     o3(0xE5,0x86,0x97), o3(0xE5,0x89,0xB0),
     o3(0xE5,0x9F,0x8E), o3(0xE5,0xA0,0xB4),
     o3(0xE5,0xA3,0x8C), o3(0xE5,0xAC,0xA2),
     o3(0xE5,0xB8,0xB8), o3(0xE6,0x83,0x85),
     o3(0xE6,0x93,0xBE), o3(0xE6,0x9D,0xA1),
     o3(0xE6,0x9D,0x96), o3(0xE6,0xB5,0x84),
     o3(0xE7,0x8A,0xB6), o3(0xE7,0x95,0xB3),
     o3(0xE7,0xA9,0xA3), o3(0xE8,0x92,0xB8),
     o3(0xE8,0xAD,0xB2), o3(0xE9,0x86,0xB8),
     o3(0xE9,0x8C,0xA0), o3(0xE5,0x98,0xB1),
     o3(0xE5,0x9F,0xB4), o3(0xE9,0xA3,0xBE),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_BE = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_BE_infos
};

static const struct byte_lookup* const
from_EUC_JP_BF_infos[95] = {
     o3(0xE6,0x8B,0xAD), o3(0xE6,0xA4,0x8D),
     o3(0xE6,0xAE,0x96), o3(0xE7,0x87,0xAD),
     o3(0xE7,0xB9,0x94), o3(0xE8,0x81,0xB7),
     o3(0xE8,0x89,0xB2), o3(0xE8,0xA7,0xA6),
     o3(0xE9,0xA3,0x9F), o3(0xE8,0x9D,0x95),
     o3(0xE8,0xBE,0xB1), o3(0xE5,0xB0,0xBB),
     o3(0xE4,0xBC,0xB8), o3(0xE4,0xBF,0xA1),
     o3(0xE4,0xBE,0xB5), o3(0xE5,0x94,0x87),
     o3(0xE5,0xA8,0xA0), o3(0xE5,0xAF,0x9D),
     o3(0xE5,0xAF,0xA9), o3(0xE5,0xBF,0x83),
     o3(0xE6,0x85,0x8E), o3(0xE6,0x8C,0xAF),
     o3(0xE6,0x96,0xB0), o3(0xE6,0x99,0x8B),
     o3(0xE6,0xA3,0xAE), o3(0xE6,0xA6,0x9B),
     o3(0xE6,0xB5,0xB8), o3(0xE6,0xB7,0xB1),
     o3(0xE7,0x94,0xB3), o3(0xE7,0x96,0xB9),
     o3(0xE7,0x9C,0x9F), o3(0xE7,0xA5,0x9E),
     o3(0xE7,0xA7,0xA6), o3(0xE7,0xB4,0xB3),
     o3(0xE8,0x87,0xA3), o3(0xE8,0x8A,0xAF),
     o3(0xE8,0x96,0xAA), o3(0xE8,0xA6,0xAA),
     o3(0xE8,0xA8,0xBA), o3(0xE8,0xBA,0xAB),
     o3(0xE8,0xBE,0x9B), o3(0xE9,0x80,0xB2),
     o3(0xE9,0x87,0x9D), o3(0xE9,0x9C,0x87),
     o3(0xE4,0xBA,0xBA), o3(0xE4,0xBB,0x81),
     o3(0xE5,0x88,0x83), o3(0xE5,0xA1,0xB5),
     o3(0xE5,0xA3,0xAC), o3(0xE5,0xB0,0x8B),
     o3(0xE7,0x94,0x9A), o3(0xE5,0xB0,0xBD),
     o3(0xE8,0x85,0x8E), o3(0xE8,0xA8,0x8A),
     o3(0xE8,0xBF,0x85), o3(0xE9,0x99,0xA3),
     o3(0xE9,0x9D,0xAD), o3(0xE7,0xAC,0xA5),
     o3(0xE8,0xAB,0x8F), o3(0xE9,0xA0,0x88),
     o3(0xE9,0x85,0xA2), o3(0xE5,0x9B,0xB3),
     o3(0xE5,0x8E,0xA8), o3(0xE9,0x80,0x97),
     o3(0xE5,0x90,0xB9), o3(0xE5,0x9E,0x82),
     o3(0xE5,0xB8,0xA5), o3(0xE6,0x8E,0xA8),
     o3(0xE6,0xB0,0xB4), o3(0xE7,0x82,0x8A),
     o3(0xE7,0x9D,0xA1), o3(0xE7,0xB2,0x8B),
     o3(0xE7,0xBF,0xA0), o3(0xE8,0xA1,0xB0),
     o3(0xE9,0x81,0x82), o3(0xE9,0x85,0x94),
     o3(0xE9,0x8C,0x90), o3(0xE9,0x8C,0x98),
     o3(0xE9,0x9A,0x8F), o3(0xE7,0x91,0x9E),
     o3(0xE9,0xAB,0x84), o3(0xE5,0xB4,0x87),
     o3(0xE5,0xB5,0xA9), o3(0xE6,0x95,0xB0),
     o3(0xE6,0x9E,0xA2), o3(0xE8,0xB6,0xA8),
     o3(0xE9,0x9B,0x9B), o3(0xE6,0x8D,0xAE),
     o3(0xE6,0x9D,0x89), o3(0xE6,0xA4,0x99),
     o3(0xE8,0x8F,0x85), o3(0xE9,0xA0,0x97),
     o3(0xE9,0x9B,0x80), o3(0xE8,0xA3,0xBE),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_BF = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_BF_infos
};

static const struct byte_lookup* const
from_EUC_JP_C0_infos[95] = {
     o3(0xE6,0xBE,0x84), o3(0xE6,0x91,0xBA),
     o3(0xE5,0xAF,0xB8), o3(0xE4,0xB8,0x96),
     o3(0xE7,0x80,0xAC), o3(0xE7,0x95,0x9D),
     o3(0xE6,0x98,0xAF), o3(0xE5,0x87,0x84),
     o3(0xE5,0x88,0xB6), o3(0xE5,0x8B,0xA2),
     o3(0xE5,0xA7,0x93), o3(0xE5,0xBE,0x81),
     o3(0xE6,0x80,0xA7), o3(0xE6,0x88,0x90),
     o3(0xE6,0x94,0xBF), o3(0xE6,0x95,0xB4),
     o3(0xE6,0x98,0x9F), o3(0xE6,0x99,0xB4),
     o3(0xE6,0xA3,0xB2), o3(0xE6,0xA0,0x96),
     o3(0xE6,0xAD,0xA3), o3(0xE6,0xB8,0x85),
     o3(0xE7,0x89,0xB2), o3(0xE7,0x94,0x9F),
     o3(0xE7,0x9B,0x9B), o3(0xE7,0xB2,0xBE),
     o3(0xE8,0x81,0x96), o3(0xE5,0xA3,0xB0),
     o3(0xE8,0xA3,0xBD), o3(0xE8,0xA5,0xBF),
     o3(0xE8,0xAA,0xA0), o3(0xE8,0xAA,0x93),
     o3(0xE8,0xAB,0x8B), o3(0xE9,0x80,0x9D),
     o3(0xE9,0x86,0x92), o3(0xE9,0x9D,0x92),
     o3(0xE9,0x9D,0x99), o3(0xE6,0x96,0x89),
     o3(0xE7,0xA8,0x8E), o3(0xE8,0x84,0x86),
     o3(0xE9,0x9A,0xBB), o3(0xE5,0xB8,0xAD),
     o3(0xE6,0x83,0x9C), o3(0xE6,0x88,0x9A),
     o3(0xE6,0x96,0xA5), o3(0xE6,0x98,0x94),
     o3(0xE6,0x9E,0x90), o3(0xE7,0x9F,0xB3),
     o3(0xE7,0xA9,0x8D), o3(0xE7,0xB1,0x8D),
     o3(0xE7,0xB8,0xBE), o3(0xE8,0x84,0x8A),
     o3(0xE8,0xB2,0xAC), o3(0xE8,0xB5,0xA4),
     o3(0xE8,0xB7,0xA1), o3(0xE8,0xB9,0x9F),
     o3(0xE7,0xA2,0xA9), o3(0xE5,0x88,0x87),
     o3(0xE6,0x8B,0x99), o3(0xE6,0x8E,0xA5),
     o3(0xE6,0x91,0x82), o3(0xE6,0x8A,0x98),
     o3(0xE8,0xA8,0xAD), o3(0xE7,0xAA,0x83),
     o3(0xE7,0xAF,0x80), o3(0xE8,0xAA,0xAC),
     o3(0xE9,0x9B,0xAA), o3(0xE7,0xB5,0xB6),
     o3(0xE8,0x88,0x8C), o3(0xE8,0x9D,0x89),
     o3(0xE4,0xBB,0x99), o3(0xE5,0x85,0x88),
     o3(0xE5,0x8D,0x83), o3(0xE5,0x8D,0xA0),
     o3(0xE5,0xAE,0xA3), o3(0xE5,0xB0,0x82),
     o3(0xE5,0xB0,0x96), o3(0xE5,0xB7,0x9D),
     o3(0xE6,0x88,0xA6), o3(0xE6,0x89,0x87),
     o3(0xE6,0x92,0xB0), o3(0xE6,0xA0,0x93),
     o3(0xE6,0xA0,0xB4), o3(0xE6,0xB3,0x89),
     o3(0xE6,0xB5,0x85), o3(0xE6,0xB4,0x97),
     o3(0xE6,0x9F,0x93), o3(0xE6,0xBD,0x9C),
     o3(0xE7,0x85,0x8E), o3(0xE7,0x85,0xBD),
     o3(0xE6,0x97,0x8B), o3(0xE7,0xA9,0xBF),
     o3(0xE7,0xAE,0xAD), o3(0xE7,0xB7,0x9A),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_C0 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_C0_infos
};

static const struct byte_lookup* const
from_EUC_JP_C1_infos[95] = {
     o3(0xE7,0xB9,0x8A), o3(0xE7,0xBE,0xA8),
     o3(0xE8,0x85,0xBA), o3(0xE8,0x88,0x9B),
     o3(0xE8,0x88,0xB9), o3(0xE8,0x96,0xA6),
     o3(0xE8,0xA9,0xAE), o3(0xE8,0xB3,0x8E),
     o3(0xE8,0xB7,0xB5), o3(0xE9,0x81,0xB8),
     o3(0xE9,0x81,0xB7), o3(0xE9,0x8A,0xAD),
     o3(0xE9,0x8A,0x91), o3(0xE9,0x96,0x83),
     o3(0xE9,0xAE,0xAE), o3(0xE5,0x89,0x8D),
     o3(0xE5,0x96,0x84), o3(0xE6,0xBC,0xB8),
     o3(0xE7,0x84,0xB6), o3(0xE5,0x85,0xA8),
     o3(0xE7,0xA6,0x85), o3(0xE7,0xB9,0x95),
     o3(0xE8,0x86,0xB3), o3(0xE7,0xB3,0x8E),
     o3(0xE5,0x99,0x8C), o3(0xE5,0xA1,0x91),
     o3(0xE5,0xB2,0xA8), o3(0xE6,0x8E,0xAA),
     o3(0xE6,0x9B,0xBE), o3(0xE6,0x9B,0xBD),
     o3(0xE6,0xA5,0x9A), o3(0xE7,0x8B,0x99),
     o3(0xE7,0x96,0x8F), o3(0xE7,0x96,0x8E),
     o3(0xE7,0xA4,0x8E), o3(0xE7,0xA5,0x96),
     o3(0xE7,0xA7,0x9F), o3(0xE7,0xB2,0x97),
     o3(0xE7,0xB4,0xA0), o3(0xE7,0xB5,0x84),
     o3(0xE8,0x98,0x87), o3(0xE8,0xA8,0xB4),
     o3(0xE9,0x98,0xBB), o3(0xE9,0x81,0xA1),
     o3(0xE9,0xBC,0xA0), o3(0xE5,0x83,0xA7),
     o3(0xE5,0x89,0xB5), o3(0xE5,0x8F,0x8C),
     o3(0xE5,0x8F,0xA2), o3(0xE5,0x80,0x89),
     o3(0xE5,0x96,0xAA), o3(0xE5,0xA3,0xAE),
     o3(0xE5,0xA5,0x8F), o3(0xE7,0x88,0xBD),
     o3(0xE5,0xAE,0x8B), o3(0xE5,0xB1,0xA4),
     o3(0xE5,0x8C,0x9D), o3(0xE6,0x83,0xA3),
     o3(0xE6,0x83,0xB3), o3(0xE6,0x8D,0x9C),
     o3(0xE6,0x8E,0x83), o3(0xE6,0x8C,0xBF),
     o3(0xE6,0x8E,0xBB), o3(0xE6,0x93,0x8D),
     o3(0xE6,0x97,0xA9), o3(0xE6,0x9B,0xB9),
     o3(0xE5,0xB7,0xA3), o3(0xE6,0xA7,0x8D),
     o3(0xE6,0xA7,0xBD), o3(0xE6,0xBC,0x95),
     o3(0xE7,0x87,0xA5), o3(0xE4,0xBA,0x89),
     o3(0xE7,0x97,0xA9), o3(0xE7,0x9B,0xB8),
     o3(0xE7,0xAA,0x93), o3(0xE7,0xB3,0x9F),
     o3(0xE7,0xB7,0x8F), o3(0xE7,0xB6,0x9C),
     o3(0xE8,0x81,0xA1), o3(0xE8,0x8D,0x89),
     o3(0xE8,0x8D,0x98), o3(0xE8,0x91,0xAC),
     o3(0xE8,0x92,0xBC), o3(0xE8,0x97,0xBB),
     o3(0xE8,0xA3,0x85), o3(0xE8,0xB5,0xB0),
     o3(0xE9,0x80,0x81), o3(0xE9,0x81,0xAD),
     o3(0xE9,0x8E,0x97), o3(0xE9,0x9C,0x9C),
     o3(0xE9,0xA8,0x92), o3(0xE5,0x83,0x8F),
     o3(0xE5,0xA2,0x97), o3(0xE6,0x86,0x8E),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_C1 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_C1_infos
};

static const struct byte_lookup* const
from_EUC_JP_C2_infos[95] = {
     o3(0xE8,0x87,0x93), o3(0xE8,0x94,0xB5),
     o3(0xE8,0xB4,0x88), o3(0xE9,0x80,0xA0),
     o3(0xE4,0xBF,0x83), o3(0xE5,0x81,0xB4),
     o3(0xE5,0x89,0x87), o3(0xE5,0x8D,0xB3),
     o3(0xE6,0x81,0xAF), o3(0xE6,0x8D,0x89),
     o3(0xE6,0x9D,0x9F), o3(0xE6,0xB8,0xAC),
     o3(0xE8,0xB6,0xB3), o3(0xE9,0x80,0x9F),
     o3(0xE4,0xBF,0x97), o3(0xE5,0xB1,0x9E),
     o3(0xE8,0xB3,0x8A), o3(0xE6,0x97,0x8F),
     o3(0xE7,0xB6,0x9A), o3(0xE5,0x8D,0x92),
     o3(0xE8,0xA2,0x96), o3(0xE5,0x85,0xB6),
     o3(0xE6,0x8F,0x83), o3(0xE5,0xAD,0x98),
     o3(0xE5,0xAD,0xAB), o3(0xE5,0xB0,0x8A),
     o3(0xE6,0x90,0x8D), o3(0xE6,0x9D,0x91),
     o3(0xE9,0x81,0x9C), o3(0xE4,0xBB,0x96),
     o3(0xE5,0xA4,0x9A), o3(0xE5,0xA4,0xAA),
     o3(0xE6,0xB1,0xB0), o3(0xE8,0xA9,0x91),
     o3(0xE5,0x94,0xBE), o3(0xE5,0xA0,0x95),
     o3(0xE5,0xA6,0xA5), o3(0xE6,0x83,0xB0),
     o3(0xE6,0x89,0x93), o3(0xE6,0x9F,0x81),
     o3(0xE8,0x88,0xB5), o3(0xE6,0xA5,0x95),
     o3(0xE9,0x99,0x80), o3(0xE9,0xA7,0x84),
     o3(0xE9,0xA8,0xA8), o3(0xE4,0xBD,0x93),
     o3(0xE5,0xA0,0x86), o3(0xE5,0xAF,0xBE),
     o3(0xE8,0x80,0x90), o3(0xE5,0xB2,0xB1),
     o3(0xE5,0xB8,0xAF), o3(0xE5,0xBE,0x85),
     o3(0xE6,0x80,0xA0), o3(0xE6,0x85,0x8B),
     o3(0xE6,0x88,0xB4), o3(0xE6,0x9B,0xBF),
     o3(0xE6,0xB3,0xB0), o3(0xE6,0xBB,0x9E),
     o3(0xE8,0x83,0x8E), o3(0xE8,0x85,0xBF),
     o3(0xE8,0x8B,0x94), o3(0xE8,0xA2,0x8B),
     o3(0xE8,0xB2,0xB8), o3(0xE9,0x80,0x80),
     o3(0xE9,0x80,0xAE), o3(0xE9,0x9A,0x8A),
     o3(0xE9,0xBB,0x9B), o3(0xE9,0xAF,0x9B),
     o3(0xE4,0xBB,0xA3), o3(0xE5,0x8F,0xB0),
     o3(0xE5,0xA4,0xA7), o3(0xE7,0xAC,0xAC),
     o3(0xE9,0x86,0x8D), o3(0xE9,0xA1,0x8C),
     o3(0xE9,0xB7,0xB9), o3(0xE6,0xBB,0x9D),
     o3(0xE7,0x80,0xA7), o3(0xE5,0x8D,0x93),
     o3(0xE5,0x95,0x84), o3(0xE5,0xAE,0x85),
     o3(0xE6,0x89,0x98), o3(0xE6,0x8A,0x9E),
     o3(0xE6,0x8B,0x93), o3(0xE6,0xB2,0xA2),
     o3(0xE6,0xBF,0xAF), o3(0xE7,0x90,0xA2),
     o3(0xE8,0xA8,0x97), o3(0xE9,0x90,0xB8),
     o3(0xE6,0xBF,0x81), o3(0xE8,0xAB,0xBE),
     o3(0xE8,0x8C,0xB8), o3(0xE5,0x87,0xA7),
     o3(0xE8,0x9B,0xB8), o3(0xE5,0x8F,0xAA),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_C2 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_C2_infos
};

static const struct byte_lookup* const
from_EUC_JP_C3_infos[95] = {
     o3(0xE5,0x8F,0xA9), o3(0xE4,0xBD,0x86),
     o3(0xE9,0x81,0x94), o3(0xE8,0xBE,0xB0),
     o3(0xE5,0xA5,0xAA), o3(0xE8,0x84,0xB1),
     o3(0xE5,0xB7,0xBD), o3(0xE7,0xAB,0xAA),
     o3(0xE8,0xBE,0xBF), o3(0xE6,0xA3,0x9A),
     o3(0xE8,0xB0,0xB7), o3(0xE7,0x8B,0xB8),
     o3(0xE9,0xB1,0x88), o3(0xE6,0xA8,0xBD),
     o3(0xE8,0xAA,0xB0), o3(0xE4,0xB8,0xB9),
     o3(0xE5,0x8D,0x98), o3(0xE5,0x98,0x86),
     o3(0xE5,0x9D,0xA6), o3(0xE6,0x8B,0x85),
     o3(0xE6,0x8E,0xA2), o3(0xE6,0x97,0xA6),
     o3(0xE6,0xAD,0x8E), o3(0xE6,0xB7,0xA1),
     o3(0xE6,0xB9,0x9B), o3(0xE7,0x82,0xAD),
     o3(0xE7,0x9F,0xAD), o3(0xE7,0xAB,0xAF),
     o3(0xE7,0xAE,0xAA), o3(0xE7,0xB6,0xBB),
     o3(0xE8,0x80,0xBD), o3(0xE8,0x83,0x86),
     o3(0xE8,0x9B,0x8B), o3(0xE8,0xAA,0x95),
     o3(0xE9,0x8D,0x9B), o3(0xE5,0x9B,0xA3),
     o3(0xE5,0xA3,0x87), o3(0xE5,0xBC,0xBE),
     o3(0xE6,0x96,0xAD), o3(0xE6,0x9A,0x96),
     o3(0xE6,0xAA,0x80), o3(0xE6,0xAE,0xB5),
     o3(0xE7,0x94,0xB7), o3(0xE8,0xAB,0x87),
     o3(0xE5,0x80,0xA4), o3(0xE7,0x9F,0xA5),
     o3(0xE5,0x9C,0xB0), o3(0xE5,0xBC,0x9B),
     o3(0xE6,0x81,0xA5), o3(0xE6,0x99,0xBA),
     o3(0xE6,0xB1,0xA0), o3(0xE7,0x97,0xB4),
     o3(0xE7,0xA8,0x9A), o3(0xE7,0xBD,0xAE),
     o3(0xE8,0x87,0xB4), o3(0xE8,0x9C,0x98),
     o3(0xE9,0x81,0x85), o3(0xE9,0xA6,0xB3),
     o3(0xE7,0xAF,0x89), o3(0xE7,0x95,0x9C),
     o3(0xE7,0xAB,0xB9), o3(0xE7,0xAD,0x91),
     o3(0xE8,0x93,0x84), o3(0xE9,0x80,0x90),
     o3(0xE7,0xA7,0xA9), o3(0xE7,0xAA,0x92),
     o3(0xE8,0x8C,0xB6), o3(0xE5,0xAB,0xA1),
     o3(0xE7,0x9D,0x80), o3(0xE4,0xB8,0xAD),
     o3(0xE4,0xBB,0xB2), o3(0xE5,0xAE,0x99),
     o3(0xE5,0xBF,0xA0), o3(0xE6,0x8A,0xBD),
     o3(0xE6,0x98,0xBC), o3(0xE6,0x9F,0xB1),
     o3(0xE6,0xB3,0xA8), o3(0xE8,0x99,0xAB),
     o3(0xE8,0xA1,0xB7), o3(0xE8,0xA8,0xBB),
     o3(0xE9,0x85,0x8E), o3(0xE9,0x8B,0xB3),
     o3(0xE9,0xA7,0x90), o3(0xE6,0xA8,0x97),
     o3(0xE7,0x80,0xA6), o3(0xE7,0x8C,0xAA),
     o3(0xE8,0x8B,0xA7), o3(0xE8,0x91,0x97),
     o3(0xE8,0xB2,0xAF), o3(0xE4,0xB8,0x81),
     o3(0xE5,0x85,0x86), o3(0xE5,0x87,0x8B),
     o3(0xE5,0x96,0x8B), o3(0xE5,0xAF,0xB5),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_C3 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_C3_infos
};

static const struct byte_lookup* const
from_EUC_JP_C4_infos[95] = {
     o3(0xE5,0xB8,0x96), o3(0xE5,0xB8,0xB3),
     o3(0xE5,0xBA,0x81), o3(0xE5,0xBC,0x94),
     o3(0xE5,0xBC,0xB5), o3(0xE5,0xBD,0xAB),
     o3(0xE5,0xBE,0xB4), o3(0xE6,0x87,0xB2),
     o3(0xE6,0x8C,0x91), o3(0xE6,0x9A,0xA2),
     o3(0xE6,0x9C,0x9D), o3(0xE6,0xBD,0xAE),
     o3(0xE7,0x89,0x92), o3(0xE7,0x94,0xBA),
     o3(0xE7,0x9C,0xBA), o3(0xE8,0x81,0xB4),
     o3(0xE8,0x84,0xB9), o3(0xE8,0x85,0xB8),
     o3(0xE8,0x9D,0xB6), o3(0xE8,0xAA,0xBF),
     o3(0xE8,0xAB,0x9C), o3(0xE8,0xB6,0x85),
     o3(0xE8,0xB7,0xB3), o3(0xE9,0x8A,0x9A),
     o3(0xE9,0x95,0xB7), o3(0xE9,0xA0,0x82),
     o3(0xE9,0xB3,0xA5), o3(0xE5,0x8B,0x85),
     o3(0xE6,0x8D,0x97), o3(0xE7,0x9B,0xB4),
     o3(0xE6,0x9C,0x95), o3(0xE6,0xB2,0x88),
     o3(0xE7,0x8F,0x8D), o3(0xE8,0xB3,0x83),
     o3(0xE9,0x8E,0xAE), o3(0xE9,0x99,0xB3),
     o3(0xE6,0xB4,0xA5), o3(0xE5,0xA2,0x9C),
     o3(0xE6,0xA4,0x8E), o3(0xE6,0xA7,0x8C),
     o3(0xE8,0xBF,0xBD), o3(0xE9,0x8E,0x9A),
     o3(0xE7,0x97,0x9B), o3(0xE9,0x80,0x9A),
     o3(0xE5,0xA1,0x9A), o3(0xE6,0xA0,0x82),
     o3(0xE6,0x8E,0xB4), o3(0xE6,0xA7,0xBB),
     o3(0xE4,0xBD,0x83), o3(0xE6,0xBC,0xAC),
     o3(0xE6,0x9F,0x98), o3(0xE8,0xBE,0xBB),
     o3(0xE8,0x94,0xA6), o3(0xE7,0xB6,0xB4),
     o3(0xE9,0x8D,0x94), o3(0xE6,0xA4,0xBF),
     o3(0xE6,0xBD,0xB0), o3(0xE5,0x9D,0xAA),
     o3(0xE5,0xA3,0xB7), o3(0xE5,0xAC,0xAC),
     o3(0xE7,0xB4,0xAC), o3(0xE7,0x88,0xAA),
     o3(0xE5,0x90,0x8A), o3(0xE9,0x87,0xA3),
     o3(0xE9,0xB6,0xB4), o3(0xE4,0xBA,0xAD),
     o3(0xE4,0xBD,0x8E), o3(0xE5,0x81,0x9C),
     o3(0xE5,0x81,0xB5), o3(0xE5,0x89,0x83),
     o3(0xE8,0xB2,0x9E), o3(0xE5,0x91,0x88),
     o3(0xE5,0xA0,0xA4), o3(0xE5,0xAE,0x9A),
     o3(0xE5,0xB8,0x9D), o3(0xE5,0xBA,0x95),
     o3(0xE5,0xBA,0xAD), o3(0xE5,0xBB,0xB7),
     o3(0xE5,0xBC,0x9F), o3(0xE6,0x82,0x8C),
     o3(0xE6,0x8A,0xB5), o3(0xE6,0x8C,0xBA),
     o3(0xE6,0x8F,0x90), o3(0xE6,0xA2,0xAF),
     o3(0xE6,0xB1,0x80), o3(0xE7,0xA2,0x87),
     o3(0xE7,0xA6,0x8E), o3(0xE7,0xA8,0x8B),
     o3(0xE7,0xB7,0xA0), o3(0xE8,0x89,0x87),
     o3(0xE8,0xA8,0x82), o3(0xE8,0xAB,0xA6),
     o3(0xE8,0xB9,0x84), o3(0xE9,0x80,0x93),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_C4 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_C4_infos
};

static const struct byte_lookup* const
from_EUC_JP_C5_infos[95] = {
     o3(0xE9,0x82,0xB8), o3(0xE9,0x84,0xAD),
     o3(0xE9,0x87,0x98), o3(0xE9,0xBC,0x8E),
     o3(0xE6,0xB3,0xA5), o3(0xE6,0x91,0x98),
     o3(0xE6,0x93,0xA2), o3(0xE6,0x95,0xB5),
     o3(0xE6,0xBB,0xB4), o3(0xE7,0x9A,0x84),
     o3(0xE7,0xAC,0x9B), o3(0xE9,0x81,0xA9),
     o3(0xE9,0x8F,0x91), o3(0xE6,0xBA,0xBA),
     o3(0xE5,0x93,0xB2), o3(0xE5,0xBE,0xB9),
     o3(0xE6,0x92,0xA4), o3(0xE8,0xBD,0x8D),
     o3(0xE8,0xBF,0xAD), o3(0xE9,0x89,0x84),
     o3(0xE5,0x85,0xB8), o3(0xE5,0xA1,0xAB),
     o3(0xE5,0xA4,0xA9), o3(0xE5,0xB1,0x95),
     o3(0xE5,0xBA,0x97), o3(0xE6,0xB7,0xBB),
     o3(0xE7,0xBA,0x8F), o3(0xE7,0x94,0x9C),
     o3(0xE8,0xB2,0xBC), o3(0xE8,0xBB,0xA2),
     o3(0xE9,0xA1,0x9B), o3(0xE7,0x82,0xB9),
     o3(0xE4,0xBC,0x9D), o3(0xE6,0xAE,0xBF),
     o3(0xE6,0xBE,0xB1), o3(0xE7,0x94,0xB0),
     o3(0xE9,0x9B,0xBB), o3(0xE5,0x85,0x8E),
     o3(0xE5,0x90,0x90), o3(0xE5,0xA0,0xB5),
     o3(0xE5,0xA1,0x97), o3(0xE5,0xA6,0xAC),
     o3(0xE5,0xB1,0xA0), o3(0xE5,0xBE,0x92),
     o3(0xE6,0x96,0x97), o3(0xE6,0x9D,0x9C),
     o3(0xE6,0xB8,0xA1), o3(0xE7,0x99,0xBB),
     o3(0xE8,0x8F,0x9F), o3(0xE8,0xB3,0xAD),
     o3(0xE9,0x80,0x94), o3(0xE9,0x83,0xBD),
     o3(0xE9,0x8D,0x8D), o3(0xE7,0xA0,0xA5),
     o3(0xE7,0xA0,0xBA), o3(0xE5,0x8A,0xAA),
     o3(0xE5,0xBA,0xA6), o3(0xE5,0x9C,0x9F),
     o3(0xE5,0xA5,0xB4), o3(0xE6,0x80,0x92),
     o3(0xE5,0x80,0x92), o3(0xE5,0x85,0x9A),
     o3(0xE5,0x86,0xAC), o3(0xE5,0x87,0x8D),
     o3(0xE5,0x88,0x80), o3(0xE5,0x94,0x90),
     o3(0xE5,0xA1,0x94), o3(0xE5,0xA1,0x98),
     o3(0xE5,0xA5,0x97), o3(0xE5,0xAE,0x95),
     o3(0xE5,0xB3,0xB6), o3(0xE5,0xB6,0x8B),
     o3(0xE6,0x82,0xBC), o3(0xE6,0x8A,0x95),
     o3(0xE6,0x90,0xAD), o3(0xE6,0x9D,0xB1),
     o3(0xE6,0xA1,0x83), o3(0xE6,0xA2,0xBC),
     o3(0xE6,0xA3,0x9F), o3(0xE7,0x9B,0x97),
     o3(0xE6,0xB7,0x98), o3(0xE6,0xB9,0xAF),
     o3(0xE6,0xB6,0x9B), o3(0xE7,0x81,0xAF),
     o3(0xE7,0x87,0x88), o3(0xE5,0xBD,0x93),
     o3(0xE7,0x97,0x98), o3(0xE7,0xA5,0xB7),
     o3(0xE7,0xAD,0x89), o3(0xE7,0xAD,0x94),
     o3(0xE7,0xAD,0x92), o3(0xE7,0xB3,0x96),
     o3(0xE7,0xB5,0xB1), o3(0xE5,0x88,0xB0),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_C5 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_C5_infos
};

static const struct byte_lookup* const
from_EUC_JP_C6_infos[95] = {
     o3(0xE8,0x91,0xA3), o3(0xE8,0x95,0xA9),
     o3(0xE8,0x97,0xA4), o3(0xE8,0xA8,0x8E),
     o3(0xE8,0xAC,0x84), o3(0xE8,0xB1,0x86),
     o3(0xE8,0xB8,0x8F), o3(0xE9,0x80,0x83),
     o3(0xE9,0x80,0x8F), o3(0xE9,0x90,0x99),
     o3(0xE9,0x99,0xB6), o3(0xE9,0xA0,0xAD),
     o3(0xE9,0xA8,0xB0), o3(0xE9,0x97,0x98),
     o3(0xE5,0x83,0x8D), o3(0xE5,0x8B,0x95),
     o3(0xE5,0x90,0x8C), o3(0xE5,0xA0,0x82),
     o3(0xE5,0xB0,0x8E), o3(0xE6,0x86,0xA7),
     o3(0xE6,0x92,0x9E), o3(0xE6,0xB4,0x9E),
     o3(0xE7,0x9E,0xB3), o3(0xE7,0xAB,0xA5),
     o3(0xE8,0x83,0xB4), o3(0xE8,0x90,0x84),
     o3(0xE9,0x81,0x93), o3(0xE9,0x8A,0x85),
     o3(0xE5,0xB3,0xA0), o3(0xE9,0xB4,0x87),
     o3(0xE5,0x8C,0xBF), o3(0xE5,0xBE,0x97),
     o3(0xE5,0xBE,0xB3), o3(0xE6,0xB6,0x9C),
     o3(0xE7,0x89,0xB9), o3(0xE7,0x9D,0xA3),
     o3(0xE7,0xA6,0xBF), o3(0xE7,0xAF,0xA4),
     o3(0xE6,0xAF,0x92), o3(0xE7,0x8B,0xAC),
     o3(0xE8,0xAA,0xAD), o3(0xE6,0xA0,0x83),
     o3(0xE6,0xA9,0xA1), o3(0xE5,0x87,0xB8),
     o3(0xE7,0xAA,0x81), o3(0xE6,0xA4,0xB4),
     o3(0xE5,0xB1,0x8A), o3(0xE9,0xB3,0xB6),
     o3(0xE8,0x8B,0xAB), o3(0xE5,0xAF,0x85),
     o3(0xE9,0x85,0x89), o3(0xE7,0x80,0x9E),
     o3(0xE5,0x99,0xB8), o3(0xE5,0xB1,0xAF),
     o3(0xE6,0x83,0x87), o3(0xE6,0x95,0xA6),
     o3(0xE6,0xB2,0x8C), o3(0xE8,0xB1,0x9A),
     o3(0xE9,0x81,0x81), o3(0xE9,0xA0,0x93),
     o3(0xE5,0x91,0x91), o3(0xE6,0x9B,0x87),
     o3(0xE9,0x88,0x8D), o3(0xE5,0xA5,0x88),
     o3(0xE9,0x82,0xA3), o3(0xE5,0x86,0x85),
     o3(0xE4,0xB9,0x8D), o3(0xE5,0x87,0xAA),
     o3(0xE8,0x96,0x99), o3(0xE8,0xAC,0x8E),
     o3(0xE7,0x81,0x98), o3(0xE6,0x8D,0xBA),
     o3(0xE9,0x8D,0x8B), o3(0xE6,0xA5,0xA2),
     o3(0xE9,0xA6,0xB4), o3(0xE7,0xB8,0x84),
     o3(0xE7,0x95,0xB7), o3(0xE5,0x8D,0x97),
     o3(0xE6,0xA5,0xA0), o3(0xE8,0xBB,0x9F),
     o3(0xE9,0x9B,0xA3), o3(0xE6,0xB1,0x9D),
     o3(0xE4,0xBA,0x8C), o3(0xE5,0xB0,0xBC),
     o3(0xE5,0xBC,0x90), o3(0xE8,0xBF,0xA9),
     o3(0xE5,0x8C,0x82), o3(0xE8,0xB3,0x91),
     o3(0xE8,0x82,0x89), o3(0xE8,0x99,0xB9),
     o3(0xE5,0xBB,0xBF), o3(0xE6,0x97,0xA5),
     o3(0xE4,0xB9,0xB3), o3(0xE5,0x85,0xA5),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_C6 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_C6_infos
};

static const struct byte_lookup* const
from_EUC_JP_C7_infos[95] = {
     o3(0xE5,0xA6,0x82), o3(0xE5,0xB0,0xBF),
     o3(0xE9,0x9F,0xAE), o3(0xE4,0xBB,0xBB),
     o3(0xE5,0xA6,0x8A), o3(0xE5,0xBF,0x8D),
     o3(0xE8,0xAA,0x8D), o3(0xE6,0xBF,0xA1),
     o3(0xE7,0xA6,0xB0), o3(0xE7,0xA5,0xA2),
     o3(0xE5,0xAF,0xA7), o3(0xE8,0x91,0xB1),
     o3(0xE7,0x8C,0xAB), o3(0xE7,0x86,0xB1),
     o3(0xE5,0xB9,0xB4), o3(0xE5,0xBF,0xB5),
     o3(0xE6,0x8D,0xBB), o3(0xE6,0x92,0x9A),
     o3(0xE7,0x87,0x83), o3(0xE7,0xB2,0x98),
     o3(0xE4,0xB9,0x83), o3(0xE5,0xBB,0xBC),
     o3(0xE4,0xB9,0x8B), o3(0xE5,0x9F,0x9C),
     o3(0xE5,0x9A,0xA2), o3(0xE6,0x82,0xA9),
     o3(0xE6,0xBF,0x83), o3(0xE7,0xB4,0x8D),
     o3(0xE8,0x83,0xBD), o3(0xE8,0x84,0xB3),
     o3(0xE8,0x86,0xBF), o3(0xE8,0xBE,0xB2),
     o3(0xE8,0xA6,0x97), o3(0xE8,0x9A,0xA4),
     o3(0xE5,0xB7,0xB4), o3(0xE6,0x8A,0x8A),
     o3(0xE6,0x92,0xAD), o3(0xE8,0xA6,0x87),
     o3(0xE6,0x9D,0xB7), o3(0xE6,0xB3,0xA2),
     o3(0xE6,0xB4,0xBE), o3(0xE7,0x90,0xB6),
     o3(0xE7,0xA0,0xB4), o3(0xE5,0xA9,0x86),
     o3(0xE7,0xBD,0xB5), o3(0xE8,0x8A,0xAD),
     o3(0xE9,0xA6,0xAC), o3(0xE4,0xBF,0xB3),
     o3(0xE5,0xBB,0x83), o3(0xE6,0x8B,0x9D),
     o3(0xE6,0x8E,0x92), o3(0xE6,0x95,0x97),
     o3(0xE6,0x9D,0xAF), o3(0xE7,0x9B,0x83),
     o3(0xE7,0x89,0x8C), o3(0xE8,0x83,0x8C),
     o3(0xE8,0x82,0xBA), o3(0xE8,0xBC,0xA9),
     o3(0xE9,0x85,0x8D), o3(0xE5,0x80,0x8D),
     o3(0xE5,0x9F,0xB9), o3(0xE5,0xAA,0x92),
     o3(0xE6,0xA2,0x85), o3(0xE6,0xA5,0xB3),
     o3(0xE7,0x85,0xA4), o3(0xE7,0x8B,0xBD),
     o3(0xE8,0xB2,0xB7), o3(0xE5,0xA3,0xB2),
     o3(0xE8,0xB3,0xA0), o3(0xE9,0x99,0xAA),
     o3(0xE9,0x80,0x99), o3(0xE8,0x9D,0xBF),
     o3(0xE7,0xA7,0xA4), o3(0xE7,0x9F,0xA7),
     o3(0xE8,0x90,0xA9), o3(0xE4,0xBC,0xAF),
     o3(0xE5,0x89,0xA5), o3(0xE5,0x8D,0x9A),
     o3(0xE6,0x8B,0x8D), o3(0xE6,0x9F,0x8F),
     o3(0xE6,0xB3,0x8A), o3(0xE7,0x99,0xBD),
     o3(0xE7,0xAE,0x94), o3(0xE7,0xB2,0x95),
     o3(0xE8,0x88,0xB6), o3(0xE8,0x96,0x84),
     o3(0xE8,0xBF,0xAB), o3(0xE6,0x9B,0x9D),
     o3(0xE6,0xBC,0xA0), o3(0xE7,0x88,0x86),
     o3(0xE7,0xB8,0x9B), o3(0xE8,0x8E,0xAB),
     o3(0xE9,0xA7,0x81), o3(0xE9,0xBA,0xA6),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_C7 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_C7_infos
};

static const struct byte_lookup* const
from_EUC_JP_C8_infos[95] = {
     o3(0xE5,0x87,0xBD), o3(0xE7,0xAE,0xB1),
     o3(0xE7,0xA1,0xB2), o3(0xE7,0xAE,0xB8),
     o3(0xE8,0x82,0x87), o3(0xE7,0xAD,0x88),
     o3(0xE6,0xAB,0xA8), o3(0xE5,0xB9,0xA1),
     o3(0xE8,0x82,0x8C), o3(0xE7,0x95,0x91),
     o3(0xE7,0x95,0xA0), o3(0xE5,0x85,0xAB),
     o3(0xE9,0x89,0xA2), o3(0xE6,0xBA,0x8C),
     o3(0xE7,0x99,0xBA), o3(0xE9,0x86,0x97),
     o3(0xE9,0xAB,0xAA), o3(0xE4,0xBC,0x90),
     o3(0xE7,0xBD,0xB0), o3(0xE6,0x8A,0x9C),
     o3(0xE7,0xAD,0x8F), o3(0xE9,0x96,0xA5),
     o3(0xE9,0xB3,0xA9), o3(0xE5,0x99,0xBA),
     o3(0xE5,0xA1,0x99), o3(0xE8,0x9B,0xA4),
     o3(0xE9,0x9A,0xBC), o3(0xE4,0xBC,0xB4),
     o3(0xE5,0x88,0xA4), o3(0xE5,0x8D,0x8A),
     o3(0xE5,0x8F,0x8D), o3(0xE5,0x8F,0x9B),
     o3(0xE5,0xB8,0x86), o3(0xE6,0x90,0xAC),
     o3(0xE6,0x96,0x91), o3(0xE6,0x9D,0xBF),
     o3(0xE6,0xB0,0xBE), o3(0xE6,0xB1,0x8E),
     o3(0xE7,0x89,0x88), o3(0xE7,0x8A,0xAF),
     o3(0xE7,0x8F,0xAD), o3(0xE7,0x95,0x94),
     o3(0xE7,0xB9,0x81), o3(0xE8,0x88,0xAC),
     o3(0xE8,0x97,0xA9), o3(0xE8,0xB2,0xA9),
     o3(0xE7,0xAF,0x84), o3(0xE9,0x87,0x86),
     o3(0xE7,0x85,0xA9), o3(0xE9,0xA0,0x92),
     o3(0xE9,0xA3,0xAF), o3(0xE6,0x8C,0xBD),
     o3(0xE6,0x99,0xA9), o3(0xE7,0x95,0xAA),
     o3(0xE7,0x9B,0xA4), o3(0xE7,0xA3,0x90),
     o3(0xE8,0x95,0x83), o3(0xE8,0x9B,0xAE),
     o3(0xE5,0x8C,0xAA), o3(0xE5,0x8D,0x91),
     o3(0xE5,0x90,0xA6), o3(0xE5,0xA6,0x83),
     o3(0xE5,0xBA,0x87), o3(0xE5,0xBD,0xBC),
     o3(0xE6,0x82,0xB2), o3(0xE6,0x89,0x89),
     o3(0xE6,0x89,0xB9), o3(0xE6,0x8A,0xAB),
     o3(0xE6,0x96,0x90), o3(0xE6,0xAF,0x94),
     o3(0xE6,0xB3,0x8C), o3(0xE7,0x96,0xB2),
     o3(0xE7,0x9A,0xAE), o3(0xE7,0xA2,0x91),
     o3(0xE7,0xA7,0x98), o3(0xE7,0xB7,0x8B),
     o3(0xE7,0xBD,0xB7), o3(0xE8,0x82,0xA5),
     o3(0xE8,0xA2,0xAB), o3(0xE8,0xAA,0xB9),
     o3(0xE8,0xB2,0xBB), o3(0xE9,0x81,0xBF),
     o3(0xE9,0x9D,0x9E), o3(0xE9,0xA3,0x9B),
     o3(0xE6,0xA8,0x8B), o3(0xE7,0xB0,0xB8),
     o3(0xE5,0x82,0x99), o3(0xE5,0xB0,0xBE),
     o3(0xE5,0xBE,0xAE), o3(0xE6,0x9E,0x87),
     o3(0xE6,0xAF,0x98), o3(0xE7,0x90,0xB5),
     o3(0xE7,0x9C,0x89), o3(0xE7,0xBE,0x8E),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_C8 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_C8_infos
};

static const struct byte_lookup* const
from_EUC_JP_C9_infos[95] = {
     o3(0xE9,0xBC,0xBB), o3(0xE6,0x9F,0x8A),
     o3(0xE7,0xA8,0x97), o3(0xE5,0x8C,0xB9),
     o3(0xE7,0x96,0x8B), o3(0xE9,0xAB,0xAD),
     o3(0xE5,0xBD,0xA6), o3(0xE8,0x86,0x9D),
     o3(0xE8,0x8F,0xB1), o3(0xE8,0x82,0x98),
     o3(0xE5,0xBC,0xBC), o3(0xE5,0xBF,0x85),
     o3(0xE7,0x95,0xA2), o3(0xE7,0xAD,0x86),
     o3(0xE9,0x80,0xBC), o3(0xE6,0xA1,0xA7),
     o3(0xE5,0xA7,0xAB), o3(0xE5,0xAA,0x9B),
     o3(0xE7,0xB4,0x90), o3(0xE7,0x99,0xBE),
     o3(0xE8,0xAC,0xAC), o3(0xE4,0xBF,0xB5),
     o3(0xE5,0xBD,0xAA), o3(0xE6,0xA8,0x99),
     o3(0xE6,0xB0,0xB7), o3(0xE6,0xBC,0x82),
     o3(0xE7,0x93,0xA2), o3(0xE7,0xA5,0xA8),
     o3(0xE8,0xA1,0xA8), o3(0xE8,0xA9,0x95),
     o3(0xE8,0xB1,0xB9), o3(0xE5,0xBB,0x9F),
     o3(0xE6,0x8F,0x8F), o3(0xE7,0x97,0x85),
     o3(0xE7,0xA7,0x92), o3(0xE8,0x8B,0x97),
     o3(0xE9,0x8C,0xA8), o3(0xE9,0x8B,0xB2),
     o3(0xE8,0x92,0x9C), o3(0xE8,0x9B,0xAD),
     o3(0xE9,0xB0,0xAD), o3(0xE5,0x93,0x81),
     o3(0xE5,0xBD,0xAC), o3(0xE6,0x96,0x8C),
     o3(0xE6,0xB5,0x9C), o3(0xE7,0x80,0x95),
     o3(0xE8,0xB2,0xA7), o3(0xE8,0xB3,0x93),
     o3(0xE9,0xA0,0xBB), o3(0xE6,0x95,0x8F),
     o3(0xE7,0x93,0xB6), o3(0xE4,0xB8,0x8D),
     o3(0xE4,0xBB,0x98), o3(0xE5,0x9F,0xA0),
     o3(0xE5,0xA4,0xAB), o3(0xE5,0xA9,0xA6),
     o3(0xE5,0xAF,0x8C), o3(0xE5,0x86,0xA8),
     o3(0xE5,0xB8,0x83), o3(0xE5,0xBA,0x9C),
     o3(0xE6,0x80,0x96), o3(0xE6,0x89,0xB6),
     o3(0xE6,0x95,0xB7), o3(0xE6,0x96,0xA7),
     o3(0xE6,0x99,0xAE), o3(0xE6,0xB5,0xAE),
     o3(0xE7,0x88,0xB6), o3(0xE7,0xAC,0xA6),
     o3(0xE8,0x85,0x90), o3(0xE8,0x86,0x9A),
     o3(0xE8,0x8A,0x99), o3(0xE8,0xAD,0x9C),
     o3(0xE8,0xB2,0xA0), o3(0xE8,0xB3,0xA6),
     o3(0xE8,0xB5,0xB4), o3(0xE9,0x98,0x9C),
     o3(0xE9,0x99,0x84), o3(0xE4,0xBE,0xAE),
     o3(0xE6,0x92,0xAB), o3(0xE6,0xAD,0xA6),
     o3(0xE8,0x88,0x9E), o3(0xE8,0x91,0xA1),
     o3(0xE8,0x95,0xAA), o3(0xE9,0x83,0xA8),
     o3(0xE5,0xB0,0x81), o3(0xE6,0xA5,0x93),
     o3(0xE9,0xA2,0xA8), o3(0xE8,0x91,0xBA),
     o3(0xE8,0x95,0x97), o3(0xE4,0xBC,0x8F),
     o3(0xE5,0x89,0xAF), o3(0xE5,0xBE,0xA9),
     o3(0xE5,0xB9,0x85), o3(0xE6,0x9C,0x8D),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_C9 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_C9_infos
};

static const struct byte_lookup* const
from_EUC_JP_CA_infos[95] = {
     o3(0xE7,0xA6,0x8F), o3(0xE8,0x85,0xB9),
     o3(0xE8,0xA4,0x87), o3(0xE8,0xA6,0x86),
     o3(0xE6,0xB7,0xB5), o3(0xE5,0xBC,0x97),
     o3(0xE6,0x89,0x95), o3(0xE6,0xB2,0xB8),
     o3(0xE4,0xBB,0x8F), o3(0xE7,0x89,0xA9),
     o3(0xE9,0xAE,0x92), o3(0xE5,0x88,0x86),
     o3(0xE5,0x90,0xBB), o3(0xE5,0x99,0xB4),
     o3(0xE5,0xA2,0xB3), o3(0xE6,0x86,0xA4),
     o3(0xE6,0x89,0xAE), o3(0xE7,0x84,0x9A),
     o3(0xE5,0xA5,0xAE), o3(0xE7,0xB2,0x89),
     o3(0xE7,0xB3,0x9E), o3(0xE7,0xB4,0x9B),
     o3(0xE9,0x9B,0xB0), o3(0xE6,0x96,0x87),
     o3(0xE8,0x81,0x9E), o3(0xE4,0xB8,0x99),
     o3(0xE4,0xBD,0xB5), o3(0xE5,0x85,0xB5),
     o3(0xE5,0xA1,0x80), o3(0xE5,0xB9,0xA3),
     o3(0xE5,0xB9,0xB3), o3(0xE5,0xBC,0x8A),
     o3(0xE6,0x9F,0x84), o3(0xE4,0xB8,0xA6),
     o3(0xE8,0x94,0xBD), o3(0xE9,0x96,0x89),
     o3(0xE9,0x99,0x9B), o3(0xE7,0xB1,0xB3),
     o3(0xE9,0xA0,0x81), o3(0xE5,0x83,0xBB),
     o3(0xE5,0xA3,0x81), o3(0xE7,0x99,0x96),
     o3(0xE7,0xA2,0xA7), o3(0xE5,0x88,0xA5),
     o3(0xE7,0x9E,0xA5), o3(0xE8,0x94,0x91),
     o3(0xE7,0xAE,0x86), o3(0xE5,0x81,0x8F),
     o3(0xE5,0xA4,0x89), o3(0xE7,0x89,0x87),
     o3(0xE7,0xAF,0x87), o3(0xE7,0xB7,0xA8),
     o3(0xE8,0xBE,0xBA), o3(0xE8,0xBF,0x94),
     o3(0xE9,0x81,0x8D), o3(0xE4,0xBE,0xBF),
     o3(0xE5,0x8B,0x89), o3(0xE5,0xA8,0xA9),
     o3(0xE5,0xBC,0x81), o3(0xE9,0x9E,0xAD),
     o3(0xE4,0xBF,0x9D), o3(0xE8,0x88,0x97),
     o3(0xE9,0x8B,0xAA), o3(0xE5,0x9C,0x83),
     o3(0xE6,0x8D,0x95), o3(0xE6,0xAD,0xA9),
     o3(0xE7,0x94,0xAB), o3(0xE8,0xA3,0x9C),
     o3(0xE8,0xBC,0x94), o3(0xE7,0xA9,0x82),
     o3(0xE5,0x8B,0x9F), o3(0xE5,0xA2,0x93),
     o3(0xE6,0x85,0x95), o3(0xE6,0x88,0x8A),
     o3(0xE6,0x9A,0xAE), o3(0xE6,0xAF,0x8D),
     o3(0xE7,0xB0,0xBF), o3(0xE8,0x8F,0xA9),
     o3(0xE5,0x80,0xA3), o3(0xE4,0xBF,0xB8),
     o3(0xE5,0x8C,0x85), o3(0xE5,0x91,0x86),
     o3(0xE5,0xA0,0xB1), o3(0xE5,0xA5,0x89),
     o3(0xE5,0xAE,0x9D), o3(0xE5,0xB3,0xB0),
     o3(0xE5,0xB3,0xAF), o3(0xE5,0xB4,0xA9),
     o3(0xE5,0xBA,0x96), o3(0xE6,0x8A,0xB1),
     o3(0xE6,0x8D,0xA7), o3(0xE6,0x94,0xBE),
     o3(0xE6,0x96,0xB9), o3(0xE6,0x9C,0x8B),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_CA = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_CA_infos
};

static const struct byte_lookup* const
from_EUC_JP_CB_infos[95] = {
     o3(0xE6,0xB3,0x95), o3(0xE6,0xB3,0xA1),
     o3(0xE7,0x83,0xB9), o3(0xE7,0xA0,0xB2),
     o3(0xE7,0xB8,0xAB), o3(0xE8,0x83,0x9E),
     o3(0xE8,0x8A,0xB3), o3(0xE8,0x90,0x8C),
     o3(0xE8,0x93,0xAC), o3(0xE8,0x9C,0x82),
     o3(0xE8,0xA4,0x92), o3(0xE8,0xA8,0xAA),
     o3(0xE8,0xB1,0x8A), o3(0xE9,0x82,0xA6),
     o3(0xE9,0x8B,0x92), o3(0xE9,0xA3,0xBD),
     o3(0xE9,0xB3,0xB3), o3(0xE9,0xB5,0xAC),
     o3(0xE4,0xB9,0x8F), o3(0xE4,0xBA,0xA1),
     o3(0xE5,0x82,0x8D), o3(0xE5,0x89,0x96),
     o3(0xE5,0x9D,0x8A), o3(0xE5,0xA6,0xA8),
     o3(0xE5,0xB8,0xBD), o3(0xE5,0xBF,0x98),
     o3(0xE5,0xBF,0x99), o3(0xE6,0x88,0xBF),
     o3(0xE6,0x9A,0xB4), o3(0xE6,0x9C,0x9B),
     o3(0xE6,0x9F,0x90), o3(0xE6,0xA3,0x92),
     o3(0xE5,0x86,0x92), o3(0xE7,0xB4,0xA1),
     o3(0xE8,0x82,0xAA), o3(0xE8,0x86,0xA8),
     o3(0xE8,0xAC,0x80), o3(0xE8,0xB2,0x8C),
     o3(0xE8,0xB2,0xBF), o3(0xE9,0x89,0xBE),
     o3(0xE9,0x98,0xB2), o3(0xE5,0x90,0xA0),
     o3(0xE9,0xA0,0xAC), o3(0xE5,0x8C,0x97),
     o3(0xE5,0x83,0x95), o3(0xE5,0x8D,0x9C),
     o3(0xE5,0xA2,0xA8), o3(0xE6,0x92,0xB2),
     o3(0xE6,0x9C,0xB4), o3(0xE7,0x89,0xA7),
     o3(0xE7,0x9D,0xA6), o3(0xE7,0xA9,0x86),
     o3(0xE9,0x87,0xA6), o3(0xE5,0x8B,0x83),
     o3(0xE6,0xB2,0xA1), o3(0xE6,0xAE,0x86),
     o3(0xE5,0xA0,0x80), o3(0xE5,0xB9,0x8C),
     o3(0xE5,0xA5,0x94), o3(0xE6,0x9C,0xAC),
     o3(0xE7,0xBF,0xBB), o3(0xE5,0x87,0xA1),
     o3(0xE7,0x9B,0x86), o3(0xE6,0x91,0xA9),
     o3(0xE7,0xA3,0xA8), o3(0xE9,0xAD,0x94),
     o3(0xE9,0xBA,0xBB), o3(0xE5,0x9F,0x8B),
     o3(0xE5,0xA6,0xB9), o3(0xE6,0x98,0xA7),
     o3(0xE6,0x9E,0x9A), o3(0xE6,0xAF,0x8E),
     o3(0xE5,0x93,0xA9), o3(0xE6,0xA7,0x99),
     o3(0xE5,0xB9,0x95), o3(0xE8,0x86,0x9C),
     o3(0xE6,0x9E,0x95), o3(0xE9,0xAE,0xAA),
     o3(0xE6,0x9F,0xBE), o3(0xE9,0xB1,0x92),
     o3(0xE6,0xA1,0x9D), o3(0xE4,0xBA,0xA6),
     o3(0xE4,0xBF,0xA3), o3(0xE5,0x8F,0x88),
     o3(0xE6,0x8A,0xB9), o3(0xE6,0x9C,0xAB),
     o3(0xE6,0xB2,0xAB), o3(0xE8,0xBF,0x84),
     o3(0xE4,0xBE,0xAD), o3(0xE7,0xB9,0xAD),
     o3(0xE9,0xBA,0xBF), o3(0xE4,0xB8,0x87),
     o3(0xE6,0x85,0xA2), o3(0xE6,0xBA,0x80),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_CB = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_CB_infos
};

static const struct byte_lookup* const
from_EUC_JP_CC_infos[95] = {
     o3(0xE6,0xBC,0xAB), o3(0xE8,0x94,0x93),
     o3(0xE5,0x91,0xB3), o3(0xE6,0x9C,0xAA),
     o3(0xE9,0xAD,0x85), o3(0xE5,0xB7,0xB3),
     o3(0xE7,0xAE,0x95), o3(0xE5,0xB2,0xAC),
     o3(0xE5,0xAF,0x86), o3(0xE8,0x9C,0x9C),
     o3(0xE6,0xB9,0x8A), o3(0xE8,0x93,0x91),
     o3(0xE7,0xA8,0x94), o3(0xE8,0x84,0x88),
     o3(0xE5,0xA6,0x99), o3(0xE7,0xB2,0x8D),
     o3(0xE6,0xB0,0x91), o3(0xE7,0x9C,0xA0),
     o3(0xE5,0x8B,0x99), o3(0xE5,0xA4,0xA2),
     o3(0xE7,0x84,0xA1), o3(0xE7,0x89,0x9F),
     o3(0xE7,0x9F,0x9B), o3(0xE9,0x9C,0xA7),
     o3(0xE9,0xB5,0xA1), o3(0xE6,0xA4,0x8B),
     o3(0xE5,0xA9,0xBF), o3(0xE5,0xA8,0x98),
     o3(0xE5,0x86,0xA5), o3(0xE5,0x90,0x8D),
     o3(0xE5,0x91,0xBD), o3(0xE6,0x98,0x8E),
     o3(0xE7,0x9B,0x9F), o3(0xE8,0xBF,0xB7),
     o3(0xE9,0x8A,0x98), o3(0xE9,0xB3,0xB4),
     o3(0xE5,0xA7,0xAA), o3(0xE7,0x89,0x9D),
     o3(0xE6,0xBB,0x85), o3(0xE5,0x85,0x8D),
     o3(0xE6,0xA3,0x89), o3(0xE7,0xB6,0xBF),
     o3(0xE7,0xB7,0xAC), o3(0xE9,0x9D,0xA2),
     o3(0xE9,0xBA,0xBA), o3(0xE6,0x91,0xB8),
     o3(0xE6,0xA8,0xA1), o3(0xE8,0x8C,0x82),
     o3(0xE5,0xA6,0x84), o3(0xE5,0xAD,0x9F),
     o3(0xE6,0xAF,0x9B), o3(0xE7,0x8C,0x9B),
     o3(0xE7,0x9B,0xB2), o3(0xE7,0xB6,0xB2),
     o3(0xE8,0x80,0x97), o3(0xE8,0x92,0x99),
     o3(0xE5,0x84,0xB2), o3(0xE6,0x9C,0xA8),
     o3(0xE9,0xBB,0x99), o3(0xE7,0x9B,0xAE),
     o3(0xE6,0x9D,0xA2), o3(0xE5,0x8B,0xBF),
     o3(0xE9,0xA4,0x85), o3(0xE5,0xB0,0xA4),
     o3(0xE6,0x88,0xBB), o3(0xE7,0xB1,0xBE),
     o3(0xE8,0xB2,0xB0), o3(0xE5,0x95,0x8F),
     o3(0xE6,0x82,0xB6), o3(0xE7,0xB4,0x8B),
     o3(0xE9,0x96,0x80), o3(0xE5,0x8C,0x81),
     o3(0xE4,0xB9,0x9F), o3(0xE5,0x86,0xB6),
     o3(0xE5,0xA4,0x9C), o3(0xE7,0x88,0xBA),
     o3(0xE8,0x80,0xB6), o3(0xE9,0x87,0x8E),
     o3(0xE5,0xBC,0xA5), o3(0xE7,0x9F,0xA2),
     o3(0xE5,0x8E,0x84), o3(0xE5,0xBD,0xB9),
     o3(0xE7,0xB4,0x84), o3(0xE8,0x96,0xAC),
     o3(0xE8,0xA8,0xB3), o3(0xE8,0xBA,0x8D),
     o3(0xE9,0x9D,0x96), o3(0xE6,0x9F,0xB3),
     o3(0xE8,0x96,0xAE), o3(0xE9,0x91,0x93),
     o3(0xE6,0x84,0x89), o3(0xE6,0x84,0x88),
     o3(0xE6,0xB2,0xB9), o3(0xE7,0x99,0x92),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_CC = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_CC_infos
};

static const struct byte_lookup* const
from_EUC_JP_CD_infos[95] = {
     o3(0xE8,0xAB,0xAD), o3(0xE8,0xBC,0xB8),
     o3(0xE5,0x94,0xAF), o3(0xE4,0xBD,0x91),
     o3(0xE5,0x84,0xAA), o3(0xE5,0x8B,0x87),
     o3(0xE5,0x8F,0x8B), o3(0xE5,0xAE,0xA5),
     o3(0xE5,0xB9,0xBD), o3(0xE6,0x82,0xA0),
     o3(0xE6,0x86,0x82), o3(0xE6,0x8F,0x96),
     o3(0xE6,0x9C,0x89), o3(0xE6,0x9F,0x9A),
     o3(0xE6,0xB9,0xA7), o3(0xE6,0xB6,0x8C),
     o3(0xE7,0x8C,0xB6), o3(0xE7,0x8C,0xB7),
     o3(0xE7,0x94,0xB1), o3(0xE7,0xA5,0x90),
     o3(0xE8,0xA3,0x95), o3(0xE8,0xAA,0x98),
     o3(0xE9,0x81,0x8A), o3(0xE9,0x82,0x91),
     o3(0xE9,0x83,0xB5), o3(0xE9,0x9B,0x84),
     o3(0xE8,0x9E,0x8D), o3(0xE5,0xA4,0x95),
     o3(0xE4,0xBA,0x88), o3(0xE4,0xBD,0x99),
     o3(0xE4,0xB8,0x8E), o3(0xE8,0xAA,0x89),
     o3(0xE8,0xBC,0xBF), o3(0xE9,0xA0,0x90),
     o3(0xE5,0x82,0xAD), o3(0xE5,0xB9,0xBC),
     o3(0xE5,0xA6,0x96), o3(0xE5,0xAE,0xB9),
     o3(0xE5,0xBA,0xB8), o3(0xE6,0x8F,0x9A),
     o3(0xE6,0x8F,0xBA), o3(0xE6,0x93,0x81),
     o3(0xE6,0x9B,0x9C), o3(0xE6,0xA5,0x8A),
     o3(0xE6,0xA7,0x98), o3(0xE6,0xB4,0x8B),
     o3(0xE6,0xBA,0xB6), o3(0xE7,0x86,0x94),
     o3(0xE7,0x94,0xA8), o3(0xE7,0xAA,0xAF),
     o3(0xE7,0xBE,0x8A), o3(0xE8,0x80,0x80),
     o3(0xE8,0x91,0x89), o3(0xE8,0x93,0x89),
     o3(0xE8,0xA6,0x81), o3(0xE8,0xAC,0xA1),
     o3(0xE8,0xB8,0x8A), o3(0xE9,0x81,0xA5),
     o3(0xE9,0x99,0xBD), o3(0xE9,0xA4,0x8A),
     o3(0xE6,0x85,0xBE), o3(0xE6,0x8A,0x91),
     o3(0xE6,0xAC,0xB2), o3(0xE6,0xB2,0x83),
     o3(0xE6,0xB5,0xB4), o3(0xE7,0xBF,0x8C),
     o3(0xE7,0xBF,0xBC), o3(0xE6,0xB7,0x80),
     o3(0xE7,0xBE,0x85), o3(0xE8,0x9E,0xBA),
     o3(0xE8,0xA3,0xB8), o3(0xE6,0x9D,0xA5),
     o3(0xE8,0x8E,0xB1), o3(0xE9,0xA0,0xBC),
     o3(0xE9,0x9B,0xB7), o3(0xE6,0xB4,0x9B),
     o3(0xE7,0xB5,0xA1), o3(0xE8,0x90,0xBD),
     o3(0xE9,0x85,0xAA), o3(0xE4,0xB9,0xB1),
     o3(0xE5,0x8D,0xB5), o3(0xE5,0xB5,0x90),
     o3(0xE6,0xAC,0x84), o3(0xE6,0xBF,0xAB),
     o3(0xE8,0x97,0x8D), o3(0xE8,0x98,0xAD),
     o3(0xE8,0xA6,0xA7), o3(0xE5,0x88,0xA9),
     o3(0xE5,0x90,0x8F), o3(0xE5,0xB1,0xA5),
     o3(0xE6,0x9D,0x8E), o3(0xE6,0xA2,0xA8),
     o3(0xE7,0x90,0x86), o3(0xE7,0x92,0x83),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_CD = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_CD_infos
};

static const struct byte_lookup* const
from_EUC_JP_CE_infos[95] = {
     o3(0xE7,0x97,0xA2), o3(0xE8,0xA3,0x8F),
     o3(0xE8,0xA3,0xA1), o3(0xE9,0x87,0x8C),
     o3(0xE9,0x9B,0xA2), o3(0xE9,0x99,0xB8),
     o3(0xE5,0xBE,0x8B), o3(0xE7,0x8E,0x87),
     o3(0xE7,0xAB,0x8B), o3(0xE8,0x91,0x8E),
     o3(0xE6,0x8E,0xA0), o3(0xE7,0x95,0xA5),
     o3(0xE5,0x8A,0x89), o3(0xE6,0xB5,0x81),
     o3(0xE6,0xBA,0x9C), o3(0xE7,0x90,0x89),
     o3(0xE7,0x95,0x99), o3(0xE7,0xA1,0xAB),
     o3(0xE7,0xB2,0x92), o3(0xE9,0x9A,0x86),
     o3(0xE7,0xAB,0x9C), o3(0xE9,0xBE,0x8D),
     o3(0xE4,0xBE,0xB6), o3(0xE6,0x85,0xAE),
     o3(0xE6,0x97,0x85), o3(0xE8,0x99,0x9C),
     o3(0xE4,0xBA,0x86), o3(0xE4,0xBA,0xAE),
     o3(0xE5,0x83,0x9A), o3(0xE4,0xB8,0xA1),
     o3(0xE5,0x87,0x8C), o3(0xE5,0xAF,0xAE),
     o3(0xE6,0x96,0x99), o3(0xE6,0xA2,0x81),
     o3(0xE6,0xB6,0xBC), o3(0xE7,0x8C,0x9F),
     o3(0xE7,0x99,0x82), o3(0xE7,0x9E,0xAD),
     o3(0xE7,0xA8,0x9C), o3(0xE7,0xB3,0xA7),
     o3(0xE8,0x89,0xAF), o3(0xE8,0xAB,0x92),
     o3(0xE9,0x81,0xBC), o3(0xE9,0x87,0x8F),
     o3(0xE9,0x99,0xB5), o3(0xE9,0xA0,0x98),
     o3(0xE5,0x8A,0x9B), o3(0xE7,0xB7,0x91),
     o3(0xE5,0x80,0xAB), o3(0xE5,0x8E,0x98),
     o3(0xE6,0x9E,0x97), o3(0xE6,0xB7,0x8B),
     o3(0xE7,0x87,0x90), o3(0xE7,0x90,0xB3),
     o3(0xE8,0x87,0xA8), o3(0xE8,0xBC,0xAA),
     o3(0xE9,0x9A,0xA3), o3(0xE9,0xB1,0x97),
     o3(0xE9,0xBA,0x9F), o3(0xE7,0x91,0xA0),
     o3(0xE5,0xA1,0x81), o3(0xE6,0xB6,0x99),
     o3(0xE7,0xB4,0xAF), o3(0xE9,0xA1,0x9E),
     o3(0xE4,0xBB,0xA4), o3(0xE4,0xBC,0xB6),
     o3(0xE4,0xBE,0x8B), o3(0xE5,0x86,0xB7),
     o3(0xE5,0x8A,0xB1), o3(0xE5,0xB6,0xBA),
     o3(0xE6,0x80,0x9C), o3(0xE7,0x8E,0xB2),
     o3(0xE7,0xA4,0xBC), o3(0xE8,0x8B,0x93),
     o3(0xE9,0x88,0xB4), o3(0xE9,0x9A,0xB7),
     o3(0xE9,0x9B,0xB6), o3(0xE9,0x9C,0x8A),
     o3(0xE9,0xBA,0x97), o3(0xE9,0xBD,0xA2),
     o3(0xE6,0x9A,0xA6), o3(0xE6,0xAD,0xB4),
     o3(0xE5,0x88,0x97), o3(0xE5,0x8A,0xA3),
     o3(0xE7,0x83,0x88), o3(0xE8,0xA3,0x82),
     o3(0xE5,0xBB,0x89), o3(0xE6,0x81,0x8B),
     o3(0xE6,0x86,0x90), o3(0xE6,0xBC,0xA3),
     o3(0xE7,0x85,0x89), o3(0xE7,0xB0,0xBE),
     o3(0xE7,0xB7,0xB4), o3(0xE8,0x81,0xAF),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_CE = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_CE_infos
};

static const unsigned char
from_EUC_JP_CF_offsets[256] = {
     51, 51, 51, 51, 51, 51, 51, 51,   51, 51, 51, 51, 51, 51, 51, 51,
     51, 51, 51, 51, 51, 51, 51, 51,   51, 51, 51, 51, 51, 51, 51, 51,
     51, 51, 51, 51, 51, 51, 51, 51,   51, 51, 51, 51, 51, 51, 51, 51,
     51, 51, 51, 51, 51, 51, 51, 51,   51, 51, 51, 51, 51, 51, 51, 51,
     51, 51, 51, 51, 51, 51, 51, 51,   51, 51, 51, 51, 51, 51, 51, 51,
     51, 51, 51, 51, 51, 51, 51, 51,   51, 51, 51, 51, 51, 51, 51, 51,
     51, 51, 51, 51, 51, 51, 51, 51,   51, 51, 51, 51, 51, 51, 51, 51,
     51, 51, 51, 51, 51, 51, 51, 51,   51, 51, 51, 51, 51, 51, 51, 51,
     51, 51, 51, 51, 51, 51, 51, 51,   51, 51, 51, 51, 51, 51, 51, 51,
     51, 51, 51, 51, 51, 51, 51, 51,   51, 51, 51, 51, 51, 51, 51, 51,
     51,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,   23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,   39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 51, 51, 51,   51, 51, 51, 51, 51, 51, 51, 51,
     51, 51, 51, 51, 51, 51, 51, 51,   51, 51, 51, 51, 51, 51, 51, 51,
     51, 51, 51, 51, 51, 51, 51, 51,   51, 51, 51, 51, 51, 51, 51, 51,
};
static const struct byte_lookup* const
from_EUC_JP_CF_infos[52] = {
     o3(0xE8,0x93,0xAE), o3(0xE9,0x80,0xA3),
     o3(0xE9,0x8C,0xAC), o3(0xE5,0x91,0x82),
     o3(0xE9,0xAD,0xAF), o3(0xE6,0xAB,0x93),
     o3(0xE7,0x82,0x89), o3(0xE8,0xB3,0x82),
     o3(0xE8,0xB7,0xAF), o3(0xE9,0x9C,0xB2),
     o3(0xE5,0x8A,0xB4), o3(0xE5,0xA9,0x81),
     o3(0xE5,0xBB,0x8A), o3(0xE5,0xBC,0x84),
     o3(0xE6,0x9C,0x97), o3(0xE6,0xA5,0xBC),
     o3(0xE6,0xA6,0x94), o3(0xE6,0xB5,0xAA),
     o3(0xE6,0xBC,0x8F), o3(0xE7,0x89,0xA2),
     o3(0xE7,0x8B,0xBC), o3(0xE7,0xAF,0xAD),
     o3(0xE8,0x80,0x81), o3(0xE8,0x81,0xBE),
     o3(0xE8,0x9D,0x8B), o3(0xE9,0x83,0x8E),
     o3(0xE5,0x85,0xAD), o3(0xE9,0xBA,0x93),
     o3(0xE7,0xA6,0x84), o3(0xE8,0x82,0x8B),
     o3(0xE9,0x8C,0xB2), o3(0xE8,0xAB,0x96),
     o3(0xE5,0x80,0xAD), o3(0xE5,0x92,0x8C),
     o3(0xE8,0xA9,0xB1), o3(0xE6,0xAD,0xAA),
     o3(0xE8,0xB3,0x84), o3(0xE8,0x84,0x87),
     o3(0xE6,0x83,0x91), o3(0xE6,0x9E,0xA0),
     o3(0xE9,0xB7,0xB2), o3(0xE4,0xBA,0x99),
     o3(0xE4,0xBA,0x98), o3(0xE9,0xB0,0x90),
     o3(0xE8,0xA9,0xAB), o3(0xE8,0x97,0x81),
     o3(0xE8,0x95,0xA8), o3(0xE6,0xA4,0x80),
     o3(0xE6,0xB9,0xBE), o3(0xE7,0xA2,0x97),
     o3(0xE8,0x85,0x95),              UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_CF = {
    from_EUC_JP_CF_offsets,
    from_EUC_JP_CF_infos
};

static const struct byte_lookup* const
from_EUC_JP_D0_infos[95] = {
     o3(0xE5,0xBC,0x8C), o3(0xE4,0xB8,0x90),
     o3(0xE4,0xB8,0x95), o3(0xE4,0xB8,0xAA),
     o3(0xE4,0xB8,0xB1), o3(0xE4,0xB8,0xB6),
     o3(0xE4,0xB8,0xBC), o3(0xE4,0xB8,0xBF),
     o3(0xE4,0xB9,0x82), o3(0xE4,0xB9,0x96),
     o3(0xE4,0xB9,0x98), o3(0xE4,0xBA,0x82),
     o3(0xE4,0xBA,0x85), o3(0xE8,0xB1,0xAB),
     o3(0xE4,0xBA,0x8A), o3(0xE8,0x88,0x92),
     o3(0xE5,0xBC,0x8D), o3(0xE4,0xBA,0x8E),
     o3(0xE4,0xBA,0x9E), o3(0xE4,0xBA,0x9F),
     o3(0xE4,0xBA,0xA0), o3(0xE4,0xBA,0xA2),
     o3(0xE4,0xBA,0xB0), o3(0xE4,0xBA,0xB3),
     o3(0xE4,0xBA,0xB6), o3(0xE4,0xBB,0x8E),
     o3(0xE4,0xBB,0x8D), o3(0xE4,0xBB,0x84),
     o3(0xE4,0xBB,0x86), o3(0xE4,0xBB,0x82),
     o3(0xE4,0xBB,0x97), o3(0xE4,0xBB,0x9E),
     o3(0xE4,0xBB,0xAD), o3(0xE4,0xBB,0x9F),
     o3(0xE4,0xBB,0xB7), o3(0xE4,0xBC,0x89),
     o3(0xE4,0xBD,0x9A), o3(0xE4,0xBC,0xB0),
     o3(0xE4,0xBD,0x9B), o3(0xE4,0xBD,0x9D),
     o3(0xE4,0xBD,0x97), o3(0xE4,0xBD,0x87),
     o3(0xE4,0xBD,0xB6), o3(0xE4,0xBE,0x88),
     o3(0xE4,0xBE,0x8F), o3(0xE4,0xBE,0x98),
     o3(0xE4,0xBD,0xBB), o3(0xE4,0xBD,0xA9),
     o3(0xE4,0xBD,0xB0), o3(0xE4,0xBE,0x91),
     o3(0xE4,0xBD,0xAF), o3(0xE4,0xBE,0x86),
     o3(0xE4,0xBE,0x96), o3(0xE5,0x84,0x98),
     o3(0xE4,0xBF,0x94), o3(0xE4,0xBF,0x9F),
     o3(0xE4,0xBF,0x8E), o3(0xE4,0xBF,0x98),
     o3(0xE4,0xBF,0x9B), o3(0xE4,0xBF,0x91),
     o3(0xE4,0xBF,0x9A), o3(0xE4,0xBF,0x90),
     o3(0xE4,0xBF,0xA4), o3(0xE4,0xBF,0xA5),
     o3(0xE5,0x80,0x9A), o3(0xE5,0x80,0xA8),
     o3(0xE5,0x80,0x94), o3(0xE5,0x80,0xAA),
     o3(0xE5,0x80,0xA5), o3(0xE5,0x80,0x85),
     o3(0xE4,0xBC,0x9C), o3(0xE4,0xBF,0xB6),
     o3(0xE5,0x80,0xA1), o3(0xE5,0x80,0xA9),
     o3(0xE5,0x80,0xAC), o3(0xE4,0xBF,0xBE),
     o3(0xE4,0xBF,0xAF), o3(0xE5,0x80,0x91),
     o3(0xE5,0x80,0x86), o3(0xE5,0x81,0x83),
     o3(0xE5,0x81,0x87), o3(0xE6,0x9C,0x83),
     o3(0xE5,0x81,0x95), o3(0xE5,0x81,0x90),
     o3(0xE5,0x81,0x88), o3(0xE5,0x81,0x9A),
     o3(0xE5,0x81,0x96), o3(0xE5,0x81,0xAC),
     o3(0xE5,0x81,0xB8), o3(0xE5,0x82,0x80),
     o3(0xE5,0x82,0x9A), o3(0xE5,0x82,0x85),
     o3(0xE5,0x82,0xB4), o3(0xE5,0x82,0xB2),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_D0 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_D0_infos
};

static const struct byte_lookup* const
from_EUC_JP_D1_infos[95] = {
     o3(0xE5,0x83,0x89), o3(0xE5,0x83,0x8A),
     o3(0xE5,0x82,0xB3), o3(0xE5,0x83,0x82),
     o3(0xE5,0x83,0x96), o3(0xE5,0x83,0x9E),
     o3(0xE5,0x83,0xA5), o3(0xE5,0x83,0xAD),
     o3(0xE5,0x83,0xA3), o3(0xE5,0x83,0xAE),
     o3(0xE5,0x83,0xB9), o3(0xE5,0x83,0xB5),
     o3(0xE5,0x84,0x89), o3(0xE5,0x84,0x81),
     o3(0xE5,0x84,0x82), o3(0xE5,0x84,0x96),
     o3(0xE5,0x84,0x95), o3(0xE5,0x84,0x94),
     o3(0xE5,0x84,0x9A), o3(0xE5,0x84,0xA1),
     o3(0xE5,0x84,0xBA), o3(0xE5,0x84,0xB7),
     o3(0xE5,0x84,0xBC), o3(0xE5,0x84,0xBB),
     o3(0xE5,0x84,0xBF), o3(0xE5,0x85,0x80),
     o3(0xE5,0x85,0x92), o3(0xE5,0x85,0x8C),
     o3(0xE5,0x85,0x94), o3(0xE5,0x85,0xA2),
     o3(0xE7,0xAB,0xB8), o3(0xE5,0x85,0xA9),
     o3(0xE5,0x85,0xAA), o3(0xE5,0x85,0xAE),
     o3(0xE5,0x86,0x80), o3(0xE5,0x86,0x82),
     o3(0xE5,0x9B,0x98), o3(0xE5,0x86,0x8C),
     o3(0xE5,0x86,0x89), o3(0xE5,0x86,0x8F),
     o3(0xE5,0x86,0x91), o3(0xE5,0x86,0x93),
     o3(0xE5,0x86,0x95), o3(0xE5,0x86,0x96),
     o3(0xE5,0x86,0xA4), o3(0xE5,0x86,0xA6),
     o3(0xE5,0x86,0xA2), o3(0xE5,0x86,0xA9),
     o3(0xE5,0x86,0xAA), o3(0xE5,0x86,0xAB),
     o3(0xE5,0x86,0xB3), o3(0xE5,0x86,0xB1),
     o3(0xE5,0x86,0xB2), o3(0xE5,0x86,0xB0),
     o3(0xE5,0x86,0xB5), o3(0xE5,0x86,0xBD),
     o3(0xE5,0x87,0x85), o3(0xE5,0x87,0x89),
     o3(0xE5,0x87,0x9B), o3(0xE5,0x87,0xA0),
     o3(0xE8,0x99,0x95), o3(0xE5,0x87,0xA9),
     o3(0xE5,0x87,0xAD), o3(0xE5,0x87,0xB0),
     o3(0xE5,0x87,0xB5), o3(0xE5,0x87,0xBE),
     o3(0xE5,0x88,0x84), o3(0xE5,0x88,0x8B),
     o3(0xE5,0x88,0x94), o3(0xE5,0x88,0x8E),
     o3(0xE5,0x88,0xA7), o3(0xE5,0x88,0xAA),
     o3(0xE5,0x88,0xAE), o3(0xE5,0x88,0xB3),
     o3(0xE5,0x88,0xB9), o3(0xE5,0x89,0x8F),
     o3(0xE5,0x89,0x84), o3(0xE5,0x89,0x8B),
     o3(0xE5,0x89,0x8C), o3(0xE5,0x89,0x9E),
     o3(0xE5,0x89,0x94), o3(0xE5,0x89,0xAA),
     o3(0xE5,0x89,0xB4), o3(0xE5,0x89,0xA9),
     o3(0xE5,0x89,0xB3), o3(0xE5,0x89,0xBF),
     o3(0xE5,0x89,0xBD), o3(0xE5,0x8A,0x8D),
     o3(0xE5,0x8A,0x94), o3(0xE5,0x8A,0x92),
     o3(0xE5,0x89,0xB1), o3(0xE5,0x8A,0x88),
     o3(0xE5,0x8A,0x91), o3(0xE8,0xBE,0xA8),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_D1 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_D1_infos
};

static const struct byte_lookup* const
from_EUC_JP_D2_infos[95] = {
     o3(0xE8,0xBE,0xA7), o3(0xE5,0x8A,0xAC),
     o3(0xE5,0x8A,0xAD), o3(0xE5,0x8A,0xBC),
     o3(0xE5,0x8A,0xB5), o3(0xE5,0x8B,0x81),
     o3(0xE5,0x8B,0x8D), o3(0xE5,0x8B,0x97),
     o3(0xE5,0x8B,0x9E), o3(0xE5,0x8B,0xA3),
     o3(0xE5,0x8B,0xA6), o3(0xE9,0xA3,0xAD),
     o3(0xE5,0x8B,0xA0), o3(0xE5,0x8B,0xB3),
     o3(0xE5,0x8B,0xB5), o3(0xE5,0x8B,0xB8),
     o3(0xE5,0x8B,0xB9), o3(0xE5,0x8C,0x86),
     o3(0xE5,0x8C,0x88), o3(0xE7,0x94,0xB8),
     o3(0xE5,0x8C,0x8D), o3(0xE5,0x8C,0x90),
     o3(0xE5,0x8C,0x8F), o3(0xE5,0x8C,0x95),
     o3(0xE5,0x8C,0x9A), o3(0xE5,0x8C,0xA3),
     o3(0xE5,0x8C,0xAF), o3(0xE5,0x8C,0xB1),
     o3(0xE5,0x8C,0xB3), o3(0xE5,0x8C,0xB8),
     o3(0xE5,0x8D,0x80), o3(0xE5,0x8D,0x86),
     o3(0xE5,0x8D,0x85), o3(0xE4,0xB8,0x97),
     o3(0xE5,0x8D,0x89), o3(0xE5,0x8D,0x8D),
     o3(0xE5,0x87,0x96), o3(0xE5,0x8D,0x9E),
     o3(0xE5,0x8D,0xA9), o3(0xE5,0x8D,0xAE),
     o3(0xE5,0xA4,0x98), o3(0xE5,0x8D,0xBB),
     o3(0xE5,0x8D,0xB7), o3(0xE5,0x8E,0x82),
     o3(0xE5,0x8E,0x96), o3(0xE5,0x8E,0xA0),
     o3(0xE5,0x8E,0xA6), o3(0xE5,0x8E,0xA5),
     o3(0xE5,0x8E,0xAE), o3(0xE5,0x8E,0xB0),
     o3(0xE5,0x8E,0xB6), o3(0xE5,0x8F,0x83),
     o3(0xE7,0xB0,0x92), o3(0xE9,0x9B,0x99),
     o3(0xE5,0x8F,0x9F), o3(0xE6,0x9B,0xBC),
     o3(0xE7,0x87,0xAE), o3(0xE5,0x8F,0xAE),
     o3(0xE5,0x8F,0xA8), o3(0xE5,0x8F,0xAD),
     o3(0xE5,0x8F,0xBA), o3(0xE5,0x90,0x81),
     o3(0xE5,0x90,0xBD), o3(0xE5,0x91,0x80),
     o3(0xE5,0x90,0xAC), o3(0xE5,0x90,0xAD),
     o3(0xE5,0x90,0xBC), o3(0xE5,0x90,0xAE),
     o3(0xE5,0x90,0xB6), o3(0xE5,0x90,0xA9),
     o3(0xE5,0x90,0x9D), o3(0xE5,0x91,0x8E),
     o3(0xE5,0x92,0x8F), o3(0xE5,0x91,0xB5),
     o3(0xE5,0x92,0x8E), o3(0xE5,0x91,0x9F),
     o3(0xE5,0x91,0xB1), o3(0xE5,0x91,0xB7),
     o3(0xE5,0x91,0xB0), o3(0xE5,0x92,0x92),
     o3(0xE5,0x91,0xBB), o3(0xE5,0x92,0x80),
     o3(0xE5,0x91,0xB6), o3(0xE5,0x92,0x84),
     o3(0xE5,0x92,0x90), o3(0xE5,0x92,0x86),
     o3(0xE5,0x93,0x87), o3(0xE5,0x92,0xA2),
     o3(0xE5,0x92,0xB8), o3(0xE5,0x92,0xA5),
     o3(0xE5,0x92,0xAC), o3(0xE5,0x93,0x84),
     o3(0xE5,0x93,0x88), o3(0xE5,0x92,0xA8),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_D2 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_D2_infos
};

static const struct byte_lookup* const
from_EUC_JP_D3_infos[95] = {
     o3(0xE5,0x92,0xAB), o3(0xE5,0x93,0x82),
     o3(0xE5,0x92,0xA4), o3(0xE5,0x92,0xBE),
     o3(0xE5,0x92,0xBC), o3(0xE5,0x93,0x98),
     o3(0xE5,0x93,0xA5), o3(0xE5,0x93,0xA6),
     o3(0xE5,0x94,0x8F), o3(0xE5,0x94,0x94),
     o3(0xE5,0x93,0xBD), o3(0xE5,0x93,0xAE),
     o3(0xE5,0x93,0xAD), o3(0xE5,0x93,0xBA),
     o3(0xE5,0x93,0xA2), o3(0xE5,0x94,0xB9),
     o3(0xE5,0x95,0x80), o3(0xE5,0x95,0xA3),
     o3(0xE5,0x95,0x8C), o3(0xE5,0x94,0xAE),
     o3(0xE5,0x95,0x9C), o3(0xE5,0x95,0x85),
     o3(0xE5,0x95,0x96), o3(0xE5,0x95,0x97),
     o3(0xE5,0x94,0xB8), o3(0xE5,0x94,0xB3),
     o3(0xE5,0x95,0x9D), o3(0xE5,0x96,0x99),
     o3(0xE5,0x96,0x80), o3(0xE5,0x92,0xAF),
     o3(0xE5,0x96,0x8A), o3(0xE5,0x96,0x9F),
     o3(0xE5,0x95,0xBB), o3(0xE5,0x95,0xBE),
     o3(0xE5,0x96,0x98), o3(0xE5,0x96,0x9E),
     o3(0xE5,0x96,0xAE), o3(0xE5,0x95,0xBC),
     o3(0xE5,0x96,0x83), o3(0xE5,0x96,0xA9),
     o3(0xE5,0x96,0x87), o3(0xE5,0x96,0xA8),
     o3(0xE5,0x97,0x9A), o3(0xE5,0x97,0x85),
     o3(0xE5,0x97,0x9F), o3(0xE5,0x97,0x84),
     o3(0xE5,0x97,0x9C), o3(0xE5,0x97,0xA4),
     o3(0xE5,0x97,0x94), o3(0xE5,0x98,0x94),
     o3(0xE5,0x97,0xB7), o3(0xE5,0x98,0x96),
     o3(0xE5,0x97,0xBE), o3(0xE5,0x97,0xBD),
     o3(0xE5,0x98,0x9B), o3(0xE5,0x97,0xB9),
     o3(0xE5,0x99,0x8E), o3(0xE5,0x99,0x90),
     o3(0xE7,0x87,0x9F), o3(0xE5,0x98,0xB4),
     o3(0xE5,0x98,0xB6), o3(0xE5,0x98,0xB2),
     o3(0xE5,0x98,0xB8), o3(0xE5,0x99,0xAB),
     o3(0xE5,0x99,0xA4), o3(0xE5,0x98,0xAF),
     o3(0xE5,0x99,0xAC), o3(0xE5,0x99,0xAA),
     o3(0xE5,0x9A,0x86), o3(0xE5,0x9A,0x80),
     o3(0xE5,0x9A,0x8A), o3(0xE5,0x9A,0xA0),
     o3(0xE5,0x9A,0x94), o3(0xE5,0x9A,0x8F),
     o3(0xE5,0x9A,0xA5), o3(0xE5,0x9A,0xAE),
     o3(0xE5,0x9A,0xB6), o3(0xE5,0x9A,0xB4),
     o3(0xE5,0x9B,0x82), o3(0xE5,0x9A,0xBC),
     o3(0xE5,0x9B,0x81), o3(0xE5,0x9B,0x83),
     o3(0xE5,0x9B,0x80), o3(0xE5,0x9B,0x88),
     o3(0xE5,0x9B,0x8E), o3(0xE5,0x9B,0x91),
     o3(0xE5,0x9B,0x93), o3(0xE5,0x9B,0x97),
     o3(0xE5,0x9B,0xAE), o3(0xE5,0x9B,0xB9),
     o3(0xE5,0x9C,0x80), o3(0xE5,0x9B,0xBF),
     o3(0xE5,0x9C,0x84), o3(0xE5,0x9C,0x89),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_D3 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_D3_infos
};

static const struct byte_lookup* const
from_EUC_JP_D4_infos[95] = {
     o3(0xE5,0x9C,0x88), o3(0xE5,0x9C,0x8B),
     o3(0xE5,0x9C,0x8D), o3(0xE5,0x9C,0x93),
     o3(0xE5,0x9C,0x98), o3(0xE5,0x9C,0x96),
     o3(0xE5,0x97,0x87), o3(0xE5,0x9C,0x9C),
     o3(0xE5,0x9C,0xA6), o3(0xE5,0x9C,0xB7),
     o3(0xE5,0x9C,0xB8), o3(0xE5,0x9D,0x8E),
     o3(0xE5,0x9C,0xBB), o3(0xE5,0x9D,0x80),
     o3(0xE5,0x9D,0x8F), o3(0xE5,0x9D,0xA9),
     o3(0xE5,0x9F,0x80), o3(0xE5,0x9E,0x88),
     o3(0xE5,0x9D,0xA1), o3(0xE5,0x9D,0xBF),
     o3(0xE5,0x9E,0x89), o3(0xE5,0x9E,0x93),
     o3(0xE5,0x9E,0xA0), o3(0xE5,0x9E,0xB3),
     o3(0xE5,0x9E,0xA4), o3(0xE5,0x9E,0xAA),
     o3(0xE5,0x9E,0xB0), o3(0xE5,0x9F,0x83),
     o3(0xE5,0x9F,0x86), o3(0xE5,0x9F,0x94),
     o3(0xE5,0x9F,0x92), o3(0xE5,0x9F,0x93),
     o3(0xE5,0xA0,0x8A), o3(0xE5,0x9F,0x96),
     o3(0xE5,0x9F,0xA3), o3(0xE5,0xA0,0x8B),
     o3(0xE5,0xA0,0x99), o3(0xE5,0xA0,0x9D),
     o3(0xE5,0xA1,0xB2), o3(0xE5,0xA0,0xA1),
     o3(0xE5,0xA1,0xA2), o3(0xE5,0xA1,0x8B),
     o3(0xE5,0xA1,0xB0), o3(0xE6,0xAF,0x80),
     o3(0xE5,0xA1,0x92), o3(0xE5,0xA0,0xBD),
     o3(0xE5,0xA1,0xB9), o3(0xE5,0xA2,0x85),
     o3(0xE5,0xA2,0xB9), o3(0xE5,0xA2,0x9F),
     o3(0xE5,0xA2,0xAB), o3(0xE5,0xA2,0xBA),
     o3(0xE5,0xA3,0x9E), o3(0xE5,0xA2,0xBB),
     o3(0xE5,0xA2,0xB8), o3(0xE5,0xA2,0xAE),
     o3(0xE5,0xA3,0x85), o3(0xE5,0xA3,0x93),
     o3(0xE5,0xA3,0x91), o3(0xE5,0xA3,0x97),
     o3(0xE5,0xA3,0x99), o3(0xE5,0xA3,0x98),
     o3(0xE5,0xA3,0xA5), o3(0xE5,0xA3,0x9C),
     o3(0xE5,0xA3,0xA4), o3(0xE5,0xA3,0x9F),
     o3(0xE5,0xA3,0xAF), o3(0xE5,0xA3,0xBA),
     o3(0xE5,0xA3,0xB9), o3(0xE5,0xA3,0xBB),
     o3(0xE5,0xA3,0xBC), o3(0xE5,0xA3,0xBD),
     o3(0xE5,0xA4,0x82), o3(0xE5,0xA4,0x8A),
     o3(0xE5,0xA4,0x90), o3(0xE5,0xA4,0x9B),
     o3(0xE6,0xA2,0xA6), o3(0xE5,0xA4,0xA5),
     o3(0xE5,0xA4,0xAC), o3(0xE5,0xA4,0xAD),
     o3(0xE5,0xA4,0xB2), o3(0xE5,0xA4,0xB8),
     o3(0xE5,0xA4,0xBE), o3(0xE7,0xAB,0x92),
     o3(0xE5,0xA5,0x95), o3(0xE5,0xA5,0x90),
     o3(0xE5,0xA5,0x8E), o3(0xE5,0xA5,0x9A),
     o3(0xE5,0xA5,0x98), o3(0xE5,0xA5,0xA2),
     o3(0xE5,0xA5,0xA0), o3(0xE5,0xA5,0xA7),
     o3(0xE5,0xA5,0xAC), o3(0xE5,0xA5,0xA9),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_D4 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_D4_infos
};

static const struct byte_lookup* const
from_EUC_JP_D5_infos[95] = {
     o3(0xE5,0xA5,0xB8), o3(0xE5,0xA6,0x81),
     o3(0xE5,0xA6,0x9D), o3(0xE4,0xBD,0x9E),
     o3(0xE4,0xBE,0xAB), o3(0xE5,0xA6,0xA3),
     o3(0xE5,0xA6,0xB2), o3(0xE5,0xA7,0x86),
     o3(0xE5,0xA7,0xA8), o3(0xE5,0xA7,0x9C),
     o3(0xE5,0xA6,0x8D), o3(0xE5,0xA7,0x99),
     o3(0xE5,0xA7,0x9A), o3(0xE5,0xA8,0xA5),
     o3(0xE5,0xA8,0x9F), o3(0xE5,0xA8,0x91),
     o3(0xE5,0xA8,0x9C), o3(0xE5,0xA8,0x89),
     o3(0xE5,0xA8,0x9A), o3(0xE5,0xA9,0x80),
     o3(0xE5,0xA9,0xAC), o3(0xE5,0xA9,0x89),
     o3(0xE5,0xA8,0xB5), o3(0xE5,0xA8,0xB6),
     o3(0xE5,0xA9,0xA2), o3(0xE5,0xA9,0xAA),
     o3(0xE5,0xAA,0x9A), o3(0xE5,0xAA,0xBC),
     o3(0xE5,0xAA,0xBE), o3(0xE5,0xAB,0x8B),
     o3(0xE5,0xAB,0x82), o3(0xE5,0xAA,0xBD),
     o3(0xE5,0xAB,0xA3), o3(0xE5,0xAB,0x97),
     o3(0xE5,0xAB,0xA6), o3(0xE5,0xAB,0xA9),
     o3(0xE5,0xAB,0x96), o3(0xE5,0xAB,0xBA),
     o3(0xE5,0xAB,0xBB), o3(0xE5,0xAC,0x8C),
     o3(0xE5,0xAC,0x8B), o3(0xE5,0xAC,0x96),
     o3(0xE5,0xAC,0xB2), o3(0xE5,0xAB,0x90),
     o3(0xE5,0xAC,0xAA), o3(0xE5,0xAC,0xB6),
     o3(0xE5,0xAC,0xBE), o3(0xE5,0xAD,0x83),
     o3(0xE5,0xAD,0x85), o3(0xE5,0xAD,0x80),
     o3(0xE5,0xAD,0x91), o3(0xE5,0xAD,0x95),
     o3(0xE5,0xAD,0x9A), o3(0xE5,0xAD,0x9B),
     o3(0xE5,0xAD,0xA5), o3(0xE5,0xAD,0xA9),
     o3(0xE5,0xAD,0xB0), o3(0xE5,0xAD,0xB3),
     o3(0xE5,0xAD,0xB5), o3(0xE5,0xAD,0xB8),
     o3(0xE6,0x96,0x88), o3(0xE5,0xAD,0xBA),
     o3(0xE5,0xAE,0x80), o3(0xE5,0xAE,0x83),
     o3(0xE5,0xAE,0xA6), o3(0xE5,0xAE,0xB8),
     o3(0xE5,0xAF,0x83), o3(0xE5,0xAF,0x87),
     o3(0xE5,0xAF,0x89), o3(0xE5,0xAF,0x94),
     o3(0xE5,0xAF,0x90), o3(0xE5,0xAF,0xA4),
     o3(0xE5,0xAF,0xA6), o3(0xE5,0xAF,0xA2),
     o3(0xE5,0xAF,0x9E), o3(0xE5,0xAF,0xA5),
     o3(0xE5,0xAF,0xAB), o3(0xE5,0xAF,0xB0),
     o3(0xE5,0xAF,0xB6), o3(0xE5,0xAF,0xB3),
     o3(0xE5,0xB0,0x85), o3(0xE5,0xB0,0x87),
     o3(0xE5,0xB0,0x88), o3(0xE5,0xB0,0x8D),
     o3(0xE5,0xB0,0x93), o3(0xE5,0xB0,0xA0),
     o3(0xE5,0xB0,0xA2), o3(0xE5,0xB0,0xA8),
     o3(0xE5,0xB0,0xB8), o3(0xE5,0xB0,0xB9),
     o3(0xE5,0xB1,0x81), o3(0xE5,0xB1,0x86),
     o3(0xE5,0xB1,0x8E), o3(0xE5,0xB1,0x93),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_D5 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_D5_infos
};

static const struct byte_lookup* const
from_EUC_JP_D6_infos[95] = {
     o3(0xE5,0xB1,0x90), o3(0xE5,0xB1,0x8F),
     o3(0xE5,0xAD,0xB1), o3(0xE5,0xB1,0xAC),
     o3(0xE5,0xB1,0xAE), o3(0xE4,0xB9,0xA2),
     o3(0xE5,0xB1,0xB6), o3(0xE5,0xB1,0xB9),
     o3(0xE5,0xB2,0x8C), o3(0xE5,0xB2,0x91),
     o3(0xE5,0xB2,0x94), o3(0xE5,0xA6,0x9B),
     o3(0xE5,0xB2,0xAB), o3(0xE5,0xB2,0xBB),
     o3(0xE5,0xB2,0xB6), o3(0xE5,0xB2,0xBC),
     o3(0xE5,0xB2,0xB7), o3(0xE5,0xB3,0x85),
     o3(0xE5,0xB2,0xBE), o3(0xE5,0xB3,0x87),
     o3(0xE5,0xB3,0x99), o3(0xE5,0xB3,0xA9),
     o3(0xE5,0xB3,0xBD), o3(0xE5,0xB3,0xBA),
     o3(0xE5,0xB3,0xAD), o3(0xE5,0xB6,0x8C),
     o3(0xE5,0xB3,0xAA), o3(0xE5,0xB4,0x8B),
     o3(0xE5,0xB4,0x95), o3(0xE5,0xB4,0x97),
     o3(0xE5,0xB5,0x9C), o3(0xE5,0xB4,0x9F),
     o3(0xE5,0xB4,0x9B), o3(0xE5,0xB4,0x91),
     o3(0xE5,0xB4,0x94), o3(0xE5,0xB4,0xA2),
     o3(0xE5,0xB4,0x9A), o3(0xE5,0xB4,0x99),
     o3(0xE5,0xB4,0x98), o3(0xE5,0xB5,0x8C),
     o3(0xE5,0xB5,0x92), o3(0xE5,0xB5,0x8E),
     o3(0xE5,0xB5,0x8B), o3(0xE5,0xB5,0xAC),
     o3(0xE5,0xB5,0xB3), o3(0xE5,0xB5,0xB6),
     o3(0xE5,0xB6,0x87), o3(0xE5,0xB6,0x84),
     o3(0xE5,0xB6,0x82), o3(0xE5,0xB6,0xA2),
     o3(0xE5,0xB6,0x9D), o3(0xE5,0xB6,0xAC),
     o3(0xE5,0xB6,0xAE), o3(0xE5,0xB6,0xBD),
     o3(0xE5,0xB6,0x90), o3(0xE5,0xB6,0xB7),
     o3(0xE5,0xB6,0xBC), o3(0xE5,0xB7,0x89),
     o3(0xE5,0xB7,0x8D), o3(0xE5,0xB7,0x93),
     o3(0xE5,0xB7,0x92), o3(0xE5,0xB7,0x96),
     o3(0xE5,0xB7,0x9B), o3(0xE5,0xB7,0xAB),
     o3(0xE5,0xB7,0xB2), o3(0xE5,0xB7,0xB5),
     o3(0xE5,0xB8,0x8B), o3(0xE5,0xB8,0x9A),
     o3(0xE5,0xB8,0x99), o3(0xE5,0xB8,0x91),
     o3(0xE5,0xB8,0x9B), o3(0xE5,0xB8,0xB6),
     o3(0xE5,0xB8,0xB7), o3(0xE5,0xB9,0x84),
     o3(0xE5,0xB9,0x83), o3(0xE5,0xB9,0x80),
     o3(0xE5,0xB9,0x8E), o3(0xE5,0xB9,0x97),
     o3(0xE5,0xB9,0x94), o3(0xE5,0xB9,0x9F),
     o3(0xE5,0xB9,0xA2), o3(0xE5,0xB9,0xA4),
     o3(0xE5,0xB9,0x87), o3(0xE5,0xB9,0xB5),
     o3(0xE5,0xB9,0xB6), o3(0xE5,0xB9,0xBA),
     o3(0xE9,0xBA,0xBC), o3(0xE5,0xB9,0xBF),
     o3(0xE5,0xBA,0xA0), o3(0xE5,0xBB,0x81),
     o3(0xE5,0xBB,0x82), o3(0xE5,0xBB,0x88),
     o3(0xE5,0xBB,0x90), o3(0xE5,0xBB,0x8F),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_D6 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_D6_infos
};

static const struct byte_lookup* const
from_EUC_JP_D7_infos[95] = {
     o3(0xE5,0xBB,0x96), o3(0xE5,0xBB,0xA3),
     o3(0xE5,0xBB,0x9D), o3(0xE5,0xBB,0x9A),
     o3(0xE5,0xBB,0x9B), o3(0xE5,0xBB,0xA2),
     o3(0xE5,0xBB,0xA1), o3(0xE5,0xBB,0xA8),
     o3(0xE5,0xBB,0xA9), o3(0xE5,0xBB,0xAC),
     o3(0xE5,0xBB,0xB1), o3(0xE5,0xBB,0xB3),
     o3(0xE5,0xBB,0xB0), o3(0xE5,0xBB,0xB4),
     o3(0xE5,0xBB,0xB8), o3(0xE5,0xBB,0xBE),
     o3(0xE5,0xBC,0x83), o3(0xE5,0xBC,0x89),
     o3(0xE5,0xBD,0x9D), o3(0xE5,0xBD,0x9C),
     o3(0xE5,0xBC,0x8B), o3(0xE5,0xBC,0x91),
     o3(0xE5,0xBC,0x96), o3(0xE5,0xBC,0xA9),
     o3(0xE5,0xBC,0xAD), o3(0xE5,0xBC,0xB8),
     o3(0xE5,0xBD,0x81), o3(0xE5,0xBD,0x88),
     o3(0xE5,0xBD,0x8C), o3(0xE5,0xBD,0x8E),
     o3(0xE5,0xBC,0xAF), o3(0xE5,0xBD,0x91),
     o3(0xE5,0xBD,0x96), o3(0xE5,0xBD,0x97),
     o3(0xE5,0xBD,0x99), o3(0xE5,0xBD,0xA1),
     o3(0xE5,0xBD,0xAD), o3(0xE5,0xBD,0xB3),
     o3(0xE5,0xBD,0xB7), o3(0xE5,0xBE,0x83),
     o3(0xE5,0xBE,0x82), o3(0xE5,0xBD,0xBF),
     o3(0xE5,0xBE,0x8A), o3(0xE5,0xBE,0x88),
     o3(0xE5,0xBE,0x91), o3(0xE5,0xBE,0x87),
     o3(0xE5,0xBE,0x9E), o3(0xE5,0xBE,0x99),
     o3(0xE5,0xBE,0x98), o3(0xE5,0xBE,0xA0),
     o3(0xE5,0xBE,0xA8), o3(0xE5,0xBE,0xAD),
     o3(0xE5,0xBE,0xBC), o3(0xE5,0xBF,0x96),
     o3(0xE5,0xBF,0xBB), o3(0xE5,0xBF,0xA4),
     o3(0xE5,0xBF,0xB8), o3(0xE5,0xBF,0xB1),
     o3(0xE5,0xBF,0x9D), o3(0xE6,0x82,0xB3),
     o3(0xE5,0xBF,0xBF), o3(0xE6,0x80,0xA1),
     o3(0xE6,0x81,0xA0), o3(0xE6,0x80,0x99),
     o3(0xE6,0x80,0x90), o3(0xE6,0x80,0xA9),
     o3(0xE6,0x80,0x8E), o3(0xE6,0x80,0xB1),
     o3(0xE6,0x80,0x9B), o3(0xE6,0x80,0x95),
     o3(0xE6,0x80,0xAB), o3(0xE6,0x80,0xA6),
     o3(0xE6,0x80,0x8F), o3(0xE6,0x80,0xBA),
     o3(0xE6,0x81,0x9A), o3(0xE6,0x81,0x81),
     o3(0xE6,0x81,0xAA), o3(0xE6,0x81,0xB7),
     o3(0xE6,0x81,0x9F), o3(0xE6,0x81,0x8A),
     o3(0xE6,0x81,0x86), o3(0xE6,0x81,0x8D),
     o3(0xE6,0x81,0xA3), o3(0xE6,0x81,0x83),
     o3(0xE6,0x81,0xA4), o3(0xE6,0x81,0x82),
     o3(0xE6,0x81,0xAC), o3(0xE6,0x81,0xAB),
     o3(0xE6,0x81,0x99), o3(0xE6,0x82,0x81),
     o3(0xE6,0x82,0x8D), o3(0xE6,0x83,0xA7),
     o3(0xE6,0x82,0x83), o3(0xE6,0x82,0x9A),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_D7 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_D7_infos
};

static const struct byte_lookup* const
from_EUC_JP_D8_infos[95] = {
     o3(0xE6,0x82,0x84), o3(0xE6,0x82,0x9B),
     o3(0xE6,0x82,0x96), o3(0xE6,0x82,0x97),
     o3(0xE6,0x82,0x92), o3(0xE6,0x82,0xA7),
     o3(0xE6,0x82,0x8B), o3(0xE6,0x83,0xA1),
     o3(0xE6,0x82,0xB8), o3(0xE6,0x83,0xA0),
     o3(0xE6,0x83,0x93), o3(0xE6,0x82,0xB4),
     o3(0xE5,0xBF,0xB0), o3(0xE6,0x82,0xBD),
     o3(0xE6,0x83,0x86), o3(0xE6,0x82,0xB5),
     o3(0xE6,0x83,0x98), o3(0xE6,0x85,0x8D),
     o3(0xE6,0x84,0x95), o3(0xE6,0x84,0x86),
     o3(0xE6,0x83,0xB6), o3(0xE6,0x83,0xB7),
     o3(0xE6,0x84,0x80), o3(0xE6,0x83,0xB4),
     o3(0xE6,0x83,0xBA), o3(0xE6,0x84,0x83),
     o3(0xE6,0x84,0xA1), o3(0xE6,0x83,0xBB),
     o3(0xE6,0x83,0xB1), o3(0xE6,0x84,0x8D),
     o3(0xE6,0x84,0x8E), o3(0xE6,0x85,0x87),
     o3(0xE6,0x84,0xBE), o3(0xE6,0x84,0xA8),
     o3(0xE6,0x84,0xA7), o3(0xE6,0x85,0x8A),
     o3(0xE6,0x84,0xBF), o3(0xE6,0x84,0xBC),
     o3(0xE6,0x84,0xAC), o3(0xE6,0x84,0xB4),
     o3(0xE6,0x84,0xBD), o3(0xE6,0x85,0x82),
     o3(0xE6,0x85,0x84), o3(0xE6,0x85,0xB3),
     o3(0xE6,0x85,0xB7), o3(0xE6,0x85,0x98),
     o3(0xE6,0x85,0x99), o3(0xE6,0x85,0x9A),
     o3(0xE6,0x85,0xAB), o3(0xE6,0x85,0xB4),
     o3(0xE6,0x85,0xAF), o3(0xE6,0x85,0xA5),
     o3(0xE6,0x85,0xB1), o3(0xE6,0x85,0x9F),
     o3(0xE6,0x85,0x9D), o3(0xE6,0x85,0x93),
     o3(0xE6,0x85,0xB5), o3(0xE6,0x86,0x99),
     o3(0xE6,0x86,0x96), o3(0xE6,0x86,0x87),
     o3(0xE6,0x86,0xAC), o3(0xE6,0x86,0x94),
     o3(0xE6,0x86,0x9A), o3(0xE6,0x86,0x8A),
     o3(0xE6,0x86,0x91), o3(0xE6,0x86,0xAB),
     o3(0xE6,0x86,0xAE), o3(0xE6,0x87,0x8C),
     o3(0xE6,0x87,0x8A), o3(0xE6,0x87,0x89),
     o3(0xE6,0x87,0xB7), o3(0xE6,0x87,0x88),
     o3(0xE6,0x87,0x83), o3(0xE6,0x87,0x86),
     o3(0xE6,0x86,0xBA), o3(0xE6,0x87,0x8B),
     o3(0xE7,0xBD,0xB9), o3(0xE6,0x87,0x8D),
     o3(0xE6,0x87,0xA6), o3(0xE6,0x87,0xA3),
     o3(0xE6,0x87,0xB6), o3(0xE6,0x87,0xBA),
     o3(0xE6,0x87,0xB4), o3(0xE6,0x87,0xBF),
     o3(0xE6,0x87,0xBD), o3(0xE6,0x87,0xBC),
     o3(0xE6,0x87,0xBE), o3(0xE6,0x88,0x80),
     o3(0xE6,0x88,0x88), o3(0xE6,0x88,0x89),
     o3(0xE6,0x88,0x8D), o3(0xE6,0x88,0x8C),
     o3(0xE6,0x88,0x94), o3(0xE6,0x88,0x9B),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_D8 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_D8_infos
};

static const struct byte_lookup* const
from_EUC_JP_D9_infos[95] = {
     o3(0xE6,0x88,0x9E), o3(0xE6,0x88,0xA1),
     o3(0xE6,0x88,0xAA), o3(0xE6,0x88,0xAE),
     o3(0xE6,0x88,0xB0), o3(0xE6,0x88,0xB2),
     o3(0xE6,0x88,0xB3), o3(0xE6,0x89,0x81),
     o3(0xE6,0x89,0x8E), o3(0xE6,0x89,0x9E),
     o3(0xE6,0x89,0xA3), o3(0xE6,0x89,0x9B),
     o3(0xE6,0x89,0xA0), o3(0xE6,0x89,0xA8),
     o3(0xE6,0x89,0xBC), o3(0xE6,0x8A,0x82),
     o3(0xE6,0x8A,0x89), o3(0xE6,0x89,0xBE),
     o3(0xE6,0x8A,0x92), o3(0xE6,0x8A,0x93),
     o3(0xE6,0x8A,0x96), o3(0xE6,0x8B,0x94),
     o3(0xE6,0x8A,0x83), o3(0xE6,0x8A,0x94),
     o3(0xE6,0x8B,0x97), o3(0xE6,0x8B,0x91),
     o3(0xE6,0x8A,0xBB), o3(0xE6,0x8B,0x8F),
     o3(0xE6,0x8B,0xBF), o3(0xE6,0x8B,0x86),
     o3(0xE6,0x93,0x94), o3(0xE6,0x8B,0x88),
     o3(0xE6,0x8B,0x9C), o3(0xE6,0x8B,0x8C),
     o3(0xE6,0x8B,0x8A), o3(0xE6,0x8B,0x82),
     o3(0xE6,0x8B,0x87), o3(0xE6,0x8A,0x9B),
     o3(0xE6,0x8B,0x89), o3(0xE6,0x8C,0x8C),
     o3(0xE6,0x8B,0xAE), o3(0xE6,0x8B,0xB1),
     o3(0xE6,0x8C,0xA7), o3(0xE6,0x8C,0x82),
     o3(0xE6,0x8C,0x88), o3(0xE6,0x8B,0xAF),
     o3(0xE6,0x8B,0xB5), o3(0xE6,0x8D,0x90),
     o3(0xE6,0x8C,0xBE), o3(0xE6,0x8D,0x8D),
     o3(0xE6,0x90,0x9C), o3(0xE6,0x8D,0x8F),
     o3(0xE6,0x8E,0x96), o3(0xE6,0x8E,0x8E),
     o3(0xE6,0x8E,0x80), o3(0xE6,0x8E,0xAB),
     o3(0xE6,0x8D,0xB6), o3(0xE6,0x8E,0xA3),
     o3(0xE6,0x8E,0x8F), o3(0xE6,0x8E,0x89),
     o3(0xE6,0x8E,0x9F), o3(0xE6,0x8E,0xB5),
     o3(0xE6,0x8D,0xAB), o3(0xE6,0x8D,0xA9),
     o3(0xE6,0x8E,0xBE), o3(0xE6,0x8F,0xA9),
     o3(0xE6,0x8F,0x80), o3(0xE6,0x8F,0x86),
     o3(0xE6,0x8F,0xA3), o3(0xE6,0x8F,0x89),
     o3(0xE6,0x8F,0x92), o3(0xE6,0x8F,0xB6),
     o3(0xE6,0x8F,0x84), o3(0xE6,0x90,0x96),
     o3(0xE6,0x90,0xB4), o3(0xE6,0x90,0x86),
     o3(0xE6,0x90,0x93), o3(0xE6,0x90,0xA6),
     o3(0xE6,0x90,0xB6), o3(0xE6,0x94,0x9D),
     o3(0xE6,0x90,0x97), o3(0xE6,0x90,0xA8),
     o3(0xE6,0x90,0x8F), o3(0xE6,0x91,0xA7),
     o3(0xE6,0x91,0xAF), o3(0xE6,0x91,0xB6),
     o3(0xE6,0x91,0x8E), o3(0xE6,0x94,0xAA),
     o3(0xE6,0x92,0x95), o3(0xE6,0x92,0x93),
     o3(0xE6,0x92,0xA5), o3(0xE6,0x92,0xA9),
     o3(0xE6,0x92,0x88), o3(0xE6,0x92,0xBC),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_D9 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_D9_infos
};

static const struct byte_lookup* const
from_EUC_JP_DA_infos[95] = {
     o3(0xE6,0x93,0x9A), o3(0xE6,0x93,0x92),
     o3(0xE6,0x93,0x85), o3(0xE6,0x93,0x87),
     o3(0xE6,0x92,0xBB), o3(0xE6,0x93,0x98),
     o3(0xE6,0x93,0x82), o3(0xE6,0x93,0xB1),
     o3(0xE6,0x93,0xA7), o3(0xE8,0x88,0x89),
     o3(0xE6,0x93,0xA0), o3(0xE6,0x93,0xA1),
     o3(0xE6,0x8A,0xAC), o3(0xE6,0x93,0xA3),
     o3(0xE6,0x93,0xAF), o3(0xE6,0x94,0xAC),
     o3(0xE6,0x93,0xB6), o3(0xE6,0x93,0xB4),
     o3(0xE6,0x93,0xB2), o3(0xE6,0x93,0xBA),
     o3(0xE6,0x94,0x80), o3(0xE6,0x93,0xBD),
     o3(0xE6,0x94,0x98), o3(0xE6,0x94,0x9C),
     o3(0xE6,0x94,0x85), o3(0xE6,0x94,0xA4),
     o3(0xE6,0x94,0xA3), o3(0xE6,0x94,0xAB),
     o3(0xE6,0x94,0xB4), o3(0xE6,0x94,0xB5),
     o3(0xE6,0x94,0xB7), o3(0xE6,0x94,0xB6),
     o3(0xE6,0x94,0xB8), o3(0xE7,0x95,0x8B),
     o3(0xE6,0x95,0x88), o3(0xE6,0x95,0x96),
     o3(0xE6,0x95,0x95), o3(0xE6,0x95,0x8D),
     o3(0xE6,0x95,0x98), o3(0xE6,0x95,0x9E),
     o3(0xE6,0x95,0x9D), o3(0xE6,0x95,0xB2),
     o3(0xE6,0x95,0xB8), o3(0xE6,0x96,0x82),
     o3(0xE6,0x96,0x83), o3(0xE8,0xAE,0x8A),
     o3(0xE6,0x96,0x9B), o3(0xE6,0x96,0x9F),
     o3(0xE6,0x96,0xAB), o3(0xE6,0x96,0xB7),
     o3(0xE6,0x97,0x83), o3(0xE6,0x97,0x86),
     o3(0xE6,0x97,0x81), o3(0xE6,0x97,0x84),
     o3(0xE6,0x97,0x8C), o3(0xE6,0x97,0x92),
     o3(0xE6,0x97,0x9B), o3(0xE6,0x97,0x99),
     o3(0xE6,0x97,0xA0), o3(0xE6,0x97,0xA1),
     o3(0xE6,0x97,0xB1), o3(0xE6,0x9D,0xB2),
     o3(0xE6,0x98,0x8A), o3(0xE6,0x98,0x83),
     o3(0xE6,0x97,0xBB), o3(0xE6,0x9D,0xB3),
     o3(0xE6,0x98,0xB5), o3(0xE6,0x98,0xB6),
     o3(0xE6,0x98,0xB4), o3(0xE6,0x98,0x9C),
     o3(0xE6,0x99,0x8F), o3(0xE6,0x99,0x84),
     o3(0xE6,0x99,0x89), o3(0xE6,0x99,0x81),
     o3(0xE6,0x99,0x9E), o3(0xE6,0x99,0x9D),
     o3(0xE6,0x99,0xA4), o3(0xE6,0x99,0xA7),
     o3(0xE6,0x99,0xA8), o3(0xE6,0x99,0x9F),
     o3(0xE6,0x99,0xA2), o3(0xE6,0x99,0xB0),
     o3(0xE6,0x9A,0x83), o3(0xE6,0x9A,0x88),
     o3(0xE6,0x9A,0x8E), o3(0xE6,0x9A,0x89),
     o3(0xE6,0x9A,0x84), o3(0xE6,0x9A,0x98),
     o3(0xE6,0x9A,0x9D), o3(0xE6,0x9B,0x81),
     o3(0xE6,0x9A,0xB9), o3(0xE6,0x9B,0x89),
     o3(0xE6,0x9A,0xBE), o3(0xE6,0x9A,0xBC),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_DA = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_DA_infos
};

static const struct byte_lookup* const
from_EUC_JP_DB_infos[95] = {
     o3(0xE6,0x9B,0x84), o3(0xE6,0x9A,0xB8),
     o3(0xE6,0x9B,0x96), o3(0xE6,0x9B,0x9A),
     o3(0xE6,0x9B,0xA0), o3(0xE6,0x98,0xBF),
     o3(0xE6,0x9B,0xA6), o3(0xE6,0x9B,0xA9),
     o3(0xE6,0x9B,0xB0), o3(0xE6,0x9B,0xB5),
     o3(0xE6,0x9B,0xB7), o3(0xE6,0x9C,0x8F),
     o3(0xE6,0x9C,0x96), o3(0xE6,0x9C,0x9E),
     o3(0xE6,0x9C,0xA6), o3(0xE6,0x9C,0xA7),
     o3(0xE9,0x9C,0xB8), o3(0xE6,0x9C,0xAE),
     o3(0xE6,0x9C,0xBF), o3(0xE6,0x9C,0xB6),
     o3(0xE6,0x9D,0x81), o3(0xE6,0x9C,0xB8),
     o3(0xE6,0x9C,0xB7), o3(0xE6,0x9D,0x86),
     o3(0xE6,0x9D,0x9E), o3(0xE6,0x9D,0xA0),
     o3(0xE6,0x9D,0x99), o3(0xE6,0x9D,0xA3),
     o3(0xE6,0x9D,0xA4), o3(0xE6,0x9E,0x89),
     o3(0xE6,0x9D,0xB0), o3(0xE6,0x9E,0xA9),
     o3(0xE6,0x9D,0xBC), o3(0xE6,0x9D,0xAA),
     o3(0xE6,0x9E,0x8C), o3(0xE6,0x9E,0x8B),
     o3(0xE6,0x9E,0xA6), o3(0xE6,0x9E,0xA1),
     o3(0xE6,0x9E,0x85), o3(0xE6,0x9E,0xB7),
     o3(0xE6,0x9F,0xAF), o3(0xE6,0x9E,0xB4),
     o3(0xE6,0x9F,0xAC), o3(0xE6,0x9E,0xB3),
     o3(0xE6,0x9F,0xA9), o3(0xE6,0x9E,0xB8),
     o3(0xE6,0x9F,0xA4), o3(0xE6,0x9F,0x9E),
     o3(0xE6,0x9F,0x9D), o3(0xE6,0x9F,0xA2),
     o3(0xE6,0x9F,0xAE), o3(0xE6,0x9E,0xB9),
     o3(0xE6,0x9F,0x8E), o3(0xE6,0x9F,0x86),
     o3(0xE6,0x9F,0xA7), o3(0xE6,0xAA,0x9C),
     o3(0xE6,0xA0,0x9E), o3(0xE6,0xA1,0x86),
     o3(0xE6,0xA0,0xA9), o3(0xE6,0xA1,0x80),
     o3(0xE6,0xA1,0x8D), o3(0xE6,0xA0,0xB2),
     o3(0xE6,0xA1,0x8E), o3(0xE6,0xA2,0xB3),
     o3(0xE6,0xA0,0xAB), o3(0xE6,0xA1,0x99),
     o3(0xE6,0xA1,0xA3), o3(0xE6,0xA1,0xB7),
     o3(0xE6,0xA1,0xBF), o3(0xE6,0xA2,0x9F),
     o3(0xE6,0xA2,0x8F), o3(0xE6,0xA2,0xAD),
     o3(0xE6,0xA2,0x94), o3(0xE6,0xA2,0x9D),
     o3(0xE6,0xA2,0x9B), o3(0xE6,0xA2,0x83),
     o3(0xE6,0xAA,0xAE), o3(0xE6,0xA2,0xB9),
     o3(0xE6,0xA1,0xB4), o3(0xE6,0xA2,0xB5),
     o3(0xE6,0xA2,0xA0), o3(0xE6,0xA2,0xBA),
     o3(0xE6,0xA4,0x8F), o3(0xE6,0xA2,0x8D),
     o3(0xE6,0xA1,0xBE), o3(0xE6,0xA4,0x81),
     o3(0xE6,0xA3,0x8A), o3(0xE6,0xA4,0x88),
     o3(0xE6,0xA3,0x98), o3(0xE6,0xA4,0xA2),
     o3(0xE6,0xA4,0xA6), o3(0xE6,0xA3,0xA1),
     o3(0xE6,0xA4,0x8C), o3(0xE6,0xA3,0x8D),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_DB = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_DB_infos
};

static const struct byte_lookup* const
from_EUC_JP_DC_infos[95] = {
     o3(0xE6,0xA3,0x94), o3(0xE6,0xA3,0xA7),
     o3(0xE6,0xA3,0x95), o3(0xE6,0xA4,0xB6),
     o3(0xE6,0xA4,0x92), o3(0xE6,0xA4,0x84),
     o3(0xE6,0xA3,0x97), o3(0xE6,0xA3,0xA3),
     o3(0xE6,0xA4,0xA5), o3(0xE6,0xA3,0xB9),
     o3(0xE6,0xA3,0xA0), o3(0xE6,0xA3,0xAF),
     o3(0xE6,0xA4,0xA8), o3(0xE6,0xA4,0xAA),
     o3(0xE6,0xA4,0x9A), o3(0xE6,0xA4,0xA3),
     o3(0xE6,0xA4,0xA1), o3(0xE6,0xA3,0x86),
     o3(0xE6,0xA5,0xB9), o3(0xE6,0xA5,0xB7),
     o3(0xE6,0xA5,0x9C), o3(0xE6,0xA5,0xB8),
     o3(0xE6,0xA5,0xAB), o3(0xE6,0xA5,0x94),
     o3(0xE6,0xA5,0xBE), o3(0xE6,0xA5,0xAE),
     o3(0xE6,0xA4,0xB9), o3(0xE6,0xA5,0xB4),
     o3(0xE6,0xA4,0xBD), o3(0xE6,0xA5,0x99),
     o3(0xE6,0xA4,0xB0), o3(0xE6,0xA5,0xA1),
     o3(0xE6,0xA5,0x9E), o3(0xE6,0xA5,0x9D),
     o3(0xE6,0xA6,0x81), o3(0xE6,0xA5,0xAA),
     o3(0xE6,0xA6,0xB2), o3(0xE6,0xA6,0xAE),
     o3(0xE6,0xA7,0x90), o3(0xE6,0xA6,0xBF),
     o3(0xE6,0xA7,0x81), o3(0xE6,0xA7,0x93),
     o3(0xE6,0xA6,0xBE), o3(0xE6,0xA7,0x8E),
     o3(0xE5,0xAF,0xA8), o3(0xE6,0xA7,0x8A),
     o3(0xE6,0xA7,0x9D), o3(0xE6,0xA6,0xBB),
     o3(0xE6,0xA7,0x83), o3(0xE6,0xA6,0xA7),
     o3(0xE6,0xA8,0xAE), o3(0xE6,0xA6,0x91),
     o3(0xE6,0xA6,0xA0), o3(0xE6,0xA6,0x9C),
     o3(0xE6,0xA6,0x95), o3(0xE6,0xA6,0xB4),
     o3(0xE6,0xA7,0x9E), o3(0xE6,0xA7,0xA8),
     o3(0xE6,0xA8,0x82), o3(0xE6,0xA8,0x9B),
     o3(0xE6,0xA7,0xBF), o3(0xE6,0xAC,0x8A),
     o3(0xE6,0xA7,0xB9), o3(0xE6,0xA7,0xB2),
     o3(0xE6,0xA7,0xA7), o3(0xE6,0xA8,0x85),
     o3(0xE6,0xA6,0xB1), o3(0xE6,0xA8,0x9E),
     o3(0xE6,0xA7,0xAD), o3(0xE6,0xA8,0x94),
     o3(0xE6,0xA7,0xAB), o3(0xE6,0xA8,0x8A),
     o3(0xE6,0xA8,0x92), o3(0xE6,0xAB,0x81),
     o3(0xE6,0xA8,0xA3), o3(0xE6,0xA8,0x93),
     o3(0xE6,0xA9,0x84), o3(0xE6,0xA8,0x8C),
     o3(0xE6,0xA9,0xB2), o3(0xE6,0xA8,0xB6),
     o3(0xE6,0xA9,0xB8), o3(0xE6,0xA9,0x87),
     o3(0xE6,0xA9,0xA2), o3(0xE6,0xA9,0x99),
     o3(0xE6,0xA9,0xA6), o3(0xE6,0xA9,0x88),
     o3(0xE6,0xA8,0xB8), o3(0xE6,0xA8,0xA2),
     o3(0xE6,0xAA,0x90), o3(0xE6,0xAA,0x8D),
     o3(0xE6,0xAA,0xA0), o3(0xE6,0xAA,0x84),
     o3(0xE6,0xAA,0xA2), o3(0xE6,0xAA,0xA3),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_DC = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_DC_infos
};

static const struct byte_lookup* const
from_EUC_JP_DD_infos[95] = {
     o3(0xE6,0xAA,0x97), o3(0xE8,0x98,0x97),
     o3(0xE6,0xAA,0xBB), o3(0xE6,0xAB,0x83),
     o3(0xE6,0xAB,0x82), o3(0xE6,0xAA,0xB8),
     o3(0xE6,0xAA,0xB3), o3(0xE6,0xAA,0xAC),
     o3(0xE6,0xAB,0x9E), o3(0xE6,0xAB,0x91),
     o3(0xE6,0xAB,0x9F), o3(0xE6,0xAA,0xAA),
     o3(0xE6,0xAB,0x9A), o3(0xE6,0xAB,0xAA),
     o3(0xE6,0xAB,0xBB), o3(0xE6,0xAC,0x85),
     o3(0xE8,0x98,0x96), o3(0xE6,0xAB,0xBA),
     o3(0xE6,0xAC,0x92), o3(0xE6,0xAC,0x96),
     o3(0xE9,0xAC,0xB1), o3(0xE6,0xAC,0x9F),
     o3(0xE6,0xAC,0xB8), o3(0xE6,0xAC,0xB7),
     o3(0xE7,0x9B,0x9C), o3(0xE6,0xAC,0xB9),
     o3(0xE9,0xA3,0xAE), o3(0xE6,0xAD,0x87),
     o3(0xE6,0xAD,0x83), o3(0xE6,0xAD,0x89),
     o3(0xE6,0xAD,0x90), o3(0xE6,0xAD,0x99),
     o3(0xE6,0xAD,0x94), o3(0xE6,0xAD,0x9B),
     o3(0xE6,0xAD,0x9F), o3(0xE6,0xAD,0xA1),
     o3(0xE6,0xAD,0xB8), o3(0xE6,0xAD,0xB9),
     o3(0xE6,0xAD,0xBF), o3(0xE6,0xAE,0x80),
     o3(0xE6,0xAE,0x84), o3(0xE6,0xAE,0x83),
     o3(0xE6,0xAE,0x8D), o3(0xE6,0xAE,0x98),
     o3(0xE6,0xAE,0x95), o3(0xE6,0xAE,0x9E),
     o3(0xE6,0xAE,0xA4), o3(0xE6,0xAE,0xAA),
     o3(0xE6,0xAE,0xAB), o3(0xE6,0xAE,0xAF),
     o3(0xE6,0xAE,0xB2), o3(0xE6,0xAE,0xB1),
     o3(0xE6,0xAE,0xB3), o3(0xE6,0xAE,0xB7),
     o3(0xE6,0xAE,0xBC), o3(0xE6,0xAF,0x86),
     o3(0xE6,0xAF,0x8B), o3(0xE6,0xAF,0x93),
     o3(0xE6,0xAF,0x9F), o3(0xE6,0xAF,0xAC),
     o3(0xE6,0xAF,0xAB), o3(0xE6,0xAF,0xB3),
     o3(0xE6,0xAF,0xAF), o3(0xE9,0xBA,0xBE),
     o3(0xE6,0xB0,0x88), o3(0xE6,0xB0,0x93),
     o3(0xE6,0xB0,0x94), o3(0xE6,0xB0,0x9B),
     o3(0xE6,0xB0,0xA4), o3(0xE6,0xB0,0xA3),
     o3(0xE6,0xB1,0x9E), o3(0xE6,0xB1,0x95),
     o3(0xE6,0xB1,0xA2), o3(0xE6,0xB1,0xAA),
     o3(0xE6,0xB2,0x82), o3(0xE6,0xB2,0x8D),
     o3(0xE6,0xB2,0x9A), o3(0xE6,0xB2,0x81),
     o3(0xE6,0xB2,0x9B), o3(0xE6,0xB1,0xBE),
     o3(0xE6,0xB1,0xA8), o3(0xE6,0xB1,0xB3),
     o3(0xE6,0xB2,0x92), o3(0xE6,0xB2,0x90),
     o3(0xE6,0xB3,0x84), o3(0xE6,0xB3,0xB1),
     o3(0xE6,0xB3,0x93), o3(0xE6,0xB2,0xBD),
     o3(0xE6,0xB3,0x97), o3(0xE6,0xB3,0x85),
     o3(0xE6,0xB3,0x9D), o3(0xE6,0xB2,0xAE),
     o3(0xE6,0xB2,0xB1), o3(0xE6,0xB2,0xBE),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_DD = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_DD_infos
};

static const struct byte_lookup* const
from_EUC_JP_DE_infos[95] = {
     o3(0xE6,0xB2,0xBA), o3(0xE6,0xB3,0x9B),
     o3(0xE6,0xB3,0xAF), o3(0xE6,0xB3,0x99),
     o3(0xE6,0xB3,0xAA), o3(0xE6,0xB4,0x9F),
     o3(0xE8,0xA1,0x8D), o3(0xE6,0xB4,0xB6),
     o3(0xE6,0xB4,0xAB), o3(0xE6,0xB4,0xBD),
     o3(0xE6,0xB4,0xB8), o3(0xE6,0xB4,0x99),
     o3(0xE6,0xB4,0xB5), o3(0xE6,0xB4,0xB3),
     o3(0xE6,0xB4,0x92), o3(0xE6,0xB4,0x8C),
     o3(0xE6,0xB5,0xA3), o3(0xE6,0xB6,0x93),
     o3(0xE6,0xB5,0xA4), o3(0xE6,0xB5,0x9A),
     o3(0xE6,0xB5,0xB9), o3(0xE6,0xB5,0x99),
     o3(0xE6,0xB6,0x8E), o3(0xE6,0xB6,0x95),
     o3(0xE6,0xBF,0xA4), o3(0xE6,0xB6,0x85),
     o3(0xE6,0xB7,0xB9), o3(0xE6,0xB8,0x95),
     o3(0xE6,0xB8,0x8A), o3(0xE6,0xB6,0xB5),
     o3(0xE6,0xB7,0x87), o3(0xE6,0xB7,0xA6),
     o3(0xE6,0xB6,0xB8), o3(0xE6,0xB7,0x86),
     o3(0xE6,0xB7,0xAC), o3(0xE6,0xB7,0x9E),
     o3(0xE6,0xB7,0x8C), o3(0xE6,0xB7,0xA8),
     o3(0xE6,0xB7,0x92), o3(0xE6,0xB7,0x85),
     o3(0xE6,0xB7,0xBA), o3(0xE6,0xB7,0x99),
     o3(0xE6,0xB7,0xA4), o3(0xE6,0xB7,0x95),
     o3(0xE6,0xB7,0xAA), o3(0xE6,0xB7,0xAE),
     o3(0xE6,0xB8,0xAD), o3(0xE6,0xB9,0xAE),
     o3(0xE6,0xB8,0xAE), o3(0xE6,0xB8,0x99),
     o3(0xE6,0xB9,0xB2), o3(0xE6,0xB9,0x9F),
     o3(0xE6,0xB8,0xBE), o3(0xE6,0xB8,0xA3),
     o3(0xE6,0xB9,0xAB), o3(0xE6,0xB8,0xAB),
     o3(0xE6,0xB9,0xB6), o3(0xE6,0xB9,0x8D),
     o3(0xE6,0xB8,0x9F), o3(0xE6,0xB9,0x83),
     o3(0xE6,0xB8,0xBA), o3(0xE6,0xB9,0x8E),
     o3(0xE6,0xB8,0xA4), o3(0xE6,0xBB,0xBF),
     o3(0xE6,0xB8,0x9D), o3(0xE6,0xB8,0xB8),
     o3(0xE6,0xBA,0x82), o3(0xE6,0xBA,0xAA),
     o3(0xE6,0xBA,0x98), o3(0xE6,0xBB,0x89),
     o3(0xE6,0xBA,0xB7), o3(0xE6,0xBB,0x93),
     o3(0xE6,0xBA,0xBD), o3(0xE6,0xBA,0xAF),
     o3(0xE6,0xBB,0x84), o3(0xE6,0xBA,0xB2),
     o3(0xE6,0xBB,0x94), o3(0xE6,0xBB,0x95),
     o3(0xE6,0xBA,0x8F), o3(0xE6,0xBA,0xA5),
     o3(0xE6,0xBB,0x82), o3(0xE6,0xBA,0x9F),
     o3(0xE6,0xBD,0x81), o3(0xE6,0xBC,0x91),
     o3(0xE7,0x81,0x8C), o3(0xE6,0xBB,0xAC),
     o3(0xE6,0xBB,0xB8), o3(0xE6,0xBB,0xBE),
     o3(0xE6,0xBC,0xBF), o3(0xE6,0xBB,0xB2),
     o3(0xE6,0xBC,0xB1), o3(0xE6,0xBB,0xAF),
     o3(0xE6,0xBC,0xB2), o3(0xE6,0xBB,0x8C),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_DE = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_DE_infos
};

static const struct byte_lookup* const
from_EUC_JP_DF_infos[95] = {
     o3(0xE6,0xBC,0xBE), o3(0xE6,0xBC,0x93),
     o3(0xE6,0xBB,0xB7), o3(0xE6,0xBE,0x86),
     o3(0xE6,0xBD,0xBA), o3(0xE6,0xBD,0xB8),
     o3(0xE6,0xBE,0x81), o3(0xE6,0xBE,0x80),
     o3(0xE6,0xBD,0xAF), o3(0xE6,0xBD,0x9B),
     o3(0xE6,0xBF,0xB3), o3(0xE6,0xBD,0xAD),
     o3(0xE6,0xBE,0x82), o3(0xE6,0xBD,0xBC),
     o3(0xE6,0xBD,0x98), o3(0xE6,0xBE,0x8E),
     o3(0xE6,0xBE,0x91), o3(0xE6,0xBF,0x82),
     o3(0xE6,0xBD,0xA6), o3(0xE6,0xBE,0xB3),
     o3(0xE6,0xBE,0xA3), o3(0xE6,0xBE,0xA1),
     o3(0xE6,0xBE,0xA4), o3(0xE6,0xBE,0xB9),
     o3(0xE6,0xBF,0x86), o3(0xE6,0xBE,0xAA),
     o3(0xE6,0xBF,0x9F), o3(0xE6,0xBF,0x95),
     o3(0xE6,0xBF,0xAC), o3(0xE6,0xBF,0x94),
     o3(0xE6,0xBF,0x98), o3(0xE6,0xBF,0xB1),
     o3(0xE6,0xBF,0xAE), o3(0xE6,0xBF,0x9B),
     o3(0xE7,0x80,0x89), o3(0xE7,0x80,0x8B),
     o3(0xE6,0xBF,0xBA), o3(0xE7,0x80,0x91),
     o3(0xE7,0x80,0x81), o3(0xE7,0x80,0x8F),
     o3(0xE6,0xBF,0xBE), o3(0xE7,0x80,0x9B),
     o3(0xE7,0x80,0x9A), o3(0xE6,0xBD,0xB4),
     o3(0xE7,0x80,0x9D), o3(0xE7,0x80,0x98),
     o3(0xE7,0x80,0x9F), o3(0xE7,0x80,0xB0),
     o3(0xE7,0x80,0xBE), o3(0xE7,0x80,0xB2),
     o3(0xE7,0x81,0x91), o3(0xE7,0x81,0xA3),
     o3(0xE7,0x82,0x99), o3(0xE7,0x82,0x92),
     o3(0xE7,0x82,0xAF), o3(0xE7,0x83,0xB1),
     o3(0xE7,0x82,0xAC), o3(0xE7,0x82,0xB8),
     o3(0xE7,0x82,0xB3), o3(0xE7,0x82,0xAE),
     o3(0xE7,0x83,0x9F), o3(0xE7,0x83,0x8B),
     o3(0xE7,0x83,0x9D), o3(0xE7,0x83,0x99),
     o3(0xE7,0x84,0x89), o3(0xE7,0x83,0xBD),
     o3(0xE7,0x84,0x9C), o3(0xE7,0x84,0x99),
     o3(0xE7,0x85,0xA5), o3(0xE7,0x85,0x95),
     o3(0xE7,0x86,0x88), o3(0xE7,0x85,0xA6),
     o3(0xE7,0x85,0xA2), o3(0xE7,0x85,0x8C),
     o3(0xE7,0x85,0x96), o3(0xE7,0x85,0xAC),
     o3(0xE7,0x86,0x8F), o3(0xE7,0x87,0xBB),
     o3(0xE7,0x86,0x84), o3(0xE7,0x86,0x95),
     o3(0xE7,0x86,0xA8), o3(0xE7,0x86,0xAC),
     o3(0xE7,0x87,0x97), o3(0xE7,0x86,0xB9),
     o3(0xE7,0x86,0xBE), o3(0xE7,0x87,0x92),
     o3(0xE7,0x87,0x89), o3(0xE7,0x87,0x94),
     o3(0xE7,0x87,0x8E), o3(0xE7,0x87,0xA0),
     o3(0xE7,0x87,0xAC), o3(0xE7,0x87,0xA7),
     o3(0xE7,0x87,0xB5), o3(0xE7,0x87,0xBC),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_DF = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_DF_infos
};

static const struct byte_lookup* const
from_EUC_JP_E0_infos[95] = {
     o3(0xE7,0x87,0xB9), o3(0xE7,0x87,0xBF),
     o3(0xE7,0x88,0x8D), o3(0xE7,0x88,0x90),
     o3(0xE7,0x88,0x9B), o3(0xE7,0x88,0xA8),
     o3(0xE7,0x88,0xAD), o3(0xE7,0x88,0xAC),
     o3(0xE7,0x88,0xB0), o3(0xE7,0x88,0xB2),
     o3(0xE7,0x88,0xBB), o3(0xE7,0x88,0xBC),
     o3(0xE7,0x88,0xBF), o3(0xE7,0x89,0x80),
     o3(0xE7,0x89,0x86), o3(0xE7,0x89,0x8B),
     o3(0xE7,0x89,0x98), o3(0xE7,0x89,0xB4),
     o3(0xE7,0x89,0xBE), o3(0xE7,0x8A,0x82),
     o3(0xE7,0x8A,0x81), o3(0xE7,0x8A,0x87),
     o3(0xE7,0x8A,0x92), o3(0xE7,0x8A,0x96),
     o3(0xE7,0x8A,0xA2), o3(0xE7,0x8A,0xA7),
     o3(0xE7,0x8A,0xB9), o3(0xE7,0x8A,0xB2),
     o3(0xE7,0x8B,0x83), o3(0xE7,0x8B,0x86),
     o3(0xE7,0x8B,0x84), o3(0xE7,0x8B,0x8E),
     o3(0xE7,0x8B,0x92), o3(0xE7,0x8B,0xA2),
     o3(0xE7,0x8B,0xA0), o3(0xE7,0x8B,0xA1),
     o3(0xE7,0x8B,0xB9), o3(0xE7,0x8B,0xB7),
     o3(0xE5,0x80,0x8F), o3(0xE7,0x8C,0x97),
     o3(0xE7,0x8C,0x8A), o3(0xE7,0x8C,0x9C),
     o3(0xE7,0x8C,0x96), o3(0xE7,0x8C,0x9D),
     o3(0xE7,0x8C,0xB4), o3(0xE7,0x8C,0xAF),
     o3(0xE7,0x8C,0xA9), o3(0xE7,0x8C,0xA5),
     o3(0xE7,0x8C,0xBE), o3(0xE7,0x8D,0x8E),
     o3(0xE7,0x8D,0x8F), o3(0xE9,0xBB,0x98),
     o3(0xE7,0x8D,0x97), o3(0xE7,0x8D,0xAA),
     o3(0xE7,0x8D,0xA8), o3(0xE7,0x8D,0xB0),
     o3(0xE7,0x8D,0xB8), o3(0xE7,0x8D,0xB5),
     o3(0xE7,0x8D,0xBB), o3(0xE7,0x8D,0xBA),
     o3(0xE7,0x8F,0x88), o3(0xE7,0x8E,0xB3),
     o3(0xE7,0x8F,0x8E), o3(0xE7,0x8E,0xBB),
     o3(0xE7,0x8F,0x80), o3(0xE7,0x8F,0xA5),
     o3(0xE7,0x8F,0xAE), o3(0xE7,0x8F,0x9E),
     o3(0xE7,0x92,0xA2), o3(0xE7,0x90,0x85),
     o3(0xE7,0x91,0xAF), o3(0xE7,0x90,0xA5),
     o3(0xE7,0x8F,0xB8), o3(0xE7,0x90,0xB2),
     o3(0xE7,0x90,0xBA), o3(0xE7,0x91,0x95),
     o3(0xE7,0x90,0xBF), o3(0xE7,0x91,0x9F),
     o3(0xE7,0x91,0x99), o3(0xE7,0x91,0x81),
     o3(0xE7,0x91,0x9C), o3(0xE7,0x91,0xA9),
     o3(0xE7,0x91,0xB0), o3(0xE7,0x91,0xA3),
     o3(0xE7,0x91,0xAA), o3(0xE7,0x91,0xB6),
     o3(0xE7,0x91,0xBE), o3(0xE7,0x92,0x8B),
     o3(0xE7,0x92,0x9E), o3(0xE7,0x92,0xA7),
     o3(0xE7,0x93,0x8A), o3(0xE7,0x93,0x8F),
     o3(0xE7,0x93,0x94), o3(0xE7,0x8F,0xB1),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_E0 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_E0_infos
};

static const struct byte_lookup* const
from_EUC_JP_E1_infos[95] = {
     o3(0xE7,0x93,0xA0), o3(0xE7,0x93,0xA3),
     o3(0xE7,0x93,0xA7), o3(0xE7,0x93,0xA9),
     o3(0xE7,0x93,0xAE), o3(0xE7,0x93,0xB2),
     o3(0xE7,0x93,0xB0), o3(0xE7,0x93,0xB1),
     o3(0xE7,0x93,0xB8), o3(0xE7,0x93,0xB7),
     o3(0xE7,0x94,0x84), o3(0xE7,0x94,0x83),
     o3(0xE7,0x94,0x85), o3(0xE7,0x94,0x8C),
     o3(0xE7,0x94,0x8E), o3(0xE7,0x94,0x8D),
     o3(0xE7,0x94,0x95), o3(0xE7,0x94,0x93),
     o3(0xE7,0x94,0x9E), o3(0xE7,0x94,0xA6),
     o3(0xE7,0x94,0xAC), o3(0xE7,0x94,0xBC),
     o3(0xE7,0x95,0x84), o3(0xE7,0x95,0x8D),
     o3(0xE7,0x95,0x8A), o3(0xE7,0x95,0x89),
     o3(0xE7,0x95,0x9B), o3(0xE7,0x95,0x86),
     o3(0xE7,0x95,0x9A), o3(0xE7,0x95,0xA9),
     o3(0xE7,0x95,0xA4), o3(0xE7,0x95,0xA7),
     o3(0xE7,0x95,0xAB), o3(0xE7,0x95,0xAD),
     o3(0xE7,0x95,0xB8), o3(0xE7,0x95,0xB6),
     o3(0xE7,0x96,0x86), o3(0xE7,0x96,0x87),
     o3(0xE7,0x95,0xB4), o3(0xE7,0x96,0x8A),
     o3(0xE7,0x96,0x89), o3(0xE7,0x96,0x82),
     o3(0xE7,0x96,0x94), o3(0xE7,0x96,0x9A),
     o3(0xE7,0x96,0x9D), o3(0xE7,0x96,0xA5),
     o3(0xE7,0x96,0xA3), o3(0xE7,0x97,0x82),
     o3(0xE7,0x96,0xB3), o3(0xE7,0x97,0x83),
     o3(0xE7,0x96,0xB5), o3(0xE7,0x96,0xBD),
     o3(0xE7,0x96,0xB8), o3(0xE7,0x96,0xBC),
     o3(0xE7,0x96,0xB1), o3(0xE7,0x97,0x8D),
     o3(0xE7,0x97,0x8A), o3(0xE7,0x97,0x92),
     o3(0xE7,0x97,0x99), o3(0xE7,0x97,0xA3),
     o3(0xE7,0x97,0x9E), o3(0xE7,0x97,0xBE),
     o3(0xE7,0x97,0xBF), o3(0xE7,0x97,0xBC),
     o3(0xE7,0x98,0x81), o3(0xE7,0x97,0xB0),
     o3(0xE7,0x97,0xBA), o3(0xE7,0x97,0xB2),
     o3(0xE7,0x97,0xB3), o3(0xE7,0x98,0x8B),
     o3(0xE7,0x98,0x8D), o3(0xE7,0x98,0x89),
     o3(0xE7,0x98,0x9F), o3(0xE7,0x98,0xA7),
     o3(0xE7,0x98,0xA0), o3(0xE7,0x98,0xA1),
     o3(0xE7,0x98,0xA2), o3(0xE7,0x98,0xA4),
     o3(0xE7,0x98,0xB4), o3(0xE7,0x98,0xB0),
     o3(0xE7,0x98,0xBB), o3(0xE7,0x99,0x87),
     o3(0xE7,0x99,0x88), o3(0xE7,0x99,0x86),
     o3(0xE7,0x99,0x9C), o3(0xE7,0x99,0x98),
     o3(0xE7,0x99,0xA1), o3(0xE7,0x99,0xA2),
     o3(0xE7,0x99,0xA8), o3(0xE7,0x99,0xA9),
     o3(0xE7,0x99,0xAA), o3(0xE7,0x99,0xA7),
     o3(0xE7,0x99,0xAC), o3(0xE7,0x99,0xB0),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_E1 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_E1_infos
};

static const struct byte_lookup* const
from_EUC_JP_E2_infos[95] = {
     o3(0xE7,0x99,0xB2), o3(0xE7,0x99,0xB6),
     o3(0xE7,0x99,0xB8), o3(0xE7,0x99,0xBC),
     o3(0xE7,0x9A,0x80), o3(0xE7,0x9A,0x83),
     o3(0xE7,0x9A,0x88), o3(0xE7,0x9A,0x8B),
     o3(0xE7,0x9A,0x8E), o3(0xE7,0x9A,0x96),
     o3(0xE7,0x9A,0x93), o3(0xE7,0x9A,0x99),
     o3(0xE7,0x9A,0x9A), o3(0xE7,0x9A,0xB0),
     o3(0xE7,0x9A,0xB4), o3(0xE7,0x9A,0xB8),
     o3(0xE7,0x9A,0xB9), o3(0xE7,0x9A,0xBA),
     o3(0xE7,0x9B,0x82), o3(0xE7,0x9B,0x8D),
     o3(0xE7,0x9B,0x96), o3(0xE7,0x9B,0x92),
     o3(0xE7,0x9B,0x9E), o3(0xE7,0x9B,0xA1),
     o3(0xE7,0x9B,0xA5), o3(0xE7,0x9B,0xA7),
     o3(0xE7,0x9B,0xAA), o3(0xE8,0x98,0xAF),
     o3(0xE7,0x9B,0xBB), o3(0xE7,0x9C,0x88),
     o3(0xE7,0x9C,0x87), o3(0xE7,0x9C,0x84),
     o3(0xE7,0x9C,0xA9), o3(0xE7,0x9C,0xA4),
     o3(0xE7,0x9C,0x9E), o3(0xE7,0x9C,0xA5),
     o3(0xE7,0x9C,0xA6), o3(0xE7,0x9C,0x9B),
     o3(0xE7,0x9C,0xB7), o3(0xE7,0x9C,0xB8),
     o3(0xE7,0x9D,0x87), o3(0xE7,0x9D,0x9A),
     o3(0xE7,0x9D,0xA8), o3(0xE7,0x9D,0xAB),
     o3(0xE7,0x9D,0x9B), o3(0xE7,0x9D,0xA5),
     o3(0xE7,0x9D,0xBF), o3(0xE7,0x9D,0xBE),
     o3(0xE7,0x9D,0xB9), o3(0xE7,0x9E,0x8E),
     o3(0xE7,0x9E,0x8B), o3(0xE7,0x9E,0x91),
     o3(0xE7,0x9E,0xA0), o3(0xE7,0x9E,0x9E),
     o3(0xE7,0x9E,0xB0), o3(0xE7,0x9E,0xB6),
     o3(0xE7,0x9E,0xB9), o3(0xE7,0x9E,0xBF),
     o3(0xE7,0x9E,0xBC), o3(0xE7,0x9E,0xBD),
     o3(0xE7,0x9E,0xBB), o3(0xE7,0x9F,0x87),
     o3(0xE7,0x9F,0x8D), o3(0xE7,0x9F,0x97),
     o3(0xE7,0x9F,0x9A), o3(0xE7,0x9F,0x9C),
     o3(0xE7,0x9F,0xA3), o3(0xE7,0x9F,0xAE),
     o3(0xE7,0x9F,0xBC), o3(0xE7,0xA0,0x8C),
     o3(0xE7,0xA0,0x92), o3(0xE7,0xA4,0xA6),
     o3(0xE7,0xA0,0xA0), o3(0xE7,0xA4,0xAA),
     o3(0xE7,0xA1,0x85), o3(0xE7,0xA2,0x8E),
     o3(0xE7,0xA1,0xB4), o3(0xE7,0xA2,0x86),
     o3(0xE7,0xA1,0xBC), o3(0xE7,0xA2,0x9A),
     o3(0xE7,0xA2,0x8C), o3(0xE7,0xA2,0xA3),
     o3(0xE7,0xA2,0xB5), o3(0xE7,0xA2,0xAA),
     o3(0xE7,0xA2,0xAF), o3(0xE7,0xA3,0x91),
     o3(0xE7,0xA3,0x86), o3(0xE7,0xA3,0x8B),
     o3(0xE7,0xA3,0x94), o3(0xE7,0xA2,0xBE),
     o3(0xE7,0xA2,0xBC), o3(0xE7,0xA3,0x85),
     o3(0xE7,0xA3,0x8A), o3(0xE7,0xA3,0xAC),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_E2 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_E2_infos
};

static const struct byte_lookup* const
from_EUC_JP_E3_infos[95] = {
     o3(0xE7,0xA3,0xA7), o3(0xE7,0xA3,0x9A),
     o3(0xE7,0xA3,0xBD), o3(0xE7,0xA3,0xB4),
     o3(0xE7,0xA4,0x87), o3(0xE7,0xA4,0x92),
     o3(0xE7,0xA4,0x91), o3(0xE7,0xA4,0x99),
     o3(0xE7,0xA4,0xAC), o3(0xE7,0xA4,0xAB),
     o3(0xE7,0xA5,0x80), o3(0xE7,0xA5,0xA0),
     o3(0xE7,0xA5,0x97), o3(0xE7,0xA5,0x9F),
     o3(0xE7,0xA5,0x9A), o3(0xE7,0xA5,0x95),
     o3(0xE7,0xA5,0x93), o3(0xE7,0xA5,0xBA),
     o3(0xE7,0xA5,0xBF), o3(0xE7,0xA6,0x8A),
     o3(0xE7,0xA6,0x9D), o3(0xE7,0xA6,0xA7),
     o3(0xE9,0xBD,0x8B), o3(0xE7,0xA6,0xAA),
     o3(0xE7,0xA6,0xAE), o3(0xE7,0xA6,0xB3),
     o3(0xE7,0xA6,0xB9), o3(0xE7,0xA6,0xBA),
     o3(0xE7,0xA7,0x89), o3(0xE7,0xA7,0x95),
     o3(0xE7,0xA7,0xA7), o3(0xE7,0xA7,0xAC),
     o3(0xE7,0xA7,0xA1), o3(0xE7,0xA7,0xA3),
     o3(0xE7,0xA8,0x88), o3(0xE7,0xA8,0x8D),
     o3(0xE7,0xA8,0x98), o3(0xE7,0xA8,0x99),
     o3(0xE7,0xA8,0xA0), o3(0xE7,0xA8,0x9F),
     o3(0xE7,0xA6,0x80), o3(0xE7,0xA8,0xB1),
     o3(0xE7,0xA8,0xBB), o3(0xE7,0xA8,0xBE),
     o3(0xE7,0xA8,0xB7), o3(0xE7,0xA9,0x83),
     o3(0xE7,0xA9,0x97), o3(0xE7,0xA9,0x89),
     o3(0xE7,0xA9,0xA1), o3(0xE7,0xA9,0xA2),
     o3(0xE7,0xA9,0xA9), o3(0xE9,0xBE,0x9D),
     o3(0xE7,0xA9,0xB0), o3(0xE7,0xA9,0xB9),
     o3(0xE7,0xA9,0xBD), o3(0xE7,0xAA,0x88),
     o3(0xE7,0xAA,0x97), o3(0xE7,0xAA,0x95),
     o3(0xE7,0xAA,0x98), o3(0xE7,0xAA,0x96),
     o3(0xE7,0xAA,0xA9), o3(0xE7,0xAB,0x88),
     o3(0xE7,0xAA,0xB0), o3(0xE7,0xAA,0xB6),
     o3(0xE7,0xAB,0x85), o3(0xE7,0xAB,0x84),
     o3(0xE7,0xAA,0xBF), o3(0xE9,0x82,0x83),
     o3(0xE7,0xAB,0x87), o3(0xE7,0xAB,0x8A),
     o3(0xE7,0xAB,0x8D), o3(0xE7,0xAB,0x8F),
     o3(0xE7,0xAB,0x95), o3(0xE7,0xAB,0x93),
     o3(0xE7,0xAB,0x99), o3(0xE7,0xAB,0x9A),
     o3(0xE7,0xAB,0x9D), o3(0xE7,0xAB,0xA1),
     o3(0xE7,0xAB,0xA2), o3(0xE7,0xAB,0xA6),
     o3(0xE7,0xAB,0xAD), o3(0xE7,0xAB,0xB0),
     o3(0xE7,0xAC,0x82), o3(0xE7,0xAC,0x8F),
     o3(0xE7,0xAC,0x8A), o3(0xE7,0xAC,0x86),
     o3(0xE7,0xAC,0xB3), o3(0xE7,0xAC,0x98),
     o3(0xE7,0xAC,0x99), o3(0xE7,0xAC,0x9E),
     o3(0xE7,0xAC,0xB5), o3(0xE7,0xAC,0xA8),
     o3(0xE7,0xAC,0xB6), o3(0xE7,0xAD,0x90),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_E3 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_E3_infos
};

static const struct byte_lookup* const
from_EUC_JP_E4_infos[95] = {
     o3(0xE7,0xAD,0xBA), o3(0xE7,0xAC,0x84),
     o3(0xE7,0xAD,0x8D), o3(0xE7,0xAC,0x8B),
     o3(0xE7,0xAD,0x8C), o3(0xE7,0xAD,0x85),
     o3(0xE7,0xAD,0xB5), o3(0xE7,0xAD,0xA5),
     o3(0xE7,0xAD,0xB4), o3(0xE7,0xAD,0xA7),
     o3(0xE7,0xAD,0xB0), o3(0xE7,0xAD,0xB1),
     o3(0xE7,0xAD,0xAC), o3(0xE7,0xAD,0xAE),
     o3(0xE7,0xAE,0x9D), o3(0xE7,0xAE,0x98),
     o3(0xE7,0xAE,0x9F), o3(0xE7,0xAE,0x8D),
     o3(0xE7,0xAE,0x9C), o3(0xE7,0xAE,0x9A),
     o3(0xE7,0xAE,0x8B), o3(0xE7,0xAE,0x92),
     o3(0xE7,0xAE,0x8F), o3(0xE7,0xAD,0x9D),
     o3(0xE7,0xAE,0x99), o3(0xE7,0xAF,0x8B),
     o3(0xE7,0xAF,0x81), o3(0xE7,0xAF,0x8C),
     o3(0xE7,0xAF,0x8F), o3(0xE7,0xAE,0xB4),
     o3(0xE7,0xAF,0x86), o3(0xE7,0xAF,0x9D),
     o3(0xE7,0xAF,0xA9), o3(0xE7,0xB0,0x91),
     o3(0xE7,0xB0,0x94), o3(0xE7,0xAF,0xA6),
     o3(0xE7,0xAF,0xA5), o3(0xE7,0xB1,0xA0),
     o3(0xE7,0xB0,0x80), o3(0xE7,0xB0,0x87),
     o3(0xE7,0xB0,0x93), o3(0xE7,0xAF,0xB3),
     o3(0xE7,0xAF,0xB7), o3(0xE7,0xB0,0x97),
     o3(0xE7,0xB0,0x8D), o3(0xE7,0xAF,0xB6),
     o3(0xE7,0xB0,0xA3), o3(0xE7,0xB0,0xA7),
     o3(0xE7,0xB0,0xAA), o3(0xE7,0xB0,0x9F),
     o3(0xE7,0xB0,0xB7), o3(0xE7,0xB0,0xAB),
     o3(0xE7,0xB0,0xBD), o3(0xE7,0xB1,0x8C),
     o3(0xE7,0xB1,0x83), o3(0xE7,0xB1,0x94),
     o3(0xE7,0xB1,0x8F), o3(0xE7,0xB1,0x80),
     o3(0xE7,0xB1,0x90), o3(0xE7,0xB1,0x98),
     o3(0xE7,0xB1,0x9F), o3(0xE7,0xB1,0xA4),
     o3(0xE7,0xB1,0x96), o3(0xE7,0xB1,0xA5),
     o3(0xE7,0xB1,0xAC), o3(0xE7,0xB1,0xB5),
     o3(0xE7,0xB2,0x83), o3(0xE7,0xB2,0x90),
     o3(0xE7,0xB2,0xA4), o3(0xE7,0xB2,0xAD),
     o3(0xE7,0xB2,0xA2), o3(0xE7,0xB2,0xAB),
     o3(0xE7,0xB2,0xA1), o3(0xE7,0xB2,0xA8),
     o3(0xE7,0xB2,0xB3), o3(0xE7,0xB2,0xB2),
     o3(0xE7,0xB2,0xB1), o3(0xE7,0xB2,0xAE),
     o3(0xE7,0xB2,0xB9), o3(0xE7,0xB2,0xBD),
     o3(0xE7,0xB3,0x80), o3(0xE7,0xB3,0x85),
     o3(0xE7,0xB3,0x82), o3(0xE7,0xB3,0x98),
     o3(0xE7,0xB3,0x92), o3(0xE7,0xB3,0x9C),
     o3(0xE7,0xB3,0xA2), o3(0xE9,0xAC,0xBB),
     o3(0xE7,0xB3,0xAF), o3(0xE7,0xB3,0xB2),
     o3(0xE7,0xB3,0xB4), o3(0xE7,0xB3,0xB6),
     o3(0xE7,0xB3,0xBA), o3(0xE7,0xB4,0x86),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_E4 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_E4_infos
};

static const struct byte_lookup* const
from_EUC_JP_E5_infos[95] = {
     o3(0xE7,0xB4,0x82), o3(0xE7,0xB4,0x9C),
     o3(0xE7,0xB4,0x95), o3(0xE7,0xB4,0x8A),
     o3(0xE7,0xB5,0x85), o3(0xE7,0xB5,0x8B),
     o3(0xE7,0xB4,0xAE), o3(0xE7,0xB4,0xB2),
     o3(0xE7,0xB4,0xBF), o3(0xE7,0xB4,0xB5),
     o3(0xE7,0xB5,0x86), o3(0xE7,0xB5,0xB3),
     o3(0xE7,0xB5,0x96), o3(0xE7,0xB5,0x8E),
     o3(0xE7,0xB5,0xB2), o3(0xE7,0xB5,0xA8),
     o3(0xE7,0xB5,0xAE), o3(0xE7,0xB5,0x8F),
     o3(0xE7,0xB5,0xA3), o3(0xE7,0xB6,0x93),
     o3(0xE7,0xB6,0x89), o3(0xE7,0xB5,0x9B),
     o3(0xE7,0xB6,0x8F), o3(0xE7,0xB5,0xBD),
     o3(0xE7,0xB6,0x9B), o3(0xE7,0xB6,0xBA),
     o3(0xE7,0xB6,0xAE), o3(0xE7,0xB6,0xA3),
     o3(0xE7,0xB6,0xB5), o3(0xE7,0xB7,0x87),
     o3(0xE7,0xB6,0xBD), o3(0xE7,0xB6,0xAB),
     o3(0xE7,0xB8,0xBD), o3(0xE7,0xB6,0xA2),
     o3(0xE7,0xB6,0xAF), o3(0xE7,0xB7,0x9C),
     o3(0xE7,0xB6,0xB8), o3(0xE7,0xB6,0x9F),
     o3(0xE7,0xB6,0xB0), o3(0xE7,0xB7,0x98),
     o3(0xE7,0xB7,0x9D), o3(0xE7,0xB7,0xA4),
     o3(0xE7,0xB7,0x9E), o3(0xE7,0xB7,0xBB),
     o3(0xE7,0xB7,0xB2), o3(0xE7,0xB7,0xA1),
     o3(0xE7,0xB8,0x85), o3(0xE7,0xB8,0x8A),
     o3(0xE7,0xB8,0xA3), o3(0xE7,0xB8,0xA1),
     o3(0xE7,0xB8,0x92), o3(0xE7,0xB8,0xB1),
     o3(0xE7,0xB8,0x9F), o3(0xE7,0xB8,0x89),
     o3(0xE7,0xB8,0x8B), o3(0xE7,0xB8,0xA2),
     o3(0xE7,0xB9,0x86), o3(0xE7,0xB9,0xA6),
     o3(0xE7,0xB8,0xBB), o3(0xE7,0xB8,0xB5),
     o3(0xE7,0xB8,0xB9), o3(0xE7,0xB9,0x83),
     o3(0xE7,0xB8,0xB7), o3(0xE7,0xB8,0xB2),
     o3(0xE7,0xB8,0xBA), o3(0xE7,0xB9,0xA7),
     o3(0xE7,0xB9,0x9D), o3(0xE7,0xB9,0x96),
     o3(0xE7,0xB9,0x9E), o3(0xE7,0xB9,0x99),
     o3(0xE7,0xB9,0x9A), o3(0xE7,0xB9,0xB9),
     o3(0xE7,0xB9,0xAA), o3(0xE7,0xB9,0xA9),
     o3(0xE7,0xB9,0xBC), o3(0xE7,0xB9,0xBB),
     o3(0xE7,0xBA,0x83), o3(0xE7,0xB7,0x95),
     o3(0xE7,0xB9,0xBD), o3(0xE8,0xBE,0xAE),
     o3(0xE7,0xB9,0xBF), o3(0xE7,0xBA,0x88),
     o3(0xE7,0xBA,0x89), o3(0xE7,0xBA,0x8C),
     o3(0xE7,0xBA,0x92), o3(0xE7,0xBA,0x90),
     o3(0xE7,0xBA,0x93), o3(0xE7,0xBA,0x94),
     o3(0xE7,0xBA,0x96), o3(0xE7,0xBA,0x8E),
     o3(0xE7,0xBA,0x9B), o3(0xE7,0xBA,0x9C),
     o3(0xE7,0xBC,0xB8), o3(0xE7,0xBC,0xBA),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_E5 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_E5_infos
};

static const struct byte_lookup* const
from_EUC_JP_E6_infos[95] = {
     o3(0xE7,0xBD,0x85), o3(0xE7,0xBD,0x8C),
     o3(0xE7,0xBD,0x8D), o3(0xE7,0xBD,0x8E),
     o3(0xE7,0xBD,0x90), o3(0xE7,0xBD,0x91),
     o3(0xE7,0xBD,0x95), o3(0xE7,0xBD,0x94),
     o3(0xE7,0xBD,0x98), o3(0xE7,0xBD,0x9F),
     o3(0xE7,0xBD,0xA0), o3(0xE7,0xBD,0xA8),
     o3(0xE7,0xBD,0xA9), o3(0xE7,0xBD,0xA7),
     o3(0xE7,0xBD,0xB8), o3(0xE7,0xBE,0x82),
     o3(0xE7,0xBE,0x86), o3(0xE7,0xBE,0x83),
     o3(0xE7,0xBE,0x88), o3(0xE7,0xBE,0x87),
     o3(0xE7,0xBE,0x8C), o3(0xE7,0xBE,0x94),
     o3(0xE7,0xBE,0x9E), o3(0xE7,0xBE,0x9D),
     o3(0xE7,0xBE,0x9A), o3(0xE7,0xBE,0xA3),
     o3(0xE7,0xBE,0xAF), o3(0xE7,0xBE,0xB2),
     o3(0xE7,0xBE,0xB9), o3(0xE7,0xBE,0xAE),
     o3(0xE7,0xBE,0xB6), o3(0xE7,0xBE,0xB8),
     o3(0xE8,0xAD,0xB1), o3(0xE7,0xBF,0x85),
     o3(0xE7,0xBF,0x86), o3(0xE7,0xBF,0x8A),
     o3(0xE7,0xBF,0x95), o3(0xE7,0xBF,0x94),
     o3(0xE7,0xBF,0xA1), o3(0xE7,0xBF,0xA6),
     o3(0xE7,0xBF,0xA9), o3(0xE7,0xBF,0xB3),
     o3(0xE7,0xBF,0xB9), o3(0xE9,0xA3,0x9C),
     o3(0xE8,0x80,0x86), o3(0xE8,0x80,0x84),
     o3(0xE8,0x80,0x8B), o3(0xE8,0x80,0x92),
     o3(0xE8,0x80,0x98), o3(0xE8,0x80,0x99),
     o3(0xE8,0x80,0x9C), o3(0xE8,0x80,0xA1),
     o3(0xE8,0x80,0xA8), o3(0xE8,0x80,0xBF),
     o3(0xE8,0x80,0xBB), o3(0xE8,0x81,0x8A),
     o3(0xE8,0x81,0x86), o3(0xE8,0x81,0x92),
     o3(0xE8,0x81,0x98), o3(0xE8,0x81,0x9A),
     o3(0xE8,0x81,0x9F), o3(0xE8,0x81,0xA2),
     o3(0xE8,0x81,0xA8), o3(0xE8,0x81,0xB3),
     o3(0xE8,0x81,0xB2), o3(0xE8,0x81,0xB0),
     o3(0xE8,0x81,0xB6), o3(0xE8,0x81,0xB9),
     o3(0xE8,0x81,0xBD), o3(0xE8,0x81,0xBF),
     o3(0xE8,0x82,0x84), o3(0xE8,0x82,0x86),
     o3(0xE8,0x82,0x85), o3(0xE8,0x82,0x9B),
     o3(0xE8,0x82,0x93), o3(0xE8,0x82,0x9A),
     o3(0xE8,0x82,0xAD), o3(0xE5,0x86,0x90),
     o3(0xE8,0x82,0xAC), o3(0xE8,0x83,0x9B),
     o3(0xE8,0x83,0xA5), o3(0xE8,0x83,0x99),
     o3(0xE8,0x83,0x9D), o3(0xE8,0x83,0x84),
     o3(0xE8,0x83,0x9A), o3(0xE8,0x83,0x96),
     o3(0xE8,0x84,0x89), o3(0xE8,0x83,0xAF),
     o3(0xE8,0x83,0xB1), o3(0xE8,0x84,0x9B),
     o3(0xE8,0x84,0xA9), o3(0xE8,0x84,0xA3),
     o3(0xE8,0x84,0xAF), o3(0xE8,0x85,0x8B),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_E6 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_E6_infos
};

static const struct byte_lookup* const
from_EUC_JP_E7_infos[95] = {
     o3(0xE9,0x9A,0x8B), o3(0xE8,0x85,0x86),
     o3(0xE8,0x84,0xBE), o3(0xE8,0x85,0x93),
     o3(0xE8,0x85,0x91), o3(0xE8,0x83,0xBC),
     o3(0xE8,0x85,0xB1), o3(0xE8,0x85,0xAE),
     o3(0xE8,0x85,0xA5), o3(0xE8,0x85,0xA6),
     o3(0xE8,0x85,0xB4), o3(0xE8,0x86,0x83),
     o3(0xE8,0x86,0x88), o3(0xE8,0x86,0x8A),
     o3(0xE8,0x86,0x80), o3(0xE8,0x86,0x82),
     o3(0xE8,0x86,0xA0), o3(0xE8,0x86,0x95),
     o3(0xE8,0x86,0xA4), o3(0xE8,0x86,0xA3),
     o3(0xE8,0x85,0x9F), o3(0xE8,0x86,0x93),
     o3(0xE8,0x86,0xA9), o3(0xE8,0x86,0xB0),
     o3(0xE8,0x86,0xB5), o3(0xE8,0x86,0xBE),
     o3(0xE8,0x86,0xB8), o3(0xE8,0x86,0xBD),
     o3(0xE8,0x87,0x80), o3(0xE8,0x87,0x82),
     o3(0xE8,0x86,0xBA), o3(0xE8,0x87,0x89),
     o3(0xE8,0x87,0x8D), o3(0xE8,0x87,0x91),
     o3(0xE8,0x87,0x99), o3(0xE8,0x87,0x98),
     o3(0xE8,0x87,0x88), o3(0xE8,0x87,0x9A),
     o3(0xE8,0x87,0x9F), o3(0xE8,0x87,0xA0),
     o3(0xE8,0x87,0xA7), o3(0xE8,0x87,0xBA),
     o3(0xE8,0x87,0xBB), o3(0xE8,0x87,0xBE),
     o3(0xE8,0x88,0x81), o3(0xE8,0x88,0x82),
     o3(0xE8,0x88,0x85), o3(0xE8,0x88,0x87),
     o3(0xE8,0x88,0x8A), o3(0xE8,0x88,0x8D),
     o3(0xE8,0x88,0x90), o3(0xE8,0x88,0x96),
     o3(0xE8,0x88,0xA9), o3(0xE8,0x88,0xAB),
     o3(0xE8,0x88,0xB8), o3(0xE8,0x88,0xB3),
     o3(0xE8,0x89,0x80), o3(0xE8,0x89,0x99),
     o3(0xE8,0x89,0x98), o3(0xE8,0x89,0x9D),
     o3(0xE8,0x89,0x9A), o3(0xE8,0x89,0x9F),
     o3(0xE8,0x89,0xA4), o3(0xE8,0x89,0xA2),
     o3(0xE8,0x89,0xA8), o3(0xE8,0x89,0xAA),
     o3(0xE8,0x89,0xAB), o3(0xE8,0x88,0xAE),
     o3(0xE8,0x89,0xB1), o3(0xE8,0x89,0xB7),
     o3(0xE8,0x89,0xB8), o3(0xE8,0x89,0xBE),
     o3(0xE8,0x8A,0x8D), o3(0xE8,0x8A,0x92),
     o3(0xE8,0x8A,0xAB), o3(0xE8,0x8A,0x9F),
     o3(0xE8,0x8A,0xBB), o3(0xE8,0x8A,0xAC),
     o3(0xE8,0x8B,0xA1), o3(0xE8,0x8B,0xA3),
     o3(0xE8,0x8B,0x9F), o3(0xE8,0x8B,0x92),
     o3(0xE8,0x8B,0xB4), o3(0xE8,0x8B,0xB3),
     o3(0xE8,0x8B,0xBA), o3(0xE8,0x8E,0x93),
     o3(0xE8,0x8C,0x83), o3(0xE8,0x8B,0xBB),
     o3(0xE8,0x8B,0xB9), o3(0xE8,0x8B,0x9E),
     o3(0xE8,0x8C,0x86), o3(0xE8,0x8B,0x9C),
     o3(0xE8,0x8C,0x89), o3(0xE8,0x8B,0x99),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_E7 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_E7_infos
};

static const struct byte_lookup* const
from_EUC_JP_E8_infos[95] = {
     o3(0xE8,0x8C,0xB5), o3(0xE8,0x8C,0xB4),
     o3(0xE8,0x8C,0x96), o3(0xE8,0x8C,0xB2),
     o3(0xE8,0x8C,0xB1), o3(0xE8,0x8D,0x80),
     o3(0xE8,0x8C,0xB9), o3(0xE8,0x8D,0x90),
     o3(0xE8,0x8D,0x85), o3(0xE8,0x8C,0xAF),
     o3(0xE8,0x8C,0xAB), o3(0xE8,0x8C,0x97),
     o3(0xE8,0x8C,0x98), o3(0xE8,0x8E,0x85),
     o3(0xE8,0x8E,0x9A), o3(0xE8,0x8E,0xAA),
     o3(0xE8,0x8E,0x9F), o3(0xE8,0x8E,0xA2),
     o3(0xE8,0x8E,0x96), o3(0xE8,0x8C,0xA3),
     o3(0xE8,0x8E,0x8E), o3(0xE8,0x8E,0x87),
     o3(0xE8,0x8E,0x8A), o3(0xE8,0x8D,0xBC),
     o3(0xE8,0x8E,0xB5), o3(0xE8,0x8D,0xB3),
     o3(0xE8,0x8D,0xB5), o3(0xE8,0x8E,0xA0),
     o3(0xE8,0x8E,0x89), o3(0xE8,0x8E,0xA8),
     o3(0xE8,0x8F,0xB4), o3(0xE8,0x90,0x93),
     o3(0xE8,0x8F,0xAB), o3(0xE8,0x8F,0x8E),
     o3(0xE8,0x8F,0xBD), o3(0xE8,0x90,0x83),
     o3(0xE8,0x8F,0x98), o3(0xE8,0x90,0x8B),
     o3(0xE8,0x8F,0x81), o3(0xE8,0x8F,0xB7),
     o3(0xE8,0x90,0x87), o3(0xE8,0x8F,0xA0),
     o3(0xE8,0x8F,0xB2), o3(0xE8,0x90,0x8D),
     o3(0xE8,0x90,0xA2), o3(0xE8,0x90,0xA0),
     o3(0xE8,0x8E,0xBD), o3(0xE8,0x90,0xB8),
     o3(0xE8,0x94,0x86), o3(0xE8,0x8F,0xBB),
     o3(0xE8,0x91,0xAD), o3(0xE8,0x90,0xAA),
     o3(0xE8,0x90,0xBC), o3(0xE8,0x95,0x9A),
     o3(0xE8,0x92,0x84), o3(0xE8,0x91,0xB7),
     o3(0xE8,0x91,0xAB), o3(0xE8,0x92,0xAD),
     o3(0xE8,0x91,0xAE), o3(0xE8,0x92,0x82),
     o3(0xE8,0x91,0xA9), o3(0xE8,0x91,0x86),
     o3(0xE8,0x90,0xAC), o3(0xE8,0x91,0xAF),
     o3(0xE8,0x91,0xB9), o3(0xE8,0x90,0xB5),
     o3(0xE8,0x93,0x8A), o3(0xE8,0x91,0xA2),
     o3(0xE8,0x92,0xB9), o3(0xE8,0x92,0xBF),
     o3(0xE8,0x92,0x9F), o3(0xE8,0x93,0x99),
     o3(0xE8,0x93,0x8D), o3(0xE8,0x92,0xBB),
     o3(0xE8,0x93,0x9A), o3(0xE8,0x93,0x90),
     o3(0xE8,0x93,0x81), o3(0xE8,0x93,0x86),
     o3(0xE8,0x93,0x96), o3(0xE8,0x92,0xA1),
     o3(0xE8,0x94,0xA1), o3(0xE8,0x93,0xBF),
     o3(0xE8,0x93,0xB4), o3(0xE8,0x94,0x97),
     o3(0xE8,0x94,0x98), o3(0xE8,0x94,0xAC),
     o3(0xE8,0x94,0x9F), o3(0xE8,0x94,0x95),
     o3(0xE8,0x94,0x94), o3(0xE8,0x93,0xBC),
     o3(0xE8,0x95,0x80), o3(0xE8,0x95,0xA3),
     o3(0xE8,0x95,0x98), o3(0xE8,0x95,0x88),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_E8 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_E8_infos
};

static const struct byte_lookup* const
from_EUC_JP_E9_infos[95] = {
     o3(0xE8,0x95,0x81), o3(0xE8,0x98,0x82),
     o3(0xE8,0x95,0x8B), o3(0xE8,0x95,0x95),
     o3(0xE8,0x96,0x80), o3(0xE8,0x96,0xA4),
     o3(0xE8,0x96,0x88), o3(0xE8,0x96,0x91),
     o3(0xE8,0x96,0x8A), o3(0xE8,0x96,0xA8),
     o3(0xE8,0x95,0xAD), o3(0xE8,0x96,0x94),
     o3(0xE8,0x96,0x9B), o3(0xE8,0x97,0xAA),
     o3(0xE8,0x96,0x87), o3(0xE8,0x96,0x9C),
     o3(0xE8,0x95,0xB7), o3(0xE8,0x95,0xBE),
     o3(0xE8,0x96,0x90), o3(0xE8,0x97,0x89),
     o3(0xE8,0x96,0xBA), o3(0xE8,0x97,0x8F),
     o3(0xE8,0x96,0xB9), o3(0xE8,0x97,0x90),
     o3(0xE8,0x97,0x95), o3(0xE8,0x97,0x9D),
     o3(0xE8,0x97,0xA5), o3(0xE8,0x97,0x9C),
     o3(0xE8,0x97,0xB9), o3(0xE8,0x98,0x8A),
     o3(0xE8,0x98,0x93), o3(0xE8,0x98,0x8B),
     o3(0xE8,0x97,0xBE), o3(0xE8,0x97,0xBA),
     o3(0xE8,0x98,0x86), o3(0xE8,0x98,0xA2),
     o3(0xE8,0x98,0x9A), o3(0xE8,0x98,0xB0),
     o3(0xE8,0x98,0xBF), o3(0xE8,0x99,0x8D),
     o3(0xE4,0xB9,0x95), o3(0xE8,0x99,0x94),
     o3(0xE8,0x99,0x9F), o3(0xE8,0x99,0xA7),
     o3(0xE8,0x99,0xB1), o3(0xE8,0x9A,0x93),
     o3(0xE8,0x9A,0xA3), o3(0xE8,0x9A,0xA9),
     o3(0xE8,0x9A,0xAA), o3(0xE8,0x9A,0x8B),
     o3(0xE8,0x9A,0x8C), o3(0xE8,0x9A,0xB6),
     o3(0xE8,0x9A,0xAF), o3(0xE8,0x9B,0x84),
     o3(0xE8,0x9B,0x86), o3(0xE8,0x9A,0xB0),
     o3(0xE8,0x9B,0x89), o3(0xE8,0xA0,0xA3),
     o3(0xE8,0x9A,0xAB), o3(0xE8,0x9B,0x94),
     o3(0xE8,0x9B,0x9E), o3(0xE8,0x9B,0xA9),
     o3(0xE8,0x9B,0xAC), o3(0xE8,0x9B,0x9F),
     o3(0xE8,0x9B,0x9B), o3(0xE8,0x9B,0xAF),
     o3(0xE8,0x9C,0x92), o3(0xE8,0x9C,0x86),
     o3(0xE8,0x9C,0x88), o3(0xE8,0x9C,0x80),
     o3(0xE8,0x9C,0x83), o3(0xE8,0x9B,0xBB),
     o3(0xE8,0x9C,0x91), o3(0xE8,0x9C,0x89),
     o3(0xE8,0x9C,0x8D), o3(0xE8,0x9B,0xB9),
     o3(0xE8,0x9C,0x8A), o3(0xE8,0x9C,0xB4),
     o3(0xE8,0x9C,0xBF), o3(0xE8,0x9C,0xB7),
     o3(0xE8,0x9C,0xBB), o3(0xE8,0x9C,0xA5),
     o3(0xE8,0x9C,0xA9), o3(0xE8,0x9C,0x9A),
     o3(0xE8,0x9D,0xA0), o3(0xE8,0x9D,0x9F),
     o3(0xE8,0x9D,0xB8), o3(0xE8,0x9D,0x8C),
     o3(0xE8,0x9D,0x8E), o3(0xE8,0x9D,0xB4),
     o3(0xE8,0x9D,0x97), o3(0xE8,0x9D,0xA8),
     o3(0xE8,0x9D,0xAE), o3(0xE8,0x9D,0x99),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_E9 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_E9_infos
};

static const struct byte_lookup* const
from_EUC_JP_EA_infos[95] = {
     o3(0xE8,0x9D,0x93), o3(0xE8,0x9D,0xA3),
     o3(0xE8,0x9D,0xAA), o3(0xE8,0xA0,0x85),
     o3(0xE8,0x9E,0xA2), o3(0xE8,0x9E,0x9F),
     o3(0xE8,0x9E,0x82), o3(0xE8,0x9E,0xAF),
     o3(0xE8,0x9F,0x8B), o3(0xE8,0x9E,0xBD),
     o3(0xE8,0x9F,0x80), o3(0xE8,0x9F,0x90),
     o3(0xE9,0x9B,0x96), o3(0xE8,0x9E,0xAB),
     o3(0xE8,0x9F,0x84), o3(0xE8,0x9E,0xB3),
     o3(0xE8,0x9F,0x87), o3(0xE8,0x9F,0x86),
     o3(0xE8,0x9E,0xBB), o3(0xE8,0x9F,0xAF),
     o3(0xE8,0x9F,0xB2), o3(0xE8,0x9F,0xA0),
     o3(0xE8,0xA0,0x8F), o3(0xE8,0xA0,0x8D),
     o3(0xE8,0x9F,0xBE), o3(0xE8,0x9F,0xB6),
     o3(0xE8,0x9F,0xB7), o3(0xE8,0xA0,0x8E),
     o3(0xE8,0x9F,0x92), o3(0xE8,0xA0,0x91),
     o3(0xE8,0xA0,0x96), o3(0xE8,0xA0,0x95),
     o3(0xE8,0xA0,0xA2), o3(0xE8,0xA0,0xA1),
     o3(0xE8,0xA0,0xB1), o3(0xE8,0xA0,0xB6),
     o3(0xE8,0xA0,0xB9), o3(0xE8,0xA0,0xA7),
     o3(0xE8,0xA0,0xBB), o3(0xE8,0xA1,0x84),
     o3(0xE8,0xA1,0x82), o3(0xE8,0xA1,0x92),
     o3(0xE8,0xA1,0x99), o3(0xE8,0xA1,0x9E),
     o3(0xE8,0xA1,0xA2), o3(0xE8,0xA1,0xAB),
     o3(0xE8,0xA2,0x81), o3(0xE8,0xA1,0xBE),
     o3(0xE8,0xA2,0x9E), o3(0xE8,0xA1,0xB5),
     o3(0xE8,0xA1,0xBD), o3(0xE8,0xA2,0xB5),
     o3(0xE8,0xA1,0xB2), o3(0xE8,0xA2,0x82),
     o3(0xE8,0xA2,0x97), o3(0xE8,0xA2,0x92),
     o3(0xE8,0xA2,0xAE), o3(0xE8,0xA2,0x99),
     o3(0xE8,0xA2,0xA2), o3(0xE8,0xA2,0x8D),
     o3(0xE8,0xA2,0xA4), o3(0xE8,0xA2,0xB0),
     o3(0xE8,0xA2,0xBF), o3(0xE8,0xA2,0xB1),
     o3(0xE8,0xA3,0x83), o3(0xE8,0xA3,0x84),
     o3(0xE8,0xA3,0x94), o3(0xE8,0xA3,0x98),
     o3(0xE8,0xA3,0x99), o3(0xE8,0xA3,0x9D),
     o3(0xE8,0xA3,0xB9), o3(0xE8,0xA4,0x82),
     o3(0xE8,0xA3,0xBC), o3(0xE8,0xA3,0xB4),
     o3(0xE8,0xA3,0xA8), o3(0xE8,0xA3,0xB2),
     o3(0xE8,0xA4,0x84), o3(0xE8,0xA4,0x8C),
     o3(0xE8,0xA4,0x8A), o3(0xE8,0xA4,0x93),
     o3(0xE8,0xA5,0x83), o3(0xE8,0xA4,0x9E),
     o3(0xE8,0xA4,0xA5), o3(0xE8,0xA4,0xAA),
     o3(0xE8,0xA4,0xAB), o3(0xE8,0xA5,0x81),
     o3(0xE8,0xA5,0x84), o3(0xE8,0xA4,0xBB),
     o3(0xE8,0xA4,0xB6), o3(0xE8,0xA4,0xB8),
     o3(0xE8,0xA5,0x8C), o3(0xE8,0xA4,0x9D),
     o3(0xE8,0xA5,0xA0), o3(0xE8,0xA5,0x9E),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_EA = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_EA_infos
};

static const struct byte_lookup* const
from_EUC_JP_EB_infos[95] = {
     o3(0xE8,0xA5,0xA6), o3(0xE8,0xA5,0xA4),
     o3(0xE8,0xA5,0xAD), o3(0xE8,0xA5,0xAA),
     o3(0xE8,0xA5,0xAF), o3(0xE8,0xA5,0xB4),
     o3(0xE8,0xA5,0xB7), o3(0xE8,0xA5,0xBE),
     o3(0xE8,0xA6,0x83), o3(0xE8,0xA6,0x88),
     o3(0xE8,0xA6,0x8A), o3(0xE8,0xA6,0x93),
     o3(0xE8,0xA6,0x98), o3(0xE8,0xA6,0xA1),
     o3(0xE8,0xA6,0xA9), o3(0xE8,0xA6,0xA6),
     o3(0xE8,0xA6,0xAC), o3(0xE8,0xA6,0xAF),
     o3(0xE8,0xA6,0xB2), o3(0xE8,0xA6,0xBA),
     o3(0xE8,0xA6,0xBD), o3(0xE8,0xA6,0xBF),
     o3(0xE8,0xA7,0x80), o3(0xE8,0xA7,0x9A),
     o3(0xE8,0xA7,0x9C), o3(0xE8,0xA7,0x9D),
     o3(0xE8,0xA7,0xA7), o3(0xE8,0xA7,0xB4),
     o3(0xE8,0xA7,0xB8), o3(0xE8,0xA8,0x83),
     o3(0xE8,0xA8,0x96), o3(0xE8,0xA8,0x90),
     o3(0xE8,0xA8,0x8C), o3(0xE8,0xA8,0x9B),
     o3(0xE8,0xA8,0x9D), o3(0xE8,0xA8,0xA5),
     o3(0xE8,0xA8,0xB6), o3(0xE8,0xA9,0x81),
     o3(0xE8,0xA9,0x9B), o3(0xE8,0xA9,0x92),
     o3(0xE8,0xA9,0x86), o3(0xE8,0xA9,0x88),
     o3(0xE8,0xA9,0xBC), o3(0xE8,0xA9,0xAD),
     o3(0xE8,0xA9,0xAC), o3(0xE8,0xA9,0xA2),
     o3(0xE8,0xAA,0x85), o3(0xE8,0xAA,0x82),
     o3(0xE8,0xAA,0x84), o3(0xE8,0xAA,0xA8),
     o3(0xE8,0xAA,0xA1), o3(0xE8,0xAA,0x91),
     o3(0xE8,0xAA,0xA5), o3(0xE8,0xAA,0xA6),
     o3(0xE8,0xAA,0x9A), o3(0xE8,0xAA,0xA3),
     o3(0xE8,0xAB,0x84), o3(0xE8,0xAB,0x8D),
     o3(0xE8,0xAB,0x82), o3(0xE8,0xAB,0x9A),
     o3(0xE8,0xAB,0xAB), o3(0xE8,0xAB,0xB3),
     o3(0xE8,0xAB,0xA7), o3(0xE8,0xAB,0xA4),
     o3(0xE8,0xAB,0xB1), o3(0xE8,0xAC,0x94),
     o3(0xE8,0xAB,0xA0), o3(0xE8,0xAB,0xA2),
     o3(0xE8,0xAB,0xB7), o3(0xE8,0xAB,0x9E),
     o3(0xE8,0xAB,0x9B), o3(0xE8,0xAC,0x8C),
     o3(0xE8,0xAC,0x87), o3(0xE8,0xAC,0x9A),
     o3(0xE8,0xAB,0xA1), o3(0xE8,0xAC,0x96),
     o3(0xE8,0xAC,0x90), o3(0xE8,0xAC,0x97),
     o3(0xE8,0xAC,0xA0), o3(0xE8,0xAC,0xB3),
     o3(0xE9,0x9E,0xAB), o3(0xE8,0xAC,0xA6),
     o3(0xE8,0xAC,0xAB), o3(0xE8,0xAC,0xBE),
     o3(0xE8,0xAC,0xA8), o3(0xE8,0xAD,0x81),
     o3(0xE8,0xAD,0x8C), o3(0xE8,0xAD,0x8F),
     o3(0xE8,0xAD,0x8E), o3(0xE8,0xAD,0x89),
     o3(0xE8,0xAD,0x96), o3(0xE8,0xAD,0x9B),
     o3(0xE8,0xAD,0x9A), o3(0xE8,0xAD,0xAB),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_EB = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_EB_infos
};

static const struct byte_lookup* const
from_EUC_JP_EC_infos[95] = {
     o3(0xE8,0xAD,0x9F), o3(0xE8,0xAD,0xAC),
     o3(0xE8,0xAD,0xAF), o3(0xE8,0xAD,0xB4),
     o3(0xE8,0xAD,0xBD), o3(0xE8,0xAE,0x80),
     o3(0xE8,0xAE,0x8C), o3(0xE8,0xAE,0x8E),
     o3(0xE8,0xAE,0x92), o3(0xE8,0xAE,0x93),
     o3(0xE8,0xAE,0x96), o3(0xE8,0xAE,0x99),
     o3(0xE8,0xAE,0x9A), o3(0xE8,0xB0,0xBA),
     o3(0xE8,0xB1,0x81), o3(0xE8,0xB0,0xBF),
     o3(0xE8,0xB1,0x88), o3(0xE8,0xB1,0x8C),
     o3(0xE8,0xB1,0x8E), o3(0xE8,0xB1,0x90),
     o3(0xE8,0xB1,0x95), o3(0xE8,0xB1,0xA2),
     o3(0xE8,0xB1,0xAC), o3(0xE8,0xB1,0xB8),
     o3(0xE8,0xB1,0xBA), o3(0xE8,0xB2,0x82),
     o3(0xE8,0xB2,0x89), o3(0xE8,0xB2,0x85),
     o3(0xE8,0xB2,0x8A), o3(0xE8,0xB2,0x8D),
     o3(0xE8,0xB2,0x8E), o3(0xE8,0xB2,0x94),
     o3(0xE8,0xB1,0xBC), o3(0xE8,0xB2,0x98),
     o3(0xE6,0x88,0x9D), o3(0xE8,0xB2,0xAD),
     o3(0xE8,0xB2,0xAA), o3(0xE8,0xB2,0xBD),
     o3(0xE8,0xB2,0xB2), o3(0xE8,0xB2,0xB3),
     o3(0xE8,0xB2,0xAE), o3(0xE8,0xB2,0xB6),
     o3(0xE8,0xB3,0x88), o3(0xE8,0xB3,0x81),
     o3(0xE8,0xB3,0xA4), o3(0xE8,0xB3,0xA3),
     o3(0xE8,0xB3,0x9A), o3(0xE8,0xB3,0xBD),
     o3(0xE8,0xB3,0xBA), o3(0xE8,0xB3,0xBB),
     o3(0xE8,0xB4,0x84), o3(0xE8,0xB4,0x85),
     o3(0xE8,0xB4,0x8A), o3(0xE8,0xB4,0x87),
     o3(0xE8,0xB4,0x8F), o3(0xE8,0xB4,0x8D),
     o3(0xE8,0xB4,0x90), o3(0xE9,0xBD,0x8E),
     o3(0xE8,0xB4,0x93), o3(0xE8,0xB3,0x8D),
     o3(0xE8,0xB4,0x94), o3(0xE8,0xB4,0x96),
     o3(0xE8,0xB5,0xA7), o3(0xE8,0xB5,0xAD),
     o3(0xE8,0xB5,0xB1), o3(0xE8,0xB5,0xB3),
     o3(0xE8,0xB6,0x81), o3(0xE8,0xB6,0x99),
     o3(0xE8,0xB7,0x82), o3(0xE8,0xB6,0xBE),
     o3(0xE8,0xB6,0xBA), o3(0xE8,0xB7,0x8F),
     o3(0xE8,0xB7,0x9A), o3(0xE8,0xB7,0x96),
     o3(0xE8,0xB7,0x8C), o3(0xE8,0xB7,0x9B),
     o3(0xE8,0xB7,0x8B), o3(0xE8,0xB7,0xAA),
     o3(0xE8,0xB7,0xAB), o3(0xE8,0xB7,0x9F),
     o3(0xE8,0xB7,0xA3), o3(0xE8,0xB7,0xBC),
     o3(0xE8,0xB8,0x88), o3(0xE8,0xB8,0x89),
     o3(0xE8,0xB7,0xBF), o3(0xE8,0xB8,0x9D),
     o3(0xE8,0xB8,0x9E), o3(0xE8,0xB8,0x90),
     o3(0xE8,0xB8,0x9F), o3(0xE8,0xB9,0x82),
     o3(0xE8,0xB8,0xB5), o3(0xE8,0xB8,0xB0),
     o3(0xE8,0xB8,0xB4), o3(0xE8,0xB9,0x8A),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_EC = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_EC_infos
};

static const struct byte_lookup* const
from_EUC_JP_ED_infos[95] = {
     o3(0xE8,0xB9,0x87), o3(0xE8,0xB9,0x89),
     o3(0xE8,0xB9,0x8C), o3(0xE8,0xB9,0x90),
     o3(0xE8,0xB9,0x88), o3(0xE8,0xB9,0x99),
     o3(0xE8,0xB9,0xA4), o3(0xE8,0xB9,0xA0),
     o3(0xE8,0xB8,0xAA), o3(0xE8,0xB9,0xA3),
     o3(0xE8,0xB9,0x95), o3(0xE8,0xB9,0xB6),
     o3(0xE8,0xB9,0xB2), o3(0xE8,0xB9,0xBC),
     o3(0xE8,0xBA,0x81), o3(0xE8,0xBA,0x87),
     o3(0xE8,0xBA,0x85), o3(0xE8,0xBA,0x84),
     o3(0xE8,0xBA,0x8B), o3(0xE8,0xBA,0x8A),
     o3(0xE8,0xBA,0x93), o3(0xE8,0xBA,0x91),
     o3(0xE8,0xBA,0x94), o3(0xE8,0xBA,0x99),
     o3(0xE8,0xBA,0xAA), o3(0xE8,0xBA,0xA1),
     o3(0xE8,0xBA,0xAC), o3(0xE8,0xBA,0xB0),
     o3(0xE8,0xBB,0x86), o3(0xE8,0xBA,0xB1),
     o3(0xE8,0xBA,0xBE), o3(0xE8,0xBB,0x85),
     o3(0xE8,0xBB,0x88), o3(0xE8,0xBB,0x8B),
     o3(0xE8,0xBB,0x9B), o3(0xE8,0xBB,0xA3),
     o3(0xE8,0xBB,0xBC), o3(0xE8,0xBB,0xBB),
     o3(0xE8,0xBB,0xAB), o3(0xE8,0xBB,0xBE),
     o3(0xE8,0xBC,0x8A), o3(0xE8,0xBC,0x85),
     o3(0xE8,0xBC,0x95), o3(0xE8,0xBC,0x92),
     o3(0xE8,0xBC,0x99), o3(0xE8,0xBC,0x93),
     o3(0xE8,0xBC,0x9C), o3(0xE8,0xBC,0x9F),
     o3(0xE8,0xBC,0x9B), o3(0xE8,0xBC,0x8C),
     o3(0xE8,0xBC,0xA6), o3(0xE8,0xBC,0xB3),
     o3(0xE8,0xBC,0xBB), o3(0xE8,0xBC,0xB9),
     o3(0xE8,0xBD,0x85), o3(0xE8,0xBD,0x82),
     o3(0xE8,0xBC,0xBE), o3(0xE8,0xBD,0x8C),
     o3(0xE8,0xBD,0x89), o3(0xE8,0xBD,0x86),
     o3(0xE8,0xBD,0x8E), o3(0xE8,0xBD,0x97),
     o3(0xE8,0xBD,0x9C), o3(0xE8,0xBD,0xA2),
     o3(0xE8,0xBD,0xA3), o3(0xE8,0xBD,0xA4),
     o3(0xE8,0xBE,0x9C), o3(0xE8,0xBE,0x9F),
     o3(0xE8,0xBE,0xA3), o3(0xE8,0xBE,0xAD),
     o3(0xE8,0xBE,0xAF), o3(0xE8,0xBE,0xB7),
     o3(0xE8,0xBF,0x9A), o3(0xE8,0xBF,0xA5),
     o3(0xE8,0xBF,0xA2), o3(0xE8,0xBF,0xAA),
     o3(0xE8,0xBF,0xAF), o3(0xE9,0x82,0x87),
     o3(0xE8,0xBF,0xB4), o3(0xE9,0x80,0x85),
     o3(0xE8,0xBF,0xB9), o3(0xE8,0xBF,0xBA),
     o3(0xE9,0x80,0x91), o3(0xE9,0x80,0x95),
     o3(0xE9,0x80,0xA1), o3(0xE9,0x80,0x8D),
     o3(0xE9,0x80,0x9E), o3(0xE9,0x80,0x96),
     o3(0xE9,0x80,0x8B), o3(0xE9,0x80,0xA7),
     o3(0xE9,0x80,0xB6), o3(0xE9,0x80,0xB5),
     o3(0xE9,0x80,0xB9), o3(0xE8,0xBF,0xB8),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_ED = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_ED_infos
};

static const struct byte_lookup* const
from_EUC_JP_EE_infos[95] = {
     o3(0xE9,0x81,0x8F), o3(0xE9,0x81,0x90),
     o3(0xE9,0x81,0x91), o3(0xE9,0x81,0x92),
     o3(0xE9,0x80,0x8E), o3(0xE9,0x81,0x89),
     o3(0xE9,0x80,0xBE), o3(0xE9,0x81,0x96),
     o3(0xE9,0x81,0x98), o3(0xE9,0x81,0x9E),
     o3(0xE9,0x81,0xA8), o3(0xE9,0x81,0xAF),
     o3(0xE9,0x81,0xB6), o3(0xE9,0x9A,0xA8),
     o3(0xE9,0x81,0xB2), o3(0xE9,0x82,0x82),
     o3(0xE9,0x81,0xBD), o3(0xE9,0x82,0x81),
     o3(0xE9,0x82,0x80), o3(0xE9,0x82,0x8A),
     o3(0xE9,0x82,0x89), o3(0xE9,0x82,0x8F),
     o3(0xE9,0x82,0xA8), o3(0xE9,0x82,0xAF),
     o3(0xE9,0x82,0xB1), o3(0xE9,0x82,0xB5),
     o3(0xE9,0x83,0xA2), o3(0xE9,0x83,0xA4),
     o3(0xE6,0x89,0x88), o3(0xE9,0x83,0x9B),
     o3(0xE9,0x84,0x82), o3(0xE9,0x84,0x92),
     o3(0xE9,0x84,0x99), o3(0xE9,0x84,0xB2),
     o3(0xE9,0x84,0xB0), o3(0xE9,0x85,0x8A),
     o3(0xE9,0x85,0x96), o3(0xE9,0x85,0x98),
     o3(0xE9,0x85,0xA3), o3(0xE9,0x85,0xA5),
     o3(0xE9,0x85,0xA9), o3(0xE9,0x85,0xB3),
     o3(0xE9,0x85,0xB2), o3(0xE9,0x86,0x8B),
     o3(0xE9,0x86,0x89), o3(0xE9,0x86,0x82),
     o3(0xE9,0x86,0xA2), o3(0xE9,0x86,0xAB),
     o3(0xE9,0x86,0xAF), o3(0xE9,0x86,0xAA),
     o3(0xE9,0x86,0xB5), o3(0xE9,0x86,0xB4),
     o3(0xE9,0x86,0xBA), o3(0xE9,0x87,0x80),
     o3(0xE9,0x87,0x81), o3(0xE9,0x87,0x89),
     o3(0xE9,0x87,0x8B), o3(0xE9,0x87,0x90),
     o3(0xE9,0x87,0x96), o3(0xE9,0x87,0x9F),
     o3(0xE9,0x87,0xA1), o3(0xE9,0x87,0x9B),
     o3(0xE9,0x87,0xBC), o3(0xE9,0x87,0xB5),
     o3(0xE9,0x87,0xB6), o3(0xE9,0x88,0x9E),
     o3(0xE9,0x87,0xBF), o3(0xE9,0x88,0x94),
     o3(0xE9,0x88,0xAC), o3(0xE9,0x88,0x95),
     o3(0xE9,0x88,0x91), o3(0xE9,0x89,0x9E),
     o3(0xE9,0x89,0x97), o3(0xE9,0x89,0x85),
     o3(0xE9,0x89,0x89), o3(0xE9,0x89,0xA4),
     o3(0xE9,0x89,0x88), o3(0xE9,0x8A,0x95),
     o3(0xE9,0x88,0xBF), o3(0xE9,0x89,0x8B),
     o3(0xE9,0x89,0x90), o3(0xE9,0x8A,0x9C),
     o3(0xE9,0x8A,0x96), o3(0xE9,0x8A,0x93),
     o3(0xE9,0x8A,0x9B), o3(0xE9,0x89,0x9A),
     o3(0xE9,0x8B,0x8F), o3(0xE9,0x8A,0xB9),
     o3(0xE9,0x8A,0xB7), o3(0xE9,0x8B,0xA9),
     o3(0xE9,0x8C,0x8F), o3(0xE9,0x8B,0xBA),
     o3(0xE9,0x8D,0x84), o3(0xE9,0x8C,0xAE),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_EE = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_EE_infos
};

static const struct byte_lookup* const
from_EUC_JP_EF_infos[95] = {
     o3(0xE9,0x8C,0x99), o3(0xE9,0x8C,0xA2),
     o3(0xE9,0x8C,0x9A), o3(0xE9,0x8C,0xA3),
     o3(0xE9,0x8C,0xBA), o3(0xE9,0x8C,0xB5),
     o3(0xE9,0x8C,0xBB), o3(0xE9,0x8D,0x9C),
     o3(0xE9,0x8D,0xA0), o3(0xE9,0x8D,0xBC),
     o3(0xE9,0x8D,0xAE), o3(0xE9,0x8D,0x96),
     o3(0xE9,0x8E,0xB0), o3(0xE9,0x8E,0xAC),
     o3(0xE9,0x8E,0xAD), o3(0xE9,0x8E,0x94),
     o3(0xE9,0x8E,0xB9), o3(0xE9,0x8F,0x96),
     o3(0xE9,0x8F,0x97), o3(0xE9,0x8F,0xA8),
     o3(0xE9,0x8F,0xA5), o3(0xE9,0x8F,0x98),
     o3(0xE9,0x8F,0x83), o3(0xE9,0x8F,0x9D),
     o3(0xE9,0x8F,0x90), o3(0xE9,0x8F,0x88),
     o3(0xE9,0x8F,0xA4), o3(0xE9,0x90,0x9A),
     o3(0xE9,0x90,0x94), o3(0xE9,0x90,0x93),
     o3(0xE9,0x90,0x83), o3(0xE9,0x90,0x87),
     o3(0xE9,0x90,0x90), o3(0xE9,0x90,0xB6),
     o3(0xE9,0x90,0xAB), o3(0xE9,0x90,0xB5),
     o3(0xE9,0x90,0xA1), o3(0xE9,0x90,0xBA),
     o3(0xE9,0x91,0x81), o3(0xE9,0x91,0x92),
     o3(0xE9,0x91,0x84), o3(0xE9,0x91,0x9B),
     o3(0xE9,0x91,0xA0), o3(0xE9,0x91,0xA2),
     o3(0xE9,0x91,0x9E), o3(0xE9,0x91,0xAA),
     o3(0xE9,0x88,0xA9), o3(0xE9,0x91,0xB0),
     o3(0xE9,0x91,0xB5), o3(0xE9,0x91,0xB7),
     o3(0xE9,0x91,0xBD), o3(0xE9,0x91,0x9A),
     o3(0xE9,0x91,0xBC), o3(0xE9,0x91,0xBE),
     o3(0xE9,0x92,0x81), o3(0xE9,0x91,0xBF),
     o3(0xE9,0x96,0x82), o3(0xE9,0x96,0x87),
     o3(0xE9,0x96,0x8A), o3(0xE9,0x96,0x94),
     o3(0xE9,0x96,0x96), o3(0xE9,0x96,0x98),
     o3(0xE9,0x96,0x99), o3(0xE9,0x96,0xA0),
     o3(0xE9,0x96,0xA8), o3(0xE9,0x96,0xA7),
     o3(0xE9,0x96,0xAD), o3(0xE9,0x96,0xBC),
     o3(0xE9,0x96,0xBB), o3(0xE9,0x96,0xB9),
     o3(0xE9,0x96,0xBE), o3(0xE9,0x97,0x8A),
     o3(0xE6,0xBF,0xB6), o3(0xE9,0x97,0x83),
     o3(0xE9,0x97,0x8D), o3(0xE9,0x97,0x8C),
     o3(0xE9,0x97,0x95), o3(0xE9,0x97,0x94),
     o3(0xE9,0x97,0x96), o3(0xE9,0x97,0x9C),
     o3(0xE9,0x97,0xA1), o3(0xE9,0x97,0xA5),
     o3(0xE9,0x97,0xA2), o3(0xE9,0x98,0xA1),
     o3(0xE9,0x98,0xA8), o3(0xE9,0x98,0xAE),
     o3(0xE9,0x98,0xAF), o3(0xE9,0x99,0x82),
     o3(0xE9,0x99,0x8C), o3(0xE9,0x99,0x8F),
     o3(0xE9,0x99,0x8B), o3(0xE9,0x99,0xB7),
     o3(0xE9,0x99,0x9C), o3(0xE9,0x99,0x9E),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_EF = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_EF_infos
};

static const struct byte_lookup* const
from_EUC_JP_F0_infos[95] = {
     o3(0xE9,0x99,0x9D), o3(0xE9,0x99,0x9F),
     o3(0xE9,0x99,0xA6), o3(0xE9,0x99,0xB2),
     o3(0xE9,0x99,0xAC), o3(0xE9,0x9A,0x8D),
     o3(0xE9,0x9A,0x98), o3(0xE9,0x9A,0x95),
     o3(0xE9,0x9A,0x97), o3(0xE9,0x9A,0xAA),
     o3(0xE9,0x9A,0xA7), o3(0xE9,0x9A,0xB1),
     o3(0xE9,0x9A,0xB2), o3(0xE9,0x9A,0xB0),
     o3(0xE9,0x9A,0xB4), o3(0xE9,0x9A,0xB6),
     o3(0xE9,0x9A,0xB8), o3(0xE9,0x9A,0xB9),
     o3(0xE9,0x9B,0x8E), o3(0xE9,0x9B,0x8B),
     o3(0xE9,0x9B,0x89), o3(0xE9,0x9B,0x8D),
     o3(0xE8,0xA5,0x8D), o3(0xE9,0x9B,0x9C),
     o3(0xE9,0x9C,0x8D), o3(0xE9,0x9B,0x95),
     o3(0xE9,0x9B,0xB9), o3(0xE9,0x9C,0x84),
     o3(0xE9,0x9C,0x86), o3(0xE9,0x9C,0x88),
     o3(0xE9,0x9C,0x93), o3(0xE9,0x9C,0x8E),
     o3(0xE9,0x9C,0x91), o3(0xE9,0x9C,0x8F),
     o3(0xE9,0x9C,0x96), o3(0xE9,0x9C,0x99),
     o3(0xE9,0x9C,0xA4), o3(0xE9,0x9C,0xAA),
     o3(0xE9,0x9C,0xB0), o3(0xE9,0x9C,0xB9),
     o3(0xE9,0x9C,0xBD), o3(0xE9,0x9C,0xBE),
     o3(0xE9,0x9D,0x84), o3(0xE9,0x9D,0x86),
     o3(0xE9,0x9D,0x88), o3(0xE9,0x9D,0x82),
     o3(0xE9,0x9D,0x89), o3(0xE9,0x9D,0x9C),
     o3(0xE9,0x9D,0xA0), o3(0xE9,0x9D,0xA4),
     o3(0xE9,0x9D,0xA6), o3(0xE9,0x9D,0xA8),
     o3(0xE5,0x8B,0x92), o3(0xE9,0x9D,0xAB),
     o3(0xE9,0x9D,0xB1), o3(0xE9,0x9D,0xB9),
     o3(0xE9,0x9E,0x85), o3(0xE9,0x9D,0xBC),
     o3(0xE9,0x9E,0x81), o3(0xE9,0x9D,0xBA),
     o3(0xE9,0x9E,0x86), o3(0xE9,0x9E,0x8B),
     o3(0xE9,0x9E,0x8F), o3(0xE9,0x9E,0x90),
     o3(0xE9,0x9E,0x9C), o3(0xE9,0x9E,0xA8),
     o3(0xE9,0x9E,0xA6), o3(0xE9,0x9E,0xA3),
     o3(0xE9,0x9E,0xB3), o3(0xE9,0x9E,0xB4),
     o3(0xE9,0x9F,0x83), o3(0xE9,0x9F,0x86),
     o3(0xE9,0x9F,0x88), o3(0xE9,0x9F,0x8B),
     o3(0xE9,0x9F,0x9C), o3(0xE9,0x9F,0xAD),
     o3(0xE9,0xBD,0x8F), o3(0xE9,0x9F,0xB2),
     o3(0xE7,0xAB,0x9F), o3(0xE9,0x9F,0xB6),
     o3(0xE9,0x9F,0xB5), o3(0xE9,0xA0,0x8F),
     o3(0xE9,0xA0,0x8C), o3(0xE9,0xA0,0xB8),
     o3(0xE9,0xA0,0xA4), o3(0xE9,0xA0,0xA1),
     o3(0xE9,0xA0,0xB7), o3(0xE9,0xA0,0xBD),
     o3(0xE9,0xA1,0x86), o3(0xE9,0xA1,0x8F),
     o3(0xE9,0xA1,0x8B), o3(0xE9,0xA1,0xAB),
     o3(0xE9,0xA1,0xAF), o3(0xE9,0xA1,0xB0),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_F0 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_F0_infos
};

static const struct byte_lookup* const
from_EUC_JP_F1_infos[95] = {
     o3(0xE9,0xA1,0xB1), o3(0xE9,0xA1,0xB4),
     o3(0xE9,0xA1,0xB3), o3(0xE9,0xA2,0xAA),
     o3(0xE9,0xA2,0xAF), o3(0xE9,0xA2,0xB1),
     o3(0xE9,0xA2,0xB6), o3(0xE9,0xA3,0x84),
     o3(0xE9,0xA3,0x83), o3(0xE9,0xA3,0x86),
     o3(0xE9,0xA3,0xA9), o3(0xE9,0xA3,0xAB),
     o3(0xE9,0xA4,0x83), o3(0xE9,0xA4,0x89),
     o3(0xE9,0xA4,0x92), o3(0xE9,0xA4,0x94),
     o3(0xE9,0xA4,0x98), o3(0xE9,0xA4,0xA1),
     o3(0xE9,0xA4,0x9D), o3(0xE9,0xA4,0x9E),
     o3(0xE9,0xA4,0xA4), o3(0xE9,0xA4,0xA0),
     o3(0xE9,0xA4,0xAC), o3(0xE9,0xA4,0xAE),
     o3(0xE9,0xA4,0xBD), o3(0xE9,0xA4,0xBE),
     o3(0xE9,0xA5,0x82), o3(0xE9,0xA5,0x89),
     o3(0xE9,0xA5,0x85), o3(0xE9,0xA5,0x90),
     o3(0xE9,0xA5,0x8B), o3(0xE9,0xA5,0x91),
     o3(0xE9,0xA5,0x92), o3(0xE9,0xA5,0x8C),
     o3(0xE9,0xA5,0x95), o3(0xE9,0xA6,0x97),
     o3(0xE9,0xA6,0x98), o3(0xE9,0xA6,0xA5),
     o3(0xE9,0xA6,0xAD), o3(0xE9,0xA6,0xAE),
     o3(0xE9,0xA6,0xBC), o3(0xE9,0xA7,0x9F),
     o3(0xE9,0xA7,0x9B), o3(0xE9,0xA7,0x9D),
     o3(0xE9,0xA7,0x98), o3(0xE9,0xA7,0x91),
     o3(0xE9,0xA7,0xAD), o3(0xE9,0xA7,0xAE),
     o3(0xE9,0xA7,0xB1), o3(0xE9,0xA7,0xB2),
     o3(0xE9,0xA7,0xBB), o3(0xE9,0xA7,0xB8),
     o3(0xE9,0xA8,0x81), o3(0xE9,0xA8,0x8F),
     o3(0xE9,0xA8,0x85), o3(0xE9,0xA7,0xA2),
     o3(0xE9,0xA8,0x99), o3(0xE9,0xA8,0xAB),
     o3(0xE9,0xA8,0xB7), o3(0xE9,0xA9,0x85),
     o3(0xE9,0xA9,0x82), o3(0xE9,0xA9,0x80),
     o3(0xE9,0xA9,0x83), o3(0xE9,0xA8,0xBE),
     o3(0xE9,0xA9,0x95), o3(0xE9,0xA9,0x8D),
     o3(0xE9,0xA9,0x9B), o3(0xE9,0xA9,0x97),
     o3(0xE9,0xA9,0x9F), o3(0xE9,0xA9,0xA2),
     o3(0xE9,0xA9,0xA5), o3(0xE9,0xA9,0xA4),
     o3(0xE9,0xA9,0xA9), o3(0xE9,0xA9,0xAB),
     o3(0xE9,0xA9,0xAA), o3(0xE9,0xAA,0xAD),
     o3(0xE9,0xAA,0xB0), o3(0xE9,0xAA,0xBC),
     o3(0xE9,0xAB,0x80), o3(0xE9,0xAB,0x8F),
     o3(0xE9,0xAB,0x91), o3(0xE9,0xAB,0x93),
     o3(0xE9,0xAB,0x94), o3(0xE9,0xAB,0x9E),
     o3(0xE9,0xAB,0x9F), o3(0xE9,0xAB,0xA2),
     o3(0xE9,0xAB,0xA3), o3(0xE9,0xAB,0xA6),
     o3(0xE9,0xAB,0xAF), o3(0xE9,0xAB,0xAB),
     o3(0xE9,0xAB,0xAE), o3(0xE9,0xAB,0xB4),
     o3(0xE9,0xAB,0xB1), o3(0xE9,0xAB,0xB7),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_F1 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_F1_infos
};

static const struct byte_lookup* const
from_EUC_JP_F2_infos[95] = {
     o3(0xE9,0xAB,0xBB), o3(0xE9,0xAC,0x86),
     o3(0xE9,0xAC,0x98), o3(0xE9,0xAC,0x9A),
     o3(0xE9,0xAC,0x9F), o3(0xE9,0xAC,0xA2),
     o3(0xE9,0xAC,0xA3), o3(0xE9,0xAC,0xA5),
     o3(0xE9,0xAC,0xA7), o3(0xE9,0xAC,0xA8),
     o3(0xE9,0xAC,0xA9), o3(0xE9,0xAC,0xAA),
     o3(0xE9,0xAC,0xAE), o3(0xE9,0xAC,0xAF),
     o3(0xE9,0xAC,0xB2), o3(0xE9,0xAD,0x84),
     o3(0xE9,0xAD,0x83), o3(0xE9,0xAD,0x8F),
     o3(0xE9,0xAD,0x8D), o3(0xE9,0xAD,0x8E),
     o3(0xE9,0xAD,0x91), o3(0xE9,0xAD,0x98),
     o3(0xE9,0xAD,0xB4), o3(0xE9,0xAE,0x93),
     o3(0xE9,0xAE,0x83), o3(0xE9,0xAE,0x91),
     o3(0xE9,0xAE,0x96), o3(0xE9,0xAE,0x97),
     o3(0xE9,0xAE,0x9F), o3(0xE9,0xAE,0xA0),
     o3(0xE9,0xAE,0xA8), o3(0xE9,0xAE,0xB4),
     o3(0xE9,0xAF,0x80), o3(0xE9,0xAF,0x8A),
     o3(0xE9,0xAE,0xB9), o3(0xE9,0xAF,0x86),
     o3(0xE9,0xAF,0x8F), o3(0xE9,0xAF,0x91),
     o3(0xE9,0xAF,0x92), o3(0xE9,0xAF,0xA3),
     o3(0xE9,0xAF,0xA2), o3(0xE9,0xAF,0xA4),
     o3(0xE9,0xAF,0x94), o3(0xE9,0xAF,0xA1),
     o3(0xE9,0xB0,0xBA), o3(0xE9,0xAF,0xB2),
     o3(0xE9,0xAF,0xB1), o3(0xE9,0xAF,0xB0),
     o3(0xE9,0xB0,0x95), o3(0xE9,0xB0,0x94),
     o3(0xE9,0xB0,0x89), o3(0xE9,0xB0,0x93),
     o3(0xE9,0xB0,0x8C), o3(0xE9,0xB0,0x86),
     o3(0xE9,0xB0,0x88), o3(0xE9,0xB0,0x92),
     o3(0xE9,0xB0,0x8A), o3(0xE9,0xB0,0x84),
     o3(0xE9,0xB0,0xAE), o3(0xE9,0xB0,0x9B),
     o3(0xE9,0xB0,0xA5), o3(0xE9,0xB0,0xA4),
     o3(0xE9,0xB0,0xA1), o3(0xE9,0xB0,0xB0),
     o3(0xE9,0xB1,0x87), o3(0xE9,0xB0,0xB2),
     o3(0xE9,0xB1,0x86), o3(0xE9,0xB0,0xBE),
     o3(0xE9,0xB1,0x9A), o3(0xE9,0xB1,0xA0),
     o3(0xE9,0xB1,0xA7), o3(0xE9,0xB1,0xB6),
     o3(0xE9,0xB1,0xB8), o3(0xE9,0xB3,0xA7),
     o3(0xE9,0xB3,0xAC), o3(0xE9,0xB3,0xB0),
     o3(0xE9,0xB4,0x89), o3(0xE9,0xB4,0x88),
     o3(0xE9,0xB3,0xAB), o3(0xE9,0xB4,0x83),
     o3(0xE9,0xB4,0x86), o3(0xE9,0xB4,0xAA),
     o3(0xE9,0xB4,0xA6), o3(0xE9,0xB6,0xAF),
     o3(0xE9,0xB4,0xA3), o3(0xE9,0xB4,0x9F),
     o3(0xE9,0xB5,0x84), o3(0xE9,0xB4,0x95),
     o3(0xE9,0xB4,0x92), o3(0xE9,0xB5,0x81),
     o3(0xE9,0xB4,0xBF), o3(0xE9,0xB4,0xBE),
     o3(0xE9,0xB5,0x86), o3(0xE9,0xB5,0x88),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_F2 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_F2_infos
};

static const struct byte_lookup* const
from_EUC_JP_F3_infos[95] = {
     o3(0xE9,0xB5,0x9D), o3(0xE9,0xB5,0x9E),
     o3(0xE9,0xB5,0xA4), o3(0xE9,0xB5,0x91),
     o3(0xE9,0xB5,0x90), o3(0xE9,0xB5,0x99),
     o3(0xE9,0xB5,0xB2), o3(0xE9,0xB6,0x89),
     o3(0xE9,0xB6,0x87), o3(0xE9,0xB6,0xAB),
     o3(0xE9,0xB5,0xAF), o3(0xE9,0xB5,0xBA),
     o3(0xE9,0xB6,0x9A), o3(0xE9,0xB6,0xA4),
     o3(0xE9,0xB6,0xA9), o3(0xE9,0xB6,0xB2),
     o3(0xE9,0xB7,0x84), o3(0xE9,0xB7,0x81),
     o3(0xE9,0xB6,0xBB), o3(0xE9,0xB6,0xB8),
     o3(0xE9,0xB6,0xBA), o3(0xE9,0xB7,0x86),
     o3(0xE9,0xB7,0x8F), o3(0xE9,0xB7,0x82),
     o3(0xE9,0xB7,0x99), o3(0xE9,0xB7,0x93),
     o3(0xE9,0xB7,0xB8), o3(0xE9,0xB7,0xA6),
     o3(0xE9,0xB7,0xAD), o3(0xE9,0xB7,0xAF),
     o3(0xE9,0xB7,0xBD), o3(0xE9,0xB8,0x9A),
     o3(0xE9,0xB8,0x9B), o3(0xE9,0xB8,0x9E),
     o3(0xE9,0xB9,0xB5), o3(0xE9,0xB9,0xB9),
     o3(0xE9,0xB9,0xBD), o3(0xE9,0xBA,0x81),
     o3(0xE9,0xBA,0x88), o3(0xE9,0xBA,0x8B),
     o3(0xE9,0xBA,0x8C), o3(0xE9,0xBA,0x92),
     o3(0xE9,0xBA,0x95), o3(0xE9,0xBA,0x91),
     o3(0xE9,0xBA,0x9D), o3(0xE9,0xBA,0xA5),
     o3(0xE9,0xBA,0xA9), o3(0xE9,0xBA,0xB8),
     o3(0xE9,0xBA,0xAA), o3(0xE9,0xBA,0xAD),
     o3(0xE9,0x9D,0xA1), o3(0xE9,0xBB,0x8C),
     o3(0xE9,0xBB,0x8E), o3(0xE9,0xBB,0x8F),
     o3(0xE9,0xBB,0x90), o3(0xE9,0xBB,0x94),
     o3(0xE9,0xBB,0x9C), o3(0xE9,0xBB,0x9E),
     o3(0xE9,0xBB,0x9D), o3(0xE9,0xBB,0xA0),
     o3(0xE9,0xBB,0xA5), o3(0xE9,0xBB,0xA8),
     o3(0xE9,0xBB,0xAF), o3(0xE9,0xBB,0xB4),
     o3(0xE9,0xBB,0xB6), o3(0xE9,0xBB,0xB7),
     o3(0xE9,0xBB,0xB9), o3(0xE9,0xBB,0xBB),
     o3(0xE9,0xBB,0xBC), o3(0xE9,0xBB,0xBD),
     o3(0xE9,0xBC,0x87), o3(0xE9,0xBC,0x88),
     o3(0xE7,0x9A,0xB7), o3(0xE9,0xBC,0x95),
     o3(0xE9,0xBC,0xA1), o3(0xE9,0xBC,0xAC),
     o3(0xE9,0xBC,0xBE), o3(0xE9,0xBD,0x8A),
     o3(0xE9,0xBD,0x92), o3(0xE9,0xBD,0x94),
     o3(0xE9,0xBD,0xA3), o3(0xE9,0xBD,0x9F),
     o3(0xE9,0xBD,0xA0), o3(0xE9,0xBD,0xA1),
     o3(0xE9,0xBD,0xA6), o3(0xE9,0xBD,0xA7),
     o3(0xE9,0xBD,0xAC), o3(0xE9,0xBD,0xAA),
     o3(0xE9,0xBD,0xB7), o3(0xE9,0xBD,0xB2),
     o3(0xE9,0xBD,0xB6), o3(0xE9,0xBE,0x95),
     o3(0xE9,0xBE,0x9C), o3(0xE9,0xBE,0xA0),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_F3 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_F3_infos
};

static const unsigned char
from_EUC_JP_F4_offsets[256] = {
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  0,  1,  2,  3,  4,  5,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,    6,  6,  6,  6,  6,  6,  6,  6,
};
static const struct byte_lookup* const
from_EUC_JP_F4_infos[7] = {
     o3(0xE5,0xA0,0xAF), o3(0xE6,0xA7,0x87),
     o3(0xE9,0x81,0x99), o3(0xE7,0x91,0xA4),
     o3(0xE5,0x87,0x9C), o3(0xE7,0x86,0x99),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_F4 = {
    from_EUC_JP_F4_offsets,
    from_EUC_JP_F4_infos
};

static const struct byte_lookup* const
from_EUC_JP_F9_infos[95] = {
     o3(0xE7,0xBA,0x8A), o3(0xE8,0xA4,0x9C),
     o3(0xE9,0x8D,0x88), o3(0xE9,0x8A,0x88),
     o3(0xE8,0x93,0x9C), o3(0xE4,0xBF,0x89),
     o3(0xE7,0x82,0xBB), o3(0xE6,0x98,0xB1),
     o3(0xE6,0xA3,0x88), o3(0xE9,0x8B,0xB9),
     o3(0xE6,0x9B,0xBB), o3(0xE5,0xBD,0x85),
     o3(0xE4,0xB8,0xA8), o3(0xE4,0xBB,0xA1),
     o3(0xE4,0xBB,0xBC), o3(0xE4,0xBC,0x80),
     o3(0xE4,0xBC,0x83), o3(0xE4,0xBC,0xB9),
     o3(0xE4,0xBD,0x96), o3(0xE4,0xBE,0x92),
     o3(0xE4,0xBE,0x8A), o3(0xE4,0xBE,0x9A),
     o3(0xE4,0xBE,0x94), o3(0xE4,0xBF,0x8D),
     o3(0xE5,0x81,0x80), o3(0xE5,0x80,0xA2),
     o3(0xE4,0xBF,0xBF), o3(0xE5,0x80,0x9E),
     o3(0xE5,0x81,0x86), o3(0xE5,0x81,0xB0),
     o3(0xE5,0x81,0x82), o3(0xE5,0x82,0x94),
     o3(0xE5,0x83,0xB4), o3(0xE5,0x83,0x98),
     o3(0xE5,0x85,0x8A), o3(0xE5,0x85,0xA4),
     o3(0xE5,0x86,0x9D), o3(0xE5,0x86,0xBE),
     o3(0xE5,0x87,0xAC), o3(0xE5,0x88,0x95),
     o3(0xE5,0x8A,0x9C), o3(0xE5,0x8A,0xA6),
     o3(0xE5,0x8B,0x80), o3(0xE5,0x8B,0x9B),
     o3(0xE5,0x8C,0x80), o3(0xE5,0x8C,0x87),
     o3(0xE5,0x8C,0xA4), o3(0xE5,0x8D,0xB2),
     o3(0xE5,0x8E,0x93), o3(0xE5,0x8E,0xB2),
     o3(0xE5,0x8F,0x9D), o3(0xEF,0xA8,0x8E),
     o3(0xE5,0x92,0x9C), o3(0xE5,0x92,0x8A),
     o3(0xE5,0x92,0xA9), o3(0xE5,0x93,0xBF),
     o3(0xE5,0x96,0x86), o3(0xE5,0x9D,0x99),
     o3(0xE5,0x9D,0xA5), o3(0xE5,0x9E,0xAC),
     o3(0xE5,0x9F,0x88), o3(0xE5,0x9F,0x87),
     o3(0xEF,0xA8,0x8F), o3(0xEF,0xA8,0x90),
     o3(0xE5,0xA2,0x9E), o3(0xE5,0xA2,0xB2),
     o3(0xE5,0xA4,0x8B), o3(0xE5,0xA5,0x93),
     o3(0xE5,0xA5,0x9B), o3(0xE5,0xA5,0x9D),
     o3(0xE5,0xA5,0xA3), o3(0xE5,0xA6,0xA4),
     o3(0xE5,0xA6,0xBA), o3(0xE5,0xAD,0x96),
     o3(0xE5,0xAF,0x80), o3(0xE7,0x94,0xAF),
     o3(0xE5,0xAF,0x98), o3(0xE5,0xAF,0xAC),
     o3(0xE5,0xB0,0x9E), o3(0xE5,0xB2,0xA6),
     o3(0xE5,0xB2,0xBA), o3(0xE5,0xB3,0xB5),
     o3(0xE5,0xB4,0xA7), o3(0xE5,0xB5,0x93),
     o3(0xEF,0xA8,0x91), o3(0xE5,0xB5,0x82),
     o3(0xE5,0xB5,0xAD), o3(0xE5,0xB6,0xB8),
     o3(0xE5,0xB6,0xB9), o3(0xE5,0xB7,0x90),
     o3(0xE5,0xBC,0xA1), o3(0xE5,0xBC,0xB4),
     o3(0xE5,0xBD,0xA7), o3(0xE5,0xBE,0xB7),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_F9 = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_F9_infos
};

static const struct byte_lookup* const
from_EUC_JP_FA_infos[95] = {
     o3(0xE5,0xBF,0x9E), o3(0xE6,0x81,0x9D),
     o3(0xE6,0x82,0x85), o3(0xE6,0x82,0x8A),
     o3(0xE6,0x83,0x9E), o3(0xE6,0x83,0x95),
     o3(0xE6,0x84,0xA0), o3(0xE6,0x83,0xB2),
     o3(0xE6,0x84,0x91), o3(0xE6,0x84,0xB7),
     o3(0xE6,0x84,0xB0), o3(0xE6,0x86,0x98),
     o3(0xE6,0x88,0x93), o3(0xE6,0x8A,0xA6),
     o3(0xE6,0x8F,0xB5), o3(0xE6,0x91,0xA0),
     o3(0xE6,0x92,0x9D), o3(0xE6,0x93,0x8E),
     o3(0xE6,0x95,0x8E), o3(0xE6,0x98,0x80),
     o3(0xE6,0x98,0x95), o3(0xE6,0x98,0xBB),
     o3(0xE6,0x98,0x89), o3(0xE6,0x98,0xAE),
     o3(0xE6,0x98,0x9E), o3(0xE6,0x98,0xA4),
     o3(0xE6,0x99,0xA5), o3(0xE6,0x99,0x97),
     o3(0xE6,0x99,0x99), o3(0xEF,0xA8,0x92),
     o3(0xE6,0x99,0xB3), o3(0xE6,0x9A,0x99),
     o3(0xE6,0x9A,0xA0), o3(0xE6,0x9A,0xB2),
     o3(0xE6,0x9A,0xBF), o3(0xE6,0x9B,0xBA),
     o3(0xE6,0x9C,0x8E), o3(0xEF,0xA4,0xA9),
     o3(0xE6,0x9D,0xA6), o3(0xE6,0x9E,0xBB),
     o3(0xE6,0xA1,0x92), o3(0xE6,0x9F,0x80),
     o3(0xE6,0xA0,0x81), o3(0xE6,0xA1,0x84),
     o3(0xE6,0xA3,0x8F), o3(0xEF,0xA8,0x93),
     o3(0xE6,0xA5,0xA8), o3(0xEF,0xA8,0x94),
     o3(0xE6,0xA6,0x98), o3(0xE6,0xA7,0xA2),
     o3(0xE6,0xA8,0xB0), o3(0xE6,0xA9,0xAB),
     o3(0xE6,0xA9,0x86), o3(0xE6,0xA9,0xB3),
     o3(0xE6,0xA9,0xBE), o3(0xE6,0xAB,0xA2),
     o3(0xE6,0xAB,0xA4), o3(0xE6,0xAF,0x96),
     o3(0xE6,0xB0,0xBF), o3(0xE6,0xB1,0x9C),
     o3(0xE6,0xB2,0x86), o3(0xE6,0xB1,0xAF),
     o3(0xE6,0xB3,0x9A), o3(0xE6,0xB4,0x84),
     o3(0xE6,0xB6,0x87), o3(0xE6,0xB5,0xAF),
     o3(0xE6,0xB6,0x96), o3(0xE6,0xB6,0xAC),
     o3(0xE6,0xB7,0x8F), o3(0xE6,0xB7,0xB8),
     o3(0xE6,0xB7,0xB2), o3(0xE6,0xB7,0xBC),
     o3(0xE6,0xB8,0xB9), o3(0xE6,0xB9,0x9C),
     o3(0xE6,0xB8,0xA7), o3(0xE6,0xB8,0xBC),
     o3(0xE6,0xBA,0xBF), o3(0xE6,0xBE,0x88),
     o3(0xE6,0xBE,0xB5), o3(0xE6,0xBF,0xB5),
     o3(0xE7,0x80,0x85), o3(0xE7,0x80,0x87),
     o3(0xE7,0x80,0xA8), o3(0xE7,0x82,0x85),
     o3(0xE7,0x82,0xAB), o3(0xE7,0x84,0x8F),
     o3(0xE7,0x84,0x84), o3(0xE7,0x85,0x9C),
     o3(0xE7,0x85,0x86), o3(0xE7,0x85,0x87),
     o3(0xEF,0xA8,0x95), o3(0xE7,0x87,0x81),
     o3(0xE7,0x87,0xBE), o3(0xE7,0x8A,0xB1),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_FA = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_FA_infos
};

static const struct byte_lookup* const
from_EUC_JP_FB_infos[95] = {
     o3(0xE7,0x8A,0xBE), o3(0xE7,0x8C,0xA4),
     o3(0xEF,0xA8,0x96), o3(0xE7,0x8D,0xB7),
     o3(0xE7,0x8E,0xBD), o3(0xE7,0x8F,0x89),
     o3(0xE7,0x8F,0x96), o3(0xE7,0x8F,0xA3),
     o3(0xE7,0x8F,0x92), o3(0xE7,0x90,0x87),
     o3(0xE7,0x8F,0xB5), o3(0xE7,0x90,0xA6),
     o3(0xE7,0x90,0xAA), o3(0xE7,0x90,0xA9),
     o3(0xE7,0x90,0xAE), o3(0xE7,0x91,0xA2),
     o3(0xE7,0x92,0x89), o3(0xE7,0x92,0x9F),
     o3(0xE7,0x94,0x81), o3(0xE7,0x95,0xAF),
     o3(0xE7,0x9A,0x82), o3(0xE7,0x9A,0x9C),
     o3(0xE7,0x9A,0x9E), o3(0xE7,0x9A,0x9B),
     o3(0xE7,0x9A,0xA6), o3(0xEF,0xA8,0x97),
     o3(0xE7,0x9D,0x86), o3(0xE5,0x8A,0xAF),
     o3(0xE7,0xA0,0xA1), o3(0xE7,0xA1,0x8E),
     o3(0xE7,0xA1,0xA4), o3(0xE7,0xA1,0xBA),
     o3(0xE7,0xA4,0xB0), o3(0xEF,0xA8,0x98),
     o3(0xEF,0xA8,0x99), o3(0xEF,0xA8,0x9A),
     o3(0xE7,0xA6,0x94), o3(0xEF,0xA8,0x9B),
     o3(0xE7,0xA6,0x9B), o3(0xE7,0xAB,0x91),
     o3(0xE7,0xAB,0xA7), o3(0xEF,0xA8,0x9C),
     o3(0xE7,0xAB,0xAB), o3(0xE7,0xAE,0x9E),
     o3(0xEF,0xA8,0x9D), o3(0xE7,0xB5,0x88),
     o3(0xE7,0xB5,0x9C), o3(0xE7,0xB6,0xB7),
     o3(0xE7,0xB6,0xA0), o3(0xE7,0xB7,0x96),
     o3(0xE7,0xB9,0x92), o3(0xE7,0xBD,0x87),
     o3(0xE7,0xBE,0xA1), o3(0xEF,0xA8,0x9E),
     o3(0xE8,0x8C,0x81), o3(0xE8,0x8D,0xA2),
     o3(0xE8,0x8D,0xBF), o3(0xE8,0x8F,0x87),
     o3(0xE8,0x8F,0xB6), o3(0xE8,0x91,0x88),
     o3(0xE8,0x92,0xB4), o3(0xE8,0x95,0x93),
     o3(0xE8,0x95,0x99), o3(0xE8,0x95,0xAB),
     o3(0xEF,0xA8,0x9F), o3(0xE8,0x96,0xB0),
     o3(0xEF,0xA8,0xA0), o3(0xEF,0xA8,0xA1),
     o3(0xE8,0xA0,0x87), o3(0xE8,0xA3,0xB5),
     o3(0xE8,0xA8,0x92), o3(0xE8,0xA8,0xB7),
     o3(0xE8,0xA9,0xB9), o3(0xE8,0xAA,0xA7),
     o3(0xE8,0xAA,0xBE), o3(0xE8,0xAB,0x9F),
     o3(0xEF,0xA8,0xA2), o3(0xE8,0xAB,0xB6),
     o3(0xE8,0xAD,0x93), o3(0xE8,0xAD,0xBF),
     o3(0xE8,0xB3,0xB0), o3(0xE8,0xB3,0xB4),
     o3(0xE8,0xB4,0x92), o3(0xE8,0xB5,0xB6),
     o3(0xEF,0xA8,0xA3), o3(0xE8,0xBB,0x8F),
     o3(0xEF,0xA8,0xA4), o3(0xEF,0xA8,0xA5),
     o3(0xE9,0x81,0xA7), o3(0xE9,0x83,0x9E),
     o3(0xEF,0xA8,0xA6), o3(0xE9,0x84,0x95),
     o3(0xE9,0x84,0xA7), o3(0xE9,0x87,0x9A),
                  UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_FB = {
    from_EUC_JP_A1_offsets,
    from_EUC_JP_FB_infos
};

static const unsigned char
from_EUC_JP_FC_offsets[256] = {
     91, 91, 91, 91, 91, 91, 91, 91,   91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,   91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,   91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,   91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,   91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,   91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,   91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,   91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,   91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91,   91, 91, 91, 91, 91, 91, 91, 91,
     91,  0,  1,  2,  3,  4,  5,  6,    7,  8,  9, 10, 11, 12, 13, 14,
     15, 16, 17, 18, 19, 20, 21, 22,   23, 24, 25, 26, 27, 28, 29, 30,
     31, 32, 33, 34, 35, 36, 37, 38,   39, 40, 41, 42, 43, 44, 45, 46,
     47, 48, 49, 50, 51, 52, 53, 54,   55, 56, 57, 58, 59, 60, 61, 62,
     63, 64, 65, 66, 67, 68, 69, 70,   71, 72, 73, 74, 75, 76, 77, 91,
     91, 78, 79, 80, 81, 82, 83, 84,   85, 86, 87, 91, 88, 89, 90, 91,
};
static const struct byte_lookup* const
from_EUC_JP_FC_infos[92] = {
     o3(0xE9,0x87,0x97), o3(0xE9,0x87,0x9E),
     o3(0xE9,0x87,0xAD), o3(0xE9,0x87,0xAE),
     o3(0xE9,0x87,0xA4), o3(0xE9,0x87,0xA5),
     o3(0xE9,0x88,0x86), o3(0xE9,0x88,0x90),
     o3(0xE9,0x88,0x8A), o3(0xE9,0x88,0xBA),
     o3(0xE9,0x89,0x80), o3(0xE9,0x88,0xBC),
     o3(0xE9,0x89,0x8E), o3(0xE9,0x89,0x99),
     o3(0xE9,0x89,0x91), o3(0xE9,0x88,0xB9),
     o3(0xE9,0x89,0xA7), o3(0xE9,0x8A,0xA7),
     o3(0xE9,0x89,0xB7), o3(0xE9,0x89,0xB8),
     o3(0xE9,0x8B,0xA7), o3(0xE9,0x8B,0x97),
     o3(0xE9,0x8B,0x99), o3(0xE9,0x8B,0x90),
     o3(0xEF,0xA8,0xA7), o3(0xE9,0x8B,0x95),
     o3(0xE9,0x8B,0xA0), o3(0xE9,0x8B,0x93),
     o3(0xE9,0x8C,0xA5), o3(0xE9,0x8C,0xA1),
     o3(0xE9,0x8B,0xBB), o3(0xEF,0xA8,0xA8),
     o3(0xE9,0x8C,0x9E), o3(0xE9,0x8B,0xBF),
     o3(0xE9,0x8C,0x9D), o3(0xE9,0x8C,0x82),
     o3(0xE9,0x8D,0xB0), o3(0xE9,0x8D,0x97),
     o3(0xE9,0x8E,0xA4), o3(0xE9,0x8F,0x86),
     o3(0xE9,0x8F,0x9E), o3(0xE9,0x8F,0xB8),
     o3(0xE9,0x90,0xB1), o3(0xE9,0x91,0x85),
     o3(0xE9,0x91,0x88), o3(0xE9,0x96,0x92),
     o3(0xEF,0xA7,0x9C), o3(0xEF,0xA8,0xA9),
     o3(0xE9,0x9A,0x9D), o3(0xE9,0x9A,0xAF),
     o3(0xE9,0x9C,0xB3), o3(0xE9,0x9C,0xBB),
     o3(0xE9,0x9D,0x83), o3(0xE9,0x9D,0x8D),
     o3(0xE9,0x9D,0x8F), o3(0xE9,0x9D,0x91),
     o3(0xE9,0x9D,0x95), o3(0xE9,0xA1,0x97),
     o3(0xE9,0xA1,0xA5), o3(0xEF,0xA8,0xAA),
     o3(0xEF,0xA8,0xAB), o3(0xE9,0xA4,0xA7),
     o3(0xEF,0xA8,0xAC), o3(0xE9,0xA6,0x9E),
     o3(0xE9,0xA9,0x8E), o3(0xE9,0xAB,0x99),
     o3(0xE9,0xAB,0x9C), o3(0xE9,0xAD,0xB5),
     o3(0xE9,0xAD,0xB2), o3(0xE9,0xAE,0x8F),
     o3(0xE9,0xAE,0xB1), o3(0xE9,0xAE,0xBB),
     o3(0xE9,0xB0,0x80), o3(0xE9,0xB5,0xB0),
     o3(0xE9,0xB5,0xAB), o3(0xEF,0xA8,0xAD),
     o3(0xE9,0xB8,0x99), o3(0xE9,0xBB,0x91),
     o3(0xE2,0x85,0xB0), o3(0xE2,0x85,0xB1),
     o3(0xE2,0x85,0xB2), o3(0xE2,0x85,0xB3),
     o3(0xE2,0x85,0xB4), o3(0xE2,0x85,0xB5),
     o3(0xE2,0x85,0xB6), o3(0xE2,0x85,0xB7),
     o3(0xE2,0x85,0xB8), o3(0xE2,0x85,0xB9),
     o3(0xEF,0xBF,0xA4), o3(0xEF,0xBC,0x87),
     o3(0xEF,0xBC,0x82),              UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP_FC = {
    from_EUC_JP_FC_offsets,
    from_EUC_JP_FC_infos
};

static const unsigned char
from_EUC_JP_offsets[256] = {
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
     84, 84, 84, 84, 84, 84, 84, 84,   84, 84, 84, 84, 84, 84,  1, 84,
     84, 84, 84, 84, 84, 84, 84, 84,   84, 84, 84, 84, 84, 84, 84, 84,
     84,  2,  3,  4,  5,  6,  7,  8,    9, 84, 84, 84, 84, 10, 84, 84,
     11, 12, 13, 14, 15, 16, 17, 18,   19, 20, 21, 22, 23, 24, 25, 26,
     27, 28, 29, 30, 31, 32, 33, 34,   35, 36, 37, 38, 39, 40, 41, 42,
     43, 44, 45, 46, 47, 48, 49, 50,   51, 52, 53, 54, 55, 56, 57, 58,
     59, 60, 61, 62, 63, 64, 65, 66,   67, 68, 69, 70, 71, 72, 73, 74,
     75, 76, 77, 78, 79, 84, 84, 84,   84, 80, 81, 82, 83, 84, 84, 84,
};
static const struct byte_lookup* const
from_EUC_JP_infos[85] = {
               NOMAP, &from_EUC_JP_8E, &from_EUC_JP_A1, &from_EUC_JP_A2,
     &from_EUC_JP_A3, &from_EUC_JP_A4, &from_EUC_JP_A5, &from_EUC_JP_A6,
     &from_EUC_JP_A7, &from_EUC_JP_A8, &from_EUC_JP_AD, &from_EUC_JP_B0,
     &from_EUC_JP_B1, &from_EUC_JP_B2, &from_EUC_JP_B3, &from_EUC_JP_B4,
     &from_EUC_JP_B5, &from_EUC_JP_B6, &from_EUC_JP_B7, &from_EUC_JP_B8,
     &from_EUC_JP_B9, &from_EUC_JP_BA, &from_EUC_JP_BB, &from_EUC_JP_BC,
     &from_EUC_JP_BD, &from_EUC_JP_BE, &from_EUC_JP_BF, &from_EUC_JP_C0,
     &from_EUC_JP_C1, &from_EUC_JP_C2, &from_EUC_JP_C3, &from_EUC_JP_C4,
     &from_EUC_JP_C5, &from_EUC_JP_C6, &from_EUC_JP_C7, &from_EUC_JP_C8,
     &from_EUC_JP_C9, &from_EUC_JP_CA, &from_EUC_JP_CB, &from_EUC_JP_CC,
     &from_EUC_JP_CD, &from_EUC_JP_CE, &from_EUC_JP_CF, &from_EUC_JP_D0,
     &from_EUC_JP_D1, &from_EUC_JP_D2, &from_EUC_JP_D3, &from_EUC_JP_D4,
     &from_EUC_JP_D5, &from_EUC_JP_D6, &from_EUC_JP_D7, &from_EUC_JP_D8,
     &from_EUC_JP_D9, &from_EUC_JP_DA, &from_EUC_JP_DB, &from_EUC_JP_DC,
     &from_EUC_JP_DD, &from_EUC_JP_DE, &from_EUC_JP_DF, &from_EUC_JP_E0,
     &from_EUC_JP_E1, &from_EUC_JP_E2, &from_EUC_JP_E3, &from_EUC_JP_E4,
     &from_EUC_JP_E5, &from_EUC_JP_E6, &from_EUC_JP_E7, &from_EUC_JP_E8,
     &from_EUC_JP_E9, &from_EUC_JP_EA, &from_EUC_JP_EB, &from_EUC_JP_EC,
     &from_EUC_JP_ED, &from_EUC_JP_EE, &from_EUC_JP_EF, &from_EUC_JP_F0,
     &from_EUC_JP_F1, &from_EUC_JP_F2, &from_EUC_JP_F3, &from_EUC_JP_F4,
     &from_EUC_JP_F9, &from_EUC_JP_FA, &from_EUC_JP_FB, &from_EUC_JP_FC,
               UNDEF,
};
static const BYTE_LOOKUP
from_EUC_JP = {
    from_EUC_JP_offsets,
    from_EUC_JP_infos
};
static const rb_transcoder
rb_from_EUC_JP = {
    "EUC-JP", "UTF-8", &from_EUC_JP, 3, 0,
    NULL, NULL,
};

static const struct byte_lookup* const
to_EUC_JP_C2_infos[14] = {
     o2(0xA1,0xF1), o2(0xA1,0xF2), o2(0xA1,0xEF), o2(0xFC,0xFC),
     o2(0xA1,0xF8), o2(0xA1,0xAF), o2(0xA2,0xCC), o2(0xA1,0xB1),
     o2(0xA1,0xEB), o2(0xA1,0xDE), o2(0xA1,0xAD), o2(0xA2,0xF9),
     o2(0xA1,0xA4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_C2 = {
    to_SHIFT_JIS_C2_offsets,
    to_EUC_JP_C2_infos
};

static const struct byte_lookup* const
to_EUC_JP_C3_infos[3] = {
     o2(0xA1,0xDF), o2(0xA1,0xE0),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_C3 = {
    to_SHIFT_JIS_C3_offsets,
    to_EUC_JP_C3_infos
};

static const struct byte_lookup* const
to_EUC_JP_CE_infos[40] = {
     o2(0xA6,0xA1), o2(0xA6,0xA2), o2(0xA6,0xA3), o2(0xA6,0xA4),
     o2(0xA6,0xA5), o2(0xA6,0xA6), o2(0xA6,0xA7), o2(0xA6,0xA8),
     o2(0xA6,0xA9), o2(0xA6,0xAA), o2(0xA6,0xAB), o2(0xA6,0xAC),
     o2(0xA6,0xAD), o2(0xA6,0xAE), o2(0xA6,0xAF), o2(0xA6,0xB0),
     o2(0xA6,0xB1), o2(0xA6,0xB2), o2(0xA6,0xB3), o2(0xA6,0xB4),
     o2(0xA6,0xB5), o2(0xA6,0xB6), o2(0xA6,0xB7), o2(0xA6,0xB8),
     o2(0xA6,0xC1), o2(0xA6,0xC2), o2(0xA6,0xC3), o2(0xA6,0xC4),
     o2(0xA6,0xC5), o2(0xA6,0xC6), o2(0xA6,0xC7), o2(0xA6,0xC8),
     o2(0xA6,0xC9), o2(0xA6,0xCA), o2(0xA6,0xCB), o2(0xA6,0xCC),
     o2(0xA6,0xCD), o2(0xA6,0xCE), o2(0xA6,0xCF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_CE = {
    to_SHIFT_JIS_CE_offsets,
    to_EUC_JP_CE_infos
};

static const struct byte_lookup* const
to_EUC_JP_CF_infos[10] = {
     o2(0xA6,0xD0), o2(0xA6,0xD1), o2(0xA6,0xD2), o2(0xA6,0xD3),
     o2(0xA6,0xD4), o2(0xA6,0xD5), o2(0xA6,0xD6), o2(0xA6,0xD7),
     o2(0xA6,0xD8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_CF = {
    to_SHIFT_JIS_CF_offsets,
    to_EUC_JP_CF_infos
};

static const struct byte_lookup* const
to_EUC_JP_D0_infos[50] = {
     o2(0xA7,0xA7), o2(0xA7,0xA1), o2(0xA7,0xA2), o2(0xA7,0xA3),
     o2(0xA7,0xA4), o2(0xA7,0xA5), o2(0xA7,0xA6), o2(0xA7,0xA8),
     o2(0xA7,0xA9), o2(0xA7,0xAA), o2(0xA7,0xAB), o2(0xA7,0xAC),
     o2(0xA7,0xAD), o2(0xA7,0xAE), o2(0xA7,0xAF), o2(0xA7,0xB0),
     o2(0xA7,0xB1), o2(0xA7,0xB2), o2(0xA7,0xB3), o2(0xA7,0xB4),
     o2(0xA7,0xB5), o2(0xA7,0xB6), o2(0xA7,0xB7), o2(0xA7,0xB8),
     o2(0xA7,0xB9), o2(0xA7,0xBA), o2(0xA7,0xBB), o2(0xA7,0xBC),
     o2(0xA7,0xBD), o2(0xA7,0xBE), o2(0xA7,0xBF), o2(0xA7,0xC0),
     o2(0xA7,0xC1), o2(0xA7,0xD1), o2(0xA7,0xD2), o2(0xA7,0xD3),
     o2(0xA7,0xD4), o2(0xA7,0xD5), o2(0xA7,0xD6), o2(0xA7,0xD8),
     o2(0xA7,0xD9), o2(0xA7,0xDA), o2(0xA7,0xDB), o2(0xA7,0xDC),
     o2(0xA7,0xDD), o2(0xA7,0xDE), o2(0xA7,0xDF), o2(0xA7,0xE0),
     o2(0xA7,0xE1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_D0 = {
    to_SHIFT_JIS_D0_offsets,
    to_EUC_JP_D0_infos
};

static const struct byte_lookup* const
to_EUC_JP_D1_infos[18] = {
     o2(0xA7,0xE2), o2(0xA7,0xE3), o2(0xA7,0xE4), o2(0xA7,0xE5),
     o2(0xA7,0xE6), o2(0xA7,0xE7), o2(0xA7,0xE8), o2(0xA7,0xE9),
     o2(0xA7,0xEA), o2(0xA7,0xEB), o2(0xA7,0xEC), o2(0xA7,0xED),
     o2(0xA7,0xEE), o2(0xA7,0xEF), o2(0xA7,0xF0), o2(0xA7,0xF1),
     o2(0xA7,0xD7),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_D1 = {
    to_SHIFT_JIS_D1_offsets,
    to_EUC_JP_D1_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_80_infos[16] = {
     o2(0xA1,0xBE), o2(0xA1,0xBD), o2(0xA1,0xC2), o2(0xA1,0xC6),
     o2(0xA1,0xC7), o2(0xA1,0xC8), o2(0xA1,0xC9), o2(0xA2,0xF7),
     o2(0xA2,0xF8), o2(0xA1,0xC5), o2(0xA1,0xC4), o2(0xA2,0xF3),
     o2(0xA1,0xEC), o2(0xA1,0xED), o2(0xA2,0xA8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_80 = {
    to_SHIFT_JIS_E2_80_offsets,
    to_EUC_JP_E2_80_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_84_infos[5] = {
     o2(0xA1,0xEE), o2(0xAD,0xE2), o2(0xAD,0xE4), o2(0xA2,0xF2),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_84 = {
    to_SHIFT_JIS_E2_84_offsets,
    to_EUC_JP_E2_84_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_85_infos[21] = {
     o2(0xAD,0xB5), o2(0xAD,0xB6), o2(0xAD,0xB7), o2(0xAD,0xB8),
     o2(0xAD,0xB9), o2(0xAD,0xBA), o2(0xAD,0xBB), o2(0xAD,0xBC),
     o2(0xAD,0xBD), o2(0xAD,0xBE), o2(0xFC,0xF1), o2(0xFC,0xF2),
     o2(0xFC,0xF3), o2(0xFC,0xF4), o2(0xFC,0xF5), o2(0xFC,0xF6),
     o2(0xFC,0xF7), o2(0xFC,0xF8), o2(0xFC,0xF9), o2(0xFC,0xFA),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_85 = {
    to_SHIFT_JIS_E2_85_offsets,
    to_EUC_JP_E2_85_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_86_infos[5] = {
     o2(0xA2,0xAB), o2(0xA2,0xAC), o2(0xA2,0xAA), o2(0xA2,0xAD),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_86 = {
    to_SHIFT_JIS_E2_86_offsets,
    to_EUC_JP_E2_86_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_87_infos[3] = {
     o2(0xA2,0xCD), o2(0xA2,0xCE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_87 = {
    to_SHIFT_JIS_E2_87_offsets,
    to_EUC_JP_E2_87_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_88_infos[24] = {
     o2(0xA2,0xCF), o2(0xA2,0xDF), o2(0xA2,0xD0), o2(0xA2,0xE0),
     o2(0xA2,0xBA), o2(0xA2,0xBB), o2(0xAD,0xF4), o2(0xA1,0xDD),
     o2(0xAD,0xF5), o2(0xA2,0xE7), o2(0xA1,0xE7), o2(0xAD,0xF8),
     o2(0xAD,0xF7), o2(0xA2,0xCA), o2(0xA2,0xCB), o2(0xAD,0xFB),
     o2(0xAD,0xFC), o2(0xAD,0xF2), o2(0xA2,0xEA), o2(0xAD,0xF3),
     o2(0xA1,0xE8), o2(0xAD,0xFA), o2(0xA2,0xE6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_88 = {
    to_SHIFT_JIS_E2_88_offsets,
    to_EUC_JP_E2_88_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_89_infos[8] = {
     o2(0xAD,0xF0), o2(0xA1,0xE2), o2(0xAD,0xF1), o2(0xA1,0xE5),
     o2(0xA1,0xE6), o2(0xA2,0xE3), o2(0xA2,0xE4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_89 = {
    to_SHIFT_JIS_E2_89_offsets,
    to_EUC_JP_E2_89_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_8A_infos[7] = {
     o2(0xA2,0xBE), o2(0xA2,0xBF), o2(0xA2,0xBC), o2(0xA2,0xBD),
     o2(0xAD,0xF6), o2(0xAD,0xF9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_8A = {
    to_SHIFT_JIS_E2_8A_offsets,
    to_EUC_JP_E2_8A_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_8C_infos[2] = {
     o2(0xA2,0xDE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_8C = {
    to_SHIFT_JIS_E2_8C_offsets,
    to_EUC_JP_E2_8C_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_91_infos[21] = {
     o2(0xAD,0xA1), o2(0xAD,0xA2), o2(0xAD,0xA3), o2(0xAD,0xA4),
     o2(0xAD,0xA5), o2(0xAD,0xA6), o2(0xAD,0xA7), o2(0xAD,0xA8),
     o2(0xAD,0xA9), o2(0xAD,0xAA), o2(0xAD,0xAB), o2(0xAD,0xAC),
     o2(0xAD,0xAD), o2(0xAD,0xAE), o2(0xAD,0xAF), o2(0xAD,0xB0),
     o2(0xAD,0xB1), o2(0xAD,0xB2), o2(0xAD,0xB3), o2(0xAD,0xB4),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_91 = {
    to_SHIFT_JIS_E2_91_offsets,
    to_EUC_JP_E2_91_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_94_infos[31] = {
     o2(0xA8,0xA1), o2(0xA8,0xAC), o2(0xA8,0xA2), o2(0xA8,0xAD),
     o2(0xA8,0xA3), o2(0xA8,0xAE), o2(0xA8,0xA4), o2(0xA8,0xAF),
     o2(0xA8,0xA6), o2(0xA8,0xB1), o2(0xA8,0xA5), o2(0xA8,0xB0),
     o2(0xA8,0xA7), o2(0xA8,0xBC), o2(0xA8,0xB7), o2(0xA8,0xB2),
     o2(0xA8,0xA9), o2(0xA8,0xBE), o2(0xA8,0xB9), o2(0xA8,0xB4),
     o2(0xA8,0xA8), o2(0xA8,0xB8), o2(0xA8,0xBD), o2(0xA8,0xB3),
     o2(0xA8,0xAA), o2(0xA8,0xBA), o2(0xA8,0xBF), o2(0xA8,0xB5),
     o2(0xA8,0xAB), o2(0xA8,0xBB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_94 = {
    to_SHIFT_JIS_E2_94_offsets,
    to_EUC_JP_E2_94_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_95_infos[3] = {
     o2(0xA8,0xC0), o2(0xA8,0xB6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_95 = {
    to_SHIFT_JIS_E2_95_offsets,
    to_EUC_JP_E2_95_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_96_infos[7] = {
     o2(0xA2,0xA3), o2(0xA2,0xA2), o2(0xA2,0xA5), o2(0xA2,0xA4),
     o2(0xA2,0xA7), o2(0xA2,0xA6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_96 = {
    to_SHIFT_JIS_E2_96_offsets,
    to_EUC_JP_E2_96_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_97_infos[7] = {
     o2(0xA2,0xA1), o2(0xA1,0xFE), o2(0xA1,0xFB), o2(0xA1,0xFD),
     o2(0xA1,0xFC), o2(0xA2,0xFE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_97 = {
    to_SHIFT_JIS_E2_97_offsets,
    to_EUC_JP_E2_97_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_98_infos[3] = {
     o2(0xA1,0xFA), o2(0xA1,0xF9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_98 = {
    to_SHIFT_JIS_E2_98_offsets,
    to_EUC_JP_E2_98_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_99_infos[6] = {
     o2(0xA1,0xEA), o2(0xA1,0xE9), o2(0xA2,0xF6), o2(0xA2,0xF5),
     o2(0xA2,0xF4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2_99 = {
    to_SHIFT_JIS_E2_99_offsets,
    to_EUC_JP_E2_99_infos
};

static const struct byte_lookup* const
to_EUC_JP_E2_infos[17] = {
     &to_EUC_JP_E2_80, &to_EUC_JP_E2_84, &to_EUC_JP_E2_85, &to_EUC_JP_E2_86,
     &to_EUC_JP_E2_87, &to_EUC_JP_E2_88, &to_EUC_JP_E2_89, &to_EUC_JP_E2_8A,
     &to_EUC_JP_E2_8C, &to_EUC_JP_E2_91, &to_EUC_JP_E2_94, &to_EUC_JP_E2_95,
     &to_EUC_JP_E2_96, &to_EUC_JP_E2_97, &to_EUC_JP_E2_98, &to_EUC_JP_E2_99,
                UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E2 = {
    to_SHIFT_JIS_E2_offsets,
    to_EUC_JP_E2_infos
};

static const struct byte_lookup* const
to_EUC_JP_E3_80_infos[25] = {
     o2(0xA1,0xA1), o2(0xA1,0xA2), o2(0xA1,0xA3), o2(0xA1,0xB7),
     o2(0xA1,0xB9), o2(0xA1,0xBA), o2(0xA1,0xBB), o2(0xA1,0xD2),
     o2(0xA1,0xD3), o2(0xA1,0xD4), o2(0xA1,0xD5), o2(0xA1,0xD6),
     o2(0xA1,0xD7), o2(0xA1,0xD8), o2(0xA1,0xD9), o2(0xA1,0xDA),
     o2(0xA1,0xDB), o2(0xA2,0xA9), o2(0xA2,0xAE), o2(0xA1,0xCC),
     o2(0xA1,0xCD), o2(0xA1,0xC1), o2(0xAD,0xE0), o2(0xAD,0xE1),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E3_80 = {
    to_SHIFT_JIS_E3_80_offsets,
    to_EUC_JP_E3_80_infos
};

static const struct byte_lookup* const
to_EUC_JP_E3_81_infos[64] = {
     o2(0xA4,0xA1), o2(0xA4,0xA2), o2(0xA4,0xA3), o2(0xA4,0xA4),
     o2(0xA4,0xA5), o2(0xA4,0xA6), o2(0xA4,0xA7), o2(0xA4,0xA8),
     o2(0xA4,0xA9), o2(0xA4,0xAA), o2(0xA4,0xAB), o2(0xA4,0xAC),
     o2(0xA4,0xAD), o2(0xA4,0xAE), o2(0xA4,0xAF), o2(0xA4,0xB0),
     o2(0xA4,0xB1), o2(0xA4,0xB2), o2(0xA4,0xB3), o2(0xA4,0xB4),
     o2(0xA4,0xB5), o2(0xA4,0xB6), o2(0xA4,0xB7), o2(0xA4,0xB8),
     o2(0xA4,0xB9), o2(0xA4,0xBA), o2(0xA4,0xBB), o2(0xA4,0xBC),
     o2(0xA4,0xBD), o2(0xA4,0xBE), o2(0xA4,0xBF), o2(0xA4,0xC0),
     o2(0xA4,0xC1), o2(0xA4,0xC2), o2(0xA4,0xC3), o2(0xA4,0xC4),
     o2(0xA4,0xC5), o2(0xA4,0xC6), o2(0xA4,0xC7), o2(0xA4,0xC8),
     o2(0xA4,0xC9), o2(0xA4,0xCA), o2(0xA4,0xCB), o2(0xA4,0xCC),
     o2(0xA4,0xCD), o2(0xA4,0xCE), o2(0xA4,0xCF), o2(0xA4,0xD0),
     o2(0xA4,0xD1), o2(0xA4,0xD2), o2(0xA4,0xD3), o2(0xA4,0xD4),
     o2(0xA4,0xD5), o2(0xA4,0xD6), o2(0xA4,0xD7), o2(0xA4,0xD8),
     o2(0xA4,0xD9), o2(0xA4,0xDA), o2(0xA4,0xDB), o2(0xA4,0xDC),
     o2(0xA4,0xDD), o2(0xA4,0xDE), o2(0xA4,0xDF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E3_81 = {
    to_SHIFT_JIS_E3_81_offsets,
    to_EUC_JP_E3_81_infos
};

static const struct byte_lookup* const
to_EUC_JP_E3_82_infos[56] = {
     o2(0xA4,0xE0), o2(0xA4,0xE1), o2(0xA4,0xE2), o2(0xA4,0xE3),
     o2(0xA4,0xE4), o2(0xA4,0xE5), o2(0xA4,0xE6), o2(0xA4,0xE7),
     o2(0xA4,0xE8), o2(0xA4,0xE9), o2(0xA4,0xEA), o2(0xA4,0xEB),
     o2(0xA4,0xEC), o2(0xA4,0xED), o2(0xA4,0xEE), o2(0xA4,0xEF),
     o2(0xA4,0xF0), o2(0xA4,0xF1), o2(0xA4,0xF2), o2(0xA4,0xF3),
     o2(0xA1,0xAB), o2(0xA1,0xAC), o2(0xA1,0xB5), o2(0xA1,0xB6),
     o2(0xA5,0xA1), o2(0xA5,0xA2), o2(0xA5,0xA3), o2(0xA5,0xA4),
     o2(0xA5,0xA5), o2(0xA5,0xA6), o2(0xA5,0xA7), o2(0xA5,0xA8),
     o2(0xA5,0xA9), o2(0xA5,0xAA), o2(0xA5,0xAB), o2(0xA5,0xAC),
     o2(0xA5,0xAD), o2(0xA5,0xAE), o2(0xA5,0xAF), o2(0xA5,0xB0),
     o2(0xA5,0xB1), o2(0xA5,0xB2), o2(0xA5,0xB3), o2(0xA5,0xB4),
     o2(0xA5,0xB5), o2(0xA5,0xB6), o2(0xA5,0xB7), o2(0xA5,0xB8),
     o2(0xA5,0xB9), o2(0xA5,0xBA), o2(0xA5,0xBB), o2(0xA5,0xBC),
     o2(0xA5,0xBD), o2(0xA5,0xBE), o2(0xA5,0xBF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E3_82 = {
    to_SHIFT_JIS_E3_82_offsets,
    to_EUC_JP_E3_82_infos
};

static const struct byte_lookup* const
to_EUC_JP_E3_83_infos[60] = {
     o2(0xA5,0xC0), o2(0xA5,0xC1), o2(0xA5,0xC2), o2(0xA5,0xC3),
     o2(0xA5,0xC4), o2(0xA5,0xC5), o2(0xA5,0xC6), o2(0xA5,0xC7),
     o2(0xA5,0xC8), o2(0xA5,0xC9), o2(0xA5,0xCA), o2(0xA5,0xCB),
     o2(0xA5,0xCC), o2(0xA5,0xCD), o2(0xA5,0xCE), o2(0xA5,0xCF),
     o2(0xA5,0xD0), o2(0xA5,0xD1), o2(0xA5,0xD2), o2(0xA5,0xD3),
     o2(0xA5,0xD4), o2(0xA5,0xD5), o2(0xA5,0xD6), o2(0xA5,0xD7),
     o2(0xA5,0xD8), o2(0xA5,0xD9), o2(0xA5,0xDA), o2(0xA5,0xDB),
     o2(0xA5,0xDC), o2(0xA5,0xDD), o2(0xA5,0xDE), o2(0xA5,0xDF),
     o2(0xA5,0xE0), o2(0xA5,0xE1), o2(0xA5,0xE2), o2(0xA5,0xE3),
     o2(0xA5,0xE4), o2(0xA5,0xE5), o2(0xA5,0xE6), o2(0xA5,0xE7),
     o2(0xA5,0xE8), o2(0xA5,0xE9), o2(0xA5,0xEA), o2(0xA5,0xEB),
     o2(0xA5,0xEC), o2(0xA5,0xED), o2(0xA5,0xEE), o2(0xA5,0xEF),
     o2(0xA5,0xF0), o2(0xA5,0xF1), o2(0xA5,0xF2), o2(0xA5,0xF3),
     o2(0xA5,0xF4), o2(0xA5,0xF5), o2(0xA5,0xF6), o2(0xA1,0xA6),
     o2(0xA1,0xBC), o2(0xA1,0xB3), o2(0xA1,0xB4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E3_83 = {
    to_SHIFT_JIS_E3_83_offsets,
    to_EUC_JP_E3_83_infos
};

static const struct byte_lookup* const
to_EUC_JP_E3_88_infos[4] = {
     o2(0xAD,0xEA), o2(0xAD,0xEB), o2(0xAD,0xEC),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E3_88 = {
    to_SHIFT_JIS_E3_88_offsets,
    to_EUC_JP_E3_88_infos
};

static const struct byte_lookup* const
to_EUC_JP_E3_8A_infos[6] = {
     o2(0xAD,0xE5), o2(0xAD,0xE6), o2(0xAD,0xE7), o2(0xAD,0xE8),
     o2(0xAD,0xE9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E3_8A = {
    to_SHIFT_JIS_E3_8A_offsets,
    to_EUC_JP_E3_8A_infos
};

static const struct byte_lookup* const
to_EUC_JP_E3_8C_infos[12] = {
     o2(0xAD,0xC6), o2(0xAD,0xCA), o2(0xAD,0xC1), o2(0xAD,0xC4),
     o2(0xAD,0xC2), o2(0xAD,0xCC), o2(0xAD,0xCB), o2(0xAD,0xC5),
     o2(0xAD,0xCD), o2(0xAD,0xC7), o2(0xAD,0xCF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E3_8C = {
    to_SHIFT_JIS_E3_8C_offsets,
    to_EUC_JP_E3_8C_infos
};

static const struct byte_lookup* const
to_EUC_JP_E3_8D_infos[10] = {
     o2(0xAD,0xC0), o2(0xAD,0xCE), o2(0xAD,0xC3), o2(0xAD,0xC8),
     o2(0xAD,0xC9), o2(0xAD,0xDF), o2(0xAD,0xEF), o2(0xAD,0xEE),
     o2(0xAD,0xED),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E3_8D = {
    to_SHIFT_JIS_E3_8D_offsets,
    to_EUC_JP_E3_8D_infos
};

static const struct byte_lookup* const
to_EUC_JP_E3_8E_infos[7] = {
     o2(0xAD,0xD3), o2(0xAD,0xD4), o2(0xAD,0xD0), o2(0xAD,0xD1),
     o2(0xAD,0xD2), o2(0xAD,0xD6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E3_8E = {
    to_SHIFT_JIS_E3_8E_offsets,
    to_EUC_JP_E3_8E_infos
};

static const struct byte_lookup* const
to_EUC_JP_E3_8F_infos[3] = {
     o2(0xAD,0xD5), o2(0xAD,0xE3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E3_8F = {
    to_SHIFT_JIS_E3_8F_offsets,
    to_EUC_JP_E3_8F_infos
};

static const struct byte_lookup* const
to_EUC_JP_E3_infos[11] = {
     &to_EUC_JP_E3_80, &to_EUC_JP_E3_81, &to_EUC_JP_E3_82, &to_EUC_JP_E3_83,
     &to_EUC_JP_E3_88, &to_EUC_JP_E3_8A, &to_EUC_JP_E3_8C, &to_EUC_JP_E3_8D,
     &to_EUC_JP_E3_8E, &to_EUC_JP_E3_8F,            UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E3 = {
    to_SHIFT_JIS_E3_offsets,
    to_EUC_JP_E3_infos
};

static const struct byte_lookup* const
to_EUC_JP_E4_B8_infos[33] = {
     o2(0xB0,0xEC), o2(0xC3,0xFA), o2(0xBC,0xB7), o2(0xCB,0xFC),
     o2(0xBE,0xE6), o2(0xBB,0xB0), o2(0xBE,0xE5), o2(0xB2,0xBC),
     o2(0xC9,0xD4), o2(0xCD,0xBF), o2(0xD0,0xA2), o2(0xB1,0xAF),
     o2(0xB3,0xEE), o2(0xD0,0xA3), o2(0xC0,0xA4), o2(0xD2,0xC2),
     o2(0xB5,0xD6), o2(0xCA,0xBA), o2(0xBE,0xE7), o2(0xCE,0xBE),
     o2(0xCA,0xC2), o2(0xF9,0xAD), o2(0xD0,0xA4), o2(0xC3,0xE6),
     o2(0xD0,0xA5), o2(0xB6,0xFA), o2(0xD0,0xA6), o2(0xB4,0xDD),
     o2(0xC3,0xB0), o2(0xBC,0xE7), o2(0xD0,0xA7), o2(0xD0,0xA8),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E4_B8 = {
    to_SHIFT_JIS_E4_B8_offsets,
    to_EUC_JP_E4_B8_infos
};

static const struct byte_lookup* const
to_EUC_JP_E4_B9_infos[20] = {
     o2(0xD0,0xA9), o2(0xC7,0xB5), o2(0xB5,0xD7), o2(0xC7,0xB7),
     o2(0xC6,0xE3), o2(0xB8,0xC3), o2(0xCB,0xB3), o2(0xE9,0xC9),
     o2(0xD0,0xAA), o2(0xBE,0xE8), o2(0xD0,0xAB), o2(0xB2,0xB5),
     o2(0xB6,0xE5), o2(0xB8,0xF0), o2(0xCC,0xE9), o2(0xD6,0xA6),
     o2(0xCD,0xF0), o2(0xC6,0xFD), o2(0xB4,0xA5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E4_B9 = {
    to_SHIFT_JIS_E4_B9_offsets,
    to_EUC_JP_E4_B9_infos
};

static const struct byte_lookup* const
to_EUC_JP_E4_BA_infos[36] = {
     o2(0xB5,0xB5), o2(0xD0,0xAC), o2(0xD0,0xAD), o2(0xCE,0xBB),
     o2(0xCD,0xBD), o2(0xC1,0xE8), o2(0xD0,0xAF), o2(0xBB,0xF6),
     o2(0xC6,0xF3), o2(0xD0,0xB2), o2(0xB1,0xBE), o2(0xB8,0xDF),
     o2(0xB8,0xDE), o2(0xB0,0xE6), o2(0xCF,0xCB), o2(0xCF,0xCA),
     o2(0xBA,0xB3), o2(0xB0,0xA1), o2(0xD0,0xB3), o2(0xD0,0xB4),
     o2(0xD0,0xB5), o2(0xCB,0xB4), o2(0xD0,0xB6), o2(0xB8,0xF2),
     o2(0xB0,0xE7), o2(0xCB,0xF2), o2(0xB5,0xFC), o2(0xB5,0xFD),
     o2(0xB5,0xFE), o2(0xC4,0xE2), o2(0xCE,0xBC), o2(0xD0,0xB7),
     o2(0xD0,0xB8), o2(0xD0,0xB9), o2(0xBF,0xCD),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E4_BA = {
    to_SHIFT_JIS_E4_BA_offsets,
    to_EUC_JP_E4_BA_infos
};

static const struct byte_lookup* const
to_EUC_JP_E4_BB_infos[33] = {
     o2(0xBD,0xBA), o2(0xBF,0xCE), o2(0xD0,0xBE), o2(0xD0,0xBC),
     o2(0xD0,0xBD), o2(0xB5,0xD8), o2(0xBA,0xA3), o2(0xB2,0xF0),
     o2(0xD0,0xBB), o2(0xD0,0xBA), o2(0xCA,0xA9), o2(0xBB,0xC6),
     o2(0xBB,0xC5), o2(0xC2,0xBE), o2(0xD0,0xBF), o2(0xC9,0xD5),
     o2(0xC0,0xE7), o2(0xA1,0xB8), o2(0xD0,0xC0), o2(0xD0,0xC2),
     o2(0xF9,0xAE), o2(0xC2,0xE5), o2(0xCE,0xE1), o2(0xB0,0xCA),
     o2(0xD0,0xC1), o2(0xB2,0xBE), o2(0xB6,0xC4), o2(0xC3,0xE7),
     o2(0xB7,0xEF), o2(0xD0,0xC3), o2(0xC7,0xA4), o2(0xF9,0xAF),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E4_BB = {
    to_SHIFT_JIS_E4_BB_offsets,
    to_EUC_JP_E4_BB_infos
};

static const struct byte_lookup* const
to_EUC_JP_E4_BC_infos[23] = {
     o2(0xF9,0xB0), o2(0xB4,0xEB), o2(0xF9,0xB1), o2(0xD0,0xC4),
     o2(0xB0,0xCB), o2(0xB8,0xE0), o2(0xB4,0xEC), o2(0xC9,0xFA),
     o2(0xC8,0xB2), o2(0xB5,0xD9), o2(0xB2,0xF1), o2(0xD0,0xE7),
     o2(0xC5,0xC1), o2(0xC7,0xEC), o2(0xD0,0xC6), o2(0xC8,0xBC),
     o2(0xCE,0xE2), o2(0xBF,0xAD), o2(0xF9,0xB2), o2(0xBB,0xC7),
     o2(0xBB,0xF7), o2(0xB2,0xC0),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E4_BC = {
    to_SHIFT_JIS_E4_BC_offsets,
    to_EUC_JP_E4_BC_infos
};

static const struct byte_lookup* const
to_EUC_JP_E4_BD_infos[28] = {
     o2(0xC4,0xD1), o2(0xC3,0xA2), o2(0xD0,0xCA), o2(0xB0,0xCC),
     o2(0xC4,0xE3), o2(0xBD,0xBB), o2(0xBA,0xB4), o2(0xCD,0xA4),
     o2(0xC2,0xCE), o2(0xB2,0xBF), o2(0xF9,0xB3), o2(0xD0,0xC9),
     o2(0xCD,0xBE), o2(0xD0,0xC5), o2(0xD0,0xC7), o2(0xBA,0xEE),
     o2(0xD0,0xC8), o2(0xD5,0xA4), o2(0xD0,0xD0), o2(0xD0,0xD3),
     o2(0xD0,0xD1), o2(0xB2,0xC2), o2(0xCA,0xBB), o2(0xD0,0xCB),
     o2(0xD0,0xCF), o2(0xB8,0xF3), o2(0xBB,0xC8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E4_BD = {
    to_SHIFT_JIS_E4_BD_offsets,
    to_EUC_JP_E4_BD_infos
};

static const struct byte_lookup* const
to_EUC_JP_E4_BE_infos[25] = {
     o2(0xB4,0xA6), o2(0xD0,0xD4), o2(0xD0,0xCC), o2(0xF9,0xB5),
     o2(0xCE,0xE3), o2(0xBB,0xF8), o2(0xD0,0xCD), o2(0xD0,0xD2),
     o2(0xF9,0xB4), o2(0xF9,0xB7), o2(0xD0,0xD5), o2(0xD0,0xCE),
     o2(0xF9,0xB6), o2(0xB6,0xA1), o2(0xB0,0xCD), o2(0xB6,0xA2),
     o2(0xB2,0xC1), o2(0xD5,0xA5), o2(0xCB,0xF9), o2(0xC9,0xEE),
     o2(0xB8,0xF4), o2(0xBF,0xAF), o2(0xCE,0xB7), o2(0xCA,0xD8),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E4_BE = {
    to_SHIFT_JIS_E4_BE_offsets,
    to_EUC_JP_E4_BE_infos
};

static const struct byte_lookup* const
to_EUC_JP_E4_BF_infos[30] = {
     o2(0xB7,0xB8), o2(0xC2,0xA5), o2(0xB2,0xE4), o2(0xF9,0xA6),
     o2(0xBD,0xD3), o2(0xF9,0xB8), o2(0xD0,0xD9), o2(0xD0,0xDE),
     o2(0xD0,0xDC), o2(0xD0,0xD7), o2(0xC2,0xAF), o2(0xD0,0xDA),
     o2(0xD0,0xDD), o2(0xD0,0xDB), o2(0xCA,0xDD), o2(0xD0,0xD8),
     o2(0xBF,0xAE), o2(0xCB,0xF3), o2(0xD0,0xDF), o2(0xD0,0xE0),
     o2(0xBD,0xA4), o2(0xD0,0xED), o2(0xC7,0xD0), o2(0xC9,0xB6),
     o2(0xD0,0xE8), o2(0xCA,0xF0), o2(0xB2,0xB6), o2(0xD0,0xEC),
     o2(0xF9,0xBB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E4_BF = {
    to_SHIFT_JIS_E4_BF_offsets,
    to_EUC_JP_E4_BF_infos
};

static const struct byte_lookup* const
to_EUC_JP_E4_infos[9] = {
     &to_EUC_JP_E4_B8, &to_EUC_JP_E4_B9, &to_EUC_JP_E4_BA, &to_EUC_JP_E4_BB,
     &to_EUC_JP_E4_BC, &to_EUC_JP_E4_BD, &to_EUC_JP_E4_BE, &to_EUC_JP_E4_BF,
                UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E4 = {
    to_SHIFT_JIS_E4_offsets,
    to_EUC_JP_E4_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_80_infos[29] = {
     o2(0xD0,0xE6), o2(0xD0,0xEF), o2(0xC1,0xD2), o2(0xB8,0xC4),
     o2(0xC7,0xDC), o2(0xE0,0xC7), o2(0xD0,0xEE), o2(0xC5,0xDD),
     o2(0xD0,0xE3), o2(0xB8,0xF6), o2(0xB8,0xF5), o2(0xD0,0xE1),
     o2(0xF9,0xBC), o2(0xBC,0xDA), o2(0xD0,0xE9), o2(0xF9,0xBA),
     o2(0xCA,0xEF), o2(0xC3,0xCD), o2(0xD0,0xE5), o2(0xB7,0xF1),
     o2(0xD0,0xE2), o2(0xD0,0xEA), o2(0xD0,0xE4), o2(0xCE,0xD1),
     o2(0xD0,0xEB), o2(0xCF,0xC1), o2(0xB6,0xE6), o2(0xB7,0xF0),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_80 = {
    to_SHIFT_JIS_E5_80_offsets,
    to_EUC_JP_E5_80_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_81_infos[23] = {
     o2(0xF9,0xB9), o2(0xF9,0xBF), o2(0xD0,0xF0), o2(0xF9,0xBD),
     o2(0xD0,0xF1), o2(0xD0,0xF5), o2(0xB0,0xCE), o2(0xCA,0xD0),
     o2(0xD0,0xF4), o2(0xD0,0xF3), o2(0xD0,0xF7), o2(0xD0,0xF6),
     o2(0xC4,0xE4), o2(0xB7,0xF2), o2(0xD0,0xF8), o2(0xF9,0xBE),
     o2(0xBC,0xC5), o2(0xC2,0xA6), o2(0xC4,0xE5), o2(0xB6,0xF6),
     o2(0xD0,0xF9), o2(0xB5,0xB6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_81 = {
    to_SHIFT_JIS_E5_81_offsets,
    to_EUC_JP_E5_81_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_82_infos[17] = {
     o2(0xD0,0xFA), o2(0xD0,0xFC), o2(0xCB,0xB5), o2(0xB7,0xE6),
     o2(0xF9,0xC0), o2(0xBB,0xB1), o2(0xC8,0xF7), o2(0xD0,0xFB),
     o2(0xBA,0xC5), o2(0xCD,0xC3), o2(0xD0,0xFE), o2(0xD1,0xA3),
     o2(0xD0,0xFD), o2(0xBA,0xC4), o2(0xBD,0xFD), o2(0xB7,0xB9),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_82 = {
    to_SHIFT_JIS_E5_82_offsets,
    to_EUC_JP_E5_82_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_83_infos[22] = {
     o2(0xD1,0xA4), o2(0xB6,0xCF), o2(0xD1,0xA1), o2(0xD1,0xA2),
     o2(0xC6,0xAF), o2(0xC1,0xFC), o2(0xB6,0xA3), o2(0xCB,0xCD),
     o2(0xD1,0xA5), o2(0xF9,0xC2), o2(0xCE,0xBD), o2(0xD1,0xA6),
     o2(0xD1,0xA9), o2(0xD1,0xA7), o2(0xC1,0xCE), o2(0xD1,0xA8),
     o2(0xD1,0xAA), o2(0xF9,0xC1), o2(0xD1,0xAC), o2(0xD1,0xAB),
     o2(0xCA,0xC8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_83 = {
    to_SHIFT_JIS_E5_83_offsets,
    to_EUC_JP_E5_83_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_84_infos[21] = {
     o2(0xB5,0xB7), o2(0xD1,0xAE), o2(0xD1,0xAF), o2(0xB2,0xAF),
     o2(0xD1,0xAD), o2(0xBC,0xF4), o2(0xD1,0xB2), o2(0xD1,0xB1),
     o2(0xD1,0xB0), o2(0xD0,0xD6), o2(0xD1,0xB3), o2(0xBD,0xFE),
     o2(0xD1,0xB4), o2(0xCD,0xA5), o2(0xCC,0xD9), o2(0xD1,0xB6),
     o2(0xD1,0xB5), o2(0xD1,0xB8), o2(0xD1,0xB7), o2(0xD1,0xB9),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_84 = {
    to_SHIFT_JIS_E5_84_offsets,
    to_EUC_JP_E5_84_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_85_infos[36] = {
     o2(0xD1,0xBA), o2(0xB0,0xF4), o2(0xB8,0xB5), o2(0xB7,0xBB),
     o2(0xBD,0xBC), o2(0xC3,0xFB), o2(0xB6,0xA4), o2(0xC0,0xE8),
     o2(0xB8,0xF7), o2(0xF9,0xC3), o2(0xB9,0xEE), o2(0xD1,0xBC),
     o2(0xCC,0xC8), o2(0xC5,0xC6), o2(0xBB,0xF9), o2(0xD1,0xBB),
     o2(0xD1,0xBD), o2(0xC5,0xDE), o2(0xB3,0xF5), o2(0xD1,0xBE),
     o2(0xF9,0xC4), o2(0xC6,0xFE), o2(0xC1,0xB4), o2(0xD1,0xC0),
     o2(0xD1,0xC1), o2(0xC8,0xAC), o2(0xB8,0xF8), o2(0xCF,0xBB),
     o2(0xD1,0xC2), o2(0xB6,0xA6), o2(0xCA,0xBC), o2(0xC2,0xB6),
     o2(0xB6,0xF1), o2(0xC5,0xB5), o2(0xB7,0xF3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_85 = {
    to_SHIFT_JIS_E5_85_offsets,
    to_EUC_JP_E5_85_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_86_infos[39] = {
     o2(0xD1,0xC3), o2(0xD1,0xC4), o2(0xC6,0xE2), o2(0xB1,0xDF),
     o2(0xD1,0xC7), o2(0xBA,0xFD), o2(0xD1,0xC6), o2(0xBA,0xC6),
     o2(0xD1,0xC8), o2(0xE6,0xEE), o2(0xD1,0xC9), o2(0xCB,0xC1),
     o2(0xD1,0xCA), o2(0xD1,0xCB), o2(0xD1,0xCC), o2(0xBE,0xE9),
     o2(0xBC,0xCC), o2(0xF9,0xC5), o2(0xB4,0xA7), o2(0xD1,0xCF),
     o2(0xD1,0xCD), o2(0xCC,0xBD), o2(0xD1,0xCE), o2(0xC9,0xDA),
     o2(0xD1,0xD0), o2(0xD1,0xD1), o2(0xD1,0xD2), o2(0xC5,0xDF),
     o2(0xD1,0xD6), o2(0xD1,0xD4), o2(0xD1,0xD5), o2(0xD1,0xD3),
     o2(0xBA,0xE3), o2(0xD1,0xD7), o2(0xCC,0xEA), o2(0xCE,0xE4),
     o2(0xD1,0xD8), o2(0xF9,0xC6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_86 = {
    to_SHIFT_JIS_E5_86_offsets,
    to_EUC_JP_E5_86_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_87_infos[29] = {
     o2(0xC0,0xA8), o2(0xD1,0xD9), o2(0xBD,0xDA), o2(0xD1,0xDA),
     o2(0xC3,0xFC), o2(0xCE,0xBF), o2(0xC5,0xE0), o2(0xD2,0xC5),
     o2(0xD1,0xDB), o2(0xF4,0xA5), o2(0xB6,0xC5), o2(0xD1,0xDC),
     o2(0xCB,0xDE), o2(0xBD,0xE8), o2(0xC2,0xFC), o2(0xD1,0xDE),
     o2(0xC6,0xE4), o2(0xF9,0xC7), o2(0xD1,0xDF), o2(0xD1,0xE0),
     o2(0xB3,0xAE), o2(0xD1,0xE1), o2(0xB6,0xA7), o2(0xC6,0xCC),
     o2(0xB1,0xFA), o2(0xBD,0xD0), o2(0xC8,0xA1), o2(0xD1,0xE2),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_87 = {
    to_SHIFT_JIS_E5_87_offsets,
    to_EUC_JP_E5_87_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_88_infos[29] = {
     o2(0xC5,0xE1), o2(0xBF,0xCF), o2(0xD1,0xE3), o2(0xCA,0xAC),
     o2(0xC0,0xDA), o2(0xB4,0xA2), o2(0xB4,0xA9), o2(0xD1,0xE4),
     o2(0xD1,0xE6), o2(0xB7,0xBA), o2(0xD1,0xE5), o2(0xF9,0xC8),
     o2(0xCE,0xF3), o2(0xBD,0xE9), o2(0xC8,0xBD), o2(0xCA,0xCC),
     o2(0xD1,0xE7), o2(0xCD,0xF8), o2(0xD1,0xE8), o2(0xD1,0xE9),
     o2(0xC5,0xFE), o2(0xD1,0xEA), o2(0xC0,0xA9), o2(0xBA,0xFE),
     o2(0xB7,0xF4), o2(0xD1,0xEB), o2(0xBB,0xC9), o2(0xB9,0xEF),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_88 = {
    to_SHIFT_JIS_E5_88_offsets,
    to_EUC_JP_E5_88_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_89_infos[27] = {
     o2(0xC4,0xE6), o2(0xD1,0xED), o2(0xC2,0xA7), o2(0xBA,0xEF),
     o2(0xD1,0xEE), o2(0xD1,0xEF), o2(0xC1,0xB0), o2(0xD1,0xEC),
     o2(0xD1,0xF1), o2(0xCB,0xB6), o2(0xB9,0xE4), o2(0xD1,0xF0),
     o2(0xB7,0xF5), o2(0xBA,0xDE), o2(0xC7,0xED), o2(0xD1,0xF4),
     o2(0xD1,0xF2), o2(0xC9,0xFB), o2(0xBE,0xEA), o2(0xD1,0xFB),
     o2(0xB3,0xE4), o2(0xD1,0xF5), o2(0xD1,0xF3), o2(0xC1,0xCF),
     o2(0xD1,0xF7), o2(0xD1,0xF6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_89 = {
    to_SHIFT_JIS_E5_89_offsets,
    to_EUC_JP_E5_89_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_8A_infos[27] = {
     o2(0xB3,0xC4), o2(0xB7,0xE0), o2(0xD1,0xFC), o2(0xCE,0xAD),
     o2(0xD1,0xF8), o2(0xD1,0xFD), o2(0xD1,0xFA), o2(0xD1,0xF9),
     o2(0xCE,0xCF), o2(0xF9,0xC9), o2(0xB8,0xF9), o2(0xB2,0xC3),
     o2(0xCE,0xF4), o2(0xF9,0xCA), o2(0xBD,0xF5), o2(0xC5,0xD8),
     o2(0xB9,0xE5), o2(0xD2,0xA2), o2(0xD2,0xA3), o2(0xFB,0xBC),
     o2(0xCE,0xE5), o2(0xCF,0xAB), o2(0xD2,0xA5), o2(0xB8,0xFA),
     o2(0xD2,0xA4), o2(0xB3,0xAF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_8A = {
    to_SHIFT_JIS_E5_8A_offsets,
    to_EUC_JP_E5_8A_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_8B_infos[31] = {
     o2(0xF9,0xCB), o2(0xD2,0xA6), o2(0xCB,0xD6), o2(0xC4,0xBC),
     o2(0xCD,0xA6), o2(0xCA,0xD9), o2(0xD2,0xA7), o2(0xF0,0xD5),
     o2(0xC6,0xB0), o2(0xD2,0xA8), o2(0xB4,0xAA), o2(0xCC,0xB3),
     o2(0xF9,0xCC), o2(0xBE,0xA1), o2(0xD2,0xA9), o2(0xCA,0xE7),
     o2(0xD2,0xAD), o2(0xC0,0xAA), o2(0xD2,0xAA), o2(0xB6,0xD0),
     o2(0xD2,0xAB), o2(0xB4,0xAB), o2(0xB7,0xAE), o2(0xD2,0xAE),
     o2(0xD2,0xAF), o2(0xD2,0xB0), o2(0xD2,0xB1), o2(0xBC,0xDB),
     o2(0xB8,0xFB), o2(0xCC,0xDE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_8B = {
    to_SHIFT_JIS_E5_8B_offsets,
    to_EUC_JP_E5_8B_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_8C_infos[30] = {
     o2(0xF9,0xCD), o2(0xCC,0xE8), o2(0xC6,0xF7), o2(0xCA,0xF1),
     o2(0xD2,0xB2), o2(0xF9,0xCE), o2(0xD2,0xB3), o2(0xD2,0xB5),
     o2(0xD2,0xB7), o2(0xD2,0xB6), o2(0xD2,0xB8), o2(0xB2,0xBD),
     o2(0xCB,0xCC), o2(0xBA,0xFC), o2(0xD2,0xB9), o2(0xC1,0xD9),
     o2(0xBE,0xA2), o2(0xB6,0xA9), o2(0xD2,0xBA), o2(0xF9,0xCF),
     o2(0xC8,0xDB), o2(0xD2,0xBB), o2(0xD2,0xBC), o2(0xD2,0xBD),
     o2(0xD2,0xBE), o2(0xC9,0xA4), o2(0xB6,0xE8), o2(0xB0,0xE5),
     o2(0xC6,0xBF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_8C = {
    to_SHIFT_JIS_E5_8C_offsets,
    to_EUC_JP_E5_8C_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_8D_infos[35] = {
     o2(0xD2,0xBF), o2(0xBD,0xBD), o2(0xC0,0xE9), o2(0xD2,0xC1),
     o2(0xD2,0xC0), o2(0xBE,0xA3), o2(0xB8,0xE1), o2(0xD2,0xC3),
     o2(0xC8,0xBE), o2(0xD2,0xC4), o2(0xC8,0xDC), o2(0xC2,0xB4),
     o2(0xC2,0xEE), o2(0xB6,0xA8), o2(0xC6,0xEE), o2(0xC3,0xB1),
     o2(0xC7,0xEE), o2(0xCB,0xCE), o2(0xD2,0xC6), o2(0xC0,0xEA),
     o2(0xB7,0xB5), o2(0xD2,0xC7), o2(0xD2,0xC8), o2(0xB1,0xAC),
     o2(0xB0,0xF5), o2(0xB4,0xED), o2(0xF9,0xD0), o2(0xC2,0xA8),
     o2(0xB5,0xD1), o2(0xCD,0xF1), o2(0xD2,0xCB), o2(0xB2,0xB7),
     o2(0xD2,0xCA), o2(0xB6,0xAA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_8D = {
    to_SHIFT_JIS_E5_8D_offsets,
    to_EUC_JP_E5_8D_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_8E_infos[20] = {
     o2(0xD2,0xCC), o2(0xCC,0xF1), o2(0xF9,0xD1), o2(0xD2,0xCD),
     o2(0xCE,0xD2), o2(0xB8,0xFC), o2(0xB8,0xB6), o2(0xD2,0xCE),
     o2(0xD2,0xD0), o2(0xD2,0xCF), o2(0xBF,0xDF), o2(0xB1,0xB9),
     o2(0xB1,0xDE), o2(0xD2,0xD1), o2(0xD2,0xD2), o2(0xF9,0xD2),
     o2(0xB8,0xB7), o2(0xD2,0xD3), o2(0xB5,0xEE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_8E = {
    to_SHIFT_JIS_E5_8E_offsets,
    to_EUC_JP_E5_8E_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_8F_infos[38] = {
     o2(0xBB,0xB2), o2(0xD2,0xD4), o2(0xCB,0xF4), o2(0xBA,0xB5),
     o2(0xB5,0xDA), o2(0xCD,0xA7), o2(0xC1,0xD0), o2(0xC8,0xBF),
     o2(0xBC,0xFD), o2(0xBD,0xC7), o2(0xBC,0xE8), o2(0xBC,0xF5),
     o2(0xBD,0xF6), o2(0xC8,0xC0), o2(0xF9,0xD3), o2(0xD2,0xD7),
     o2(0xB1,0xC3), o2(0xC1,0xD1), o2(0xB8,0xFD), o2(0xB8,0xC5),
     o2(0xB6,0xE7), o2(0xD2,0xDB), o2(0xC3,0xA1), o2(0xC2,0xFE),
     o2(0xB6,0xAB), o2(0xBE,0xA4), o2(0xD2,0xDC), o2(0xD2,0xDA),
     o2(0xB2,0xC4), o2(0xC2,0xE6), o2(0xBC,0xB8), o2(0xBB,0xCB),
     o2(0xB1,0xA6), o2(0xB3,0xF0), o2(0xB9,0xE6), o2(0xBB,0xCA),
     o2(0xD2,0xDD),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_8F = {
    to_SHIFT_JIS_E5_8F_offsets,
    to_EUC_JP_E5_8F_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_90_infos[31] = {
     o2(0xD2,0xDE), o2(0xB5,0xC9), o2(0xB3,0xC6), o2(0xB9,0xE7),
     o2(0xB5,0xC8), o2(0xC4,0xDF), o2(0xB1,0xA5), o2(0xC6,0xB1),
     o2(0xCC,0xBE), o2(0xB9,0xA1), o2(0xCD,0xF9), o2(0xC5,0xC7),
     o2(0xB8,0xFE), o2(0xB7,0xAF), o2(0xD2,0xE7), o2(0xB6,0xE3),
     o2(0xCB,0xCA), o2(0xC8,0xDD), o2(0xD2,0xE6), o2(0xB4,0xDE),
     o2(0xD2,0xE1), o2(0xD2,0xE2), o2(0xD2,0xE4), o2(0xD2,0xE5),
     o2(0xB5,0xDB), o2(0xBF,0xE1), o2(0xCA,0xAD), o2(0xD2,0xE3),
     o2(0xD2,0xDF), o2(0xB8,0xE3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_90 = {
    to_SHIFT_JIS_E5_90_offsets,
    to_EUC_JP_E5_90_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_91_infos[21] = {
     o2(0xD2,0xE0), o2(0xCF,0xA4), o2(0xCA,0xF2), o2(0xC4,0xE8),
     o2(0xB8,0xE2), o2(0xB9,0xF0), o2(0xD2,0xE8), o2(0xC6,0xDD),
     o2(0xD2,0xEC), o2(0xBC,0xFE), o2(0xBC,0xF6), o2(0xD2,0xEF),
     o2(0xD2,0xED), o2(0xCC,0xA3), o2(0xD2,0xEA), o2(0xD2,0xF3),
     o2(0xD2,0xEE), o2(0xD2,0xF1), o2(0xB8,0xC6), o2(0xCC,0xBF),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_91 = {
    to_SHIFT_JIS_E5_91_offsets,
    to_EUC_JP_E5_91_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_92_infos[26] = {
     o2(0xD2,0xF2), o2(0xD2,0xF4), o2(0xD2,0xF6), o2(0xF9,0xD6),
     o2(0xBA,0xF0), o2(0xCF,0xC2), o2(0xD2,0xEB), o2(0xD2,0xE9),
     o2(0xD2,0xF5), o2(0xD2,0xF0), o2(0xF9,0xD5), o2(0xD2,0xF8),
     o2(0xD3,0xA3), o2(0xD2,0xFA), o2(0xD2,0xFE), o2(0xF9,0xD7),
     o2(0xD3,0xA1), o2(0xD2,0xFB), o2(0xD3,0xBE), o2(0xBA,0xE9),
     o2(0xB3,0xB1), o2(0xD2,0xF9), o2(0xD3,0xA5), o2(0xB0,0xF6),
     o2(0xD3,0xA4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_92 = {
    to_SHIFT_JIS_E5_92_offsets,
    to_EUC_JP_E5_92_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_93_infos[21] = {
     o2(0xB0,0xA5), o2(0xC9,0xCA), o2(0xD3,0xA2), o2(0xD2,0xFC),
     o2(0xD2,0xF7), o2(0xD2,0xFD), o2(0xBA,0xC8), o2(0xD3,0xA6),
     o2(0xB0,0xF7), o2(0xD3,0xAF), o2(0xD3,0xA7), o2(0xD3,0xA8),
     o2(0xBE,0xA5), o2(0xCB,0xE9), o2(0xD3,0xAD), o2(0xD3,0xAC),
     o2(0xC5,0xAF), o2(0xD3,0xAE), o2(0xD3,0xAB), o2(0xF9,0xD8),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_93 = {
    to_SHIFT_JIS_E5_93_offsets,
    to_EUC_JP_E5_93_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_94_infos[15] = {
     o2(0xB1,0xB4), o2(0xBA,0xB6), o2(0xBF,0xB0), o2(0xD3,0xA9),
     o2(0xC5,0xE2), o2(0xD3,0xAA), o2(0xB0,0xA2), o2(0xD3,0xB4),
     o2(0xCD,0xA3), o2(0xBE,0xA7), o2(0xD3,0xBA), o2(0xD3,0xB9),
     o2(0xD3,0xB0), o2(0xC2,0xC3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_94 = {
    to_SHIFT_JIS_E5_94_offsets,
    to_EUC_JP_E5_94_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_95_infos[16] = {
     o2(0xD3,0xB1), o2(0xC2,0xEF), o2(0xD3,0xB6), o2(0xBE,0xA6),
     o2(0xD3,0xB3), o2(0xCC,0xE4), o2(0xB7,0xBC), o2(0xD3,0xB7),
     o2(0xD3,0xB8), o2(0xD3,0xB5), o2(0xD3,0xBB), o2(0xD3,0xB2),
     o2(0xD3,0xC1), o2(0xD3,0xC6), o2(0xD3,0xC2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_95 = {
    to_SHIFT_JIS_E5_95_offsets,
    to_EUC_JP_E5_95_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_96_infos[25] = {
     o2(0xD3,0xBD), o2(0xD3,0xC7), o2(0xC1,0xB1), o2(0xF9,0xD9),
     o2(0xD3,0xC9), o2(0xB9,0xA2), o2(0xD3,0xBF), o2(0xC3,0xFD),
     o2(0xD3,0xC3), o2(0xD3,0xBC), o2(0xB4,0xAD), o2(0xB4,0xEE),
     o2(0xB3,0xE5), o2(0xD3,0xC4), o2(0xD3,0xC0), o2(0xB7,0xF6),
     o2(0xD3,0xCA), o2(0xD3,0xC8), o2(0xC1,0xD3), o2(0xB5,0xCA),
     o2(0xB6,0xAC), o2(0xD3,0xC5), o2(0xB6,0xF4), o2(0xB1,0xC4),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_96 = {
    to_SHIFT_JIS_E5_96_offsets,
    to_EUC_JP_E5_96_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_97_infos[14] = {
     o2(0xD3,0xCE), o2(0xD3,0xCC), o2(0xD4,0xA7), o2(0xD3,0xD1),
     o2(0xD3,0xCB), o2(0xD3,0xCF), o2(0xD3,0xCD), o2(0xBB,0xCC),
     o2(0xD3,0xD0), o2(0xD3,0xD3), o2(0xD3,0xD8), o2(0xD3,0xD6),
     o2(0xD3,0xD5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_97 = {
    to_SHIFT_JIS_E5_97_offsets,
    to_EUC_JP_E5_97_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_98_infos[15] = {
     o2(0xC3,0xB2), o2(0xB2,0xC5), o2(0xD3,0xD2), o2(0xD3,0xD4),
     o2(0xBE,0xA8), o2(0xB1,0xB3), o2(0xD3,0xD7), o2(0xB2,0xDE),
     o2(0xD3,0xE2), o2(0xBE,0xFC), o2(0xD3,0xDE), o2(0xD3,0xDC),
     o2(0xD3,0xDD), o2(0xD3,0xDF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_98 = {
    to_SHIFT_JIS_E5_98_offsets,
    to_EUC_JP_E5_98_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_99_infos[14] = {
     o2(0xB1,0xBD), o2(0xC1,0xB9), o2(0xD3,0xD9), o2(0xD3,0xDA),
     o2(0xB3,0xFA), o2(0xD3,0xE1), o2(0xB4,0xEF), o2(0xD3,0xE4),
     o2(0xD3,0xE0), o2(0xD3,0xE3), o2(0xCA,0xAE), o2(0xC6,0xD5),
     o2(0xC8,0xB8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_99 = {
    to_SHIFT_JIS_E5_99_offsets,
    to_EUC_JP_E5_99_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_9A_infos[14] = {
     o2(0xD3,0xE6), o2(0xD3,0xE5), o2(0xB3,0xC5), o2(0xD3,0xE7),
     o2(0xD3,0xEA), o2(0xD3,0xE9), o2(0xD3,0xE8), o2(0xC7,0xB9),
     o2(0xD3,0xEB), o2(0xD3,0xEC), o2(0xD3,0xEE), o2(0xD3,0xED),
     o2(0xD3,0xF0),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_9A = {
    to_SHIFT_JIS_E5_9A_offsets,
    to_EUC_JP_E5_9A_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_9B_infos[24] = {
     o2(0xD3,0xF3), o2(0xD3,0xF1), o2(0xD3,0xEF), o2(0xD3,0xF2),
     o2(0xD3,0xF4), o2(0xD3,0xF5), o2(0xD3,0xF6), o2(0xD3,0xF7),
     o2(0xD3,0xF8), o2(0xD1,0xC5), o2(0xBC,0xFC), o2(0xBB,0xCD),
     o2(0xB2,0xF3), o2(0xB0,0xF8), o2(0xC3,0xC4), o2(0xD3,0xF9),
     o2(0xBA,0xA4), o2(0xB0,0xCF), o2(0xBF,0xDE), o2(0xD3,0xFA),
     o2(0xB8,0xC7), o2(0xB9,0xF1), o2(0xD3,0xFC),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_9B = {
    to_SHIFT_JIS_E5_9B_offsets,
    to_EUC_JP_E5_9B_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_9C_infos[23] = {
     o2(0xD3,0xFB), o2(0xCA,0xE0), o2(0xD3,0xFD), o2(0xD4,0xA1),
     o2(0xD3,0xFE), o2(0xD4,0xA2), o2(0xD4,0xA3), o2(0xB7,0xF7),
     o2(0xB1,0xE0), o2(0xD4,0xA4), o2(0xD4,0xA6), o2(0xD4,0xA5),
     o2(0xD4,0xA8), o2(0xC5,0xDA), o2(0xD4,0xA9), o2(0xB0,0xB5),
     o2(0xBA,0xDF), o2(0xB7,0xBD), o2(0xC3,0xCF), o2(0xD4,0xAA),
     o2(0xD4,0xAB), o2(0xD4,0xAD),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_9C = {
    to_SHIFT_JIS_E5_9C_offsets,
    to_EUC_JP_E5_9C_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_9D_infos[17] = {
     o2(0xD4,0xAE), o2(0xBA,0xE4), o2(0xB6,0xD1), o2(0xCB,0xB7),
     o2(0xD4,0xAC), o2(0xD4,0xAF), o2(0xBA,0xC1), o2(0xB9,0xA3),
     o2(0xF9,0xDA), o2(0xD4,0xB3), o2(0xBA,0xA5), o2(0xF9,0xDB),
     o2(0xC3,0xB3), o2(0xD4,0xB0), o2(0xC4,0xDA), o2(0xD4,0xB4),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_9D = {
    to_SHIFT_JIS_E5_9D_offsets,
    to_EUC_JP_E5_9D_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_9E_infos[14] = {
     o2(0xBF,0xE2), o2(0xD4,0xB2), o2(0xD4,0xB5), o2(0xB7,0xBF),
     o2(0xD4,0xB6), o2(0xD4,0xB7), o2(0xB9,0xA4), o2(0xB3,0xC0),
     o2(0xD4,0xB9), o2(0xD4,0xBA), o2(0xF9,0xDC), o2(0xD4,0xBB),
     o2(0xD4,0xB8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_9E = {
    to_SHIFT_JIS_E5_9E_offsets,
    to_EUC_JP_E5_9E_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_9F_infos[21] = {
     o2(0xD4,0xB1), o2(0xD4,0xBC), o2(0xD4,0xBD), o2(0xF9,0xDE),
     o2(0xF9,0xDD), o2(0xCB,0xE4), o2(0xBE,0xEB), o2(0xD4,0xBF),
     o2(0xD4,0xC0), o2(0xD4,0xBE), o2(0xD4,0xC2), o2(0xC7,0xB8),
     o2(0xB0,0xE8), o2(0xC9,0xD6), o2(0xD4,0xC3), o2(0xBE,0xFD),
     o2(0xBC,0xB9), o2(0xC7,0xDD), o2(0xB4,0xF0), o2(0xBA,0xEB),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_9F = {
    to_SHIFT_JIS_E5_9F_offsets,
    to_EUC_JP_E5_9F_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_A0_infos[20] = {
     o2(0xCB,0xD9), o2(0xC6,0xB2), o2(0xB7,0xF8), o2(0xC2,0xCF),
     o2(0xD4,0xC1), o2(0xD4,0xC4), o2(0xC2,0xC4), o2(0xD4,0xC5),
     o2(0xD4,0xC6), o2(0xD4,0xC8), o2(0xC4,0xE9), o2(0xB4,0xAE),
     o2(0xF4,0xA1), o2(0xB1,0xE1), o2(0xCA,0xF3), o2(0xBE,0xEC),
     o2(0xC5,0xC8), o2(0xBA,0xE6), o2(0xD4,0xCE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_A0 = {
    to_SHIFT_JIS_E5_A0_offsets,
    to_EUC_JP_E5_A0_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_A1_infos[21] = {
     o2(0xCA,0xBD), o2(0xCE,0xDD), o2(0xB2,0xF4), o2(0xD4,0xCA),
     o2(0xC1,0xBA), o2(0xD4,0xCD), o2(0xC5,0xE3), o2(0xC5,0xC9),
     o2(0xC5,0xE4), o2(0xC8,0xB9), o2(0xC4,0xCD), o2(0xBA,0xC9),
     o2(0xD4,0xC9), o2(0xB1,0xF6), o2(0xC5,0xB6), o2(0xD4,0xCB),
     o2(0xD4,0xC7), o2(0xBF,0xD0), o2(0xD4,0xCF), o2(0xBD,0xCE),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_A1 = {
    to_SHIFT_JIS_E5_A1_offsets,
    to_EUC_JP_E5_A1_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_A2_infos[18] = {
     o2(0xB6,0xAD), o2(0xD4,0xD0), o2(0xCA,0xE8), o2(0xC1,0xFD),
     o2(0xC4,0xC6), o2(0xF9,0xE1), o2(0xD4,0xD2), o2(0xCB,0xCF),
     o2(0xD4,0xD3), o2(0xD4,0xD8), o2(0xF9,0xE2), o2(0xCA,0xAF),
     o2(0xD4,0xD7), o2(0xD4,0xD1), o2(0xD4,0xD4), o2(0xD4,0xD6),
     o2(0xBA,0xA6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_A2 = {
    to_SHIFT_JIS_E5_A2_offsets,
    to_EUC_JP_E5_A2_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_A3_infos[30] = {
     o2(0xCA,0xC9), o2(0xD4,0xD9), o2(0xC3,0xC5), o2(0xB2,0xF5),
     o2(0xBE,0xED), o2(0xD4,0xDB), o2(0xD4,0xDA), o2(0xB9,0xE8),
     o2(0xD4,0xDC), o2(0xD4,0xDE), o2(0xD4,0xDD), o2(0xD4,0xE0),
     o2(0xD4,0xD5), o2(0xD4,0xE2), o2(0xD4,0xE1), o2(0xD4,0xDF),
     o2(0xBB,0xCE), o2(0xBF,0xD1), o2(0xC1,0xD4), o2(0xD4,0xE3),
     o2(0xC0,0xBC), o2(0xB0,0xED), o2(0xC7,0xE4), o2(0xC4,0xDB),
     o2(0xD4,0xE5), o2(0xD4,0xE4), o2(0xD4,0xE6), o2(0xD4,0xE7),
     o2(0xD4,0xE8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_A3 = {
    to_SHIFT_JIS_E5_A3_offsets,
    to_EUC_JP_E5_A3_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_A4_infos[28] = {
     o2(0xD4,0xE9), o2(0xCA,0xD1), o2(0xD4,0xEA), o2(0xF9,0xE3),
     o2(0xB2,0xC6), o2(0xD4,0xEB), o2(0xCD,0xBC), o2(0xB3,0xB0),
     o2(0xD2,0xC9), o2(0xBD,0xC8), o2(0xC2,0xBF), o2(0xD4,0xEC),
     o2(0xCC,0xEB), o2(0xCC,0xB4), o2(0xD4,0xEE), o2(0xC2,0xE7),
     o2(0xC5,0xB7), o2(0xC2,0xC0), o2(0xC9,0xD7), o2(0xD4,0xEF),
     o2(0xD4,0xF0), o2(0xB1,0xFB), o2(0xBC,0xBA), o2(0xD4,0xF1),
     o2(0xB0,0xD0), o2(0xD4,0xF2), o2(0xD4,0xF3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_A4 = {
    to_SHIFT_JIS_E5_A4_offsets,
    to_EUC_JP_E5_A4_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_A5_infos[31] = {
     o2(0xB1,0xE2), o2(0xB4,0xF1), o2(0xC6,0xE0), o2(0xCA,0xF4),
     o2(0xD4,0xF7), o2(0xC1,0xD5), o2(0xD4,0xF6), o2(0xB7,0xC0),
     o2(0xF9,0xE4), o2(0xCB,0xDB), o2(0xD4,0xF5), o2(0xC5,0xE5),
     o2(0xD4,0xF9), o2(0xD4,0xF8), o2(0xF9,0xE5), o2(0xF9,0xE6),
     o2(0xD4,0xFB), o2(0xD4,0xFA), o2(0xF9,0xE7), o2(0xB1,0xFC),
     o2(0xD4,0xFC), o2(0xBE,0xA9), o2(0xD4,0xFE), o2(0xC3,0xA5),
     o2(0xD4,0xFD), o2(0xCA,0xB3), o2(0xBD,0xF7), o2(0xC5,0xDB),
     o2(0xD5,0xA1), o2(0xB9,0xA5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_A5 = {
    to_SHIFT_JIS_E5_A5_offsets,
    to_EUC_JP_E5_A5_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_A6_infos[22] = {
     o2(0xD5,0xA2), o2(0xC7,0xA1), o2(0xC8,0xDE), o2(0xCC,0xD1),
     o2(0xC7,0xA5), o2(0xD5,0xAB), o2(0xB5,0xB8), o2(0xCD,0xC5),
     o2(0xCC,0xAF), o2(0xD6,0xAC), o2(0xD5,0xA3), o2(0xD5,0xA6),
     o2(0xF9,0xE8), o2(0xC2,0xC5), o2(0xCB,0xB8), o2(0xC5,0xCA),
     o2(0xD5,0xA7), o2(0xCB,0xE5), o2(0xF9,0xE9), o2(0xBA,0xCA),
     o2(0xBE,0xAA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_A6 = {
    to_SHIFT_JIS_E5_A6_offsets,
    to_EUC_JP_E5_A6_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_A7_infos[19] = {
     o2(0xD5,0xA8), o2(0xBB,0xD0), o2(0xBB,0xCF), o2(0xB0,0xB9),
     o2(0xB8,0xC8), o2(0xC0,0xAB), o2(0xB0,0xD1), o2(0xD5,0xAC),
     o2(0xD5,0xAD), o2(0xD5,0xAA), o2(0xB1,0xB8), o2(0xB4,0xAF),
     o2(0xD5,0xA9), o2(0xCC,0xC5), o2(0xC9,0xB1), o2(0xB0,0xA8),
     o2(0xB0,0xF9), o2(0xBB,0xD1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_A7 = {
    to_SHIFT_JIS_E5_A7_offsets,
    to_EUC_JP_E5_A7_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_A8_infos[16] = {
     o2(0xB0,0xD2), o2(0xB0,0xA3), o2(0xD5,0xB2), o2(0xD5,0xB0),
     o2(0xCC,0xBC), o2(0xD5,0xB3), o2(0xD5,0xB1), o2(0xD5,0xAF),
     o2(0xBF,0xB1), o2(0xD5,0xAE), o2(0xCA,0xDA), o2(0xB8,0xE4),
     o2(0xD5,0xB7), o2(0xD5,0xB8), o2(0xBE,0xAB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_A8 = {
    to_SHIFT_JIS_E5_A8_offsets,
    to_EUC_JP_E5_A8_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_A9_infos[11] = {
     o2(0xD5,0xB4), o2(0xCF,0xAC), o2(0xC7,0xCC), o2(0xD5,0xB6),
     o2(0xBA,0xA7), o2(0xD5,0xB9), o2(0xC9,0xD8), o2(0xD5,0xBA),
     o2(0xD5,0xB5), o2(0xCC,0xBB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_A9 = {
    to_SHIFT_JIS_E5_A9_offsets,
    to_EUC_JP_E5_A9_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_AA_infos[7] = {
     o2(0xC7,0xDE), o2(0xD5,0xBB), o2(0xC9,0xB2), o2(0xD5,0xBC),
     o2(0xD5,0xC0), o2(0xD5,0xBD),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_AA = {
    to_SHIFT_JIS_E5_AA_offsets,
    to_EUC_JP_E5_AA_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_AB_infos[15] = {
     o2(0xB2,0xC7), o2(0xD5,0xBF), o2(0xBC,0xBB), o2(0xD5,0xBE),
     o2(0xB7,0xF9), o2(0xD5,0xCC), o2(0xD5,0xC5), o2(0xD5,0xC2),
     o2(0xC3,0xE4), o2(0xD5,0xC1), o2(0xD5,0xC3), o2(0xD5,0xC4),
     o2(0xD5,0xC6), o2(0xD5,0xC7),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_AB = {
    to_SHIFT_JIS_E5_AB_offsets,
    to_EUC_JP_E5_AB_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_AC_infos[12] = {
     o2(0xB4,0xF2), o2(0xD5,0xC9), o2(0xD5,0xC8), o2(0xD5,0xCA),
     o2(0xBE,0xEE), o2(0xD5,0xCD), o2(0xC4,0xDC), o2(0xB1,0xC5),
     o2(0xD5,0xCB), o2(0xD5,0xCE), o2(0xD5,0xCF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_AC = {
    to_SHIFT_JIS_E5_AC_offsets,
    to_EUC_JP_E5_AC_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_AD_infos[28] = {
     o2(0xD5,0xD2), o2(0xD5,0xD0), o2(0xD5,0xD1), o2(0xBB,0xD2),
     o2(0xD5,0xD3), o2(0xB9,0xA6), o2(0xD5,0xD4), o2(0xF9,0xEA),
     o2(0xBB,0xFA), o2(0xC2,0xB8), o2(0xD5,0xD5), o2(0xD5,0xD6),
     o2(0xBB,0xDA), o2(0xB9,0xA7), o2(0xCC,0xD2), o2(0xB5,0xA8),
     o2(0xB8,0xC9), o2(0xD5,0xD7), o2(0xB3,0xD8), o2(0xD5,0xD8),
     o2(0xC2,0xB9), o2(0xD5,0xD9), o2(0xD6,0xA3), o2(0xD5,0xDA),
     o2(0xD5,0xDB), o2(0xD5,0xDC), o2(0xD5,0xDE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_AD = {
    to_SHIFT_JIS_E5_AD_offsets,
    to_EUC_JP_E5_AD_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_AE_infos[34] = {
     o2(0xD5,0xDF), o2(0xD5,0xE0), o2(0xC2,0xF0), o2(0xB1,0xA7),
     o2(0xBC,0xE9), o2(0xB0,0xC2), o2(0xC1,0xD7), o2(0xB4,0xB0),
     o2(0xBC,0xB5), o2(0xB9,0xA8), o2(0xC5,0xE6), o2(0xBD,0xA1),
     o2(0xB4,0xB1), o2(0xC3,0xE8), o2(0xC4,0xEA), o2(0xB0,0xB8),
     o2(0xB5,0xB9), o2(0xCA,0xF5), o2(0xBC,0xC2), o2(0xB5,0xD2),
     o2(0xC0,0xEB), o2(0xBC,0xBC), o2(0xCD,0xA8), o2(0xD5,0xE1),
     o2(0xB5,0xDC), o2(0xBA,0xCB), o2(0xB3,0xB2), o2(0xB1,0xE3),
     o2(0xBE,0xAC), o2(0xB2,0xC8), o2(0xD5,0xE2), o2(0xCD,0xC6),
     o2(0xBD,0xC9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_AE = {
    to_SHIFT_JIS_E5_AE_offsets,
    to_EUC_JP_E5_AE_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_AF_infos[38] = {
     o2(0xF9,0xEB), o2(0xBC,0xE4), o2(0xD5,0xE3), o2(0xB4,0xF3),
     o2(0xC6,0xD2), o2(0xCC,0xA9), o2(0xD5,0xE4), o2(0xD5,0xE5),
     o2(0xC9,0xD9), o2(0xD5,0xE7), o2(0xB4,0xA8), o2(0xB6,0xF7),
     o2(0xD5,0xE6), o2(0xF9,0xED), o2(0xB4,0xB2), o2(0xBF,0xB2),
     o2(0xD5,0xEB), o2(0xBB,0xA1), o2(0xB2,0xC9), o2(0xD5,0xEA),
     o2(0xD5,0xE8), o2(0xD5,0xEC), o2(0xD5,0xE9), o2(0xC7,0xAB),
     o2(0xDC,0xCD), o2(0xBF,0xB3), o2(0xD5,0xED), o2(0xF9,0xEE),
     o2(0xCE,0xC0), o2(0xD5,0xEE), o2(0xD5,0xF0), o2(0xC3,0xFE),
     o2(0xD5,0xEF), o2(0xC0,0xA3), o2(0xBB,0xFB), o2(0xC2,0xD0),
     o2(0xBC,0xF7),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_AF = {
    to_SHIFT_JIS_E5_AF_offsets,
    to_EUC_JP_E5_AF_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_B0_infos[33] = {
     o2(0xC9,0xF5), o2(0xC0,0xEC), o2(0xBC,0xCD), o2(0xD5,0xF1),
     o2(0xBE,0xAD), o2(0xD5,0xF2), o2(0xD5,0xF3), o2(0xB0,0xD3),
     o2(0xC2,0xBA), o2(0xBF,0xD2), o2(0xD5,0xF4), o2(0xC6,0xB3),
     o2(0xBE,0xAE), o2(0xBE,0xAF), o2(0xD5,0xF5), o2(0xC0,0xED),
     o2(0xBE,0xB0), o2(0xF9,0xEF), o2(0xD5,0xF6), o2(0xD5,0xF7),
     o2(0xCC,0xE0), o2(0xD5,0xF8), o2(0xB6,0xC6), o2(0xBD,0xA2),
     o2(0xD5,0xF9), o2(0xD5,0xFA), o2(0xBC,0xDC), o2(0xBF,0xAC),
     o2(0xC6,0xF4), o2(0xBF,0xD4), o2(0xC8,0xF8), o2(0xC7,0xA2),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_B0 = {
    to_SHIFT_JIS_E5_B0_offsets,
    to_EUC_JP_E5_B0_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_B1_infos[26] = {
     o2(0xB6,0xC9), o2(0xD5,0xFB), o2(0xB5,0xEF), o2(0xD5,0xFC),
     o2(0xB6,0xFE), o2(0xC6,0xCF), o2(0xB2,0xB0), o2(0xBB,0xD3),
     o2(0xD5,0xFD), o2(0xD6,0xA2), o2(0xD6,0xA1), o2(0xB6,0xFD),
     o2(0xD5,0xFE), o2(0xC5,0xB8), o2(0xC2,0xB0), o2(0xC5,0xCB),
     o2(0xBC,0xC8), o2(0xC1,0xD8), o2(0xCD,0xFA), o2(0xD6,0xA4),
     o2(0xD6,0xA5), o2(0xC6,0xD6), o2(0xBB,0xB3), o2(0xD6,0xA7),
     o2(0xD6,0xA8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_B1 = {
    to_SHIFT_JIS_E5_B1_offsets,
    to_EUC_JP_E5_B1_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_B2_infos[20] = {
     o2(0xD6,0xA9), o2(0xB4,0xF4), o2(0xD6,0xAA), o2(0xD6,0xAB),
     o2(0xB2,0xAC), o2(0xF9,0xF0), o2(0xC1,0xBB), o2(0xB4,0xE4),
     o2(0xD6,0xAD), o2(0xCC,0xA8), o2(0xC2,0xD2), o2(0xB3,0xD9),
     o2(0xD6,0xAF), o2(0xD6,0xB1), o2(0xB4,0xDF), o2(0xF9,0xF1),
     o2(0xD6,0xAE), o2(0xD6,0xB0), o2(0xD6,0xB3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_B2 = {
    to_SHIFT_JIS_E5_B2_offsets,
    to_EUC_JP_E5_B2_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_B3_infos[17] = {
     o2(0xD6,0xB2), o2(0xD6,0xB4), o2(0xD6,0xB5), o2(0xC6,0xBD),
     o2(0xB6,0xAE), o2(0xB2,0xE5), o2(0xD6,0xB6), o2(0xD6,0xBB),
     o2(0xD6,0xB9), o2(0xCA,0xF7), o2(0xCA,0xF6), o2(0xF9,0xF2),
     o2(0xC5,0xE7), o2(0xD6,0xB8), o2(0xBD,0xD4), o2(0xD6,0xB7),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_B3 = {
    to_SHIFT_JIS_E5_B3_offsets,
    to_EUC_JP_E5_B3_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_B4_infos[17] = {
     o2(0xBF,0xF2), o2(0xD6,0xBC), o2(0xBA,0xEA), o2(0xD6,0xC2),
     o2(0xD6,0xC3), o2(0xD6,0xBD), o2(0xB3,0xB3), o2(0xD6,0xBE),
     o2(0xD6,0xC7), o2(0xD6,0xC6), o2(0xD6,0xC5), o2(0xD6,0xC1),
     o2(0xD6,0xC0), o2(0xD6,0xC4), o2(0xF9,0xF3), o2(0xCA,0xF8),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_B4 = {
    to_SHIFT_JIS_E5_B4_offsets,
    to_EUC_JP_E5_B4_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_B5_infos[15] = {
     o2(0xF9,0xF6), o2(0xD6,0xCB), o2(0xD6,0xC8), o2(0xD6,0xCA),
     o2(0xCD,0xF2), o2(0xD6,0xC9), o2(0xF9,0xF4), o2(0xD6,0xBF),
     o2(0xBF,0xF3), o2(0xD6,0xCC), o2(0xF9,0xF7), o2(0xBA,0xB7),
     o2(0xD6,0xCD), o2(0xD6,0xCE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_B5 = {
    to_SHIFT_JIS_E5_B5_offsets,
    to_EUC_JP_E5_B5_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_B6_infos[17] = {
     o2(0xD6,0xD1), o2(0xD6,0xD0), o2(0xD6,0xCF), o2(0xC5,0xE8),
     o2(0xD6,0xBA), o2(0xD6,0xD7), o2(0xD6,0xD3), o2(0xD6,0xD2),
     o2(0xD6,0xD4), o2(0xD6,0xD5), o2(0xD6,0xD8), o2(0xF9,0xF8),
     o2(0xF9,0xF9), o2(0xCE,0xE6), o2(0xD6,0xD9), o2(0xD6,0xD6),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_B6 = {
    to_SHIFT_JIS_E5_B6_offsets,
    to_EUC_JP_E5_B6_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_B7_infos[28] = {
     o2(0xD6,0xDA), o2(0xB4,0xE0), o2(0xD6,0xDB), o2(0xF9,0xFA),
     o2(0xD6,0xDD), o2(0xD6,0xDC), o2(0xD6,0xDE), o2(0xD6,0xDF),
     o2(0xC0,0xEE), o2(0xBD,0xA3), o2(0xBD,0xE4), o2(0xC1,0xE3),
     o2(0xB9,0xA9), o2(0xBA,0xB8), o2(0xB9,0xAA), o2(0xB5,0xF0),
     o2(0xD6,0xE0), o2(0xBA,0xB9), o2(0xB8,0xCA), o2(0xD6,0xE1),
     o2(0xCC,0xA6), o2(0xC7,0xC3), o2(0xD6,0xE2), o2(0xB9,0xAB),
     o2(0xB4,0xAC), o2(0xC3,0xA7), o2(0xB6,0xD2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_B7 = {
    to_SHIFT_JIS_E5_B7_offsets,
    to_EUC_JP_E5_B7_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_B8_infos[22] = {
     o2(0xBB,0xD4), o2(0xC9,0xDB), o2(0xC8,0xC1), o2(0xD6,0xE3),
     o2(0xB4,0xF5), o2(0xD6,0xE6), o2(0xC4,0xA1), o2(0xD6,0xE5),
     o2(0xD6,0xE4), o2(0xD6,0xE7), o2(0xC4,0xEB), o2(0xBF,0xE3),
     o2(0xBB,0xD5), o2(0xC0,0xCA), o2(0xC2,0xD3), o2(0xB5,0xA2),
     o2(0xC4,0xA2), o2(0xD6,0xE8), o2(0xD6,0xE9), o2(0xBE,0xEF),
     o2(0xCB,0xB9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_B8 = {
    to_SHIFT_JIS_E5_B8_offsets,
    to_EUC_JP_E5_B8_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_B9_infos[29] = {
     o2(0xD6,0xEC), o2(0xD6,0xEB), o2(0xD6,0xEA), o2(0xC9,0xFD),
     o2(0xD6,0xF3), o2(0xCB,0xDA), o2(0xD6,0xED), o2(0xD6,0xEF),
     o2(0xCB,0xEB), o2(0xD6,0xEE), o2(0xD6,0xF0), o2(0xC8,0xA8),
     o2(0xD6,0xF1), o2(0xCA,0xBE), o2(0xD6,0xF2), o2(0xB4,0xB3),
     o2(0xCA,0xBF), o2(0xC7,0xAF), o2(0xD6,0xF4), o2(0xD6,0xF5),
     o2(0xB9,0xAC), o2(0xB4,0xB4), o2(0xD6,0xF6), o2(0xB8,0xB8),
     o2(0xCD,0xC4), o2(0xCD,0xA9), o2(0xB4,0xF6), o2(0xD6,0xF8),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_B9 = {
    to_SHIFT_JIS_E5_B9_offsets,
    to_EUC_JP_E5_B9_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_BA_infos[21] = {
     o2(0xC4,0xA3), o2(0xB9,0xAD), o2(0xBE,0xB1), o2(0xC8,0xDF),
     o2(0xBE,0xB2), o2(0xBD,0xF8), o2(0xC4,0xEC), o2(0xCA,0xF9),
     o2(0xC5,0xB9), o2(0xB9,0xAE), o2(0xC9,0xDC), o2(0xD6,0xF9),
     o2(0xC5,0xD9), o2(0xBA,0xC2), o2(0xB8,0xCB), o2(0xC4,0xED),
     o2(0xB0,0xC3), o2(0xBD,0xEE), o2(0xB9,0xAF), o2(0xCD,0xC7),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_BA = {
    to_SHIFT_JIS_E5_BA_offsets,
    to_EUC_JP_E5_BA_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_BB_infos[34] = {
     o2(0xD6,0xFA), o2(0xD6,0xFB), o2(0xC7,0xD1), o2(0xD6,0xFC),
     o2(0xCE,0xF7), o2(0xCF,0xAD), o2(0xD6,0xFE), o2(0xD6,0xFD),
     o2(0xB3,0xC7), o2(0xD7,0xA1), o2(0xD7,0xA4), o2(0xD7,0xA5),
     o2(0xD7,0xA3), o2(0xC9,0xC0), o2(0xBE,0xB3), o2(0xD7,0xA7),
     o2(0xD7,0xA6), o2(0xD7,0xA2), o2(0xD7,0xA8), o2(0xD7,0xA9),
     o2(0xD7,0xAA), o2(0xD7,0xAD), o2(0xD7,0xAB), o2(0xD7,0xAC),
     o2(0xD7,0xAE), o2(0xB1,0xE4), o2(0xC4,0xEE), o2(0xD7,0xAF),
     o2(0xB7,0xFA), o2(0xB2,0xF6), o2(0xC7,0xB6), o2(0xD7,0xB0),
     o2(0xC6,0xFB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_BB = {
    to_SHIFT_JIS_E5_BB_offsets,
    to_EUC_JP_E5_BB_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_BC_infos[34] = {
     o2(0xCA,0xDB), o2(0xD7,0xB1), o2(0xCF,0xAE), o2(0xD7,0xB2),
     o2(0xCA,0xC0), o2(0xD7,0xB5), o2(0xD0,0xA1), o2(0xD0,0xB1),
     o2(0xBC,0xB0), o2(0xC6,0xF5), o2(0xD7,0xB6), o2(0xB5,0xDD),
     o2(0xC4,0xA4), o2(0xB0,0xFA), o2(0xD7,0xB7), o2(0xCA,0xA6),
     o2(0xB9,0xB0), o2(0xC3,0xD0), o2(0xC4,0xEF), o2(0xF9,0xFB),
     o2(0xCC,0xEF), o2(0xB8,0xB9), o2(0xB8,0xCC), o2(0xD7,0xB8),
     o2(0xD7,0xB9), o2(0xD7,0xBF), o2(0xBC,0xE5), o2(0xF9,0xFC),
     o2(0xC4,0xA5), o2(0xB6,0xAF), o2(0xD7,0xBA), o2(0xC9,0xAB),
     o2(0xC3,0xC6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_BC = {
    to_SHIFT_JIS_E5_BC_offsets,
    to_EUC_JP_E5_BC_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_BD_infos[30] = {
     o2(0xD7,0xBB), o2(0xF9,0xAC), o2(0xD7,0xBC), o2(0xB6,0xB0),
     o2(0xD7,0xBD), o2(0xD7,0xBE), o2(0xD7,0xC0), o2(0xC5,0xF6),
     o2(0xD7,0xC1), o2(0xD7,0xC2), o2(0xD7,0xC3), o2(0xD7,0xB4),
     o2(0xD7,0xB3), o2(0xD7,0xC4), o2(0xB7,0xC1), o2(0xC9,0xA7),
     o2(0xF9,0xFD), o2(0xBA,0xCC), o2(0xC9,0xB7), o2(0xC4,0xA6),
     o2(0xC9,0xCB), o2(0xD7,0xC5), o2(0xBE,0xB4), o2(0xB1,0xC6),
     o2(0xD7,0xC6), o2(0xD7,0xC7), o2(0xCC,0xF2), o2(0xC8,0xE0),
     o2(0xD7,0xCA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_BD = {
    to_SHIFT_JIS_E5_BD_offsets,
    to_EUC_JP_E5_BD_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_BE_infos[33] = {
     o2(0xB1,0xFD), o2(0xC0,0xAC), o2(0xD7,0xC9), o2(0xD7,0xC8),
     o2(0xB7,0xC2), o2(0xC2,0xD4), o2(0xD7,0xCE), o2(0xD7,0xCC),
     o2(0xD7,0xCB), o2(0xCE,0xA7), o2(0xB8,0xE5), o2(0xBD,0xF9),
     o2(0xD7,0xCD), o2(0xC5,0xCC), o2(0xBD,0xBE), o2(0xC6,0xC0),
     o2(0xD7,0xD1), o2(0xD7,0xD0), o2(0xD7,0xCF), o2(0xD7,0xD2),
     o2(0xB8,0xE6), o2(0xD7,0xD3), o2(0xC9,0xFC), o2(0xBD,0xDB),
     o2(0xD7,0xD4), o2(0xC8,0xF9), o2(0xC6,0xC1), o2(0xC4,0xA7),
     o2(0xF9,0xFE), o2(0xC5,0xB0), o2(0xD7,0xD5), o2(0xB5,0xAB),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_BE = {
    to_SHIFT_JIS_E5_BE_offsets,
    to_EUC_JP_E5_BE_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_BF_infos[22] = {
     o2(0xBF,0xB4), o2(0xC9,0xAC), o2(0xB4,0xF7), o2(0xC7,0xA6),
     o2(0xD7,0xD6), o2(0xBB,0xD6), o2(0xCB,0xBA), o2(0xCB,0xBB),
     o2(0xB1,0xFE), o2(0xD7,0xDB), o2(0xFA,0xA1), o2(0xC3,0xE9),
     o2(0xD7,0xD8), o2(0xB2,0xF7), o2(0xD8,0xAD), o2(0xD7,0xDA),
     o2(0xC7,0xB0), o2(0xD7,0xD9), o2(0xD7,0xD7), o2(0xB9,0xFA),
     o2(0xD7,0xDD),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5_BF = {
    to_SHIFT_JIS_E5_BF_offsets,
    to_EUC_JP_E5_BF_infos
};

static const struct byte_lookup* const
to_EUC_JP_E5_infos[64] = {
     &to_EUC_JP_E5_80, &to_EUC_JP_E5_81, &to_EUC_JP_E5_82, &to_EUC_JP_E5_83,
     &to_EUC_JP_E5_84, &to_EUC_JP_E5_85, &to_EUC_JP_E5_86, &to_EUC_JP_E5_87,
     &to_EUC_JP_E5_88, &to_EUC_JP_E5_89, &to_EUC_JP_E5_8A, &to_EUC_JP_E5_8B,
     &to_EUC_JP_E5_8C, &to_EUC_JP_E5_8D, &to_EUC_JP_E5_8E, &to_EUC_JP_E5_8F,
     &to_EUC_JP_E5_90, &to_EUC_JP_E5_91, &to_EUC_JP_E5_92, &to_EUC_JP_E5_93,
     &to_EUC_JP_E5_94, &to_EUC_JP_E5_95, &to_EUC_JP_E5_96, &to_EUC_JP_E5_97,
     &to_EUC_JP_E5_98, &to_EUC_JP_E5_99, &to_EUC_JP_E5_9A, &to_EUC_JP_E5_9B,
     &to_EUC_JP_E5_9C, &to_EUC_JP_E5_9D, &to_EUC_JP_E5_9E, &to_EUC_JP_E5_9F,
     &to_EUC_JP_E5_A0, &to_EUC_JP_E5_A1, &to_EUC_JP_E5_A2, &to_EUC_JP_E5_A3,
     &to_EUC_JP_E5_A4, &to_EUC_JP_E5_A5, &to_EUC_JP_E5_A6, &to_EUC_JP_E5_A7,
     &to_EUC_JP_E5_A8, &to_EUC_JP_E5_A9, &to_EUC_JP_E5_AA, &to_EUC_JP_E5_AB,
     &to_EUC_JP_E5_AC, &to_EUC_JP_E5_AD, &to_EUC_JP_E5_AE, &to_EUC_JP_E5_AF,
     &to_EUC_JP_E5_B0, &to_EUC_JP_E5_B1, &to_EUC_JP_E5_B2, &to_EUC_JP_E5_B3,
     &to_EUC_JP_E5_B4, &to_EUC_JP_E5_B5, &to_EUC_JP_E5_B6, &to_EUC_JP_E5_B7,
     &to_EUC_JP_E5_B8, &to_EUC_JP_E5_B9, &to_EUC_JP_E5_BA, &to_EUC_JP_E5_BB,
     &to_EUC_JP_E5_BC, &to_EUC_JP_E5_BD, &to_EUC_JP_E5_BE, &to_EUC_JP_E5_BF,
};
static const BYTE_LOOKUP
to_EUC_JP_E5 = {
    to_SHIFT_JIS_E5_offsets,
    to_EUC_JP_E5_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_80_infos[23] = {
     o2(0xD7,0xE3), o2(0xD7,0xE9), o2(0xD7,0xE1), o2(0xC5,0xDC),
     o2(0xD7,0xE6), o2(0xC9,0xDD), o2(0xD7,0xE0), o2(0xD7,0xE5),
     o2(0xCE,0xE7), o2(0xBB,0xD7), o2(0xC2,0xD5), o2(0xD7,0xDE),
     o2(0xB5,0xDE), o2(0xD7,0xE8), o2(0xC0,0xAD), o2(0xB1,0xE5),
     o2(0xD7,0xE2), o2(0xB2,0xF8), o2(0xD7,0xE7), o2(0xB6,0xB1),
     o2(0xD7,0xE4), o2(0xD7,0xEA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_80 = {
    to_SHIFT_JIS_E6_80_offsets,
    to_EUC_JP_E6_80_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_81_infos[30] = {
     o2(0xD7,0xEC), o2(0xD7,0xF6), o2(0xD7,0xF4), o2(0xD7,0xF1),
     o2(0xD7,0xF0), o2(0xCE,0xF8), o2(0xD7,0xF2), o2(0xB6,0xB2),
     o2(0xB9,0xB1), o2(0xBD,0xFA), o2(0xD7,0xF9), o2(0xD7,0xEB),
     o2(0xFA,0xA2), o2(0xD7,0xEF), o2(0xD7,0xDF), o2(0xB2,0xFA),
     o2(0xD7,0xF3), o2(0xD7,0xF5), o2(0xC3,0xD1), o2(0xBA,0xA8),
     o2(0xB2,0xB8), o2(0xD7,0xED), o2(0xD7,0xF8), o2(0xD7,0xF7),
     o2(0xB6,0xB3), o2(0xC2,0xA9), o2(0xB3,0xE6), o2(0xB7,0xC3),
     o2(0xD7,0xEE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_81 = {
    to_SHIFT_JIS_E6_81_offsets,
    to_EUC_JP_E6_81_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_82_infos[31] = {
     o2(0xD7,0xFA), o2(0xD7,0xFD), o2(0xD8,0xA1), o2(0xFA,0xA3),
     o2(0xBC,0xBD), o2(0xFA,0xA4), o2(0xD8,0xA7), o2(0xC4,0xF0),
     o2(0xD7,0xFB), o2(0xD8,0xA5), o2(0xB2,0xF9), o2(0xD8,0xA3),
     o2(0xD8,0xA4), o2(0xD7,0xFE), o2(0xD8,0xA2), o2(0xB8,0xE7),
     o2(0xCD,0xAA), o2(0xB4,0xB5), o2(0xB1,0xD9), o2(0xD8,0xA6),
     o2(0xC7,0xBA), o2(0xB0,0xAD), o2(0xC8,0xE1), o2(0xD7,0xDC),
     o2(0xD8,0xAC), o2(0xD8,0xB0), o2(0xCC,0xE5), o2(0xD8,0xA9),
     o2(0xC5,0xE9), o2(0xD8,0xAE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_82 = {
    to_SHIFT_JIS_E6_82_offsets,
    to_EUC_JP_E6_82_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_83_infos[27] = {
     o2(0xBE,0xF0), o2(0xD8,0xAF), o2(0xC6,0xD7), o2(0xCF,0xC7),
     o2(0xD8,0xAB), o2(0xFA,0xA6), o2(0xD8,0xB1), o2(0xB9,0xFB),
     o2(0xC0,0xCB), o2(0xFA,0xA5), o2(0xB0,0xD4), o2(0xD8,0xAA),
     o2(0xD8,0xA8), o2(0xC1,0xDA), o2(0xD7,0xFC), o2(0xBB,0xB4),
     o2(0xC2,0xC6), o2(0xD8,0xBD), o2(0xFA,0xA8), o2(0xC1,0xDB),
     o2(0xD8,0xB8), o2(0xD8,0xB5), o2(0xD8,0xB6), o2(0xBC,0xE6),
     o2(0xD8,0xB9), o2(0xD8,0xBC),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_83 = {
    to_SHIFT_JIS_E6_83_offsets,
    to_EUC_JP_E6_83_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_84_infos[27] = {
     o2(0xD8,0xB7), o2(0xBD,0xA5), o2(0xD8,0xBA), o2(0xD8,0xB4),
     o2(0xCC,0xFC), o2(0xCC,0xFB), o2(0xD8,0xBE), o2(0xD8,0xBF),
     o2(0xB0,0xD5), o2(0xFA,0xA9), o2(0xD8,0xB3), o2(0xB6,0xF2),
     o2(0xB0,0xA6), o2(0xB4,0xB6), o2(0xFA,0xA7), o2(0xD8,0xBB),
     o2(0xD8,0xC3), o2(0xD8,0xC2), o2(0xD8,0xC7), o2(0xFA,0xAB),
     o2(0xD8,0xC8), o2(0xFA,0xAA), o2(0xD8,0xC6), o2(0xD8,0xC9),
     o2(0xD8,0xC1), o2(0xD8,0xC5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_84 = {
    to_SHIFT_JIS_E6_84_offsets,
    to_EUC_JP_E6_84_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_85_infos[33] = {
     o2(0xD8,0xCA), o2(0xD8,0xCB), o2(0xD8,0xC0), o2(0xBB,0xFC),
     o2(0xD8,0xC4), o2(0xC2,0xD6), o2(0xB9,0xB2), o2(0xD8,0xB2),
     o2(0xBF,0xB5), o2(0xD8,0xD8), o2(0xCA,0xE9), o2(0xD8,0xCE),
     o2(0xD8,0xCF), o2(0xD8,0xD0), o2(0xD8,0xD7), o2(0xD8,0xD6),
     o2(0xCB,0xFD), o2(0xB4,0xB7), o2(0xD8,0xD4), o2(0xB7,0xC5),
     o2(0xB3,0xB4), o2(0xD8,0xD1), o2(0xCE,0xB8), o2(0xD8,0xD3),
     o2(0xB0,0xD6), o2(0xD8,0xD5), o2(0xD8,0xCC), o2(0xD8,0xD2),
     o2(0xD8,0xD9), o2(0xB7,0xC4), o2(0xD8,0xCD), o2(0xCD,0xDD),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_85 = {
    to_SHIFT_JIS_E6_85_offsets,
    to_EUC_JP_E6_85_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_86_infos[22] = {
     o2(0xCD,0xAB), o2(0xD8,0xDC), o2(0xD8,0xE0), o2(0xC1,0xFE),
     o2(0xCE,0xF9), o2(0xD8,0xE1), o2(0xD8,0xDE), o2(0xD8,0xDB),
     o2(0xFA,0xAC), o2(0xD8,0xDA), o2(0xD8,0xDF), o2(0xCA,0xB0),
     o2(0xC6,0xB4), o2(0xB7,0xC6), o2(0xD8,0xE2), o2(0xD8,0xDD),
     o2(0xD8,0xE3), o2(0xB7,0xFB), o2(0xB2,0xB1), o2(0xD8,0xEB),
     o2(0xB4,0xB8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_86 = {
    to_SHIFT_JIS_E6_86_offsets,
    to_EUC_JP_E6_86_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_87_infos[23] = {
     o2(0xD8,0xE9), o2(0xD8,0xEA), o2(0xBA,0xA9), o2(0xD8,0xE8),
     o2(0xD8,0xE6), o2(0xD8,0xE5), o2(0xD8,0xEC), o2(0xD8,0xE4),
     o2(0xD8,0xEE), o2(0xB2,0xFB), o2(0xD8,0xF0), o2(0xD8,0xEF),
     o2(0xC4,0xA8), o2(0xD8,0xF3), o2(0xD8,0xF1), o2(0xD8,0xE7),
     o2(0xB7,0xFC), o2(0xD8,0xF2), o2(0xD8,0xF6), o2(0xD8,0xF5),
     o2(0xD8,0xF7), o2(0xD8,0xF4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_87 = {
    to_SHIFT_JIS_E6_87_offsets,
    to_EUC_JP_E6_87_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_88_infos[31] = {
     o2(0xD8,0xF8), o2(0xD8,0xF9), o2(0xD8,0xFA), o2(0xCA,0xEA),
     o2(0xD8,0xFC), o2(0xD8,0xFB), o2(0xBD,0xBF), o2(0xC0,0xAE),
     o2(0xB2,0xE6), o2(0xB2,0xFC), o2(0xFA,0xAD), o2(0xD8,0xFD),
     o2(0xB0,0xBF), o2(0xC0,0xCC), o2(0xD8,0xFE), o2(0xEC,0xC3),
     o2(0xD9,0xA1), o2(0xB7,0xE1), o2(0xD9,0xA2), o2(0xC0,0xEF),
     o2(0xD9,0xA3), o2(0xD9,0xA4), o2(0xB5,0xBA), o2(0xD9,0xA5),
     o2(0xD9,0xA6), o2(0xD9,0xA7), o2(0xC2,0xD7), o2(0xB8,0xCD),
     o2(0xCC,0xE1), o2(0xCB,0xBC),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_88 = {
    to_SHIFT_JIS_E6_88_offsets,
    to_EUC_JP_E6_88_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_89_infos[24] = {
     o2(0xBD,0xEA), o2(0xD9,0xA8), o2(0xC0,0xF0), o2(0xEE,0xBD),
     o2(0xC8,0xE2), o2(0xBC,0xEA), o2(0xBA,0xCD), o2(0xD9,0xA9),
     o2(0xC2,0xC7), o2(0xCA,0xA7), o2(0xC2,0xF1), o2(0xD9,0xAC),
     o2(0xD9,0xAA), o2(0xD9,0xAD), o2(0xD9,0xAB), o2(0xD9,0xAE),
     o2(0xCA,0xB1), o2(0xB0,0xB7), o2(0xC9,0xDE), o2(0xC8,0xE3),
     o2(0xD9,0xAF), o2(0xD9,0xB2), o2(0xBE,0xB5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_89 = {
    to_SHIFT_JIS_E6_89_offsets,
    to_EUC_JP_E6_89_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_8A_infos[27] = {
     o2(0xB5,0xBB), o2(0xD9,0xB0), o2(0xD9,0xB7), o2(0xBE,0xB6),
     o2(0xD9,0xB1), o2(0xC7,0xC4), o2(0xCD,0xDE), o2(0xD9,0xB3),
     o2(0xD9,0xB4), o2(0xD9,0xB8), o2(0xC5,0xEA), o2(0xD9,0xB5),
     o2(0xB9,0xB3), o2(0xC0,0xDE), o2(0xD9,0xC6), o2(0xC8,0xB4),
     o2(0xC2,0xF2), o2(0xFA,0xAE), o2(0xC8,0xE4), o2(0xDA,0xAD),
     o2(0xCA,0xFA), o2(0xC4,0xF1), o2(0xCB,0xF5), o2(0xD9,0xBB),
     o2(0xB2,0xA1), o2(0xC3,0xEA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_8A = {
    to_SHIFT_JIS_E6_8A_offsets,
    to_EUC_JP_E6_8A_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_8B_infos[35] = {
     o2(0xD9,0xC4), o2(0xC3,0xB4), o2(0xD9,0xBE), o2(0xD9,0xC5),
     o2(0xD9,0xC0), o2(0xD9,0xC7), o2(0xD9,0xC3), o2(0xD9,0xC2),
     o2(0xC7,0xEF), o2(0xD9,0xBC), o2(0xB2,0xFD), o2(0xD9,0xBA),
     o2(0xB5,0xF1), o2(0xC2,0xF3), o2(0xD9,0xB6), o2(0xD9,0xB9),
     o2(0xB9,0xB4), o2(0xC0,0xDB), o2(0xBE,0xB7), o2(0xD9,0xC1),
     o2(0xC7,0xD2), o2(0xB5,0xF2), o2(0xB3,0xC8), o2(0xB3,0xE7),
     o2(0xBF,0xA1), o2(0xD9,0xC9), o2(0xD9,0xCE), o2(0xD9,0xCA),
     o2(0xB7,0xFD), o2(0xD9,0xCF), o2(0xBB,0xA2), o2(0xB9,0xE9),
     o2(0xBD,0xA6), o2(0xD9,0xBD),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_8B = {
    to_SHIFT_JIS_E6_8B_offsets,
    to_EUC_JP_E6_8B_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_8C_infos[18] = {
     o2(0xBB,0xFD), o2(0xD9,0xCC), o2(0xBB,0xD8), o2(0xD9,0xCD),
     o2(0xB0,0xC4), o2(0xD9,0xC8), o2(0xC4,0xA9), o2(0xB5,0xF3),
     o2(0xB6,0xB4), o2(0xD9,0xCB), o2(0xB0,0xA7), o2(0xBA,0xC3),
     o2(0xBF,0xB6), o2(0xC4,0xF2), o2(0xC8,0xD4), o2(0xD9,0xD1),
     o2(0xC1,0xDE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_8C = {
    to_SHIFT_JIS_E6_8C_offsets,
    to_EUC_JP_E6_8C_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_8D_infos[19] = {
     o2(0xC2,0xAA), o2(0xBB,0xAB), o2(0xD9,0xD2), o2(0xD9,0xD4),
     o2(0xD9,0xD0), o2(0xCA,0xE1), o2(0xC4,0xBD), o2(0xC1,0xDC),
     o2(0xCA,0xFB), o2(0xBC,0xCE), o2(0xD9,0xE0), o2(0xD9,0xDF),
     o2(0xBF,0xF8), o2(0xB7,0xFE), o2(0xD9,0xD9), o2(0xBE,0xB9),
     o2(0xC6,0xE8), o2(0xC7,0xB1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_8D = {
    to_SHIFT_JIS_E6_8D_offsets,
    to_EUC_JP_E6_8D_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_8E_infos[29] = {
     o2(0xD9,0xD7), o2(0xC1,0xDD), o2(0xBC,0xF8), o2(0xD9,0xDC),
     o2(0xBE,0xB8), o2(0xD9,0xD6), o2(0xD9,0xDB), o2(0xC7,0xD3),
     o2(0xD9,0xD5), o2(0xB7,0xA1), o2(0xB3,0xDD), o2(0xD9,0xDD),
     o2(0xCE,0xAB), o2(0xBA,0xCE), o2(0xC3,0xB5), o2(0xD9,0xDA),
     o2(0xC0,0xDC), o2(0xB9,0xB5), o2(0xBF,0xE4), o2(0xB1,0xE6),
     o2(0xC1,0xBC), o2(0xD9,0xD8), o2(0xB5,0xC5), o2(0xB7,0xC7),
     o2(0xC4,0xCF), o2(0xD9,0xDE), o2(0xC1,0xDF), o2(0xD9,0xE1),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_8E = {
    to_SHIFT_JIS_E6_8E_offsets,
    to_EUC_JP_E6_8E_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_8F_infos[20] = {
     o2(0xD9,0xE3), o2(0xC2,0xB7), o2(0xD9,0xE9), o2(0xD9,0xE4),
     o2(0xD9,0xE6), o2(0xC9,0xC1), o2(0xC4,0xF3), o2(0xD9,0xE7),
     o2(0xCD,0xAC), o2(0xCD,0xC8), o2(0xB4,0xB9), o2(0xB0,0xAE),
     o2(0xD9,0xE5), o2(0xD9,0xE2), o2(0xB4,0xF8), o2(0xB1,0xE7),
     o2(0xFA,0xAF), o2(0xD9,0xE8), o2(0xCD,0xC9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_8F = {
    to_SHIFT_JIS_E6_8F_offsets,
    to_EUC_JP_E6_8F_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_90_infos[16] = {
     o2(0xD9,0xEC), o2(0xC2,0xBB), o2(0xD9,0xF3), o2(0xD9,0xED),
     o2(0xD9,0xEA), o2(0xD9,0xF1), o2(0xD9,0xD3), o2(0xD9,0xEE),
     o2(0xD9,0xF2), o2(0xC8,0xC2), o2(0xC5,0xEB), o2(0xD9,0xEB),
     o2(0xD9,0xEF), o2(0xB7,0xC8), o2(0xBA,0xF1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_90 = {
    to_SHIFT_JIS_E6_90_offsets,
    to_EUC_JP_E6_90_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_91_infos[11] = {
     o2(0xC0,0xDD), o2(0xD9,0xF7), o2(0xC5,0xA6), o2(0xFA,0xB0),
     o2(0xD9,0xF4), o2(0xCB,0xE0), o2(0xD9,0xF5), o2(0xD9,0xF6),
     o2(0xCC,0xCE), o2(0xC0,0xA2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_91 = {
    to_SHIFT_JIS_E6_91_offsets,
    to_EUC_JP_E6_91_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_92_infos[20] = {
     o2(0xB7,0xE2), o2(0xD9,0xFD), o2(0xBB,0xB5), o2(0xD9,0xFA),
     o2(0xD9,0xF9), o2(0xC7,0xB2), o2(0xFA,0xB1), o2(0xC6,0xB5),
     o2(0xC5,0xB1), o2(0xD9,0xFB), o2(0xD9,0xFC), o2(0xC9,0xEF),
     o2(0xC7,0xC5), o2(0xBB,0xA3), o2(0xC0,0xF1), o2(0xCB,0xD0),
     o2(0xB3,0xC9), o2(0xDA,0xA5), o2(0xD9,0xFE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_92 = {
    to_SHIFT_JIS_E6_92_offsets,
    to_EUC_JP_E6_92_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_93_infos[26] = {
     o2(0xCD,0xCA), o2(0xDA,0xA7), o2(0xDA,0xA3), o2(0xDA,0xA4),
     o2(0xC1,0xE0), o2(0xFA,0xB2), o2(0xDA,0xA2), o2(0xD9,0xBF),
     o2(0xDA,0xA6), o2(0xDA,0xA1), o2(0xDA,0xAB), o2(0xDA,0xAC),
     o2(0xC5,0xA7), o2(0xDA,0xAE), o2(0xBB,0xA4), o2(0xDA,0xA9),
     o2(0xB5,0xBC), o2(0xDA,0xAF), o2(0xDA,0xA8), o2(0xDA,0xB3),
     o2(0xDA,0xB2), o2(0xDA,0xB1), o2(0xDA,0xB4), o2(0xDA,0xB6),
     o2(0xBE,0xF1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_93 = {
    to_SHIFT_JIS_E6_93_offsets,
    to_EUC_JP_E6_93_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_94_infos[21] = {
     o2(0xDA,0xB5), o2(0xDA,0xB9), o2(0xDA,0xB7), o2(0xDA,0xB8),
     o2(0xD9,0xF0), o2(0xDA,0xBB), o2(0xDA,0xBA), o2(0xD9,0xF8),
     o2(0xDA,0xBC), o2(0xDA,0xB0), o2(0xBB,0xD9), o2(0xDA,0xBD),
     o2(0xDA,0xBE), o2(0xDA,0xC0), o2(0xDA,0xBF), o2(0xDA,0xC1),
     o2(0xB2,0xFE), o2(0xB9,0xB6), o2(0xCA,0xFC), o2(0xC0,0xAF),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_94 = {
    to_SHIFT_JIS_E6_94_offsets,
    to_EUC_JP_E6_94_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_95_infos[24] = {
     o2(0xB8,0xCE), o2(0xDA,0xC3), o2(0xDA,0xC6), o2(0xFA,0xB3),
     o2(0xC9,0xD2), o2(0xB5,0xDF), o2(0xDA,0xC5), o2(0xDA,0xC4),
     o2(0xC7,0xD4), o2(0xDA,0xC7), o2(0xB6,0xB5), o2(0xDA,0xC9),
     o2(0xDA,0xC8), o2(0xB4,0xBA), o2(0xBB,0xB6), o2(0xC6,0xD8),
     o2(0xB7,0xC9), o2(0xBF,0xF4), o2(0xDA,0xCA), o2(0xC0,0xB0),
     o2(0xC5,0xA8), o2(0xC9,0xDF), o2(0xDA,0xCB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_95 = {
    to_SHIFT_JIS_E6_95_offsets,
    to_EUC_JP_E6_95_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_96_infos[28] = {
     o2(0xDA,0xCC), o2(0xDA,0xCD), o2(0xCA,0xB8), o2(0xD5,0xDD),
     o2(0xC0,0xC6), o2(0xC9,0xCC), o2(0xBA,0xD8), o2(0xC8,0xE5),
     o2(0xC8,0xC3), o2(0xC5,0xCD), o2(0xCE,0xC1), o2(0xDA,0xCF),
     o2(0xBC,0xD0), o2(0xDA,0xD0), o2(0xB0,0xB6), o2(0xB6,0xD4),
     o2(0xC0,0xCD), o2(0xC9,0xE0), o2(0xDA,0xD1), o2(0xBB,0xC2),
     o2(0xC3,0xC7), o2(0xBB,0xDB), o2(0xBF,0xB7), o2(0xDA,0xD2),
     o2(0xCA,0xFD), o2(0xB1,0xF7), o2(0xBB,0xDC),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_96 = {
    to_SHIFT_JIS_E6_96_offsets,
    to_EUC_JP_E6_96_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_97_infos[26] = {
     o2(0xDA,0xD5), o2(0xDA,0xD3), o2(0xDA,0xD6), o2(0xCE,0xB9),
     o2(0xDA,0xD4), o2(0xC0,0xFB), o2(0xDA,0xD7), o2(0xC2,0xB2),
     o2(0xDA,0xD8), o2(0xB4,0xFA), o2(0xDA,0xDA), o2(0xDA,0xD9),
     o2(0xDA,0xDB), o2(0xDA,0xDC), o2(0xB4,0xFB), o2(0xC6,0xFC),
     o2(0xC3,0xB6), o2(0xB5,0xEC), o2(0xBB,0xDD), o2(0xC1,0xE1),
     o2(0xBD,0xDC), o2(0xB0,0xB0), o2(0xDA,0xDD), o2(0xB2,0xA2),
     o2(0xDA,0xE1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_97 = {
    to_SHIFT_JIS_E6_97_offsets,
    to_EUC_JP_E6_97_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_98_infos[32] = {
     o2(0xFA,0xB4), o2(0xB9,0xB7), o2(0xDA,0xE0), o2(0xBA,0xAB),
     o2(0xBE,0xBA), o2(0xFA,0xB7), o2(0xDA,0xDF), o2(0xBE,0xBB),
     o2(0xCC,0xC0), o2(0xBA,0xAA), o2(0xB0,0xD7), o2(0xC0,0xCE),
     o2(0xFA,0xB5), o2(0xDA,0xE6), o2(0xFA,0xB9), o2(0xC0,0xB1),
     o2(0xB1,0xC7), o2(0xFA,0xBA), o2(0xBD,0xD5), o2(0xCB,0xE6),
     o2(0xBA,0xF2), o2(0xBE,0xBC), o2(0xFA,0xB8), o2(0xC0,0xA7),
     o2(0xF9,0xA8), o2(0xDA,0xE5), o2(0xDA,0xE3), o2(0xDA,0xE4),
     o2(0xFA,0xB6), o2(0xC3,0xEB), o2(0xDB,0xA6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_98 = {
    to_SHIFT_JIS_E6_98_offsets,
    to_EUC_JP_E6_98_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_99_infos[28] = {
     o2(0xDA,0xEA), o2(0xBB,0xFE), o2(0xB9,0xB8), o2(0xDA,0xE8),
     o2(0xDA,0xE9), o2(0xBF,0xB8), o2(0xDA,0xE7), o2(0xBB,0xAF),
     o2(0xFA,0xBC), o2(0xFA,0xBD), o2(0xDA,0xEC), o2(0xDA,0xEB),
     o2(0xDA,0xF0), o2(0xDA,0xF1), o2(0xDA,0xED), o2(0xFA,0xBB),
     o2(0xB3,0xA2), o2(0xDA,0xEE), o2(0xDA,0xEF), o2(0xC8,0xD5),
     o2(0xC9,0xE1), o2(0xB7,0xCA), o2(0xDA,0xF2), o2(0xFA,0xBF),
     o2(0xC0,0xB2), o2(0xBE,0xBD), o2(0xC3,0xD2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_99 = {
    to_SHIFT_JIS_E6_99_offsets,
    to_EUC_JP_E6_99_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_9A_infos[26] = {
     o2(0xB6,0xC7), o2(0xDA,0xF3), o2(0xDA,0xF7), o2(0xB2,0xCB),
     o2(0xDA,0xF4), o2(0xDA,0xF6), o2(0xDA,0xF5), o2(0xBD,0xEB),
     o2(0xC3,0xC8), o2(0xB0,0xC5), o2(0xDA,0xF8), o2(0xFA,0xC0),
     o2(0xDA,0xF9), o2(0xFA,0xC1), o2(0xC4,0xAA), o2(0xCE,0xF1),
     o2(0xBB,0xC3), o2(0xCA,0xEB), o2(0xFA,0xC2), o2(0xCB,0xBD),
     o2(0xDB,0xA2), o2(0xDA,0xFB), o2(0xDA,0xFE), o2(0xDA,0xFD),
     o2(0xFA,0xC3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_9A = {
    to_SHIFT_JIS_E6_9A_offsets,
    to_EUC_JP_E6_9A_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_9B_infos[27] = {
     o2(0xDA,0xFA), o2(0xDB,0xA1), o2(0xC6,0xDE), o2(0xDA,0xFC),
     o2(0xDB,0xA3), o2(0xBD,0xEC), o2(0xDB,0xA4), o2(0xCD,0xCB),
     o2(0xC7,0xF8), o2(0xDB,0xA5), o2(0xDB,0xA7), o2(0xDB,0xA8),
     o2(0xDB,0xA9), o2(0xB6,0xCA), o2(0xB1,0xC8), o2(0xB9,0xB9),
     o2(0xDB,0xAA), o2(0xDB,0xAB), o2(0xBD,0xF1), o2(0xC1,0xE2),
     o2(0xFA,0xC4), o2(0xF9,0xAB), o2(0xD2,0xD8), o2(0xC1,0xBE),
     o2(0xC1,0xBD), o2(0xC2,0xD8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_9B = {
    to_SHIFT_JIS_E6_9B_offsets,
    to_EUC_JP_E6_9B_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_9C_infos[33] = {
     o2(0xBA,0xC7), o2(0xD0,0xF2), o2(0xB7,0xEE), o2(0xCD,0xAD),
     o2(0xCA,0xFE), o2(0xC9,0xFE), o2(0xFA,0xC5), o2(0xDB,0xAC),
     o2(0xBA,0xF3), o2(0xC4,0xBF), o2(0xDB,0xAD), o2(0xCF,0xAF),
     o2(0xCB,0xBE), o2(0xC4,0xAB), o2(0xDB,0xAE), o2(0xB4,0xFC),
     o2(0xDB,0xAF), o2(0xDB,0xB0), o2(0xCC,0xDA), o2(0xCC,0xA4),
     o2(0xCB,0xF6), o2(0xCB,0xDC), o2(0xBB,0xA5), o2(0xDB,0xB2),
     o2(0xBC,0xEB), o2(0xCB,0xD1), o2(0xDB,0xB4), o2(0xDB,0xB7),
     o2(0xDB,0xB6), o2(0xB4,0xF9), o2(0xB5,0xE0), o2(0xDB,0xB3),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_9C = {
    to_SHIFT_JIS_E6_9C_offsets,
    to_EUC_JP_E6_9C_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_9D_infos[33] = {
     o2(0xDB,0xB5), o2(0xDB,0xB8), o2(0xBF,0xF9), o2(0xCD,0xFB),
     o2(0xB0,0xC9), o2(0xBA,0xE0), o2(0xC2,0xBC), o2(0xBC,0xDD),
     o2(0xBE,0xF3), o2(0xDB,0xBB), o2(0xC5,0xCE), o2(0xDB,0xB9),
     o2(0xC2,0xAB), o2(0xDB,0xBA), o2(0xBE,0xF2), o2(0xCC,0xDD),
     o2(0xDB,0xBC), o2(0xDB,0xBD), o2(0xCD,0xE8), o2(0xFA,0xC7),
     o2(0xDB,0xC2), o2(0xB9,0xBA), o2(0xC7,0xD5), o2(0xDB,0xBF),
     o2(0xC5,0xEC), o2(0xDA,0xDE), o2(0xDA,0xE2), o2(0xB5,0xCF),
     o2(0xC7,0xC7), o2(0xDB,0xC1), o2(0xBE,0xBE), o2(0xC8,0xC4),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_9D = {
    to_SHIFT_JIS_E6_9D_offsets,
    to_EUC_JP_E6_9D_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_9E_infos[25] = {
     o2(0xDB,0xC7), o2(0xC8,0xFA), o2(0xDB,0xBE), o2(0xDB,0xC4),
     o2(0xDB,0xC3), o2(0xC0,0xCF), o2(0xCB,0xED), o2(0xCE,0xD3),
     o2(0xCB,0xE7), o2(0xB2,0xCC), o2(0xBB,0xDE), o2(0xCF,0xC8),
     o2(0xDB,0xC6), o2(0xBF,0xF5), o2(0xDB,0xC5), o2(0xDB,0xC0),
     o2(0xB8,0xCF), o2(0xDB,0xCC), o2(0xDB,0xCA), o2(0xB2,0xCD),
     o2(0xDB,0xC8), o2(0xDB,0xCE), o2(0xDB,0xD4), o2(0xFA,0xC8),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_9E = {
    to_SHIFT_JIS_E6_9E_offsets,
    to_EUC_JP_E6_9E_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_9F_infos[30] = {
     o2(0xFA,0xCA), o2(0xC2,0xC8), o2(0xCA,0xC1), o2(0xDB,0xD6),
     o2(0xC9,0xA2), o2(0xDB,0xD5), o2(0xC7,0xF0), o2(0xCB,0xBF),
     o2(0xB4,0xBB), o2(0xC0,0xF7), o2(0xBD,0xC0), o2(0xC4,0xD3),
     o2(0xCD,0xAE), o2(0xDB,0xD1), o2(0xDB,0xD0), o2(0xDB,0xD2),
     o2(0xDB,0xCF), o2(0xDB,0xD7), o2(0xDB,0xCD), o2(0xDB,0xCB),
     o2(0xDB,0xD3), o2(0xDB,0xC9), o2(0xC3,0xEC), o2(0xCC,0xF8),
     o2(0xBC,0xC6), o2(0xBA,0xF4), o2(0xBA,0xBA), o2(0xCB,0xEF),
     o2(0xB3,0xC1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_9F = {
    to_SHIFT_JIS_E6_9F_offsets,
    to_EUC_JP_E6_9F_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_A0_infos[20] = {
     o2(0xFA,0xCB), o2(0xC4,0xCE), o2(0xC6,0xCA), o2(0xB1,0xC9),
     o2(0xC0,0xF2), o2(0xC0,0xB4), o2(0xB7,0xAA), o2(0xDB,0xD9),
     o2(0xB9,0xBB), o2(0xB3,0xFC), o2(0xDB,0xDB), o2(0xB3,0xF4),
     o2(0xDB,0xE1), o2(0xDB,0xDE), o2(0xC0,0xF3), o2(0xB3,0xCB),
     o2(0xBA,0xAC), o2(0xB3,0xCA), o2(0xBA,0xCF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_A0 = {
    to_SHIFT_JIS_E6_A0_offsets,
    to_EUC_JP_E6_A0_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_A1_infos[26] = {
     o2(0xDB,0xDC), o2(0xB7,0xE5), o2(0xB7,0xCB), o2(0xC5,0xED),
     o2(0xFA,0xCC), o2(0xDB,0xDA), o2(0xB0,0xC6), o2(0xDB,0xDD),
     o2(0xDB,0xDF), o2(0xB6,0xCD), o2(0xB7,0xAC), o2(0xFA,0xC9),
     o2(0xB4,0xBC), o2(0xB5,0xCB), o2(0xDB,0xE2), o2(0xBA,0xF9),
     o2(0xCB,0xF1), o2(0xBB,0xB7), o2(0xDB,0xE3), o2(0xC9,0xB0),
     o2(0xDB,0xEF), o2(0xB2,0xB3), o2(0xDB,0xE4), o2(0xDB,0xF5),
     o2(0xDB,0xE5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_A1 = {
    to_SHIFT_JIS_E6_A1_offsets,
    to_EUC_JP_E6_A1_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_A2_infos[27] = {
     o2(0xCE,0xC2), o2(0xDB,0xEC), o2(0xC7,0xDF), o2(0xDB,0xF4),
     o2(0xDB,0xE7), o2(0xB0,0xB4), o2(0xDB,0xE9), o2(0xB9,0xBC),
     o2(0xDB,0xEB), o2(0xDB,0xEA), o2(0xDB,0xE6), o2(0xDB,0xF1),
     o2(0xBE,0xBF), o2(0xD4,0xED), o2(0xB8,0xE8), o2(0xCD,0xFC),
     o2(0xDB,0xE8), o2(0xC4,0xF4), o2(0xB3,0xA3), o2(0xBA,0xAD),
     o2(0xDB,0xE0), o2(0xDB,0xF0), o2(0xB3,0xE1), o2(0xDB,0xEE),
     o2(0xDB,0xF2), o2(0xC5,0xEE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_A2 = {
    to_SHIFT_JIS_E6_A2_offsets,
    to_EUC_JP_E6_A2_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_A3_infos[25] = {
     o2(0xB4,0xFE), o2(0xDC,0xB2), o2(0xF9,0xA9), o2(0xCC,0xC9),
     o2(0xDB,0xF7), o2(0xB4,0xFD), o2(0xDB,0xFE), o2(0xFA,0xCD),
     o2(0xCB,0xC0), o2(0xDC,0xA1), o2(0xDC,0xA3), o2(0xDC,0xA7),
     o2(0xDB,0xF9), o2(0xC3,0xAA), o2(0xC5,0xEF), o2(0xDC,0xAB),
     o2(0xDB,0xFC), o2(0xDC,0xA8), o2(0xDC,0xA2), o2(0xBF,0xB9),
     o2(0xDC,0xAC), o2(0xC0,0xB3), o2(0xDC,0xAA), o2(0xB4,0xBD),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_A3 = {
    to_SHIFT_JIS_E6_A3_offsets,
    to_EUC_JP_E6_A3_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_A4_infos[29] = {
     o2(0xCF,0xD0), o2(0xDB,0xF6), o2(0xDC,0xA6), o2(0xB0,0xD8),
     o2(0xDB,0xF8), o2(0xCC,0xBA), o2(0xDB,0xFD), o2(0xBF,0xA2),
     o2(0xC4,0xC7), o2(0xDB,0xF3), o2(0xDC,0xA5), o2(0xBF,0xFA),
     o2(0xDC,0xAF), o2(0xB3,0xF1), o2(0xB8,0xA1), o2(0xDC,0xB1),
     o2(0xDB,0xFA), o2(0xDC,0xB0), o2(0xDC,0xA9), o2(0xDB,0xFB),
     o2(0xDC,0xAD), o2(0xDC,0xAE), o2(0xDC,0xBF), o2(0xC6,0xCE),
     o2(0xDC,0xA4), o2(0xDC,0xBB), o2(0xDC,0xBD), o2(0xC4,0xD8),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_A4 = {
    to_SHIFT_JIS_E6_A4_offsets,
    to_EUC_JP_E6_A4_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_A5_infos[28] = {
     o2(0xCD,0xCC), o2(0xC9,0xF6), o2(0xDC,0xB8), o2(0xC2,0xCA),
     o2(0xDC,0xBE), o2(0xC1,0xBF), o2(0xDC,0xB5), o2(0xDC,0xC2),
     o2(0xDC,0xC1), o2(0xC6,0xEF), o2(0xDC,0xC0), o2(0xC6,0xEA),
     o2(0xFA,0xCF), o2(0xDC,0xC4), o2(0xDC,0xB7), o2(0xB6,0xC8),
     o2(0xDC,0xBA), o2(0xBD,0xDD), o2(0xC7,0xE0), o2(0xDC,0xBC),
     o2(0xB6,0xCB), o2(0xDC,0xB4), o2(0xDC,0xB6), o2(0xDC,0xB3),
     o2(0xCF,0xB0), o2(0xB3,0xDA), o2(0xDC,0xB9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_A5 = {
    to_SHIFT_JIS_E6_A5_offsets,
    to_EUC_JP_E6_A5_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_A6_infos[20] = {
     o2(0xDC,0xC3), o2(0xB3,0xB5), o2(0xBA,0xE7), o2(0xB1,0xDD),
     o2(0xDC,0xD4), o2(0xCF,0xB1), o2(0xDC,0xD7), o2(0xFA,0xD1),
     o2(0xBF,0xBA), o2(0xDC,0xD6), o2(0xDC,0xD5), o2(0xDC,0xD2),
     o2(0xDC,0xC6), o2(0xDC,0xE3), o2(0xDC,0xC5), o2(0xDC,0xD8),
     o2(0xDC,0xD0), o2(0xDC,0xCB), o2(0xDC,0xC8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_A6 = {
    to_SHIFT_JIS_E6_A6_offsets,
    to_EUC_JP_E6_A6_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_A7_infos[25] = {
     o2(0xDC,0xC9), o2(0xDC,0xD1), o2(0xF4,0xA2), o2(0xDC,0xCE),
     o2(0xB9,0xBD), o2(0xC4,0xC8), o2(0xC1,0xE4), o2(0xDC,0xCC),
     o2(0xDC,0xC7), o2(0xDC,0xCA), o2(0xCD,0xCD), o2(0xCB,0xEA),
     o2(0xDC,0xCF), o2(0xDC,0xD9), o2(0xFA,0xD2), o2(0xDC,0xE1),
     o2(0xDC,0xDA), o2(0xDC,0xE7), o2(0xDC,0xE5), o2(0xDC,0xE0),
     o2(0xDC,0xDF), o2(0xC4,0xD0), o2(0xC1,0xE5), o2(0xDC,0xDD),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_A7 = {
    to_SHIFT_JIS_E6_A7_offsets,
    to_EUC_JP_E6_A7_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_A8_infos[28] = {
     o2(0xDC,0xDB), o2(0xDC,0xE2), o2(0xDC,0xE8), o2(0xC8,0xF5),
     o2(0xDC,0xEE), o2(0xDC,0xE9), o2(0xDC,0xEC), o2(0xDC,0xE6),
     o2(0xC3,0xF4), o2(0xC9,0xB8), o2(0xDC,0xDC), o2(0xDC,0xE4),
     o2(0xBE,0xC0), o2(0xCC,0xCF), o2(0xDC,0xF8), o2(0xDC,0xEB),
     o2(0xB8,0xA2), o2(0xB2,0xA3), o2(0xB3,0xDF), o2(0xDC,0xD3),
     o2(0xFA,0xD3), o2(0xBE,0xC1), o2(0xDC,0xF0), o2(0xDC,0xF7),
     o2(0xBC,0xF9), o2(0xB3,0xF2), o2(0xC3,0xAE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_A8 = {
    to_SHIFT_JIS_E6_A8_offsets,
    to_EUC_JP_E6_A8_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_A9_infos[18] = {
     o2(0xDC,0xED), o2(0xFA,0xD5), o2(0xDC,0xF2), o2(0xDC,0xF6),
     o2(0xB6,0xB6), o2(0xB5,0xCC), o2(0xDC,0xF4), o2(0xB5,0xA1),
     o2(0xC6,0xCB), o2(0xDC,0xF3), o2(0xDC,0xF5), o2(0xFA,0xD4),
     o2(0xDC,0xEF), o2(0xFA,0xD6), o2(0xDC,0xF1), o2(0xFA,0xD7),
     o2(0xB3,0xE0),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_A9 = {
    to_SHIFT_JIS_E6_A9_offsets,
    to_EUC_JP_E6_A9_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_AA_infos[17] = {
     o2(0xC3,0xC9), o2(0xDC,0xFC), o2(0xDC,0xFA), o2(0xB8,0xE9),
     o2(0xDC,0xF9), o2(0xDD,0xA1), o2(0xDB,0xD8), o2(0xDC,0xFB),
     o2(0xDC,0xFD), o2(0xDC,0xFE), o2(0xDD,0xAC), o2(0xDD,0xA8),
     o2(0xDB,0xED), o2(0xDD,0xA7), o2(0xDD,0xA6), o2(0xDD,0xA3),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_AA = {
    to_SHIFT_JIS_E6_AA_offsets,
    to_EUC_JP_E6_AA_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_AB_infos[16] = {
     o2(0xDC,0xEA), o2(0xDD,0xA5), o2(0xDD,0xA4), o2(0xDD,0xAA),
     o2(0xCF,0xA6), o2(0xDD,0xAD), o2(0xB6,0xFB), o2(0xDD,0xA9),
     o2(0xDD,0xAB), o2(0xFA,0xD8), o2(0xFA,0xD9), o2(0xC8,0xA7),
     o2(0xDD,0xAE), o2(0xDD,0xB2), o2(0xDD,0xAF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_AB = {
    to_SHIFT_JIS_E6_AB_offsets,
    to_EUC_JP_E6_AB_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_AC_infos[19] = {
     o2(0xCD,0xF3), o2(0xDD,0xB0), o2(0xDC,0xDE), o2(0xDD,0xB3),
     o2(0xDD,0xB4), o2(0xB1,0xB5), o2(0xDD,0xB6), o2(0xB7,0xE7),
     o2(0xBC,0xA1), o2(0xB6,0xD5), o2(0xB2,0xA4), o2(0xCD,0xDF),
     o2(0xDD,0xB8), o2(0xDD,0xB7), o2(0xDD,0xBA), o2(0xB5,0xBD),
     o2(0xB6,0xD6), o2(0xB4,0xBE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_AC = {
    to_SHIFT_JIS_E6_AC_offsets,
    to_EUC_JP_E6_AC_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_AD_infos[26] = {
     o2(0xDD,0xBD), o2(0xDD,0xBC), o2(0xDD,0xBE), o2(0xB2,0xCE),
     o2(0xC3,0xB7), o2(0xDD,0xBF), o2(0xB4,0xBF), o2(0xDD,0xC1),
     o2(0xDD,0xC0), o2(0xDD,0xC2), o2(0xDD,0xC3), o2(0xDD,0xC4),
     o2(0xBB,0xDF), o2(0xC0,0xB5), o2(0xBA,0xA1), o2(0xC9,0xF0),
     o2(0xCA,0xE2), o2(0xCF,0xC4), o2(0xBB,0xF5), o2(0xBA,0xD0),
     o2(0xCE,0xF2), o2(0xDD,0xC5), o2(0xDD,0xC6), o2(0xBB,0xE0),
     o2(0xDD,0xC7),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_AD = {
    to_SHIFT_JIS_E6_AD_offsets,
    to_EUC_JP_E6_AD_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_AE_infos[27] = {
     o2(0xDD,0xC8), o2(0xDD,0xCA), o2(0xDD,0xC9), o2(0xCB,0xD8),
     o2(0xBD,0xDE), o2(0xBC,0xEC), o2(0xBB,0xC4), o2(0xDD,0xCB),
     o2(0xDD,0xCD), o2(0xBF,0xA3), o2(0xDD,0xCC), o2(0xDD,0xCE),
     o2(0xDD,0xCF), o2(0xDD,0xD0), o2(0xDD,0xD1), o2(0xDD,0xD2),
     o2(0xDD,0xD4), o2(0xDD,0xD3), o2(0xDD,0xD5), o2(0xB2,0xA5),
     o2(0xC3,0xCA), o2(0xDD,0xD6), o2(0xBB,0xA6), o2(0xB3,0xCC),
     o2(0xDD,0xD7), o2(0xC5,0xC2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_AE = {
    to_SHIFT_JIS_E6_AE_offsets,
    to_EUC_JP_E6_AE_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_AF_infos[18] = {
     o2(0xD4,0xCC), o2(0xB5,0xA3), o2(0xDD,0xD8), o2(0xDD,0xD9),
     o2(0xCA,0xEC), o2(0xCB,0xE8), o2(0xC6,0xC7), o2(0xDD,0xDA),
     o2(0xC8,0xE6), o2(0xFA,0xDA), o2(0xC8,0xFB), o2(0xCC,0xD3),
     o2(0xDD,0xDB), o2(0xDD,0xDD), o2(0xDD,0xDC), o2(0xDD,0xDF),
     o2(0xDD,0xDE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_AF = {
    to_SHIFT_JIS_E6_AF_offsets,
    to_EUC_JP_E6_AF_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_B0_infos[15] = {
     o2(0xDD,0xE1), o2(0xBB,0xE1), o2(0xCC,0xB1), o2(0xDD,0xE2),
     o2(0xDD,0xE3), o2(0xB5,0xA4), o2(0xDD,0xE4), o2(0xDD,0xE6),
     o2(0xDD,0xE5), o2(0xBF,0xE5), o2(0xC9,0xB9), o2(0xB1,0xCA),
     o2(0xC8,0xC5), o2(0xFA,0xDB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_B0 = {
    to_SHIFT_JIS_E6_B0_offsets,
    to_EUC_JP_E6_B0_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_B1_infos[24] = {
     o2(0xC4,0xF5), o2(0xBD,0xC1), o2(0xB5,0xE1), o2(0xC8,0xC6),
     o2(0xBC,0xAE), o2(0xDD,0xE8), o2(0xB4,0xC0), o2(0xB1,0xF8),
     o2(0xFA,0xDC), o2(0xC6,0xF2), o2(0xDD,0xE7), o2(0xB9,0xBE),
     o2(0xC3,0xD3), o2(0xDD,0xE9), o2(0xDD,0xF1), o2(0xDD,0xEA),
     o2(0xFA,0xDE), o2(0xC2,0xC1), o2(0xB5,0xE2), o2(0xDD,0xF2),
     o2(0xB7,0xE8), o2(0xB5,0xA5), o2(0xDD,0xF0),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_B1 = {
    to_SHIFT_JIS_E6_B1_offsets,
    to_EUC_JP_E6_B1_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_B2_infos[29] = {
     o2(0xDD,0xEE), o2(0xDD,0xEB), o2(0xCD,0xE0), o2(0xFA,0xDD),
     o2(0xC4,0xC0), o2(0xC6,0xD9), o2(0xDD,0xEC), o2(0xDD,0xF4),
     o2(0xDD,0xF3), o2(0xB7,0xA3), o2(0xB2,0xAD), o2(0xBA,0xBB),
     o2(0xDD,0xED), o2(0xDD,0xEF), o2(0xCB,0xD7), o2(0xC2,0xF4),
     o2(0xCB,0xF7), o2(0xDD,0xFC), o2(0xDD,0xFD), o2(0xB2,0xCF),
     o2(0xCA,0xA8), o2(0xCC,0xFD), o2(0xDE,0xA1), o2(0xBC,0xA3),
     o2(0xBE,0xC2), o2(0xDD,0xF8), o2(0xDD,0xFE), o2(0xB1,0xE8),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_B2 = {
    to_SHIFT_JIS_E6_B2_offsets,
    to_EUC_JP_E6_B2_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_B3_infos[24] = {
     o2(0xB6,0xB7), o2(0xDD,0xF5), o2(0xDD,0xFA), o2(0xC0,0xF4),
     o2(0xC7,0xF1), o2(0xC8,0xE7), o2(0xDD,0xF7), o2(0xCB,0xA1),
     o2(0xDD,0xF9), o2(0xDE,0xA4), o2(0xFA,0xDF), o2(0xDE,0xA2),
     o2(0xDD,0xFB), o2(0xCB,0xA2), o2(0xC7,0xC8), o2(0xB5,0xE3),
     o2(0xC5,0xA5), o2(0xC3,0xED), o2(0xDE,0xA5), o2(0xDE,0xA3),
     o2(0xC2,0xD9), o2(0xDD,0xF6), o2(0xB1,0xCB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_B3 = {
    to_SHIFT_JIS_E6_B3_offsets,
    to_EUC_JP_E6_B3_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_B4_infos[22] = {
     o2(0xFA,0xE0), o2(0xCD,0xCE), o2(0xDE,0xB0), o2(0xDE,0xAF),
     o2(0xC0,0xF6), o2(0xDE,0xAC), o2(0xCD,0xEC), o2(0xC6,0xB6),
     o2(0xDE,0xA6), o2(0xC4,0xC5), o2(0xB1,0xCC), o2(0xB9,0xBF),
     o2(0xDE,0xA9), o2(0xBD,0xA7), o2(0xDE,0xAE), o2(0xDE,0xAD),
     o2(0xDE,0xA8), o2(0xDE,0xAB), o2(0xB3,0xE8), o2(0xDE,0xAA),
     o2(0xC7,0xC9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_B4 = {
    to_SHIFT_JIS_E6_B4_offsets,
    to_EUC_JP_E6_B4_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_B5_infos[19] = {
     o2(0xCE,0xAE), o2(0xBE,0xF4), o2(0xC0,0xF5), o2(0xDE,0xB6),
     o2(0xDE,0xB4), o2(0xC9,0xCD), o2(0xDE,0xB1), o2(0xDE,0xB3),
     o2(0xB1,0xBA), o2(0xB9,0xC0), o2(0xCF,0xB2), o2(0xB3,0xBD),
     o2(0xC9,0xE2), o2(0xFA,0xE2), o2(0xCD,0xE1), o2(0xB3,0xA4),
     o2(0xBF,0xBB), o2(0xDE,0xB5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_B5 = {
    to_SHIFT_JIS_E6_B5_offsets,
    to_EUC_JP_E6_B5_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_B6_infos[18] = {
     o2(0xDE,0xBA), o2(0xFA,0xE1), o2(0xBE,0xC3), o2(0xCD,0xB0),
     o2(0xDE,0xB7), o2(0xDE,0xB2), o2(0xDE,0xB8), o2(0xFA,0xE3),
     o2(0xCE,0xDE), o2(0xC5,0xF3), o2(0xC6,0xC2), o2(0xFA,0xE4),
     o2(0xB3,0xB6), o2(0xB1,0xD5), o2(0xDE,0xBE), o2(0xDE,0xC1),
     o2(0xCE,0xC3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_B6 = {
    to_SHIFT_JIS_E6_B6_offsets,
    to_EUC_JP_E6_B6_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_B7_infos[32] = {
     o2(0xCD,0xE4), o2(0xDE,0xC8), o2(0xDE,0xC2), o2(0xDE,0xBF),
     o2(0xCE,0xD4), o2(0xDE,0xC5), o2(0xFA,0xE5), o2(0xBD,0xCA),
     o2(0xDE,0xC7), o2(0xDE,0xCC), o2(0xC5,0xF1), o2(0xDE,0xCA),
     o2(0xDE,0xC4), o2(0xC3,0xB8), o2(0xDE,0xCB), o2(0xDE,0xC0),
     o2(0xDE,0xC6), o2(0xDE,0xCD), o2(0xB0,0xFC), o2(0xDE,0xC3),
     o2(0xDE,0xCE), o2(0xBF,0xBC), o2(0xFA,0xE7), o2(0xBD,0xDF),
     o2(0xCA,0xA5), o2(0xBA,0xAE), o2(0xFA,0xE6), o2(0xDE,0xBB),
     o2(0xDE,0xC9), o2(0xC5,0xBA), o2(0xFA,0xE8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_B7 = {
    to_SHIFT_JIS_E6_B7_offsets,
    to_EUC_JP_E6_B7_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_B8_infos[32] = {
     o2(0xC0,0xB6), o2(0xB3,0xE9), o2(0xBA,0xD1), o2(0xBE,0xC4),
     o2(0xDE,0xBD), o2(0xBD,0xC2), o2(0xB7,0xCC), o2(0xDE,0xBC),
     o2(0xDE,0xD2), o2(0xBD,0xED), o2(0xB8,0xBA), o2(0xDE,0xE1),
     o2(0xDE,0xDB), o2(0xB5,0xF4), o2(0xC5,0xCF), o2(0xDE,0xD6),
     o2(0xDE,0xDF), o2(0xB0,0xAF), o2(0xB1,0xB2), o2(0xFA,0xEB),
     o2(0xB2,0xB9), o2(0xDE,0xD8), o2(0xC2,0xAC), o2(0xDE,0xCF),
     o2(0xDE,0xD1), o2(0xB9,0xC1), o2(0xDE,0xE2), o2(0xFA,0xE9),
     o2(0xDE,0xDD), o2(0xFA,0xEC), o2(0xDE,0xD5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_B8 = {
    to_SHIFT_JIS_E6_B8_offsets,
    to_EUC_JP_E6_B8_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_B9_infos[18] = {
     o2(0xDE,0xDC), o2(0xCC,0xAB), o2(0xDE,0xDA), o2(0xDE,0xDE),
     o2(0xB8,0xD0), o2(0xBE,0xC5), o2(0xC3,0xB9), o2(0xFA,0xEA),
     o2(0xDE,0xD4), o2(0xCD,0xAF), o2(0xDE,0xD7), o2(0xDE,0xD0),
     o2(0xC5,0xF2), o2(0xDE,0xD3), o2(0xDE,0xD9), o2(0xCF,0xD1),
     o2(0xBC,0xBE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_B9 = {
    to_SHIFT_JIS_E6_B9_offsets,
    to_EUC_JP_E6_B9_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_BA_infos[21] = {
     o2(0xCB,0xFE), o2(0xDE,0xE3), o2(0xC8,0xAE), o2(0xDE,0xEF),
     o2(0xB8,0xBB), o2(0xBD,0xE0), o2(0xDE,0xE5), o2(0xCE,0xAF),
     o2(0xB9,0xC2), o2(0xDE,0xF2), o2(0xB0,0xEE), o2(0xDE,0xF0),
     o2(0xDE,0xE4), o2(0xDE,0xEA), o2(0xDE,0xEC), o2(0xCD,0xCF),
     o2(0xDE,0xE7), o2(0xC5,0xAE), o2(0xDE,0xE9), o2(0xFA,0xED),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_BA = {
    to_SHIFT_JIS_E6_BA_offsets,
    to_EUC_JP_E6_BA_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_BB_infos[21] = {
     o2(0xDE,0xF1), o2(0xDE,0xEB), o2(0xCC,0xC7), o2(0xDE,0xE6),
     o2(0xBC,0xA2), o2(0xDE,0xFE), o2(0xB3,0xEA), o2(0xDE,0xE8),
     o2(0xDE,0xED), o2(0xDE,0xEE), o2(0xC2,0xEC), o2(0xC2,0xDA),
     o2(0xDE,0xF6), o2(0xDE,0xFC), o2(0xDE,0xFA), o2(0xC5,0xA9),
     o2(0xDF,0xA3), o2(0xDE,0xF7), o2(0xDE,0xF8), o2(0xDE,0xE0),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_BB = {
    to_SHIFT_JIS_E6_BB_offsets,
    to_EUC_JP_E6_BB_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_BC_infos[20] = {
     o2(0xB5,0xF9), o2(0xC9,0xBA), o2(0xBC,0xBF), o2(0xB9,0xF7),
     o2(0xCF,0xB3), o2(0xDE,0xF4), o2(0xDF,0xA2), o2(0xB1,0xE9),
     o2(0xC1,0xE6), o2(0xC7,0xF9), o2(0xB4,0xC1), o2(0xCE,0xFA),
     o2(0xCC,0xA1), o2(0xC4,0xD2), o2(0xDE,0xFB), o2(0xDE,0xFD),
     o2(0xC1,0xB2), o2(0xDF,0xA1), o2(0xDE,0xF9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_BC = {
    to_SHIFT_JIS_E6_BC_offsets,
    to_EUC_JP_E6_BC_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_BD_infos[18] = {
     o2(0xDE,0xF3), o2(0xB4,0xC3), o2(0xB7,0xE9), o2(0xDF,0xAF),
     o2(0xDF,0xAA), o2(0xC0,0xF8), o2(0xB3,0xE3), o2(0xBD,0xE1),
     o2(0xDF,0xB3), o2(0xDF,0xAC), o2(0xC4,0xAC), o2(0xDF,0xA9),
     o2(0xC4,0xD9), o2(0xDF,0xCC), o2(0xDF,0xA6), o2(0xDF,0xA5),
     o2(0xDF,0xAE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_BD = {
    to_SHIFT_JIS_E6_BD_offsets,
    to_EUC_JP_E6_BD_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_BE_infos[18] = {
     o2(0xDF,0xA8), o2(0xDF,0xA7), o2(0xDF,0xAD), o2(0xC0,0xA1),
     o2(0xDF,0xA4), o2(0xFA,0xEE), o2(0xDF,0xB0), o2(0xDF,0xB1),
     o2(0xB4,0xC2), o2(0xDF,0xB6), o2(0xDF,0xB5), o2(0xDF,0xB7),
     o2(0xDF,0xBA), o2(0xC5,0xC3), o2(0xDF,0xB4), o2(0xFA,0xEF),
     o2(0xDF,0xB8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_BE = {
    to_SHIFT_JIS_E6_BE_offsets,
    to_EUC_JP_E6_BE_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_BF_infos[24] = {
     o2(0xB7,0xE3), o2(0xC2,0xF9), o2(0xDF,0xB2), o2(0xC7,0xBB),
     o2(0xDF,0xB9), o2(0xDF,0xBE), o2(0xDF,0xBC), o2(0xDF,0xBF),
     o2(0xDF,0xC2), o2(0xDF,0xBB), o2(0xB9,0xEA), o2(0xC7,0xA8),
     o2(0xDE,0xB9), o2(0xCD,0xF4), o2(0xDF,0xBD), o2(0xDF,0xC1),
     o2(0xC2,0xF5), o2(0xDF,0xC0), o2(0xDF,0xAB), o2(0xFA,0xF0),
     o2(0xEF,0xE9), o2(0xDF,0xC5), o2(0xDF,0xC9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6_BF = {
    to_SHIFT_JIS_E6_BF_offsets,
    to_EUC_JP_E6_BF_infos
};

static const struct byte_lookup* const
to_EUC_JP_E6_infos[64] = {
     &to_EUC_JP_E6_80, &to_EUC_JP_E6_81, &to_EUC_JP_E6_82, &to_EUC_JP_E6_83,
     &to_EUC_JP_E6_84, &to_EUC_JP_E6_85, &to_EUC_JP_E6_86, &to_EUC_JP_E6_87,
     &to_EUC_JP_E6_88, &to_EUC_JP_E6_89, &to_EUC_JP_E6_8A, &to_EUC_JP_E6_8B,
     &to_EUC_JP_E6_8C, &to_EUC_JP_E6_8D, &to_EUC_JP_E6_8E, &to_EUC_JP_E6_8F,
     &to_EUC_JP_E6_90, &to_EUC_JP_E6_91, &to_EUC_JP_E6_92, &to_EUC_JP_E6_93,
     &to_EUC_JP_E6_94, &to_EUC_JP_E6_95, &to_EUC_JP_E6_96, &to_EUC_JP_E6_97,
     &to_EUC_JP_E6_98, &to_EUC_JP_E6_99, &to_EUC_JP_E6_9A, &to_EUC_JP_E6_9B,
     &to_EUC_JP_E6_9C, &to_EUC_JP_E6_9D, &to_EUC_JP_E6_9E, &to_EUC_JP_E6_9F,
     &to_EUC_JP_E6_A0, &to_EUC_JP_E6_A1, &to_EUC_JP_E6_A2, &to_EUC_JP_E6_A3,
     &to_EUC_JP_E6_A4, &to_EUC_JP_E6_A5, &to_EUC_JP_E6_A6, &to_EUC_JP_E6_A7,
     &to_EUC_JP_E6_A8, &to_EUC_JP_E6_A9, &to_EUC_JP_E6_AA, &to_EUC_JP_E6_AB,
     &to_EUC_JP_E6_AC, &to_EUC_JP_E6_AD, &to_EUC_JP_E6_AE, &to_EUC_JP_E6_AF,
     &to_EUC_JP_E6_B0, &to_EUC_JP_E6_B1, &to_EUC_JP_E6_B2, &to_EUC_JP_E6_B3,
     &to_EUC_JP_E6_B4, &to_EUC_JP_E6_B5, &to_EUC_JP_E6_B6, &to_EUC_JP_E6_B7,
     &to_EUC_JP_E6_B8, &to_EUC_JP_E6_B9, &to_EUC_JP_E6_BA, &to_EUC_JP_E6_BB,
     &to_EUC_JP_E6_BC, &to_EUC_JP_E6_BD, &to_EUC_JP_E6_BE, &to_EUC_JP_E6_BF,
};
static const BYTE_LOOKUP
to_EUC_JP_E6 = {
    to_SHIFT_JIS_E5_offsets,
    to_EUC_JP_E6_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_80_infos[22] = {
     o2(0xDF,0xC7), o2(0xFA,0xF1), o2(0xFA,0xF2), o2(0xDF,0xC3),
     o2(0xDF,0xC4), o2(0xDF,0xC8), o2(0xDF,0xC6), o2(0xC9,0xCE),
     o2(0xDF,0xCE), o2(0xDF,0xCB), o2(0xDF,0xCA), o2(0xDF,0xCD),
     o2(0xC6,0xD4), o2(0xDF,0xCF), o2(0xC3,0xF5), o2(0xC2,0xED),
     o2(0xFA,0xF3), o2(0xC0,0xA5), o2(0xDF,0xD0), o2(0xDF,0xD2),
     o2(0xDF,0xD1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_80 = {
    to_SHIFT_JIS_E7_80_offsets,
    to_EUC_JP_E7_80_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_81_infos[11] = {
     o2(0xDE,0xF5), o2(0xDF,0xD3), o2(0xC6,0xE7), o2(0xDF,0xD4),
     o2(0xB2,0xD0), o2(0xC5,0xF4), o2(0xB3,0xA5), o2(0xB5,0xE4),
     o2(0xBC,0xDE), o2(0xBA,0xD2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_81 = {
    to_SHIFT_JIS_E7_81_offsets,
    to_EUC_JP_E7_81_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_82_infos[17] = {
     o2(0xFA,0xF4), o2(0xCF,0xA7), o2(0xBF,0xE6), o2(0xB1,0xEA),
     o2(0xDF,0xD6), o2(0xDF,0xD5), o2(0xFA,0xF5), o2(0xDF,0xD9),
     o2(0xC3,0xBA), o2(0xDF,0xDC), o2(0xDF,0xD7), o2(0xDF,0xDB),
     o2(0xDF,0xDA), o2(0xC5,0xC0), o2(0xB0,0xD9), o2(0xF9,0xA7),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_82 = {
    to_SHIFT_JIS_E7_82_offsets,
    to_EUC_JP_E7_82_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_83_infos[10] = {
     o2(0xCE,0xF5), o2(0xDF,0xDE), o2(0xB1,0xA8), o2(0xDF,0xE0),
     o2(0xDF,0xDF), o2(0xDF,0xDD), o2(0xDF,0xD8), o2(0xCB,0xA3),
     o2(0xDF,0xE2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_83 = {
    to_SHIFT_JIS_E7_83_offsets,
    to_EUC_JP_E7_83_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_84_infos[12] = {
     o2(0xFA,0xF7), o2(0xDF,0xE1), o2(0xFA,0xF6), o2(0xB1,0xEB),
     o2(0xDF,0xE4), o2(0xCA,0xB2), o2(0xDF,0xE3), o2(0xCC,0xB5),
     o2(0xBE,0xC7), o2(0xC1,0xB3), o2(0xBE,0xC6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_84 = {
    to_SHIFT_JIS_E7_84_offsets,
    to_EUC_JP_E7_84_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_85_infos[19] = {
     o2(0xFA,0xF9), o2(0xFA,0xFA), o2(0xCE,0xFB), o2(0xDF,0xEA),
     o2(0xC0,0xF9), o2(0xDF,0xE6), o2(0xDF,0xEB), o2(0xB1,0xEC),
     o2(0xFA,0xF8), o2(0xDF,0xE9), o2(0xC7,0xE1), o2(0xDF,0xE5),
     o2(0xDF,0xE8), o2(0xBE,0xC8), o2(0xC8,0xD1), o2(0xDF,0xEC),
     o2(0xBC,0xD1), o2(0xC0,0xFA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_85 = {
    to_SHIFT_JIS_E7_85_offsets,
    to_EUC_JP_E7_85_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_86_infos[14] = {
     o2(0xDF,0xEF), o2(0xDF,0xE7), o2(0xB7,0xA7), o2(0xDF,0xED),
     o2(0xCD,0xD0), o2(0xDF,0xF0), o2(0xF4,0xA6), o2(0xBD,0xCF),
     o2(0xDF,0xF1), o2(0xDF,0xF2), o2(0xC7,0xAE), o2(0xDF,0xF4),
     o2(0xDF,0xF5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_86 = {
    to_SHIFT_JIS_E7_86_offsets,
    to_EUC_JP_E7_86_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_87_infos[25] = {
     o2(0xFA,0xFC), o2(0xC7,0xB3), o2(0xC5,0xF5), o2(0xDF,0xF7),
     o2(0xDF,0xF9), o2(0xCE,0xD5), o2(0xDF,0xF6), o2(0xDF,0xF8),
     o2(0xB1,0xED), o2(0xDF,0xF3), o2(0xD3,0xDB), o2(0xDF,0xFA),
     o2(0xC1,0xE7), o2(0xBB,0xB8), o2(0xDF,0xFC), o2(0xDF,0xFB),
     o2(0xBF,0xA4), o2(0xD2,0xD9), o2(0xDF,0xFD), o2(0xE0,0xA1),
     o2(0xDF,0xEE), o2(0xDF,0xFE), o2(0xFA,0xFD), o2(0xE0,0xA2),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_87 = {
    to_SHIFT_JIS_E7_87_offsets,
    to_EUC_JP_E7_87_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_88_infos[19] = {
     o2(0xC7,0xFA), o2(0xE0,0xA3), o2(0xE0,0xA4), o2(0xE0,0xA5),
     o2(0xE0,0xA6), o2(0xC4,0xDE), o2(0xE0,0xA8), o2(0xE0,0xA7),
     o2(0xE0,0xA9), o2(0xE0,0xAA), o2(0xBC,0xDF), o2(0xC9,0xE3),
     o2(0xCC,0xEC), o2(0xE0,0xAB), o2(0xE0,0xAC), o2(0xC1,0xD6),
     o2(0xBC,0xA4), o2(0xE0,0xAD),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_88 = {
    to_SHIFT_JIS_E7_88_offsets,
    to_EUC_JP_E7_88_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_89_infos[22] = {
     o2(0xE0,0xAE), o2(0xE0,0xAF), o2(0xCA,0xD2), o2(0xC8,0xC7),
     o2(0xE0,0xB0), o2(0xC7,0xD7), o2(0xC4,0xAD), o2(0xE0,0xB1),
     o2(0xB2,0xE7), o2(0xB5,0xED), o2(0xCC,0xC6), o2(0xCC,0xB6),
     o2(0xB2,0xB4), o2(0xCF,0xB4), o2(0xCB,0xD2), o2(0xCA,0xAA),
     o2(0xC0,0xB7), o2(0xE0,0xB2), o2(0xC6,0xC3), o2(0xB8,0xA3),
     o2(0xE0,0xB3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_89 = {
    to_SHIFT_JIS_E7_89_offsets,
    to_EUC_JP_E7_89_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_8A_infos[17] = {
     o2(0xBA,0xD4), o2(0xE0,0xB5), o2(0xE0,0xB4), o2(0xE0,0xB6),
     o2(0xE0,0xB7), o2(0xE0,0xB8), o2(0xB5,0xBE), o2(0xE0,0xB9),
     o2(0xE0,0xBA), o2(0xB8,0xA4), o2(0xC8,0xC8), o2(0xFA,0xFE),
     o2(0xE0,0xBC), o2(0xBE,0xF5), o2(0xE0,0xBB), o2(0xFB,0xA1),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_8A = {
    to_SHIFT_JIS_E7_8A_offsets,
    to_EUC_JP_E7_8A_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_8B_infos[22] = {
     o2(0xB6,0xB8), o2(0xE0,0xBD), o2(0xE0,0xBF), o2(0xE0,0xBE),
     o2(0xE0,0xC0), o2(0xB8,0xD1), o2(0xE0,0xC1), o2(0xB6,0xE9),
     o2(0xC1,0xC0), o2(0xB9,0xFD), o2(0xE0,0xC3), o2(0xE0,0xC4),
     o2(0xE0,0xC2), o2(0xBC,0xED), o2(0xC6,0xC8), o2(0xB6,0xB9),
     o2(0xE0,0xC6), o2(0xC3,0xAC), o2(0xE0,0xC5), o2(0xCF,0xB5),
     o2(0xC7,0xE2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_8B = {
    to_SHIFT_JIS_E7_8B_offsets,
    to_EUC_JP_E7_8B_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_8C_infos[20] = {
     o2(0xE0,0xC9), o2(0xE0,0xCB), o2(0xE0,0xC8), o2(0xCC,0xD4),
     o2(0xE0,0xCA), o2(0xE0,0xCC), o2(0xCE,0xC4), o2(0xFB,0xA2),
     o2(0xE0,0xD0), o2(0xE0,0xCF), o2(0xC3,0xF6), o2(0xC7,0xAD),
     o2(0xB8,0xA5), o2(0xE0,0xCE), o2(0xE0,0xCD), o2(0xCD,0xB1),
     o2(0xCD,0xB2), o2(0xE0,0xD1), o2(0xB1,0xEE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_8C = {
    to_SHIFT_JIS_E7_8C_offsets,
    to_EUC_JP_E7_8C_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_8D_infos[16] = {
     o2(0xB9,0xF6), o2(0xBB,0xE2), o2(0xE0,0xD2), o2(0xE0,0xD3),
     o2(0xE0,0xD5), o2(0xBD,0xC3), o2(0xE0,0xD7), o2(0xE0,0xD6),
     o2(0xE0,0xD8), o2(0xB3,0xCD), o2(0xE0,0xDA), o2(0xFB,0xA4),
     o2(0xE0,0xD9), o2(0xE0,0xDC), o2(0xE0,0xDB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_8D = {
    to_SHIFT_JIS_E7_8D_offsets,
    to_EUC_JP_E7_8D_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_8E_infos[11] = {
     o2(0xB8,0xBC), o2(0xCE,0xA8), o2(0xB6,0xCC), o2(0xB2,0xA6),
     o2(0xB6,0xEA), o2(0xB4,0xE1), o2(0xCE,0xE8), o2(0xE0,0xDE),
     o2(0xE0,0xE0), o2(0xFB,0xA5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_8E = {
    to_SHIFT_JIS_E7_8E_offsets,
    to_EUC_JP_E7_8E_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_8F_infos[21] = {
     o2(0xE0,0xE1), o2(0xB2,0xD1), o2(0xE0,0xDD), o2(0xFB,0xA6),
     o2(0xBB,0xB9), o2(0xC4,0xC1), o2(0xE0,0xDF), o2(0xFB,0xA9),
     o2(0xFB,0xA7), o2(0xE0,0xE4), o2(0xBC,0xEE), o2(0xFB,0xA8),
     o2(0xE0,0xE2), o2(0xB7,0xBE), o2(0xC8,0xC9), o2(0xE0,0xE3),
     o2(0xE0,0xFE), o2(0xFB,0xAB), o2(0xE0,0xE9), o2(0xB8,0xBD),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_8F = {
    to_SHIFT_JIS_E7_8F_offsets,
    to_EUC_JP_E7_8F_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_90_infos[19] = {
     o2(0xB5,0xE5), o2(0xE0,0xE6), o2(0xCD,0xFD), o2(0xFB,0xAA),
     o2(0xCE,0xB0), o2(0xC2,0xF6), o2(0xE0,0xE8), o2(0xFB,0xAC),
     o2(0xFB,0xAE), o2(0xFB,0xAD), o2(0xFB,0xAF), o2(0xE0,0xEA),
     o2(0xCE,0xD6), o2(0xB6,0xD7), o2(0xC8,0xFC), o2(0xC7,0xCA),
     o2(0xE0,0xEB), o2(0xE0,0xED),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_90 = {
    to_SHIFT_JIS_E7_90_offsets,
    to_EUC_JP_E7_90_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_91_infos[20] = {
     o2(0xE0,0xF0), o2(0xE0,0xEC), o2(0xE0,0xEF), o2(0xB8,0xEA),
     o2(0xB1,0xCD), o2(0xE0,0xF1), o2(0xBF,0xF0), o2(0xE0,0xEE),
     o2(0xCE,0xDC), o2(0xFB,0xB0), o2(0xE0,0xF4), o2(0xF4,0xA4),
     o2(0xE0,0xF2), o2(0xE0,0xF5), o2(0xE0,0xE7), o2(0xE0,0xF3),
     o2(0xBA,0xBC), o2(0xE0,0xF6), o2(0xE0,0xF7),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_91 = {
    to_SHIFT_JIS_E7_91_offsets,
    to_EUC_JP_E7_91_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_92_infos[10] = {
     o2(0xCD,0xFE), o2(0xFB,0xB1), o2(0xE0,0xF8), o2(0xE0,0xF9),
     o2(0xFB,0xB2), o2(0xE0,0xE5), o2(0xE0,0xFA), o2(0xB4,0xC4),
     o2(0xBC,0xA5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_92 = {
    to_SHIFT_JIS_E7_92_offsets,
    to_EUC_JP_E7_92_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_93_infos[18] = {
     o2(0xE0,0xFB), o2(0xE0,0xFC), o2(0xE0,0xFD), o2(0xB1,0xBB),
     o2(0xE1,0xA1), o2(0xC9,0xBB), o2(0xE1,0xA2), o2(0xB4,0xA4),
     o2(0xE1,0xA3), o2(0xE1,0xA4), o2(0xE1,0xA5), o2(0xE1,0xA7),
     o2(0xE1,0xA8), o2(0xE1,0xA6), o2(0xC9,0xD3), o2(0xE1,0xAA),
     o2(0xE1,0xA9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_93 = {
    to_SHIFT_JIS_E7_93_offsets,
    to_EUC_JP_E7_93_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_94_infos[32] = {
     o2(0xFB,0xB3), o2(0xE1,0xAC), o2(0xE1,0xAB), o2(0xE1,0xAD),
     o2(0xE1,0xAE), o2(0xE1,0xB0), o2(0xE1,0xAF), o2(0xB9,0xF9),
     o2(0xE1,0xB2), o2(0xE1,0xB1), o2(0xB4,0xC5), o2(0xBF,0xD3),
     o2(0xC5,0xBC), o2(0xE1,0xB3), o2(0xC0,0xB8), o2(0xBB,0xBA),
     o2(0xB1,0xF9), o2(0xE1,0xB4), o2(0xCD,0xD1), o2(0xCA,0xE3),
     o2(0xE1,0xB5), o2(0xF9,0xEC), o2(0xC5,0xC4), o2(0xCD,0xB3),
     o2(0xB9,0xC3), o2(0xBF,0xBD), o2(0xC3,0xCB), o2(0xD2,0xB4),
     o2(0xC4,0xAE), o2(0xB2,0xE8), o2(0xE1,0xB6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_94 = {
    to_SHIFT_JIS_E7_94_offsets,
    to_EUC_JP_E7_94_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_95_infos[34] = {
     o2(0xE1,0xB7), o2(0xE1,0xBC), o2(0xE1,0xBA), o2(0xE1,0xB9),
     o2(0xDA,0xC2), o2(0xB3,0xA6), o2(0xE1,0xB8), o2(0xB0,0xDA),
     o2(0xC8,0xAA), o2(0xC8,0xCA), o2(0xCE,0xB1), o2(0xE1,0xBD),
     o2(0xE1,0xBB), o2(0xC3,0xDC), o2(0xC0,0xA6), o2(0xC8,0xAB),
     o2(0xC9,0xAD), o2(0xE1,0xBF), o2(0xCE,0xAC), o2(0xB7,0xCD),
     o2(0xE1,0xC0), o2(0xE1,0xBE), o2(0xC8,0xD6), o2(0xE1,0xC1),
     o2(0xE1,0xC2), o2(0xFB,0xB4), o2(0xB0,0xDB), o2(0xBE,0xF6),
     o2(0xE1,0xC7), o2(0xE1,0xC4), o2(0xC6,0xED), o2(0xE1,0xC3),
     o2(0xB5,0xA6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_95 = {
    to_SHIFT_JIS_E7_95_offsets,
    to_EUC_JP_E7_95_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_96_infos[25] = {
     o2(0xE1,0xCA), o2(0xE1,0xC5), o2(0xE1,0xC6), o2(0xE1,0xC9),
     o2(0xE1,0xC8), o2(0xC9,0xA5), o2(0xC1,0xC2), o2(0xC1,0xC1),
     o2(0xB5,0xBF), o2(0xE1,0xCB), o2(0xE1,0xCC), o2(0xE1,0xCD),
     o2(0xE1,0xCF), o2(0xE1,0xCE), o2(0xB1,0xD6), o2(0xE1,0xD7),
     o2(0xC8,0xE8), o2(0xE1,0xD1), o2(0xE1,0xD3), o2(0xE1,0xD5),
     o2(0xBF,0xBE), o2(0xE1,0xD6), o2(0xE1,0xD4), o2(0xBC,0xC0),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_96 = {
    to_SHIFT_JIS_E7_96_offsets,
    to_EUC_JP_E7_96_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_97_infos[25] = {
     o2(0xE1,0xD0), o2(0xE1,0xD2), o2(0xC9,0xC2), o2(0xBE,0xC9),
     o2(0xE1,0xD9), o2(0xE1,0xD8), o2(0xE1,0xDA), o2(0xBC,0xA6),
     o2(0xBA,0xAF), o2(0xC5,0xF7), o2(0xE1,0xDB), o2(0xC4,0xCB),
     o2(0xE1,0xDD), o2(0xCE,0xA1), o2(0xE1,0xDC), o2(0xC1,0xE9),
     o2(0xE1,0xE2), o2(0xE1,0xE4), o2(0xE1,0xE5), o2(0xC3,0xD4),
     o2(0xE1,0xE3), o2(0xE1,0xE0), o2(0xE1,0xDE), o2(0xE1,0xDF),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_97 = {
    to_SHIFT_JIS_E7_97_offsets,
    to_EUC_JP_E7_97_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_98_infos[14] = {
     o2(0xE1,0xE1), o2(0xE1,0xE8), o2(0xE1,0xE6), o2(0xE1,0xE7),
     o2(0xE1,0xE9), o2(0xE1,0xEB), o2(0xE1,0xEC), o2(0xE1,0xED),
     o2(0xE1,0xEE), o2(0xE1,0xEA), o2(0xE1,0xF0), o2(0xE1,0xEF),
     o2(0xE1,0xF1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_98 = {
    to_SHIFT_JIS_E7_98_offsets,
    to_EUC_JP_E7_98_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_99_infos[26] = {
     o2(0xCE,0xC5), o2(0xE1,0xF4), o2(0xE1,0xF2), o2(0xE1,0xF3),
     o2(0xB4,0xE2), o2(0xCC,0xFE), o2(0xCA,0xCA), o2(0xE1,0xF6),
     o2(0xE1,0xF5), o2(0xE1,0xF7), o2(0xE1,0xF8), o2(0xE1,0xFC),
     o2(0xE1,0xF9), o2(0xE1,0xFA), o2(0xE1,0xFB), o2(0xE1,0xFD),
     o2(0xE1,0xFE), o2(0xE2,0xA1), o2(0xE2,0xA2), o2(0xE2,0xA3),
     o2(0xC8,0xAF), o2(0xC5,0xD0), o2(0xE2,0xA4), o2(0xC7,0xF2),
     o2(0xC9,0xB4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_99 = {
    to_SHIFT_JIS_E7_99_offsets,
    to_EUC_JP_E7_99_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_9A_infos[27] = {
     o2(0xE2,0xA5), o2(0xFB,0xB5), o2(0xE2,0xA6), o2(0xC5,0xAA),
     o2(0xB3,0xA7), o2(0xB9,0xC4), o2(0xE2,0xA7), o2(0xE2,0xA8),
     o2(0xE2,0xA9), o2(0xBB,0xA9), o2(0xE2,0xAB), o2(0xE2,0xAA),
     o2(0xE2,0xAC), o2(0xE2,0xAD), o2(0xFB,0xB8), o2(0xFB,0xB6),
     o2(0xFB,0xB7), o2(0xFB,0xB9), o2(0xC8,0xE9), o2(0xE2,0xAE),
     o2(0xE2,0xAF), o2(0xF3,0xE9), o2(0xE2,0xB0), o2(0xE2,0xB1),
     o2(0xE2,0xB2), o2(0xBB,0xAE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_9A = {
    to_SHIFT_JIS_E7_9A_offsets,
    to_EUC_JP_E7_9A_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_9B_infos[26] = {
     o2(0xE2,0xB3), o2(0xC7,0xD6), o2(0xCB,0xDF), o2(0xB1,0xCE),
     o2(0xB1,0xD7), o2(0xE2,0xB4), o2(0xE2,0xB6), o2(0xE2,0xB5),
     o2(0xC5,0xF0), o2(0xC0,0xB9), o2(0xDD,0xB9), o2(0xE2,0xB7),
     o2(0xCC,0xC1), o2(0xE2,0xB8), o2(0xB4,0xC6), o2(0xC8,0xD7),
     o2(0xE2,0xB9), o2(0xE2,0xBA), o2(0xE2,0xBB), o2(0xCC,0xDC),
     o2(0xCC,0xD5), o2(0xC4,0xBE), o2(0xC1,0xEA), o2(0xE2,0xBD),
     o2(0xBD,0xE2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_9B = {
    to_SHIFT_JIS_E7_9B_offsets,
    to_EUC_JP_E7_9B_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_9C_infos[20] = {
     o2(0xBE,0xCA), o2(0xE2,0xC0), o2(0xE2,0xBF), o2(0xE2,0xBE),
     o2(0xC8,0xFD), o2(0xB4,0xC7), o2(0xB8,0xA9), o2(0xE2,0xC6),
     o2(0xE2,0xC3), o2(0xBF,0xBF), o2(0xCC,0xB2), o2(0xE2,0xC2),
     o2(0xE2,0xC4), o2(0xE2,0xC5), o2(0xE2,0xC1), o2(0xE2,0xC7),
     o2(0xE2,0xC8), o2(0xC4,0xAF), o2(0xB4,0xE3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_9C = {
    to_SHIFT_JIS_E7_9C_offsets,
    to_EUC_JP_E7_9C_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_9D_infos[15] = {
     o2(0xC3,0xE5), o2(0xFB,0xBB), o2(0xE2,0xC9), o2(0xE2,0xCA),
     o2(0xE2,0xCD), o2(0xBF,0xE7), o2(0xC6,0xC4), o2(0xE2,0xCE),
     o2(0xCB,0xD3), o2(0xE2,0xCB), o2(0xE2,0xCC), o2(0xE2,0xD1),
     o2(0xE2,0xD0), o2(0xE2,0xCF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_9D = {
    to_SHIFT_JIS_E7_9D_offsets,
    to_EUC_JP_E7_9D_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_9E_infos[17] = {
     o2(0xE2,0xD3), o2(0xE2,0xD2), o2(0xE2,0xD4), o2(0xE2,0xD6),
     o2(0xE2,0xD5), o2(0xCA,0xCD), o2(0xBD,0xD6), o2(0xCE,0xC6),
     o2(0xE2,0xD7), o2(0xC6,0xB7), o2(0xE2,0xD8), o2(0xE2,0xD9),
     o2(0xE2,0xDD), o2(0xE2,0xDB), o2(0xE2,0xDC), o2(0xE2,0xDA),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_9E = {
    to_SHIFT_JIS_E7_9E_offsets,
    to_EUC_JP_E7_9E_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_9F_infos[17] = {
     o2(0xE2,0xDE), o2(0xE2,0xDF), o2(0xE2,0xE0), o2(0xE2,0xE1),
     o2(0xCC,0xB7), o2(0xE2,0xE2), o2(0xCC,0xF0), o2(0xE2,0xE3),
     o2(0xC3,0xCE), o2(0xC7,0xEA), o2(0xB6,0xEB), o2(0xC3,0xBB),
     o2(0xE2,0xE4), o2(0xB6,0xBA), o2(0xC0,0xD0), o2(0xE2,0xE5),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_9F = {
    to_SHIFT_JIS_E7_9F_offsets,
    to_EUC_JP_E7_9F_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_A0_infos[15] = {
     o2(0xBA,0xBD), o2(0xE2,0xE6), o2(0xE2,0xE7), o2(0xB8,0xA6),
     o2(0xBA,0xD5), o2(0xE2,0xE9), o2(0xFB,0xBD), o2(0xC5,0xD6),
     o2(0xBA,0xD6), o2(0xB5,0xCE), o2(0xCB,0xA4), o2(0xC7,0xCB),
     o2(0xC5,0xD7), o2(0xB9,0xDC),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_A0 = {
    to_SHIFT_JIS_E7_A0_offsets,
    to_EUC_JP_E7_A0_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_A1_infos[12] = {
     o2(0xE2,0xEB), o2(0xFB,0xBE), o2(0xBE,0xCB), o2(0xFB,0xBF),
     o2(0xCE,0xB2), o2(0xB9,0xC5), o2(0xB8,0xA7), o2(0xC8,0xA3),
     o2(0xE2,0xED), o2(0xFB,0xC0), o2(0xE2,0xEF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_A1 = {
    to_SHIFT_JIS_E7_A1_offsets,
    to_EUC_JP_E7_A1_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_A2_infos[21] = {
     o2(0xB8,0xEB), o2(0xE2,0xEE), o2(0xC4,0xF6), o2(0xE2,0xF1),
     o2(0xB3,0xB7), o2(0xE2,0xEC), o2(0xC8,0xEA), o2(0xB1,0xB0),
     o2(0xBA,0xEC), o2(0xCF,0xD2), o2(0xE2,0xF0), o2(0xE2,0xF2),
     o2(0xCA,0xCB), o2(0xC0,0xD9), o2(0xE2,0xF4), o2(0xE2,0xF5),
     o2(0xE2,0xF3), o2(0xB3,0xCE), o2(0xE2,0xFB), o2(0xE2,0xFA),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_A2 = {
    to_SHIFT_JIS_E7_A2_offsets,
    to_EUC_JP_E7_A2_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_A3_infos[16] = {
     o2(0xBC,0xA7), o2(0xE2,0xFC), o2(0xE2,0xF7), o2(0xE2,0xFD),
     o2(0xE2,0xF8), o2(0xC8,0xD8), o2(0xE2,0xF6), o2(0xE2,0xF9),
     o2(0xE3,0xA2), o2(0xE3,0xA1), o2(0xCB,0xE1), o2(0xE2,0xFE),
     o2(0xB0,0xEB), o2(0xE3,0xA4), o2(0xE3,0xA3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_A3 = {
    to_SHIFT_JIS_E7_A3_offsets,
    to_EUC_JP_E7_A3_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_A4_infos[15] = {
     o2(0xBE,0xCC), o2(0xE3,0xA5), o2(0xC1,0xC3), o2(0xE3,0xA7),
     o2(0xE3,0xA6), o2(0xE3,0xA8), o2(0xE2,0xE8), o2(0xE2,0xEA),
     o2(0xE3,0xAA), o2(0xE3,0xA9), o2(0xFB,0xC1), o2(0xBC,0xA8),
     o2(0xCE,0xE9), o2(0xBC,0xD2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_A4 = {
    to_SHIFT_JIS_E7_A4_offsets,
    to_EUC_JP_E7_A4_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_A5_infos[23] = {
     o2(0xE3,0xAB), o2(0xB7,0xB7), o2(0xB5,0xC0), o2(0xB5,0xA7),
     o2(0xBB,0xE3), o2(0xCD,0xB4), o2(0xE3,0xB1), o2(0xE3,0xB0),
     o2(0xC1,0xC4), o2(0xE3,0xAD), o2(0xE3,0xAF), o2(0xBD,0xCB),
     o2(0xBF,0xC0), o2(0xE3,0xAE), o2(0xE3,0xAC), o2(0xC7,0xAA),
     o2(0xBE,0xCD), o2(0xC9,0xBC), o2(0xBA,0xD7), o2(0xC5,0xF8),
     o2(0xE3,0xB2), o2(0xE3,0xB3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_A5 = {
    to_SHIFT_JIS_E7_A5_offsets,
    to_EUC_JP_E7_A5_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_A6_infos[23] = {
     o2(0xE3,0xC9), o2(0xB6,0xD8), o2(0xCF,0xBD), o2(0xC1,0xB5),
     o2(0xE3,0xB4), o2(0xB2,0xD2), o2(0xC4,0xF7), o2(0xCA,0xA1),
     o2(0xFB,0xC5), o2(0xFB,0xC7), o2(0xE3,0xB5), o2(0xB5,0xFA),
     o2(0xE3,0xB6), o2(0xE3,0xB8), o2(0xE3,0xB9), o2(0xC7,0xA9),
     o2(0xE3,0xBA), o2(0xE3,0xBB), o2(0xE3,0xBC), o2(0xB6,0xD9),
     o2(0xB2,0xD3), o2(0xC6,0xC5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_A6 = {
    to_SHIFT_JIS_E7_A6_offsets,
    to_EUC_JP_E7_A6_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_A7_infos[19] = {
     o2(0xBD,0xA8), o2(0xBB,0xE4), o2(0xE3,0xBD), o2(0xBD,0xA9),
     o2(0xB2,0xCA), o2(0xC9,0xC3), o2(0xE3,0xBE), o2(0xC8,0xEB),
     o2(0xC1,0xC5), o2(0xE3,0xC1), o2(0xE3,0xC2), o2(0xC7,0xE9),
     o2(0xBF,0xC1), o2(0xE3,0xBF), o2(0xC3,0xE1), o2(0xE3,0xC0),
     o2(0xBE,0xCE), o2(0xB0,0xDC),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_A7 = {
    to_SHIFT_JIS_E7_A7_offsets,
    to_EUC_JP_E7_A7_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_A8_infos[23] = {
     o2(0xB5,0xA9), o2(0xE3,0xC3), o2(0xC4,0xF8), o2(0xE3,0xC4),
     o2(0xC0,0xC7), o2(0xCC,0xAD), o2(0xC9,0xA3), o2(0xE3,0xC5),
     o2(0xE3,0xC6), o2(0xC3,0xD5), o2(0xCE,0xC7), o2(0xE3,0xC8),
     o2(0xE3,0xC7), o2(0xBC,0xEF), o2(0xE3,0xCA), o2(0xB0,0xF0),
     o2(0xE3,0xCD), o2(0xE3,0xCB), o2(0xB2,0xD4), o2(0xB7,0xCE),
     o2(0xE3,0xCC), o2(0xB9,0xC6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_A8 = {
    to_SHIFT_JIS_E7_A8_offsets,
    to_EUC_JP_E7_A8_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_A9_infos[23] = {
     o2(0xB9,0xF2), o2(0xCA,0xE6), o2(0xE3,0xCE), o2(0xCB,0xD4),
     o2(0xE3,0xD0), o2(0xC0,0xD1), o2(0xB1,0xCF), o2(0xB2,0xBA),
     o2(0xB0,0xAC), o2(0xE3,0xCF), o2(0xE3,0xD1), o2(0xE3,0xD2),
     o2(0xBE,0xF7), o2(0xE3,0xD3), o2(0xB3,0xCF), o2(0xE3,0xD5),
     o2(0xB7,0xEA), o2(0xB5,0xE6), o2(0xE3,0xD6), o2(0xB6,0xF5),
     o2(0xE3,0xD7), o2(0xC0,0xFC),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_A9 = {
    to_SHIFT_JIS_E7_A9_offsets,
    to_EUC_JP_E7_A9_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_AA_infos[20] = {
     o2(0xC6,0xCD), o2(0xC0,0xE0), o2(0xBA,0xF5), o2(0xE3,0xD8),
     o2(0xC3,0xE2), o2(0xC1,0xEB), o2(0xE3,0xDA), o2(0xE3,0xDC),
     o2(0xE3,0xD9), o2(0xE3,0xDB), o2(0xB7,0xA2), o2(0xE3,0xDD),
     o2(0xB7,0xA6), o2(0xB5,0xE7), o2(0xCD,0xD2), o2(0xE3,0xDF),
     o2(0xE3,0xE0), o2(0xB1,0xAE), o2(0xE3,0xE3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_AA = {
    to_SHIFT_JIS_E7_AA_offsets,
    to_EUC_JP_E7_AA_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_AB_infos[36] = {
     o2(0xB3,0xF6), o2(0xE3,0xE2), o2(0xE3,0xE1), o2(0xE3,0xE5),
     o2(0xE3,0xDE), o2(0xE3,0xE6), o2(0xCE,0xA9), o2(0xE3,0xE7),
     o2(0xE3,0xE8), o2(0xFB,0xC8), o2(0xD4,0xF4), o2(0xE3,0xEA),
     o2(0xE3,0xE9), o2(0xE3,0xEB), o2(0xE3,0xEC), o2(0xCE,0xB5),
     o2(0xE3,0xED), o2(0xF0,0xEF), o2(0xBE,0xCF), o2(0xE3,0xEE),
     o2(0xE3,0xEF), o2(0xBD,0xD7), o2(0xC6,0xB8), o2(0xE3,0xF0),
     o2(0xFB,0xC9), o2(0xC3,0xA8), o2(0xFB,0xCB), o2(0xE3,0xF1),
     o2(0xC3,0xBC), o2(0xE3,0xF2), o2(0xB6,0xA5), o2(0xD1,0xBF),
     o2(0xC3,0xDD), o2(0xBC,0xB3), o2(0xB4,0xC8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_AB = {
    to_SHIFT_JIS_E7_AB_offsets,
    to_EUC_JP_E7_AB_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_AC_infos[22] = {
     o2(0xE3,0xF3), o2(0xE4,0xA2), o2(0xE3,0xF6), o2(0xB5,0xE8),
     o2(0xE3,0xF5), o2(0xE4,0xA4), o2(0xE3,0xF4), o2(0xBE,0xD0),
     o2(0xE3,0xF8), o2(0xE3,0xF9), o2(0xC5,0xAB), o2(0xE3,0xFA),
     o2(0xB3,0xDE), o2(0xBF,0xDA), o2(0xC9,0xE4), o2(0xE3,0xFC),
     o2(0xC2,0xE8), o2(0xE3,0xF7), o2(0xE3,0xFB), o2(0xE3,0xFD),
     o2(0xBA,0xFB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_AC = {
    to_SHIFT_JIS_E7_AC_offsets,
    to_EUC_JP_E7_AC_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_AD_infos[24] = {
     o2(0xE4,0xA6), o2(0xC9,0xAE), o2(0xC8,0xA6), o2(0xC5,0xF9),
     o2(0xB6,0xDA), o2(0xE4,0xA5), o2(0xE4,0xA3), o2(0xC8,0xB5),
     o2(0xE3,0xFE), o2(0xC3,0xDE), o2(0xC5,0xFB), o2(0xC5,0xFA),
     o2(0xBA,0xF6), o2(0xE4,0xB8), o2(0xE4,0xA8), o2(0xE4,0xAA),
     o2(0xE4,0xAD), o2(0xE4,0xAE), o2(0xE4,0xAB), o2(0xE4,0xAC),
     o2(0xE4,0xA9), o2(0xE4,0xA7), o2(0xE4,0xA1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_AD = {
    to_SHIFT_JIS_E7_AD_offsets,
    to_EUC_JP_E7_AD_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_AE_infos[23] = {
     o2(0xCA,0xCF), o2(0xB2,0xD5), o2(0xE4,0xB5), o2(0xE4,0xB2),
     o2(0xE4,0xB7), o2(0xE4,0xB6), o2(0xC7,0xF3), o2(0xCC,0xA7),
     o2(0xBB,0xBB), o2(0xE4,0xB0), o2(0xE4,0xB9), o2(0xE4,0xB4),
     o2(0xE4,0xB3), o2(0xE4,0xAF), o2(0xFB,0xCC), o2(0xE4,0xB1),
     o2(0xB4,0xC9), o2(0xC3,0xBD), o2(0xC0,0xFD), o2(0xC8,0xA2),
     o2(0xE4,0xBE), o2(0xC8,0xA4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_AE = {
    to_SHIFT_JIS_E7_AE_offsets,
    to_EUC_JP_E7_AE_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_AF_infos[20] = {
     o2(0xC0,0xE1), o2(0xE4,0xBB), o2(0xC8,0xCF), o2(0xE4,0xBF),
     o2(0xCA,0xD3), o2(0xC3,0xDB), o2(0xE4,0xBA), o2(0xE4,0xBC),
     o2(0xE4,0xBD), o2(0xE4,0xC0), o2(0xBC,0xC4), o2(0xC6,0xC6),
     o2(0xE4,0xC5), o2(0xE4,0xC4), o2(0xE4,0xC1), o2(0xCF,0xB6),
     o2(0xE4,0xCA), o2(0xE4,0xCE), o2(0xE4,0xCB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_AF = {
    to_SHIFT_JIS_E7_AF_offsets,
    to_EUC_JP_E7_AF_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_B0_infos[20] = {
     o2(0xE4,0xC7), o2(0xE4,0xC8), o2(0xE4,0xCD), o2(0xE4,0xC2),
     o2(0xD2,0xD5), o2(0xE4,0xC9), o2(0xE4,0xC3), o2(0xE4,0xCC),
     o2(0xE4,0xD2), o2(0xB4,0xCA), o2(0xE4,0xCF), o2(0xE4,0xD0),
     o2(0xE4,0xD1), o2(0xE4,0xD4), o2(0xE4,0xD3), o2(0xC8,0xF6),
     o2(0xE4,0xD5), o2(0xCE,0xFC), o2(0xCA,0xED),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_B0 = {
    to_SHIFT_JIS_E7_B0_offsets,
    to_EUC_JP_E7_B0_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_B1_infos[18] = {
     o2(0xE4,0xDA), o2(0xE4,0xD7), o2(0xE4,0xD6), o2(0xC0,0xD2),
     o2(0xE4,0xD9), o2(0xE4,0xDB), o2(0xE4,0xD8), o2(0xE4,0xDF),
     o2(0xE4,0xDC), o2(0xE4,0xDD), o2(0xE4,0xC6), o2(0xE4,0xDE),
     o2(0xE4,0xE0), o2(0xE4,0xE1), o2(0xCA,0xC6), o2(0xE4,0xE2),
     o2(0xCC,0xE2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_B1 = {
    to_SHIFT_JIS_E7_B1_offsets,
    to_EUC_JP_E7_B1_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_B2_infos[29] = {
     o2(0xB6,0xCE), o2(0xB7,0xA9), o2(0xE4,0xE3), o2(0xCA,0xB4),
     o2(0xBF,0xE8), o2(0xCC,0xB0), o2(0xE4,0xE4), o2(0xCE,0xB3),
     o2(0xC7,0xF4), o2(0xC1,0xC6), o2(0xC7,0xB4), o2(0xBD,0xCD),
     o2(0xB0,0xC0), o2(0xE4,0xE9), o2(0xE4,0xE7), o2(0xE4,0xE5),
     o2(0xB4,0xA1), o2(0xBE,0xD1), o2(0xE4,0xEA), o2(0xE4,0xE8),
     o2(0xE4,0xE6), o2(0xE4,0xEE), o2(0xE4,0xED), o2(0xE4,0xEC),
     o2(0xE4,0xEB), o2(0xE4,0xEF), o2(0xE4,0xF0), o2(0xC0,0xBA),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_B2 = {
    to_SHIFT_JIS_E7_B2_offsets,
    to_EUC_JP_E7_B2_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_B3_infos[23] = {
     o2(0xE4,0xF1), o2(0xE4,0xF3), o2(0xE4,0xF2), o2(0xB8,0xD2),
     o2(0xC1,0xB8), o2(0xE4,0xF5), o2(0xC5,0xFC), o2(0xE4,0xF4),
     o2(0xE4,0xF6), o2(0xCA,0xB5), o2(0xC1,0xEC), o2(0xB9,0xC7),
     o2(0xE4,0xF7), o2(0xCE,0xC8), o2(0xE4,0xF9), o2(0xE4,0xFA),
     o2(0xE4,0xFB), o2(0xE4,0xFC), o2(0xBB,0xE5), o2(0xE4,0xFD),
     o2(0xB7,0xCF), o2(0xB5,0xEA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_B3 = {
    to_SHIFT_JIS_E7_B3_offsets,
    to_EUC_JP_E7_B3_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_B4_infos[32] = {
     o2(0xB5,0xAA), o2(0xE5,0xA1), o2(0xCC,0xF3), o2(0xB9,0xC8),
     o2(0xE4,0xFE), o2(0xE5,0xA4), o2(0xCC,0xE6), o2(0xC7,0xBC),
     o2(0xC9,0xB3), o2(0xBD,0xE3), o2(0xE5,0xA3), o2(0xBC,0xD3),
     o2(0xB9,0xC9), o2(0xBB,0xE6), o2(0xB5,0xE9), o2(0xCA,0xB6),
     o2(0xE5,0xA2), o2(0xC1,0xC7), o2(0xCB,0xC2), o2(0xBA,0xF7),
     o2(0xBB,0xE7), o2(0xC4,0xDD), o2(0xE5,0xA7), o2(0xCE,0xDF),
     o2(0xBA,0xD9), o2(0xE5,0xA8), o2(0xBF,0xC2), o2(0xE5,0xAA),
     o2(0xBE,0xD2), o2(0xBA,0xB0), o2(0xE5,0xA9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_B4 = {
    to_SHIFT_JIS_E7_B4_offsets,
    to_EUC_JP_E7_B4_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_B5_infos[29] = {
     o2(0xBD,0xAA), o2(0xB8,0xBE), o2(0xC1,0xC8), o2(0xE5,0xA5),
     o2(0xE5,0xAB), o2(0xFB,0xCE), o2(0xE5,0xA6), o2(0xB7,0xD0),
     o2(0xE5,0xAE), o2(0xE5,0xB2), o2(0xB7,0xEB), o2(0xE5,0xAD),
     o2(0xE5,0xB6), o2(0xFB,0xCF), o2(0xB9,0xCA), o2(0xCD,0xED),
     o2(0xB0,0xBC), o2(0xE5,0xB3), o2(0xB5,0xEB), o2(0xE5,0xB0),
     o2(0xE5,0xB1), o2(0xC5,0xFD), o2(0xE5,0xAF), o2(0xE5,0xAC),
     o2(0xB3,0xA8), o2(0xC0,0xE4), o2(0xB8,0xA8), o2(0xE5,0xB8),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_B5 = {
    to_SHIFT_JIS_E7_B5_offsets,
    to_EUC_JP_E7_B5_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_B6_infos[29] = {
     o2(0xE5,0xB5), o2(0xE5,0xB7), o2(0xE5,0xB4), o2(0xB7,0xD1),
     o2(0xC2,0xB3), o2(0xE5,0xB9), o2(0xC1,0xEE), o2(0xE5,0xC6),
     o2(0xFB,0xD1), o2(0xE5,0xC2), o2(0xE5,0xBC), o2(0xE5,0xC0),
     o2(0xBC,0xFA), o2(0xB0,0xDD), o2(0xE5,0xBB), o2(0xE5,0xC3),
     o2(0xE5,0xC7), o2(0xB9,0xCB), o2(0xCC,0xD6), o2(0xC4,0xD6),
     o2(0xE5,0xBD), o2(0xFB,0xD0), o2(0xE5,0xC5), o2(0xE5,0xBA),
     o2(0xC3,0xBE), o2(0xE5,0xBF), o2(0xB0,0xBD), o2(0xCC,0xCA),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_B6 = {
    to_SHIFT_JIS_E7_B6_offsets,
    to_EUC_JP_E7_B6_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_B7_infos[24] = {
     o2(0xE5,0xBE), o2(0xB6,0xDB), o2(0xC8,0xEC), o2(0xC1,0xED),
     o2(0xCE,0xD0), o2(0xBD,0xEF), o2(0xE5,0xEE), o2(0xFB,0xD2),
     o2(0xE5,0xC8), o2(0xC0,0xFE), o2(0xE5,0xC4), o2(0xE5,0xC9),
     o2(0xE5,0xCB), o2(0xC4,0xF9), o2(0xE5,0xCE), o2(0xE5,0xCA),
     o2(0xCA,0xD4), o2(0xB4,0xCB), o2(0xCC,0xCB), o2(0xB0,0xDE),
     o2(0xE5,0xCD), o2(0xCE,0xFD), o2(0xE5,0xCC),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_B7 = {
    to_SHIFT_JIS_E7_B7_offsets,
    to_EUC_JP_E7_B7_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_B8_infos[26] = {
     o2(0xB1,0xEF), o2(0xC6,0xEC), o2(0xE5,0xCF), o2(0xE5,0xD6),
     o2(0xE5,0xD0), o2(0xE5,0xD7), o2(0xE5,0xD3), o2(0xC7,0xFB),
     o2(0xBC,0xCA), o2(0xE5,0xD5), o2(0xE5,0xD2), o2(0xE5,0xD8),
     o2(0xE5,0xD1), o2(0xBD,0xC4), o2(0xCB,0xA5), o2(0xBD,0xCC),
     o2(0xE5,0xD4), o2(0xE5,0xE0), o2(0xE5,0xDC), o2(0xE5,0xDF),
     o2(0xE5,0xDD), o2(0xE5,0xE1), o2(0xE5,0xDB), o2(0xE5,0xC1),
     o2(0xC0,0xD3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_B8 = {
    to_SHIFT_JIS_E7_B8_offsets,
    to_EUC_JP_E7_B8_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_B9_infos[26] = {
     o2(0xC8,0xCB), o2(0xE5,0xDE), o2(0xE5,0xD9), o2(0xC1,0xA1),
     o2(0xB7,0xD2), o2(0xBD,0xAB), o2(0xFB,0xD3), o2(0xBF,0xA5),
     o2(0xC1,0xB6), o2(0xE5,0xE4), o2(0xE5,0xE6), o2(0xE5,0xE7),
     o2(0xE5,0xE3), o2(0xE5,0xE5), o2(0xE5,0xDA), o2(0xE5,0xE2),
     o2(0xE5,0xEA), o2(0xE5,0xE9), o2(0xCB,0xFA), o2(0xB7,0xAB),
     o2(0xE5,0xE8), o2(0xE5,0xEC), o2(0xE5,0xEB), o2(0xE5,0xEF),
     o2(0xE5,0xF1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_B9 = {
    to_SHIFT_JIS_E7_B9_offsets,
    to_EUC_JP_E7_B9_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_BA_infos[16] = {
     o2(0xBB,0xBC), o2(0xE5,0xED), o2(0xE5,0xF2), o2(0xE5,0xF3),
     o2(0xF9,0xA1), o2(0xE5,0xF4), o2(0xE5,0xFA), o2(0xC5,0xBB),
     o2(0xE5,0xF6), o2(0xE5,0xF5), o2(0xE5,0xF7), o2(0xE5,0xF8),
     o2(0xE5,0xF9), o2(0xE5,0xFB), o2(0xE5,0xFC),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_BA = {
    to_SHIFT_JIS_E7_BA_offsets,
    to_EUC_JP_E7_BA_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_BC_infos[4] = {
     o2(0xB4,0xCC), o2(0xE5,0xFD), o2(0xE5,0xFE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_BC = {
    to_SHIFT_JIS_E7_BC_offsets,
    to_EUC_JP_E7_BC_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_BD_infos[25] = {
     o2(0xE6,0xA1), o2(0xFB,0xD4), o2(0xE6,0xA2), o2(0xE6,0xA3),
     o2(0xE6,0xA4), o2(0xE6,0xA5), o2(0xE6,0xA6), o2(0xE6,0xA8),
     o2(0xE6,0xA7), o2(0xE6,0xA9), o2(0xE6,0xAA), o2(0xE6,0xAB),
     o2(0xE6,0xAE), o2(0xE6,0xAC), o2(0xE6,0xAD), o2(0xBA,0xE1),
     o2(0xB7,0xD3), o2(0xC3,0xD6), o2(0xC8,0xB3), o2(0xBD,0xF0),
     o2(0xC7,0xCD), o2(0xC8,0xED), o2(0xE6,0xAF), o2(0xD8,0xED),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_BD = {
    to_SHIFT_JIS_E7_BD_offsets,
    to_EUC_JP_E7_BD_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_BE_infos[26] = {
     o2(0xE6,0xB0), o2(0xE6,0xB2), o2(0xCD,0xE5), o2(0xE6,0xB1),
     o2(0xE6,0xB4), o2(0xE6,0xB3), o2(0xCD,0xD3), o2(0xE6,0xB5),
     o2(0xC8,0xFE), o2(0xE6,0xB6), o2(0xE6,0xB9), o2(0xE6,0xB8),
     o2(0xE6,0xB7), o2(0xFB,0xD5), o2(0xE6,0xBA), o2(0xB7,0xB2),
     o2(0xC1,0xA2), o2(0xB5,0xC1), o2(0xE6,0xBE), o2(0xE6,0xBB),
     o2(0xE6,0xBC), o2(0xE6,0xBF), o2(0xE6,0xC0), o2(0xE6,0xBD),
     o2(0xB1,0xA9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_BE = {
    to_SHIFT_JIS_E7_BE_offsets,
    to_EUC_JP_E7_BE_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_BF_infos[19] = {
     o2(0xB2,0xA7), o2(0xE6,0xC2), o2(0xE6,0xC3), o2(0xE6,0xC4),
     o2(0xCD,0xE2), o2(0xBD,0xAC), o2(0xE6,0xC6), o2(0xE6,0xC5),
     o2(0xBF,0xE9), o2(0xE6,0xC7), o2(0xE6,0xC8), o2(0xE6,0xC9),
     o2(0xB4,0xE5), o2(0xB4,0xCD), o2(0xE6,0xCA), o2(0xE6,0xCB),
     o2(0xCB,0xDD), o2(0xCD,0xE3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7_BF = {
    to_SHIFT_JIS_E7_BF_offsets,
    to_EUC_JP_E7_BF_infos
};

static const struct byte_lookup* const
to_EUC_JP_E7_infos[64] = {
     &to_EUC_JP_E7_80, &to_EUC_JP_E7_81, &to_EUC_JP_E7_82, &to_EUC_JP_E7_83,
     &to_EUC_JP_E7_84, &to_EUC_JP_E7_85, &to_EUC_JP_E7_86, &to_EUC_JP_E7_87,
     &to_EUC_JP_E7_88, &to_EUC_JP_E7_89, &to_EUC_JP_E7_8A, &to_EUC_JP_E7_8B,
     &to_EUC_JP_E7_8C, &to_EUC_JP_E7_8D, &to_EUC_JP_E7_8E, &to_EUC_JP_E7_8F,
     &to_EUC_JP_E7_90, &to_EUC_JP_E7_91, &to_EUC_JP_E7_92, &to_EUC_JP_E7_93,
     &to_EUC_JP_E7_94, &to_EUC_JP_E7_95, &to_EUC_JP_E7_96, &to_EUC_JP_E7_97,
     &to_EUC_JP_E7_98, &to_EUC_JP_E7_99, &to_EUC_JP_E7_9A, &to_EUC_JP_E7_9B,
     &to_EUC_JP_E7_9C, &to_EUC_JP_E7_9D, &to_EUC_JP_E7_9E, &to_EUC_JP_E7_9F,
     &to_EUC_JP_E7_A0, &to_EUC_JP_E7_A1, &to_EUC_JP_E7_A2, &to_EUC_JP_E7_A3,
     &to_EUC_JP_E7_A4, &to_EUC_JP_E7_A5, &to_EUC_JP_E7_A6, &to_EUC_JP_E7_A7,
     &to_EUC_JP_E7_A8, &to_EUC_JP_E7_A9, &to_EUC_JP_E7_AA, &to_EUC_JP_E7_AB,
     &to_EUC_JP_E7_AC, &to_EUC_JP_E7_AD, &to_EUC_JP_E7_AE, &to_EUC_JP_E7_AF,
     &to_EUC_JP_E7_B0, &to_EUC_JP_E7_B1, &to_EUC_JP_E7_B2, &to_EUC_JP_E7_B3,
     &to_EUC_JP_E7_B4, &to_EUC_JP_E7_B5, &to_EUC_JP_E7_B6, &to_EUC_JP_E7_B7,
     &to_EUC_JP_E7_B8, &to_EUC_JP_E7_B9, &to_EUC_JP_E7_BA, &to_EUC_JP_E7_BC,
     &to_EUC_JP_E7_BD, &to_EUC_JP_E7_BE, &to_EUC_JP_E7_BF,            UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E7 = {
    to_SHIFT_JIS_E7_offsets,
    to_EUC_JP_E7_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_80_infos[23] = {
     o2(0xCD,0xD4), o2(0xCF,0xB7), o2(0xB9,0xCD), o2(0xE6,0xCE),
     o2(0xBC,0xD4), o2(0xE6,0xCD), o2(0xE6,0xCF), o2(0xBC,0xA9),
     o2(0xC2,0xD1), o2(0xE6,0xD0), o2(0xB9,0xCC), o2(0xCC,0xD7),
     o2(0xE6,0xD1), o2(0xE6,0xD2), o2(0xE6,0xD3), o2(0xE6,0xD4),
     o2(0xE6,0xD5), o2(0xBC,0xAA), o2(0xCC,0xED), o2(0xE6,0xD7),
     o2(0xC3,0xBF), o2(0xE6,0xD6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_80 = {
    to_SHIFT_JIS_E8_80_offsets,
    to_EUC_JP_E8_80_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_81_infos[23] = {
     o2(0xE6,0xD9), o2(0xE6,0xD8), o2(0xE6,0xDA), o2(0xC0,0xBB),
     o2(0xE6,0xDB), o2(0xE6,0xDC), o2(0xCA,0xB9), o2(0xE6,0xDD),
     o2(0xC1,0xEF), o2(0xE6,0xDE), o2(0xE6,0xDF), o2(0xCE,0xFE),
     o2(0xE6,0xE2), o2(0xE6,0xE1), o2(0xE6,0xE0), o2(0xC4,0xB0),
     o2(0xE6,0xE3), o2(0xBF,0xA6), o2(0xE6,0xE4), o2(0xE6,0xE5),
     o2(0xCF,0xB8), o2(0xE6,0xE6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_81 = {
    to_SHIFT_JIS_E8_81_offsets,
    to_EUC_JP_E8_81_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_82_infos[26] = {
     o2(0xE6,0xE7), o2(0xE6,0xE9), o2(0xE6,0xE8), o2(0xC8,0xA5),
     o2(0xC6,0xF9), o2(0xCF,0xBE), o2(0xC8,0xA9), o2(0xE6,0xEB),
     o2(0xBE,0xD3), o2(0xC9,0xAA), o2(0xE6,0xEC), o2(0xE6,0xEA),
     o2(0xB4,0xCE), o2(0xB8,0xD4), o2(0xBB,0xE8), o2(0xC8,0xEE),
     o2(0xB8,0xAA), o2(0xCB,0xC3), o2(0xE6,0xEF), o2(0xE6,0xED),
     o2(0xB9,0xCE), o2(0xB9,0xCF), o2(0xB0,0xE9), o2(0xBA,0xE8),
     o2(0xC7,0xD9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_82 = {
    to_SHIFT_JIS_E8_82_offsets,
    to_EUC_JP_E8_82_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_83_infos[21] = {
     o2(0xB0,0xDF), o2(0xE6,0xF4), o2(0xC3,0xC0), o2(0xC7,0xD8),
     o2(0xC2,0xDB), o2(0xE6,0xF6), o2(0xE6,0xF2), o2(0xE6,0xF5),
     o2(0xE6,0xF0), o2(0xE6,0xF3), o2(0xCB,0xA6), o2(0xB8,0xD5),
     o2(0xB0,0xFD), o2(0xE6,0xF1), o2(0xE6,0xF8), o2(0xE6,0xF9),
     o2(0xC6,0xB9), o2(0xB6,0xBB), o2(0xE7,0xA6), o2(0xC7,0xBD),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_83 = {
    to_SHIFT_JIS_E8_83_offsets,
    to_EUC_JP_E8_83_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_84_infos[17] = {
     o2(0xBB,0xE9), o2(0xB6,0xBC), o2(0xC0,0xC8), o2(0xCF,0xC6),
     o2(0xCC,0xAE), o2(0xE6,0xF7), o2(0xC0,0xD4), o2(0xB5,0xD3),
     o2(0xE6,0xFA), o2(0xE6,0xFC), o2(0xE6,0xFB), o2(0xE6,0xFD),
     o2(0xC3,0xA6), o2(0xC7,0xBE), o2(0xC4,0xB1), o2(0xE7,0xA3),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_84 = {
    to_SHIFT_JIS_E8_84_offsets,
    to_EUC_JP_E8_84_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_85_infos[21] = {
     o2(0xE7,0xA2), o2(0xE6,0xFE), o2(0xBF,0xD5), o2(0xC9,0xE5),
     o2(0xE7,0xA5), o2(0xE7,0xA4), o2(0xB9,0xD0), o2(0xCF,0xD3),
     o2(0xE7,0xB5), o2(0xE7,0xA9), o2(0xE7,0xAA), o2(0xBC,0xF0),
     o2(0xE7,0xA8), o2(0xB9,0xF8), o2(0xE7,0xA7), o2(0xE7,0xAB),
     o2(0xC4,0xB2), o2(0xCA,0xA2), o2(0xC1,0xA3), o2(0xC2,0xDC),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_85 = {
    to_SHIFT_JIS_E8_85_offsets,
    to_EUC_JP_E8_85_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_86_infos[25] = {
     o2(0xE7,0xAF), o2(0xE7,0xB0), o2(0xE7,0xAC), o2(0xE7,0xAD),
     o2(0xE7,0xAE), o2(0xB9,0xD1), o2(0xE7,0xB6), o2(0xE7,0xB2),
     o2(0xC9,0xE6), o2(0xCB,0xEC), o2(0xC9,0xA8), o2(0xE7,0xB1),
     o2(0xE7,0xB4), o2(0xE7,0xB3), o2(0xCB,0xC4), o2(0xE7,0xB7),
     o2(0xE7,0xB8), o2(0xC1,0xB7), o2(0xE7,0xB9), o2(0xE7,0xBB),
     o2(0xE7,0xBF), o2(0xE7,0xBC), o2(0xE7,0xBA), o2(0xC7,0xBF),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_86 = {
    to_SHIFT_JIS_E8_86_offsets,
    to_EUC_JP_E8_86_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_87_infos[26] = {
     o2(0xE7,0xBD), o2(0xE7,0xBE), o2(0xB2,0xB2), o2(0xE7,0xC5),
     o2(0xE7,0xC0), o2(0xE7,0xC1), o2(0xE7,0xC2), o2(0xC2,0xA1),
     o2(0xE7,0xC4), o2(0xE7,0xC3), o2(0xE7,0xC6), o2(0xE7,0xC7),
     o2(0xE7,0xC8), o2(0xBF,0xC3), o2(0xB2,0xE9), o2(0xE7,0xC9),
     o2(0xCE,0xD7), o2(0xBC,0xAB), o2(0xBD,0xAD), o2(0xBB,0xEA),
     o2(0xC3,0xD7), o2(0xE7,0xCA), o2(0xE7,0xCB), o2(0xB1,0xB1),
     o2(0xE7,0xCC),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_87 = {
    to_SHIFT_JIS_E8_87_offsets,
    to_EUC_JP_E8_87_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_88_infos[31] = {
     o2(0xE7,0xCD), o2(0xE7,0xCE), o2(0xE7,0xCF), o2(0xE7,0xD0),
     o2(0xB6,0xBD), o2(0xDA,0xAA), o2(0xE7,0xD1), o2(0xC0,0xE5),
     o2(0xE7,0xD2), o2(0xBC,0xCB), o2(0xE7,0xD3), o2(0xD0,0xB0),
     o2(0xE7,0xD4), o2(0xCA,0xDE), o2(0xB4,0xDC), o2(0xC1,0xA4),
     o2(0xBD,0xD8), o2(0xC9,0xF1), o2(0xBD,0xAE), o2(0xE7,0xD5),
     o2(0xB9,0xD2), o2(0xE7,0xD6), o2(0xC8,0xCC), o2(0xE7,0xE4),
     o2(0xE7,0xD8), o2(0xC2,0xC9), o2(0xC7,0xF5), o2(0xB8,0xBF),
     o2(0xE7,0xD7), o2(0xC1,0xA5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_88 = {
    to_SHIFT_JIS_E8_88_offsets,
    to_EUC_JP_E8_88_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_89_infos[22] = {
     o2(0xE7,0xD9), o2(0xC4,0xFA), o2(0xE7,0xDB), o2(0xE7,0xDA),
     o2(0xE7,0xDD), o2(0xE7,0xDC), o2(0xE7,0xDE), o2(0xE7,0xE0),
     o2(0xE7,0xDF), o2(0xB4,0xCF), o2(0xE7,0xE1), o2(0xE7,0xE2),
     o2(0xE7,0xE3), o2(0xBA,0xB1), o2(0xCE,0xC9), o2(0xE7,0xE5),
     o2(0xBF,0xA7), o2(0xB1,0xF0), o2(0xE7,0xE6), o2(0xE7,0xE7),
     o2(0xE7,0xE8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_89 = {
    to_SHIFT_JIS_E8_89_offsets,
    to_EUC_JP_E8_89_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_8A_infos[19] = {
     o2(0xB0,0xF2), o2(0xE7,0xE9), o2(0xE7,0xEA), o2(0xC9,0xE7),
     o2(0xBC,0xC7), o2(0xE7,0xEC), o2(0xB3,0xA9), o2(0xB0,0xB2),
     o2(0xE7,0xEB), o2(0xE7,0xEE), o2(0xC7,0xCE), o2(0xBF,0xC4),
     o2(0xB2,0xD6), o2(0xCB,0xA7), o2(0xB7,0xDD), o2(0xB6,0xDC),
     o2(0xE7,0xED), o2(0xB2,0xEA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_8A = {
    to_SHIFT_JIS_E8_8A_offsets,
    to_EUC_JP_E8_8A_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_8B_infos[24] = {
     o2(0xB4,0xA3), o2(0xB1,0xF1), o2(0xE7,0xF2), o2(0xCE,0xEA),
     o2(0xC2,0xDD), o2(0xC9,0xC4), o2(0xE7,0xFE), o2(0xB2,0xD7),
     o2(0xE7,0xFC), o2(0xE7,0xFA), o2(0xE7,0xF1), o2(0xE7,0xEF),
     o2(0xE7,0xF0), o2(0xBC,0xE3), o2(0xB6,0xEC), o2(0xC3,0xF7),
     o2(0xC6,0xD1), o2(0xB1,0xD1), o2(0xE7,0xF4), o2(0xE7,0xF3),
     o2(0xE7,0xF9), o2(0xE7,0xF5), o2(0xE7,0xF8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_8B = {
    to_SHIFT_JIS_E8_8B_offsets,
    to_EUC_JP_E8_8B_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_8C_infos[24] = {
     o2(0xFB,0xD7), o2(0xCC,0xD0), o2(0xE7,0xF7), o2(0xB2,0xD8),
     o2(0xB3,0xFD), o2(0xE7,0xFB), o2(0xE7,0xFD), o2(0xB7,0xD4),
     o2(0xE8,0xA3), o2(0xE8,0xAC), o2(0xE8,0xAD), o2(0xB0,0xAB),
     o2(0xE8,0xB4), o2(0xB0,0xF1), o2(0xE8,0xAB), o2(0xE8,0xAA),
     o2(0xE8,0xA5), o2(0xE8,0xA4), o2(0xE8,0xA2), o2(0xE8,0xA1),
     o2(0xC3,0xE3), o2(0xC2,0xFB), o2(0xE8,0xA7),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_8C = {
    to_SHIFT_JIS_E8_8C_offsets,
    to_EUC_JP_E8_8C_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_8D_infos[16] = {
     o2(0xE8,0xA6), o2(0xE8,0xA9), o2(0xC1,0xF0), o2(0xB7,0xD5),
     o2(0xB1,0xC1), o2(0xE8,0xA8), o2(0xB9,0xD3), o2(0xC1,0xF1),
     o2(0xFB,0xD8), o2(0xE8,0xBA), o2(0xE8,0xBB), o2(0xB2,0xD9),
     o2(0xB2,0xAE), o2(0xE8,0xB8), o2(0xFB,0xD9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_8D = {
    to_SHIFT_JIS_E8_8D_offsets,
    to_EUC_JP_E8_8D_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_8E_infos[19] = {
     o2(0xE8,0xAE), o2(0xE8,0xB6), o2(0xE8,0xBD), o2(0xE8,0xB7),
     o2(0xE8,0xB5), o2(0xE7,0xF6), o2(0xE8,0xB3), o2(0xE8,0xAF),
     o2(0xB4,0xD0), o2(0xE8,0xB1), o2(0xE8,0xBC), o2(0xE8,0xB2),
     o2(0xE8,0xBE), o2(0xE8,0xB0), o2(0xC7,0xFC), o2(0xCD,0xE9),
     o2(0xE8,0xB9), o2(0xE8,0xCF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_8E = {
    to_SHIFT_JIS_E8_8E_offsets,
    to_EUC_JP_E8_8E_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_8F_infos[24] = {
     o2(0xE8,0xC7), o2(0xBF,0xFB), o2(0xFB,0xDA), o2(0xB5,0xC6),
     o2(0xB6,0xDD), o2(0xE8,0xC2), o2(0xB2,0xDB), o2(0xBE,0xD4),
     o2(0xE8,0xC5), o2(0xBA,0xDA), o2(0xC5,0xD1), o2(0xE8,0xCA),
     o2(0xCA,0xEE), o2(0xE8,0xC1), o2(0xB2,0xDA), o2(0xB8,0xD6),
     o2(0xC9,0xA9), o2(0xE8,0xCB), o2(0xE8,0xBF), o2(0xFB,0xDB),
     o2(0xE8,0xC8), o2(0xE8,0xD2), o2(0xE8,0xC3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_8F = {
    to_SHIFT_JIS_E8_8F_offsets,
    to_EUC_JP_E8_8F_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_90_infos[19] = {
     o2(0xE8,0xC4), o2(0xC6,0xBA), o2(0xE8,0xC9), o2(0xE8,0xC6),
     o2(0xCB,0xA8), o2(0xE8,0xCC), o2(0xB0,0xE0), o2(0xE8,0xC0),
     o2(0xE8,0xCE), o2(0xE8,0xCD), o2(0xC7,0xEB), o2(0xE8,0xD4),
     o2(0xE8,0xDF), o2(0xB3,0xFE), o2(0xE8,0xE2), o2(0xE8,0xD0),
     o2(0xE8,0xD5), o2(0xCD,0xEE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_90 = {
    to_SHIFT_JIS_E8_90_offsets,
    to_EUC_JP_E8_90_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_91_infos[22] = {
     o2(0xE8,0xDE), o2(0xFB,0xDC), o2(0xCD,0xD5), o2(0xCE,0xAA),
     o2(0xC3,0xF8), o2(0xB3,0xEB), o2(0xC9,0xF2), o2(0xE8,0xE4),
     o2(0xC6,0xA1), o2(0xB0,0xB1), o2(0xE8,0xDD), o2(0xE8,0xD9),
     o2(0xC1,0xF2), o2(0xE8,0xD3), o2(0xE8,0xDB), o2(0xE8,0xE0),
     o2(0xC7,0xAC), o2(0xB0,0xAA), o2(0xE8,0xD8), o2(0xE8,0xE1),
     o2(0xC9,0xF8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_91 = {
    to_SHIFT_JIS_E8_91_offsets,
    to_EUC_JP_E8_91_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_92_infos[18] = {
     o2(0xE8,0xDC), o2(0xE8,0xD7), o2(0xBE,0xD5), o2(0xBD,0xAF),
     o2(0xBC,0xAC), o2(0xCC,0xD8), o2(0xC9,0xC7), o2(0xE8,0xE7),
     o2(0xE8,0xF0), o2(0xE8,0xDA), o2(0xB3,0xF7), o2(0xFB,0xDD),
     o2(0xBE,0xF8), o2(0xE8,0xE5), o2(0xE8,0xEA), o2(0xC1,0xF3),
     o2(0xE8,0xE6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_92 = {
    to_SHIFT_JIS_E8_92_offsets,
    to_EUC_JP_E8_92_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_93_infos[19] = {
     o2(0xE8,0xED), o2(0xC3,0xDF), o2(0xE8,0xEE), o2(0xCD,0xD6),
     o2(0xE8,0xE3), o2(0xB3,0xB8), o2(0xE8,0xE9), o2(0xE8,0xEC),
     o2(0xCC,0xAC), o2(0xE8,0xEF), o2(0xE8,0xE8), o2(0xE8,0xEB),
     o2(0xF9,0xA5), o2(0xCB,0xA9), o2(0xCF,0xA1), o2(0xE8,0xF3),
     o2(0xE8,0xFA), o2(0xE8,0xF2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_93 = {
    to_SHIFT_JIS_E8_93_offsets,
    to_EUC_JP_E8_93_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_94_infos[17] = {
     o2(0xBC,0xC3), o2(0xE8,0xD1), o2(0xCA,0xCE), o2(0xCC,0xA2),
     o2(0xE8,0xF9), o2(0xE8,0xF8), o2(0xE8,0xF4), o2(0xE8,0xF5),
     o2(0xB1,0xB6), o2(0xE8,0xF7), o2(0xE8,0xF1), o2(0xC4,0xD5),
     o2(0xE8,0xF6), o2(0xB0,0xFE), o2(0xC2,0xA2), o2(0xCA,0xC3),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_94 = {
    to_SHIFT_JIS_E8_94_offsets,
    to_EUC_JP_E8_94_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_95_infos[23] = {
     o2(0xE8,0xFB), o2(0xE9,0xA1), o2(0xC8,0xD9), o2(0xE8,0xFE),
     o2(0xBE,0xD6), o2(0xBC,0xC9), o2(0xE9,0xA3), o2(0xB6,0xBE),
     o2(0xFB,0xDE), o2(0xE9,0xA4), o2(0xC9,0xF9), o2(0xE8,0xFD),
     o2(0xFB,0xDF), o2(0xE8,0xD6), o2(0xE8,0xFC), o2(0xCF,0xCF),
     o2(0xC6,0xA2), o2(0xC9,0xF3), o2(0xFB,0xE0), o2(0xE9,0xAB),
     o2(0xE9,0xB1), o2(0xE9,0xB2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_95 = {
    to_SHIFT_JIS_E8_95_offsets,
    to_EUC_JP_E8_95_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_96_infos[25] = {
     o2(0xE9,0xA5), o2(0xC7,0xF6), o2(0xE9,0xAF), o2(0xE9,0xA7),
     o2(0xE9,0xA9), o2(0xE9,0xB3), o2(0xE9,0xA8), o2(0xE9,0xAC),
     o2(0xB1,0xF2), o2(0xC6,0xE5), o2(0xE9,0xAD), o2(0xE9,0xB0),
     o2(0xE9,0xA6), o2(0xC1,0xA6), o2(0xE9,0xAA), o2(0xBB,0xA7),
     o2(0xBF,0xC5), o2(0xB7,0xB0), o2(0xCC,0xF4), o2(0xCC,0xF9),
     o2(0xBD,0xF2), o2(0xFB,0xE2), o2(0xE9,0xB7), o2(0xE9,0xB5),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_96 = {
    to_SHIFT_JIS_E8_96_offsets,
    to_EUC_JP_E8_96_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_97_infos[18] = {
     o2(0xCF,0xCE), o2(0xE9,0xB4), o2(0xCD,0xF5), o2(0xE9,0xB6),
     o2(0xE9,0xB8), o2(0xE9,0xB9), o2(0xE9,0xBC), o2(0xE9,0xBA),
     o2(0xC6,0xA3), o2(0xE9,0xBB), o2(0xC8,0xCD), o2(0xE9,0xAE),
     o2(0xBD,0xF3), o2(0xE9,0xBD), o2(0xE9,0xC2), o2(0xC1,0xF4),
     o2(0xE9,0xC1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_97 = {
    to_SHIFT_JIS_E8_97_offsets,
    to_EUC_JP_E8_97_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_98_infos[15] = {
     o2(0xE9,0xA2), o2(0xE9,0xC3), o2(0xC1,0xC9), o2(0xE9,0xBE),
     o2(0xE9,0xC0), o2(0xE9,0xBF), o2(0xDD,0xB1), o2(0xDD,0xA2),
     o2(0xE9,0xC5), o2(0xE9,0xC4), o2(0xCD,0xF6), o2(0xE2,0xBC),
     o2(0xE9,0xC6), o2(0xE9,0xC7),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_98 = {
    to_SHIFT_JIS_E8_98_offsets,
    to_EUC_JP_E8_98_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_99_infos[15] = {
     o2(0xE9,0xC8), o2(0xB8,0xD7), o2(0xB5,0xD4), o2(0xE9,0xCA),
     o2(0xD1,0xDD), o2(0xB5,0xF5), o2(0xCE,0xBA), o2(0xB6,0xF3),
     o2(0xE9,0xCB), o2(0xE9,0xCC), o2(0xC3,0xEE), o2(0xE9,0xCD),
     o2(0xC6,0xFA), o2(0xB0,0xBA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_99 = {
    to_SHIFT_JIS_E8_99_offsets,
    to_EUC_JP_E8_99_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_9A_infos[14] = {
     o2(0xB2,0xE3), o2(0xE9,0xD2), o2(0xE9,0xD3), o2(0xE9,0xCE),
     o2(0xBB,0xBD), o2(0xE9,0xCF), o2(0xC7,0xC2), o2(0xE9,0xD0),
     o2(0xE9,0xD1), o2(0xE9,0xDB), o2(0xE9,0xD5), o2(0xE9,0xD8),
     o2(0xE9,0xD4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_9A = {
    to_SHIFT_JIS_E8_9A_offsets,
    to_EUC_JP_E8_9A_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_9B_infos[23] = {
     o2(0xE9,0xD6), o2(0xE9,0xD7), o2(0xBC,0xD8), o2(0xE9,0xD9),
     o2(0xC3,0xC1), o2(0xB7,0xD6), o2(0xB3,0xC2), o2(0xE9,0xDC),
     o2(0xB3,0xBF), o2(0xE9,0xE1), o2(0xE9,0xDD), o2(0xE9,0xE0),
     o2(0xC8,0xBA), o2(0xE9,0xDE), o2(0xE9,0xDF), o2(0xC9,0xC8),
     o2(0xC8,0xDA), o2(0xE9,0xE2), o2(0xC2,0xFD), o2(0xE9,0xEC),
     o2(0xE9,0xE8), o2(0xB2,0xEB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_9B = {
    to_SHIFT_JIS_E8_9B_offsets,
    to_EUC_JP_E8_9B_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_9C_infos[20] = {
     o2(0xE9,0xE6), o2(0xCB,0xAA), o2(0xE9,0xE7), o2(0xE9,0xE4),
     o2(0xE9,0xE5), o2(0xE9,0xEA), o2(0xE9,0xED), o2(0xE9,0xEB),
     o2(0xE9,0xE9), o2(0xE9,0xE3), o2(0xC3,0xD8), o2(0xE9,0xF4),
     o2(0xCC,0xAA), o2(0xE9,0xF2), o2(0xE9,0xF3), o2(0xE9,0xEE),
     o2(0xE9,0xF0), o2(0xE9,0xF1), o2(0xE9,0xEF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_9C = {
    to_SHIFT_JIS_E8_9C_offsets,
    to_EUC_JP_E8_9C_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_9D_infos[20] = {
     o2(0xC0,0xE6), o2(0xCF,0xB9), o2(0xE9,0xF8), o2(0xE9,0xF9),
     o2(0xEA,0xA1), o2(0xBF,0xAA), o2(0xE9,0xFB), o2(0xE9,0xFE),
     o2(0xE9,0xF6), o2(0xE9,0xF5), o2(0xEA,0xA2), o2(0xB2,0xDC),
     o2(0xE9,0xFC), o2(0xEA,0xA3), o2(0xE9,0xFD), o2(0xE9,0xFA),
     o2(0xC4,0xB3), o2(0xE9,0xF7), o2(0xC7,0xE8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_9D = {
    to_SHIFT_JIS_E8_9D_offsets,
    to_EUC_JP_E8_9D_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_9E_infos[11] = {
     o2(0xEA,0xA7), o2(0xCD,0xBB), o2(0xEA,0xA6), o2(0xEA,0xA5),
     o2(0xEA,0xAE), o2(0xEA,0xA8), o2(0xEA,0xB0), o2(0xCD,0xE6),
     o2(0xEA,0xB3), o2(0xEA,0xAA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_9E = {
    to_SHIFT_JIS_E8_9E_offsets,
    to_EUC_JP_E8_9E_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_9F_infos[16] = {
     o2(0xEA,0xAB), o2(0xEA,0xAF), o2(0xEA,0xB2), o2(0xEA,0xB1),
     o2(0xEA,0xA9), o2(0xEA,0xAC), o2(0xEA,0xBD), o2(0xEA,0xB6),
     o2(0xEA,0xB4), o2(0xEA,0xB5), o2(0xEA,0xBA), o2(0xEA,0xBB),
     o2(0xB3,0xAA), o2(0xB5,0xC2), o2(0xEA,0xB9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_9F = {
    to_SHIFT_JIS_E8_9F_offsets,
    to_EUC_JP_E8_9F_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_A0_infos[17] = {
     o2(0xEA,0xA4), o2(0xFB,0xE5), o2(0xEA,0xB8), o2(0xEA,0xBC),
     o2(0xEA,0xB7), o2(0xEA,0xBE), o2(0xEA,0xC0), o2(0xEA,0xBF),
     o2(0xEA,0xC2), o2(0xEA,0xC1), o2(0xE9,0xDA), o2(0xEA,0xC6),
     o2(0xEA,0xC3), o2(0xEA,0xC4), o2(0xEA,0xC5), o2(0xEA,0xC7),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_A0 = {
    to_SHIFT_JIS_E8_A0_offsets,
    to_EUC_JP_E8_A0_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_A1_infos[26] = {
     o2(0xB7,0xEC), o2(0xEA,0xC9), o2(0xEA,0xC8), o2(0xBD,0xB0),
     o2(0xB9,0xD4), o2(0xDE,0xA7), o2(0xEA,0xCA), o2(0xBD,0xD1),
     o2(0xB3,0xB9), o2(0xEA,0xCB), o2(0xB1,0xD2), o2(0xBE,0xD7),
     o2(0xEA,0xCC), o2(0xB9,0xD5), o2(0xEA,0xCD), o2(0xB0,0xE1),
     o2(0xC9,0xBD), o2(0xEA,0xCE), o2(0xBF,0xEA), o2(0xEA,0xD5),
     o2(0xEA,0xD2), o2(0xC3,0xEF), o2(0xEA,0xD3), o2(0xEA,0xD0),
     o2(0xB6,0xDE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_A1 = {
    to_SHIFT_JIS_E8_A1_offsets,
    to_EUC_JP_E8_A1_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_A2_infos[21] = {
     o2(0xEA,0xCF), o2(0xEA,0xD6), o2(0xB7,0xB6), o2(0xC2,0xDE),
     o2(0xEA,0xDC), o2(0xEA,0xD8), o2(0xC2,0xB5), o2(0xEA,0xD7),
     o2(0xEA,0xDA), o2(0xEA,0xD1), o2(0xEA,0xDB), o2(0xEA,0xDD),
     o2(0xC8,0xEF), o2(0xEA,0xD9), o2(0xEA,0xDE), o2(0xEA,0xE0),
     o2(0xB8,0xD3), o2(0xEA,0xD4), o2(0xB0,0xC1), o2(0xEA,0xDF),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_A2 = {
    to_SHIFT_JIS_E8_A2_offsets,
    to_EUC_JP_E8_A2_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_A3_infos[25] = {
     o2(0xBA,0xDB), o2(0xCE,0xF6), o2(0xEA,0xE1), o2(0xEA,0xE2),
     o2(0xC1,0xF5), o2(0xCE,0xA2), o2(0xEA,0xE3), o2(0xCD,0xB5),
     o2(0xEA,0xE4), o2(0xEA,0xE5), o2(0xCA,0xE4), o2(0xEA,0xE6),
     o2(0xBA,0xC0), o2(0xCE,0xA3), o2(0xEA,0xEB), o2(0xEA,0xEC),
     o2(0xBE,0xD8), o2(0xEA,0xEA), o2(0xFB,0xE6), o2(0xCD,0xE7),
     o2(0xEA,0xE7), o2(0xEA,0xE9), o2(0xC0,0xBD), o2(0xBF,0xFE),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_A3 = {
    to_SHIFT_JIS_E8_A3_offsets,
    to_EUC_JP_E8_A3_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_A4_infos[18] = {
     o2(0xEA,0xE8), o2(0xEA,0xED), o2(0xCA,0xA3), o2(0xEA,0xEF),
     o2(0xEA,0xEE), o2(0xB3,0xEC), o2(0xCB,0xAB), o2(0xEA,0xF0),
     o2(0xF9,0xA2), o2(0xEA,0xFC), o2(0xEA,0xF2), o2(0xEA,0xF3),
     o2(0xEA,0xF4), o2(0xEA,0xF5), o2(0xEA,0xF9), o2(0xEA,0xFA),
     o2(0xEA,0xF8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_A4 = {
    to_SHIFT_JIS_E8_A4_offsets,
    to_EUC_JP_E8_A4_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_A5_infos[20] = {
     o2(0xEA,0xF6), o2(0xEA,0xF1), o2(0xEA,0xF7), o2(0xEA,0xFB),
     o2(0xF0,0xB7), o2(0xB2,0xA8), o2(0xEA,0xFE), o2(0xB6,0xDF),
     o2(0xEA,0xFD), o2(0xEB,0xA2), o2(0xEB,0xA1), o2(0xEB,0xA4),
     o2(0xEB,0xA3), o2(0xEB,0xA5), o2(0xBD,0xB1), o2(0xEB,0xA6),
     o2(0xEB,0xA7), o2(0xEB,0xA8), o2(0xC0,0xBE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_A5 = {
    to_SHIFT_JIS_E8_A5_offsets,
    to_EUC_JP_E8_A5_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_A6_infos[26] = {
     o2(0xCD,0xD7), o2(0xEB,0xA9), o2(0xCA,0xA4), o2(0xC7,0xC6),
     o2(0xEB,0xAA), o2(0xEB,0xAB), o2(0xB8,0xAB), o2(0xB5,0xAC),
     o2(0xEB,0xAC), o2(0xBB,0xEB), o2(0xC7,0xC1), o2(0xEB,0xAD),
     o2(0xB3,0xD0), o2(0xEB,0xAE), o2(0xEB,0xB0), o2(0xCD,0xF7),
     o2(0xEB,0xAF), o2(0xBF,0xC6), o2(0xEB,0xB1), o2(0xEB,0xB2),
     o2(0xEB,0xB3), o2(0xB4,0xD1), o2(0xEB,0xB4), o2(0xEB,0xB5),
     o2(0xEB,0xB6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_A6 = {
    to_SHIFT_JIS_E8_A6_offsets,
    to_EUC_JP_E8_A6_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_A7_infos[11] = {
     o2(0xEB,0xB7), o2(0xB3,0xD1), o2(0xEB,0xB8), o2(0xEB,0xB9),
     o2(0xEB,0xBA), o2(0xB2,0xF2), o2(0xBF,0xA8), o2(0xEB,0xBB),
     o2(0xEB,0xBC), o2(0xEB,0xBD),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_A7 = {
    to_SHIFT_JIS_E8_A7_offsets,
    to_EUC_JP_E8_A7_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_A8_infos[29] = {
     o2(0xB8,0xC0), o2(0xC4,0xFB), o2(0xEB,0xBE), o2(0xB7,0xD7),
     o2(0xBF,0xD6), o2(0xEB,0xC1), o2(0xC6,0xA4), o2(0xEB,0xC0),
     o2(0xFB,0xE7), o2(0xB7,0xB1), o2(0xEB,0xBF), o2(0xC2,0xF7),
     o2(0xB5,0xAD), o2(0xEB,0xC2), o2(0xEB,0xC3), o2(0xBE,0xD9),
     o2(0xB7,0xED), o2(0xEB,0xC4), o2(0xCB,0xAC), o2(0xC0,0xDF),
     o2(0xB5,0xF6), o2(0xCC,0xF5), o2(0xC1,0xCA), o2(0xEB,0xC5),
     o2(0xFB,0xE8), o2(0xBF,0xC7), o2(0xC3,0xF0), o2(0xBE,0xDA),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_A8 = {
    to_SHIFT_JIS_E8_A8_offsets,
    to_EUC_JP_E8_A8_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_A9_infos[26] = {
     o2(0xEB,0xC6), o2(0xEB,0xC9), o2(0xEB,0xCA), o2(0xBA,0xBE),
     o2(0xC2,0xC2), o2(0xEB,0xC8), o2(0xBE,0xDB), o2(0xC9,0xBE),
     o2(0xEB,0xC7), o2(0xBB,0xEC), o2(0xB1,0xD3), o2(0xEB,0xCE),
     o2(0xB7,0xD8), o2(0xBB,0xEE), o2(0xBB,0xED), o2(0xCF,0xCD),
     o2(0xEB,0xCD), o2(0xEB,0xCC), o2(0xC1,0xA7), o2(0xB5,0xCD),
     o2(0xCF,0xC3), o2(0xB3,0xBA), o2(0xBE,0xDC), o2(0xFB,0xE9),
     o2(0xEB,0xCB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_A9 = {
    to_SHIFT_JIS_E8_A9_offsets,
    to_EUC_JP_E8_A9_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_AA_infos[30] = {
     o2(0xEB,0xD0), o2(0xEB,0xD1), o2(0xEB,0xCF), o2(0xB8,0xD8),
     o2(0xCD,0xC0), o2(0xBB,0xEF), o2(0xC7,0xA7), o2(0xEB,0xD4),
     o2(0xC0,0xC0), o2(0xC3,0xC2), o2(0xCD,0xB6), o2(0xEB,0xD7),
     o2(0xB8,0xEC), o2(0xC0,0xBF), o2(0xEB,0xD3), o2(0xEB,0xD8),
     o2(0xB8,0xED), o2(0xEB,0xD5), o2(0xEB,0xD6), o2(0xFB,0xEA),
     o2(0xEB,0xD2), o2(0xC0,0xE2), o2(0xC6,0xC9), o2(0xC3,0xAF),
     o2(0xB2,0xDD), o2(0xC8,0xF0), o2(0xB5,0xC3), o2(0xFB,0xEB),
     o2(0xC4,0xB4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_AA = {
    to_SHIFT_JIS_E8_AA_offsets,
    to_EUC_JP_E8_AA_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_AB_infos[31] = {
     o2(0xEB,0xDB), o2(0xEB,0xD9), o2(0xC3,0xCC), o2(0xC0,0xC1),
     o2(0xB4,0xD2), o2(0xEB,0xDA), o2(0xBF,0xDB), o2(0xCE,0xCA),
     o2(0xCF,0xC0), o2(0xEB,0xDC), o2(0xEB,0xE7), o2(0xC4,0xB5),
     o2(0xEB,0xE6), o2(0xFB,0xEC), o2(0xEB,0xE3), o2(0xEB,0xEB),
     o2(0xEB,0xE4), o2(0xEB,0xE0), o2(0xC4,0xFC), o2(0xEB,0xDF),
     o2(0xEB,0xDD), o2(0xCD,0xA1), o2(0xBB,0xF0), o2(0xEB,0xE1),
     o2(0xEB,0xDE), o2(0xFB,0xEE), o2(0xEB,0xE5), o2(0xBD,0xF4),
     o2(0xB8,0xC1), o2(0xC2,0xFA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_AB = {
    to_SHIFT_JIS_E8_AB_offsets,
    to_EUC_JP_E8_AB_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_AC_infos[25] = {
     o2(0xCB,0xC5), o2(0xB1,0xDA), o2(0xB0,0xE2), o2(0xC6,0xA5),
     o2(0xEB,0xE9), o2(0xEB,0xE8), o2(0xC6,0xE6), o2(0xEB,0xED),
     o2(0xEB,0xE2), o2(0xEB,0xEC), o2(0xEB,0xEE), o2(0xB8,0xAC),
     o2(0xEB,0xEA), o2(0xB9,0xD6), o2(0xBC,0xD5), o2(0xEB,0xEF),
     o2(0xCD,0xD8), o2(0xEB,0xF2), o2(0xEB,0xF5), o2(0xEB,0xF3),
     o2(0xC9,0xB5), o2(0xEB,0xF0), o2(0xB6,0xE0), o2(0xEB,0xF4),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_AC = {
    to_SHIFT_JIS_E8_AC_offsets,
    to_EUC_JP_E8_AC_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_AD_infos[24] = {
     o2(0xEB,0xF6), o2(0xEB,0xFA), o2(0xEB,0xF7), o2(0xEB,0xF9),
     o2(0xEB,0xF8), o2(0xFB,0xEF), o2(0xEB,0xFB), o2(0xBC,0xB1),
     o2(0xEB,0xFD), o2(0xEB,0xFC), o2(0xC9,0xE8), o2(0xEC,0xA1),
     o2(0xB7,0xD9), o2(0xEB,0xFE), o2(0xEC,0xA2), o2(0xEC,0xA3),
     o2(0xB5,0xC4), o2(0xE6,0xC1), o2(0xBE,0xF9), o2(0xEC,0xA4),
     o2(0xB8,0xEE), o2(0xEC,0xA5), o2(0xFB,0xF0),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_AD = {
    to_SHIFT_JIS_E8_AD_offsets,
    to_EUC_JP_E8_AD_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_AE_infos[12] = {
     o2(0xEC,0xA6), o2(0xBB,0xBE), o2(0xDA,0xCE), o2(0xEC,0xA7),
     o2(0xEC,0xA8), o2(0xBD,0xB2), o2(0xEC,0xA9), o2(0xEC,0xAA),
     o2(0xEC,0xAB), o2(0xEC,0xAC), o2(0xEC,0xAD),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_AE = {
    to_SHIFT_JIS_E8_AE_offsets,
    to_EUC_JP_E8_AE_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_B0_infos[4] = {
     o2(0xC3,0xAB), o2(0xEC,0xAE), o2(0xEC,0xB0),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_B0 = {
    to_SHIFT_JIS_E8_B0_offsets,
    to_EUC_JP_E8_B0_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_B1_infos[19] = {
     o2(0xEC,0xAF), o2(0xC6,0xA6), o2(0xEC,0xB1), o2(0xCB,0xAD),
     o2(0xEC,0xB2), o2(0xEC,0xB3), o2(0xEC,0xB4), o2(0xEC,0xB5),
     o2(0xC6,0xDA), o2(0xBE,0xDD), o2(0xEC,0xB6), o2(0xB9,0xEB),
     o2(0xD0,0xAE), o2(0xEC,0xB7), o2(0xEC,0xB8), o2(0xC9,0xBF),
     o2(0xEC,0xB9), o2(0xEC,0xC1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_B1 = {
    to_SHIFT_JIS_E8_B1_offsets,
    to_EUC_JP_E8_B1_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_B2_infos[35] = {
     o2(0xEC,0xBA), o2(0xEC,0xBC), o2(0xEC,0xBB), o2(0xEC,0xBD),
     o2(0xCB,0xC6), o2(0xEC,0xBE), o2(0xEC,0xBF), o2(0xEC,0xC0),
     o2(0xEC,0xC2), o2(0xB3,0xAD), o2(0xC4,0xE7), o2(0xC9,0xE9),
     o2(0xBA,0xE2), o2(0xB9,0xD7), o2(0xC9,0xCF), o2(0xB2,0xDF),
     o2(0xC8,0xCE), o2(0xEC,0xC5), o2(0xB4,0xD3), o2(0xC0,0xD5),
     o2(0xEC,0xC4), o2(0xEC,0xC9), o2(0xC3,0xF9), o2(0xCC,0xE3),
     o2(0xEC,0xC7), o2(0xEC,0xC8), o2(0xB5,0xAE), o2(0xEC,0xCA),
     o2(0xC7,0xE3), o2(0xC2,0xDF), o2(0xC8,0xF1), o2(0xC5,0xBD),
     o2(0xEC,0xC6), o2(0xCB,0xC7),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_B2 = {
    to_SHIFT_JIS_E8_B2_offsets,
    to_EUC_JP_E8_B2_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_B3_infos[30] = {
     o2(0xB2,0xEC), o2(0xEC,0xCC), o2(0xCF,0xA8), o2(0xC4,0xC2),
     o2(0xCF,0xC5), o2(0xBB,0xF1), o2(0xEC,0xCB), o2(0xC2,0xB1),
     o2(0xEC,0xDC), o2(0xC1,0xA8), o2(0xC6,0xF8), o2(0xC9,0xD0),
     o2(0xEC,0xCF), o2(0xBB,0xBF), o2(0xBB,0xF2), o2(0xBE,0xDE),
     o2(0xC7,0xE5), o2(0xB8,0xAD), o2(0xEC,0xCE), o2(0xEC,0xCD),
     o2(0xC9,0xEA), o2(0xBC,0xC1), o2(0xC5,0xD2), o2(0xFB,0xF1),
     o2(0xFB,0xF2), o2(0xEC,0xD1), o2(0xEC,0xD2), o2(0xB9,0xD8),
     o2(0xEC,0xD0),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_B3 = {
    to_SHIFT_JIS_E8_B3_offsets,
    to_EUC_JP_E8_B3_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_B4_infos[14] = {
     o2(0xEC,0xD3), o2(0xEC,0xD4), o2(0xEC,0xD6), o2(0xC2,0xA3),
     o2(0xEC,0xD5), o2(0xB4,0xE6), o2(0xEC,0xD8), o2(0xEC,0xD7),
     o2(0xEC,0xD9), o2(0xFB,0xF3), o2(0xEC,0xDB), o2(0xEC,0xDD),
     o2(0xEC,0xDE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_B4 = {
    to_SHIFT_JIS_E8_B4_offsets,
    to_EUC_JP_E8_B4_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_B5_infos[12] = {
     o2(0xC0,0xD6), o2(0xBC,0xCF), o2(0xEC,0xDF), o2(0xB3,0xD2),
     o2(0xEC,0xE0), o2(0xC1,0xF6), o2(0xEC,0xE1), o2(0xEC,0xE2),
     o2(0xC9,0xEB), o2(0xFB,0xF4), o2(0xB5,0xAF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_B5 = {
    to_SHIFT_JIS_E8_B5_offsets,
    to_EUC_JP_E8_B5_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_B6_infos[10] = {
     o2(0xEC,0xE3), o2(0xC4,0xB6), o2(0xB1,0xDB), o2(0xEC,0xE4),
     o2(0xBC,0xF1), o2(0xBF,0xF6), o2(0xC2,0xAD), o2(0xEC,0xE7),
     o2(0xEC,0xE6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_B6 = {
    to_SHIFT_JIS_E8_B6_offsets,
    to_EUC_JP_E8_B6_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_B7_infos[20] = {
     o2(0xEC,0xE5), o2(0xEC,0xED), o2(0xEC,0xEB), o2(0xEC,0xE8),
     o2(0xEC,0xEA), o2(0xEC,0xE9), o2(0xEC,0xEC), o2(0xB5,0xF7),
     o2(0xEC,0xF0), o2(0xC0,0xD7), o2(0xEC,0xF1), o2(0xB8,0xD9),
     o2(0xEC,0xEE), o2(0xEC,0xEF), o2(0xCF,0xA9), o2(0xC4,0xB7),
     o2(0xC1,0xA9), o2(0xEC,0xF2), o2(0xEC,0xF5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_B7 = {
    to_SHIFT_JIS_E8_B7_offsets,
    to_EUC_JP_E8_B7_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_B8_infos[13] = {
     o2(0xEC,0xF3), o2(0xEC,0xF4), o2(0xCD,0xD9), o2(0xC6,0xA7),
     o2(0xEC,0xF8), o2(0xEC,0xF6), o2(0xEC,0xF7), o2(0xEC,0xF9),
     o2(0xED,0xA9), o2(0xEC,0xFC), o2(0xEC,0xFD), o2(0xEC,0xFB),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_B8 = {
    to_SHIFT_JIS_E8_B8_offsets,
    to_EUC_JP_E8_B8_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_B9_infos[19] = {
     o2(0xEC,0xFA), o2(0xC4,0xFD), o2(0xED,0xA1), o2(0xED,0xA5),
     o2(0xED,0xA2), o2(0xEC,0xFE), o2(0xED,0xA3), o2(0xED,0xA4),
     o2(0xED,0xAB), o2(0xED,0xA6), o2(0xC0,0xD8), o2(0xED,0xA8),
     o2(0xED,0xAA), o2(0xED,0xA7), o2(0xED,0xAD), o2(0xBD,0xB3),
     o2(0xED,0xAC), o2(0xED,0xAE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_B9 = {
    to_SHIFT_JIS_E8_B9_offsets,
    to_EUC_JP_E8_B9_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_BA_infos[20] = {
     o2(0xED,0xAF), o2(0xED,0xB2), o2(0xED,0xB1), o2(0xED,0xB0),
     o2(0xED,0xB4), o2(0xED,0xB3), o2(0xCC,0xF6), o2(0xED,0xB6),
     o2(0xED,0xB5), o2(0xED,0xB7), o2(0xED,0xB8), o2(0xED,0xBA),
     o2(0xED,0xB9), o2(0xBF,0xC8), o2(0xED,0xBB), o2(0xB6,0xED),
     o2(0xED,0xBC), o2(0xED,0xBE), o2(0xED,0xBF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_BA = {
    to_SHIFT_JIS_E8_BA_offsets,
    to_EUC_JP_E8_BA_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_BB_infos[20] = {
     o2(0xED,0xC0), o2(0xED,0xBD), o2(0xED,0xC1), o2(0xBC,0xD6),
     o2(0xED,0xC2), o2(0xB5,0xB0), o2(0xB7,0xB3), o2(0xFB,0xF6),
     o2(0xB8,0xAE), o2(0xED,0xC3), o2(0xC6,0xF0), o2(0xC5,0xBE),
     o2(0xED,0xC4), o2(0xED,0xC7), o2(0xBC,0xB4), o2(0xED,0xC6),
     o2(0xED,0xC5), o2(0xB7,0xDA), o2(0xED,0xC8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_BB = {
    to_SHIFT_JIS_E8_BB_offsets,
    to_EUC_JP_E8_BB_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_BC_infos[25] = {
     o2(0xB3,0xD3), o2(0xED,0xCA), o2(0xBA,0xDC), o2(0xED,0xC9),
     o2(0xED,0xD2), o2(0xED,0xCC), o2(0xED,0xCE), o2(0xCA,0xE5),
     o2(0xED,0xCB), o2(0xED,0xCD), o2(0xED,0xD1), o2(0xED,0xCF),
     o2(0xB5,0xB1), o2(0xED,0xD0), o2(0xED,0xD3), o2(0xC7,0xDA),
     o2(0xCE,0xD8), o2(0xBD,0xB4), o2(0xED,0xD4), o2(0xCD,0xA2),
     o2(0xED,0xD6), o2(0xED,0xD5), o2(0xED,0xD9), o2(0xCD,0xC1),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_BC = {
    to_SHIFT_JIS_E8_BC_offsets,
    to_EUC_JP_E8_BC_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_BD_infos[16] = {
     o2(0xED,0xD8), o2(0xB3,0xED), o2(0xED,0xD7), o2(0xED,0xDC),
     o2(0xED,0xDB), o2(0xED,0xDA), o2(0xC5,0xB2), o2(0xED,0xDD),
     o2(0xED,0xDE), o2(0xED,0xDF), o2(0xB9,0xEC), o2(0xB7,0xA5),
     o2(0xED,0xE0), o2(0xED,0xE1), o2(0xED,0xE2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_BD = {
    to_SHIFT_JIS_E8_BD_offsets,
    to_EUC_JP_E8_BD_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_BE_infos[19] = {
     o2(0xBF,0xC9), o2(0xED,0xE3), o2(0xBC,0xAD), o2(0xED,0xE4),
     o2(0xED,0xE5), o2(0xD2,0xA1), o2(0xD1,0xFE), o2(0xED,0xE6),
     o2(0xE5,0xF0), o2(0xED,0xE7), o2(0xC3,0xA4), o2(0xBF,0xAB),
     o2(0xC7,0xC0), o2(0xED,0xE8), o2(0xCA,0xD5), o2(0xC4,0xD4),
     o2(0xB9,0xFE), o2(0xC3,0xA9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_BE = {
    to_SHIFT_JIS_E8_BE_offsets,
    to_EUC_JP_E8_BE_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_BF_infos[23] = {
     o2(0xB1,0xAA), o2(0xCB,0xF8), o2(0xBF,0xD7), o2(0xB7,0xDE),
     o2(0xB6,0xE1), o2(0xCA,0xD6), o2(0xED,0xE9), o2(0xED,0xEB),
     o2(0xED,0xEA), o2(0xB2,0xE0), o2(0xC6,0xF6), o2(0xED,0xEC),
     o2(0xC7,0xF7), o2(0xC5,0xB3), o2(0xED,0xED), o2(0xBD,0xD2),
     o2(0xED,0xEF), o2(0xCC,0xC2), o2(0xED,0xFE), o2(0xED,0xF1),
     o2(0xED,0xF2), o2(0xC4,0xC9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8_BF = {
    to_SHIFT_JIS_E8_BF_offsets,
    to_EUC_JP_E8_BF_infos
};

static const struct byte_lookup* const
to_EUC_JP_E8_infos[64] = {
     &to_EUC_JP_E8_80, &to_EUC_JP_E8_81, &to_EUC_JP_E8_82, &to_EUC_JP_E8_83,
     &to_EUC_JP_E8_84, &to_EUC_JP_E8_85, &to_EUC_JP_E8_86, &to_EUC_JP_E8_87,
     &to_EUC_JP_E8_88, &to_EUC_JP_E8_89, &to_EUC_JP_E8_8A, &to_EUC_JP_E8_8B,
     &to_EUC_JP_E8_8C, &to_EUC_JP_E8_8D, &to_EUC_JP_E8_8E, &to_EUC_JP_E8_8F,
     &to_EUC_JP_E8_90, &to_EUC_JP_E8_91, &to_EUC_JP_E8_92, &to_EUC_JP_E8_93,
     &to_EUC_JP_E8_94, &to_EUC_JP_E8_95, &to_EUC_JP_E8_96, &to_EUC_JP_E8_97,
     &to_EUC_JP_E8_98, &to_EUC_JP_E8_99, &to_EUC_JP_E8_9A, &to_EUC_JP_E8_9B,
     &to_EUC_JP_E8_9C, &to_EUC_JP_E8_9D, &to_EUC_JP_E8_9E, &to_EUC_JP_E8_9F,
     &to_EUC_JP_E8_A0, &to_EUC_JP_E8_A1, &to_EUC_JP_E8_A2, &to_EUC_JP_E8_A3,
     &to_EUC_JP_E8_A4, &to_EUC_JP_E8_A5, &to_EUC_JP_E8_A6, &to_EUC_JP_E8_A7,
     &to_EUC_JP_E8_A8, &to_EUC_JP_E8_A9, &to_EUC_JP_E8_AA, &to_EUC_JP_E8_AB,
     &to_EUC_JP_E8_AC, &to_EUC_JP_E8_AD, &to_EUC_JP_E8_AE, &to_EUC_JP_E8_B0,
     &to_EUC_JP_E8_B1, &to_EUC_JP_E8_B2, &to_EUC_JP_E8_B3, &to_EUC_JP_E8_B4,
     &to_EUC_JP_E8_B5, &to_EUC_JP_E8_B6, &to_EUC_JP_E8_B7, &to_EUC_JP_E8_B8,
     &to_EUC_JP_E8_B9, &to_EUC_JP_E8_BA, &to_EUC_JP_E8_BB, &to_EUC_JP_E8_BC,
     &to_EUC_JP_E8_BD, &to_EUC_JP_E8_BE, &to_EUC_JP_E8_BF,            UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E8 = {
    to_SHIFT_JIS_E8_offsets,
    to_EUC_JP_E8_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_80_infos[36] = {
     o2(0xC2,0xE0), o2(0xC1,0xF7), o2(0xC6,0xA8), o2(0xED,0xF0),
     o2(0xB5,0xD5), o2(0xED,0xF9), o2(0xED,0xF6), o2(0xEE,0xA5),
     o2(0xC6,0xA9), o2(0xC3,0xE0), o2(0xED,0xF3), o2(0xC4,0xFE),
     o2(0xC5,0xD3), o2(0xED,0xF4), o2(0xED,0xF8), o2(0xBF,0xE0),
     o2(0xC7,0xE7), o2(0xC4,0xCC), o2(0xC0,0xC2), o2(0xED,0xF7),
     o2(0xC2,0xAE), o2(0xC2,0xA4), o2(0xED,0xF5), o2(0xB0,0xA9),
     o2(0xCF,0xA2), o2(0xED,0xFA), o2(0xC2,0xE1), o2(0xBD,0xB5),
     o2(0xBF,0xCA), o2(0xED,0xFC), o2(0xED,0xFB), o2(0xB0,0xEF),
     o2(0xED,0xFD), o2(0xC9,0xAF), o2(0xEE,0xA7),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_80 = {
    to_SHIFT_JIS_E9_80_offsets,
    to_EUC_JP_E9_80_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_81_infos[41] = {
     o2(0xC6,0xDB), o2(0xBF,0xEB), o2(0xC3,0xD9), o2(0xB6,0xF8),
     o2(0xEE,0xA6), o2(0xCD,0xB7), o2(0xB1,0xBF), o2(0xCA,0xD7),
     o2(0xB2,0xE1), o2(0xEE,0xA1), o2(0xEE,0xA2), o2(0xEE,0xA3),
     o2(0xEE,0xA4), o2(0xC6,0xBB), o2(0xC3,0xA3), o2(0xB0,0xE3),
     o2(0xEE,0xA8), o2(0xEE,0xA9), o2(0xF4,0xA3), o2(0xC2,0xBD),
     o2(0xEE,0xAA), o2(0xB1,0xF3), o2(0xC1,0xCC), o2(0xB8,0xAF),
     o2(0xCD,0xDA), o2(0xFB,0xF9), o2(0xEE,0xAB), o2(0xC5,0xAC),
     o2(0xC1,0xF8), o2(0xBC,0xD7), o2(0xEE,0xAC), o2(0xEE,0xAF),
     o2(0xBD,0xE5), o2(0xEE,0xAD), o2(0xC1,0xAB), o2(0xC1,0xAA),
     o2(0xB0,0xE4), o2(0xCE,0xCB), o2(0xEE,0xB1), o2(0xC8,0xF2),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_81 = {
    to_SHIFT_JIS_E9_81_offsets,
    to_EUC_JP_E9_81_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_82_infos[19] = {
     o2(0xEE,0xB3), o2(0xEE,0xB2), o2(0xEE,0xB0), o2(0xE3,0xE4),
     o2(0xB4,0xD4), o2(0xED,0xEE), o2(0xEE,0xB5), o2(0xEE,0xB4),
     o2(0xEE,0xB6), o2(0xCD,0xB8), o2(0xC6,0xE1), o2(0xCB,0xAE),
     o2(0xEE,0xB7), o2(0xBC,0xD9), o2(0xEE,0xB8), o2(0xEE,0xB9),
     o2(0xEE,0xBA), o2(0xC5,0xA1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_82 = {
    to_SHIFT_JIS_E9_82_offsets,
    to_EUC_JP_E9_82_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_83_infos[14] = {
     o2(0xB0,0xEA), o2(0xB9,0xD9), o2(0xCF,0xBA), o2(0xEE,0xBE),
     o2(0xFB,0xFA), o2(0xB7,0xB4), o2(0xEE,0xBB), o2(0xEE,0xBC),
     o2(0xC9,0xF4), o2(0xB3,0xD4), o2(0xCD,0xB9), o2(0xB6,0xBF),
     o2(0xC5,0xD4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_83 = {
    to_SHIFT_JIS_E9_83_offsets,
    to_EUC_JP_E9_83_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_84_infos[9] = {
     o2(0xEE,0xBF), o2(0xEE,0xC0), o2(0xFB,0xFC), o2(0xEE,0xC1),
     o2(0xFB,0xFD), o2(0xC5,0xA2), o2(0xEE,0xC3), o2(0xEE,0xC2),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_84 = {
    to_SHIFT_JIS_E9_84_offsets,
    to_EUC_JP_E9_84_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_85_infos[22] = {
     o2(0xC6,0xD3), o2(0xEE,0xC4), o2(0xBD,0xB6), o2(0xBC,0xE0),
     o2(0xC7,0xDB), o2(0xC3,0xF1), o2(0xBC,0xF2), o2(0xBF,0xEC),
     o2(0xEE,0xC5), o2(0xEE,0xC6), o2(0xBF,0xDD), o2(0xEE,0xC7),
     o2(0xEE,0xC8), o2(0xEE,0xC9), o2(0xCD,0xEF), o2(0xBD,0xB7),
     o2(0xEE,0xCB), o2(0xEE,0xCA), o2(0xB9,0xDA), o2(0xB9,0xF3),
     o2(0xBB,0xC0),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_85 = {
    to_SHIFT_JIS_E9_85_offsets,
    to_EUC_JP_E9_85_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_86_infos[19] = {
     o2(0xEE,0xCE), o2(0xBD,0xE6), o2(0xEE,0xCD), o2(0xEE,0xCC),
     o2(0xC2,0xE9), o2(0xB8,0xEF), o2(0xC0,0xC3), o2(0xC8,0xB0),
     o2(0xBD,0xB9), o2(0xEE,0xCF), o2(0xBE,0xDF), o2(0xEE,0xD2),
     o2(0xEE,0xD0), o2(0xEE,0xD1), o2(0xEE,0xD4), o2(0xEE,0xD3),
     o2(0xBE,0xFA), o2(0xEE,0xD5),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_86 = {
    to_SHIFT_JIS_E9_86_offsets,
    to_EUC_JP_E9_86_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_87_infos[35] = {
     o2(0xEE,0xD6), o2(0xEE,0xD7), o2(0xC8,0xD0), o2(0xBA,0xD3),
     o2(0xBC,0xE1), o2(0xEE,0xD8), o2(0xEE,0xD9), o2(0xCE,0xA4),
     o2(0xBD,0xC5), o2(0xCC,0xEE), o2(0xCE,0xCC), o2(0xEE,0xDA),
     o2(0xB6,0xE2), o2(0xEE,0xDB), o2(0xFC,0xA1), o2(0xC5,0xA3),
     o2(0xFB,0xFE), o2(0xEE,0xDE), o2(0xB3,0xF8), o2(0xBF,0xCB),
     o2(0xFC,0xA2), o2(0xEE,0xDC), o2(0xEE,0xDD), o2(0xC4,0xE0),
     o2(0xFC,0xA5), o2(0xFC,0xA6), o2(0xCB,0xD5), o2(0xB6,0xFC),
     o2(0xFC,0xA3), o2(0xFC,0xA4), o2(0xEE,0xE0), o2(0xEE,0xE1),
     o2(0xEE,0xDF), o2(0xEE,0xE3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_87 = {
    to_SHIFT_JIS_E9_87_offsets,
    to_EUC_JP_E9_87_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_88_infos[18] = {
     o2(0xFC,0xA7), o2(0xFC,0xA9), o2(0xC6,0xDF), o2(0xB3,0xC3),
     o2(0xFC,0xA8), o2(0xEE,0xE7), o2(0xEE,0xE4), o2(0xEE,0xE6),
     o2(0xEE,0xE2), o2(0xEF,0xCF), o2(0xEE,0xE5), o2(0xCE,0xEB),
     o2(0xB8,0xDA), o2(0xFC,0xB0), o2(0xFC,0xAA), o2(0xFC,0xAC),
     o2(0xEE,0xEF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_88 = {
    to_SHIFT_JIS_E9_88_offsets,
    to_EUC_JP_E9_88_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_89_infos[23] = {
     o2(0xFC,0xAB), o2(0xC5,0xB4), o2(0xEE,0xEA), o2(0xEE,0xED),
     o2(0xEE,0xEB), o2(0xEE,0xF0), o2(0xFC,0xAD), o2(0xEE,0xF1),
     o2(0xFC,0xAF), o2(0xEE,0xE9), o2(0xFC,0xAE), o2(0xEE,0xF6),
     o2(0xB1,0xF4), o2(0xEE,0xE8), o2(0xC8,0xAD), o2(0xEE,0xEC),
     o2(0xBE,0xE0), o2(0xFC,0xB1), o2(0xB9,0xDB), o2(0xFC,0xB3),
     o2(0xFC,0xB4), o2(0xCB,0xC8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_89 = {
    to_SHIFT_JIS_E9_89_offsets,
    to_EUC_JP_E9_89_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_8A_infos[17] = {
     o2(0xB6,0xE4), o2(0xBD,0xC6), o2(0xC6,0xBC), o2(0xF9,0xA4),
     o2(0xC1,0xAD), o2(0xEE,0xF4), o2(0xEE,0xEE), o2(0xEE,0xF3),
     o2(0xCC,0xC3), o2(0xC4,0xB8), o2(0xEE,0xF5), o2(0xEE,0xF2),
     o2(0xFC,0xB2), o2(0xC1,0xAC), o2(0xEE,0xF9), o2(0xEE,0xF8),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_8A = {
    to_SHIFT_JIS_E9_8A_offsets,
    to_EUC_JP_E9_8A_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_8B_infos[22] = {
     o2(0xEE,0xF7), o2(0xFC,0xB8), o2(0xCB,0xAF), o2(0xFC,0xBC),
     o2(0xFC,0xBA), o2(0xFC,0xB6), o2(0xFC,0xB7), o2(0xFC,0xBB),
     o2(0xBD,0xFB), o2(0xFC,0xB5), o2(0xEE,0xFA), o2(0xCA,0xDF),
     o2(0xB1,0xD4), o2(0xC9,0xC6), o2(0xC3,0xF2), o2(0xB5,0xF8),
     o2(0xF9,0xAA), o2(0xEE,0xFC), o2(0xFC,0xBF), o2(0xB9,0xDD),
     o2(0xFC,0xC2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_8B = {
    to_SHIFT_JIS_E9_8B_offsets,
    to_EUC_JP_E9_8B_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_8C_infos[25] = {
     o2(0xFC,0xC4), o2(0xBB,0xAC), o2(0xEE,0xFB), o2(0xBF,0xED),
     o2(0xBF,0xEE), o2(0xEF,0xA1), o2(0xEF,0xA3), o2(0xFC,0xC3),
     o2(0xFC,0xC1), o2(0xBE,0xFB), o2(0xFC,0xBE), o2(0xEF,0xA2),
     o2(0xEF,0xA4), o2(0xFC,0xBD), o2(0xB6,0xD3), o2(0xC9,0xC5),
     o2(0xBC,0xE2), o2(0xCF,0xA3), o2(0xEE,0xFE), o2(0xBA,0xF8),
     o2(0xCF,0xBF), o2(0xEF,0xA6), o2(0xEF,0xA5), o2(0xEF,0xA7),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_8C = {
    to_SHIFT_JIS_E9_8C_offsets,
    to_EUC_JP_E9_8C_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_8D_infos[17] = {
     o2(0xEE,0xFD), o2(0xF9,0xA3), o2(0xC6,0xE9), o2(0xC5,0xD5),
     o2(0xC4,0xD7), o2(0xEF,0xAC), o2(0xFC,0xC6), o2(0xC3,0xC3),
     o2(0xEF,0xA8), o2(0xEF,0xA9), o2(0xB7,0xAD), o2(0xEF,0xAB),
     o2(0xFC,0xC5), o2(0xB8,0xB0), o2(0xEF,0xAA), o2(0xBE,0xE1),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_8D = {
    to_SHIFT_JIS_E9_8D_offsets,
    to_EUC_JP_E9_8D_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_8E_infos[13] = {
     o2(0xB3,0xF9), o2(0xEF,0xB0), o2(0xBA,0xBF), o2(0xC1,0xF9),
     o2(0xC4,0xCA), o2(0xFC,0xC7), o2(0xB3,0xBB), o2(0xEF,0xAE),
     o2(0xEF,0xAF), o2(0xC4,0xC3), o2(0xEF,0xAD), o2(0xEF,0xB1),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_8E = {
    to_SHIFT_JIS_E9_8E_offsets,
    to_EUC_JP_E9_8E_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_8F_infos[16] = {
     o2(0xEF,0xB7), o2(0xFC,0xC8), o2(0xEF,0xBA), o2(0xEF,0xB9),
     o2(0xC5,0xAD), o2(0xEF,0xB2), o2(0xEF,0xB3), o2(0xEF,0xB6),
     o2(0xEF,0xB8), o2(0xFC,0xC9), o2(0xB6,0xC0), o2(0xEF,0xBB),
     o2(0xEF,0xB5), o2(0xEF,0xB4), o2(0xFC,0xCA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_8F = {
    to_SHIFT_JIS_E9_8F_offsets,
    to_EUC_JP_E9_8F_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_90_infos[16] = {
     o2(0xEF,0xBF), o2(0xEF,0xC0), o2(0xEF,0xC1), o2(0xEF,0xBE),
     o2(0xEF,0xBD), o2(0xBE,0xE2), o2(0xC6,0xAA), o2(0xEF,0xBC),
     o2(0xEF,0xC5), o2(0xEF,0xC3), o2(0xFC,0xCB), o2(0xEF,0xC4),
     o2(0xEF,0xC2), o2(0xC2,0xF8), o2(0xEF,0xC6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_90 = {
    to_SHIFT_JIS_E9_90_offsets,
    to_EUC_JP_E9_90_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_91_infos[21] = {
     o2(0xEF,0xC7), o2(0xEF,0xC9), o2(0xFC,0xCC), o2(0xFC,0xCD),
     o2(0xB4,0xD5), o2(0xEF,0xC8), o2(0xCC,0xFA), o2(0xEF,0xD4),
     o2(0xEF,0xCA), o2(0xEF,0xCD), o2(0xEF,0xCB), o2(0xEF,0xCC),
     o2(0xEF,0xCE), o2(0xEF,0xD0), o2(0xEF,0xD1), o2(0xEF,0xD2),
     o2(0xEF,0xD5), o2(0xEF,0xD3), o2(0xEF,0xD6), o2(0xEF,0xD8),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_91 = {
    to_SHIFT_JIS_E9_91_offsets,
    to_EUC_JP_E9_91_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_92_infos[2] = {
     o2(0xEF,0xD7),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_92 = {
    to_SHIFT_JIS_E9_92_offsets,
    to_EUC_JP_E9_92_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_95_infos[2] = {
     o2(0xC4,0xB9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_95 = {
    to_SHIFT_JIS_E9_95_offsets,
    to_EUC_JP_E9_95_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_96_infos[29] = {
     o2(0xCC,0xE7), o2(0xEF,0xD9), o2(0xC1,0xAE), o2(0xEF,0xDA),
     o2(0xCA,0xC4), o2(0xEF,0xDB), o2(0xB3,0xAB), o2(0xB1,0xBC),
     o2(0xB4,0xD7), o2(0xFC,0xCE), o2(0xB4,0xD6), o2(0xEF,0xDC),
     o2(0xEF,0xDD), o2(0xEF,0xDE), o2(0xEF,0xDF), o2(0xEF,0xE0),
     o2(0xB4,0xD8), o2(0xB3,0xD5), o2(0xB9,0xDE), o2(0xC8,0xB6),
     o2(0xEF,0xE2), o2(0xEF,0xE1), o2(0xEF,0xE3), o2(0xB1,0xDC),
     o2(0xEF,0xE6), o2(0xEF,0xE5), o2(0xEF,0xE4), o2(0xEF,0xE7),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_96 = {
    to_SHIFT_JIS_E9_96_offsets,
    to_EUC_JP_E9_96_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_97_infos[14] = {
     o2(0xEF,0xEA), o2(0xB0,0xC7), o2(0xEF,0xE8), o2(0xEF,0xEC),
     o2(0xEF,0xEB), o2(0xEF,0xEE), o2(0xEF,0xED), o2(0xEF,0xEF),
     o2(0xC6,0xAE), o2(0xEF,0xF0), o2(0xEF,0xF1), o2(0xEF,0xF3),
     o2(0xEF,0xF2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_97 = {
    to_SHIFT_JIS_E9_97_offsets,
    to_EUC_JP_E9_97_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_98_infos[10] = {
     o2(0xC9,0xEC), o2(0xEF,0xF4), o2(0xEF,0xF5), o2(0xBA,0xE5),
     o2(0xEF,0xF6), o2(0xEF,0xF7), o2(0xCB,0xC9), o2(0xC1,0xCB),
     o2(0xB0,0xA4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_98 = {
    to_SHIFT_JIS_E9_98_offsets,
    to_EUC_JP_E9_98_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_99_infos[30] = {
     o2(0xC2,0xCB), o2(0xEF,0xF8), o2(0xC9,0xED), o2(0xEF,0xFB),
     o2(0xEF,0xF9), o2(0xB9,0xDF), o2(0xEF,0xFA), o2(0xB8,0xC2),
     o2(0xCA,0xC5), o2(0xEF,0xFD), o2(0xF0,0xA1), o2(0xEF,0xFE),
     o2(0xF0,0xA2), o2(0xB1,0xA1), o2(0xBF,0xD8), o2(0xBD,0xFC),
     o2(0xB4,0xD9), o2(0xF0,0xA3), o2(0xC7,0xE6), o2(0xF0,0xA5),
     o2(0xB1,0xA2), o2(0xF0,0xA4), o2(0xC4,0xC4), o2(0xCE,0xCD),
     o2(0xC6,0xAB), o2(0xEF,0xFC), o2(0xCE,0xA6), o2(0xB8,0xB1),
     o2(0xCD,0xDB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_99 = {
    to_SHIFT_JIS_E9_99_offsets,
    to_EUC_JP_E9_99_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_9A_infos[33] = {
     o2(0xB6,0xF9), o2(0xCE,0xB4), o2(0xB7,0xA8), o2(0xC2,0xE2),
     o2(0xE7,0xA1), o2(0xF0,0xA6), o2(0xB3,0xAC), o2(0xBF,0xEF),
     o2(0xB3,0xD6), o2(0xF0,0xA8), o2(0xF0,0xA9), o2(0xF0,0xA7),
     o2(0xB7,0xE4), o2(0xBA,0xDD), o2(0xBE,0xE3), o2(0xFC,0xD1),
     o2(0xB1,0xA3), o2(0xCE,0xD9), o2(0xF0,0xAB), o2(0xEE,0xAE),
     o2(0xF0,0xAA), o2(0xFC,0xD2), o2(0xF0,0xAE), o2(0xF0,0xAC),
     o2(0xF0,0xAD), o2(0xF0,0xAF), o2(0xF0,0xB0), o2(0xCE,0xEC),
     o2(0xF0,0xB1), o2(0xF0,0xB2), o2(0xC0,0xC9), o2(0xC8,0xBB),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_9A = {
    to_SHIFT_JIS_E9_9A_offsets,
    to_EUC_JP_E9_9A_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_9B_infos[29] = {
     o2(0xBF,0xFD), o2(0xB4,0xE7), o2(0xCD,0xBA), o2(0xB2,0xED),
     o2(0xBD,0xB8), o2(0xB8,0xDB), o2(0xF0,0xB5), o2(0xF0,0xB4),
     o2(0xBB,0xF3), o2(0xF0,0xB6), o2(0xF0,0xB3), o2(0xBB,0xA8),
     o2(0xF0,0xBA), o2(0xEA,0xAD), o2(0xD2,0xD6), o2(0xBF,0xF7),
     o2(0xF0,0xB8), o2(0xCE,0xA5), o2(0xC6,0xF1), o2(0xB1,0xAB),
     o2(0xC0,0xE3), o2(0xBC,0xB6), o2(0xCA,0xB7), o2(0xB1,0xC0),
     o2(0xCE,0xED), o2(0xCD,0xEB), o2(0xF0,0xBB), o2(0xC5,0xC5),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_9B = {
    to_SHIFT_JIS_E9_9B_offsets,
    to_EUC_JP_E9_9B_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_9C_infos[27] = {
     o2(0xBC,0xFB), o2(0xF0,0xBC), o2(0xF0,0xBD), o2(0xBF,0xCC),
     o2(0xF0,0xBE), o2(0xCE,0xEE), o2(0xF0,0xB9), o2(0xF0,0xC0),
     o2(0xF0,0xC2), o2(0xF0,0xC1), o2(0xF0,0xBF), o2(0xF0,0xC3),
     o2(0xF0,0xC4), o2(0xC1,0xFA), o2(0xB2,0xE2), o2(0xF0,0xC5),
     o2(0xCC,0xB8), o2(0xF0,0xC6), o2(0xF0,0xC7), o2(0xCF,0xAA),
     o2(0xFC,0xD3), o2(0xDB,0xB1), o2(0xF0,0xC8), o2(0xFC,0xD4),
     o2(0xF0,0xC9), o2(0xF0,0xCA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_9C = {
    to_SHIFT_JIS_E9_9C_offsets,
    to_EUC_JP_E9_9C_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_9D_infos[30] = {
     o2(0xF0,0xCE), o2(0xFC,0xD5), o2(0xF0,0xCB), o2(0xF0,0xCC),
     o2(0xF0,0xCD), o2(0xF0,0xCF), o2(0xFC,0xD6), o2(0xFC,0xD7),
     o2(0xFC,0xD8), o2(0xC0,0xC4), o2(0xFC,0xD9), o2(0xCC,0xF7),
     o2(0xC0,0xC5), o2(0xF0,0xD0), o2(0xC8,0xF3), o2(0xF0,0xD1),
     o2(0xF3,0xD3), o2(0xCC,0xCC), o2(0xF0,0xD2), o2(0xF0,0xD3),
     o2(0xF0,0xD4), o2(0xB3,0xD7), o2(0xF0,0xD6), o2(0xBF,0xD9),
     o2(0xF0,0xD7), o2(0xB7,0xA4), o2(0xF0,0xD8), o2(0xF0,0xDC),
     o2(0xF0,0xDA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_9D = {
    to_SHIFT_JIS_E9_9D_offsets,
    to_EUC_JP_E9_9D_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_9E_infos[19] = {
     o2(0xF0,0xDB), o2(0xB3,0xF3), o2(0xF0,0xD9), o2(0xF0,0xDD),
     o2(0xF0,0xDE), o2(0xB0,0xC8), o2(0xF0,0xDF), o2(0xF0,0xE0),
     o2(0xBE,0xE4), o2(0xF0,0xE1), o2(0xB5,0xC7), o2(0xF0,0xE4),
     o2(0xF0,0xE3), o2(0xF0,0xE2), o2(0xEB,0xF1), o2(0xCA,0xDC),
     o2(0xF0,0xE5), o2(0xF0,0xE6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_9E = {
    to_SHIFT_JIS_E9_9E_offsets,
    to_EUC_JP_E9_9E_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_9F_infos[15] = {
     o2(0xF0,0xE7), o2(0xF0,0xE8), o2(0xF0,0xE9), o2(0xF0,0xEA),
     o2(0xB4,0xDA), o2(0xF0,0xEB), o2(0xF0,0xEC), o2(0xC7,0xA3),
     o2(0xF0,0xEE), o2(0xB2,0xBB), o2(0xF0,0xF1), o2(0xF0,0xF0),
     o2(0xB1,0xA4), o2(0xB6,0xC1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_9F = {
    to_SHIFT_JIS_E9_9F_offsets,
    to_EUC_JP_E9_9F_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_A0_infos[26] = {
     o2(0xCA,0xC7), o2(0xC4,0xBA), o2(0xBA,0xA2), o2(0xB9,0xE0),
     o2(0xBD,0xE7), o2(0xBF,0xDC), o2(0xF0,0xF3), o2(0xF0,0xF2),
     o2(0xCD,0xC2), o2(0xB4,0xE8), o2(0xC8,0xD2), o2(0xC6,0xDC),
     o2(0xBF,0xFC), o2(0xCE,0xCE), o2(0xB7,0xDB), o2(0xF0,0xF6),
     o2(0xF0,0xF5), o2(0xCB,0xCB), o2(0xC6,0xAC), o2(0xB1,0xD0),
     o2(0xF0,0xF7), o2(0xF0,0xF4), o2(0xC9,0xD1), o2(0xCD,0xEA),
     o2(0xF0,0xF8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_A0 = {
    to_SHIFT_JIS_E9_A0_offsets,
    to_EUC_JP_E9_A0_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_A1_infos[21] = {
     o2(0xF0,0xF9), o2(0xF0,0xFB), o2(0xC2,0xEA), o2(0xB3,0xDB),
     o2(0xB3,0xDC), o2(0xF0,0xFA), o2(0xB4,0xE9), o2(0xB8,0xB2),
     o2(0xFC,0xDA), o2(0xB4,0xEA), o2(0xC5,0xBF), o2(0xCE,0xE0),
     o2(0xFC,0xDB), o2(0xB8,0xDC), o2(0xF0,0xFC), o2(0xF0,0xFD),
     o2(0xF0,0xFE), o2(0xF1,0xA1), o2(0xF1,0xA3), o2(0xF1,0xA2),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_A1 = {
    to_SHIFT_JIS_E9_A1_offsets,
    to_EUC_JP_E9_A1_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_A2_infos[6] = {
     o2(0xC9,0xF7), o2(0xF1,0xA4), o2(0xF1,0xA5), o2(0xF1,0xA6),
     o2(0xF1,0xA7),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_A2 = {
    to_SHIFT_JIS_E9_A2_offsets,
    to_EUC_JP_E9_A2_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_A3_infos[18] = {
     o2(0xF1,0xA9), o2(0xF1,0xA8), o2(0xF1,0xAA), o2(0xC8,0xF4),
     o2(0xE6,0xCC), o2(0xBF,0xA9), o2(0xB5,0xB2), o2(0xF1,0xAB),
     o2(0xF1,0xAC), o2(0xD2,0xAC), o2(0xDD,0xBB), o2(0xC8,0xD3),
     o2(0xB0,0xFB), o2(0xB0,0xBB), o2(0xBB,0xF4), o2(0xCB,0xB0),
     o2(0xBE,0xFE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_A3 = {
    to_SHIFT_JIS_E9_A3_offsets,
    to_EUC_JP_E9_A3_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_A4_infos[22] = {
     o2(0xF1,0xAD), o2(0xCC,0xDF), o2(0xF1,0xAE), o2(0xCD,0xDC),
     o2(0xB1,0xC2), o2(0xBB,0xC1), o2(0xF1,0xAF), o2(0xB2,0xEE),
     o2(0xF1,0xB0), o2(0xF1,0xB1), o2(0xF1,0xB3), o2(0xF1,0xB4),
     o2(0xF1,0xB6), o2(0xF1,0xB2), o2(0xF1,0xB5), o2(0xFC,0xDE),
     o2(0xB4,0xDB), o2(0xF1,0xB7), o2(0xF1,0xB8), o2(0xF1,0xB9),
     o2(0xF1,0xBA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_A4 = {
    to_SHIFT_JIS_E9_A4_offsets,
    to_EUC_JP_E9_A4_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_A5_infos[11] = {
     o2(0xF1,0xBB), o2(0xF1,0xBD), o2(0xF1,0xBC), o2(0xF1,0xBF),
     o2(0xF1,0xC2), o2(0xF1,0xBE), o2(0xF1,0xC0), o2(0xF1,0xC1),
     o2(0xF1,0xC3), o2(0xB6,0xC2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_A5 = {
    to_SHIFT_JIS_E9_A5_offsets,
    to_EUC_JP_E9_A5_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_A6_infos[14] = {
     o2(0xBC,0xF3), o2(0xF1,0xC4), o2(0xF1,0xC5), o2(0xB9,0xE1),
     o2(0xFC,0xE0), o2(0xF1,0xC6), o2(0xB3,0xBE), o2(0xC7,0xCF),
     o2(0xF1,0xC7), o2(0xF1,0xC8), o2(0xC3,0xDA), o2(0xC6,0xEB),
     o2(0xF1,0xC9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_A6 = {
    to_SHIFT_JIS_E9_A6_offsets,
    to_EUC_JP_E9_A6_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_A7_infos[22] = {
     o2(0xC7,0xFD), o2(0xC2,0xCC), o2(0xB1,0xD8), o2(0xB6,0xEE),
     o2(0xB6,0xEF), o2(0xC3,0xF3), o2(0xF1,0xCE), o2(0xB6,0xF0),
     o2(0xB2,0xEF), o2(0xF1,0xCD), o2(0xF1,0xCB), o2(0xF1,0xCC),
     o2(0xF1,0xCA), o2(0xF1,0xD8), o2(0xF1,0xCF), o2(0xF1,0xD0),
     o2(0xF1,0xD1), o2(0xF1,0xD2), o2(0xF1,0xD4), o2(0xF1,0xD3),
     o2(0xBD,0xD9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_A7 = {
    to_SHIFT_JIS_E9_A7_offsets,
    to_EUC_JP_E9_A7_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_A8_infos[13] = {
     o2(0xF1,0xD5), o2(0xF1,0xD7), o2(0xB5,0xB3), o2(0xF1,0xD6),
     o2(0xC1,0xFB), o2(0xB8,0xB3), o2(0xF1,0xD9), o2(0xC2,0xCD),
     o2(0xF1,0xDA), o2(0xC6,0xAD), o2(0xF1,0xDB), o2(0xF1,0xE0),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_A8 = {
    to_SHIFT_JIS_E9_A8_offsets,
    to_EUC_JP_E9_A8_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_A9_infos[18] = {
     o2(0xF1,0xDE), o2(0xF1,0xDD), o2(0xF1,0xDF), o2(0xF1,0xDC),
     o2(0xF1,0xE2), o2(0xFC,0xE1), o2(0xF1,0xE1), o2(0xF1,0xE4),
     o2(0xB6,0xC3), o2(0xF1,0xE3), o2(0xF1,0xE5), o2(0xF1,0xE6),
     o2(0xF1,0xE8), o2(0xF1,0xE7), o2(0xF1,0xE9), o2(0xF1,0xEB),
     o2(0xF1,0xEA),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_A9 = {
    to_SHIFT_JIS_E9_A9_offsets,
    to_EUC_JP_E9_A9_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_AA_infos[6] = {
     o2(0xB9,0xFC), o2(0xF1,0xEC), o2(0xF1,0xED), o2(0xB3,0xBC),
     o2(0xF1,0xEE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_AA = {
    to_SHIFT_JIS_E9_AA_offsets,
    to_EUC_JP_E9_AA_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_AB_infos[24] = {
     o2(0xF1,0xEF), o2(0xBF,0xF1), o2(0xF1,0xF0), o2(0xF1,0xF1),
     o2(0xF1,0xF2), o2(0xF1,0xF3), o2(0xB9,0xE2), o2(0xFC,0xE2),
     o2(0xFC,0xE3), o2(0xF1,0xF4), o2(0xF1,0xF5), o2(0xF1,0xF6),
     o2(0xF1,0xF7), o2(0xF1,0xF8), o2(0xC8,0xB1), o2(0xF1,0xFA),
     o2(0xC9,0xA6), o2(0xF1,0xFB), o2(0xF1,0xF9), o2(0xF1,0xFD),
     o2(0xF1,0xFC), o2(0xF1,0xFE), o2(0xF2,0xA1),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_AB = {
    to_SHIFT_JIS_E9_AB_offsets,
    to_EUC_JP_E9_AB_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_AC_infos[18] = {
     o2(0xF2,0xA2), o2(0xF2,0xA3), o2(0xF2,0xA4), o2(0xF2,0xA5),
     o2(0xF2,0xA6), o2(0xF2,0xA7), o2(0xF2,0xA8), o2(0xF2,0xA9),
     o2(0xF2,0xAA), o2(0xF2,0xAB), o2(0xF2,0xAC), o2(0xF2,0xAD),
     o2(0xF2,0xAE), o2(0xDD,0xB5), o2(0xF2,0xAF), o2(0xE4,0xF8),
     o2(0xB5,0xB4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_AC = {
    to_SHIFT_JIS_E9_AC_offsets,
    to_EUC_JP_E9_AC_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_AD_infos[17] = {
     o2(0xB3,0xA1), o2(0xBA,0xB2), o2(0xF2,0xB1), o2(0xF2,0xB0),
     o2(0xCC,0xA5), o2(0xF2,0xB3), o2(0xF2,0xB4), o2(0xF2,0xB2),
     o2(0xF2,0xB5), o2(0xCB,0xE2), o2(0xF2,0xB6), o2(0xB5,0xFB),
     o2(0xCF,0xA5), o2(0xFC,0xE5), o2(0xF2,0xB7), o2(0xFC,0xE4),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_AD = {
    to_SHIFT_JIS_E9_AD_offsets,
    to_EUC_JP_E9_AD_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_AE_infos[20] = {
     o2(0xF2,0xB9), o2(0xB0,0xBE), o2(0xFC,0xE6), o2(0xF2,0xBA),
     o2(0xCA,0xAB), o2(0xF2,0xB8), o2(0xF2,0xBB), o2(0xF2,0xBC),
     o2(0xF2,0xBD), o2(0xF2,0xBE), o2(0xF2,0xBF), o2(0xCB,0xEE),
     o2(0xBB,0xAD), o2(0xBA,0xFA), o2(0xC1,0xAF), o2(0xFC,0xE7),
     o2(0xF2,0xC0), o2(0xF2,0xC3), o2(0xFC,0xE8),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_AE = {
    to_SHIFT_JIS_E9_AE_offsets,
    to_EUC_JP_E9_AE_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_AF_infos[20] = {
     o2(0xF2,0xC1), o2(0xF2,0xC4), o2(0xB8,0xF1), o2(0xF2,0xC2),
     o2(0xF2,0xC5), o2(0xF2,0xC6), o2(0xF2,0xC7), o2(0xF2,0xCB),
     o2(0xBB,0xAA), o2(0xC2,0xE4), o2(0xF2,0xCC), o2(0xF2,0xC9),
     o2(0xF2,0xC8), o2(0xF2,0xCA), o2(0xB7,0xDF), o2(0xF2,0xD0),
     o2(0xF2,0xCF), o2(0xF2,0xCE), o2(0xB0,0xB3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_AF = {
    to_SHIFT_JIS_E9_AF_offsets,
    to_EUC_JP_E9_AF_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_B0_infos[27] = {
     o2(0xFC,0xE9), o2(0xF2,0xDA), o2(0xF2,0xD6), o2(0xF2,0xD7),
     o2(0xF2,0xD3), o2(0xF2,0xD9), o2(0xF2,0xD5), o2(0xB3,0xE2),
     o2(0xCF,0xCC), o2(0xF2,0xD8), o2(0xF2,0xD4), o2(0xF2,0xD2),
     o2(0xF2,0xD1), o2(0xF2,0xDC), o2(0xF2,0xDF), o2(0xF2,0xDE),
     o2(0xF2,0xDD), o2(0xC9,0xC9), o2(0xF2,0xDB), o2(0xB0,0xF3),
     o2(0xF2,0xE0), o2(0xF2,0xE2), o2(0xB3,0xEF), o2(0xF2,0xCD),
     o2(0xB1,0xB7), o2(0xF2,0xE4),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_B0 = {
    to_SHIFT_JIS_E9_B0_offsets,
    to_EUC_JP_E9_B0_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_B1_infos[11] = {
     o2(0xF2,0xE3), o2(0xF2,0xE1), o2(0xC3,0xAD), o2(0xCB,0xF0),
     o2(0xCE,0xDA), o2(0xF2,0xE5), o2(0xF2,0xE6), o2(0xF2,0xE7),
     o2(0xF2,0xE8), o2(0xF2,0xE9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_B1 = {
    to_SHIFT_JIS_E9_B1_offsets,
    to_EUC_JP_E9_B1_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_B3_infos[10] = {
     o2(0xC4,0xBB), o2(0xF2,0xEA), o2(0xC8,0xB7), o2(0xF2,0xEF),
     o2(0xF2,0xEB), o2(0xF2,0xEC), o2(0xCB,0xB1), o2(0xCC,0xC4),
     o2(0xC6,0xD0),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_B3 = {
    to_SHIFT_JIS_E9_B3_offsets,
    to_EUC_JP_E9_B3_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_B4_infos[20] = {
     o2(0xF2,0xF0), o2(0xF2,0xF1), o2(0xC6,0xBE), o2(0xF2,0xEE),
     o2(0xF2,0xED), o2(0xB2,0xAA), o2(0xF2,0xF9), o2(0xF2,0xF8),
     o2(0xB1,0xF5), o2(0xF2,0xF6), o2(0xF2,0xF5), o2(0xF2,0xF3),
     o2(0xB3,0xFB), o2(0xF2,0xF2), o2(0xBC,0xB2), o2(0xB2,0xA9),
     o2(0xB9,0xE3), o2(0xF2,0xFC), o2(0xF2,0xFB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_B4 = {
    to_SHIFT_JIS_E9_B4_offsets,
    to_EUC_JP_E9_B4_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_B5_infos[20] = {
     o2(0xF2,0xFA), o2(0xF2,0xF7), o2(0xF2,0xFD), o2(0xF2,0xFE),
     o2(0xF3,0xA5), o2(0xF3,0xA4), o2(0xF3,0xA6), o2(0xB1,0xAD),
     o2(0xF3,0xA1), o2(0xF3,0xA2), o2(0xB9,0xF4), o2(0xCC,0xB9),
     o2(0xF3,0xA3), o2(0xFC,0xEB), o2(0xCB,0xB2), o2(0xF3,0xAB),
     o2(0xFC,0xEA), o2(0xF3,0xA7), o2(0xF3,0xAC),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_B5 = {
    to_SHIFT_JIS_E9_B5_offsets,
    to_EUC_JP_E9_B5_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_B6_infos[14] = {
     o2(0xF3,0xA9), o2(0xF3,0xA8), o2(0xB7,0xDC), o2(0xF3,0xAD),
     o2(0xF3,0xAE), o2(0xF3,0xAF), o2(0xF3,0xAA), o2(0xF2,0xF4),
     o2(0xF3,0xB0), o2(0xC4,0xE1), o2(0xF3,0xB4), o2(0xF3,0xB5),
     o2(0xF3,0xB3),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_B6 = {
    to_SHIFT_JIS_E9_B6_offsets,
    to_EUC_JP_E9_B6_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_B7_infos[16] = {
     o2(0xF3,0xB2), o2(0xF3,0xB8), o2(0xF3,0xB1), o2(0xF3,0xB6),
     o2(0xF3,0xB7), o2(0xF3,0xBA), o2(0xF3,0xB9), o2(0xF3,0xBC),
     o2(0xF3,0xBD), o2(0xF3,0xBE), o2(0xCF,0xC9), o2(0xF3,0xBB),
     o2(0xC2,0xEB), o2(0xBA,0xED), o2(0xF3,0xBF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_B7 = {
    to_SHIFT_JIS_E9_B7_offsets,
    to_EUC_JP_E9_B7_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_B8_infos[5] = {
     o2(0xFC,0xED), o2(0xF3,0xC0), o2(0xF3,0xC1), o2(0xF3,0xC2),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_B8 = {
    to_SHIFT_JIS_E9_B8_offsets,
    to_EUC_JP_E9_B8_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_B9_infos[6] = {
     o2(0xF3,0xC3), o2(0xB8,0xB4), o2(0xF3,0xC4), o2(0xF3,0xC5),
     o2(0xBC,0xAF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_B9 = {
    to_SHIFT_JIS_E9_B9_offsets,
    to_EUC_JP_E9_B9_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_BA_infos[24] = {
     o2(0xF3,0xC6), o2(0xF3,0xC7), o2(0xF3,0xC8), o2(0xF3,0xC9),
     o2(0xF3,0xCC), o2(0xF3,0xCA), o2(0xCF,0xBC), o2(0xF3,0xCB),
     o2(0xCE,0xEF), o2(0xF3,0xCD), o2(0xCE,0xDB), o2(0xF3,0xCE),
     o2(0xC7,0xFE), o2(0xF3,0xCF), o2(0xF3,0xD1), o2(0xF3,0xD2),
     o2(0xF3,0xD0), o2(0xB9,0xED), o2(0xCC,0xCD), o2(0xCB,0xE3),
     o2(0xD6,0xF7), o2(0xDD,0xE0), o2(0xCB,0xFB),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_BA = {
    to_SHIFT_JIS_E9_BA_offsets,
    to_EUC_JP_E9_BA_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_BB_infos[27] = {
     o2(0xB2,0xAB), o2(0xF3,0xD4), o2(0xB5,0xD0), o2(0xF3,0xD5),
     o2(0xF3,0xD6), o2(0xF3,0xD7), o2(0xFC,0xEE), o2(0xB9,0xF5),
     o2(0xF3,0xD8), o2(0xE0,0xD4), o2(0xCC,0xDB), o2(0xC2,0xE3),
     o2(0xF3,0xD9), o2(0xF3,0xDB), o2(0xF3,0xDA), o2(0xF3,0xDC),
     o2(0xF3,0xDD), o2(0xF3,0xDE), o2(0xF3,0xDF), o2(0xF3,0xE0),
     o2(0xF3,0xE1), o2(0xF3,0xE2), o2(0xF3,0xE3), o2(0xF3,0xE4),
     o2(0xF3,0xE5), o2(0xF3,0xE6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_BB = {
    to_SHIFT_JIS_E9_BB_offsets,
    to_EUC_JP_E9_BB_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_BC_infos[11] = {
     o2(0xF3,0xE7), o2(0xF3,0xE8), o2(0xC5,0xA4), o2(0xB8,0xDD),
     o2(0xF3,0xEA), o2(0xC1,0xCD), o2(0xF3,0xEB), o2(0xF3,0xEC),
     o2(0xC9,0xA1), o2(0xF3,0xED),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_BC = {
    to_SHIFT_JIS_E9_BC_offsets,
    to_EUC_JP_E9_BC_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_BD_infos[19] = {
     o2(0xF3,0xEE), o2(0xE3,0xB7), o2(0xEC,0xDA), o2(0xF0,0xED),
     o2(0xF3,0xEF), o2(0xF3,0xF0), o2(0xF3,0xF2), o2(0xF3,0xF3),
     o2(0xF3,0xF4), o2(0xCE,0xF0), o2(0xF3,0xF1), o2(0xF3,0xF5),
     o2(0xF3,0xF6), o2(0xF3,0xF8), o2(0xF3,0xF7), o2(0xF3,0xFA),
     o2(0xF3,0xFB), o2(0xF3,0xF9),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_BD = {
    to_SHIFT_JIS_E9_BD_offsets,
    to_EUC_JP_E9_BD_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_BE_infos[6] = {
     o2(0xCE,0xB6), o2(0xF3,0xFC), o2(0xF3,0xFD), o2(0xE3,0xD4),
     o2(0xF3,0xFE),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9_BE = {
    to_SHIFT_JIS_E9_BE_offsets,
    to_EUC_JP_E9_BE_infos
};

static const struct byte_lookup* const
to_EUC_JP_E9_infos[61] = {
     &to_EUC_JP_E9_80, &to_EUC_JP_E9_81, &to_EUC_JP_E9_82, &to_EUC_JP_E9_83,
     &to_EUC_JP_E9_84, &to_EUC_JP_E9_85, &to_EUC_JP_E9_86, &to_EUC_JP_E9_87,
     &to_EUC_JP_E9_88, &to_EUC_JP_E9_89, &to_EUC_JP_E9_8A, &to_EUC_JP_E9_8B,
     &to_EUC_JP_E9_8C, &to_EUC_JP_E9_8D, &to_EUC_JP_E9_8E, &to_EUC_JP_E9_8F,
     &to_EUC_JP_E9_90, &to_EUC_JP_E9_91, &to_EUC_JP_E9_92, &to_EUC_JP_E9_95,
     &to_EUC_JP_E9_96, &to_EUC_JP_E9_97, &to_EUC_JP_E9_98, &to_EUC_JP_E9_99,
     &to_EUC_JP_E9_9A, &to_EUC_JP_E9_9B, &to_EUC_JP_E9_9C, &to_EUC_JP_E9_9D,
     &to_EUC_JP_E9_9E, &to_EUC_JP_E9_9F, &to_EUC_JP_E9_A0, &to_EUC_JP_E9_A1,
     &to_EUC_JP_E9_A2, &to_EUC_JP_E9_A3, &to_EUC_JP_E9_A4, &to_EUC_JP_E9_A5,
     &to_EUC_JP_E9_A6, &to_EUC_JP_E9_A7, &to_EUC_JP_E9_A8, &to_EUC_JP_E9_A9,
     &to_EUC_JP_E9_AA, &to_EUC_JP_E9_AB, &to_EUC_JP_E9_AC, &to_EUC_JP_E9_AD,
     &to_EUC_JP_E9_AE, &to_EUC_JP_E9_AF, &to_EUC_JP_E9_B0, &to_EUC_JP_E9_B1,
     &to_EUC_JP_E9_B3, &to_EUC_JP_E9_B4, &to_EUC_JP_E9_B5, &to_EUC_JP_E9_B6,
     &to_EUC_JP_E9_B7, &to_EUC_JP_E9_B8, &to_EUC_JP_E9_B9, &to_EUC_JP_E9_BA,
     &to_EUC_JP_E9_BB, &to_EUC_JP_E9_BC, &to_EUC_JP_E9_BD, &to_EUC_JP_E9_BE,
                UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_E9 = {
    to_SHIFT_JIS_E9_offsets,
    to_EUC_JP_E9_infos
};

static const struct byte_lookup* const
to_EUC_JP_EF_A4_infos[2] = {
     o2(0xFA,0xC6),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_EF_A4 = {
    to_SHIFT_JIS_EF_A4_offsets,
    to_EUC_JP_EF_A4_infos
};

static const struct byte_lookup* const
to_EUC_JP_EF_A7_infos[2] = {
     o2(0xFC,0xCF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_EF_A7 = {
    to_SHIFT_JIS_EF_A7_offsets,
    to_EUC_JP_EF_A7_infos
};

static const struct byte_lookup* const
to_EUC_JP_EF_A8_infos[33] = {
     o2(0xF9,0xD4), o2(0xF9,0xDF), o2(0xF9,0xE0), o2(0xF9,0xF5),
     o2(0xFA,0xBE), o2(0xFA,0xCE), o2(0xFA,0xD0), o2(0xFA,0xFB),
     o2(0xFB,0xA3), o2(0xFB,0xBA), o2(0xFB,0xC2), o2(0xFB,0xC3),
     o2(0xFB,0xC4), o2(0xFB,0xC6), o2(0xFB,0xCA), o2(0xFB,0xCD),
     o2(0xFB,0xD6), o2(0xFB,0xE1), o2(0xFB,0xE3), o2(0xFB,0xE4),
     o2(0xFB,0xED), o2(0xFB,0xF5), o2(0xFB,0xF7), o2(0xFB,0xF8),
     o2(0xFB,0xFB), o2(0xFC,0xB9), o2(0xFC,0xC0), o2(0xFC,0xD0),
     o2(0xFC,0xDC), o2(0xFC,0xDD), o2(0xFC,0xDF), o2(0xFC,0xEC),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_EF_A8 = {
    to_SHIFT_JIS_EF_A8_offsets,
    to_EUC_JP_EF_A8_infos
};

static const struct byte_lookup* const
to_EUC_JP_EF_BC_infos[62] = {
     o2(0xA1,0xAA), o2(0xFC,0xFE), o2(0xA1,0xF4), o2(0xA1,0xF0),
     o2(0xA1,0xF3), o2(0xA1,0xF5), o2(0xFC,0xFD), o2(0xA1,0xCA),
     o2(0xA1,0xCB), o2(0xA1,0xF6), o2(0xA1,0xDC), o2(0xA1,0xA5),
     o2(0xA1,0xBF), o2(0xA3,0xB0), o2(0xA3,0xB1), o2(0xA3,0xB2),
     o2(0xA3,0xB3), o2(0xA3,0xB4), o2(0xA3,0xB5), o2(0xA3,0xB6),
     o2(0xA3,0xB7), o2(0xA3,0xB8), o2(0xA3,0xB9), o2(0xA1,0xA7),
     o2(0xA1,0xA8), o2(0xA1,0xE3), o2(0xA1,0xE1), o2(0xA1,0xE4),
     o2(0xA1,0xA9), o2(0xA1,0xF7), o2(0xA3,0xC1), o2(0xA3,0xC2),
     o2(0xA3,0xC3), o2(0xA3,0xC4), o2(0xA3,0xC5), o2(0xA3,0xC6),
     o2(0xA3,0xC7), o2(0xA3,0xC8), o2(0xA3,0xC9), o2(0xA3,0xCA),
     o2(0xA3,0xCB), o2(0xA3,0xCC), o2(0xA3,0xCD), o2(0xA3,0xCE),
     o2(0xA3,0xCF), o2(0xA3,0xD0), o2(0xA3,0xD1), o2(0xA3,0xD2),
     o2(0xA3,0xD3), o2(0xA3,0xD4), o2(0xA3,0xD5), o2(0xA3,0xD6),
     o2(0xA3,0xD7), o2(0xA3,0xD8), o2(0xA3,0xD9), o2(0xA3,0xDA),
     o2(0xA1,0xCE), o2(0xA1,0xC0), o2(0xA1,0xCF), o2(0xA1,0xB0),
     o2(0xA1,0xB2),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_EF_BC = {
    to_SHIFT_JIS_EF_BC_offsets,
    to_EUC_JP_EF_BC_infos
};

static const struct byte_lookup* const
to_EUC_JP_EF_BD_infos[62] = {
     o2(0xA1,0xAE), o2(0xA3,0xE1), o2(0xA3,0xE2), o2(0xA3,0xE3),
     o2(0xA3,0xE4), o2(0xA3,0xE5), o2(0xA3,0xE6), o2(0xA3,0xE7),
     o2(0xA3,0xE8), o2(0xA3,0xE9), o2(0xA3,0xEA), o2(0xA3,0xEB),
     o2(0xA3,0xEC), o2(0xA3,0xED), o2(0xA3,0xEE), o2(0xA3,0xEF),
     o2(0xA3,0xF0), o2(0xA3,0xF1), o2(0xA3,0xF2), o2(0xA3,0xF3),
     o2(0xA3,0xF4), o2(0xA3,0xF5), o2(0xA3,0xF6), o2(0xA3,0xF7),
     o2(0xA3,0xF8), o2(0xA3,0xF9), o2(0xA3,0xFA), o2(0xA1,0xD0),
     o2(0xA1,0xC3), o2(0xA1,0xD1), o2(0x8E,0xA1), o2(0x8E,0xA2),
     o2(0x8E,0xA3), o2(0x8E,0xA4), o2(0x8E,0xA5), o2(0x8E,0xA6),
     o2(0x8E,0xA7), o2(0x8E,0xA8), o2(0x8E,0xA9), o2(0x8E,0xAA),
     o2(0x8E,0xAB), o2(0x8E,0xAC), o2(0x8E,0xAD), o2(0x8E,0xAE),
     o2(0x8E,0xAF), o2(0x8E,0xB0), o2(0x8E,0xB1), o2(0x8E,0xB2),
     o2(0x8E,0xB3), o2(0x8E,0xB4), o2(0x8E,0xB5), o2(0x8E,0xB6),
     o2(0x8E,0xB7), o2(0x8E,0xB8), o2(0x8E,0xB9), o2(0x8E,0xBA),
     o2(0x8E,0xBB), o2(0x8E,0xBC), o2(0x8E,0xBD), o2(0x8E,0xBE),
     o2(0x8E,0xBF),         UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_EF_BD = {
    to_SHIFT_JIS_EF_BD_offsets,
    to_EUC_JP_EF_BD_infos
};

static const struct byte_lookup* const
to_EUC_JP_EF_BE_infos[33] = {
     o2(0x8E,0xC0), o2(0x8E,0xC1), o2(0x8E,0xC2), o2(0x8E,0xC3),
     o2(0x8E,0xC4), o2(0x8E,0xC5), o2(0x8E,0xC6), o2(0x8E,0xC7),
     o2(0x8E,0xC8), o2(0x8E,0xC9), o2(0x8E,0xCA), o2(0x8E,0xCB),
     o2(0x8E,0xCC), o2(0x8E,0xCD), o2(0x8E,0xCE), o2(0x8E,0xCF),
     o2(0x8E,0xD0), o2(0x8E,0xD1), o2(0x8E,0xD2), o2(0x8E,0xD3),
     o2(0x8E,0xD4), o2(0x8E,0xD5), o2(0x8E,0xD6), o2(0x8E,0xD7),
     o2(0x8E,0xD8), o2(0x8E,0xD9), o2(0x8E,0xDA), o2(0x8E,0xDB),
     o2(0x8E,0xDC), o2(0x8E,0xDD), o2(0x8E,0xDE), o2(0x8E,0xDF),
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_EF_BE = {
    to_SHIFT_JIS_EF_BE_offsets,
    to_EUC_JP_EF_BE_infos
};

static const struct byte_lookup* const
to_EUC_JP_EF_infos[7] = {
     &to_EUC_JP_EF_A4, &to_EUC_JP_EF_A7, &to_EUC_JP_EF_A8, &to_EUC_JP_EF_BC,
     &to_EUC_JP_EF_BD, &to_EUC_JP_EF_BE,            UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP_EF = {
    to_SHIFT_JIS_EF_offsets,
    to_EUC_JP_EF_infos
};

static const struct byte_lookup* const
to_EUC_JP_infos[17] = {
             NOMAP, &to_EUC_JP_C2, &to_EUC_JP_C3, &to_EUC_JP_CE,
     &to_EUC_JP_CF, &to_EUC_JP_D0, &to_EUC_JP_D1, &to_EUC_JP_E2,
     &to_EUC_JP_E3, &to_EUC_JP_E4, &to_EUC_JP_E5, &to_EUC_JP_E6,
     &to_EUC_JP_E7, &to_EUC_JP_E8, &to_EUC_JP_E9, &to_EUC_JP_EF,
             UNDEF,
};
static const BYTE_LOOKUP
to_EUC_JP = {
    to_SHIFT_JIS_offsets,
    to_EUC_JP_infos
};
static const rb_transcoder
rb_to_EUC_JP = {
    "UTF-8", "EUC-JP", &to_EUC_JP, 2, 1,
    NULL, NULL,
};

#define ISO_2022_ENCODING(escseq, byte) ((escseq<<8)|byte)
enum ISO_2022_ESCSEQ {
    ISO_2022_CZD   = '!',
    ISO_2022_C1D   = '"',
    ISO_2022_GZD4  = '(',
    ISO_2022_G1D4  = ')',
    ISO_2022_G2D4  = '*',
    ISO_2022_G3D4  = '+',
    ISO_2022_G1D6  = '-',
    ISO_2022_G2D6  = '.',
    ISO_2022_G3D6  = '/',
    ISO_2022_GZDM4 = ISO_2022_ENCODING('$','('),
    ISO_2022_G1DM4 = ISO_2022_ENCODING('$',')'),
    ISO_2022_G2DM4 = ISO_2022_ENCODING('$','*'),
    ISO_2022_G3DM4 = ISO_2022_ENCODING('$','+'),
    ISO_2022_G1DM6 = ISO_2022_ENCODING('$','-'),
    ISO_2022_G2DM6 = ISO_2022_ENCODING('$','.'),
    ISO_2022_G3DM6 = ISO_2022_ENCODING('$','/'),
    ISO_2022_DOCS  = ISO_2022_ENCODING('%','I'),
    ISO_2022_IRR   = '&'
};


#define ISO_2022_GZ_ASCII                       ISO_2022_ENCODING(ISO_2022_GZD4, 'B')
#define ISO_2022_GZ_JIS_X_0201_Katakana         ISO_2022_ENCODING(ISO_2022_GZD4, 'I')
#define ISO_2022_GZ_JIS_X_0201_Roman            ISO_2022_ENCODING(ISO_2022_GZD4, 'J')
#define ISO_2022_GZ_JIS_C_6226_1978             ISO_2022_ENCODING(ISO_2022_GZDM4,'@')
#define ISO_2022_GZ_JIS_X_0208_1983             ISO_2022_ENCODING(ISO_2022_GZDM4,'B')
#define ISO_2022_GZ_JIS_X_0212_1990             ISO_2022_ENCODING(ISO_2022_GZDM4,'D')
#define ISO_2022_GZ_JIS_X_0213_2000_1           ISO_2022_ENCODING(ISO_2022_GZDM4,'O')
#define ISO_2022_GZ_JIS_X_0213_2000_2           ISO_2022_ENCODING(ISO_2022_GZDM4,'P')
#define ISO_2022_GZ_JIS_X_0213_2004_1           ISO_2022_ENCODING(ISO_2022_GZDM4,'Q')

static int
get_iso_2022_mode(unsigned char **in_pos)
{
    int new_mode;
    unsigned char *in_p = *in_pos;
    switch (*in_p++)
    {
    case '(':
	switch (*in_p++)
	{
	case 'B': case 'I': case 'J':
	    new_mode = ISO_2022_ENCODING(ISO_2022_GZD4, *(in_p-1));
	    break;
	default:
	    rb_raise(rb_eRuntimeError /*change exception*/, "this mode is not supported (ESC ( %c)", *(in_p-1));
	    break;
	}
	break;
    case '$':
	switch (*in_p++)
	{
	case '@': case 'A': case 'B':
	    new_mode = ISO_2022_ENCODING(ISO_2022_GZDM4, *(in_p-1));
	    break;
	case '(':
	    switch (*in_p++)
	    {
	    case 'D': case 'O': case 'P': case 'Q':
		new_mode = ISO_2022_ENCODING(ISO_2022_GZDM4, *(in_p-1));
		break;
	    default:
		rb_raise(rb_eRuntimeError /*change exception*/, "this mode is not supported (ESC $ ( %c)", *(in_p-1));
		break;
	    }
	    break;
	default:
	    rb_raise(rb_eRuntimeError /*change exception*/, "this mode is not supported (ESC $ %c)", *(in_p-1));
	    break;
	}
	break;
    default:
	    rb_raise(rb_eRuntimeError /*change exception*/, "this mode is not supported (ESC %c)", *(in_p-1));
	break;
    }
    *in_pos = in_p;
    return new_mode;
}

static void
from_iso_2022_jp_transcoder_preprocessor(unsigned char **in_pos, unsigned char **out_pos,
					 unsigned char *in_stop, unsigned char *out_stop,
					 rb_transcoding *my_transcoding)
{
    const rb_transcoder *my_transcoder = my_transcoding->transcoder;
    unsigned char *in_p = *in_pos, *out_p = *out_pos;
    int cur_mode = ISO_2022_GZ_ASCII;
    unsigned char c1;
    unsigned char *out_s = out_stop - my_transcoder->max_output + 1;
    while (in_p < in_stop) {
	if (out_p >= out_s) {
	    int len = (out_p - *out_pos);
	    int new_len = (len + my_transcoder->max_output) * 2;
	    *out_pos = (*my_transcoding->flush_func)(my_transcoding, len, new_len);
	    out_p = *out_pos + len;
	    out_s = *out_pos + new_len - my_transcoder->max_output;
	}
	c1 = *in_p++;
	if (c1 == 0x1B) {
	    cur_mode = get_iso_2022_mode(&in_p);
	} else if (c1 == 0x1E || c1 == 0x1F) {
	    /* SHIFT */
	    rb_raise(rb_eRuntimeError /*change exception*/, "shift is not supported");
	} else if (c1 >= 0x80) {
	    rb_raise(rb_eRuntimeError /*change exception*/, "invalid byte sequence");
	} else {
	    switch (cur_mode) {
	    case ISO_2022_GZ_ASCII:
	    case ISO_2022_GZ_JIS_X_0201_Roman:
		*out_p++ = c1;
		break;
	    case ISO_2022_GZ_JIS_X_0201_Katakana:
		*out_p++ = 0x8E;
		*out_p++ = c1 | 0x80;
		break;
	    case ISO_2022_GZ_JIS_X_0212_1990:
		*out_p++ = 0x8F;
	    case ISO_2022_GZ_JIS_C_6226_1978:
	    case ISO_2022_GZ_JIS_X_0208_1983:
		*out_p++ = c1 | 0x80;
		*out_p++ = *in_p++ | 0x80;
		break;
	    }
	}
    }
    /* cleanup */
    *in_pos  = in_p;
    *out_pos = out_p;
}

static int
select_iso_2022_mode(unsigned char **out_pos, int new_mode)
{
    unsigned char *out_p = *out_pos;
    *out_p++ = '\x1b';
    switch (new_mode>>8)
    {
    case ISO_2022_GZD4:
	*out_p++ = new_mode >> 8;
	*out_p++ = new_mode & 0x7F;
	break;
    case ISO_2022_GZDM4:
	*out_p++ = new_mode >> 16;
	if ((new_mode & 0x7F) != '@' &&
	    (new_mode & 0x7F) != 'A' &&
	    (new_mode & 0x7F) != 'B')
	{
	    *out_p++ = (new_mode>>8) & 0x7F;
	}
	*out_p++ = new_mode & 0x7F;
	break;
    default:
	rb_raise(rb_eRuntimeError /*change exception*/, "this mode is not supported.");
	break;
    }
    *out_pos = out_p;
    return new_mode;
}

static void
to_iso_2022_jp_transcoder_postprocessor(unsigned char **in_pos, unsigned char **out_pos,
					unsigned char *in_stop, unsigned char *out_stop,
					rb_transcoding *my_transcoding)
{
    const rb_transcoder *my_transcoder = my_transcoding->transcoder;
    unsigned char *in_p = *in_pos, *out_p = *out_pos;
    int cur_mode = ISO_2022_GZ_ASCII, new_mode = 0;
    unsigned char next_byte;
    unsigned char *out_s = out_stop - my_transcoder->max_output + 1;
    while (in_p < in_stop) {
	if (out_p >= out_s) {
	    int len = (out_p - *out_pos);
	    int new_len = (len + my_transcoder->max_output) * 2;
	    *out_pos = (*my_transcoding->flush_func)(my_transcoding, len, new_len);
	    out_p = *out_pos + len;
	    out_s = *out_pos + new_len - my_transcoder->max_output;
	}
	next_byte = *in_p++;
	if (next_byte < 0x80) {
	    new_mode = ISO_2022_GZ_ASCII;
	} else if (next_byte == 0x8E) {
	    new_mode = ISO_2022_GZ_JIS_X_0201_Katakana;
	    next_byte = *in_p++;
	} else if (next_byte == 0x8F) {
	    new_mode = ISO_2022_GZ_JIS_X_0212_1990;
	    next_byte = *in_p++;
	} else {
	    new_mode = ISO_2022_GZ_JIS_X_0208_1983;
	}
	if (cur_mode != new_mode)
	    cur_mode = select_iso_2022_mode(&out_p, new_mode);
	if (cur_mode < 0xFFFF) {
	    *out_p++ = next_byte & 0x7F;
	} else {
	    *out_p++ = next_byte & 0x7F;
	    *out_p++ = *in_p++ & 0x7F;
	}
    }
    if (cur_mode != ISO_2022_GZ_ASCII)
	cur_mode = select_iso_2022_mode(&out_p, ISO_2022_GZ_ASCII);
    /* cleanup */
    *in_pos  = in_p;
    *out_pos = out_p;
}

static const rb_transcoder
rb_from_ISO_2022_JP = {
    "ISO-2022-JP", "UTF-8", &from_EUC_JP, 8, 0,
    &from_iso_2022_jp_transcoder_preprocessor, NULL,
};

static const rb_transcoder
rb_to_ISO_2022_JP = {
    "UTF-8", "ISO-2022-JP", &to_EUC_JP, 8, 1,
    NULL, &to_iso_2022_jp_transcoder_postprocessor,
};

void
Init_japanese(void)
{
    rb_register_transcoder(&rb_from_SHIFT_JIS);
    rb_register_transcoder(&rb_from_Windows_31J);
    rb_register_transcoder(&rb_from_EUC_JP);
    rb_register_transcoder(&rb_to_SHIFT_JIS);
    rb_register_transcoder(&rb_to_Windows_31J);
    rb_register_transcoder(&rb_to_EUC_JP);
    rb_register_transcoder(&rb_from_ISO_2022_JP);
    rb_register_transcoder(&rb_to_ISO_2022_JP);
}
