/* -*-c-*-
 THIS FILE WAS AUTOGENERATED BY template/prelude.c.tmpl. DO NOT EDIT.

 sources: ./ast, ./dir, ./gc, ./numeric, ./io, ./marshal, ./mjit, ./mjit_compiler, ./mjit_instruction, ./pack, ./trace_point, ./warning, ./array, ./kernel, ./ractor, ./timev, ./thread_sync, ./nilclass, ./prelude, ./gem_prelude, ./yjit
*/
#include "internal.h"
#include "internal/warnings.h"
#include "iseq.h"
#include "ruby/ruby.h"
#include "vm_core.h"

COMPILER_WARNING_PUSH
#if __has_warning("-Wstring-concatenation")
COMPILER_WARNING_IGNORED(-Wstring-concatenation)
#endif

static const char prelude_name0[] = "<internal:ast>";
static const struct {
    char L0[488]; /* 1..95 */
    char L95[503]; /* 96..162 */
    char L162[338]; /* 163..191 */
} prelude_code0 = {
#line 1 "ast.rb"
""/* for ast.c */
""
""/* AbstractSyntaxTree provides methods to parse Ruby code into */
""/* abstract syntax trees. The nodes in the tree */
""/* are instances of RubyVM::AbstractSyntaxTree::Node. */
""/*  */
""/* This module is MRI specific as it exposes implementation details */
""/* of the MRI abstract syntax tree. */
""/*  */
""/* This module is experimental and its API is not stable, therefore it might */
""/* change without notice. As examples, the order of children nodes is not */
""/* guaranteed, the number of children nodes might change, there is no way to */
""/* access children nodes by name, etc. */
""/*  */
""/* If you are looking for a stable API or an API working under multiple Ruby */
""/* implementations, consider using the _parser_ gem or Ripper. If you would */
""/* like to make RubyVM::AbstractSyntaxTree stable, please join the discussion */
""/* at https://bugs.ruby-lang.org/issues/14844. */
""/*  */
"module RubyVM::AbstractSyntaxTree\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.parse(string) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*  Parses the given _string_ into an abstract syntax tree, */
"\n"/*  returning the root node of that tree. */
"\n"/*  */
"\n"/*  SyntaxError is raised if the given _string_ is invalid syntax. */
"\n"/*  */
"\n"/*    RubyVM::AbstractSyntaxTree.parse("x = 1 + 2") */
"\n"/*    # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-1:9> */
"  def self.parse string, keep_script_lines: false\n"
"    Primitive.ast_s_parse string, keep_script_lines\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.parse_file(pathname) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*   Reads the file from _pathname_, then parses it like ::parse, */
"\n"/*   returning the root node of the abstract syntax tree. */
"\n"/*  */
"\n"/*   SyntaxError is raised if _pathname_'s contents are not */
"\n"/*   valid Ruby syntax. */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.parse_file("my-app/app.rb") */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-31:3> */
"  def self.parse_file pathname, keep_script_lines: false\n"
"    Primitive.ast_s_parse_file pathname, keep_script_lines\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.of(proc)   -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*     RubyVM::AbstractSyntaxTree.of(method) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*   Returns AST nodes of the given _proc_ or _method_. */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.of(proc {1 + 2}) */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:35-1:42> */
"\n"/*  */
"\n"/*     def hello */
"\n"/*       puts "hello, world" */
"\n"/*     end */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.of(method(:hello)) */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-3:3> */
"  def self.of body, keep_script_lines: false\n"
"    Primitive.ast_s_of body, keep_script_lines\n"
"  end\n"
"\n"
"\n"/* RubyVM::AbstractSyntaxTree::Node instances are created by parse methods in */
"\n"/* RubyVM::AbstractSyntaxTree. */
"\n"/*  */
"\n"/* This class is MRI specific. */
"\n"/*  */
"  class Node\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.type -> symbol */
"\n"/*  */
"\n"/*  Returns the type of this node as a symbol. */
"\n"/*  */
"\n"/*    root = RubyVM::AbstractSyntaxTree.parse("x = 1 + 2") */
"\n"/*    root.type # => :SCOPE */
"\n"/*    lasgn = root.children[2] */
"\n"/*    lasgn.type # => :LASGN */
"\n"/*    call = lasgn.children[1] */
"\n"/*    call.type # => :OPCALL */
"    def type\n"
"      Primitive.ast_node_type\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.first_lineno -> integer */
"\n"/*  */
"\n"/*  The line number in the source code where this AST's text began. */
,
#line 96 "ast.rb"
"    def first_lineno\n"
"      Primitive.ast_node_first_lineno\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.first_column -> integer */
"\n"/*  */
"\n"/*  The column number in the source code where this AST's text began. */
"    def first_column\n"
"      Primitive.ast_node_first_column\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.last_lineno -> integer */
"\n"/*  */
"\n"/*  The line number in the source code where this AST's text ended. */
"    def last_lineno\n"
"      Primitive.ast_node_last_lineno\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.last_column -> integer */
"\n"/*  */
"\n"/*  The column number in the source code where this AST's text ended. */
"    def last_column\n"
"      Primitive.ast_node_last_column\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.children -> array */
"\n"/*  */
"\n"/*  Returns AST nodes under this one.  Each kind of node */
"\n"/*  has different children, depending on what kind of node it is. */
"\n"/*  */
"\n"/*  The returned array may contain other nodes or <code>nil</code>. */
"    def children\n"
"      Primitive.ast_node_children\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.inspect -> string */
"\n"/*  */
"\n"/*  Returns debugging information about this node as a string. */
"    def inspect\n"
"      Primitive.ast_node_inspect\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.node_id -> integer */
"\n"/*  */
"\n"/*  Returns an internal node_id number. */
"\n"/*  Note that this is an API for ruby internal use, debugging, */
"\n"/*  and research. Do not use this for any other purpose. */
"\n"/*  The compatibility is not guaranteed. */
"    def node_id\n"
"      Primitive.ast_node_node_id\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.script_lines -> array */
"\n"/*  */
"\n"/*  Returns the original source code as an array of lines. */
"\n"/*  */
"\n"/*  Note that this is an API for ruby internal use, debugging, */
"\n"/*  and research. Do not use this for any other purpose. */
"\n"/*  The compatibility is not guaranteed. */
"    def script_lines\n"
,
#line 163 "ast.rb"
"      Primitive.ast_node_script_lines\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.source -> string */
"\n"/*  */
"\n"/*  Returns the code fragment that corresponds to this AST. */
"\n"/*  */
"\n"/*  Note that this is an API for ruby internal use, debugging, */
"\n"/*  and research. Do not use this for any other purpose. */
"\n"/*  The compatibility is not guaranteed. */
"\n"/*  */
"\n"/*  Also note that this API may return an incomplete code fragment */
"\n"/*  that does not parse; for example, a here document following */
"\n"/*  an expression may be dropped. */
"    def source\n"
"      lines = script_lines\n"
"      if lines\n"
"        lines = lines[first_lineno - 1 .. last_lineno - 1]\n"
"        lines[-1] = lines[-1][0...last_column]\n"
"        lines[0] = lines[0][first_column..-1]\n"
"        lines.join\n"
"      else\n"
"        nil\n"
"      end\n"
"    end\n"
"  end\n"
"end\n"
#line 219 "miniprelude.c"
};

static const char prelude_name1[] = "<internal:dir>";
static const struct {
    char L0[508]; /* 1..191 */
    char L191[350]; /* 192..315 */
} prelude_code1 = {
#line 1 "dir.rb"
""/* Objects of class Dir are directory streams representing */
""/* directories in the underlying file system. They provide a variety */
""/* of ways to list directories and their contents. See also File. */
""/*  */
""/* The directory used in these examples contains the two regular files */
""/* (<code>config.h</code> and <code>main.rb</code>), the parent */
""/* directory (<code>..</code>), and the directory itself */
""/* (<code>.</code>). */
""/*  */
""/* == What's Here */
""/*  */
""/* First, what's elsewhere. \Class \Dir: */
""/*  */
""/* - Inherits from {class Object}[rdoc-ref:Object@What-27s+Here]. */
""/* - Includes {module Enumerable}[rdoc-ref:Enumerable@What-27s+Here], */
""/*   which provides dozens of additional methods. */
""/*  */
""/* Here, class \Dir provides methods that are useful for: */
""/*  */
""/* - {Reading}[rdoc-ref:Dir@Reading] */
""/* - {Setting}[rdoc-ref:Dir@Setting] */
""/* - {Querying}[rdoc-ref:Dir@Querying] */
""/* - {Iterating}[rdoc-ref:Dir@Iterating] */
""/* - {Other}[rdoc-ref:Dir@Other] */
""/*  */
""/* === Reading */
""/*  */
""/* - #close: Closes the directory stream for +self+. */
""/* - #pos=: Sets the position in the directory stream for +self+. */
""/* - #read: Reads and returns the next entry in the directory stream for +self+. */
""/* - #rewind: Sets the position in the directory stream for +self+ to the first entry. */
""/* - #seek: Sets the position in the directory stream for +self+ */
""/*   the entry at the given offset. */
""/*  */
""/* === Setting */
""/*  */
""/* - ::chdir: Changes the working directory of the current process */
""/*   to the given directory. */
""/* - ::chroot: Changes the file-system root for the current process */
""/*   to the given directory. */
""/*  */
""/* === Querying */
""/*  */
""/* - ::[]: Same as ::glob without the ability to pass flags. */
""/* - ::children: Returns an array of names of the children */
""/*   (both files and directories) of the given directory, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/* - ::empty?: Returns whether the given path is an empty directory. */
""/* - ::entries: Returns an array of names of the children */
""/*   (both files and directories) of the given directory, */
""/*   including <tt>.</tt> and <tt>..</tt>. */
""/* - ::exist?: Returns whether the given path is a directory. */
""/* - ::getwd (aliased as #pwd): Returns the path to the current working directory. */
""/* - ::glob: Returns an array of file paths matching the given pattern and flags. */
""/* - ::home: Returns the home directory path for a given user or the current user. */
""/* - #children: Returns an array of names of the children */
""/*   (both files and directories) of +self+, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/* - #fileno: Returns the integer file descriptor for +self+. */
""/* - #path (aliased as #to_path): Returns the path used to create +self+. */
""/* - #tell (aliased as #pos): Returns the integer position */
""/*   in the directory stream for +self+. */
""/*  */
""/* === Iterating */
""/*  */
""/* - ::each_child: Calls the given block with each entry in the given directory, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/* - ::foreach: Calls the given block with each entry in the given directory, */
""/*   including <tt>.</tt> and <tt>..</tt>. */
""/* - #each: Calls the given block with each entry in +self+, */
""/*   including <tt>.</tt> and <tt>..</tt>. */
""/* - #each_child: Calls the given block with each entry in +self+, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/*  */
""/* === Other */
""/*  */
""/* - ::mkdir: Creates a directory at the given path, with optional permissions. */
""/* - ::new: Returns a new \Dir for the given path, with optional encoding. */
""/* - ::open: Same as ::new, but if a block is given, yields the \Dir to the block, */
""/*   closing it upon block exit. */
""/* - ::unlink (aliased as ::delete and ::rmdir): Removes the given directory. */
""/* - #inspect: Returns a string description of +self+. */
"class Dir\n"
"\n"/* call-seq: */
"\n"/*    Dir.open( string ) -> aDir */
"\n"/*    Dir.open( string, encoding: enc ) -> aDir */
"\n"/*    Dir.open( string ) {| aDir | block } -> anObject */
"\n"/*    Dir.open( string, encoding: enc ) {| aDir | block } -> anObject */
"\n"/*  */
"\n"/* The optional <i>encoding</i> keyword argument specifies the encoding of the directory. */
"\n"/* If not specified, the filesystem encoding is used. */
"\n"/*  */
"\n"/* With no block, <code>open</code> is a synonym for Dir::new. If a */
"\n"/* block is present, it is passed <i>aDir</i> as a parameter. The */
"\n"/* directory is closed at the end of the block, and Dir::open returns */
"\n"/* the value of the block. */
"  def self.open(name, encoding: nil, &block)\n"
"    dir = Primitive.dir_s_open(name, encoding)\n"
"    if block\n"
"      begin\n"
"        yield dir\n"
"      ensure\n"
"        Primitive.dir_s_close(dir)\n"
"      end\n"
"    else\n"
"      dir\n"
"    end\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    Dir.new( string ) -> aDir */
"\n"/*    Dir.new( string, encoding: enc ) -> aDir */
"\n"/*  */
"\n"/* Returns a new directory object for the named directory. */
"\n"/*  */
"\n"/* The optional <i>encoding</i> keyword argument specifies the encoding of the directory. */
"\n"/* If not specified, the filesystem encoding is used. */
"  def initialize(name, encoding: nil)\n"
"    Primitive.dir_initialize(name, encoding)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    Dir[ string [, string ...] [, base: path] [, sort: true] ] -> array */
"\n"/*  */
"\n"/* Equivalent to calling */
"\n"/* <code>Dir.glob([</code><i>string,...</i><code>], 0)</code>. */
"  def self.[](*args, base: nil, sort: true)\n"
"    Primitive.dir_s_aref(args, base, sort)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    Dir.glob( pattern, [flags], [base: path] [, sort: true] )                       -> array */
"\n"/*    Dir.glob( pattern, [flags], [base: path] [, sort: true] ) { |filename| block }  -> nil */
"\n"/*  */
"\n"/* Expands +pattern+, which is a pattern string or an Array of pattern */
"\n"/* strings, and returns an array containing the matching filenames. */
"\n"/* If a block is given, calls the block once for each matching filename, */
"\n"/* passing the filename as a parameter to the block. */
"\n"/*  */
"\n"/* The optional +base+ keyword argument specifies the base directory for */
"\n"/* interpreting relative pathnames instead of the current working directory. */
"\n"/* As the results are not prefixed with the base directory name in this */
"\n"/* case, you will need to prepend the base directory name if you want real */
"\n"/* paths. */
"\n"/*  */
"\n"/* The results which matched single wildcard or character set are sorted in */
"\n"/* binary ascending order, unless +false+ is given as the optional +sort+ */
"\n"/* keyword argument.  The order of an Array of pattern strings and braces */
"\n"/* are preserved. */
"\n"/*  */
"\n"/* Note that the pattern is not a regexp, it's closer to a shell glob. */
"\n"/* See File::fnmatch for the meaning of the +flags+ parameter. */
"\n"/* Case sensitivity depends on your system (+File::FNM_CASEFOLD+ is ignored). */
"\n"/*  */
"\n"/* <code>*</code>:: */
"\n"/*   Matches any file. Can be restricted by other values in the glob. */
"\n"/*   Equivalent to <code>/.*\/mx</code> in regexp. */
"\n"/*  */
"\n"/*   <code>*</code>::     Matches all files */
"\n"/*   <code>c*</code>::    Matches all files beginning with <code>c</code> */
"\n"/*   <code>*c</code>::    Matches all files ending with <code>c</code> */
"\n"/*   <code>\*c\*</code>:: Match all files that have <code>c</code> in them */
"\n"/*                        (including at the beginning or end). */
"\n"/*  */
"\n"/*   Note, this will not match Unix-like hidden files (dotfiles).  In order */
"\n"/*   to include those in the match results, you must use the */
"\n"/*   File::FNM_DOTMATCH flag or something like <code>"{*,.*}"</code>. */
"\n"/*  */
"\n"/* <code>**</code>:: */
"\n"/*   Matches directories recursively if followed by <code>/</code>.  If */
"\n"/*   this path segment contains any other characters, it is the same as the */
"\n"/*   usual <code>*</code>. */
"\n"/*  */
"\n"/* <code>?</code>:: */
"\n"/*   Matches any one character. Equivalent to <code>/.{1}/</code> in regexp. */
"\n"/*  */
"\n"/* <code>[set]</code>:: */
"\n"/*   Matches any one character in +set+.  Behaves exactly like character sets */
"\n"/*   in Regexp, including set negation (<code>[^a-z]</code>). */
"\n"/*  */
"\n"/* <code>{p,q}</code>:: */
"\n"/*   Matches either literal <code>p</code> or literal <code>q</code>. */
"\n"/*   Equivalent to pattern alternation in regexp. */
"\n"/*  */
"\n"/*   Matching literals may be more than one character in length.  More than */
"\n"/*   two literals may be specified. */
"\n"/*  */
"\n"/* <code>\\</code>:: */
"\n"/*   Escapes the next metacharacter. */
"\n"/*  */
"\n"/*   Note that this means you cannot use backslash on windows as part of a */
,
#line 192 "dir.rb"
"\n"/*   glob, i.e.  <code>Dir["c:\\foo*"]</code> will not work, use */
"\n"/*   <code>Dir["c:/foo*"]</code> instead. */
"\n"/*  */
"\n"/* Examples: */
"\n"/*  */
"\n"/*    Dir["config.?"]                     #=> ["config.h"] */
"\n"/*    Dir.glob("config.?")                #=> ["config.h"] */
"\n"/*    Dir.glob("*.[a-z][a-z]")            #=> ["main.rb"] */
"\n"/*    Dir.glob("*.[^r]*")                 #=> ["config.h"] */
"\n"/*    Dir.glob("*.{rb,h}")                #=> ["main.rb", "config.h"] */
"\n"/*    Dir.glob("*")                       #=> ["config.h", "main.rb"] */
"\n"/*    Dir.glob("*", File::FNM_DOTMATCH)   #=> [".", "config.h", "main.rb"] */
"\n"/*    Dir.glob(["*.rb", "*.h"])           #=> ["main.rb", "config.h"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/\*.rb")                 #=> ["main.rb", */
"\n"/*                                        #    "lib/song.rb", */
"\n"/*                                        #    "lib/song/karaoke.rb"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/\*.rb", base: "lib")    #=> ["song.rb", */
"\n"/*                                        #    "song/karaoke.rb"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/lib")                  #=> ["lib"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/lib/\**\/\*.rb")          #=> ["lib/song.rb", */
"\n"/*                                        #    "lib/song/karaoke.rb"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/lib/\*.rb")             #=> ["lib/song.rb"] */
"  def self.glob(pattern, _flags = 0, flags: _flags, base: nil, sort: true)\n"
"    Primitive.dir_s_glob(pattern, flags, base, sort)\n"
"  end\n"
"end\n"
"\n"
"class << File\n"
"\n"/* call-seq: */
"\n"/*    File.fnmatch( pattern, path, [flags] ) -> (true or false) */
"\n"/*    File.fnmatch?( pattern, path, [flags] ) -> (true or false) */
"\n"/*  */
"\n"/* Returns true if +path+ matches against +pattern+.  The pattern is not a */
"\n"/* regular expression; instead it follows rules similar to shell filename */
"\n"/* globbing.  It may contain the following metacharacters: */
"\n"/*  */
"\n"/* <code>*</code>:: */
"\n"/*   Matches any file. Can be restricted by other values in the glob. */
"\n"/*   Equivalent to <code>/.*\/x</code> in regexp. */
"\n"/*  */
"\n"/*   <code>*</code>::    Matches all regular files */
"\n"/*   <code>c*</code>::   Matches all files beginning with <code>c</code> */
"\n"/*   <code>*c</code>::   Matches all files ending with <code>c</code> */
"\n"/*   <code>\*c*</code>:: Matches all files that have <code>c</code> in them */
"\n"/*                       (including at the beginning or end). */
"\n"/*  */
"\n"/*   To match hidden files (that start with a <code>.</code>) set the */
"\n"/*   File::FNM_DOTMATCH flag. */
"\n"/*  */
"\n"/* <code>**</code>:: */
"\n"/*   Matches directories recursively or files expansively. */
"\n"/*  */
"\n"/* <code>?</code>:: */
"\n"/*   Matches any one character. Equivalent to <code>/.{1}/</code> in regexp. */
"\n"/*  */
"\n"/* <code>[set]</code>:: */
"\n"/*   Matches any one character in +set+.  Behaves exactly like character sets */
"\n"/*   in Regexp, including set negation (<code>[^a-z]</code>). */
"\n"/*  */
"\n"/* <code>\\</code>:: */
"\n"/*   Escapes the next metacharacter. */
"\n"/*  */
"\n"/* <code>{a,b}</code>:: */
"\n"/*   Matches pattern a and pattern b if File::FNM_EXTGLOB flag is enabled. */
"\n"/*   Behaves like a Regexp union (<code>(?:a|b)</code>). */
"\n"/*  */
"\n"/* +flags+ is a bitwise OR of the <code>FNM_XXX</code> constants. The same */
"\n"/* glob pattern and flags are used by Dir::glob. */
"\n"/*  */
"\n"/* Examples: */
"\n"/*  */
"\n"/*    File.fnmatch('cat',       'cat')        #=> true  # match entire string */
"\n"/*    File.fnmatch('cat',       'category')   #=> false # only match partial string */
"\n"/*  */
"\n"/*    File.fnmatch('c{at,ub}s', 'cats')                    #=> false # { } isn't supported by default */
"\n"/*    File.fnmatch('c{at,ub}s', 'cats', File::FNM_EXTGLOB) #=> true  # { } is supported on FNM_EXTGLOB */
"\n"/*  */
"\n"/*    File.fnmatch('c?t',     'cat')          #=> true  # '?' match only 1 character */
"\n"/*    File.fnmatch('c??t',    'cat')          #=> false # ditto */
"\n"/*    File.fnmatch('c*',      'cats')         #=> true  # '*' match 0 or more characters */
"\n"/*    File.fnmatch('c*t',     'c/a/b/t')      #=> true  # ditto */
"\n"/*    File.fnmatch('ca[a-z]', 'cat')          #=> true  # inclusive bracket expression */
"\n"/*    File.fnmatch('ca[^t]',  'cat')          #=> false # exclusive bracket expression ('^' or '!') */
"\n"/*  */
"\n"/*    File.fnmatch('cat', 'CAT')                     #=> false # case sensitive */
"\n"/*    File.fnmatch('cat', 'CAT', File::FNM_CASEFOLD) #=> true  # case insensitive */
"\n"/*    File.fnmatch('cat', 'CAT', File::FNM_SYSCASE)  #=> true or false # depends on the system default */
"\n"/*  */
"\n"/*    File.fnmatch('?',   '/', File::FNM_PATHNAME)  #=> false # wildcard doesn't match '/' on FNM_PATHNAME */
"\n"/*    File.fnmatch('*',   '/', File::FNM_PATHNAME)  #=> false # ditto */
"\n"/*    File.fnmatch('[/]', '/', File::FNM_PATHNAME)  #=> false # ditto */
"\n"/*  */
"\n"/*    File.fnmatch('\?',   '?')                       #=> true  # escaped wildcard becomes ordinary */
"\n"/*    File.fnmatch('\a',   'a')                       #=> true  # escaped ordinary remains ordinary */
"\n"/*    File.fnmatch('\a',   '\a', File::FNM_NOESCAPE)  #=> true  # FNM_NOESCAPE makes '\' ordinary */
"\n"/*    File.fnmatch('[\?]', '?')                       #=> true  # can escape inside bracket expression */
"\n"/*  */
"\n"/*    File.fnmatch('*',   '.profile')                      #=> false # wildcard doesn't match leading */
"\n"/*    File.fnmatch('*',   '.profile', File::FNM_DOTMATCH)  #=> true  # period by default. */
"\n"/*    File.fnmatch('.*',  '.profile')                      #=> true */
"\n"/*  */
"\n"/*    File.fnmatch('**\/\*.rb', 'main.rb')                  #=> false */
"\n"/*    File.fnmatch('**\/\*.rb', './main.rb')                #=> false */
"\n"/*    File.fnmatch('**\/\*.rb', 'lib/song.rb')              #=> true */
"\n"/*    File.fnmatch('**.rb', 'main.rb')                    #=> true */
"\n"/*    File.fnmatch('**.rb', './main.rb')                  #=> false */
"\n"/*    File.fnmatch('**.rb', 'lib/song.rb')                #=> true */
"\n"/*    File.fnmatch('*',     'dave/.profile')              #=> true */
"\n"/*  */
"\n"/*    File.fnmatch('**\/foo', 'a/b/c/foo', File::FNM_PATHNAME)     #=> true */
"\n"/*    File.fnmatch('**\/foo', '/a/b/c/foo', File::FNM_PATHNAME)    #=> true */
"\n"/*    File.fnmatch('**\/foo', 'c:/a/b/c/foo', File::FNM_PATHNAME)  #=> true */
"\n"/*    File.fnmatch('**\/foo', 'a/.b/c/foo', File::FNM_PATHNAME)    #=> false */
"\n"/*    File.fnmatch('**\/foo', 'a/.b/c/foo', File::FNM_PATHNAME | File::FNM_DOTMATCH) #=> true */
"  def fnmatch(pattern, path, flags = 0)\n"
"  end\n"
"  alias fnmatch? fnmatch\n"
"end if false\n"
#line 544 "miniprelude.c"
};

static const char prelude_name2[] = "<internal:gc>";
static const struct {
    char L0[492]; /* 1..70 */
    char L70[495]; /* 71..230 */
    char L230[492]; /* 231..272 */
    char L272[429]; /* 273..301 */
    char L301[128]; /* 302..307 */
} prelude_code2 = {
#line 1 "gc.rb"
""/* for gc.c */
""
""/*  The GC module provides an interface to Ruby's mark and */
""/*  sweep garbage collection mechanism. */
""/*  */
""/*  Some of the underlying methods are also available via the ObjectSpace */
""/*  module. */
""/*  */
""/*  You may obtain information about the operation of the GC through */
""/*  GC::Profiler. */
"module GC\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.start                     -> nil */
"\n"/*     ObjectSpace.garbage_collect  -> nil */
"\n"/*     include GC; garbage_collect  -> nil */
"\n"/*     GC.start(full_mark: true, immediate_sweep: true)           -> nil */
"\n"/*     ObjectSpace.garbage_collect(full_mark: true, immediate_sweep: true) -> nil */
"\n"/*     include GC; garbage_collect(full_mark: true, immediate_sweep: true) -> nil */
"\n"/*  */
"\n"/*  Initiates garbage collection, even if manually disabled. */
"\n"/*  */
"\n"/*  This method is defined with keyword arguments that default to true: */
"\n"/*  */
"\n"/*     def GC.start(full_mark: true, immediate_sweep: true); end */
"\n"/*  */
"\n"/*  Use full_mark: false to perform a minor GC. */
"\n"/*  Use immediate_sweep: false to defer sweeping (use lazy sweep). */
"\n"/*  */
"\n"/*  Note: These keyword arguments are implementation and version dependent. They */
"\n"/*  are not guaranteed to be future-compatible, and may be ignored if the */
"\n"/*  underlying implementation does not support them. */
"  def self.start full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"  def garbage_collect full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.enable    -> true or false */
"\n"/*  */
"\n"/*  Enables garbage collection, returning +true+ if garbage */
"\n"/*  collection was previously disabled. */
"\n"/*  */
"\n"/*     GC.disable   #=> false */
"\n"/*     GC.enable    #=> true */
"\n"/*     GC.enable    #=> false */
"\n"/*  */
"  def self.enable\n"
"    Primitive.gc_enable\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.disable    -> true or false */
"\n"/*  */
"\n"/*  Disables garbage collection, returning +true+ if garbage */
"\n"/*  collection was already disabled. */
"\n"/*  */
"\n"/*     GC.disable   #=> false */
"\n"/*     GC.disable   #=> true */
"  def self.disable\n"
"    Primitive.gc_disable\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    GC.stress	    -> integer, true or false */
"\n"/*  */
"\n"/*  Returns current status of GC stress mode. */
,
#line 71 "gc.rb"
"  def self.stress\n"
"    Primitive.gc_stress_get\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    GC.stress = flag          -> flag */
"\n"/*  */
"\n"/*  Updates the GC stress mode. */
"\n"/*  */
"\n"/*  When stress mode is enabled, the GC is invoked at every GC opportunity: */
"\n"/*  all memory and object allocations. */
"\n"/*  */
"\n"/*  Enabling stress mode will degrade performance, it is only for debugging. */
"\n"/*  */
"\n"/*  flag can be true, false, or an integer bit-ORed following flags. */
"\n"/*    0x01:: no major GC */
"\n"/*    0x02:: no immediate sweep */
"\n"/*    0x04:: full mark after malloc/calloc/realloc */
"  def self.stress=(flag)\n"
"    Primitive.gc_stress_set_m flag\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.count -> Integer */
"\n"/*  */
"\n"/*  The number of times GC occurred. */
"\n"/*  */
"\n"/*  It returns the number of times GC occurred since the process started. */
"  def self.count\n"
"    Primitive.gc_count\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.stat -> Hash */
"\n"/*     GC.stat(hash) -> Hash */
"\n"/*     GC.stat(:key) -> Numeric */
"\n"/*  */
"\n"/*  Returns a Hash containing information about the GC. */
"\n"/*  */
"\n"/*  The contents of the hash are implementation specific and may change in */
"\n"/*  the future without notice. */
"\n"/*  */
"\n"/*  The hash includes information about internal statistics about GC such as: */
"\n"/*  */
"\n"/*  [count] */
"\n"/*    The total number of garbage collections ran since application start */
"\n"/*    (count includes both minor and major garbage collections) */
"\n"/*  [time] */
"\n"/*    The total time spent in garbage collections (in milliseconds) */
"\n"/*  [heap_allocated_pages] */
"\n"/*    The total number of `:heap_eden_pages` + `:heap_tomb_pages` */
"\n"/*  [heap_sorted_length] */
"\n"/*    The number of pages that can fit into the buffer that holds references to */
"\n"/*    all pages */
"\n"/*  [heap_allocatable_pages] */
"\n"/*    The total number of pages the application could allocate without additional GC */
"\n"/*  [heap_available_slots] */
"\n"/*    The total number of slots in all `:heap_allocated_pages` */
"\n"/*  [heap_live_slots] */
"\n"/*    The total number of slots which contain live objects */
"\n"/*  [heap_free_slots] */
"\n"/*    The total number of slots which do not contain live objects */
"\n"/*  [heap_final_slots] */
"\n"/*    The total number of slots with pending finalizers to be run */
"\n"/*  [heap_marked_slots] */
"\n"/*    The total number of objects marked in the last GC */
"\n"/*  [heap_eden_pages] */
"\n"/*    The total number of pages which contain at least one live slot */
"\n"/*  [heap_tomb_pages] */
"\n"/*    The total number of pages which do not contain any live slots */
"\n"/*  [total_allocated_pages] */
"\n"/*    The cumulative number of pages allocated since application start */
"\n"/*  [total_freed_pages] */
"\n"/*    The cumulative number of pages freed since application start */
"\n"/*  [total_allocated_objects] */
"\n"/*    The cumulative number of objects allocated since application start */
"\n"/*  [total_freed_objects] */
"\n"/*    The cumulative number of objects freed since application start */
"\n"/*  [malloc_increase_bytes] */
"\n"/*    Amount of memory allocated on the heap for objects. Decreased by any GC */
"\n"/*  [malloc_increase_bytes_limit] */
"\n"/*    When `:malloc_increase_bytes` crosses this limit, GC is triggered */
"\n"/*  [minor_gc_count] */
"\n"/*    The total number of minor garbage collections run since process start */
"\n"/*  [major_gc_count] */
"\n"/*    The total number of major garbage collections run since process start */
"\n"/*  [compact_count] */
"\n"/*    The total number of compactions run since process start */
"\n"/*  [read_barrier_faults] */
"\n"/*    The total number of times the read barrier was triggered during */
"\n"/*    compaction */
"\n"/*  [total_moved_objects] */
"\n"/*    The total number of objects compaction has moved */
"\n"/*  [remembered_wb_unprotected_objects] */
"\n"/*    The total number of objects without write barriers */
"\n"/*  [remembered_wb_unprotected_objects_limit] */
"\n"/*    When `:remembered_wb_unprotected_objects` crosses this limit, */
"\n"/*    major GC is triggered */
"\n"/*  [old_objects] */
"\n"/*    Number of live, old objects which have survived at least 3 garbage collections */
"\n"/*  [old_objects_limit] */
"\n"/*    When `:old_objects` crosses this limit, major GC is triggered */
"\n"/*  [oldmalloc_increase_bytes] */
"\n"/*    Amount of memory allocated on the heap for objects. Decreased by major GC */
"\n"/*  [oldmalloc_increase_bytes_limit] */
"\n"/*    When `:old_malloc_increase_bytes` crosses this limit, major GC is triggered */
"\n"/*  */
"\n"/*  If the optional argument, hash, is given, */
"\n"/*  it is overwritten and returned. */
"\n"/*  This is intended to avoid probe effect. */
"\n"/*  */
"\n"/*  This method is only expected to work on CRuby. */
"  def self.stat hash_or_key = nil\n"
"    Primitive.gc_stat hash_or_key\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.stat_heap -> Hash */
"\n"/*    GC.stat_heap(nil, hash) -> Hash */
"\n"/*    GC.stat_heap(heap_name) -> Hash */
"\n"/*    GC.stat_heap(heap_name, hash) -> Hash */
"\n"/*    GC.stat_heap(heap_name, :key) -> Numeric */
"\n"/*  */
"\n"/* Returns information for memory pools in the GC. */
"\n"/*  */
"\n"/* If the first optional argument, +heap_name+, is passed in and not +nil+, it */
"\n"/* returns a +Hash+ containing information about the particular memory pool. */
"\n"/* Otherwise, it will return a +Hash+ with memory pool names as keys and */
"\n"/* a +Hash+ containing information about the memory pool as values. */
"\n"/*  */
"\n"/* If the second optional argument, +hash_or_key+, is given as +Hash+, it will */
"\n"/* be overwritten and returned. This is intended to avoid the probe effect. */
"\n"/*  */
"\n"/* If both optional arguments are passed in and the second optional argument is */
"\n"/* a symbol, it will return a +Numeric+ of the value for the particular memory */
"\n"/* pool. */
"\n"/*  */
"\n"/* On CRuby, +heap_name+ is of the type +Integer+ but may be of type +String+ */
"\n"/* on other implementations. */
"\n"/*  */
"\n"/* The contents of the hash are implementation specific and may change in */
"\n"/* the future without notice. */
"\n"/*  */
"\n"/* If the optional argument, hash, is given, it is overwritten and returned. */
"\n"/*  */
"\n"/* This method is only expected to work on CRuby. */
"  def self.stat_heap heap_name = nil, hash_or_key = nil\n"
"    Primitive.gc_stat_heap heap_name, hash_or_key\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.latest_gc_info -> {:gc_by=>:newobj} */
"\n"/*     GC.latest_gc_info(hash) -> hash */
"\n"/*     GC.latest_gc_info(:major_by) -> :malloc */
"\n"/*  */
"\n"/*  Returns information about the most recent garbage collection. */
"\n"/*  */
"\n"/* If the optional argument, hash, is given, */
"\n"/* it is overwritten and returned. */
"\n"/* This is intended to avoid probe effect. */
,
#line 231 "gc.rb"
"  def self.latest_gc_info hash_or_key = nil\n"
"    Primitive.gc_latest_gc_info hash_or_key\n"
"  end\n"
"\n"
"  if respond_to?(:compact)\n"
"\n"/* call-seq: */
"\n"/*    GC.verify_compaction_references(toward: nil, double_heap: false) -> hash */
"\n"/*  */
"\n"/* Verify compaction reference consistency. */
"\n"/*  */
"\n"/* This method is implementation specific.  During compaction, objects that */
"\n"/* were moved are replaced with T_MOVED objects.  No object should have a */
"\n"/* reference to a T_MOVED object after compaction. */
"\n"/*  */
"\n"/* This function expands the heap to ensure room to move all objects, */
"\n"/* compacts the heap to make sure everything moves, updates all references, */
"\n"/* then performs a full GC.  If any object contains a reference to a T_MOVED */
"\n"/* object, that object should be pushed on the mark stack, and will */
"\n"/* make a SEGV. */
"    def self.verify_compaction_references(toward: nil, double_heap: false, expand_heap: false)\n"
"      Primitive.gc_verify_compaction_references(double_heap, expand_heap, toward == :empty)\n"
"    end\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*     GC.using_rvargc? -> true or false */
"\n"/*  */
"\n"/* Returns true if using experimental feature Variable Width Allocation, false */
"\n"/* otherwise. */
"  def self.using_rvargc?\n"/* :nodoc: */
"    GC::INTERNAL_CONSTANTS[:SIZE_POOL_COUNT] > 1\n"
"  end\n"
"\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.measure_total_time = true/false */
"\n"/*  */
"\n"/* Enable to measure GC time. */
"\n"/* You can get the result with <tt>GC.stat(:time)</tt>. */
"\n"/* Note that GC time measurement can cause some performance overhead. */
"  def self.measure_total_time=(flag)\n"
"    Primitive.cstmt! %{\n"
,
#line 273 "gc.rb"
"      rb_objspace.flags.measure_gc = RTEST(flag) ? TRUE : FALSE;\n"
"      return flag;\n"
"    }\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.measure_total_time -> true/false */
"\n"/*  */
"\n"/* Return measure_total_time flag (default: +true+). */
"\n"/* Note that measurement can affect the application performance. */
"  def self.measure_total_time\n"
"    Primitive.cexpr! %{\n"
"      RBOOL(rb_objspace.flags.measure_gc)\n"
"    }\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.total_time -> int */
"\n"/*  */
"\n"/* Return measured GC total time in nano seconds. */
"  def self.total_time\n"
"    Primitive.cexpr! %{\n"
"      ULL2NUM(rb_objspace.profile.total_time_ns)\n"
"    }\n"
"  end\n"
"end\n"
"\n"
"module ObjectSpace\n"
"  def garbage_collect full_mark: true, immediate_mark: true, immediate_sweep: true\n"
,
#line 302 "gc.rb"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"  module_function :garbage_collect\n"
"end\n"
#line 870 "miniprelude.c"
};

static const char prelude_name3[] = "<internal:numeric>";
static const struct {
    char L0[508]; /* 1..102 */
    char L102[504]; /* 103..180 */
    char L180[508]; /* 181..270 */
    char L270[497]; /* 271..334 */
    char L334[179]; /* 335..350 */
} prelude_code3 = {
#line 1 "numeric.rb"
"class Numeric\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     num.real?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +num+ is a real number (i.e. not Complex). */
"\n"/*  */
"  def real?\n"
"    return true\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     num.integer?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +num+ is an Integer. */
"\n"/*  */
"\n"/*      1.0.integer?   #=> false */
"\n"/*      1.integer?     #=> true */
"\n"/*  */
"  def integer?\n"
"    return false\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     num.finite?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +num+ is a finite number, otherwise returns +false+. */
"\n"/*  */
"  def finite?\n"
"    return true\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     num.infinite?  ->  -1, 1, or nil */
"\n"/*  */
"\n"/*  Returns +nil+, -1, or 1 depending on whether the value is */
"\n"/*  finite, <code>-Infinity</code>, or <code>+Infinity</code>. */
"\n"/*  */
"  def infinite?\n"
"    return nil\n"
"  end\n"
"end\n"
"\n"
"class Integer\n"
"\n"/* call-seq: */
"\n"/*    -int  ->  integer */
"\n"/*  */
"\n"/* Returns +int+, negated. */
"  def -@\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_uminus(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   ~int  ->  integer */
"\n"/*  */
"\n"/* One's complement: returns a number where each bit is flipped. */
"\n"/*  */
"\n"/* Inverts the bits in an Integer. As integers are conceptually of */
"\n"/* infinite length, the result acts as if it had an infinite number of */
"\n"/* one bits to the left. In hex representations, this is displayed */
"\n"/* as two periods to the left of the digits. */
"\n"/*  */
"\n"/*   sprintf("%X", ~0x1122334455)    #=> "..FEEDDCCBBAA" */
"  def ~\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_comp(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    int.abs        ->  integer */
"\n"/*    int.magnitude  ->  integer */
"\n"/*  */
"\n"/* Returns the absolute value of +int+. */
"\n"/*  */
"\n"/*    (-12345).abs   #=> 12345 */
"\n"/*    -12345.abs     #=> 12345 */
"\n"/*    12345.abs      #=> 12345 */
"\n"/*  */
"\n"/* Integer#magnitude is an alias for Integer#abs. */
"  def abs\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_abs(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    int.bit_length  ->  integer */
"\n"/*  */
"\n"/* Returns the number of bits of the value of +int+. */
"\n"/*  */
"\n"/* "Number of bits" means the bit position of the highest bit */
"\n"/* which is different from the sign bit */
"\n"/* (where the least significant bit has bit position 1). */
"\n"/* If there is no such bit (zero or minus one), zero is returned. */
"\n"/*  */
"\n"/* I.e. this method returns <i>ceil(log2(int < 0 ? -int : int+1))</i>. */
"\n"/*  */
"\n"/*    (-2**1000-1).bit_length   #=> 1001 */
"\n"/*    (-2**1000).bit_length     #=> 1000 */
,
#line 103 "numeric.rb"
"\n"/*    (-2**1000+1).bit_length   #=> 1000 */
"\n"/*    (-2**12-1).bit_length     #=> 13 */
"\n"/*    (-2**12).bit_length       #=> 12 */
"\n"/*    (-2**12+1).bit_length     #=> 12 */
"\n"/*    -0x101.bit_length         #=> 9 */
"\n"/*    -0x100.bit_length         #=> 8 */
"\n"/*    -0xff.bit_length          #=> 8 */
"\n"/*    -2.bit_length             #=> 1 */
"\n"/*    -1.bit_length             #=> 0 */
"\n"/*    0.bit_length              #=> 0 */
"\n"/*    1.bit_length              #=> 1 */
"\n"/*    0xff.bit_length           #=> 8 */
"\n"/*    0x100.bit_length          #=> 9 */
"\n"/*    (2**12-1).bit_length      #=> 12 */
"\n"/*    (2**12).bit_length        #=> 13 */
"\n"/*    (2**12+1).bit_length      #=> 13 */
"\n"/*    (2**1000-1).bit_length    #=> 1000 */
"\n"/*    (2**1000).bit_length      #=> 1001 */
"\n"/*    (2**1000+1).bit_length    #=> 1001 */
"\n"/*  */
"\n"/* This method can be used to detect overflow in Array#pack as follows: */
"\n"/*  */
"\n"/*    if n.bit_length < 32 */
"\n"/*      [n].pack("l") # no overflow */
"\n"/*    else */
"\n"/*      raise "overflow" */
"\n"/*    end */
"  def bit_length\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_bit_length(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.even?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +int+ is an even number. */
"  def even?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_even_p(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.integer?  ->  true */
"\n"/*  */
"\n"/*  Since +int+ is already an Integer, this always returns +true+. */
"  def integer?\n"
"    return true\n"
"  end\n"
"\n"
"  alias magnitude abs\n"
"=begin\n"
"  def magnitude\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_abs(self)'\n"
"  end\n"
"=end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.odd?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +int+ is an odd number. */
"  def odd?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_odd_p(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.ord  ->  self */
"\n"/*  */
"\n"/*  Returns the +int+ itself. */
"\n"/*  */
"\n"/*     97.ord   #=> 97 */
"\n"/*  */
"\n"/*  This method is intended for compatibility to character literals */
"\n"/*  in Ruby 1.9. */
"\n"/*  */
"\n"/*  For example, <code>?a.ord</code> returns 97 both in 1.8 and 1.9. */
"  def ord\n"
,
#line 181 "numeric.rb"
"    return self\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  Document-method: Integer#size */
"\n"/*  call-seq: */
"\n"/*     int.size  ->  int */
"\n"/*  */
"\n"/*  Returns the number of bytes in the machine representation of +int+ */
"\n"/*  (machine dependent). */
"\n"/*  */
"\n"/*     1.size               #=> 8 */
"\n"/*     -1.size              #=> 8 */
"\n"/*     2147483647.size      #=> 8 */
"\n"/*     (256**10 - 1).size   #=> 10 */
"\n"/*     (256**20 - 1).size   #=> 20 */
"\n"/*     (256**40 - 1).size   #=> 40 */
"\n"/*  */
"  def size\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_size(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.to_i    ->  integer */
"\n"/*  */
"\n"/*  Since +int+ is already an Integer, returns +self+. */
"\n"/*  */
"\n"/*  #to_int is an alias for #to_i. */
"  def to_i\n"
"    return self\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.to_int  ->  integer */
"\n"/*  */
"\n"/*  Since +int+ is already an Integer, returns +self+. */
"  def to_int\n"
"    return self\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    int.zero? -> true or false */
"\n"/*  */
"\n"/* Returns +true+ if +int+ has a zero value. */
"  def zero?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_zero_p(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    ceildiv(other) -> integer */
"\n"/*  */
"\n"/*  Returns the result of division +self+ by +other+. The result is rounded up to the nearest integer. */
"\n"/*  */
"\n"/*    3.ceildiv(3) # => 1 */
"\n"/*    4.ceildiv(3) # => 2 */
"\n"/*  */
"\n"/*    4.ceildiv(-3) # => -1 */
"\n"/*    -4.ceildiv(3) # => -1 */
"\n"/*    -4.ceildiv(-3) # => 2 */
"\n"/*  */
"\n"/*    3.ceildiv(1.2) # => 3 */
"  def ceildiv(other)\n"
"    -div(-other)\n"
"  end\n"
"end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    Integer.try_convert(object) -> object, integer, or nil */
"\n"/*  */
"\n"/*  If +object+ is an \Integer object, returns +object+. */
"\n"/*    Integer.try_convert(1) # => 1 */
"\n"/*  */
"\n"/*  Otherwise if +object+ responds to <tt>:to_int</tt>, */
"\n"/*  calls <tt>object.to_int</tt> and returns the result. */
"\n"/*    Integer.try_convert(1.25) # => 1 */
"\n"/*  */
"\n"/*  Returns +nil+ if +object+ does not respond to <tt>:to_int</tt> */
"\n"/*    Integer.try_convert([]) # => nil */
"\n"/*  */
"\n"/*  Raises an exception unless <tt>object.to_int</tt> returns an \Integer object. */
"\n"/*  */
"def Integer.try_convert(num)\n"
"=begin\n"
"  Primitive.attr! 'inline'\n"
"  Primitive.cexpr! 'rb_check_integer_type(num)'\n"
"=end\n"
"end if false\n"
"\n"
,
#line 271 "numeric.rb"
"class Float\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    float.to_f  ->  self */
"\n"/*  */
"\n"/* Since +float+ is already a Float, returns +self+. */
"\n"/*  */
"  def to_f\n"
"    return self\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     float.abs        ->  float */
"\n"/*     float.magnitude  ->  float */
"\n"/*  */
"\n"/*  Returns the absolute value of +float+. */
"\n"/*  */
"\n"/*     (-34.56).abs   #=> 34.56 */
"\n"/*     -34.56.abs     #=> 34.56 */
"\n"/*     34.56.abs      #=> 34.56 */
"\n"/*  */
"\n"/*  Float#magnitude is an alias for Float#abs. */
"\n"/*  */
"  def abs\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_float_abs(self)'\n"
"  end\n"
"\n"
"  def magnitude\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_float_abs(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    -float  ->  float */
"\n"/*  */
"\n"/* Returns +float+, negated. */
"\n"/*  */
"  def -@\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_float_uminus(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     float.zero?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +float+ is 0.0. */
"\n"/*  */
"  def zero?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'RBOOL(FLOAT_ZERO_P(self))'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     float.positive?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +float+ is greater than 0. */
"\n"/*  */
"  def positive?\n"
"    Primitive.attr! 'inline'\n"
,
#line 335 "numeric.rb"
"    Primitive.cexpr! 'RBOOL(RFLOAT_VALUE(self) > 0.0)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     float.negative?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +float+ is less than 0. */
"\n"/*  */
"  def negative?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'RBOOL(RFLOAT_VALUE(self) < 0.0)'\n"
"  end\n"
"\n"
"end\n"
#line 1239 "miniprelude.c"
};

static const char prelude_name4[] = "<internal:io>";
static const struct {
    char L0[336]; /* 1..124 */
} prelude_code4 = {
#line 1 "io.rb"
"class IO\n"
"\n"/* other IO methods are defined in io.c */
"\n"
"\n"/* call-seq: */
"\n"/*    ios.read_nonblock(maxlen [, options])              -> string */
"\n"/*    ios.read_nonblock(maxlen, outbuf [, options])      -> outbuf */
"\n"/*  */
"\n"/* Reads at most <i>maxlen</i> bytes from <em>ios</em> using */
"\n"/* the read(2) system call after O_NONBLOCK is set for */
"\n"/* the underlying file descriptor. */
"\n"/*  */
"\n"/* If the optional <i>outbuf</i> argument is present, */
"\n"/* it must reference a String, which will receive the data. */
"\n"/* The <i>outbuf</i> will contain only the received data after the method call */
"\n"/* even if it is not empty at the beginning. */
"\n"/*  */
"\n"/* read_nonblock just calls the read(2) system call. */
"\n"/* It causes all errors the read(2) system call causes: Errno::EWOULDBLOCK, Errno::EINTR, etc. */
"\n"/* The caller should care such errors. */
"\n"/*  */
"\n"/* If the exception is Errno::EWOULDBLOCK or Errno::EAGAIN, */
"\n"/* it is extended by IO::WaitReadable. */
"\n"/* So IO::WaitReadable can be used to rescue the exceptions for retrying */
"\n"/* read_nonblock. */
"\n"/*  */
"\n"/* read_nonblock causes EOFError on EOF. */
"\n"/*  */
"\n"/* On some platforms, such as Windows, non-blocking mode is not supported */
"\n"/* on IO objects other than sockets. In such cases, Errno::EBADF will */
"\n"/* be raised. */
"\n"/*  */
"\n"/* If the read byte buffer is not empty, */
"\n"/* read_nonblock reads from the buffer like readpartial. */
"\n"/* In this case, the read(2) system call is not called. */
"\n"/*  */
"\n"/* When read_nonblock raises an exception kind of IO::WaitReadable, */
"\n"/* read_nonblock should not be called */
"\n"/* until io is readable for avoiding busy loop. */
"\n"/* This can be done as follows. */
"\n"/*  */
"\n"/*   # emulates blocking read (readpartial). */
"\n"/*   begin */
"\n"/*     result = io.read_nonblock(maxlen) */
"\n"/*   rescue IO::WaitReadable */
"\n"/*     IO.select([io]) */
"\n"/*     retry */
"\n"/*   end */
"\n"/*  */
"\n"/* Although IO#read_nonblock doesn't raise IO::WaitWritable. */
"\n"/* OpenSSL::Buffering#read_nonblock can raise IO::WaitWritable. */
"\n"/* If IO and SSL should be used polymorphically, */
"\n"/* IO::WaitWritable should be rescued too. */
"\n"/* See the document of OpenSSL::Buffering#read_nonblock for sample code. */
"\n"/*  */
"\n"/* Note that this method is identical to readpartial */
"\n"/* except the non-blocking flag is set. */
"\n"/*  */
"\n"/* By specifying a keyword argument _exception_ to +false+, you can indicate */
"\n"/* that read_nonblock should not raise an IO::WaitReadable exception, but */
"\n"/* return the symbol +:wait_readable+ instead. At EOF, it will return nil */
"\n"/* instead of raising EOFError. */
"  def read_nonblock(len, buf = nil, exception: true)\n"
"    Primitive.io_read_nonblock(len, buf, exception)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    ios.write_nonblock(string)   -> integer */
"\n"/*    ios.write_nonblock(string [, options])   -> integer */
"\n"/*  */
"\n"/* Writes the given string to <em>ios</em> using */
"\n"/* the write(2) system call after O_NONBLOCK is set for */
"\n"/* the underlying file descriptor. */
"\n"/*  */
"\n"/* It returns the number of bytes written. */
"\n"/*  */
"\n"/* write_nonblock just calls the write(2) system call. */
"\n"/* It causes all errors the write(2) system call causes: Errno::EWOULDBLOCK, Errno::EINTR, etc. */
"\n"/* The result may also be smaller than string.length (partial write). */
"\n"/* The caller should care such errors and partial write. */
"\n"/*  */
"\n"/* If the exception is Errno::EWOULDBLOCK or Errno::EAGAIN, */
"\n"/* it is extended by IO::WaitWritable. */
"\n"/* So IO::WaitWritable can be used to rescue the exceptions for retrying write_nonblock. */
"\n"/*  */
"\n"/*   # Creates a pipe. */
"\n"/*   r, w = IO.pipe */
"\n"/*  */
"\n"/*   # write_nonblock writes only 65536 bytes and return 65536. */
"\n"/*   # (The pipe size is 65536 bytes on this environment.) */
"\n"/*   s = "a" * 100000 */
"\n"/*   p w.write_nonblock(s)     #=> 65536 */
"\n"/*  */
"\n"/*   # write_nonblock cannot write a byte and raise EWOULDBLOCK (EAGAIN). */
"\n"/*   p w.write_nonblock("b")   # Resource temporarily unavailable (Errno::EAGAIN) */
"\n"/*  */
"\n"/* If the write buffer is not empty, it is flushed at first. */
"\n"/*  */
"\n"/* When write_nonblock raises an exception kind of IO::WaitWritable, */
"\n"/* write_nonblock should not be called */
"\n"/* until io is writable for avoiding busy loop. */
"\n"/* This can be done as follows. */
"\n"/*  */
"\n"/*   begin */
"\n"/*     result = io.write_nonblock(string) */
"\n"/*   rescue IO::WaitWritable, Errno::EINTR */
"\n"/*     IO.select(nil, [io]) */
"\n"/*     retry */
"\n"/*   end */
"\n"/*  */
"\n"/* Note that this doesn't guarantee to write all data in string. */
"\n"/* The length written is reported as result and it should be checked later. */
"\n"/*  */
"\n"/* On some platforms such as Windows, write_nonblock is not supported */
"\n"/* according to the kind of the IO object. */
"\n"/* In such cases, write_nonblock raises <code>Errno::EBADF</code>. */
"\n"/*  */
"\n"/* By specifying a keyword argument _exception_ to +false+, you can indicate */
"\n"/* that write_nonblock should not raise an IO::WaitWritable exception, but */
"\n"/* return the symbol +:wait_writable+ instead. */
"  def write_nonblock(buf, exception: true)\n"
"    Primitive.io_write_nonblock(buf, exception)\n"
"  end\n"
"end\n"
#line 1370 "miniprelude.c"
};

static const char prelude_name5[] = "<internal:marshal>";
static const struct {
    char L0[202]; /* 1..41 */
} prelude_code5 = {
#line 1 "marshal.rb"
"module Marshal\n"
"\n"/* call-seq: */
"\n"/*    load(source, proc = nil, freeze: false) -> obj */
"\n"/*    restore(source, proc = nil, freeze: false) -> obj */
"\n"/*  */
"\n"/* Returns the result of converting the serialized data in source into a */
"\n"/* Ruby object (possibly with associated subordinate objects). source */
"\n"/* may be either an instance of IO or an object that responds to */
"\n"/* to_str. If proc is specified, each object will be passed to the proc, as the object */
"\n"/* is being deserialized. */
"\n"/*  */
"\n"/* Never pass untrusted data (including user supplied input) to this method. */
"\n"/* Please see the overview for further details. */
"\n"/*  */
"\n"/* If the <tt>freeze: true</tt> argument is passed, deserialized object would */
"\n"/* be deeply frozen. Note that it may lead to more efficient memory usage due to */
"\n"/* frozen strings deduplication: */
"\n"/*  */
"\n"/*    serialized = Marshal.dump(['value1', 'value2', 'value1', 'value2']) */
"\n"/*  */
"\n"/*    deserialized = Marshal.load(serialized) */
"\n"/*    deserialized.map(&:frozen?) */
"\n"/*    # => [false, false, false, false] */
"\n"/*    deserialized.map(&:object_id) */
"\n"/*    # => [1023900, 1023920, 1023940, 1023960] -- 4 different objects */
"\n"/*  */
"\n"/*    deserialized = Marshal.load(serialized, freeze: true) */
"\n"/*    deserialized.map(&:frozen?) */
"\n"/*    # => [true, true, true, true] */
"\n"/*    deserialized.map(&:object_id) */
"\n"/*    # => [1039360, 1039380, 1039360, 1039380] -- only 2 different objects, object_ids repeating */
"\n"/*  */
"  def self.load(source, proc = nil, freeze: false)\n"
"    Primitive.marshal_load(source, proc, freeze)\n"
"  end\n"
"\n"
"  class << self\n"
"    alias restore load\n"
"  end\n"
"end\n"
#line 1418 "miniprelude.c"
};

static const char prelude_name6[] = "<internal:mjit>";
static const struct {
    char L0[238]; /* 1..14 */
} prelude_code6 = {
#line 1 "mjit.rb"
"module RubyVM::MJIT\n"
"  def self.enabled?\n"
"    Primitive.cexpr! 'RBOOL(mjit_enabled)'\n"
"  end\n"
"\n"
"  def self.pause(wait: true)\n"
"    Primitive.cexpr! 'mjit_pause(RTEST(wait))'\n"
"  end\n"
"\n"
"  def self.resume\n"
"    Primitive.cexpr! 'mjit_resume()'\n"
"  end\n"
"end\n"
#line 1439 "miniprelude.c"
};

static const char prelude_name7[] = "<internal:mjit_compiler>";
static const struct {
    char L0[491]; /* 1..26 */
    char L26[440]; /* 27..41 */
    char L41[497]; /* 42..59 */
    char L59[488]; /* 60..73 */
    char L73[467]; /* 74..82 */
    char L82[459]; /* 83..94 */
    char L94[479]; /* 95..113 */
    char L113[441]; /* 114..128 */
    char L128[321]; /* 129..137 */
} prelude_code7 = {
#line 1 "mjit_compiler.rb"
""/* frozen_string_literal: true */
""/* TODO: Merge this to mjit.rb */
"if RubyVM::MJIT.enabled?\n"
"  begin\n"
"    require 'etc'\n"
"    require 'fiddle'\n"
"  rescue LoadError\n"
"    return\n"/* skip miniruby */
"  end\n"
"\n"
"  if Fiddle::SIZEOF_VOIDP == 8\n"
"    require 'mjit/c_64'\n"
"  else\n"
"    require 'mjit/c_32'\n"
"  end\n"
"\n"
"  class << RubyVM::MJIT::C\n"
"    def ROBJECT_EMBED_LEN_MAX\n"
"      Primitive.cexpr! 'INT2NUM(RBIMPL_EMBED_LEN_MAX_OF(VALUE))'\n"
"    end\n"
"\n"
"    def cdhash_to_hash(cdhash_addr)\n"
"      Primitive.cdhash_to_hash(cdhash_addr)\n"
"    end\n"
"\n"
"    def builtin_compiler(f, bf, index, stack_size, builtin_inline_p)\n"
,
#line 27 "mjit_compiler.rb"
"      Primitive.builtin_compile(f, bf.to_i, index, stack_size, builtin_inline_p)\n"
"    end\n"
"\n"
"    def has_cache_for_send(cc, insn)\n"
"      Primitive.has_cache_for_send(cc.to_i, insn)\n"
"    end\n"
"\n"
"    def rb_iseq_check(iseq)\n"
"      _iseq_addr = iseq.to_i\n"
"      iseq_addr = Primitive.cexpr! 'PTR2NUM((VALUE)rb_iseq_check((rb_iseq_t *)NUM2PTR(_iseq_addr)))'\n"
"      rb_iseq_t.new(iseq_addr)\n"
"    end\n"
"\n"
"    def rb_iseq_path(iseq)\n"
"      _iseq_addr = iseq.to_i\n"
,
#line 42 "mjit_compiler.rb"
"      Primitive.cexpr! 'rb_iseq_path((rb_iseq_t *)NUM2PTR(_iseq_addr))'\n"
"    end\n"
"\n"
"    def vm_ci_argc(ci)\n"
"      _ci_addr = ci.to_i\n"
"      Primitive.cexpr! 'UINT2NUM(vm_ci_argc((CALL_INFO)NUM2PTR(_ci_addr)))'\n"
"    end\n"
"\n"
"    def vm_ci_flag(ci)\n"
"      _ci_addr = ci.to_i\n"
"      Primitive.cexpr! 'UINT2NUM(vm_ci_flag((CALL_INFO)NUM2PTR(_ci_addr)))'\n"
"    end\n"
"\n"
"    def rb_splat_or_kwargs_p(ci)\n"
"      _ci_addr = ci.to_i\n"
"      Primitive.cexpr! 'RBOOL(rb_splat_or_kwargs_p((CALL_INFO)NUM2PTR(_ci_addr)))'\n"
"    end\n"
"\n"
,
#line 60 "mjit_compiler.rb"
"    def fastpath_applied_iseq_p(ci, cc, iseq)\n"
"      _ci_addr = ci.to_i\n"
"      _cc_addr = cc.to_i\n"
"      _iseq_addr = iseq.to_i\n"
"      Primitive.cexpr! 'RBOOL(fastpath_applied_iseq_p((CALL_INFO)NUM2PTR(_ci_addr), (CALL_CACHE)NUM2PTR(_cc_addr), (rb_iseq_t *)NUM2PTR(_iseq_addr)))'\n"
"    end\n"
"\n"
"    def mjit_opts\n"
"      addr = Primitive.cexpr! 'PTR2NUM((VALUE)&mjit_opts)'\n"
"      mjit_options.new(addr)\n"
"    end\n"
"\n"
"    def mjit_call_attribute_sp_inc(insn, operands)\n"
"      _operands_addr = operands.to_i\n"
,
#line 74 "mjit_compiler.rb"
"      Primitive.cexpr! 'LONG2NUM(mjit_call_attribute_sp_inc(NUM2INT(insn), (VALUE *)NUM2PTR(_operands_addr)))'\n"
"    end\n"
"\n"
"    def mjit_capture_cc_entries(compiled_body, captured_body)\n"
"      _compiled_body_addr = compiled_body.to_i\n"
"      _captured_body_addr = captured_body.to_i\n"
"      Primitive.cexpr! 'INT2NUM(mjit_capture_cc_entries((struct rb_iseq_constant_body *)NUM2PTR(_compiled_body_addr), (struct rb_iseq_constant_body *)NUM2PTR(_captured_body_addr)))'\n"
"    end\n"
"\n"
,
#line 83 "mjit_compiler.rb"
"    #const struct rb_iseq_constant_body *body, union iseq_inline_storage_entry *is_entries\n"
"    def mjit_capture_is_entries(body, is_entries)\n"
"      _body_addr = body.to_i\n"
"      _is_entries_addr = is_entries.to_i\n"
"      Primitive.cstmt! %{\n"
"        mjit_capture_is_entries((struct rb_iseq_constant_body *)NUM2PTR(_body_addr), (union iseq_inline_storage_entry *)NUM2PTR(_is_entries_addr));\n"
"        return Qnil;\n"
"      }\n"
"    end\n"
"\n"
"\n"/* Convert encoded VM pointers to insn BINs. */
"    def rb_vm_insn_decode(encoded)\n"
,
#line 95 "mjit_compiler.rb"
"      Primitive.cexpr! 'INT2NUM(rb_vm_insn_decode(NUM2PTR(encoded)))'\n"
"    end\n"
"\n"
"\n"/* Convert insn BINs to encoded VM pointers. This one is not used by the compiler, but useful for debugging. */
"    def rb_vm_insn_encode(bin)\n"
"      Primitive.cexpr! 'PTR2NUM((VALUE)rb_vm_get_insns_address_table()[NUM2INT(bin)])'\n"
"    end\n"
"\n"
"    def insn_may_depend_on_sp_or_pc(insn, opes)\n"
"      _opes_addr = opes.to_i\n"
"      Primitive.cexpr! 'RBOOL(insn_may_depend_on_sp_or_pc(NUM2INT(insn), (VALUE *)NUM2PTR(_opes_addr)))'\n"
"    end\n"
"\n"
"\n"/* Convert Integer VALUE to an actual Ruby object */
"    def to_ruby(value)\n"
"      Primitive.cexpr! '(VALUE)NUM2PTR(value)'\n"
"    end\n"
"\n"
"\n"/* Convert RubyVM::InstructionSequence to C.rb_iseq_t. Not used by the compiler, but useful for debugging. */
,
#line 114 "mjit_compiler.rb"
"    def rb_iseqw_to_iseq(iseqw)\n"
"      iseq_addr = Primitive.cexpr! 'PTR2NUM((VALUE)rb_iseqw_to_iseq(iseqw))'\n"
"      rb_iseq_t.new(iseq_addr)\n"
"    end\n"
"\n"
"\n"/* TODO: remove this after migration */
"    def fprintf(f, str)\n"
"      Primitive.cstmt! %{\n"
"        fprintf((FILE *)NUM2PTR(f), \"%s\", RSTRING_PTR(str));\n"
"        return Qnil;\n"
"      }\n"
"    end\n"
"\n"
"    def rb_cFalseClass; Primitive.cexpr! 'PTR2NUM(rb_cFalseClass)' end\n"
"    def rb_cNilClass;   Primitive.cexpr! 'PTR2NUM(rb_cNilClass)'   end\n"
,
#line 129 "mjit_compiler.rb"
"    def rb_cTrueClass;  Primitive.cexpr! 'PTR2NUM(rb_cTrueClass)'  end\n"
"    def rb_cInteger;    Primitive.cexpr! 'PTR2NUM(rb_cInteger)'    end\n"
"    def rb_cSymbol;     Primitive.cexpr! 'PTR2NUM(rb_cSymbol)'     end\n"
"    def rb_cFloat;      Primitive.cexpr! 'PTR2NUM(rb_cFloat)'      end\n"
"  end\n"
"\n"
"  require \"mjit/compiler\"\n"
"end\n"
#line 1607 "miniprelude.c"
};

static const char prelude_name8[] = "<internal:mjit_instruction>";
static const struct {
    char L0[483]; /* 1..32 */
    char L32[463]; /* 33..48 */
    char L48[476]; /* 49..62 */
    char L62[486]; /* 63..72 */
    char L72[507]; /* 73..89 */
    char L89[446]; /* 90..100 */
    char L100[494]; /* 101..118 */
    char L118[487]; /* 119..128 */
    char L128[484]; /* 129..145 */
    char L145[499]; /* 146..158 */
    char L158[494]; /* 159..174 */
    char L174[480]; /* 175..190 */
    char L190[497]; /* 191..203 */
    char L203[504]; /* 204..220 */
    char L220[484]; /* 221..233 */
    char L233[508]; /* 234..248 */
    char L248[454]; /* 249..265 */
    char L265[450]; /* 266..279 */
    char L279[485]; /* 280..291 */
    char L291[455]; /* 292..306 */
    char L306[446]; /* 307..317 */
    char L317[458]; /* 318..333 */
    char L333[496]; /* 334..347 */
    char L347[490]; /* 348..360 */
    char L360[505]; /* 361..379 */
    char L379[498]; /* 380..398 */
    char L398[482]; /* 399..423 */
    char L423[460]; /* 424..443 */
    char L443[498]; /* 444..461 */
    char L461[487]; /* 462..477 */
    char L477[480]; /* 478..495 */
    char L495[498]; /* 496..510 */
    char L510[494]; /* 511..526 */
    char L526[486]; /* 527..540 */
    char L540[464]; /* 541..558 */
    char L558[450]; /* 559..574 */
    char L574[488]; /* 575..591 */
    char L591[507]; /* 592..608 */
    char L608[506]; /* 609..626 */
    char L626[493]; /* 627..643 */
    char L643[488]; /* 644..657 */
    char L657[448]; /* 658..673 */
    char L673[467]; /* 674..690 */
    char L690[505]; /* 691..708 */
    char L708[490]; /* 709..726 */
    char L726[480]; /* 727..737 */
    char L737[504]; /* 738..760 */
    char L760[489]; /* 761..777 */
    char L777[505]; /* 778..799 */
    char L799[490]; /* 800..814 */
    char L814[508]; /* 815..838 */
    char L838[501]; /* 839..857 */
    char L857[499]; /* 858..874 */
    char L874[499]; /* 875..896 */
    char L896[331]; /* 897..910 */
    char L910[500]; /* 911..921 */
    char L921[490]; /* 922..931 */
    char L931[410]; /* 932..946 */
    char L946[507]; /* 947..962 */
    char L962[491]; /* 963..975 */
    char L975[468]; /* 976..987 */
    char L987[458]; /* 988..995 */
    char L995[465]; /* 996..1010 */
    char L1010[506]; /* 1011..1028 */
    char L1028[507]; /* 1029..1043 */
    char L1043[503]; /* 1044..1055 */
    char L1055[489]; /* 1056..1076 */
    char L1076[505]; /* 1077..1093 */
    char L1093[484]; /* 1094..1107 */
    char L1107[504]; /* 1108..1124 */
    char L1124[489]; /* 1125..1144 */
    char L1144[489]; /* 1145..1160 */
    char L1160[486]; /* 1161..1173 */
    char L1173[502]; /* 1174..1190 */
    char L1190[448]; /* 1191..1206 */
    char L1206[506]; /* 1207..1226 */
    char L1226[498]; /* 1227..1237 */
    char L1237[503]; /* 1238..1255 */
    char L1255[506]; /* 1256..1275 */
    char L1275[502]; /* 1276..1298 */
    char L1298[489]; /* 1299..1310 */
    char L1310[488]; /* 1311..1331 */
    char L1331[501]; /* 1332..1351 */
    char L1351[501]; /* 1352..1370 */
    char L1370[474]; /* 1371..1390 */
    char L1390[455]; /* 1391..1407 */
    char L1407[507]; /* 1408..1426 */
    char L1426[492]; /* 1427..1437 */
    char L1437[486]; /* 1438..1453 */
    char L1453[487]; /* 1454..1473 */
    char L1473[493]; /* 1474..1488 */
    char L1488[507]; /* 1489..1500 */
    char L1500[424]; /* 1501..1518 */
    char L1518[494]; /* 1519..1537 */
    char L1537[494]; /* 1538..1547 */
    char L1547[501]; /* 1548..1563 */
    char L1563[493]; /* 1564..1582 */
    char L1582[503]; /* 1583..1593 */
    char L1593[446]; /* 1594..1607 */
    char L1607[481]; /* 1608..1627 */
    char L1627[489]; /* 1628..1642 */
    char L1642[507]; /* 1643..1654 */
    char L1654[422]; /* 1655..1672 */
    char L1672[495]; /* 1673..1691 */
    char L1691[494]; /* 1692..1701 */
    char L1701[484]; /* 1702..1717 */
    char L1717[481]; /* 1718..1737 */
    char L1737[493]; /* 1738..1752 */
    char L1752[508]; /* 1753..1764 */
    char L1764[436]; /* 1765..1782 */
    char L1782[495]; /* 1783..1796 */
    char L1796[431]; /* 1797..1811 */
    char L1811[477]; /* 1812..1827 */
    char L1827[488]; /* 1828..1839 */
    char L1839[471]; /* 1840..1858 */
    char L1858[450]; /* 1859..1877 */
    char L1877[491]; /* 1878..1890 */
    char L1890[506]; /* 1891..1906 */
    char L1906[484]; /* 1907..1925 */
    char L1925[489]; /* 1926..1945 */
    char L1945[483]; /* 1946..1961 */
    char L1961[486]; /* 1962..1972 */
    char L1972[486]; /* 1973..1988 */
    char L1988[440]; /* 1989..2003 */
    char L2003[443]; /* 2004..2016 */
    char L2016[411]; /* 2017..2033 */
    char L2033[504]; /* 2034..2044 */
    char L2044[462]; /* 2045..2057 */
    char L2057[431]; /* 2058..2073 */
    char L2073[498]; /* 2074..2086 */
    char L2086[498]; /* 2087..2097 */
    char L2097[507]; /* 2098..2114 */
    char L2114[489]; /* 2115..2132 */
    char L2132[494]; /* 2133..2151 */
    char L2151[261]; /* 2152..2163 */
} prelude_code8 = {
#line 1 "mjit_instruction.rb"
"module RubyVM::MJIT\n"
"  Instruction = Struct.new(\n"
"    :name,\n"
"    :bin,\n"
"    :len,\n"
"    :expr,\n"
"    :declarations,\n"
"    :preamble,\n"
"    :opes,\n"
"    :pops,\n"
"    :rets,\n"
"    :always_leaf?,\n"
"    :leaf_without_check_ints?,\n"
"    :handles_sp?,\n"
"  )\n"
"\n"
"  INSNS = {\n"
"    0 => Instruction.new(\n"
"      name: :nop,\n"
"      bin: 0,\n"/* BIN(nop) */
"      len: 1,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    /* none */\n"
"}\n"
"      EXPR\n"
"      declarations: [],\n"
"      preamble: [],\n"
"      opes: [],\n"
"      pops: [],\n"
"      rets: [],\n"
"      always_leaf?: true,\n"
,
#line 33 "mjit_instruction.rb"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    1 => Instruction.new(\n"
"      name: :getlocal,\n"
"      bin: 1,\n"/* BIN(getlocal) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = *(vm_get_ep(GET_EP(), level) - idx);\n"
"    RB_DEBUG_COUNTER_INC(lvar_get);\n"
"    (void)RB_DEBUG_COUNTER_INC_IF(lvar_get_dynamic, level > 0);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(lindex_t) idx\", \"MAYBE_UNUSED(rb_num_t) level\"],\n"
"      preamble: [],\n"
,
#line 49 "mjit_instruction.rb"
"      opes: [{:decl=>\"lindex_t idx\", :type=>\"lindex_t\", :name=>\"idx\"}, {:decl=>\"rb_num_t level\", :type=>\"rb_num_t\", :name=>\"level\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    2 => Instruction.new(\n"
"      name: :setlocal,\n"
"      bin: 2,\n"/* BIN(setlocal) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    vm_env_write(vm_get_ep(GET_EP(), level), -(int)idx, val);\n"
,
#line 63 "mjit_instruction.rb"
"    RB_DEBUG_COUNTER_INC(lvar_set);\n"
"    (void)RB_DEBUG_COUNTER_INC_IF(lvar_set_dynamic, level > 0);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(lindex_t) idx\", \"MAYBE_UNUSED(rb_num_t) level\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"lindex_t idx\", :type=>\"lindex_t\", :name=>\"idx\"}, {:decl=>\"rb_num_t level\", :type=>\"rb_num_t\", :name=>\"level\"}],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      rets: [],\n"
"      always_leaf?: true,\n"
,
#line 73 "mjit_instruction.rb"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    3 => Instruction.new(\n"
"      name: :getblockparam,\n"
"      bin: 3,\n"/* BIN(getblockparam) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    const VALUE *ep = vm_get_ep(GET_EP(), level);\n"
"    VM_ASSERT(VM_ENV_LOCAL_P(ep));\n"
"\n"
"    if (!VM_ENV_FLAGS(ep, VM_FRAME_FLAG_MODIFIED_BLOCK_PARAM)) {\n"
"        val = rb_vm_bh_to_procval(ec, VM_ENV_BLOCK_HANDLER(ep));\n"
"        vm_env_write(ep, -(int)idx, val);\n"
"        VM_ENV_FLAGS_SET(ep, VM_FRAME_FLAG_MODIFIED_BLOCK_PARAM);\n"
"    }\n"
,
#line 90 "mjit_instruction.rb"
"    else {\n"
"        val = *(ep - idx);\n"
"        RB_DEBUG_COUNTER_INC(lvar_get);\n"
"        (void)RB_DEBUG_COUNTER_INC_IF(lvar_get_dynamic, level > 0);\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(lindex_t) idx\", \"MAYBE_UNUSED(rb_num_t) level\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"lindex_t idx\", :type=>\"lindex_t\", :name=>\"idx\"}, {:decl=>\"rb_num_t level\", :type=>\"rb_num_t\", :name=>\"level\"}],\n"
"      pops: [],\n"
,
#line 101 "mjit_instruction.rb"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    4 => Instruction.new(\n"
"      name: :setblockparam,\n"
"      bin: 4,\n"/* BIN(setblockparam) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    const VALUE *ep = vm_get_ep(GET_EP(), level);\n"
"    VM_ASSERT(VM_ENV_LOCAL_P(ep));\n"
"\n"
"    vm_env_write(ep, -(int)idx, val);\n"
"    RB_DEBUG_COUNTER_INC(lvar_set);\n"
"    (void)RB_DEBUG_COUNTER_INC_IF(lvar_set_dynamic, level > 0);\n"
"\n"
,
#line 119 "mjit_instruction.rb"
"    VM_ENV_FLAGS_SET(ep, VM_FRAME_FLAG_MODIFIED_BLOCK_PARAM);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(lindex_t) idx\", \"MAYBE_UNUSED(rb_num_t) level\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"lindex_t idx\", :type=>\"lindex_t\", :name=>\"idx\"}, {:decl=>\"rb_num_t level\", :type=>\"rb_num_t\", :name=>\"level\"}],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      rets: [],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
,
#line 129 "mjit_instruction.rb"
"      handles_sp?: false,\n"
"    ),\n"
"    5 => Instruction.new(\n"
"      name: :getblockparamproxy,\n"
"      bin: 5,\n"/* BIN(getblockparamproxy) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    const VALUE *ep = vm_get_ep(GET_EP(), level);\n"
"    VM_ASSERT(VM_ENV_LOCAL_P(ep));\n"
"\n"
"    if (!VM_ENV_FLAGS(ep, VM_FRAME_FLAG_MODIFIED_BLOCK_PARAM)) {\n"
"        VALUE block_handler = VM_ENV_BLOCK_HANDLER(ep);\n"
"\n"
"        if (block_handler) {\n"
"            switch (vm_block_handler_type(block_handler)) {\n"
"              case block_handler_type_iseq:\n"
,
#line 146 "mjit_instruction.rb"
"              case block_handler_type_ifunc:\n"
"                val = rb_block_param_proxy;\n"
"                break;\n"
"              case block_handler_type_symbol:\n"
"                val = rb_sym_to_proc(VM_BH_TO_SYMBOL(block_handler));\n"
"                goto INSN_LABEL(set);\n"
"              case block_handler_type_proc:\n"
"                val = VM_BH_TO_PROC(block_handler);\n"
"                goto INSN_LABEL(set);\n"
"              default:\n"
"                VM_UNREACHABLE(getblockparamproxy);\n"
"            }\n"
"        }\n"
,
#line 159 "mjit_instruction.rb"
"        else {\n"
"            val = Qnil;\n"
"          INSN_LABEL(set):\n"
"            vm_env_write(ep, -(int)idx, val);\n"
"            VM_ENV_FLAGS_SET(ep, VM_FRAME_FLAG_MODIFIED_BLOCK_PARAM);\n"
"        }\n"
"    }\n"
"    else {\n"
"        val = *(ep - idx);\n"
"        RB_DEBUG_COUNTER_INC(lvar_get);\n"
"        (void)RB_DEBUG_COUNTER_INC_IF(lvar_get_dynamic, level > 0);\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(lindex_t) idx\", \"MAYBE_UNUSED(rb_num_t) level\"],\n"
"      preamble: [],\n"
,
#line 175 "mjit_instruction.rb"
"      opes: [{:decl=>\"lindex_t idx\", :type=>\"lindex_t\", :name=>\"idx\"}, {:decl=>\"rb_num_t level\", :type=>\"rb_num_t\", :name=>\"level\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    6 => Instruction.new(\n"
"      name: :getspecial,\n"
"      bin: 6,\n"/* BIN(getspecial) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_getspecial(ec, GET_LEP(), key, type);\n"
"}\n"
"      EXPR\n"
,
#line 191 "mjit_instruction.rb"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(rb_num_t) key, type\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t key\", :type=>\"rb_num_t\", :name=>\"key\"}, {:decl=>\"rb_num_t type\", :type=>\"rb_num_t\", :name=>\"type\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    7 => Instruction.new(\n"
"      name: :setspecial,\n"
"      bin: 7,\n"/* BIN(setspecial) */
"      len: 2,\n"/* insn_len */
,
#line 204 "mjit_instruction.rb"
"      expr: <<-EXPR,\n"
"{\n"
"    lep_svar_set(ec, GET_LEP(), key, obj);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) obj\", \"MAYBE_UNUSED(rb_num_t) key\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t key\", :type=>\"rb_num_t\", :name=>\"key\"}],\n"
"      pops: [{:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    8 => Instruction.new(\n"
"      name: :getinstancevariable,\n"
"      bin: 8,\n"/* BIN(getinstancevariable) */
,
#line 221 "mjit_instruction.rb"
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_getinstancevariable(GET_ISEQ(), GET_SELF(), id, ic);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(ID) id\", \"MAYBE_UNUSED(IVC) ic\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"ID id\", :type=>\"ID\", :name=>\"id\"}, {:decl=>\"IVC ic\", :type=>\"IVC\", :name=>\"ic\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
,
#line 234 "mjit_instruction.rb"
"      handles_sp?: false,\n"
"    ),\n"
"    9 => Instruction.new(\n"
"      name: :setinstancevariable,\n"
"      bin: 9,\n"/* BIN(setinstancevariable) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    vm_setinstancevariable(GET_ISEQ(), GET_SELF(), id, val, ic);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(ID) id\", \"MAYBE_UNUSED(IVC) ic\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"ID id\", :type=>\"ID\", :name=>\"id\"}, {:decl=>\"IVC ic\", :type=>\"IVC\", :name=>\"ic\"}],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
,
#line 249 "mjit_instruction.rb"
"      rets: [],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    10 => Instruction.new(\n"
"      name: :getclassvariable,\n"
"      bin: 10,\n"/* BIN(getclassvariable) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    rb_control_frame_t *cfp = GET_CFP();\n"
"    val = vm_getclassvariable(GET_ISEQ(), cfp, id, ic);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(ICVARC) ic\", \"MAYBE_UNUSED(ID) id\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
,
#line 266 "mjit_instruction.rb"
"      opes: [{:decl=>\"ID id\", :type=>\"ID\", :name=>\"id\"}, {:decl=>\"ICVARC ic\", :type=>\"ICVARC\", :name=>\"ic\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    11 => Instruction.new(\n"
"      name: :setclassvariable,\n"
"      bin: 11,\n"/* BIN(setclassvariable) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    vm_ensure_not_refinement_module(GET_SELF());\n"
,
#line 280 "mjit_instruction.rb"
"    vm_setclassvariable(GET_ISEQ(), GET_CFP(), id,  val, ic);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(ICVARC) ic\", \"MAYBE_UNUSED(ID) id\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"ID id\", :type=>\"ID\", :name=>\"id\"}, {:decl=>\"ICVARC ic\", :type=>\"ICVARC\", :name=>\"ic\"}],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      rets: [],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
,
#line 292 "mjit_instruction.rb"
"    12 => Instruction.new(\n"
"      name: :opt_getconstant_path,\n"
"      bin: 12,\n"/* BIN(opt_getconstant_path) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    const ID *segments = ic->segments;\n"
"    struct iseq_inline_constant_cache_entry *ice = ic->entry;\n"
"    if (ice && vm_ic_hit_p(ice, GET_EP())) {\n"
"        val = ice->value;\n"
"\n"
"        VM_ASSERT(val == vm_get_ev_const_chain(ec, segments));\n"
"    } else {\n"
"        ruby_vm_constant_cache_misses++;\n"
"        val = vm_get_ev_const_chain(ec, segments);\n"
,
#line 307 "mjit_instruction.rb"
"        vm_ic_track_const_chain(GET_CFP(), ic, segments);\n"
"        // Because leaf=false, we need to undo the PC increment to get the address to this instruction\n"
"        // INSN_ATTR(width) == 2\n"
"        vm_ic_update(GET_ISEQ(), ic, val, GET_EP(), GET_PC() - 2);\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(IC) ic\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"IC ic\", :type=>\"IC\", :name=>\"ic\"}],\n"
"      pops: [],\n"
,
#line 318 "mjit_instruction.rb"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    13 => Instruction.new(\n"
"      name: :getconstant,\n"
"      bin: 13,\n"/* BIN(getconstant) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_get_ev_const(ec, klass, id, allow_nil == Qtrue, 0);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(ID) id\", \"MAYBE_UNUSED(VALUE) allow_nil, klass, val\"],\n"
"      preamble: [],\n"
,
#line 334 "mjit_instruction.rb"
"      opes: [{:decl=>\"ID id\", :type=>\"ID\", :name=>\"id\"}],\n"
"      pops: [{:decl=>\"VALUE klass\", :type=>\"VALUE\", :name=>\"klass\"}, {:decl=>\"VALUE allow_nil\", :type=>\"VALUE\", :name=>\"allow_nil\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    14 => Instruction.new(\n"
"      name: :setconstant,\n"
"      bin: 14,\n"/* BIN(setconstant) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    vm_check_if_namespace(cbase);\n"
,
#line 348 "mjit_instruction.rb"
"    vm_ensure_not_refinement_module(GET_SELF());\n"
"    rb_const_set(cbase, id, val);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(ID) id\", \"MAYBE_UNUSED(VALUE) cbase, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"ID id\", :type=>\"ID\", :name=>\"id\"}],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}, {:decl=>\"VALUE cbase\", :type=>\"VALUE\", :name=>\"cbase\"}],\n"
"      rets: [],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
,
#line 361 "mjit_instruction.rb"
"    15 => Instruction.new(\n"
"      name: :getglobal,\n"
"      bin: 15,\n"/* BIN(getglobal) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = rb_gvar_get(gid);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(ID) gid\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"ID gid\", :type=>\"ID\", :name=>\"gid\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    16 => Instruction.new(\n"
,
#line 380 "mjit_instruction.rb"
"      name: :setglobal,\n"
"      bin: 16,\n"/* BIN(setglobal) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    rb_gvar_set(gid, val);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(ID) gid\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"ID gid\", :type=>\"ID\", :name=>\"gid\"}],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      rets: [],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    17 => Instruction.new(\n"
"      name: :putnil,\n"
,
#line 399 "mjit_instruction.rb"
"      bin: 17,\n"/* BIN(putnil) */
"      len: 1,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = Qnil;\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    18 => Instruction.new(\n"
"      name: :putself,\n"
"      bin: 18,\n"/* BIN(putself) */
"      len: 1,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = GET_SELF();\n"
"}\n"
"      EXPR\n"
,
#line 424 "mjit_instruction.rb"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    19 => Instruction.new(\n"
"      name: :putobject,\n"
"      bin: 19,\n"/* BIN(putobject) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    /* */\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
,
#line 444 "mjit_instruction.rb"
"      opes: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    20 => Instruction.new(\n"
"      name: :putspecialobject,\n"
"      bin: 20,\n"/* BIN(putspecialobject) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    enum vm_special_object_type type;\n"
"\n"
"    type = (enum vm_special_object_type)value_type;\n"
"    val = vm_get_special_object(GET_EP(), type);\n"
"}\n"
,
#line 462 "mjit_instruction.rb"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(rb_num_t) value_type\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t value_type\", :type=>\"rb_num_t\", :name=>\"value_type\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    21 => Instruction.new(\n"
"      name: :putstring,\n"
"      bin: 21,\n"/* BIN(putstring) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
,
#line 478 "mjit_instruction.rb"
"    val = rb_ec_str_resurrect(ec, str);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) str, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"VALUE str\", :type=>\"VALUE\", :name=>\"str\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    22 => Instruction.new(\n"
"      name: :concatstrings,\n"
"      bin: 22,\n"/* BIN(concatstrings) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
,
#line 496 "mjit_instruction.rb"
"    val = rb_str_concat_literals(num, STACK_ADDR_FROM_TOP(num));\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(rb_num_t) num\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t num\", :type=>\"rb_num_t\", :name=>\"num\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    23 => Instruction.new(\n"
"      name: :anytostring,\n"
"      bin: 23,\n"/* BIN(anytostring) */
,
#line 511 "mjit_instruction.rb"
"      len: 1,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = rb_obj_as_string_result(str, val);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) str, val\"],\n"
"      preamble: [],\n"
"      opes: [],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}, {:decl=>\"VALUE str\", :type=>\"VALUE\", :name=>\"str\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    24 => Instruction.new(\n"
,
#line 527 "mjit_instruction.rb"
"      name: :toregexp,\n"
"      bin: 24,\n"/* BIN(toregexp) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    const VALUE ary = rb_ary_tmp_new_from_values(0, cnt, STACK_ADDR_FROM_TOP(cnt));\n"
"    val = rb_reg_new_ary(ary, (int)opt);\n"
"    rb_ary_clear(ary);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(rb_num_t) cnt, opt\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t opt\", :type=>\"rb_num_t\", :name=>\"opt\"}, {:decl=>\"rb_num_t cnt\", :type=>\"rb_num_t\", :name=>\"cnt\"}],\n"
"      pops: [],\n"
,
#line 541 "mjit_instruction.rb"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    25 => Instruction.new(\n"
"      name: :intern,\n"
"      bin: 25,\n"/* BIN(intern) */
"      len: 1,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    sym = rb_str_intern(str);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) str, sym\"],\n"
"      preamble: [],\n"
"      opes: [],\n"
"      pops: [{:decl=>\"VALUE str\", :type=>\"VALUE\", :name=>\"str\"}],\n"
,
#line 559 "mjit_instruction.rb"
"      rets: [{:decl=>\"VALUE sym\", :type=>\"VALUE\", :name=>\"sym\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    26 => Instruction.new(\n"
"      name: :newarray,\n"
"      bin: 26,\n"/* BIN(newarray) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = rb_ec_ary_new_from_values(ec, num, STACK_ADDR_FROM_TOP(num));\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(rb_num_t) num\"],\n"
"      preamble: [],\n"
,
#line 575 "mjit_instruction.rb"
"      opes: [{:decl=>\"rb_num_t num\", :type=>\"rb_num_t\", :name=>\"num\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    27 => Instruction.new(\n"
"      name: :newarraykwsplat,\n"
"      bin: 27,\n"/* BIN(newarraykwsplat) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    if (RHASH_EMPTY_P(*STACK_ADDR_FROM_TOP(1))) {\n"
"        val = rb_ary_new4(num-1, STACK_ADDR_FROM_TOP(num));\n"
"    }\n"
"    else {\n"
,
#line 592 "mjit_instruction.rb"
"        val = rb_ary_new4(num, STACK_ADDR_FROM_TOP(num));\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(rb_num_t) num\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t num\", :type=>\"rb_num_t\", :name=>\"num\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    28 => Instruction.new(\n"
"      name: :duparray,\n"
"      bin: 28,\n"/* BIN(duparray) */
"      len: 2,\n"/* insn_len */
,
#line 609 "mjit_instruction.rb"
"      expr: <<-EXPR,\n"
"{\n"
"    RUBY_DTRACE_CREATE_HOOK(ARRAY, RARRAY_LEN(ary));\n"
"    val = rb_ary_resurrect(ary);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) ary, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"VALUE ary\", :type=>\"VALUE\", :name=>\"ary\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    29 => Instruction.new(\n"
"      name: :duphash,\n"
"      bin: 29,\n"/* BIN(duphash) */
,
#line 627 "mjit_instruction.rb"
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    RUBY_DTRACE_CREATE_HOOK(HASH, RHASH_SIZE(hash) << 1);\n"
"    val = rb_hash_resurrect(hash);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) hash, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"VALUE hash\", :type=>\"VALUE\", :name=>\"hash\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    30 => Instruction.new(\n"
,
#line 644 "mjit_instruction.rb"
"      name: :expandarray,\n"
"      bin: 30,\n"/* BIN(expandarray) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    vm_expandarray(GET_SP(), ary, num, (int)flag);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) ary\", \"MAYBE_UNUSED(rb_num_t) flag, num\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t num\", :type=>\"rb_num_t\", :name=>\"num\"}, {:decl=>\"rb_num_t flag\", :type=>\"rb_num_t\", :name=>\"flag\"}],\n"
"      pops: [{:decl=>\"VALUE ary\", :type=>\"VALUE\", :name=>\"ary\"}],\n"
"      rets: [],\n"
"      always_leaf?: false,\n"
,
#line 658 "mjit_instruction.rb"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    31 => Instruction.new(\n"
"      name: :concatarray,\n"
"      bin: 31,\n"/* BIN(concatarray) */
"      len: 1,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    ary = vm_concat_array(ary1, ary2);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) ary, ary1, ary2\"],\n"
"      preamble: [],\n"
"      opes: [],\n"
"      pops: [{:decl=>\"VALUE ary1\", :type=>\"VALUE\", :name=>\"ary1\"}, {:decl=>\"VALUE ary2\", :type=>\"VALUE\", :name=>\"ary2\"}],\n"
,
#line 674 "mjit_instruction.rb"
"      rets: [{:decl=>\"VALUE ary\", :type=>\"VALUE\", :name=>\"ary\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    32 => Instruction.new(\n"
"      name: :splatarray,\n"
"      bin: 32,\n"/* BIN(splatarray) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    obj = vm_splat_array(flag, ary);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) ary, flag, obj\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"VALUE flag\", :type=>\"VALUE\", :name=>\"flag\"}],\n"
,
#line 691 "mjit_instruction.rb"
"      pops: [{:decl=>\"VALUE ary\", :type=>\"VALUE\", :name=>\"ary\"}],\n"
"      rets: [{:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    33 => Instruction.new(\n"
"      name: :newhash,\n"
"      bin: 33,\n"/* BIN(newhash) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    RUBY_DTRACE_CREATE_HOOK(HASH, num);\n"
"\n"
"    if (num) {\n"
"        val = rb_hash_new_with_size(num / 2);\n"
"        rb_hash_bulk_insert(num, STACK_ADDR_FROM_TOP(num), val);\n"
"    }\n"
,
#line 709 "mjit_instruction.rb"
"    else {\n"
"        val = rb_hash_new();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(rb_num_t) num\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t num\", :type=>\"rb_num_t\", :name=>\"num\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    34 => Instruction.new(\n"
"      name: :newrange,\n"
"      bin: 34,\n"/* BIN(newrange) */
"      len: 2,\n"/* insn_len */
,
#line 727 "mjit_instruction.rb"
"      expr: <<-EXPR,\n"
"{\n"
"    val = rb_range_new(low, high, (int)flag);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) high, low, val\", \"MAYBE_UNUSED(rb_num_t) flag\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t flag\", :type=>\"rb_num_t\", :name=>\"flag\"}],\n"
"      pops: [{:decl=>\"VALUE low\", :type=>\"VALUE\", :name=>\"low\"}, {:decl=>\"VALUE high\", :type=>\"VALUE\", :name=>\"high\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
,
#line 738 "mjit_instruction.rb"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    35 => Instruction.new(\n"
"      name: :pop,\n"
"      bin: 35,\n"/* BIN(pop) */
"      len: 1,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    (void)val;\n"
"    /* none */\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      rets: [],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    36 => Instruction.new(\n"
,
#line 761 "mjit_instruction.rb"
"      name: :dup,\n"
"      bin: 36,\n"/* BIN(dup) */
"      len: 1,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val1 = val2 = val;\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val, val1, val2\"],\n"
"      preamble: [],\n"
"      opes: [],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      rets: [{:decl=>\"VALUE val1\", :type=>\"VALUE\", :name=>\"val1\"}, {:decl=>\"VALUE val2\", :type=>\"VALUE\", :name=>\"val2\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
,
#line 778 "mjit_instruction.rb"
"    37 => Instruction.new(\n"
"      name: :dupn,\n"
"      bin: 37,\n"/* BIN(dupn) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    void *dst = GET_SP();\n"
"    void *src = STACK_ADDR_FROM_TOP(n);\n"
"\n"
"    MEMCPY(dst, src, VALUE, n);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(rb_num_t) n\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t n\", :type=>\"rb_num_t\", :name=>\"n\"}],\n"
"      pops: [],\n"
"      rets: [],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    38 => Instruction.new(\n"
,
#line 800 "mjit_instruction.rb"
"      name: :swap,\n"
"      bin: 38,\n"/* BIN(swap) */
"      len: 1,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    /* none */\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) obj, val\"],\n"
"      preamble: [],\n"
"      opes: [],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [{:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}, {:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
,
#line 815 "mjit_instruction.rb"
"      handles_sp?: false,\n"
"    ),\n"
"    39 => Instruction.new(\n"
"      name: :opt_reverse,\n"
"      bin: 39,\n"/* BIN(opt_reverse) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    rb_num_t i;\n"
"    VALUE *sp = STACK_ADDR_FROM_TOP(n);\n"
"\n"
"    for (i=0; i<n/2; i++) {\n"
"        VALUE v0 = sp[i];\n"
"        VALUE v1 = TOPN(i);\n"
"        sp[i] = v1;\n"
"        TOPN(i) = v0;\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(rb_num_t) n\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t n\", :type=>\"rb_num_t\", :name=>\"n\"}],\n"
"      pops: [],\n"
"      rets: [],\n"
,
#line 839 "mjit_instruction.rb"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    40 => Instruction.new(\n"
"      name: :topn,\n"
"      bin: 40,\n"/* BIN(topn) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = TOPN(n);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(rb_num_t) n\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t n\", :type=>\"rb_num_t\", :name=>\"n\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
,
#line 858 "mjit_instruction.rb"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    41 => Instruction.new(\n"
"      name: :setn,\n"
"      bin: 41,\n"/* BIN(setn) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    TOPN(n) = val;\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(rb_num_t) n\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t n\", :type=>\"rb_num_t\", :name=>\"n\"}],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
,
#line 875 "mjit_instruction.rb"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    42 => Instruction.new(\n"
"      name: :adjuststack,\n"
"      bin: 42,\n"/* BIN(adjuststack) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    /* none */\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(rb_num_t) n\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t n\", :type=>\"rb_num_t\", :name=>\"n\"}],\n"
"      pops: [],\n"
"      rets: [],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
,
#line 897 "mjit_instruction.rb"
"    43 => Instruction.new(\n"
"      name: :defined,\n"
"      bin: 43,\n"/* BIN(defined) */
"      len: 4,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = Qnil;\n"
"    if (vm_defined(ec, GET_CFP(), op_type, obj, v)) {\n"
"      val = pushval;\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) obj, pushval, v, val\", \"MAYBE_UNUSED(rb_num_t) op_type\"],\n"
"      preamble: [],\n"
,
#line 911 "mjit_instruction.rb"
"      opes: [{:decl=>\"rb_num_t op_type\", :type=>\"rb_num_t\", :name=>\"op_type\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}, {:decl=>\"VALUE pushval\", :type=>\"VALUE\", :name=>\"pushval\"}],\n"
"      pops: [{:decl=>\"VALUE v\", :type=>\"VALUE\", :name=>\"v\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    44 => Instruction.new(\n"
"      name: :checkmatch,\n"
"      bin: 44,\n"/* BIN(checkmatch) */
"      len: 2,\n"/* insn_len */
,
#line 922 "mjit_instruction.rb"
"      expr: <<-EXPR,\n"
"{\n"
"    result = vm_check_match(ec, target, pattern, flag);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) pattern, result, target\", \"MAYBE_UNUSED(rb_num_t) flag\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t flag\", :type=>\"rb_num_t\", :name=>\"flag\"}],\n"
"      pops: [{:decl=>\"VALUE target\", :type=>\"VALUE\", :name=>\"target\"}, {:decl=>\"VALUE pattern\", :type=>\"VALUE\", :name=>\"pattern\"}],\n"
"      rets: [{:decl=>\"VALUE result\", :type=>\"VALUE\", :name=>\"result\"}],\n"
,
#line 932 "mjit_instruction.rb"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    45 => Instruction.new(\n"
"      name: :checkkeyword,\n"
"      bin: 45,\n"/* BIN(checkkeyword) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    ret = vm_check_keyword(kw_bits_index, keyword_index, GET_EP());\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) ret\", \"MAYBE_UNUSED(lindex_t) keyword_index, kw_bits_index\"],\n"
"      preamble: [],\n"
,
#line 947 "mjit_instruction.rb"
"      opes: [{:decl=>\"lindex_t kw_bits_index\", :type=>\"lindex_t\", :name=>\"kw_bits_index\"}, {:decl=>\"lindex_t keyword_index\", :type=>\"lindex_t\", :name=>\"keyword_index\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE ret\", :type=>\"VALUE\", :name=>\"ret\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    46 => Instruction.new(\n"
"      name: :checktype,\n"
"      bin: 46,\n"/* BIN(checktype) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    ret = RBOOL(TYPE(val) == (int)type);\n"
"}\n"
"      EXPR\n"
,
#line 963 "mjit_instruction.rb"
"      declarations: [\"MAYBE_UNUSED(VALUE) ret, val\", \"MAYBE_UNUSED(rb_num_t) type\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t type\", :type=>\"rb_num_t\", :name=>\"type\"}],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      rets: [{:decl=>\"VALUE ret\", :type=>\"VALUE\", :name=>\"ret\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    47 => Instruction.new(\n"
"      name: :defineclass,\n"
"      bin: 47,\n"/* BIN(defineclass) */
"      len: 4,\n"/* insn_len */
,
#line 976 "mjit_instruction.rb"
"      expr: <<-EXPR,\n"
"{\n"
"    VALUE klass = vm_find_or_create_class_by_id(id, flags, cbase, super);\n"
"\n"
"    rb_iseq_check(class_iseq);\n"
"\n"
"    /* enter scope */\n"
"    vm_push_frame(ec, class_iseq, VM_FRAME_MAGIC_CLASS | VM_ENV_FLAG_LOCAL, klass,\n"
"                  GET_BLOCK_HANDLER(),\n"
"                  (VALUE)vm_cref_push(ec, klass, NULL, FALSE, FALSE),\n"
"                  ISEQ_BODY(class_iseq)->iseq_encoded, GET_SP(),\n"
"                  ISEQ_BODY(class_iseq)->local_table_size,\n"
,
#line 988 "mjit_instruction.rb"
"                  ISEQ_BODY(class_iseq)->stack_max);\n"
"    RESTORE_REGS();\n"
"    NEXT_INSN();\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(ID) id\", \"MAYBE_UNUSED(ISEQ) class_iseq\", \"MAYBE_UNUSED(VALUE) cbase, super, val\", \"MAYBE_UNUSED(rb_num_t) flags\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"ID id\", :type=>\"ID\", :name=>\"id\"}, {:decl=>\"ISEQ class_iseq\", :type=>\"ISEQ\", :name=>\"class_iseq\"}, {:decl=>\"rb_num_t flags\", :type=>\"rb_num_t\", :name=>\"flags\"}],\n"
,
#line 996 "mjit_instruction.rb"
"      pops: [{:decl=>\"VALUE cbase\", :type=>\"VALUE\", :name=>\"cbase\"}, {:decl=>\"VALUE super\", :type=>\"VALUE\", :name=>\"super\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: true,\n"
"    ),\n"
"    48 => Instruction.new(\n"
"      name: :definemethod,\n"
"      bin: 48,\n"/* BIN(definemethod) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    vm_define_method(ec, Qnil, id, (VALUE)iseq, FALSE);\n"
"}\n"
"      EXPR\n"
,
#line 1011 "mjit_instruction.rb"
"      declarations: [\"MAYBE_UNUSED(ID) id\", \"MAYBE_UNUSED(ISEQ) iseq\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"ID id\", :type=>\"ID\", :name=>\"id\"}, {:decl=>\"ISEQ iseq\", :type=>\"ISEQ\", :name=>\"iseq\"}],\n"
"      pops: [],\n"
"      rets: [],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: true,\n"
"    ),\n"
"    49 => Instruction.new(\n"
"      name: :definesmethod,\n"
"      bin: 49,\n"/* BIN(definesmethod) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    vm_define_method(ec, obj, id, (VALUE)iseq, TRUE);\n"
"}\n"
"      EXPR\n"
,
#line 1029 "mjit_instruction.rb"
"      declarations: [\"MAYBE_UNUSED(ID) id\", \"MAYBE_UNUSED(ISEQ) iseq\", \"MAYBE_UNUSED(VALUE) obj\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"ID id\", :type=>\"ID\", :name=>\"id\"}, {:decl=>\"ISEQ iseq\", :type=>\"ISEQ\", :name=>\"iseq\"}],\n"
"      pops: [{:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: true,\n"
"    ),\n"
"    50 => Instruction.new(\n"
"      name: :send,\n"
"      bin: 50,\n"/* BIN(send) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
,
#line 1044 "mjit_instruction.rb"
"    VALUE bh = vm_caller_setup_arg_block(ec, GET_CFP(), cd->ci, blockiseq, false);\n"
"    val = vm_sendish(ec, GET_CFP(), cd, bh, mexp_search_method);\n"
"\n"
"    if (val == Qundef) {\n"
"        RESTORE_REGS();\n"
"        NEXT_INSN();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(ISEQ) blockiseq\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}, {:decl=>\"ISEQ blockiseq\", :type=>\"ISEQ\", :name=>\"blockiseq\"}],\n"
,
#line 1056 "mjit_instruction.rb"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: true,\n"
"    ),\n"
"    51 => Instruction.new(\n"
"      name: :opt_send_without_block,\n"
"      bin: 51,\n"/* BIN(opt_send_without_block) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    VALUE bh = VM_BLOCK_HANDLER_NONE;\n"
"    val = vm_sendish(ec, GET_CFP(), cd, bh, mexp_search_method);\n"
"\n"
"    if (val == Qundef) {\n"
"        RESTORE_REGS();\n"
"        NEXT_INSN();\n"
"    }\n"
"}\n"
"      EXPR\n"
,
#line 1077 "mjit_instruction.rb"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: true,\n"
"    ),\n"
"    52 => Instruction.new(\n"
"      name: :objtostring,\n"
"      bin: 52,\n"/* BIN(objtostring) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_objtostring(GET_ISEQ(), recv, cd);\n"
"\n"
,
#line 1094 "mjit_instruction.rb"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
,
#line 1108 "mjit_instruction.rb"
"    53 => Instruction.new(\n"
"      name: :opt_str_freeze,\n"
"      bin: 53,\n"/* BIN(opt_str_freeze) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_str_freeze(str, BOP_FREEZE, idFreeze);\n"
"\n"
"    if (val == Qundef) {\n"
"        PUSH(rb_str_resurrect(str));\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) str, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"VALUE str\", :type=>\"VALUE\", :name=>\"str\"}, {:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
,
#line 1125 "mjit_instruction.rb"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    54 => Instruction.new(\n"
"      name: :opt_nil_p,\n"
"      bin: 54,\n"/* BIN(opt_nil_p) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_nil_p(GET_ISEQ(), cd, recv);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) recv, val\"],\n"
,
#line 1145 "mjit_instruction.rb"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    55 => Instruction.new(\n"
"      name: :opt_str_uminus,\n"
"      bin: 55,\n"/* BIN(opt_str_uminus) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_str_freeze(str, BOP_UMINUS, idUMinus);\n"
"\n"
,
#line 1161 "mjit_instruction.rb"
"    if (val == Qundef) {\n"
"        PUSH(rb_str_resurrect(str));\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) str, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"VALUE str\", :type=>\"VALUE\", :name=>\"str\"}, {:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
,
#line 1174 "mjit_instruction.rb"
"      handles_sp?: false,\n"
"    ),\n"
"    56 => Instruction.new(\n"
"      name: :opt_newarray_max,\n"
"      bin: 56,\n"/* BIN(opt_newarray_max) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_newarray_max(ec, num, STACK_ADDR_FROM_TOP(num));\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(rb_num_t) num\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t num\", :type=>\"rb_num_t\", :name=>\"num\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
,
#line 1191 "mjit_instruction.rb"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    57 => Instruction.new(\n"
"      name: :opt_newarray_min,\n"
"      bin: 57,\n"/* BIN(opt_newarray_min) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_newarray_min(ec, num, STACK_ADDR_FROM_TOP(num));\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(rb_num_t) num\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t num\", :type=>\"rb_num_t\", :name=>\"num\"}],\n"
"      pops: [],\n"
,
#line 1207 "mjit_instruction.rb"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    58 => Instruction.new(\n"
"      name: :invokesuper,\n"
"      bin: 58,\n"/* BIN(invokesuper) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    VALUE bh = vm_caller_setup_arg_block(ec, GET_CFP(), cd->ci, blockiseq, true);\n"
"    val = vm_sendish(ec, GET_CFP(), cd, bh, mexp_search_super);\n"
"\n"
"    if (val == Qundef) {\n"
"        RESTORE_REGS();\n"
"        NEXT_INSN();\n"
"    }\n"
"}\n"
"      EXPR\n"
,
#line 1227 "mjit_instruction.rb"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(ISEQ) blockiseq\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}, {:decl=>\"ISEQ blockiseq\", :type=>\"ISEQ\", :name=>\"blockiseq\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: true,\n"
"    ),\n"
"    59 => Instruction.new(\n"
"      name: :invokeblock,\n"
,
#line 1238 "mjit_instruction.rb"
"      bin: 59,\n"/* BIN(invokeblock) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    VALUE bh = VM_BLOCK_HANDLER_NONE;\n"
"    val = vm_sendish(ec, GET_CFP(), cd, bh, mexp_search_invokeblock);\n"
"\n"
"    if (val == Qundef) {\n"
"        RESTORE_REGS();\n"
"        NEXT_INSN();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
,
#line 1256 "mjit_instruction.rb"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: true,\n"
"    ),\n"
"    60 => Instruction.new(\n"
"      name: :leave,\n"
"      bin: 60,\n"/* BIN(leave) */
"      len: 1,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    if (OPT_CHECKED_RUN) {\n"
"        const VALUE *const bp = vm_base_ptr(GET_CFP());\n"
"        if (GET_SP() != bp) {\n"
"            vm_stack_consistency_error(ec, GET_CFP(), bp);\n"
"        }\n"
"    }\n"
"\n"
"    if (vm_pop_frame(ec, GET_CFP(), GET_EP())) {\n"
"#if OPT_CALL_THREADED_CODE\n"
"        rb_ec_thread_ptr(ec)->retval = val;\n"
,
#line 1276 "mjit_instruction.rb"
"        return 0;\n"
"#else\n"
"        return val;\n"
"#endif\n"
"    }\n"
"    else {\n"
"        RESTORE_REGS();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: true,\n"
"    ),\n"
"    61 => Instruction.new(\n"
"      name: :throw,\n"
"      bin: 61,\n"/* BIN(throw) */
"      len: 2,\n"/* insn_len */
,
#line 1299 "mjit_instruction.rb"
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_throw(ec, GET_CFP(), throw_state, throwobj);\n"
"    THROW_EXCEPTION(val);\n"
"    /* unreachable */\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) throwobj, val\", \"MAYBE_UNUSED(rb_num_t) throw_state\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"rb_num_t throw_state\", :type=>\"rb_num_t\", :name=>\"throw_state\"}],\n"
"      pops: [{:decl=>\"VALUE throwobj\", :type=>\"VALUE\", :name=>\"throwobj\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
,
#line 1311 "mjit_instruction.rb"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    62 => Instruction.new(\n"
"      name: :jump,\n"
"      bin: 62,\n"/* BIN(jump) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    RUBY_VM_CHECK_INTS(ec);\n"
"    JUMP(dst);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(OFFSET) dst\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"OFFSET dst\", :type=>\"OFFSET\", :name=>\"dst\"}],\n"
"      pops: [],\n"
"      rets: [],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: true,\n"
,
#line 1332 "mjit_instruction.rb"
"      handles_sp?: false,\n"
"    ),\n"
"    63 => Instruction.new(\n"
"      name: :branchif,\n"
"      bin: 63,\n"/* BIN(branchif) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    if (RTEST(val)) {\n"
"        RUBY_VM_CHECK_INTS(ec);\n"
"        JUMP(dst);\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(OFFSET) dst\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"OFFSET dst\", :type=>\"OFFSET\", :name=>\"dst\"}],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      rets: [],\n"
"      always_leaf?: false,\n"
,
#line 1352 "mjit_instruction.rb"
"      leaf_without_check_ints?: true,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    64 => Instruction.new(\n"
"      name: :branchunless,\n"
"      bin: 64,\n"/* BIN(branchunless) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    if (!RTEST(val)) {\n"
"        RUBY_VM_CHECK_INTS(ec);\n"
"        JUMP(dst);\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(OFFSET) dst\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"OFFSET dst\", :type=>\"OFFSET\", :name=>\"dst\"}],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
,
#line 1371 "mjit_instruction.rb"
"      rets: [],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: true,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    65 => Instruction.new(\n"
"      name: :branchnil,\n"
"      bin: 65,\n"/* BIN(branchnil) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    if (NIL_P(val)) {\n"
"        RUBY_VM_CHECK_INTS(ec);\n"
"        JUMP(dst);\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(OFFSET) dst\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"OFFSET dst\", :type=>\"OFFSET\", :name=>\"dst\"}],\n"
,
#line 1391 "mjit_instruction.rb"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      rets: [],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: true,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    66 => Instruction.new(\n"
"      name: :once,\n"
"      bin: 66,\n"/* BIN(once) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_once_dispatch(ec, iseq, ise);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(ISE) ise\", \"MAYBE_UNUSED(ISEQ) iseq\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
,
#line 1408 "mjit_instruction.rb"
"      opes: [{:decl=>\"ISEQ iseq\", :type=>\"ISEQ\", :name=>\"iseq\"}, {:decl=>\"ISE ise\", :type=>\"ISE\", :name=>\"ise\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: true,\n"
"    ),\n"
"    67 => Instruction.new(\n"
"      name: :opt_case_dispatch,\n"
"      bin: 67,\n"/* BIN(opt_case_dispatch) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    OFFSET dst = vm_case_dispatch(hash, else_offset, key);\n"
"\n"
"    if (dst) {\n"
"        JUMP(dst);\n"
"    }\n"
"}\n"
,
#line 1427 "mjit_instruction.rb"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CDHASH) hash\", \"MAYBE_UNUSED(OFFSET) else_offset\", \"MAYBE_UNUSED(VALUE) key\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CDHASH hash\", :type=>\"CDHASH\", :name=>\"hash\"}, {:decl=>\"OFFSET else_offset\", :type=>\"OFFSET\", :name=>\"else_offset\"}],\n"
"      pops: [{:decl=>\"VALUE key\", :type=>\"VALUE\", :name=>\"key\"}],\n"
"      rets: [],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    68 => Instruction.new(\n"
,
#line 1438 "mjit_instruction.rb"
"      name: :opt_plus,\n"
"      bin: 68,\n"/* BIN(opt_plus) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_plus(recv, obj);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
,
#line 1454 "mjit_instruction.rb"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    69 => Instruction.new(\n"
"      name: :opt_minus,\n"
"      bin: 69,\n"/* BIN(opt_minus) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_minus(recv, obj);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
,
#line 1474 "mjit_instruction.rb"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    70 => Instruction.new(\n"
"      name: :opt_mult,\n"
"      bin: 70,\n"/* BIN(opt_mult) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_mult(recv, obj);\n"
"\n"
,
#line 1489 "mjit_instruction.rb"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
,
#line 1501 "mjit_instruction.rb"
"      handles_sp?: false,\n"
"    ),\n"
"    71 => Instruction.new(\n"
"      name: :opt_div,\n"
"      bin: 71,\n"/* BIN(opt_div) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_div(recv, obj);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
,
#line 1519 "mjit_instruction.rb"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    72 => Instruction.new(\n"
"      name: :opt_mod,\n"
"      bin: 72,\n"/* BIN(opt_mod) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_mod(recv, obj);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
,
#line 1538 "mjit_instruction.rb"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    73 => Instruction.new(\n"
,
#line 1548 "mjit_instruction.rb"
"      name: :opt_eq,\n"
"      bin: 73,\n"/* BIN(opt_eq) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = opt_equality(GET_ISEQ(), recv, obj, cd);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
,
#line 1564 "mjit_instruction.rb"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    74 => Instruction.new(\n"
"      name: :opt_neq,\n"
"      bin: 74,\n"/* BIN(opt_neq) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_neq(GET_ISEQ(), cd, cd_eq, recv, obj);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd, cd_eq\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
,
#line 1583 "mjit_instruction.rb"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd_eq\", :type=>\"CALL_DATA\", :name=>\"cd_eq\"}, {:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    75 => Instruction.new(\n"
"      name: :opt_lt,\n"
"      bin: 75,\n"/* BIN(opt_lt) */
,
#line 1594 "mjit_instruction.rb"
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_lt(recv, obj);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
,
#line 1608 "mjit_instruction.rb"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    76 => Instruction.new(\n"
"      name: :opt_le,\n"
"      bin: 76,\n"/* BIN(opt_le) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_le(recv, obj);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
,
#line 1628 "mjit_instruction.rb"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    77 => Instruction.new(\n"
"      name: :opt_gt,\n"
"      bin: 77,\n"/* BIN(opt_gt) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_gt(recv, obj);\n"
"\n"
,
#line 1643 "mjit_instruction.rb"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
,
#line 1655 "mjit_instruction.rb"
"      handles_sp?: false,\n"
"    ),\n"
"    78 => Instruction.new(\n"
"      name: :opt_ge,\n"
"      bin: 78,\n"/* BIN(opt_ge) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_ge(recv, obj);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
,
#line 1673 "mjit_instruction.rb"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    79 => Instruction.new(\n"
"      name: :opt_ltlt,\n"
"      bin: 79,\n"/* BIN(opt_ltlt) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_ltlt(recv, obj);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
,
#line 1692 "mjit_instruction.rb"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    80 => Instruction.new(\n"
,
#line 1702 "mjit_instruction.rb"
"      name: :opt_and,\n"
"      bin: 80,\n"/* BIN(opt_and) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_and(recv, obj);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
,
#line 1718 "mjit_instruction.rb"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    81 => Instruction.new(\n"
"      name: :opt_or,\n"
"      bin: 81,\n"/* BIN(opt_or) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_or(recv, obj);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
,
#line 1738 "mjit_instruction.rb"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    82 => Instruction.new(\n"
"      name: :opt_aref,\n"
"      bin: 82,\n"/* BIN(opt_aref) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_aref(recv, obj);\n"
"\n"
,
#line 1753 "mjit_instruction.rb"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
,
#line 1765 "mjit_instruction.rb"
"      handles_sp?: false,\n"
"    ),\n"
"    83 => Instruction.new(\n"
"      name: :opt_aset,\n"
"      bin: 83,\n"/* BIN(opt_aset) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_aset(recv, obj, set);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj, recv, set, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
,
#line 1783 "mjit_instruction.rb"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE obj\", :type=>\"VALUE\", :name=>\"obj\"}, {:decl=>\"VALUE set\", :type=>\"VALUE\", :name=>\"set\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    84 => Instruction.new(\n"
"      name: :opt_aset_with,\n"
"      bin: 84,\n"/* BIN(opt_aset_with) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    VALUE tmp = vm_opt_aset_with(recv, key, val);\n"
"\n"
,
#line 1797 "mjit_instruction.rb"
"    if (tmp != Qundef) {\n"
"        val = tmp;\n"
"    }\n"
"    else {\n"
"#ifndef MJIT_HEADER\n"
"        TOPN(0) = rb_str_resurrect(key);\n"
"        PUSH(val);\n"
"#endif\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) key, recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"VALUE key\", :type=>\"VALUE\", :name=>\"key\"}, {:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
,
#line 1812 "mjit_instruction.rb"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}, {:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    85 => Instruction.new(\n"
"      name: :opt_aref_with,\n"
"      bin: 85,\n"/* BIN(opt_aref_with) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_aref_with(recv, key);\n"
"\n"
"    if (val == Qundef) {\n"
"#ifndef MJIT_HEADER\n"
,
#line 1828 "mjit_instruction.rb"
"        PUSH(rb_str_resurrect(key));\n"
"#endif\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) key, recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"VALUE key\", :type=>\"VALUE\", :name=>\"key\"}, {:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
,
#line 1840 "mjit_instruction.rb"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    86 => Instruction.new(\n"
"      name: :opt_length,\n"
"      bin: 86,\n"/* BIN(opt_length) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_length(recv, BOP_LENGTH);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
,
#line 1859 "mjit_instruction.rb"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    87 => Instruction.new(\n"
"      name: :opt_size,\n"
"      bin: 87,\n"/* BIN(opt_size) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_length(recv, BOP_SIZE);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
,
#line 1878 "mjit_instruction.rb"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    88 => Instruction.new(\n"
"      name: :opt_empty_p,\n"
"      bin: 88,\n"/* BIN(opt_empty_p) */
"      len: 2,\n"/* insn_len */
,
#line 1891 "mjit_instruction.rb"
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_empty_p(recv);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
,
#line 1907 "mjit_instruction.rb"
"      handles_sp?: false,\n"
"    ),\n"
"    89 => Instruction.new(\n"
"      name: :opt_succ,\n"
"      bin: 89,\n"/* BIN(opt_succ) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_succ(recv);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) recv, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}],\n"
,
#line 1926 "mjit_instruction.rb"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    90 => Instruction.new(\n"
"      name: :opt_not,\n"
"      bin: 90,\n"/* BIN(opt_not) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_not(GET_ISEQ(), cd, recv);\n"
"\n"
"    if (val == Qundef) {\n"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) recv, val\"],\n"
"      preamble: [],\n"
,
#line 1946 "mjit_instruction.rb"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE recv\", :type=>\"VALUE\", :name=>\"recv\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    91 => Instruction.new(\n"
"      name: :opt_regexpmatch2,\n"
"      bin: 91,\n"/* BIN(opt_regexpmatch2) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_opt_regexpmatch2(obj2, obj1);\n"
"\n"
"    if (val == Qundef) {\n"
,
#line 1962 "mjit_instruction.rb"
"        CALL_SIMPLE_METHOD();\n"
"    }\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(CALL_DATA) cd\", \"MAYBE_UNUSED(VALUE) obj1, obj2, val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"CALL_DATA cd\", :type=>\"CALL_DATA\", :name=>\"cd\"}],\n"
"      pops: [{:decl=>\"VALUE obj2\", :type=>\"VALUE\", :name=>\"obj2\"}, {:decl=>\"VALUE obj1\", :type=>\"VALUE\", :name=>\"obj1\"}],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
,
#line 1973 "mjit_instruction.rb"
"      handles_sp?: false,\n"
"    ),\n"
"    92 => Instruction.new(\n"
"      name: :invokebuiltin,\n"
"      bin: 92,\n"/* BIN(invokebuiltin) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_invoke_builtin(ec, reg_cfp, bf, STACK_ADDR_FROM_TOP(bf->argc));\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(RB_BUILTIN) bf\", \"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"RB_BUILTIN bf\", :type=>\"RB_BUILTIN\", :name=>\"bf\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
,
#line 1989 "mjit_instruction.rb"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    93 => Instruction.new(\n"
"      name: :opt_invokebuiltin_delegate,\n"
"      bin: 93,\n"/* BIN(opt_invokebuiltin_delegate) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = vm_invoke_builtin_delegate(ec, reg_cfp, bf, (unsigned int)index);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(RB_BUILTIN) bf\", \"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(rb_num_t) index\"],\n"
"      preamble: [],\n"
,
#line 2004 "mjit_instruction.rb"
"      opes: [{:decl=>\"RB_BUILTIN bf\", :type=>\"RB_BUILTIN\", :name=>\"bf\"}, {:decl=>\"rb_num_t index\", :type=>\"rb_num_t\", :name=>\"index\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    94 => Instruction.new(\n"
"      name: :opt_invokebuiltin_delegate_leave,\n"
"      bin: 94,\n"/* BIN(opt_invokebuiltin_delegate_leave) */
"      len: 3,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
,
#line 2017 "mjit_instruction.rb"
"    val = vm_invoke_builtin_delegate(ec, reg_cfp, bf, (unsigned int)index);\n"
"\n"
"    /* leave fastpath */\n"
"    /* TracePoint/return fallbacks this insn to opt_invokebuiltin_delegate */\n"
"    if (vm_pop_frame(ec, GET_CFP(), GET_EP())) {\n"
"#if OPT_CALL_THREADED_CODE\n"
"        rb_ec_thread_ptr(ec)->retval = val;\n"
"        return 0;\n"
"#else\n"
"        return val;\n"
"#endif\n"
"    }\n"
"    else {\n"
"        RESTORE_REGS();\n"
"    }\n"
"}\n"
"      EXPR\n"
,
#line 2034 "mjit_instruction.rb"
"      declarations: [\"MAYBE_UNUSED(RB_BUILTIN) bf\", \"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(rb_num_t) index\"],\n"
"      preamble: [],\n"
"      opes: [{:decl=>\"RB_BUILTIN bf\", :type=>\"RB_BUILTIN\", :name=>\"bf\"}, {:decl=>\"rb_num_t index\", :type=>\"rb_num_t\", :name=>\"index\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: false,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    95 => Instruction.new(\n"
"      name: :getlocal_WC_0,\n"
,
#line 2045 "mjit_instruction.rb"
"      bin: 95,\n"/* BIN(getlocal_WC_0) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = *(vm_get_ep(GET_EP(), level) - idx);\n"
"    RB_DEBUG_COUNTER_INC(lvar_get);\n"
"    (void)RB_DEBUG_COUNTER_INC_IF(lvar_get_dynamic, level > 0);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(lindex_t) idx\", \"MAYBE_UNUSED(rb_num_t) level\"],\n"
"      preamble: [\"    const rb_num_t level = 0;\"],\n"
"      opes: [{:decl=>\"lindex_t idx\", :type=>\"lindex_t\", :name=>\"idx\"}],\n"
"      pops: [],\n"
,
#line 2058 "mjit_instruction.rb"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    96 => Instruction.new(\n"
"      name: :getlocal_WC_1,\n"
"      bin: 96,\n"/* BIN(getlocal_WC_1) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    val = *(vm_get_ep(GET_EP(), level) - idx);\n"
"    RB_DEBUG_COUNTER_INC(lvar_get);\n"
"    (void)RB_DEBUG_COUNTER_INC_IF(lvar_get_dynamic, level > 0);\n"
"}\n"
"      EXPR\n"
,
#line 2074 "mjit_instruction.rb"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(lindex_t) idx\", \"MAYBE_UNUSED(rb_num_t) level\"],\n"
"      preamble: [\"    const rb_num_t level = 1;\"],\n"
"      opes: [{:decl=>\"lindex_t idx\", :type=>\"lindex_t\", :name=>\"idx\"}],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    97 => Instruction.new(\n"
"      name: :setlocal_WC_0,\n"
"      bin: 97,\n"/* BIN(setlocal_WC_0) */
"      len: 2,\n"/* insn_len */
,
#line 2087 "mjit_instruction.rb"
"      expr: <<-EXPR,\n"
"{\n"
"    vm_env_write(vm_get_ep(GET_EP(), level), -(int)idx, val);\n"
"    RB_DEBUG_COUNTER_INC(lvar_set);\n"
"    (void)RB_DEBUG_COUNTER_INC_IF(lvar_set_dynamic, level > 0);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(lindex_t) idx\", \"MAYBE_UNUSED(rb_num_t) level\"],\n"
"      preamble: [\"    const rb_num_t level = 0;\"],\n"
"      opes: [{:decl=>\"lindex_t idx\", :type=>\"lindex_t\", :name=>\"idx\"}],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
,
#line 2098 "mjit_instruction.rb"
"      rets: [],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    98 => Instruction.new(\n"
"      name: :setlocal_WC_1,\n"
"      bin: 98,\n"/* BIN(setlocal_WC_1) */
"      len: 2,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    vm_env_write(vm_get_ep(GET_EP(), level), -(int)idx, val);\n"
"    RB_DEBUG_COUNTER_INC(lvar_set);\n"
"    (void)RB_DEBUG_COUNTER_INC_IF(lvar_set_dynamic, level > 0);\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\", \"MAYBE_UNUSED(lindex_t) idx\", \"MAYBE_UNUSED(rb_num_t) level\"],\n"
,
#line 2115 "mjit_instruction.rb"
"      preamble: [\"    const rb_num_t level = 1;\"],\n"
"      opes: [{:decl=>\"lindex_t idx\", :type=>\"lindex_t\", :name=>\"idx\"}],\n"
"      pops: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      rets: [],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    99 => Instruction.new(\n"
"      name: :putobject_INT2FIX_0_,\n"
"      bin: 99,\n"/* BIN(putobject_INT2FIX_0_) */
"      len: 1,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    /* */\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\"],\n"
,
#line 2133 "mjit_instruction.rb"
"      preamble: [\"    const VALUE val = INT2FIX(0);\"],\n"
"      opes: [],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"    100 => Instruction.new(\n"
"      name: :putobject_INT2FIX_1_,\n"
"      bin: 100,\n"/* BIN(putobject_INT2FIX_1_) */
"      len: 1,\n"/* insn_len */
"      expr: <<-EXPR,\n"
"{\n"
"    /* */\n"
"}\n"
"      EXPR\n"
"      declarations: [\"MAYBE_UNUSED(VALUE) val\"],\n"
"      preamble: [\"    const VALUE val = INT2FIX(1);\"],\n"
,
#line 2152 "mjit_instruction.rb"
"      opes: [],\n"
"      pops: [],\n"
"      rets: [{:decl=>\"VALUE val\", :type=>\"VALUE\", :name=>\"val\"}],\n"
"      always_leaf?: true,\n"
"      leaf_without_check_ints?: false,\n"
"      handles_sp?: false,\n"
"    ),\n"
"  }\n"
"\n"
"  private_constant(*constants)\n"
"end if RubyVM::MJIT.enabled?\n"
#line 4179 "miniprelude.c"
};

static const char prelude_name9[] = "<internal:pack>";
static const struct {
    char L0[501]; /* 1..306 */
    char L306[50]; /* 307..310 */
} prelude_code9 = {
#line 1 "pack.rb"
"class Array\n"
"\n"/*  call-seq: */
"\n"/*     arr.pack( aTemplateString ) -> aBinaryString */
"\n"/*     arr.pack( aTemplateString, buffer: aBufferString ) -> aBufferString */
"\n"/*  */
"\n"/*  Packs the contents of <i>arr</i> into a binary sequence according to */
"\n"/*  the directives in <i>aTemplateString</i> (see the table below) */
"\n"/*  Directives ``A,'' ``a,'' and ``Z'' may be followed by a count, */
"\n"/*  which gives the width of the resulting field. The remaining */
"\n"/*  directives also may take a count, indicating the number of array */
"\n"/*  elements to convert. If the count is an asterisk */
"\n"/*  (``<code>*</code>''), all remaining array elements will be */
"\n"/*  converted. Any of the directives ``<code>sSiIlL</code>'' may be */
"\n"/*  followed by an underscore (``<code>_</code>'') or */
"\n"/*  exclamation mark (``<code>!</code>'') to use the underlying */
"\n"/*  platform's native size for the specified type; otherwise, they use a */
"\n"/*  platform-independent size. Spaces are ignored in the template */
"\n"/*  string. See also String#unpack. */
"\n"/*  */
"\n"/*     a = [ "a", "b", "c" ] */
"\n"/*     n = [ 65, 66, 67 ] */
"\n"/*     a.pack("A3A3A3")   #=> "a  b  c  " */
"\n"/*     a.pack("a3a3a3")   #=> "a\000\000b\000\000c\000\000" */
"\n"/*     n.pack("ccc")      #=> "ABC" */
"\n"/*  */
"\n"/*  If <i>aBufferString</i> is specified and its capacity is enough, */
"\n"/*  +pack+ uses it as the buffer and returns it. */
"\n"/*  When the offset is specified by the beginning of <i>aTemplateString</i>, */
"\n"/*  the result is filled after the offset. */
"\n"/*  If original contents of <i>aBufferString</i> exists and it's longer than */
"\n"/*  the offset, the rest of <i>offsetOfBuffer</i> are overwritten by the result. */
"\n"/*  If it's shorter, the gap is filled with ``<code>\0</code>''. */
"\n"/*  */
"\n"/*     # packed data is appended by default */
"\n"/*     [255].pack("C", buffer:"foo".b) #=> "foo\xFF" */
"\n"/*  */
"\n"/*     # "@0" (offset 0) specifies that packed data is filled from beginning. */
"\n"/*     # Also, original data after packed data is removed. ("oo" is removed.) */
"\n"/*     [255].pack("@0C", buffer:"foo".b) #=> "\xFF" */
"\n"/*  */
"\n"/*     # If the offset is bigger than the original length, \x00 is filled. */
"\n"/*     [255].pack("@5C", buffer:"foo".b) #=> "foo\x00\x00\xFF" */
"\n"/*  */
"\n"/*  Note that ``buffer:'' option does not guarantee not to allocate memory */
"\n"/*  in +pack+.  If the capacity of <i>aBufferString</i> is not enough, */
"\n"/*  +pack+ allocates memory. */
"\n"/*  */
"\n"/*  Directives for +pack+. */
"\n"/*  */
"\n"/*   Integer       | Array   | */
"\n"/*   Directive     | Element | Meaning */
"\n"/*   ---------------------------------------------------------------------------- */
"\n"/*   C             | Integer | 8-bit unsigned (unsigned char) */
"\n"/*   S             | Integer | 16-bit unsigned, native endian (uint16_t) */
"\n"/*   L             | Integer | 32-bit unsigned, native endian (uint32_t) */
"\n"/*   Q             | Integer | 64-bit unsigned, native endian (uint64_t) */
"\n"/*   J             | Integer | pointer width unsigned, native endian (uintptr_t) */
"\n"/*                 |         | (J is available since Ruby 2.3.) */
"\n"/*                 |         | */
"\n"/*   c             | Integer | 8-bit signed (signed char) */
"\n"/*   s             | Integer | 16-bit signed, native endian (int16_t) */
"\n"/*   l             | Integer | 32-bit signed, native endian (int32_t) */
"\n"/*   q             | Integer | 64-bit signed, native endian (int64_t) */
"\n"/*   j             | Integer | pointer width signed, native endian (intptr_t) */
"\n"/*                 |         | (j is available since Ruby 2.3.) */
"\n"/*                 |         | */
"\n"/*   S_ S!         | Integer | unsigned short, native endian */
"\n"/*   I I_ I!       | Integer | unsigned int, native endian */
"\n"/*   L_ L!         | Integer | unsigned long, native endian */
"\n"/*   Q_ Q!         | Integer | unsigned long long, native endian (ArgumentError */
"\n"/*                 |         | if the platform has no long long type.) */
"\n"/*                 |         | (Q_ and Q! is available since Ruby 2.1.) */
"\n"/*   J!            | Integer | uintptr_t, native endian (same with J) */
"\n"/*                 |         | (J! is available since Ruby 2.3.) */
"\n"/*                 |         | */
"\n"/*   s_ s!         | Integer | signed short, native endian */
"\n"/*   i i_ i!       | Integer | signed int, native endian */
"\n"/*   l_ l!         | Integer | signed long, native endian */
"\n"/*   q_ q!         | Integer | signed long long, native endian (ArgumentError */
"\n"/*                 |         | if the platform has no long long type.) */
"\n"/*                 |         | (q_ and q! is available since Ruby 2.1.) */
"\n"/*   j!            | Integer | intptr_t, native endian (same with j) */
"\n"/*                 |         | (j! is available since Ruby 2.3.) */
"\n"/*                 |         | */
"\n"/*   S> s> S!> s!> | Integer | same as the directives without ">" except */
"\n"/*   L> l> L!> l!> |         | big endian */
"\n"/*   I!> i!>       |         | (available since Ruby 1.9.3) */
"\n"/*   Q> q> Q!> q!> |         | "S>" is the same as "n" */
"\n"/*   J> j> J!> j!> |         | "L>" is the same as "N" */
"\n"/*                 |         | */
"\n"/*   S< s< S!< s!< | Integer | same as the directives without "<" except */
"\n"/*   L< l< L!< l!< |         | little endian */
"\n"/*   I!< i!<       |         | (available since Ruby 1.9.3) */
"\n"/*   Q< q< Q!< q!< |         | "S<" is the same as "v" */
"\n"/*   J< j< J!< j!< |         | "L<" is the same as "V" */
"\n"/*                 |         | */
"\n"/*   n             | Integer | 16-bit unsigned, network (big-endian) byte order */
"\n"/*   N             | Integer | 32-bit unsigned, network (big-endian) byte order */
"\n"/*   v             | Integer | 16-bit unsigned, VAX (little-endian) byte order */
"\n"/*   V             | Integer | 32-bit unsigned, VAX (little-endian) byte order */
"\n"/*                 |         | */
"\n"/*   U             | Integer | UTF-8 character */
"\n"/*   w             | Integer | BER-compressed integer */
"\n"/*  */
"\n"/*   Float        | Array   | */
"\n"/*   Directive    | Element | Meaning */
"\n"/*   --------------------------------------------------------------------------- */
"\n"/*   D d          | Float   | double-precision, native format */
"\n"/*   F f          | Float   | single-precision, native format */
"\n"/*   E            | Float   | double-precision, little-endian byte order */
"\n"/*   e            | Float   | single-precision, little-endian byte order */
"\n"/*   G            | Float   | double-precision, network (big-endian) byte order */
"\n"/*   g            | Float   | single-precision, network (big-endian) byte order */
"\n"/*  */
"\n"/*   String       | Array   | */
"\n"/*   Directive    | Element | Meaning */
"\n"/*   --------------------------------------------------------------------------- */
"\n"/*   A            | String  | arbitrary binary string (space padded, count is width) */
"\n"/*   a            | String  | arbitrary binary string (null padded, count is width) */
"\n"/*   Z            | String  | same as ``a'', except that null is added with * */
"\n"/*   B            | String  | bit string (MSB first) */
"\n"/*   b            | String  | bit string (LSB first) */
"\n"/*   H            | String  | hex string (high nibble first) */
"\n"/*   h            | String  | hex string (low nibble first) */
"\n"/*   u            | String  | UU-encoded string */
"\n"/*   M            | String  | quoted printable, MIME encoding (see also RFC2045) */
"\n"/*                |         | (text mode but input must use LF and output LF) */
"\n"/*   m            | String  | base64 encoded string (see RFC 2045) */
"\n"/*                |         | (if count is 0, no line feed are added, see RFC 4648) */
"\n"/*                |         | (count specifies input bytes between each LF, */
"\n"/*                |         | rounded down to nearest multiple of 3) */
"\n"/*   P            | String  | pointer to a structure (fixed-length string) */
"\n"/*   p            | String  | pointer to a null-terminated string */
"\n"/*  */
"\n"/*   Misc.        | Array   | */
"\n"/*   Directive    | Element | Meaning */
"\n"/*   --------------------------------------------------------------------------- */
"\n"/*   @            | ---     | moves to absolute position */
"\n"/*   X            | ---     | back up a byte */
"\n"/*   x            | ---     | null byte */
"  def pack(fmt, buffer: nil)\n"
"    Primitive.pack_pack(fmt, buffer)\n"
"  end\n"
"end\n"
"\n"
"class String\n"
"\n"/* call-seq: */
"\n"/*    str.unpack(format)    ->  anArray */
"\n"/*    str.unpack(format, offset: anInteger)    ->  anArray */
"\n"/*  */
"\n"/* Decodes <i>str</i> (which may contain binary data) according to the */
"\n"/* format string, returning an array of each value extracted. */
"\n"/* The format string consists of a sequence of single-character directives, */
"\n"/* summarized in the table at the end of this entry. */
"\n"/* Each directive may be followed */
"\n"/* by a number, indicating the number of times to repeat with this */
"\n"/* directive. An asterisk (``<code>*</code>'') will use up all */
"\n"/* remaining elements. The directives <code>sSiIlL</code> may each be */
"\n"/* followed by an underscore (``<code>_</code>'') or */
"\n"/* exclamation mark (``<code>!</code>'') to use the underlying */
"\n"/* platform's native size for the specified type; otherwise, it uses a */
"\n"/* platform-independent consistent size. Spaces are ignored in the */
"\n"/* format string. */
"\n"/*  */
"\n"/* See also String#unpack1,  Array#pack. */
"\n"/*  */
"\n"/*    "abc \0\0abc \0\0".unpack('A6Z6')   #=> ["abc", "abc "] */
"\n"/*    "abc \0\0".unpack('a3a3')           #=> ["abc", " \000\000"] */
"\n"/*    "abc \0abc \0".unpack('Z*Z*')       #=> ["abc ", "abc "] */
"\n"/*    "aa".unpack('b8B8')                 #=> ["10000110", "01100001"] */
"\n"/*    "aaa".unpack('h2H2c')               #=> ["16", "61", 97] */
"\n"/*    "\xfe\xff\xfe\xff".unpack('sS')     #=> [-2, 65534] */
"\n"/*    "now=20is".unpack('M*')             #=> ["now is"] */
"\n"/*    "whole".unpack('xax2aX2aX1aX2a')    #=> ["h", "e", "l", "l", "o"] */
"\n"/*  */
"\n"/* This table summarizes the various formats and the Ruby classes */
"\n"/* returned by each. */
"\n"/*  */
"\n"/*  Integer       |         | */
"\n"/*  Directive     | Returns | Meaning */
"\n"/*  ------------------------------------------------------------------ */
"\n"/*  C             | Integer | 8-bit unsigned (unsigned char) */
"\n"/*  S             | Integer | 16-bit unsigned, native endian (uint16_t) */
"\n"/*  L             | Integer | 32-bit unsigned, native endian (uint32_t) */
"\n"/*  Q             | Integer | 64-bit unsigned, native endian (uint64_t) */
"\n"/*  J             | Integer | pointer width unsigned, native endian (uintptr_t) */
"\n"/*                |         | */
"\n"/*  c             | Integer | 8-bit signed (signed char) */
"\n"/*  s             | Integer | 16-bit signed, native endian (int16_t) */
"\n"/*  l             | Integer | 32-bit signed, native endian (int32_t) */
"\n"/*  q             | Integer | 64-bit signed, native endian (int64_t) */
"\n"/*  j             | Integer | pointer width signed, native endian (intptr_t) */
"\n"/*                |         | */
"\n"/*  S_ S!         | Integer | unsigned short, native endian */
"\n"/*  I I_ I!       | Integer | unsigned int, native endian */
"\n"/*  L_ L!         | Integer | unsigned long, native endian */
"\n"/*  Q_ Q!         | Integer | unsigned long long, native endian (ArgumentError */
"\n"/*                |         | if the platform has no long long type.) */
"\n"/*  J!            | Integer | uintptr_t, native endian (same with J) */
"\n"/*                |         | */
"\n"/*  s_ s!         | Integer | signed short, native endian */
"\n"/*  i i_ i!       | Integer | signed int, native endian */
"\n"/*  l_ l!         | Integer | signed long, native endian */
"\n"/*  q_ q!         | Integer | signed long long, native endian (ArgumentError */
"\n"/*                |         | if the platform has no long long type.) */
"\n"/*  j!            | Integer | intptr_t, native endian (same with j) */
"\n"/*                |         | */
"\n"/*  S> s> S!> s!> | Integer | same as the directives without ">" except */
"\n"/*  L> l> L!> l!> |         | big endian */
"\n"/*  I!> i!>       |         | */
"\n"/*  Q> q> Q!> q!> |         | "S>" is the same as "n" */
"\n"/*  J> j> J!> j!> |         | "L>" is the same as "N" */
"\n"/*                |         | */
"\n"/*  S< s< S!< s!< | Integer | same as the directives without "<" except */
"\n"/*  L< l< L!< l!< |         | little endian */
"\n"/*  I!< i!<       |         | */
"\n"/*  Q< q< Q!< q!< |         | "S<" is the same as "v" */
"\n"/*  J< j< J!< j!< |         | "L<" is the same as "V" */
"\n"/*                |         | */
"\n"/*  n             | Integer | 16-bit unsigned, network (big-endian) byte order */
"\n"/*  N             | Integer | 32-bit unsigned, network (big-endian) byte order */
"\n"/*  v             | Integer | 16-bit unsigned, VAX (little-endian) byte order */
"\n"/*  V             | Integer | 32-bit unsigned, VAX (little-endian) byte order */
"\n"/*                |         | */
"\n"/*  U             | Integer | UTF-8 character */
"\n"/*  w             | Integer | BER-compressed integer (see Array#pack) */
"\n"/*  */
"\n"/*  Float        |         | */
"\n"/*  Directive    | Returns | Meaning */
"\n"/*  ----------------------------------------------------------------- */
"\n"/*  D d          | Float   | double-precision, native format */
"\n"/*  F f          | Float   | single-precision, native format */
"\n"/*  E            | Float   | double-precision, little-endian byte order */
"\n"/*  e            | Float   | single-precision, little-endian byte order */
"\n"/*  G            | Float   | double-precision, network (big-endian) byte order */
"\n"/*  g            | Float   | single-precision, network (big-endian) byte order */
"\n"/*  */
"\n"/*  String       |         | */
"\n"/*  Directive    | Returns | Meaning */
"\n"/*  ----------------------------------------------------------------- */
"\n"/*  A            | String  | arbitrary binary string (remove trailing nulls and ASCII spaces) */
"\n"/*  a            | String  | arbitrary binary string */
"\n"/*  Z            | String  | null-terminated string */
"\n"/*  B            | String  | bit string (MSB first) */
"\n"/*  b            | String  | bit string (LSB first) */
"\n"/*  H            | String  | hex string (high nibble first) */
"\n"/*  h            | String  | hex string (low nibble first) */
"\n"/*  u            | String  | UU-encoded string */
"\n"/*  M            | String  | quoted-printable, MIME encoding (see RFC2045) */
"\n"/*  m            | String  | base64 encoded string (RFC 2045) (default) */
"\n"/*               |         | base64 encoded string (RFC 4648) if followed by 0 */
"\n"/*  P            | String  | pointer to a structure (fixed-length string) */
"\n"/*  p            | String  | pointer to a null-terminated string */
"\n"/*  */
"\n"/*  Misc.        |         | */
"\n"/*  Directive    | Returns | Meaning */
"\n"/*  ----------------------------------------------------------------- */
"\n"/*  @            | ---     | skip to the offset given by the length argument */
"\n"/*  X            | ---     | skip backward one byte */
"\n"/*  x            | ---     | skip forward one byte */
"\n"/*  */
"\n"/* The keyword <i>offset</i> can be given to start the decoding after skipping */
"\n"/* the specified amount of bytes: */
"\n"/*   "abc".unpack("C*") # => [97, 98, 99] */
"\n"/*   "abc".unpack("C*", offset: 2) # => [99] */
"\n"/*   "abc".unpack("C*", offset: 4) # => offset outside of string (ArgumentError) */
"\n"/*  */
"\n"/* HISTORY */
"\n"/*  */
"\n"/* * J, J! j, and j! are available since Ruby 2.3. */
"\n"/* * Q_, Q!, q_, and q! are available since Ruby 2.1. */
"\n"/* * I!<, i!<, I!>, and i!> are available since Ruby 1.9.3. */
"  def unpack(fmt, offset: 0)\n"
"    Primitive.pack_unpack(fmt, offset)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    str.unpack1(format)    ->  obj */
"\n"/*    str.unpack1(format, offset: anInteger)    ->  obj */
"\n"/*  */
"\n"/* Decodes <i>str</i> (which may contain binary data) according to the */
"\n"/* format string, returning the first value extracted. */
"\n"/*  */
"\n"/* See also String#unpack, Array#pack. */
"\n"/*  */
"\n"/* Contrast with String#unpack: */
"\n"/*  */
"\n"/*    "abc \0\0abc \0\0".unpack('A6Z6')   #=> ["abc", "abc "] */
"\n"/*    "abc \0\0abc \0\0".unpack1('A6Z6')  #=> "abc" */
"\n"/*  */
"\n"/* In that case data would be lost but often it's the case that the array */
"\n"/* only holds one value, especially when unpacking binary data. For instance: */
"\n"/*  */
"\n"/*    "\xff\x00\x00\x00".unpack("l")         #=>  [255] */
"\n"/*    "\xff\x00\x00\x00".unpack1("l")        #=>  255 */
"\n"/*  */
"\n"/* Thus unpack1 is convenient, makes clear the intention and signals */
"\n"/* the expected return value to those reading the code. */
"\n"/*  */
"\n"/* The keyword <i>offset</i> can be given to start the decoding after skipping */
"\n"/* the specified amount of bytes: */
"\n"/*   "abc".unpack1("C*") # => 97 */
"\n"/*   "abc".unpack1("C*", offset: 2) # => 99 */
"\n"/*   "abc".unpack1("C*", offset: 4) # => offset outside of string (ArgumentError) */
"\n"/*  */
"  def unpack1(fmt, offset: 0)\n"
,
#line 307 "pack.rb"
"    Primitive.pack_unpack1(fmt, offset)\n"
"  end\n"
"end\n"
#line 4499 "miniprelude.c"
};

static const char prelude_name10[] = "<internal:trace_point>";
static const struct {
    char L0[481]; /* 1..211 */
    char L211[484]; /* 212..279 */
    char L279[496]; /* 280..354 */
    char L354[215]; /* 355..372 */
} prelude_code10 = {
#line 1 "trace_point.rb"
""/* loaded from vm_trace.c */
""
""/* Document-class: TracePoint */
""/*  */
""/* A class that provides the functionality of Kernel#set_trace_func in a */
""/* nice Object-Oriented API. */
""/*  */
""/* == Example */
""/*  */
""/* We can use TracePoint to gather information specifically for exceptions: */
""/*  */
""/*     trace = TracePoint.new(:raise) do |tp| */
""/* 	p [tp.lineno, tp.event, tp.raised_exception] */
""/*     end */
""/*     #=> #<TracePoint:disabled> */
""/*  */
""/*     trace.enable */
""/*     #=> false */
""/*  */
""/*     0 / 0 */
""/*     #=> [5, :raise, #<ZeroDivisionError: divided by 0>] */
""/*  */
""/* == Events */
""/*  */
""/* If you don't specify the type of events you want to listen for, */
""/* TracePoint will include all available events. */
""/*  */
""/* *Note* do not depend on current event set, as this list is subject to */
""/* change. Instead, it is recommended you specify the type of events you */
""/* want to use. */
""/*  */
""/* To filter what is traced, you can pass any of the following as +events+: */
""/*  */
""/* +:line+:: execute an expression or statement on a new line */
""/* +:class+:: start a class or module definition */
""/* +:end+:: finish a class or module definition */
""/* +:call+:: call a Ruby method */
""/* +:return+:: return from a Ruby method */
""/* +:c_call+:: call a C-language routine */
""/* +:c_return+:: return from a C-language routine */
""/* +:raise+:: raise an exception */
""/* +:b_call+:: event hook at block entry */
""/* +:b_return+:: event hook at block ending */
""/* +:a_call+:: event hook at all calls (+call+, +b_call+, and +c_call+) */
""/* +:a_return+:: event hook at all returns (+return+, +b_return+, and +c_return+) */
""/* +:thread_begin+:: event hook at thread beginning */
""/* +:thread_end+:: event hook at thread ending */
""/* +:fiber_switch+:: event hook at fiber switch */
""/* +:script_compiled+:: new Ruby code compiled (with +eval+, +load+ or +require+) */
""/*  */
"class TracePoint\n"
"\n"/* call-seq: */
"\n"/* TracePoint.new(*events) { |obj| block }	    -> obj */
"\n"/*  */
"\n"/* Returns a new TracePoint object, not enabled by default. */
"\n"/*  */
"\n"/* Next, in order to activate the trace, you must use TracePoint#enable */
"\n"/*  */
"\n"/* trace = TracePoint.new(:call) do |tp| */
"\n"/*     p [tp.lineno, tp.defined_class, tp.method_id, tp.event] */
"\n"/* end */
"\n"/* #=> #<TracePoint:disabled> */
"\n"/*  */
"\n"/* trace.enable */
"\n"/* #=> false */
"\n"/*  */
"\n"/* puts "Hello, TracePoint!" */
"\n"/* # ... */
"\n"/* # [48, IRB::Notifier::AbstractNotifier, :printf, :call] */
"\n"/* # ... */
"\n"/*  */
"\n"/* When you want to deactivate the trace, you must use TracePoint#disable */
"\n"/*  */
"\n"/* trace.disable */
"\n"/*  */
"\n"/* See TracePoint@Events for possible events and more information. */
"\n"/*  */
"\n"/* A block must be given, otherwise an ArgumentError is raised. */
"\n"/*  */
"\n"/* If the trace method isn't included in the given events filter, a */
"\n"/* RuntimeError is raised. */
"\n"/*  */
"\n"/* TracePoint.trace(:line) do |tp| */
"\n"/*     p tp.raised_exception */
"\n"/* end */
"\n"/* #=> RuntimeError: 'raised_exception' not supported by this event */
"\n"/*  */
"\n"/* If the trace method is called outside block, a RuntimeError is raised. */
"\n"/*  */
"\n"/*      TracePoint.trace(:line) do |tp| */
"\n"/*        $tp = tp */
"\n"/*      end */
"\n"/*      $tp.lineno #=> access from outside (RuntimeError) */
"\n"/*  */
"\n"/* Access from other threads is also forbidden. */
"\n"/*  */
"  def self.new(*events)\n"
"    Primitive.tracepoint_new_s(events)\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    trace.inspect  -> string */
"\n"/*  */
"\n"/*  Return a string containing a human-readable TracePoint */
"\n"/*  status. */
"  def inspect\n"
"    Primitive.tracepoint_inspect\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* TracePoint.stat -> obj */
"\n"/*  */
"\n"/*  Returns internal information of TracePoint. */
"\n"/*  */
"\n"/*  The contents of the returned value are implementation specific. */
"\n"/*  It may be changed in future. */
"\n"/*  */
"\n"/*  This method is only for debugging TracePoint itself. */
"  def self.stat\n"
"    Primitive.tracepoint_stat_s\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    TracePoint.trace(*events) { |obj| block }	-> obj */
"\n"/*  */
"\n"/* A convenience method for TracePoint.new, that activates the trace */
"\n"/* automatically. */
"\n"/*  */
"\n"/*     trace = TracePoint.trace(:call) { |tp| [tp.lineno, tp.event] } */
"\n"/*     #=> #<TracePoint:enabled> */
"\n"/*  */
"\n"/*     trace.enabled? #=> true */
"\n"/*  */
"  def self.trace(*events)\n"
"    Primitive.tracepoint_trace_s(events)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   TracePoint.allow_reentry */
"\n"/*  */
"\n"/* In general, while a TracePoint callback is running, */
"\n"/* other registered callbacks are not called to avoid */
"\n"/* confusion by reentrance. */
"\n"/* This method allows the reentrance in a given block. */
"\n"/* This method should be used carefully, otherwise the callback */
"\n"/* can be easily called infinitely. */
"\n"/*  */
"\n"/* If this method is called when the reentrance is already allowed, */
"\n"/* it raises a RuntimeError. */
"  def self.allow_reentry\n"
"    Primitive.tracepoint_allow_reentry\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    trace.enable(target: nil, target_line: nil, target_thread: nil)    -> true or false */
"\n"/*    trace.enable(target: nil, target_line: nil, target_thread: :default) { block }  -> obj */
"\n"/*  */
"\n"/* Activates the trace. */
"\n"/*  */
"\n"/* Returns +true+ if trace was enabled. */
"\n"/* Returns +false+ if trace was disabled. */
"\n"/*  */
"\n"/*   trace.enabled?  #=> false */
"\n"/*   trace.enable    #=> false (previous state) */
"\n"/*                   #   trace is enabled */
"\n"/*   trace.enabled?  #=> true */
"\n"/*   trace.enable    #=> true (previous state) */
"\n"/*                   #   trace is still enabled */
"\n"/*  */
"\n"/* If a block is given, the trace will only be enabled during the block call. */
"\n"/* If target and target_line are both nil, then target_thread will default */
"\n"/* to the current thread if a block is given. */
"\n"/*  */
"\n"/*    trace.enabled? */
"\n"/*    #=> false */
"\n"/*  */
"\n"/*    trace.enable do */
"\n"/*      trace.enabled? */
"\n"/*      # only enabled for this block and thread */
"\n"/*    end */
"\n"/*  */
"\n"/*    trace.enabled? */
"\n"/*    #=> false */
"\n"/*  */
"\n"/* +target+, +target_line+ and +target_thread+ parameters are used to */
"\n"/* limit tracing only to specified code objects. +target+ should be a */
"\n"/* code object for which RubyVM::InstructionSequence.of will return */
"\n"/* an instruction sequence. */
"\n"/*  */
"\n"/*    t = TracePoint.new(:line) { |tp| p tp } */
"\n"/*  */
"\n"/*    def m1 */
"\n"/*      p 1 */
"\n"/*    end */
"\n"/*  */
"\n"/*    def m2 */
"\n"/*      p 2 */
"\n"/*    end */
"\n"/*  */
"\n"/*    t.enable(target: method(:m1)) */
"\n"/*  */
"\n"/*    m1 */
"\n"/*    # prints #<TracePoint:line test.rb:4 in `m1'> */
"\n"/*    m2 */
"\n"/*    # prints nothing */
"\n"/*  */
"\n"/* Note: You cannot access event hooks within the +enable+ block. */
"\n"/*  */
"\n"/*    trace.enable { p tp.lineno } */
"\n"/*    #=> RuntimeError: access from outside */
"\n"/*  */
,
#line 212 "trace_point.rb"
"  def enable(target: nil, target_line: nil, target_thread: :default)\n"
"    Primitive.tracepoint_enable_m(target, target_line, target_thread)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* trace.disable		-> true or false */
"\n"/* trace.disable { block } -> obj */
"\n"/*  */
"\n"/* Deactivates the trace */
"\n"/*  */
"\n"/* Return true if trace was enabled. */
"\n"/* Return false if trace was disabled. */
"\n"/*  */
"\n"/* trace.enabled?	#=> true */
"\n"/* trace.disable	#=> true (previous status) */
"\n"/* trace.enabled?	#=> false */
"\n"/* trace.disable	#=> false */
"\n"/*  */
"\n"/* If a block is given, the trace will only be disable within the scope of the */
"\n"/* block. */
"\n"/*  */
"\n"/* trace.enabled? */
"\n"/* #=> true */
"\n"/*  */
"\n"/* trace.disable do */
"\n"/*     trace.enabled? */
"\n"/*     # only disabled for this block */
"\n"/* end */
"\n"/*  */
"\n"/* trace.enabled? */
"\n"/* #=> true */
"\n"/*  */
"\n"/* Note: You cannot access event hooks within the block. */
"\n"/*  */
"\n"/* trace.disable { p tp.lineno } */
"\n"/* #=> RuntimeError: access from outside */
"  def disable\n"
"    Primitive.tracepoint_disable_m\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* trace.enabled?	    -> true or false */
"\n"/*  */
"\n"/* The current status of the trace */
"  def enabled?\n"
"    Primitive.tracepoint_enabled_p\n"
"  end\n"
"\n"
"\n"/* Type of event */
"\n"/*  */
"\n"/* See TracePoint@Events for more information. */
"  def event\n"
"    Primitive.tracepoint_attr_event\n"
"  end\n"
"\n"
"\n"/* Line number of the event */
"  def lineno\n"
"    Primitive.tracepoint_attr_lineno\n"
"  end\n"
"\n"
"\n"/* Path of the file being run */
"  def path\n"
"    Primitive.tracepoint_attr_path\n"
"  end\n"
"\n"
"\n"/* Return the parameters definition of the method or block that the */
"\n"/* current hook belongs to. Format is the same as for Method#parameters */
"  def parameters\n"
,
#line 280 "trace_point.rb"
"    Primitive.tracepoint_attr_parameters\n"
"  end\n"
"\n"
"\n"/* Return the name at the definition of the method being called */
"  def method_id\n"
"    Primitive.tracepoint_attr_method_id\n"
"  end\n"
"\n"
"\n"/* Return the called name of the method being called */
"  def callee_id\n"
"    Primitive.tracepoint_attr_callee_id\n"
"  end\n"
"\n"
"\n"/* Return class or module of the method being called. */
"\n"/*  */
"\n"/* class C; def foo; end; end */
"\n"/* 	trace = TracePoint.new(:call) do |tp| */
"\n"/* 	  p tp.defined_class #=> C */
"\n"/* 	end.enable do */
"\n"/* 	  C.new.foo */
"\n"/* 	end */
"\n"/*  */
"\n"/* If method is defined by a module, then that module is returned. */
"\n"/*  */
"\n"/* module M; def foo; end; end */
"\n"/* 	class C; include M; end; */
"\n"/* 	trace = TracePoint.new(:call) do |tp| */
"\n"/* 	  p tp.defined_class #=> M */
"\n"/* 	end.enable do */
"\n"/* 	  C.new.foo */
"\n"/* 	end */
"\n"/*  */
"\n"/* <b>Note:</b> #defined_class returns singleton class. */
"\n"/*  */
"\n"/* 6th block parameter of Kernel#set_trace_func passes original class */
"\n"/* of attached by singleton class. */
"\n"/*  */
"\n"/* <b>This is a difference between Kernel#set_trace_func and TracePoint.</b> */
"\n"/*  */
"\n"/* class C; def self.foo; end; end */
"\n"/* 	trace = TracePoint.new(:call) do |tp| */
"\n"/* 	  p tp.defined_class #=> #<Class:C> */
"\n"/* 	end.enable do */
"\n"/* 	  C.foo */
"\n"/* 	end */
"  def defined_class\n"
"    Primitive.tracepoint_attr_defined_class\n"
"  end\n"
"\n"
"\n"/* Return the generated binding object from event. */
"\n"/*  */
"\n"/* Note that for +c_call+ and +c_return+ events, the binding returned is the */
"\n"/* binding of the nearest Ruby method calling the C method, since C methods */
"\n"/* themselves do not have bindings. */
"  def binding\n"
"    Primitive.tracepoint_attr_binding\n"
"  end\n"
"\n"
"\n"/* Return the trace object during event */
"\n"/*  */
"\n"/* Same as the following, except it returns the correct object (the method */
"\n"/* receiver) for +c_call+ and +c_return+ events: */
"\n"/*  */
"\n"/*   trace.binding.eval('self') */
"  def self\n"
"    Primitive.tracepoint_attr_self\n"
"  end\n"
"\n"
"\n"/*  Return value from +:return+, +c_return+, and +b_return+ event */
"  def return_value\n"
"    Primitive.tracepoint_attr_return_value\n"
"  end\n"
"\n"
"\n"/* Value from exception raised on the +:raise+ event */
"  def raised_exception\n"
,
#line 355 "trace_point.rb"
"    Primitive.tracepoint_attr_raised_exception\n"
"  end\n"
"\n"
"\n"/* Compiled source code (String) on *eval methods on the +:script_compiled+ event. */
"\n"/* If loaded from a file, it will return nil. */
"  def eval_script\n"
"    Primitive.tracepoint_attr_eval_script\n"
"  end\n"
"\n"
"\n"/* Compiled instruction sequence represented by a RubyVM::InstructionSequence instance */
"\n"/* on the +:script_compiled+ event. */
"\n"/*  */
"\n"/* Note that this method is MRI specific. */
"  def instruction_sequence\n"
"    Primitive.tracepoint_attr_instruction_sequence\n"
"  end\n"
"end\n"
#line 4887 "miniprelude.c"
};

static const char prelude_name11[] = "<internal:warning>";
static const struct {
    char L0[182]; /* 1..54 */
} prelude_code11 = {
#line 1 "warning.rb"
""/* encoding: utf-8 */
""/* frozen-string-literal: true */
""
"module Kernel\n"
"  module_function\n"
"\n"
"\n"/* call-seq: */
"\n"/*    warn(*msgs, uplevel: nil, category: nil)   -> nil */
"\n"/*  */
"\n"/* If warnings have been disabled (for example with the */
"\n"/* <code>-W0</code> flag), does nothing.  Otherwise, */
"\n"/* converts each of the messages to strings, appends a newline */
"\n"/* character to the string if the string does not end in a newline, */
"\n"/* and calls Warning.warn with the string. */
"\n"/*  */
"\n"/*    warn("warning 1", "warning 2") */
"\n"/*  */
"\n"/*  <em>produces:</em> */
"\n"/*  */
"\n"/*    warning 1 */
"\n"/*    warning 2 */
"\n"/*  */
"\n"/* If the <code>uplevel</code> keyword argument is given, the string will */
"\n"/* be prepended with information for the given caller frame in */
"\n"/* the same format used by the <code>rb_warn</code> C function. */
"\n"/*  */
"\n"/*    # In baz.rb */
"\n"/*    def foo */
"\n"/*      warn("invalid call to foo", uplevel: 1) */
"\n"/*    end */
"\n"/*  */
"\n"/*    def bar */
"\n"/*      foo */
"\n"/*    end */
"\n"/*  */
"\n"/*    bar */
"\n"/*  */
"\n"/*  <em>produces:</em> */
"\n"/*  */
"\n"/*    baz.rb:6: warning: invalid call to foo */
"\n"/*  */
"\n"/* If <code>category</code> keyword argument is given, passes the category */
"\n"/* to <code>Warning.warn</code>.  The category given must be be one of the */
"\n"/* following categories: */
"\n"/*  */
"\n"/* :deprecated :: Used for warning for deprecated functionality that may */
"\n"/*                be removed in the future. */
"\n"/* :experimental :: Used for experimental features that may change in */
"\n"/*                  future releases. */
"  def warn(*msgs, uplevel: nil, category: nil)\n"
"    Primitive.rb_warn_m(msgs, uplevel, category)\n"
"  end\n"
"end\n"
#line 4948 "miniprelude.c"
};

static const char prelude_name12[] = "<internal:array>";
static const struct {
    char L0[397]; /* 1..70 */
} prelude_code12 = {
#line 1 "array.rb"
"class Array\n"
"\n"/* call-seq: */
"\n"/*    array.shuffle!(random: Random) -> array */
"\n"/*  */
"\n"/* Shuffles the elements of +self+ in place. */
"\n"/*    a = [1, 2, 3] #=> [1, 2, 3] */
"\n"/*    a.shuffle!    #=> [2, 3, 1] */
"\n"/*    a             #=> [2, 3, 1] */
"\n"/*  */
"\n"/* The optional +random+ argument will be used as the random number generator: */
"\n"/*    a.shuffle!(random: Random.new(1))  #=> [1, 3, 2] */
"  def shuffle!(random: Random)\n"
"    Primitive.rb_ary_shuffle_bang(random)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    array.shuffle(random: Random) -> new_ary */
"\n"/*  */
"\n"/* Returns a new array with elements of +self+ shuffled. */
"\n"/*    a = [1, 2, 3] #=> [1, 2, 3] */
"\n"/*    a.shuffle     #=> [2, 3, 1] */
"\n"/*    a             #=> [1, 2, 3] */
"\n"/*  */
"\n"/* The optional +random+ argument will be used as the random number generator: */
"\n"/*    a.shuffle(random: Random.new(1))  #=> [1, 3, 2] */
"  def shuffle(random: Random)\n"
"    Primitive.rb_ary_shuffle(random)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    array.sample(random: Random) -> object */
"\n"/*    array.sample(n, random: Random) -> new_ary */
"\n"/*  */
"\n"/* Returns random elements from +self+. */
"\n"/*  */
"\n"/* When no arguments are given, returns a random element from +self+: */
"\n"/*    a = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10] */
"\n"/*    a.sample # => 3 */
"\n"/*    a.sample # => 8 */
"\n"/* If +self+ is empty, returns +nil+. */
"\n"/*  */
"\n"/* When argument +n+ is given, returns a new \Array containing +n+ random */
"\n"/* elements from +self+: */
"\n"/*    a.sample(3) # => [8, 9, 2] */
"\n"/*    a.sample(6) # => [9, 6, 10, 3, 1, 4] */
"\n"/* Returns no more than <tt>a.size</tt> elements */
"\n"/* (because no new duplicates are introduced): */
"\n"/*    a.sample(a.size * 2) # => [6, 4, 1, 8, 5, 9, 10, 2, 3, 7] */
"\n"/* But +self+ may contain duplicates: */
"\n"/*    a = [1, 1, 1, 2, 2, 3] */
"\n"/*    a.sample(a.size * 2) # => [1, 1, 3, 2, 1, 2] */
"\n"/* The argument +n+ must be a non-negative numeric value. */
"\n"/* The order of the result array is unrelated to the order of +self+. */
"\n"/* Returns a new empty \Array if +self+ is empty. */
"\n"/*  */
"\n"/* The optional +random+ argument will be used as the random number generator: */
"\n"/*    a = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10] */
"\n"/*    a.sample(random: Random.new(1))     #=> 6 */
"\n"/*    a.sample(4, random: Random.new(1))  #=> [6, 10, 9, 2] */
"  def sample(n = (ary = false), random: Random)\n"
"    if Primitive.mandatory_only?\n"
"\n"/* Primitive.cexpr! %{ rb_ary_sample(self, rb_cRandom, Qfalse, Qfalse) } */
"      Primitive.ary_sample0\n"
"    else\n"
"\n"/* Primitive.cexpr! %{ rb_ary_sample(self, random, n, ary) } */
"      Primitive.ary_sample(random, n, ary)\n"
"    end\n"
"  end\n"
"end\n"
#line 5025 "miniprelude.c"
};

static const char prelude_name13[] = "<internal:kernel>";
static const struct {
    char L0[484]; /* 1..121 */
    char L121[486]; /* 122..179 */
} prelude_code13 = {
#line 1 "kernel.rb"
"module Kernel\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.class    -> class */
"\n"/*  */
"\n"/*  Returns the class of <i>obj</i>. This method must always be called */
"\n"/*  with an explicit receiver, as #class is also a reserved word in */
"\n"/*  Ruby. */
"\n"/*  */
"\n"/*     1.class      #=> Integer */
"\n"/*     self.class   #=> Object */
"  #--\n"
"\n"/* Equivalent to \c Object\#class in Ruby. */
"\n"/*  */
"\n"/* Returns the class of \c obj, skipping singleton classes or module inclusions. */
"  #++\n"
"\n"/*  */
"  def class\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_obj_class(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.clone(freeze: nil) -> an_object */
"\n"/*  */
"\n"/*  Produces a shallow copy of <i>obj</i>---the instance variables of */
"\n"/*  <i>obj</i> are copied, but not the objects they reference. */
"\n"/*  #clone copies the frozen value state of <i>obj</i>, unless the */
"\n"/*  +:freeze+ keyword argument is given with a false or true value. */
"\n"/*  See also the discussion under Object#dup. */
"\n"/*  */
"\n"/*     class Klass */
"\n"/*        attr_accessor :str */
"\n"/*     end */
"\n"/*     s1 = Klass.new      #=> #<Klass:0x401b3a38> */
"\n"/*     s1.str = "Hello"    #=> "Hello" */
"\n"/*     s2 = s1.clone       #=> #<Klass:0x401b3998 @str="Hello"> */
"\n"/*     s2.str[1,4] = "i"   #=> "i" */
"\n"/*     s1.inspect          #=> "#<Klass:0x401b3a38 @str=\"Hi\">" */
"\n"/*     s2.inspect          #=> "#<Klass:0x401b3998 @str=\"Hi\">" */
"\n"/*  */
"\n"/*  This method may have class-specific behavior.  If so, that */
"\n"/*  behavior will be documented under the #+initialize_copy+ method of */
"\n"/*  the class. */
"\n"/*  */
"  def clone(freeze: nil)\n"
"    Primitive.rb_obj_clone2(freeze)\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.frozen?    -> true or false */
"\n"/*  */
"\n"/*  Returns the freeze status of <i>obj</i>. */
"\n"/*  */
"\n"/*     a = [ "a", "b", "c" ] */
"\n"/*     a.freeze    #=> ["a", "b", "c"] */
"\n"/*     a.frozen?   #=> true */
"  #--\n"
"\n"/* Determines if the object is frozen. Equivalent to \c Object\#frozen? in Ruby. */
"\n"/* \param[in] obj  the object to be determines */
"\n"/* \retval Qtrue if frozen */
"\n"/* \retval Qfalse if not frozen */
"  #++\n"
"\n"/*  */
"  def frozen?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_obj_frozen_p(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.tap {|x| block }    -> obj */
"\n"/*  */
"\n"/*  Yields self to the block, and then returns self. */
"\n"/*  The primary purpose of this method is to "tap into" a method chain, */
"\n"/*  in order to perform operations on intermediate results within the chain. */
"\n"/*  */
"\n"/*     (1..10)                  .tap {|x| puts "original: #{x}" } */
"\n"/*       .to_a                  .tap {|x| puts "array:    #{x}" } */
"\n"/*       .select {|x| x.even? } .tap {|x| puts "evens:    #{x}" } */
"\n"/*       .map {|x| x*x }        .tap {|x| puts "squares:  #{x}" } */
"\n"/*  */
"  #--\n"
"\n"/* \private */
"  #++\n"
"\n"/*  */
"  def tap\n"
"    yield(self)\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.then {|x| block }          -> an_object */
"\n"/*  */
"\n"/*  Yields self to the block and returns the result of the block. */
"\n"/*  */
"\n"/*     3.next.then {|x| x**x }.to_s             #=> "256" */
"\n"/*  */
"\n"/*  Good usage for +then+ is value piping in method chains: */
"\n"/*  */
"\n"/*     require 'open-uri' */
"\n"/*     require 'json' */
"\n"/*  */
"\n"/*     construct_url(arguments). */
"\n"/*       then {|url| URI(url).read }. */
"\n"/*       then {|response| JSON.parse(response) } */
"\n"/*  */
"\n"/*  When called without block, the method returns +Enumerator+, */
"\n"/*  which can be used, for example, for conditional */
"\n"/*  circuit-breaking: */
"\n"/*  */
"\n"/*     # meets condition, no-op */
"\n"/*     1.then.detect(&:odd?)            # => 1 */
"\n"/*     # does not meet condition, drop value */
"\n"/*     2.then.detect(&:odd?)            # => nil */
"\n"/*  */
"  def then\n"
"    unless Primitive.block_given_p\n"
,
#line 122 "kernel.rb"
"      return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, rb_obj_size)'\n"
"    end\n"
"    yield(self)\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.yield_self {|x| block }    -> an_object */
"\n"/*  */
"\n"/*  Yields self to the block and returns the result of the block. */
"\n"/*  */
"\n"/*     "my string".yield_self {|s| s.upcase }   #=> "MY STRING" */
"\n"/*  */
"\n"/*  Good usage for +then+ is value piping in method chains: */
"\n"/*  */
"\n"/*     require 'open-uri' */
"\n"/*     require 'json' */
"\n"/*  */
"\n"/*     construct_url(arguments). */
"\n"/*       then {|url| URI(url).read }. */
"\n"/*       then {|response| JSON.parse(response) } */
"\n"/*  */
"  def yield_self\n"
"    unless Primitive.block_given_p\n"
"      return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, rb_obj_size)'\n"
"    end\n"
"    yield(self)\n"
"  end\n"
"\n"
"  module_function\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     Float(arg, exception: true)    -> float or nil */
"\n"/*  */
"\n"/*  Returns <i>arg</i> converted to a float. Numeric types are */
"\n"/*  converted directly, and with exception to String and */
"\n"/*  <code>nil</code> the rest are converted using */
"\n"/*  <i>arg</i><code>.to_f</code>.  Converting a String with invalid */
"\n"/*  characters will result in a ArgumentError.  Converting */
"\n"/*  <code>nil</code> generates a TypeError.  Exceptions can be */
"\n"/*  suppressed by passing <code>exception: false</code>. */
"\n"/*  */
"\n"/*     Float(1)                 #=> 1.0 */
"\n"/*     Float("123.456")         #=> 123.456 */
"\n"/*     Float("123.0_badstring") #=> ArgumentError: invalid value for Float(): "123.0_badstring" */
"\n"/*     Float(nil)               #=> TypeError: can't convert nil into Float */
"\n"/*     Float("123.0_badstring", exception: false)  #=> nil */
"\n"/*  */
"  def Float(arg, exception: true)\n"
"    if Primitive.mandatory_only?\n"
"      Primitive.rb_f_float1(arg)\n"
"    else\n"
"      Primitive.rb_f_float(arg, exception)\n"
"    end\n"
"  end\n"
"end\n"
#line 5214 "miniprelude.c"
};

static const char prelude_name14[] = "<internal:ractor>";
static const struct {
    char L0[508]; /* 1..293 */
    char L293[485]; /* 294..349 */
    char L349[508]; /* 350..473 */
    char L473[466]; /* 474..627 */
    char L627[455]; /* 628..703 */
    char L703[478]; /* 704..753 */
    char L753[508]; /* 754..827 */
    char L827[184]; /* 828..839 */
} prelude_code14 = {
#line 1 "ractor.rb"
""/* Ractor is an Actor-model abstraction for Ruby that provides thread-safe parallel execution. */
""/*  */
""/* Ractor.new can make a new Ractor, and it will run in parallel. */
""/*  */
""/*     # The simplest ractor */
""/*     r = Ractor.new {puts "I am in Ractor!"} */
""/*     r.take # wait for it to finish */
""/*     # here "I am in Ractor!" would be printed */
""/*  */
""/* Ractors do not share usual objects, so the same kinds of thread-safety concerns such as data-race, */
""/* race-conditions are not available on multi-ractor programming. */
""/*  */
""/* To achieve this, ractors severely limit object sharing between different ractors. */
""/* For example, unlike threads, ractors can't access each other's objects, nor any objects through */
""/* variables of the outer scope. */
""/*  */
""/*     a = 1 */
""/*     r = Ractor.new {puts "I am in Ractor! a=#{a}"} */
""/*     # fails immediately with */
""/*     # ArgumentError (can not isolate a Proc because it accesses outer variables (a).) */
""/*  */
""/* On CRuby (the default implementation), Global Virtual Machine Lock (GVL) is held per ractor, so */
""/* ractors are performed in parallel without locking each other. */
""/*  */
""/* Instead of accessing the shared state, the objects should be passed to and from ractors via */
""/* sending and receiving objects as messages. */
""/*  */
""/*     a = 1 */
""/*     r = Ractor.new do */
""/*       a_in_ractor = receive # receive blocks till somebody will pass message */
""/*       puts "I am in Ractor! a=#{a_in_ractor}" */
""/*     end */
""/*     r.send(a)  # pass it */
""/*     r.take */
""/*     # here "I am in Ractor! a=1" would be printed */
""/*  */
""/* There are two pairs of methods for sending/receiving messages: */
""/*  */
""/* * Ractor#send and Ractor.receive for when the _sender_ knows the receiver (push); */
""/* * Ractor.yield and Ractor#take for when the _receiver_ knows the sender (pull); */
""/*  */
""/* In addition to that, an argument to Ractor.new would be passed to block and available there */
""/* as if received by Ractor.receive, and the last block value would be sent outside of the */
""/* ractor as if sent by Ractor.yield. */
""/*  */
""/* A little demonstration on a classic ping-pong: */
""/*  */
""/*     server = Ractor.new do */
""/*       puts "Server starts: #{self.inspect}" */
""/*       puts "Server sends: ping" */
""/*       Ractor.yield 'ping'                       # The server doesn't know the receiver and sends to whoever interested */
""/*       received = Ractor.receive                 # The server doesn't know the sender and receives from whoever sent */
""/*       puts "Server received: #{received}" */
""/*     end */
""/*  */
""/*     client = Ractor.new(server) do |srv|        # The server is sent inside client, and available as srv */
""/*       puts "Client starts: #{self.inspect}" */
""/*       received = srv.take                       # The Client takes a message specifically from the server */
""/*       puts "Client received from " \ */
""/*            "#{srv.inspect}: #{received}" */
""/*       puts "Client sends to " \ */
""/*            "#{srv.inspect}: pong" */
""/*       srv.send 'pong'                           # The client sends a message specifically to the server */
""/*     end */
""/*  */
""/*     [client, server].each(&:take)               # Wait till they both finish */
""/*  */
""/* This will output: */
""/*  */
""/*     Server starts: #<Ractor:#2 test.rb:1 running> */
""/*     Server sends: ping */
""/*     Client starts: #<Ractor:#3 test.rb:8 running> */
""/*     Client received from #<Ractor:#2 rac.rb:1 blocking>: ping */
""/*     Client sends to #<Ractor:#2 rac.rb:1 blocking>: pong */
""/*     Server received: pong */
""/*  */
""/* It is said that Ractor receives messages via the <em>incoming port</em>, and sends them */
""/* to the <em>outgoing port</em>. Either one can be disabled with Ractor#close_incoming and */
""/* Ractor#close_outgoing respectively. If a ractor terminated, its ports will be closed */
""/* automatically. */
""/*  */
""/* == Shareable and unshareable objects */
""/*  */
""/* When the object is sent to and from the ractor, it is important to understand whether the */
""/* object is shareable or unshareable. Most of objects are unshareable objects. */
""/*  */
""/* Shareable objects are basically those which can be used by several threads without compromising */
""/* thread-safety; e.g. immutable ones. Ractor.shareable? allows to check this, and Ractor.make_shareable */
""/* tries to make object shareable if it is not. */
""/*  */
""/*     Ractor.shareable?(1)            #=> true -- numbers and other immutable basic values are */
""/*     Ractor.shareable?('foo')        #=> false, unless the string is frozen due to # freeze_string_literals: true */
""/*     Ractor.shareable?('foo'.freeze) #=> true */
""/*  */
""/*     ary = ['hello', 'world'] */
""/*     ary.frozen?                 #=> false */
""/*     ary[0].frozen?              #=> false */
""/*     Ractor.make_shareable(ary) */
""/*     ary.frozen?                 #=> true */
""/*     ary[0].frozen?              #=> true */
""/*     ary[1].frozen?              #=> true */
""/*  */
""/* When a shareable object is sent (via #send or Ractor.yield), no additional processing happens, */
""/* and it just becomes usable by both ractors. When an unshareable object is sent, it can be */
""/* either _copied_ or _moved_. The first is the default, and it makes the object's full copy by */
""/* deep cloning of non-shareable parts of its structure. */
""/*  */
""/*     data = ['foo', 'bar'.freeze] */
""/*     r = Ractor.new do */
""/*       data2 = Ractor.receive */
""/*       puts "In ractor: #{data2.object_id}, #{data2[0].object_id}, #{data2[1].object_id}" */
""/*     end */
""/*     r.send(data) */
""/*     r.take */
""/*     puts "Outside  : #{data.object_id}, #{data[0].object_id}, #{data[1].object_id}" */
""/*  */
""/* This will output: */
""/*  */
""/*     In ractor: 340, 360, 320 */
""/*     Outside  : 380, 400, 320 */
""/*  */
""/* (Note that object id of both array and non-frozen string inside array have changed inside */
""/* the ractor, showing it is different objects. But the second array's element, which is a */
""/* shareable frozen string, has the same object_id.) */
""/*  */
""/* Deep cloning of the objects may be slow, and sometimes impossible. Alternatively, */
""/* <tt>move: true</tt> may be used on sending. This will <em>move</em> the object to the */
""/* receiving ractor, making it inaccessible for a sending ractor. */
""/*  */
""/*     data = ['foo', 'bar'] */
""/*     r = Ractor.new do */
""/*       data_in_ractor = Ractor.receive */
""/*       puts "In ractor: #{data_in_ractor.object_id}, #{data_in_ractor[0].object_id}" */
""/*     end */
""/*     r.send(data, move: true) */
""/*     r.take */
""/*     puts "Outside: moved? #{Ractor::MovedObject === data}" */
""/*     puts "Outside: #{data.inspect}" */
""/*  */
""/* This will output: */
""/*  */
""/*     In ractor: 100, 120 */
""/*     Outside: moved? true */
""/*     test.rb:9:in `method_missing': can not send any methods to a moved object (Ractor::MovedError) */
""/*  */
""/* Notice that even +inspect+ (and more basic methods like <tt>__id__</tt>) is inaccessible */
""/* on a moved object. */
""/*  */
""/* Besides frozen objects, there are shareable objects. Class and Module objects are shareable so */
""/* the Class/Module definitions are shared between ractors. Ractor objects are also shareable objects. */
""/* All operations for the shareable mutable objects are thread-safe, so the thread-safety property */
""/* will be kept. We can not define mutable shareable objects in Ruby, but C extensions can introduce them. */
""/*  */
""/* It is prohibited to access instance variables of mutable shareable objects (especially Modules and classes) */
""/* from ractors other than main: */
""/*  */
""/*     class C */
""/*       class << self */
""/*         attr_accessor :tricky */
""/*       end */
""/*     end */
""/*  */
""/*     C.tricky = 'test' */
""/*  */
""/*     r = Ractor.new(C) do |cls| */
""/*       puts "I see #{cls}" */
""/*       puts "I can't see #{cls.tricky}" */
""/*     end */
""/*     r.take */
""/*     # I see C */
""/*     # can not access instance variables of classes/modules from non-main Ractors (RuntimeError) */
""/*  */
""/* Ractors can access constants if they are shareable. The main Ractor is the only one that can */
""/* access non-shareable constants. */
""/*  */
""/*     GOOD = 'good'.freeze */
""/*     BAD = 'bad' */
""/*  */
""/*     r = Ractor.new do */
""/*       puts "GOOD=#{GOOD}" */
""/*       puts "BAD=#{BAD}" */
""/*     end */
""/*     r.take */
""/*     # GOOD=good */
""/*     # can not access non-shareable objects in constant Object::BAD by non-main Ractor. (NameError) */
""/*  */
""/*     # Consider the same C class from above */
""/*  */
""/*     r = Ractor.new do */
""/*       puts "I see #{C}" */
""/*       puts "I can't see #{C.tricky}" */
""/*     end */
""/*     r.take */
""/*     # I see C */
""/*     # can not access instance variables of classes/modules from non-main Ractors (RuntimeError) */
""/*  */
""/* See also the description of <tt># shareable_constant_value</tt> pragma in */
""/* {Comments syntax}[rdoc-ref:syntax/comments.rdoc] explanation. */
""/*  */
""/* == Ractors vs threads */
""/*  */
""/* Each ractor creates its own thread. New threads can be created from inside ractor */
""/* (and, on CRuby, sharing GVL with other threads of this ractor). */
""/*  */
""/*     r = Ractor.new do */
""/*       a = 1 */
""/*       Thread.new {puts "Thread in ractor: a=#{a}"}.join */
""/*     end */
""/*     r.take */
""/*     # Here "Thread in ractor: a=1" will be printed */
""/*  */
""/* == Note on code examples */
""/*  */
""/* In examples below, sometimes we use the following method to wait till ractors that */
""/* are not currently blocked will finish (or process till next blocking) method. */
""/*  */
""/*     def wait */
""/*       sleep(0.1) */
""/*     end */
""/*  */
""/* It is **only for demonstration purposes** and shouldn't be used in a real code. */
""/* Most of the times, just #take is used to wait till ractor will finish. */
""/*  */
""/* == Reference */
""/*  */
""/* See {Ractor design doc}[rdoc-ref:ractor.md] for more details. */
""/*  */
"class Ractor\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     Ractor.new(*args, name: nil) {|*args| block } -> ractor */
"\n"/*  */
"\n"/* Create a new Ractor with args and a block. */
"\n"/*  */
"\n"/* A block (Proc) will be isolated (can't access to outer variables). +self+ */
"\n"/* inside the block will refer to the current Ractor. */
"\n"/*  */
"\n"/*    r = Ractor.new { puts "Hi, I am #{self.inspect}" } */
"\n"/*    r.take */
"\n"/*    # Prints "Hi, I am #<Ractor:#2 test.rb:1 running>" */
"\n"/*  */
"\n"/* +args+ passed to the method would be propagated to block args by the same rules as */
"\n"/* objects passed through #send/Ractor.receive: if +args+ are not shareable, they */
"\n"/* will be copied (via deep cloning, which might be inefficient). */
"\n"/*  */
"\n"/*    arg = [1, 2, 3] */
"\n"/*    puts "Passing: #{arg} (##{arg.object_id})" */
"\n"/*    r = Ractor.new(arg) {|received_arg| */
"\n"/*      puts "Received: #{received_arg} (##{received_arg.object_id})" */
"\n"/*    } */
"\n"/*    r.take */
"\n"/*    # Prints: */
"\n"/*    #   Passing: [1, 2, 3] (#280) */
"\n"/*    #   Received: [1, 2, 3] (#300) */
"\n"/*  */
"\n"/* Ractor's +name+ can be set for debugging purposes: */
"\n"/*  */
"\n"/*    r = Ractor.new(name: 'my ractor') {} */
"\n"/*    p r */
"\n"/*    #=> #<Ractor:#3 my ractor test.rb:1 terminated> */
"\n"/*  */
"  def self.new(*args, name: nil, &block)\n"
"    b = block\n"/* TODO: builtin bug */
"    raise ArgumentError, \"must be called with a block\" unless block\n"
"    loc = caller_locations(1, 1).first\n"
"    loc = \"#{loc.path}:#{loc.lineno}\"\n"
"    __builtin_ractor_create(loc, name, args, b)\n"
"  end\n"
"\n"
"\n"/* Returns the currently executing Ractor. */
"\n"/*  */
"\n"/*   Ractor.current #=> #<Ractor:#1 running> */
"  def self.current\n"
"    __builtin_cexpr! %q{\n"
"      rb_ractor_self(rb_ec_ractor_ptr(ec));\n"
"    }\n"
"  end\n"
"\n"
"\n"/* Returns total count of Ractors currently running. */
"\n"/*  */
"\n"/*    Ractor.count                   #=> 1 */
"\n"/*    r = Ractor.new(name: 'example') { Ractor.yield(1) } */
"\n"/*    Ractor.count                   #=> 2 (main + example ractor) */
"\n"/*    r.take                         # wait for Ractor.yield(1) */
"\n"/*    r.take                         # wait till r will finish */
"\n"/*    Ractor.count                   #=> 1 */
"  def self.count\n"
"    __builtin_cexpr! %q{\n"
"      ULONG2NUM(GET_VM()->ractor.cnt);\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
,
#line 294 "ractor.rb"
"\n"/* call-seq: */
"\n"/*    Ractor.select(*ractors, [yield_value:, move: false]) -> [ractor or symbol, obj] */
"\n"/*  */
"\n"/* Waits for the first ractor to have something in its outgoing port, reads from this ractor, and */
"\n"/* returns that ractor and the object received. */
"\n"/*  */
"\n"/*    r1 = Ractor.new {Ractor.yield 'from 1'} */
"\n"/*    r2 = Ractor.new {Ractor.yield 'from 2'} */
"\n"/*  */
"\n"/*    r, obj = Ractor.select(r1, r2) */
"\n"/*  */
"\n"/*    puts "received #{obj.inspect} from #{r.inspect}" */
"\n"/*    # Prints: received "from 1" from #<Ractor:#2 test.rb:1 running> */
"\n"/*  */
"\n"/* If one of the given ractors is the current ractor, and it would be selected, +r+ will contain */
"\n"/* +:receive+ symbol instead of the ractor object. */
"\n"/*  */
"\n"/*    r1 = Ractor.new(Ractor.current) do |main| */
"\n"/*      main.send 'to main' */
"\n"/*      Ractor.yield 'from 1' */
"\n"/*    end */
"\n"/*    r2 = Ractor.new do */
"\n"/*      Ractor.yield 'from 2' */
"\n"/*    end */
"\n"/*  */
"\n"/*    r, obj = Ractor.select(r1, r2, Ractor.current) */
"\n"/*    puts "received #{obj.inspect} from #{r.inspect}" */
"\n"/*    # Prints: received "to main" from :receive */
"\n"/*  */
"\n"/* If +yield_value+ is provided, that value may be yielded if another Ractor is calling #take. */
"\n"/* In this case, the pair <tt>[:yield, nil]</tt> would be returned: */
"\n"/*  */
"\n"/*    r1 = Ractor.new(Ractor.current) do |main| */
"\n"/*      puts "Received from main: #{main.take}" */
"\n"/*    end */
"\n"/*  */
"\n"/*    puts "Trying to select" */
"\n"/*    r, obj = Ractor.select(r1, Ractor.current, yield_value: 123) */
"\n"/*    wait */
"\n"/*    puts "Received #{obj.inspect} from #{r.inspect}" */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*    Trying to select */
"\n"/*    Received from main: 123 */
"\n"/*    Received nil from :yield */
"\n"/*  */
"\n"/* +move+ boolean flag defines whether yielded value should be copied (default) or moved. */
"  def self.select(*ractors, yield_value: yield_unspecified = true, move: false)\n"
"    raise ArgumentError, 'specify at least one ractor or `yield_value`' if yield_unspecified && ractors.empty?\n"
"\n"
"    __builtin_cstmt! %q{\n"
"      const VALUE *rs = RARRAY_CONST_PTR_TRANSIENT(ractors);\n"
"      VALUE rv;\n"
"      VALUE v = ractor_select(ec, rs, RARRAY_LENINT(ractors),\n"
"                              yield_unspecified == Qtrue ? Qundef : yield_value,\n"
,
#line 350 "ractor.rb"
"                              (bool)RTEST(move) ? true : false, &rv);\n"
"      return rb_ary_new_from_args(2, rv, v);\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.receive -> msg */
"\n"/*  */
"\n"/* Receive an incoming message from the current Ractor's incoming port's queue, which was */
"\n"/* sent there by #send. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       v1 = Ractor.receive */
"\n"/*       puts "Received: #{v1}" */
"\n"/*     end */
"\n"/*     r.send('message1') */
"\n"/*     r.take */
"\n"/*     # Here will be printed: "Received: message1" */
"\n"/*  */
"\n"/* Alternatively, private instance method +receive+ may be used: */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       v1 = receive */
"\n"/*       puts "Received: #{v1}" */
"\n"/*     end */
"\n"/*     r.send('message1') */
"\n"/*     r.take */
"\n"/*     # Here will be printed: "Received: message1" */
"\n"/*  */
"\n"/* The method blocks if the queue is empty. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       puts "Before first receive" */
"\n"/*       v1 = Ractor.receive */
"\n"/*       puts "Received: #{v1}" */
"\n"/*       v2 = Ractor.receive */
"\n"/*       puts "Received: #{v2}" */
"\n"/*     end */
"\n"/*     wait */
"\n"/*     puts "Still not received" */
"\n"/*     r.send('message1') */
"\n"/*     wait */
"\n"/*     puts "Still received only one" */
"\n"/*     r.send('message2') */
"\n"/*     r.take */
"\n"/*  */
"\n"/* Output: */
"\n"/*  */
"\n"/*     Before first receive */
"\n"/*     Still not received */
"\n"/*     Received: message1 */
"\n"/*     Still received only one */
"\n"/*     Received: message2 */
"\n"/*  */
"\n"/* If close_incoming was called on the ractor, the method raises Ractor::ClosedError */
"\n"/* if there are no more messages in incoming queue: */
"\n"/*  */
"\n"/*     Ractor.new do */
"\n"/*       close_incoming */
"\n"/*       receive */
"\n"/*     end */
"\n"/*     wait */
"\n"/*     # in `receive': The incoming port is already closed => #<Ractor:#2 test.rb:1 running> (Ractor::ClosedError) */
"\n"/*  */
"  def self.receive\n"
"    __builtin_cexpr! %q{\n"
"      ractor_receive(ec, rb_ec_ractor_ptr(ec))\n"
"    }\n"
"  end\n"
"\n"
"  class << self\n"
"    alias recv receive\n"
"  end\n"
"\n"
"\n"/* same as Ractor.receive */
"  private def receive\n"
"    __builtin_cexpr! %q{\n"
"      ractor_receive(ec, rb_ec_ractor_ptr(ec))\n"
"    }\n"
"  end\n"
"  alias recv receive\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.receive_if {|msg| block } -> msg */
"\n"/*  */
"\n"/* Receive only a specific message. */
"\n"/*  */
"\n"/* Instead of Ractor.receive, Ractor.receive_if can provide a pattern */
"\n"/* by a block and you can choose the receiving message. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/foo/)} #=> "foo3" */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/bar/)} #=> "bar1" */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/baz/)} #=> "baz2" */
"\n"/*     end */
"\n"/*     r << "bar1" */
"\n"/*     r << "baz2" */
"\n"/*     r << "foo3" */
"\n"/*     r.take */
"\n"/*  */
"\n"/* This will output: */
"\n"/*  */
"\n"/*     foo3 */
"\n"/*     bar1 */
"\n"/*     baz2 */
"\n"/*  */
"\n"/* If the block returns a truthy value, the message will be removed from the incoming queue */
"\n"/* and returned. */
"\n"/* Otherwise, the message remains in the incoming queue and the following received */
"\n"/* messages are checked by the given block. */
"\n"/*  */
"\n"/* If there are no messages left in the incoming queue, the method will */
"\n"/* block until new messages arrive. */
"\n"/*  */
"\n"/* If the block is escaped by break/return/exception/throw, the message is removed from */
"\n"/* the incoming queue as if a truthy value had been returned. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       val = Ractor.receive_if{|msg| msg.is_a?(Array)} */
"\n"/*       puts "Received successfully: #{val}" */
"\n"/*     end */
"\n"/*  */
,
#line 474 "ractor.rb"
"\n"/*     r.send(1) */
"\n"/*     r.send('test') */
"\n"/*     wait */
"\n"/*     puts "2 non-matching sent, nothing received" */
"\n"/*     r.send([1, 2, 3]) */
"\n"/*     wait */
"\n"/*  */
"\n"/* Prints: */
"\n"/*  */
"\n"/*     2 non-matching sent, nothing received */
"\n"/*     Received successfully: [1, 2, 3] */
"\n"/*  */
"\n"/* Note that you can not call receive/receive_if in the given block recursively. */
"\n"/* It means that you should not do any tasks in the block. */
"\n"/*  */
"\n"/*     Ractor.current << true */
"\n"/*     Ractor.receive_if{|msg| Ractor.receive} */
"\n"/*     #=> `receive': can not call receive/receive_if recursively (Ractor::Error) */
"\n"/*  */
"  def self.receive_if &b\n"
"    Primitive.ractor_receive_if b\n"
"  end\n"
"\n"
"  private def receive_if &b\n"
"    Primitive.ractor_receive_if b\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    ractor.send(msg, move: false) -> self */
"\n"/*  */
"\n"/* Send a message to a Ractor's incoming queue to be consumed by Ractor.receive. */
"\n"/*  */
"\n"/*   r = Ractor.new do */
"\n"/*     value = Ractor.receive */
"\n"/*     puts "Received #{value}" */
"\n"/*   end */
"\n"/*   r.send 'message' */
"\n"/*   # Prints: "Received: message" */
"\n"/*  */
"\n"/* The method is non-blocking (will return immediately even if the ractor is not ready */
"\n"/* to receive anything): */
"\n"/*  */
"\n"/*    r = Ractor.new {sleep(5)} */
"\n"/*    r.send('test') */
"\n"/*    puts "Sent successfully" */
"\n"/*    # Prints: "Sent successfully" immediately */
"\n"/*  */
"\n"/* Attempt to send to ractor which already finished its execution will raise Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {} */
"\n"/*   r.take */
"\n"/*   p r */
"\n"/*   # "#<Ractor:#6 (irb):23 terminated>" */
"\n"/*   r.send('test') */
"\n"/*   # Ractor::ClosedError (The incoming-port is already closed) */
"\n"/*  */
"\n"/* If close_incoming was called on the ractor, the method also raises Ractor::ClosedError. */
"\n"/*  */
"\n"/*    r =  Ractor.new do */
"\n"/*      sleep(500) */
"\n"/*      receive */
"\n"/*    end */
"\n"/*    r.close_incoming */
"\n"/*    r.send('test') */
"\n"/*    # Ractor::ClosedError (The incoming-port is already closed) */
"\n"/*    # The error would be raised immediately, not when ractor will try to receive */
"\n"/*  */
"\n"/* If the +obj+ is unshareable, by default it would be copied into ractor by deep cloning. */
"\n"/* If the <tt>move: true</tt> is passed, object is _moved_ into ractor and becomes */
"\n"/* inaccessible to sender. */
"\n"/*  */
"\n"/*    r = Ractor.new {puts "Received: #{receive}"} */
"\n"/*    msg = 'message' */
"\n"/*    r.send(msg, move: true) */
"\n"/*    r.take */
"\n"/*    p msg */
"\n"/*  */
"\n"/* This prints: */
"\n"/*  */
"\n"/*    Received: message */
"\n"/*    in `p': undefined method `inspect' for #<Ractor::MovedObject:0x000055c99b9b69b8> */
"\n"/*  */
"\n"/* All references to the object and its parts will become invalid in sender. */
"\n"/*  */
"\n"/*    r = Ractor.new {puts "Received: #{receive}"} */
"\n"/*    s = 'message' */
"\n"/*    ary = [s] */
"\n"/*    copy = ary.dup */
"\n"/*    r.send(ary, move: true) */
"\n"/*  */
"\n"/*    s.inspect */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    ary.class */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    copy.class */
"\n"/*    # => Array, it is different object */
"\n"/*    copy[0].inspect */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    # ...but its item was still a reference to `s`, which was moved */
"\n"/*  */
"\n"/* If the object was shareable, <tt>move: true</tt> has no effect on it: */
"\n"/*  */
"\n"/*    r = Ractor.new {puts "Received: #{receive}"} */
"\n"/*    s = 'message'.freeze */
"\n"/*    r.send(s, move: true) */
"\n"/*    s.inspect #=> "message", still available */
"\n"/*  */
"  def send(obj, move: false)\n"
"    __builtin_cexpr! %q{\n"
"      ractor_send(ec, RACTOR_PTR(self), obj, move)\n"
"    }\n"
"  end\n"
"  alias << send\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     Ractor.yield(msg, move: false) -> nil */
"\n"/*  */
"\n"/* Send a message to the current ractor's outgoing port to be consumed by #take. */
"\n"/*  */
"\n"/*    r = Ractor.new {Ractor.yield 'Hello from ractor'} */
"\n"/*    puts r.take */
"\n"/*    # Prints: "Hello from ractor" */
"\n"/*  */
"\n"/* The method is blocking, and will return only when somebody consumes the */
"\n"/* sent message. */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*      puts "Ractor: after yield" */
"\n"/*    end */
"\n"/*    wait */
"\n"/*    puts "Still not taken" */
"\n"/*    puts r.take */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*    Still not taken */
"\n"/*    Hello from ractor */
"\n"/*    Ractor: after yield */
"\n"/*  */
"\n"/* If the outgoing port was closed with #close_outgoing, the method will raise: */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      close_outgoing */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*    end */
"\n"/*    wait */
"\n"/*    # `yield': The outgoing-port is already closed (Ractor::ClosedError) */
"\n"/*  */
"\n"/* The meaning of +move+ argument is the same as for #send. */
"  def self.yield(obj, move: false)\n"
"    __builtin_cexpr! %q{\n"
,
#line 628 "ractor.rb"
"      ractor_yield(ec, rb_ec_ractor_ptr(ec), obj, move)\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     ractor.take -> msg */
"\n"/*  */
"\n"/* Take a message from ractor's outgoing port, which was put there by Ractor.yield or at ractor's */
"\n"/* finalization. */
"\n"/*  */
"\n"/*   r = Ractor.new do */
"\n"/*     Ractor.yield 'explicit yield' */
"\n"/*     'last value' */
"\n"/*   end */
"\n"/*   puts r.take #=> 'explicit yield' */
"\n"/*   puts r.take #=> 'last value' */
"\n"/*   puts r.take # Ractor::ClosedError (The outgoing-port is already closed) */
"\n"/*  */
"\n"/* The fact that the last value is also put to outgoing port means that +take+ can be used */
"\n"/* as some analog of Thread#join ("just wait till ractor finishes"), but don't forget it */
"\n"/* will raise if somebody had already consumed everything ractor have produced. */
"\n"/*  */
"\n"/* If the outgoing port was closed with #close_outgoing, the method will raise Ractor::ClosedError. */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      sleep(500) */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*    end */
"\n"/*    r.close_outgoing */
"\n"/*    r.take */
"\n"/*    # Ractor::ClosedError (The outgoing-port is already closed) */
"\n"/*    # The error would be raised immediately, not when ractor will try to receive */
"\n"/*  */
"\n"/* If an uncaught exception is raised in the Ractor, it is propagated on take as a */
"\n"/* Ractor::RemoteError. */
"\n"/*  */
"\n"/*   r = Ractor.new {raise "Something weird happened"} */
"\n"/*  */
"\n"/*   begin */
"\n"/*     r.take */
"\n"/*   rescue => e */
"\n"/*     p e              #  => #<Ractor::RemoteError: thrown by remote Ractor.> */
"\n"/*     p e.ractor == r  # => true */
"\n"/*     p e.cause        # => #<RuntimeError: Something weird happened> */
"\n"/*   end */
"\n"/*  */
"\n"/* Ractor::ClosedError is a descendant of StopIteration, so the closing of the ractor will break */
"\n"/* the loops without propagating the error: */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       3.times {|i| Ractor.yield "message #{i}"} */
"\n"/*       "finishing" */
"\n"/*     end */
"\n"/*  */
"\n"/*     loop {puts "Received: " + r.take} */
"\n"/*     puts "Continue successfully" */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*     Received: message 0 */
"\n"/*     Received: message 1 */
"\n"/*     Received: message 2 */
"\n"/*     Received: finishing */
"\n"/*     Continue successfully */
"  def take\n"
"    __builtin_cexpr! %q{\n"
"      ractor_take(ec, RACTOR_PTR(self))\n"
"    }\n"
"  end\n"
"\n"
"  def inspect\n"
"    loc  = __builtin_cexpr! %q{ RACTOR_PTR(self)->loc }\n"
"    name = __builtin_cexpr! %q{ RACTOR_PTR(self)->name }\n"
"    id   = __builtin_cexpr! %q{ UINT2NUM(rb_ractor_id(RACTOR_PTR(self))) }\n"
"    status = __builtin_cexpr! %q{\n"
,
#line 704 "ractor.rb"
"      rb_str_new2(ractor_status_str(RACTOR_PTR(self)->status_))\n"
"    }\n"
"    \"#<Ractor:##{id}#{name ? ' '+name : ''}#{loc ? \" \" + loc : ''} #{status}>\"\n"
"  end\n"
"\n"
"  alias to_s inspect\n"
"\n"
"\n"/* The name set in Ractor.new, or +nil+. */
"  def name\n"
"    __builtin_cexpr! %q{RACTOR_PTR(self)->name}\n"
"  end\n"
"\n"
"  class RemoteError\n"
"    attr_reader :ractor\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     ractor.close_incoming -> true | false */
"\n"/*  */
"\n"/* Closes the incoming port and returns its previous state. */
"\n"/* All further attempts to Ractor.receive in the ractor, and #send to the ractor */
"\n"/* will fail with Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {sleep(500)} */
"\n"/*   r.close_incoming  #=> false */
"\n"/*   r.close_incoming  #=> true */
"\n"/*   r.send('test') */
"\n"/*   # Ractor::ClosedError (The incoming-port is already closed) */
"  def close_incoming\n"
"    __builtin_cexpr! %q{\n"
"      ractor_close_incoming(ec, RACTOR_PTR(self));\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    ractor.close_outgoing -> true | false */
"\n"/*  */
"\n"/* Closes the outgoing port and returns its previous state. */
"\n"/* All further attempts to Ractor.yield in the ractor, and #take from the ractor */
"\n"/* will fail with Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {sleep(500)} */
"\n"/*   r.close_outgoing  #=> false */
"\n"/*   r.close_outgoing  #=> true */
"\n"/*   r.take */
"\n"/*   # Ractor::ClosedError (The outgoing-port is already closed) */
"  def close_outgoing\n"
"    __builtin_cexpr! %q{\n"
,
#line 754 "ractor.rb"
"      ractor_close_outgoing(ec, RACTOR_PTR(self));\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.shareable?(obj) -> true | false */
"\n"/*  */
"\n"/* Checks if the object is shareable by ractors. */
"\n"/*  */
"\n"/*     Ractor.shareable?(1)            #=> true -- numbers and other immutable basic values are frozen */
"\n"/*     Ractor.shareable?('foo')        #=> false, unless the string is frozen due to # freeze_string_literals: true */
"\n"/*     Ractor.shareable?('foo'.freeze) #=> true */
"\n"/*  */
"\n"/* See also the "Shareable and unshareable objects" section in the Ractor class docs. */
"  def self.shareable? obj\n"
"    __builtin_cexpr! %q{\n"
"      RBOOL(rb_ractor_shareable_p(obj));\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.make_shareable(obj, copy: false) -> shareable_obj */
"\n"/*  */
"\n"/* Make +obj+ shareable between ractors. */
"\n"/*  */
"\n"/* +obj+ and all the objects it refers to will be frozen, unless they are */
"\n"/* already shareable. */
"\n"/*  */
"\n"/* If +copy+ keyword is +true+, the method will copy objects before freezing them */
"\n"/* This is safer option but it can take be slower. */
"\n"/*  */
"\n"/* Note that the specification and implementation of this method are not */
"\n"/* mature and may be changed in the future. */
"\n"/*  */
"\n"/*   obj = ['test'] */
"\n"/*   Ractor.shareable?(obj)     #=> false */
"\n"/*   Ractor.make_shareable(obj) #=> ["test"] */
"\n"/*   Ractor.shareable?(obj)     #=> true */
"\n"/*   obj.frozen?                #=> true */
"\n"/*   obj[0].frozen?             #=> true */
"\n"/*  */
"\n"/*   # Copy vs non-copy versions: */
"\n"/*   obj1 = ['test'] */
"\n"/*   obj1s = Ractor.make_shareable(obj1) */
"\n"/*   obj1.frozen?                        #=> true */
"\n"/*   obj1s.object_id == obj1.object_id   #=> true */
"\n"/*   obj2 = ['test'] */
"\n"/*   obj2s = Ractor.make_shareable(obj2, copy: true) */
"\n"/*   obj2.frozen?                        #=> false */
"\n"/*   obj2s.frozen?                       #=> true */
"\n"/*   obj2s.object_id == obj2.object_id   #=> false */
"\n"/*   obj2s[0].object_id == obj2[0].object_id #=> false */
"\n"/*  */
"\n"/* See also the "Shareable and unshareable objects" section in the Ractor class docs. */
"  def self.make_shareable obj, copy: false\n"
"    if copy\n"
"      __builtin_cexpr! %q{\n"
"        rb_ractor_make_shareable_copy(obj);\n"
"      }\n"
"    else\n"
"      __builtin_cexpr! %q{\n"
"        rb_ractor_make_shareable(obj);\n"
"      }\n"
"    end\n"
"  end\n"
"\n"
"\n"/* get a value from ractor-local storage */
"  def [](sym)\n"
"    Primitive.ractor_local_value(sym)\n"
"  end\n"
"\n"
"\n"/* set a value in ractor-local storage */
,
#line 828 "ractor.rb"
"  def []=(sym, val)\n"
"    Primitive.ractor_local_value_set(sym, val)\n"
"  end\n"
"\n"
"\n"/* returns main ractor */
"  def self.main\n"
"    __builtin_cexpr! %q{\n"
"      rb_ractor_self(GET_VM()->ractor.main_ractor);\n"
"    }\n"
"  end\n"
"end\n"
#line 6081 "miniprelude.c"
};

static const char prelude_name15[] = "<internal:timev>";
static const struct {
    char L0[450]; /* 1..364 */
    char L364[450]; /* 365..381 */
} prelude_code15 = {
#line 1 "timev.rb"
""/* A \Time object represents a date and time: */
""/*  */
""/*   Time.new(2000, 1, 1, 0, 0, 0) # => 2000-01-01 00:00:00 -0600 */
""/*  */
""/* Although its value can be expressed as a single numeric */
""/* (see {Epoch Seconds}[rdoc-ref:Time@Epoch+Seconds] below), */
""/* it can be convenient to deal with the value by parts: */
""/*  */
""/*   t = Time.new(-2000, 1, 1, 0, 0, 0.0) */
""/*   # => -2000-01-01 00:00:00 -0600 */
""/*   t.year # => -2000 */
""/*   t.month # => 1 */
""/*   t.mday # => 1 */
""/*   t.hour # => 0 */
""/*   t.min # => 0 */
""/*   t.sec # => 0 */
""/*   t.subsec # => 0 */
""/*  */
""/*   t = Time.new(2000, 12, 31, 23, 59, 59.5) */
""/*   # => 2000-12-31 23:59:59.5 -0600 */
""/*   t.year # => 2000 */
""/*   t.month # => 12 */
""/*   t.mday # => 31 */
""/*   t.hour # => 23 */
""/*   t.min # => 59 */
""/*   t.sec # => 59 */
""/*   t.subsec # => (1/2) */
""/*  */
""/* == Epoch Seconds */
""/*  */
""/* <i>Epoch seconds</i> is the exact number of seconds */
""/* (including fractional subseconds) since the Unix Epoch, January 1, 1970. */
""/*  */
""/* You can retrieve that value exactly using method Time.to_r: */
""/*  */
""/*   Time.at(0).to_r        # => (0/1) */
""/*   Time.at(0.999999).to_r # => (9007190247541737/9007199254740992) */
""/*  */
""/* Other retrieval methods such as Time#to_i and Time#to_f */
""/* may return a value that rounds or truncates subseconds. */
""/*  */
""/* == \Time Resolution */
""/*  */
""/* A \Time object derived from the system clock */
""/* (for example, by method Time.now) */
""/* has the resolution supported by the system. */
""/*  */
""/* == Examples */
""/*  */
""/* All of these examples were done using the EST timezone which is GMT-5. */
""/*  */
""/* === Creating a New \Time Instance */
""/*  */
""/* You can create a new instance of Time with Time.new. This will use the */
""/* current system time. Time.now is an alias for this. You can also */
""/* pass parts of the time to Time.new such as year, month, minute, etc. When */
""/* you want to construct a time this way you must pass at least a year. If you */
""/* pass the year with nothing else time will default to January 1 of that year */
""/* at 00:00:00 with the current system timezone. Here are some examples: */
""/*  */
""/*   Time.new(2002)         #=> 2002-01-01 00:00:00 -0500 */
""/*   Time.new(2002, 10)     #=> 2002-10-01 00:00:00 -0500 */
""/*   Time.new(2002, 10, 31) #=> 2002-10-31 00:00:00 -0500 */
""/*  */
""/* You can pass a UTC offset: */
""/*  */
""/*   Time.new(2002, 10, 31, 2, 2, 2, "+02:00") #=> 2002-10-31 02:02:02 +0200 */
""/*  */
""/* Or a timezone object: */
""/*  */
""/*   zone = timezone("Europe/Athens")      # Eastern European Time, UTC+2 */
""/*   Time.new(2002, 10, 31, 2, 2, 2, zone) #=> 2002-10-31 02:02:02 +0200 */
""/*  */
""/* You can also use Time.local and Time.utc to infer */
""/* local and UTC timezones instead of using the current system */
""/* setting. */
""/*  */
""/* You can also create a new time using Time.at which takes the number of */
""/* seconds (with subsecond) since the {Unix */
""/* Epoch}[https://en.wikipedia.org/wiki/Unix_time]. */
""/*  */
""/*   Time.at(628232400) #=> 1989-11-28 00:00:00 -0500 */
""/*  */
""/* === Working with an Instance of \Time */
""/*  */
""/* Once you have an instance of Time there is a multitude of things you can */
""/* do with it. Below are some examples. For all of the following examples, we */
""/* will work on the assumption that you have done the following: */
""/*  */
""/*   t = Time.new(1993, 02, 24, 12, 0, 0, "+09:00") */
""/*  */
""/* Was that a monday? */
""/*  */
""/*   t.monday? #=> false */
""/*  */
""/* What year was that again? */
""/*  */
""/*   t.year #=> 1993 */
""/*  */
""/* Was it daylight savings at the time? */
""/*  */
""/*   t.dst? #=> false */
""/*  */
""/* What's the day a year later? */
""/*  */
""/*   t + (60*60*24*365) #=> 1994-02-24 12:00:00 +0900 */
""/*  */
""/* How many seconds was that since the Unix Epoch? */
""/*  */
""/*   t.to_i #=> 730522800 */
""/*  */
""/* You can also do standard functions like compare two times. */
""/*  */
""/*   t1 = Time.new(2010) */
""/*   t2 = Time.new(2011) */
""/*  */
""/*   t1 == t2 #=> false */
""/*   t1 == t1 #=> true */
""/*   t1 <  t2 #=> true */
""/*   t1 >  t2 #=> false */
""/*  */
""/*   Time.new(2010,10,31).between?(t1, t2) #=> true */
""/*  */
""/* == What's Here */
""/*  */
""/* First, what's elsewhere. \Class \Time: */
""/*  */
""/* - Inherits from {class Object}[rdoc-ref:Object@What-27s+Here]. */
""/* - Includes {module Comparable}[rdoc-ref:Comparable@What-27s+Here]. */
""/*  */
""/* Here, class \Time provides methods that are useful for: */
""/*  */
""/* - {Creating \Time objects}[rdoc-ref:Time@Methods+for+Creating]. */
""/* - {Fetching \Time values}[rdoc-ref:Time@Methods+for+Fetching]. */
""/* - {Querying a \Time object}[rdoc-ref:Time@Methods+for+Querying]. */
""/* - {Comparing \Time objects}[rdoc-ref:Time@Methods+for+Comparing]. */
""/* - {Converting a \Time object}[rdoc-ref:Time@Methods+for+Converting]. */
""/* - {Rounding a \Time}[rdoc-ref:Time@Methods+for+Rounding]. */
""/*  */
""/* === Methods for Creating */
""/*  */
""/* - ::new: Returns a new time from specified arguments (year, month, etc.), */
""/*   including an optional timezone value. */
""/* - ::local (aliased as ::mktime): Same as ::new, except the */
""/*   timezone is the local timezone. */
""/* - ::utc (aliased as ::gm): Same as ::new, except the timezone is UTC. */
""/* - ::at: Returns a new time based on seconds since epoch. */
""/* - ::now: Returns a new time based on the current system time. */
""/* - #+ (plus): Returns a new time increased by the given number of seconds. */
""/* - #- (minus): Returns a new time decreased by the given number of seconds. */
""/*  */
""/* === Methods for Fetching */
""/*  */
""/* - #year: Returns the year of the time. */
""/* - #month (aliased as #mon): Returns the month of the time. */
""/* - #mday (aliased as #day): Returns the day of the month. */
""/* - #hour: Returns the hours value for the time. */
""/* - #min: Returns the minutes value for the time. */
""/* - #sec: Returns the seconds value for the time. */
""/* - #usec (aliased as #tv_usec): Returns the number of microseconds */
""/*   in the subseconds value of the time. */
""/* - #nsec (aliased as #tv_nsec: Returns the number of nanoseconds */
""/*   in the subsecond part of the time. */
""/* - #subsec: Returns the subseconds value for the time. */
""/* - #wday: Returns the integer weekday value of the time (0 == Sunday). */
""/* - #yday: Returns the integer yearday value of the time (1 == January 1). */
""/* - #hash: Returns the integer hash value for the time. */
""/* - #utc_offset (aliased as #gmt_offset and #gmtoff): Returns the offset */
""/*   in seconds between time and UTC. */
""/* - #to_f: Returns the float number of seconds since epoch for the time. */
""/* - #to_i (aliased as #tv_sec): Returns the integer number of seconds since epoch */
""/*   for the time. */
""/* - #to_r: Returns the Rational number of seconds since epoch for the time. */
""/* - #zone: Returns a string representation of the timezone of the time. */
""/*  */
""/* === Methods for Querying */
""/*  */
""/* - #utc? (aliased as #gmt?): Returns whether the time is UTC. */
""/* - #dst? (aliased as #isdst): Returns whether the time is DST (daylight saving time). */
""/* - #sunday?: Returns whether the time is a Sunday. */
""/* - #monday?: Returns whether the time is a Monday. */
""/* - #tuesday?: Returns whether the time is a Tuesday. */
""/* - #wednesday?: Returns whether the time is a Wednesday. */
""/* - #thursday?: Returns whether the time is a Thursday. */
""/* - #friday?: Returns whether time is a Friday. */
""/* - #saturday?: Returns whether the time is a Saturday. */
""/*  */
""/* === Methods for Comparing */
""/*  */
""/* - #<=>: Compares +self+ to another time. */
""/* - #eql?: Returns whether the time is equal to another time. */
""/*  */
""/* === Methods for Converting */
""/*  */
""/* - #asctime (aliased as #ctime): Returns the time as a string. */
""/* - #inspect: Returns the time in detail as a string. */
""/* - #strftime: Returns the time as a string, according to a given format. */
""/* - #to_a: Returns a 10-element array of values from the time. */
""/* - #to_s: Returns a string representation of the time. */
""/* - #getutc (aliased as #getgm): Returns a new time converted to UTC. */
""/* - #getlocal: Returns a new time converted to local time. */
""/* - #utc (aliased as #gmtime): Converts time to UTC in place. */
""/* - #localtime: Converts time to local time in place. */
""/*  */
""/* === Methods for Rounding */
""/*  */
""/* - #round:Returns a new time with subseconds rounded. */
""/* - #ceil: Returns a new time with subseconds raised to a ceiling. */
""/* - #floor: Returns a new time with subseconds lowered to a floor. */
""/*  */
""/* For the forms of argument +zone+, see */
""/* {Timezone Specifiers}[rdoc-ref:timezones.rdoc]. */
"class Time\n"
"\n"/* Creates a new \Time object from the current system time. */
"\n"/* This is the same as Time.new without arguments. */
"\n"/*  */
"\n"/*    Time.now               # => 2009-06-24 12:39:54 +0900 */
"\n"/*    Time.now(in: '+04:00') # => 2009-06-24 07:39:54 +0400 */
"\n"/*  */
"\n"/* For forms of argument +zone+, see */
"\n"/* {Timezone Specifiers}[rdoc-ref:timezones.rdoc]. */
"  def self.now(in: nil)\n"
"    Primitive.time_s_now(Primitive.arg!(:in))\n"
"  end\n"
"\n"
"\n"/* Returns a new \Time object based on the given arguments. */
"\n"/*  */
"\n"/* Required argument +time+ may be either of: */
"\n"/*  */
"\n"/* - A \Time object, whose value is the basis for the returned time; */
"\n"/*   also influenced by optional keyword argument +in:+ (see below). */
"\n"/* - A numeric number of */
"\n"/*   {Epoch seconds}[rdoc-ref:Time@Epoch+Seconds] */
"\n"/*   for the returned time. */
"\n"/*  */
"\n"/* Examples: */
"\n"/*  */
"\n"/*   t = Time.new(2000, 12, 31, 23, 59, 59) # => 2000-12-31 23:59:59 -0600 */
"\n"/*   secs = t.to_i                          # => 978328799 */
"\n"/*   Time.at(secs)                          # => 2000-12-31 23:59:59 -0600 */
"\n"/*   Time.at(secs + 0.5)                    # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*   Time.at(1000000000)                    # => 2001-09-08 20:46:40 -0500 */
"\n"/*   Time.at(0)                             # => 1969-12-31 18:00:00 -0600 */
"\n"/*   Time.at(-1000000000)                   # => 1938-04-24 17:13:20 -0500 */
"\n"/*  */
"\n"/* Optional numeric argument +subsec+ and optional symbol argument +units+ */
"\n"/* work together to specify subseconds for the returned time; */
"\n"/* argument +units+ specifies the units for +subsec+: */
"\n"/*  */
"\n"/* - +:millisecond+: +subsec+ in milliseconds: */
"\n"/*  */
"\n"/*     Time.at(secs, 0, :millisecond)     # => 2000-12-31 23:59:59 -0600 */
"\n"/*     Time.at(secs, 500, :millisecond)   # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*     Time.at(secs, 1000, :millisecond)  # => 2001-01-01 00:00:00 -0600 */
"\n"/*     Time.at(secs, -1000, :millisecond) # => 2000-12-31 23:59:58 -0600 */
"\n"/*  */
"\n"/* - +:microsecond+ or +:usec+: +subsec+ in microseconds: */
"\n"/*  */
"\n"/*     Time.at(secs, 0, :microsecond)        # => 2000-12-31 23:59:59 -0600 */
"\n"/*     Time.at(secs, 500000, :microsecond)   # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*     Time.at(secs, 1000000, :microsecond)  # => 2001-01-01 00:00:00 -0600 */
"\n"/*     Time.at(secs, -1000000, :microsecond) # => 2000-12-31 23:59:58 -0600 */
"\n"/*  */
"\n"/* - +:nanosecond+ or +:nsec+: +subsec+ in nanoseconds: */
"\n"/*  */
"\n"/*     Time.at(secs, 0, :nanosecond)           # => 2000-12-31 23:59:59 -0600 */
"\n"/*     Time.at(secs, 500000000, :nanosecond)   # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*     Time.at(secs, 1000000000, :nanosecond)  # => 2001-01-01 00:00:00 -0600 */
"\n"/*     Time.at(secs, -1000000000, :nanosecond) # => 2000-12-31 23:59:58 -0600 */
"\n"/*  */
"\n"/*  */
"\n"/* Optional keyword argument <tt>+in: zone</tt> specifies the timezone */
"\n"/* for the returned time: */
"\n"/*  */
"\n"/*   Time.at(secs, in: '+12:00') # => 2001-01-01 17:59:59 +1200 */
"\n"/*   Time.at(secs, in: '-12:00') # => 2000-12-31 17:59:59 -1200 */
"\n"/*  */
"\n"/* For the forms of argument +zone+, see */
"\n"/* {Timezone Specifiers}[rdoc-ref:timezones.rdoc]. */
"\n"/*  */
"  def self.at(time, subsec = false, unit = :microsecond, in: nil)\n"
"    if Primitive.mandatory_only?\n"
"      Primitive.time_s_at1(time)\n"
"    else\n"
"      Primitive.time_s_at(time, subsec, unit, Primitive.arg!(:in))\n"
"    end\n"
"  end\n"
"\n"
"\n"/* Returns a new \Time object based on the given arguments, */
"\n"/* by default in the local timezone. */
"\n"/*  */
"\n"/* With no positional arguments, returns the value of Time.now: */
"\n"/*  */
"\n"/*   Time.new # => 2021-04-24 17:27:46.0512465 -0500 */
"\n"/*  */
"\n"/* With one to six arguments, returns a new \Time object */
"\n"/* based on the given arguments, in the local timezone. */
"\n"/*  */
"\n"/*   Time.new(2000, 1, 2, 3, 4, 5) # => 2000-01-02 03:04:05 -0600 */
"\n"/*  */
"\n"/* For the positional arguments (other than +zone+): */
"\n"/*  */
"\n"/* - +year+: Year, with no range limits: */
"\n"/*  */
"\n"/*     Time.new(999999999)  # => 999999999-01-01 00:00:00 -0600 */
"\n"/*     Time.new(-999999999) # => -999999999-01-01 00:00:00 -0600 */
"\n"/*  */
"\n"/* - +month+: Month in range (1..12), or case-insensitive */
"\n"/*   3-letter month name: */
"\n"/*  */
"\n"/*     Time.new(2000, 1)     # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 12)    # => 2000-12-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 'jan') # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 'JAN') # => 2000-01-01 00:00:00 -0600 */
"\n"/*  */
"\n"/* - +mday+: Month day in range(1..31): */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1)  # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 31) # => 2000-01-31 00:00:00 -0600 */
"\n"/*  */
"\n"/* - +hour+: Hour in range (0..23), or 24 if +min+, +sec+, and +usec+ */
"\n"/*   are zero: */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1, 0)  # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 1, 23) # => 2000-01-01 23:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 1, 24) # => 2000-01-02 00:00:00 -0600 */
"\n"/*  */
"\n"/* - +min+: Minute in range (0..59): */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1, 0, 0)  # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 1, 0, 59) # => 2000-01-01 00:59:00 -0600 */
"\n"/*  */
"\n"/* - +sec+: Second in range (0..59), or 60 if +usec+ is zero: */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1, 0, 0, 0)  # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 1, 0, 0, 59) # => 2000-01-01 00:00:59 -0600 */
"\n"/*     Time.new(2000, 1, 1, 0, 0, 60) # => 2000-01-01 00:01:00 -0600 */
"\n"/*  */
"\n"/* These values may be: */
"\n"/*  */
"\n"/* - Integers, as above. */
"\n"/* - Numerics convertible to integers: */
"\n"/*  */
"\n"/*     Time.new(Float(0.0), Rational(1, 1), 1.0, 0.0, 0.0, 0.0) */
"\n"/*     # => 0000-01-01 00:00:00 -0600 */
"\n"/*  */
"\n"/* - \String integers: */
"\n"/*  */
"\n"/*     a = %w[0 1 1 0 0 0] */
"\n"/*     # => ["0", "1", "1", "0", "0", "0"] */
"\n"/*     Time.new(*a) # => 0000-01-01 00:00:00 -0600 */
"\n"/*  */
"\n"/* When positional argument +zone+ or keyword argument +in:+ is given, */
"\n"/* the new \Time object is in the specified timezone. */
"\n"/* For the forms of argument +zone+, see */
"\n"/* {Timezone Specifiers}[rdoc-ref:timezones.rdoc]: */
"\n"/*  */
"\n"/*   Time.new(2000, 1, 1, 0, 0, 0, '+12:00') */
"\n"/*   # => 2000-01-01 00:00:00 +1200 */
"\n"/*   Time.new(2000, 1, 1, 0, 0, 0, in: '-12:00') */
"\n"/*   # => 2000-01-01 00:00:00 -1200 */
"\n"/*   Time.new(in: '-12:00') */
"\n"/*   # => 2022-08-23 08:49:26.1941467 -1200 */
"\n"/*  */
,
#line 365 "timev.rb"
"  def initialize(year = (now = true), mon = nil, mday = nil, hour = nil, min = nil, sec = nil, zone = nil, in: nil)\n"
"    if zone\n"
"      if Primitive.arg!(:in)\n"
"        raise ArgumentError, \"timezone argument given as positional and keyword arguments\"\n"
"      end\n"
"    else\n"
"      zone = Primitive.arg!(:in)\n"
"    end\n"
"\n"
"    if now\n"
"      return Primitive.time_init_now(zone)\n"
"    end\n"
"\n"
"    Primitive.time_init_args(year, mon, mday, hour, min, sec, zone)\n"
"  end\n"
"end\n"
#line 6472 "miniprelude.c"
};

static const char prelude_name16[] = "<internal:thread_sync>";
static const struct {
    char L0[500]; /* 1..38 */
    char L38[446]; /* 39..69 */
} prelude_code16 = {
#line 1 "thread_sync.rb"
"class Thread\n"
"  class Queue\n"
"\n"/* call-seq: */
"\n"/*   pop(non_block=false, timeout: nil) */
"\n"/*  */
"\n"/* Retrieves data from the queue. */
"\n"/*  */
"\n"/* If the queue is empty, the calling thread is suspended until data is pushed */
"\n"/* onto the queue. If +non_block+ is true, the thread isn't suspended, and */
"\n"/* +ThreadError+ is raised. */
"\n"/*  */
"\n"/* If +timeout+ seconds have passed and no data is available +nil+ is */
"\n"/* returned. */
"    def pop(non_block = false, timeout: nil)\n"
"      if non_block && timeout\n"
"        raise ArgumentError, \"can't set a timeout if non_block is enabled\"\n"
"      end\n"
"      Primitive.rb_queue_pop(non_block, timeout)\n"
"    end\n"
"    alias_method :deq, :pop\n"
"    alias_method :shift, :pop\n"
"  end\n"
"\n"
"  class SizedQueue\n"
"\n"/* call-seq: */
"\n"/*   pop(non_block=false, timeout: nil) */
"\n"/*  */
"\n"/* Retrieves data from the queue. */
"\n"/*  */
"\n"/* If the queue is empty, the calling thread is suspended until data is */
"\n"/* pushed onto the queue. If +non_block+ is true, the thread isn't */
"\n"/* suspended, and +ThreadError+ is raised. */
"\n"/*  */
"\n"/* If +timeout+ seconds have passed and no data is available +nil+ is */
"\n"/* returned. */
"    def pop(non_block = false, timeout: nil)\n"
"      if non_block && timeout\n"
"        raise ArgumentError, \"can't set a timeout if non_block is enabled\"\n"
,
#line 39 "thread_sync.rb"
"      end\n"
"      Primitive.rb_szqueue_pop(non_block, timeout)\n"
"    end\n"
"    alias_method :deq, :pop\n"
"    alias_method :shift, :pop\n"
"\n"
"\n"/* call-seq: */
"\n"/*   push(object, non_block=false, timeout: nil) */
"\n"/*   enq(object, non_block=false, timeout: nil) */
"\n"/*   <<(object) */
"\n"/*  */
"\n"/* Pushes +object+ to the queue. */
"\n"/*  */
"\n"/* If there is no space left in the queue, waits until space becomes */
"\n"/* available, unless +non_block+ is true.  If +non_block+ is true, the */
"\n"/* thread isn't suspended, and +ThreadError+ is raised. */
"\n"/*  */
"\n"/* If +timeout+ seconds have passed and no space is available +nil+ is */
"\n"/* returned. */
"\n"/* Otherwise it returns +self+. */
"    def push(object, non_block = false, timeout: nil)\n"
"      if non_block && timeout\n"
"        raise ArgumentError, \"can't set a timeout if non_block is enabled\"\n"
"      end\n"
"      Primitive.rb_szqueue_push(object, non_block, timeout)\n"
"    end\n"
"    alias_method :enq, :push\n"
"    alias_method :<<, :push\n"
"  end\n"
"end\n"
#line 6551 "miniprelude.c"
};

static const char prelude_name17[] = "<internal:nilclass>";
static const struct {
    char L0[98]; /* 1..26 */
} prelude_code17 = {
#line 1 "nilclass.rb"
"class NilClass\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     nil.to_i -> 0 */
"\n"/*  */
"\n"/*  Always returns zero. */
"\n"/*  */
"\n"/*     nil.to_i   #=> 0 */
"\n"/*  */
"  def to_i\n"
"    return 0\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     nil.to_f    -> 0.0 */
"\n"/*  */
"\n"/*  Always returns zero. */
"\n"/*  */
"\n"/*     nil.to_f   #=> 0.0 */
"\n"/*  */
"  def to_f\n"
"    return 0.0\n"
"  end\n"
"end\n"
#line 6584 "miniprelude.c"
};

static const char prelude_name18[] = "<internal:prelude>";
static const struct {
    char L0[310]; /* 1..32 */
} prelude_code18 = {
#line 1 "prelude.rb"
"class Binding\n"
"\n"/* :nodoc: */
"  def irb\n"
"    require 'irb'\n"
"    irb\n"
"  end\n"
"\n"
"\n"/* suppress redefinition warning */
"  alias irb irb\n"/* :nodoc: */
"end\n"
"\n"
"module Kernel\n"
"  def pp(*objs)\n"
"    require 'pp'\n"
"    pp(*objs)\n"
"  end\n"
"\n"
"\n"/* suppress redefinition warning */
"  alias pp pp\n"/* :nodoc: */
"\n"
"  private :pp\n"
"end\n"
"\n"
"autoload :Set, 'set'\n"
"\n"
"module Enumerable\n"
"\n"/* Makes a set from the enumerable object with given arguments. */
"  def to_set(klass = Set, *args, &block)\n"
"    klass.new(self, *args, &block)\n"
"  end\n"
"end\n"
#line 6623 "miniprelude.c"
};

static const char prelude_name19[] = "<internal:gem_prelude>";
static const struct {
    char L0[490]; /* 1..24 */
    char L24[32]; /* 25..27 */
} prelude_code19 = {
#line 1 "gem_prelude.rb"
"begin\n"
"  require 'rubygems'\n"
"rescue LoadError => e\n"
"  raise unless e.path == 'rubygems'\n"
"\n"
"  warn \"`RubyGems' were not loaded.\"\n"
"end if defined?(Gem)\n"
"\n"
"begin\n"
"  require 'error_highlight'\n"
"rescue LoadError\n"
"  warn \"`error_highlight' was not loaded.\"\n"
"end if defined?(ErrorHighlight)\n"
"\n"
"begin\n"
"  require 'did_you_mean'\n"
"rescue LoadError\n"
"  warn \"`did_you_mean' was not loaded.\"\n"
"end if defined?(DidYouMean)\n"
"\n"
"begin\n"
"  require 'syntax_suggest/core_ext'\n"
"rescue LoadError\n"
"  warn \"`syntax_suggest' was not loaded.\"\n"
,
#line 25 "gem_prelude.rb"
"end if defined?(SyntaxSuggest)\n"
"\n"
#line 6660 "miniprelude.c"
};

static const char prelude_name20[] = "<internal:yjit>";
static const struct {
    char L0[508]; /* 1..39 */
    char L39[484]; /* 40..66 */
    char L66[477]; /* 67..83 */
    char L83[493]; /* 84..105 */
    char L105[497]; /* 106..143 */
    char L143[490]; /* 144..177 */
    char L177[485]; /* 178..187 */
    char L187[461]; /* 188..192 */
    char L192[459]; /* 193..209 */
    char L209[500]; /* 210..216 */
    char L216[493]; /* 217..223 */
    char L223[461]; /* 224..232 */
    char L232[488]; /* 233..247 */
    char L247[449]; /* 248..256 */
    char L256[441]; /* 257..273 */
    char L273[483]; /* 274..285 */
    char L285[285]; /* 286..295 */
} prelude_code20 = {
#line 1 "yjit.rb"
""/* frozen_string_literal: true */
""
""/* This module allows for introspection of YJIT, CRuby's experimental in-process */
""/* just-in-time compiler. This module exists only to help develop YJIT, as such, */
""/* everything in the module is highly implementation specific and comes with no */
""/* API stability guarantee whatsoever. */
""/*  */
""/* This module may not exist if YJIT does not support the particular platform */
""/* for which CRuby is built. There is also no API stability guarantee as to in */
""/* what situations this module is defined. */
"module RubyVM::YJIT\n"
"\n"/* Check if YJIT is enabled */
"  def self.enabled?\n"
"    Primitive.cexpr! 'RBOOL(rb_yjit_enabled_p())'\n"
"  end\n"
"\n"
"  def self.stats_enabled?\n"
"    Primitive.rb_yjit_stats_enabled_p\n"
"  end\n"
"\n"
"\n"/* Check if rb_yjit_trace_exit_locations_enabled_p is enabled. */
"  def self.trace_exit_locations_enabled?\n"
"    Primitive.rb_yjit_trace_exit_locations_enabled_p\n"
"  end\n"
"\n"
"\n"/* Discard statistics collected for --yjit-stats. */
"  def self.reset_stats!\n"
"    Primitive.rb_yjit_reset_stats_bang\n"
"  end\n"
"\n"
"\n"/* If --yjit-trace-exits is enabled parse the hashes from */
"\n"/* Primitive.rb_yjit_get_exit_locations into a format readable */
"\n"/* by Stackprof. This will allow us to find the exact location of a */
"\n"/* side exit in YJIT based on the instruction that is exiting. */
"  def self.exit_locations\n"
"    return unless trace_exit_locations_enabled?\n"
"\n"
"    results = Primitive.rb_yjit_get_exit_locations\n"
"    raw_samples = results[:raw].dup\n"
,
#line 40 "yjit.rb"
"    line_samples = results[:lines].dup\n"
"    frames = results[:frames].dup\n"
"    samples_count = 0\n"
"\n"
"\n"/* Loop through the instructions and set the frame hash with the data. */
"\n"/* We use nonexistent.def for the file name, otherwise insns.def will be displayed */
"\n"/* and that information isn't useful in this context. */
"    RubyVM::INSTRUCTION_NAMES.each_with_index do |name, frame_id|\n"
"      frame_hash = { samples: 0, total_samples: 0, edges: {}, name: name, file: \"nonexistent.def\", line: nil, lines: {} }\n"
"      results[:frames][frame_id] = frame_hash\n"
"      frames[frame_id] = frame_hash\n"
"    end\n"
"\n"
"\n"/* Loop through the raw_samples and build the hashes for StackProf. */
"\n"/* The loop is based off an example in the StackProf documentation and therefore */
"\n"/* this functionality can only work with that library. */
"\n"/*  */
"\n"/* Raw Samples: */
"\n"/* [ length, frame1, frame2, frameN, ..., instruction, count */
"\n"/*  */
"\n"/* Line Samples */
"\n"/* [ length, line_1, line_2, line_n, ..., dummy value, count */
"    i = 0\n"
"    while i < raw_samples.length\n"
"      stack_length = raw_samples[i] + 1\n"
"      i += 1\n"/* consume the stack length */
"\n"
,
#line 67 "yjit.rb"
"      prev_frame_id = nil\n"
"      stack_length.times do |idx|\n"
"        idx += i\n"
"        frame_id = raw_samples[idx]\n"
"\n"
"        if prev_frame_id\n"
"          prev_frame = frames[prev_frame_id]\n"
"          prev_frame[:edges][frame_id] ||= 0\n"
"          prev_frame[:edges][frame_id] += 1\n"
"        end\n"
"\n"
"        frame_info = frames[frame_id]\n"
"        frame_info[:total_samples] += 1\n"
"\n"
"        frame_info[:lines][line_samples[idx]] ||= [0, 0]\n"
"        frame_info[:lines][line_samples[idx]][0] += 1\n"
"\n"
,
#line 84 "yjit.rb"
"        prev_frame_id = frame_id\n"
"      end\n"
"\n"
"      i += stack_length\n"/* consume the stack */
"\n"
"      top_frame_id = prev_frame_id\n"
"      top_frame_line = 1\n"
"\n"
"      sample_count = raw_samples[i]\n"
"\n"
"      frames[top_frame_id][:samples] += sample_count\n"
"      frames[top_frame_id][:lines] ||= {}\n"
"      frames[top_frame_id][:lines][top_frame_line] ||= [0, 0]\n"
"      frames[top_frame_id][:lines][top_frame_line][1] += sample_count\n"
"\n"
"      samples_count += sample_count\n"
"      i += 1\n"
"    end\n"
"\n"
"    results[:samples] = samples_count\n"
"\n"/* Set missed_samples and gc_samples to 0 as their values */
"\n"/* don't matter to us in this context. */
,
#line 106 "yjit.rb"
"    results[:missed_samples] = 0\n"
"    results[:gc_samples] = 0\n"
"    results\n"
"  end\n"
"\n"
"\n"/* Marshal dumps exit locations to the given filename. */
"\n"/*  */
"\n"/* Usage: */
"\n"/*  */
"\n"/* In a script call: */
"\n"/*  */
"\n"/*   RubyVM::YJIT.dump_exit_locations("my_file.dump") */
"\n"/*  */
"\n"/* Then run the file with the following options: */
"\n"/*  */
"\n"/*   ruby --yjit --yjit-stats --yjit-trace-exits test.rb */
"\n"/*  */
"\n"/* Once the code is done running, use Stackprof to read the dump file. */
"\n"/* See Stackprof documentation for options. */
"  def self.dump_exit_locations(filename)\n"
"    unless trace_exit_locations_enabled?\n"
"      raise ArgumentError, \"--yjit-trace-exits must be enabled to use dump_exit_locations.\"\n"
"    end\n"
"\n"
"    File.binwrite(filename, Marshal.dump(RubyVM::YJIT.exit_locations))\n"
"  end\n"
"\n"
"\n"/* Return a hash for statistics generated for the --yjit-stats command line option. */
"\n"/* Return nil when option is not passed or unavailable. */
"  def self.runtime_stats\n"
"    Primitive.rb_yjit_get_stats\n"
"  end\n"
"\n"
"\n"/* Produce disassembly for an iseq */
"  def self.disasm(iseq)\n"
"\n"/* If a method or proc is passed in, get its iseq */
"    iseq = RubyVM::InstructionSequence.of(iseq)\n"
"\n"
,
#line 144 "yjit.rb"
"    if self.enabled?\n"
"\n"/* Produce the disassembly string */
"\n"/* Include the YARV iseq disasm in the string for additional context */
"      iseq.disasm + \"\\n\" + Primitive.rb_yjit_disasm_iseq(iseq)\n"
"    else\n"
"      iseq.disasm\n"
"    end\n"
"  end\n"
"\n"
"\n"/* Produce a list of instructions compiled by YJIT for an iseq */
"  def self.insns_compiled(iseq)\n"
"\n"/* If a method or proc is passed in, get its iseq */
"    iseq = RubyVM::InstructionSequence.of(iseq)\n"
"\n"
"    if self.enabled?\n"
"      Primitive.rb_yjit_insns_compiled(iseq)\n"
"    else\n"
"      Qnil\n"
"    end\n"
"  end\n"
"\n"
"  def self.simulate_oom!\n"
"    Primitive.rb_yjit_simulate_oom_bang\n"
"  end\n"
"\n"
"\n"/* Avoid calling a method here to not interfere with compilation tests */
"  if Primitive.rb_yjit_stats_enabled_p\n"
"    at_exit { _print_stats }\n"
"  end\n"
"\n"
"  class << self\n"
"    private\n"
"\n"
"\n"/* Format and print out counters */
,
#line 178 "yjit.rb"
"    def _print_stats\n"
"      stats = runtime_stats\n"
"      return unless stats\n"
"\n"
"      $stderr.puts(\"***YJIT: Printing YJIT statistics on exit***\")\n"
"\n"
"      print_counters(stats, prefix: 'send_', prompt: 'method call exit reasons: ')\n"
"      print_counters(stats, prefix: 'invokesuper_', prompt: 'invokesuper exit reasons: ')\n"
"      print_counters(stats, prefix: 'leave_', prompt: 'leave exit reasons: ')\n"
"      print_counters(stats, prefix: 'gbpp_', prompt: 'getblockparamproxy exit reasons: ')\n"
,
#line 188 "yjit.rb"
"      print_counters(stats, prefix: 'getivar_', prompt: 'getinstancevariable exit reasons:')\n"
"      print_counters(stats, prefix: 'setivar_', prompt: 'setinstancevariable exit reasons:')\n"
"      print_counters(stats, prefix: 'oaref_', prompt: 'opt_aref exit reasons: ')\n"
"      print_counters(stats, prefix: 'expandarray_', prompt: 'expandarray exit reasons: ')\n"
"      print_counters(stats, prefix: 'opt_getinlinecache_', prompt: 'opt_getinlinecache exit reasons: ')\n"
,
#line 193 "yjit.rb"
"      print_counters(stats, prefix: 'invalidate_', prompt: 'invalidation reasons: ')\n"
"\n"
"      side_exits = total_exit_count(stats)\n"
"      total_exits = side_exits + stats[:leave_interp_return]\n"
"\n"
"\n"/* Number of instructions that finish executing in YJIT. */
"\n"/* See :count-placement: about the subtraction. */
"      retired_in_yjit = stats[:exec_instruction] - side_exits\n"
"\n"
"\n"/* Average length of instruction sequences executed by YJIT */
"      avg_len_in_yjit = retired_in_yjit.to_f / total_exits\n"
"\n"
"\n"/* Proportion of instructions that retire in YJIT */
"      total_insns_count = retired_in_yjit + stats[:vm_insns_count]\n"
"      yjit_ratio_pct = 100.0 * retired_in_yjit.to_f / total_insns_count\n"
"\n"
"\n"/* Number of failed compiler invocations */
,
#line 210 "yjit.rb"
"      compilation_failure = stats[:compilation_failure]\n"
"\n"
"      $stderr.puts \"bindings_allocations:  \" + (\"%10d\" % stats[:binding_allocations])\n"
"      $stderr.puts \"bindings_set:          \" + (\"%10d\" % stats[:binding_set])\n"
"      $stderr.puts \"compilation_failure:   \" + (\"%10d\" % compilation_failure) if compilation_failure != 0\n"
"      $stderr.puts \"compiled_iseq_count:   \" + (\"%10d\" % stats[:compiled_iseq_count])\n"
"      $stderr.puts \"compiled_block_count:  \" + (\"%10d\" % stats[:compiled_block_count])\n"
,
#line 217 "yjit.rb"
"      $stderr.puts \"invalidation_count:    \" + (\"%10d\" % stats[:invalidation_count])\n"
"      $stderr.puts \"constant_state_bumps:  \" + (\"%10d\" % stats[:constant_state_bumps])\n"
"      $stderr.puts \"inline_code_size:      \" + (\"%10d\" % stats[:inline_code_size])\n"
"      $stderr.puts \"outlined_code_size:    \" + (\"%10d\" % stats[:outlined_code_size])\n"
"      $stderr.puts \"num_gc_obj_refs:       \" + (\"%10d\" % stats[:num_gc_obj_refs])\n"
"\n"
"      $stderr.puts \"total_exit_count:      \" + (\"%10d\" % total_exits)\n"
,
#line 224 "yjit.rb"
"      $stderr.puts \"total_insns_count:     \" + (\"%10d\" % total_insns_count)\n"
"      $stderr.puts \"vm_insns_count:        \" + (\"%10d\" % stats[:vm_insns_count])\n"
"      $stderr.puts \"yjit_insns_count:      \" + (\"%10d\" % stats[:exec_instruction])\n"
"      $stderr.puts \"ratio_in_yjit:         \" + (\"%9.1f\" % yjit_ratio_pct) + \"%\"\n"
"      $stderr.puts \"avg_len_in_yjit:       \" + (\"%10.1f\" % avg_len_in_yjit)\n"
"\n"
"      print_sorted_exit_counts(stats, prefix: \"exit_\")\n"
"    end\n"
"\n"
,
#line 233 "yjit.rb"
"    def print_sorted_exit_counts(stats, prefix:, how_many: 20, left_pad: 4)\n"
"      exits = []\n"
"      stats.each do |k, v|\n"
"        if k.start_with?(prefix)\n"
"          exits.push [k.to_s.delete_prefix(prefix), v]\n"
"        end\n"
"      end\n"
"\n"
"      exits = exits.sort_by { |name, count| -count }[0...how_many]\n"
"      total_exits = total_exit_count(stats)\n"
"\n"
"      if total_exits > 0\n"
"        top_n_total = exits.map { |name, count| count }.sum\n"
"        top_n_exit_pct = 100.0 * top_n_total / total_exits\n"
"\n"
,
#line 248 "yjit.rb"
"        $stderr.puts \"Top-#{how_many} most frequent exit ops (#{\"%.1f\" % top_n_exit_pct}% of exits):\"\n"
"\n"
"        longest_insn_name_len = exits.map { |name, count| name.length }.max\n"
"        exits.each do |name, count|\n"
"          padding = longest_insn_name_len + left_pad\n"
"          padded_name = \"%#{padding}s\" % name\n"
"          padded_count = \"%10d\" % count\n"
"          percent = 100.0 * count / total_exits\n"
"          formatted_percent = \"%.1f\" % percent\n"
,
#line 257 "yjit.rb"
"          $stderr.puts(\"#{padded_name}: #{padded_count} (#{formatted_percent}%)\" )\n"
"        end\n"
"      else\n"
"        $stderr.puts \"total_exits:           \" + (\"%10d\" % total_exits)\n"
"      end\n"
"    end\n"
"\n"
"    def total_exit_count(stats, prefix: \"exit_\")\n"
"      total = 0\n"
"      stats.each do |k,v|\n"
"        total += v if k.start_with?(prefix)\n"
"      end\n"
"      total\n"
"    end\n"
"\n"
"    def print_counters(counters, prefix:, prompt:)\n"
"      $stderr.puts(prompt)\n"
,
#line 274 "yjit.rb"
"      counters = counters.filter { |key, _| key.start_with?(prefix) }\n"
"      counters.filter! { |_, value| value != 0 }\n"
"      counters.transform_keys! { |key| key.to_s.delete_prefix(prefix) }\n"
"\n"
"      if counters.empty?\n"
"        $stderr.puts(\"    (all relevant counters are zero)\")\n"
"        return\n"
"      end\n"
"\n"
"      counters = counters.to_a\n"
"      counters.sort_by! { |(_, counter_value)| counter_value }\n"
"      longest_name_length = counters.max_by { |(name, _)| name.length }.first.length\n"
,
#line 286 "yjit.rb"
"      total = counters.sum { |(_, counter_value)| counter_value }\n"
"\n"
"      counters.reverse_each do |(name, value)|\n"
"        percentage = value.fdiv(total) * 100\n"
"        $stderr.printf(\"    %*s %10d (%4.1f%%)\\n\", longest_name_length, name, value, percentage);\n"
"      end\n"
"    end\n"
"  end\n"
"end\n"
#line 7010 "miniprelude.c"
};

COMPILER_WARNING_POP

#define PRELUDE_NAME(n) rb_usascii_str_new_static(prelude_name##n, sizeof(prelude_name##n)-1)
#define PRELUDE_CODE(n) rb_utf8_str_new_static(prelude_code##n.L0, sizeof(prelude_code##n))

static rb_ast_t *
prelude_ast(VALUE name, VALUE code, int line)
{
    rb_ast_t *ast = rb_parser_compile_string_path(rb_parser_new(), name, code, line);
    if (!ast->body.root) {
        rb_ast_dispose(ast);
        rb_exc_raise(rb_errinfo());
    }
    return ast;
}

#define PRELUDE_AST(n, name_str, start_line) \
    (((sizeof(prelude_name##n) - prefix_len - 2) == namelen) && \
     (strncmp(prelude_name##n + prefix_len, feature_name, namelen) == 0) ? \
     prelude_ast((name_str) = PRELUDE_NAME(n), PRELUDE_CODE(n), start_line) : 0)

rb_ast_t *
rb_builtin_ast(const char *feature_name, VALUE *name_str)
{
    const size_t prefix_len = rb_strlen_lit("<internal:");
    size_t namelen = strlen(feature_name);
    rb_ast_t *ast = 0;

    if ((ast = PRELUDE_AST(0, *name_str, 20)) != 0) return ast;
    if ((ast = PRELUDE_AST(1, *name_str, 83)) != 0) return ast;
    if ((ast = PRELUDE_AST(2, *name_str, 11)) != 0) return ast;
    if ((ast = PRELUDE_AST(3, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(4, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(5, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(6, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(7, *name_str, 3)) != 0) return ast;
    if ((ast = PRELUDE_AST(8, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(9, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(10, *name_str, 51)) != 0) return ast;
    if ((ast = PRELUDE_AST(11, *name_str, 4)) != 0) return ast;
    if ((ast = PRELUDE_AST(12, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(13, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(14, *name_str, 228)) != 0) return ast;
    if ((ast = PRELUDE_AST(15, *name_str, 213)) != 0) return ast;
    if ((ast = PRELUDE_AST(16, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(17, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(18, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(19, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(20, *name_str, 11)) != 0) return ast;
    return ast;
}

void
Init_prelude(void)
{
}
