require "dpklib/format"
require "rexml/document"

module Dpklib_REXML
  class NoEncodingSource < REXML::Source
    def encoding=(enc)
      enc
    end
  end #/NoEncodingSource
  
  class NoencodingDocumentFormat < Dpklib::Format
    def parse(xml)
      source = NoEncodingSource.new(xml)
      REXML::Document.new(source)
    end

    def format(xmldoc)
      xml = ""
      xmldoc.each { |node|
        node.write(xml, 0)
      }
      xml
    end
    Dpklib.install_singleton_format_and_parse(self)
  end #/NoencodingDocumentFormat

  class << self
    def seal_encoding_behavior
      require "rexml/encoding"
      REXML::Encoding.module_eval(<<-EOF, __FILE__, __LINE__ + 1)
        def encoding=(enc)
          @encoding = enc.upcase
          nil
        end
      EOF
    end
  end #/<< self
end #/Dpklib_REXML
