

module Dpklib
  class TimeAreaComposer
    class FieldComposer
      attr_accessor :field, :atom_composer
      def perform
        if field.size == 0 then
          "*"
        else
          compose_field(field)
        end
      end

      protected
      def compose_field(field)
        items = field.collect do |item|
          compose_item(item)
        end
        items.join(",")
      end

      def compose_item(item)
        case item
          when Range
          first = atom_composer[item.first]
          last = atom_composer[item.last]
          "#{first}-#{last}"
          else
          atom_composer[item]
        end
      end
    end #/FieldComposer
    
    class Processor
      attr_accessor :composer
      def perform
        timearea = composer.timearea
        @field_composer = FieldComposer.new
        @fields = []

        compose_field(timearea.monthdays) { |atom|
          "#{atom.month}/#{atom.day}"
        }
        compose_field(timearea.hours) { |atom|
          "#{atom.hour}:#{atom.min}"
        }
        compose_field(timearea.wdays) { |atom|
          TimeArea::WDAY[atom]
        }
        timearea.etc && @fields << timearea.etc
        @fields.join(" ")
      end

      protected
      def compose_field(field, &block)
        @field_composer.field = field
        @field_composer.atom_composer = block
        @fields << @field_composer.perform
      end
    end #/Processor

    attr_accessor :timearea
    def perform
      processor = Processor.new
      processor.composer = self
      processor.perform
    end
  end #/TimeAreaComposer
    
end #/Dpklib
