require "date"
require "dpklib/error"
require "parsedate"

module Dpklib
  TimeParseError = Class.new(StandardError)
  DateParseError = Dpklib.new_error_class(TimeParseError) { |str|
    "Cannot parse into date: #{str}"
  }
  TimestampParseError = Dpklib.new_error_class(TimeParseError) { |str|
    "Cannot parse into timestamp: #{str}"
  }
end #/Dpklib

class << Dpklib
  def time_to_date(time)
    Date.new(time.year, time.month, time.day)
  end

  def date_to_time(date, hour = 0, min = 0, sec = 0)
    Time.local(date.year, date.month, date.day, hour, min, sec)
  end

  def parse_date(string)
    dateargs = ParseDate.parsedate(string)[0..2]
    dateargs.include?(nil) && Dpklib::DateParseError.raise(string)
    Date.new(*dateargs)
  end

  def parse_timestamp(string)
    timeargs = ParseDate.parsedate(string)[0..5]
    timeargs.include?(nil) && Dpklib::TimestampParseError.raise(string)
    Time.local(*timeargs)
  end
  
end #/<< Dpklib
