=begin
=TC_TestResult.rb
Contains tests for the TestResult class
=end

#<standard_header>
#
# Copyright (C) 2000-2001 Nathaniel Talbott
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#</standard_header>

require 'Lapidary/TestCase'
require 'Lapidary/TestResult'

module Lapidary
	class TC_TestResult < TestCase
		def setup()
			@myResult = TestResult.new
			@myResult.addSuccessfulAssertion()
			@myResult.addFailedAssertion()
			@myResult.addError()
		end
		def testResultChangedNotification
			called1 = false
			@myResult.addResultListener( proc {
				|result|
				assertBlock("The result should be correct") { result == @myResult }
				called1 = true
			} )
			@myResult.addSuccessfulAssertion()
			assertBlock("Should have been notified when the assertion happened") { called1 }
			
			called1, called2 = false, false
			@myResult.addResultListener( proc {
				|result|
				assertBlock("The result should be correct") { result == @myResult }
				called2 = true
			} )
			@myResult.addSuccessfulAssertion
			assertBlock("Both listeners should have been notified for a success") { called1 && called2 }

			called1, called2 = false, false		
			@myResult.addFailedAssertion
			assertBlock("Both listeners should have been notified for a failure") { called1 && called2 }

			called1, called2 = false, false		
			@myResult.addError
			assertBlock("Both listeners should have been notified for an error") { called1 && called2 }

			called1, called2 = false, false		
			@myResult.addRun
			assertBlock("Both listeners should have been notified for a run") { called1 && called2 }
		end
		def testAddRemoveResultChangedListener
			called1 = false
			listener1 = proc {
				| result |
				called1 = true
			}
			@myResult.addResultListener(listener1) 
			called2 = false
			listener2 = proc {
				| result |
				called2 = true
			}
			@myResult.addResultListener(listener2)
			@myResult.addSuccessfulAssertion()
			assertBlock("Both listeners should have been called") { called1 && called2 }
			
			called1, called2 = false, false
			@myResult.removeResultListener(listener1)
			@myResult.addSuccessfulAssertion()
			assertBlock("The first listener should not be called anymore") { ! called1 }
			assertBlock("The second listener should still be called") { called2 }

			called1, called2 = false, false
			@myResult.removeResultListener(listener2)
			@myResult.addSuccessfulAssertion()
			assertBlock("Neither listener should be called anymore") { ! (called1 && called2) }
		end
		def testFaultNotification
			called1 = false
			fault = "fault"
			@myResult.addFaultListener( proc {
				| passedFault |
				assertBlock("The fault should be correct") { passedFault == fault }
				called1 = true
			} )

			@myResult.addSuccessfulAssertion(fault)
			assertBlock("Should not have been notified when the assertion happened") { !called1 }
			
			@myResult.addFailedAssertion(fault)
			assertBlock("Should have been notified when the failure happened") { called1 }
			
			called1, called2 = false, false
			@myResult.addFaultListener( proc {
				| passedFault |
				assertBlock("The fault should be correct") { passedFault == fault }
				called2 = true
			} )

			@myResult.addSuccessfulAssertion(fault)
			assertBlock("Neither listener should have been notified for a success") { !(called1 || called2) }

			called1, called2 = false, false
			@myResult.addFailedAssertion(fault)
			assertBlock("Both listeners should have been notified for a failure") { called1 && called2 }

			called1, called2 = false, false		
			@myResult.addError(fault)
			assertBlock("Both listeners should have been notified for an error") { called1 && called2 }

			called1, called2 = false, false		
			@myResult.addRun
			assertBlock("Neither listener should have been notified for a run") { !(called1 || called2) }
		end
		def testAddRemoveFaultListener
			called1 = false
			listener1 = proc {
				| fault |
				called1 = true
			}
			@myResult.addFaultListener(listener1) 
			called2 = false
			listener2 = proc {
				| fault |
				called2 = true
			}
			@myResult.addFaultListener(listener2)
			@myResult.addFailedAssertion
			assertBlock("Both listeners should have been called") { called1 && called2 }
			
			called1, called2 = false, false
			@myResult.removeFaultListener(listener1)
			@myResult.addFailedAssertion
			assertBlock("The first listener should not be called anymore") { ! called1 }
			assertBlock("The second listener should still be called") { called2 }

			called1, called2 = false, false
			@myResult.removeFaultListener(listener2)
			@myResult.addFailedAssertion
			assertBlock("Neither listener should be called anymore") { ! (called1 || called2) }
		end
	end
end
