=begin
=TF_SetupTearDown.rb
A test fixture for testing TestCase setup and tear down.
=end

#<standard_header>
#
# Copyright (C) 2000-2001 Nathaniel Talbott
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#</standard_header>

require 'Lapidary/TestCase'

module Lapidary
	class TF_SetupTearDown < TestCase
		attr_reader(:setupCalled, :tearDownCalled)
		def initialize(test)
			super(test)
			@setupCalled = false
			@tearDownCalled = false
		end
		def setup
			@setupCalled = true
		end
		def tearDown
			@tearDownCalled = true
		end
		def testSucceed
			assertBlock {true}
		end
		def testFail
			assertBlock {false}
		end
		def testError
			raise Exception.new()
		end
	end
end
