#!/usr/bin/ruby -I. -w

require "nqxml/treeparser"
require "nqxml/writer"
require "benchmark"

include Benchmark

n=400
bm(20) do |test|
	File.open("project.xml") do |source|
		test.report("Parsing file"){ n.times {
			NQXML::TreeParser.new(source).document
			source.rewind
		}}
	end
	test.report("Document.new") {  n.times {
		NQXML::Document.new 
	}}
	test.report("new element") {  n.times {
		NQXML::Tag.new("x", {}) 
	}}
	document = NQXML::Document.new
	element = document.setRoot(NQXML::Tag.new("x", {}))
	test.report("add element") {  n.times {
		element.addChild( NQXML::Tag.new("x", {})) 
	}}
	el1 = NQXML::Tag.new("x", {})
	puts "add child is same as add element for NQXML"

	test.report("Tree manipulation") { n.times {
		doc = NQXML::Document.new()
		doc.setRoot(NQXML::Tag.new("tag1", {"blah"=>"four"}))

		tag2 = NQXML::Tag.new( "tag2", {"some"=>"value"})
		node = doc.rootNode.addChild( tag2 )

		tag3 = NQXML::Tag.new( "tag3", {})
		node.addChild( tag3 )
	}}
	File.open("project.xml") do |source|
		document = NQXML::TreeParser.new(source).document
	end
	test.report("Writing tree") { n.times {
		string = ""
		writer = NQXML::Writer.new string, true
		writer.writeDocument( document )
	}}
	test.report("Detecting children") { n.times {
		element = document.rootNode.children.detect{ |node|
			entity = node.entity
			entity.instance_of?(NQXML::Tag) and entity.name == "Datasets"
		}
		element = element.children.detect{ |node|
			entity = node.entity
			entity.instance_of?(NQXML::Tag) and
			entity.name == "link" and
			entity.attrs['idref'] == '18'
		}
	}}
	puts "NQXML does not support XPath searches"
end
