#!/usr/bin/ruby -I. -w

Dir.chdir ".." if Dir.pwd =~ /bin.?$/

require "test/unit/testcase"
require "test/unit/ui/console/testrunner"

Dir.entries('test').each do |file|
	require "test/#{file}" if file =~ /\.rb$/
end

runner = Test::Unit::UI::Console::TestRunner
suite = Test::Unit::TestSuite


# Parse and handle the arguments
if ARGV.size > 0

	if ARGV[0] == '--help'
		puts "USAGE: #$0 [--help|--list [<suite>]|[--gui] <suite> [<method>]]\n"+
		"  --list\tList the available test suites\n"+
		"    <suite>\tList the methods of a suite\n"+
		"  <suite>\tRun all of the tests in a suite\n"+
		"  <method>\tRun the given method"
		exit

	elsif ARGV[0] == '--list'
		if ARGV[1]
			suite = ARGV[1]
			ObjectSpace.each_object(Class){|ob|suite = ob if ob.to_s == suite}
			puts((suite.instance_methods - Object.methods).collect{|mn| "  "+mn})
		else
			ObjectSpace.each_object(Class){|ob| 
				puts ob.to_s if ob.ancestors.include? Test::Unit::TestCase and ob.to_s != 'RUNIT::TestCase'
			}
		end
		exit

	elsif ARGV[0] == '--gui'
		ARGV.shift
		begin
			require 'test/unit/ui/fox/testrunner'
			runner = Test::Unit::UI::Fox::TestRunner
			suite = Test::Unit::TestSuite
		rescue Exception
			puts $!
			puts "You must have Test::Unit and FXRuby installed to run the GUI test runner.\n"
			puts "I'm continuing without the GUI."
		end
	end
end

if ARGV.size > 0
	# Get the test Class object for the named test
	test = ARGV[0]
	ObjectSpace.each_object(Class) {|ob| test = ob if ob.to_s == test }

	# Are we running a single test, or a test suite?
	if ARGV.size == 2
		test = test.new(ARGV[1])
	else
		test = test.suite
	end

	runner.run( test )
else
	suite = suite.new 'REXML'
	ObjectSpace.each_object(Class){|ob| 
		if ob.ancestors.include? Test::Unit::TestCase and ob.to_s != 'RUNIT::TestCase' and ob.to_s != 'Test::Unit::TestCase'
			suite << ob.suite 
		end
	}
	runner.run( suite )
end
