require 'runit/testcase'
require 'runit/cui/testrunner'
require 'dummytestcase'

class TestSkipAssert < RUNIT::TestCase
  def test_skip_assert
    RUNIT::Assert.skip_failure = true
    suite = DummyTestSkipAssertTest.suite
    result = RUNIT::TestResult.new
    suite.run(result)
    assert_equal(3, result.run_asserts)
    assert_equal(1, result.failure_size)
  end
  def test_no_skip_assert
    RUNIT::Assert.skip_failure = false
    suite = DummyTestSkipAssertTest.suite
    result = RUNIT::TestResult.new
    suite.run(result)
    assert_equal(1, result.run_asserts)
  end
  def teardown
    RUNIT::Assert.skip_failure = false
  end
end

if $0 == __FILE__
  if ARGV.size == 0
    suite = TestSkip.suite
  else
    suite = RUNIT::TestSuite.new
    ARGV.each do |testmethod|
      suite.add(TestSkip.new(testmethod))
    end
  end
  RUNIT::CUI::TestRunner.run(suite)
end
