require 'runit/testcase'
require 'runit/cui/testrunner'

require 'dummytestcase'

class TestRUNIT__TestResultItem < RUNIT::TestCase
  def test_run_asserts
    result = RUNIT::TestResult.new
    suite = DummyTestCaseNormal.suite
    suite.run(result)
    assert_equal(1, result.items.size)
    assert_equal(2, result.items[0].run_asserts)

    result = RUNIT::TestResult.new
    suite = DummyTestCaseMultiTest.suite
    suite.run(result)
    assert_equal(3, result.items.size)
    run_asserts_tested = false
    result.items.each do |i|
      assert_match(i.name, /^DummyTestCaseMultiTest#test_/)
      if "DummyTestCaseMultiTest#test_3" == i.name
        assert_equal(2, i.run_asserts)
        run_asserts_tested = true
      end
    end
    assert(run_asserts_tested)
  end

end

if $0 == __FILE__
  if ARGV.size == 0
    suite = TestRUNIT__TestResultItem.suite
  else
    suite = RUNIT::TestSuite.new
    ARGV.each do |testmethod|
      suite.add(TestRUNIT__TestResultItem.new(testmethod))
    end
  end
  RUNIT::CUI::TestRunner.run(suite)
end
