require 'racc/parser'

#
# parsemail.rb
#
#   Copyright (c) 1998-2001 Minero Aoki <aamine@dp.u-netsurf.ne.jp>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#

require 'tmail/scanmail'


module TMail

  class Mailp < ::Racc::Parser

module_eval <<'..end mailp.y modeval..id272a6459bf', 'mailp.y', 289

  def self.parse( str, obj, ident )
    new.parse( str, obj, ident )
  end


  MAILP_DEBUG = false

  def initialize
    self.debug = MAILP_DEBUG
  end

  def debug=( flag )
    @yydebug = flag && Racc_debug_parser
    @scanner_debug = flag
  end

  def debug
    @yydebug
  end


  NATIVE_ROUTINE = {
    'TMail::MsgidH' => :msgid_parse,
    'TMail::RefH' => :refs_parse
  }

  def parse( str, obj, ident )
    return if /\A\s*\z/ === str

    @field = obj

    if mid = NATIVE_ROUTINE[ obj.type.name ] then
      send mid, str
    else
      unless ident then
        ident = obj.type.name.split('::')[-1].to_s
        cmt = []
        obj.comments.replace cmt
      else
        cmt = nil
      end

      @scanner = MailScanner.new( str, ident, cmt )
      @scanner.debug = @scanner_debug
      @first = [ ident.intern, ident ]
      @pass_array = [nil, nil]

      do_parse
    end
  end


  private


  def next_token
    if @first then
      ret = @first
      @first = nil
      ret
    else
      @scanner.scan @pass_array
    end
  end
  
  def on_error( tok, val, vstack )
    raise ParseError,
      "\nparse error in '#{@field.name}:' on token #{val.inspect}"
  end



  def refs_parse( str )
    arr = []

    while mdata = ::TMail::MSGID.match( str ) do
      str = mdata.post_match

      pre = mdata.pre_match
      pre.strip!
      proc_phrase pre, arr unless pre.empty?
      arr.push mdata.to_s
    end
    str.strip!
    proc_phrase str, arr if not pre or pre.empty?

    @field.refs.replace arr
  end

  def proc_phrase( str, arr )
    while mdata = /"([^\\]*(?:\\.[^"\\]*)*)"/.match( str ) do
      str = mdata.post_match

      pre = mdata.pre_match
      pre.strip!
      arr.push pre unless pre.empty?
      arr.push mdata[1]
    end
    str.strip!
    arr.push str unless str.empty?
  end


  def msgid_parse( str )
    if mdata = ::TMail::MSGID.match( str ) then
      @field.msgid = mdata.to_s
    else
      raise ParseError, "wrong Message-ID format: #{str}"
    end
  end

..end mailp.y modeval..id272a6459bf

##### racc 1.3.6 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 2, 39, :_reduce_1,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_4,
 2, 39, :_reduce_5,
 2, 39, :_reduce_6,
 2, 39, :_reduce_7,
 2, 39, :_reduce_8,
 2, 39, :_reduce_9,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_none,
 2, 39, :_reduce_15,
 2, 39, :_reduce_16,
 6, 40, :_reduce_17,
 0, 55, :_reduce_none,
 2, 55, :_reduce_none,
 3, 56, :_reduce_20,
 5, 56, :_reduce_21,
 1, 57, :_reduce_22,
 7, 41, :_reduce_none,
 0, 58, :_reduce_none,
 2, 58, :_reduce_25,
 4, 58, :_reduce_26,
 3, 58, :_reduce_27,
 0, 59, :_reduce_none,
 2, 59, :_reduce_29,
 0, 60, :_reduce_none,
 2, 60, :_reduce_31,
 0, 61, :_reduce_none,
 2, 61, :_reduce_33,
 0, 62, :_reduce_none,
 2, 62, :_reduce_35,
 2, 62, :_reduce_36,
 0, 63, :_reduce_none,
 2, 63, :_reduce_38,
 0, 64, :_reduce_none,
 2, 64, :_reduce_40,
 2, 42, :_reduce_none,
 1, 42, :_reduce_42,
 1, 43, :_reduce_43,
 3, 43, :_reduce_44,
 1, 44, :_reduce_none,
 1, 44, :_reduce_none,
 1, 45, :_reduce_47,
 3, 45, :_reduce_48,
 1, 46, :_reduce_none,
 1, 46, :_reduce_none,
 2, 46, :_reduce_51,
 4, 67, :_reduce_52,
 4, 66, :_reduce_53,
 3, 66, :_reduce_54,
 2, 69, :_reduce_none,
 2, 70, :_reduce_56,
 4, 70, :_reduce_57,
 3, 54, :_reduce_58,
 1, 54, :_reduce_59,
 1, 71, :_reduce_60,
 3, 71, :_reduce_61,
 1, 65, :_reduce_62,
 3, 65, :_reduce_63,
 1, 73, :_reduce_none,
 1, 73, :_reduce_none,
 1, 73, :_reduce_none,
 3, 47, :_reduce_67,
 1, 68, :_reduce_none,
 2, 68, :_reduce_69,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 72, :_reduce_none,
 1, 48, :_reduce_none,
 3, 48, :_reduce_none,
 1, 49, :_reduce_75,
 2, 49, :_reduce_76,
 3, 50, :_reduce_77,
 4, 51, :_reduce_78,
 2, 51, :_reduce_79,
 0, 75, :_reduce_none,
 5, 75, :_reduce_81,
 1, 76, :_reduce_none,
 1, 76, :_reduce_none,
 1, 52, :_reduce_84,
 2, 53, :_reduce_85,
 0, 77, :_reduce_none,
 3, 77, :_reduce_none,
 0, 78, :_reduce_none,
 3, 78, :_reduce_89,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none,
 1, 74, :_reduce_none ]

racc_reduce_n = 97

racc_shift_n = 162

racc_action_table = [
   -60,    21,    26,   147,   131,    30,    98,    98,    19,    20,
    25,    27,    29,   105,    34,    38,   133,    22,    21,    26,
   -60,    95,    30,   -60,   107,    19,    20,    25,    27,    29,
   -60,    34,    94,   -60,    22,    21,    26,   115,   113,    30,
    74,   109,    19,    20,    25,    27,    29,   114,    21,    26,
    73,    22,    30,   103,   104,    19,    20,    25,    27,    29,
    91,    34,    21,    26,    22,   111,    30,   151,   152,    19,
    20,    25,    27,    29,    84,    21,    26,   116,    22,    30,
   151,   152,    19,    20,    25,    27,    29,   117,    21,    26,
   118,    22,    30,    82,    81,    19,    20,    25,    27,    29,
   121,    21,    26,    80,    22,    30,   114,   123,    19,    20,
    25,    27,    29,   124,   114,    21,    26,    22,    96,    30,
    70,   125,    19,    20,    25,    27,    29,   114,    34,    21,
    26,    22,   126,    30,   127,    66,    19,    20,    25,    27,
    29,    63,    21,    26,    99,    22,    30,    78,    56,    19,
    20,    25,    27,    29,   134,    55,    92,   138,    22,    21,
    26,   139,   140,    30,   114,   142,    19,    20,    25,    27,
    29,   117,    34,    21,    26,    22,   143,    30,   114,   145,
    19,    20,    25,    27,    29,   146,    21,    26,    51,    22,
    30,   149,    50,    19,    20,    25,    27,    29,    44,    34,
    21,    26,    22,   155,    30,    38,   158,    19,    20,    25,
    27,    29,   159,    34,    21,    26,    22,    44,    30,   161,
   nil,    19,    20,    25,    27,    29,   nil,    34,    21,    26,
    22,   nil,    30,   nil,   nil,    19,    20,    25,    27,    29,
   nil,    21,    26,   nil,    22,    30,   nil,   nil,    19,    20,
    25,    27,    29,   nil,    34,    21,    26,    22,   nil,    30,
   nil,   nil,    19,    20,    25,    27,    29,   nil,    34,    21,
    26,    22,   nil,    30,   nil,   nil,    19,    20,    25,    27,
    29,   nil,    21,    26,   nil,    22,    30,    78,   nil,    19,
    20,    25,    27,    29,   nil,    21,    26,   nil,    22,    30,
   nil,   nil,    19,    20,    25,    27,    29,   nil,    21,    26,
   nil,    22,    30,   nil,   nil,    19,    20,    25,    27,    29,
   nil,    34,   nil,   nil,    22,     6,     8,    10,    12,    14,
    16,     2,     4,     5,     7,     9,    11,    13,    15,     1,
     3,    89,    26,   nil,   nil,    30,   nil,    86,    19,    20,
    25,    27,    29,    89,    26,   nil,   nil,    30,   nil,    86,
    19,    20,    25,    27,    29,    89,    26,   nil,   nil,    30,
   nil,    86,    19,    20,    25,    27,    29,    89,    26,   nil,
   nil,    30,   nil,    86,    19,    20,    25,    27,    29,    89,
    26,   nil,   nil,    30,   nil,    86,    19,    20,    25,    27,
    29,    89,    26,   nil,   nil,    30,   nil,    86,    19,    20,
    25,    27,    29,    89,    26,   nil,   nil,    30,   nil,    86,
    19,    20,    25,    27,    29 ]

racc_action_check = [
    18,    12,    12,   140,   117,    12,   120,    68,    12,    12,
    12,    12,    12,    77,    12,   140,   120,    12,     2,     2,
    18,    59,     2,    18,    79,     2,     2,     2,     2,     2,
    18,     2,    56,    18,     2,     3,     3,    88,    88,     3,
    33,    82,     3,     3,     3,     3,     3,    88,   149,   149,
    33,     3,   149,    76,    76,   149,   149,   149,   149,   149,
    51,   149,     5,     5,   149,    85,     5,   143,   143,     5,
     5,     5,     5,     5,    49,    73,    73,    91,     5,    73,
   142,   142,    73,    73,    73,    73,    73,    93,     7,     7,
    94,    73,     7,    45,    44,     7,     7,     7,     7,     7,
    97,    75,    75,    41,     7,    75,   101,   102,    75,    75,
    75,    75,    75,   103,   106,    60,    60,    75,    60,    60,
    17,   109,    60,    60,    60,    60,    60,   110,    60,    80,
    80,    60,   111,    80,   112,    15,    80,    80,    80,    80,
    80,    13,    55,    55,    70,    80,    55,    55,    11,    55,
    55,    55,    55,    55,   121,    10,    55,   125,    55,     1,
     1,   127,   128,     1,   130,   131,     1,     1,     1,     1,
     1,   132,     1,    46,    46,     1,   134,    46,   136,   137,
    46,    46,    46,    46,    46,   138,    14,    14,     9,    46,
    14,   141,     8,    14,    14,    14,    14,    14,     6,    14,
    95,    95,    14,   146,    95,     4,   150,    95,    95,    95,
    95,    95,   155,    95,    16,    16,    95,   158,    16,   159,
   nil,    16,    16,    16,    16,    16,   nil,    16,   108,   108,
    16,   nil,   108,   nil,   nil,   108,   108,   108,   108,   108,
   nil,    28,    28,   nil,   108,    28,   nil,   nil,    28,    28,
    28,    28,    28,   nil,    28,    96,    96,    28,   nil,    96,
   nil,   nil,    96,    96,    96,    96,    96,   nil,    96,    42,
    42,    96,   nil,    42,   nil,   nil,    42,    42,    42,    42,
    42,   nil,    34,    34,   nil,    42,    34,    34,   nil,    34,
    34,    34,    34,    34,   nil,    38,    38,   nil,    34,    38,
   nil,   nil,    38,    38,    38,    38,    38,   nil,    98,    98,
   nil,    38,    98,   nil,   nil,    98,    98,    98,    98,    98,
   nil,    98,   nil,   nil,    98,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    74,    74,   nil,   nil,    74,   nil,    74,    74,    74,
    74,    74,    74,   115,   115,   nil,   nil,   115,   nil,   115,
   115,   115,   115,   115,   115,   114,   114,   nil,   nil,   114,
   nil,   114,   114,   114,   114,   114,   114,    50,    50,   nil,
   nil,    50,   nil,    50,    50,    50,    50,    50,    50,    84,
    84,   nil,   nil,    84,   nil,    84,    84,    84,    84,    84,
    84,    78,    78,   nil,   nil,    78,   nil,    78,    78,    78,
    78,    78,    78,   124,   124,   nil,   nil,   124,   nil,   124,
   124,   124,   124,   124,   124 ]

racc_action_pointer = [
   323,   141,     0,    17,   174,    44,   179,    70,   170,   170,
   124,   113,   -17,   106,   168,   100,   196,   120,     0,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   223,   nil,
   nil,   nil,   nil,    17,   264,   nil,   nil,   nil,   277,   nil,
   nil,    83,   251,   nil,    74,    75,   155,   nil,   nil,    49,
   359,    27,   nil,   nil,   nil,   124,    -4,   nil,   nil,     1,
    97,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   -13,   nil,
   144,   nil,   nil,    57,   323,    83,    33,   -19,   383,    -8,
   111,   nil,    22,   nil,   371,    39,   nil,   nil,    14,   nil,
   nil,    59,   nil,    57,    55,   182,   237,    70,   290,   nil,
   nil,    73,    75,    90,   nil,   nil,    81,   nil,   210,   103,
    94,   113,   107,   nil,   347,   335,   nil,   -31,   nil,   nil,
   -14,   119,   nil,   nil,   395,   139,   nil,   142,   134,   nil,
   131,   128,   141,   nil,   139,   nil,   145,   160,   164,   nil,
   -16,   162,    46,    33,   nil,   nil,   185,   nil,   nil,    30,
   176,   nil,   nil,   nil,   nil,   191,   nil,   nil,   198,   201,
   nil,   nil ]

racc_action_default = [
   -97,   -97,   -97,   -97,   -97,   -97,   -18,   -97,   -24,   -97,
   -97,   -97,   -97,   -97,   -97,   -97,   -97,   -97,   -68,   -92,
   -93,   -72,   -71,   -70,   -50,   -94,   -90,   -95,   -97,   -96,
   -91,   -49,   -15,   -59,   -97,    -7,   -60,   -16,   -97,    -8,
   -68,    -9,   -73,    -1,   -97,   -97,   -75,   -10,    -2,   -28,
   -97,   -97,   -11,   -42,    -3,   -97,   -80,   -12,   -46,    -4,
   -97,   -43,   -45,   -84,   -13,    -5,   -86,   -14,    -6,   -47,
   -97,   -69,   -51,   -97,   -97,   -97,   -97,   -97,   -97,   -97,
   -97,   -19,   -97,   -76,   -97,   -30,   -65,   -62,   -25,   -66,
   -64,   -97,   -41,   -79,   -97,   -97,   -97,   -85,   -97,   162,
   -61,   -58,   -97,   -97,   -55,   -54,   -56,   -67,   -74,   -97,
   -29,   -97,   -32,   -27,   -97,   -97,   -77,   -97,   -80,   -44,
   -97,   -88,   -48,   -53,   -97,   -97,   -31,   -97,   -34,   -63,
   -26,   -97,   -78,   -52,   -97,   -87,   -57,   -97,   -97,   -33,
   -97,   -37,   -97,   -97,   -17,   -22,   -97,   -36,   -35,   -97,
   -39,   -83,   -82,   -81,   -89,   -20,   -38,   -23,   -18,   -97,
   -40,   -21 ]

racc_goto_table = [
    43,    42,    61,    68,    65,    39,    90,    36,    60,    40,
    60,    46,    32,    35,   144,    53,    37,   153,   154,    93,
    67,    88,    57,   137,    64,    49,    85,    69,   112,   128,
    90,   141,    71,    72,    90,   150,   157,    52,    36,    47,
    90,    41,    36,    59,   129,   101,    71,    77,    54,   106,
    83,    79,    48,    17,    97,   110,   135,   nil,   nil,    36,
   nil,   nil,   nil,   nil,    71,    72,   nil,   nil,    77,   nil,
    90,    90,   nil,   nil,   nil,   nil,   108,   100,   nil,    36,
    90,   132,   nil,   120,    40,   119,   130,   nil,   102,   nil,
   nil,    60,   nil,   nil,   nil,   136,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,    69,   nil,   122,
   nil,   nil,    71,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   156,
   nil,   148,   nil,   nil,   nil,    60,   nil,   nil,   nil,   nil,
   nil,   nil,   160 ]

racc_goto_check = [
     2,    30,     6,     7,     6,     9,    36,    34,    30,    34,
    30,    34,     8,     8,    19,    28,    16,    38,    38,    37,
    15,    27,    13,    18,    14,    20,    21,     8,    22,    23,
    36,    24,    34,    28,    36,    25,    26,    12,    34,    11,
    36,    10,    34,     5,    35,    27,    34,    16,     4,    27,
    34,    16,     3,     1,    39,    27,    40,   nil,   nil,    34,
   nil,   nil,   nil,   nil,    34,    28,   nil,   nil,    16,   nil,
    36,    36,   nil,   nil,   nil,   nil,    30,    34,   nil,    34,
    36,    37,   nil,     7,    34,     6,    27,   nil,    16,   nil,
   nil,    30,   nil,   nil,   nil,    27,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,     8,   nil,     8,
   nil,   nil,    34,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,     6,
   nil,     9,   nil,   nil,   nil,    30,   nil,   nil,   nil,   nil,
   nil,   nil,     2 ]

racc_goto_pointer = [
   nil,    53,    -6,    44,    38,    31,   -10,   -13,    11,     1,
    36,    32,    28,    11,    11,     5,    13,   nil,  -102,  -123,
    17,   -23,   -57,   -83,   -97,  -106,  -114,   -29,     5,   nil,
    -4,   nil,   nil,   nil,     4,   -70,   -44,   -37,  -125,   -12,
   -65 ]

racc_goto_default = [
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    62,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,    31,    45,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    24,    58,
    28,    75,    76,    33,    18,    87,    23,   nil,   nil,   nil,
   nil ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :DateH => 2,
 :RecvH => 3,
 :RetpathH => 4,
 :MaddrH => 5,
 :SaddrH => 6,
 :MmboxH => 7,
 :SmboxH => 8,
 :MsgidH => 9,
 :KeyH => 10,
 :EncH => 11,
 :VersionH => 12,
 :CTypeH => 13,
 :CEncodingH => 14,
 :CDispositionH => 15,
 :Mbox => 16,
 :Spec => 17,
 :DIGIT => 18,
 :ATOM => 19,
 "," => 20,
 ":" => 21,
 :FROM => 22,
 "@" => 23,
 :DOMLIT => 24,
 :BY => 25,
 :VIA => 26,
 :WITH => 27,
 :ID => 28,
 :FOR => 29,
 ";" => 30,
 "<" => 31,
 ">" => 32,
 "." => 33,
 :QUOTED => 34,
 :TOKEN => 35,
 "/" => 36,
 "=" => 37 }

racc_use_result_var = true

racc_nt_base = 38

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n,
 racc_use_result_var ]

Racc_debug_parser = false

##### racc system variables end #####

 # reduce 0 omitted

module_eval <<'.,.,', 'mailp.y', 14
  def _reduce_1( val, _values, result )
 @field.date  = val[1]
   result
  end
.,.,

 # reduce 2 omitted

 # reduce 3 omitted

module_eval <<'.,.,', 'mailp.y', 17
  def _reduce_4( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 18
  def _reduce_5( val, _values, result )
 @field.addr  = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 19
  def _reduce_6( val, _values, result )
 @field.addrs.replace val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 20
  def _reduce_7( val, _values, result )
 @field.addr  = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 21
  def _reduce_8( val, _values, result )
 @field.msgid = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 22
  def _reduce_9( val, _values, result )
 @field.keys.replace val[1]
   result
  end
.,.,

 # reduce 10 omitted

 # reduce 11 omitted

 # reduce 12 omitted

 # reduce 13 omitted

 # reduce 14 omitted

module_eval <<'.,.,', 'mailp.y', 30
  def _reduce_15( val, _values, result )
                  mb = val[1]
                  @field.phrase = mb.phrase
                  @field.setroute mb.route
                  @field.local  = mb.local
                  @field.domain = mb.domain
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 38
  def _reduce_16( val, _values, result )
                  mb = val[1]
                  @field.local  = mb.local
                  @field.domain = mb.domain
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 47
  def _reduce_17( val, _values, result )
                  t = Time.gm( val[3].to_i, val[2], val[1].to_i, 0, 0, 0 )
                  result = (t + val[4] - val[5]).localtime
   result
  end
.,.,

 # reduce 18 omitted

 # reduce 19 omitted

module_eval <<'.,.,', 'mailp.y', 56
  def _reduce_20( val, _values, result )
                  result = (val[0].to_i * 60 * 60) +
                           (val[2].to_i * 60)
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 61
  def _reduce_21( val, _values, result )
                  result = (val[0].to_i * 60 * 60) +
                           (val[2].to_i * 60) +
                           (val[4].to_i)
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 68
  def _reduce_22( val, _values, result )
                  result = ::TMail.zonestr2i( result )
   result
  end
.,.,

 # reduce 23 omitted

 # reduce 24 omitted

module_eval <<'.,.,', 'mailp.y', 76
  def _reduce_25( val, _values, result )
                  @field.from = Address.join( val[1] )
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 80
  def _reduce_26( val, _values, result )
                  @field.from = Address.join( val[3] )
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 84
  def _reduce_27( val, _values, result )
                  @field.from = Address.join( val[1] )
   result
  end
.,.,

 # reduce 28 omitted

module_eval <<'.,.,', 'mailp.y', 90
  def _reduce_29( val, _values, result )
                  @field.by = Address.join( val[1] )
   result
  end
.,.,

 # reduce 30 omitted

module_eval <<'.,.,', 'mailp.y', 96
  def _reduce_31( val, _values, result )
                  @field.via = val[1]
   result
  end
.,.,

 # reduce 32 omitted

module_eval <<'.,.,', 'mailp.y', 102
  def _reduce_33( val, _values, result )
                  @field.with.push val[1]
   result
  end
.,.,

 # reduce 34 omitted

module_eval <<'.,.,', 'mailp.y', 108
  def _reduce_35( val, _values, result )
                  @field.msgid = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 112
  def _reduce_36( val, _values, result )
                  @field.msgid = val[1]
   result
  end
.,.,

 # reduce 37 omitted

module_eval <<'.,.,', 'mailp.y', 118
  def _reduce_38( val, _values, result )
                  @field.for_ = val[1].address
   result
  end
.,.,

 # reduce 39 omitted

module_eval <<'.,.,', 'mailp.y', 125
  def _reduce_40( val, _values, result )
                  @field.date = val[1]
   result
  end
.,.,

 # reduce 41 omitted

module_eval <<'.,.,', 'mailp.y', 131
  def _reduce_42( val, _values, result )
                  @field.route.replace result.route
                  @field.addr = result.addr
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 135
  def _reduce_43( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 136
  def _reduce_44( val, _values, result )
 result.push val[2]
   result
  end
.,.,

 # reduce 45 omitted

 # reduce 46 omitted

module_eval <<'.,.,', 'mailp.y', 143
  def _reduce_47( val, _values, result )
                  result = val
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 147
  def _reduce_48( val, _values, result )
                  result.push val[2]
   result
  end
.,.,

 # reduce 49 omitted

 # reduce 50 omitted

module_eval <<'.,.,', 'mailp.y', 154
  def _reduce_51( val, _values, result )
                  val[1].phrase = HFdecoder.decode( result )
                  result = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 160
  def _reduce_52( val, _values, result )
                  result = AddressGroup.new( result, val[2] )
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 166
  def _reduce_53( val, _values, result )
                  result = val[2]
                  result.route = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 171
  def _reduce_54( val, _values, result )
                  result = val[1]
   result
  end
.,.,

 # reduce 55 omitted

module_eval <<'.,.,', 'mailp.y', 176
  def _reduce_56( val, _values, result )
 result = [ val[1] ]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 177
  def _reduce_57( val, _values, result )
 result.push val[3]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 179
  def _reduce_58( val, _values, result )
 result = Address.new( val[0], val[2] )
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 180
  def _reduce_59( val, _values, result )
 result = Address.new( result, nil )
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 182
  def _reduce_60( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 183
  def _reduce_61( val, _values, result )
 result.push val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 185
  def _reduce_62( val, _values, result )
 result = val
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 186
  def _reduce_63( val, _values, result )
 result.push val[2]
   result
  end
.,.,

 # reduce 64 omitted

 # reduce 65 omitted

 # reduce 66 omitted

module_eval <<'.,.,', 'mailp.y', 194
  def _reduce_67( val, _values, result )
                  val[1] = val[1].addr
                  result = val.join('')
   result
  end
.,.,

 # reduce 68 omitted

module_eval <<'.,.,', 'mailp.y', 199
  def _reduce_69( val, _values, result )
 result << ' ' << val[1]
   result
  end
.,.,

 # reduce 70 omitted

 # reduce 71 omitted

 # reduce 72 omitted

 # reduce 73 omitted

 # reduce 74 omitted

module_eval <<'.,.,', 'mailp.y', 210
  def _reduce_75( val, _values, result )
                  @field.encrypter = val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 214
  def _reduce_76( val, _values, result )
                  @field.encrypter = val[0]
                  @field.keyword   = val[1]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 220
  def _reduce_77( val, _values, result )
                  @field.major = val[0].to_i
                  @field.minor = val[2].to_i
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 226
  def _reduce_78( val, _values, result )
                  @field.main = val[0]
                  @field.sub  = val[2]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 231
  def _reduce_79( val, _values, result )
                  @field.main = val[0]
                  @field.sub  = ''
   result
  end
.,.,

 # reduce 80 omitted

module_eval <<'.,.,', 'mailp.y', 238
  def _reduce_81( val, _values, result )
                  @field.params[ val[2].downcase ] = val[4]
   result
  end
.,.,

 # reduce 82 omitted

 # reduce 83 omitted

module_eval <<'.,.,', 'mailp.y', 246
  def _reduce_84( val, _values, result )
                  @field.encoding = val[0]
   result
  end
.,.,

module_eval <<'.,.,', 'mailp.y', 251
  def _reduce_85( val, _values, result )
                  @field.disposition = val[0]
   result
  end
.,.,

 # reduce 86 omitted

 # reduce 87 omitted

 # reduce 88 omitted

module_eval <<'.,.,', 'mailp.y', 261
  def _reduce_89( val, _values, result )
                  @field.params[ val[0].downcase ] = val[2]
   result
  end
.,.,

 # reduce 90 omitted

 # reduce 91 omitted

 # reduce 92 omitted

 # reduce 93 omitted

 # reduce 94 omitted

 # reduce 95 omitted

 # reduce 96 omitted

 def _reduce_none( val, _values, result )
  result
 end

  end   # class Mailp

end   # module TMail
