#! /usr/bin/env ruby

#
# Testcase for parser Features
# 
# Copyright (C) 2001, 2002 by Michael Neumann (neumann@s-direktnet.de)
#
# $Id: test_features.rb,v 1.5 2003/01/25 15:06:44 mneumann Exp $
#

require "runit/cui/testrunner"
require "runit/testcase"
require "./util"
require "xmlrpc/create"
require "xmlrpc/parser"
require "xmlrpc/config"

module XMLRPC
module Config
  ENABLE_NIL_CREATE = true
  ENABLE_NIL_PARSER = true
end
end

class Test_Features < RUNIT::TestCase

  def setup
    @c = [ XMLRPC::Create.new(XMLRPC::XMLWriter::Simple.new),
           XMLRPC::Create.new(XMLRPC::XMLWriter::XMLParser.new) ]

    @p = XMLRPC::XMLParser::Classes.map {|klass| klass.new} 
  end

  def test_nil
    params = [nil, {"test" => nil}, [nil, 1, nil]]

    @c.each do |c| 
      str = c.methodCall("test", *params) 
      @p.each do |p|
        para = p.parseMethodCall(str)
        assert_equal(para[1], params)
      end
    end
  end

end

RUNIT::CUI::TestRunner.run(Test_Features.suite)
