# -*- ruby -*-
#
# Using templates for expanding data.
#

require 'xtemplate'
require 'xtemplate/xml'

data = {
  'members' => [
    {'member' => {'name' => 'name1', '@uid' => 1, 'email' => 'name1@com'}},
    {'member' => {'name' => 'name2', '@uid' => 2, 'email' => 'name2@com'}},
    {'member' => {'name' => 'name3', '@uid' => 3, 'email' => 'name3@com'}},
  ]
}

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<xt:template xmlns:xt="#{XTemplate::BIND_URI}">
<xt:expand id="//member">
  <a href="mailto:@{email}">(<xt:value-of id="@uid" />)<xt:value-of id="name" /></a>
</xt:expand>
<members>
   <xt:select id="/members/member" />
</members>
</xt:template>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
