require 'rubyunit'

require 'dpklib/file'

class TESTCASE_CvsIgnore < RUNIT::TestCase
  def test_it
    assert Dpklib::CvsIgnore.match?("file~")
    assert !Dpklib::CvsIgnore.match?("file")
  end

  def test_gsub_fileext
    assert_equals "aaa.zip", Dpklib.gsub_fileext("aaa.tar", "zip")
    assert_equals "aaa.doc", Dpklib.gsub_fileext("aaa", "doc")
    assert_equals ".dotfile.gz", Dpklib.gsub_fileext(".dotfile", "gz")
  end
end #/TESTCASE_CvsIgnore
