/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIPolicyReference.idl
 */

#ifndef __gen_nsIPolicyReference_h__
#define __gen_nsIPolicyReference_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIURI; /* forward declaration */


/* starting interface:    nsIPolicyReference */
#define NS_IPOLICYREFERENCE_IID_STR "8c51e90d-cbe7-4a2c-b9f3-77bf3af12694"

#define NS_IPOLICYREFERENCE_IID \
  {0x8c51e90d, 0xcbe7, 0x4a2c, \
    { 0xb9, 0xf3, 0x77, 0xbf, 0x3a, 0xf1, 0x26, 0x94 }}

class NS_NO_VTABLE nsIPolicyReference : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IPOLICYREFERENCE_IID)

  /**
   * Main URI or a URI with the same host as the main URI.
   */
  enum { IS_MAIN_URI = 1U };

  /**
   * URI with a domain different from the main URI.
   */
  enum { IS_EMBEDDED_URI = 2U };

  /**
   * URI referenced via LINK tag
   */
  enum { IS_LINKED_URI = 4U };

  /**
   * Signals a successful policy load
   */
  enum { POLICY_LOAD_SUCCESS = 8U };

  /**
   * Signals a policy load failure
   */
  enum { POLICY_LOAD_FAILURE = 16U };

  /**
   * Signals obsolete policy
   */
  enum { POLICY_LIFE_EXPIRED = 32U };

  /**
   * Signals a syntax error ( Ex. xml error ) in the policy.
   */
  enum { POLICY_SYNTAX_ERROR = 64U };

  /**
   * Initialize the object with the document's URI.
   *
   * @param aMailURI -> Current document's URI
   *
   */
  /* void initialize (in nsIURI aMainURI); */
  NS_IMETHOD Initialize(nsIURI *aMainURI) = 0;

  /**
   * Call this method to locate the policy reference file for the current uri.
   *
   * @param aCurrentURI -> URI that requests a privacy policy
   * @paran aFlag       -> IS_SELECTED_URI | IS_EMBEDDED_URI | IS_LINKED_URI
   *
   */
  /* void loadPolicyReferenceFileFor (in nsIURI aCurrentURI, in unsigned long aFlag); */
  NS_IMETHOD LoadPolicyReferenceFileFor(nsIURI *aCurrentURI, PRUint32 aFlag) = 0;

  /**
   * This method releases all the objects used for policy reference.
   *
   */
  /* void finalize (); */
  NS_IMETHOD Finalize(void) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIPOLICYREFERENCE \
  NS_IMETHOD Initialize(nsIURI *aMainURI); \
  NS_IMETHOD LoadPolicyReferenceFileFor(nsIURI *aCurrentURI, PRUint32 aFlag); \
  NS_IMETHOD Finalize(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIPOLICYREFERENCE(_to) \
  NS_IMETHOD Initialize(nsIURI *aMainURI) { return _to Initialize(aMainURI); } \
  NS_IMETHOD LoadPolicyReferenceFileFor(nsIURI *aCurrentURI, PRUint32 aFlag) { return _to LoadPolicyReferenceFileFor(aCurrentURI, aFlag); } \
  NS_IMETHOD Finalize(void) { return _to Finalize(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIPOLICYREFERENCE(_to) \
  NS_IMETHOD Initialize(nsIURI *aMainURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->Initialize(aMainURI); } \
  NS_IMETHOD LoadPolicyReferenceFileFor(nsIURI *aCurrentURI, PRUint32 aFlag) { return !_to ? NS_ERROR_NULL_POINTER : _to->LoadPolicyReferenceFileFor(aCurrentURI, aFlag); } \
  NS_IMETHOD Finalize(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Finalize(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsPolicyReference : public nsIPolicyReference
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIPOLICYREFERENCE

  nsPolicyReference();

private:
  ~nsPolicyReference();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsPolicyReference, nsIPolicyReference)

nsPolicyReference::nsPolicyReference()
{
  /* member initializers and constructor code */
}

nsPolicyReference::~nsPolicyReference()
{
  /* destructor code */
}

/* void initialize (in nsIURI aMainURI); */
NS_IMETHODIMP nsPolicyReference::Initialize(nsIURI *aMainURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void loadPolicyReferenceFileFor (in nsIURI aCurrentURI, in unsigned long aFlag); */
NS_IMETHODIMP nsPolicyReference::LoadPolicyReferenceFileFor(nsIURI *aCurrentURI, PRUint32 aFlag)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void finalize (); */
NS_IMETHODIMP nsPolicyReference::Finalize()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIPolicyReference_h__ */
