#!/bin/sh

SWVERSION=2.96
ARCH=i386
PVER=P1

rm -rf libjconv-2.7
tar zxf libjconv-2.7.tar.gz
cd libjconv-2.7
make CFLAGS="-Wall -O2 -fPIC"
cd ..

rm -rf grip-${SWVERSION}
tar zxf grip+cdpar-${SWVERSION}.tgz
tar zxf grip-${SWVERSION}ja.patch-r3.tgz
cd grip-${SWVERSION}
ln -s ../libjconv-2.7/jconv.h .
ln -s ../libjconv-2.7/libjconv.a .

patch -p1 < grip-${SWVERSION}-jconv.patch
cp grip-${SWVERSION}.po  grip.po
patch -p1 <  grip-${SWVERSION}-gettext.patch
cd cdparanoia
./configure --prefix=/usr
make lib
cd ..
patch <<EOF
--- grip-2.96/grip.c._orig_	2004-05-25 22:58:12.000000000 +0900
+++ grip-2.96/grip.c	2004-05-25 23:15:56.000000000 +0900
@@ -224,9 +224,9 @@
 struct disc_info info;
 DiscData ddata;
 ProxyServer proxy_server={"",8000};
-CDDBServer dbserver={"freedb.freedb.org","~cddb/cddb.cgi",
+CDDBServer dbserver={"ns.w7r.net","~cddb/cddb.cgi/euc",
 		     80,0,&proxy_server};
-CDDBServer dbserver2={"","~cddb/cddb.cgi",
+CDDBServer dbserver2={"freedbtest.dyndns.org","~cddb/cddbeuc.cgi",
 		      80,0,&proxy_server};
 #ifdef SOLARIS
 char *cddevice = NULL;
EOF
patch <<EOF
--- grip.c.orig	2004-05-17 00:52:57.000000000 +0900
+++ grip.c	2004-05-17 00:59:05.000000000 +0900
@@ -55,7 +55,7 @@
 #include "dialog/dialog.h"
 
 #ifdef JCONV
-#include <jconv.h>
+#include "jconv.h"
 #endif // JCONV
 
 #ifdef CDPAR
EOF
patch <<EOF
--- Makefile.orig	2004-05-17 00:52:57.000000000 +0900
+++ Makefile	2004-05-17 00:58:08.000000000 +0900
@@ -34,7 +34,7 @@
 
 # Convert character code
 CFLAGS+=-DJCONV
-LIBS+= -ljconv
+LIBS+= libjconv.a
 
 PARLIBS=	cdparanoia/interface/libcdda_interface.a \\
 		cdparanoia/paranoia/libcdda_paranoia.a
EOF
make

rm -rf ../pkg
mkdir -p ../pkg/usr/bin
mkdir -p ../pkg/usr/man
mkdir -p ../pkg/usr/share/locale/ja/LC_MESSAGES
mkdir -p ../pkg/usr/share/doc/grip-${SWVERSION}

make install PREFIX=`pwd`/../pkg/usr
cp -p ../PlamoBuild.sh C* L* R* T* ../pkg/usr/share/doc/grip-${SWVERSION}
chown -R root:root ../pkg/usr/share/doc/grip-${SWVERSION}

cd ../pkg
mv usr/man usr/share/.
gzip usr/share/man/man1/*.1

/sbin/makepkg grip-${SWVERSION}-${ARCH}-${PVER}.tgz <<EOF
y
y
EOF

