#!/bin/sh

PLAMOARCH=i386
PLAMOVER=P1
PLAMOPREFIX=/usr
GARNOMEVER=2.12.2.1

GARNOME_SITE=http://ftp.gnome.org/pub/GNOME/sources/garnome/2.12/
GARNOME_FILE=download/garnome-$GARNOMEVER.tar.bz2
GARNOME_DIR=garnome-$GARNOMEVER

case "$1" in
clean|-clean|--clean)
    sh tools/resethook.sh
    rm -rf $GARNOME_DIR
    exit 0
    ;;
distclean|-distclean|--distclean)
    sh tools/resethook.sh
    rm -rf $GARNOME_DIR
    rm -f packages/*
    rm -f $GARNOME_FILE
    exit 0
    ;;
esac

TOP_PWD=`pwd`
PLAMODESTDIR=$TOP_PWD/.work/pkgroot

export PLAMOARCH PLAMOVER PLAMOPREFIX TOP_PWD PLAMODESTDIR

if [ -x /bin/install-4.1 ]; then
    INSTALL=/bin/install-4.1
    export INSTALL
fi

if [ ! -f packages/diskgnm ]; then
    (cd packages; perl ../tools/makedesc.pl -d ../files/gnm.desc)
fi

if [ ! -f "$GARNOME_FILE" ]; then
    wget -O "$GARNOME_FILE" "$GARNOME_SITE${GARNOME_FILE##*/}"
fi

if [ ! -d "$GARNOME_DIR" ]; then
    tar jxf $GARNOME_FILE
    tar zxf files/plamo-selection.tar.gz -C $GARNOME_DIR

    for d in `cd $GARNOME_DIR; ls -1 */*/Makefile | sed -e 's/\/Makefile$//'`; do
	grep -v 'include ../category.mk' $GARNOME_DIR/$d/Makefile > $GARNOME_DIR/$d/garnome.mk
	cp tools/Makefile.build $GARNOME_DIR/$d/Makefile
	cp tools/buildpkg.sh $GARNOME_DIR/$d
	if [ -d "hacks/$d" ]; then
	    cp -r hacks/$d/* $GARNOME_DIR/$d
	    if [ -f "$GARNOME_DIR/$d/checksums.ad" ]; then
		cat $GARNOME_DIR/$d/checksums.ad >> $GARNOME_DIR/$d/checksums
	    fi
	fi
    done

    for d in `cat files/packages.nobuild`; do
	cp tools/Makefile.nobuild $GARNOME_DIR/$d/Makefile
    done
fi

for f in `cd $GARNOME_DIR; ls -1 */*/garnome.mk`; do
    d=${f%/garnome.mk}
    pkg=`grep '^GARNAME' $GARNOME_DIR/$f | sed -e 's/^GARNAME *= *//' | tr A-Z+- a-zp_`
    if [ -f "/var/adm/packages/$pkg" ]; then
	cp tools/Makefile.nobuild $GARNOME_DIR/$d/Makefile
    fi
done

mkdir .work
chown 0:0 .work
chmod 755 .work

. tools/sethook.sh

if [ -n "$1" ]; then
    if [ -d "$GARNOME_DIR/$1" ]; then
	cp tools/Makefile.build $GARNOME_DIR/$1/Makefile
	(cd $GARNOME_DIR/$1; make cookieclean plamopackage)
    else
	echo "$1 not found!"
    fi
else
    (cd $GARNOME_DIR; make paranoid-plamopackage)
fi

. tools/resethook.sh

rmdir .work
