#!/bin/sh
#
# ƻإե θե ؤ v1.3
# Copyright (C) 1999-2002 Kyoichiro Suda
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# \
exec wish "$0" "$@"

wm title . {OYATU v1.3}
############################################################
#
# ܡɤξ
#

#============================================================
#
# ɤ

# ˥塼ѤΥꥹ
set menu_kbd { { "jp106 ̵ѴѴ" "jp106" "131" "129"
	"106ܡɤȡƻإեȤ̵ѴѴȤäŪ" }
               { "jp106 Ѵ"   "jp106"  "65" "129"
	"106ܡɤȡƻإեȤ˶Ӥôʤ" }
	       { "KB211 ֡"   "211"    "23"  "65"
	"ƻإեѥܡɤȡεǽ򤱤" }
	       { "Towns ̵ѴѴ"   "towns-jis"    "29"  "28"
	"FM-Towns  JIS ܡɤȡѴ̵ѴȤä" }}

# 106ܡɤ
set kbd_code(jp106) {
    49 10 11 12 13 14 15 16 17 18 19 20 21 133 22
    23 24 25 26 27 28 29 30 31 32 33 34 35 36
    66 38 39 40 41 42 43 44 45 46 47 48 51 ""
    50 52 53 54 55 56 57 58 59 60 61 123 62
    37 64 "" "" "" 65 120 113 109
}
# FMV-KB211
set kbd_code(211) {
    49 10 11 12 13 14 15 16 17 18 19 20 21 133 51
    "" 24 25 26 27 28 29 30 31 32 33 48 35 36
    66 38 39 40 41 42 43 44 45 46 47 22  9 34
    50 52 53 54 55 56 57 58 59 60 61 123 62
    37 64 23 "" "" 65 120 113 109
}
# FM-Townsѥܡɤ
set kbd_code(towns-jis) {
    27 49 50 51 52 53 54 55 56 57 48 189 222 220 8
    "" 81 87 69 82 84 89 85 73 79 80 255 219 13
    17 65 83 68 70 71 72 74 75 76 187 186 221 ""
    16 90 88 67 86 66 78 77 188 190 191 223 ""
    "" "" 20 29 28 32 240 "" 3
}

#============================================================
#
# 

# ܡɤοå
# {Ͽ̾  ʸ    ƻإե  ̾}
set skb_color_set(white) {
    "WHITE-BASE"
    "WhiteSmoke" "black"
    "gainsboro" "LightGray" "snow3" "seashell3"
    "gray" oyatu_label
}
set skb_color_set(gray) {
    "Gray Townes"
    "gray44" "white"
    "gray55" "gray44" "gray30" "gray24"
    "gray" oyatu_label_old
}

#============================================================
#
# ǥ
wm geometry . 640x400

# η()λ
set skb_width_map {
    1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
    1.5 1 1 1 1 1 1 1 1 1 1 1 1 1.5
    1.8 1 1 1 1 1 1 1 1 1 1 1 1 1.2
    2.3 1 1 1 1 1 1 1 1 1 1 1 1.75
    1.5 1.5 1.5 2.35 2.35 1.8 1.4 1.25 1.5
}

# 
set skb_color(map) {
    3 1 1 1 1 1 2 2 2 2 2 2 2 2 2
    3 1 1 1 1 1 2 2 2 2 2 2 2 3
    3 1 1 1 1 1 2 2 2 2 2 3 3 2
    3 1 1 1 1 1 2 2 2 2 2 2 3
    3 3 3 4 4 3 3 3 3
}

# ƻإեȤΥǥå
set skb(nicola_L) 59
set skb(nicola_R) 60

#============================================================
#
# ȥåɽʸȥ׻νʸ

# ʥ⡼̾ʸ (2ɽѤˤϲԤ򺮤Ƥ)
set map(nicola_N) {
    {Ⱦ/
}        1  2  3  4  5  6  7  8  9  0  -  "" ""
    ѻ               ,    {Enter
}
    {Caps Lock
Ѿʸ}             ""
    { ե}    .          "" { ե}
    {Ctrl
ĥǽ} Alt  ƻغ ƻر  {
Ҥ餬} Alt {Ctrl
ĥǽ}
}
# ʥ⡼̾ν
set char(nicola_N) {
    ""  1  2  3  4  5  6  7  8  9  0  -  "" ""
    ""          ,    ^m
    ""           ^h ^c ""
    ""  .          "" ""
    "" "" ^i "" ""   " "   "" "" ""
}

# ʥ⡼ɿƻغʸ
set map(nicola_L) {
    {Ⱦ/
}        ?  /  ~   [  ]  (  )     "" ""
    ѻ               "" ""  {Enter
}
    {Caps Lock
Ѿʸ}          ""   ""
    { ե}            "" "" { ե}
    {Ctrl
ĥǽ} Alt  ƻغ ƻر  {
Ҥ餬} Alt {Ctrl
ĥǽ}
}
set char(nicola_L) {
    ""  ?  /  ~   [  ]  (  )     "" ""
    ""           "" "" ^m
    ""          "" ^h ^c ""
    ""          "" "" ""
    "" "" ^i "" ""  " "  "" "" ""
}

# ʥ⡼ɿƻرʸ
set map(nicola_R) {
    {Ⱦ/
}         ?  /  ~   [  ]  (  )     "" ""
    ѻ     ""             {Enter
}
    {Caps Lock
Ѿʸ}             ""
    { ե}   ""           { ե}
    {Ctrl
ĥǽ} Alt  ƻغ ƻر  {
Ҥ餬} Alt {Ctrl
ĥǽ}
}
set char(nicola_R) {
    ""  ?  /  ~   [  ]  (  )     "" ""
    "" ""            ^m
    ""           ^h ^c ""
    "" ""           ""
    "" "" ^i "" ""  " "  "" "" ""
}

# ʥ⡼ɥեʸ
set map(nicola_S) {
    {Ⱦ/
}         1  2  3  4  5  6  7  8  9  0  -  "" ""
    ѻ              ,    {Enter
}
    {Caps Lock
Ѿʸ}             ""
    { ե}    .          "" { ե}
    {Ctrl
ĥǽ} Alt  ƻغ ƻر  {
Ҥ餬} Alt {Ctrl
ĥǽ}
}
set char(S) {
    ""     1  2  3  4  5  6  7  8  9  0  -  "" ""
    ""              ,    ^m
    ""           ^h ^c ""
    ""    .          "" ""
    "" "" ^i "" "" " " "" "" ""
}

# ѿ⡼̾ʸ
set map(ascii_N) {
    {Ⱦ/
}         1  2  3  4  5  6  7  8  9  0  -  ^ "" \]
    ѻ      q  w  e  r  t  y  u  i  o  p  : \[ {Enter
}
    {Caps Lock
Ѿʸ}  a  s  d  f  g  h  j  k  l  ;    @
    { ե}    z  x  c  v  b  n  m  ,  .  / \\ { ե}
    {Ctrl
ĥǽ} Alt  ƻغ ƻر  {
Ҥ餬} Alt {Ctrl
ĥǽ}
}
set char{ascii_N} {
    ""  1  2  3  4  5  6  7  8  9  0  -  ^ "" \]
    ""  q  w  e  r  t  y  u  i  o  p  : \[ ^m
    ""  a  s  d  f  g  h  j  k  l  ; ^h ^c  @
    ""  z  x  c  v  b  n  m  ,  .  / \\ ""
    "" "" ^i "" "" " " "" "" ""
}

## Ⱦѥơ֥
#set char(half) {,.:;?!-/\'`"~_()[]\{\}+-=<>$%#&*@0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz}
#set char(full){ʡˡΡϡСѡܡݡ£ãģţƣǣȣɣʣˣ̣ͣΣϣУѣңӣԣգ֣ףأ٣ڣ}

#============================================================
#
# ľϤѴơ֥ (񤷤)

# ơ֥ϴñեȼʤɤΥɽؤʤα

#============================================================
#
# ֤Υơ֥ȽϢ

# Υ٥(ǥå)
set map(L0) {  0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 }
set map(L1) { 15 16 17 18 19 20 21 22 23 24 25 26 27 28 }
set map(L2) { 29 30 31 32 33 34 35 36 37 38 39 40 41 42 }
set map(L3) { 43 44 45 46 47 48 49 50 51 52 53 54 55 }
set map(L4) { 56 57 58 59 60 61 62 63 64 }
# νޤ
set map(L9) [concat $map(L0) $map(L1) $map(L2) $map(L3) $map(L4)]

# ܡɥ˥塼饭ܡɤʬ
proc menu_set_kbd {} {
    global menu_kbd kbd_go
    set type     [lindex $menu_kbd $kbd_go]
    set kbd_type [lindex $type 1]
    set L_code   [lindex $type 2]
    set R_code   [lindex $type 3]
    set_kbd $kbd_type $L_code $R_code
    #set comment  [lindex $type 4]
}

# ܡɤΥ
proc set_kbd { kbd_type L_code R_code } {
    global kbd map kbd_code nicola skb
    set kbd $kbd_type
    # ɤȰ֤б
    foreach w $map(L9) {
	set skb([lindex $kbd_code($kbd) $w]) $w
    }
    # ƻإեȤΥ
    set nicola(L_code) $L_code
    set nicola(R_code) $R_code
}

## ɤ٥(ǥå)Ѵ
#proc code2index { kcode } {
#    global skb
#    return [array names skb $kcode]
#}
## ľܥɤʸѴ
#proc code2let { m kcode } {
#    global char skb
#    set idx [array names skb $kcode]
#    if { $idx != "" } {
#	return [lindex char($m) $idx ]
#    }
#}

# ɽʸΥꥹȤʬ򤷡ȥåפɽʸѿȤ
proc leton { nicola_shift } {
    global map let
    foreach w $map(L9) {
	set let($w) [lindex $map($nicola_shift) $w]
    }
}

# äɸ˽
leton "nicola_N"
# Ͼ
set status ""

############################################################
#
# ̹ (˥塼ΤߺǸ)
#

# ե
switch $tcl_platform(platform) {
    unix {
	font create typing -family fixed -size 13
	font create k_mini -family fixed -size 8
	font create k_norm -family fixed -size 13
	font create medium -family fixed -size 11
	#font create typing -compound { r16 k16 }
	#font create k_mini -compound { r10 k10 }
	#font create k_norm -compound { r16 k16 }
	#font create medium -compound { r14 k14 }
    }
    windows {
	font create typing -family {ͣ å} -size 13
	font create k_mini -family {ͣ å} -size 8
	font create k_norm -family {ͣ å} -size 13
	font create medium -family {ͣ å} -size 11
    }
}

#============================================================
#
# եȥܡɤɽ

# ܡɥե졼
set p .kbd
#frame $p -bg $skb_color(bg) -relief groove -borderwidth 7
frame $p -relief groove -borderwidth 7

# ȥåץ,
set x 7 ; set y 30 ; set gw 3
# ȥåץ,
set keys 38 ; set keyc 1

# 
set p $p.frm
frame $p -relief flat -bg black
place $p -x $x -y $y \
	-width  [expr ($keys + $keyc) * 15 + $keyc + [expr $gw * 2]] \
	-height [expr ($keys + $keyc) *  5 + $keyc + [expr $gw * 2]]

# ȥå
set y [expr $keyc + $gw]
foreach { L } { L0 L1 L2 L3 L4 } {
    set x [expr $keyc + $gw]
    foreach { w } $map($L) {
	# եȤ羮ؤˤȤꤢۿή
	if { [lindex $skb_color(map) $w] != 3 } {
	    label $p.$w -relief raised -borderwidth [expr $keys / 5] \
		    -textvariable let($w) -font k_norm
	} else {
	    label $p.$w -relief raised -borderwidth [expr $keys / 5] \
		    -textvariable let($w) -font k_mini
	}
	# å˥ɤäƤ
	eval {bind $p.$w <ButtonRelease-1>} \{ m_keyf $w \}
	place $p.$w -x $x -y $y \
		-width [expr $keys * [lindex $skb_width_map $w]] -height $keys
	set x [expr $x + [expr $keys * [lindex $skb_width_map $w]] + $keyc]
    }
    set y [expr $y + $keys + $keyc]
}
# Ĵ
$p.$skb(nicola_L) configure -borderwidth [expr $keys / 4]
$p.$skb(nicola_R) configure -borderwidth [expr $keys / 4]

# ܡɰ,
place .kbd -x 8 -y 110 -width 624 -height 252

#============================================================
#
#  OYATU

image create bitmap oyatu_label -data "
#define oyatu_width 64
#define oyatu_height 24
static char oyatu_bits[] = {
 0x00,0x00,0x00,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0x07,0x00,0x00,
 0x00,0x00,0x00,0x00,0x60,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,
 0x00,0x00,0x00,0x00,0x00,0x0e,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x0c,
 0x00,0x00,0x00,0x00,0x00,0x00,0x71,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0xe3,
 0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0xf8,0xe1,0x80,
 0x83,0xc1,0xff,0x79,0xf0,0x9e,0xc7,0xc1,0x81,0xe1,0xff,0x73,0x70,0x06,0xc6,
 0xc1,0xc1,0x23,0x1c,0x72,0x70,0x07,0x8e,0xe3,0xc0,0x03,0x1c,0x70,0x70,0x07,
 0x0e,0x63,0xe0,0x07,0x1c,0x70,0x70,0x07,0x0e,0x77,0xe0,0x07,0x1c,0x70,0x70,
 0x07,0x0e,0x3e,0x60,0x06,0x1c,0x70,0x70,0x07,0x0e,0x3e,0x70,0x0e,0x1c,0x70,
 0x70,0x07,0x0e,0x1c,0x30,0x0c,0x1c,0x70,0x70,0x07,0x0e,0x1c,0xf8,0x1f,0x1c,
 0x70,0x70,0x07,0x0e,0x1c,0x38,0x1c,0x1c,0x70,0x70,0x07,0x0e,0x1c,0x38,0x1c,
 0x1c,0x70,0x70,0x06,0x06,0x1c,0x1c,0x38,0x1c,0x60,0x30,0x9e,0x07,0x1c,0x1c,
 0x38,0x1c,0xe0,0x38,0xf8,0x01,0x3e,0x1e,0x78,0x3e,0x80,0x0f};
"
image create bitmap oyatu_label_old -data "
#define oyatu_old_width 64
#define oyatu_old_height 24
static char oyatu_old_bits[] = {
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x0c,0xc3,
 0xf0,0xef,0x38,0x00,0x00,0xfe,0x9d,0xc3,0xf0,0xef,0x38,0x00,0x00,0xce,0x99,
 0xe1,0xb1,0xcd,0x18,0x00,0x00,0x86,0xf9,0xe1,0x81,0xc1,0x18,0x00,0x00,0x86,
 0xf1,0x30,0x83,0xc1,0x18,0x00,0x00,0x86,0x61,0x30,0x83,0xc1,0x18,0x00,0x00,
 0xce,0x61,0xf8,0x87,0xc1,0x18,0x00,0x00,0xfe,0xf1,0x1c,0xce,0xc3,0x1f,0x00,
 0x00,0xfc,0xf0,0x1c,0xce,0x83,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
"

label .kbd.logo -image oyatu_label -relief flat -borderwidth 0
place .kbd.logo -x 7 -y 3

#============================================================
#
# ⡼ɽ
#set modeview {Ⱦ }

label .kbd.mode -relief sunken -bg "SlateBlue2" -fg "White" \
	-borderwidth 1 -width 8 -padx 1 -pady 2 \
	-textvariable modeview -font medium
place .kbd.mode -x 505 -y 3

#============================================================
#
# 

# åȤκǽν
proc skb_col_init {} {
    global skb_color_set skb_color skb_color_sel
    if { [array size skb_color_set] < 1 } {
	# åȤꤵƤʤ
	puts "顼: 顼åȤޤ"
	exit 0
    } else {
	foreach set [array names skb_color_set] {
	    # 
	    set i 0
	    foreach sect { name bg fg 1 2 3 4 logo xbm } {
		set skb_color($set,$sect) [lindex $skb_color_set($set) $i]
		set i [expr $i + 1]
	    }
	}
	# ϿƤǽΰĤ
	set skb_color_sel [lindex [array names skb_color_set] 0]
	skb_col_set
}   }
# Ƥ
proc skb_col_set {} {
    # ܡ
    .kbd configure -bg [skb_col_get "bg"]
    for { set w 0 } { $w <= 64 } { incr w } {
	.kbd.frm.$w configure -bg [skb_col_get $w] -fg [skb_col_get "fg"]
    }
    .kbd.logo configure -image [skb_col_get "xbm"]
    [skb_col_get "xbm"] configure \
	    -background [skb_col_get "bg"] -foreground [skb_col_get "logo"]
}
#proc skb_col_set_key { w } {
#    # ΥΤ
#    .kbd.frm.$w configure -bg [skb_col_get $w] -fg [skb_col_get "fg"]
#}
# ܡɤο
proc skb_col_get { i } {
    global skb_color skb_color_sel
    # ʿ,طʿ,ǥåˤ
    if { $i < "A" } {
	set i [lindex $skb_color(map) $i]
    }
    return $skb_color($skb_color_sel,$i)
}

#============================================================
#
# ͳɽ

# ͳ
set line {ؤ ƻإե 塼ȥꥢ}
message .line -relief sunken -borderwidth 4 -padx 2 -pady 4 \
        -width 600 -bg white -textvariable line -justify left
place .line -x 20 -y 360 -width 600 -height 30

#============================================================
#
# ܡɤɽ

# 
frame .board -relief ridge -bg "SlateBlue2" \
	-borderwidth 3 -width 560
message .board.q -relief flat -bg "SlateBlue2" -fg "White" \
	-textvariable board_q -width 540 -font typing
message .board.a -relief flat -bg "SlateBlue2" -fg "White" \
	-textvariable board_a -width 540 -font typing
message .board.s -relief flat -bg "SlateBlue2" -fg "White" \
	-textvariable board_s -width 540
place .board -x 40 -y 6 -width 560 -height 100
place .board.q -x 10 -y 1 -width 540 -height 50
place .board.a -x 10 -y 42 -width 540 -height 50

#============================================================
# about ؤ
proc about {} {
    global line
    set line {ؤ ƻإե 塼ȥꥢ}
}

############################################################
#
# Ͻ
#

#============================================================
#
# ϤΥեå

bind all <Key>             { keyf %k }
bind all <KeyRelease>      { key_release %k }
bind all <ButtonPress-2>   { nicola_on nicola_L }
bind all <ButtonPress-3>   { nicola_on nicola_R }
bind all <ButtonRelease-2> { nicola_off nicola_L }
bind all <ButtonRelease-3> { nicola_off nicola_R }

#============================================================
#
# ޤ륭

bind all <Control-m> { input "^M" }
bind all <Control-M> { input "^M" }
bind all <Control-h> { input "^H" }
bind all <Control-H> { input "^H" }
bind all <Control-j> { input "^J" }
bind all <Control-J> { input "^J" }
bind all <Control-q> { exit 0 }
bind all <Control-Q> { exit 0 }

#============================================================
#
# ƻإեȥߥ졼 (ϴ)

# ʸȽ롼
proc keyf { kcode } {
    global status nicola line skb
    ## Ĵ
    # global modeview
    #set modeview $kcode
    #puts "Υ: $kcode"
    # ʸȥեȤ򿶤ʬ
    if     { $kcode == $nicola(L_code) } { nicola_on nicola_L } \
    elseif { $kcode == $nicola(R_code) } { nicola_on nicola_R } \
    else   {
	# ƻإեȤäƤФ
	if       { $status == "nicola_L" } {
	    after 500 type_off
	    after 500 leton "nicola_N"
	    set status $kcode
	    putlet "nicola_L"
	} elseif { $status == "nicola_R" } {
	    after 500 type_off
	    after 500 leton "nicola_N"
	    set status $kcode
	    putlet "nicola_R"
	} else {
	    if { $status != "" } {
		# õ򺣹Ԥʤ
		after cancel leton "nicola_N"
		leton "nicola_N"
		# եԤʸɤФ
		putlet "nicola_N"
	    }
	    # եȽԤ
	    set status $kcode
	    after 150 putlet "nicola_N"
}   }   }

# դ
proc key_release { kcode } {
    global nicola
    # ƻإեȤβǧ
    if     { $kcode == $nicola(L_code) } { after 200 nicola_off nicola_L } \
    elseif { $kcode == $nicola(R_code) } { after 200 nicola_off nicola_R }
}

# סʸβ
proc putlet { nicola_shift } {
    global status char skb
    # ٱβ
    after cancel putlet "nicola_N"
    type_on
    after 500 type_off
    # ɤбʸѰդƤʤ
    if { [array names skb $status] == "" } return
    # ʸߤ
    set let [lindex $char($nicola_shift) $skb($status)]
    input $let
    # β
    set status ""
}

#============================================================
#
# ޥˤ

# νꡢɽǥեȲǤƤʤ

proc m_keyf { kindex } {
    global status
    if       { $status == "nicola_L" } {
	type_off
	nicola_on nicola_L
	m_putlet "nicola_L" $kindex
    } elseif { $status == "nicola_R" } {
	type_off
	nicola_on nicola_R
	m_putlet "nicola_R" $kindex
    } else {
	leton "nicola_N"
	m_putlet "nicola_N" $kindex
}   }
# ʸ ޥ
proc m_putlet { shift kindex } {
    global status char
    # ʸߤ
    set let [lindex $char($shift) $kindex]
    input $let
    # β
    set status ""
}

#============================================================
#
# ƻإեȥߥ졼 (եȾִ)

# ƻإեȤν
proc nicola_on { nicola_shift } {
    global status
    # ꤵ줿եȤФ륷եȤΥơ֥
    set nicola_pair(nicola_L) nicola_R
    set nicola_pair(nicola_R) nicola_L
    # եٱβ
    after cancel nicola_off $nicola_shift
    # õβ
    after cancel leton "nicola_N"
    # եȾ֤Ƚ
    if { $status != $nicola_shift } {
	leton $nicola_shift
	if { $status == $nicola_pair($nicola_shift) } {
	    type_off
	    set status $nicola_shift
	    type_on
	} elseif { $status == "" } {
	    set status $nicola_shift
	    type_on
	} else {
	    # ʸν
	    putlet $nicola_shift
	    set status $nicola_shift
	    # ƻإեȤξ֤򤷤Ф餯ɽ
	    type_on
	    after 500 type_off
	    after 500 leton "nicola_N"
	    # ˥եȤβ
	    set status {}
}   }   }

# եȾ֤β
proc nicola_off { nicola_shift } {
    global status
    after cancel nicola_off $nicola_shift
    # ƻإեȤΥơפ˲
    if { $nicola_shift == "" || $status == $nicola_shift } {
	type_off
	set status ""
	# ɽʸ᤹
	leton "nicola_N"
}   }

#============================================================
#
# ưȽ䤹

# 򲡤ɽ
set type_key {}
proc type_on {} {
    global status skb type_key
    # ѰդƤʤɤϤϤͤ
    if { [array names skb $status] == "" } return
    set k $skb($status)
    .kbd.frm.$k configure -bg LightSkyBlue -fg salmon
    # ƤɽΥɲ
    set type_key [concat $type_key $k]
}
proc type_off {} {
    global type_key skb_color
    if { $type_key != "" } {
	set k [lindex $type_key 0]
	.kbd.frm.$k configure \
		-bg [skb_col_get $k] -fg [skb_col_get "fg"]
	set type_key [lrange $type_key 1 end]
}   }

# ҥѤΥϥ饤Ƚ
set hint_key {nohint}
proc type_hint { a } {
    global char skb hint_key
    # ˥ϥ饤ȤƤʤ
    if { $hint_key != "" } return
    # Ԥʸ饤ǥå
    foreach s { nicola_N nicola_R nicola_L } {
	set k [lsearch $char($s) $a]
	if { $k > 0 } break
    }
    #puts "ǥХå: ҥȥϥ饤: ǥå $k"
    if { $k < 1 } return
    # ʸΥϥ饤
    .kbd.frm.$k configure -bg salmon -fg LightSkyBlue
    if { $s != "nicola_N" } {
    .kbd.frm.$skb($s) configure -bg salmon -fg LightSkyBlue
    }
    # ٱϥ饤ȥ
    set hint_key "$s $k"
    after 2000 type_hint_off
}
proc type_hint_off {} {
    global hint_key skb skb_color
    # 
    if { [llength $hint_key] < 2 } { 
	#puts "ͽƤ륨顼: ϥ饤ȥ: $hint_key"
	return
    }
    # ʣϲ򤷤ƤĤʤ
    after cancel type_hint_off
    # եȼȥǥåʬ
    set s [lindex $hint_key 0]
    set k [lindex $hint_key 1]
    .kbd.frm.$k configure -bg [skb_col_get $k] -fg [skb_col_get "fg"]
    if { $s != "nicola_N" } {
	.kbd.frm.$skb($s) configure \
	                  -bg [skb_col_get $k] -fg [skb_col_get "fg"]
    }
    # Ѥ
    set hint_key {}
}
############################################################
#
# ܡɽؤȤʬ(­ꤺ)

# ʬΤ
proc input { let } {
    global lesson_go
    #puts "ǥХå: input: lesson_go $lesson_go"
    if { $lesson_go == -1 } {
	input_free   $let
    } else {
	input_lesson $let
    }
}
# ͳϤ
proc input_free { let } {
    if { $let == "" } return
    switch -- $let {
	"^m" -
	"^M" -
	"^j" -
	"^J" { f_clear }
	"^h" -
	"^H" { f_back }
	"^i" -
	"-I" { f_puts "	" }
	default { f_puts $let }
    }
}
# 
proc input_lesson { let } {
    if { $let == "" } return
#    switch $let {
#	"^m" -
#	"^M" -
#	"^j" -
#	"^J" { q_next }
#	"^h" -
#	"^H" { }
#	"^i" -
#	"-I" {}
#	default { q_ans $let }
#    }
q_ans $let
}

############################################################
#
# ͳͽ
#

proc f_init {} {
    f_clear
    clipboard clear
}
# ϰ(ϲ)Υꥢ
proc f_clear {} {
    global line
    set line ""
    clipboard clear
}
# 
proc f_back {} {
    global line tcl_platform
    switch $tcl_platform(platform) {
	unix { set l [string length $line] }
	windows { set l [string length $line] }
    }
    if { $l == 1 } {
	set line ""
    } elseif { $l > 1 } {
	switch $tcl_platform(platform) {
	    unix { set line [string range $line 0 [expr $l - 2] ] }
	    windows { set line [string range $line 0 [expr $l - 2] ] }
	}
    }
    clipboard clear
    clipboard append $line
}
# 
proc f_puts { let } {
    global line
    set line $line$let
    clipboard clear
    clipboard append $line
}

############################################################
#
# 
#
# 1Ĥե 1Ĥꥰ롼פ q
# 1Ĥꥰ롼פʣ         lesson
# 1ĤȲȰǹ     number
# οʹԤˤϲʸ֤Ȥ                locate

#============================================================
#
# եȤư (ϵǽɲ)

set lesson_max 0
# Υ
proc q_load { q_file } {
    global q q_entry q_intro q_number lesson_max
    set id [open $q_file r]
    gets $id header
    close $id
    if { $header != "#OYATU" } {
	puts "顼: : OYATU եǤϤޤ"
	tk_messageBox -icon error -message "Υեϡؤ٤α齬ϿեǤϤޤ" -parent . -title "OYATU: file loading error." -type ok
	return -1
    }
    # $l ˾Ĺ $lesson_max 
    set l $lesson_max
    # ե
    set lesson {}
    source $q_file
    if { $lesson == {} } {
	puts "顼: : ե lesson ޤޤޤ"
	tk_messageBox -icon error -message "Υեˤ꤬ޤޤƤʤޤҤƤޤ" -parent . -title "OYATU: file loading error." -type ok
	return -1
    }
    # ǡˤ
    set q_entry($l) [lindex [lindex $lesson 0] 0]
    set q_intro($l) [lindex [lindex $lesson 0] 1]
    for { set i 1 } { $i < [llength $lesson] } { incr i } {
	#  1åȽ
	set lesson_set [lindex $lesson $i]
	if { [llength $lesson_set] >= 3 } {
	    # ̤λ
	    set q($l,$i,stage)   [lindex $lesson_set 0]
	    set q($l,$i,script)  [lindex $lesson_set 1]
	    #set q($l,$i,narrate) [lindex $lesson_set 2]
	    # ɤϰ־
	    set q($l,$i,narrate) [guide_init [lindex $lesson_set 1] \
					     [lindex $lesson_set 2]]
	} elseif { [llength $lesson_set] == 2 } {
	    # ά
	    set q($l,$i,stage)   [lindex $lesson_set 0]
	    set q($l,$i,script)  [lindex $lesson_set 1]
	    set q($l,$i,narrate) {}
	} elseif { [llength $lesson_set] == 1 } {
	    # ά
	    set q($l,$i,stage)   [lindex $lesson_set 0]
	    set q($l,$i,script)  {%S}
	    set q($l,$i,narrate) {}
	} else {
	    # ά
	    set q($l,$i,stage)   "$q_entry($l)"
	    set q($l,$i,script)  {%S}
	    set q($l,$i,narrate) {}
	}
    }
    # 
    set q_number($l) [expr $i - 1]
    # 򥤥󥯥
    set lesson_max [expr $l + 1]
}

# ե륻쥯Ȥäƥ(˥塼ˤϻĤʤ)
proc tk_q_load {} {
    global lesson_max lesson_go
    set q_file [tk_getOpenFile \
	    -filetypes {{"Lesson tcl" .oyatu} {"All Files" *}} \
	    -title "ե뤫"]
    if { $q_file != "" } {
	# ɤ֤ͤ򸫤Ƚ
	set OK [q_load $q_file]
	if { $OK != -1 } {
	    set lesson_max [expr $lesson_max - 1]
	    set lesson_go $lesson_max
	    q_init
	}
    }
}

#============================================================
#
# ʬ 

# ν
proc q_init { } {
    global q lesson_go number_go q_entry q_intro board_q a_wait
    # Ͽ̵
    if { [array names q_entry $lesson_go] == "" } {
	puts "顼: $lesson_go бϿʤƤޤ"
	puts "ƥ1: [array names q_entry]"
	puts "ƥ2: $q_entry($lesson_go)"
	return 1
    }
    if { $q_intro($lesson_go) != "" } {
	## ҲʸɽԤ
	#set board_q "$q_intro($lesson_go)"
	#set a_wait {}
	#puts_answer_pause
	#set number_go 0
	# ҲʸɽԤ
	puts_answer_pause "$q_intro($lesson_go)"
	set number_go 0
    } {
	# ̵лϤ Ǥ 1
	q_set $losson_go 1
    }
}

# 
proc q_set { lesson number } {
    global q number_go board_q q_number arrange_mode
    # Υƥ
    if { $q_number($lesson) < $number } {
	#puts "ǥХå: q_set:  q_number $q_number($lesson), number $number"
	set number 1
    }
    # ֹϿ
    set number_go $number
    # ɽ
    set board_q "$q($lesson,$number,stage)"
    # ɽõ
    puts_answer_clear
    # ֤ν
    set q_locate 0
    # ɤɽ
    q_guide $lesson $number 0
    # ʸ֤β
    set arrange_mode {}
    # Ԥν
    a_set 0
}

# ɽ
proc q_guide { lesson number locate } {
    global q
    # μ
    set narrate $q($lesson,$number,narrate)
    # ʤʤ
    if { $narrate == "" } return
    # Ȥꤢ¤ٴ
    array set guide $narrate
    # ޡ
    set guide($locate.5) {nattate left of me}
    set j [lsort -real [array names guide]]
    set i [lsearch $j $locate.5]
    #puts "ǥХå0: : [array names guide]"
    #puts "ǥХå1: : $j"
    #puts "ǥХå2: : $i"
    if { $i < 1 } return
    puts_message $guide([lindex $j [expr $i - 1]])
}

# ɽ (ե륿)
proc guide_init { script guide } {
    global tcl_platform
    #puts "ǥХå: guide_init: script $script"
    set g_idx 0
    set s_loc 0
    set f_loc 0
    # do while ̵Τǡ
    while { $f_loc >= 0 } {
	# %M ΰ
	switch $tcl_platform(platform) {
	    unix {
		set f_loc [string first "%M" \
			[string range $script $s_loc end]]
	    }
	    windows {
		set f_loc [string first "%M" \
			[string range $script $s_loc end]]
	    }
	}

	# ɽ
	set k_start $s_loc
	set k_find 0
	# %K  %M ֤ǤϽǤʤ
	if { $f_loc < 0 } {
	    set k_end [string length $script]
	} else {
	    set k_end [expr $f_loc - 2]
	}
	while { $k_end >= 0 && $k_find >= 0 } {
	    #  %K ΰ֤򸫤Ƥ
	    switch $tcl_platform(platform) {
		unix {
		    set k_find [string first "%K" \
				[string range $script $k_start $k_end]]
		}
		windows {
		    set k_find [string first "%K" \
				    [string range $script $k_start $k_end]]
		}
	    }
	    if { $k_find >= 0 } {
		set guide [linsert $guide $g_idx {}]
		set guide [linsert $guide $g_idx [expr $k_start + $k_find]]
		set g_idx [expr $g_idx + 2]
		set k_start [expr $k_start + $k_find + 2]
	    }
	}

	if { $f_loc >= 0 } {
	    #puts "ǥХå: guide_init: g $g_idx s $s_loc f $f_loc"
	    set guide [linsert $guide $g_idx [expr $s_loc + $f_loc]]
	    set g_idx [expr $g_idx + 2]
	    set s_loc [expr $s_loc + $f_loc + 2]
	}
    }
    #puts "ǥХå: guide_init: return $guide"
    return $guide
}

# δͤ
proc a_set { locate } {
    global q a_wait lesson_go number_go a_locate \
	    arrange_mode space_mode dlm_mode tcl_platform
    # ץȤγ
    set script $q($lesson_go,$number_go,script)
    # ξʸ򤽤Τޤ޻Ȥ
    if { $script == "" } {
	set script $q($lesson_go,$number_go,stage)
    }
    # ޤʸ
    switch $tcl_platform(platform) {
	unix { set s [string range $script $locate $locate] }
	windows { set s [string range $script $locate $locate] }
    }
    # ִ
    if { $s == "," || $s == "" || $s == "" || \
	    $s == "." || $s == "" || $s == "" } {
	set s [a_set_dlm $s]
    }
    # äʸνλǧ
    if { $s == "" } {
	set locate [expr $locate + 1]
	puts_answer_end
	# Ԥ򽪤ƲԤԤ
	set s {}
    } elseif { $s == " " && $space_mode == "AUTO" } {
	## ʬưϤ
	set s "%0"
    } elseif { $s == "%" } {
	# ü쵭ν
	set locate [expr $locate + 1]
	switch $tcl_platform(platform) {
	    unix { set s [string range $script $locate $locate] }
	    windows { set s [string range $script $locate $locate] }
	}
	set s [a_set_arrange $s]
	if { $s == -1 } {
	    set locate [a_set [expr $locate + 1]]
	    return
	}
    }
    if { $s == "%0" } {
	# ѤʤΤǼưϤΤ߽
	a_arrange 0
	set locate [a_set [expr $locate + 1]]
	return
    }
    # 褦䤯Ԥʸ˻
    set a_wait $s
    # ֤¸
    set a_locate $locate
    return $locate
}
# script 
proc a_set_arrange { s } {
    global arrange_mode
    switch "$s" {
	"%"	{ return "%" }
	" "	{ return " " }
	"S"	{ 
	    # Ԥ¥ɽ
	    puts_answer_pause ""
	    return "%S"
	}
	"M"	{
	    # ɤ뤿ñ˸
	    return -1
	}
	"K"	{
	    # ɾõ
	    return -1
	}
    }
    switch "$s" {
	"A"	{
	    # ʸĤ֤(ȥ)
	    if { $arrange_mode == "" } {
		set arrange_mode "AUTO"
	    } else {
		set arrange_mode {}
	    }
	    ##return ""
	}
	default	{
	    if { $s < "A" } {
		# ʤʸ֤
		a_arrange $s
	    } else {
		# 
		puts_answer_add $s
	    }
	}
    }
    # Ͼò켡оݤߤ
    return -1
}
# ִΤ
proc a_set_dlm { s } {
    global dlm_mode
    switch $dlm_mode {
	"USE"	{ return $s }
	"AUTO"	{
	    if { $s == "," || $s == "" || $s == "" || \
		    $s == "." || $s == "" || $s == "" } {
		return {%0}
	}   }
	"COMP"	{
	    if { $s == "," || $s == "" || $s == "" } {
		return  {%,}
	    } elseif {$s == "." || $s == "" || $s == "" } {
		return {%.}
	}   }
	default	{
	    puts "顼: ⡼: $dlm_mode"
	    exit 1 }
}   }

# Ƚ
proc q_ans { a } {
    global a_wait a_locate lesson_go number_go
    # Ԥν
    if { $a_wait == "" } {
	if { $a == "^m" || $a == "^M" } {
	    q_set $lesson_go [expr $number_go + 1]
	}
	return
    }
    # Ԥν 2
    if { $a_wait == "%S" } {
	if { $a == "^m" || $a == "^M" } {
	    puts_answer_pause_off
	    q_set $lesson_go [expr $number_go + 1]
	}
	return
    }
    # Ԥν
    if { $a_wait == "%," } {
	if { $a == "," || $a == "" || $a == "" } {
	    a_arrange 0
	    a_set [expr $a_locate + 1]
	}
	return
    } elseif { $a_wait == "%." } {
	if { $a == "." || $a == "" || $a == "" } {
	    a_arrange 0
	    a_set [expr $a_locate + 1]
	}
	return
    } elseif { $a == $a_wait } {
	# Ѥߤɲ
	puts_answer_add "$a_wait"
	# δʸ
	a_set [expr $a_locate + 1]
	# ɤι
	q_guide $lesson_go $number_go $a_locate
    } elseif { $a == "^m" || $a == "^M" } {
	# Ԥ˲Ԥ򲡤Ԥɽ
	puts_answer_hint "$a_wait"
    } {
	# ְ㤤ʸ򸫤
	puts_answer_wrong "$a"
}   }

#============================================================
#
# ɽ

# åɽ
proc puts_message { m } {
    global line
    set line "$m"
}

# õ
proc puts_answer_clear {} {
    global  answer_line
    set answer_line {}
    puts_answer "|"
}
# ɲü
proc puts_answer_add { a } {
    global  answer_line hint_key  arrange_mode board_q tcl_platform
    if { $arrange_mode == "AUTO" } {
	# ʸĲ󤫤ʸľ
	switch $tcl_platform(platform) {
	    unix { set l [string length $answer_line]
		   set a [string range $board_q $l $l] }
	    windows { set l [string length $answer_line]
		      set a [string range $board_q $l $l] }
	}
    }
    set answer_line "$answer_line$a"
    puts_answer "$answer_line|"
    # ҥȥϥ饤Ȥ
    type_hint_off
    set hint_key {nohint}
}
# ҥ
proc puts_answer_hint { a } {
    global answer_line hint_key
    puts_answer "$answer_line?$a"
    type_hint $a
    if { $hint_key == "nohint" } {
	set hint_key {}
    }
}
# (̤)
proc puts_answer_wrong { a } {
    global answer_line
    puts_answer "$answer_line|$a"
}
# λ
proc puts_answer_end {} {
    global answer_line
    puts_answer "$answer_line"
}

# ʸ֤
proc a_arrange { n } {
    global board_q answer_line tcl_platform
    # ʤ
    if { $n < 0 || $n > 9 } {
	puts "顼: ʸ֤: $n"
	return 1
    }
    # ˽񤤤Ƥʸο
    switch $tcl_platform(platform) {
	unix { set l [string length $answer_line] }
	windows { set l [string length $answer_line] }
    }
    if { $n == 0 } {
	# ư
	switch $tcl_platform(platform) {
	    unix { set a [string range $board_q $l $l] }
	    windows { set a [string range $board_q $l $l] }
	}
	set answer_line "$answer_line$a"
    } else {
	# ʸ֤
	if { $l > 1 } {
	    switch $tcl_platform(platform) {
		unix {
		    set a [string range $answer_line 0 [expr $l - $n - 1]]
		    set b [string range $board_q [expr $l - $n] [expr $l - $n]]
		}
		windows {
		    set a [string range $answer_line 0 [expr $l - $n - 1]]
		    set b [string range $board_q [expr $l - $n] [expr $l - $n]]
		}
}
	    set answer_line "$a$b"
	} {
	    switch $tcl_platform(platform) {
		unix { set answer_line [string range $board_q 0 0] }
		windows { set answer_line [string range $board_q 0 0] }
	    }
	}
    }
    puts_answer "$answer_line|"
}

# Ʋ
#proc puts_answer_pause {} {
#    global  board_a
#    #puts "ǥХå: PAUSE"
#    set board_a {[]򲡤ƿʤޤ}
#}
proc puts_answer_pause { s } {
    global board_s board_q a_wait
    set m {

 [  ] 򲡤ƿʤޤ}
    if { $s == "" } {
	set board_s "$board_q$m"
	set board_q ""
    } else {
	set board_s "$s$m"
    }
    place .board.s -x 10 -y 1 -width 540 -height 80
    set a_wait "%S"
}
proc puts_answer_pause_off {} {
    set board_s ""
    place forget .board.s
}
# ɽ(˹碌)
proc puts_answer { a } {
    global board_q board_a
    # ɽ
    set i [expr [string length $board_q] - [string length $a]]
    if { $i > 0 } {
	set board_a "$a[spc $i]"
    } {
	set board_a "$a"
    }
}

# Ŀζ֤
proc spc { N } {
    set SPC {}
    set I 0
    while { $I < $N } {
	set SPC "$SPC "
	set I [expr $I + 1]
    }
    return $SPC
}

############################################################
#
# 󤷤ˤ
#

# 
#puts "ǥХå: ѥ᥿: $argc"
foreach I $argv {
    #puts "ǥХå: ե: $I"
    q_load $I
}

#============================================================
# ˥塼

. configure -menu .menu
menu .menu
  .menu add cascade -menu .menu.main -label "NICOLA-Tutor"
  menu .menu.main -tearoff no
    .menu.main add command -label "ϲ ?" -command { about }
    .menu.main add separator
    .menu.main add command -label "ޤ" -command { exit 0 }
    .menu add cascade -menu .menu.lesson -label "Tutorials"
  menu .menu.lesson -tearoff no
    .menu.lesson add radiobutton -label "ͳϤ" \
	    -variable lesson_go -value "-1" -command { f_init }
    .menu.lesson add separator
    foreach I [array names q_entry] {
	eval { .menu.lesson add radiobutton -label } \{$q_entry($I)\} { -variable lesson_go -value } $I { -command { q_init } }
    }
    .menu.lesson add separator
    .menu.lesson add command -label "ե뤫ɤ߹" -command { tk_q_load }
  .menu add cascade -menu .menu.kbd -label "Keyboard"
    menu .menu.kbd -tearoff no
    .menu.kbd add checkbutton -label "-ư" -variable space_mode -offvalue {} -onvalue {AUTO}
    .menu.kbd add cascade -label "" -menu .menu.kbd.dlm
      menu .menu.kbd.dlm -tearoff no
        .menu.kbd.dlm add radiobutton -label "ʤ" \
		-variable dlm_mode -value {USE}
        .menu.kbd.dlm add radiobutton -label "θߴ" \
		-variable dlm_mode -value {COMP}
        .menu.kbd.dlm add radiobutton -label "ư" \
		-variable dlm_mode -value {AUTO}
    .menu.kbd add separator
    .menu.kbd add cascade -label " ۿ " -menu .menu.kbd.col
      menu .menu.kbd.col -tearoff no
      foreach I [array names skb_color_set] {
	  eval {.menu.kbd.col add radiobutton -label } \{[lindex $skb_color_set($I) 0]\} { -variable skb_color_sel -value } $I { -command { skb_col_set } }
      }
    .menu.kbd add separator
    for { set I 0 } { $I < [llength $menu_kbd] } { incr I } {
	eval { .menu.kbd add radiobutton -label } \{[lindex [lindex $menu_kbd $I] 0]\} { -variable kbd_go -value } $I { -command { menu_set_kbd } }
    }

#============================================================
# ֤

# ưϤλ
.menu.kbd invoke 0
# ߴν
.menu.kbd.dlm invoke 0
# ۿ
skb_col_init
# ܡ
.menu.kbd invoke 5

# ⡼
if { $lesson_max < 1 } {
    # ̵꤬ϼͳϥ⡼
   .menu.lesson invoke 0
} else {
    # ꤬Ǥ⤢Фɽ
    .menu.lesson invoke 2
}
