/*
 * tp-constants.h - constants used in telepathy
 * Copyright (C) 2005, 2007 Collabora Ltd.
 * Copyright (C) 2005, 2007 Nokia Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __LIBTELEPATHY_CONSTANTS_H__
#define __LIBTELEPATHY_CONSTANTS_H__

#include <glib.h>

G_BEGIN_DECLS

#include <telepathy-glib/enums.h>

#ifndef LIBTELEPATHY_DISABLE_DEPRECATED
#include <libtelepathy/_gen-tp-constants-deprecated.h>

/* Fixup for libtelepathy conventions differing from telepathy-glib */
#include <libtelepathy/_gen-tp-constants-whitelist-aliases.h>
#include <libtelepathy/_gen-tp-constants-deprecated-aliases.h>

/* Fixup for bits of libtelepathy that didn't follow convention */

/* handle type is officially no longer called "connection handle type" */
#define TP_CONN_HANDLE_TYPE_NONE      TP_HANDLE_TYPE_NONE
#define TP_CONN_HANDLE_TYPE_CONTACT   TP_HANDLE_TYPE_CONTACT
#define TP_CONN_HANDLE_TYPE_ROOM      TP_HANDLE_TYPE_ROOM
#define TP_CONN_HANDLE_TYPE_LIST      TP_HANDLE_TYPE_LIST
#define TP_CONN_HANDLE_TYPE_GROUP     TP_HANDLE_TYPE_GROUP
#define LAST_TP_CONN_HANDLE_TYPE      LAST_TP_HANDLE_TYPE
#define TelepathyConnectionHandleType TpHandleType

/* A historical typo */
#define TP_MEDIA_STREAM_DIRECTION_RECIEVE TP_MEDIA_STREAM_DIRECTION_RECEIVE

/* Namespace pollution, but needed for compatibility */
#define ConnectionAliasFlags          TpConnectionAliasFlags

/* Connection_Capability_Flags used to be Connection_Capability_Type */
#define TP_CONN_CAPABILITY_TYPE_CREATE TP_CONN_CAPABILITY_FLAG_CREATE
#define TP_CONN_CAPABILITY_TYPE_INVITE TP_CONN_CAPABILITY_FLAG_INVITE
#define LAST_TP_CONN_CAPABILITY_TYPE LAST_TP_CONN_CAPABILITY_FLAG
#define TelepathyConnectionCapabilityType TpConnectionCapabilityFlags

/* Unconventional singular names for flag-set type */
#define TelepathyChannelTextMessageFlag TpChannelTextMessageFlags
#define TelepathyChannelMediaCapability TpChannelMediaCapabilities

/* API compatibility (these used to be in the spec, but not any more) */
#define TP_CHANNEL_PASSWORD_FLAG_REQUIRED ((TpChannelPasswordFlags)1)
#define TP_CHANNEL_PASSWORD_FLAG_VISIBLE ((TpChannelPasswordFlags)2)
#define TP_CHANNEL_PASSWORD_FLAG_MODIFIABLE ((TpChannelPasswordFlags)4)

/* This enum isn't in the spec at all any more; kept for source compat */
typedef enum {
    TP_CHANNEL_SUBJECT_FLAG_PRESENT = 1,
    TP_CHANNEL_SUBJECT_FLAG_MODIFIABLE = 2,
    LAST_TP_CHANNEL_SUBJECT_FLAG
} TelepathyChannelSubjectFlags;

/* This type has been renamed in the spec to reflect its purpose */
#define TelepathyMediaStreamPending TpMediaStreamPendingSend

/* This type has been renamed in the spec */
#define TP_MEDIA_STREAM_PROTO_UDP   TP_MEDIA_STREAM_BASE_PROTO_UDP
#define TP_MEDIA_STREAM_PROTO_TCP   TP_MEDIA_STREAM_BASE_PROTO_TCP
#define LAST_TP_MEDIA_STREAM_PROTO  LAST_TP_MEDIA_STREAM_BASE_PROTO
#define TelepathyMediaStreamProto   TpMediaStreamBaseProto

/* This naming just isn't in the spec, perhaps it used to be... */
#define TP_CODEC_MEDIA_TYPE_AUDIO   TP_MEDIA_STREAM_TYPE_AUDIO
#define TP_CODEC_MEDIA_TYPE_VIDEO   TP_MEDIA_STREAM_TYPE_VIDEO
#define LAST_TP_CODEC_MEDIA_TYPE    LAST_TP_MEDIA_STREAM_TYPE
#define TelepathyCodecMediaType     TpMediaStreamType

#endif /* !defined(LIBTELEPATHY_DISABLE_DEPRECATED) */

G_END_DECLS

#endif
