/*
 *  KANJI Code conversion routines.
 */

#ifndef PTEXENC_KANJICNV_H
#define PTEXENC_KANJICNV_H

#include <kpathsea/c-proto.h>
#include <kpathsea/types.h>

#define HI(x)     ((((int)(x)) >> 8) & 0xff)
#define LO(x)     ( ((int)(x))       & 0xff)
#define HILO(x,y) ((LO(x) << 8) | LO(y))

extern KPSEDLL boolean isEUCkanji1 P1H(int c);
extern KPSEDLL boolean isEUCkanji2 P1H(int c);

extern KPSEDLL boolean isSJISkanji1 P1H(int c);
extern KPSEDLL boolean isSJISkanji2 P1H(int c);

/* EUC <=> JIS X 0208 code conversion */
extern KPSEDLL int EUCtoJIS P1H(int);
extern KPSEDLL int JIStoEUC P1H(int);

/* Shift JIS <=> JIS Kanji code conversion */
extern KPSEDLL int SJIStoJIS P1H(int);
extern KPSEDLL int JIStoSJIS P1H(int);

/* Shift JIS <=> EUC Kanji code conversion */
extern KPSEDLL int SJIStoEUC P1H(int);
extern KPSEDLL int EUCtoSJIS P1H(int);

/* KUTEN => JIS kanji code conversion */
extern KPSEDLL int KUTENtoJIS P1H(int);

#endif /* PTEXENC_KANJICNV_H */
