#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "eggx.h"
#include "cyan10ppm.h"
#include "e_ctrls.h"

// begin{3D 4-th Runge-Kutta} 
typedef struct {
  double f[6];
} vec6;

void rk4fixv6(vec6 f(), 
              double t, double *r, double h)
{
  int i, n;
  double ts, rs[6], k[4][6];
  double c[4] = { 1, 0.5, 0.5, 1 };
  vec6 diff;

  for (n = 0; n < 6; n++) rs[n] = r[n];

  ts = t;
  for (i = 0; i < 4; i++) {
    if (i > 0) {
      for (n = 0; n < 6; n++)rs[n] = r[n] + k[i - 1][n] * c[i];
      ts = t + c[i]*h;
    }
    diff = f(ts, rs);
    for (n = 0; n < 6; n++) k[i][n] = h * diff.f[n];
  }

  for (n = 0; n < 6; n++) {
    for (i = 0; i < 4; i++) r[n] += k[i][n] / c[i] / 6;
  }
}
// end{3D 4th Runge-Kutta}

#define WD     320
#define HT     24
#define BOX    10   /* 固定端箱の幅，高さはその2倍 */
#define R      10   /* 球の半径（画像に依存） */
#define L0     100  /* (WD-2*BOX)/3  */

double   K1 = 4.0;  /* 両端のバネ定数2 */
double   K2 = 0.5;  /* 中央のバネ定数1 */

vec6 mov(double t, double r[6])
{
  vec6 ret;
  ret.f[0] = r[1];
  ret.f[1] = -K1*r[0] + K2*(r[2]-r[0]);
  ret.f[2] = r[3];
  ret.f[3] = -K2*(r[2]-r[0]) - K1*r[2];

  return ret;
}

int win, cwin, iscwin, type, button;
double run = 1, set = 0, quit = 0;
double mr[6] = {0,0,0,0,0,0}, t = 0;
double xi = 30, h = 0.05;
float wx, wy;

extern void spring (int, double, double, double, double, 
  double, double, double);

void draw()
{
  gclr(win);
  fillrect(win, -BOX, HT/2-BOX, BOX, 2*BOX);
  fillrect(win, WD-2*BOX, HT/2-BOX, BOX, 2*BOX);
  putimg24(win, L0+mr[0]-10, HT/2-10, 20, 20, cyan10);
  putimg24(win, 2*L0+mr[2]-10, HT/2-10, 20, 20, cyan10);
  spring(win, 0, HT/2, L0+mr[0]-BOX, 8, 6, 8, 0);
  spring(win, L0+mr[0]+R, HT/2, L0+mr[2]-mr[0]-2*R, 8, 6, 8, 0);
  spring(win, 2*L0+mr[2]+R, HT/2, L0-mr[2]-R, 8, 6, 8, 0);
  t += h;
  copylayer(win,1,0);
}

void init()
{
  mr[1]=mr[2]=mr[3]=mr[4]=mr[5]=0.0;
  mr[0] = xi;
  t = 0;
  draw();
}

int main(int argc, char **argv)
{
  _CTRL ctrls[] = {
    {"K2", &K2, 0.1, init},
    {"X_init", &xi, 10, init},
    {"_Set", &set,0, init},
    {"_Run", &run,0},
    {"_Quit", &quit, 0, exit},
  };
  init_ctrls(&cwin, 5);

  gsetinitialbgcolor("white");
  win = gopen(WD, HT);
  window(win, -BOX, 0, WD-BOX, HT);
  newcolor(win,"steelblue");
  winname(win, "Harmonic Oscillator: RK4");
  layer(win,0,1);
  gsetnonblock(ENABLE);
  init();

  while (!quit) {
    iscwin = ggetxpress(&type, &button, &wx, &wy);
    display_ctrls(cwin, ctrls, 5, wx, wy, iscwin, type, button);
    if (run) { rk4fixv6(mov, t, mr, h); draw();}
    if (set) { 
         run = 0; 
         init(); 
         display_ctrls(cwin, ctrls, 5, wx, wy, iscwin, type, button);
         set = 0;
    }
    msleep(20);
  }
  return 0;
}

