/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.javafx2.project.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.project.ui.customizer.CustomizerProvider3;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.MouseUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/**
 *
 * @author psomol
 */
public class JSEDeploymentPanel extends javax.swing.JPanel {

    private final JFXProjectProperties props;
    private final Project project;
    private final PropertyEvaluator evaluator;
    //private final CustomizerProvider3 seCustomizer;
    
    /**
     * Creates new form JSEDeploymentPanel
     */
    public JSEDeploymentPanel(JFXProjectProperties props) {
        this.props = props;
        this.project = props.getProject();
        this.evaluator = props.getEvaluator();
        //seCustomizer = project.getLookup().lookup(CustomizerProvider3.class);
        initComponents();
        buttonSwitchToJFX.addActionListener( new MainClassListener( project, evaluator ) );
        checkBoxKeepJFXRT.setSelected(props.getKeepJFXRTonCP());
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        labelKeepJFXRT = new javax.swing.JLabel();
        checkBoxKeepJFXRT = new javax.swing.JCheckBox();
        labelSwitchToJFX = new javax.swing.JLabel();
        buttonSwitchToJFX = new javax.swing.JButton();
        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0), new java.awt.Dimension(0, 0), new java.awt.Dimension(0, 0));
        filler2 = new javax.swing.Box.Filler(new java.awt.Dimension(500, 0), new java.awt.Dimension(500, 0), new java.awt.Dimension(500, 32767));

        setLayout(new java.awt.GridBagLayout());

        labelKeepJFXRT.setLabelFor(checkBoxKeepJFXRT);
        org.openide.awt.Mnemonics.setLocalizedText(labelKeepJFXRT, org.openide.util.NbBundle.getMessage(JSEDeploymentPanel.class, "JSEDeploymentPanel.labelKeepJFXRT.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(25, 0, 0, 0);
        add(labelKeepJFXRT, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(checkBoxKeepJFXRT, org.openide.util.NbBundle.getMessage(JSEDeploymentPanel.class, "JSEDeploymentPanel.checkBoxKeepJFXRT.text")); // NOI18N
        checkBoxKeepJFXRT.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                checkBoxKeepJFXRTActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 15, 0, 0);
        add(checkBoxKeepJFXRT, gridBagConstraints);
        checkBoxKeepJFXRT.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(JSEDeploymentPanel.class, "AN_JSEDeploymentPanel.checkBoxKeepJFXRT")); // NOI18N
        checkBoxKeepJFXRT.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JSEDeploymentPanel.class, "AD_JSEDeploymentPanel.checkBoxKeepJFXRT")); // NOI18N

        labelSwitchToJFX.setLabelFor(buttonSwitchToJFX);
        org.openide.awt.Mnemonics.setLocalizedText(labelSwitchToJFX, org.openide.util.NbBundle.getMessage(JSEDeploymentPanel.class, "JSEDeploymentPanel.labelSwitchToJFX.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(25, 0, 0, 0);
        add(labelSwitchToJFX, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(buttonSwitchToJFX, org.openide.util.NbBundle.getMessage(JSEDeploymentPanel.class, "JSEDeploymentPanel.buttonSwitchToJFX.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 15, 0, 0);
        add(buttonSwitchToJFX, gridBagConstraints);
        buttonSwitchToJFX.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(JSEDeploymentPanel.class, "AN_JSEDeploymentPanel.buttonSwitchToJFX")); // NOI18N
        buttonSwitchToJFX.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JSEDeploymentPanel.class, "AD_JSEDeploymentPanel.buttonSwitchToJFX")); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(filler1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        add(filler2, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void checkBoxKeepJFXRTActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_checkBoxKeepJFXRTActionPerformed
        boolean sel = checkBoxKeepJFXRT.isSelected();
        props.setKeepJFXRTonCP(sel);
    }//GEN-LAST:event_checkBoxKeepJFXRTActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton buttonSwitchToJFX;
    private javax.swing.JCheckBox checkBoxKeepJFXRT;
    private javax.swing.Box.Filler filler1;
    private javax.swing.Box.Filler filler2;
    private javax.swing.JLabel labelKeepJFXRT;
    private javax.swing.JLabel labelSwitchToJFX;
    // End of variables declaration//GEN-END:variables

     // Innerclasses -------------------------------------------------------------
     
     private class MainClassListener implements ActionListener /*, DocumentListener */ {
         
         private final JButton okButton;
         private final PropertyEvaluator evaluator;
         private final Project project;
         
         MainClassListener( final @NonNull Project p, final @NonNull PropertyEvaluator pe ) {            
             this.evaluator = pe;
             this.project = p;
             this.okButton  = new JButton (NbBundle.getMessage (JSEDeploymentPanel.class, "LBL_SwitchToFX")); // NOI18N
             this.okButton.getAccessibleContext().setAccessibleDescription (NbBundle.getMessage (JSEDeploymentPanel.class, "AD_SwitchToFX"));  // NOI18N
         }
         
         // Implementation of ActionListener ------------------------------------
         
         /** Handles button events
          */        
         @Override
         public void actionPerformed( ActionEvent e ) {
             
             final JSEApplicationClassChooser panel = new JSEApplicationClassChooser(project, evaluator);
             Object[] options = new Object[] {
                 okButton,
                 DialogDescriptor.CANCEL_OPTION
             };
             panel.addChangeListener (new ChangeListener () {
                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e != null && e.getSource () instanceof MouseEvent && MouseUtils.isDoubleClick (((MouseEvent)e.getSource ()))) {
                        // click button and finish the dialog with selected class
                        okButton.doClick();
                    } else {
                        //okButton.setEnabled (panel.getSelectedClass () != null);
                        okButton.setEnabled (panel.isClassSelectionValid());
                    }
                }
             });
             okButton.setEnabled (panel.isClassSelectionValid());
             DialogDescriptor desc = new DialogDescriptor (
                 panel,
                 NbBundle.getMessage (JSEDeploymentPanel.class, "LBL_ChooseMainClassForSwitch_Title" ),  // NOI18N
                 true, 
                 options, 
                 options[0], 
                 DialogDescriptor.BOTTOM_ALIGN, 
                 null, 
                 null);
             //desc.setMessageType (DialogDescriptor.INFORMATION_MESSAGE);
             //panel.setDialogDescriptor(desc);
             Dialog dlg = DialogDisplayer.getDefault ().createDialog (desc);
             dlg.setVisible (true);
             if (desc.getValue() == options[0]) {
                 
                 NotifyDescriptor d =
                     new NotifyDescriptor.Confirmation(
                         NbBundle.getMessage (JSEDeploymentPanel.class, "JSEDeploymentPanel.confirmSwitchToFX.text" ),  // NOI18N
                         NbBundle.getMessage (JSEDeploymentPanel.class, "JSEDeploymentPanel.confirmSwitchToFX.title" ),  // NOI18N
                         NotifyDescriptor.OK_CANCEL_OPTION);
                 if (DialogDisplayer.getDefault().notify(d) == NotifyDescriptor.OK_OPTION) {

                     CustomizerProvider3 canceller = project.getLookup().lookup(CustomizerProvider3.class);
                     if(canceller != null) {
                         canceller.cancelCustomizer();
                         ProgressUtils.showProgressDialogAndRun(new Runnable() {
                             @Override
                             public void run() {
                                 try {
                                     JFXProjectUtils.switchProjectToFX(project, panel);
                                 } catch (IOException ex) {
                                     Exceptions.printStackTrace(ex);
                                 }
                             }
                         }, NbBundle.getMessage (JSEDeploymentPanel.class, "JSEDeploymentPanel.confirmSwitchToFX.progress.title" ) // NOI18N
                         );
                     }
                 }
                 
             } 
             dlg.dispose();
         }
    }
}
