#define SIMDE_TEST_ARM_NEON_INSN cadd_rot90

#include "test-neon.h"
#include "../../../simde/arm/neon/cadd_rot90.h"

static int
test_simde_vcadd_rot90_f16 (SIMDE_MUNIT_TEST_ARGS) {
#if 1
  struct {
    simde_float16_t a[4];
    simde_float16_t b[4];
    simde_float16_t r[4];
  } test_vec[] = {
    { { SIMDE_FLOAT16_VALUE(   816.50), SIMDE_FLOAT16_VALUE(   773.50), SIMDE_FLOAT16_VALUE(  -377.75), SIMDE_FLOAT16_VALUE(   544.50) },
      { SIMDE_FLOAT16_VALUE(  -188.38), SIMDE_FLOAT16_VALUE(   269.75), SIMDE_FLOAT16_VALUE(   115.62), SIMDE_FLOAT16_VALUE(  -544.00) },
      { SIMDE_FLOAT16_VALUE(   547.00), SIMDE_FLOAT16_VALUE(   585.00), SIMDE_FLOAT16_VALUE(   166.25), SIMDE_FLOAT16_VALUE(   660.00) } },
    { { SIMDE_FLOAT16_VALUE(  -659.50), SIMDE_FLOAT16_VALUE(   924.50), SIMDE_FLOAT16_VALUE(   484.00), SIMDE_FLOAT16_VALUE(  -757.00) },
      { SIMDE_FLOAT16_VALUE(   730.00), SIMDE_FLOAT16_VALUE(   103.12), SIMDE_FLOAT16_VALUE(  -381.25), SIMDE_FLOAT16_VALUE(   898.50) },
      { SIMDE_FLOAT16_VALUE(  -762.50), SIMDE_FLOAT16_VALUE(  1654.00), SIMDE_FLOAT16_VALUE(  -414.50), SIMDE_FLOAT16_VALUE( -1138.00) } },
    { { SIMDE_FLOAT16_VALUE(   293.00), SIMDE_FLOAT16_VALUE(  -114.06), SIMDE_FLOAT16_VALUE(  -137.62), SIMDE_FLOAT16_VALUE(   722.50) },
      { SIMDE_FLOAT16_VALUE(    -6.33), SIMDE_FLOAT16_VALUE(   161.38), SIMDE_FLOAT16_VALUE(   115.50), SIMDE_FLOAT16_VALUE(    70.38) },
      { SIMDE_FLOAT16_VALUE(   131.62), SIMDE_FLOAT16_VALUE(  -120.38), SIMDE_FLOAT16_VALUE(  -208.00), SIMDE_FLOAT16_VALUE(   838.00) } },
    { { SIMDE_FLOAT16_VALUE(  -899.00), SIMDE_FLOAT16_VALUE(  -582.50), SIMDE_FLOAT16_VALUE(   359.00), SIMDE_FLOAT16_VALUE(   342.25) },
      { SIMDE_FLOAT16_VALUE(   913.00), SIMDE_FLOAT16_VALUE(   740.50), SIMDE_FLOAT16_VALUE(  -436.25), SIMDE_FLOAT16_VALUE(  -904.00) },
      { SIMDE_FLOAT16_VALUE( -1640.00), SIMDE_FLOAT16_VALUE(   330.50), SIMDE_FLOAT16_VALUE(  1263.00), SIMDE_FLOAT16_VALUE(   -94.00) } },
    { { SIMDE_FLOAT16_VALUE(  -335.25), SIMDE_FLOAT16_VALUE(  -252.38), SIMDE_FLOAT16_VALUE(   227.25), SIMDE_FLOAT16_VALUE(    -8.67) },
      { SIMDE_FLOAT16_VALUE(   490.50), SIMDE_FLOAT16_VALUE(   507.50), SIMDE_FLOAT16_VALUE(  -979.50), SIMDE_FLOAT16_VALUE(  -718.00) },
      { SIMDE_FLOAT16_VALUE(  -843.00), SIMDE_FLOAT16_VALUE(   238.12), SIMDE_FLOAT16_VALUE(   945.00), SIMDE_FLOAT16_VALUE(  -988.00) } },
    { { SIMDE_FLOAT16_VALUE(   498.50), SIMDE_FLOAT16_VALUE(   205.75), SIMDE_FLOAT16_VALUE(  -797.50), SIMDE_FLOAT16_VALUE(   741.50) },
      { SIMDE_FLOAT16_VALUE(  -835.00), SIMDE_FLOAT16_VALUE(  -308.00), SIMDE_FLOAT16_VALUE(  -674.50), SIMDE_FLOAT16_VALUE(  -247.00) },
      { SIMDE_FLOAT16_VALUE(   806.50), SIMDE_FLOAT16_VALUE(  -629.00), SIMDE_FLOAT16_VALUE(  -550.50), SIMDE_FLOAT16_VALUE(    67.00) } },
    { { SIMDE_FLOAT16_VALUE(  -210.88), SIMDE_FLOAT16_VALUE(  -430.75), SIMDE_FLOAT16_VALUE(   725.50), SIMDE_FLOAT16_VALUE(  -944.50) },
      { SIMDE_FLOAT16_VALUE(   142.00), SIMDE_FLOAT16_VALUE(  -966.00), SIMDE_FLOAT16_VALUE(  -131.50), SIMDE_FLOAT16_VALUE(   462.50) },
      { SIMDE_FLOAT16_VALUE(   755.00), SIMDE_FLOAT16_VALUE(  -288.75), SIMDE_FLOAT16_VALUE(   263.00), SIMDE_FLOAT16_VALUE( -1076.00) } },
    { { SIMDE_FLOAT16_VALUE(  -361.00), SIMDE_FLOAT16_VALUE(   185.62), SIMDE_FLOAT16_VALUE(    60.47), SIMDE_FLOAT16_VALUE(   749.50) },
      { SIMDE_FLOAT16_VALUE(  -975.50), SIMDE_FLOAT16_VALUE(   383.50), SIMDE_FLOAT16_VALUE(   500.25), SIMDE_FLOAT16_VALUE(   517.00) },
      { SIMDE_FLOAT16_VALUE(  -744.50), SIMDE_FLOAT16_VALUE(  -790.00), SIMDE_FLOAT16_VALUE(  -456.50), SIMDE_FLOAT16_VALUE(  1250.00) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde_float16x4_t a = simde_vld1_f16(test_vec[i].a);
    simde_float16x4_t b = simde_vld1_f16(test_vec[i].b);
    simde_float16x4_t r = simde_vcadd_rot90_f16(a, b);

    simde_test_arm_neon_assert_equal_f16x4(r, simde_vld1_f16(test_vec[i].r), 1);
  }

  return 0;
#else
  fputc('\n', stdout);
  for (int i = 0 ; i < 8 ; i++) {
    simde_float16x4_t a = simde_test_arm_neon_random_f16x4(-1000.0f, 1000.0f);
    simde_float16x4_t b = simde_test_arm_neon_random_f16x4(-1000.0f, 1000.0f);
    simde_float16x4_t r = simde_vcadd_rot90_f16(a, b);

    simde_test_arm_neon_write_f16x4(2, a, SIMDE_TEST_VEC_POS_FIRST);
    simde_test_arm_neon_write_f16x4(2, b, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_arm_neon_write_f16x4(2, r, SIMDE_TEST_VEC_POS_LAST);
  }
  return 1;
#endif
}

static int
test_simde_vcaddq_rot90_f16 (SIMDE_MUNIT_TEST_ARGS) {
#if 1
  struct {
    simde_float16_t a[8];
    simde_float16_t b[8];
    simde_float16_t r[8];
  } test_vec[] = {
    { { SIMDE_FLOAT16_VALUE(   540.00), SIMDE_FLOAT16_VALUE(  -927.50), SIMDE_FLOAT16_VALUE(    17.94), SIMDE_FLOAT16_VALUE(   340.75),
        SIMDE_FLOAT16_VALUE(  -397.75), SIMDE_FLOAT16_VALUE(   166.12), SIMDE_FLOAT16_VALUE(   854.00), SIMDE_FLOAT16_VALUE(  -110.75) },
      { SIMDE_FLOAT16_VALUE(  -936.50), SIMDE_FLOAT16_VALUE(  -465.00), SIMDE_FLOAT16_VALUE(  -104.00), SIMDE_FLOAT16_VALUE(  -348.00),
        SIMDE_FLOAT16_VALUE(  -370.75), SIMDE_FLOAT16_VALUE(    18.20), SIMDE_FLOAT16_VALUE(  -209.25), SIMDE_FLOAT16_VALUE(  -856.00) },
      { SIMDE_FLOAT16_VALUE(1005.000000), SIMDE_FLOAT16_VALUE(-1864.000000), SIMDE_FLOAT16_VALUE(366.000000), SIMDE_FLOAT16_VALUE(236.750000), 
        SIMDE_FLOAT16_VALUE(-416.000000), SIMDE_FLOAT16_VALUE(-204.625000), SIMDE_FLOAT16_VALUE(1710.000000), SIMDE_FLOAT16_VALUE(-320.000000) } },
    { { SIMDE_FLOAT16_VALUE(   251.25), SIMDE_FLOAT16_VALUE(   523.50), SIMDE_FLOAT16_VALUE(   -62.34), SIMDE_FLOAT16_VALUE(  -412.00),
        SIMDE_FLOAT16_VALUE(   818.50), SIMDE_FLOAT16_VALUE(  -266.25), SIMDE_FLOAT16_VALUE(   558.50), SIMDE_FLOAT16_VALUE(  -474.75) },
      { SIMDE_FLOAT16_VALUE(   583.50), SIMDE_FLOAT16_VALUE(  -666.00), SIMDE_FLOAT16_VALUE(   875.50), SIMDE_FLOAT16_VALUE(   382.50),
        SIMDE_FLOAT16_VALUE(  -535.00), SIMDE_FLOAT16_VALUE(   374.50), SIMDE_FLOAT16_VALUE(    89.81), SIMDE_FLOAT16_VALUE(   432.50) },
      { SIMDE_FLOAT16_VALUE(917.000000), SIMDE_FLOAT16_VALUE(1107.000000), SIMDE_FLOAT16_VALUE(-444.750000), SIMDE_FLOAT16_VALUE(463.500000), 
        SIMDE_FLOAT16_VALUE(444.000000), SIMDE_FLOAT16_VALUE(-801.000000), SIMDE_FLOAT16_VALUE(126.000000), SIMDE_FLOAT16_VALUE(-385.000000) } },
    { { SIMDE_FLOAT16_VALUE(    83.19), SIMDE_FLOAT16_VALUE(   418.00), SIMDE_FLOAT16_VALUE(  -875.50), SIMDE_FLOAT16_VALUE(   830.50),
        SIMDE_FLOAT16_VALUE(  -633.50), SIMDE_FLOAT16_VALUE(   832.00), SIMDE_FLOAT16_VALUE(  -890.00), SIMDE_FLOAT16_VALUE(   650.00) },
      { SIMDE_FLOAT16_VALUE(  -111.25), SIMDE_FLOAT16_VALUE(  -830.50), SIMDE_FLOAT16_VALUE(    59.75), SIMDE_FLOAT16_VALUE(   970.50),
        SIMDE_FLOAT16_VALUE(   522.50), SIMDE_FLOAT16_VALUE(  -822.50), SIMDE_FLOAT16_VALUE(   411.25), SIMDE_FLOAT16_VALUE(  -692.50) },
      { SIMDE_FLOAT16_VALUE(913.500000), SIMDE_FLOAT16_VALUE(306.750000), SIMDE_FLOAT16_VALUE(-1846.000000), SIMDE_FLOAT16_VALUE(890.000000), 
        SIMDE_FLOAT16_VALUE(189.000000), SIMDE_FLOAT16_VALUE(1354.000000), SIMDE_FLOAT16_VALUE(-197.500000), SIMDE_FLOAT16_VALUE(1061.000000) } },
    { { SIMDE_FLOAT16_VALUE(   648.50), SIMDE_FLOAT16_VALUE(   385.25), SIMDE_FLOAT16_VALUE(   479.25), SIMDE_FLOAT16_VALUE(  -793.50),
        SIMDE_FLOAT16_VALUE(  -740.50), SIMDE_FLOAT16_VALUE(   245.00), SIMDE_FLOAT16_VALUE(   229.25), SIMDE_FLOAT16_VALUE(  -113.25) },
      { SIMDE_FLOAT16_VALUE(   331.50), SIMDE_FLOAT16_VALUE(  -677.50), SIMDE_FLOAT16_VALUE(    97.31), SIMDE_FLOAT16_VALUE(   -52.09),
        SIMDE_FLOAT16_VALUE(   239.12), SIMDE_FLOAT16_VALUE(   469.75), SIMDE_FLOAT16_VALUE(  -543.50), SIMDE_FLOAT16_VALUE(   827.00) },
      { SIMDE_FLOAT16_VALUE(1326.000000), SIMDE_FLOAT16_VALUE(717.000000), SIMDE_FLOAT16_VALUE(531.500000), SIMDE_FLOAT16_VALUE(-696.000000), 
        SIMDE_FLOAT16_VALUE(-1210.000000), SIMDE_FLOAT16_VALUE(484.000000), SIMDE_FLOAT16_VALUE(-598.000000), SIMDE_FLOAT16_VALUE(-657.000000) } },
    { { SIMDE_FLOAT16_VALUE(   226.38), SIMDE_FLOAT16_VALUE(   178.88), SIMDE_FLOAT16_VALUE(   181.75), SIMDE_FLOAT16_VALUE(   420.50),
        SIMDE_FLOAT16_VALUE(  -699.00), SIMDE_FLOAT16_VALUE(  -151.12), SIMDE_FLOAT16_VALUE(  -388.25), SIMDE_FLOAT16_VALUE(   350.75) },
      { SIMDE_FLOAT16_VALUE(   890.50), SIMDE_FLOAT16_VALUE(  -665.00), SIMDE_FLOAT16_VALUE(  -618.00), SIMDE_FLOAT16_VALUE(   190.88),
        SIMDE_FLOAT16_VALUE(   218.12), SIMDE_FLOAT16_VALUE(  -329.00), SIMDE_FLOAT16_VALUE(  -549.50), SIMDE_FLOAT16_VALUE(  -460.00) },
      { SIMDE_FLOAT16_VALUE(891.500000), SIMDE_FLOAT16_VALUE(1069.000000), SIMDE_FLOAT16_VALUE(-9.125000), SIMDE_FLOAT16_VALUE(-197.500000), 
        SIMDE_FLOAT16_VALUE(-370.000000), SIMDE_FLOAT16_VALUE(67.000000), SIMDE_FLOAT16_VALUE(71.750000), SIMDE_FLOAT16_VALUE(-198.750000) } },
    { { SIMDE_FLOAT16_VALUE(  -378.00), SIMDE_FLOAT16_VALUE(  -695.50), SIMDE_FLOAT16_VALUE(   121.50), SIMDE_FLOAT16_VALUE(   -78.44),
        SIMDE_FLOAT16_VALUE(  -869.50), SIMDE_FLOAT16_VALUE(  -710.00), SIMDE_FLOAT16_VALUE(   457.25), SIMDE_FLOAT16_VALUE(   579.00) },
      { SIMDE_FLOAT16_VALUE(  -786.50), SIMDE_FLOAT16_VALUE(  -974.00), SIMDE_FLOAT16_VALUE(  -570.50), SIMDE_FLOAT16_VALUE(   369.25),
        SIMDE_FLOAT16_VALUE(    48.06), SIMDE_FLOAT16_VALUE(  -640.00), SIMDE_FLOAT16_VALUE(  -552.00), SIMDE_FLOAT16_VALUE(    75.88) },
      { SIMDE_FLOAT16_VALUE(596.000000), SIMDE_FLOAT16_VALUE(-1482.000000), SIMDE_FLOAT16_VALUE(-247.750000), SIMDE_FLOAT16_VALUE(-649.000000), 
        SIMDE_FLOAT16_VALUE(-229.500000), SIMDE_FLOAT16_VALUE(-662.000000), SIMDE_FLOAT16_VALUE(381.500000), SIMDE_FLOAT16_VALUE(27.000000) } },
    { { SIMDE_FLOAT16_VALUE(   352.25), SIMDE_FLOAT16_VALUE(   324.25), SIMDE_FLOAT16_VALUE(   485.50), SIMDE_FLOAT16_VALUE(   943.50),
        SIMDE_FLOAT16_VALUE(  -976.00), SIMDE_FLOAT16_VALUE(   395.50), SIMDE_FLOAT16_VALUE(  -100.62), SIMDE_FLOAT16_VALUE(  -463.75) },
      { SIMDE_FLOAT16_VALUE(  -973.00), SIMDE_FLOAT16_VALUE(  -159.62), SIMDE_FLOAT16_VALUE(  -377.00), SIMDE_FLOAT16_VALUE(  -853.00),
        SIMDE_FLOAT16_VALUE(   831.00), SIMDE_FLOAT16_VALUE(   661.00), SIMDE_FLOAT16_VALUE(  -717.00), SIMDE_FLOAT16_VALUE(   891.50) },
      { SIMDE_FLOAT16_VALUE(512.000000), SIMDE_FLOAT16_VALUE(-649.000000), SIMDE_FLOAT16_VALUE(1338.000000), SIMDE_FLOAT16_VALUE(566.500000), 
        SIMDE_FLOAT16_VALUE(-1637.000000), SIMDE_FLOAT16_VALUE(1226.000000), SIMDE_FLOAT16_VALUE(-992.000000), SIMDE_FLOAT16_VALUE(-1181.000000) } },
    { { SIMDE_FLOAT16_VALUE(   535.50), SIMDE_FLOAT16_VALUE(   621.50), SIMDE_FLOAT16_VALUE(   578.50), SIMDE_FLOAT16_VALUE(   430.50),
        SIMDE_FLOAT16_VALUE(  -574.50), SIMDE_FLOAT16_VALUE(  -319.75), SIMDE_FLOAT16_VALUE(  -735.00), SIMDE_FLOAT16_VALUE(   248.50) },
      { SIMDE_FLOAT16_VALUE(   274.50), SIMDE_FLOAT16_VALUE(   192.38), SIMDE_FLOAT16_VALUE(   679.00), SIMDE_FLOAT16_VALUE(   502.25),
        SIMDE_FLOAT16_VALUE(  -618.50), SIMDE_FLOAT16_VALUE(   -70.81), SIMDE_FLOAT16_VALUE(  -596.50), SIMDE_FLOAT16_VALUE(   810.50) },
      { SIMDE_FLOAT16_VALUE(343.000000), SIMDE_FLOAT16_VALUE(896.000000), SIMDE_FLOAT16_VALUE(76.250000), SIMDE_FLOAT16_VALUE(1110.000000), 
        SIMDE_FLOAT16_VALUE(-503.750000), SIMDE_FLOAT16_VALUE(-938.000000), SIMDE_FLOAT16_VALUE(-1546.000000), SIMDE_FLOAT16_VALUE(-348.000000) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde_float16x8_t a = simde_vld1q_f16(test_vec[i].a);
    simde_float16x8_t b = simde_vld1q_f16(test_vec[i].b);
    simde_float16x8_t r = simde_vcaddq_rot90_f16(a, b);

    simde_test_arm_neon_assert_equal_f16x8(r, simde_vld1q_f16(test_vec[i].r), 1);
  }
  return 0;
#else
  fputc('\n', stdout);
  for (int i = 0 ; i < 8 ; i++) {
    simde_float16x8_t a = simde_test_arm_neon_random_f16x8(-1000.0f, 1000.0f);
    simde_float16x8_t b = simde_test_arm_neon_random_f16x8(-1000.0f, 1000.0f);
    simde_float16x8_t r = simde_vcaddq_rot90_f16(a, b);

    simde_test_arm_neon_write_f16x8(2, a, SIMDE_TEST_VEC_POS_FIRST);
    simde_test_arm_neon_write_f16x8(2, b, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_arm_neon_write_f16x8(2, r, SIMDE_TEST_VEC_POS_LAST);
  }
  return 1;
#endif
}

static int
test_simde_vcadd_rot90_f32 (SIMDE_MUNIT_TEST_ARGS) {
#if 1
  static const struct {
    simde_float32 a[2];
    simde_float32 b[2];
    simde_float32 r[2];
  } test_vec[] = {
    { { SIMDE_FLOAT32_C(   863.66), SIMDE_FLOAT32_C(   828.31) },
      { SIMDE_FLOAT32_C(  -563.51), SIMDE_FLOAT32_C(  -576.51) },
      { SIMDE_FLOAT32_C(1440.169922), SIMDE_FLOAT32_C(264.799988) } },
    { { SIMDE_FLOAT32_C(  -703.45), SIMDE_FLOAT32_C(   383.90) },
      { SIMDE_FLOAT32_C(  -772.46), SIMDE_FLOAT32_C(   457.40) },
      { SIMDE_FLOAT32_C(-1160.849976), SIMDE_FLOAT32_C(-388.560028) } },
    { { SIMDE_FLOAT32_C(   295.99), SIMDE_FLOAT32_C(   653.10) },
      { SIMDE_FLOAT32_C(  -120.98), SIMDE_FLOAT32_C(   945.50) },
      { SIMDE_FLOAT32_C(-649.510010), SIMDE_FLOAT32_C(532.119995) } },
    { { SIMDE_FLOAT32_C(  -280.81), SIMDE_FLOAT32_C(   631.32) },
      { SIMDE_FLOAT32_C(   688.34), SIMDE_FLOAT32_C(   191.95) },
      { SIMDE_FLOAT32_C(-472.760010), SIMDE_FLOAT32_C(1319.660034) } },
    { { SIMDE_FLOAT32_C(  -522.88), SIMDE_FLOAT32_C(  -323.79) },
      { SIMDE_FLOAT32_C(  -887.99), SIMDE_FLOAT32_C(  -283.70) },
      { SIMDE_FLOAT32_C(-239.179993), SIMDE_FLOAT32_C(-1211.780029) } },
    { { SIMDE_FLOAT32_C(  -117.76), SIMDE_FLOAT32_C(  -841.45) },
      { SIMDE_FLOAT32_C(   664.94), SIMDE_FLOAT32_C(  -987.19) },
      { SIMDE_FLOAT32_C(869.429993), SIMDE_FLOAT32_C(-176.510010) } },
    { { SIMDE_FLOAT32_C(  -642.89), SIMDE_FLOAT32_C(  -152.10) },
      { SIMDE_FLOAT32_C(   963.83), SIMDE_FLOAT32_C(   919.89) },
      { SIMDE_FLOAT32_C(-1562.780029), SIMDE_FLOAT32_C(811.729980) } },
    { { SIMDE_FLOAT32_C(   630.40), SIMDE_FLOAT32_C(  -669.33) },
      { SIMDE_FLOAT32_C(   671.13), SIMDE_FLOAT32_C(   256.93) },
      { SIMDE_FLOAT32_C(373.470032), SIMDE_FLOAT32_C( 1.799988) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde_float32x2_t a = simde_vld1_f32(test_vec[i].a);
    simde_float32x2_t b = simde_vld1_f32(test_vec[i].b);
    simde_float32x2_t r = simde_vcadd_rot90_f32(a, b);

    simde_test_arm_neon_assert_equal_f32x2(r, simde_vld1_f32(test_vec[i].r), 1);
  }
  return 0;
#else
  fputc('\n', stdout);
  for (int i = 0 ; i < 8 ; i++) {
    simde_float32x2_t a = simde_test_arm_neon_random_f32x2(-1000.0f, 1000.0f);
    simde_float32x2_t b = simde_test_arm_neon_random_f32x2(-1000.0f, 1000.0f);
    simde_float32x2_t r = simde_vcadd_rot90_f32(a, b);

    simde_test_arm_neon_write_f32x2(2, a, SIMDE_TEST_VEC_POS_FIRST);
    simde_test_arm_neon_write_f32x2(2, b, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_arm_neon_write_f32x2(2, r, SIMDE_TEST_VEC_POS_LAST);
  }
  return 1;
#endif
}

static int
test_simde_vcaddq_rot90_f32 (SIMDE_MUNIT_TEST_ARGS) {
#if 1
  static const struct {
    simde_float32 a[4];
    simde_float32 b[4];
    simde_float32 r[4];
  } test_vec[] = {
    { { SIMDE_FLOAT32_C(  -337.31), SIMDE_FLOAT32_C(  -857.36), SIMDE_FLOAT32_C(   334.71), SIMDE_FLOAT32_C(  -617.33) },
      { SIMDE_FLOAT32_C(  -439.38), SIMDE_FLOAT32_C(   245.13), SIMDE_FLOAT32_C(   111.06), SIMDE_FLOAT32_C(   520.69) },
      { SIMDE_FLOAT32_C(-582.440002), SIMDE_FLOAT32_C(-1296.739990), SIMDE_FLOAT32_C(-185.980011), SIMDE_FLOAT32_C(-506.270020) } },
    { { SIMDE_FLOAT32_C(    85.49), SIMDE_FLOAT32_C(   250.19), SIMDE_FLOAT32_C(  -679.96), SIMDE_FLOAT32_C(  -750.25) },
      { SIMDE_FLOAT32_C(  -138.26), SIMDE_FLOAT32_C(   -14.62), SIMDE_FLOAT32_C(  -921.52), SIMDE_FLOAT32_C(   225.91) },
      { SIMDE_FLOAT32_C(100.110001), SIMDE_FLOAT32_C(111.930008), SIMDE_FLOAT32_C(-905.869995), SIMDE_FLOAT32_C(-1671.770020) } },
    { { SIMDE_FLOAT32_C(   242.83), SIMDE_FLOAT32_C(   869.28), SIMDE_FLOAT32_C(   297.95), SIMDE_FLOAT32_C(   105.66) },
      { SIMDE_FLOAT32_C(  -722.51), SIMDE_FLOAT32_C(  -802.37), SIMDE_FLOAT32_C(  -245.78), SIMDE_FLOAT32_C(   915.39) },
      { SIMDE_FLOAT32_C(1045.199951), SIMDE_FLOAT32_C(146.770020), SIMDE_FLOAT32_C(-617.440002), SIMDE_FLOAT32_C(-140.119995) } },
    { { SIMDE_FLOAT32_C(    54.20), SIMDE_FLOAT32_C(  -928.06), SIMDE_FLOAT32_C(   362.39), SIMDE_FLOAT32_C(  -936.63) },
      { SIMDE_FLOAT32_C(   185.82), SIMDE_FLOAT32_C(  -244.43), SIMDE_FLOAT32_C(   924.66), SIMDE_FLOAT32_C(  -643.82) },
      { SIMDE_FLOAT32_C(298.630005), SIMDE_FLOAT32_C(-742.239990), SIMDE_FLOAT32_C(1006.210022), SIMDE_FLOAT32_C(-11.970032) } },
    { { SIMDE_FLOAT32_C(  -516.92), SIMDE_FLOAT32_C(  -615.16), SIMDE_FLOAT32_C(  -751.52), SIMDE_FLOAT32_C(  -974.04) },
      { SIMDE_FLOAT32_C(  -144.42), SIMDE_FLOAT32_C(   338.27), SIMDE_FLOAT32_C(   704.92), SIMDE_FLOAT32_C(   116.90) },
      { SIMDE_FLOAT32_C(-855.189941), SIMDE_FLOAT32_C(-759.579956), SIMDE_FLOAT32_C(-868.420044), SIMDE_FLOAT32_C(-269.119995) } },
    { { SIMDE_FLOAT32_C(    49.39), SIMDE_FLOAT32_C(  -363.00), SIMDE_FLOAT32_C(  -476.30), SIMDE_FLOAT32_C(   106.71) },
      { SIMDE_FLOAT32_C(  -725.84), SIMDE_FLOAT32_C(  -353.71), SIMDE_FLOAT32_C(   268.41), SIMDE_FLOAT32_C(   728.83) },
      { SIMDE_FLOAT32_C(403.099976), SIMDE_FLOAT32_C(-1088.840088), SIMDE_FLOAT32_C(-1205.130005), SIMDE_FLOAT32_C(375.119995) } },
    { { SIMDE_FLOAT32_C(  -470.26), SIMDE_FLOAT32_C(    81.87), SIMDE_FLOAT32_C(    72.27), SIMDE_FLOAT32_C(  -992.59) },
      { SIMDE_FLOAT32_C(  -615.67), SIMDE_FLOAT32_C(   620.28), SIMDE_FLOAT32_C(  -606.51), SIMDE_FLOAT32_C(  -327.77) },
      { SIMDE_FLOAT32_C(-1090.540039), SIMDE_FLOAT32_C(-533.799988), SIMDE_FLOAT32_C(400.039978), SIMDE_FLOAT32_C(-1599.100098) } },
    { { SIMDE_FLOAT32_C(  -331.80), SIMDE_FLOAT32_C(  -605.94), SIMDE_FLOAT32_C(  -295.86), SIMDE_FLOAT32_C(  -275.42) },
      { SIMDE_FLOAT32_C(  -752.64), SIMDE_FLOAT32_C(    21.91), SIMDE_FLOAT32_C(   826.83), SIMDE_FLOAT32_C(   599.82) },
      { SIMDE_FLOAT32_C(-353.709991), SIMDE_FLOAT32_C(-1358.580078), SIMDE_FLOAT32_C(-895.679993), SIMDE_FLOAT32_C(551.410034) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde_float32x4_t a = simde_vld1q_f32(test_vec[i].a);
    simde_float32x4_t b = simde_vld1q_f32(test_vec[i].b);
    simde_float32x4_t r = simde_vcaddq_rot90_f32(a, b);
    simde_test_arm_neon_assert_equal_f32x4(r, simde_vld1q_f32(test_vec[i].r), 1);
  }
  return 0;
#else
  fputc('\n', stdout);
  for (int i = 0 ; i < 8 ; i++) {
    simde_float32x4_t a = simde_test_arm_neon_random_f32x4(-1000.0f, 1000.0f);
    simde_float32x4_t b = simde_test_arm_neon_random_f32x4(-1000.0f, 1000.0f);
    simde_float32x4_t r = simde_vcaddq_rot90_f32(a, b);

    simde_test_arm_neon_write_f32x4(2, a, SIMDE_TEST_VEC_POS_FIRST);
    simde_test_arm_neon_write_f32x4(2, b, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_arm_neon_write_f32x4(2, r, SIMDE_TEST_VEC_POS_LAST);
  }
  return 1;
#endif
}

static int
test_simde_vcaddq_rot90_f64 (SIMDE_MUNIT_TEST_ARGS) {
#if 1
  static const struct {
    simde_float64 a[2];
    simde_float64 b[2];
    simde_float64 r[2];
  } test_vec[] = {
    { { SIMDE_FLOAT64_C(   -30.36), SIMDE_FLOAT64_C(   631.53) },
      { SIMDE_FLOAT64_C(   850.75), SIMDE_FLOAT64_C(  -263.55) },
      { SIMDE_FLOAT64_C(233.190000), SIMDE_FLOAT64_C(1482.280000) } },
    { { SIMDE_FLOAT64_C(   139.96), SIMDE_FLOAT64_C(   859.14) },
      { SIMDE_FLOAT64_C(  -834.47), SIMDE_FLOAT64_C(   216.10) },
      { SIMDE_FLOAT64_C(-76.140000), SIMDE_FLOAT64_C(24.670000) } },
    { { SIMDE_FLOAT64_C(   995.86), SIMDE_FLOAT64_C(   529.74) },
      { SIMDE_FLOAT64_C(    79.08), SIMDE_FLOAT64_C(   947.13) },
      { SIMDE_FLOAT64_C(48.730000), SIMDE_FLOAT64_C(608.820000) } },
    { { SIMDE_FLOAT64_C(   122.02), SIMDE_FLOAT64_C(  -250.00) },
      { SIMDE_FLOAT64_C(  -361.82), SIMDE_FLOAT64_C(   265.24) },
      { SIMDE_FLOAT64_C(-143.220000), SIMDE_FLOAT64_C(-611.820000) } },
    { { SIMDE_FLOAT64_C(   275.71), SIMDE_FLOAT64_C(     2.71) },
      { SIMDE_FLOAT64_C(    99.79), SIMDE_FLOAT64_C(  -137.67) },
      { SIMDE_FLOAT64_C(413.380000), SIMDE_FLOAT64_C(102.500000) } },
    { { SIMDE_FLOAT64_C(  -761.19), SIMDE_FLOAT64_C(   813.19) },
      { SIMDE_FLOAT64_C(  -897.68), SIMDE_FLOAT64_C(   653.58) },
      { SIMDE_FLOAT64_C(-1414.770000), SIMDE_FLOAT64_C(-84.490000) } },
    { { SIMDE_FLOAT64_C(   396.02), SIMDE_FLOAT64_C(   413.06) },
      { SIMDE_FLOAT64_C(   514.09), SIMDE_FLOAT64_C(  -977.67) },
      { SIMDE_FLOAT64_C(1373.690000), SIMDE_FLOAT64_C(927.150000) } },
    { { SIMDE_FLOAT64_C(  -671.79), SIMDE_FLOAT64_C(   -92.13) },
      { SIMDE_FLOAT64_C(  -441.32), SIMDE_FLOAT64_C(  -374.27) },
      { SIMDE_FLOAT64_C(-297.520000), SIMDE_FLOAT64_C(-533.450000) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde_float64x2_t a = simde_vld1q_f64(test_vec[i].a);
    simde_float64x2_t b = simde_vld1q_f64(test_vec[i].b);
    simde_float64x2_t r = simde_vcaddq_rot90_f64(a, b);
    simde_test_arm_neon_assert_equal_f64x2(r, simde_vld1q_f64(test_vec[i].r), 1);
  }
  return 0;
#else
  fputc('\n', stdout);
  for (int i = 0 ; i < 8 ; i++) {
    simde_float64x2_t a = simde_test_arm_neon_random_f64x2(-1000.0f, 1000.0f);
    simde_float64x2_t b = simde_test_arm_neon_random_f64x2(-1000.0f, 1000.0f);
    simde_float64x2_t r = simde_vcaddq_rot90_f64(a, b);

    simde_test_arm_neon_write_f64x2(2, a, SIMDE_TEST_VEC_POS_FIRST);
    simde_test_arm_neon_write_f64x2(2, b, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_arm_neon_write_f64x2(2, r, SIMDE_TEST_VEC_POS_LAST);
  }
  return 1;
#endif
}

SIMDE_TEST_FUNC_LIST_BEGIN
SIMDE_TEST_FUNC_LIST_ENTRY(vcadd_rot90_f16)
SIMDE_TEST_FUNC_LIST_ENTRY(vcaddq_rot90_f16)
SIMDE_TEST_FUNC_LIST_ENTRY(vcadd_rot90_f32)
SIMDE_TEST_FUNC_LIST_ENTRY(vcaddq_rot90_f32)
SIMDE_TEST_FUNC_LIST_ENTRY(vcaddq_rot90_f64)
SIMDE_TEST_FUNC_LIST_END

#include "test-neon-footer.h"
