#!/bin/sh
# build.sh
# Copyright (C) 2002 PostgreSQL, Inc.

echo
echo "WhoisJ Build System"
echo "-------------------"

isJavaSet=0

if [ "$JAVA_HOME" != "" ]; then
     isJavaSet=1
fi

which java > /dev/null
a=$?
if  [ $a -ne 0 -a $isJavaSet -eq 0 ]; then
        echo "No java installation found";
        exit 1;
fi

REPLIC_HOME=`dirname $0`;
echo  REPLIC_HOME is "$REPLIC_HOME";

OLD_CLASSPATH=`echo "$CLASSPATH"`;
echo Saving CLASSPATH:
echo "$OLD_CLASSPATH";

unset CLASSPATH
CLASSPATH=`echo lib/*.jar | tr ' ' ':'`
export CLASSPATH
echo New  CLASSPATH is:
echo "$CLASSPATH"


##### Run Ant:
if [ "$ANT_HOME" != "" ] ; then
    echo Saving old ANT_HOME ...
    OLD_ANT_HOME=$ANT_HOME
fi

ANT_HOME="$REPLIC_HOME/tools";
export ANT_HOME
echo New ANT_HOME is "$ANT_HOME";

chmod u+x $REPLIC_HOME/tools/bin/antRun
chmod u+x $REPLIC_HOME/tools/bin/ant


unset ANT_HOME
  $REPLIC_HOME/tools/bin/ant -verbose $@

##### Restore  CLASSPATH:

CLASSPATH=$OLD_CLASSPATH
export CLASSPATH
echo Restoring CLASSPATH:
echo "$OLD_CLASSPATH"


#### Restore ANT_HOME:

ANT_HOME="$OLD_ANT_HOME";
export ANT_HOME
echo Restoring ANT_HOME:
echo "$OLD_ANT_HOME"
