CREATE EXTENSION plpgpsm;

SET plpgpsm.dump_parser TO OFF;

/*
 * Basic set of tests
 *
 */
CREATE OR REPLACE FUNCTION public.test01(a integer)
RETURNS integer
LANGUAGE plpgpsm
AS $$
BEGIN
  DECLARE x int DEFAULT a + a;
  SET x = x + 1;
  PRINT 'x = ', x;
  RETURN x;
END;
$$;

SELECT test01(10);

CREATE OR REPLACE FUNCTION public.test02(a integer)
RETURNS integer
LANGUAGE plpgpsm
AS $$
BEGIN
  DECLARE i int DEFAULT 0;
  WHILE i < a
  DO
    SET i = i + 1;
    PRINT 'i = ', i;
  END WHILE;
  RETURN i;
END;
$$;

SELECT test01(5);

SELECT test02(10);
SELECT test02(5);

CREATE OR REPLACE FUNCTION test03(a int)
RETURNS int AS $$
BEGIN
  WHILE a > 0 DO
    SET a = a - 2;
  END WHILE;
  RETURN a;
END;
$$ LANGUAGE plpgpsm;

SELECT test03(10);
SELECT test03(9);


CREATE OR REPLACE FUNCTION test04(a int)
RETURNS int AS $$
BEGIN
  LOOP
    IF a = -5 THEN
      RETURN a;
    END IF;
    SET a = a - 1;
  END LOOP;
END;
$$ LANGUAGE plpgpsm;

SELECT test04(10);

CREATE OR REPLACE FUNCTION test05(a int)
RETURNS int AS $$
BEGIN
  DECLARE i int DEFAULT 0;
  DECLARE s int DEFAULT 0;
  REPEAT
    SET s = s + i;
    SET i = i + 1;
  UNTIL i >= a END REPEAT;
  RETURN s;
END;
$$ LANGUAGE plpgpsm;

SELECT test05(5);
SELECT test05(10);

CREATE OR REPLACE FUNCTION test05(a int)
RETURNS int AS $$
BEGIN
  DECLARE i, s int DEFAULT 0;
  REPEAT
    SET s = s + i;
    SET i = i + 1;
  UNTIL i >= a END REPEAT;
  RETURN s;
END;
$$ LANGUAGE plpgpsm;

SELECT test05(5);
SELECT test05(10);

CREATE OR REPLACE FUNCTION test06(a int)
RETURNS int AS $$
BEGIN
  x1: WHILE a > 0 DO
        SET a = a - 1;
        IF a < 10 THEN
          LEAVE x1;
        END IF;
      END WHILE;
      RETURN a;
END;
$$ LANGUAGE plpgpsm;

SELECT test06(1);
SELECT test06(20);

CREATE OR REPLACE FUNCTION test07(a int)
RETURNS int AS $$
  BEGIN
    DECLARE i int DEFAULT a + 10;
x1: LOOP
      PRINT '***';
      SET i = i - 1;
      IF i > a THEN
        ITERATE x1;
      END IF;
      PRINT '###';
      IF i < 1 THEN
        LEAVE x1;
      END IF;
    END LOOP;
    RETURN i;
  END;
$$ LANGUAGE plpgpsm;

SELECT test07(10);

CREATE OR REPLACE FUNCTION test08(a text)
RETURNS text AS $$
BEGIN
  DECLARE x text DEFAULT 'Hello, ' || a;
  RETURN x;
END;
$$ LANGUAGE plpgpsm;

SELECT test08('World');

CREATE OR REPLACE FUNCTION test08(a text)
RETURNS text AS $$
  RETURN 'Hello, ' || a;
$$ LANGUAGE plpgpsm;

SELECT test08('World');

CREATE OR REPLACE FUNCTION test07(a int)
RETURNS int AS $$
  x1: BEGIN
        DECLARE a int DEFAULT 7;
    x2: BEGIN
          DECLARE a int DEFAULT 5;
          RETURN a;
        END;
      END;
$$ LANGUAGE plpgpsm;

SELECT test07(3);

CREATE OR REPLACE FUNCTION test08(a int)
RETURNS int AS $$
  x1: BEGIN
        DECLARE a int DEFAULT 7;
    x2: BEGIN
          DECLARE a int DEFAULT 5;
          RETURN $1;
        END;
      END;
$$ LANGUAGE plpgpsm;

SELECT test08(3);

CREATE OR REPLACE FUNCTION test09(a int)
RETURNS int AS $$
  x1: BEGIN
        DECLARE a int DEFAULT 7;
    x2: BEGIN
          DECLARE a int DEFAULT 5;
          RETURN (test09.a - x1.a) * x2.a;
        END;
      END;
$$ LANGUAGE plpgpsm;

SELECT test09(10);

CREATE OR REPLACE FUNCTION test11(a int)
RETURNS int AS $$
    BEGIN
      DECLARE b int DEFAULT 3;
  x1: BEGIN
        DECLARE b int DEFAULT 7;
        PRINT b;
      END;
  x2: BEGIN
        RETURN a + b;
      END;
    END;
$$ LANGUAGE plpgpsm;

SELECT test11(10);

CREATE OR REPLACE FUNCTION test12(a int)
RETURNS int AS $$
CASE a
      WHEN 1 THEN RETURN 11;
      WHEN 2 THEN RETURN 12;
      WHEN 3 THEN RETURN 13;
END CASE;
$$ LANGUAGE plpgpsm;

SELECT test12(10);

CREATE OR REPLACE FUNCTION test12(a int)
RETURNS int AS $$
BEGIN
  DECLARE CONTINUE HANDLER FOR NOT FOUND
    RETURN -100;
  CASE a
        WHEN 1 THEN RETURN 11;
        WHEN 2 THEN RETURN 12;
        WHEN 3 THEN RETURN 13;
  END CASE;
END;
$$ LANGUAGE plpgpsm;

SELECT test12(10);

CREATE OR REPLACE FUNCTION test13(a int)
RETURNS int AS $$
CASE a
      WHEN 1 THEN RETURN 11;
      WHEN 2 THEN RETURN 12;
      WHEN 3 THEN RETURN 13;
             ELSE RETURN 14;
END CASE;
$$ LANGUAGE plpgpsm;

SELECT test13(1);
SELECT test13(10);

CREATE OR REPLACE FUNCTION test14(a int)
RETURNS int AS $$
CASE
      WHEN a = 1 THEN set a = a + 10; RETURN a;
      WHEN a = 2 THEN set a = a + 10; RETURN a;
      WHEN a = 3 THEN set a = a + 10; RETURN a;
             ELSE RETURN -1;
END CASE;
$$ LANGUAGE plpgpsm;

SELECT test14(1);
SELECT test14(10);

CREATE OR REPLACE FUNCTION test15(a int)
RETURNS int AS $$
IF a > 0 AND a <= 10 THEN
  RETURN 10;
ELSEIF a > 10 AND a <= 20 THEN
  RETURN 20;
ELSE
  RETURN 30;
END IF;
$$ LANGUAGE plpgpsm;

SELECT test15(5);
SELECT test15(16);
SELECT test15(36);

CREATE OR REPLACE FUNCTION test15(a int)
RETURNS int AS $$
IF a > 0 AND a <= 10 THEN
  RETURN 10;
ELSEIF a > 10 AND a <= 20 THEN
  RETURN 20;
END IF;
$$ LANGUAGE plpgpsm;

SELECT test15(5);
SELECT test15(16);
SELECT test15(36);

CREATE OR REPLACE FUNCTION test16(a int, b int, c int)
RETURNS int AS $$
BEGIN
  DECLARE d, e, f int;
  SET (d, e, f) = (a, b, c);
  RETURN d + e + f;
END;
$$ LANGUAGE plpgpsm;

SELECT test16(10,20,30);

CREATE OR REPLACE FUNCTION test17(a int, b int, c int)
RETURNS int AS $$
BEGIN
  DECLARE d, e, f int;
  DECLARE x, y, z text;
  SET (d, x, e, y, f, z) = (a, 'Ahoj', b, 'Ahoj', c, 'Ahoj');
  PRINT x, y, z;
  RETURN d + e + f;
END;
$$ LANGUAGE plpgpsm;

SELECT test17(10,20,30);

CREATE OR REPLACE FUNCTION test18(a int, b int, c int)
RETURNS int AS $$
BEGIN
  DECLARE d, e, f int;
  DECLARE x, y, z text;
  SET (d, x, e, y, f, z) = (a, date '2012-04-01', b, numeric '12323.22', c, 'Ahoj');
  PRINT x, y, z;
  RETURN d + e + f;
END;
$$ LANGUAGE plpgpsm;

SELECT test18(10,20,30);

CREATE OR REPLACE FUNCTION test19(a int, b int, c int)
RETURNS int AS $$
BEGIN
  DECLARE d, e, f int;
  DECLARE x, y, z text;
  SET d = a, e = b, f = c;
  SET x = date '2912-04-01', y = numeric '122232.32', z = 'Ahoj';
  PRINT x, y, z;
  RETURN d + e + f;
END;
$$ LANGUAGE plpgpsm;

SELECT test19(10,20,30);

CREATE TABLE t1(a int, b date, c text);

INSERT INTO t1 VALUES(1, '2001-01-01', 'some text');
INSERT INTO t1 VALUES(2, '2002-01-03', 'some other text');
INSERT INTO t1 VALUES(3, '2003-01-04', 'Some very' || 'long long long long long long long long long long long long long long long long '
 || 'long long long long long long long long long long long long long long long long '
 || 'long long long long long long long long long long long long long long long long '
 || 'long long long long long long long long long long long long long long long long '
 || 'long long long long long long long long long long long long long long long long '
 || 'long long long long long long long long long long long long long long long long '
 || 'long long long long long long long long long long long long long long long long  text');

CREATE OR REPLACE FUNCTION test20()
RETURNS void AS $$
BEGIN
  DECLARE _a int;
  DECLARE _b date;
  DECLARE _c text;
  DECLARE sqlcode int;
  DECLARE c CURSOR FOR SELECT * FROM t1;
  OPEN c;
  FETCH c INTO _a, _b, _c;
  WHILE sqlcode = 0 DO
    PRINT _a, _b, _c;
    FETCH c INTO _a, _b, _c;
  END WHILE;
  CLOSE c;
END;
$$ LANGUAGE plpgpsm;

SELECT test20();

CREATE OR REPLACE FUNCTION test21()
RETURNS void AS $$
BEGIN
  DECLARE _a int;
  DECLARE _b date;
  DECLARE _c text;
  DECLARE sqlstate char(5);
  DECLARE c CURSOR FOR SELECT * FROM t1;
  OPEN c;
  FETCH c INTO _a, _b, _c;
  WHILE sqlstate = '00000' DO
    PRINT _a, _b, _c;
    FETCH c INTO _a, _b, _c;
  END WHILE;
  CLOSE c;
END;
$$ LANGUAGE plpgpsm;

SELECT test21();

CREATE OR REPLACE FUNCTION test22()
RETURNS void AS $$
BEGIN
  DECLARE _a int;
  DECLARE _b date;
  DECLARE _c text;
  DECLARE found boolean DEFAULT true;
  DECLARE c CURSOR FOR SELECT * FROM t1;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET found = false;
  OPEN c;
  FETCH c INTO _a, _b, _c;
  WHILE found DO
    PRINT _a, _b, _c;
    FETCH c INTO _a, _b, _c;
  END WHILE;
  CLOSE c;
END;
$$ LANGUAGE plpgpsm;

SELECT test22();

CREATE OR REPLACE FUNCTION test22()
RETURNS void AS $$
BEGIN
  DECLARE _a int;
  DECLARE _b date;
  DECLARE _c text;
  DECLARE c CURSOR FOR SELECT * FROM t1;
  DECLARE CONTINUE HANDLER FOR NOT FOUND RETURN;
  OPEN c;
  LOOP
    FETCH c INTO _a, _b, _c;
    PRINT _a, _b, _c;
  END LOOP;
  CLOSE c;
END;
$$ LANGUAGE plpgpsm;

SELECT test22();

CREATE OR REPLACE FUNCTION test22()
RETURNS void AS $$
BEGIN
  DECLARE _a int;
  DECLARE _b date;
  DECLARE _c text;
  DECLARE done boolean DEFAULT false;
  DECLARE c CURSOR FOR SELECT * FROM t1;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = true;
  OPEN c;
  l1: LOOP
        FETCH c INTO _a, _b, _c;
        IF done THEN LEAVE l1; END IF;
         PRINT _a, _b, _c;
      END LOOP;
  CLOSE c;
END;
$$ LANGUAGE plpgpsm;

SELECT test22();

CREATE OR REPLACE FUNCTION test22()
RETURNS void AS $$
BEGIN
  DECLARE _a int;
  DECLARE _b date;
  DECLARE _c text;
  DECLARE _repeat boolean DEFAULT true;
  DECLARE c CURSOR FOR SELECT * FROM t1;
  DECLARE CONTINUE HANDLER FOR NOT FOUND BEGIN SET _repeat = false; END;
  OPEN c;
  FETCH c INTO _a, _b, _c;
  WHILE _repeat DO
    PRINT _a, _b, _c;
    FETCH c INTO _a, _b, _c;
  END WHILE;
  CLOSE c;
END;
$$ LANGUAGE plpgpsm;

SELECT test22();

CREATE OR REPLACE FUNCTION test23(a int, OUT aa int, OUT bb int)
AS $$
  SET aa = a + 10, bb = a + 20;
$$ LANGUAGE plpgpsm;

SELECT * from test23(10);
SELECT test23(10);

CREATE OR REPLACE FUNCTION test24(a int, OUT aa text, OUT bb numeric)
AS $$
  SET aa = 'Hello ' || a, bb = a + 10.22;
$$ LANGUAGE plpgpsm;

SELECT * FROM test24(10);
SELECT test24(10);

CREATE OR REPLACE FUNCTION test25()
RETURNS void AS $$
BEGIN
  DECLARE _r1, _r2, sqlcode int;
  DECLARE c1 CURSOR FOR SELECT * FROM generate_series(1,3);
  DECLARE c2 CURSOR FOR SELECT * FROM generate_series(1,4);
  OPEN c1;
  OPEN c2;
  LOOP
    FETCH c1 INTO _r1;
    FETCH c2 INTO _r2;
    IF sqlcode <> 0 THEN
      RETURN;
    END IF;
    PRINT _r1, _r2;
  END LOOP;
END;
$$ LANGUAGE plpgpsm;

SELECT test25();

CREATE OR REPLACE FUNCTION test26(a int, b int)
RETURNS void AS $$
BEGIN
  DECLARE _r1, _r2 text;
  DECLARE sqlcode int;
  DECLARE c1 CURSOR FOR SELECT 'a' || i FROM generate_series(1,test26.a) g(i);
  DECLARE c2 CURSOR FOR SELECT 'b' || i FROM generate_series(1,test26.b) g(i);
  OPEN c1;
  FETCH c1 INTO _r1;
  WHILE sqlcode = 0 DO
    OPEN c2;
    FETCH c2 INTO _r2;
    WHILE sqlcode = 0 DO
      PRINT _r1, _r2;
      FETCH c2 INTO _r2;
    END WHILE;
    CLOSE c2;
    FETCH c1 INTO _r1;
  END WHILE;
END;
$$ LANGUAGE plpgpsm;

SELECT test26(3,4);
SELECT test26(4,3);

CREATE OR REPLACE FUNCTION test27(a int, b int)
RETURNS void AS $$
BEGIN
  DECLARE _r1, _r2 text;
  DECLARE done boolean DEFAULT false;
  DECLARE c1 CURSOR FOR SELECT 'a' || i FROM generate_series(1,a) g(i);
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = true;
  OPEN c1;
  FETCH c1 INTO _r1;
  WHILE NOT done DO
    BEGIN
      DECLARE done boolean DEFAULT false;
      DECLARE c2 CURSOR FOR SELECT 'b' || i FROM generate_series(1,b) g(i);
      DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = true;
      OPEN c2;
      FETCH c2 INTO _r2;
      WHILE NOT done DO
        PRINT _r1, _r2;
        FETCH c2 INTO _r2;
      END WHILE;
    END;
    FETCH c1 INTO _r1;
  END WHILE;
END;
$$ LANGUAGE plpgpsm;

SELECT test27(3,4);
SELECT test27(4,3);

CREATE OR REPLACE FUNCTION test28()
RETURNS void AS $$
FOR SELECT * FROM t1 DO
  PRINT a, b, c;
END FOR;
$$ LANGUAGE plpgpsm;

SELECT test28();

CREATE OR REPLACE FUNCTION test28()
RETURNS void AS $$
FOR fn AS SELECT * FROM t1 DO
  PRINT fn.a, fn.b, fn.c;
END FOR;
$$ LANGUAGE plpgpsm;

SELECT test28();

CREATE OR REPLACE FUNCTION test28()
RETURNS void AS $$
FOR fn AS c1 CURSOR FOR SELECT * FROM t1 DO
  PRINT fn.a, fn.b, fn.c;
END FOR;
$$ LANGUAGE plpgpsm;

SELECT test28();

CREATE OR REPLACE FUNCTION test29(a int, b int)
RETURNS void AS $$
FOR f1 AS SELECT 'a' || i AS x FROM generate_series(1, a) g(i) DO
  FOR f2 AS SELECT 'b' || i AS x FROM generate_series(1, b) g(i) DO
    PRINT f1.x, f2.x;
  END FOR;
END FOR;
$$ LANGUAGE plpgpsm;

SELECT test29(3,4);
SELECT test29(4,3);

CREATE OR REPLACE FUNCTION test30()
RETURNS void AS $$
x1: FOR SELECT generate_series(1,10) AS i DO
      IF i > 5 THEN LEAVE  x1; END IF;
      PRINT i;
    END FOR;
$$ LANGUAGE plpgpsm;

SELECT test30();

CREATE OR REPLACE FUNCTION test31()
RETURNS void AS $$
BEGIN
  -- statement FOR doesn't raise signal NOT FOUND 
  DECLARE CONTINUE HANDLER FOR NOT FOUND PRINT 'not found signaled'; -- not processed
  FOR SELECT generate_series(1,10) AS i DO
    PRINT i;
  END FOR;
END;
$$ LANGUAGE plpgpsm;

SELECT test31();

CREATE OR REPLACE FUNCTION test31()
RETURNS void AS $$
BEGIN
  /*
   * statement FOR doesn't raise signal NOT FOUND, but inner
   * statement can send NOT FOUND signal.
   */
  DECLARE CONTINUE HANDLER FOR NOT FOUND PRINT 'not found signaled'; -- not processed
  FOR SELECT generate_series(1,10) AS i DO
    CASE WHEN false THEN PRINT i; END CASE;
  END FOR;
END;
$$ LANGUAGE plpgpsm;

SELECT test31();

/* test of empty statement list */
CREATE OR REPLACE FUNCTION test32()
RETURNS void AS $$
IF true THEN
ELSE
END IF;
$$ LANGUAGE plpgpsm;

SELECT test32();

CREATE OR REPLACE FUNCTION test32()
RETURNS void AS $$
FOR SELECT generate_series(1,5) DO
END FOR;
$$ LANGUAGE plpgpsm;

SELECT test32();

CREATE OR REPLACE FUNCTION test33()
RETURNS void AS $$
BEGIN
  DECLARE CONTINUE HANDLER FOR SQLSTATE '01000' PRINT 'Hello';
  PRINT 'First line';
  SIGNAL SQLSTATE '01001';
  PRINT 'Second line';
  SIGNAL SQLSTATE '01001';
  PRINT 'Third line';
END;
$$ LANGUAGE plpgpsm;

SELECT test33();

CREATE OR REPLACE FUNCTION test33()
RETURNS void AS $$
BEGIN
  DECLARE CONTINUE HANDLER FOR SQLSTATE '01000' PRINT 'Hello';
  PRINT 'First line';
  SIGNAL SQLSTATE '01001';
  PRINT 'Second line';
  SIGNAL SQLSTATE '01001';
  PRINT 'Third line';
END;
$$ LANGUAGE plpgpsm;

SELECT test33();

CREATE OR REPLACE FUNCTION test34()
RETURNS void AS $$
BEGIN
  DECLARE EXIT HANDLER FOR SQLSTATE '01000' PRINT 'Hello';
  PRINT 'First line';
  SIGNAL SQLSTATE '01001';
  PRINT 'Second line';
  SIGNAL SQLSTATE '01001';
  PRINT 'Third line';
END;
$$ LANGUAGE plpgpsm;

SELECT test34();

CREATE OR REPLACE FUNCTION test35()
RETURNS void AS $$
BEGIN
  BEGIN
    DECLARE EXIT HANDLER FOR SQLSTATE '01000' PRINT 'Hello';
    PRINT 'First line';
    SIGNAL SQLSTATE '01001';
    PRINT 'Second line';
    SIGNAL SQLSTATE '01001';
    PRINT 'Third line';
  END;
  PRINT 'Next statement';
END;
$$ LANGUAGE plpgpsm;

SELECT test35();

CREATE OR REPLACE FUNCTION test36()
RETURNS void AS $$
BEGIN
  DECLARE num int DEFAULT 20;
  SIGNAL SQLSTATE '01001' SET message_text = 'Message ' || num, detail_text = 'Detail ' || num, hint_text = 'Hint ' || num;
END;
$$ LANGUAGE plpgpsm;

SELECT test36();

CREATE OR REPLACE FUNCTION test37()
RETURNS void AS $$
BEGIN
  PRINT 'first line';
  BEGIN ATOMIC
    DECLARE UNDO HANDLER FOR SQLSTATE '01001' PRINT 'Handled signal and rollback current subtransaction';
    print 'nested block - first line';
    SIGNAL SQLSTATE '01001';
    print 'nested block - second line';
  END;
  PRINT 'second line';
END;
$$ LANGUAGE plpgpsm;

SELECT test37();

CREATE OR REPLACE FUNCTION test37()
RETURNS void AS $$
BEGIN
  PRINT 'zero line';
  BEGIN ATOMIC
    DECLARE UNDO HANDLER FOR SQLSTATE '01002' PRINT 'Handled signal 01002 and rollback current subtransaction';
    PRINT 'first line';
    BEGIN ATOMIC
      DECLARE UNDO HANDLER FOR SQLSTATE '01001' PRINT 'Handled signal 01001 and rollback current subtransaction';
      print 'nested block - first line';
      SIGNAL SQLSTATE '01002';
      print 'nested block - second line';
    END;
    PRINT 'second line';
  END;
  PRINT 'last line';
END;
$$ LANGUAGE plpgpsm;

SELECT test37();

CREATE OR REPLACE FUNCTION test38()
RETURNS void AS $$
BEGIN
  DECLARE EXIT HANDLER FOR SQLSTATE '01002'
    BEGIN
      PRINT 'Handler signal 01002 and resignal';
      SIGNAL SQLSTATE '01002' SET MESSAGE_TEXT = 'unhandled warning 01002';
      PRINT 'next line';
    END;
  PRINT 'first line';
  SIGNAL SQLSTATE '01002';
  PRINT 'next line';
END;
$$ LANGUAGE plpgpsm;

SELECT test38();

CREATE OR REPLACE FUNCTION test38()
RETURNS void AS $$
BEGIN
  DECLARE EXIT HANDLER FOR SQLSTATE '01002'
    BEGIN
      DECLARE EXIT HANDLER FOR SQLSTATE '01002' PRINT 'nested nested handler 01002';
      PRINT 'Handler signal 01002 and resignal';
      SIGNAL SQLSTATE '01002';
      PRINT 'next line';
    END;
  PRINT 'first line';
  SIGNAL SQLSTATE '01002';
  PRINT 'next line';
END;
$$ LANGUAGE plpgpsm;

SELECT test38();

CREATE OR REPLACE FUNCTION test39()
RETURNS void AS $$
BEGIN
  DECLARE EXIT HANDLER FOR SQLSTATE '01002'
    BEGIN
      PRINT 'Handled 01002';
      RESIGNAL;
    END;
  SIGNAL SQLSTATE '01002'
    SET MESSAGE_TEXT = 'some interesting text',
        DETAIL_TEXT = 'see forwarded signal';
  PRINT 'next line';
END;
$$ LANGUAGE plpgpsm;

SELECT test39();

CREATE OR REPLACE FUNCTION test39()
RETURNS void AS $$
BEGIN ATOMIC
  DECLARE UNDO HANDLER FOR SQLSTATE '03002'
    BEGIN
      PRINT 'Handled 03002';
      RESIGNAL;
    END;
  SIGNAL SQLSTATE '03002'
    SET MESSAGE_TEXT = 'some interesting text',
        DETAIL_TEXT = 'see forwarded signal';
  PRINT 'next line';
END;
$$ LANGUAGE plpgpsm;

SELECT test39();

CREATE OR REPLACE FUNCTION test39()
RETURNS void AS $$
BEGIN
  DECLARE EXIT HANDLER FOR SQLSTATE '01002'
    BEGIN
      PRINT 'Handled 01002';
      RESIGNAL SET HINT_TEXT = 'test of other info';
    END;
  SIGNAL SQLSTATE '01002'
    SET MESSAGE_TEXT = 'some interesting text',
        DETAIL_TEXT = 'see forwarded signal';
  PRINT 'next line';
END;
$$ LANGUAGE plpgpsm;

SELECT test39();

CREATE OR REPLACE FUNCTION test39()
RETURNS void AS $$
BEGIN ATOMIC
  DECLARE UNDO HANDLER FOR SQLSTATE '03002'
    BEGIN
      PRINT 'Handled 03002';
      RESIGNAL SET HINT_TEXT = 'test of other info';
    END;
  SIGNAL SQLSTATE '03002'
    SET MESSAGE_TEXT = 'some interesting text',
        DETAIL_TEXT = 'see forwarded signal';
  PRINT 'next line';
END;
$$ LANGUAGE plpgpsm;

SELECT test39();

--cannot to compile
CREATE OR REPLACE FUNCTION test40()
RETURNS void AS $$
xx: LOOP
      BEGIN
        DECLARE CONTINUE HANDLER FOR NOT FOUND LEAVE xx; -- xx is not accessable from handler scope
        SIGNAL SQLSTATE '02001';
      END;
    END LOOP;
$$ LANGUAGE plpgpsm;

CREATE OR REPLACE FUNCTION test41()
RETURNS void AS $$
BEGIN
  DECLARE custom_condition CONDITION;
  SIGNAL custom_condition;
END;
$$ LANGUAGE plpgpsm;

SELECT test41();

CREATE OR REPLACE FUNCTION test41()
RETURNS void AS $$
BEGIN
  DECLARE not_found CONDITION FOR SQLSTATE '02000';
  SIGNAL not_found;
END;
$$ LANGUAGE plpgpsm;

SELECT test41();

CREATE OR REPLACE FUNCTION test42()
RETURNS void AS $$
BEGIN
  DECLARE custom_condition CONDITION FOR SQLSTATE '01001';
  DECLARE EXIT HANDLER FOR custom_condition PRINT 'Handled custom condition';
  SIGNAL custom_condition;
END;
$$ LANGUAGE plpgpsm;

SELECT test42();

CREATE OR REPLACE FUNCTION test42()
RETURNS void AS $$
BEGIN
  DECLARE custom_condition CONDITION FOR SQLSTATE '01001';
  DECLARE EXIT HANDLER FOR SQLSTATE '01001' PRINT 'Handled custom condition';
  SIGNAL custom_condition;
END;
$$ LANGUAGE plpgpsm;

SELECT test42();

CREATE OR REPLACE FUNCTION test42()
RETURNS void AS $$
BEGIN
  DECLARE custom_condition CONDITION FOR SQLSTATE '01001';
  DECLARE EXIT HANDLER FOR custom_condition PRINT 'Handled custom condition';
  SIGNAL SQLSTATE '01001';
END;
$$ LANGUAGE plpgpsm;

SELECT test42();


CREATE OR REPLACE FUNCTION test43()
RETURNS void AS $$
BEGIN
   DECLARE _a int;
   DECLARE _b date;
   DECLARE _c text;
   DECLARE done boolean DEFAULT false;
   DECLARE not_found CONDITION FOR SQLSTATE '02000';
   DECLARE c CURSOR FOR SELECT * FROM t1;
   DECLARE CONTINUE HANDLER FOR not_found SET done = true;
   OPEN c;
l: LOOP
     FETCH c INTO _a, _b, _c;
     IF done THEN LEAVE l; END IF;
     PRINT _a, _b, _c;
   END LOOP;
   CLOSE c;
END;
$$ LANGUAGE plpgpsm;

SELECT test43();

CREATE OR REPLACE FUNCTION test44()
RETURNS void AS $$
BEGIN
  DECLARE sqlstate char(5);
  DECLARE c1 CONDITION FOR SQLSTATE '01001';
  DECLARE c2 CONDITION FOR SQLSTATE '01002';
  DECLARE CONTINUE HANDLER FOR c1, c2 PRINT 'Handled condition ' || sqlstate;
  SIGNAL c1;
  SIGNAL c2;
END;
$$ LANGUAGE plpgpsm;

SELECT test44();

CREATE OR REPLACE FUNCTION test45()
RETURNS void AS $$
BEGIN
  DECLARE message, detail, hint, _sqlstate text;
  DECLARE _sqlcode int;
  DECLARE CONTINUE HANDLER FOR SQLSTATE '01001'
    BEGIN
      GET DIAGNOSTICS
         message = MESSAGE_TEXT,
         detail = DETAIL_TEXT,
         hint = HINT_TEXT,
         _sqlstate = RETURNED_SQLSTATE,
         _sqlcode = RETURNED_SQLCODE;
    END;
    SIGNAL SQLSTATE '01001'
      SET MESSAGE_TEXT = 'some message text',
          DETAIL_TEXT = 'some detail text',
          HINT_TEXT = 'some hint text';
  PRINT message, detail, hint, _sqlstate, _sqlcode;
END;
$$ LANGUAGE plpgpsm;

SELECT test45();

CREATE OR REPLACE FUNCTION test45()
RETURNS void AS $$
BEGIN
  DECLARE message, detail, hint, _sqlstate text;
  DECLARE _sqlcode int;
  DECLARE CONTINUE HANDLER FOR SQLSTATE '01001'
    BEGIN
      GET STACKED DIAGNOSTICS
         message = MESSAGE_TEXT,
         detail = DETAIL_TEXT,
         hint = HINT_TEXT,
         _sqlstate = RETURNED_SQLSTATE,
         _sqlcode = RETURNED_SQLCODE;
    END;
    SIGNAL SQLSTATE '01001'
      SET MESSAGE_TEXT = 'some message text',
          DETAIL_TEXT = 'some detail text',
          HINT_TEXT = 'some hint text';
  PRINT message, detail, hint, _sqlstate, _sqlcode;
END;
$$ LANGUAGE plpgpsm;

SELECT test45();

CREATE OR REPLACE FUNCTION test45()
RETURNS void AS $$
BEGIN
  DECLARE message, detail, hint, _sqlstate text;
  DECLARE _sqlcode int;
  DECLARE CONTINUE HANDLER FOR SQLSTATE '01001'
    BEGIN
      PRINT 'Hello';
      GET CURRENT DIAGNOSTICS
         message = MESSAGE_TEXT,
         detail = DETAIL_TEXT,
         hint = HINT_TEXT,
         _sqlstate = RETURNED_SQLSTATE,
         _sqlcode = RETURNED_SQLCODE;
    END;
    SIGNAL SQLSTATE '01001'
      SET MESSAGE_TEXT = 'some message text',
          DETAIL_TEXT = 'some detail text',
          HINT_TEXT = 'some hint text';
  PRINT message, detail, hint, _sqlstate, _sqlcode;
END;
$$ LANGUAGE plpgpsm;

SELECT test45();

CREATE OR REPLACE FUNCTION test45()
RETURNS void AS $$
BEGIN
  DECLARE message, detail, hint, _sqlstate text;
  DECLARE _sqlcode int;
  DECLARE CONTINUE HANDLER FOR SQLSTATE '01001'
    BEGIN
      PRINT 'Hello';
      GET STACKED DIAGNOSTICS
         message = MESSAGE_TEXT,
         detail = DETAIL_TEXT,
         hint = HINT_TEXT,
         _sqlstate = RETURNED_SQLSTATE,
         _sqlcode = RETURNED_SQLCODE;
    END;
    SIGNAL SQLSTATE '01001'
      SET MESSAGE_TEXT = 'some message text',
          DETAIL_TEXT = 'some detail text',
          HINT_TEXT = 'some hint text';
  PRINT message, detail, hint, _sqlstate, _sqlcode;
END;
$$ LANGUAGE plpgpsm;

SELECT test45();

CREATE OR REPLACE FUNCTION test45()
RETURNS void AS $$
BEGIN
  DECLARE _condition_name text;
  DECLARE custom_condition CONDITION FOR SQLSTATE '01001';
  DECLARE EXIT HANDLER FOR custom_condition
    BEGIN
      GET STACKED DIAGNOSTICS
            _condition_name = CONDITION_IDENTIFIER;
      PRINT _condition_name;
    END;
  SIGNAL custom_condition;
END;
$$ LANGUAGE plpgpsm;

SELECT test45();

CREATE OR REPLACE FUNCTION test45()
RETURNS void AS $$
BEGIN ATOMIC
  DECLARE _condition_name text;
  DECLARE custom_condition CONDITION;
  DECLARE UNDO HANDLER FOR custom_condition
    BEGIN
      GET STACKED DIAGNOSTICS
            _condition_name = CONDITION_IDENTIFIER;
      PRINT _condition_name;
    END;
  SIGNAL custom_condition;
END;
$$ LANGUAGE plpgpsm;

SELECT test45();

CREATE OR REPLACE FUNCTION test46()
RETURNS void AS $$
BEGIN
  SIGNAL SQLSTATE '22012';
END;
$$ LANGUAGE plpgpsm;

SELECT test46();

CREATE OR REPLACE FUNCTION test46()
RETURNS void AS $$
BEGIN ATOMIC
  SIGNAL SQLSTATE '22012';
END;
$$ LANGUAGE plpgpsm;

SELECT test46();

CREATE OR REPLACE FUNCTION test46()
RETURNS void AS $$
BEGIN
  DECLARE a int;
  DECLARE b int DEFAULT 0;
  SET a = 10 / b;
END;
$$ LANGUAGE plpgpsm;

SELECT test46();

CREATE OR REPLACE FUNCTION test46()
RETURNS void AS $$
BEGIN ATOMIC
  DECLARE a int;
  DECLARE b int DEFAULT 0;
  SET a = 10 / b;
END;
$$ LANGUAGE plpgpsm;

SELECT test46();

CREATE OR REPLACE FUNCTION test47(b int)
RETURNS int AS $$
BEGIN ATOMIC
  DECLARE a int;
  DECLARE UNDO HANDLER FOR SQLSTATE '22012'
    BEGIN
      PRINT '>>> division by zero <<<';
      RETURN -1;
    END;
  SET a = 10 / b;
  RETURN a;
END;
$$ LANGUAGE plpgpsm;

SELECT test47(10);
SELECT test47(0);

CREATE OR REPLACE FUNCTION test47(b int)
RETURNS int AS $$
BEGIN ATOMIC
  DECLARE UNDO HANDLER FOR SQLSTATE '22012'
    BEGIN
      PRINT '>>> division by zero <<<';
      RETURN -1;
    END;
  BEGIN ATOMIC
    DECLARE a int;
    SET a = 10 / b;
    RETURN a;
  END;
END;
$$ LANGUAGE plpgpsm;

SELECT test47(10);
SELECT test47(0);

CREATE OR REPLACE FUNCTION test48(b int)
RETURNS int AS $$
BEGIN
  DECLARE division_by_zero CONDITION FOR SQLSTATE '22012';
  BEGIN ATOMIC
    DECLARE UNDO HANDLER FOR division_by_zero
      BEGIN
        PRINT '>>> division by zero <<<';
        RETURN -1;
      END;
    RETURN 10 / b;
  END;
END;
$$ LANGUAGE plpgpsm;

SELECT test48(10);
SELECT test48(0);

CREATE OR REPLACE FUNCTION test49(iterations int)
RETURNS int AS $$
BEGIN
  DECLARE division_by_zero CONDITION FOR SQLSTATE '22012';
  DECLARE i, j, z int DEFAULT 0;
  WHILE i < iterations DO
    BEGIN ATOMIC
      DECLARE UNDO HANDLER FOR division_by_zero
        SET j = j + 1;
      SET z = j / z;
    END;
    SET i = i + 1;
  END WHILE;
  PRINT i, j, z;
  RETURN j;
END;
$$ LANGUAGE plpgpsm;

SELECT test49(100);
SELECT test49(1000);

CREATE OR REPLACE FUNCTION test50(iterations int)
RETURNS int AS $$
BEGIN
  DECLARE division_by_zero CONDITION FOR SQLSTATE '22012';
  DECLARE i, j, z int DEFAULT 0;
  WHILE i < iterations DO
    BEGIN ATOMIC
      DECLARE _r1 int;
      DECLARE str text DEFAULT 'some very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very';
      DECLARE c1 CURSOR FOR SELECT * FROM generate_series(1,3);
      DECLARE UNDO HANDLER FOR division_by_zero
        SET j = j + 1;
      OPEN c1;
      FETCH c1 INTO _r1;
      SET z = j / z;
    END;
    SET i = i + 1;
  END WHILE;
  PRINT i, j, z;
  RETURN j;
END;
$$ LANGUAGE plpgpsm;

SELECT test50(10);
SELECT test50(100);

-- using predefined conditions
CREATE OR REPLACE FUNCTION test51(a int)
RETURNS int AS $$
BEGIN ATOMIC
  DECLARE UNDO HANDLER FOR division_by_zero
    BEGIN
      PRINT '>>> division by zero <<<';
      RETURN -1;
    END;
  RETURN 10 / a;
END;
$$ LANGUAGE plpgpsm;

SELECT test51(10);
SELECT test51(0);

-- using predefined conditions
CREATE OR REPLACE FUNCTION test51(a int)
RETURNS int AS $$
BEGIN ATOMIC
  DECLARE UNDO HANDLER FOR division_by_zero
    BEGIN
      PRINT '>>> division by zero <<<';
      RETURN -1;
    END;
  IF a <> 0 THEN
    RETURN 10 / a;
  ELSE
    SIGNAL division_by_zero;
  END IF;
END;
$$ LANGUAGE plpgpsm;

SELECT test51(10);
SELECT test51(0);

CREATE OR REPLACE FUNCTION test51(a int)
RETURNS int AS $$
  IF a <> 0 THEN
    RETURN 10 / a;
  ELSE
    SIGNAL division_by_zero;
  END IF;
$$ LANGUAGE plpgpsm;

SELECT test51(10);
SELECT test51(0);

CREATE OR REPLACE FUNCTION test52()
RETURNS int AS $$
  SIGNAL division_by_zero;
$$ LANGUAGE plpgpsm;

SELECT test52();

