/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.mapping;

import java.util.HashSet;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.team.internal.core.mapping.CompoundResourceTraversal;
import org.eclipse.team.internal.core.subscribers.AbstractSynchronizationScope;

public abstract class AbstractResourceMappingScope
extends AbstractSynchronizationScope {
    @Override
    public ResourceMapping getMapping(Object modelObject) {
        ResourceMapping[] mappings;
        ResourceMapping[] resourceMappingArray = mappings = this.getMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (mapping.getModelObject().equals(modelObject)) {
                return mapping;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ResourceMapping[] getMappings(String id) {
        ResourceMapping[] mappings;
        HashSet<ResourceMapping> result = new HashSet<ResourceMapping>();
        ResourceMapping[] resourceMappingArray = mappings = this.getMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (mapping.getModelProviderId().equals(id)) {
                result.add(mapping);
            }
            ++n2;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    @Override
    public ResourceTraversal[] getTraversals(String modelProviderId) {
        ResourceMapping[] mappings = this.getMappings(modelProviderId);
        CompoundResourceTraversal traversal = new CompoundResourceTraversal();
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            ResourceTraversal[] traversals = this.getTraversals(mapping);
            if (traversals != null) {
                traversal.addTraversals(traversals);
            }
            ++n2;
        }
        return traversal.asTraversals();
    }

    @Override
    public ModelProvider[] getModelProviders() {
        ResourceMapping[] mappings;
        HashSet<ModelProvider> result = new HashSet<ModelProvider>();
        ResourceMapping[] resourceMappingArray = mappings = this.getMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            ModelProvider modelProvider = mapping.getModelProvider();
            if (modelProvider != null) {
                result.add(modelProvider);
            }
            ++n2;
        }
        return result.toArray(new ModelProvider[result.size()]);
    }
}

